/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./ColumnHeaderMenuAdapter","../utils/TableUtils","sap/m/library","sap/m/table/columnmenu/QuickAction","sap/m/table/columnmenu/QuickSort","sap/m/table/columnmenu/QuickSortItem","sap/m/table/columnmenu/QuickGroup","sap/m/table/columnmenu/QuickGroupItem","sap/m/table/columnmenu/QuickTotal","sap/m/table/columnmenu/QuickTotalItem","sap/m/table/columnmenu/ItemContainer","sap/m/table/columnmenu/ActionItem","sap/m/Button","sap/m/Switch","sap/m/Input","sap/ui/core/Lib","sap/ui/core/library","sap/ui/Device"],function(e,t,i,o,s,u,r,n,c,l,a,_,p,h,m,k,Q,g){"use strict";const f=e.extend("sap.ui.table.menus.MobileColumnHeaderMenuAdapter",{});f.prototype.injectMenuItems=function(e,t){this._oColumn=t;this._oMenu=e;this._prepareQuickActions(t);this._oMenu.addAggregation("_quickActions",this._oQuickSort);this._oMenu.addAggregation("_quickActions",this._oQuickFilter);this._oMenu.addAggregation("_quickActions",this._oQuickGroup);this._oMenu.addAggregation("_quickActions",this._oQuickTotal);this._oMenu.addAggregation("_quickActions",this._oQuickFreeze);this._oMenu.addAggregation("_quickActions",this._oQuickResize);this._prepareItems(t);e.addAggregation("_items",this._oItemContainer)};f.prototype.removeMenuItems=function(e){delete this._oColumn;e.removeAggregation("_quickActions",this._oQuickSort);e.removeAggregation("_quickActions",this._oQuickFilter);e.removeAggregation("_quickActions",this._oQuickGroup);e.removeAggregation("_quickActions",this._oQuickTotal);e.removeAggregation("_quickActions",this._oQuickFreeze);e.removeAggregation("_quickActions",this._oQuickResize);e.removeAggregation("_items",this._oItemContainer)};f.prototype.onAfterMenuDestroyed=function(e){if(e!==this._oMenu){return}delete this._oQuickSort;delete this._oQuickFilter;delete this._oQuickGroup;delete this._oQuickTotal;delete this._oQuickFreeze;delete this._oQuickResize;delete this._oItemContainer;delete this._oCustomFilterItem};f.prototype.destroy=function(){e.prototype.destroy.apply(this,arguments);this._destroyQuickActions();this._destroyItems();delete this._oColumn};f.prototype._prepareQuickActions=function(e){const t=e._getTable();this._prepareQuickSort(e);if(!t.getEnableCustomFilter()){this._prepareQuickFilter(e)}this._prepareQuickGroup(e);this._prepareQuickTotal(e);this._prepareQuickFreeze(e);this._prepareQuickResize(e)};f.prototype._prepareItems=function(e){const t=e._getTable();if(t.getEnableCustomFilter()){this._prepareCustomFilterItem(e)}if(!this._oItemContainer){this._oItemContainer=new a}this._oItemContainer.addItem(this._oCustomFilterItem)};f.prototype._destroyQuickActions=function(){if(this._oQuickSort){this._oQuickSort.destroy()}if(this._oQuickFilter){this._oQuickFilter.destroy()}if(this._oQuickGroup){this._oQuickGroup.destroy()}if(this._oQuickTotal){this._oQuickTotal.destroy()}if(this._oQuickFreeze){this._oQuickFreeze.destroy()}if(this._oQuickResize){this._oQuickResize.destroy()}delete this._oQuickSort;delete this._oQuickFilter;delete this._oQuickGroup;delete this._oQuickTotal;delete this._oQuickFreeze;delete this._oQuickResize};f.prototype._destroyItems=function(){if(this._oItemContainer){this._oItemContainer.destroy()}delete this._oItemContainer;delete this._oCustomFilterItem};f.prototype._prepareQuickSort=function(e){if(e.isSortableByMenu()){if(!this._oQuickSort){this._oQuickSort=this._createQuickSort()}this._updateQuickSort(e);this._oQuickSort.setVisible(true)}else if(this._oQuickSort){this._oQuickSort.setVisible(false)}};f.prototype._createQuickSort=function(){return new s({items:new u,change:[function(e){const t=e.getParameter("item").getSortOrder();this._oColumn._sort(t,false)},this]})};f.prototype._updateQuickSort=function(e){const i=this._oQuickSort.getItems()[0];i.setLabel(t.Column.getHeaderText(e));i.setSortOrder(e.getSortOrder())};f.prototype._prepareQuickFilter=function(e){if(e.getShowFilterMenuEntry()&&e.isFilterableByMenu()){if(!this._oQuickFilter){this._oQuickFilter=this._createQuickFilter(e);this._oQuickFilter._bHideLabelColon=true}this._updateQuickFilter(e);this._oQuickFilter.setVisible(true)}else if(this._oQuickFilter){this._oQuickFilter.setVisible(false)}};f.prototype._createQuickFilter=function(){return new o({content:new m({submit:[function(e){this._oColumn.setFilterValue(e.getSource().getValue());const t=this._oColumn._getFilterState();if(t===Q.ValueState.None){this._oColumn.filter(e.getSource().getValue());this._oMenu.close()}e.getSource().setValueState(t)},this]}),category:i.table.columnmenu.Category.Filter})};f.prototype._updateQuickFilter=function(e){const i=this._oQuickFilter.getContent()[0];this._oQuickFilter.setLabel(t.Column.getHeaderText(e));i.setValue(e.getFilterValue());i.setValueState(e._getFilterState())};f.prototype._prepareQuickGroup=function(e){if(e._isGroupableByMenu()){if(!this._oQuickGroup){this._oQuickGroup=this._createQuickGroup()}this._updateQuickGroup(e);this._oQuickGroup.setVisible(true)}else if(this._oQuickGroup){this._oQuickGroup.setVisible(false)}};f.prototype._createQuickGroup=function(){return new r({items:new n,change:[function(e){const i=e.getParameter("item").getGrouped();const o=this._oColumn;const s=o._getTable();this._oMenu.attachEventOnce("afterClose",function(){if(i&&(!o.getShowIfGrouped||!o.getShowIfGrouped())){let e;if(t.isNoDataVisible(s)){e=s.getDomRef("noDataCnt")}else{e=s.getDomRef("rowsel0")}if(e){e.focus()}}o._setGrouped(i)})},this]})};f.prototype._updateQuickGroup=function(e){const i=this._oQuickGroup.getItems()[0];i.setLabel(t.Column.getHeaderText(e));i.setGrouped(e.getGrouped())};f.prototype._prepareQuickTotal=function(e){if(e._isAggregatableByMenu()){if(!this._oQuickTotal){this._oQuickTotal=this._createQuickTotal()}this._updateQuickTotal(e);this._oQuickTotal.setVisible(true)}else if(this._oQuickTotal){this._oQuickTotal.setVisible(false)}};f.prototype._createQuickTotal=function(){return new c({items:new l,change:[function(e){this._oColumn.setSummed(e.getParameter("item").getTotaled())},this]})};f.prototype._updateQuickTotal=function(e){const i=this._oQuickTotal.getItems()[0];i.setLabel(t.Column.getHeaderText(e));i.setTotaled(e.getSummed())};f.prototype._prepareQuickFreeze=function(e){if(e._getTable().getEnableColumnFreeze()){if(!this._oQuickFreeze){this._oQuickFreeze=this._createQuickFreeze()}this._updateQuickFreeze(e);this._oQuickFreeze.setVisible(true)}else if(this._oQuickFreeze){this._oQuickFreeze.setVisible(false)}};f.prototype._createQuickFreeze=function(){return new o({label:t.getResourceText("TBL_FREEZE"),content:new h({customTextOn:" ",customTextOff:" ",change:[function(e){const t=this._oColumn._getTable();const i=t.fireColumnFreeze({column:this._oColumn});if(i){if(e.getSource().getState()){t.setFixedColumnCount(this._oColumn.getIndex()+1)}else{t.setFixedColumnCount(this._oColumn.getIndex())}}this._oMenu.close()},this]})})};f.prototype._updateQuickFreeze=function(e){const i=e.getIndex()+t.Column.getHeaderSpan(e)<=e._getTable().getComputedFixedColumnCount();this._oQuickFreeze.getContent()[0].setState(i)};f.prototype._prepareQuickResize=function(e){if(!g.system.desktop&&e.getResizable()){if(!this._oQuickResize){this._oQuickResize=this._createQuickResize(e)}this._oQuickResize.setVisible(true)}else if(this._oQuickResize){this._oQuickResize.setVisible(false)}};f.prototype._createQuickResize=function(e){const t=k.getResourceBundleFor("sap.m");const i=t.getText("table.COLUMNMENU_RESIZE");return new o({label:i,content:new p({icon:"sap-icon://resize-horizontal",tooltip:i,press:[function(t){this._startColumnResize(e);this._oMenu.close()},this]})})};f.prototype._startColumnResize=function(e){const t=e._getTable();t.$().toggleClass("sapUiTableResizing",true);t._$colResize=t.$("rsz");t._$colResize.toggleClass("sapUiTableColRszActive",true)};f.prototype._removeHeaderCellColumnResizer=function(e){const t=e&&e.$().find(".sapUiTableCHT .sapUiTableCellTouchMenu");if(t.length){t.parent().find(".sapUiTableCellInner").show();t.remove()}};f.prototype._prepareCustomFilterItem=function(e){if(e.getShowFilterMenuEntry()){if(!this._oCustomFilterItem){this._oCustomFilterItem=this._createCustomFilterItem()}this._oCustomFilterItem.setVisible(true)}else if(this._oCustomFilterItem){this._oCustomFilterItem.setVisible(false)}};f.prototype._createCustomFilterItem=function(){return new _({label:t.getResourceText("TBL_FILTER_ITEM"),icon:"sap-icon://filter",press:[function(e){this._oColumn._getTable().fireCustomFilter({column:this._oColumn})},this]})};return f});
//# sourceMappingURL=MobileColumnHeaderMenuAdapter.js.map