/*
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./SelectionPlugin","../utils/TableUtils","../library"],function(e,t,n){"use strict";const i=n.SelectionMode;const o=e.extend("sap.ui.table.plugins.BindingSelection",{metadata:{library:"sap.ui.table",properties:{selectionMode:{type:"sap.ui.table.SelectionMode",group:"Behavior",defaultValue:i.MultiToggle}},events:{selectionChange:{parameters:{indices:{type:"int[]"},selectAll:{type:"boolean"}}}}}});o.prototype.onActivate=function(n){e.prototype.onActivate.apply(this,arguments);c(this,n.getBinding());t.Hook.register(n,t.Hook.Keys.Table.RowsBound,s,this)};o.prototype.onDeactivate=function(n){e.prototype.onDeactivate.apply(this,arguments);r(this,n.getBinding());t.Hook.deregister(n,t.Hook.Keys.Table.RowsBound,s,this)};o.prototype.getTableBinding=function(){return this.getControl()?.getBinding()};o.prototype.setSelected=function(e,t,n){if(!this.isIndexSelectable(e.getIndex())){return}if(n&&n.range){const t=this.getSelectedIndex();if(t>=0){this.addSelectionInterval(t,e.getIndex())}}else if(t){this.addSelectionInterval(e.getIndex(),e.getIndex())}else{this.removeSelectionInterval(e.getIndex(),e.getIndex())}};o.prototype.isSelected=function(e){return this.isIndexSelected(e.getIndex())};o.prototype.getRenderConfig=function(){return{headerSelector:{type:"toggle",visible:t.hasSelectAll(this.getControl()),selected:this.getSelectableCount()>0&&this.getSelectableCount()===this.getSelectedCount()}}};function l(e){const t=e.getControl();let n;if(e.getSelectionMode()!==i.MultiToggle){return false}if(e.getSelectableCount()>e.getSelectedCount()){t._iSourceRowIndex=0;e.selectAll();n=true}else{t._iSourceRowIndex=-1;e.clearSelection();n=false}t._iSourceRowIndex=undefined;return n}o.prototype.onHeaderSelectorPress=function(){if(this.getRenderConfig().headerSelector.visible){l(this)}};o.prototype.onKeyboardShortcut=function(e,t){if(e==="toggle"&&l(this)===false){t.setMarked("sapUiTableClearAll")}else if(e==="clear"){this.clearSelection();t.setMarked("sapUiTableClearAll")}};o.prototype.addSelectionInterval=function(e,t){if(this.getSelectionMode()===i.None){return}const n=this.getTableBinding();if(n&&n.addSelectionInterval){if(this.getSelectionMode()===i.Single){e=t;this.setSelectionInterval(e,t)}else{n.addSelectionInterval(e,t)}}};o.prototype.clearSelection=function(){const e=this.getTableBinding();if(e&&e.clearSelection){e.clearSelection()}};o.prototype.getSelectedIndex=function(){const e=this.getTableBinding();if(e&&e.getSelectedIndex){return e.getSelectedIndex()}else{return-1}};o.prototype.getSelectedIndices=function(){const e=this.getTableBinding();if(this.getSelectionMode()===i.Single){const e=this.getSelectedIndex();if(e===-1){return[]}return[e]}if(e&&e.getSelectedIndices){return e.getSelectedIndices()}else{return[]}};o.prototype.getSelectableCount=function(){const e=this.getTableBinding();if(!e){return 0}else if(e.isA("sap.ui.model.analytics.AnalyticalBinding")){const t=e.getGrandTotalContextInfo();return t?t.totalNumberOfLeafs:0}else{return e.getLength()}};o.prototype.getSelectedCount=function(){const e=this.getTableBinding();if(e&&e.getSelectedNodesCount){return e.getSelectedNodesCount()}else{return 0}};o.prototype.isIndexSelectable=function(e){const t=this.getTableBinding();if(t&&t.isIndexSelectable){return t.isIndexSelectable(e)}else{return false}};o.prototype.isIndexSelected=function(e){const t=this.getTableBinding();if(this.getSelectionMode()===i.Single){if(e<0){return false}return e===this.getSelectedIndex()}if(t&&t.isIndexSelected){return t.isIndexSelected(e)}else{return false}};o.prototype.removeSelectionInterval=function(e,t){const n=this.getTableBinding();if(n&&n.removeSelectionInterval){n.removeSelectionInterval(e,t)}};o.prototype.selectAll=function(){if(this.getSelectionMode()!==i.MultiToggle){return}const e=this.getTableBinding();if(e&&e.selectAll){e.selectAll()}};o.prototype.setSelectedIndex=function(e){if(this.getSelectionMode()===i.None){return}if(e===-1){this.clearSelection()}else{const t=this.getTableBinding();if(t&&t.setSelectedIndex){t.setSelectedIndex(e)}}};o.prototype.setSelectionInterval=function(e,t){if(this.getSelectionMode()===i.None){return}const n=this.getTableBinding();if(n&&n.setSelectionInterval){if(this.getSelectionMode()===i.Single){e=t}n.setSelectionInterval(e,t)}};o.prototype.setSelectionMode=function(e){const t=this.getSelectionMode();this.setProperty("selectionMode",e);if(this.getSelectionMode()!==t){this.clearSelection()}return this};o.prototype._getHighestSelectableIndex=function(){const e=this.getTableBinding();if(!e){return-1}else if(e.isA("sap.ui.model.analytics.AnalyticalBinding")){const t=e.providesGrandTotal()&&e.hasTotaledMeasures();return e.getLength()-(t?2:1)}else{return e.getLength()-1}};function s(e){c(this,e)}function c(e,t){t?.attachChange(a,e);t?.attachSelectionChanged?.(d,e)}function r(e,t){t?.detachChange(a,e);t?.detachSelectionChanged?.(d,e)}function a(e){const t=typeof e==="object"?e.getParameter("reason"):e;if(t==="sort"||t==="filter"){this.clearSelection()}}function d(e){const t=e.getParameter("rowIndices");const n=e.getParameter("selectAll");this.fireSelectionChange({rowIndices:t,selectAll:n})}return o});
//# sourceMappingURL=BindingSelection.js.map