/*
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./SelectionPlugin","./PluginBase","./SelectionModelSelection","./BindingSelection","../library","../utils/TableUtils","sap/ui/core/Icon","sap/ui/core/IconPool","sap/base/Log"],function(e,t,i,n,o,l,r,s,c){"use strict";const a=o.SelectionMode;const u=e.extend("sap.ui.table.plugins.MultiSelectionPlugin",{metadata:{library:"sap.ui.table",properties:{limit:{type:"int",group:"Behavior",defaultValue:200},enableNotification:{type:"boolean",group:"Behavior",defaultValue:false},showHeaderSelector:{type:"boolean",group:"Appearance",defaultValue:true},selectionMode:{type:"sap.ui.table.SelectionMode",group:"Behavior",defaultValue:a.MultiToggle}},aggregations:{icon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}},events:{selectionChange:{parameters:{indices:{type:"int[]"},limitReached:{type:"boolean"},customPayload:{type:"object"}}}}}});u.findOn=t.findOn;u.prototype.init=function(){e.prototype.init.apply(this,arguments);this._bLimitReached=false;this._bLimitDisabled=this.getLimit()===0;this.oInnerSelectionPlugin=null};u.prototype.onActivate=function(t){e.prototype.onActivate.apply(this,arguments);this.oInnerSelectionPlugin=h(t);this.oInnerSelectionPlugin.attachSelectionChange(this._onSelectionChange,this);f(this,t.getBinding());t.addAggregation("_hiddenDependents",this.oInnerSelectionPlugin);t.setProperty("selectionMode",this.getSelectionMode());p(this);l.Hook.register(t,l.Hook.Keys.Table.RowsBound,S,this)};function h(e){if(e.isA(["sap.ui.table.TreeTable","sap.ui.table.AnalyticalTable"])){return new n}else{return new i}}u.prototype.onDeactivate=function(t){e.prototype.onDeactivate.apply(this,arguments);t.setProperty("selectionMode",a.None);m(this,t.getBinding());this.oInnerSelectionPlugin?.destroy();delete this.oInnerSelectionPlugin;l.Hook.deregister(t,l.Hook.Keys.Table.RowsBound,S,this)};u.prototype.setSelected=function(e,t,i){if(!this.isIndexSelectable(e.getIndex())){return}if(i&&i.range){const t=this.getSelectedIndex();if(t>=0){this.addSelectionInterval(t,e.getIndex())}}else if(t){this.addSelectionInterval(e.getIndex(),e.getIndex())}else{this.removeSelectionInterval(e.getIndex(),e.getIndex())}};u.prototype.isSelected=function(e){return this.isIndexSelected(e.getIndex())};u.prototype.getRenderConfig=function(){if(!this.isActive()){return e.prototype.getRenderConfig.apply(this,arguments)}return{headerSelector:{type:this._bLimitDisabled?"toggle":"custom",icon:this.getAggregation("icon"),visible:this.getSelectionMode()===a.MultiToggle&&this.getShowHeaderSelector(),enabled:this.getSelectableCount()>0,selected:this.getSelectableCount()>0&&this.getSelectableCount()===this.getSelectedCount(),tooltip:this.getSelectedCount()===0?l.getResourceText("TBL_SELECT_ALL"):l.getResourceText("TBL_DESELECT_ALL")}}};u.prototype.onHeaderSelectorPress=function(){const e=this.getRenderConfig();if(!e.headerSelector.visible||!e.headerSelector.enabled){return}if(e.headerSelector.type==="toggle"){d(this)}else if(e.headerSelector.type==="custom"){if(this.getSelectedCount()>0){this.clearSelection()}else{this.addSelectionInterval(0,this._getHighestSelectableIndex())}}};u.prototype.onKeyboardShortcut=function(e,t){if(e==="toggle"){if(this.getSelectionMode()!==a.MultiToggle){return}if(this._bLimitDisabled){if(!d(this)){t.setMarked("sapUiTableClearAll")}}else{this.addSelectionInterval(0,this._getHighestSelectableIndex())}}else if(e==="clear"){this.clearSelection();t.setMarked("sapUiTableClearAll")}};function d(e){if(e.getSelectableCount()>e.getSelectedCount()){e.selectAll();return true}else{e.clearSelection();return false}}u.prototype.setSelectionMode=function(e){const t=this.getParent();if(t){t.setProperty("selectionMode",e,true)}if(this.oInnerSelectionPlugin){this.oInnerSelectionPlugin.setSelectionMode(e)}this.setProperty("selectionMode",e);p(this);return this};u.prototype.setLimit=function(e){if(typeof e==="number"&&e<0){c.warning("The limit must be greater than or equal to 0",this);return this}this.setProperty("limit",e,!!this.getLimit()===!!e);this._bLimitDisabled=e===0;p(this);return this};u.prototype.setEnableNotification=function(e){this.setProperty("enableNotification",e,true);return this};u.prototype.isLimitReached=function(){return this._bLimitReached};u.prototype.setLimitReached=function(e){this._bLimitReached=e};u.prototype.selectAll=function(e){if(!this._bLimitDisabled){return Promise.reject(new Error("Not possible if the limit is enabled"))}const t=this.getSelectableCount();if(t===0){return Promise.reject(new Error("Nothing to select"))}return this.addSelectionInterval(0,this._getHighestSelectableIndex(),e)};function g(e,t,i,n){const o=e._getHighestSelectableIndex();if(t<0&&i<0||t>o&&i>o){return Promise.reject(new Error("Out of range"))}t=Math.min(Math.max(0,t),o);i=Math.min(Math.max(0,i),o);const r=e.getLimit();const s=i<t;let c=s?i:t;let a;if(n&&e.isIndexSelected(t)){if(s){t--}else if(t!==i){t++;c++}}a=Math.abs(i-t)+1;if(!e._bLimitDisabled){e.setLimitReached(a>r);if(e.isLimitReached()){if(s){i=t-r+1;c=i-1}else{i=t+r-1}a=r+1}}return l.loadContexts(e.getControl().getBinding(),c,a).then(function(){return{indexFrom:t,indexTo:i}})}u.prototype.setSelectionInterval=function(e,t,i){const n=this.getControl();const o=this.getSelectionMode();if(o===a.None){return Promise.reject(new Error("SelectionMode is '"+a.None+"'"))}if(o===a.Single){e=t}return g(this,e,t,false).then(function(e){this._oCustomEventPayloadTmp=i;this.oInnerSelectionPlugin.setSelectionInterval(e.indexFrom,e.indexTo);delete this._oCustomEventPayloadTmp;if(!this.isLimitReached()){return Promise.resolve()}return l.scrollTableToIndex(n,e.indexTo,e.indexFrom>e.indexTo).then(function(){if(!this.getEnableNotification()){return Promise.resolve()}return l.showNotificationPopoverAtIndex(n,e.indexTo,this.getLimit())}.bind(this))}.bind(this))};u.prototype.setSelectedIndex=function(e,t){return this.setSelectionInterval(e,e,t)};u.prototype.addSelectionInterval=function(e,t,i){const n=this.getControl();const o=this.getSelectionMode();if(o===a.None){return Promise.reject(new Error("SelectionMode is '"+a.None+"'"))}if(o===a.Single){return this.setSelectionInterval(t,t)}if(o===a.MultiToggle){return g(this,e,t,true).then(function(e){this._oCustomEventPayloadTmp=i;this.oInnerSelectionPlugin.addSelectionInterval(e.indexFrom,e.indexTo);delete this._oCustomEventPayloadTmp;if(!this.isLimitReached()){return Promise.resolve()}return l.scrollTableToIndex(n,e.indexTo,e.indexFrom>e.indexTo).then(function(){if(!this.getEnableNotification()){return Promise.resolve()}return l.showNotificationPopoverAtIndex(n,e.indexTo,this.getLimit())}.bind(this))}.bind(this))}};u.prototype.clearSelection=function(e){if(this.oInnerSelectionPlugin){this.setLimitReached(false);this._oCustomEventPayloadTmp=e;this.oInnerSelectionPlugin.clearSelection();delete this._oCustomEventPayloadTmp}};u.prototype.getSelectedIndex=function(){if(this.oInnerSelectionPlugin){return this.oInnerSelectionPlugin.getSelectedIndex()}return-1};u.prototype.getSelectedIndices=function(){if(this.oInnerSelectionPlugin){return this.oInnerSelectionPlugin.getSelectedIndices()}return[]};u.prototype.getSelectableCount=function(){if(this.oInnerSelectionPlugin){return this.oInnerSelectionPlugin.getSelectableCount()}return 0};u.prototype.getSelectedCount=function(){if(this.oInnerSelectionPlugin){return this.oInnerSelectionPlugin.getSelectedCount()}return 0};u.prototype.isIndexSelectable=function(e){if(this.oInnerSelectionPlugin){return this.oInnerSelectionPlugin.isIndexSelectable(e)}return false};u.prototype.isIndexSelected=function(e){if(this.oInnerSelectionPlugin){return this.oInnerSelectionPlugin.isIndexSelected(e)}return false};u.prototype.removeSelectionInterval=function(e,t,i){if(this.oInnerSelectionPlugin){this.setLimitReached(false);this._oCustomEventPayloadTmp=i;this.oInnerSelectionPlugin.removeSelectionInterval(e,t);delete this._oCustomEventPayloadTmp}};function p(e){if(e.getSelectionMode()===a.MultiToggle&&!e._bLimitDisabled){if(!e.getAggregation("icon")){const t=new r({useIconTooltip:false});t.addStyleClass("sapUiTableSelectClear");e.setAggregation("icon",t,true)}const t=e.getAggregation("icon");const i=e.getSelectedCount();if(e.getSelectableCount()===i&&i!==0){t.setSrc(s.getIconURI(l.ThemeParameters.allSelectedIcon))}else if(i!==0){t.setSrc(s.getIconURI(l.ThemeParameters.clearSelectionIcon))}else{t.setSrc(s.getIconURI(l.ThemeParameters.checkboxIcon))}}else{e.destroyAggregation("icon")}}u.prototype._onSelectionChange=function(e){const t=e.getParameter("rowIndices");p(this);this.fireSelectionChange({rowIndices:t,limitReached:this.isLimitReached(),customPayload:typeof this._oCustomEventPayloadTmp==="object"?this._oCustomEventPayloadTmp:null,_internalTrigger:e.getParameter("_internalTrigger")})};u.prototype._getHighestSelectableIndex=function(){if(this.oInnerSelectionPlugin){return this.oInnerSelectionPlugin._getHighestSelectableIndex()}return 0};function S(e){f(this,e)}function f(e,t){t?.attachChange(I,e)}function m(e,t){t?.detachChange(I,e)}function I(e){p(this)}u.prototype.onThemeChanged=function(){p(this)};return u});
//# sourceMappingURL=MultiSelectionPlugin.js.map