/*
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./SelectionPlugin","./SelectionMode","./PluginBase","../library","../utils/TableUtils","sap/ui/core/Icon","sap/ui/core/IconPool"],function(e,t,i,n,o,s,l){"use strict";const r=o.createWeakMapFacade();const c=e.extend("sap.ui.table.plugins.ODataV4Selection",{metadata:{library:"sap.ui.table",properties:{selectionMode:{type:"sap.ui.table.plugins.SelectionMode",group:"Behavior",defaultValue:t.MultiToggle},limit:{type:"int",group:"Behavior",defaultValue:200},enableNotification:{type:"boolean",group:"Behavior",defaultValue:false},hideHeaderSelector:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{icon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}}}});c.findOn=i.findOn;c.prototype.init=function(){e.prototype.init.apply(this,arguments);const t=new s({src:l.getIconURI(o.ThemeParameters.checkboxIcon),useIconTooltip:false});t.addStyleClass("sapUiTableSelectClear");this.setAggregation("icon",t,true);r(this).bLimitReached=false;r(this).oRangeSelectionStartContext=null};c.prototype.onActivate=function(t){const i=t.getBinding();f(this,i);e.prototype.onActivate.apply(this,arguments);t.setProperty("selectionMode",this.getSelectionMode());b(this,i);o.Hook.register(t,o.Hook.Keys.Table.RowsBound,p,this);o.Hook.register(t,o.Hook.Keys.Table.UnbindRows,C,this)};c.prototype.onDeactivate=function(t){e.prototype.onDeactivate.apply(this,arguments);r(this).bLimitReached=false;r(this).oRangeSelectionStartContext=null;t.setProperty("selectionMode",n.SelectionMode.None);clearTimeout(r(this).iSelectionChangeTimeout);delete r(this).iSelectionChangeTimeout;y(this,t.getBinding());o.Hook.deregister(t,o.Hook.Keys.Table.RowsBound,p,this);o.Hook.register(t,o.Hook.Keys.Table.UnbindRows,C,this);delete r(this).aSelectedContexts;delete r(this).iSelectionCount};c.prototype.setSelected=function(e,i,n){const o=e.getRowBindingContext();const s=this.getSelectionMode();if(!this.isActive()||!o||!T(o)){return}if(n?.range){a(this,e);return}if(this.isSelected(e)===i){return}if(s===t.Single&&i){this.clearSelection()}o.setSelected(i);r(this).oRangeSelectionStartContext=i&&s===t.MultiToggle?o:null};function a(e,t){if(!r(e).oRangeSelectionStartContext){return}let i=r(e).oRangeSelectionStartContext.getIndex();const n=t.getRowBindingContext();const o=n?n.getIndex():-1;if(i!==o){i+=o>i?1:-1}L(e,i,o)}c.prototype.isSelected=function(e){if(!this.isActive()){return false}return e.getRowBindingContext()?.isSelected()??false};c.prototype.getSelectedCount=function(){if(!this.isActive()){return 0}r(this).iSelectionCount??=this.getSelectedContexts().length;return r(this).iSelectionCount};function g(e){const t=e.getControl().getBinding();let i=-1;if(!t||t.getLength()===0){return 0}if(r(e).iSelectableCount!=null){return r(e).iSelectableCount}if(t.getAggregation()){if(e._isLimitDisabled()){const e=t.getAllCurrentContexts();if(t.getLength()===e.length){i=e.filter(T).length}}}else if(t.isLengthFinal()){i=t.getLength()}r(e).iSelectableCount=i;return i}function d(e){if(e._isLimitDisabled()){return}let t=l.getIconURI(o.ThemeParameters.checkboxIcon);if(e.getSelectedCount()>0){if(u(e)){t=l.getIconURI(o.ThemeParameters.allSelectedIcon)}else{t=l.getIconURI(o.ThemeParameters.clearSelectionIcon)}}e.getAggregation("icon").setSrc(t)}c.prototype.getRenderConfig=function(){if(!this.isActive()){return e.prototype.getRenderConfig.apply(this,arguments)}d(this);const i={headerSelector:{type:this._isLimitDisabled()?"toggle":"custom",icon:this.getAggregation("icon"),visible:this.getSelectionMode()===t.MultiToggle&&!this.getHideHeaderSelector(),enabled:g(this)!==0,selected:u(this),tooltip:this.getSelectedCount()===0?o.getResourceText("TBL_SELECT_ALL"):o.getResourceText("TBL_DESELECT_ALL")}};return i};function h(e){if(u(e)){e.clearSelection();return false}else if(e._isLimitDisabled()){const t=e.getControl().getBinding();if(t?.getLength()){L(e,0,t.getLength()-1);return true}}return undefined}function u(e){const t=g(e);return t>0&&t===e.getSelectedCount()}c.prototype.onHeaderSelectorPress=function(){if(!this.isActive()){return}const e=this.getRenderConfig();if(!e.headerSelector.visible||!e.headerSelector.enabled){return}if(e.headerSelector.type==="toggle"){h(this)}else if(e.headerSelector.type==="custom"){if(this.getSelectedCount()>0){this.clearSelection()}else{const e=this.getControl().getBinding();if(e?.getLength()>0){L(this,0,e.getLength()-1)}}}};c.prototype.onKeyboardShortcut=function(e,i){if(!this.isActive()){return}if(e==="toggle"){if(this.getSelectionMode()!==t.MultiToggle){return}if(this._isLimitDisabled()){if(h(this)===false){i.setMarked("sapUiTableClearAll")}}else{const e=this.getControl().getBinding();if(e?.getLength()>0){L(this,0,e.getLength()-1)}}}else if(e==="clear"){this.clearSelection();i.setMarked("sapUiTableClearAll")}};c.prototype.setSelectionMode=function(e){this.setProperty("selectionMode",e,true);if(!this.isActive()){return this}r(this).oRangeSelectionStartContext=null;this.clearSelection();this.getControl().setProperty("selectionMode",this.getSelectionMode());return this};c.prototype.setLimit=function(e){this.setProperty("limit",e);r(this).bLimitReached=false;return this};function f(e,t){if(!t){return}if(!t.getModel().isA("sap.ui.model.odata.v4.ODataModel")){throw new Error("Model must be sap.ui.model.odata.v4.ODataModel")}S(e,t)}function S(e,i,n){const o=i.getHeaderContext();let s=[];if(n){s=n.isSelected()?[n]:[]}else{s=e.getSelectedContexts();if(o?.isSelected()){s.unshift(o)}}for(const e of s){if(e===o){throw new Error("Header context must not be selected")}if(!T(e)){throw new Error(`Context ${e} is not allowed to be selected`)}}if(e.getSelectionMode()===t.Single&&e.getSelectedCount()>1){throw new Error("Multiple contexts selected. Cannot select more than one context in selection mode 'Single'")}}function p(e){f(this,e);b(this,e)}function C(){delete r(this).aSelectedContexts;delete r(this).iSelectionCount}function b(e,t){t?.attachEvent("selectionChanged",m,e);t?.attachChange(x,e)}function y(e,t){t?.detachEvent("selectionChanged",m,e);t?.detachChange(x,e)}function m(e){const t=e.getParameter("context");delete r(this).aSelectedContexts;delete r(this).iSelectionCount;try{S(this,t.getBinding(),t)}catch(e){t.setSelected(false);throw e}if(r(this).iSelectionChangeTimeout){return}r(this).iSelectionChangeTimeout=setTimeout(()=>{this.fireSelectionChange();delete r(this).iSelectionChangeTimeout},0)}function x(e){delete r(this).aSelectedContexts;delete r(this).iSelectionCount;delete r(this).iSelectableCount}c.prototype._isLimitDisabled=function(){return this.getLimit()===0};function L(e,t,i){const n=e.getControl();const s=e.getLimit();const l=i<t;let c=l?i:t;let a=Math.abs(i-t)+1;if(!e._isLimitDisabled()){r(e).bLimitReached=a>s;if(r(e).bLimitReached){if(l){i=t-s+1;c=i}else{i=t+s-1}a=s+1}}o.loadContexts(n.getBinding(),c,a).then(function(t){t.forEach(function(t){if(!T(t)||t.isSelected()){return}if(l&&t.getIndex()>=i||t.getIndex()<=i){t.setSelected(true)}if(t.getIndex()===i){r(e).oRangeSelectionStartContext=t}});if(r(e).bLimitReached){o.scrollTableToIndex(n,i,l).then(function(){if(e.getEnableNotification()){o.showNotificationPopoverAtIndex(n,i,e.getLimit())}})}})}function T(e){const t=e.getBinding();const i=e===t.getHeaderContext();const n=e.getProperty("@$ui5.node.isExpanded")===undefined;const o=e.getProperty("@$ui5.node.isTotal");const s="hierarchyQualifier"in(t.getAggregation()||{});return!i&&(s||n&&!o)}c.prototype.clearSelection=function(){if(!this.isActive()){return}this.getControl().getBinding()?.getHeaderContext()?.setSelected(false)};c.prototype.getSelectedContexts=function(){if(!this.isActive()){return[]}r(this).aSelectedContexts??=this.getControl().getBinding()?.getAllCurrentContexts().filter(e=>e.isSelected())??[];r(this).iSelectionCount=r(this).aSelectedContexts.length;return r(this).aSelectedContexts};c.prototype.onThemeChanged=function(){d(this)};return c});
//# sourceMappingURL=ODataV4Selection.js.map