/*
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/model/SelectionModel","./SelectionPlugin","../utils/TableUtils","../library"],function(e,t,o,i){"use strict";const n=i.SelectionMode;const l=t.extend("sap.ui.table.plugins.SelectionModelSelection",{metadata:{library:"sap.ui.table",properties:{selectionMode:{type:"sap.ui.table.SelectionMode",group:"Behavior",defaultValue:n.MultiToggle}},events:{selectionChange:{parameters:{indices:{type:"int[]"},selectAll:{type:"boolean"}}}}}});l.prototype.init=function(){t.prototype.init.apply(this,arguments);this.oSelectionModel=new e(r(this.getSelectionMode()))};l.prototype.exit=function(){t.prototype.exit.apply(this,arguments);this.oSelectionModel?.destroy();delete this.oSelectionModel};l.prototype.onActivate=function(e){t.prototype.onActivate.apply(this,arguments);this.oSelectionModel.attachSelectionChanged(a,this);h(this,e.getBinding());o.Hook.register(e,o.Hook.Keys.Table.TotalRowCountChanged,u,this);o.Hook.register(e,o.Hook.Keys.Table.UnbindRows,d,this);o.Hook.register(e,o.Hook.Keys.Table.RowsBound,c,this);this._iTotalRowCount=e._getTotalRowCount()};l.prototype.onDeactivate=function(e){t.prototype.onDeactivate.apply(this,arguments);this.oSelectionModel?.detachSelectionChanged(a,this);this.oSelectionModel?.clearSelection();g(this,e.getBinding());o.Hook.deregister(e,o.Hook.Keys.Table.TotalRowCountChanged,u,this);o.Hook.deregister(e,o.Hook.Keys.Table.UnbindRows,d,this);o.Hook.deregister(e,o.Hook.Keys.Table.RowsBound,c,this)};l.prototype.setSelected=function(e,t,o){if(!this.isIndexSelectable(e.getIndex())){return}if(o&&o.range){const t=this.getSelectedIndex();if(t>=0){this.addSelectionInterval(t,e.getIndex())}}else if(t){this.addSelectionInterval(e.getIndex(),e.getIndex())}else{this.removeSelectionInterval(e.getIndex(),e.getIndex())}};l.prototype.isSelected=function(e){return this.isIndexSelected(e.getIndex())};l.prototype.getRenderConfig=function(){return{headerSelector:{type:"toggle",visible:o.hasSelectAll(this.getControl()),selected:this.getSelectableCount()>0&&this.getSelectableCount()===this.getSelectedCount()}}};function s(e){const t=e.getControl();let o;if(e.getSelectionMode()!==n.MultiToggle){return false}if(e.getSelectableCount()>e.getSelectedCount()){t._iSourceRowIndex=0;e.selectAll();o=true}else{t._iSourceRowIndex=-1;e.clearSelection();o=false}t._iSourceRowIndex=undefined;return o}l.prototype.onHeaderSelectorPress=function(){if(this.getRenderConfig().headerSelector.visible){s(this)}};l.prototype.onKeyboardShortcut=function(e,t){if(e==="toggle"&&s(this)===false){t.setMarked("sapUiTableClearAll")}else if(e==="clear"){this.clearSelection();t.setMarked("sapUiTableClearAll")}};l.prototype.addSelectionInterval=function(e,t){if(!this.oSelectionModel||this.getSelectionMode()===n.None){return}this.oSelectionModel.addSelectionInterval(e,t)};l.prototype.clearSelection=function(){if(this.oSelectionModel){this.oSelectionModel.clearSelection()}};l.prototype.getSelectedIndex=function(){if(this.oSelectionModel){return this.oSelectionModel.getLeadSelectedIndex()}return-1};l.prototype.getSelectedIndices=function(){if(this.oSelectionModel){return this.oSelectionModel.getSelectedIndices()}return[]};l.prototype.getSelectableCount=function(){const e=this.getControl().getBinding();return e?e.getLength():0};l.prototype.getSelectedCount=function(){return this.getSelectedIndices().length};l.prototype.isIndexSelectable=function(e){return e>=0&&e<=this._getHighestSelectableIndex()};l.prototype.isIndexSelected=function(e){return this.getSelectedIndices().indexOf(e)!==-1};l.prototype.removeSelectionInterval=function(e,t){if(this.oSelectionModel){this.oSelectionModel.removeSelectionInterval(e,t)}};l.prototype.selectAll=function(){if(!this.oSelectionModel||this.getSelectionMode()!==n.MultiToggle){return}this.oSelectionModel.selectAll(this._getHighestSelectableIndex())};l.prototype.setSelectedIndex=function(e){if(this.getSelectionMode()===n.None){return}if(e===-1){this.clearSelection()}else{this.setSelectionInterval(e,e)}};l.prototype.setSelectionInterval=function(e,t){if(!this.oSelectionModel||this.getSelectionMode()===n.None){return}this.oSelectionModel.setSelectionInterval(e,t)};l.prototype.setSelectionMode=function(e){const t=this.getSelectionMode();this.setProperty("selectionMode",e);if(this.getSelectionMode()!==t){this.clearSelection()}if(this.oSelectionModel){this.oSelectionModel.setSelectionMode(r(this.getSelectionMode()))}return this};function r(t){return t===n.MultiToggle?e.MULTI_SELECTION:e.SINGLE_SELECTION}l.prototype._getHighestSelectableIndex=function(){const e=this.getControl().getBinding();return e?e.getLength()-1:-1};function c(e){h(this,e)}function d(){this._bSuppressSelectionChangeEvent=true;this.clearSelection();delete this._bSuppressSelectionChangeEvent}function a(e){const t=e.getParameter("rowIndices");const o=e.getParameter("selectAll");if(!this._bSuppressSelectionChangeEvent){this.fireSelectionChange({rowIndices:t,selectAll:o,_internalTrigger:this._bInternalTrigger})}}function h(e,t){t?.attachChange(S,e)}function g(e,t){t?.detachChange(S,e)}function S(e){const t=typeof e==="object"?e.getParameter("reason"):e;if(t==="sort"||t==="filter"){this._bInternalTrigger=true;this.clearSelection();delete this._bInternalTrigger}}function u(){const e=this.getControl()._getTotalRowCount();if(this._iTotalRowCount>0&&this._iTotalRowCount!==e){this._bInternalTrigger=true;this.clearSelection();delete this._bInternalTrigger}this._iTotalRowCount=e}return l});
//# sourceMappingURL=SelectionModelSelection.js.map