/*
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["../utils/TableUtils","./RowMode","sap/ui/Device","sap/ui/thirdparty/jquery"],function(t,e,o,jQuery){"use strict";const i=t.createWeakMapFacade();const s=e.extend("sap.ui.table.rowmodes.Auto",{metadata:{library:"sap.ui.table",properties:{minRowCount:{type:"int",defaultValue:5,group:"Appearance"},maxRowCount:{type:"int",defaultValue:-1,group:"Appearance"},fixedTopRowCount:{type:"int",defaultValue:0,group:"Appearance"},fixedBottomRowCount:{type:"int",defaultValue:0,group:"Appearance"},rowContentHeight:{type:"int",defaultValue:0,group:"Appearance"},hideEmptyRows:{type:"boolean",defaultValue:false,group:"Appearance",visibility:"hidden"}}},constructor:function(t){Object.defineProperty(this,"bLegacy",{value:typeof t==="boolean"?t:false});e.apply(this,arguments)}});const n={};function a(t){const e=t.getTable();const i=e?e.getDomRef("tableCCnt"):null;if(i&&o.browser.chrome&&window.devicePixelRatio!==1){const e=document.createElement("table");const o=e.insertRow();const s=t.getRowContentHeight();e.classList.add("sapUiTableCtrl");o.classList.add("sapUiTableTr");if(s>0){o.style.height=t.getBaseRowHeightOfTable()+"px"}i.appendChild(e);const n=o.getBoundingClientRect().height;i.removeChild(e);return n}else{return t.getBaseRowHeightOfTable()}}s.prototype.init=function(){e.prototype.init.apply(this,arguments);i(this).iPendingStartTableUpdateSignals=0;i(this).bRowCountAutoAdjustmentActive=false;i(this).iLastAvailableSpace=0;i(this).rowCount=-1;i(this).bTableIsFlexItem=false;i(this).adjustRowCountToAvailableSpaceAsync=t.throttleFrameWise(this.adjustRowCountToAvailableSpace.bind(this))};s.prototype.attachEvents=function(){e.prototype.attachEvents.apply(this,arguments);t.addDelegate(this.getTable(),n,this)};s.prototype.detachEvents=function(){e.prototype.detachEvents.apply(this,arguments);t.removeDelegate(this.getTable(),n)};s.prototype.cancelAsyncOperations=function(){e.prototype.cancelAsyncOperations.apply(this,arguments);this.stopAutoRowMode()};s.prototype.registerHooks=function(){e.prototype.registerHooks.apply(this,arguments);t.Hook.register(this.getTable(),t.Hook.Keys.Table.RefreshRows,this._onTableRefreshRows,this);t.Hook.register(this.getTable(),t.Hook.Keys.Table.UpdateSizes,this._onUpdateTableSizes,this)};s.prototype.deregisterHooks=function(){e.prototype.deregisterHooks.apply(this,arguments);t.Hook.deregister(this.getTable(),t.Hook.Keys.Table.RefreshRows,this._onTableRefreshRows,this);t.Hook.deregister(this.getTable(),t.Hook.Keys.Table.UpdateSizes,this._onUpdateTableSizes,this)};s.prototype.getFixedTopRowCount=function(){if(this.bLegacy){const t=this.getTable();return t?t.getFixedRowCount():0}return this.getProperty("fixedTopRowCount")};s.prototype.getFixedBottomRowCount=function(){if(this.bLegacy){const t=this.getTable();return t?t.getFixedBottomRowCount():0}return this.getProperty("fixedBottomRowCount")};s.prototype.getMinRowCount=function(){if(this.bLegacy){const t=this.getTable();return t?t.getMinAutoRowCount():0}return this.getProperty("minRowCount")};s.prototype.getRowContentHeight=function(){if(this.bLegacy){const t=this.getTable();return t?t.getRowHeight():0}return this.getProperty("rowContentHeight")};s.prototype.setHideEmptyRows=function(t){this.setProperty("hideEmptyRows",t);if(t){this.disableNoData()}else{this.enableNoData()}return this};s.prototype.getHideEmptyRows=function(){return this.getProperty("hideEmptyRows")};s.prototype._getMinRowCount=function(){const t=this.getMinRowCount();const e=this.getMaxRowCount();if(e>=0){return Math.min(t,e)}else{return t}};s.prototype.getMinRequestLength=function(){const e=this.getTable();let i=this.getConfiguredRowCount();if(u(this)||e&&!e._bContextsAvailable){const e=Math.ceil(o.resize.height/t.DefaultRowHeight.sapUiSizeCondensed);i=Math.max(i,e)}return i};s.prototype.updateTable=function(){if(this.getHideEmptyRows()&&this.getComputedRowCounts().count===0){const t=this.getConfiguredRowCount();if(t>0){this.getRowContexts(t)}}return e.prototype.updateTable.apply(this,arguments)};s.prototype.getComputedRowCounts=function(){if(u(this)){return{count:0,scrollable:0,fixedTop:0,fixedBottom:0}}let t=this.getConfiguredRowCount();const e=this.getFixedTopRowCount();const o=this.getFixedBottomRowCount();if(this.getHideEmptyRows()){t=Math.min(t,this.getTotalRowCountOfTable())}return this.computeStandardizedRowCounts(t,e,o)};s.prototype.getTableStyles=function(){let t="0px";if(u(this)){t="auto"}else{const e=this.getConfiguredRowCount();if(e===0||e===this._getMinRowCount()){t="auto"}}return{height:t}};s.prototype.getTableBottomPlaceholderStyles=function(){if(!this.getHideEmptyRows()){return undefined}let t;if(u(this)){t=this._getMinRowCount()}else{t=this.getConfiguredRowCount()-this.getComputedRowCounts().count}return{height:t*this.getBaseRowHeightOfTable()+"px"}};s.prototype.getRowContainerStyles=function(){return{height:this.getComputedRowCounts().count*Math.max(this.getBaseRowHeightOfTable(),a(this))+"px"}};s.prototype.renderRowStyles=function(t){const e=this.getRowContentHeight();if(e>0){t.style("height",this.getBaseRowHeightOfTable()+"px")}};s.prototype.renderCellContentStyles=function(t){let e=this.getRowContentHeight();if(this.bLegacy){if(e>0){t.style("max-height",e+"px")}return}if(e<=0){e=this.getDefaultRowContentHeightOfTable()}if(e>0){t.style("max-height",e+"px")}};s.prototype.getBaseRowContentHeight=function(){return Math.max(0,this.getRowContentHeight())};s.prototype._onTableRefreshRows=function(){const t=this.getConfiguredRowCount();if(t>0){if(!u(this)){this.initTableRowsAfterDataRequested(t)}this.getRowContexts(t)}};s.prototype.getConfiguredRowCount=function(){let t=Math.max(0,this.getMinRowCount(),i(this).rowCount);const e=this.getMaxRowCount();if(e>=0){t=Math.min(t,e)}return t};s.prototype.startAutoRowMode=function(){i(this).adjustRowCountToAvailableSpaceAsync(t.RowsUpdateReason.Render,true)};s.prototype.stopAutoRowMode=function(){this.deregisterResizeHandler();i(this).adjustRowCountToAvailableSpaceAsync.cancel();i(this).bRowCountAutoAdjustmentActive=false;l(this)};s.prototype.registerResizeHandler=function(e){const o=this.getTable();if(o){t.registerResizeHandler(o,"AutoRowMode",this.onResize.bind(this),null,e===true);t.registerResizeHandler(o,"AutoRowMode-BeforeTable",this.onResize.bind(this),"before");t.registerResizeHandler(o,"AutoRowMode-AfterTable",this.onResize.bind(this),"after")}};s.prototype.deregisterResizeHandler=function(){const e=this.getTable();if(e){t.deregisterResizeHandler(e,["AutoRowMode, AutoRowMode-BeforeTable, AutoRowMode-AfterTable"])}};s.prototype.onResize=function(e){const o=e.oldSize.height;const s=e.size.height;if(o!==s){r(this);i(this).adjustRowCountToAvailableSpaceAsync(t.RowsUpdateReason.Resize)}};s.prototype._onUpdateTableSizes=function(e){if(e===t.RowsUpdateReason.Resize||e===t.RowsUpdateReason.Render){return}if(i(this).bRowCountAutoAdjustmentActive){r(this);i(this).adjustRowCountToAvailableSpaceAsync(e)}};s.prototype.adjustRowCountToAvailableSpace=function(e,o){o=o===true;const s=this.getTable();const n=s?s.getDomRef():null;if(!s||s._bInvalid||!n||!t.isThemeApplied()){l(this);return}i(this).bTableIsFlexItem=window.getComputedStyle(n.parentNode).display==="flex";if(n.scrollHeight===0){if(o){this.registerResizeHandler(!i(this).bTableIsFlexItem);i(this).bRowCountAutoAdjustmentActive=true}l(this);return}const r=this.determineAvailableSpace();const u=this.getConfiguredRowCount();const h=Math.floor(r/a(this));const p=this.getComputedRowCounts().count;i(this).rowCount=h;const g=this.getComputedRowCounts().count;if(this.bLegacy){s.setProperty("visibleRowCount",g,true)}if(p!==g){this.updateTable(e)}else{if(u!==h||e===t.RowsUpdateReason.Zoom){this.applyTableStyles();this.applyRowContainerStyles();this.applyTableBottomPlaceholderStyles()}if(!this._bFiredRowsUpdatedAfterRendering&&s.getRows().length>0){this.fireRowsUpdated(e)}}if(o){this.registerResizeHandler(!i(this).bTableIsFlexItem);i(this).bRowCountAutoAdjustmentActive=true}l(this)};s.prototype.determineAvailableSpace=function(){const t=this.getTable();const e=t?t.getDomRef():null;const s=t?t.getDomRef("tableCCnt"):null;const n=t?t.getDomRef("placeholder-bottom"):null;if(!e||!s||!e.parentNode){return 0}let a=0;const r=s.clientHeight;const l=n?n.clientHeight:0;if(i(this).bTableIsFlexItem){const t=e.childNodes;for(let e=0;e<t.length;e++){a+=t[e].offsetHeight}a-=r-l}else{a=e.scrollHeight-r-l}const u=t._getScrollExtension();if(!u.isHorizontalScrollbarVisible()){const t={};t[o.browser.BROWSER.CHROME]=16;t[o.browser.BROWSER.FIREFOX]=16;t[o.browser.BROWSER.SAFARI]=16;t[o.browser.BROWSER.ANDROID]=8;a+=t[o.browser.name]}const h=i(this).bTableIsFlexItem?e:e.parentNode;const p=Math.max(0,Math.floor(jQuery(h).height()-a));const g=Math.abs(p-i(this).iLastAvailableSpace);if(g>=5){i(this).iLastAvailableSpace=p}return i(this).iLastAvailableSpace};n.onBeforeRendering=function(t){const e=t&&t.isMarked("renderRows");if(!e){this.stopAutoRowMode()}};n.onAfterRendering=function(t){const e=t&&t.isMarked("renderRows");if(!e){this.startAutoRowMode()}};function r(e){i(e).iPendingStartTableUpdateSignals++;t.Hook.call(e.getTable(),t.Hook.Keys.Signal,"StartTableUpdate")}function l(e){for(let o=0;o<i(e).iPendingStartTableUpdateSignals;o++){t.Hook.call(e.getTable(),t.Hook.Keys.Signal,"EndTableUpdate")}i(e).iPendingStartTableUpdateSignals=0}function u(t){return i(t).rowCount===-1}return s});
//# sourceMappingURL=Auto.js.map