/*
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./RowMode","../utils/TableUtils","sap/ui/Device","sap/m/Menu","sap/m/MenuItem","sap/ui/core/InvisibleMessage"],function(t,e,o,n,i,s){"use strict";const a=e.createWeakMapFacade();const r=t.extend("sap.ui.table.rowmodes.Interactive",{metadata:{library:"sap.ui.table",final:true,properties:{rowCount:{type:"int",defaultValue:10,group:"Appearance"},minRowCount:{type:"int",defaultValue:5,group:"Appearance"},maxRowCount:{type:"int",defaultValue:-1,group:"Appearance"},fixedTopRowCount:{type:"int",defaultValue:0,group:"Appearance"},fixedBottomRowCount:{type:"int",defaultValue:0,group:"Appearance"},rowContentHeight:{type:"int",defaultValue:0,group:"Appearance"}}},constructor:function(e){Object.defineProperty(this,"bLegacy",{value:typeof e==="boolean"?e:false});t.apply(this,arguments)}});const u={};const g={};function h(t){a(this).rowCount=t;s.getInstance().announce(e.getResourceText("TBL_RSZ_RESIZED",[t]))}r.prototype.attachEvents=function(){t.prototype.attachEvents.apply(this,arguments);e.addDelegate(this.getTable(),u,this)};r.prototype.detachEvents=function(){t.prototype.detachEvents.apply(this,arguments);e.removeDelegate(this.getTable(),u)};r.prototype.registerHooks=function(){t.prototype.registerHooks.apply(this,arguments);e.Hook.register(this.getTable(),e.Hook.Keys.Table.RefreshRows,this._onTableRefreshRows,this)};r.prototype.deregisterHooks=function(){t.prototype.deregisterHooks.apply(this,arguments);e.Hook.deregister(this.getTable(),e.Hook.Keys.Table.RefreshRows,this._onTableRefreshRows,this)};r.prototype.getRowCount=function(){if(this.bLegacy){const t=this.getTable();return t?t.getVisibleRowCount():0}return this.getProperty("rowCount")};r.prototype.getFixedTopRowCount=function(){if(this.bLegacy){const t=this.getTable();return t?t.getFixedRowCount():0}return this.getProperty("fixedTopRowCount")};r.prototype.getFixedBottomRowCount=function(){if(this.bLegacy){const t=this.getTable();return t?t.getFixedBottomRowCount():0}return this.getProperty("fixedBottomRowCount")};r.prototype.getMinRowCount=function(){if(this.bLegacy){const t=this.getTable();return t?t.getMinAutoRowCount():0}return this.getProperty("minRowCount")};r.prototype.getRowContentHeight=function(){if(this.bLegacy){const t=this.getTable();return t?t.getRowHeight():0}return this.getProperty("rowContentHeight")};r.prototype.getMinRequestLength=function(){return this.getActualRowCount()};r.prototype.getComputedRowCounts=function(){const t=this.getActualRowCount();const e=this.getFixedTopRowCount();const o=this.getFixedBottomRowCount();return this.computeStandardizedRowCounts(t,e,o)};r.prototype.getTableStyles=function(){return{height:"auto"}};r.prototype.getRowContainerStyles=function(){const t=this.getComputedRowCounts().count*this.getBaseRowHeightOfTable()+"px";if(this.bLegacy&&!e.isVariableRowHeightEnabled(this.getTable())){return{minHeight:t}}return{height:t}};r.prototype.renderRowStyles=function(t){const e=this.getRowContentHeight();if(e>0){t.style("height",this.getBaseRowHeightOfTable()+"px")}};r.prototype.renderCellContentStyles=function(t){let e=this.getRowContentHeight();if(this.bLegacy){return}if(e<=0){e=this.getDefaultRowContentHeightOfTable()}if(e>0){t.style("max-height",e+"px")}};r.prototype.renderInTableBottomArea=function(t){const o=this.getTable();t.openStart("div",o.getId()+"-heightResizer").attr("role","separator").attr("aria-orientation","horizontal").attr("title",e.getResourceText("TBL_RSZ_BTN_TOOLTIP")).attr("tabindex","0").attr("aria-valuemin",this.getMinRowCount()).attr("aria-valuenow",this.getActualRowCount()).class("sapUiTableHeightResizer");const n=o.getAriaLabelledBy();if(n.length){t.attr("aria-labelledby",n.join(" "))}t.openEnd();t.openStart("div").class("sapUiTableHeightResizerDecorationBefore").openEnd().close("div");t.openStart("div").attr("role","presentation").class("sapUiTableHeightResizerGrip").openEnd().icon("sap-icon://horizontal-grip",["sapUiTableHeightResizerGripIcon"]).close("div");t.openStart("div").class("sapUiTableHeightResizerDecorationAfter").openEnd().close("div");t.close("div")};r.prototype.getBaseRowContentHeight=function(){return Math.max(0,this.getRowContentHeight())};r.prototype._onTableRefreshRows=function(){const t=this.getActualRowCount();if(t>0){this.initTableRowsAfterDataRequested(t);this.getRowContexts(t)}};r.prototype.getActualRowCount=function(){return Math.max(0,this.getMinRowCount(),a(this).rowCount||this.getRowCount())};r.prototype._getMaxRowCount=function(){const t=this.getMaxRowCount();const e=this.getMinRowCount();if(t>=0){return Math.max(t,e)}const o=this._determineAvailableSpace();return Math.max(Math.floor(o/this.getBaseRowHeightOfTable()),e)};r.prototype._determineAvailableSpace=function(){const t=this.getTable();const e=t.getDomRef();const n=t.getDomRef("tableCCnt");const i=o.resize.height;if(!e||!n){return 0}return Math.max(0,Math.floor(i-e.getBoundingClientRect().height+n.getBoundingClientRect().height))};r.prototype.setRowCount=function(t){this.setProperty("rowCount",t);h.call(this,t);return this};r.prototype.updateTable=function(e){this.getTable().getDomRef("heightResizer")?.setAttribute("aria-valuenow",this.getActualRowCount());t.prototype.updateTable.apply(this,arguments)};u.onBeforeRendering=function(t){if(this.bLegacy){this.getTable().setVisibleRowCount(this.getComputedRowCounts().count)}};u.onAfterRendering=function(t){const o=this.getTable();const n=t&&t.isMarked("renderRows");if(!n&&o.getRows().length>0){this.fireRowsUpdated(e.RowsUpdateReason.Render)}const i=o.getDomRef("heightResizer");i.setAttribute("aria-valuemax",this._getMaxRowCount())};u.onmousedown=function(t){const e=this.getTable();if(t.button===0&&e.getDomRef("heightResizer").contains(t.target)){g.initResizing(e,this,t)}};u.oncontextmenu=function(t){const e=this.getTable();const o=e.getDomRef("heightResizer");if(o.contains(t.target)){t.preventDefault();o.classList.add("sapUiTableHeightResizerActive");g.openContextMenu(e,this,t)}};u.onkeydown=function(t){const o=this.getTable();if(t.target===o.getDomRef("heightResizer")){switch(t.key){case"ArrowUp":t.preventDefault();h.call(this,Math.max(this.getActualRowCount()-1,this.getMinRowCount()));this.updateTable(e.RowsUpdateReason.Render);break;case"ArrowDown":t.preventDefault();h.call(this,Math.min(this.getActualRowCount()+1,this._getMaxRowCount()));this.updateTable(e.RowsUpdateReason.Render);break;case"Home":t.preventDefault();h.call(this,this.getMinRowCount());this.updateTable(e.RowsUpdateReason.Render);break;case"End":t.preventDefault();h.call(this,this._getMaxRowCount());this.updateTable(e.RowsUpdateReason.Render);break;default:}}};u.ondblclick=function(t){if(!this.getTable().getDomRef("heightResizer").contains(t.target)){return}const o=this.getActualRowCount();if(o===this._getMaxRowCount()){h.call(this,this.getMinRowCount())}else if(o===this.getMinRowCount()){h.call(this,this.getRowCount())}else{h.call(this,this._getMaxRowCount())}this.updateTable(e.RowsUpdateReason.Render)};g.initResizing=function(t,e,o){t._disableTextSelection();g._oTable=t;g._iResizerStartPos=o.pageY;document.addEventListener("touchend",g.onResizingEnd.bind(t,e),{once:true});document.addEventListener("touchmove",g.onResizerMove);document.addEventListener("mouseup",g.onResizingEnd.bind(t,e),{once:true});document.addEventListener("mousemove",g.onResizerMove);const n=t.getDomRef("heightResizer");n.classList.add("sapUiTableHeightResizerActive");n.style.top="0"};g.onResizerMove=function(t){const e=t.pageY-g._iResizerStartPos;g._oTable.getDomRef("heightResizer").style.top=e+"px"};g.onResizingEnd=function(t,o){const n=e.getEventPosition(o,this).y;const i=this.getDomRef("tableCCnt").getBoundingClientRect().top;const s=this.getDomRef().querySelector(".sapUiTableFtr");const a=s?s.getBoundingClientRect().height:0;const r=n-i-a;const u=Math.floor(r/t.getBaseRowHeightOfTable());let R=Math.max(0,u,t.getMinRowCount());const c=t._getMaxRowCount();if(c>0){R=Math.min(R,c)}if(t.bLegacy){R=Math.max(R,t.getFixedTopRowCount()+t.getFixedBottomRowCount()+1);this.setVisibleRowCount(R)}h.call(t,R);t.updateTable(e.RowsUpdateReason.Render);document.removeEventListener("touchmove",g.onResizerMove);document.removeEventListener("mousemove",g.onResizerMove);const p=this.getDomRef("heightResizer");p.classList.remove("sapUiTableHeightResizerActive");p.style.top="";this._enableTextSelection()};g.openContextMenu=function(t,o,s){if(!g._oContextMenu){g._oContextMenu=new n({items:[new i({text:e.getResourceText("TBL_RSZ_ROW_UP"),shortcutText:e.getResourceText("TBL_RSZ_ROW_UP_SHORTCUT"),press:function(){const t=o.getActualRowCount();a(o).rowCount=Math.max(t-1,o.getMinRowCount());o.updateTable(e.RowsUpdateReason.Render)}}),new i({text:e.getResourceText("TBL_RSZ_ROW_DOWN"),shortcutText:e.getResourceText("TBL_RSZ_ROW_DOWN_SHORTCUT"),press:function(){const t=o.getActualRowCount();a(o).rowCount=Math.min(t+1,o._getMaxRowCount());o.updateTable(e.RowsUpdateReason.Render)}}),new i({text:e.getResourceText("TBL_RSZ_MINIMIZE"),shortcutText:e.getResourceText("TBL_RSZ_MINIMIZE_SHORTCUT"),press:function(){a(o).rowCount=o.getMinRowCount();o.updateTable(e.RowsUpdateReason.Render)}}),new i({text:e.getResourceText("TBL_RSZ_MAXIMIZE"),shortcutText:e.getResourceText("TBL_RSZ_MAXIMIZE_SHORTCUT"),press:function(){a(o).rowCount=o._getMaxRowCount();o.updateTable(e.RowsUpdateReason.Render)}})],closed:function(){t.getDomRef("heightResizer").classList.remove("sapUiTableHeightResizerActive")}});g._oContextMenu.openAsContextMenu(s,t.getDomRef("heightResizer"))}else{g._oContextMenu.openAsContextMenu(s,t.getDomRef("heightResizer"))}};return r});
//# sourceMappingURL=Interactive.js.map