/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./_GroupingUtils","./_ColumnUtils","./_MenuUtils","./_BindingUtils","./_HookUtils","../library","sap/ui/base/Object","sap/ui/core/Element","sap/ui/core/ResizeHandler","sap/ui/core/theming/Parameters","sap/ui/core/Theming","sap/ui/core/Icon","sap/ui/core/Lib","sap/ui/core/InvisibleMessage","sap/ui/core/message/MessageType","sap/ui/model/ChangeReason","sap/ui/thirdparty/jquery","sap/base/util/restricted/_throttle","sap/base/Log"],function(e,t,n,o,i,s,l,a,r,u,c,d,f,g,p,C,jQuery,m,R){"use strict";const _=s.SelectionBehavior;const h=s.SelectionMode;let w=null;const I={DATACELL:1<<1,COLUMNHEADER:1<<2,ROWHEADER:1<<3,ROWACTION:1<<4,COLUMNROWHEADER:1<<5,ROWACTIONCOLUMNHEADER:1<<6,PSEUDO:1<<7};I.ANYCONTENTCELL=I.ROWHEADER|I.DATACELL|I.ROWACTION;I.ANYCOLUMNHEADER=I.COLUMNHEADER|I.COLUMNROWHEADER|I.ROWACTIONCOLUMNHEADER;I.ANYROWHEADER=I.ROWHEADER|I.COLUMNROWHEADER;I.ANY=I.ANYCONTENTCELL|I.ANYCOLUMNHEADER;const b={sapUiSizeCozy:48,sapUiSizeCompact:32,sapUiSizeCondensed:24,undefined:32};let T=1;let E=1;const S={sapUiSizeCozy:b.sapUiSizeCozy+E,sapUiSizeCompact:b.sapUiSizeCompact+E,sapUiSizeCondensed:b.sapUiSizeCondensed+E,undefined:b.undefined+E};const x={navigationIcon:"navigation-right-arrow",deleteIcon:"sys-cancel",clearSelectionIcon:"clear-all",allSelectedIcon:"complete",checkboxIcon:"border",navIndicatorWidth:3};const y={Render:"Render",VerticalScroll:"VerticalScroll",FirstVisibleRowChange:"FirstVisibleRowChange",Unbind:"Unbind",Animation:"Animation",Resize:"Resize",Zoom:"Zoom",Unknown:"Unknown"};for(const e in C){y[e]=C[e]}const A=":sapTabbable";const L={Grouping:e,Column:t,Menu:n,Binding:o,Hook:i,CELLTYPE:I,BaseSize:b,BaseBorderWidth:T,RowHorizontalFrameSize:E,DefaultRowHeight:S,RowsUpdateReason:y,INTERACTIVE_ELEMENT_SELECTOR:A,ThemeParameters:x,hasRowHeader:function(t){return t.getSelectionMode()!==h.None&&t.getSelectionBehavior()!==_.RowOnly||e.isInGroupMode(t)},hasSelectAll:function(e){const t=e?e.getSelectionMode():h.None;return t===h.MultiToggle&&e.getEnableSelectAll()},hasRowHighlights:function(e){if(!e){return false}const t=e.getRowSettingsTemplate();if(!t){return false}const n=t.getHighlight();return t.isBound("highlight")||n!=null&&n!==p.None},hasRowNavigationIndicators:function(e){if(!e){return false}const t=e.getRowSettingsTemplate();if(!t){return false}const n=t.getNavigated();return t.isBound("navigated")||n},hasRowActions:function(e){const t=e?e.getRowActionTemplate():null;return t!=null&&(t.isBound("visible")||t.getVisible())&&e.getRowActionCount()>0},isRowSelectionAllowed:function(e){return e.getSelectionMode()!==h.None&&(e.getSelectionBehavior()===_.Row||e.getSelectionBehavior()===_.RowOnly)},isRowSelectorSelectionAllowed:function(e){return e.getSelectionMode()!==h.None&&L.hasRowHeader(e)},isNoDataVisible:function(e){return!e._isNoDataDisabled()&&!L.hasData(e)||L.getVisibleColumnCount(e)===0},hasData:function(e){return e._getTotalRowCount()>0},isBusyIndicatorVisible:function(e){if(!e||!e.getDomRef()){return false}const t=e.getCreationRow()?"-sapUiTableGridCnt":"-sapUiTableCnt";return e.getDomRef().querySelector('[id="'+e.getId()+t+'"] > .sapUiLocalBusyIndicator')!=null},isA:function(e,t){return l.isObjectA(e,t)},toggleRowSelection:function(e,t,n,o){let i;if(L.isA(t,"sap.ui.table.Row")){i=t}else if(typeof t==="number"){i=e.getRows()[t]}else{const n=jQuery(t);const o=L.getCellInfo(n[0]);const s=L.isRowSelectionAllowed(e);if(!L.Grouping.isInGroupHeaderRow(n[0])&&(o.isOfType(L.CELLTYPE.DATACELL|L.CELLTYPE.ROWACTION)&&s||o.isOfType(L.CELLTYPE.ROWHEADER)&&L.isRowSelectorSelectionAllowed(e))){i=e.getRows()[o.rowIndex]}}if(!i||i.isEmpty()){return}e._iSourceRowIndex=i.getIndex();if(o){o(i)}else{i._setSelected(n??!i._isSelected())}delete e._iSourceRowIndex},getNoContentMessage:function(e){if(L.getVisibleColumnCount(e)>0){return e.getNoData()||L.getResourceText("TBL_NO_DATA")}else{return e.getAggregation("_noColumnsMessage")||L.getResourceText("TBL_NO_COLUMNS")}},getVisibleColumnCount:function(e){return e._getVisibleColumns().length},getHeaderRowCount:function(e){if(e._iHeaderRowCount===undefined){if(!e.getColumnHeaderVisible()){e._iHeaderRowCount=0}else{let t=1;const n=e.getColumns();for(let e=0;e<n.length;e++){if(n[e].shouldRender()){t=Math.max(t,n[e].getMultiLabels().length)}}e._iHeaderRowCount=t}}return e._iHeaderRowCount},isVariableRowHeightEnabled:function(e){const t=e._getRowCounts();return e&&e._bVariableRowHeightEnabled&&!t.fixedTop&&!t.fixedBottom},getNonEmptyRowCount:function(e){return Math.min(e._getRowCounts().count,e._getTotalRowCount())},getFocusedItemInfo:function(e){const t=e._getItemNavigation();if(!t){return null}return{cell:t.getFocusedIndex(),columnCount:t.iColumns,cellInRow:t.getFocusedIndex()%t.iColumns,row:Math.floor(t.getFocusedIndex()/t.iColumns),cellCount:t.getItemDomRefs().length,domRef:t.getFocusedDomRef()}},getRowIndexOfFocusedCell:function(e){const t=L.getFocusedItemInfo(e);return t.row-L.getHeaderRowCount(e)},isFixedColumn:function(e,t){return t<e.getComputedFixedColumnCount()},hasFixedColumns:function(e){return e.getComputedFixedColumnCount()>0},focusItem:function(e,t,n){const o=e._getItemNavigation();if(o){o.focusItem(t,n)}},scrollTableToIndex:function(e,t,n){if(!e){return Promise.resolve()}const o=e.getFirstVisibleRow();const i=e._getRowCounts();const s=o+i.scrollable-1;let l=false;if(t<o||t>s){const o=n?t-i.fixedTop-1:t-i.scrollable-i.fixedTop+2;l=e._setFirstVisibleRowIndex(Math.max(0,o))}return new Promise(function(t){if(l){e.attachEventOnce("_rowsUpdated",t)}else{t()}})},showNotificationPopoverAtIndex:function(e,t,n){let o=e._oNotificationPopover;const i=e.getRows()[t-e._getFirstRenderedRowIndex()];const s=L.getResourceText("TBL_SELECT_LIMIT_TITLE");const l=L.getResourceText("TBL_SELECT_LIMIT",[n]);if(!i){return Promise.resolve()}return new Promise(function(t){sap.ui.require(["sap/m/Popover","sap/m/Bar","sap/m/Title","sap/m/Text","sap/m/HBox","sap/ui/core/library","sap/m/library"],function(n,a,r,u,c,f,p){if(!o){o=new n(e.getId()+"-notificationPopover",{customHeader:[new a({contentMiddle:[new c({items:[new d({src:"sap-icon://message-warning",color:f.IconColor.Critical}).addStyleClass("sapUiTinyMarginEnd"),new r({text:s,level:f.TitleLevel.H2})],renderType:p.FlexRendertype.Bare,justifyContent:p.FlexJustifyContent.Center,alignItems:p.FlexAlignItems.Center})]})],content:new u({text:l})});o.addStyleClass("sapUiContentPadding");e._oNotificationPopover=o;e.addAggregation("_hiddenDependents",e._oNotificationPopover)}else{o.getContent()[0].setText(l)}e.detachFirstVisibleRowChanged(this.onFirstVisibleRowChange,this);e.attachFirstVisibleRowChanged(this.onFirstVisibleRowChange,this);const C=i.getDomRefs().rowSelector;if(C){o.attachEventOnce("afterOpen",function(){g.getInstance().announce(l);t()});o.openBy(C)}else{t()}}.bind(this))}.bind(this))},onFirstVisibleRowChange:function(e){const t=e.getSource();if(!t._oNotificationPopover){return}if(t){t.detachFirstVisibleRowChanged(this.onFirstVisibleRowChange,this)}t._oNotificationPopover.close()},loadContexts:function(e,t,n){const o=e.getContexts(t,n,0,true);const i=o.length===Math.min(n,e.getLength())&&!o.includes(undefined);if(i){return Promise.resolve(o)}return new Promise(function(o){e.attachEventOnce("dataReceived",function(){o(this.loadContexts(e,t,n))}.bind(this))}.bind(this))},getCellInfo:function(e){const t={type:0,cell:null,rowIndex:null,columnIndex:null,columnSpan:null};const n=jQuery(e);let o;let i;let s;let l;let r;if(n.hasClass("sapUiTableDataCell")){o=n.attr("data-sap-ui-colid");i=a.getElementById(o);t.type=L.CELLTYPE.DATACELL;t.rowIndex=parseInt(n.parent().attr("data-sap-ui-rowindex"));t.columnIndex=i?.getIndex()??-1;t.columnSpan=1}else if(n.hasClass("sapUiTableHeaderDataCell")){s=/_([\d]+)/;o=n.attr("id");l=s.exec(o);r=l&&l[1]!=null?parseInt(l[1]):0;t.type=L.CELLTYPE.COLUMNHEADER;t.rowIndex=r;t.columnIndex=parseInt(n.attr("data-sap-ui-colindex"));t.columnSpan=parseInt(n.attr("colspan")||1)}else if(n.hasClass("sapUiTableRowSelectionCell")){t.type=L.CELLTYPE.ROWHEADER;t.rowIndex=parseInt(n.parent().attr("data-sap-ui-rowindex"));t.columnIndex=-1;t.columnSpan=1}else if(n.hasClass("sapUiTableRowActionCell")){t.type=L.CELLTYPE.ROWACTION;t.rowIndex=parseInt(n.parent().attr("data-sap-ui-rowindex"));t.columnIndex=-2;t.columnSpan=1}else if(n.hasClass("sapUiTableRowActionHeaderCell")){t.type=L.CELLTYPE.ROWACTIONCOLUMNHEADER;t.columnIndex=-2;t.columnSpan=1}else if(n.hasClass("sapUiTableRowSelectionHeaderCell")){t.type=L.CELLTYPE.COLUMNROWHEADER;t.columnIndex=-1;t.columnSpan=1}else if(n.hasClass("sapUiTablePseudoCell")){o=n.attr("data-sap-ui-colid");i=a.getElementById(o);t.type=L.CELLTYPE.PSEUDO;t.rowIndex=-1;t.columnIndex=i?.getIndex()??-1;t.columnSpan=1}if(t.type!==0){t.cell=n[0]}t.isOfType=function(e){if(e==null){return false}return(this.type&e)>0};return t},getRowColCell:function(e,t,n,o){const i=e.getRows()[t]||null;const s=o?e.getColumns():e._getVisibleColumns();const l=s[n]||null;let a;let r=null;if(i&&l){if(!a){let e=l.getMetadata();while(e.getName()!=="sap.ui.table.Column"){e=e.getParent()}a=e.getClass()}r=i.getCells().find(function(e){return l===a.ofCell(e)})||null}return{row:i,column:l,cell:r}},getCell:function(e,t,n){n=n===true;if(!e||!t){return null}const o=jQuery(t);const i=e.getDomRef();let s=".sapUiTableCell";if(!n){s+=":not(.sapUiTablePseudoCell)"}const l=o.closest(s,i);if(l.length>0){return l}return null},getParentCell:function(e,t,n){n=n===true;const o=jQuery(t);const i=L.getCell(e,t,n);if(!i||i[0]===o[0]){return null}else{return i}},registerResizeHandler:function(e,t,n,o,i){o=o==null?"":o;i=i===true;if(!e||typeof t!=="string"||typeof n!=="function"){return undefined}let s=e.getDomRef(o);L.deregisterResizeHandler(e,t);if(!e._mResizeHandlerIds){e._mResizeHandlerIds={}}if(i&&s){s=s.parentNode}if(s){e._mResizeHandlerIds[t]=r.register(s,n)}return e._mResizeHandlerIds[t]},deregisterResizeHandler:function(e,t){let n=[];if(!e._mResizeHandlerIds){return}if(typeof t==="string"){n.push(t)}else if(t===undefined){for(const t in e._mResizeHandlerIds){if(typeof t==="string"&&e._mResizeHandlerIds.hasOwnProperty(t)){n.push(t)}}}else if(Array.isArray(t)){n=t}for(let t=0;t<n.length;t++){const o=n[t];if(e._mResizeHandlerIds[o]){r.deregister(e._mResizeHandlerIds[o]);e._mResizeHandlerIds[o]=undefined}}},isFirstScrollableRow:function(e,t){if(isNaN(t)){const e=jQuery(t);t=parseInt(e.add(e.parent()).filter("[data-sap-ui-rowindex]").attr("data-sap-ui-rowindex"))}return t===e._getRowCounts().fixedTop},isLastScrollableRow:function(e,t){if(isNaN(t)){const e=jQuery(t);t=parseInt(e.add(e.parent()).filter("[data-sap-ui-rowindex]").attr("data-sap-ui-rowindex"))}const n=e._getRowCounts();return t===n.count-n.fixedBottom-1},getContentDensity:function(e){let t;const n=["sapUiSizeCondensed","sapUiSizeCompact","sapUiSizeCozy"];const o=function(e,t){if(!t[e]){return}for(let o=0;o<n.length;o++){if(t[e](n[o])){return n[o]}}};let i=e.$();if(i.length>0){t=o("hasClass",i)}else{t=o("hasStyleClass",e)}if(t){return t}let s=null;let l=e.getParent();if(l){do{t=o("hasStyleClass",l);if(t){return t}if(l.getDomRef){s=l.getDomRef()}else if(l.getRootNode){s=l.getRootNode()}if(!s&&l.getParent){l=l.getParent()}else{l=null}}while(l&&!s)}i=jQuery(s||document.body);t=o("hasClass",i.closest("."+n.join(",.")));return t},isVariableWidth:function(e){return!e||e==="auto"||e.toString().match(/%$/)},getFirstFixedBottomRowIndex:function(e){const t=e._getRowCounts();if(!e.getBinding()||t.fixedBottom===0){return-1}let n=-1;const o=e.getFirstVisibleRow();const i=e._getTotalRowCount();if(i>=t.count){n=t.count-t.fixedBottom}else{const e=i-t.fixedBottom-o;if(e>=0&&o+e<i){n=e}}return n},getResourceText:function(e,t){return f.getResourceBundleFor("sap.ui.table").getText(e,t)},dynamicCall:function(e,t,n){const o=typeof e==="function"?e():e;if(!o||!t){return undefined}n=n||o;if(typeof t==="function"){t.call(n,o);return undefined}else{let e;const i=[];for(const s in t){if(typeof o[s]==="function"){e=t[s];i.push(o[s].apply(n,e))}else{i.push(undefined)}}if(i.length===1){return i[0]}else{return i}}},throttle:function(e,t,n){n=Object.assign({leading:true,asyncLeading:false,trailing:true},n);let o;let i=false;let s={};let l;let a;if(n.leading&&n.asyncLeading){l=function(){if(i){const t=Promise.resolve().then(function(){if(!t.canceled){e.apply(s.context,s.args)}o=null});t.cancel=function(){t.canceled=true};o=t}else{e.apply(this,arguments)}}}else{l=e}const r=m(l,t,{leading:n.leading,trailing:n.trailing});if(n.leading&&n.asyncLeading){const e=r.cancel;r.cancel=function(){if(o){o.cancel()}e()};a=Object.assign(function(){s={context:this,args:arguments};i=true;r.apply(this,arguments);i=false},r)}else{a=r}return a},throttleFrameWise:function(e){let t=null;const n=function(){n.cancel();t=window.requestAnimationFrame(function(t){e.apply(this,t)}.bind(this,arguments))};n.cancel=function(){window.cancelAnimationFrame(t);t=null};return n},getInteractiveElements:function(e){if(!e){return null}const t=jQuery(e);const n=L.getCellInfo(t);if(n.isOfType(I.ANY|I.PSEUDO)){const e=t.find(A);if(e.length>0){return e}}return null},getFirstInteractiveElement:function(e,t){if(!e){return null}const n=e.getTable();const o=e.getCells();if(t===true&&L.hasRowActions(n)){o.push(e.getRowAction())}for(let e=0;e<o.length;e++){const t=o[e].getDomRef();const i=L.getCell(n,t,true);const s=L.getInteractiveElements(i);if(s){return s[0]}}return null},convertCSSSizeToPixel:function(e,t){let n;if(typeof e!=="string"){return null}if(e.endsWith("px")){n=parseFloat(e)}else if(e.endsWith("em")||e.endsWith("rem")){n=parseFloat(e)*L.getBaseFontSize()}else{return null}if(t){return n+"px"}else{return n}},getBaseFontSize:function(){if(w==null){const e=document.documentElement;if(e){w=parseInt(window.getComputedStyle(e).fontSize)}}return w==null?16:w},readThemeParameters:function(){const e=u.get({name:["_sap_ui_table_BaseSize","_sap_ui_table_BaseSizeCozy","_sap_ui_table_BaseSizeCompact","_sap_ui_table_BaseSizeCondensed","_sap_ui_table_BaseBorderWidth","_sap_ui_table_NavigationIcon","_sap_ui_table_DeleteIcon","_sap_ui_table_ClearSelectionIcon","_sap_ui_table_AllSelectedIcon","_sap_ui_table_CheckboxIcon","_sap_ui_table_NavIndicatorWidth"]});function t(t){return L.convertCSSSizeToPixel(e[t])}b.undefined=t("_sap_ui_table_BaseSize");b.sapUiSizeCozy=t("_sap_ui_table_BaseSizeCozy");b.sapUiSizeCompact=t("_sap_ui_table_BaseSizeCompact");b.sapUiSizeCondensed=t("_sap_ui_table_BaseSizeCondensed");T=t("_sap_ui_table_BaseBorderWidth");E=T;S.undefined=b.undefined+E;S.sapUiSizeCozy=b.sapUiSizeCozy+E;S.sapUiSizeCompact=b.sapUiSizeCompact+E;S.sapUiSizeCondensed=b.sapUiSizeCondensed+E;x.navigationIcon=e["_sap_ui_table_NavigationIcon"];x.deleteIcon=e["_sap_ui_table_DeleteIcon"];x.clearSelectionIcon=e["_sap_ui_table_ClearSelectionIcon"];x.allSelectedIcon=e["_sap_ui_table_AllSelectedIcon"];x.checkboxIcon=e["_sap_ui_table_CheckboxIcon"];x.navIndicatorWidth=t("_sap_ui_table_NavIndicatorWidth")},isThemeApplied:function(){let e=false;const t=function(){e=true};c.attachApplied(t);c.detachApplied(t);return e},addDelegate:function(e,t,n){if(e&&t){e.addDelegate(t,false,n?n:t,false)}},removeDelegate:function(e,t){if(e&&t){e.removeDelegate(t)}},createWeakMapFacade:function(){const e=new window.WeakMap;return function(t){if(!t||!(typeof t==="object")){return null}if(!e.has(t)){e.set(t,{})}return e.get(t)}},_getTableTemplateHelper:function(e){const t="An automatic control and template generation for the sap.ui.table.Table is not supported "+"anymore for the aggragations footer and title and the aggregations label and template of "+"the sap.ui.table.Columns. Use concrete controls for those aggregations instead of altType string.";if(s.TableHelper){if(!e){R.warning(t)}return s.TableHelper}throw new Error(t)},getEventPosition:function(e,t){const n=o(e)||e;function o(n){if(!t._isTouchEvent(n)){return null}const o=["touches","targetTouches","changedTouches"];for(let t=0;t<o.length;t++){const n=o[t];if(e[n]&&e[n][0]){return e[n][0]}if(e.originalEvent[n]&&e.originalEvent[n][0]){return e.originalEvent[n][0]}}return null}return{x:n.pageX,y:n.pageY}}};e.TableUtils=L;t.TableUtils=L;n.TableUtils=L;o.TableUtils=L;i.TableUtils=L;return L},true);
//# sourceMappingURL=TableUtils.js.map