/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
(function(e){"use strict";var t;if(e.module){t=e.module;e.module=undefined}sap.ui.define(["sap/base/util/extend","sap/base/util/ObjectPath","sap/ui/thirdparty/jquery","sap/ui/Global","sap/ui/base/Object","sap/ui/core/Element","sap/ui/core/mvc/View","sap/ui/test/matchers/Ancestor","sap/ui/test/matchers/MatcherFactory","sap/ui/test/pipelines/MatcherPipeline","sap/ui/test/_OpaLogger"],function(e,t,i,r,n,o,l,s,a,u,g){var c=n.extend("sap.ui.test.OpaPlugin",{constructor:function(){n.call(this);this._oLogger=g.getLogger("sap.ui.test.Opa5");this._oMatcherFactory=new a},getAllControls:function(e,t){var i=c.getElementRegistry().filter(f(e));this._oLogger.debug("Found "+i.length+" controls"+(e?" of type '"+(t||e)+"'":"")+" in page");return i},getView:function(e){var t=this.getAllControls(l,"View");var i=t.filter(function(t){return t.getViewName()===e});this._oLogger.debug("Found "+i.length+" views with viewName '"+e+"'");if(i.length>1){i=i.filter(function(e){var t=e.$();return t.length>0&&t.is(":visible")&&t.css("visibility")!=="hidden"});this._oLogger.debug("Found "+i.length+" visible views with viewName '"+e+"'");if(i.length!==1){this._oLogger.debug("Cannot identify controls uniquely. Please provide viewId to locate the exact view.");i=[]}}return i[0]},_getMatchingView:function(e){var t=null;var i;if(e.viewName){var r=(e.viewNamespace||"")+"."+(e.viewName||"");i=r.replace(/\.+/g,".").replace(/^\.|\.$/g,"")}if(e.viewId){var n=c.getElementById(e.viewId);if(n instanceof l&&(!i||n.getViewName()===i)){t=n}}else{t=this.getView(i)}this._oLogger.debug("Found "+(t?"":"no ")+"view with ID '"+e.viewId+"' and viewName '"+i+"'");return t},getControlInView:function(e){var t=typeof e.id==="string",i;if(e.viewName||e.viewId){i=this._getMatchingView(e)}if(!i){return t?null:[]}var r=i.getViewName();var n=e.fragmentId?e.fragmentId+c.VIEW_ID_DELIMITER:"";if(Array.isArray(e.id)){var o=[];var l=[];e.id.map(function(e){return n+e}).forEach(function(e){var t=i.byId(e);if(t){o.push(t)}else{l.push(e)}});this._oLogger.debug("Found "+o.length+" controls with ID contained in "+e.id+" in view '"+r+"'"+l.length?". Found no controls matching the subset of IDs "+l:"");if(o.length&&e.controlType){var s=this._filterUniqueControlsByCondition(o,f(e.controlType));this._oLogger.debug("Found "+(s.length?s.length:"no")+" controls in view '"+r+"' with control type matching '"+e.sOriginalControlType+"' and ID contained in "+e.id);if(s.length!==o.length){this._oLogger.error("Some results don't match the desired controlType '"+e.sOriginalControlType+"'. Please double check the expected controlType - this might lead to unexpected test results!")}}return o}if(t){var a=n+e.id;var u=i.byId(a)||null;if(u){if(f(e.controlType)(u)){this._oLogger.debug("Found control with ID '"+a+"' and controlType '"+e.sOriginalControlType+"' in view '"+r+"'")}else{this._oLogger.error("Found control with ID '"+a+"' in view '"+r+"' but it does not have required controlType '"+e.sOriginalControlType+"'. Please double check the expected controlType - this might lead to unexpected test results!")}return u}else{this._oLogger.debug("Found no control with ID '"+a+"' in view '"+r+"'");return u}}var g=this.getAllControlsWithTheParent(i,e.controlType,e.sOriginalControlType);var d=this._isRegExp(e.id);if(d){g=g.filter(function(t){var r=this._getUnprefixedControlId(t.getId(),i.getId(),e.fragmentId);return e.id.test(r)}.bind(this))}this._oLogger.debug("Found "+g.length+" controls of type "+e.sOriginalControlType+(d?" with ID matching "+e.id:"")+" in view '"+r+"'");return g},getAllControlsWithTheParent:function(e,t,i){var r=new s(e);return this._filterUniqueControlsByCondition(this.getAllControls(t,i),r)},getAllControlsInContainer:function(e,t,i,r){var n=f(t),o=this._filterUniqueControlsByCondition(this._getControlsInContainer(e),n);this._oLogger.debug("Found "+o.length+" controls in "+(r?r:"container")+" with controlType '"+i+"'");return o},_getControlsInStaticArea:function(e){var t=i(c.getStaticAreaDomRef());var r=this._getControlsInContainer(t)||[];if(e.id){r=this._filterUniqueControlsByCondition(r,function(t){var i=t.getId(),r;if(e.viewName||e.viewId){r=this._getMatchingView(e)}if(r){if(this._isControlInView(t,r.getViewName())){i=this._getUnprefixedControlId(t.getId(),r.getId(),e.fragmentId)}}var n=false;if(typeof e.id==="string"){n=i===e.id}if(this._isRegExp(e.id)){n=e.id.test(i)}if(Array.isArray(e.id)){n=e.id.filter(function(e){return e===i}).length>0}return n}.bind(this));this._oLogger.debug("Found "+(r.length?r.length:"no")+" controls in the static area with ID matching '"+e.id+"'"+(e.fragmentId?" and fragmentId: '"+e.fragmentId+"'":""))}if(r.length&&e.controlType){var n=f(e.controlType);r=this._filterUniqueControlsByCondition(r,n);this._oLogger.debug("Found "+(r.length?r.length:"no")+" controls in the static area with control type matching '"+e.sOriginalControlType+"'")}if(e.id&&typeof e.id==="string"){return r[0]||null}else{return r}},_getControlsInContainer:function(e){return d(e.find("*"))},_isControlInView:function(e,t){if(!e){return false}if(e.getViewName&&e.getViewName()===t){return true}else{return this._isControlInView(e.getParent(),t)}},_isRegExp:function(e){return Object.prototype.toString.call(e)==="[object RegExp]"},getMatchingControls:function(e){var t=null;e=e||{};var i=this._modifyControlType(e);if(!i){return typeof e.id==="string"?t:[]}if(e.searchOpenDialogs){t=this._getControlsInStaticArea(e)}else if(e.viewName||e.viewId){t=this.getControlInView(e)}else if(e.id){t=this.getControlByGlobalId(e)}else if(e.controlType){t=this.getAllControls(e.controlType,e.sOriginalControlType)}else{t=this.getAllControls()}if(!t){return t}var r=this._oMatcherFactory.getStateMatchers({visible:e.visible,interactable:e.interactable,enabled:typeof e.enabled==="undefined"?e.interactable:e.enabled,editable:typeof e.editable==="undefined"?false:e.editable});var n=c._oMatcherPipeline.process({control:t,matchers:r});if(!n){if(Array.isArray(t)){return[]}if(t){return null}return t}return n},_getFilteredControls:function(t){var i=this._filterControlsByCondition(t);var r=e({},t);["interactable","visible","enabled","editable"].forEach(function(e){delete r[e]});return i===c.FILTER_FOUND_NO_CONTROLS?c.FILTER_FOUND_NO_CONTROLS:this._filterControlsByMatchers(r,i)},_filterControlsByCondition:function(e){var t=null;var i=this._isLookingForAControl(e);if(i){t=this.getMatchingControls(e)}var r=[typeof e.id==="string"&&!t,this._isRegExp(e.id)&&!t.length,Array.isArray(e.id)&&(!t||t.length!==e.id.length),e.controlType&&Array.isArray(t)&&!t.length,!e.id&&(e.viewName||e.viewId||e.searchOpenDialogs)&&!t.length];return r.some(Boolean)?c.FILTER_FOUND_NO_CONTROLS:t},_filterControlsByMatchers:function(t,i){var r=e({},t);var n=this._oMatcherFactory.getFilteringMatchers(r);var o=this._isLookingForAControl(t);var l=null;if((i||!o)&&n.length){l=c._oMatcherPipeline.process({matchers:n,control:i});if(!l){return c.FILTER_FOUND_NO_CONTROLS}}else{l=i}return l},getControlByGlobalId:function(e){var t=f(e.controlType);if(typeof e.id==="string"){var i=c.getElementById(e.id)||null;if(i&&!t(i)){this._oLogger.error("A control with global ID '"+e.id+"' is found but does not have required controlType '"+e.sOriginalControlType+"'. Found control is '"+i+"' but null is returned instead");return null}this._oLogger.debug("Found "+(i?"":"no ")+"control with the global ID '"+e.id+"'");return i}var r=[];var n=this._isRegExp(e.id);if(n){c.getElementRegistry().forEach(function(t,i){if(e.id.test(i)){r.push(i)}})}else if(Array.isArray(e.id)){r=e.id}var o=[];var l=[];r.forEach(function(e){var i=c.getElementById(e);if(i&&t(i)&&!i.bIsDestroyed){o.push(i)}else{l.push(e)}});var s=!n&&l.length?". Found no controls of matching the subset of IDs "+l:"";this._oLogger.debug("Found "+o.length+" controls of type "+e.sOriginalControlType+(n?" with ID matching '":" with ID contained in '")+e.id+s);return o},getControlConstructor:function(e){var i=e.replace(/\./g,"/");var n=sap.ui.require(i);if(n==null){if(r.lazyRequire._isStub(e)){this._oLogger.debug("The control type "+e+" is currently a lazy stub.");return null}n=t.get(e);if(typeof n==="function"){this._oLogger.debug("The control type "+e+" could only be retrieved via global name.")}}if(!n){this._oLogger.debug("The control type "+e+" is undefined.");return null}if(typeof n!=="function"){this._oLogger.debug("The control type "+e+" must be a function.");return null}return n},_isLookingForAControl:function(e){return Object.keys(e).some(function(t){return c._aControlSelectorsForMatchingControls.indexOf(t)!==-1&&!!e[t]})},_filterUniqueControlsByCondition:function(e,t){return e.filter(function(e,i,r){var n=!!t(e);return n&&r.indexOf(e)===i})},_modifyControlType:function(e){var t=e.controlType;if(typeof t!=="string"){if(t&&t._sapUiLazyLoader){this._oLogger.debug("The control type is currently a lazy stub");return false}return true}var i=this.getControlConstructor(t);if(!i){return false}e.sOriginalControlType=t;e.controlType=i;return true},_getUnprefixedControlId:function(e,t,i){var r=e.replace(t+c.VIEW_ID_DELIMITER,"");if(i){if(r.startsWith(i+c.VIEW_ID_DELIMITER)){r=r.replace(i+c.VIEW_ID_DELIMITER,"")}else{r=""}}return r}});function f(e){return function(t){if(!e){return true}return t instanceof e}}c._oMatcherPipeline=new u;c._aControlSelectorsForMatchingControls=["id","viewName","viewId","controlType","searchOpenDialogs"];c.FILTER_FOUND_NO_CONTROLS="FILTER_FOUND_NO_CONTROL";c.VIEW_ID_DELIMITER="--";c.isUIDirty=function(){var e=sap.ui.require("sap/ui/core/Rendering");if(typeof e?.isPending==="function"){return e.isPending()}var t=sap.ui.require("sap/ui/core/Core");if(typeof t?.getUIDirty==="function"){return t.getUIDirty()}};c.getLibraryResourceBundle=function(e){var t=sap.ui.require("sap/ui/core/Lib");if(typeof t?.getResourceBundleFor==="function"){return t.getResourceBundleFor(e)}var i=sap.ui.require("sap/ui/core/Core");if(typeof i?.getLibraryResourceBundle==="function"){return i.getLibraryResourceBundle(e)}};c.getElementById=function(e){var t=sap.ui.require("sap/ui/core/Element");if(typeof t.getElementById==="function"){return t.getElementById(e)}if(typeof t.registry?.get==="function"){return t.registry.get(e)}};c.getStaticAreaDomRef=function(){var e=sap.ui.require("sap/ui/core/StaticArea");if(typeof e?.getDomRef==="function"){return e.getDomRef()}var t=sap.ui.require("sap/ui/core/Core");if(typeof t?.getStaticAreaRef==="function"){return t.getStaticAreaRef()}};c.getElementRegistry=function(){var e=sap.ui.require("sap/ui/core/ElementRegistry");if(e){return e}return sap.ui.require("sap/ui/core/Element").registry};let d=function(e){const t=[];e.each((e,i)=>{const r=o.closestTo(i);if(r&&!t.includes(r)){t.push(r)}});return t};if(typeof o.closestTo!=="function"){d=function(e){var t=e.control();var i=[];t.forEach(function(e){var t=!i.filter(function(t){return t.getId()===e.getId()}).length;if(t){i.push(e)}});return i}}return c});if(t){e.module=t}})(window);
//# sourceMappingURL=OpaPlugin.js.map