/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/ManagedObject","sap/ui/qunit/QUnitUtils","sap/ui/test/Opa5","sap/ui/Device","sap/ui/thirdparty/jquery","sap/ui/test/_OpaLogger","sap/ui/test/_FocusListener"],function(e,t,r,n,jQuery,i,s){"use strict";return e.extend("sap.ui.test.actions.Action",{metadata:{properties:{idSuffix:{type:"string"}},publicMethods:["executeOn"]},executeOn:function(){return true},$:function(e){var t;var r="";if(this.getIdSuffix()){t=e.$(this.getIdSuffix());r=t.length?"":"DOM representation of control '"+e+"' has no element with user-provided ID suffix '"+this.getIdSuffix()+"'"}else{var n=this._getAdapter(e);if(n){t=e.$(n);r=t.length?"":"DOM representation of control '"+e+"' has no element with ID suffix '"+n+"' which is the default adapter for '"+this.getMetadata().getName()+"'"}if(!t||!t.length){t=jQuery(e.getFocusDomRef());if(!t.length){t=e.$();if(!t.length){r+="DOM representation of control '"+e+"' has no focus DOM reference"}}}}if(t.length){this.oLogger.info("Found a DOM reference for the control '"+e+"'. Executing '"+this.getMetadata().getName()+"' on the DOM element with ID '"+t[0].id+"'");return t}else{this.oLogger.error(r);throw new Error(r)}},getUtils:function(){return r.getUtils()||t},init:function(){this.controlAdapters={};this.oLogger=i.getLogger(this.getMetadata().getName())},dropPosition:{BEFORE:"BEFORE",AFTER:"AFTER",CENTER:"CENTER"},_getAdapter:function(e){var t=function(r){var n=this.controlAdapters[r.getName()];if(n){if(typeof n==="function"){return n(e)}if(typeof n==="string"){return n}}var i=r.getParent();if(i){return t(i)}return null}.bind(this);return t(e.getMetadata())},_tryOrSimulateFocusin:function(e,t){var r=e[0];var i=false;var a=false;var o=this._isFocused(r);var u=n.browser.firefox&&n.browser.version>=60;var c;if(o||u){i=true}else{e.trigger("focus");var l=this._isFocused(r);i=!l}if(i){this.oLogger.debug("Control "+t+" could not be focused - maybe you are debugging?");c=s.getLastFocusedElement();a=c&&c!==r&&c!==s.getLastBlurredElement();if(a){this._simulateFocusout(c)}this._createAndDispatchFocusEvent("focusin",r);this._createAndDispatchFocusEvent("focus",r);this._createAndDispatchFocusEvent("activate",r)}if(!this._isFocused(r)){this.oLogger.trace("Control "+t+" could not be focused-in correctly. This may lead to lost interactions with the control")}},_simulateFocusout:function(e){this._createAndDispatchFocusEvent("focusout",e);this._createAndDispatchFocusEvent("blur",e);this._createAndDispatchFocusEvent("deactivate",e)},_createAndDispatchMouseEvent:function(e,t,r,n,i,s,a){var o=0;var u;u=new MouseEvent(e,{bubbles:true,cancelable:true,identifier:1,target:t,radiusX:1,radiusY:1,rotationAngle:0,button:o,type:e,shiftKey:r,altKey:n,ctrlKey:i,clientX:s,clientY:a});t.dispatchEvent(u)},_createAndDispatchFocusEvent:function(e,t){var r,n=["focusin","focusout","activate","deactivate"].indexOf(e)!==-1;r=new FocusEvent(e,{type:e,target:t,curentTarget:t,bubbles:n});t.dispatchEvent(r);this.oLogger.info("Dispatched focus event: '"+e+"'")},_createAndDispatchDragEvent:function(e,t,r){var n=this._getEventCoordinates(t,r);var i=new DataTransfer;var s;s=new DragEvent(e,{type:e,eventPhase:3,bubbles:true,cancelable:true,defaultPrevented:false,composed:true,returnValue:true,cancelBubble:false,target:t,toElement:t,srcElement:t,radiusX:1,radiusY:1,rotationAngle:0,clientX:n.x,clientY:n.y,dataTransfer:i});t.dispatchEvent(s)},_createAndDispatchScrollEvent:function(e,t){if(t.x!=null){e.scrollLeft=t.x}if(t.y!=null){e.scrollTop=t.y}var r=new Event("scroll",{bubbles:false,cancelBubble:false,cancelable:false,composed:false,currentTarget:null,defaultPrevented:false,eventPhase:0,isTrusted:true,returnValue:true,target:e,srcElement:e,type:"scroll"});e.dispatchEvent(r)},_getEventCoordinates:function(e,t){var r=jQuery(e);var n=r.offset();var i={x:n.left+r.outerWidth()/2,y:n.top+r.outerHeight()/2};if(!t){return i}switch(t.position){case this.dropPosition.BEFORE:return{x:n.left,y:n.top};case this.dropPosition.AFTER:return{x:n.left+r.outerWidth(),y:n.top+r.outerHeight()};case this.dropPosition.CENTER:default:return i}},_isFocused:function(e){var t=e===document.activeElement;var r=!document.hasFocus||document.hasFocus();var n=!!(e.type||e.href||~e.tabIndex);return t&&r&&n}})});
//# sourceMappingURL=Action.js.map