/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/util/deepExtend","sap/base/util/each","sap/ui/base/Object","sap/ui/test/gherkin/dataTableUtils","sap/ui/test/gherkin/simpleGherkinParser","sap/base/strings/escapeRegExp"],function(e,t,n,r,i,s){"use strict";var a=n.extend("sap.ui.test.gherkin.GherkinTestGenerator",{constructor:function(e,t,r){n.apply(this,arguments);if(typeof e==="string"||e instanceof String){e=i.parseFile(e)}else if(!e||typeof e!=="object"||!e.scenarios){throw new Error("GherkinTestGenerator constructor: parameter 'vFeature' must be a valid String or a valid Feature object")}if(typeof t!=="function"||!(new t)._generateTestStep){throw new Error("GherkinTestGenerator constructor: parameter 'fnStepDefsConstructor' must be a valid StepDefinitions constructor")}if(r&&typeof r!=="function"){throw new Error("GherkinTestGenerator constructor: if specified, parameter 'fnAlternateTestStepGenerator' must be a valid Function")}this._oFeature=e;this._fnStepDefsConstructor=t;this._oStepDefs=null;this._fnAlternateTestStepGenerator=r||null},setUp:function(){this._oStepDefs=new this._fnStepDefsConstructor},tearDown:function(){if(this._oStepDefs&&this._oStepDefs._needsTearDown){this._oStepDefs.closeApplication()}this._oStepDefs=null},generate:function(){if(!this._oStepDefs){this.setUp()}return this._generateFeatureTest()},execute:function(e,t){if(!this._oStepDefs){throw new Error("Run 'generate' before calling 'execute'")}if(!e||!e.skip&&(typeof e.func!=="function"||!Array.isArray(e.parameters))){throw new Error("Input parameter 'oTestStep' is not a valid TestStep object.")}if(!e.skip){this._oStepDefs.assert=t;e.func.apply(this._oStepDefs,e.parameters);this._oStepDefs._needsTearDown=true}return!e.skip},_generateFeatureTest:function(){var e=[];this._oFeature.scenarios.forEach(function(t){e=e.concat(this._expandScenarioOutline(t))},this);var t=e.map(function(e){return this._generateTestScenario(e,this._oFeature.background)},this);var n=this._isWip(this._oFeature);var r=t.every(function(e){return e.skip});return{name:(n?"(WIP) ":"")+"Feature: "+this._oFeature.name,skip:n||r,wip:n,testScenarios:t}},_expandScenarioOutline:function(n){if(!this._isScenarioOutlineWithExamples(n)){return[n]}var r=[];n.examples.filter(this._isNotWip).forEach(function(i,a){var o=this._convertScenarioExamplesToListOfObjects(i.data);r=r.concat(o.map(function(r,a){var o=e({},n);o.name+=i.name?": "+i.name:"";o.name+=" #"+(a+1);t(r,function(e,t){o.steps.forEach(function(n){var r=s(e);n.text=n.text.replace(new RegExp("<"+r+">","g"),t)})});return o},this))},this);return r},_generateTestScenario:function(e,t){var n=this._isWip(e);var r=this._isScenarioOutline(e)?"Scenario Outline: ":"Scenario: ";var i=(n?"(WIP) ":"")+r+e.name;var s=t?this._generateTestSteps(n,t,false):[];var a=this._isScenarioOutline(e)&&!this._isScenarioOutlineWithExamples(e);var o=a||s.some(function(e){return!e.isMatch});s=s.concat(this._generateTestSteps(n,e,o));return{name:i,skip:n||a||s.every(function(e){return e.skip&&e.isMatch}),wip:n,testSteps:s}},_generateTestSteps:function(e,t,n){var r=[];for(var i=0;i<t.steps.length;++i){var s=t.steps[i];var a=this._oStepDefs._generateTestStep(s);if(!a.isMatch&&this._fnAlternateTestStepGenerator){a=this._fnAlternateTestStepGenerator(s)}if(!a.isMatch){n=true}a.skip=n||e;if(a.isMatch&&a.skip){a.text="(SKIPPED) "+a.text}r.push(a)}return r},_convertScenarioExamplesToListOfObjects:function(e){e=e.map(function(e){return typeof e==="string"||e instanceof String?[e]:e});return r.toTable(e)},_isScenarioOutline:function(e){return!!e.examples},_isScenarioOutlineWithExamples:function(e){return!!e.examples&&e.examples.length!==0&&e.examples.some(this._isNotWip)},_isNotWip:function(e){return e.tags==null||!e.tags.includes("@wip",e.tags)},_isWip:function(e){return!this._isNotWip(e)}});return a});
//# sourceMappingURL=GherkinTestGenerator.js.map