/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/Object","sap/base/util/extend","sap/ui/core/Element","sap/ui/testrecorder/CommunicationBus","sap/ui/testrecorder/CommunicationChannels","sap/ui/testrecorder/mutationObservers/AppMutationObserver","sap/ui/testrecorder/mutationObservers/ElementMutationObserver","sap/ui/support/supportRules/ui/external/Highlighter","sap/ui/test/_ControlFinder","sap/ui/testrecorder/inspector/ControlAPI","sap/ui/testrecorder/inspector/ControlInspectorRepo","sap/ui/testrecorder/Constants","sap/ui/testrecorder/DialectRegistry","sap/ui/testrecorder/Dialects","sap/ui/testrecorder/controlSelectors/ControlSelectorGenerator","sap/ui/testrecorder/codeSnippets/POMethodUtil","sap/ui/testrecorder/codeSnippets/RawSnippetUtil","sap/ui/testrecorder/codeSnippets/CodeSnippetProvider","sap/ui/testrecorder/ui/models/SharedModel"],function(e,t,i,r,s,n,o,p,a,l,c,d,u,h,E,g,b,C,S){"use strict";var f=null;var m=new p(d.HIGHLIGHTER_ID);var I=Object.assign({},S.getData().settings);var D=e.extend("sap.ui.testrecorder.inspector.ControlInspector",{constructor:function(){if(!f){e.apply(this,arguments);this._appObserver=new n(this.getAllControlData.bind(this));this._selectedElementObserver=new o(this.getControlData.bind(this))}else{return f}}});D.prototype.init=function(){this._appObserver.start();r.subscribe(s.REQUEST_ALL_CONTROLS_DATA,this.getAllControlData.bind(this));r.subscribe(s.REQUEST_CONTROL_DATA,this.getControlData.bind(this));r.subscribe(s.REQUEST_CODE_SNIPPET,this.getCodeSnippet.bind(this));r.subscribe(s.HIGHLIGHT_CONTROL,this.highlightControl.bind(this));r.subscribe(s.SET_DIALECT,this.setDialect.bind(this));r.subscribe(s.UPDATE_SETTINGS,this.updateSettings.bind(this));r.subscribe(s.CLEAR_SNIPPETS,this.clearSnippets.bind(this))};D.prototype.getAllControlData=function(){r.publish(s.RECEIVE_ALL_CONTROLS_DATA,{renderedControls:l.getAllControlData().renderedControls,framework:l.getFrameworkData().framework});c.clear()};D.prototype.getControlData=function(e){var t=e.domElementId?document.getElementById(e.domElementId):i.getElementById(e.controlId).getDomRef();this._selectedElementObserver.stop();this._selectedElementObserver.start(t);var n=l.getControlData(e);r.publish(s.RECEIVE_CONTROL_DATA,n)};D.prototype.getCodeSnippet=function(e){var i=Object.assign({},e,{settings:I});var n=c.findSelector(e.domElementId);var o=n?Promise.resolve(n):E.getSelector(i);return o.then(function(e){n=e;return C.getSnippet({controlSelector:e,action:i.action,assertion:i.assertion,settings:I})}).then(function(i){c.save(e,n,i);var r=I.multipleSnippets?c.getSnippets():[i];if(u.getActiveDialect()===h.RAW){return b.getJSON(r,I)}else{return g.getPOMethod(r,t({action:e.action,assertion:e.assertion},I),u.getActiveDialect()===h.WDI5)}}).then(function(e){r.publish(s.RECEIVE_CODE_SNIPPET,{codeSnippet:e})}).catch(function(t){r.publish(s.RECEIVE_CODE_SNIPPET,{error:"Could not generate code snippet for "+JSON.stringify(e)+". Details: "+t,domElementId:i.domElementId})})};D.prototype.highlightControl=function(e){if(e.domElementId){m.highlight(e.domElementId)}else if(e.controlId){var t=a._findElements({id:e.controlId})[0];if(t){m.highlight(t.id)}}};D.prototype.setDialect=function(e){if(u.getActiveDialect()!==e){u.setActiveDialect(e);r.publish(s.DIALECT_CHANGED,{dialect:e});c.getRequests().forEach(this.getCodeSnippet.bind(this))}};D.prototype.updateSettings=function(e){Object.assign(I,e);var t=c.getRequests();if(O(e,"multipleSnippets")){this.clearSnippets();if(t.length){this.getCodeSnippet(t[t.length-1])}}if(O(e,["preferViewId"])){c.clear()}if(O(e,["formatAsPOMethod","preferViewId"])){if(I.multipleSnippets){t.forEach(this.getCodeSnippet.bind(this))}else if(t.length){this.getCodeSnippet(t[t.length-1])}}};D.prototype.clearSnippets=function(){c.clear();r.publish(s.RECEIVE_CODE_SNIPPET,{codeSnippet:""})};D.prototype.stop=function(){this._appObserver.stop();this._selectedElementObserver.stop()};function O(e,t){var i=Array.isArray(t)?t:[t];return i.filter(function(t){return e[t]!==null&&e[t]!==undefined}).length}f=new D;return f},true);
//# sourceMappingURL=ControlInspector.js.map