/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","sap/ui/Device","sap/ui/util/Storage","sap/ui/core/mvc/Controller","sap/ui/dom/includeStylesheet","sap/ui/testrecorder/ui/models/SharedModel","sap/ui/testrecorder/CommunicationBus","sap/ui/testrecorder/CommunicationChannels","sap/ui/model/json/JSONModel","sap/ui/model/resource/ResourceModel","sap/ui/model/Binding","sap/m/MessageToast","sap/m/Dialog","sap/m/CheckBox","sap/m/Button","sap/m/VBox","sap/ui/support/supportRules/ui/external/ElementTree","sap/ui/testrecorder/interaction/ContextMenu"],function(e,t,i,o,n,s,r,l,a,d,c,p,h,g,u,m,T,_){"use strict";return o.extend("sap.ui.testrecorder.ui.controllers.Main",{onInit:function(){this._minimized=false;this._selectionId=null;this._localStorage=new i(i.Type.local,"sap-ui-test-recorder");n("sap/ui/testrecorder/ui/styles/overlay.css");this.elementTree=new T(null,{filter:{issues:false,search:true},onSelectionChanged:this._onTreeSelectionChanged.bind(this),onContextMenu:this._onTreeContextMenu.bind(this),onInitialRendering:this._onElementTreeInitialRendering.bind(this)});this._setupModels();this.toggleHeaderToolbars()},onBeforeRendering:function(){r.publish(l.REQUEST_ALL_CONTROLS_DATA)},onAfterRendering:function(){r.subscribe(l.RECEIVE_ALL_CONTROLS_DATA,this._onUpdateAllControls.bind(this));r.subscribe(l.RECEIVE_CONTROL_DATA,this._onReceiveControlDetails.bind(this));r.subscribe(l.RECEIVE_CODE_SNIPPET,this._onUpdateCodeSnippet.bind(this));r.subscribe(l.SELECT_CONTROL_IN_TREE,this._onUpdateSelection.bind(this));r.subscribe(l.DIALECT_CHANGED,this._changeDialect.bind(this))},toggleHeaderToolbars:function(){this.byId("ttMaximizeHeaderBar").setVisible(this._minimized)},toggleMinimize:function(){this._minimized=!this._minimized;this.toggleHeaderToolbars();if(this._minimized){r.publish(l.MINIMIZE_IFRAME)}else{r.publish(l.SHOW_IFRAME)}},dockBottom:function(){r.publish(l.DOCK_IFRAME_BOTTOM)},dockRight:function(){r.publish(l.DOCK_IFRAME_RIGHT)},dockLeft:function(){r.publish(l.DOCK_IFRAME_LEFT)},openWindow:function(){r.publish(l.OPEN_NEW_WINDOW)},close:function(){r.publish(l.CLOSE_IFRAME)},copyCodeSnippet:function(){var e=this.byId("codeEditor").getValue();var i=function(t){if(t.clipboardData){t.clipboardData.setData("text/plain",e)}else{t.originalEvent.clipboardData.setData("text/plain",e)}t.preventDefault()};if(t.browser.msie&&window.clipboardData){window.clipboardData.setData("text",e)}else{document.addEventListener("copy",i);document.execCommand("copy");document.removeEventListener("copy",i)}},clearCodeSnippet:function(){r.publish(l.CLEAR_SNIPPETS);this.byId("codeEditor").setValue("")},openSettingsDialog:function(){if(!this.settingsDialog){this.settingsDialog=new h({title:this.getView().getModel("i18n").getProperty("TestRecorder.SettingsDialog.Title"),content:[new m({items:[new g({text:this.getView().getModel("i18n").getProperty("TestRecorder.SettingsDialog.IDCheckBox.Text"),name:"preferViewId",selected:this.model.getProperty("/settings/preferViewId"),select:this._onSelectCheckBox.bind(this)}),new g({text:this.getView().getModel("i18n").getProperty("TestRecorder.SettingsDialog.POMethodCheckBox.Text"),name:"formatAsPOMethod",selected:this.model.getProperty("/settings/formatAsPOMethod"),select:this._onSelectCheckBox.bind(this)})]})],endButton:new u({text:this.getView().getModel("i18n").getProperty("TestRecorder.SettingsDialog.CloseButton.Text"),press:this.closeSettingsDialog.bind(this)})});this.getView().addDependent(this.settingsDialog)}this.settingsDialog.open()},closeSettingsDialog:function(){if(this.settingsDialog){this.settingsDialog.close()}},handlePropertyIconPress:function(e){var t=e.getSource();var i=t.getParent().getParent();var o=i.getCells()[0].getItems()[1].getText();var n=i.getCells()[1].getText();var s=i.getCells()[2].getText();r.publish(l.ASSERT_PROPERTY,{domElementId:this._selectionId,assertion:{propertyName:o,expectedValue:n,propertyType:s}})},_setupModels:function(){this.model=s;this.getView().setModel(this.model);this.model.setProperty("/isInIframe",!window.opener);var e=this._localStorage.get("dialect");var t=this._localStorage.get("settings-preferViewId");var i=this._localStorage.get("settings-formatAsPOMethod");if(e){this.model.setProperty("/selectedDialect",e);r.publish(l.SET_DIALECT,e)}if(t!==null&&t!=="undefined"){this.model.setProperty("/settings/preferViewId",t)}if(i!==null&&i!=="undefined"){this.model.setProperty("/settings/formatAsPOMethod",i)}r.publish(l.UPDATE_SETTINGS,this.model.getProperty("/settings"));var o=new c(s,"/",s.getContext("/selectedDialect"));o.attachChange(function(){r.publish(l.SET_DIALECT,this.model.getProperty("/selectedDialect"))}.bind(this));var n=new d({bundleName:"sap.ui.core.messagebundle"});this.getView().setModel(n,"i18n");this.getView().setModel(new a({framework:{}}),"framework");this.getView().setModel(new a({controls:{bindings:{},properties:{},codeSnippet:"",renderedControls:[]}}),"controls")},_onUpdateAllControls:function(e){this.elementTree.setContainerId(this.byId("elementTreeContainer").getId());this._clearControlData();if(e.framework){this.getView().getModel("controls").setProperty("/framework",e.framework)}if(e.renderedControls){this.getView().getModel("controls").setProperty("/renderedControls",e.renderedControls);this.elementTree.setData({controls:e.renderedControls})}if(!this._minimized){p.show(this.getView().getModel("i18n").getProperty("TestRecorder.ControlTree.MessageToast"),{duration:1e3})}},_onReceiveControlDetails:function(e){if(e.properties){this.getView().getModel("controls").setProperty("/properties",e.properties)}if(e.bindings){this.getView().getModel("controls").setProperty("/bindings",e.bindings)}},_onUpdateCodeSnippet:function(e){if(e.codeSnippet!==undefined){this.getView().getModel("controls").setProperty("/codeSnippet",e.codeSnippet)}else if(e.error){var t=this.getView().getModel("i18n").getResourceBundle().getText("TestRecorder.Inspect.Snippet.NotFound.Text",["#"+e.domElementId]);this.getView().getModel("controls").setProperty("/codeSnippet",t)}},_onUpdateSelection:function(e){this._selectionId=e.rootElementId;this.elementTree.setSelectedElement(e.rootElementId,false);this._clearControlData();r.publish(l.REQUEST_CONTROL_DATA,{domElementId:e.rootElementId});r.publish(l.REQUEST_CODE_SNIPPET,{domElementId:e.interactionElementId,action:e.action,assertion:e.assertion});r.publish(l.HIGHLIGHT_CONTROL,{domElementId:e.rootElementId})},_onTreeSelectionChanged:function(e){this._selectionId=e;this._clearControlData();r.publish(l.REQUEST_CONTROL_DATA,{domElementId:e});r.publish(l.REQUEST_CODE_SNIPPET,{domElementId:e});r.publish(l.HIGHLIGHT_CONTROL,{domElementId:e})},_onTreeContextMenu:function(e){e=e||{};e.withEvents=true;e.items={highlight:false};_.show(e)},_onElementTreeInitialRendering:function(){var t=this.elementTree._filterContainer;var i=t.onkeyup;var o=t.onchange;var n=["filter","attributes","namespaces"];var s=this.model;n.forEach(function(i){var o=t.querySelector("["+i+"]");o.checked=s.getProperty("/elementTree/"+i);e(o).change()});var r=t.querySelector("[search]");r.value=s.getProperty("/elementTree/search");e(r).keyup();t.onchange=function(e){n.forEach(function(t){if(e.target.getAttribute(t)!==null){s.setProperty("/elementTree/"+t,e.target.checked)}});o.apply(this,arguments)};t.onkeyup=function(e){s.setProperty("/elementTree/search",e.target.value);i.apply(this,arguments)}},_clearControlData:function(){this.getView().getModel("controls").setProperty("/properties",{});this.getView().getModel("controls").setProperty("/bindings",{});this.getView().getModel("controls").setProperty("/codeSnippet","")},_changeDialect:function(e){this._localStorage.put("dialect",e.dialect)},_onSelectCheckBox:function(e){var t=e.getParameter("selected");var i=e.getSource().getName();var o={};o[i]=t;this.model.setProperty("/settings/"+i,t);this._localStorage.put("settings-"+i,t);r.publish(l.UPDATE_SETTINGS,o)},_onChangeMultiple:function(e){var t=e.getParameter("state");r.publish(l.UPDATE_SETTINGS,{multipleSnippets:t})},_onCodeEditorChange:function(e){var t=this.byId("codeEditor");var i=t.getValue().split("\n").length;if(i){t._oEditor.scrollToLine(i)}}})});
//# sourceMappingURL=Main.controller.js.map