(function(e){"use strict";
/*
 *      bignumber.js v6.0.0
 *      A JavaScript library for arbitrary-precision arithmetic.
 *      https://github.com/MikeMcl/bignumber.js
 *      Copyright (c) 2018 Michael Mclaughlin <M8ch88l@gmail.com>
 *      MIT Licensed.
 *
 *      BigNumber.prototype methods     |  BigNumber methods
 *                                      |
 *      absoluteValue            abs    |  clone
 *      comparedTo                      |  config               set
 *      decimalPlaces            dp     |      DECIMAL_PLACES
 *      dividedBy                div    |      ROUNDING_MODE
 *      dividedToIntegerBy       idiv   |      EXPONENTIAL_AT
 *      exponentiatedBy          pow    |      RANGE
 *      integerValue                    |      CRYPTO
 *      isEqualTo                eq     |      MODULO_MODE
 *      isFinite                        |      POW_PRECISION
 *      isGreaterThan            gt     |      FORMAT
 *      isGreaterThanOrEqualTo   gte    |      ALPHABET
 *      isInteger                       |  isBigNumber
 *      isLessThan               lt     |  maximum              max
 *      isLessThanOrEqualTo      lte    |  minimum              min
 *      isNaN                           |  random
 *      isNegative                      |
 *      isPositive                      |
 *      isZero                          |
 *      minus                           |
 *      modulo                   mod    |
 *      multipliedBy             times  |
 *      negated                         |
 *      plus                            |
 *      precision                sd     |
 *      shiftedBy                       |
 *      squareRoot               sqrt   |
 *      toExponential                   |
 *      toFixed                         |
 *      toFormat                        |
 *      toFraction                      |
 *      toJSON                          |
 *      toNumber                        |
 *      toPrecision                     |
 *      toString                        |
 *      valueOf                         |
 *
 */var r,n=/^-?(?:\d+(?:\.\d*)?|\.\d+)(?:e[+-]?\d+)?$/i,i=Math.ceil,t=Math.floor,f="[BigNumber Error] ",s=f+"Number primitive has more than 15 significant digits: ",o=1e14,l=14,u=9007199254740991,c=[1,10,100,1e3,1e4,1e5,1e6,1e7,1e8,1e9,1e10,1e11,1e12,1e13],a=1e7,h=1e9;function g(e){var r,y,b,E=M.prototype,A=new M(1),R=20,P=4,S=-7,_=21,L=-1e7,D=1e7,T=false,I=1,B=0,x={decimalSeparator:".",groupSeparator:",",groupSize:3,secondaryGroupSize:0,fractionGroupSeparator:" ",fractionGroupSize:0},C="0123456789abcdefghijklmnopqrstuvwxyz";function M(e,r){var i,f,o,c,a,h,g,p=this;if(!(p instanceof M)){return new M(e,r)}if(r==null){if(e instanceof M){p.s=e.s;p.e=e.e;p.c=(e=e.c)?e.slice():e;return}a=typeof e=="number";if(a&&e*0==0){p.s=1/e<0?(e=-e,-1):1;if(e===~~e){for(o=0,c=e;c>=10;c/=10,o++);p.e=o;p.c=[e];return}g=e+""}else{if(!n.test(g=e+""))return b(p,g,a);p.s=g.charCodeAt(0)==45?(g=g.slice(1),-1):1}}else{m(r,2,C.length,"Base");g=e+"";if(r==10){p=new M(e instanceof M?e:g);return G(p,R+p.e+1,P)}a=typeof e=="number";if(a){if(e*0!=0)return b(p,g,a,r);p.s=1/e<0?(g=g.slice(1),-1):1;if(g.replace(/^0\.0*|\./,"").length>15){throw Error(s+e)}a=false}else{p.s=g.charCodeAt(0)===45?(g=g.slice(1),-1):1;if(r>10&&r<37)g=g.toLowerCase()}i=C.slice(0,r);o=c=0;for(h=g.length;c<h;c++){if(i.indexOf(f=g.charAt(c))<0){if(f=="."){if(c>o){o=h;continue}}return b(p,e+"",a,r)}}g=y(g,r,10,p.s)}if((o=g.indexOf("."))>-1)g=g.replace(".","");if((c=g.search(/e/i))>0){if(o<0)o=c;o+=+g.slice(c+1);g=g.substring(0,c)}else if(o<0){o=g.length}for(c=0;g.charCodeAt(c)===48;c++);for(h=g.length;g.charCodeAt(--h)===48;);g=g.slice(c,h+1);if(g){h=g.length;if(a&&h>15&&(e>u||e!==t(e))){throw Error(s+p.s*e)}o=o-c-1;if(o>D){p.c=p.e=null}else if(o<L){p.c=[p.e=0]}else{p.e=o;p.c=[];c=(o+1)%l;if(o<0)c+=l;if(c<h){if(c)p.c.push(+g.slice(0,c));for(h-=l;c<h;){p.c.push(+g.slice(c,c+=l))}g=g.slice(c);c=l-g.length}else{c-=h}for(;c--;g+="0");p.c.push(+g)}}else{p.c=[p.e=0]}}M.clone=g;M.ROUND_UP=0;M.ROUND_DOWN=1;M.ROUND_CEIL=2;M.ROUND_FLOOR=3;M.ROUND_HALF_UP=4;M.ROUND_HALF_DOWN=5;M.ROUND_HALF_EVEN=6;M.ROUND_HALF_CEIL=7;M.ROUND_HALF_FLOOR=8;M.EUCLID=9;M.config=M.set=function(e){var r,n;if(e!=null){if(typeof e=="object"){if(e.hasOwnProperty(r="DECIMAL_PLACES")){n=e[r];m(n,0,h,r);R=n}if(e.hasOwnProperty(r="ROUNDING_MODE")){n=e[r];m(n,0,8,r);P=n}if(e.hasOwnProperty(r="EXPONENTIAL_AT")){n=e[r];if(v(n)){m(n[0],-h,0,r);m(n[1],0,h,r);S=n[0];_=n[1]}else{m(n,-h,h,r);S=-(_=n<0?-n:n)}}if(e.hasOwnProperty(r="RANGE")){n=e[r];if(v(n)){m(n[0],-h,-1,r);m(n[1],1,h,r);L=n[0];D=n[1]}else{m(n,-h,h,r);if(n){L=-(D=n<0?-n:n)}else{throw Error(f+r+" cannot be zero: "+n)}}}if(e.hasOwnProperty(r="CRYPTO")){n=e[r];if(n===!!n){if(n){if(typeof crypto!="undefined"&&crypto&&(crypto.getRandomValues||crypto.randomBytes)){T=n}else{T=!n;throw Error(f+"crypto unavailable")}}else{T=n}}else{throw Error(f+r+" not true or false: "+n)}}if(e.hasOwnProperty(r="MODULO_MODE")){n=e[r];m(n,0,9,r);I=n}if(e.hasOwnProperty(r="POW_PRECISION")){n=e[r];m(n,0,h,r);B=n}if(e.hasOwnProperty(r="FORMAT")){n=e[r];if(typeof n=="object")x=n;else throw Error(f+r+" not an object: "+n)}if(e.hasOwnProperty(r="ALPHABET")){n=e[r];if(typeof n=="string"&&!/^.$|\.|(.).*\1/.test(n)){C=n}else{throw Error(f+r+" invalid: "+n)}}}else{throw Error(f+"Object expected: "+e)}}return{DECIMAL_PLACES:R,ROUNDING_MODE:P,EXPONENTIAL_AT:[S,_],RANGE:[L,D],CRYPTO:T,MODULO_MODE:I,POW_PRECISION:B,FORMAT:x,ALPHABET:C}};M.isBigNumber=function(e){return e instanceof M||e&&e._isBigNumber===true||false};M.maximum=M.max=function(){return F(arguments,E.lt)};M.minimum=M.min=function(){return F(arguments,E.gt)};M.random=function(){var e=9007199254740992;var r=Math.random()*e&2097151?function(){return t(Math.random()*e)}:function(){return(Math.random()*1073741824|0)*8388608+(Math.random()*8388608|0)};return function(e){var n,s,o,u,a,g=0,p=[],w=new M(A);if(e==null)e=R;else m(e,0,h);u=i(e/l);if(T){if(crypto.getRandomValues){n=crypto.getRandomValues(new Uint32Array(u*=2));for(;g<u;){a=n[g]*131072+(n[g+1]>>>11);if(a>=9e15){s=crypto.getRandomValues(new Uint32Array(2));n[g]=s[0];n[g+1]=s[1]}else{p.push(a%1e14);g+=2}}g=u/2}else if(crypto.randomBytes){n=crypto.randomBytes(u*=7);for(;g<u;){a=(n[g]&31)*281474976710656+n[g+1]*1099511627776+n[g+2]*4294967296+n[g+3]*16777216+(n[g+4]<<16)+(n[g+5]<<8)+n[g+6];if(a>=9e15){crypto.randomBytes(7).copy(n,g)}else{p.push(a%1e14);g+=7}}g=u/7}else{T=false;throw Error(f+"crypto unavailable")}}if(!T){for(;g<u;){a=r();if(a<9e15)p[g++]=a%1e14}}u=p[--g];e%=l;if(u&&e){a=c[l-e];p[g]=t(u/a)*a}for(;p[g]===0;p.pop(),g--);if(g<0){p=[o=0]}else{for(o=-1;p[0]===0;p.splice(0,1),o-=l);for(g=1,a=p[0];a>=10;a/=10,g++);if(g<l)o-=l-g}w.e=o;w.c=p;return w}}();y=function(){var e="0123456789";function n(e,r,n,i){var t,f=[0],s,o=0,l=e.length;for(;o<l;){for(s=f.length;s--;f[s]*=r);f[0]+=i.indexOf(e.charAt(o++));for(t=0;t<f.length;t++){if(f[t]>n-1){if(f[t+1]==null)f[t+1]=0;f[t+1]+=f[t]/n|0;f[t]%=n}}}return f.reverse()}return function(i,t,f,s,o){var l,u,c,a,h,g,p,d,m=i.indexOf("."),v=R,N=P;if(m>=0){a=B;B=0;i=i.replace(".","");d=new M(t);g=d.pow(i.length-m);B=a;d.c=n(O(w(g.c),g.e,"0"),10,f,e);d.e=d.c.length}p=n(i,t,f,o?(l=C,e):(l=e,C));c=a=p.length;for(;p[--a]==0;p.pop());if(!p[0])return l.charAt(0);if(m<0){--c}else{g.c=p;g.e=c;g.s=s;g=r(g,d,v,N,f);p=g.c;h=g.r;c=g.e}u=c+v+1;m=p[u];a=f/2;h=h||u<0||p[u+1]!=null;h=N<4?(m!=null||h)&&(N==0||N==(g.s<0?3:2)):m>a||m==a&&(N==4||h||N==6&&p[u-1]&1||N==(g.s<0?8:7));if(u<1||!p[0]){i=h?O(l.charAt(1),-v,l.charAt(0)):l.charAt(0)}else{p.length=u;if(h){for(--f;++p[--u]>f;){p[u]=0;if(!u){++c;p=[1].concat(p)}}}for(a=p.length;!p[--a];);for(m=0,i="";m<=a;i+=l.charAt(p[m++]));i=O(i,c,l.charAt(0))}return i}}();r=function(){function e(e,r,n){var i,t,f,s,o=0,l=e.length,u=r%a,c=r/a|0;for(e=e.slice();l--;){f=e[l]%a;s=e[l]/a|0;i=c*f+s*u;t=u*f+i%a*a+o;o=(t/n|0)+(i/a|0)+c*s;e[l]=t%n}if(o)e=[o].concat(e);return e}function r(e,r,n,i){var t,f;if(n!=i){f=n>i?1:-1}else{for(t=f=0;t<n;t++){if(e[t]!=r[t]){f=e[t]>r[t]?1:-1;break}}}return f}function n(e,r,n,i){var t=0;for(;n--;){e[n]-=t;t=e[n]<r[n]?1:0;e[n]=t*i+e[n]-r[n]}for(;!e[0]&&e.length>1;e.splice(0,1));}return function(i,f,s,u,c){var a,h,g,w,d,m,v,N,O,y,b,E,A,R,P,S,_,L=i.s==f.s?1:-1,D=i.c,T=f.c;if(!D||!D[0]||!T||!T[0]){return new M(!i.s||!f.s||(D?T&&D[0]==T[0]:!T)?NaN:D&&D[0]==0||!T?L*0:L/0)}N=new M(L);O=N.c=[];h=i.e-f.e;L=s+h+1;if(!c){c=o;h=p(i.e/l)-p(f.e/l);L=L/l|0}for(g=0;T[g]==(D[g]||0);g++);if(T[g]>(D[g]||0))h--;if(L<0){O.push(1);w=true}else{R=D.length;S=T.length;g=0;L+=2;d=t(c/(T[0]+1));if(d>1){T=e(T,d,c);D=e(D,d,c);S=T.length;R=D.length}A=S;y=D.slice(0,S);b=y.length;for(;b<S;y[b++]=0);_=T.slice();_=[0].concat(_);P=T[0];if(T[1]>=c/2)P++;do{d=0;a=r(T,y,S,b);if(a<0){E=y[0];if(S!=b)E=E*c+(y[1]||0);d=t(E/P);if(d>1){if(d>=c)d=c-1;m=e(T,d,c);v=m.length;b=y.length;while(r(m,y,v,b)==1){d--;n(m,S<v?_:T,v,c);v=m.length;a=1}}else{if(d==0){a=d=1}m=T.slice();v=m.length}if(v<b)m=[0].concat(m);n(y,m,b,c);b=y.length;if(a==-1){while(r(T,y,S,b)<1){d++;n(y,S<b?_:T,b,c);b=y.length}}}else if(a===0){d++;y=[0]}O[g++]=d;if(y[0]){y[b++]=D[A]||0}else{y=[D[A]];b=1}}while((A++<R||y[0]!=null)&&L--);w=y[0]!=null;if(!O[0])O.splice(0,1)}if(c==o){for(g=1,L=O[0];L>=10;L/=10,g++);G(N,s+(N.e=g+h*l-1)+1,u,w)}else{N.e=h;N.r=+w}return N}}();function U(e,r,n,i){var t,f,s,o,l;if(n==null)n=P;else m(n,0,8);if(!e.c)return e.toString();t=e.c[0];s=e.e;if(r==null){l=w(e.c);l=i==1||i==2&&s<=S?N(l,s):O(l,s,"0")}else{e=G(new M(e),r,n);f=e.e;l=w(e.c);o=l.length;if(i==1||i==2&&(r<=f||f<=S)){for(;o<r;l+="0",o++);l=N(l,f)}else{r-=s;l=O(l,f,"0");if(f+1>o){if(--r>0)for(l+=".";r--;l+="0");}else{r+=f-o;if(r>0){if(f+1==o)l+=".";for(;r--;l+="0");}}}}return e.s<0&&t?"-"+l:l}function F(e,r){var n,i,t=0;if(v(e[0]))e=e[0];n=new M(e[0]);for(;++t<e.length;){i=new M(e[t]);if(!i.s){n=i;break}else if(r.call(n,i)){n=i}}return n}function k(e,r,n){var i=1,t=r.length;for(;!r[--t];r.pop());for(t=r[0];t>=10;t/=10,i++);if((n=i+n*l-1)>D){e.c=e.e=null}else if(n<L){e.c=[e.e=0]}else{e.e=n;e.c=r}return e}b=function(){var e=/^(-?)0([xbo])(?=\w[\w.]*$)/i,r=/^([^.]+)\.$/,n=/^\.([^.]+)$/,i=/^-?(Infinity|NaN)$/,t=/^\s*\+(?=[\w.])|^\s+|\s+$/g;return function(s,o,l,u){var c,a=l?o:o.replace(t,"");if(i.test(a)){s.s=isNaN(a)?null:a<0?-1:1;s.c=s.e=null}else{if(!l){a=a.replace(e,function(e,r,n){c=(n=n.toLowerCase())=="x"?16:n=="b"?2:8;return!u||u==c?r:e});if(u){c=u;a=a.replace(r,"$1").replace(n,"0.$1")}if(o!=a)return new M(a,c)}throw Error(f+"Not a"+(u?" base "+u:"")+" number: "+o)}}}();function G(e,r,n,f){var s,u,a,h,g,p,w,d=e.c,m=c;if(d){e:{for(s=1,h=d[0];h>=10;h/=10,s++);u=r-s;if(u<0){u+=l;a=r;g=d[p=0];w=g/m[s-a-1]%10|0}else{p=i((u+1)/l);if(p>=d.length){if(f){for(;d.length<=p;d.push(0));g=w=0;s=1;u%=l;a=u-l+1}else{break e}}else{g=h=d[p];for(s=1;h>=10;h/=10,s++);u%=l;a=u-l+s;w=a<0?0:g/m[s-a-1]%10|0}}f=f||r<0||d[p+1]!=null||(a<0?g:g%m[s-a-1]);f=n<4?(w||f)&&(n==0||n==(e.s<0?3:2)):w>5||w==5&&(n==4||f||n==6&&(u>0?a>0?g/m[s-a]:0:d[p-1])%10&1||n==(e.s<0?8:7));if(r<1||!d[0]){d.length=0;if(f){r-=e.e+1;d[0]=m[(l-r%l)%l];e.e=-r||0}else{d[0]=e.e=0}return e}if(u==0){d.length=p;h=1;p--}else{d.length=p+1;h=m[l-u];d[p]=a>0?t(g/m[s-a]%m[a])*h:0}if(f){for(;;){if(p==0){for(u=1,a=d[0];a>=10;a/=10,u++);a=d[0]+=h;for(h=1;a>=10;a/=10,h++);if(u!=h){e.e++;if(d[0]==o)d[0]=1}break}else{d[p]+=h;if(d[p]!=o)break;d[p--]=0;h=1}}}for(u=d.length;d[--u]===0;d.pop());}if(e.e>D){e.c=e.e=null}else if(e.e<L){e.c=[e.e=0]}}return e}E.absoluteValue=E.abs=function(){var e=new M(this);if(e.s<0)e.s=1;return e};E.comparedTo=function(e,r){return d(this,new M(e,r))};E.decimalPlaces=E.dp=function(e,r){var n,i,t,f=this;if(e!=null){m(e,0,h);if(r==null)r=P;else m(r,0,8);return G(new M(f),e+f.e+1,r)}if(!(n=f.c))return null;i=((t=n.length-1)-p(this.e/l))*l;if(t=n[t])for(;t%10==0;t/=10,i--);if(i<0)i=0;return i};E.dividedBy=E.div=function(e,n){return r(this,new M(e,n),R,P)};E.dividedToIntegerBy=E.idiv=function(e,n){return r(this,new M(e,n),0,1)};E.isEqualTo=E.eq=function(e,r){return d(this,new M(e,r))===0};E.integerValue=function(e){var r=new M(this);if(e==null)e=P;else m(e,0,8);return G(r,r.e+1,e)};E.isGreaterThan=E.gt=function(e,r){return d(this,new M(e,r))>0};E.isGreaterThanOrEqualTo=E.gte=function(e,r){return(r=d(this,new M(e,r)))===1||r===0};E.isFinite=function(){return!!this.c};E.isInteger=function(){return!!this.c&&p(this.e/l)>this.c.length-2};E.isNaN=function(){return!this.s};E.isNegative=function(){return this.s<0};E.isPositive=function(){return this.s>0};E.isZero=function(){return!!this.c&&this.c[0]==0};E.isLessThan=E.lt=function(e,r){return d(this,new M(e,r))<0};E.isLessThanOrEqualTo=E.lte=function(e,r){return(r=d(this,new M(e,r)))===-1||r===0};E.minus=function(e,r){var n,i,t,f,s=this,u=s.s;e=new M(e,r);r=e.s;if(!u||!r)return new M(NaN);if(u!=r){e.s=-r;return s.plus(e)}var c=s.e/l,a=e.e/l,h=s.c,g=e.c;if(!c||!a){if(!h||!g)return h?(e.s=-r,e):new M(g?s:NaN);if(!h[0]||!g[0]){return g[0]?(e.s=-r,e):new M(h[0]?s:P==3?-0:0)}}c=p(c);a=p(a);h=h.slice();if(u=c-a){if(f=u<0){u=-u;t=h}else{a=c;t=g}t.reverse();for(r=u;r--;t.push(0));t.reverse()}else{i=(f=(u=h.length)<(r=g.length))?u:r;for(u=r=0;r<i;r++){if(h[r]!=g[r]){f=h[r]<g[r];break}}}if(f)t=h,h=g,g=t,e.s=-e.s;r=(i=g.length)-(n=h.length);if(r>0)for(;r--;h[n++]=0);r=o-1;for(;i>u;){if(h[--i]<g[i]){for(n=i;n&&!h[--n];h[n]=r);--h[n];h[i]+=o}h[i]-=g[i]}for(;h[0]==0;h.splice(0,1),--a);if(!h[0]){e.s=P==3?-1:1;e.c=[e.e=0];return e}return k(e,h,a)};E.modulo=E.mod=function(e,n){var i,t,f=this;e=new M(e,n);if(!f.c||!e.s||e.c&&!e.c[0]){return new M(NaN)}else if(!e.c||f.c&&!f.c[0]){return new M(f)}if(I==9){t=e.s;e.s=1;i=r(f,e,0,3);e.s=t;i.s*=t}else{i=r(f,e,0,I)}return f.minus(i.times(e))};E.multipliedBy=E.times=function(e,r){var n,i,t,f,s,u,c,h,g,w,d,m,v,N,O,y=this,b=y.c,E=(e=new M(e,r)).c;if(!b||!E||!b[0]||!E[0]){if(!y.s||!e.s||b&&!b[0]&&!E||E&&!E[0]&&!b){e.c=e.e=e.s=null}else{e.s*=y.s;if(!b||!E){e.c=e.e=null}else{e.c=[0];e.e=0}}return e}i=p(y.e/l)+p(e.e/l);e.s*=y.s;c=b.length;w=E.length;if(c<w)v=b,b=E,E=v,t=c,c=w,w=t;for(t=c+w,v=[];t--;v.push(0));N=o;O=a;for(t=w;--t>=0;){n=0;d=E[t]%O;m=E[t]/O|0;for(s=c,f=t+s;f>t;){h=b[--s]%O;g=b[s]/O|0;u=m*h+g*d;h=d*h+u%O*O+v[f]+n;n=(h/N|0)+(u/O|0)+m*g;v[f--]=h%N}v[f]=n}if(n){++i}else{v.splice(0,1)}return k(e,v,i)};E.negated=function(){var e=new M(this);e.s=-e.s||null;return e};E.plus=function(e,r){var n,i=this,t=i.s;e=new M(e,r);r=e.s;if(!t||!r)return new M(NaN);if(t!=r){e.s=-r;return i.minus(e)}var f=i.e/l,s=e.e/l,u=i.c,c=e.c;if(!f||!s){if(!u||!c)return new M(t/0);if(!u[0]||!c[0])return c[0]?e:new M(u[0]?i:t*0)}f=p(f);s=p(s);u=u.slice();if(t=f-s){if(t>0){s=f;n=c}else{t=-t;n=u}n.reverse();for(;t--;n.push(0));n.reverse()}t=u.length;r=c.length;if(t-r<0)n=c,c=u,u=n,r=t;for(t=0;r;){t=(u[--r]=u[r]+c[r]+t)/o|0;u[r]=o===u[r]?0:u[r]%o}if(t){u=[t].concat(u);++s}return k(e,u,s)};E.precision=E.sd=function(e,r){var n,i,t,f=this;if(e!=null&&e!==!!e){m(e,1,h);if(r==null)r=P;else m(r,0,8);return G(new M(f),e,r)}if(!(n=f.c))return null;t=n.length-1;i=t*l+1;if(t=n[t]){for(;t%10==0;t/=10,i--);for(t=n[0];t>=10;t/=10,i++);}if(e&&f.e+1>i)i=f.e+1;return i};E.shiftedBy=function(e){m(e,-u,u);return this.times("1e"+e)};E.squareRoot=E.sqrt=function(){var e,n,i,t,f,s=this,o=s.c,l=s.s,u=s.e,c=R+4,a=new M("0.5");if(l!==1||!o||!o[0]){return new M(!l||l<0&&(!o||o[0])?NaN:o?s:1/0)}l=Math.sqrt(+s);if(l==0||l==1/0){n=w(o);if((n.length+u)%2==0)n+="0";l=Math.sqrt(n);u=p((u+1)/2)-(u<0||u%2);if(l==1/0){n="1e"+u}else{n=l.toExponential();n=n.slice(0,n.indexOf("e")+1)+u}i=new M(n)}else{i=new M(l+"")}if(i.c[0]){u=i.e;l=u+c;if(l<3)l=0;for(;;){f=i;i=a.times(f.plus(r(s,f,c,1)));if(w(f.c).slice(0,l)===(n=w(i.c)).slice(0,l)){if(i.e<u)--l;n=n.slice(l-3,l+1);if(n=="9999"||!t&&n=="4999"){if(!t){G(f,f.e+R+2,0);if(f.times(f).eq(s)){i=f;break}}c+=4;l+=4;t=1}else{if(!+n||!+n.slice(1)&&n.charAt(0)=="5"){G(i,i.e+R+2,1);e=!i.times(i).eq(s)}break}}}}return G(i,i.e+R+1,P,e)};E.toExponential=function(e,r){if(e!=null){m(e,0,h);e++}return U(this,e,r,1)};E.toFixed=function(e,r){if(e!=null){m(e,0,h);e=e+this.e+1}return U(this,e,r)};E.toFormat=function(e,r){var n=this.toFixed(e,r);if(this.c){var i,t=n.split("."),f=+x.groupSize,s=+x.secondaryGroupSize,o=x.groupSeparator,l=t[0],u=t[1],c=this.s<0,a=c?l.slice(1):l,h=a.length;if(s)i=f,f=s,s=i,h-=i;if(f>0&&h>0){i=h%f||f;l=a.substr(0,i);for(;i<h;i+=f){l+=o+a.substr(i,f)}if(s>0)l+=o+a.slice(i);if(c)l="-"+l}n=u?l+x.decimalSeparator+((s=+x.fractionGroupSize)?u.replace(new RegExp("\\d{"+s+"}\\B","g"),"$&"+x.fractionGroupSeparator):u):l}return n};E.toFraction=function(e){var n,i,t,s,o,u,a,h,g,p,d,m,v=this,N=v.c;if(e!=null){h=new M(e);if(!h.isInteger()||h.lt(A)){throw Error(f+"Argument "+(h.isInteger()?"out of range: ":"not an integer: ")+e)}}if(!N)return v.toString();i=new M(A);p=t=new M(A);s=g=new M(A);m=w(N);u=i.e=m.length-v.e-1;i.c[0]=c[(a=u%l)<0?l+a:a];e=!e||h.comparedTo(i)>0?u>0?i:p:h;a=D;D=1/0;h=new M(m);g.c[0]=0;for(;;){d=r(h,i,0,1);o=t.plus(d.times(s));if(o.comparedTo(e)==1)break;t=s;s=o;p=g.plus(d.times(o=p));g=o;i=h.minus(d.times(o=i));h=o}o=r(e.minus(t),s,0,1);g=g.plus(o.times(p));t=t.plus(o.times(s));g.s=p.s=v.s;u*=2;n=r(p,s,u,P).minus(v).abs().comparedTo(r(g,t,u,P).minus(v).abs())<1?[p.toString(),s.toString()]:[g.toString(),t.toString()];D=a;return n};E.toNumber=function(){return+this};E.exponentiatedBy=E.pow=function(e,r){var n,f,s,o,c=this;m(e,-u,u);if(r!=null)r=new M(r);if(r){if(e>1&&c.gt(A)&&c.isInteger()&&r.gt(A)&&r.isInteger()){c=c.mod(r)}else{o=r;r=null}}else if(B){f=i(B/l+2)}s=new M(A);for(n=t(e<0?-e:e);;){if(n%2){s=s.times(c);if(!s.c)break;if(f){if(s.c.length>f)s.c.length=f}else if(r){s=s.mod(r)}}n=t(n/2);if(!n)break;c=c.times(c);if(f){if(c.c&&c.c.length>f)c.c.length=f}else if(r){c=c.mod(r)}}if(r)return s;if(e<0)s=A.div(s);return o?s.mod(o):f?G(s,B,P):s};E.toPrecision=function(e,r){if(e!=null)m(e,1,h);return U(this,e,r,2)};E.toString=function(e){var r,n=this,i=n.s,t=n.e;if(t===null){if(i){r="Infinity";if(i<0)r="-"+r}else{r="NaN"}}else{r=w(n.c);if(e==null){r=t<=S||t>=_?N(r,t):O(r,t,"0")}else{m(e,2,C.length,"Base");r=y(O(r,t,"0"),10,e,i,true)}if(i<0&&n.c[0])r="-"+r}return r};E.valueOf=E.toJSON=function(){var e,r=this,n=r.e;if(n===null)return r.toString();e=w(r.c);e=n<=S||n>=_?N(e,n):O(e,n,"0");return r.s<0?"-"+e:e};E._isBigNumber=true;if(e!=null)M.set(e);return M}function p(e){var r=e|0;return e>0||e===r?r:r-1}function w(e){var r,n,i=1,t=e.length,f=e[0]+"";for(;i<t;){r=e[i++]+"";n=l-r.length;for(;n--;r="0"+r);f+=r}for(t=f.length;f.charCodeAt(--t)===48;);return f.slice(0,t+1||1)}function d(e,r){var n,i,t=e.c,f=r.c,s=e.s,o=r.s,l=e.e,u=r.e;if(!s||!o)return null;n=t&&!t[0];i=f&&!f[0];if(n||i)return n?i?0:-o:s;if(s!=o)return s;n=s<0;i=l==u;if(!t||!f)return i?0:!t^n?1:-1;if(!i)return l>u^n?1:-1;o=(l=t.length)<(u=f.length)?l:u;for(s=0;s<o;s++)if(t[s]!=f[s])return t[s]>f[s]^n?1:-1;return l==u?0:l>u^n?1:-1}function m(e,r,n,s){if(e<r||e>n||e!==(e<0?i(e):t(e))){throw Error(f+(s||"Argument")+(typeof e=="number"?e<r||e>n?" out of range: ":" not an integer: ":" not a primitive number: ")+e)}}function v(e){return Object.prototype.toString.call(e)=="[object Array]"}function N(e,r){return(e.length>1?e.charAt(0)+"."+e.slice(1):e)+(r<0?"e":"e+")+r}function O(e,r,n){var i,t;if(r<0){for(t=n+".";++r;t+=n);e=t+e}else{i=e.length;if(++r>i){for(t=n,r-=i;--r;t+=n);e+=t}else if(r<i){e=e.slice(0,r)+"."+e.slice(r)}}return e}r=g();r["default"]=r.BigNumber=r;if(typeof define=="function"&&define.amd){define(function(){return r})}else if(typeof module!="undefined"&&module.exports){module.exports=r}else{if(!e){e=typeof self!="undefined"?self:Function("return this")()}e.BigNumber=r}})(this);
//# sourceMappingURL=bignumber.js.map