/*!
 * jQuery UI Draggable 1.10.4
 * http://jqueryui.com
 *
 * Copyright 2014 jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 *
 * http://api.jqueryui.com/draggable/
 *
 * Depends:
 *	jquery.ui.core.js
 *	jquery.ui.mouse.js
 *	jquery.ui.widget.js
 */
(function(t,e){t.widget("ui.draggable",t.ui.mouse,{version:"1.10.4",widgetEventPrefix:"drag",options:{addClasses:true,appendTo:"parent",axis:false,connectToSortable:false,containment:false,cursor:"auto",cursorAt:false,grid:false,handle:false,helper:"original",iframeFix:false,opacity:false,refreshPositions:false,revert:false,revertDuration:500,scope:"default",scroll:true,scrollSensitivity:20,scrollSpeed:20,snap:false,snapMode:"both",snapTolerance:20,stack:false,zIndex:false,drag:null,start:null,stop:null},_create:function(){if(this.options.helper==="original"&&!/^(?:r|a|f)/.test(this.element.css("position"))){this.element[0].style.position="relative"}if(this.options.addClasses){this.element.addClass("ui-draggable")}if(this.options.disabled){this.element.addClass("ui-draggable-disabled")}this._mouseInit()},_destroy:function(){this.element.removeClass("ui-draggable ui-draggable-dragging ui-draggable-disabled");this._mouseDestroy()},_mouseCapture:function(e){var i=this.options;if(this.helper||i.disabled||t(e.target).closest(".ui-resizable-handle").length>0){return false}this.handle=this._getHandle(e);if(!this.handle){return false}t(i.iframeFix===true?"iframe":i.iframeFix).each(function(){t("<div class='ui-draggable-iframeFix'></div>").css({background:"#fff",width:this.offsetWidth+"px",height:this.offsetHeight+"px",position:"absolute",opacity:"0.001",zIndex:1e3}).css(t(this).offset()).appendTo("body")});return true},_mouseStart:function(e){var i=this.options;this.helper=this._createHelper(e);this.helper.addClass("ui-draggable-dragging");this._cacheHelperProportions();if(t.ui.ddmanager){t.ui.ddmanager.current=this}this._cacheMargins();this.cssPosition=this.helper.css("position");this.scrollParent=this.helper.scrollParent();this.offsetParent=this.helper.offsetParent();this.offsetParentCssPosition=this.offsetParent.css("position");this.offset=this.positionAbs=this.element.offset();this.offset={top:this.offset.top-this.margins.top,left:this.offset.left-this.margins.left};this.offset.scroll=false;t.extend(this.offset,{click:{left:e.pageX-this.offset.left,top:e.pageY-this.offset.top},parent:this._getParentOffset(),relative:this._getRelativeOffset()});this.originalPosition=this.position=this._generatePosition(e);this.originalPageX=e.pageX;this.originalPageY=e.pageY;i.cursorAt&&this._adjustOffsetFromHelper(i.cursorAt);this._setContainment();if(this._trigger("start",e)===false){this._clear();return false}this._cacheHelperProportions();if(t.ui.ddmanager&&!i.dropBehaviour){t.ui.ddmanager.prepareOffsets(this,e)}this._mouseDrag(e,true);if(t.ui.ddmanager){t.ui.ddmanager.dragStart(this,e)}return true},_mouseDrag:function(e,i){if(this.offsetParentCssPosition==="fixed"){this.offset.parent=this._getParentOffset()}this.position=this._generatePosition(e);this.positionAbs=this._convertPositionTo("absolute");if(!i){var s=this._uiHash();if(this._trigger("drag",e,s)===false){this._mouseUp({});return false}this.position=s.position}if(!this.options.axis||this.options.axis!=="y"){this.helper[0].style.left=this.position.left+"px"}if(!this.options.axis||this.options.axis!=="x"){this.helper[0].style.top=this.position.top+"px"}if(t.ui.ddmanager){t.ui.ddmanager.drag(this,e)}return false},_mouseStop:function(e){var i=this,s=false;if(t.ui.ddmanager&&!this.options.dropBehaviour){s=t.ui.ddmanager.drop(this,e)}if(this.dropped){s=this.dropped;this.dropped=false}if(this.options.helper==="original"&&!t.contains(this.element[0].ownerDocument,this.element[0])){return false}if(this.options.revert==="invalid"&&!s||this.options.revert==="valid"&&s||this.options.revert===true||typeof this.options.revert==="function"&&this.options.revert.call(this.element,s)){t(this.helper).animate(this.originalPosition,parseInt(this.options.revertDuration,10),function(){if(i._trigger("stop",e)!==false){i._clear()}})}else{if(this._trigger("stop",e)!==false){this._clear()}}return false},_mouseUp:function(e){t("div.ui-draggable-iframeFix").each(function(){this.parentNode.removeChild(this)});if(t.ui.ddmanager){t.ui.ddmanager.dragStop(this,e)}return t.ui.mouse.prototype._mouseUp.call(this,e)},cancel:function(){if(this.helper.is(".ui-draggable-dragging")){this._mouseUp({})}else{this._clear()}return this},_getHandle:function(e){return this.options.handle?!!t(e.target).closest(this.element.find(this.options.handle)).length:true},_createHelper:function(e){var i=this.options,s=typeof i.helper==="function"?t(i.helper.apply(this.element[0],[e])):i.helper==="clone"?this.element.clone().removeAttr("id"):this.element;if(!s.parents("body").length){s.appendTo(i.appendTo==="parent"?this.element[0].parentNode:i.appendTo)}if(s[0]!==this.element[0]&&!/(fixed|absolute)/.test(s.css("position"))){s.css("position","absolute")}return s},_adjustOffsetFromHelper:function(e){if(typeof e==="string"){e=e.split(" ")}if(t.isArray(e)){e={left:+e[0],top:+e[1]||0}}if("left"in e){this.offset.click.left=e.left+this.margins.left}if("right"in e){this.offset.click.left=this.helperProportions.width-e.right+this.margins.left}if("top"in e){this.offset.click.top=e.top+this.margins.top}if("bottom"in e){this.offset.click.top=this.helperProportions.height-e.bottom+this.margins.top}},_getParentOffset:function(){var e=this.offsetParent.offset();if(this.cssPosition==="absolute"&&this.scrollParent[0]!==document&&t.contains(this.scrollParent[0],this.offsetParent[0])){e.left+=this.scrollParent.scrollLeft();e.top+=this.scrollParent.scrollTop()}if(this.offsetParent[0]===document.body||this.offsetParent[0].tagName&&this.offsetParent[0].tagName.toLowerCase()==="html"&&t.ui.ie){e={top:0,left:0}}return{top:e.top+(parseInt(this.offsetParent.css("borderTopWidth"),10)||0),left:e.left+(parseInt(this.offsetParent.css("borderLeftWidth"),10)||0)}},_getRelativeOffset:function(){if(this.cssPosition==="relative"){var t=this.element.position();return{top:t.top-(parseInt(this.helper.css("top"),10)||0)+this.scrollParent.scrollTop(),left:t.left-(parseInt(this.helper.css("left"),10)||0)+this.scrollParent.scrollLeft()}}else{return{top:0,left:0}}},_cacheMargins:function(){this.margins={left:parseInt(this.element.css("marginLeft"),10)||0,top:parseInt(this.element.css("marginTop"),10)||0,right:parseInt(this.element.css("marginRight"),10)||0,bottom:parseInt(this.element.css("marginBottom"),10)||0}},_cacheHelperProportions:function(){this.helperProportions={width:this.helper.outerWidth(),height:this.helper.outerHeight()}},_setContainment:function(){var e,i,s,o=this.options;if(!o.containment){this.containment=null;return}if(o.containment==="window"){this.containment=[t(window).scrollLeft()-this.offset.relative.left-this.offset.parent.left,t(window).scrollTop()-this.offset.relative.top-this.offset.parent.top,t(window).scrollLeft()+t(window).width()-this.helperProportions.width-this.margins.left,t(window).scrollTop()+(t(window).height()||document.body.parentNode.scrollHeight)-this.helperProportions.height-this.margins.top];return}if(o.containment==="document"){this.containment=[0,0,t(document).width()-this.helperProportions.width-this.margins.left,(t(document).height()||document.body.parentNode.scrollHeight)-this.helperProportions.height-this.margins.top];return}if(o.containment.constructor===Array){this.containment=o.containment;return}if(o.containment==="parent"){o.containment=this.helper[0].parentNode}i=t(o.containment);s=i[0];if(!s){return}e=i.css("overflow")!=="hidden";this.containment=[(parseInt(i.css("borderLeftWidth"),10)||0)+(parseInt(i.css("paddingLeft"),10)||0),(parseInt(i.css("borderTopWidth"),10)||0)+(parseInt(i.css("paddingTop"),10)||0),(e?Math.max(s.scrollWidth,s.offsetWidth):s.offsetWidth)-(parseInt(i.css("borderRightWidth"),10)||0)-(parseInt(i.css("paddingRight"),10)||0)-this.helperProportions.width-this.margins.left-this.margins.right,(e?Math.max(s.scrollHeight,s.offsetHeight):s.offsetHeight)-(parseInt(i.css("borderBottomWidth"),10)||0)-(parseInt(i.css("paddingBottom"),10)||0)-this.helperProportions.height-this.margins.top-this.margins.bottom];this.relative_container=i},_convertPositionTo:function(e,i){if(!i){i=this.position}var s=e==="absolute"?1:-1,o=this.cssPosition==="absolute"&&!(this.scrollParent[0]!==document&&t.contains(this.scrollParent[0],this.offsetParent[0]))?this.offsetParent:this.scrollParent;if(!this.offset.scroll){this.offset.scroll={top:o.scrollTop(),left:o.scrollLeft()}}return{top:i.top+this.offset.relative.top*s+this.offset.parent.top*s-(this.cssPosition==="fixed"?-this.scrollParent.scrollTop():this.offset.scroll.top)*s,left:i.left+this.offset.relative.left*s+this.offset.parent.left*s-(this.cssPosition==="fixed"?-this.scrollParent.scrollLeft():this.offset.scroll.left)*s}},_generatePosition:function(e){var i,s,o,n,r=this.options,a=this.cssPosition==="absolute"&&!(this.scrollParent[0]!==document&&t.contains(this.scrollParent[0],this.offsetParent[0]))?this.offsetParent:this.scrollParent,l=e.pageX,f=e.pageY;if(!this.offset.scroll){this.offset.scroll={top:a.scrollTop(),left:a.scrollLeft()}}if(this.originalPosition){if(this.containment){if(this.relative_container){s=this.relative_container.offset();i=[this.containment[0]+s.left,this.containment[1]+s.top,this.containment[2]+s.left,this.containment[3]+s.top]}else{i=this.containment}if(e.pageX-this.offset.click.left<i[0]){l=i[0]+this.offset.click.left}if(e.pageY-this.offset.click.top<i[1]){f=i[1]+this.offset.click.top}if(e.pageX-this.offset.click.left>i[2]){l=i[2]+this.offset.click.left}if(e.pageY-this.offset.click.top>i[3]){f=i[3]+this.offset.click.top}}if(r.grid){o=r.grid[1]?this.originalPageY+Math.round((f-this.originalPageY)/r.grid[1])*r.grid[1]:this.originalPageY;f=i?o-this.offset.click.top>=i[1]||o-this.offset.click.top>i[3]?o:o-this.offset.click.top>=i[1]?o-r.grid[1]:o+r.grid[1]:o;n=r.grid[0]?this.originalPageX+Math.round((l-this.originalPageX)/r.grid[0])*r.grid[0]:this.originalPageX;l=i?n-this.offset.click.left>=i[0]||n-this.offset.click.left>i[2]?n:n-this.offset.click.left>=i[0]?n-r.grid[0]:n+r.grid[0]:n}}return{top:f-this.offset.click.top-this.offset.relative.top-this.offset.parent.top+(this.cssPosition==="fixed"?-this.scrollParent.scrollTop():this.offset.scroll.top),left:l-this.offset.click.left-this.offset.relative.left-this.offset.parent.left+(this.cssPosition==="fixed"?-this.scrollParent.scrollLeft():this.offset.scroll.left)}},_clear:function(){this.helper.removeClass("ui-draggable-dragging");if(this.helper[0]!==this.element[0]&&!this.cancelHelperRemoval){this.helper.remove()}this.helper=null;this.cancelHelperRemoval=false},_trigger:function(e,i,s){s=s||this._uiHash();t.ui.plugin.call(this,e,[i,s]);if(e==="drag"){this.positionAbs=this._convertPositionTo("absolute")}return t.Widget.prototype._trigger.call(this,e,i,s)},plugins:{},_uiHash:function(){return{helper:this.helper,position:this.position,originalPosition:this.originalPosition,offset:this.positionAbs}}});t.ui.plugin.add("draggable","connectToSortable",{start:function(e,i){var s=t(this).data("ui-draggable"),o=s.options,n=t.extend({},i,{item:s.element});s.sortables=[];t(o.connectToSortable).each(function(){var i=t.data(this,"ui-sortable");if(i&&!i.options.disabled){s.sortables.push({instance:i,shouldRevert:i.options.revert});i.refreshPositions();i._trigger("activate",e,n)}})},stop:function(e,i){var s=t(this).data("ui-draggable"),o=t.extend({},i,{item:s.element});t.each(s.sortables,function(){if(this.instance.isOver){this.instance.isOver=0;s.cancelHelperRemoval=true;this.instance.cancelHelperRemoval=false;if(this.shouldRevert){this.instance.options.revert=this.shouldRevert}this.instance._mouseStop(e);this.instance.options.helper=this.instance.options._helper;if(s.options.helper==="original"){this.instance.currentItem.css({top:"auto",left:"auto"})}}else{this.instance.cancelHelperRemoval=false;this.instance._trigger("deactivate",e,o)}})},drag:function(e,i){var s=t(this).data("ui-draggable"),o=this;t.each(s.sortables,function(){var n=false,r=this;this.instance.positionAbs=s.positionAbs;this.instance.helperProportions=s.helperProportions;this.instance.offset.click=s.offset.click;if(this.instance._intersectsWith(this.instance.containerCache)){n=true;t.each(s.sortables,function(){this.instance.positionAbs=s.positionAbs;this.instance.helperProportions=s.helperProportions;this.instance.offset.click=s.offset.click;if(this!==r&&this.instance._intersectsWith(this.instance.containerCache)&&t.contains(r.instance.element[0],this.instance.element[0])){n=false}return n})}if(n){if(!this.instance.isOver){this.instance.isOver=1;this.instance.currentItem=t(o).clone().removeAttr("id").appendTo(this.instance.element).data("ui-sortable-item",true);this.instance.options._helper=this.instance.options.helper;this.instance.options.helper=function(){return i.helper[0]};e.target=this.instance.currentItem[0];this.instance._mouseCapture(e,true);this.instance._mouseStart(e,true,true);this.instance.offset.click.top=s.offset.click.top;this.instance.offset.click.left=s.offset.click.left;this.instance.offset.parent.left-=s.offset.parent.left-this.instance.offset.parent.left;this.instance.offset.parent.top-=s.offset.parent.top-this.instance.offset.parent.top;s._trigger("toSortable",e);s.dropped=this.instance.element;s.currentItem=s.element;this.instance.fromOutside=s}if(this.instance.currentItem){this.instance._mouseDrag(e)}}else{if(this.instance.isOver){this.instance.isOver=0;this.instance.cancelHelperRemoval=true;this.instance.options.revert=false;this.instance._trigger("out",e,this.instance._uiHash(this.instance));this.instance._mouseStop(e,true);this.instance.options.helper=this.instance.options._helper;this.instance.currentItem.remove();if(this.instance.placeholder){this.instance.placeholder.remove()}s._trigger("fromSortable",e);s.dropped=false}}})}});t.ui.plugin.add("draggable","cursor",{start:function(){var e=t("body"),i=t(this).data("ui-draggable").options;if(e.css("cursor")){i._cursor=e.css("cursor")}e.css("cursor",i.cursor)},stop:function(){var e=t(this).data("ui-draggable").options;if(e._cursor){t("body").css("cursor",e._cursor)}}});t.ui.plugin.add("draggable","opacity",{start:function(e,i){var s=t(i.helper),o=t(this).data("ui-draggable").options;if(s.css("opacity")){o._opacity=s.css("opacity")}s.css("opacity",o.opacity)},stop:function(e,i){var s=t(this).data("ui-draggable").options;if(s._opacity){t(i.helper).css("opacity",s._opacity)}}});t.ui.plugin.add("draggable","scroll",{start:function(){var e=t(this).data("ui-draggable");if(e.scrollParent[0]!==document&&e.scrollParent[0].tagName!=="HTML"){e.overflowOffset=e.scrollParent.offset()}},drag:function(e){var i=t(this).data("ui-draggable"),s=i.options,o=false;if(i.scrollParent[0]!==document&&i.scrollParent[0].tagName!=="HTML"){if(!s.axis||s.axis!=="x"){if(i.overflowOffset.top+i.scrollParent[0].offsetHeight-e.pageY<s.scrollSensitivity){i.scrollParent[0].scrollTop=o=i.scrollParent[0].scrollTop+s.scrollSpeed}else if(e.pageY-i.overflowOffset.top<s.scrollSensitivity){i.scrollParent[0].scrollTop=o=i.scrollParent[0].scrollTop-s.scrollSpeed}}if(!s.axis||s.axis!=="y"){if(i.overflowOffset.left+i.scrollParent[0].offsetWidth-e.pageX<s.scrollSensitivity){i.scrollParent[0].scrollLeft=o=i.scrollParent[0].scrollLeft+s.scrollSpeed}else if(e.pageX-i.overflowOffset.left<s.scrollSensitivity){i.scrollParent[0].scrollLeft=o=i.scrollParent[0].scrollLeft-s.scrollSpeed}}}else{if(!s.axis||s.axis!=="x"){if(e.pageY-t(document).scrollTop()<s.scrollSensitivity){o=t(document).scrollTop(t(document).scrollTop()-s.scrollSpeed)}else if(t(window).height()-(e.pageY-t(document).scrollTop())<s.scrollSensitivity){o=t(document).scrollTop(t(document).scrollTop()+s.scrollSpeed)}}if(!s.axis||s.axis!=="y"){if(e.pageX-t(document).scrollLeft()<s.scrollSensitivity){o=t(document).scrollLeft(t(document).scrollLeft()-s.scrollSpeed)}else if(t(window).width()-(e.pageX-t(document).scrollLeft())<s.scrollSensitivity){o=t(document).scrollLeft(t(document).scrollLeft()+s.scrollSpeed)}}}if(o!==false&&t.ui.ddmanager&&!s.dropBehaviour){t.ui.ddmanager.prepareOffsets(i,e)}}});t.ui.plugin.add("draggable","snap",{start:function(){var e=t(this).data("ui-draggable"),i=e.options;e.snapElements=[];t(i.snap.constructor!==String?i.snap.items||":data(ui-draggable)":i.snap).each(function(){var i=t(this),s=i.offset();if(this!==e.element[0]){e.snapElements.push({item:this,width:i.outerWidth(),height:i.outerHeight(),top:s.top,left:s.left})}})},drag:function(e,i){var s,o,n,r,a,l,f,h,c,p,d=t(this).data("ui-draggable"),g=d.options,u=g.snapTolerance,m=i.offset.left,v=m+d.helperProportions.width,P=i.offset.top,b=P+d.helperProportions.height;for(c=d.snapElements.length-1;c>=0;c--){a=d.snapElements[c].left;l=a+d.snapElements[c].width;f=d.snapElements[c].top;h=f+d.snapElements[c].height;if(v<a-u||m>l+u||b<f-u||P>h+u||!t.contains(d.snapElements[c].item.ownerDocument,d.snapElements[c].item)){if(d.snapElements[c].snapping){d.options.snap.release&&d.options.snap.release.call(d.element,e,t.extend(d._uiHash(),{snapItem:d.snapElements[c].item}))}d.snapElements[c].snapping=false;continue}if(g.snapMode!=="inner"){s=Math.abs(f-b)<=u;o=Math.abs(h-P)<=u;n=Math.abs(a-v)<=u;r=Math.abs(l-m)<=u;if(s){i.position.top=d._convertPositionTo("relative",{top:f-d.helperProportions.height,left:0}).top-d.margins.top}if(o){i.position.top=d._convertPositionTo("relative",{top:h,left:0}).top-d.margins.top}if(n){i.position.left=d._convertPositionTo("relative",{top:0,left:a-d.helperProportions.width}).left-d.margins.left}if(r){i.position.left=d._convertPositionTo("relative",{top:0,left:l}).left-d.margins.left}}p=s||o||n||r;if(g.snapMode!=="outer"){s=Math.abs(f-P)<=u;o=Math.abs(h-b)<=u;n=Math.abs(a-m)<=u;r=Math.abs(l-v)<=u;if(s){i.position.top=d._convertPositionTo("relative",{top:f,left:0}).top-d.margins.top}if(o){i.position.top=d._convertPositionTo("relative",{top:h-d.helperProportions.height,left:0}).top-d.margins.top}if(n){i.position.left=d._convertPositionTo("relative",{top:0,left:a}).left-d.margins.left}if(r){i.position.left=d._convertPositionTo("relative",{top:0,left:l-d.helperProportions.width}).left-d.margins.left}}if(!d.snapElements[c].snapping&&(s||o||n||r||p)){d.options.snap.snap&&d.options.snap.snap.call(d.element,e,t.extend(d._uiHash(),{snapItem:d.snapElements[c].item}))}d.snapElements[c].snapping=s||o||n||r||p}}});t.ui.plugin.add("draggable","stack",{start:function(){var e,i=this.data("ui-draggable").options,s=t.makeArray(t(i.stack)).sort(function(e,i){return(parseInt(t(e).css("zIndex"),10)||0)-(parseInt(t(i).css("zIndex"),10)||0)});if(!s.length){return}e=parseInt(t(s[0]).css("zIndex"),10)||0;t(s).each(function(i){t(this).css("zIndex",e+i)});this.css("zIndex",e+s.length)}});t.ui.plugin.add("draggable","zIndex",{start:function(e,i){var s=t(i.helper),o=t(this).data("ui-draggable").options;if(s.css("zIndex")){o._zIndex=s.css("zIndex")}s.css("zIndex",o.zIndex)},stop:function(e,i){var s=t(this).data("ui-draggable").options;if(s._zIndex){t(i.helper).css("zIndex",s._zIndex)}}})})(jQuery);
//# sourceMappingURL=jquery-ui-draggable.js.map