/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/i18n/Formatting","sap/base/i18n/Localization","sap/base/i18n/date/CalendarType","sap/ui/core/Control","sap/ui/core/Element","sap/ui/core/LocaleData","sap/ui/unified/calendar/CalendarUtils","sap/ui/unified/DateTypeRange","./calendar/Header","./calendar/Month","./calendar/MonthPicker","./calendar/YearPicker","./calendar/YearRangePicker","./calendar/CalendarDate","sap/ui/core/date/UniversalDate","sap/ui/core/date/UI5Date","./library","sap/ui/Device","sap/ui/core/format/DateFormat","sap/ui/core/ResizeHandler","sap/ui/core/Locale","sap/ui/events/KeyCodes","./CalendarRenderer","sap/ui/dom/containsOrEquals","sap/base/util/deepEqual","sap/base/Log","sap/base/i18n/date/CalendarWeekNumbering"],function(e,t,a,i,r,s,n,o,h,g,l,d,u,c,_,p,f,D,y,m,M,P,v,S,C,T,k){"use strict";var b=i.extend("sap.ui.unified.Calendar",{metadata:{library:"sap.ui.unified",designtime:"sap/ui/unified/designtime/Calendar.designtime",properties:{intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},months:{type:"int",group:"Appearance",defaultValue:1},firstDayOfWeek:{type:"int",group:"Appearance",defaultValue:-1},nonWorkingDays:{type:"int[]",group:"Appearance",defaultValue:null},primaryCalendarType:{type:"sap.base.i18n.date.CalendarType",group:"Appearance"},secondaryCalendarType:{type:"sap.base.i18n.date.CalendarType",group:"Appearance"},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null},showWeekNumbers:{type:"boolean",group:"Appearance",defaultValue:true},showCurrentDateButton:{type:"boolean",group:"Behavior",defaultValue:false},_currentPicker:{type:"string",group:"Appearance",visibility:"hidden"},calendarWeekNumbering:{type:"sap.base.i18n.date.CalendarWeekNumbering",group:"Appearance",defaultValue:null},initialFocusedDate:{type:"object",group:"Data",defaultValue:null}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},disabledDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"disabledDate"},header:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},secondMonthHeader:{type:"sap.ui.unified.calendar.Header",multiple:false,visibility:"hidden"},month:{type:"sap.ui.unified.calendar.Month",multiple:true,visibility:"hidden"},monthPicker:{type:"sap.ui.unified.calendar.MonthPicker",multiple:false,visibility:"hidden"},yearPicker:{type:"sap.ui.unified.calendar.YearPicker",multiple:false,visibility:"hidden"},yearRangePicker:{type:"sap.ui.unified.calendar.YearPicker",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},cancel:{},startDateChange:{},weekNumberSelect:{allowPreventDefault:true,parameters:{weekNumber:{type:"int"},weekDays:{type:"sap.ui.unified.DateRange"}}}}},renderer:v});var Y={MONTH:"month",MONTH_PICKER:"monthPicker",YEAR_PICKER:"yearPicker",YEAR_RANGE_PICKER:"yearRangePicker"};b.prototype.init=function(){this._iBreakPointTablet=D.media._predefinedRangeSets[D.media.RANGESETS.SAP_STANDARD_EXTENDED].points[0];this._iBreakPointDesktop=D.media._predefinedRangeSets[D.media.RANGESETS.SAP_STANDARD_EXTENDED].points[1];this._iBreakPointLargeDesktop=D.media._predefinedRangeSets[D.media.RANGESETS.SAP_STANDARD_EXTENDED].points[2];this._iColumns=1;this.setProperty("_currentPicker",Y.MONTH_PICKER);this._oYearFormat=y.getDateInstance({format:"y",calendarType:this._getPrimaryCalendarType()});this.data("sap-ui-fastnavgroup","true",true);this._oMinDate=n._minDate(this._getPrimaryCalendarType());this._oMaxDate=n._maxDate(this._getPrimaryCalendarType());this._initializeHeader();this._initializeSecondMonthHeader();var e=this._createMonth(this.getId()+"--Month0");e.attachEvent("focus",this._handleFocus,this);e.attachEvent("select",L,this);e.attachEvent("_renderMonth",F,this);e.attachEvent("_bindMousemove",I,this);e.attachEvent("_unbindMousemove",N,this);e._bNoThemeChange=true;this.addAggregation("month",e);this._initializeMonthPicker();this._initializeYearPicker();this._initializeYearRangePicker();this._resizeProxy=w.bind(this);this._oSelectedMonth;this._bSkipCancelButtonRendering=false;this._bActionTriggeredFromSecondHeader=false};b.prototype.exit=function(){if(this._sInvalidateMonth){clearTimeout(this._sInvalidateMonth)}if(this._afterHeaderRenderAdjustCSS){this.removeDelegate(this._afterHeaderRenderAdjustCSS);this._afterHeaderRenderAdjustCSS=null}if(this._afterSecondHeaderRenderAdjustCSS){this.removeDelegate(this._afterSecondHeaderRenderAdjustCSS);this._afterSecondHeaderRenderAdjustCSS=null}if(this._sResizeListener){m.deregister(this._sResizeListener);this._sResizeListener=undefined}this._oSelectedMonth=null};b.prototype._initializeHeader=function(){var e=new h(this.getId()+"--Head");e.attachEvent("pressPrevious",this._handlePrevious,this);e.attachEvent("pressNext",this._handleNext,this);e.attachEvent("pressCurrentDate",this._handleCurrentDate,this);e.attachEvent("pressButton1",this._handleButton1,this);e.attachEvent("pressButton2",this._handleButton2,this);e.attachEvent("pressButton3",this._handleButton1,this);e.attachEvent("pressButton4",this._handleButton2,this);this._afterHeaderRenderAdjustCSS=this._createOnAfterRenderingDelegate(e);e.addDelegate(this._afterHeaderRenderAdjustCSS);this.setAggregation("header",e)};b.prototype._createOnAfterRenderingDelegate=function(e){return{onAfterRendering:function(){if(e.getVisible()&&!e.getVisibleButton1()){e.$().find(".sapUiCalHeadB2").addClass("sapUiCalSingleYearButton")}if(e.getVisible()&&!e._getVisibleButton3()){this._isTwoMonthsInTwoColumns()&&e.$().find(".sapUiCalHeadB4").addClass("sapUiCalSingleYearButton")}}.bind(this)}};b.prototype._initializeSecondMonthHeader=function(){var e=new h(this.getId()+"--SecondMonthHead",{visible:false});e.addStyleClass("sapUiCalHeadSecondMonth");e.attachEvent("pressPrevious",this._handlePrevious,this);e.attachEvent("pressNext",this._handleNext,this);e.attachEvent("pressButton1",this._handleButton1,this);e.attachEvent("pressButton2",this._handleButton2,this);this._afterSecondHeaderRenderAdjustCSS=this._createOnAfterRenderingDelegate(e);e.addDelegate(this._afterSecondHeaderRenderAdjustCSS);this.setAggregation("secondMonthHeader",e)};b.prototype._initializeMonthPicker=function(){var e=new l(this.getId()+"--MP");e._bCalendar=true;e.attachEvent("select",this._selectMonth,this);e.attachEvent("pageChange",E,this);e._bNoThemeChange=true;this.setAggregation("monthPicker",e);e._setSelectedDatesControlOrigin(this)};b.prototype._initializeYearPicker=function(){var e=new d(this.getId()+"--YP");e._bCalendar=true;e.attachEvent("select",this._selectYear,this);e.attachEvent("pageChange",J,this);this.setAggregation("yearPicker",e);e._setSelectedDatesControlOrigin(this)};b.prototype._initializeYearRangePicker=function(){var e=new u(this.getId()+"--YRP");e.attachEvent("select",this._selectYearRange,this);e.setPrimaryCalendarType(this._getPrimaryCalendarType());this.setAggregation("yearRangePicker",e);e._setSelectedDatesControlOrigin(this)};b.prototype._createMonth=function(e){var t=new g(e,{width:"100%"});this._setMonthCalendarWeekNumbering(t);t._bCalendar=true;t.attachEvent("datehovered",this._handleDateHovered,this);t.attachEvent("weekNumberSelect",this._handleWeekNumberSelect,this);return t};b.prototype._handleWeekNumberSelect=function(e){const t=e.getParameter("weekDays"),a=this.fireWeekNumberSelect({weekNumber:e.getParameter("weekNumber"),weekDays:t}),i=t?.getStartDate()&&t?.getStartDate().getMonth(),r=e.getSource().getDate()&&e.getSource().getDate().getMonth(),s=this.getAggregation("month"),o=c.fromLocalJSDate(s[0].getDate()),h=c.fromLocalJSDate(s[s.length-1].getDate());o.setDate(1);h.setDate(1);h.setMonth(h.getMonth()+1);h.setDate(0);const g=s.length>=2?!n._isBetween(c.fromLocalJSDate(e.getSource().getDate()),o,h,true):i!==r;t&&this._focusDate(c.fromLocalJSDate(t.getStartDate(),this._getPrimaryCalendarType()),g,false,false);if(!a){e.preventDefault()}return this};b.prototype._handleDateHovered=function(e){var t=this.getAggregation("month"),a=e.getParameter("date1"),i=e.getParameter("date2"),r;for(r=0;r<t.length;r++){t[r]._markDatesBetweenStartAndHoveredDate(a,i)}};b.prototype.onBeforeRendering=function(){var e=this.getAggregation("month"),t,a=e[0].getDate(),i=this._getFocusedDate();if(this.getFirstDayOfWeek()!==-1&&this.getCalendarWeekNumbering()!=="Default"){T.warning("Both properties firstDayOfWeek and calendarWeekNumbering should not be used at the same time!")}if(e.length>1&&a){t=c.fromLocalJSDate(a,this._getPrimaryCalendarType())}else if(e.length>1){t=H.call(this,this._getFocusedDate())}else{t=i}for(var r=0;r<e.length;r++){a=new c(t);if(r>0){a.setMonth(a.getMonth()+r,1)}var s=a;if(i.getYear()===a.getYear()&&i.getMonth()===a.getMonth()){s=i}e[r].displayDate(s.toLocalJSDate());e[r].setShowWeekNumbers(this.getShowWeekNumbers())}if(this._getMonthPicker()){this._setDisabledMonths(i.getYear(),this._getMonthPicker())}this._updateHeader(t);this._updateHeadersButtons();this._adjustYearRangeDisplay();this._updateLegendParent();if(this.getInitialFocusedDate()){this._oFocusedDate=c.fromLocalJSDate(this.getInitialFocusedDate(),this._getPrimaryCalendarType())}};b.prototype.onAfterRendering=function(e){if(!this._getSucessorsPickerPopup()){x.call(this)}if(B.call(this)>1||this._bInitMonth){e.size={width:this.getDomRef().offsetWidth};w.call(this,e,true);if(!this._sResizeListener){this._sResizeListener=m.register(this,this._resizeProxy)}this._bInitMonth=undefined}};b.prototype.removeSelectedDate=function(e){this._bDateRangeChanged=true;return this.removeAggregation("selectedDates",e)};b.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var e=this.removeAllAggregation("selectedDates");return e};b.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var e=this.destroyAggregation("selectedDates");return e};b.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var e=this.removeAllAggregation("specialDates");return e};b.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var e=this.destroyAggregation("specialDates");return e};b.prototype._setSpecialDatesControlOrigin=function(e){this._oSpecialDatesControlOrigin=e};b.prototype._getCalendarWeekNumbering=function(){if(this.isPropertyInitial("calendarWeekNumbering")){return}return this.getCalendarWeekNumbering()};b.prototype.getSpecialDates=function(){var e=this.getParent();if(this._oSpecialDatesControlOrigin){return this._oSpecialDatesControlOrigin.getSpecialDates()}if(e&&e.getSpecialDates){return e.getSpecialDates()}else{return this.getAggregation("specialDates",[])}};b.prototype.removeAllDisabledDates=function(){this._bDateRangeChanged=true;var e=this.removeAllAggregation("disabledDates");return e};b.prototype.destroyDisabledDates=function(){this._bDateRangeChanged=true;var e=this.destroyAggregation("disabledDates");return e};b.prototype.setLocale=function(e){if(this._sLocale!=e){this._sLocale=e;this._oLocaleData=undefined;this.invalidate();this._toggleTwoMonthsInColumnsCSS()}return this};b.prototype.getLocale=function(){if(!this._sLocale){this._sLocale=new M(e.getLanguageTag()).toString()}return this._sLocale};b.prototype._getFocusedDate=function(){if(!this._oFocusedDate){A.call(this)}return this._oFocusedDate};b.prototype._setFocusedDate=function(e){n._checkCalendarDate(e);this._oFocusedDate=new c(e,this._getPrimaryCalendarType())};b.prototype.focusDate=function(e){R.call(this,e,false);this._addMonthFocusDelegate();return this};b.prototype.displayDate=function(e){R.call(this,e,true);return this};b.prototype.getStartDate=function(){var e;if(this.getDomRef()){var t=this.getAggregation("month");e=c.fromLocalJSDate(t[0].getDate(),this._getPrimaryCalendarType())}else{e=new c(this._getFocusedDate())}e.setDate(1);return e.toLocalJSDate()};b.prototype.setCalendarWeekNumbering=function(e){var t=this.getAggregation("month");this.setProperty("calendarWeekNumbering",e);for(var a=0;a<t.length;a++){this._setMonthCalendarWeekNumbering(t[a])}return this};b.prototype._setMonthCalendarWeekNumbering=function(e){if(this.isPropertyInitial("calendarWeekNumbering")){return this}return e.setCalendarWeekNumbering(this.getCalendarWeekNumbering())};b.prototype.setMonths=function(e){this._bDateRangeChanged=undefined;this.setProperty("months",e);e=B.call(this);var t=this.getAggregation("month");var a=0;var i;if(t.length<e){for(a=t.length;a<e;a++){i=this._createMonth(this.getId()+"--Month"+a);i.attachEvent("focus",this._handleFocus,this);i.attachEvent("select",L,this);i.attachEvent("_renderMonth",F,this);i.attachEvent("_bindMousemove",I,this);i.attachEvent("_unbindMousemove",N,this);i._bNoThemeChange=true;i.setSecondaryCalendarType(this._getSecondaryCalendarType());this._setMonthCalendarWeekNumbering(i);this.addAggregation("month",i)}this._toggleTwoMonthsInColumnsCSS()}else if(t.length>e){for(a=t.length;a>e;a--){i=this.removeAggregation("month",a-1);i.destroy()}if(e==1){this._bInitMonth=true}this._toggleTwoMonthsInColumnsCSS()}if(e>1&&t[0].getDate()){t[0].setProperty("date",null,true)}t=this.getAggregation("month");t.forEach(t=>t.setProperty("_renderMonthWeeksOnly",e>1));return this};b.prototype.setPrimaryCalendarType=function(e){var t=this.getAggregation("month"),a,i,r,s,n;this.setProperty("primaryCalendarType",e);this._oYearFormat=y.getDateInstance({format:"y",calendarType:e});if(this._oFocusedDate){this._oFocusedDate=new c(this._oFocusedDate,e)}this._oMinDate=new c(this._oMinDate,e);this._oMaxDate=new c(this._oMaxDate,e);for(n=0;n<t.length;n++){a=t[n];a.setPrimaryCalendarType(e)}if(!this._getSucessorsPickerPopup()){i=this._getMonthPicker();i.setPrimaryCalendarType(e);r=this._getYearPicker();r.setPrimaryCalendarType(e);s=this.getAggregation("yearRangePicker");s.setPrimaryCalendarType(e)}return this};b.prototype.setSecondaryCalendarType=function(e){var t=e?2:3,a=this._getMonthPicker();this.setProperty("secondaryCalendarType",e);this._oYearFormatSecondary=y.getDateInstance({format:"y",calendarType:e});var i=this.getAggregation("month");for(var r=0;r<i.length;r++){var s=i[r];s.setSecondaryCalendarType(e)}a.setSecondaryCalendarType(e);a.setColumns(t);this._getYearPicker().setSecondaryCalendarType(e);this._getYearRangePicker().setSecondaryCalendarType(e);return this};b.prototype._getPrimaryCalendarType=function(){return this.getProperty("primaryCalendarType")||e.getCalendarType()};b.prototype._getSecondaryCalendarType=function(){var e=this.getSecondaryCalendarType();if(e===this._getPrimaryCalendarType()){return undefined}return e};b.prototype._getActiveHeaderAggregation=function(){if(this._bActionTriggeredFromSecondHeader&&this._isTwoMonthsInOneColumn()){return this.getAggregation("secondMonthHeader")}else{return this.getAggregation("header")}};b.prototype._saveTriggeredHeader=function(e){if(e.getSource().sParentAggregationName==="secondMonthHeader"||e.sId==="pressButton3"||e.sId==="pressButton4"){this._bActionTriggeredFromSecondHeader=true}else{this._bActionTriggeredFromSecondHeader=false}};b.prototype.setMinDate=function(e){var t=this.getAggregation("month"),a=this._getPrimaryCalendarType(),i;if(C(e,this.getMinDate())){return this}if(!e){this._oMinDate=n._minDate(a)}else{n._checkJSDateObject(e);this._oMinDate=c.fromLocalJSDate(e,a);var r=this._oMinDate.getYear();n._checkYearInValidRange(r,a);if(this._oMaxDate.isBefore(this._oMinDate)){T.warning("minDate > maxDate -> maxDate set to end of the month",this);this._oMaxDate=c.fromLocalJSDate(e,a);this._oMaxDate.setDate(n._daysInMonth(this._oMaxDate));this.setProperty("maxDate",this._oMaxDate.toLocalJSDate(),true)}this._setMinMaxDateExtend(c.fromLocalJSDate(e,a))}this.setProperty("minDate",e,false);if(!this._getSucessorsPickerPopup()){i=this._oMinDate.getYear();this._getYearPicker()._oMinDate.setYear(i);this._getYearRangePicker()._oMinDate.setYear(i)}for(var s=0;s<t.length;s++){t[s]._oMinDate=new c(this._oMinDate)}return this};b.prototype.setMaxDate=function(e){var t=this.getAggregation("month"),a=this._getPrimaryCalendarType(),i;if(C(e,this.getMaxDate())){return this}if(!e){this._oMaxDate=n._maxDate(a)}else{n._checkJSDateObject(e);this._oMaxDate=c.fromLocalJSDate(e,a);var r=this._oMaxDate.getYear();n._checkYearInValidRange(r,a);if(this._oMinDate.isAfter(this._oMaxDate)){T.warning("maxDate < minDate -> minDate set to begin of the month",this);this._oMinDate=c.fromLocalJSDate(e,a);this._oMinDate.setDate(1);this.setProperty("minDate",this._oMinDate.toLocalJSDate(),true)}this._setMinMaxDateExtend(c.fromLocalJSDate(e,a))}this.setProperty("maxDate",e,false);if(!this._getSucessorsPickerPopup()){i=this._oMaxDate.getYear();this._getYearPicker()._oMaxDate.setYear(i);this._getYearRangePicker()._oMaxDate.setYear(i)}for(var s=0;s<t.length;s++){t[s]._oMaxDate=new c(this._oMaxDate)}return this};b.prototype.setShowCurrentDateButton=function(e){this.getAggregation("header").setVisibleCurrentDateButton(e);return this.setProperty("showCurrentDateButton",e)};b.prototype.setIntervalSelection=function(e){const t=this._getMonthPicker();if(t){t._setShowSelectedRange(e)}const a=this._getYearPicker();if(a){a._setShowSelectedRange(e)}const i=this._getYearRangePicker();if(i){i._setShowSelectedRange(e)}return this.setProperty("intervalSelection",e)};b.prototype.setSingleSelection=function(e){const t=this._getMonthPicker();if(t){t.setProperty("_singleSelection",e)}const a=this._getYearPicker();if(a){a.setProperty("_singleSelection",e)}const i=this._getYearRangePicker();if(i){i.setProperty("_singleSelection",e)}return this.setProperty("singleSelection",e)};b.prototype._setMinMaxDateExtend=function(e){if(this._oFocusedDate){if(n._isOutside(this._oFocusedDate,this._oMinDate,this._oMaxDate)){T.warning("focused date is not between [minDate - maxDate] -> refocus to the new max/min date: "+e.toString(),this);this.focusDate(e.toLocalJSDate())}}};b.prototype._getLocaleData=function(){if(!this._oLocaleData){var e=this.getLocale();var t=new M(e);this._oLocaleData=s.getInstance(t)}return this._oLocaleData};b.prototype._getShowMonthHeader=function(){var e=B.call(this);if(e>2){return true}else{return false}};b.prototype._getMonthPicker=function(){return this.getAggregation("monthPicker")};b.prototype._getYearPicker=function(){return this.getAggregation("yearPicker")};b.prototype._getYearRangePicker=function(){return this.getAggregation("yearRangePicker")};b.prototype.onclick=function(e){var t=e.target;if(e.isMarked("delayedMouseEvent")){return}if(t.id==this.getId()+"-cancel"){this.onsapescape(e)}};b.prototype.onmousedown=function(e){if(e.cancelable){e.preventDefault()}e.setMark("cancelAutoClose")};b.prototype.onsapescape=function(e){this.fireCancel();this._closePickers();this._addMonthFocusDelegate();if(!this._getSucessorsPickerPopup()){this._setHeaderText(this._getFocusedDate())}};b.prototype.onsapshow=function(e){var t=e.which||e.keyCode;if(this._bPoupupMode&&t!==P.F4){this._closePickers();this._addMonthFocusDelegate();this.fireCancel();e.preventDefault()}};b.prototype.onkeydown=function(e){var t=e.which||e.keyCode,a=e.shiftKey;if(t!==P.F4){return}e.preventDefault();switch(this._iMode){case 0:if(a){this._showYearPicker()}else{this._showMonthPicker()}break;case 1:if(a){this._showYearPicker()}break;case 2:if(a){this._showYearRangePicker()}break;default:}};b.prototype.onsaphide=b.prototype.onsapshow;b.prototype.getFocusDomRef=function(){var e=this._oSelectedMonth?this._oSelectedMonth:this.getAggregation("month")[0],t=this._getMonthPicker(),a=this._getYearPicker(),i=this._getYearRangePicker();switch(this._iMode){case 0:return e.getFocusDomRef();case 1:return t.getFocusDomRef();case 2:return a.getFocusDomRef();case 3:return i.getFocusDomRef();default:return}};b.prototype.onThemeChanged=function(){var e,t=arguments;if(!this.getDomRef()){return}this._bNamesLengthChecked=undefined;if(!this._getSucessorsPickerPopup()){var a={onAfterRendering:function(){e.onThemeChanged(t);e._bNoThemeChange=true;x.call(this);this._bLongMonth=e._bLongMonth;this._closePickers();e.removeEventDelegate(a)}};e=this._getMonthPicker();this._showMonthPicker(true);e._bNoThemeChange=false;e.addEventDelegate(a,this)}var i=this.getAggregation("month");for(var r=0;r<i.length;r++){var s=i[r];s._bNoThemeChange=false;s.onThemeChanged(arguments);s._bNoThemeChange=true}var n;if(i.length>1){n=c.fromLocalJSDate(i[0].getDate(),this._getPrimaryCalendarType())}else{n=this._getFocusedDate()}this._setHeaderText(n);this._setPrimaryHeaderMonthButtonText();this._toggleTwoMonthsInColumnsCSS()};b.prototype._updateLegendParent=function(){var e=this.getLegend(),t=r.getElementById(e);t&&t._setParent(this)};b.prototype._updateHeader=function(e){this._setHeaderText(e);switch(this._iMode){case 0:this._togglePrevNext(e,true);break;case 1:this._togglePrevNext(e,false);break;case 2:case 3:this._togglePrevNexYearPicker();break}};b.prototype._togglePrevNext=function(e,t){var a=this._oMaxDate.getYear();var i=this._oMinDate.getYear();var r=this._oMaxDate.getMonth();var s=this._oMinDate.getMonth();var o=this.getAggregation("header");var h=B.call(this);var g=new c(e,this._getPrimaryCalendarType());if(this._iMode===1&&h>1){g=H.call(this,e);g.setMonth(g.getMonth()+h-1);g.setDate(n._daysInMonth(g))}else{g.setDate(n._daysInMonth(g))}var l=g.getYear();var d=g.getMonth();if((this._iMode===0||this._iMode===1)&&h>1){d+=h-1}if(l>a||l===a&&(!t||d>=r)||(this._iMode===0||this._iMode===1)&&this._getSucessorsPickerPopup()){o.setEnabledNext(false)}else{o.setEnabledNext(true)}if(this._iMode===1&&h>1){g.setMonth(g.getMonth()-h+1,1)}else{g.setDate(1)}l=g.getYear();d=g.getMonth();if(l<i||l==i&&(!t||d<=s)||this._iMode==1&&this._getSucessorsPickerPopup()){o.setEnabledPrevious(false)}else{o.setEnabledPrevious(true)}};b.prototype._togglePrevNexYearPicker=function(){var e=this.getAggregation("yearRangePicker"),t=this._getYearPicker(),a=this._getPrimaryCalendarType(),i=new c(this._oMinDate,a),r=new c(this._oMaxDate,a),s=this.getAggregation("header"),n=1,o,h,g,l;if(this._iMode===3){g=e.getYears();n=e.getRangeSize();o=new c(e.getProperty("_middleDate"));h=new c(o);o.setYear(o.getYear()-n*g/2);h.setYear(h.getYear()+n*g/2-1)}else{g=t.getYears();l=t.getProperty("_middleDate")?t.getProperty("_middleDate"):c.fromLocalJSDate(p.getInstance());o=new c(l);h=new c(l);o.setYear(o.getYear()-g/2);h.setYear(h.getYear()+g/2-1)}s.setEnabledNext(h.getYear()<r.getYear());s.setEnabledPrevious(o.getYear()>i.getYear())};b.prototype._handlePrevious=function(){var e=this._getFocusedDate(),t=B.call(this),a,i=false;switch(this._iMode){case 0:if(t>1){a=c.fromLocalJSDate(this.getAggregation("month")[0].getDate(),this._getPrimaryCalendarType());a.setDate(1);this._setFocusedDate(a);e=this._getFocusedDate()}else{e.setDate(1)}e.setDate(e.getDate()-1);this._renderMonth(i,false);this._addMonthFocusDelegate();break;case 1:e.setYear(e.getYear()-1);this._updateHeadersYearPrimaryText(this._oYearFormat.format(e.toUTCJSDate(),true));this._updateHeadersYearAdditionalTextHelper();this._togglePrevNext(e);this._setDisabledMonths(e.getYear());var r=this._getMonthPicker();r._setYear(e.getYear());r._setDate(e);r.invalidate();this.setProperty("_currentPicker",Y.MONTH_PICKER);break;case 2:this._getYearPicker().previousPage();this._togglePrevNexYearPicker();this._updateHeadersYearPrimaryText(this._getYearString());this._updateHeadersYearAdditionalTextHelper();break;case 3:this.getAggregation("yearRangePicker").previousPage();this._togglePrevNexYearPicker();this._updateHeadersYearPrimaryText(this._getYearString());break}};b.prototype._handleNext=function(){var e=this._getFocusedDate(),t=B.call(this),a;switch(this._iMode){case 0:if(t>1){a=c.fromLocalJSDate(this.getAggregation("month")[0].getDate(),this._getPrimaryCalendarType());a.setMonth(a.getMonth(),1);this._setFocusedDate(a);e=this._getFocusedDate()}e.setMonth(e.getMonth()+1,1);this._renderMonth(false,false);this._addMonthFocusDelegate();break;case 1:e.setYear(e.getYear()+1);this._updateHeadersYearPrimaryText(this._oYearFormat.format(e.toUTCJSDate(),true));this._updateHeadersYearAdditionalTextHelper();this._togglePrevNext(e);this._setDisabledMonths(e.getYear());var i=this._getMonthPicker();i._setYear(e.getYear());i._setDate(e);i.invalidate();this.setProperty("_currentPicker",Y.MONTH_PICKER);break;case 2:this._getYearPicker().nextPage();this._togglePrevNexYearPicker();this._updateHeadersYearPrimaryText(this._getYearString());this._updateHeadersYearAdditionalTextHelper();break;case 3:this.getAggregation("yearRangePicker").nextPage();this._togglePrevNexYearPicker();this._updateHeadersYearPrimaryText(this._getYearString());break}};b.prototype._updateHeadersYearAdditionalTextHelper=function(){if(!this._getSecondaryCalendarType()){return}var e=this._getDisplayedSecondaryYears();if(e.start.getYear()===e.end.getYear()){this._updateHeadersYearAdditionalText(this._oYearFormatSecondary.format(e.start.toUTCJSDate(),true))}else{var t=this._getLocaleData();var a=t.getIntervalPattern();var i=a.replace(/\{0\}/,this._oYearFormatSecondary.format(e.start.toUTCJSDate(),true)).replace(/\{1\}/,this._oYearFormatSecondary.format(e.end.toUTCJSDate(),true));this._updateHeadersYearAdditionalText(i)}};b.prototype._handleCurrentDate=function(){var e=p.getInstance(),t=this.getMaxDate(),a=this.getMinDate();this.setProperty("_currentPicker",Y.MONTH);if(t&&t.getTime()<e.getTime()){this.focusDate(t)}else if(a&&a.getTime()>e.getTime()){this.focusDate(a)}else{this.focusDate(e)}};b.prototype._getYearString=function(){var e=this._getYearPicker(),t=e.getDomRef(),a=this._getFocusedDate();if(e&&t&&t.style.display===""){a=e.getProperty("_middleDate");a.setDate(1)}return this._oYearFormat.format(_.getInstance(a.toUTCJSDate(),a.getCalendarType()),true)};b.prototype._getDisplayedMonths=function(e){var t=[];var a=e.getMonth();var i=B.call(this);if(i>1){for(var r=0;r<i;r++){t.push((a+r)%12)}}else{t.push(a)}return t};b.prototype._getDisplayedSecondaryMonths=function(){var e=this._getPrimaryCalendarType(),t=this._getSecondaryCalendarType(),a=this.getAggregation("month"),i=c.fromLocalJSDate(a[0].getDate(),e),r=c.fromLocalJSDate(a[a.length-1].getDate(),e),s,o;i.setDate(1);i=new c(i,t);s=i.getMonth();r=c.fromLocalJSDate(a[a.length-1].getDate(),e);r.setDate(n._daysInMonth(r));r=new c(r,t);o=r.getMonth();return{start:s,end:o}};b.prototype._getDisplayedSecondaryYears=function(){var e=this._getPrimaryCalendarType(),t=this._getSecondaryCalendarType(),a,i,r,s,o,h,g;switch(this._iMode){case 0:o=this.getAggregation("month");a=c.fromLocalJSDate(o[0].getDate(),e);a.setDate(1);a=new c(a,t);i=c.fromLocalJSDate(o[o.length-1].getDate(),e);i.setDate(n._daysInMonth(i));i=new c(i,t);break;case 1:r=this._getFocusedDate();s=new c(r,e);s.setMonth(0,1);a=new c(s,e);a=new c(a,t);s.setYear(s.getYear()+1);s.setDate(s.getDate()-1);i=new c(s,e);i=new c(i,t);break;case 2:h=this._getYearPicker();g=h.getYears()/2-1;r=h.getProperty("_middleDate");a=new c(r,e);a.setYear(r.getYear()-g-1);a.setMonth(0,1);a=new c(a,t);i=new c(r,e);i.setYear(i.getYear()+g+1);a.setMonth(0,1);i.setDate(i.getDate()-1);i=new c(i,t);break;default:}return{start:a,end:i}};b.prototype._closePickers=function(){this.setProperty("_currentPicker",Y.MONTH);this._togglePrevNext(this._getFocusedDate(),true);if(this.getAggregation("month").length>1){this.getAggregation("month").forEach(function(e){e._oItemNavigation.iActiveTabIndex=0})}};b.prototype._setDisabledMonths=function(e,t){var a=0;var i=11;if(e===this._oMinDate.getYear()){a=this._oMinDate.getMonth()}if(e===this._oMaxDate.getYear()){i=this._oMaxDate.getMonth()}if(!t){t=this._getMonthPicker()}t.setMinMax(a,i)};b.prototype._handleFocus=function(e){var t=c.fromLocalJSDate(e.getParameter("date"),this._getPrimaryCalendarType()),a=e.getParameter("otherMonth"),i=e.getParameter("restoreOldDate");if(this.getIntervalSelection()){this.getAggregation("month").forEach(function(e){e.setProperty("_focusedDate",t)})}if(i){if(!C(this._getFocusedDate(),t)){this._renderMonth(false,true)}}else{this._focusDate(t,a,false,true)}};b.prototype._getVisibleDays=function(){var e=this.getAggregation("month")[0];return e._getVisibleDays(e._getDate(),false)};b.prototype._renderMonth=function(e,t){var a=this._getFocusedDate(),i=this.getAggregation("month"),r,s,o=H.call(this,new c(a,this._getPrimaryCalendarType())),h=0,g=i[0].checkDateFocusable(a.toLocalJSDate()),l=!t&&!g;for(h=0;h<i.length;h++){r=i[h];s=new c(o,this._getPrimaryCalendarType());s.setMonth(o.getMonth()+h);if(!e&&n._isSameMonthAndYear(s,a)){r.setDate(a.toLocalJSDate())}else{r.displayDate(s.toLocalJSDate())}}this._updateHeader(o);this._setPrimaryHeaderMonthButtonText();this._toggleTwoMonthsInColumnsCSS();if(l){this.fireStartDateChange()}};b.prototype._updateMonthButtonVisibility=function(){var e=this._getActiveHeaderAggregation();if(this._bActionTriggeredFromSecondHeader){this._isTwoMonthsInOneColumn()?e.setVisibleButton1(!e.getVisibleButton1()):e._setVisibleButton3(!e._getVisibleButton3())}else{e.setVisibleButton1(false)}return this};b.prototype._showMonthPicker=function(e){var t=this._getFocusedDate(),a=this._getMonthPicker(),i=new c(this._getFocusedDate());this._updateActiveHeaderYearButtonVisibility();this._updateMonthButtonVisibility();this.setProperty("_currentPicker",Y.MONTH_PICKER);if(this._bActionTriggeredFromSecondHeader){i.setDate(1);i.setMonth(i.getMonth()+1);a._setYear(i.getYear());a._setDate(i)}else{a._setYear(t.getYear());a._setDate(t)}if(!e&&this._bActionTriggeredFromSecondHeader){a.setMonth(i.getMonth());this._setDisabledMonths(i.getYear(),a)}else if(!e){a.setMonth(t.getMonth());this._setDisabledMonths(t.getYear(),a)}if(this.getAggregation("month").length>1&&this.getProperty("_currentPicker")==Y.MONTH_PICKER){this.getAggregation("month").forEach(function(e){e._oItemNavigation.iActiveTabIndex=-1})}this._togglePrevNext(t,true);this._setHeaderText(this._getFocusedDate())};b.prototype._showYearPicker=function(){var e=this._getFocusedDate(),t=this._getYearPicker();this.setProperty("_currentPicker",Y.YEAR_PICKER);t.setDate(e.toLocalJSDate());this._togglePrevNexYearPicker();if(this._isTwoMonthsInOneColumn()){this._updateActiveHeaderYearButtonVisibility()}else{this._updateActiveHeaderYearButtonVisibility()}if(this._bActionTriggeredFromSecondHeader&&this.getAggregation("month")[1].getDate().getFullYear()>this._getFocusedDate().getYear()){var a=e.toLocalJSDate();a.setFullYear(a.getFullYear()+1);t.setDate(a);this._updateHeadersYearPrimaryText(this._getYearString())}else{t.setDate(e.toLocalJSDate());this._updateHeadersYearPrimaryText(this._getYearString())}if(this.getAggregation("month").length>1&&this.getProperty("_currentPicker")==Y.YEAR_PICKER){this.getAggregation("month").forEach(function(e){e._oItemNavigation.iActiveTabIndex=-1})}};b.prototype._focusDate=function(e,t,a,i){var r,s=false,n=false,o=this.getAggregation("month"),h;if(e.isBefore(this._oMinDate)){r=this._oMinDate;s=true}else if(e.isAfter(this._oMaxDate)){r=this._oMaxDate;s=true}else{r=e}if(this._focusDateExtend){n=this._focusDateExtend(e,t,a)}this._setFocusedDate(r);if(i&&!this._focusDateExtend){for(h=0;h<o.length;++h){if(o[h].checkDateFocusable(r.toLocalJSDate())){o[h].setDate(r.toLocalJSDate());o[h]._focusDate(r);return}}}if(s||t){this._renderMonth(false,a);this._addMonthFocusDelegate()}if(n){this.fireStartDateChange()}};b.prototype._setHeaderText=function(e){var t=this.getAggregation("header");var a=this.getAggregation("secondMonthHeader");var i=this._getLocaleData();var r=[];var s=[];var n=[];var o=[];var h;var g=false;var l;var d;var u;var _;var p;var f=this._getPrimaryCalendarType();var D=this._getSecondaryCalendarType();var y="";if(this._bLongMonth||!this._bNamesLengthChecked){r=i.getMonthsStandAlone("wide",f)}else{g=true;r=i.getMonthsStandAlone("abbreviated",f);s=i.getMonthsStandAlone("wide",f)}if(D){n=i.getMonthsStandAlone("abbreviated",D);o=i.getMonthsStandAlone("wide",D);var m=this._getDisplayedSecondaryMonths();if(m.start===m.end){u=n[m.start];y=o[m.start]}else{p=i.getIntervalPattern();u=p.replace(/\{0\}/,n[m.start]).replace(/\{1\}/,n[m.end]);y=p.replace(/\{0\}/,o[m.start]).replace(/\{1\}/,o[m.end])}}t.setAdditionalTextButton1(u);t._setAdditionalTextButton3(u);a.setAdditionalTextButton1(u);var M=this._getDisplayedMonths(e);this._sFirstMonthName=l=r[M[0]];d=r[M[M.length-1]];if(M.length>1&&!this._bShowOneMonth){if(!p){p=i.getIntervalPattern()}u=p.replace(/\{0\}/,l).replace(/\{1\}/,d);h=s.length?p.replace(/\{0\}/,s[M[0]]).replace(/\{1\}/,s[M[M.length-1]]):u;if(this._isTwoMonthsInTwoColumns()||this._isTwoMonthsInOneColumn()){u=l}}else{u=l;h=s[M[0]]||u}if(!this._getSucessorsPickerPopup()&&y){h+=", "+y}t.setTextButton1(u);t.setAriaLabelButton1(h);t._setTextButton3(d);t._setAriaLabelButton3(d);a.setTextButton1(d);a.setAriaLabelButton1(d);var P=new c(e,f);P.setDate(1);_=this._oYearFormat.format(P.toUTCJSDate(),true);if(P.getMonth()===11){this._updateHeadersYearPrimaryText(_,(parseInt(_)+1).toString())}else{this._updateHeadersYearPrimaryText(_,_)}if(D&&this._iMode!==3){this._updateHeadersYearAdditionalTextHelper()}else{this._updateHeadersYearAdditionalText()}return{sMonth:u,sYear:_,sAriaLabel:h,bShort:g}};b.prototype._handleButton1=function(e){if(this._iMode!=1){this._saveTriggeredHeader(e);this._showMonthPicker()}else{this.setProperty("_currentPicker",Y.MONTH);this._addMonthFocusDelegate()}};b.prototype._addMonthFocusDelegate=function(){var e=this.getAggregation("month"),t=e[0].getDate(),a=this._getFocusedDate(),i={onAfterRendering:function(){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex(),undefined,true);this.removeDelegate(i)}},r,s;if(e.length>1&&r){t=c.fromLocalJSDate(r,this._getPrimaryCalendarType())}else if(e.length>1){t=H.call(this,this._getFocusedDate())}else{t=a}for(var n=0;n<e.length;n++){r=new c(t);if(n>0){r.setMonth(r.getMonth()+n,1)}if(a.getYear()===r.getYear()&&a.getMonth()===r.getMonth()){s=this.getAggregation("month")[n];s.addDelegate(i,s)}}};b.prototype._handleButton2=function(e){if(this._iMode<=1){this._saveTriggeredHeader(e);this._showYearPicker()}else{this._showYearRangePicker()}};b.prototype._selectMonth=function(){var e=new c(this._getFocusedDate(),this._getPrimaryCalendarType()),t=this._getMonthPicker(),a=t.getProperty("_focusedMonth"),i=a||a===0?a:t.getMonth(),r=c.fromLocalJSDate(p.getInstance(),this._getPrimaryCalendarType());r=t._iYear?r.setYear(t._iYear).setMonth(i-1,1):new c(this._getFocusedDate().getYear(),i-1,1);if(B.call(this)>1){if(this._bActionTriggeredFromSecondHeader&&r.getYear()>=n._minDate(this._getPrimaryCalendarType()).getYear()){e.setYear(r.getYear());i=r.getMonth()}else if(e.getYear()===n._maxDate(this._getPrimaryCalendarType()).getYear()&&i===11){i-=1}}e.setMonth(i);if(i!=e.getMonth()){e.setDate(0)}this._focusDate(e,true,false,false);this._closePickers();this._addMonthFocusDelegate()};b.prototype._getSucessorsPickerPopup=function(){return this.getPickerPopup&&this.getPickerPopup()};b.prototype._selectYear=function(){var e=new c(this._getFocusedDate(),this._getPrimaryCalendarType()),t=e.getMonth(),a=this._getYearPicker(),i=c.fromLocalJSDate(a.getDate(),this._getPrimaryCalendarType());if(!this._bActionTriggeredFromSecondHeader){i.setMonth(t,e.getDate())}else{i.setYear(t===11?i.getYear()-1:i.getYear());i.setMonth(t,e.getDate())}e=i;this._focusDate(e,true,false,false);this._closePickers();this._addMonthFocusDelegate();this._setHeaderText(this._getFocusedDate())};b.prototype.setProperty=function(){var e=arguments[0],t=arguments[1];i.prototype.setProperty.apply(this,arguments);if(e==="_currentPicker"){switch(t){case"month":this._iMode=0;break;case"monthPicker":this._iMode=1;break;case"yearPicker":this._iMode=2;break;case"yearRangePicker":this._iMode=3;break;default:return}}return this};b.prototype._selectYearRange=function(){var e=this.getAggregation("yearRangePicker"),t=this.getAggregation("header"),a=e.getRangeSize(),i=this._getPrimaryCalendarType(),r=c.fromLocalJSDate(e.getDate(),i),s=new c(r.getYear()+a-1,0,1,i),n=this._getFocusedDate(),o,h;n.setYear(r.getYear()+a/2);r.setMonth(0,1);if(n.isBefore(this._oMinDate)){n=new c(this._oMinDate,this._getPrimaryCalendarType())}else if(n.isAfter(this._oMaxDate)){n=new c(this._oMaxDate,this._getPrimaryCalendarType())}this._setFocusedDate(n);this._showYearPicker();o=this._oYearFormat.format(_.getInstance(r.toUTCJSDate(),r.getCalendarType()),true);h=this._oYearFormat.format(_.getInstance(s.toUTCJSDate(),s.getCalendarType()),true);t.setTextButton2(o+" - "+h);t._setTextButton4(o+" - "+h)};b.prototype._showYearRangePicker=function(){var e=this.getAggregation("yearRangePicker"),t=this._getYearPicker(),a=c.fromLocalJSDate(t.getFirstRenderedDate(),this._getPrimaryCalendarType());this.setProperty("_currentPicker",Y.YEAR_RANGE_PICKER);e.getColumns()%2!==0?a.setYear(a.getYear()+Math.floor(e.getRangeSize()/2)):a.setYear(a.getYear());e.setDate(a.toLocalJSDate());this._togglePrevNexYearPicker()};b.prototype._setColumns=function(e){this._iColumns=e;return this};b.prototype._getColumns=function(){return this._iColumns};b.prototype._updateActiveHeaderYearButtonVisibility=function(){var e=this._getActiveHeaderAggregation();if(this._bActionTriggeredFromSecondHeader){this._isTwoMonthsInOneColumn()?e.setVisibleButton1(!e.getVisibleButton1()):e._setVisibleButton3(!e._getVisibleButton3())}else{e.setVisibleButton1(!e.getVisibleButton1())}return this};b.prototype._updateHeadersButtonsHelper=function(e,t,a,i){var r=this.getAggregation("header"),s=this.getAggregation("secondMonthHeader");r.setVisibleButton1(e);r.setVisibleButton2(t);r._setVisibleButton3(a);r._setVisibleButton4(i);if(s.getVisible()){s.setVisibleButton1(e);s.setVisibleButton2(t);s._setVisibleButton3(a);s._setVisibleButton4(i)}};b.prototype._updateHeadersButtons=function(){var e=this.getAggregation("secondMonthHeader");if(this._isTwoMonthsInOneColumn()){e.setVisible(true);if(this._iMode===2){this._updateHeadersButtonsHelper(false,true,false,false)}else if(this._iMode===3){this._updateHeadersButtonsHelper(false,false,false,false)}else{this._updateHeadersButtonsHelper(true,true,false,false)}}else if(this._isTwoMonthsInTwoColumns()){e.setVisible(false);if(this._iMode===2){this._bActionTriggeredFromSecondHeader?this._updateHeadersButtonsHelper(true,true,false,true):this._updateHeadersButtonsHelper(false,true,true,true)}else if(this._iMode===3){this._updateHeadersButtonsHelper(false,false,false,false)}else if(this._iMode===1){this._bActionTriggeredFromSecondHeader?this._updateHeadersButtonsHelper(true,true,false,true):this._updateHeadersButtonsHelper(false,true,true,true)}else{this._updateHeadersButtonsHelper(true,true,true,true)}}else{e.setVisible(false);if(this._iMode===1){this._updateHeadersButtonsHelper(false,true,false,false)}else if(this._iMode===2){this._updateHeadersButtonsHelper(false,true,false,false)}else if(this._iMode===3){this._updateHeadersButtonsHelper(false,false,false,false)}else{this._updateHeadersButtonsHelper(true,true,false,false)}}if(this._getSucessorsPickerPopup()){this.getAggregation("header").setVisibleButton2(false)}};b.prototype._setPrimaryHeaderMonthButtonText=function(){var e=this.getAggregation("header");if(this._isTwoMonthsInOneColumn()||this._isTwoMonthsInTwoColumns()){e.setTextButton1(this._sFirstMonthName)}};b.prototype._toggleTwoMonthsInColumnsCSS=function(){if(this._isTwoMonthsInTwoColumns()){if(new M(t.getLanguageTag()).getLanguage().toLowerCase()==="ja"||new M(t.getLanguageTag()).getLanguage().toLowerCase()==="zh"){this.addStyleClass("sapUiCalTwoMonthsTwoColumnsJaZh");this.removeStyleClass("sapUiCalTwoMonthsTwoColumns")}else{this.addStyleClass("sapUiCalTwoMonthsTwoColumns");this.removeStyleClass("sapUiCalTwoMonthsTwoColumnsJaZh")}}else{this.removeStyleClass("sapUiCalTwoMonthsTwoColumnsJaZh");this.removeStyleClass("sapUiCalTwoMonthsTwoColumns")}if(this._isTwoMonthsInOneColumn()){this.addStyleClass("sapUiCalTwoMonthsInOneColumn")}else{this.removeStyleClass("sapUiCalTwoMonthsInOneColumn")}};b.prototype._isTwoMonthsInOneColumn=function(){var e=B.call(this);return this._getColumns()===1&&e===2};b.prototype._isTwoMonthsInTwoColumns=function(){var e=B.call(this);return this._getColumns()===2&&e===2};b.prototype._updateHeadersYearPrimaryText=function(e,t){var a=this._getYearPicker(),i=this.getAggregation("header"),r=this.getAggregation("secondMonthHeader"),s=e,o=t||e,h=this._getPrimaryCalendarType();if(this._iMode===2&&a){var g=a.getProperty("_middleDate")?a.getProperty("_middleDate"):a._getDate(),l=new c(g,h),d=n._minDate(this._getPrimaryCalendarType()).getYear(),u=n._maxDate(this._getPrimaryCalendarType()).getYear(),p,f,D;l.setDate(1);l.setYear(l.getYear()-Math.floor(a.getYears()/2));if(l.getYear()<d){l.setYear(d)}else if(l.getYear()+a.getYears()>u){l.setYear(u-a.getYears()+1)}p=new c(l,h);p.setYear(p.getYear()+a.getYears()-1);f=this._oYearFormat.format(_.getInstance(l.toUTCJSDate(),l.getCalendarType()),true);D=this._oYearFormat.format(_.getInstance(p.toUTCJSDate(),p.getCalendarType()),true);if(this._bActionTriggeredFromSecondHeader){o=f+" - "+D}else{s=f+" - "+D}}i._setTextButton4(o);i._setAriaLabelButton4(o);r.setTextButton2(o);i.setTextButton2(s)};b.prototype._updateHeadersYearAdditionalText=function(e){var t=this.getAggregation("header"),a=this.getAggregation("secondMonthHeader");t.setAdditionalTextButton2(e);t._setAdditionalTextButton4(e);a.setAdditionalTextButton2(e)};b.prototype._adjustYearRangeDisplay=function(){var e=this.getAggregation("yearRangePicker"),t=this._getPrimaryCalendarType(),i=this._getSecondaryCalendarType(),r=t===a.Japanese||i===a.Japanese;if(!this._getSucessorsPickerPopup()){if(r){e.setColumns(1);e.setYears(4)}else{e.setColumns(2);e.setYears(8)}}};b.prototype._getSpecialDates=function(){var e=this.getParent();if(this._oSpecialDatesControlOrigin){return this._oSpecialDatesControlOrigin._getSpecialDates()}if(e&&e._getSpecialDates){return e._getSpecialDates()}else{var t=this.getSpecialDates();for(var a=0;a<t.length;a++){var i=t[a].getSecondaryType()===f.CalendarDayType.NonWorking&&t[a].getType()!==f.CalendarDayType.NonWorking;if(i){var r=new o;r.setType(t[a].getSecondaryType());r.setStartDate(t[a].getStartDate());if(t[a].getEndDate()){r.setEndDate(t[a].getEndDate())}t.push(r)}}return t}};function A(){var e=this.getSelectedDates();var t=this._getPrimaryCalendarType();if(e&&e[0]&&e[0].getStartDate()){this._oFocusedDate=c.fromLocalJSDate(e[0].getStartDate(),t)}else{this._oFocusedDate=c.fromLocalJSDate(p.getInstance(),t)}if(this._oFocusedDate.isBefore(this._oMinDate)){this._oFocusedDate=new c(this._oMinDate,t)}else if(this._oFocusedDate.isAfter(this._oMaxDate)){this._oFocusedDate=new c(this._oMaxDate,t)}}function w(e){var t=e.size.width;if(t<=0){return}if(t===this._iPrevWidth){return}this._iPrevWidth=t;var a=this._iSize;if(t<this._iBreakPointTablet){this._iSize=0}else if(t<this._iBreakPointDesktop){this._iSize=1}else if(t<this._iBreakPointLargeDesktop){this._iSize=2}else{this._iSize=3}var i=B.call(this);if(a!=this._iSize||this._bInitMonth){switch(this._iSize){case 1:this._setColumns(2);break;case 2:this._setColumns(3);break;case 3:this._setColumns(4);break;default:this._setColumns(1);break}if(i<this._getColumns()){this._setColumns(i)}if(this._getColumns()>2&&i>this._getColumns()){var r=this._getColumns();var s=0;var n=this._getColumns();while(r>=2){var o=i%r;if(o==0){n=r;break}else{var h=o/r;if(h>s){s=h;n=r}}r--}this._setColumns(n)}var g;var l=this.getAggregation("month");if(this._getColumns()>1){g=100/this._getColumns()+"%";this.$("content").removeClass("sapUiCalContentSingle")}else{g="100%";this.$("content").addClass("sapUiCalContentSingle")}for(var d=0;d<l.length;d++){var u=l[d];u.setWidth(g)}this.invalidate()}this._setPrimaryHeaderMonthButtonText();this._toggleTwoMonthsInColumnsCSS()}function H(e){var t=new c(e,this._getPrimaryCalendarType());t.setDate(1);var a=B.call(this);if(a<=12){var i=e.getMonth();if(12%a>0&&i+a>11){i=12-a}t.setMonth(i)}return t}function x(){var e,t,a;if(!this._bNamesLengthChecked){e=this._getMonthPicker();this._bLongMonth=e._bLongMonth;this._bNamesLengthChecked=true;this.setProperty("_currentPicker",Y.MONTH);if(!this._bLongMonth){t=this.getAggregation("month");if(t.length>1){a=c.fromLocalJSDate(t[0].getDate(),this._getPrimaryCalendarType())}else{a=this._getFocusedDate()}this._setHeaderText(a);this._setPrimaryHeaderMonthButtonText();this._toggleTwoMonthsInColumnsCSS()}}}function R(e,t){var a,i=this._getPrimaryCalendarType(),r;if(!e){return}a=c.fromLocalJSDate(e,i);r=a.getYear();n._checkYearInValidRange(r,i);if(n._isOutside(a,this._oMinDate,this._oMaxDate)){throw new Error("Date must not be in valid range (minDate and maxDate); "+this)}this._setFocusedDate(a);if(this.getDomRef()&&this._iMode==0){this._renderMonth(t,true)}}function B(){if(D.system.phone){return 1}else{return this.getMonths()}}function F(e){this.fireEvent("_renderMonth",{days:e.getParameter("days")})}function L(e){this._oSelectedMonth=e.oSource;this.fireSelect()}function I(e){var t,a,i;if(B.call(this)>1){t=this.getAggregation("month");for(i=0;i<t.length;i++){a=t[i];if(a.getId()!=e.oSource.getId()){a._bindMousemove()}}}}function N(e){var t,a,i;if(B.call(this)>1){t=this.getAggregation("month");for(i=0;i<t.length;i++){a=t[i];if(a.getId()!=e.oSource.getId()){a._unbindMousemove()}}}}function E(e){var t=e.getParameter("offset");if(t>0){this._handleNext(e)}if(t<0){this._handlePrevious(e)}}function J(){this._updateHeadersYearPrimaryText(this._getYearString())}return b});
//# sourceMappingURL=Calendar.js.map