/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/i18n/Formatting","sap/base/i18n/Localization","sap/ui/core/Control","sap/ui/Device","sap/ui/core/Lib","sap/ui/core/LocaleData","sap/ui/unified/calendar/CalendarUtils","sap/ui/core/date/UniversalDate","./library","sap/ui/core/InvisibleText","sap/ui/core/format/DateFormat","sap/ui/core/ResizeHandler","sap/ui/core/Locale","./CalendarRowRenderer","sap/ui/dom/containsOrEquals","sap/ui/thirdparty/jquery","sap/ui/unified/CalendarAppointment","sap/ui/core/library","sap/ui/core/date/UI5Date"],function(e,t,i,n,a,r,s,o,p,l,u,g,h,d,c,jQuery,f,m,v){"use strict";var T=p.CalendarDayType;var C=p.CalendarAppointmentVisualization;var A=p.GroupAppointmentsMode;var _=p.CalendarIntervalType;var U=p.CalendarAppointmentHeight;var y=p.CalendarAppointmentRoundWidth;var D=i.extend("sap.ui.unified.CalendarRow",{metadata:{library:"sap.ui.unified",properties:{startDate:{type:"object",group:"Data"},intervals:{type:"int",group:"Appearance",defaultValue:12},intervalSize:{type:"int",group:"Appearance",defaultValue:1},intervalType:{type:"sap.ui.unified.CalendarIntervalType",group:"Appearance",defaultValue:_.Hour},showSubIntervals:{type:"boolean",group:"Appearance",defaultValue:false},showIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},showEmptyIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},nonWorkingDays:{type:"int[]",group:"Misc",defaultValue:null},nonWorkingHours:{type:"int[]",group:"Misc",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},checkResize:{type:"boolean",group:"Behavior",defaultValue:true},updateCurrentTime:{type:"boolean",group:"Behavior",defaultValue:true},groupAppointmentsMode:{type:"sap.ui.unified.GroupAppointmentsMode",group:"Appearance",defaultValue:A.Collapsed},appointmentsReducedHeight:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},appointmentsVisualization:{type:"sap.ui.unified.CalendarAppointmentVisualization",group:"Appearance",defaultValue:C.Standard},appointmentHeight:{type:"sap.ui.unified.CalendarAppointmentHeight",group:"Appearance",defaultValue:U.Regular},appointmentRoundWidth:{type:"sap.ui.unified.CalendarAppointmentRoundWidth",group:"Appearance",defaultValue:y.None},multipleAppointmentsSelection:{type:"boolean",group:"Data",defaultValue:false}},aggregations:{appointments:{type:"sap.ui.unified.CalendarAppointment",defaultClass:f,multiple:true,singularName:"appointment"},nonWorkingPeriods:{type:"sap.ui.unified.NonWorkingPeriod",multiple:true},intervalHeaders:{type:"sap.ui.unified.CalendarAppointment",multiple:true,singularName:"intervalHeader"},groupAppointments:{type:"sap.ui.unified.CalendarAppointment",multiple:true,singularName:"groupAppointment",visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{parameters:{appointment:{type:"sap.ui.unified.CalendarAppointment"},appointments:{type:"sap.ui.unified.CalendarAppointment[]"},multiSelect:{type:"boolean"},domRefId:{type:"string"}}},startDateChange:{},leaveRow:{parameters:{type:{type:"string"}}},intervalSelect:{parameters:{startDate:{type:"object"},endDate:{type:"object"},subInterval:{type:"boolean"}}}}},renderer:d});D.prototype.init=function(){this._bRTL=t.getRTL();this._oRb=a.getResourceBundleFor("sap.ui.unified");var e=this._oRb.getText("APPOINTMENT_DATE_TIME_DESCRIPTION",[I.call(this).getDatePattern("long"),I.call(this).getTimePattern("medium")]);this._oFormatAria=u.getDateTimeInstance({pattern:"EEEE "+e});this._aVisibleAppointments=[];this._aVisibleIntervalHeaders=[];this.setStartDate(v.getInstance());this._resizeProxy=jQuery.proxy(this.handleResize,this);this.aSelectedAppointments=[];this._fnCustomSortedAppointments=undefined};D.prototype.exit=function(){if(this._sResizeListener){g.deregister(this._sResizeListener);this._sResizeListener=undefined}if(this._sUpdateCurrentTime){clearTimeout(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined}this._fnCustomSortedAppointments=undefined};D.prototype.onBeforeRendering=function(){this._aVisibleAppointments=[];M.call(this);H.call(this);z.call(this);if(this._sUpdateCurrentTime){clearTimeout(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined}if(!this.getAppointments().length){this.aSelectedAppointments=[]}else{this.getAppointments().forEach(function(e){this._updateSelectedAppointmentsArray(e)}.bind(this))}};D.prototype.onAfterRendering=function(){F.call(this);this.updateCurrentTimeVisualization();if(this.getCheckResize()&&!this._sResizeListener){this._sResizeListener=g.register(this,this._resizeProxy)}};D.prototype.onThemeChanged=function(e){if(this.getDomRef()){for(var t=0;t<this._aVisibleAppointments.length;t++){var i=this._aVisibleAppointments[t];i.level=-1}this.handleResize(e)}};D.prototype.invalidate=function(e){if(e&&e instanceof f){var t=false;for(var n=0;n<this._aVisibleAppointments.length;n++){if(this._aVisibleAppointments[n].appointment==e){t=true;break}}if(t){this._aVisibleAppointments=[]}this._updateSelectedAppointmentsArray(e)}i.prototype.invalidate.apply(this,arguments)};D.prototype.setStartDate=function(e){if(!e){e=v.getInstance()}s._checkJSDateObject(e);var t=e.getFullYear();s._checkYearInValidRange(t);this._oUTCStartDate=s._createUniversalUTCDate(e,undefined,true);this.setProperty("startDate",e);return this};D.prototype._getStartDate=function(){if(!this._oUTCStartDate){this._oUTCStartDate=s._createUniversalUTCDate(this.getStartDate(),undefined,true)}return this._oUTCStartDate};D.prototype.setIntervalType=function(e){this.setProperty("intervalType",e);this._aVisibleAppointments=[];return this};D.prototype._getAppointmentReducedHeight=function(e){var t=!n.system.phone&&this.getAppointmentsReducedHeight()&&e.size===U.Regular;return t};D.prototype.onfocusin=function(e){if(jQuery(e.target).hasClass("sapUiCalendarApp")){N.call(this,e.target.id)}else{var t=this._getVisibleAppointments();var i=false;var n;for(var a=0;a<t.length;a++){n=t[a].appointment;if(c(n.getDomRef(),e.target)){i=true;n.focus();break}}if(!i){n=this.getFocusedAppointment();if(n){n.focus()}}}};D.prototype.applyFocusInfo=function(e){if(this._sFocusedAppointmentId){this.getFocusedAppointment().focus()}return this};D.prototype.onsapleft=function(e){if(jQuery(e.target).hasClass("sapUiCalendarApp")){Y.call(this,this._bRTL,1)}e.preventDefault();e.stopPropagation()};D.prototype.onsapright=function(e){if(jQuery(e.target).hasClass("sapUiCalendarApp")){Y.call(this,!this._bRTL,1)}e.preventDefault();e.stopPropagation()};D.prototype.onsapup=function(e){this.fireLeaveRow({type:e.type})};D.prototype.onsapdown=function(e){this.fireLeaveRow({type:e.type})};D.prototype.onsaphome=function(e){x.call(this,e);e.preventDefault();e.stopPropagation()};D.prototype.onsapend=function(e){x.call(this,e);e.preventDefault();e.stopPropagation()};D.prototype.onsapselect=function(e){var t=this._getVisibleAppointments(),i;for(var n=0;n<t.length;n++){i=t[n].appointment;if(c(i.getDomRef(),e.target)){var a=!(this.getMultipleAppointmentsSelection()||e.ctrlKey||e.metaKey);P.call(this,i,a);break}}e.stopPropagation();e.preventDefault()};D.prototype.ontap=function(e){var t=this.$("Apps").children(".sapUiCalendarRowAppsInt");var i=0;var n=false;for(i=0;i<t.length;i++){var a=t[i];if(!this._isOneMonthsRowOnSmallSizes()&&c(a,e.target)){n=true;break}}if(n){B.call(this,i,e.target)}else{this.onsapselect(e)}};D.prototype.onsapselectmodifiers=function(e){this.onsapselect(e)};D.prototype.handleResize=function(e){if(e&&e.size&&e.size.width<=0){return this}var t=this.$("DummyApp");t.css("display","");F.call(this);return this};D.prototype.updateCurrentTimeVisualization=function(){var e=this.$("Now");var t=s._createUniversalUTCDate(v.getInstance(),undefined,true);var i=this.getIntervals();var n=this.getIntervalType();var a=this._getStartDate();var r=a.getTime();var o=this._oUTCEndDate;var p=o.getTime();this._sUpdateCurrentTime=undefined;if(t.getTime()<=p&&t.getTime()>=r){var l=V.call(this,n,i,a,o,r,t);var u=0;if(this._bRTL){e.css("right",l+"%")}else{e.css("left",l+"%")}e.css("display","");if(this.getUpdateCurrentTime()){switch(n){case _.Hour:u=6e4;break;case _.Day:case _.Week:case _.OneMonth:case"OneMonth":u=18e5;break;default:u=-1;break}if(u>0){this._sUpdateCurrentTime=setTimeout(this.updateCurrentTimeVisualization.bind(this),u)}}}else{e.css("display","none")}return this};D.prototype.getFocusedAppointment=function(){var e=this._getAppointmentsSorted();var t=this.getAggregation("groupAppointments",[]);var i;var n=0;for(n=0;n<t.length;n++){if(t[n].getId()==this._sFocusedAppointmentId){i=t[n];break}}if(!i){for(n=0;n<e.length;n++){if(e[n].getId()==this._sFocusedAppointmentId){i=e[n];break}}}return i};D.prototype.focusAppointment=function(e){if(!e||!(e instanceof f)){throw new Error("Appointment must be a CalendarAppointment; "+this)}var t=e.getId();if(this._sFocusedAppointmentId!=t){N.call(this,t)}else{e.focus()}return this};D.prototype.focusNearestAppointment=function(e){s._checkJSDateObject(e);var t=this._getAppointmentsSorted();var i;var n;var a;for(var r=0;r<t.length;r++){i=t[r];if(i.getStartDate()>e){if(r>0){n=t[r-1]}else{n=i}break}}if(i){if(n&&Math.abs(i.getStartDate()-e)>=Math.abs(n.getStartDate()-e)){a=n}else{a=i}this.focusAppointment(a)}return this};D.prototype._getVisibleAppointments=function(){return this._aVisibleAppointments};D.prototype._getVisibleIntervalHeaders=function(){return this._aVisibleIntervalHeaders};D.prototype._getNonWorkingDays=function(){if(this.getIntervalSize()!==1){return[]}var e=this.getNonWorkingDays();if(!e){var t=I.call(this);var i=t.getWeekendStart();var n=t.getWeekendEnd();e=[];for(var a=0;a<=6;a++){if(i<=n&&a>=i&&a<=n||i>n&&(a>=i||a<=n)){e.push(a)}}}else if(!Array.isArray(e)){e=[]}return e};D.prototype._isOneMonthsRowOnSmallSizes=function(){return(this.getIntervalType()===_.OneMonth||this.getIntervalType()==="OneMonth")&&this.getIntervals()===1};D.prototype._getAppointmentsSorted=function(){var e=this.getAppointments(),t=j;e.sort(this._fnCustomSortedAppointments?this._fnCustomSortedAppointments:t);return e};D.prototype._setCustomAppointmentsSorterCallback=function(e){this._fnCustomSortedAppointments=e;this.invalidate()};D.prototype._calculateAppoitnmentVisualCue=function(e){if(b(this,e)){return{appTimeUnitsDifRowStart:0,appTimeUnitsDifRowEnd:0}}var t=e.getStartDate(),i=e.getEndDate(),n=new o(t.getFullYear(),t.getMonth(),t.getDate(),t.getHours(),t.getMinutes()),a=new o(i.getFullYear(),i.getMonth(),i.getDate(),i.getHours(),i.getMinutes()),r=this.getIntervalType(),s=this.getStartDate(),p=r==="Hour"?new o(s.getFullYear(),s.getMonth(),s.getDate(),s.getHours()):new o(s.getFullYear(),s.getMonth(),s.getDate()),l=this.getIntervals(),u;switch(r){case"Hour":u=new o(s.getFullYear(),s.getMonth(),s.getDate(),s.getHours()+l);break;case"Day":case"Week":case"One Month":u=new o(s.getFullYear(),s.getMonth(),s.getDate()+l);break;case"Month":u=new o(s.getFullYear(),s.getMonth()+l,s.getDate());break;default:break}return{appTimeUnitsDifRowStart:p.getTime()-n.getTime(),appTimeUnitsDifRowEnd:a.getTime()-u.getTime()}};D.prototype._updateSelectedAppointmentsArray=function(e){if(e.getSelected()){if(this.aSelectedAppointments.indexOf(e.getId())===-1){this.aSelectedAppointments.push(e.getId())}}else{this.aSelectedAppointments=this.aSelectedAppointments.filter(function(t){return t!==e.getId()})}};function b(e,t){var i=e.getAggregation("groupAppointments",[]);var n;for(n=0;n<i.length;++n){if(t===i[n]){return true}}return false}function S(){if(!this._sLocale){this._sLocale=new h(e.getLanguageTag()).toString()}return this._sLocale}function I(){if(!this._oLocaleData){var e=S.call(this);var t=new h(e);this._oLocaleData=r.getInstance(t)}return this._oLocaleData}function M(){var e=this.getStartDate();var t;var i=this.getIntervals();var n=this.getIntervalType();this._oUTCStartDate=w.call(this,e);switch(n){case _.Hour:t=new o(this._oUTCStartDate.getTime());t.setUTCHours(t.getUTCHours()+i);break;case _.Day:case _.Week:case _.OneMonth:case"OneMonth":t=new o(this._oUTCStartDate.getTime());t.setUTCDate(t.getUTCDate()+i*this.getIntervalSize());break;case _.Month:t=new o(this._oUTCStartDate.getTime());t.setUTCMonth(t.getUTCMonth()+i);break;default:throw new Error("Unknown IntervalType: "+n+"; "+this)}t.setUTCMilliseconds(-1);this._iRowSize=t.getTime()-this._oUTCStartDate.getTime();this._iIntervalSize=Math.floor(this._iRowSize/i);this._oUTCEndDate=t}function w(e){var t=this.getIntervalType();var i=s._createUniversalUTCDate(e,undefined,true);switch(t){case _.Hour:i.setUTCMinutes(0);i.setUTCSeconds(0);i.setUTCMilliseconds(0);break;case _.Day:case _.Week:case _.OneMonth:case"OneMonth":i.setUTCHours(0);i.setUTCMinutes(0);i.setUTCSeconds(0);i.setUTCMilliseconds(0);break;case _.Month:i.setUTCDate(1);i.setUTCHours(0);i.setUTCMinutes(0);i.setUTCSeconds(0);i.setUTCMilliseconds(0);break;default:throw new Error("Unknown IntervalType: "+t+"; "+this)}return i}function k(){return n.system.phone||this.getGroupAppointmentsMode()===A.Collapsed}function H(){var e=this._getAppointmentsSorted();var t;var i;var n;var a=this.getIntervals();var r=this.getIntervalType();var p=this._getStartDate();var l=p.getTime();var u=this._oUTCEndDate;var g=u.getTime();var h=[];var d=false;var c=0;var f=0;var m=k.call(this);var T=this._needAppointmentHorizontalFit();this.destroyAggregation("groupAppointments",true);for(c=0;c<e.length;c++){t=e[c];if(!t||!t.getStartDate()){continue}var C=s._createUniversalUTCDate(t.getStartDate(),undefined,true);var A=C.getTime();C.setUTCSeconds(0);C.setUTCMilliseconds(0);var U=t.getEndDate()?s._createUniversalUTCDate(t.getEndDate(),undefined,true):s._createUniversalUTCDate(v.getInstance(864e12),undefined,true);var y=U.getTime();U.setUTCSeconds(0);U.setUTCMilliseconds(0);var D=false;if(C.getTime()<l&&U.getTime()>=l){C=new o(l);D=true}if(U.getTime()>g&&C.getTime()<=g){U=new o(g);D=true}var b=(U.getTime()-C.getTime())/6e4;if(D&&b==0){continue}var S=0;var I=0;var M=-1;i=undefined;n=undefined;if(C&&C.getTime()<=g&&U&&U.getTime()>=l&&A<=y){if(m&&r==_.Month&&U.getTime()-C.getTime()<6048e5){i=R.call(this,C,t,r,a,p,u,l,h);var w=s._createUniversalUTCDate(i.getEndDate(),undefined,true);if(U.getTime()>w.getTime()){n=R.call(this,U,t,r,a,p,u,l,h)}}if(T){this._setHorizontalRoundingWidth(t,C,U)}S=V.call(this,r,a,p,u,l,C);I=E.call(this,r,a,p,u,l,U);if(i){i._iBegin=S;i._iEnd=I;i._iLevel=M;if(n){n._iBegin=S;n._iEnd=I;n._iLevel=M}continue}h.push({appointment:t,begin:S,end:I,calculatedEnd:I,level:M,size:this.getProperty("appointmentHeight")});if(this._sFocusedAppointmentId&&this._sFocusedAppointmentId==t.getId()){d=true}}}var H=this.getAggregation("groupAppointments",[]);if(H.length>0){for(c=0;c<h.length;c++){t=h[c];if(t.appointment._aAppointments&&t.appointment._aAppointments.length<=1){i=t.appointment;var z=false;if(i._aAppointments.length==0){z=true}else{for(f=0;f<h.length;f++){if(h[f].appointment==i._aAppointments[0]){z=true;break}}}if(!z){for(f=0;f<H.length;f++){n=H[f];if(i!=n){for(var F=0;F<n._aAppointments.length;F++){if(i._aAppointments[0]==n._aAppointments[F]){n._aAppointments.splice(F,1);if(n._aAppointments.length==1){this.removeAggregation("groupAppointments",n);n.destroy();H=this.getAggregation("groupAppointments",[])}else{n.setProperty("title",n._aAppointments.length,true)}break}}}}t.begin=i._iBegin;t.end=i._iEnd;t.calculatedEnd=i._iEnd;t.level=i._iLevel;t.appointment=i._aAppointments[0]}else{h.splice(c,1);c--}this.removeAggregation("groupAppointments",i);i.destroy();H=this.getAggregation("groupAppointments",[])}}}if(!d){if(h.length>0){this._sFocusedAppointmentId=h[0].appointment.getId()}else{this._sFocusedAppointmentId=undefined}}this._aVisibleAppointments=h;return this._aVisibleAppointments}function R(e,t,i,n,a,r,p,l){var u=this.getAggregation("groupAppointments",[]);var g;var h=I.call(this);var d=h.getFirstDayOfWeek();var c=e.getUTCDay();var m=new o(e.getTime());m.setUTCHours(0);m.setUTCMinutes(0);m.setUTCSeconds(0);m.setUTCMilliseconds(0);if(d<=c){m.setDate(m.getDate()-(c-d))}else{m.setDate(m.getDate()-(7-c-d))}for(var C=0;C<u.length;C++){g=u[C];var A=s._createUniversalUTCDate(g.getStartDate(),undefined,true);if(A.getTime()==m.getTime()){break}g=undefined}if(!g){var _=new o(m.getTime());_.setDate(_.getDate()+7);_.setMilliseconds(-1);g=new f(this.getId()+"-Group"+u.length,{type:t.getType(),startDate:s._createLocalDate(v.getInstance(m.getTime()),true),endDate:s._createLocalDate(v.getInstance(_.getTime()),true)});g._aAppointments=[];this.addAggregation("groupAppointments",g,true);var U=V.call(this,i,n,a,r,p,m);var y=E.call(this,i,n,a,r,p,_);l.push({appointment:g,begin:U,end:y,calculatedEnd:y,level:-1,size:this.getProperty("appointmentHeight")})}g._aAppointments.push(t);if(g.getType()!=T.None&&g.getType()!=t.getType()){g.setType(T.None)}g.setProperty("title",g._aAppointments.length,true);return g}function V(e,t,i,n,a,r){var s=0;if(e!=_.Month){s=100*(r.getTime()-a)/this._iRowSize}else{var p=new o(r.getTime());p.setUTCDate(1);p.setUTCHours(0);p.setUTCMinutes(0);p.setUTCSeconds(0);p.setUTCMilliseconds(0);var l=new o(p.getTime());l.setUTCMonth(l.getUTCMonth()+1);l.setMilliseconds(-1);var u=l.getTime()-p.getTime();var g=(p.getUTCFullYear()-i.getUTCFullYear())*12+p.getUTCMonth()-i.getUTCMonth();s=100*g/t+100*(r.getTime()-p.getTime())/u/t}if(s<0){s=0}s=Math.round(s*1e5)/1e5;return s}function E(e,t,i,n,a,r){var s=0;if(e!=_.Month){s=100-100*(r.getTime()-a)/this._iRowSize}else{var p=new o(r.getTime());p.setUTCDate(1);p.setUTCHours(0);p.setUTCMinutes(0);p.setUTCSeconds(0);p.setUTCMilliseconds(0);var l=new o(p.getTime());l.setUTCMonth(l.getUTCMonth()+1);l.setMilliseconds(-1);var u=l.getTime()-p.getTime();var g=(p.getUTCFullYear()-i.getUTCFullYear())*12+p.getUTCMonth()-i.getUTCMonth();s=100-(100*g/t+100*(r.getTime()-p.getTime())/u/t)}if(s<0){s=0}s=Math.round(s*1e5)/1e5;return s}function z(){var e=[];if(this.getShowIntervalHeaders()){var t=this.getIntervalHeaders();var i;var n=this.getIntervals();var a=this.getIntervalType();var r=this._getStartDate();var p=r.getTime();var l=this._oUTCEndDate;var u=l.getTime();var g=0;var h=0;for(g=0;g<t.length;g++){i=t[g];var d=s._createUniversalUTCDate(i.getStartDate(),undefined,true);d.setUTCSeconds(0);d.setUTCMilliseconds(0);var c=i.getEndDate()?s._createUniversalUTCDate(i.getEndDate(),undefined,true):s._createUniversalUTCDate(v.getInstance(864e12),undefined,true);c.setUTCSeconds(0);c.setUTCMilliseconds(0);if(d&&d.getTime()<=u&&c&&c.getTime()>=p){var f=new o(r.getTime());var m=new o(r.getTime());m.setUTCMinutes(m.getUTCMinutes()-1);var T=-1;var C=-1;for(h=0;h<n;h++){switch(a){case _.Hour:m.setUTCHours(m.getUTCHours()+1);if(h>0){f.setUTCHours(f.getUTCHours()+1)}break;case _.Day:case _.Week:case _.OneMonth:case"OneMonth":m.setUTCDate(m.getUTCDate()+1);if(h>0){f.setUTCDate(f.getUTCDate()+1)}break;case _.Month:m.setUTCDate(1);m.setUTCMonth(m.getUTCMonth()+2);m.setUTCDate(0);if(h>0){f.setUTCMonth(f.getUTCMonth()+1)}break;default:throw new Error("Unknown IntervalType: "+a+"; "+this)}if(d&&d.getTime()<=f.getTime()&&c&&c.getTime()>=m.getTime()){if(T<0){T=h}C=h}}if(T>=0){e.push({interval:T,appointment:i,last:C})}}}}this._aVisibleIntervalHeaders=e;return this._aVisibleIntervalHeaders}function F(){if(this._isOneMonthsRowOnSmallSizes()){return}var e=this.$("Apps");var t=e.innerWidth();if(t<=0){return}var i=this.$("DummyApp");var n=i.outerHeight(true);if(n<=0){return}var a=4;var r=i.outerWidth();var s=r/t*100;var o=Math.ceil(1e3*s)/1e3;var p;var l;var u=0;var g=0;var h=0;var d=false;var c;var f=this._needAppointmentHorizontalFit();if(this.getShowIntervalHeaders()&&(this.getShowEmptyIntervalHeaders()||this._getVisibleIntervalHeaders().length>0)){u=jQuery(this.$("AppsInt0").children(".sapUiCalendarRowAppsIntHead")[0]).outerHeight(true);d=true}for(h=0;h<this._aVisibleAppointments.length;h++){p=this._aVisibleAppointments[h];l=p.appointment.$();var m=Math.floor(1e3*(100-p.calculatedEnd-p.begin))/1e3;var v=false;if(m<o){p.end=100-p.begin-s;if(p.end<0){p.end=0}v=true;l.addClass("sapUiCalendarAppSmall")}else if(l.hasClass("sapUiCalendarAppSmall")){p.end=p.calculatedEnd;v=true;l.removeClass("sapUiCalendarAppSmall")}if(v){p.level=-1}if(v&&!f){if(this._bRTL){l.css("left",p.end+"%")}else{l.css("right",p.end+"%")}}if(f){p.end=p.calculatedEnd}}for(h=0;h<this._aVisibleAppointments.length;h++){p=this._aVisibleAppointments[h];l=p.appointment.$();var T={};if(p.level<0){for(var C=0;C<this._aVisibleAppointments.length;C++){var A=this._aVisibleAppointments[C];if(p!=A&&p.begin<Math.floor(1e3*(100-A.end))/1e3&&Math.floor(1e3*(100-p.end))/1e3>A.begin&&A.level>=0){this._setBlockedLevelsForAppointment(A,T)}}p.level=this._getAppointmetLevel(T,p);l.attr("data-sap-level",p.level)}c=n*p.level+u;if(!d){c+=a}l.css("top",c+"px");var _=p.level;_+=this._getAppointmentRowCount(p)-1;if(g<_){g=_}}g++;n=n*g+u;if(!d){n+=a}if(!this.getHeight()){e.outerHeight(n)}else{var U=this.$("Apps").children(".sapUiCalendarRowAppsInt");for(h=0;h<U.length;h++){var y=jQuery(U[h]);y.outerHeight(n)}}i.css("display","none")}function L(e,t){var i=e.getColor();if(!i){return}var n=t?"transparent":e._getCSSColorForBackground(i),a=e.getDomRef();if(a){var r=a.querySelector(".sapUiCalendarAppCont");if(r){r.style.backgroundColor=n}}}function P(e,t){var i=0;var n;var a;var r;var s;var o;var p;var u=l.getStaticId("sap.ui.unified","APPOINTMENT_SELECTED");var g=!e.getSelected();var h=this.getAppointmentsVisualization()===C.Filled;if(t){var d=this.getAppointments();var c=this.getAggregation("groupAppointments",[]);jQuery.merge(d,c);for(i=0;i<d.length;i++){n=d[i];if(n.getId()!==e.getId()&&n.getSelected()){n.setProperty("selected",false,true);n.$().removeClass("sapUiCalendarAppSel");for(var f=0;f<this.aSelectedAppointments.length;f++){if(this.aSelectedAppointments[f]!==n.getId()){this.aSelectedAppointments.splice(f)}}a=n.$().attr("aria-describedby");r=a?a.replace(u,""):"";n.$().attr("aria-describedby",r)}}}s=e.$().attr("aria-describedby");p=(s?s.replace(u,""):"").trim();o=(p+" "+u).trim();if(e.getSelected()){e.setProperty("selected",false,true);h&&L(e,false);e.$().removeClass("sapUiCalendarAppSel");if(p){e.$().attr("aria-describedby",p)}else{e.$().removeAttr("aria-describedby")}W(this,t)}else{e.setProperty("selected",true,true);h&&L(e,true);e.$().addClass("sapUiCalendarAppSel");e.$().attr("aria-describedby",o);W(this,t)}this._updateSelectedAppointmentsArray(e);if(e._aAppointments){for(i=0;i<e._aAppointments.length;i++){n=e._aAppointments[i];n.setProperty("selected",g,true)}this.fireSelect({appointments:e._aAppointments,multiSelect:!t,domRefId:e.getId()})}else{this.fireSelect({appointment:e,multiSelect:!t,domRefId:e.getId()})}}function O(e){var t=this._getPlanningCalendar();if(t){t["_onRow"+e]()}}D.prototype._needAppointmentHorizontalFit=function(){var e=this._getPlanningCalendar(),t,i,n;if(!e||this.getAppointmentRoundWidth()===y.None){return false}t=e.getViewKey();i=e._getView(t);n=e._getIntervals(i);return n>=20};D.prototype._setHorizontalRoundingWidth=function(e,t,i){var n;switch(this.getAppointmentRoundWidth()){case y.HalfColumn:n=12;break}this._roundAppointment(e,t,i,n)};D.prototype._roundAppointment=function(e,t,i,n){var a,r;a=e.getStartDate().getHours()-e.getStartDate().getHours()%n;t.setUTCHours(a);t.setUTCMinutes(0);t.setUTCSeconds(0);t.setUTCMilliseconds(0);r=e.getEndDate().getHours()-e.getEndDate().getHours()%n+n;i.setUTCHours(r);i.setUTCMinutes(0);i.setUTCSeconds(0);i.setUTCMilliseconds(0)};D.prototype._setBlockedLevelsForAppointment=function(e,t){var i=this._getAppointmentRowCount(e);for(var n=0;n<i;n++){t[e.level+n]=true}return t};D.prototype._getAppointmentRowCount=function(e){var t,i=this._getAppointmentReducedHeight(e);switch(e.size){case U.HalfSize:t=1;break;case U.Regular:t=2;if(i&&!e.appointment.getText()&&!e.appointment.getDescription()){t=1}break;case U.Large:t=3;break;case U.Automatic:t=1;if(e.appointment.getText()){t+=1}if(e.appointment.getDescription()){t+=1}break}return t};D.prototype._getAppointmetLevel=function(e,t){var i=0;var n=this._getAppointmentRowCount(t);var a=true;while(a){a=this._isPosibleToPositionAppointment(i,e,n);if(!a){a=true;i+=1}else{a=false}}return i};D.prototype._isPosibleToPositionAppointment=function(e,t,i){for(var n=e;n<i+e;n++){if(t[n]){return false}}return true};D.prototype._getPlanningCalendar=function(){var e=this;while(e.getParent()!==null){if(e.isA("sap.m.PlanningCalendar")){return e}e=e.getParent()}};D.prototype._isNonWorkingInterval=function(e,t,i,n){return t.includes((e+i)%n)};function W(e,t){if(t){O.call(e,"DeselectAppointment")}}function $(e){var t=this.getAggregation("groupAppointments",[]);var i;var n=false;for(var a=0;a<t.length;a++){var r=t[a]._aAppointments;for(var s=0;s<r.length;s++){if(r[s].getId()==e){i=t[a];n=true;break}}if(n){break}}return i}function N(e){if(this._sFocusedAppointmentId!=e){var t=this._getAppointmentsSorted();var i=this._aVisibleAppointments;var n;var a=0;n=$.call(this,e);if(n){e=n.getId();n=undefined}for(a=0;a<i.length;a++){if(i[a].appointment.getId()==e){n=i[a].appointment;break}}if(n){var r=this.getFocusedAppointment().$();var o=n.$();this._sFocusedAppointmentId=n.getId();r.attr("tabindex","-1");o.attr("tabindex","0");o.trigger("focus")}else{for(a=0;a<t.length;a++){if(t[a].getId()==e){n=t[a];break}}if(n){this._sFocusedAppointmentId=n.getId();var p=w.call(this,n.getStartDate());this.setStartDate(s._createLocalDate(p,true));if(!c(this.getDomRef(),document.activeElement)){setTimeout(function(){this.getFocusedAppointment().focus()}.bind(this),0)}this.fireStartDateChange()}}}}function Y(e,t){var i=this._sFocusedAppointmentId;var n=this._getAppointmentsSorted();var a=this.getAggregation("groupAppointments",[]);var r;var s=0;var o=0;for(o=0;o<a.length;o++){if(a[o].getId()==i){var p=a[o]._aAppointments;if(e){i=p[p.length-1].getId()}else{i=p[0].getId()}break}}for(o=0;o<n.length;o++){if(n[o].getId()==i){s=o;break}}if(e){s=s+t}else{s=s-t}if(s<0){s=0}else if(s>=n.length){s=n.length-1}r=n[s];N.call(this,r.getId())}function x(e){var t=this._getAppointmentsSorted();var i;var n=new o(this._getStartDate());var a=new o(this._oUTCEndDate);var r=this.getIntervalType();var p;var l;n.setUTCHours(0);a.setUTCHours(0);a.setUTCMinutes(0);a.setUTCSeconds(0);switch(r){case _.Hour:a.setUTCDate(a.getUTCDate()+1);a.setUTCMilliseconds(-1);break;case _.Day:case _.Week:case _.OneMonth:case"OneMonth":n.setUTCDate(1);a.setUTCMonth(a.getUTCMonth()+1);a.setUTCDate(1);a.setUTCMilliseconds(-1);break;case _.Month:n.setUTCMonth(0);n.setUTCDate(1);a.setUTCFullYear(a.getUTCFullYear()+1);a.setUTCMonth(1);a.setUTCDate(1);a.setUTCMilliseconds(-1);break;default:throw new Error("Unknown IntervalType: "+r+"; "+this)}var u=s._createLocalDate(n,true);var g=s._createLocalDate(a,true);for(var h=0;h<t.length;h++){if(t[h].getStartDate()>=u&&t[h].getStartDate()<=g){i=t[h];p=i.getId();if(e.type=="saphome"){break}}else if(t[h].getStartDate()>g){break}}l=$.call(this,p);if(l){i=l;p=i.getId()}if(p&&p!=this._sFocusedAppointmentId){N.call(this,p)}else if(e._bPlanningCalendar&&i){i.focus()}else{this.fireLeaveRow({type:e.type})}}function B(e,t){var i=this.getIntervalType();var n=this._getStartDate();var a=new o(n.getTime());var r;var p=false;var l=0;var u=0;if(jQuery(t).hasClass("sapUiCalendarRowAppsSubInt")){p=true;var g=jQuery(jQuery(t).parent()).children(".sapUiCalendarRowAppsSubInt");u=g.length;for(l=0;l<u;l++){var h=g[l];if(h==t){break}}}switch(i){case _.Hour:a.setUTCHours(a.getUTCHours()+e);if(p){a.setUTCMinutes(a.getUTCMinutes()+l*60/u);r=new o(a.getTime());r.setUTCMinutes(r.getUTCMinutes()+60/u)}else{r=new o(a.getTime());r.setUTCHours(r.getUTCHours()+1)}break;case _.Day:case _.Week:case _.OneMonth:case"OneMonth":a.setUTCDate(a.getUTCDate()+e);if(p){a.setUTCHours(a.getUTCHours()+l*24/u);r=new o(a.getTime());r.setUTCHours(r.getUTCHours()+24/u)}else{r=new o(a.getTime());r.setUTCDate(r.getUTCDate()+1)}break;case _.Month:a.setUTCMonth(a.getUTCMonth()+e);if(p){a.setUTCDate(a.getUTCDate()+l);r=new o(a.getTime());r.setUTCDate(r.getUTCDate()+1)}else{r=new o(a.getTime());r.setUTCMonth(r.getUTCMonth()+1)}break;default:throw new Error("Unknown IntervalType: "+i+"; "+this)}r.setUTCMilliseconds(r.getUTCMilliseconds()-1);a=s._createLocalDate(a,true);r=s._createLocalDate(r,true);this.fireIntervalSelect({startDate:a,endDate:r,subInterval:p})}function j(e,t){var i=e.getStartDate()-t.getStartDate();if(i==0){i=t.getEndDate()-e.getEndDate()}return i}return D});
//# sourceMappingURL=CalendarRow.js.map