/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/i18n/Formatting","sap/base/i18n/Localization","sap/m/Popover","sap/ui/core/Control","sap/ui/core/Lib","sap/ui/core/LocaleData","sap/ui/unified/calendar/CalendarUtils","./calendar/Header","./calendar/TimesRow","./calendar/DatesRow","./calendar/MonthPicker","./calendar/YearPicker","sap/ui/core/date/UniversalDate","./library","sap/ui/core/format/DateFormat","sap/ui/Device","sap/ui/core/Locale","./CalendarTimeIntervalRenderer","sap/ui/dom/containsOrEquals","sap/base/util/deepEqual","sap/base/Log","sap/ui/unified/DateRange","sap/ui/core/date/UI5Date","sap/ui/unified/Calendar"],function(e,t,a,i,s,r,o,n,h,g,l,c,u,D,_,d,f,p,T,v,M,C,m,U){"use strict";var P=i.extend("sap.ui.unified.CalendarTimeInterval",{metadata:{library:"sap.ui.unified",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},startDate:{type:"object",group:"Data"},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},items:{type:"int",group:"Appearance",defaultValue:12},intervalMinutes:{type:"int",group:"Appearance",defaultValue:60},pickerPopup:{type:"boolean",group:"Appearance",defaultValue:false},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null},_currentPicker:{type:"string",group:"Appearance",defaultValue:"timesRow",visibility:"hidden"}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},header:{type:"sap.ui.unified.calendar.Header",multiple:false,visibility:"hidden"},timesRow:{type:"sap.ui.unified.calendar.TimesRow",multiple:false,visibility:"hidden"},datesRow:{type:"sap.ui.unified.calendar.Month",multiple:false,visibility:"hidden"},monthPicker:{type:"sap.ui.unified.calendar.MonthPicker",multiple:false,visibility:"hidden"},yearPicker:{type:"sap.ui.unified.calendar.YearPicker",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},cancel:{},startDateChange:{}}},renderer:p});var y={TIMES_ROW:"timesRow",DATES_ROW:"datesRow",MONTH_PICKER:"monthPicker",YEAR_PICKER:"yearPicker"};P.prototype.init=function(){this._iMode=0;this._oYearFormat=_.getDateInstance({format:"y"});this.data("sap-ui-fastnavgroup","true",true);this._oMinDate=new u(m.getInstance(Date.UTC(1,0,1)));this._oMinDate.getJSDate().setUTCFullYear(1);this._oMaxDate=new u(m.getInstance(Date.UTC(9999,11,31,23,59,59)));this._initializeHeader();this._initializeTimesRow();this._initializeMonthPicker();this._initializeYearPicker();this.setPickerPopup(false);this._iItemsHead=15};P.prototype._initializeHeader=function(){var e=new n(this.getId()+"--Head"),t=s.getResourceBundleFor("sap.m");e.attachEvent("pressPrevious",this._handlePrevious,this);e.attachEvent("pressNext",this._handleNext,this);this.setAggregation("header",e);if(e){e.setAriaLabelButton0(t.getText("DATETIMEPICKER_DATE"));e.setAriaLabelButton1(t.getText("MOBISCROLL_MONTH"));e.setAriaLabelButton2(t.getText("MOBISCROLL_YEAR"))}};P.prototype._initializeTimesRow=function(){var e=new h(this.getId()+"--TimesRow");e.attachEvent("focus",z,this);e.attachEvent("select",H,this);e._bNoThemeChange=true;this.setAggregation("timesRow",e)};P.prototype._initializeMonthPicker=function(){var e=this._createMonthPicker();this.setAggregation("monthPicker",e);e._setSelectedDatesControlOrigin(this)};P.prototype._initializeYearPicker=function(){var e=this._createYearPicker();this.setAggregation("yearPicker",e);e._setSelectedDatesControlOrigin(this)};P.prototype._createDatesRow=function(){var e=new g(this.getId()+"--DatesRow",{days:18,selectedDates:[new C(this.getId()+"--Range")]});e.attachEvent("focus",K,this);e.attachEvent("select",j,this);e._bNoThemeChange=true;e.getIntervalSelection=function(){return this.getProperty("intervalSelection")};e.getSingleSelection=function(){return this.getProperty("singleSelection")};e.getSelectedDates=function(){return this.getAggregation("selectedDates",[])};e.getSpecialDates=function(){return this.getAggregation("specialDates",[])};e.getAriaLabelledBy=function(){return this.getAssociation("ariaLabelledBy",[])};return e};P.prototype._createMonthPicker=function(){var e=new l(this.getId()+"--MP",{columns:0,months:6});e.attachEvent("select",$,this);e._bNoThemeChange=true;e.attachEvent("pageChange",ee,this);return e};P.prototype._createYearPicker=function(){var e=new c(this.getId()+"--YP",{columns:0,years:6});e.attachEvent("select",q,this);e.attachEvent("pageChange",te,this);e._oMinDate.setYear(this._oMinDate.getUTCFullYear());e._oMaxDate.setYear(this._oMaxDate.getUTCFullYear());return e};P.prototype.exit=function(){if(this._oPopup){this._oPopup.destroy();this._oPopup=null}if(this._oCalendar){this._oCalendar.removeDelegate(this._oFocusCalendarDelegate);this._oCalendar.destroy();this._oCalendar=null}if(this._sInvalidateContent){clearTimeout(this._sInvalidateContent)}};P.prototype.onBeforeRendering=function(){var e=this.getAggregation("timesRow");var t=this._getFocusedDate();I.call(this);e.displayDate(o._createLocalDate(t,true))};P.prototype._setAriaRole=function(e){var t=this.getAggregation("timesRow");t._setAriaRole(e);t.invalidate();return this};P.prototype._getCalendar=function(){var e;if(!this._oCalendar){e=new U(this.getId()+"--Cal",{});e.attachEvent("select",W,this);e.attachEvent("cancel",function(e){this._oPopup.close();var t=this.getAggregation("header").getDomRef("B1");if(t){t.focus()}},this);this._oFocusCalendarDelegate={onAfterRendering:function(){this.focus()}};e.addDelegate(this._oFocusCalendarDelegate,e);this._oCalendar=e}return this._oCalendar};P.prototype._getMonthPicker=function(){return this.getAggregation("monthPicker")};P.prototype._getYearPicker=function(){return this.getAggregation("yearPicker")};P.prototype.setStartDate=function(e){o._checkJSDateObject(e);if(v(this.getStartDate(),e)){return this}var t=e.getFullYear();o._checkYearInValidRange(t);var a=this.getMinDate();if(a&&e.getTime()<a.getTime()){M.warning("startDate < minDate -> minDate as startDate set",this);e=m.getInstance(a)}var i=this.getMaxDate();if(i&&e.getTime()>i.getTime()){M.warning("startDate > maxDate -> maxDate as startDate set",this);e=m.getInstance(i)}this.setProperty("startDate",e);var s=this.getAggregation("timesRow");s.setStartDate(e);this._oUTCStartDate=new u(s._getStartDate().getTime());I.call(this);var r=o._createLocalDate(this._getFocusedDate(),true);if(!s.checkDateFocusable(r)){this._setFocusedDate(this._oUTCStartDate);s.displayDate(e)}return this};P.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var e=this.removeAllAggregation("selectedDates");return e};P.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var e=this.destroyAggregation("selectedDates");return e};P.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var e=this.removeAllAggregation("specialDates");return e};P.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var e=this.destroyAggregation("specialDates");return e};P.prototype.setIntervalMinutes=function(e){if(e>=720){throw new Error("Only intervals < 720 minutes are allowed; "+this)}if(1440%e>0){throw new Error("A day must be divisible by the interval size; "+this)}this.setProperty("intervalMinutes",e);var t=this.getAggregation("timesRow");var a=o._createLocalDate(this._getFocusedDate(),true);if(!t.checkDateFocusable(a)){var i=k.call(this);this._setFocusedDate(i);t.setDate(o._createLocalDate(i,true))}return this};P.prototype.setLocale=function(e){if(this._sLocale!=e){this._sLocale=e;this._oLocaleData=undefined;this.invalidate()}return this};P.prototype.getLocale=function(){if(!this._sLocale){this._sLocale=new f(e.getLanguageTag()).toString()}return this._sLocale};P.prototype._getFocusedDate=function(){if(!this._oFocusedDate){F.call(this)}return this._oFocusedDate};P.prototype._setFocusedDate=function(e){if(!(e instanceof u)){throw new Error("Date must be a UniversalDate object "+this)}this._oFocusedDate=new u(e.getTime())};P.prototype.focusDate=function(e){var t=false;var a=this.getAggregation("timesRow");if(!a.checkDateFocusable(e)){var i=o._createUniversalUTCDate(e,undefined,true);X.call(this,i);t=true}J.call(this,e,false);if(t){this.fireStartDateChange()}return this};P.prototype.displayDate=function(e){J.call(this,e,true);return this};P.prototype.setItems=function(e){this.setProperty("items",e);e=this._getItems();var t=this.getAggregation("timesRow");t.setItems(e);var a=o._createLocalDate(this._getFocusedDate(),true);if(!t.checkDateFocusable(a)){var i=k.call(this);this._setFocusedDate(i);t.setDate(o._createLocalDate(i,true))}if(!this.getPickerPopup()){var s=this.getAggregation("datesRow");var r=Math.floor(e*1.5);if(r>31){r=31}s.setDays(r);var n=this._getMonthPicker();var h=Math.floor(e/2);if(h>12){h=12}n.setMonths(h);var g=this._getYearPicker();var l=Math.floor(e/2);if(l>20){l=20}g.setYears(l)}I.call(this);return this};P.prototype._getItems=function(){var e=this.getItems();if(d.system.phone&&e>6){return 6}else{return e}};P.prototype._getLocaleData=function(){if(!this._oLocaleData){var e=this.getLocale();var t=new f(e);this._oLocaleData=r.getInstance(t)}return this._oLocaleData};P.prototype.setPickerPopup=function(e){var t=this.getAggregation("header"),a,i,s;this.setProperty("pickerPopup",e);if(a){a.destroy()}if(e){t.setVisibleButton0(false);t.setVisibleButton1(true);t.setVisibleButton2(false);t.detachEvent("pressButton1",N,this);t.attachEvent("pressButton1",N,this);if(this.getAggregation("datesRow")){this.getAggregation("datesRow").destroy()}if(this._getMonthPicker()){this._getMonthPicker().destroy()}if(this._getYearPicker()){this._getYearPicker().destroy()}}else{t.setVisibleButton0(true);t.setVisibleButton1(true);t.setVisibleButton2(true);t.detachEvent("pressButton0",B,this);t.attachEvent("pressButton0",B,this);t.detachEvent("pressButton1",N,this);t.attachEvent("pressButton1",N,this);t.detachEvent("pressButton2",V,this);t.attachEvent("pressButton2",V,this);if(!this.getAggregation("datesRow")){this.setAggregation("datesRow",this._createDatesRow())}if(!this._getYearPicker()){this.setAggregation("yearPicker",this._createYearPicker())}if(!this._getMonthPicker()){this.setAggregation("monthPicker",this._createMonthPicker())}i=this._getMonthPicker();s=this._getYearPicker();i.setColumns(0);i.setMonths(6);s.setColumns(0);s.setYears(6)}return this};P.prototype.setMinDate=function(e){var t,a,i,s;if(v(e,this.getMinDate())){return this}if(!e){o._updateUTCDate(this._oMinDate.getJSDate(),1,0,1,0,0,0,0)}else{o._checkJSDateObject(e);this._oMinDate=o._createUniversalUTCDate(e,undefined,true);t=this.getAggregation("timesRow");this._oMinDate=t._getIntervalStart(this._oMinDate);a=this._oMinDate.getUTCFullYear();o._checkYearInValidRange(a);if(this._oMaxDate.getTime()<this._oMinDate.getTime()){M.warning("minDate > maxDate -> maxDate set to end of the month",this);this._oMaxDate=o._createUniversalUTCDate(e,undefined,true);o._updateUTCDate(this._oMaxDate,null,this._oMaxDate.getUTCMonth()+1,0,23,59,59,0);this.setProperty("maxDate",o._createLocalDate(this._oMaxDate,true))}if(this._oFocusedDate){if(this._oFocusedDate.getTime()<this._oMinDate.getTime()){M.warning("focused date < minDate -> minDate focused",this);this.focusDate(e)}}if(this._oUTCStartDate&&this._oUTCStartDate.getTime()<this._oMinDate.getTime()){M.warning("start date < minDate -> minDate set as start date",this);w.call(this,new u(this._oMinDate.getTime()),true,true)}}this.setProperty("minDate",e);if(this.getPickerPopup()){s=this._getCalendar();s.setMinDate(e)}else{i=this._getYearPicker();i._oMinDate.setYear(this._oMinDate.getUTCFullYear())}return this};P.prototype.setMaxDate=function(e){var t,a,i,s,r,n;if(v(e,this.getMaxDate())){return this}if(!e){o._updateUTCDate(this._oMaxDate.getJSDate(),9999,11,31,23,59,59,0)}else{o._checkJSDateObject(e);this._oMaxDate=o._createUniversalUTCDate(e,undefined,true);t=this.getAggregation("timesRow");this._oMaxDate=t._getIntervalStart(this._oMaxDate);this._oMaxDate.setUTCMinutes(this._oMaxDate.getUTCMinutes()+this.getIntervalMinutes());this._oMaxDate.setUTCMilliseconds(-1);a=this._oMaxDate.getUTCFullYear();o._checkYearInValidRange(a);if(this._oMinDate.getTime()>this._oMaxDate.getTime()){M.warning("maxDate < minDate -> minDate set to begin of the month",this);this._oMinDate=o._createUniversalUTCDate(e,undefined,true);o._updateUTCDate(this._oMinDate,null,null,1,0,0,0,0);this.setProperty("minDate",o._createLocalDate(this._oMinDate,true))}if(this._oFocusedDate){if(this._oFocusedDate.getTime()>this._oMaxDate.getTime()){M.warning("focused date > maxDate -> maxDate focused",this);this.focusDate(e)}}if(this._oUTCStartDate){i=new u(this._oUTCStartDate.getTime());i.setUTCMinutes(i.getUTCMinutes()+this.getIntervalMinutes()*(this._getItems()-1));if(i.getTime()>this._oMaxDate.getTime()){s=new u(this._oMaxDate.getTime());s.setUTCMinutes(s.getUTCMinutes()-this.getIntervalMinutes()*(this._getItems()-1));if(s.getTime()>=this._oMinDate.getTime()){M.warning("end date > maxDate -> maxDate set as end date",this);w.call(this,s,true,true)}}}}this.setProperty("maxDate",e);if(this.getPickerPopup()){n=this._getCalendar();n.setMaxDate(e)}else{r=this._getYearPicker();r._oMaxDate.setYear(this._oMaxDate.getUTCFullYear())}return this};P.prototype.onclick=function(e){if(e.isMarked("delayedMouseEvent")){return}if(e.target.id==this.getId()+"-cancel"){this.onsapescape(e)}};P.prototype.onmousedown=function(e){e.preventDefault();e.setMark("cancelAutoClose")};P.prototype.onsapescape=function(e){if(this.getPickerPopup()){b.call(this);this.fireCancel()}else{switch(this._iMode){case 0:this.fireCancel();break;case 1:case 2:case 3:this.setProperty("_currentPicker",y.TIMES_ROW);break}}};P.prototype.setProperty=function(){var e=arguments[0],t=arguments[1];i.prototype.setProperty.apply(this,arguments);if(e==="_currentPicker"){switch(t){case"timesRow":this._iMode=0;break;case"datesRow":this._iMode=1;break;case"monthPicker":this._iMode=2;break;case"yearPicker":this._iMode=3;break;default:return}}return this};P.prototype._handlePrevious=function(e){var t=this._getFocusedDate(),a,i,s,r,n,h,g,l;switch(this._iMode){case 0:a=this._getItems();i=new u(k.call(this).getTime());s=this.getIntervalMinutes();i.setUTCMinutes(i.getUTCMinutes()-a*s);t.setUTCMinutes(t.getUTCMinutes()-a*s);this._setFocusedDate(t);w.call(this,i,true);break;case 1:if(!this.getPickerPopup()){r=this.getAggregation("datesRow");n=o._createUniversalUTCDate(r.getDate());h=r.getDays();if(n.getUTCDate()<=h){n.setUTCDate(1)}else{n.setUTCDate(n.getUTCDate()-h)}G.call(this,n)}break;case 2:if(!this.getPickerPopup()){g=this._getMonthPicker();if(g.getMonths()<12){g.previousPage();Y.call(this)}else{t.setUTCFullYear(t.getUTCFullYear()-1);X.call(this,t);this._setFocusedDate(t);I.call(this);Z.call(this,t.getUTCFullYear(),g);this.fireStartDateChange()}}break;case 3:if(!this.getPickerPopup()){l=this._getYearPicker();l.previousPage();E.call(this)}break}};P.prototype._handleNext=function(e){var t=this._getFocusedDate();switch(this._iMode){case 0:var a=this._getItems();var i=new u(k.call(this).getTime());var s=this.getIntervalMinutes();i.setUTCMinutes(i.getUTCMinutes()+a*s);t.setUTCMinutes(t.getUTCMinutes()+a*s);this._setFocusedDate(t);w.call(this,i,true);break;case 1:if(!this.getPickerPopup()){var r=this.getAggregation("datesRow");var n=o._createUniversalUTCDate(r.getDate());var h=new u(n.getTime());h.setUTCDate(1);h.setUTCMonth(h.getUTCMonth()+1);h.setUTCDate(0);var g=r.getDays();if(n.getUTCDate()+g>h.getUTCDate()){n.setUTCDate(h.getUTCDate())}else{n.setUTCDate(n.getUTCDate()+g)}G.call(this,n)}break;case 2:if(!this.getPickerPopup()){var l=this._getMonthPicker();if(l.getMonths()<12){l.nextPage();Y.call(this)}else{t.setUTCFullYear(t.getUTCFullYear()+1);X.call(this,t);this._setFocusedDate(t);I.call(this);Z.call(this,t.getUTCFullYear(),l);this.fireStartDateChange()}}break;case 3:if(!this.getPickerPopup()){var c=this._getYearPicker();c.nextPage();E.call(this)}break}};P.prototype._getShowItemHeader=function(){var e=this.getItems();if(e>this._iItemsHead){return true}else{return false}};function w(e,t,a){var i=new u(this._oMaxDate.getTime());i.setUTCMinutes(i.getUTCMinutes()-this.getIntervalMinutes()*(this._getItems()-1));if(i.getTime()<this._oMinDate.getTime()){i=new u(this._oMinDate.getTime());i.setUTCMinutes(i.getUTCMinutes()+this.getIntervalMinutes()*(this._getItems()-1))}if(e.getTime()<this._oMinDate.getTime()){e=new u(this._oMinDate.getTime())}else if(e.getTime()>i.getTime()){e=i}var s=this.getAggregation("timesRow");var r=o._createLocalDate(e,true);s.setStartDate(r);this._oUTCStartDate=new u(s._getStartDate().getTime());r=o._createLocalDate(this._oUTCStartDate,true);this.setProperty("startDate",r);I.call(this);if(t){var n=o._createLocalDate(this._getFocusedDate(),true);if(!s.checkDateFocusable(n)){this._setFocusedDate(e);s.setDate(r)}else{s.setDate(n)}}if(!a){this.fireStartDateChange()}}function k(){if(!this._oUTCStartDate){var e=this.getAggregation("timesRow");e.setStartDate(o._createLocalDate(this._getFocusedDate(),true));this._oUTCStartDate=new u(e._getStartDate().getTime());this._setFocusedDate(this._oUTCStartDate)}return this._oUTCStartDate}function S(e){var t=this._getFocusedDate();var a=this.getAggregation("timesRow");if(!e){a.setDate(o._createLocalDate(t,true))}else{a.displayDate(o._createLocalDate(t,true))}I.call(this)}function F(){var e=this.getSelectedDates();if(e&&e[0]&&e[0].getStartDate()){this._oFocusedDate=o._createUniversalUTCDate(e[0].getStartDate(),undefined,true)}else{var t=m.getInstance();this._oFocusedDate=o._createUniversalUTCDate(t,undefined,true)}if(this._oFocusedDate.getTime()<this._oMinDate.getTime()){this._oFocusedDate=new u(this._oMinDate.getTime())}else if(this._oFocusedDate.getTime()>this._oMaxDate.getTime()){this._oFocusedDate=new u(this._oMaxDate.getTime())}}P.prototype._showCalendarPicker=function(){var e=o._createLocalDate(this._getFocusedDate(),true);var t=this._getCalendar();var a=new C({startDate:e});t.displayDate(e,false);t.removeAllSelectedDates();t.addSelectedDate(a);t.setMinDate(this.getMinDate());t.setMaxDate(this.getMaxDate());Q.call(this,t);this._showOverlay()};P.prototype._showOverlay=function(){this.$("contentOver").css("display","")};P.prototype._hideOverlay=function(){this.$("contentOver").css("display","none")};function b(e){if(this._oPopup&&this._oPopup.isOpen()){this._oPopup.close()}this._hideOverlay();if(!e){S.call(this)}this._getCalendar()._closePickers()}function R(){var e=this._getFocusedDate();var t=this._getItems();var a=this.getAggregation("datesRow");var i=a.getSelectedDates()[0];i.setStartDate(o._createLocalDate(e,true));var s=new u(e.getTime());s.setUTCDate(1);s.setUTCMonth(s.getUTCMonth()+1);s.setUTCDate(0);var r=s.getUTCDate();var n=Math.floor(t*1.5);if(n>r){n=r}a.setDays(n);this.setProperty("_currentPicker",y.DATES_ROW);this._showOverlay();G.call(this,e);this._iMode=1}function x(){var e=this._getFocusedDate();var t=this._getMonthPicker();this.setProperty("_currentPicker",y.MONTH_PICKER);this._showOverlay();t.setMonth(e.getUTCMonth());Z.call(this,e.getUTCFullYear(),t);this._iMode=2;Y.call(this)}function A(){var e=this._getFocusedDate();var t=this._getYearPicker();this.setProperty("_currentPicker",y.YEAR_PICKER);this._showOverlay();t.setDate(e.getJSDate());E.call(this);this._iMode=3}function I(){L.call(this);Y.call(this)}function Y(e){var t=new u(k.call(this).getTime());var a=this._getItems();var i=t.getJSDate().getUTCFullYear();var s=this._oMaxDate.getJSDate().getUTCFullYear();var r=this._oMinDate.getJSDate().getUTCFullYear();var o=t.getJSDate().getUTCMonth();var n=this._oMaxDate.getJSDate().getUTCMonth();var h=this._oMinDate.getJSDate().getUTCMonth();var g=t.getJSDate().getUTCDate();var l=this._oMaxDate.getJSDate().getUTCDate();var c=this._oMinDate.getJSDate().getUTCDate();var D=t.getJSDate().getUTCHours();var _=this._oMaxDate.getJSDate().getUTCHours();var d=this._oMinDate.getJSDate().getUTCHours();var f=t.getJSDate().getUTCMinutes();var p=this._oMaxDate.getJSDate().getUTCMinutes();var T=this._oMinDate.getJSDate().getUTCMinutes();var v=this.getAggregation("header");if(this._iMode==2&&!e){var M=this._getMonthPicker();var C=M.getMonths();var m=M.getStartMonth();var U=m+C-1;if(m==0||i==r&&m<=h){v.setEnabledPrevious(false)}else{v.setEnabledPrevious(true)}if(U>10||i==s&&U>=n){v.setEnabledNext(false)}else{v.setEnabledNext(true)}return}if(i<r||i==r&&(e||(o<h||o==h&&(g<c||g==c&&(D<d||D==d&&f<=T))))||(this._iMode==1||this._iMode==2)&&this.getPickerPopup()){v.setEnabledPrevious(false)}else{v.setEnabledPrevious(true)}t.setUTCMinutes(t.getUTCMinutes()+a*this.getIntervalMinutes()-1);i=t.getJSDate().getUTCFullYear();o=t.getJSDate().getUTCMonth();g=t.getJSDate().getUTCDate();D=t.getJSDate().getUTCHours();f=t.getJSDate().getUTCMinutes();if(i>s||i==s&&(!e||(o>n||o==n&&(g>l||g==l&&(D>_||D==_&&f>=p))))||(this._iMode==1||this._iMode==2)&&this.getPickerPopup()){v.setEnabledNext(false)}else{v.setEnabledNext(true)}if(this._iMode===1){var P=new u(t.getTime());P.setUTCDate(1);P.setUTCMonth(P.getUTCMonth()+1);P.setUTCDate(0);var y=this.getAggregation("datesRow").getDays();t.setUTCDate(1+(Math.ceil(t.getUTCDate()/y)-1)*y);if(P.getUTCDate()-t.getUTCDate()<y){t.setUTCDate(P.getUTCDate()-y+1)}g=t.getUTCDate();if(g<=1||i==r&&o==h&&g<=c){v.setEnabledPrevious(false)}else{v.setEnabledPrevious(true)}if(g+y>=P.getUTCDate()||i==s&&o==n&&g>=l){v.setEnabledNext(false)}else{v.setEnabledNext(true)}}}function E(){var e=this._getYearPicker();var t=e.getYears();var a=o._createUniversalUTCDate(e.getProperty("_middleDate").toLocalJSDate());a.setUTCFullYear(a.getUTCFullYear()+Math.floor(t/2));var i=this.getAggregation("header");var s=new u(this._oMaxDate);s.setUTCFullYear(s.getUTCFullYear()-Math.ceil(t/2));s.setUTCMonth(11,31);var r=new u(this._oMinDate);r.setUTCFullYear(r.getUTCFullYear()+Math.floor(t/2)+1);r.setUTCMonth(0,1);if(a.getTime()>s.getTime()){i.setEnabledNext(false)}else{i.setEnabledNext(true)}if(a.getTime()<r.getTime()){i.setEnabledPrevious(false)}else{i.setEnabledPrevious(true)}}function L(){var e=this.getAggregation("header");var t;var a=k.call(this);var i;var s=this._getLocaleData();var r=[];var n=[];var h;var g=false;var l;var c=false;if(s.oLocale.sLanguage.toLowerCase()==="ja"||s.oLocale.sLanguage.toLowerCase()==="zh"){l=_.getDateInstance({format:"d"}).format(a,true)}else{l=a.getUTCDate().toString()}if(this._bLongMonth||!this._bNamesLengthChecked){r=s.getMonthsStandAlone("wide")}else{g=true;r=s.getMonthsStandAlone("abbreviated");n=s.getMonthsStandAlone("wide")}var u=a.getUTCMonth();t=r[u];if(g){h=n[r[u]]}if(!this.getPickerPopup()){e.setTextButton0(l);e.setTextButton1(t);e.setTextButton2(this._oYearFormat.format(a,true))}else{i=_.getInstance({style:"long",strictParsing:true,relative:c},s.oLocale);h=l=i.format(o._createLocalDate(a,true));e.setTextButton1(l)}if(g){e.setAriaLabelButton1(h)}}function O(e,t){var a;var i=false;if(e.getTime()<this._oMinDate.getTime()){a=this._oMinDate;i=true}else if(e.getTime()>this._oMaxDate.getTime()){a=this._oMaxDate;i=true}else{a=e}this._setFocusedDate(a);if(i||t){X.call(this,a);S.call(this,false);this.fireStartDateChange()}}function J(e,t){if(e&&(!this._oFocusedDate||this._oFocusedDate.getTime()!=e.getTime())){o._checkJSDateObject(e);e=o._createUniversalUTCDate(e,undefined,true);var a=e.getUTCFullYear();o._checkYearInValidRange(a);if(e.getTime()<this._oMinDate.getTime()||e.getTime()>this._oMaxDate.getTime()){throw new Error("Date must not be in valid range (minDate and maxDate); "+this)}this._setFocusedDate(e);if(this.getDomRef()&&this._iMode==0){S.call(this,t)}}}function B(e){if(this._iMode!=1){R.call(this)}else{this.setProperty("_currentPicker",y.TIMES_ROW)}}function N(e){var t;if(this.getPickerPopup()){this._showCalendarPicker()}else{if(this._iMode!=2){t=function(){var e=this._getMonthPicker();e._oItemNavigation.focusItem(e.getProperty("_focusedMonth"));e.removeDelegate(t)};x.call(this);this._getMonthPicker().addDelegate({onAfterRendering:t},this)}else{this.setProperty("_currentPicker",y.TIMES_ROW)}}}function V(e){var t;if(this._iMode!=3){t=function(){var e=this._getYearPicker();e.focus();e.removeDelegate(t)};A.call(this);this._getYearPicker().addDelegate({onAfterRendering:t},this)}else{this.setProperty("_currentPicker",y.TIMES_ROW)}}function H(e){this.fireSelect()}function z(e){var t=o._createUniversalUTCDate(e.getParameter("date"),undefined,true);var a=e.getParameter("notVisible");O.call(this,t,a)}function W(e){var t=e.getSource(),a=t.getSelectedDates()[0].getStartDate();var i=new u(this._getFocusedDate().getTime());var s=o._createUniversalUTCDate(a);i.setUTCFullYear(s.getUTCFullYear());i.setUTCMonth(s.getUTCMonth(),s.getUTCDate());O.call(this,i,true);b.call(this)}function j(e){var t=new u(this._getFocusedDate().getTime());var a=e.oSource;var i=a.getSelectedDates()[0];var s=o._createUniversalUTCDate(i.getStartDate());if(!this.getPickerPopup()||s.getUTCMonth()==t.getUTCMonth()){t.setUTCDate(s.getUTCDate());t.setUTCMonth(s.getUTCMonth());t.setUTCFullYear(s.getUTCFullYear());O.call(this,t,true);this.setProperty("_currentPicker",y.TIMES_ROW)}this._addTimesRowFocusDelegate()}function K(e){var t=new u(this._getFocusedDate().getTime());var a=o._createUniversalUTCDate(e.getParameter("date"),undefined,true);var i=e.getParameter("otherMonth");if(i&&a.getUTCMonth()==t.getUTCMonth()&&a.getUTCFullYear()==t.getUTCFullYear()){G.call(this,a)}}function $(e){var t=new u(this._getFocusedDate().getTime());var a=this._getMonthPicker();var i=a.getMonth();t.setUTCMonth(i);if(i!=t.getUTCMonth()){t.setUTCDate(0)}O.call(this,t,true);this.setProperty("_currentPicker",y.TIMES_ROW);this._addTimesRowFocusDelegate()}function q(e){var t=new u(this._getFocusedDate().getTime());var a=this._getYearPicker();var i=o._createUniversalUTCDate(a.getDate());var s=t.getUTCMonth();i.setUTCMonth(t.getUTCMonth(),t.getUTCDate());i.setUTCHours(t.getUTCHours());i.setUTCMinutes(t.getUTCMinutes());t=i;if(s!=t.getUTCMonth()){t.setUTCDate(0)}O.call(this,t,true);this.setProperty("_currentPicker",y.TIMES_ROW);this._addTimesRowFocusDelegate()}P.prototype._addTimesRowFocusDelegate=function(){var e={onAfterRendering:function(){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex());this.removeDelegate(e)}},t=this.getAggregation("timesRow");t.addDelegate(e,t)};function X(e){var t=this.getAggregation("timesRow");var a=k.call(this);var i=t._oItemNavigation.getFocusedIndex();a=new u(e.getTime());a.setUTCMinutes(a.getUTCMinutes()-i*this.getIntervalMinutes());w.call(this,a,false,true)}function G(e){var t=this.getAggregation("datesRow");var a=this.getAggregation("header");if(!this.getPickerPopup()){var i=new u(e.getTime());i.setUTCDate(1);i.setUTCMonth(i.getUTCMonth()+1);i.setUTCDate(0);var s=t.getDays();var r=new u(e.getTime());r.setUTCDate(1+(Math.ceil(e.getUTCDate()/s)-1)*s);if(i.getUTCDate()-r.getUTCDate()<s){r.setUTCDate(i.getUTCDate()-s+1)}t.setStartDate(o._createLocalDate(r,true));var n=r.getJSDate().getUTCFullYear();var h=this._oMaxDate.getJSDate().getUTCFullYear();var g=this._oMinDate.getJSDate().getUTCFullYear();var l=r.getJSDate().getUTCMonth();var c=this._oMaxDate.getJSDate().getUTCMonth();var D=this._oMinDate.getJSDate().getUTCMonth();var _=r.getJSDate().getUTCDate();var d=this._oMaxDate.getJSDate().getUTCDate();var f=this._oMinDate.getJSDate().getUTCDate();if(_<=1||n==g&&l==D&&_<=f){a.setEnabledPrevious(false)}else{a.setEnabledPrevious(true)}if(_+s>=i.getUTCDate()||n==h&&l==c&&_>=d){a.setEnabledNext(false)}else{a.setEnabledNext(true)}if(!this._oFocusDatesRowDelegate){this._oFocusDatesRowDelegate={onAfterRendering:function(){this.focus()}};t.addDelegate(this._oFocusDatesRowDelegate,t)}}else{a.setEnabledPrevious(false);a.setEnabledNext(false)}t.setDate(o._createLocalDate(e,true))}function Q(e){if(!this._oPopup){var i=new a({placement:"VerticalPreferredBottom",showHeader:false,showArrow:false,verticalScrolling:false});i.oPopup.setDurations(0,0);i.addEventDelegate({onsapescape:this._oCalendar.onsapescape},this._oCalendar);this._oPopup=i}this._oPopup.addContent(e);this._oPopup.attachAfterClose(function(){this._hideOverlay();this._addTimesRowFocusDelegate()},this);this._oPopup.attachAfterOpen(function(){var e=s.$("B1");var a=this._oPopup.$();var i=Math.floor((a.width()-e.width())/2);this._oPopup.setOffsetX(t.getRTL()?i:-i);var r=e.height();this._oPopup.setOffsetY(this._oPopup._getCalculatedPlacement()==="Top"?r:-r)},this);var s=this.getAggregation("header");this._oPopup.openBy(s.getDomRef("B1"))}function Z(e,t){var a=0;var i=11;if(e==this._oMinDate.getUTCFullYear()){a=this._oMinDate.getUTCMonth()}if(e==this._oMaxDate.getUTCFullYear()){i=this._oMaxDate.getUTCMonth()}t.setMinMax(a,i)}function ee(e){Y.call(this)}function te(e){E.call(this)}return P});
//# sourceMappingURL=CalendarTimeInterval.js.map