/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/i18n/Localization","sap/ui/core/Element","sap/ui/core/Control","sap/ui/Device","sap/ui/core/Popup","./MenuItemBase","./MenuItem","./library","sap/ui/core/Core","sap/ui/core/library","sap/ui/core/RenderManager","sap/ui/unified/MenuRenderer","sap/ui/dom/containsOrEquals","sap/ui/thirdparty/jquery","sap/ui/events/KeyCodes","sap/base/Log","sap/ui/events/ControlEvents","sap/ui/events/PseudoEvents","sap/ui/events/checkMouseEnterOrLeave"],function(e,t,i,o,n,s,r,u,a,p,h,f,l,jQuery,d,c,g,m,y){"use strict";var v=n.Dock;var b=p.OpenState;var I=p.ItemSelectionMode;var _=i.extend("sap.ui.unified.Menu",{metadata:{interfaces:["sap.ui.core.IContextMenu"],library:"sap.ui.unified",properties:{enabled:{type:"boolean",group:"Behavior",defaultValue:true},ariaDescription:{type:"string",group:"Accessibility",defaultValue:null,deprecated:true},maxVisibleItems:{type:"int",group:"Behavior",defaultValue:0},pageSize:{type:"int",group:"Behavior",defaultValue:5}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.unified.IMenuItem",multiple:true,singularName:"item",defaultClass:r}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{itemSelect:{parameters:{item:{type:"sap.ui.unified.MenuItemBase"}}},closed:{},beforeClose:{allowPreventDefault:true}}},renderer:f});(function(r){_.prototype.bCozySupported=true;_._DELAY_SUBMENU_TIMER=300;_._DELAY_SUBMENU_TIMER_EXT=400;_.prototype.init=function(){var e=this;this.bOpen=false;this.oOpenedSubMenu=null;this.oHoveredItem=null;this.oPopup=null;this._bOpenedAsContextMenu=false;this.fAnyEventHandlerProxy=jQuery.proxy(function(e){var t=this.getRootMenu();if(t!=this||!this.isOpen()||!this.getDomRef()||e.type!="mousedown"&&e.type!="touchstart"){return}t.handleOuterEvent(this.getId(),e)},this);this.fOrientationChangeHandler=function(){e.close()};this.bUseTopStyle=false};_.prototype._setCustomEnhanceAccStateFunction=function(e){this._fnCustomEnhanceAccStateFunction=e};_.prototype.enhanceAccessibilityState=function(e,t){var i=typeof this._fnCustomEnhanceAccStateFunction==="function";if(i){this._fnCustomEnhanceAccStateFunction(e,t)}};_.prototype.exit=function(){if(this.oPopup){this.oPopup.detachClosed(this._menuClosed,this);this.oPopup.destroy();delete this.oPopup}g.unbindAnyEvent(this.fAnyEventHandlerProxy);if(this._bOrientationChangeBound){jQuery(r).off("orientationchange",this.fOrientationChangeHandler);this._bOrientationChangeBound=false}this._resetDelayedRerenderItems();this._detachResizeHandler()};_.prototype.invalidate=function(e){if(e instanceof s&&this.getDomRef()){this._delayedRerenderItems()}else if(this.oPopup&&this.oPopup.isOpen()){i.prototype.invalidate.apply(this,arguments)}};_.prototype.onBeforeRendering=function(){this._resetDelayedRerenderItems();this.$().off("mousemove")};_.prototype.onAfterRendering=function(){if(this.$().parent().attr("id")!="sap-ui-static"){c.error("sap.ui.unified.Menu: The Menu is popup based and must not be rendered directly as content of the page.");this.close();this.$().remove()}var e=this._getItems();for(var t=0;t<e.length;t++){if(e[t].onAfterRendering&&e[t].getDomRef()){e[t].onAfterRendering()}}if(this.oHoveredItem){this.oHoveredItem.hover(true,this)}S(this);this.$().on("mousemove",this._focusMenuItem.bind(this))};_.prototype._focusMenuItem=function(e){if(!o.system.desktop){return}var t=this.getItemByDomRef(e.target);if(!this.isOpen()||!t){return}if(this.oOpenedSubMenu&&l(this.oOpenedSubMenu.getDomRef(),e.target)){return}this.setHoveredItem(t);var i=t&&t.getDomRef()!==document.activeElement;if(i){t.focus(this)}this._openSubMenuDelayed(t)};_.prototype.onThemeChanged=function(){if(this.getDomRef()&&this.getPopup().getOpenState()===b.OPEN){S(this);this.getPopup()._applyPosition(this.getPopup()._oLastPosition)}};_.prototype.addItem=function(e){this.addAggregation("items",e,!!this.getDomRef());this._delayedRerenderItems();return this};_.prototype.insertItem=function(e,t){this.insertAggregation("items",e,t,!!this.getDomRef());this._delayedRerenderItems();return this};_.prototype.removeItem=function(e){this.removeAggregation("items",e,!!this.getDomRef());this._delayedRerenderItems();return this};_.prototype.removeAllItems=function(){var e=this.removeAllAggregation("items",!!this.getDomRef());this._delayedRerenderItems();return e};_.prototype.destroyItems=function(){this.destroyAggregation("items",!!this.getDomRef());this._delayedRerenderItems();return this};_.prototype._delayedRerenderItems=function(){if(!this.getDomRef()){return}this._resetDelayedRerenderItems();this._discardOpenSubMenuDelayed();this._itemRerenderTimer=setTimeout(function(){var e=this.getDomRef();if(e){var t=(new h).getInterface();f.renderItems(t,this);t.flush(e);t.destroy();this.onAfterRendering();this.getPopup()._applyPosition(this.getPopup()._oLastPosition)}}.bind(this),0)};_.prototype._resetDelayedRerenderItems=function(){if(this._itemRerenderTimer){clearTimeout(this._itemRerenderTimer);delete this._itemRerenderTimer}};_.prototype._detachResizeHandler=function(){if(this._hasResizeListener){o.resize.detachHandler(this._handleResizeChange,this);this._hasResizeListener=false}};_.prototype.open=function(e,t,i,n,s,u,a){var h;this._bLeavingMenu=false;if(this.isOpen()){return}p(this,true);this.oOpenerRef=t;this.bIgnoreOpenerDOMRef=false;this.getPopup().open(0,i,n,s,u||"0 0",a||"flipfit flipfit",function(e){var t=this.getPopup()._getOfDom(s);if(!t||!jQuery(t).is(":visible")||!M(t)){this.close()}else{this.getPopup()._applyPosition(e.lastPosition)}}.bind(this));this.bOpen=this.getPopup().isOpen();o.resize.attachHandler(this._handleResizeChange,this);this._hasResizeListener=true;if(e||this.getRootMenu().getId()===this.getId()){h=this.getNextSelectableItem(-1);this.setHoveredItem(h);h&&h.focus(this)}g.bindAnyEvent(this.fAnyEventHandlerProxy);if(o.support.orientation&&this.getRootMenu()===this){jQuery(r).on("orientationchange",this.fOrientationChangeHandler);this._bOrientationChangeBound=true}};_.prototype._handleResizeChange=function(){this.getPopup()._applyPosition(this.getPopup()._oLastPosition)};_.prototype.openAsContextMenu=function(i,o){var n,s,r,u,a;o=o instanceof t?o.getDomRef():o;if(i instanceof jQuery.Event){a=jQuery(o).offset();n=i.pageX-a.left;s=i.pageY-a.top;this._iX=i.clientX;this._iY=i.clientY}else{n=i.offsetX||0;s=i.offsetY||0;this._iX=i.left||0;this._iY=i.top||0}r=e.getRTL();u=v;if(r){n=o.clientWidth-n}this._bOpenedAsContextMenu=true;this.open(true,o,u.BeginTop,u.BeginTop,o,n+" "+s,"fit")};_.prototype._handleOpened=function(){var t,i,o,n,s,u,a,p,h,f;if(!this._bOpenedAsContextMenu){return}t=this.$();i=jQuery(r);o=this._iX;n=this._iY;s=i.scrollLeft()+i.width();u=i.scrollTop()+i.height();a=e.getRTL();p=false;h=t.width();f=t.height();if(n+f>u){n=n-f;p=true}if(a){if(s-o+h>s){o=s-(o+h);p=true}else{o=s-o;p=true}}else{if(o+h>s){o=o-h;p=true}}this._bOpenedAsContextMenu=false;p&&this.oPopup.setPosition("begin top","begin top",i,o+" "+n,"flipfit")};_.prototype.close=function(e){if(!this.isOpen()||_._dbg){return}this._discardOpenSubMenuDelayed();p(this,false);delete this._bFixed;g.unbindAnyEvent(this.fAnyEventHandlerProxy);if(this._bOrientationChangeBound){jQuery(r).off("orientationchange",this.fOrientationChangeHandler);this._bOrientationChangeBound=false}this.closeSubmenu();this.setHoveredItem();if(!e){this.bIgnoreOpenerDOMRef=true}this.getPopup().close(0);this.bOpen=this.getPopup().isOpen();this._detachResizeHandler();this._resetDelayedRerenderItems();this.$().remove();this.bOutput=false;if(this.isSubMenu()){this.getParent().getParent().oOpenedSubMenu=null}};_.prototype.isOpen=function(){return this.getPopup().isOpen()};_.prototype._menuClosed=function(){this.fireClosed();if(this.oOpenerRef){if(!this.bIgnoreOpenerDOMRef){try{this.oOpenerRef.focus()}catch(e){c.warning("Menu.close cannot restore the focus on opener "+this.oOpenerRef+", "+e)}}this.oOpenerRef=undefined}};_.prototype.onclick=function(e){this.selectItem(this.getItemByDomRef(e.target),false,!!(e.metaKey||e.ctrlKey));e.preventDefault();e.stopPropagation()};_.prototype.onsapnext=function(e){var t,i,o=this.oHoveredItem?this.oHoveredItem.getSubmenu():undefined;if(e.keyCode!==d.ARROW_DOWN&&!e.metaKey&&!e.altKey){if(o){if(o.isOpen()){i=o.getNextSelectableItem(-1);o.setHoveredItem(i);i&&i.focus(this)}else{this.openSubmenu(this.oHoveredItem,true)}}return}if(o&&o.isOpen()){this.closeSubmenu(false,true)}t=this.oHoveredItem?this._getItems().indexOf(this.oHoveredItem):-1;i=this.getNextSelectableItem(t);this.setHoveredItem(i);i&&i.focus(this);if(!e.metaKey&&!e.altKey){e.preventDefault();e.stopPropagation()}};_.prototype.onsapnextmodifiers=_.prototype.onsapnext;_.prototype.onsapprevious=function(e){var t=this.oHoveredItem?this._getItems().indexOf(this.oHoveredItem):-1,i=this.getPreviousSelectableItem(t),o=this.oHoveredItem?this.oHoveredItem.getSubmenu():null;if(e.keyCode!==d.ARROW_UP&&!e.metaKey&&!e.altKey){if(this.isSubMenu()){this.close(true)}e.preventDefault();e.stopPropagation();return}if(o&&o.isOpen()){this.closeSubmenu(false,true)}this.setHoveredItem(i);i&&i.focus(this);if(!e.metaKey&&!e.altKey){e.preventDefault();e.stopPropagation()}};_.prototype.onsappreviousmodifiers=_.prototype.onsapprevious;_.prototype.onsaphome=function(e){var t=this.getNextSelectableItem(-1);this.setHoveredItem(t);t&&t.focus(this);e.preventDefault();e.stopPropagation()};_.prototype.onsapend=function(e){var t=this.getPreviousSelectableItem(this._getItems().length);this.setHoveredItem(t);t&&t.focus(this);e.preventDefault();e.stopPropagation()};_.prototype.onsappagedown=function(e){var t=this._getItems(),i=this.oHoveredItem?t.indexOf(this.oHoveredItem):-1,o;if(this.getPageSize()<1){this.onsapend(e);return}i+=this.getPageSize();if(i>=t.length){this.onsapend(e);return}o=this.getNextSelectableItem(i-1);this.setHoveredItem(o);o&&o.focus(this);e.preventDefault();e.stopPropagation()};_.prototype.onsappageup=function(e){var t=this.oHoveredItem?this._getItems().indexOf(this.oHoveredItem):-1,i;if(this.getPageSize()<1){this.onsaphome(e);return}t-=this.getPageSize();if(t<0){this.onsaphome(e);return}i=this.getPreviousSelectableItem(t+1);this.setHoveredItem(i);i&&i.focus(this);e.preventDefault();e.stopPropagation()};_.prototype.onsapselect=function(e){this._sapSelectOnKeyDown=true;e.preventDefault();e.stopPropagation()};_.prototype.onkeyup=function(e){if(e.keyCode===d.ARROW_LEFT||e.keyCode===d.ARROW_RIGHT){return}if(this.oHoveredItem&&jQuery(e.target).prop("tagName")!="INPUT"){var t=this.oHoveredItem.getDomRef();jQuery(t).trigger("focus")}if(!this._sapSelectOnKeyDown){return}else{this._sapSelectOnKeyDown=false}if(!m.events.sapselect.fnCheck(e)&&e.keyCode!==d.ENTER){return}this.selectItem(this.oHoveredItem,true,false);e.preventDefault();e.stopPropagation()};_.prototype.onsapbackspace=function(e){if(jQuery(e.target).prop("tagName")!="INPUT"){e.preventDefault()}};_.prototype.onsapbackspacemodifiers=_.prototype.onsapbackspace;_.prototype.onsapescape=function(e){this._bLeavingMenu=true;this.close(true);e.preventDefault();e.stopPropagation()};_.prototype.onsaptabnext=function(e){if(this.isSubMenu()){e.preventDefault()}this._bLeavingMenu=true;this.close(true);e.stopPropagation()};_.prototype.onsaptabprevious=_.prototype.onsaptabnext;_.prototype._openSubMenuDelayed=function(e){if(!e){return}var t=e.getSubmenu(),i=t&&t._getItems().length;this._discardOpenSubMenuDelayed();this._delayedSubMenuTimer=setTimeout(function(){if(i){this.setHoveredItem(e);e&&e.focus(this);this.openSubmenu(e,false,true)}}.bind(this),i?_._DELAY_SUBMENU_TIMER:_._DELAY_SUBMENU_TIMER_EXT)};_.prototype._discardOpenSubMenuDelayed=function(e){if(this._delayedSubMenuTimer){clearTimeout(this._delayedSubMenuTimer);this._delayedSubMenuTimer=null}};_.prototype.onmouseout=function(e){if(!o.system.desktop){return}if(y(e,this.getDomRef())){this.setHoveredItem(null);if(!this.oOpenedSubMenu||!(this.oOpenedSubMenu.getParent()===this.oHoveredItem)){this.setHoveredItem(this.oHoveredItem)}this._discardOpenSubMenuDelayed()}};_.prototype.onsapfocusleave=function(e){if(this.oOpenedSubMenu||!this.isOpen()){return}if(o.os.name=="mac"&&o.browser.firefox&&this.isOpen()){var t=e.relatedControlId,i=t?a.byId(t):null,n=i&&i instanceof s;if(i&&!n){this._getItems()[0].focus();return}}this.getRootMenu().handleOuterEvent(this.getId(),e)};_.prototype.handleOuterEvent=function(e,t){var i=false,n=o.support.touch||o.system.combi;this.bIgnoreOpenerDOMRef=false;if(t.type=="mousedown"||t.type=="touchstart"){if(n&&(t.isMarked("delayedMouseEvent")||t.isMarked("cancelAutoClose"))){return}var s=this;while(s&&!i){if(l(s.getDomRef(),t.target)){i=true}s=s.oOpenedSubMenu}}else if(t.type=="sapfocusleave"){if(n){return}if(t.relatedControlId){var s=this;while(s&&!i){if(s.oOpenedSubMenu&&s.oOpenedSubMenu.getId()==t.relatedControlId||l(s.getDomRef(),jQuery(document.getElementById(t.relatedControlId)).get(0))){i=true}s=s.oOpenedSubMenu}}if(!i){this.bIgnoreOpenerDOMRef=true}}if(!i&&this.fireBeforeClose()){this.close()}};_.prototype.getItemByDomRef=function(e){var t=this._getItems(),i=t.length;for(var o=0;o<i;o++){var n=t[o],s=n.getDomRef();if(l(s,e)){return n}}return null};_.prototype.selectItem=function(e,t,i){if(!e||!(e instanceof s&&this.checkEnabled(e))){return}var n=e.getSubmenu();if(!n||!n._getItems().length){if(this.fireBeforeClose()){this.getRootMenu().close(true)}if(e._getItemSelectionMode&&e._getItemSelectionMode()!==I.None){e.setSelected(!e.getSelected())}}else{if(!o.system.desktop&&this.oOpenedSubMenu===n){this.closeSubmenu()}else{this.openSubmenu(e,t)}}e.fireSelect({item:e,ctrlKey:i});this.getRootMenu().fireItemSelect({item:e})};_.prototype.isSubMenu=function(){return this.getParent()&&this.getParent().getParent&&this.getParent().getParent()instanceof _};_.prototype.getRootMenu=function(){var e=this;while(e.isSubMenu()){e=e.getParent().getParent()}return e};_.prototype.getMenuLevel=function(){var e=1;var t=this;while(t.isSubMenu()){t=t.getParent().getParent();e++}return e};_.prototype.getPopup=function(){if(!this.oPopup){this.oPopup=new n(this,false,true,false);this.oPopup.setDurations(0,0);this.oPopup.attachClosed(this._menuClosed,this);this.oPopup.attachOpened(this._handleOpened,this)}return this.oPopup};_.prototype.setHoveredItem=function(e){if(this.oHoveredItem){this.oHoveredItem.hover(false,this)}if(!e){this.oHoveredItem=null;return}this.oHoveredItem=e;e.hover(true,this);this.scrollToItem(this.oHoveredItem)};_.prototype.openSubmenu=function(e,t,i){var o=e.getSubmenu();if(!o){return}if(!this.checkEnabled(e)){return}if(this.oOpenedSubMenu&&this.oOpenedSubMenu!==o){this.closeSubmenu()}if(this.oOpenedSubMenu){this.oOpenedSubMenu._bFixed=i&&this.oOpenedSubMenu._bFixed||!i&&!this.oOpenedSubMenu._bFixed;this.oOpenedSubMenu._bringToFront()}else if(o._getItems().length){this.oOpenedSubMenu=o;var s=n.Dock;o.open(t,e,s.BeginTop,s.EndTop,e,"-4 4")}};_.prototype.closeSubmenu=function(e,t){if(this.oOpenedSubMenu){if(e&&this.oOpenedSubMenu._bFixed){return}if(t){this.oOpenedSubMenu.bIgnoreOpenerDOMRef=true}this.oOpenedSubMenu.close();this.oOpenedSubMenu=null}};_.prototype.scrollToItem=function(e){var t=this.getDomRef(),i=e?e.getDomRef():null;if(!i||!t){return}var o=t.scrollTop,n=i.offsetTop,s=jQuery(t).height(),r=jQuery(i).height();if(o>n){t.scrollTop=n}else if(n+r>o+s){t.scrollTop=Math.ceil(n+r-s)}};_.prototype._bringToFront=function(){jQuery(document.getElementById(this.getPopup().getId())).mousedown()};_.prototype.checkEnabled=function(e){return e&&e.getEnabled()&&this.getEnabled()};_.prototype.getNextSelectableItem=function(e){var t=this._getItems();var i=t[e];for(var o=e+1;o<t.length;o++){if(t[o].getVisible()){return t[o]}}return i&&i.getVisible()?i:null};_.prototype.getPreviousSelectableItem=function(e){var t=this._getItems();var i=t[e];for(var o=e-1;o>=0;o--){if(t[o].getVisible()){return t[o]}}return i&&i.getVisible()?i:null};_.prototype.setRootMenuTopStyle=function(e){this.getRootMenu().bUseTopStyle=e;_.rerenderMenu(this.getRootMenu())};_.rerenderMenu=function(e){var t=e._getItems();for(var i=0;i<t.length;i++){var o=t[i].getSubmenu();if(o){_.rerenderMenu(o)}}e.invalidate()};_.prototype.focus=function(){if(this.isOpen()){i.prototype.focus.apply(this,arguments)}};_.prototype.isCozy=function(){if(!this.bCozySupported){return false}if(this.hasStyleClass("sapUiSizeCozy")){return true}if(u(this.oOpenerRef)){return true}if(u(this.getParent())){return true}return false};_.prototype.getSelectedItems=function(){return this._getItems().filter(e=>e.getSelected&&e.getSelected()&&e._getItemSelectionMode()!==I.None)};_.prototype._getItems=function(){var e=this.getItems(),t=[],i,o;for(o=0;o<e.length;o++){if(e[o].getItems){i=e[o].getItems();for(var n=0;n<i.length;n++){t.push(i[n])}}else{t.push(e[o])}}return t};function u(e){if(!e||!e.getDomRef){return false}return!!e.getDomRef()?.closest(".sapUiSizeCompact,.sapUiSizeCondensed,.sapUiSizeCozy")?.classList.contains("sapUiSizeCozy")}function p(e,t){var i=e.getParent();if(i&&i instanceof s){i.onSubmenuToggle(t)}}function S(e){var t=e.getMaxVisibleItems(),i=document.documentElement.clientHeight-10,o=e.$();if(t>0){var n=e._getItems();for(var s=0;s<n.length;s++){if(n[s].getDomRef()){i=Math.min(i,n[s].$().outerHeight(true)*t);break}}}if(o.outerHeight(true)>i){o.css("max-height",i+"px").toggleClass("sapUiMnuScroll",true)}else{o.css("max-height","").toggleClass("sapUiMnuScroll",false)}}function M(e){var t;if(!e){return false}if(e instanceof jQuery){e=e.get(0)}t=e.getBoundingClientRect();return t.top>=0&&t.left>=0&&t.bottom<=(r.innerHeight||document.documentElement.clientHeight)&&t.right<=(r.innerWidth||document.documentElement.clientWidth)}})(window);return _});
//# sourceMappingURL=Menu.js.map