/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/i18n/Localization","sap/ui/core/Lib","sap/ui/core/ValueStateSupport","./MenuItemBase","./library","sap/ui/core/library","sap/ui/Device","sap/base/Log","sap/ui/events/PseudoEvents","sap/ui/core/InvisibleText","sap/ui/core/IconPool","sap/ui/dom/jquery/cursorPos"],function(t,e,i,s,n,o,a,r,p,u){"use strict";var l=o.ValueState;var c=s.extend("sap.ui.unified.MenuTextFieldItem",{metadata:{interfaces:["sap.ui.unified.IMenuItem"],library:"sap.ui.unified",properties:{label:{type:"string",group:"Appearance",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},value:{type:"string",group:"Misc",defaultValue:null},valueState:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:l.None}}}});c.prototype.render=function(t,e,i,s){var n=t,o=i.checkEnabled(e),a=e.getId(),r;n.openStart("li",e);if(e.getVisible()){n.attr("tabindex","0")}n.class("sapUiMnuItm").class("sapUiMnuTfItm");if(s.iItemNo==1){n.class("sapUiMnuItmFirst")}else if(s.iItemNo==s.iTotalItems){n.class("sapUiMnuItmLast")}if(!o){n.class("sapUiMnuItmDsbl")}if(e.getStartsSection()){n.class("sapUiMnuItmSepBefore")}if(s.bAccessible){n.attr("role","menuitem");n.attr("aria-posinset",s.iItemNo);n.attr("aria-setsize",s.iTotalItems);n.attr("aria-disabled",!o)}n.openEnd();if(e.getIcon()){n.openStart("div").class("sapUiMnuItmIco").openEnd();r=e._getIcon();n.renderControl(r);n.close("div")}n.openStart("div",a+"-txt").class("sapUiMnuItmTxt").openEnd();n.openStart("label",a+"-lbl").class("sapUiMnuTfItemLbl").openEnd();n.text(e.getLabel());n.close("label");n.openStart("div",a+"-str").class("sapUiMnuTfItmStretch").openEnd().close("div");n.openStart("div").class("sapUiMnuTfItemWrppr").openEnd();n.voidStart("input",a+"-tf").attr("tabindex","-1");n.attr("role","textbox");if(e.getValue()){n.attr("value",e.getValue())}n.class("sapUiMnuTfItemTf").class(o?"sapUiMnuTfItemTfEnbl":"sapUiMnuTfItemTfDsbl");if(!o){n.attr("disabled","disabled")}if(s.bAccessible){n.accessibilityState(e,{disabled:null,describedby:e._fnInvisibleDescriptionFactory(s).getId(),labelledby:a+"-lbl"})}n.voidEnd().close("div").close("div");n.close("li")};c.prototype.exit=function(){if(this._invisibleDescription){this._fnInvisibleDescriptionFactory().destroy();this._invisibleDescription=null}};c.prototype.hover=function(t,e){this.$().toggleClass("sapUiMnuItmHov",t);if(t){e.closeSubmenu(false,true)}};c.prototype.focus=function(t){if(this.getVisible()&&this.getEnabled()){this.$("tf").get(0).focus()}else{this.$().trigger("focus")}};c.prototype.onAfterRendering=function(){this.setValueState(this.getValueState())};c.prototype.onsapup=function(t){this.getParent().onsapprevious(t)};c.prototype.onsapdown=function(t){this.getParent().onsapnext(t)};c.prototype.onsaphome=function(t){if(this._checkCursorPosForNav(false)){this.getParent().onsaphome(t)}};c.prototype.onsapend=function(t){if(this._checkCursorPosForNav(true)){this.getParent().onsapend(t)}};c.prototype.onsappageup=function(t){this.getParent().onsappageup(t)};c.prototype.onsappagedown=function(t){this.getParent().onsappagedown(t)};c.prototype.onsapescape=function(t){this.getParent().onsapescape(t)};c.prototype.onkeydown=function(t){t.stopPropagation()};c.prototype.onclick=function(t){this.getParent().closeSubmenu(false,true);if(!a.system.desktop){this.focus()}t.stopPropagation()};c.prototype.onkeyup=function(t){if(!p.events.sapenter.fnCheck(t)&&t.key!=="Enter"){return}var e=this.$("tf").val();this.setValue(e);this.getParent().selectItem(this);t.preventDefault();t.stopPropagation()};c.prototype.setSubmenu=function(t){r.warning("The aggregation 'submenu' is not supported for this type of menu item.","","sap.ui.unified.MenuTextFieldItem");return this};c.prototype.setLabel=function(t){this.setProperty("label",t,true);this.$("lbl").text(t);return this};c.prototype.setValue=function(t){this.setProperty("value",t,true);this.$("tf").val(t);return this};c.prototype.setValueState=function(t){this.setProperty("valueState",t,true);var e=this.$("tf");e.toggleClass("sapUiMnuTfItemTfErr",t==l.Error);e.toggleClass("sapUiMnuTfItemTfWarn",t==l.Warning);var s=i.enrichTooltip(this,this.getTooltip_AsString());if(s){this.$().attr("title",s)}return this};c.prototype.getFocusDomRef=function(){var t=this.$("tf");return t.length?t.get(0):null};c.prototype._checkCursorPosForNav=function(e){var i=t.getRTL();var s=e?i:!i;var n=this.$("tf");var o=n.cursorPos();var a=n.val().length;if(i){o=a-o}if(!s&&o!=a||s&&o!=0){return false}return true};c.prototype._fnInvisibleDescriptionFactory=function(t){var i,s,n;if(!this._invisibleDescription){n=e.getResourceBundleFor("sap.ui.unified");i=n.getText("UNIFIED_MENU_ITEM_COUNT_TEXT",[t.iItemNo,t.iTotalItems]);s=n.getText("UNIFIED_MENU_ITEM_HINT_TEXT");this._invisibleDescription=new u({text:i+" "+s}).toStatic()}return this._invisibleDescription};return c});
//# sourceMappingURL=MenuTextFieldItem.js.map