/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/i18n/Localization","sap/ui/Device","sap/ui/core/Control","sap/ui/core/ControlBehavior","sap/ui/core/Popup","sap/ui/core/RenderManager","sap/ui/core/theming/Parameters","./SplitContainer","./library","./ShellLayoutRenderer","sap/ui/dom/containsOrEquals","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/core/Configuration","sap/ui/dom/jquery/Focusable"],function(t,e,n,i,r,o,s,a,u,d,h,c,jQuery,p){"use strict";var l=n.extend("sap.ui.unified.ShellLayout",{metadata:{library:"sap.ui.unified",deprecated:true,properties:{showPane:{type:"boolean",group:"Appearance",defaultValue:false},headerHiding:{type:"boolean",group:"Appearance",defaultValue:false},headerVisible:{type:"boolean",group:"Appearance",defaultValue:true}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",forwarding:{idSuffix:"-container",aggregation:"content"}},paneContent:{type:"sap.ui.core.Control",multiple:true,singularName:"paneContent",forwarding:{idSuffix:"-container",aggregation:"secondaryContent"}},header:{type:"sap.ui.core.Control",multiple:false},canvasSplitContainer:{type:"sap.ui.unified.SplitContainer",multiple:false,visibility:"hidden"},curtainSplitContainer:{type:"sap.ui.unified.SplitContainer",multiple:false,visibility:"hidden"}}},renderer:d});l._SIDEPANE_WIDTH_PHONE=208;l._SIDEPANE_WIDTH_TABLET=208;l._SIDEPANE_WIDTH_DESKTOP=240;l._HEADER_ALWAYS_VISIBLE=true;l._HEADER_AUTO_CLOSE=true;l._HEADER_TOUCH_TRESHOLD=15;if(e.browser.chrome&&e.browser.version<36){l._HEADER_TOUCH_TRESHOLD=10}l.prototype.init=function(){this._rtl=t.getRTL();this._animation=p.getAnimation();this._showHeader=true;this._showCurtain=false;this._iHeaderHidingDelay=3e3;this._useStrongBG=false;this._cont=new a(this.getId()+"-container");this._cont._bRootContent=true;if(i.isAccessibilityEnabled()){var n=this;this._cont.addEventDelegate({onAfterRendering:function(){n._cont.$("canvas").attr("role","main");n._cont.$("pane").attr("role","complementary")}})}this.setAggregation("canvasSplitContainer",this._cont,true);this._curtCont=new a(this.getId()+"-curt-container");this._curtCont._bRootContent=true;this.setAggregation("curtainSplitContainer",this._curtCont,true);this._setSidePaneWidth();e.media.attachHandler(this._handleMediaChange,this,e.media.RANGESETS.SAP_STANDARD);e.resize.attachHandler(this._handleResizeChange,this)};l.prototype.exit=function(){e.media.detachHandler(this._handleMediaChange,this,e.media.RANGESETS.SAP_STANDARD);e.resize.detachHandler(this._handleResizeChange,this);delete this._cont;delete this._curtCont};l.prototype.onAfterRendering=function(){var t=this;function e(e){var n=jQuery.event.fix(e);if(h(t.getDomRef("hdr"),n.target)){t._timedHideHeader(n.type==="focus")}}if(window.addEventListener&&!l._HEADER_ALWAYS_VISIBLE){var n=this.getDomRef("hdr");n.addEventListener("focus",e,true);n.addEventListener("blur",e,true)}this._refreshAfterRendering()};l.prototype.onThemeChanged=function(){this._refreshAfterRendering()};l.prototype.onfocusin=function(t){var e=this.getId();if(t.target.id===e+"-curt-focusDummyOut"&&this.$("hdrcntnt").firstFocusableDomRef()){this.$("hdrcntnt").firstFocusableDomRef().focus()}else if(t.target.id===e+"-main-focusDummyOut"&&this.$("curtcntnt").firstFocusableDomRef()){this.$("curtcntnt").firstFocusableDomRef().focus()}};(function(){function t(t){if(t._startY===undefined||t._currY===undefined){return}var e=t._currY-t._startY;if(Math.abs(e)>l._HEADER_TOUCH_TRESHOLD){t._doShowHeader(e>0);t._startY=t._currY}}if(e.support.touch){l._HEADER_ALWAYS_VISIBLE=false;l.prototype.ontouchstart=function(t){this._startY=t.touches[0].pageY;if(this._startY>2*48){this._startY=undefined}this._currY=this._startY};l.prototype.ontouchend=function(e){t(this);this._startY=undefined;this._currY=undefined};l.prototype.ontouchcancel=l.prototype.ontouchend;l.prototype.ontouchmove=function(e){this._currY=e.touches[0].pageY;t(this)}}})();l.prototype.setHeaderHiding=function(t){t=!!t;return this._mod(function(e){return this.setProperty("headerHiding",t,e)},function(){this._doShowHeader(!t?true:this._showHeader)})};l.prototype.setHeaderHidingDelay=function(t){this._iHeaderHidingDelay=t;return this};l.prototype.getHeaderHidingDelay=function(){return this._iHeaderHidingDelay};l.prototype.getShowPane=function(){return this._cont.getShowSecondaryContent()};l.prototype.setShowPane=function(t){this._cont.setShowSecondaryContent(t);this.setProperty("showPane",!!t,true);return this};l.prototype.setShowCurtainPane=function(t){this._curtCont.setShowSecondaryContent(t);return this};l.prototype.getShowCurtainPane=function(){return this._curtCont.getShowSecondaryContent()};l.prototype.setHeaderVisible=function(t){t=!!t;this.setProperty("headerVisible",t,true);this.$().toggleClass("sapUiUfdShellNoHead",!t);return this};l.prototype.setShowCurtain=function(t){t=!!t;return this._mod(function(e){this._showCurtain=t;return this},function(){this.$("main-focusDummyOut").attr("tabindex",t?0:-1);this.$().toggleClass("sapUiUfdShellCurtainHidden",!t).toggleClass("sapUiUfdShellCurtainVisible",t);if(t){var e=r.getNextZIndex();this.$("curt").css("z-index",e+1);this.$("hdr").css("z-index",e+3);this.$("brand").css("z-index",e+7);this.$().toggleClass("sapUiUfdShellCurtainClosed",false)}this._timedCurtainClosed(t);this._doShowHeader(true)})};l.prototype.getShowCurtain=function(){return this._showCurtain};l.prototype.setHeader=function(t){this.setAggregation("header",t,true);t=this.getHeader();if(this.getDomRef()){if(!t){this.$("hdrcntnt").html("")}else{var e=(new o).getInterface();e.renderControl(t);e.flush(this.getDomRef("hdrcntnt"));e.destroy()}}return this};l.prototype.destroyHeader=function(){this.destroyAggregation("header",true);this.$("hdrcntnt").html("");return this};l.prototype.getCurtainContent=function(){return this._curtCont.getContent()};l.prototype.insertCurtainContent=function(t,e){this._curtCont.insertContent(t,e);return this};l.prototype.addCurtainContent=function(t){this._curtCont.addContent(t);return this};l.prototype.removeCurtainContent=function(t){return this._curtCont.removeContent(t)};l.prototype.removeAllCurtainContent=function(){return this._curtCont.removeAllContent()};l.prototype.destroyCurtainContent=function(){this._curtCont.destroyContent();return this};l.prototype.indexOfCurtainContent=function(t){return this._curtCont.indexOfCurtainContent(t)};l.prototype.getCurtainPaneContent=function(){return this._curtCont.getSecondaryContent()};l.prototype.insertCurtainPaneContent=function(t,e){this._curtCont.insertSecondaryContent(t,e);return this};l.prototype.addCurtainPaneContent=function(t){this._curtCont.addSecondaryContent(t);return this};l.prototype.removeCurtainPaneContent=function(t){return this._curtCont.removeSecondaryContent(t)};l.prototype.removeAllCurtainPaneContent=function(){return this._curtCont.removeAllSecondaryContent()};l.prototype.destroyCurtainPaneContent=function(){this._curtCont.destroySecondaryContent();return this};l.prototype.indexOfCurtainPaneContent=function(t){return this._curtCont.indexOfSecondaryContent(t)};l.prototype._setStrongBackground=function(t){this._useStrongBG=!!t;this.$("strgbg").toggleClass("sapUiStrongBackgroundColor",this._useStrongBG)};l.prototype._mod=function(t,e){var n=!!this.getDomRef();var i=t.apply(this,[n]);if(n&&e){if(e instanceof u._ContentRenderer){e.render()}else{e.apply(this)}}return i};l.prototype._doShowHeader=function(t){var e=this._showHeader;this._showHeader=this._isHeaderHidingActive()?!!t:true;this.$().toggleClass("sapUiUfdShellHeadHidden",!this._showHeader).toggleClass("sapUiUfdShellHeadVisible",this._showHeader);if(this._showHeader){this._timedHideHeader()}if(e!=this._showHeader&&this._isHeaderHidingActive()){setTimeout(function(){try{var t=document.createEvent("UIEvents");t.initUIEvent("resize",true,false,window,0);window.dispatchEvent(t)}catch(t){c.error(t)}},500)}};l.prototype._timedHideHeader=function(t){if(this._headerHidingTimer){clearTimeout(this._headerHidingTimer);this._headerHidingTimer=null}if(t||!l._HEADER_AUTO_CLOSE||!this._isHeaderHidingActive()||this._iHeaderHidingDelay<=0){return}this._headerHidingTimer=setTimeout(function(){if(this._isHeaderHidingActive()&&this._iHeaderHidingDelay>0&&!h(this.getDomRef("hdr"),document.activeElement)){this._doShowHeader(false)}}.bind(this),this._iHeaderHidingDelay)};l.prototype._timedCurtainClosed=function(t){if(this._curtainClosedTimer){clearTimeout(this._curtainClosedTimer);this._curtainClosedTimer=null}if(t){return}var e=parseInt(s.get("_sap_ui_unified_ShellLayout_AnimDuration"));if(!this._animation){e=0}this._curtainClosedTimer=setTimeout(function(){this._curtainClosedTimer=null;this.$("curt").css("z-index","");this.$("hdr").css("z-index","");this.$("brand").css("z-index","");this.$().toggleClass("sapUiUfdShellCurtainClosed",true)}.bind(this),e)};l.prototype._isHeaderHidingActive=function(){if(l._HEADER_ALWAYS_VISIBLE||this.getShowCurtain()||!this.getHeaderHiding()||u._iNumberOfOpenedShellOverlays>0||!this.getHeaderVisible()){return false}return true};l.prototype._setSidePaneWidth=function(t){if(!t){t=e.media.getCurrentRange(e.media.RANGESETS.SAP_STANDARD).name}var n=l["_SIDEPANE_WIDTH_"+t.toUpperCase()]+"px";this._cont.setSecondaryContentSize(n);this._curtCont.setSecondaryContentSize(n)};l.prototype._handleMediaChange=function(t){if(!this.getDomRef()){return false}this._setSidePaneWidth(t.name)};l.prototype._handleResizeChange=function(t){};l.prototype._refreshAfterRendering=function(){var t=this.getDomRef();if(!t){return false}this._timedHideHeader();return true};l.prototype._getSearchWidth=function(){return-1};return l});
//# sourceMappingURL=ShellLayout.js.map