/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/i18n/Formatting","sap/base/i18n/Localization","sap/base/i18n/date/CalendarType","sap/ui/core/date/UniversalDate","./CalendarDate","sap/ui/core/Locale","sap/ui/core/LocaleData","sap/ui/core/format/DateFormat","sap/ui/core/date/UI5Date"],function(e,t,a,n,r,i,s,g,u){"use strict";var l={};l.MAX_MILLISECONDS=864e13;l.HOURS24=1e3*3600*24;l._createLocalDate=function(e,t){var a;if(e){var r;if(e instanceof n){r=e.getJSDate()}else{r=e}a=u.getInstance(r.getUTCFullYear(),r.getUTCMonth(),r.getUTCDate());if(r.getFullYear()<1e3){a.setFullYear(r.getFullYear())}if(t){a.setHours(r.getUTCHours());a.setMinutes(r.getUTCMinutes());a.setSeconds(r.getUTCSeconds());a.setMilliseconds(r.getUTCMilliseconds())}}return a};l._createUTCDate=function(e,t){var a;if(e){var r;if(e instanceof n){r=e.getJSDate()}else{r=e}a=u.getInstance(Date.UTC(r.getFullYear(),r.getMonth(),r.getDate()));if(r.getFullYear()<1e3){a.setUTCFullYear(r.getFullYear())}if(t){a.setUTCHours(r.getHours());a.setUTCMinutes(r.getMinutes());a.setUTCSeconds(r.getSeconds());a.setUTCMilliseconds(r.getMilliseconds())}}return a};l._createUniversalUTCDate=function(e,t,a){var r;if(t){r=n.getInstance(this._createUTCDate(e,a),t)}else{r=new n(this._createUTCDate(e,a).getTime())}return r};l.calculateWeekNumber=function(e,t,a,n,r){const u=new i(a);const l=s.getInstance(u);const o=l.getMinimalDaysInFirstWeek();const c=g.getInstance({pattern:"w",calendarType:t,firstDayOfWeek:r,minimalDaysInFirstWeek:o,calendarWeekNumbering:n},u);const f=c.format(e.toLocalJSDate());return Number(f)};l._getLastWeekDate=function(e){return new r(e).setDate(e.getDate()+6)};l.getFirstDateOfWeek=function(a,r){var g=new n(a.getTime()),u,l,o=s.getInstance(new i(e.getLanguageTag())),c=new i(t.getLanguageTag()),f=o.getFirstDayOfWeek(),D;if(!r||(r.firstDayOfWeek===-1||r.firstDayOfWeek===undefined)){r={firstDayOfWeek:o.getFirstDayOfWeek(),minimalDaysInFirstWeek:o.getMinimalDaysInFirstWeek()}}D=n.getWeekByDate(g.getCalendarType(),g.getUTCFullYear(),g.getUTCMonth(),g.getUTCDate(),c,r);u=n.getFirstDateOfWeek(g.getCalendarType(),D.year,D.week,c,r);l=new n(n.UTC(u.year,u.month,u.day));if(r&&(r.firstDayOfWeek===-1||r.firstDayOfWeek===undefined)){while(l.getUTCDay()!==f){l.setUTCDate(l.getUTCDate()-1)}}return new n(n.UTC(l.getUTCFullYear(),l.getUTCMonth(),l.getUTCDate(),a.getUTCHours(),a.getUTCMinutes(),a.getUTCSeconds())).getJSDate()};l.getFirstDateOfMonth=function(e){var t=new n(e.getTime());t.setUTCDate(1);return t};l._getNumberOfWeeksForYear=function(t){var a=e.getLanguageTag().toString(),n=s.getInstance(new i(a)),r=u.getInstance(Date.UTC(t,0,1)),g=r.getUTCDay(),l=52;if(n.getFirstDayOfWeek()===0){if(g===5||g===6){l=53}}else{if(g===3||g===4){l=53}}return l};l.monthsDiffer=function(e,t){return e.getMonth()!==t.getMonth()||e.getFullYear()!==t.getFullYear()};l.isDateLastInMonth=function(e){var t=u.getInstance(e.getTime()+24*60*60*1e3);return t.getUTCDate()<e.getUTCDate()};l._updateUTCDate=function(e,t,a,n,r,i,s,g){if(t!=null){e.setUTCFullYear(t)}if(a!=null){e.setUTCMonth(a)}if(n!=null){e.setUTCDate(n)}if(r!=null){e.setUTCHours(r)}if(i!=null){e.setUTCMinutes(i)}if(s!=null){e.setUTCSeconds(s)}if(g!=null){e.setUTCMilliseconds(g)}};l._checkJSDateObject=function(e){if(!e||Object.prototype.toString.call(e)!=="[object Date]"||isNaN(e)){throw new Error("Date must be a JavaScript or UI5Date date object.")}};l._checkYearInValidRange=function(t,n){var i=e.getCalendarType(),s=new r(this._minDate(a.Gregorian),n||i),g=new r(this._maxDate(a.Gregorian),n||i);if(typeof t!=="number"||t<s.getYear()||t>g.getYear()){throw new Error("Year must be in valid range (between year 0001 and year 9999 in Gregorian calendar type).")}};l._isNextMonth=function(e,t){return e.getMonth()>t.getMonth()&&e.getFullYear()===t.getFullYear()||e.getFullYear()>t.getFullYear()};l._minutesBetween=function(e,t){var a=(t.getTime()-e.getTime())/1e3;a=a/60;return Math.abs(Math.round(a))};l._areCurrentMinutesLessThan=function(e){var t=u.getInstance().getMinutes();return e>=t};l._areCurrentMinutesMoreThan=function(e){var t=u.getInstance().getMinutes();return e<=t};l._monthsBetween=function(e,t,a){var n=u.getInstance(Date.UTC(e.getUTCFullYear(),e.getUTCMonth(),e.getUTCDate())),r=u.getInstance(Date.UTC(t.getUTCFullYear(),t.getUTCMonth(),t.getUTCDate())),i;n.setUTCFullYear(e.getUTCFullYear());r.setUTCFullYear(t.getUTCFullYear());i=r.getUTCFullYear()*12+r.getUTCMonth()-(n.getUTCFullYear()*12+n.getUTCMonth());if(!a){i=Math.abs(i)}return i};l._hoursBetween=function(e,t){var a=u.getInstance(Date.UTC(e.getUTCFullYear(),e.getUTCMonth(),e.getUTCDate(),e.getUTCHours()));var n=u.getInstance(Date.UTC(t.getUTCFullYear(),t.getUTCMonth(),t.getUTCDate(),t.getUTCHours()));a.setUTCFullYear(e.getUTCFullYear());n.setUTCFullYear(t.getUTCFullYear());return Math.abs((a.getTime()-n.getTime())/(1e3*60*60))};l._isMidnight=function(e){return e.getHours()===0&&e.getMinutes()===0&&e.getSeconds()===0&&e.getMilliseconds()===0};l._daysInMonth=function(e){this._checkCalendarDate(e);e=new r(e);e.setDate(1);e.setMonth(e.getMonth()+1);e.setDate(0);return e.getDate()};l._isLastDateInMonth=function(e){return e.getDate()===l._daysInMonth(e)};l._getFirstDateOfWeek=function(t,a){var n=s.getInstance(new i(e.getLanguageTag()));this._checkCalendarDate(t);if(!a||(a.firstDayOfWeek===-1||a.firstDayOfWeek===undefined)){a={firstDayOfWeek:n.getFirstDayOfWeek(),minimalDaysInFirstWeek:n.getMinimalDaysInFirstWeek()}}if(t.getDay()!==a.firstDayOfWeek){var g=l.getFirstDateOfWeek(t.toUTCJSDate(),a);g.setFullYear(g.getUTCFullYear(),g.getUTCMonth(),g.getUTCDate());return r.fromLocalJSDate(g,t.getCalendarType())}return t};l._getFirstDateOfMonth=function(e){this._checkCalendarDate(e);var t=new r(e,e.getCalendarType());t.setDate(1);return t};l._minDate=function(e){var t=new r(1,0,1,e);t.setYear(1);t.setMonth(0);t.setDate(1);return t};l._maxDate=function(e){var t=new r(9999,11,1,e);t.setYear(9999);t.setMonth(11);t.setDate(this._daysInMonth(t));return new r(t)};l._isBetween=function(e,t,a,n){this._checkCalendarDate(e);this._checkCalendarDate(t);this._checkCalendarDate(a);if(n){return e.isSameOrAfter(t)&&e.isSameOrBefore(a)}else{return e.isAfter(t)&&e.isBefore(a)}};l._daysBetween=function(e,t){this._checkCalendarDate(e);this._checkCalendarDate(t);return Math.ceil((e.valueOf()-t.valueOf())/this.HOURS24)};l._isOutside=function(e,t,a){return!this._isBetween(e,t,a,true)};l._isSameMonthAndYear=function(e,t){this._checkCalendarDate(e);this._checkCalendarDate(t);return e.getEra()===t.getEra()&&e.getYear()===t.getYear()&&e.getMonth()===t.getMonth()};l._checkCalendarDate=function(e){if(!e||!(e instanceof r)){throw"Invalid calendar date: ["+e+"]. Expected: sap.ui.unified.calendar.CalendarDate"}};l._getWeek=function(e){this._checkCalendarDate(e);return n.getWeekByDate(e.getCalendarType(),e.getYear(),e.getMonth(),e.getDate())};l._isWeekend=function(e,t){var a=e.getDay();return a===t.getWeekendStart()||a===t.getWeekendEnd()};return l},true);
//# sourceMappingURL=CalendarUtils.js.map