/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/i18n/date/CalendarWeekNumbering","sap/ui/core/Lib","sap/ui/core/RenderManager","sap/ui/unified/calendar/CalendarUtils","sap/ui/unified/calendar/CalendarDate","sap/ui/unified/calendar/Month","sap/ui/unified/library","./DatesRowRenderer","sap/ui/thirdparty/jquery","sap/ui/core/format/DateFormat","sap/ui/core/Locale","sap/ui/core/date/UI5Date","sap/ui/core/InvisibleText"],function(e,t,a,i,r,s,n,o,jQuery,p,h,l,u){"use strict";var c=s.extend("sap.ui.unified.calendar.DatesRow",{metadata:{library:"sap.ui.unified",properties:{startDate:{type:"object",group:"Data"},days:{type:"int",group:"Appearance",defaultValue:7},showDayNamesLine:{type:"boolean",group:"Appearance",defaultValue:true},calendarWeekNumbering:{type:"sap.base.i18n.date.CalendarWeekNumbering",group:"Appearance",defaultValue:null}}},renderer:o});c.prototype.init=function(){s.prototype.init.apply(this,arguments);this._iColumns=1;this._aWeekNumbers=[];this._bAlwaysShowSpecialDates=true};c.prototype.exit=function(){s.prototype.exit(this,arguments);if(this._invisibleDayHint){this._invisibleDayHint.destroy();this._invisibleDayHint=null}};c.prototype._setAriaRole=function(e){this._ariaRole=e;return this};c.prototype._getAriaRole=function(){return this._ariaRole?this._ariaRole:"gridcell"};c.prototype._getDayDescription=function(){return this._fnInvisibleHintFactory().getId()};c.prototype._fnInvisibleHintFactory=function(){if(!this._invisibleDayHint){this._invisibleDayHint=new u({text:t.getResourceBundleFor("sap.m").getText("SLIDETILE_ACTIVATE")}).toStatic()}return this._invisibleDayHint};c.prototype.setStartDate=function(e){i._checkJSDateObject(e);var t=e.getFullYear();i._checkYearInValidRange(t);this.setProperty("startDate",e);this._oStartDate=r.fromLocalJSDate(e,this.getPrimaryCalendarType());if(this.getDomRef()){var a=this._getDate().toLocalJSDate();this._bNoRangeCheck=true;this.displayDate(e);this._bNoRangeCheck=false;if(a&&this.checkDateFocusable(a)){this.displayDate(a)}}return this};c.prototype._getStartDate=function(){if(!this._oStartDate){this._oStartDate=r.fromLocalJSDate(l.getInstance(),this.getPrimaryCalendarType())}return this._oStartDate};c.prototype.setDate=function(e){if(!this._bNoRangeCheck&&!this.checkDateFocusable(e)){throw new Error("Date must be in visible date range; "+this)}s.prototype.setDate.apply(this,arguments);return this};c.prototype.displayDate=function(e){if(!this._bNoRangeCheck&&!this.checkDateFocusable(e)){throw new Error("Date must be in visible date range; "+this)}s.prototype.displayDate.apply(this,arguments);return this};c.prototype._setTopPosition=function(e){this._iTopPosition=e};c.prototype.setPrimaryCalendarType=function(e){s.prototype.setPrimaryCalendarType.apply(this,arguments);if(this._oStartDate){this._oStartDate=new r(this._oStartDate,e)}return this};c.setSecondaryCalendarType=function(e){this._bSecondaryCalendarTypeSet=true;s.prototype.setSecondaryCalendarType.apply(this,arguments);return this};c.prototype._handleBorderReached=function(e){var t=e.getParameter("event");var a=this._getRelativeInfo?this.getDays()*this._getRelativeInfo().iIntervalSize:this.getDays();var i=this._getRelativeInfo?this._getRelativeInfo().iIntervalSize:1;var s=this._getDate();var n=new r(s,this.getPrimaryCalendarType());if(t.type){switch(t.type){case"sapnext":case"sapnextmodifiers":n.setDate(n.getDate()+i);break;case"sapprevious":case"sappreviousmodifiers":n.setDate(n.getDate()-i);break;case"sappagedown":n.setDate(n.getDate()+a);break;case"sappageup":n.setDate(n.getDate()-a);break;default:break}this.fireFocus({date:n.toLocalJSDate(),otherMonth:true,_outsideBorder:true})}};c.prototype.checkDateFocusable=function(e){i._checkJSDateObject(e);if(this._bNoRangeCheck){return false}var t=this._getStartDate();var a=new r(t,this.getPrimaryCalendarType());var s=this.getDays();if(this._getRelativeInfo&&this._getRelativeInfo().bIsRelative){s=this.getDays()*this._getRelativeInfo().iIntervalSize}a.setDate(a.getDate()+s);var n=r.fromLocalJSDate(e,this.getPrimaryCalendarType());return n.isSameOrAfter(t)&&n.isBefore(a)};c.prototype._renderHeader=function(){var e=this._getStartDate();var t=e.getDay();var i=this._getLocaleData();var r=this.$("Names").children();var s=[];if(this._bLongWeekDays||!this._bNamesLengthChecked){s=i.getDaysStandAlone("abbreviated")}else{s=i.getDaysStandAlone("narrow")}var n=i.getDaysStandAlone("wide");var o=0;for(o=0;o<r.length;o++){var p=jQuery(r[o]);p.text(s[(o+t)%7]);p.attr("aria-label",n[(o+t)%7])}if(this._getShowHeader()){var h=this.$("Head");if(h.length>0){var l=(new a).getInterface();this.getRenderer().renderHeaderLine(l,this,i,e);l.flush(h[0]);l.destroy()}}};c.prototype._getFirstWeekDay=function(){return this._getStartDate().getDay()};c.prototype.getWeekNumbers=function(){var e=this.getDays(),t=this._getLocale(),a=this.getPrimaryCalendarType(),s=this._getStartDate(),n=new r(s,a),o=new r(s,a).setDate(n.getDate()+e),p=[];while(n.isBefore(o)){p.push(new r(n,a));n.setDate(n.getDate()+1)}this._aWeekNumbers=p.reduce(function(e,a){var r=i.calculateWeekNumber(a,this.getPrimaryCalendarType(),t,this.getCalendarWeekNumbering(),this._getFirstWeekDay());if(!e.length||e[e.length-1].number!==r){e.push({len:0,number:r})}e[e.length-1].len++;return e}.bind(this),[]);return this._aWeekNumbers};c.prototype._getCachedWeekNumbers=function(){return this._aWeekNumbers};return c});
//# sourceMappingURL=DatesRow.js.map