/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/i18n/Formatting","sap/base/i18n/date/CalendarType","sap/ui/core/Control","sap/ui/Device","sap/ui/core/LocaleData","sap/ui/core/delegate/ItemNavigation","sap/ui/unified/library","sap/ui/core/Locale","./MonthPickerRenderer","sap/ui/thirdparty/jquery","sap/ui/events/KeyCodes","sap/ui/unified/DateRange","sap/ui/unified/calendar/CalendarUtils","sap/ui/unified/calendar/CalendarDate","sap/ui/core/date/UI5Date"],function(t,e,a,i,s,o,n,r,h,jQuery,l,g,c,f,d){"use strict";var u=12,p=2,_={OneYearBackward:-1,OneYearForward:1};var m=a.extend("sap.ui.unified.calendar.MonthPicker",{metadata:{library:"sap.ui.unified",properties:{month:{type:"int",group:"Data",defaultValue:0},months:{type:"int",group:"Appearance",defaultValue:12},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},_singleSelection:{type:"boolean",group:"Behavior",defaultValue:true,visibility:"hidden"},_showSelectedRange:{type:"boolean",group:"Appearance",defaultValue:false,visibility:"hidden"},columns:{type:"int",group:"Appearance",defaultValue:3},primaryCalendarType:{type:"sap.base.i18n.date.CalendarType",group:"Appearance"},secondaryCalendarType:{type:"sap.base.i18n.date.CalendarType",group:"Appearance"},_firstMonth:{type:"int",group:"Data",visibility:"hidden",defaultValue:0},_focusedMonth:{type:"int",group:"Data",visibility:"hidden"}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{select:{},pageChange:{}}},renderer:h});m.prototype.init=function(){this._iMinMonth=0;this._iMaxMonth=11};m.prototype.onAfterRendering=function(){var t,e=this.getMonth(),a=this.getMonths(),i=this.getProperty("_firstMonth"),s=this.getProperty("_focusedMonth"),o=this._oItemNavigation?this._oItemNavigation.getFocusedIndex():0;M.call(this);S.call(this);if(this.getColumns()>0){t=s%a;var n=parseInt(u/a),r=n*a;if(s>=r){t=12-r+1+t}}else if(e<i||e>i+a-1){t=o}else{t=e-i}this._oItemNavigation.focusItem(t)};m.prototype.setMonth=function(t){var e=Math.floor(t/this.getMonths())*this.getMonths();if(e+this.getMonths()>12){e=12-this.getMonths()}this.setProperty("month",t);this.setProperty("_focusedMonth",t);this.setProperty("_firstMonth",e);t=this.getProperty("month");if(t<0||t>11){throw new Error("Property month must be between 0 and 11; "+this)}if(this.getIntervalSelection()){this._oItemNavigation&&this._oItemNavigation.focusItem(t);return this}if(this.getDomRef()){if(this.getMonths()<12){var a=this.getStartMonth();if(t>=a&&t<=a+this.getMonths()-1){this._selectMonth(t,true);this._oItemNavigation.focusItem(t-a)}else{v.call(this,t)}}else{this._selectMonth(t,true);this._oItemNavigation.focusItem(t)}}return this};m.prototype.getSelectedDates=function(){if(this._oSelectedDatesControlOrigin){return this._oSelectedDatesControlOrigin.getSelectedDates()}return this.getAggregation("selectedDates")};m.prototype._getPrimaryCalendarType=function(){return this.getProperty("primaryCalendarType")||t.getCalendarType()};m.prototype._getSelectedDates=function(){var t=this.getSelectedDates(),e;if(t){return t}else if(!this._aMPSelectedDates||!this._aMPSelectedDates.length){this._aMPSelectedDates=[new g];e=f.fromLocalJSDate(d.getInstance(),this._getPrimaryCalendarType());e.setMonth(this.getMonth(),1);this._iYear&&e.setYear(this._iYear);this._aMPSelectedDates[0].setStartDate(e.toLocalJSDate());return this._aMPSelectedDates}else{return this._aMPSelectedDates}};m.prototype.exit=function(){if(this._aMPSelectedDates&&this._aMPSelectedDates.length){this._aMPSelectedDates.forEach(function(t){t.destroy()});this._aMPSelectedDates=undefined}};m.prototype.getFocusDomRef=function(){return this.getDomRef()&&this._oItemNavigation.getItemDomRefs()[this._oItemNavigation.getFocusedIndex()]};m.prototype.setIntervalSelection=function(t){this._setShowSelectedRange(t);return this.setProperty("intervalSelection",t)};m.prototype._setShowSelectedRange=function(t){return this.setProperty("_showSelectedRange",t)};m.prototype._getShowSelectedRange=function(){return this.getProperty("_showSelectedRange")};m.prototype._setSelectedDatesControlOrigin=function(t){this._oSelectedDatesControlOrigin=t};m.prototype._setYear=function(t){this._iYear=t};m.prototype._setDate=function(t){this._oDate=t};m.prototype._getLocale=function(){var e=this._oSelectedDatesControlOrigin;if(e&&e._getLocale){return e._getLocale()}else if(!this._sLocale){this._sLocale=new r(t.getLanguageTag()).toString()}return this._sLocale};m.prototype._getLocaleData=function(){var t=this._oSelectedDatesControlOrigin;if(t&&t._getLocaleData){return t._getLocaleData()}else if(!this._oLocaleData){var e=this._getLocale();var a=new r(e);this._oLocaleData=s.getInstance(a)}return this._oLocaleData};m.prototype.onsapspace=function(t){t.preventDefault()};m.prototype.onsapselect=function(t){var e=this._oItemNavigation.getFocusedIndex();var a=e+this.getStartMonth();if(a>=this._iMinMonth&&a<=this._iMaxMonth){this._selectMonth(a);this.fireSelect()}};m.prototype.onmousedown=function(t){this._oMousedownPosition={clientX:t.clientX,clientY:t.clientY}};m.prototype.onmouseup=function(t){var e=t.target,a=this._getSelectedDates()[0],s,o,n;if(this._bMousedownChange){this._bMousedownChange=false;if(this.getIntervalSelection()&&e.classList.contains("sapUiCalItem")&&a){s=f.fromLocalJSDate(a.getStartDate(),this._getPrimaryCalendarType());o=a.getEndDate();n=this._extractMonth(e);if(n!==s.getMonth()&&!o&&n>=this._iMinMonth&&n<=this._iMaxMonth){this._selectMonth(n);this._oItemNavigation.focusItem(n)}}this.fireSelect()}else if(i.support.touch&&this._isValueInThreshold(this._oMousedownPosition.clientX,t.clientX,10)&&this._isValueInThreshold(this._oMousedownPosition.clientY,t.clientY,10)){n=this._oItemNavigation.getFocusedIndex()+this.getStartMonth();if(n>=this._iMinMonth&&n<=this._iMaxMonth){this._selectMonth(n);this.fireSelect()}}};m.prototype.onmouseover=function(t){var e=t.target,a=this._getSelectedDates()[0],i,s;if(!a){return}if(a.getStartDate()){i=f.fromLocalJSDate(a.getStartDate(),this._getPrimaryCalendarType());i.setDate(1)}if(e.classList.contains("sapUiCalItem")){s=f.fromLocalJSDate(d.getInstance(),this._getPrimaryCalendarType());s.setMonth(this._extractMonth(e),1);this._iYear&&s.setYear(this._iYear);if(this._isSelectionInProgress()){this._markInterval(i,s)}}};m.prototype.onThemeChanged=function(){if(this._bNoThemeChange){return}if(!this.getDomRef()){return}var t=this._oItemNavigation.getItemDomRefs(),e=this._getLocaleData(),a=e.getMonthsStandAlone("wide",this._getPrimaryCalendarType()),i,s;this._bNamesLengthChecked=undefined;this._bLongMonth=false;for(i=0;i<t.length;i++){s=jQuery(t[i]);s.text(a[i])}S.call(this)};m.prototype.nextPage=function(){var t=this.getStartMonth(),e=this._oItemNavigation.getFocusedIndex(),a=e+t,i=this.getMonths();a=a+i;if(a>u-1){a=u-1}v.call(this,a);var s=Math.floor(this.getStartMonth()+this.getMonths())%u;if(s+this.getMonths()>12){s=12-this.getMonths()}this.setProperty("_firstMonth",s);return this};m.prototype.previousPage=function(){var t=this.getStartMonth(),e=this._oItemNavigation.getFocusedIndex(),a=e+t,i=this.getMonths();a=a-i;if(a<0){a=0}v.call(this,a);var s=Math.floor(this.getStartMonth()-this.getMonths())%u;if(s<0){s=0}this.setProperty("_firstMonth",s);return this};m.prototype.setMinMax=function(t,e){var a,i,s,o;if(t==this._iMinMonth&&e==this._iMaxMonth){return this}t=parseInt(t);if(isNaN(t)||t<0||t>11){t=0}e=parseInt(e);if(isNaN(e)||e<0||e>11){e=11}if(t<=e){this._iMinMonth=t;this._iMaxMonth=e}else{this._iMaxMonth=t;this._iMinMonth=e}if(this.getDomRef()){a=this._oItemNavigation.getItemDomRefs();for(o=0;o<a.length;o++){i=jQuery(a[o]);s=this._extractMonth(a[o]);if(s<this._iMinMonth||s>this._iMaxMonth){i.addClass("sapUiCalItemDsbl");i.attr("aria-disabled",true)}else{i.removeClass("sapUiCalItemDsbl");i.removeAttr("aria-disabled")}}}return this};m.prototype.getStartMonth=function(){return this.getProperty("_firstMonth")};m.prototype._isValueInThreshold=function(t,e,a){var i=t-a,s=t+a;return e>=i&&e<=s};m.prototype._getSecondaryCalendarType=function(){var t=this.getSecondaryCalendarType();if(t===this._getPrimaryCalendarType()){return undefined}return t};m.prototype._getDisplayedSecondaryDates=function(t){var e=this.getSecondaryCalendarType(),a=new f(this._oDate?this._oDate:f.fromLocalJSDate(d.getInstance()),this._getPrimaryCalendarType()),i,s;a.setMonth(t);a.setDate(1);i=new f(a,e);a.setDate(c._daysInMonth(a));s=new f(a,e);return{start:i,end:s}};function M(){var t=this.getDomRef(),e=this.$().find(".sapUiCalItem"),a=this.getColumns();if(!this._oItemNavigation){this._oItemNavigation=new o;this._oItemNavigation.attachEvent(o.Events.AfterFocus,this._handleAfterFocus,this);this._oItemNavigation.attachEvent(o.Events.FocusAgain,y,this);this._oItemNavigation.attachEvent(o.Events.BorderReached,D,this);this.addDelegate(this._oItemNavigation);this._oItemNavigation.setHomeEndColumnMode(true,true);this._oItemNavigation.setDisabledModifiers({sapnext:["alt","meta"],sapprevious:["alt","meta"],saphome:["alt","meta"],sapend:["meta"]})}this._oItemNavigation.setRootDomRef(t);this._oItemNavigation.setItemDomRefs(e);this._oItemNavigation.setCycling(false);this._oItemNavigation.setColumns(a,true);var i=this.getMonth()-this.getStartMonth();this._oItemNavigation.setFocusedIndex(i);this._oItemNavigation.setPageSize(e.length)}m.prototype._handleAfterFocus=function(t){var e=t.getParameter("index"),a=t.getParameter("event"),i=this._oItemNavigation.aItemDomRefs[e],s=this._getSelectedDates()[0],o,n;if(!a){return}if(a.type==="mousedown"){this._handleMousedown(a,e)}else if(a.type==="sapnext"||a.type==="sapprevious"){if(!s){return}if(s.getStartDate()){o=f.fromLocalJSDate(s.getStartDate(),this._getPrimaryCalendarType());o.setDate(1)}n=f.fromLocalJSDate(d.getInstance(),this._getPrimaryCalendarType());n.setMonth(this._extractMonth(i),1);this._iYear&&n.setYear(this._iYear);if(this._isSelectionInProgress()){this._markInterval(o,n)}}};function y(t){this._handleAfterFocus(t)}m.prototype._isSelectionInProgress=function(){const t=this._getShowSelectedRange();const e=this._getSelectedDates()[0];if(!e){return false}return t&&e.getStartDate()&&!e.getEndDate()};m.prototype._extractMonth=function(t){var e=this.getId().length+p;return parseInt(t.id.slice(e))};m.prototype._markInterval=function(t,e){var a=this._oItemNavigation.getItemDomRefs(),i=f.fromLocalJSDate(d.getInstance(),this._getPrimaryCalendarType()),s;if(t.isAfter(e)){e=[t,t=e][0]}if(this._bMousedownChange){if(e.getMonth()>this._iMinMonth&&e.getMonth()<this._iMaxMonth){jQuery(a[e.getMonth()]).addClass("sapUiCalItemSel")}if(t.getMonth()>this._iMinMonth&&t.getMonth()<this._iMaxMonth){jQuery(a[t.getMonth()]).addClass("sapUiCalItemSel")}}for(s=0;s<a.length;++s){i.setMonth(this._extractMonth(a[s]),1);this._iYear&&i.setYear(this._iYear);if(c._isBetween(i,t,e)&&i.getMonth()>this._iMinMonth&&i.getMonth()<this._iMaxMonth){jQuery(a[s]).addClass("sapUiCalItemSelBetween")}else{jQuery(a[s]).removeClass("sapUiCalItemSelBetween")}if(this._bMousedownChange&&!i.isSame(t)&&!i.isSame(e)){jQuery(a[s]).removeClass("sapUiCalItemSel")}}};m.prototype._handleMousedown=function(t,e){if(t.button||i.support.touch&&!i.system.combi){return}var a=e+this.getStartMonth();if(a>=this._iMinMonth&&a<=this._iMaxMonth){this._selectMonth(a);this._bMousedownChange=true}t.preventDefault();t.setMark("cancelAutoClose")};function D(t){var e=t.getParameter("event"),a=this._oItemNavigation.getFocusedIndex()+this.getStartMonth(),i=this.getMonths(),s=this.getColumns(),o=this._getSelectedDates()[0],n,r=f.fromLocalJSDate(d.getInstance(),this._getPrimaryCalendarType()),h=s===0&&i<u;this._iYear&&r.setYear(this._iYear);if(o&&o.getStartDate()){n=f.fromLocalJSDate(o.getStartDate(),this._getPrimaryCalendarType());n.setDate(1)}if(e.type){switch(e.type){case"sapnext":case"sapnextmodifiers":if(h){this._oneRowChangePage(a,true)}else if(e.keyCode===l.ARROW_DOWN&&s<=i){if(a<u-i){v.call(this,a+s,false,_.OneYearForward)}else if(i===u){this.firePageChange({offset:_.OneYearForward});this._oItemNavigation.focusItem(a%s);r.setMonth(a%s,1);this.setProperty("_focusedMonth",a%s);this._isSelectionInProgress()&&this._markInterval(n,r)}else{if(s===0){s=i}v.call(this,a%s,true,_.OneYearForward)}}else{if(a<u-i){v.call(this,a+1,false,_.OneYearForward)}else if(i===u){this.firePageChange({offset:_.OneYearForward});this._oItemNavigation.focusItem(0);r.setMonth(0,1);this._isSelectionInProgress()&&this._markInterval(n,r)}else{v.call(this,0,true,_.OneYearForward)}}break;case"sapprevious":case"sappreviousmodifiers":if(h){this._oneRowChangePage(a)}else if(e.keyCode===l.ARROW_UP&&s<=i){if(a>=i){v.call(this,a-s,false,_.OneYearBackward)}else if(i===u){this.firePageChange({offset:_.OneYearBackward});this._oItemNavigation.focusItem(i-s+a);r.setMonth(i-s+a,1);this.setProperty("_focusedMonth",i-s+a);this._isSelectionInProgress()&&this._markInterval(n,r)}else{v.call(this,u-s+a,true,_.OneYearBackward)}}else{if(a>=i){v.call(this,a-1,false,_.OneYearBackward)}else if(i===u){this.firePageChange({offset:_.OneYearBackward});this._oItemNavigation.focusItem(i-1);r.setMonth(i-1,1);this._isSelectionInProgress()&&this._markInterval(n,r)}else{v.call(this,u-1,true,_.OneYearBackward)}}break;case"sappagedown":if(a<u-i){v.call(this,a+i,false,_.OneYearForward)}else if(i===u){this.firePageChange({offset:_.OneYearForward})}else{v.call(this,a,true,_.OneYearForward)}break;case"sappageup":if(a>i){v.call(this,a-i,false,_.OneYearBackward)}else if(i===u){this.firePageChange({offset:_.OneYearBackward})}else{v.call(this,a,true,_.OneYearBackward)}break;default:break}}}m.prototype._oneRowChangePage=function(t,e){var a=this.getProperty("_firstMonth"),i=this.getMonths(),s=e?a+i<u:a>0,o=e?1:-1;if(s){e&&this.nextPage()||this.previousPage();this.firePageChange({offset:0});this.setMonth(t+o)}};m.prototype._selectMonth=function(t,e){var a=this._getSelectedDates()[0],i=this.getAggregation("selectedDates"),s,o;this.setProperty("_focusedMonth",t);if(!a){return}!e&&this.setProperty("month",t);o=f.fromLocalJSDate(d.getInstance(),this._getPrimaryCalendarType());o.setMonth(t,1);this._iYear&&o.setYear(this._iYear);if(!this._oSelectedDatesControlOrigin){if(!i||!i.length){this.addAggregation("selectedDates",a,true)}!this.getIntervalSelection()&&a.setStartDate(o.toLocalJSDate())}if(this.getIntervalSelection()&&!e){if(!a.getStartDate()){a.setStartDate(o.toLocalJSDate())}else if(!a.getEndDate()){s=f.fromLocalJSDate(a.getStartDate(),this._getPrimaryCalendarType());if(o.isBefore(s)){a.setEndDate(s.toLocalJSDate());a.setStartDate(o.toLocalJSDate())}else{a.setEndDate(o.toLocalJSDate())}}else{a.setStartDate(o.toLocalJSDate());a.setEndDate(undefined)}}};function S(){if(!this._bNamesLengthChecked){var t=0,e=this._oItemNavigation.getItemDomRefs(),a=false,i=this.getMonths(),s=Math.ceil(u/i),o=i-1;for(var n=0;n<s;n++){if(i<u){v.call(this,o);o=o+i;if(o>u-1){o=u-1}}for(t=0;t<e.length;t++){var r=e[t];if(Math.abs(r.clientWidth-r.scrollWidth)>1){a=true;break}}if(a){break}}if(i<u){o=this.getMonth();v.call(this,o)}if(a){this._bLongMonth=false;var h=this._getLocaleData(),l=this._getPrimaryCalendarType(),g=h.getMonthsStandAlone("abbreviated",l),c=h.getMonthsStandAlone("wide",l);for(t=0;t<e.length;t++){var f=jQuery(e[t]);f.text(g[t]);f.attr("aria-label",c[t])}}else{this._bLongMonth=true}this._bNamesLengthChecked=true}}function v(t,e,a){var i=this._getSelectedDates()[0],s,o;this.setProperty("_focusedMonth",t);if(i&&i.getStartDate()){s=f.fromLocalJSDate(i.getStartDate(),this._getPrimaryCalendarType());s.setDate(1)}if(i&&i.getEndDate()){o=f.fromLocalJSDate(i.getEndDate(),this._getPrimaryCalendarType());o.setDate(1)}else{o=f.fromLocalJSDate(d.getInstance(),this._getPrimaryCalendarType());this._iYear&&o.setYear(this._iYear);o.setMonth(t,1)}this._isSelectionInProgress()&&this._markInterval(s,o);if(e){this.firePageChange({offset:a})}}m.prototype._isMonthSelected=function(t){const e=this.getSelectedDates();const a=this._getShowSelectedRange();if(!(e&&e.length)){return false}const i=e[0];const s=i.getStartDate();const o=i.getEndDate();if(a&&s&&o){const e=f.fromLocalJSDate(s,this._getPrimaryCalendarType());const a=f.fromLocalJSDate(o,this._getPrimaryCalendarType());return c._isSameMonthAndYear(t,e)||c._isSameMonthAndYear(t,a)}const n=e=>{const a=e.getStartDate();if(a){const a=f.fromLocalJSDate(e.getStartDate(),this._getPrimaryCalendarType());return c._isSameMonthAndYear(t,a)}return false};if(this.getProperty("_singleSelection")){return n(i)}return e.some(n)};m.prototype._isMonthInsideSelectionRange=function(t){const e=this.getSelectedDates();const a=this._getShowSelectedRange();if(!(e&&e.length)){return false}const i=e[0];if(!i){return false}if(a){const e=i.getStartDate();const a=i.getEndDate();if(!e||!a){return false}const s=f.fromLocalJSDate(e,this._getPrimaryCalendarType());const o=f.fromLocalJSDate(a,this._getPrimaryCalendarType());s.setDate(1);o.setDate(c._daysInMonth(o));return c._isBetween(t,s,o,true)}return false};return m});
//# sourceMappingURL=MonthPicker.js.map