/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/i18n/date/CalendarType","sap/ui/core/Element","sap/ui/core/Lib","sap/ui/unified/calendar/CalendarUtils","sap/ui/unified/calendar/CalendarDate","sap/ui/unified/CalendarLegend","sap/ui/unified/CalendarLegendRenderer","sap/ui/unified/library","sap/base/Log","sap/ui/core/InvisibleText","sap/ui/core/date/UI5Date","sap/ui/core/date/CalendarUtils","sap/ui/core/Locale"],function(e,a,t,i,n,r,s,o,l,d,c,p,g){"use strict";var u=o.CalendarDayType;var y={apiVersion:2};y.render=function(e,a){var i=this.getStartDate(a),n=a.getTooltip_AsString(),r=t.getResourceBundleFor("sap.ui.unified"),s=a.getId(),o={value:"",append:!a._bCalendar},l="",c=a.getWidth();e.openStart("div",a);this.getClass(e,a).forEach(function(a){e.class(a)});if(a._getSecondaryCalendarType()){e.class("sapUiCalMonthSecType")}this.addWrapperAdditionalStyles(e,a);if(n){e.attr("title",n)}if(a._getShowHeader()){o.value=s+"-Head"}if(a._bCalendar){l=d.getStaticId("sap.ui.unified","CALENDAR_MONTH_PICKER_OPEN_HINT")+" "+d.getStaticId("sap.ui.unified","CALENDAR_YEAR_PICKER_OPEN_HINT")}if(c){e.style("width",c)}e.accessibilityState(a,{role:"grid",roledescription:a._bCalendar?"":r.getText("CALENDAR_DIALOG"),multiselectable:!a.getSingleSelection()||a.getIntervalSelection(),labelledby:o,describedby:l});e.openEnd();this.renderMonth(e,a,i);e.close("div")};y.addWrapperAdditionalStyles=function(){};y.getStartDate=function(e){return e._getDate()};y.getClass=function(a,t){var i=["sapUiCalMonthView"],n=t.getPrimaryCalendarType(),r=t.getShowWeekNumbers();if(n===e.Islamic||!r){i.push("sapUiCalNoWeekNum")}return i};y.renderMonth=function(e,a,t){this.renderHeader(e,a,t);this.renderDays(e,a,t)};y.renderHeader=function(e,a,t){var i=a._getLocaleData();var n=a._getFirstDayOfWeek();this.renderHeaderLine(e,a,i,t);e.openStart("div");e.accessibilityState(null,{role:"row"});e.style("overflow","hidden");e.openEnd();this.renderDayNames(e,a,i,n,7,true,undefined);e.close("div")};y.renderHeaderLine=function(e,a,t,n){i._checkCalendarDate(n);if(a._getShowHeader()){var r=a.getId();var s=a.getPrimaryCalendarType();var o=t.getMonthsStandAlone("wide",s);e.openStart("div",r+"-Head");e.class("sapUiCalHeadText");e.openEnd();e.text(o[n.getMonth()]);e.close("div")}};y.renderDayNames=function(a,t,i,n,r,s,o){var l=t._getFirstDayOfWeek();var d=t.getId();var c="";var p=t.getPrimaryCalendarType();var g=[];if(t._bLongWeekDays||!t._bNamesLengthChecked){g=i.getDaysStandAlone("abbreviated",p)}else{g=i.getDaysStandAlone("narrow",p)}var u=i.getDaysStandAlone("wide",p);if(t.getShowWeekNumbers()&&p!==e.Islamic){this.renderDummyCell(a,"sapUiCalWH",true,"columnheader")}for(var y=0;y<r;y++){if(s){c=d+"-WH"+(y+l)%7}else{c=d+"-WH"+y}a.openStart("div",c);a.class("sapUiCalWH");if(y===0){a.class("sapUiCalFirstWDay")}if(o){a.style("width",o)}a.accessibilityState(null,{role:"columnheader"});a.openEnd();a.openStart("span");a.attr("aria-hidden","true");a.openEnd();a.text(g[(y+n)%7]);a.close("span");a.openStart("span");a.class("sapUiPseudoInvisibleText");a.openEnd();a.text(u[(y+n)%7]);a.close("span");a.close("div")}};y.renderDays=function(a,t,n){var r,s,o,l,d,c,p;i._checkCalendarDate(n);if(!n){n=t._getFocusedDate()}c=n.toUTCJSDate().getTime();if(!c&&c!==0){throw new Error("Date is invalid "+t)}l=this.getDayHelper(t,n);s=t._getVisibleDays(n,true);p=t.getShowWeekNumbers();r=t.getPrimaryCalendarType()!==e.Islamic&&p;o=s.length;for(d=0;d<o;d++){if(d%7===0){a.openStart("div");a.attr("role","row");a.openEnd();if(r){this._renderWeekNumber(a,s[d],l,t)}}this.renderDay(a,t,s[d],l,true,r,-1);if(d%7===6||d===o-1){a.close("div")}}if(o===28){this.renderDummyCell(a,"sapUiCalItem",false,"")}};y.renderDummyCell=function(e,a,i,n){e.openStart("div");e.class(a);e.class("sapUiCalDummy");e.style("visibility",i?"visible":"hidden");e.attr("role",n);e.openEnd();e.openStart("span");e.class("sapUiPseudoInvisibleText");e.openEnd();e.text(t.getResourceBundleFor("sap.ui.unified").getText("CALENDAR_WEEK"));e.close("span");e.close("div")};y.isTypeAttributeRequired=function(e,a,t,i){const n=i.color?.toLowerCase();if(e){return t===n&&a===i.type}return a===""||a===u.None||a===i.type};y.isColorAttributeRequired=function(e,a,t,i,n){const r=e&&!a;const s=e===t&&i===n[0].type;const o=e===t&&(!i||i===u.None);if(r){return true}return s||o};y.getDayHelper=function(e,t){var i,s,o=e._getLocaleData(),d={sLocale:e._getLocale(),oLocaleData:o,iMonth:t.getMonth(),iYear:t.getYear(),iFirstDayOfWeek:e._getFirstDayOfWeek(),iWeekendStart:o.getWeekendStart(),iWeekendEnd:o.getWeekendEnd(),aNonWorkingDays:e._getNonWorkingDays(),sToday:o.getRelativeDay(0),oToday:n.fromLocalJSDate(c.getInstance(),e.getPrimaryCalendarType()),sId:e.getId(),oFormatLong:e._getFormatLong(),sPrimaryCalendarType:e.getPrimaryCalendarType(),sSecondaryCalendarType:e._getSecondaryCalendarType(),oLegend:undefined};s=e.getLegend();if(s&&typeof s==="string"){i=a.getElementById(s);if(i){if(!(i instanceof r)){throw new Error(i+" is not an sap.ui.unified.CalendarLegend. "+e)}d.oLegend=i}else{l.warning("CalendarLegend "+s+" does not exist!",e)}}return d};y.renderDay=function(e,a,t,r,o,l,c,y,f){i._checkCalendarDate(t);var C=new n(t,r.sSecondaryCalendarType),D={role:a._getAriaRole(),selected:false,label:"",describedby:a._getDayDescription()},b=t._bBeforeFirstYear,m="",S=r.oLegend;var h=a._oFormatYyyymmdd.format(t.toUTCJSDate(),true);var _=t.getDay();var v=a._checkDateSelected(t);var W=a._getDateTypes(t);var T=r&&r.oLegend?r.oLegend._getSpecialDateTypeFilter():"";var E=r?.oLegend?r.oLegend._getSpecialDateColorFilter().toLowerCase():"";var N=a._checkDateEnabled(t);var k=a._isSpecialDateMarkerEnabled(t);const I=W.length>0&&W[0].type;const L=W.length>0&&W[0].secondaryType;const U=r.aNonWorkingDays&&r.aNonWorkingDays instanceof Array?r.aNonWorkingDays.some(e=>t.getDay()===e):i._isWeekend(t,a._getLocaleData());const A=I!==u.Working&&L!==u.Working&&U;const w=I===u.NonWorking||L===u.NonWorking||A;const R=!!(T||E)&&(T!==u.None||E);const x=a._oUnifiedRB.getText("LEGEND_NON_WORKING_DAY");const F=d.getStaticId("sap.ui.unified","CALENDAR_START_DATE");const M=d.getStaticId("sap.ui.unified","CALENDAR_END_DATE");const O=[];if(b){N=false}e.openStart("div",r.sId+"-"+h);e.class("sapUiCalItem");e.class("sapUiCalWDay"+_);if(y){e.style("width",y)}if(_===r.iFirstDayOfWeek){e.class("sapUiCalFirstWDay")}if(o&&r.iMonth!==t.getMonth()){e.class("sapUiCalItemOtherMonth");D["disabled"]=true}if(t.isSame(r.oToday)){e.class("sapUiCalItemNow");O.push(a._oUnifiedRB.getText("LEGEND_TODAY"))}if(v>0){e.class("sapUiCalItemSel");D["selected"]=true}else{D["selected"]=false}if(v===2){e.class("sapUiCalItemSelStart");D["describedby"]=`${D["describedby"]} ${F}`.trim()}else if(v===3){e.class("sapUiCalItemSelEnd");D["describedby"]=`${D["describedby"]} ${M}`.trim()}else if(v===4){e.class("sapUiCalItemSelBetween")}else if(v===5){e.class("sapUiCalItemSelStart");e.class("sapUiCalItemSelEnd");D["describedby"]=`${D["describedby"]} ${F}`.trim();D["describedby"]=`${D["describedby"]} ${M}`.trim()}if(this.renderWeekNumbers&&a.getShowWeekNumbers()&&a._oDate){const e=p.getWeekConfigurationValues(a.getCalendarWeekNumbering(),new g(a._getLocale()));e.firstDayOfWeek=a._getFirstDayOfWeek();const r=n.fromUTCDate(i.getFirstDateOfWeek(t.toLocalJSDate(),e),a.getPrimaryCalendarType());D["describedby"]=D["describedby"]+" "+a.getId()+"-week-"+a._calculateWeekNumber(r)+"-text"}if(w){e.class("sapUiCalItemWeekEnd");O.push(x)}if(k){const a=this;W.forEach(function(t,i){if(t.type!==u.None){if(a.isTypeAttributeRequired(R,T,E,t)){if(i===0){e.class("sapUiCalItem"+t.type)}m=t.type;if(t.tooltip){O.push(t.tooltip)}}}})}if(O.length){const a=O.filter((e,a)=>O.indexOf(e)===a);e.attr("title",a.join(" "))}if((a.getParent()&&a.getParent().getMetadata().getName()==="sap.ui.unified.CalendarOneMonthInterval"||a.getMetadata().getName()==="sap.ui.unified.calendar.OneMonthDatesRow")&&a.getStartDate()&&r.iMonth!==t.getMonth()){e.class("sapUiCalItemOtherMonth")}if(!N){e.class("sapUiCalItemDsbl");D["disabled"]=true}e.attr("tabindex","-1");e.attr("data-sap-day",h);if(f){D["label"]=D["label"]+r.aWeekDaysWide[_]+" "}D["label"]=D["label"]+r.oFormatLong.format(t.toUTCJSDate(),true);if(m!==""){s.addCalendarTypeAccInfo(D,m,S)}if(r.sSecondaryCalendarType){D["label"]=D["label"]+" "+a._oFormatSecondaryLong.format(C.toUTCJSDate(),true)}e.accessibilityState(null,D);e.openEnd();if(W[0]&&k){e.openStart("div");e.class("sapUiCalSpecialDate");const a=W[0].color?.toLowerCase();if(this.isColorAttributeRequired(a,R,E,T,W)){e.style("background-color",a)}e.openEnd();e.close("div")}e.openStart("span");e.class("sapUiCalItemText");if(W[0]&&W[0].color){e.class("sapUiCalItemTextCustomColor")}e.openEnd();if(!b){e.text(t.getDate())}e.close("span");if(f){e.openStart("span");e.class("sapUiCalDayName");e.openEnd();e.text(r.aWeekDays[_]);e.close("span")}if(r.sSecondaryCalendarType){e.openStart("span");e.class("sapUiCalItemSecText");e.openEnd();e.text(C.getDate());e.close("span")}e.close("div")};y._renderWeekNumber=function(e,a,t,i){var n=i._calculateWeekNumber(a);var r=t.sId+"-WNum-"+n;e.openStart("div",r);e.class("sapUiCalWeekNum");e.accessibilityState(null,{role:"rowheader",labelledby:d.getStaticId("sap.ui.unified","CALENDAR_WEEK")+" "+r});e.openEnd();e.text(n);e.close("div")};return y},true);
//# sourceMappingURL=MonthRenderer.js.map