/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/i18n/Formatting","sap/base/i18n/date/CalendarType","sap/ui/core/Control","sap/ui/core/Element","sap/ui/core/Lib","sap/ui/core/LocaleData","sap/ui/core/delegate/ItemNavigation","sap/ui/unified/calendar/CalendarUtils","sap/ui/unified/calendar/CalendarDate","sap/ui/unified/library","sap/ui/core/format/DateFormat","sap/ui/core/Locale","./MonthsRowRenderer","sap/ui/dom/containsOrEquals","sap/ui/thirdparty/jquery","sap/ui/unified/DateRange","sap/ui/core/date/UI5Date","sap/ui/core/InvisibleText"],function(e,t,a,i,r,o,n,s,l,h,g,p,c,u,jQuery,f,d,y){"use strict";var m=a.extend("sap.ui.unified.calendar.MonthsRow",{metadata:{library:"sap.ui.unified",properties:{date:{type:"object",group:"Data"},startDate:{type:"object",group:"Data"},months:{type:"int",group:"Appearance",defaultValue:12},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},showHeader:{type:"boolean",group:"Appearance",defaultValue:false},primaryCalendarType:{type:"sap.base.i18n.date.CalendarType",group:"Appearance"},secondaryCalendarType:{type:"sap.base.i18n.date.CalendarType",group:"Appearance"}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},focus:{parameters:{date:{type:"object"},notVisible:{type:"boolean"}}}}},renderer:c});m.prototype.init=function(){var e=this._getPrimaryCalendarType();this._oFormatYyyymm=g.getInstance({pattern:"yyyyMMdd",calendarType:e});this._oFormatOnlyYearLong=g.getInstance({pattern:"yyyy",calendarType:e});this._oFormatLong=g.getInstance({pattern:"MMMM y",calendarType:e});this._mouseMoveProxy=jQuery.proxy(this._handleMouseMove,this);this._rb=r.getResourceBundleFor("sap.ui.unified")};m.prototype.setPrimaryCalendarType=function(e){this.setProperty("primaryCalendarType",e);this._oFormatYyyymm=g.getInstance({pattern:"yyyyMMdd",calendarType:e});this._oFormatLong=g.getInstance({pattern:"MMMM y",calendarType:e});return this};m.prototype._getPrimaryCalendarType=function(){return this.getProperty("primaryCalendarType")||e.getCalendarType()};m.prototype.setSecondaryCalendarType=function(e){this.setProperty("secondaryCalendarType",e);this._oFormatYearInSecType=g.getDateInstance({format:"y",calendarType:e});this._oFormatLongInSecType=g.getInstance({pattern:"MMMM y",calendarType:e});return this};m.prototype._getSecondaryCalendarType=function(){var e=this.getSecondaryCalendarType();if(e===this._getPrimaryCalendarType()){return undefined}return e};m.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation}if(this._sInvalidateMonths){clearTimeout(this._sInvalidateMonths)}if(this._invisibleDayHint){this._invisibleDayHint.destroy();this._invisibleDayHint=null}};m.prototype.onAfterRendering=function(){D.call(this);T.call(this)};m.prototype.onsapfocusleave=function(e){if(!e.relatedControlId||!u(this.getDomRef(),i.getElementById(e.relatedControlId).getFocusDomRef())){if(this._bMouseMove){w.call(this,true);I.call(this,this._getDate());this._bMoveChange=false;this._bMousedownChange=false;L.call(this)}if(this._bMousedownChange){this._bMousedownChange=false;L.call(this)}}};m.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var e=this.removeAllAggregation("selectedDates");return e};m.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var e=this.destroyAggregation("selectedDates");return e};m.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var e=this.removeAllAggregation("specialDates");return e};m.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var e=this.destroyAggregation("specialDates");return e};m.prototype.setDate=function(e){if(e){var t=l.fromLocalJSDate(e,this.getProperty("primaryCalendarType"));this._oDate=t;C.call(this,t,false)}return this.setProperty("date",e)};m.prototype._getDisplayedSecondaryDates=function(e,t){var a=this._getSecondaryCalendarType(),i,r,o;if(this._oDate){i=new l(this._oDate)}else{i=new l(l.fromLocalJSDate(d.getInstance()),this._getPrimaryCalendarType())}i.setYear(t);i.setMonth(e);i.setDate(1);r=new l(i,a);i.setDate(s._daysInMonth(i));o=new l(i,a);return{start:r,end:o}};m.prototype._getDate=function(){if(!this._oDate){this._oDate=l.fromLocalJSDate(d.getInstance(),this.getProperty("primaryCalendarType"))}return this._oDate};m.prototype.setStartDate=function(e){s._checkJSDateObject(e);var t,a,i;a=e.getFullYear();s._checkYearInValidRange(a);t=l.fromLocalJSDate(e,this.getProperty("primaryCalendarType"));this.setProperty("startDate",e,true);this._oStartDate=t;this._oStartDate.setDate(1);if(this.getDomRef()){i=this._getDate().toLocalJSDate();this._bNoRangeCheck=true;this.displayDate(e);this._bNoRangeCheck=false;if(i&&this.checkDateFocusable(i)){this.setDate(i)}}return this};m.prototype._getStartDate=function(){if(!this._oStartDate){this._oStartDate=l.fromLocalJSDate(d.getInstance(),this.getProperty("primaryCalendarType"));this._oStartDate.setDate(1)}return this._oStartDate};m.prototype.displayDate=function(e){C.call(this,l.fromLocalJSDate(e,this.getProperty("primaryCalendarType")),true);return this};m.prototype._getLocale=function(){var t=this.getParent();if(t&&t.getLocale){return t.getLocale()}else if(!this._sLocale){this._sLocale=new p(e.getLanguageTag()).toString()}return this._sLocale};m.prototype._getLocaleData=function(){var e=this.getParent();if(e&&e._getLocaleData){return e._getLocaleData()}else if(!this._oLocaleData){var t=this._getLocale();var a=new p(t);this._oLocaleData=o.getInstance(a)}return this._oLocaleData};m.prototype._getFormatLong=function(){var e=this._getLocale();if(this._oFormatLong.oLocale.toString()!=e){var t=new p(e);this._oFormatLong=g.getInstance({style:"long",calendarType:this.getProperty("primaryCalendarType")},t)}return this._oFormatLong};m.prototype.getIntervalSelection=function(){var e=this.getParent();if(e&&e.getIntervalSelection){return e.getIntervalSelection()}else{return this.getProperty("intervalSelection")}};m.prototype.getSingleSelection=function(){var e=this.getParent();if(e&&e.getSingleSelection){return e.getSingleSelection()}else{return this.getProperty("singleSelection")}};m.prototype.getSelectedDates=function(){var e=this.getParent();if(e&&e.getSelectedDates){return e.getSelectedDates()}else{return this.getAggregation("selectedDates",[])}};m.prototype.getSpecialDates=function(){var e=this.getParent();if(e&&e.getSpecialDates){return e.getSpecialDates()}else{return this.getAggregation("specialDates",[])}};m.prototype._getShowHeader=function(){var e=this.getParent();if(e&&e._getShowItemHeader){return e._getShowItemHeader()}else{return this.getProperty("showHeader")}};m.prototype.getAriaLabelledBy=function(){var e=this.getParent();if(e&&e.getAriaLabelledBy){return e.getAriaLabelledBy()}else{return this.getAssociation("ariaLabelledBy",[])}};m.prototype._setLegendControlOrigin=function(e){this._oLegendControlOrigin=e};m.prototype.getLegend=function(){var e=this.getParent();if(this._oLegendControlOrigin){return this._oLegendControlOrigin.getLegend()}if(e&&e.getLegend){return e.getLegend()}else{return this.getAssociation("legend")}};m.prototype._setAriaRole=function(e){this._ariaRole=e;return this};m.prototype._getAriaRole=function(){return this._ariaRole?this._ariaRole:"gridcell"};m.prototype._getMonthDescription=function(){return this._fnInvisibleHintFactory().getId()};m.prototype._fnInvisibleHintFactory=function(){if(!this._invisibleDayHint){this._invisibleDayHint=new y({text:r.getResourceBundleFor("sap.m").getText("SLIDETILE_ACTIVATE")}).toStatic()}return this._invisibleDayHint};m.prototype._checkDateSelected=function(e){var t,a,i,r,o=0,n=0,h=0,g=this.getProperty("primaryCalendarType"),p,c,u;s._checkCalendarDate(e);c=this.getSelectedDates();u=new l(e);u.setDate(1);r=u.toUTCJSDate().getTime();for(p=0;p<c.length;p++){t=c[p];a=t.getStartDate();o=0;if(a){a=l.fromLocalJSDate(a,g);a.setDate(1);o=a.toUTCJSDate().getTime()}i=t.getEndDate();n=0;if(i){i=l.fromLocalJSDate(i,g);i.setDate(1);n=i.toUTCJSDate().getTime()}if(r==o&&!i){h=1;break}else if(r==o&&i){h=2;if(i&&r==n){h=5}break}else if(i&&r==n){h=3;break}else if(i&&r>o&&r<n){h=4;break}if(this.getSingleSelection()){break}}return h};m.prototype._getDateType=function(e){s._checkCalendarDate(e);var t,a,i,r,o=0,n,h=0,g,p=this.getSpecialDates(),c=new l(e),u=this.getProperty("primaryCalendarType");c.setDate(1);g=c.toUTCJSDate().getTime();for(i=0;i<p.length;i++){a=p[i];r=a.getStartDate();o=0;if(r){r=l.fromLocalJSDate(r,u);r.setDate(1);o=r.toUTCJSDate().getTime()}n=a.getEndDate();h=0;if(n){n=l.fromLocalJSDate(n,u);n.setDate(s._daysInMonth(n));h=n.toUTCJSDate().getTime()}if(g==o&&!n||g>=o&&g<=h){t={type:a.getType(),tooltip:a.getTooltip_AsString()};break}}return t};m.prototype._checkMonthEnabled=function(e){s._checkCalendarDate(e);var t=this.getParent();if(t&&t._oMinDate&&t._oMaxDate){if(s._isOutside(e,t._oMinDate,t._oMaxDate)){return false}}return true};m.prototype._handleMouseMove=function(e){if(!this.$().is(":visible")){w.call(this,true)}var t=jQuery(e.target);if(t.hasClass("sapUiCalItemText")){t=t.parent()}if(t.hasClass("sapUiCalItem")){var a=this._getDate();var i=l.fromLocalJSDate(this._oFormatYyyymm.parse(t.attr("data-sap-month"),this.getProperty("primaryCalendarType")));i.setDate(1);if(!i.isSame(a)){this.setDate(i.toLocalJSDate());I.call(this,i,true);this._bMoveChange=true}}};m.prototype.onmouseup=function(e){if(this._bMouseMove){w.call(this,true);var t=this._getDate();var a=this._oItemNavigation.getItemDomRefs();for(var i=0;i<a.length;i++){var r=jQuery(a[i]);if(r.attr("data-sap-month")==this._oFormatYyyymm.format(t.toUTCJSDate(),true)){r.trigger("focus");break}}if(this._bMoveChange){var o=jQuery(e.target);if(o.hasClass("sapUiCalItemText")){o=o.parent()}if(o.hasClass("sapUiCalItem")){t=l.fromLocalJSDate(this._oFormatYyyymm.parse(o.attr("data-sap-month")));t.setDate(1)}I.call(this,t);this._bMoveChange=false;this._bMousedownChange=false;L.call(this)}}if(this._bMousedownChange){this._bMousedownChange=false;L.call(this)}};m.prototype.onsapselect=function(e){var t=I.call(this,this._getDate());if(t){L.call(this)}e.stopPropagation();e.preventDefault()};m.prototype.onsapselectmodifiers=function(e){this.onsapselect(e)};m.prototype.onsappageupmodifiers=function(e){var t=new l(this._getDate());var a=t.getYear();if(e.metaKey||e.ctrlKey){t.setYear(a-10)}else{var i=this.getMonths();if(i<=12){t.setYear(a-1)}else{t.setMonth(t.getMonth()-i)}}this.fireFocus({date:t.toLocalJSDate(),notVisible:true});e.preventDefault()};m.prototype.onsappagedownmodifiers=function(e){var t=new l(this._getDate());var a=t.getYear();if(e.metaKey||e.ctrlKey){t.setYear(a+10)}else{var i=this.getMonths();if(i<=12){t.setYear(a+1)}else{t.setMonth(t.getMonth()+i)}}this.fireFocus({date:t.toLocalJSDate(),notVisible:true});e.preventDefault()};m.prototype.onThemeChanged=function(){if(this._bNoThemeChange){return}this._bNamesLengthChecked=undefined;this._bLongWeekDays=undefined;var e=this._getLocaleData();var t=e.getMonthsStandAlone("wide",this.getProperty("primaryCalendarType"));var a=this.$("months").children();var i=this._getStartDate().getMonth();for(var r=0;r<a.length;r++){var o=jQuery(jQuery(a[r]).children(".sapUiCalItemText"));o.text(t[(r+i)%12])}T.call(this)};m.prototype.checkDateFocusable=function(e){s._checkJSDateObject(e);if(this._bNoRangeCheck){return false}var t=this._getStartDate();var a=new l(t);a.setDate(1);a.setMonth(a.getMonth()+this.getMonths());var i=l.fromLocalJSDate(e,this.getProperty("primaryCalendarType"));return i.isSameOrAfter(t)&&i.isBefore(a)};m.prototype.applyFocusInfo=function(e){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex());return this};function D(){var e=this._getDate();var t=this._oFormatYyyymm.format(e.toUTCJSDate(),true);var a=0;var i=this.$("months").get(0);var r=this.$("months").children(".sapUiCalItem");for(var o=0;o<r.length;o++){var s=jQuery(r[o]);if(s.attr("data-sap-month")===t){a=o;break}}if(!this._oItemNavigation){this._oItemNavigation=new n;this._oItemNavigation.attachEvent(n.Events.AfterFocus,v,this);this._oItemNavigation.attachEvent(n.Events.FocusAgain,_,this);this._oItemNavigation.attachEvent(n.Events.BorderReached,S,this);this.addDelegate(this._oItemNavigation);this._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"],saphome:["alt"],sapend:["alt"]});this._oItemNavigation.setCycling(false);this._oItemNavigation.setColumns(1,true)}this._oItemNavigation.setRootDomRef(i);this._oItemNavigation.setItemDomRefs(r);this._oItemNavigation.setFocusedIndex(a);this._oItemNavigation.setPageSize(r.length)}function v(e){var t=e.getParameter("index");var a=e.getParameter("event");if(!a){return}var i=this._getDate();var r=new l(i);var o=this._oItemNavigation.getItemDomRefs();var n=jQuery(o[t]);r=l.fromLocalJSDate(this._oFormatYyyymm.parse(n.attr("data-sap-month")));r.setDate(1);this.setDate(r.toLocalJSDate());this.fireFocus({date:r.toLocalJSDate(),notVisible:false});if(a.type=="mousedown"){b.call(this,a,r,t)}}function _(e){var t=e.getParameter("index");var a=e.getParameter("event");if(!a){return}if(a.type=="mousedown"){var i=this._getDate();b.call(this,a,i,t)}}function S(e){var t=e.getParameter("event");var a=this.getMonths();var i=this._getDate();var r=new l(i);if(t.type){switch(t.type){case"sapnext":case"sapnextmodifiers":r.setMonth(r.getMonth()+1);break;case"sapprevious":case"sappreviousmodifiers":r.setMonth(r.getMonth()-1);break;case"sappagedown":r.setMonth(r.getMonth()+a);break;case"sappageup":r.setMonth(r.getMonth()-a);break;default:break}this.fireFocus({date:r.toLocalJSDate(),notVisible:true})}}function b(e,t,a){if(e.button){return}var i=I.call(this,t);if(i){this._bMousedownChange=true}if(this._bMouseMove){w.call(this,true);this._bMoveChange=false}else if(i&&this.getIntervalSelection()&&this.$().is(":visible")){P.call(this,true)}e.preventDefault();e.setMark("cancelAutoClose")}function C(e,t){s._checkCalendarDate(e);var a=e.getYear();s._checkYearInValidRange(a);var i=true;if(!this.getDate()||!e.isSame(l.fromLocalJSDate(this.getDate(),this.getProperty("primaryCalendarType")))){var r=new l(e);r.setDate(1);i=this.checkDateFocusable(e.toLocalJSDate());if(!this._bNoRangeCheck&&!i){throw new Error("Date must be in visible date range; "+this)}this.setProperty("date",e.toLocalJSDate());this._oDate=r}if(this.getDomRef()){if(i){M.call(this,this._oDate,t)}}}function M(e,t){var a=this._oFormatYyyymm.format(e.toUTCJSDate(),true);var i=this._oItemNavigation.getItemDomRefs();var r;for(var o=0;o<i.length;o++){r=jQuery(i[o]);if(r.attr("data-sap-month")==a){if(document.activeElement!=i[o]){if(t){this._oItemNavigation.setFocusedIndex(o)}else{this._oItemNavigation.focusItem(o)}}break}}}function I(e,t){if(!this._checkMonthEnabled(e)){return false}var a=this.getSelectedDates();var i;var r=0;var o=this.getParent();var n=this;var s;if(o&&o.getSelectedDates){n=o}if(this.getSingleSelection()){if(a.length>0){i=a[0];s=i.getStartDate();if(s){s=l.fromLocalJSDate(s,this.getProperty("primaryCalendarType"));s.setDate(1)}}else{i=new f;n.addAggregation("selectedDates",i)}if(this.getIntervalSelection()&&(!i.getEndDate()||t)&&s){var h;if(e.isBefore(s)){h=s;s=e;if(!t){i.setProperty("startDate",s.toLocalJSDate());i.setProperty("endDate",h.toLocalJSDate())}}else if(e.isSameOrAfter(s)){h=e;if(!t){i.setProperty("endDate",h.toLocalJSDate())}}}else{i.setProperty("startDate",e.toLocalJSDate());i.setProperty("endDate",undefined)}}else{if(this.getIntervalSelection()){throw new Error("Calender don't support multiple interval selection")}else{var g=this._checkDateSelected(e);if(g>0){for(r=0;r<a.length;r++){s=a[r].getStartDate();if(s){s=l.fromLocalJSDate(s,this.getProperty("primaryCalendarType"));s.setDate(1);if(e.isSame(s)){n.removeAggregation("selectedDates",r);break}}}}else{i=new f({startDate:e.toLocalJSDate()});n.addAggregation("selectedDates",i)}}}return true}function L(){if(this._bMouseMove){w.call(this,true)}this.fireSelect()}function T(){if(!this._bNamesLengthChecked){var e=0;var t=this.$("months").children();var a=false;var i=this.getMonths();var r=Math.ceil(12/i);var o=0;var n=this._getLocaleData();var s=n.getMonthsStandAlone("wide",this.getProperty("primaryCalendarType"));var l;for(var h=0;h<r;h++){if(i<12){for(e=0;e<t.length;e++){l=jQuery(jQuery(t[e]).children(".sapUiCalItemText"));l.text(s[(e+o)%12])}o=o+i;if(o>11){o=11}}for(e=0;e<t.length;e++){var g=t[e];if(Math.abs(g.clientWidth-g.scrollWidth)>1){a=true;break}}if(a){break}}if(i<12){o=this._getStartDate().getMonth();for(e=0;e<t.length;e++){l=jQuery(jQuery(t[e]).children(".sapUiCalItemText"));l.text(s[(e+o)%12])}}if(a){this._bLongMonth=false;var p=n.getMonthsStandAlone("abbreviated",this.getProperty("primaryCalendarType"));o=this._getStartDate().getMonth();for(e=0;e<t.length;e++){l=jQuery(jQuery(t[e]).children(".sapUiCalItemText"));l.text(p[(e+o)%12])}}else{this._bLongMonth=true}this._bNamesLengthChecked=true}}function P(){jQuery(window.document).on("mousemove",this._mouseMoveProxy);this._bMouseMove=true}function w(){jQuery(window.document).off("mousemove",this._mouseMoveProxy);this._bMouseMove=undefined}return m});
//# sourceMappingURL=MonthsRow.js.map