/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Element","sap/ui/unified/calendar/CalendarUtils","sap/ui/core/date/UniversalDate","sap/ui/unified/CalendarLegendRenderer","sap/ui/core/date/UI5Date","sap/ui/unified/library","sap/base/Log"],function(e,t,a,r,i,s,n){"use strict";var l=s.CalendarDayType;var o={apiVersion:2};o.render=function(e,t){var a=t._getStartDate();var r=t.getTooltip_AsString();var i=t.getId();e.openStart("div",t);e.class("sapUiCalTimesRow");e.class("sapUiCalRow");if(r){e.attr("title",r)}e.accessibilityState(t,{role:"grid",readonly:"true",multiselectable:!t.getSingleSelection()||t.getIntervalSelection(),labelledby:t._getShowHeader()?{value:i+"-Head",append:true}:undefined});e.openEnd();if(t.getIntervalSelection()){e.openStart("span",i+"-Start");e.style("display","none");e.openEnd();e.text(t._rb.getText("CALENDAR_START_TIME"));e.close("span");e.openStart("span",i+"-End");e.style("display","none");e.openEnd();e.text(t._rb.getText("CALENDAR_END_TIME"));e.close("span")}this.renderRow(e,t,a);e.close("div")};o.renderRow=function(e,t,a){var r=t.getId();this.renderHeader(e,t,a);e.openStart("div",r+"-times");e.class("sapUiCalItems");e.attr("role","row");e.openEnd();this.renderTimes(e,t,a);e.close("div")};o.renderHeader=function(e,t,a){if(t._getShowHeader()){var r=t._getLocaleData();var i=t.getId();e.openStart("div",i+"-Head");e.openEnd();this.renderHeaderLine(e,t,r,a);e.close("div")}};o.renderHeaderLine=function(e,t,a,r){var i=t._getFormatDate();var s=t.getId();var n=t.getItems();var l=t._getIntervalStart(r);var o=t.getIntervalMinutes();var d="";var c=0;var p=[];var m=0;for(m=0;m<n;m++){c=i.format(l,true);if(p.length>0&&p[p.length-1].sDay==c){p[p.length-1].iItems++}else{p.push({sDay:c,iItems:1})}l.setUTCMinutes(l.getUTCMinutes()+o)}for(m=0;m<p.length;m++){var g=p[m];d=100/n*g.iItems+"%";e.openStart("div",s+"-Head"+m);e.class("sapUiCalHeadText");e.style("width",d);e.openEnd();e.text(g.sDay);e.close("div")}};o.renderTimes=function(e,t,a){var r=this.getHelper(t,a);var i=t.getItems();var s=100/i+"%";var n=t._getIntervalStart(a);var l="";var o="";for(var d=0;d<i;d++){if(r.oFormatTimeAmPm){o=r.oFormatTimeAmPm.format(n,true);if(l==o){o=""}else{l=o}}this.renderTime(e,t,n,r,s,o);n.setUTCMinutes(n.getUTCMinutes()+r.iMinutes)}};o.getHelper=function(a,r){var s={};s.sLocale=a._getLocale();s.oLocaleData=a._getLocaleData();s.oNow=t._createUniversalUTCDate(i.getInstance(),undefined,true);s.sCurrentTime=a._rb.getText("CALENDAR_CURRENT_TIME");s.sId=a.getId();s.oFormatLong=a._getFormatLong();s.oFormatTime=a._getFormatTime();s.oFormatTimeAmPm=a._oFormatTimeAmPm;s.iMinutes=a.getIntervalMinutes();var l=a.getLegend();if(l){var o=e.getElementById(l);if(o){if(!(o instanceof sap.ui.unified.CalendarLegend)){throw new Error(o+" is not an sap.ui.unified.CalendarLegend. "+a)}s.oLegend=o}else{n.warning("CalendarLegend "+l+" does not exist!",a)}}return s};o.renderTime=function(e,t,i,s,n,o){var d=t._getAriaRole();var c={role:d,selected:d!=="gridcell"?null:false,label:"",describedby:t._getTimeDescription()};var p=t._oFormatYyyyMMddHHmm.format(i.getJSDate(),true);var m=t._checkDateSelected(i);var g=t._getDateType(i);var u=t._checkTimeEnabled(i);e.openStart("div",s.sId+"-"+p);e.class("sapUiCalItem");if(n){e.style("width",n)}var v=new a(i.getTime());v.setUTCMinutes(v.getUTCMinutes()+s.iMinutes);if(i.getTime()<=s.oNow.getTime()&&v.getTime()>s.oNow.getTime()){e.class("sapUiCalItemNow");c["label"]=s.sCurrentTime+" "}if(m>0){e.class("sapUiCalItemSel");if(d==="gridcell"){c["selected"]=true}}if(m==2){e.class("sapUiCalItemSelStart");c["describedby"]=c["describedby"]+" "+s.sId+"-Start"}else if(m==3){e.class("sapUiCalItemSelEnd");c["describedby"]=c["describedby"]+" "+s.sId+"-End"}else if(m==4){e.class("sapUiCalItemSelBetween")}else if(m==5){e.class("sapUiCalItemSelStart");e.class("sapUiCalItemSelEnd");c["describedby"]=c["describedby"]+" "+s.sId+"-Start";c["describedby"]=c["describedby"]+" "+s.sId+"-End"}if(g&&g.type!=l.None){e.class("sapUiCalItem"+g.type);if(g.tooltip){e.attr("title",g.tooltip)}}if(!u){e.class("sapUiCalItemDsbl");c["disabled"]=true}e.attr("tabindex","-1");e.attr("data-sap-time",p);c["label"]=c["label"]+s.oFormatLong.format(i,true);if(g&&g.type!=l.None){r.addCalendarTypeAccInfo(c,g.type,s.oLegend)}e.accessibilityState(null,c);e.openEnd();if(g&&g.type!=l.None){e.openStart("div");e.class("sapUiCalSpecialDate");if(g.color){e.style("background-color",g.color)}e.openEnd();e.close("div")}e.openStart("span");e.class("sapUiCalItemText");e.openEnd();e.text(s.oFormatTime.format(i,true));if(o){e.openStart("span");e.class("sapUiCalItemTextAmPm");e.openEnd();e.text(o);e.close("span")}e.close("span");e.close("div")};return o},true);
//# sourceMappingURL=TimesRowRenderer.js.map