/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/i18n/Formatting","sap/base/i18n/date/CalendarType","sap/ui/core/Control","sap/ui/Device","sap/ui/core/delegate/ItemNavigation","sap/ui/unified/calendar/CalendarUtils","sap/ui/unified/calendar/CalendarDate","sap/ui/unified/DateRange","sap/ui/unified/library","sap/ui/core/format/DateFormat","sap/ui/core/library","sap/ui/core/Locale","sap/ui/core/LocaleData","sap/ui/core/date/UI5Date","./YearPickerRenderer","sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery"],function(e,t,a,r,i,s,o,n,l,h,d,g,p,c,y,u,jQuery){"use strict";var m=a.extend("sap.ui.unified.calendar.YearPicker",{metadata:{library:"sap.ui.unified",properties:{year:{type:"int",group:"Data",defaultValue:2e3,deprecated:true},years:{type:"int",group:"Appearance",defaultValue:20},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},_singleSelection:{type:"boolean",group:"Behavior",defaultValue:true,visibility:"hidden"},_showSelectedRange:{type:"boolean",group:"Appearance",defaultValue:false,visibility:"hidden"},columns:{type:"int",group:"Appearance",defaultValue:4},date:{type:"object",group:"Data"},primaryCalendarType:{type:"sap.base.i18n.date.CalendarType",group:"Appearance"},secondaryCalendarType:{type:"sap.base.i18n.date.CalendarType",group:"Appearance"},_middleDate:{type:"object",group:"Data",visibility:"hidden"}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"}},events:{select:{},pageChange:{}}},renderer:y});m.prototype.init=function(){var e=c.getInstance();e.setFullYear(2e3);this.setProperty("date",e);this._oFormatYyyymmdd=h.getInstance({pattern:"yyyyMMdd",calendarType:t.Gregorian});this._oMinDate=s._minDate(this._getPrimaryCalendarType());this._oMaxDate=s._maxDate(this._getPrimaryCalendarType())};m.prototype.onBeforeRendering=function(){this._oYearFormat=h.getDateInstance({format:"y",calendarType:this._getPrimaryCalendarType()})};m.prototype.onAfterRendering=function(){_.call(this);this.focus()};m.prototype.exit=function(){if(this._aMPSelectedDates&&this._aMPSelectedDates.length){this._aMPSelectedDates.forEach(function(e){e.destroy()});this._aMPSelectedDates=undefined}};m.prototype.getFocusDomRef=function(){return this.getDomRef()&&this._oItemNavigation.getItemDomRefs()[this._iSelectedIndex]};m.prototype.setYear=function(e){this.setProperty("year",e);e=this.getProperty("year");var t=new o(e,0,1,this._getPrimaryCalendarType()),a=this._getSelectedDates()[0],r=this.getAggregation("selectedDates");if(!a||this.getIntervalSelection()){return this}if(!this._oSelectedDatesControlOrigin){if(!r||!r.length){this.addAggregation("selectedDates",a)}!this.getIntervalSelection()&&a.setStartDate(t.toLocalJSDate())}this.setDate(t.toLocalJSDate());return this};m.prototype.setDate=function(e){var t=s._maxDate(this.getProperty("primaryCalendarType")).getYear(),a,r,i,n;e&&s._checkJSDateObject(e);r=e.getFullYear();s._checkYearInValidRange(r);a=o.fromLocalJSDate(e,this._getPrimaryCalendarType());a.setMonth(0,1);this.setProperty("date",e);this.setProperty("year",a.getYear());this._oDate=a;i=this.getYears();n=Math.floor(i/2);if(e.getFullYear()<n){this._iSelectedIndex=e.getFullYear()-1}else if(e.getFullYear()>t-n){this._iSelectedIndex=t+i-e.getFullYear()-1}else{this._iSelectedIndex=n}this.setProperty("_middleDate",a);return this};m.prototype._getDate=function(){if(!this._oDate){var e=this.getDate().getFullYear();this._oDate=new o(e,0,1,this._getPrimaryCalendarType())}return this._oDate};m.prototype._getPrimaryCalendarType=function(){return this.getProperty("primaryCalendarType")||e.getCalendarType()};m.prototype._setSelectedDatesControlOrigin=function(e){this._oSelectedDatesControlOrigin=e};m.prototype.getSelectedDates=function(){if(this._oSelectedDatesControlOrigin){return this._oSelectedDatesControlOrigin.getSelectedDates()}return this.getAggregation("selectedDates")};m.prototype._getSelectedDates=function(){var e=this.getSelectedDates();if(e){return e}else if(!this._aMPSelectedDates||!this._aMPSelectedDates.length){this._aMPSelectedDates=[new n];this._aMPSelectedDates[0].setStartDate(this._getDate().toLocalJSDate());return this._aMPSelectedDates}else{return this._aMPSelectedDates}};m.prototype.setPrimaryCalendarType=function(e){this.setProperty("primaryCalendarType",e);this._oYearFormat=h.getDateInstance({format:"y",calendarType:e});if(this._oDate){this._oDate=new o(this._oDate,e);this._oDate.setMonth(0,1)}this._oMinDate=new o(this._oMinDate,e);this._oMaxDate=new o(this._oMaxDate,e);if(this._getSecondaryCalendarType()){this.setColumns(2);this.setYears(8)}return this};m.prototype.setIntervalSelection=function(e){this._setShowSelectedRange(e);return this.setProperty("intervalSelection",e)};m.prototype._setShowSelectedRange=function(e){return this.setProperty("_showSelectedRange",e)};m.prototype._getShowSelectedRange=function(){return this.getProperty("_showSelectedRange")};m.prototype.nextPage=function(){this._updatePage(true,this._oItemNavigation.getFocusedIndex());return this};m.prototype.previousPage=function(){this._updatePage(false,this._oItemNavigation.getFocusedIndex());return this};m.prototype.onsapspace=function(e){e.preventDefault()};m.prototype.onsapselect=function(e){var t=this._oItemNavigation.getFocusedIndex();var a=this._selectYear(t);if(a){this.fireSelect()}};m.prototype.onmouseover=function(e){var t=e.target,a=this._getSelectedDates()[0],r,i,s;if(!a){return}if(a.getStartDate()){r=o.fromLocalJSDate(a.getStartDate(),this._getPrimaryCalendarType());r.setMonth(0,1)}if(t.classList.contains("sapUiCalItem")){s=t.getAttribute("data-sap-year-start");i=o.fromLocalJSDate(this._oFormatYyyymmdd.parse(s),this._getPrimaryCalendarType());if(this._isSelectionInProgress()){this._markInterval(r,i)}}};m.prototype.onmousedown=function(e){this._oMousedownPosition={clientX:e.clientX,clientY:e.clientY}};m.prototype.onmouseup=function(e){var t=e.target,a=this._getSelectedDates()[0],i,s,n,l,h=this._oItemNavigation.getItemDomRefs();if(this._bMousedownChange){this._bMousedownChange=false;if(this.getIntervalSelection()&&t.classList.contains("sapUiCalItem")&&a){s=t.getAttribute("data-sap-year-start");l=o.fromLocalJSDate(this._oFormatYyyymmdd.parse(s),this._getPrimaryCalendarType());n=o.fromLocalJSDate(a.getStartDate(),this._getPrimaryCalendarType());n.setMonth(0,1);if(!l.isSame(n)&&!a.getEndDate()){i=h.index(t);this._selectYear.call(this,i);this._oItemNavigation.focusItem(i)}}this.fireSelect()}else if(r.support.touch&&this._isValueInThreshold(this._oMousedownPosition.clientX,e.clientX,10)&&this._isValueInThreshold(this._oMousedownPosition.clientY,e.clientY,10)){i=this._oItemNavigation.getFocusedIndex();if(!h[i].classList.contains("sapUiCalItemDsbl")){this._selectYear(i);this.fireSelect()}}};m.prototype._markInterval=function(e,t){var a=this._oItemNavigation.getItemDomRefs(),r,i,n;if(e.isAfter(t)){t=[e,e=t][0]}for(n=0;n<a.length;++n){i=a[n].getAttribute("data-sap-year-start");r=o.fromLocalJSDate(this._oFormatYyyymmdd.parse(i),this._getPrimaryCalendarType());if(this._bMousedownChange){if((r.isSame(e)||r.isSame(t))&&!s._isOutside(r,this._oMinDate,this._oMaxDate)){jQuery(a[n]).addClass("sapUiCalItemSel")}else{jQuery(a[n]).removeClass("sapUiCalItemSel")}}if(s._isBetween(r,e,t)&&s._isBetween(r,this._oMinDate,this._oMaxDate)){jQuery(a[n]).addClass("sapUiCalItemSelBetween")}else{jQuery(a[n]).removeClass("sapUiCalItemSelBetween")}}};m.prototype.getFirstRenderedDate=function(){var e;if(this.getDomRef()){var t=this._oItemNavigation.getItemDomRefs();e=this._oFormatYyyymmdd.parse(jQuery(t[0]).attr("data-sap-year-start"))}return e};m.prototype._isValueInThreshold=function(e,t,a){var r=e-a,i=e+a;return t>=r&&t<=i};m.prototype.setSecondaryCalendarType=function(e){this.setProperty("secondaryCalendarType",e);if(this._getSecondaryCalendarType()){this.setColumns(2);this.setYears(8)}return this};m.prototype._getSecondaryCalendarType=function(){var e=this.getSecondaryCalendarType();if(e===this._getPrimaryCalendarType()){return undefined}return e};m.prototype._getDisplayedSecondaryDates=function(e){var t=this.getSecondaryCalendarType(),a=new o(e,e.getCalendarType()),r=new o(e,e.getCalendarType());a.setMonth(0,1);a=new o(a,t);r.setYear(r.getYear()+1);r.setMonth(0,1);r.setDate(r.getDate()-1);r=new o(r,t);return{start:a,end:r}};m.prototype._getLocale=function(){var t=this._oSelectedDatesControlOrigin;if(t&&t._getLocale){return t._getLocale()}else if(!this._sLocale){this._sLocale=new g(e.getLanguageTag()).toString()}return this._sLocale};m.prototype._getLocaleData=function(){var e=this._oSelectedDatesControlOrigin;if(e&&e._getLocaleData){return e._getLocaleData()}else if(!this._oLocaleData){var t=this._getLocale();var a=new g(t);this._oLocaleData=p.getInstance(a)}return this._oLocaleData};m.prototype._checkFirstDate=function(e){var t=this.getYears(),a=new o(this._oMaxDate,this._getPrimaryCalendarType());if(!a.isSame(s._maxDate(this._getPrimaryCalendarType()))){return e}a.setYear(a.getYear()-t+1);if(e.isAfter(a)&&e.getYear()!=a.getYear()){e=new o(a,this._getPrimaryCalendarType());e.setMonth(0,1)}else if(e.isBefore(this._oMinDate)&&e.getYear()!=this._oMinDate.getYear()){e=new o(this._oMinDate,this._getPrimaryCalendarType());e.setMonth(0,1)}return e};m.prototype._checkDateEnabled=function(e){var t=true;if(e.isAfter(this._oMaxDate)&&e.getYear()!=this._oMaxDate.getYear()||e.isBefore(this._oMinDate)&&e.getYear()!=this._oMinDate.getYear()){t=false}return t};m.prototype._updatePage=function(e,t,a){var r=this._oItemNavigation.getItemDomRefs();var i=o.fromLocalJSDate(this._oFormatYyyymmdd.parse(jQuery(r[0]).attr("data-sap-year-start")),this._getPrimaryCalendarType());var s=this.getYears();if(e){var n=new o(this._oMaxDate,this._getPrimaryCalendarType());n.setYear(n.getYear()-s+1);if(i.isBefore(n)){i.setYear(i.getYear()+s);if(i.isAfter(n)){t=t+(i.getYear()-n.getYear());if(t>s-1){t=s-1}i=new o(this._oMaxDate,this._getPrimaryCalendarType());this._oDate.setMonth(0,1)}}else{return}}else{if(i.isAfter(this._oMinDate)){i.setYear(i.getYear()-s);if(i.isBefore(this._oMinDate)){t=t-(this._oMinDate.getYear()-i.getYear());if(t<0){t=0}i=new o(this._oMinDate,this._getPrimaryCalendarType())}}else{return}}i.setYear(i.getYear()+Math.floor(s/2));this._iSelectedIndex=t;this.setProperty("_middleDate",i);if(a){this.firePageChange()}};m.prototype._selectYear=function(e){var t=this._oItemNavigation.getItemDomRefs(),a=jQuery(t[e]),r=a.attr("data-sap-year-start"),i=o.fromLocalJSDate(this._oFormatYyyymmdd.parse(r),this._getPrimaryCalendarType()),s=this._getSelectedDates()[0],n=this.getAggregation("selectedDates"),l;if(a.hasClass("sapUiCalItemDsbl")){return false}if(!this._isSelectionInProgress()){var h=true}this.setProperty("year",i.getYear(),h);this.setProperty("date",i.toLocalJSDate(),h);if(!s){return true}if(!this._oSelectedDatesControlOrigin){if(!n||!n.length){this.addAggregation("selectedDates",s)}!this.getIntervalSelection()&&s.setStartDate(i.toLocalJSDate(),h)}if(this.getIntervalSelection()){if(!s.getStartDate()){s.setStartDate(i.toLocalJSDate(),h)}else if(!s.getEndDate()){l=o.fromLocalJSDate(s.getStartDate(),this._getPrimaryCalendarType());if(i.isBefore(l)){s.setEndDate(l.toLocalJSDate(),h);s.setStartDate(i.toLocalJSDate(),h)}else{s.setEndDate(i.toLocalJSDate(),h)}}else{s.setStartDate(i.toLocalJSDate(),h);s.setEndDate(undefined,h)}}if(h){for(var d=0;d<t.length;d++){a=jQuery(t[d]);r=a.attr("data-sap-year-start");var g=o.fromLocalJSDate(this._oFormatYyyymmdd.parse(r),this._getPrimaryCalendarType());var p=this._isYearSelected(g);var c=this._isYearInsideSelectionRange(g);if(p){a.addClass("sapUiCalItemSel");a.removeClass("sapUiCalItemSelBetween");a.attr("aria-selected","true")}if(c){a.addClass("sapUiCalItemSelBetween");a.attr("aria-selected","true")}if(!p&&!c){a.removeClass("sapUiCalItemSel");a.removeClass("sapUiCalItemSelBetween");a.attr("aria-selected","false")}}}return true};m.prototype._isSelectionInProgress=function(){const e=this._getShowSelectedRange();const t=this._getSelectedDates()[0];if(!t){return false}return e&&t.getStartDate()&&!t.getEndDate()};function _(){var e=this.getProperty("_middleDate")||(this.getDate()?o.fromLocalJSDate(this.getDate(),this._getPrimaryCalendarType()):this._getDate()),t=this.getDomRef(),a=this.$().find(".sapUiCalItem"),r,n,l,h;for(h=0;h<a.length;++h){n=a[h].getAttribute("data-sap-year-start");l=o.fromLocalJSDate(this._oFormatYyyymmdd.parse(n),this._getPrimaryCalendarType());if(l.isSame(e)){r=h;break}}if(!this._oItemNavigation){this._oItemNavigation=new i;this._oItemNavigation.attachEvent(i.Events.AfterFocus,f,this);this._oItemNavigation.attachEvent(i.Events.FocusAgain,D,this);this._oItemNavigation.attachEvent(i.Events.BorderReached,S,this);this.addDelegate(this._oItemNavigation);this._oItemNavigation.setHomeEndColumnMode(true,true);this._oItemNavigation.setDisabledModifiers({sapnext:["alt","meta"],sapprevious:["alt","meta"],saphome:["alt","meta"],sapend:["meta"]})}this._oItemNavigation.setRootDomRef(t);this._oItemNavigation.setItemDomRefs(a);this._oItemNavigation.setCycling(false);this._oItemNavigation.setColumns(this.getColumns(),true);if(s._isBetween(e,this._oMinDate,this._oMaxDate,true)){this._oItemNavigation.setFocusedIndex(r)}this._oItemNavigation.setPageSize(a.length)}function f(e){var t=e.getParameter("index"),a=e.getParameter("event"),r=this._oItemNavigation.aItemDomRefs[t],i=this._getSelectedDates()[0],s,n,l;if(!a){return}if(a.type==="mousedown"){this._handleMousedown(a,t)}else if(a.type==="sapnext"||a.type==="sapprevious"){if(!i){return}if(i.getStartDate()){s=o.fromLocalJSDate(i.getStartDate(),this._getPrimaryCalendarType());s.setMonth(0,1)}l=r.getAttribute("data-sap-year-start");n=o.fromLocalJSDate(this._oFormatYyyymmdd.parse(l),this._getPrimaryCalendarType());if(this._isSelectionInProgress()){this._markInterval(s,n)}}}function D(e){f.call(this,e)}m.prototype._handleMousedown=function(e,t){if(e.button||r.support.touch&&!r.system.combi){return}var a=this._selectYear(t);if(a){this._bMousedownChange=true}e.preventDefault();e.setMark("cancelAutoClose")};function S(e){var t=e.getParameter("event"),a=this._oItemNavigation.getFocusedIndex(),r=this.getYears(),i=this.getColumns(),s=this._getSelectedDates()[0],n=this._oItemNavigation.getItemDomRefs(),l,h,d;if(s&&s.getStartDate()){l=o.fromLocalJSDate(s.getStartDate(),this._getPrimaryCalendarType());l.setMonth(0,1)}if(t.type){if(i===0){i=r}switch(t.type){case"sapnext":case"sapnextmodifiers":if(t.keyCode===u.ARROW_DOWN&&i<r){d=n[a-r+i].getAttribute("data-sap-year-start");h=o.fromLocalJSDate(this._oFormatYyyymmdd.parse(d),this._getPrimaryCalendarType());this._updatePage(true,a-r+i,true);this._iSelectedIndex=a-r+i}else{d=n[0].getAttribute("data-sap-year-start");h=o.fromLocalJSDate(this._oFormatYyyymmdd.parse(d),this._getPrimaryCalendarType());this._updatePage(true,0,true)}break;case"sapprevious":case"sappreviousmodifiers":if(t.keyCode===u.ARROW_UP&&i<r){d=n[r-i+a].getAttribute("data-sap-year-start");h=o.fromLocalJSDate(this._oFormatYyyymmdd.parse(d),this._getPrimaryCalendarType());this._updatePage(false,r-i+a,true);this._iSelectedIndex=r-i+a}else{d=n[r-1].getAttribute("data-sap-year-start");h=o.fromLocalJSDate(this._oFormatYyyymmdd.parse(d),this._getPrimaryCalendarType());this._updatePage(false,r-1,true)}break;case"sappagedown":d=n[a].getAttribute("data-sap-year-start");h=o.fromLocalJSDate(this._oFormatYyyymmdd.parse(d),this._getPrimaryCalendarType());this._updatePage(true,a,true);break;case"sappageup":d=n[a].getAttribute("data-sap-year-start");h=o.fromLocalJSDate(this._oFormatYyyymmdd.parse(d),this._getPrimaryCalendarType());this._updatePage(false,a,true);break;default:break}}this._isSelectionInProgress()&&this._markInterval(l,h)}m.prototype._isYearSelected=function(e){const t=this.getSelectedDates();const a=this._getShowSelectedRange();if(!(t&&t.length)){return false}const r=t[0];const i=r.getStartDate();const s=r.getEndDate();if(a&&i&&s){const t=o.fromLocalJSDate(i,this._getPrimaryCalendarType());const a=o.fromLocalJSDate(s,this._getPrimaryCalendarType());return e.getYear()===t.getYear()||e.getYear()===a.getYear()}const n=t=>{const a=t.getStartDate();if(!a){return false}const r=o.fromLocalJSDate(a,this._getPrimaryCalendarType());return e.getYear()===r.getYear()};if(this.getProperty("_singleSelection")){return n(r)}return t.some(n)};m.prototype._isYearInsideSelectionRange=function(e){const t=this.getSelectedDates();const a=this._getShowSelectedRange();if(!(t&&t.length)){return false}const r=t[0];if(!r){return false}if(a){const t=r.getStartDate();const a=r.getEndDate();if(!t||!a){return false}const i=o.fromLocalJSDate(t,this._getPrimaryCalendarType());const n=o.fromLocalJSDate(a,this._getPrimaryCalendarType());i.setMonth(0,1);n.setMonth(0,1);return s._isBetween(e,i,n,true)}return false};return m});
//# sourceMappingURL=YearPicker.js.map