/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./YearPicker","./YearRangePickerRenderer","./CalendarDate","./CalendarUtils","sap/ui/thirdparty/jquery"],function(e,t,a,r,jQuery){"use strict";var s=e.extend("sap.ui.unified.calendar.YearRangePicker",{metadata:{library:"sap.ui.unified",properties:{years:{type:"int",group:"Appearance",defaultValue:9},columns:{type:"int",group:"Appearance",defaultValue:3},rangeSize:{type:"int",group:"Appearance",defaultValue:20}}},renderer:t});s.prototype.setDate=function(e){var t,s,i,n,o;e&&r._checkJSDateObject(e);s=e.getFullYear();r._checkYearInValidRange(s);t=a.fromLocalJSDate(e,this._getPrimaryCalendarType());t.setMonth(0,1);this.setProperty("date",e);this.setProperty("year",t.getYear());this._oDate=t;i=this.getYears();o=Math.floor(i/2);n=new a(this._oDate,this._getPrimaryCalendarType());n=this._checkFirstDate(n);this._iSelectedIndex=o;this.setProperty("_middleDate",n);return this};s.prototype._checkFirstDate=function(e){var t=this.getYears();var s=new a(this._oMaxDate,this._getPrimaryCalendarType());const i=t*this.getRangeSize();if(!s.isSame(r._maxDate(this._getPrimaryCalendarType()))){return e}if(this.getColumns()%2===0){s.setYear(s.getYear()-i/2+1)}else{Math.floor(t/2)*this.getRangeSize()+1-Math.floor(this.getRangeSize()/2)}if(e.isAfter(s)&&e.getYear()!=s.getYear()){e=new a(s,this._getPrimaryCalendarType());e.setMonth(0,1)}else if(e.isBefore(this._oMinDate)&&e.getYear()!=this._oMinDate.getYear()){e=new a(this._oMinDate,this._getPrimaryCalendarType());e.setMonth(0,1)}return e};s.prototype._updatePage=function(e,t,r){const s=this._oItemNavigation.getItemDomRefs();const i=a.fromLocalJSDate(this._oFormatYyyymmdd.parse(s[0].getAttribute("data-sap-year-start")),this._getPrimaryCalendarType());const n=this.getYears();const o=this.getRangeSize();const h=new a(i,this._getPrimaryCalendarType());const g=n*o;const l=this.getColumns()%2===0?g/2:Math.floor(n/2)*o+Math.floor(o/2);let y;if(e){const e=new a(this._oMaxDate,this._getPrimaryCalendarType());e.setYear(e.getYear()-g+1);if(i.isBefore(e)){h.setYear(i.getYear()+g);const t=new a(h,this._getPrimaryCalendarType());t.setYear(h.getYear()+g);if(t.isAfter(e)){h.setYear(e.getYear())}y=new a(h,this._getPrimaryCalendarType());y.setYear(h.getYear()+l)}else{return}}else{if(i.isAfter(this._oMinDate)){const e=new a(this._oMinDate,this._getPrimaryCalendarType());h.setYear(i.getYear()-g);if(h.isBefore(e)){h.setYear(e.getYear())}y=new a(h,this._getPrimaryCalendarType());y.setYear(h.getYear()+l)}else{return}}this._iSelectedIndex=t;this.setProperty("_middleDate",y);if(r){this.firePageChange()}};s.prototype._checkDateEnabled=function(e,t){if(r._isBetween(this._oMinDate,e,t,true)||r._isBetween(this._oMaxDate,e,t,true)||this._oMinDate.isBefore(e)&&this._oMaxDate.isAfter(t)){return true}return false};s.prototype._selectYear=function(e){var t=this._oItemNavigation.getItemDomRefs(),r=jQuery(t[e]),s=r.attr("data-sap-year-start"),i=a.fromLocalJSDate(this._oFormatYyyymmdd.parse(s),this._getPrimaryCalendarType());if(r.hasClass("sapUiCalItemDsbl")){return false}this.setProperty("date",i.toLocalJSDate());this.setProperty("year",i.getYear());return true};s.prototype._isYearSelected=function(e){const t=this.getSelectedDates();const s=this._getShowSelectedRange();if(!(t&&t.length)){return false}const i=new a(e,this.getPrimaryCalendarType());i.setYear(i.getYear()+this.getRangeSize()-1);i.setMonth(0,1);const n=t[0];const o=n.getStartDate();const h=n.getEndDate();if(s&&o&&h){const t=a.fromLocalJSDate(o,this._getPrimaryCalendarType());t.setMonth(0,1);const s=a.fromLocalJSDate(h,this._getPrimaryCalendarType());s.setMonth(0,1);return r._isBetween(t,e,i,true)||r._isBetween(s,e,i,true)}const g=t=>{const s=t.getStartDate();if(!s){return false}const n=a.fromLocalJSDate(s,this._getPrimaryCalendarType());s.setMonth(0,1);if(r._isBetween(n,e,i,true)){return true}return false};if(this.getProperty("_singleSelection")){return g(n)}return t.some(g)};s.prototype._getDisplayedSecondaryDates=function(e){var t=this.getSecondaryCalendarType(),r=new a(e,e.getCalendarType()),s=new a(e,e.getCalendarType());r.setMonth(0,1);r=new a(r,t);s.setYear(s.getYear()+this.getRangeSize());s.setMonth(0,1);s.setDate(s.getDate()-1);s=new a(s,t);return{start:r,end:s}};s.prototype.setSecondaryCalendarType=function(e){this.setProperty("secondaryCalendarType",e);if(this._getSecondaryCalendarType()){this.setColumns(2);this.setYears(8);this.setRangeSize(8)}return this};return s});
//# sourceMappingURL=YearRangePicker.js.map