/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","sap/ui/core/Control","sap/ui/core/ResizeHandler","./library","./DataSetSimpleViewRenderer","sap/base/Log","sap/ui/model/ChangeReason"],function(jQuery,e,t,i,s,n,r){"use strict";var o=e.extend("sap.ui.ux3.DataSetSimpleView",{metadata:{deprecated:true,interfaces:["sap.ui.ux3.DataSetView"],library:"sap.ui.ux3",properties:{floating:{type:"boolean",group:"Misc",defaultValue:true},name:{type:"string",group:"Misc",defaultValue:"Name of this View"},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconHovered:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconSelected:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},responsive:{type:"boolean",group:"Misc",defaultValue:false},itemMinWidth:{type:"int",group:"Misc",defaultValue:0},initialItemCount:{type:"int",group:"Appearance",defaultValue:0},reloadItemCount:{type:"int",group:"Appearance",defaultValue:0},scrollArea:{type:"any",group:"Appearance",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null}},aggregations:{template:{type:"sap.ui.core.Control",multiple:false}}}});o.prototype.init=function(){this._oDataSet=this.getParent();this.items=[];this._bRendered=false;if(this.getInitialItemCount()>0&&this.getReloadItemCount()<=0){this.setReloadItemCount(this.getInitialItemCount())}this._bUsePagination=false};o.prototype.exit=function(){if(this.sResizeListenerId){t.deregister(this.sResizeListenerId);this.sResizeListenerId=null}};o.prototype.handleSelection=function(e){var t=this.getParent();var i=t.getItems(),s=t.getSelectedIndices();if(s.length>1){this._clearTextSelection()}jQuery.each(i,function(e,i){if(t.isSelectedIndex(e)){i.$().addClass("sapUiUx3DSSVSelected")}else{i.$().removeClass("sapUiUx3DSSVSelected")}})};o.prototype._clearTextSelection=function(){if(window.getSelection){if(window.getSelection().empty){window.getSelection().empty()}else if(window.getSelection().removeAllRanges){window.getSelection().removeAllRanges()}}else if(document.selection&&document.selection.empty){try{document.selection.empty()}catch(e){}}};o.prototype.isItemSelected=function(e){var t=this.items.indexOf(e);if(t==-1){return false}return this.getParent().isSelectedIndex(t)};o.prototype.initView=function(e){this.getParent().attachSelectionChanged(this.handleSelection,this);this.items=this.items.concat(e);for(var t=0;t<e.length;t++){var i=this.getTemplate().clone();e[t].setAggregation("_template",i,true)}};o.prototype.updateView=function(e){var t;if(!this.getDomRef()){for(t=0;t<e.length;t++){if(e[t].type==="delete"){e[t].item.destroy()}}return}var i=sap.ui.getCore().createRenderManager(),s=this.items.length;for(t=0;t<e.length;t++){var n=e[t].item;var o=e[t].index;if(e[t].type==="insert"){var a=this.getTemplate().clone();n.setAggregation("_template",a,true);if(t==e.length-1&&s==0){var l={onAfterRendering:function(){this.calculateItemCounts();this.getParent().updateItems(r.Change);a.removeDelegate(l)}};a.addDelegate(l,false,this)}this.getRenderer().renderItem(i,this,n);i.flush(this.$()[0],false,o);this.items.splice(o,0,n)}else{this.items.splice(o,1);n.$().remove();n.destroy()}}if(e.length>0&&this.getFloating()&&this.getResponsive()){this._computeWidths(true)}i.destroy()};o.prototype.exitView=function(e){this.getParent().detachSelectionChanged(this.handleSelection,this);for(var t=0;t<e.length;t++){e[t].destroyAggregation("_template",true)}this.items=[]};o.prototype.initScrollArea=function(){var e=this.getScrollArea(),t=this;var i=function(e){t.getParent().updateItems(r.Change)};if(typeof e==="string"){e=jQuery(document.getElementById(e))}if(!e){e=this.$()}else if(e.is("html")){e=jQuery(document)}if(!this._bUsePagination){e.off("scroll",i)}else{e.on("scroll",i)}};o.prototype.checkScrollItems=function(){if(!this._bRendered){return}var e=this.getParent().mBindingInfos["items"],t=this.getScrollArea(),i=e.binding,s=this.getParent(),n=0,r,o,a,l;if(s.getItems().length===i.getLength()){return n}if(typeof t==="string"){t=jQuery(document.getElementById(t))}if(!t){t=this.$()}if(!t||t.length==0){return n}o=t[0];a=o.clientHeight;l=o.scrollHeight;if(t.is("html")){t=jQuery(document)}if(a==l){r=a+this._iScrollTrigger}else{r=a+this._iScrollTrigger+t.scrollTop()}if(r>0){var h=Math.floor(r/this._iRowHeight)*this._iItemsPerRow;var u=s.getItems().length;h=Math.ceil(h/this._iItemsPerRow)*this._iItemsPerRow;n=h-u}return n};o.prototype.getItemCount=function(){if(this._bUsePagination){var e=this.getParent().getItems().length,t=this.checkScrollItems();if(e==0){e+=this.getInitialItemCount()}else{e+=t}return e}else{return null}};o.prototype.setInitialItemCount=function(e){this.setProperty("initialItemCount",e);this._bUsePagination=e!=0;return this};o.prototype.onBeforeRendering=function(){if(this.sResizeListenerId){t.deregister(this.sResizeListenerId);this.sResizeListenerId=null}};o.prototype.onAfterRendering=function(){this._bRendered=true;this.initScrollArea();if(this.getFloating()&&this.getResponsive()||this._bUsePagination){this._height=-1;this._itemsPerRow=-1;this.onresize();this.sResizeListenerId=t.register(this.getDomRef(),jQuery.proxy(this.onresize,this))}};o.prototype.onThemeChanged=function(){if(this._bRendered){this.calculateItemCounts();this.getParent().updateItems(r.Change)}};o.prototype.onresize=function(){if(!this.getDomRef()){if(this.sResizeListenerId){t.deregister(this.sResizeListenerId);this.sResizeListenerId=null}return}if(this.getFloating()&&this.getResponsive()){this._computeWidths()}if(this._bUsePagination&&this.items.length>0){this.calculateItemCounts();this.getParent().updateItems(r.Change)}};o.prototype.setTemplate=function(e){this.setAggregation("template",e,true);if(this.getParent()){this.getParent().updateItems()}return this};o.prototype.calculateItemCounts=function(){if(this.getDomRef()&&sap.ui.getCore().isThemeApplied()){var e=this.$(),t=e.children().first();this._iItemsPerRow=Math.floor(e.outerWidth(true)/t.outerWidth(true));this._iNewRows=Math.ceil(this.getReloadItemCount()/this._iItemsPerRow);this._iNewItems=this._iItemsPerRow*this._iNewRows;this._iRowHeight=t.outerHeight(true);this._iScrollTrigger=this._iNewRows*this._iRowHeight}};o.prototype._computeWidths=function(e){var t=this.$();var i=Math.floor(t.width()/this.getItemMinWidth());var s=Math.floor(100/i);if(t.width()*s/100<this.getItemMinWidth()){i--;s=Math.floor(100/i)}if(e||this._height!=t.height()||this._itemsPerRow!=i){var n=-1;var r=this.getParent().getItems();var o,a;for(var l=0;l<r.length;l++){if(n==-1||n+1>i){n=0;o=100-i*s}var a=s;if(o>0){a++;o--}r[l].$().css("width",a+"%");n++}this._height=t.height();this._itemsPerRow=i}};o.prototype.setScrollArea=function(e,t){if(typeof e!=="string"&&!(e instanceof jQuery)){n.error("You can only pass a string (ID of scroll area DOM) or a jQuery object as scrollarea")}this.setProperty("scrollArea",e,t);return this};return o});
//# sourceMappingURL=DataSetSimpleView.js.map