/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","sap/ui/core/Control","sap/ui/core/delegate/ItemNavigation","sap/ui/core/theming/Parameters","./library","./NotificationBarRenderer","sap/ui/core/Message","sap/ui/core/library","sap/ui/Device","sap/base/Log"],function(jQuery,e,t,i,s,a,r,o,n,g){"use strict";var l=o.MessageType;var f=s.NotificationBarStatus;var h=e.extend("sap.ui.ux3.NotificationBar",{metadata:{deprecated:true,library:"sap.ui.ux3",properties:{visibleStatus:{type:"sap.ui.ux3.NotificationBarStatus",group:"Misc",defaultValue:f.Default},resizeEnabled:{type:"boolean",group:"Misc",defaultValue:true},alwaysShowToggler:{type:"boolean",defaultValue:false}},aggregations:{messageNotifier:{type:"sap.ui.core.Element",multiple:false},notifiers:{type:"sap.ui.core.Element",multiple:true,singularName:"notifier"}},events:{display:{parameters:{show:{type:"boolean"}}},resize:{parameters:{status:{type:"sap.ui.ux3.NotificationBarStatus"}}}}}});e.extend("sap.ui.ux3.NotificationBar.NotifierView",{renderMessages:function(e){e.write("<div");e.writeAttribute("id",this.getId()+"-content");e.addClass("sapUiNotifierContent");e.writeClasses();e.write(">");var t=this.getMessages();var i=t.length-1;var s=true;for(;i>=0;i--){if(!s||i==0&&t.length>1){e.write("<div");e.addClass("sapUiNotificationBarCltSep");e.writeClasses();e.write(">");e.write("</div>")}else{s=false}var a=t[i];if(a._message&&a._message.getReadOnly()){a.addStyleClass("sapUiNotifierMessageReadOnly")}e.renderControl(a)}e.write("</div>")},metadata:{library:"sap.ui.ux3",properties:{title:"string",visibleItems:"int",renderMode:{type:"string",defaultValue:"callout"}},aggregations:{messages:"sap.ui.ux3.NotificationBar.MessageView"}},init:function(){this._oResBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3")},exit:function(){if(this._renderedControl){delete this._renderedControl}delete this._oResBundle},getTitle:function(){var e=this.getProperty("title");var t=this.getMessages().length;if(t>0){var i="NOTIBAR_NOTIFIER_VIEW_TITLE";e=this._oResBundle.getText(i,[e,t])}return e},renderer:function(e,t){e.write("<div");e.addClass("sapUiNotifierContainer");e.writeControlData(t);e.writeClasses();e.write(">");e.write("<div");e.writeAttribute("id",t.getId()+"-title");e.addClass("sapUiNotifierTitle");e.writeClasses();e.write(">");e.writeEscaped(t.getTitle());e.write("</div>");if(t.getMessages().length>0){t.renderMessages(e)}e.write("</div>")},onAfterRendering:function(){var e=this.$("content"),t=e.children(".sapUiNotifierMessage"),i=t.length,s=this.getVisibleItems();if(i>s){setTimeout(this._fnAfterRenderingCallback.bind(this,t,e,s),0)}},_fnAfterRenderingCallback:function(e,t,i){var s=i-1,a=0;e.each(function(){if(a===i){t.css("max-height",s);return}s+=jQuery(this).outerHeight();a++})}});e.extend("sap.ui.ux3.NotificationBar.MessageView",{metadata:{library:"sap.ui.ux3",properties:{text:"string",timestamp:"string",icon:"sap.ui.core.URI"}},renderer:function(e,t){var i=t.getId();e.write("<div");e.writeControlData(t);e.addClass("sapUiNotifierMessage");e.writeClasses();e.writeAttribute("tabindex","0");e.write(">");if(t.getIcon()){e.write("<div");e.writeAttribute("id",i+"-icon");e.addClass("sapUiNotifierMessageIcon");e.writeClasses();e.write(">");e.write("<img");e.writeAttributeEscaped("src",t.getIcon());e.write(">");e.write("</div>")}e.write("<div");e.writeAttribute("id",i+"-text");e.addClass("sapUiNotifierMessageText");e.writeClasses();e.write(">");e.writeEscaped(t.getText());e.write("</div>");e.write("<div");e.writeAttribute("id",i+"-timestamp");e.addClass("sapUiNotifierMessageTimestamp");e.writeClasses();e.write(">");e.writeEscaped(t.getTimestamp());e.write("</div>");e.write("</div>")},onclick:function(e){if(!this._message.getReadOnly()){var t=this._message.getParent();t.fireMessageSelected({message:this._message,notifier:t})}},onsapselect:function(e){this.onclick(e)},exit:function(e){if(this._message){delete this._message}}});var u=function(e){var t=e.hasItems();var i=e.getVisibleStatus();if(t&&i==="None"){return true}else if(!t&&i!=="None"){return true}else if(!t&&i!=="Min"){return true}else{return false}};var d=function(e,t){var i=t.getMessages().concat([]);if(i.length>0){i.sort(r.compareByType);var s=i.length-1;e._sSeverestMessageLevel=i[s].getLevel()}};var c=function(e){var t=e.getParameter("callout");switch(e.getParameter("type")){case"added":case"removed":var i=e.getParameter("notifier");if(this.getMessageNotifier()&&this.getMessageNotifier().getId()===i.getId()){d(this,this.getMessageNotifier())}if(u(this)){var s=this.hasItems();this.fireDisplay({show:s})}else{this.invalidate();if(e.getParameter("type")==="removed"){if(t.getContent().length>0){var a=t.getContent()[0];var r=e.getParameter("message");var o=a.getMessages();var n;for(var g=0;g<o.length;g++){n=o[g];if(r.getId()===n._message.getId()){n.destroy();t.rerender();t.adjustPosition();break}}}}}break;case"openCallout":t.destroyContent();var i=e.getParameter("notifier");i.destroyAggregation("views",true);var l=i.getId();var f=this.getMessageNotifier();if(f&&l===f.getId()){l+="-messageNotifierView"}else{l+="-messageView"}var c=new h.NotifierView(l,{title:i.getTitle(),visibleItems:this._visibleItems});if(i._bEnableMessageSelect){c.addStyleClass("sapUiNotifierSelectable")}var p=i.getMessages();for(var g=0;g<p.length;g++){var m=v(p[g],i,this);c.addMessage(m)}i.addAggregation("views",c,true);t.addContent(c);break}};h.HOVER_ITEM_HEIGHT=16;h.prototype.init=function(){this._oItemNavigation=new t;this._oItemNavigation.setCycling(true);this.addDelegate(this._oItemNavigation);this._iCalloutWidth=parseInt(250);this._iCalloutHeight=parseInt(200);this._visibleItems=5;this._eventListener=jQuery.proxy(c,this);this._oResBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");this._togglerPosition="50%";this._gapMessageArea="5";this._sSeverestMessageLevel=l.None;jQuery(window).on("resize",jQuery.proxy(C,this));this._proxyEnableMessageSelect=jQuery.proxy(M,this);this.data("sap-ui-fastnavgroup","true",true);this.setAlwaysShowToggler(false)};h.prototype.exit=function(){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;delete this._iCalloutWidth;delete this._iCalloutHeight;delete this._visibleItems;delete this._eventListener;if(this.getMessageNotifier()){var e=this.getMessageNotifier();e._oMessageArea.destroy();delete e._oMessageArea}delete this._resizeFrom;delete this._resizeTo;delete this._oResBundle;delete this._formerVisibleStatus;delete this._togglerPosition;delete this._gapMessageArea;delete this._isHovered;delete this._togglerClicked;delete this._sSeverestMessageLevel;jQuery(window).off("resize",C);delete this._proxyEnableMessageSelect};var v=function(e,t,i){var s=new h.MessageView(t.getId()+"-messageView-"+e.getId(),{text:e.getText(),timestamp:e.getTimestamp()});s._message=e;if(t.sParentAggregationName=="messageNotifier"){if(i.getVisibleStatus()==f.Max){s.setIcon(e.getIcon()||e.getDefaultIcon("32x32"))}else{s.setIcon(e.getIcon()||e.getDefaultIcon())}}else{s.setIcon(e.getIcon())}return s};var p=function(e,t){t.attachEvent("_childControlCalling",e._eventListener,e)};var m=function(e,t){t.detachEvent("_childControlCalling",e._eventListener,e)};h.prototype.addNotifier=function(e){if(e){var t=this.getVisibleStatus()==f.None?true:false;this.addAggregation("notifiers",e,t);p(this,e)}return this};h.prototype.insertNotifier=function(e,t){if(e){this.insertAggregation("notifiers",e,t);p(this,e)}return this};h.prototype.removeNotifier=function(e){var t=this.removeAggregation("notifiers",e);m(this,t);return t};h.prototype.removeAllNotifiers=function(){var e=this.removeAllAggregation("notifiers");for(var t=0;t<e.length;t++){var i=e[t];m(this,i)}return e};h.prototype.destroyNotifiers=function(){var e=this.getNotifiers();for(var t=0;t<e.length;t++){var i=e[t];m(this,i)}this.destroyAggregation("notifiers");return this};var M=function(e){var t=this.getMessageNotifier();if(t&&t.getId()===e.getParameter("notifier").getId()){t.invalidate()}};h.prototype.setMessageNotifier=function(e){var t=this.getMessageNotifier();if(t){t._oMessageArea.destroy();delete t._oMessageArea;t.detachEvent("_enableMessageSelect",this._proxyEnableMessageSelect);m(this,t)}this.setAggregation("messageNotifier",e);if(e){e._oMessageArea=new h.MessageView(this.getId()+"-inplaceMessage");e._oMessageArea.setParent(e);e.attachEvent("_enableMessageSelect",this._proxyEnableMessageSelect);p(this,e)}return this};h.prototype.destroyMessageNotifier=function(e){var t=this.getMessageNotifier();if(t){t._oMessageArea.destroy();delete t._oMessageArea;t.detachEvent("_enableMessageSelect",this._proxyEnableMessageSelect);m(this,t)}this.destroyAggregation("messageNotifier");return this};var N=function(e,t){var i=e.$();switch(t){case f.Min:i.addClass("sapUiNotificationBarMinimized");break;case f.Max:var s=e.getHeightOfStatus(e.getVisibleStatus());i.addClass("sapUiNotificationBarMaximized");i.css("height",s);var a=e.$("containers");a.css("max-height",s);break;case f.None:if(!e._resizeTo){i.css("display","none")}break;case f.Default:default:i.removeClass("sapUiNotificationBarMaximized");i.removeClass("sapUiNotificationBarMinimized");break}};var _=function(e){if(S(e)){var t=e.getHeightOfStatus(e._resizeFrom);var i=e.$();i.css("height",t);var s=e.getHeightOfStatus(e._resizeTo);i.stop(true,true).animate({height:s},"fast",function(){var t=e.getVisibleStatus();if(t==="None"){i.css("display","none");if(e.hasItems()){if(e.getMessageNotifier()){var s=e.getMessageNotifier();s.$().css("display","none")}if(e.getNotifiers().length>0){var a=e.getNotifiers();for(var r=0;r<a.length;r++){a[r].$().css("display","none")}}}}N(e,t);x(e,t)})}else{var a=e.getVisibleStatus();N(e,a)}delete e._resizeFrom;delete e._resizeTo};var w=function(e){if(e.getMessageNotifier()&&e.getMessageNotifier().hasItems()){var t;var i=e.getId()+"-notifiers";var s=jQuery(document.getElementById(i));if(s.length>0){var a=parseInt(s.width());var r=s.children();for(var o=0;o<r.length;o++){var n=jQuery(r[o]);if(n.hasClass("sapUiNotifier")){a-=n.width()}else if(n.hasClass("sapUiNotifierSeparator")){a-=n.width()}else if(n.hasClass("sapUiInPlaceMessage")){t=n}}if(t){a-=e._gapMessageArea+2;t.css("width",a+"px")}}}};h.prototype.onAfterRendering=function(){this._oItemNavigation.setRootDomRef(this.getDomRef());var e=[];var t=this.getVisibleStatus()===f.Max;if(t){var i=this.getMessageNotifier();if(i!=null){var s=i.getMessages();var a=i.getId()+"-messageNotifierView-messageView-";for(var r=s.length-1;r>=0;r--){var o=document.getElementById(a+s[r].getId());if(o){e.push(o)}}}var g=this.getNotifiers();for(var r=0;r<g.length;r++){var s=g[r].getMessages();var a=g[r].getId()+"-notifierView-messageView-";for(var l=s.length-1;l>=0;l--){var o=document.getElementById(a+s[l].getId());if(o){e.push(o)}}}}else{var g=this.getNotifiers();for(var r=0;r<g.length;r++){var o=g[r].getDomRef();if(o){e.push(o)}}var i=this.getMessageNotifier();if(i!=null){var o=i.getDomRef();if(o){e.push(o)}o=this.getDomRef("inplaceMessage");if(o&&jQuery(o).hasClass("sapUiInPlaceMessageSelectable")){e.push(o)}}}this._oItemNavigation.setItemDomRefs(e);_(this);w(this);b(this,this.getMessageNotifier());y(this);if(n.browser.mobile){var h=this.$("toggler");if(this.getVisibleStatus()!==f.None){h.css("display","block")}else{h.css("display","none")}}};var b=function(e,t){if(t&&t.hasItems()){var i=t.$("counter");i.removeClass("sapUiMessageInformation");i.removeClass("sapUiMessageSuccess");i.removeClass("sapUiMessageWarning");i.removeClass("sapUiMessageError");d(e,t);var s=e._sSeverestMessageLevel;i.addClass("sapUiMessage"+s);var a=t.getMessages().length;var r="NOTIBAR_MESSAGE_NOTIFIER_DESC_LEVEL_"+s.toUpperCase()+(a===1?"_SING":"_PL");I(e,t,r,a)}};var y=function(e){var t=e.getNotifiers();for(var i=0;i<t.length;i++){var s=t[i].getMessages().length;var a="NOTIBAR_NOTIFIER_COUNT_TEXT_"+(s===1?"SING":"PL");I(e,t[i],a,s)}};var I=function(e,t,i,s){var a=t.$("description");var r=e._oResBundle.getText(i,[s]);a.html(r)};var C=function(e){w(this)};var S=function(e){if(e._resizeFrom&&e._resizeTo){if(e._resizeFrom!=e._resizeTo){return true}}return false};h.prototype.hasItems=function(){var e=this.getNotifiers();if(e.length>0){for(var t=0;t<e.length;t++){var i=e[t];if(i.hasItems()){return true}}}if(this.getMessageNotifier()){if(this.getMessageNotifier().hasItems()){return true}}return false};var x=function(e,t){var i="none";var s=e.$();switch(t){case f.Max:case f.None:break;case f.Min:s.stop().animate({height:e.getHeightOfStatus(t)},{duration:"fast",queue:true});s.addClass("sapUiNotificationBarMinimized");e.$("notifiers").css("display","none");i="block";break;case f.Default:default:s.stop().animate({height:e.getHeightOfStatus(t)},{duration:"fast",queue:true});s.removeClass("sapUiNotificationBarMaximized");s.removeClass("sapUiNotificationBarMinimized");break}var a=e.$("hoverItem");a.css("display",i)};h.prototype.onfocusin=function(e){if(this._togglerClicked){delete this._togglerClicked;e.stopImmediatePropagation(true)}};h.prototype.onclick=function(e){this._togglerClicked=true;this.$().trigger("blur");var t=jQuery(document.activeElement);V(this);var i=e.target.id;var s=i.split("-");if(s){var a=this.getVisibleStatus();var r=s.length-1;switch(s[r]){case"ArrowUp":if(a==="Min"){this.setVisibleStatus("Default")}else{this.setVisibleStatus("Max")}break;case"ArrowDown":if(a==="Max"){this.setVisibleStatus("Default")}else{this.setVisibleStatus("Min")}e.preventDefault();break;case"BarUp":if(this._formerVisibleStatus){this.setVisibleStatus(this._formerVisibleStatus)}else{this.setVisibleStatus("Default")}break;case"BarDown":this._formerVisibleStatus=a;this.setVisibleStatus("Min");t.trigger("blur");break;default:if(t.hasClass("sapUiNotifier")){t.trigger("focus")}else{if(this.hasItems()){var o=this.getNotifiers();if(o.length>0){var n=jQuery(o[0]);n.trigger("focus")}else{var g=this.getMessageNotifier();if(g){jQuery(g).trigger("focus")}}}}break}}};h.prototype.onThemeChanged=function(e){if(this.getDomRef()){this.invalidate()}};var V=function(e){var t=e.getNotifiers();for(var i=0;i<t.length;i++){var s=t[i];s._oCallout.close()}if(e.getMessageNotifier()){e.getMessageNotifier()._oCallout.close()}};h.prototype.getHeightOfStatus=function(e){if(e==f.None){return"0px"}var t=Object.assign({sapUiNotificationBarHeightMinimized:"0px",sapUiNotificationBarHeight:"40px",sapUiNotificationBarHeightMaximized:"40%"},i.get({name:["sapUiNotificationBarHeightMinimized","sapUiNotificationBarHeight","sapUiNotificationBarHeightMaximized"],callback:this.invalidate.bind(this)}));switch(e){case f.Min:return t["sapUiNotificationBarHeightMinimized"];case f.Max:return this.calculateStatusHeightMax(t["sapUiNotificationBarHeightMaximized"]);case f.Default:default:return t["sapUiNotificationBarHeight"]}};h.prototype.calculateStatusHeightMax=function(e){var t=e.indexOf("%");if(t!==-1){var i=parseInt(e),s=jQuery(window).height();s=parseInt(s/100*i);var a=parseInt(this.getHeightOfStatus(f.Default));if(s<a){s=a+1}}else{g.warning("No valid percantage value given for maximized size. 400px is used");s=400}return s+"px"};h.prototype.setVisibleStatus=function(e){this._resizeFrom=this.getVisibleStatus();this._resizeTo=e;if(this._resizeFrom!==this._resizeTo){if(e===f.None){V(this);if(this.getDomRef()){x(this,e)}else{this.$().css({height:"0px",display:"none"})}}this.setProperty("visibleStatus",e);this.fireResize({status:e})}return this};h.prototype.setAlwaysShowToggler=function(e){if(n.browser.mobile){e=true}this.setProperty("alwaysShowToggler",e,true);var t=this.$("toggler");if(e){t.css("display","block")}else{t.css("display","none")}return this};return h});
//# sourceMappingURL=NotificationBar.js.map