/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","sap/ui/commons/Menu","sap/ui/core/Control","sap/ui/core/theming/Parameters","./library","./ShellRenderer","./ShellPersonalization","./NavigationBar","sap/ui/core/delegate/ItemNavigation","sap/ui/core/RenderManager","sap/ui/core/Popup","./ToolPopup","sap/ui/commons/SearchField","sap/ui/commons/Label","./Feeder","sap/ui/commons/library","sap/ui/commons/Button","sap/ui/commons/MenuItem","./NotificationBar","sap/ui/base/Object","sap/ui/Device","sap/base/Log","sap/base/assert","sap/ui/core/Configuration","sap/ui/dom/jquery/Focusable"],function(jQuery,e,t,s,i,o,a,r,n,l,h,p,d,c,u,f,g,_,y,m,v,I,S,T){"use strict";var P=i.NotificationBarStatus;var B=i.FeederType;var x=h.Dock;var R=i.ShellDesignType;var O=i.ShellHeaderType;var H=t.extend("sap.ui.ux3.Shell",{metadata:{deprecated:true,library:"sap.ui.ux3",properties:{appTitle:{type:"string",group:"Misc",defaultValue:null},appIcon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},appIconTooltip:{type:"string",group:"Misc",defaultValue:null},showLogoutButton:{type:"boolean",group:"Misc",defaultValue:true},logoutButtonTooltip:{type:"string",group:"Accessibility",defaultValue:null},showSearchTool:{type:"boolean",group:"Misc",defaultValue:true},showInspectorTool:{type:"boolean",group:"Misc",defaultValue:false,deprecated:true},showFeederTool:{type:"boolean",group:"Misc",defaultValue:true},showTools:{type:"boolean",group:"Misc",defaultValue:true},showPane:{type:"boolean",group:"Misc",defaultValue:true},headerType:{type:"sap.ui.ux3.ShellHeaderType",group:"Misc",defaultValue:O.Standard},designType:{type:"sap.ui.ux3.ShellDesignType",group:"Misc",defaultValue:R.Standard},paneWidth:{type:"int",group:"Misc",defaultValue:250},applyContentPadding:{type:"boolean",group:"Appearance",defaultValue:true},fullHeightContent:{type:"boolean",group:"Appearance",defaultValue:false},allowOverlayHeaderAccess:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"content",aggregations:{worksetItems:{type:"sap.ui.ux3.NavigationItem",multiple:true,singularName:"worksetItem"},paneBarItems:{type:"sap.ui.core.Item",multiple:true,singularName:"paneBarItem"},paneContent:{type:"sap.ui.core.Control",multiple:true,singularName:"paneContent"},content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},toolPopups:{type:"sap.ui.ux3.ToolPopup",multiple:true,singularName:"toolPopup"},headerItems:{type:"sap.ui.core.Control",multiple:true,singularName:"headerItem"},notificationBar:{type:"sap.ui.ux3.NotificationBar",multiple:false},_paneOverflowMenu:{type:"sap.ui.commons.Menu",multiple:false,visibility:"hidden"}},associations:{selectedWorksetItem:{type:"sap.ui.ux3.NavigationItem",multiple:false}},events:{worksetItemSelected:{allowPreventDefault:true,parameters:{id:{type:"string"},item:{type:"sap.ui.ux3.NavigationItem"},key:{type:"string"}}},paneBarItemSelected:{parameters:{id:{type:"string"},item:{type:"sap.ui.core.Item"},key:{type:"string"}}},logout:{},search:{},feedSubmit:{},paneClosed:{parameters:{id:{type:"string"}}}}}});H.WSI_MENU_DELAY=200;H.WSI_OVERFLOW_SCROLL_STEP=250;H.TOOL_PREFIX="-tool-";H.FIRST_RENDERING=true;H.SIDE_BAR_BASE_WIDTH=null;H.PANE_OVERFLOW_BUTTON_HEIGHT=null;H.prototype.init=function(){this._iOpenPaneIndex=-1;this._sOpenWsiId=null;this._bPreviousScrollRight=false;this._bPreviousScrollLeft=false;this._sSelectedWorksetId=null;this._sSelectedFacetId=null;this._aSyncRefStack=[];this._mSyncRefs={};this._oWorksetBar=new r(this.getId()+"-wsBar",{toplevelVariant:true,select:[this._handleWorksetBarSelect,this]}).setParent(this);this._oFacetBar=new r(this.getId()+"-facetBar",{select:[this._handleFacetBarSelect,this]}).setParent(this);this.setAggregation("_paneOverflowMenu",new e);var t=this;this._checkResizeClosure=function(){t._checkResize()};this.currentToolPaletteWidth=0;this._updateThemeVariables()};H.prototype.exit=function(){if(this._oWorksetBar){this._oWorksetBar.destroy();delete this._oWorksetBar}if(this._oFacetBar){this._oFacetBar.destroy();delete this._oFacetBar}this._oSearchField=null;jQuery(window).off("resize",this._checkResizeClosure);clearTimeout(this._checkPaneBarOverflowDelayId);this._checkPaneBarOverflowDelayId=null};H.prototype.onBeforeRendering=function(){this._beforeRenderingToolPalette();this.$("focusDummyPane").off("focusin");if(window.FileReader){var e=this.$("hdr");e.off("dragover",this._handleDragover).off("dragend",this._handleDragend).off("drop",this._handleDrop);var t=this.$("bgImg");t.off("dragover",jQuery.proxy(this._handleDragover)).off("dragend",this._handleDragend).off("drop",this._handleDrop)}};H.prototype.onAfterRendering=function(){this._afterRenderingToolPalette();if(this._topSyncRefId&&this._mSyncRefs[this._topSyncRefId].focusLast){this.$("focusDummyPane").on("focusin",this._mSyncRefs[this._topSyncRefId].focusLast)}if(window.FileReader){var e=this.$("hdr");e.on("dragover",jQuery.proxy(this._handleDragover,this)).on("dragend",jQuery.proxy(this._handleDragend,this)).on("drop",jQuery.proxy(this._handleDrop,this));var t=this.$("bgImg");t.on("dragover",jQuery.proxy(this._handleDragover,this)).on("dragend",jQuery.proxy(this._handleDragend,this)).on("drop",jQuery.proxy(this._handleDrop,this))}var s=this._oFacetBar.getAssociatedItems().length>0;var i=this.$("facetBar");i.css("display",s?"block":"none");this._adaptContentHeight();this._bRtl=T.getRTL();if(this._getPersonalization().hasChanges()){this._getPersonalization().applySettings(this._getPersonalization().oSettings)}if(!this._oPaneItemNavigation){this._oPaneItemNavigation=(new n).setCycling(false);this.addDelegate(this._oPaneItemNavigation)}var o=this.$("paneBarEntries");this._updatePaneBarItemNavigation(o);this._setNotifyVisibility();if(H.FIRST_RENDERING){jQuery(window).on("resize",this._checkResizeClosure)}this._checkResize();H.FIRST_RENDERING=false;if(v.browser.firefox&&v.browser.version==17){setTimeout(this._checkResize.bind(this),500)}};H.prototype._updateThemeVariables=function(){var e=Object.assign({sapUiUx3ShellSideBarBaseWidth:"40px",sapUiUx3ShellPaneOverflowButtonHeight:"40px"},s.get({name:["sapUiUx3ShellSideBarBaseWidth","sapUiUx3ShellPaneOverflowButtonHeight"],callback:function(e){H.SIDE_BAR_BASE_WIDTH=parseInt(e["sapUiUx3ShellSideBarBaseWidth"]);H.PANE_OVERFLOW_BUTTON_HEIGHT=parseInt(e["sapUiUx3ShellPaneOverflowButtonHeight"])}}));H.SIDE_BAR_BASE_WIDTH=parseInt(e["sapUiUx3ShellSideBarBaseWidth"]);H.PANE_OVERFLOW_BUTTON_HEIGHT=parseInt(e["sapUiUx3ShellPaneOverflowButtonHeight"]);H.PANE_OVERFLOW_BUTTON_MAX_HEIGHT=H.PANE_OVERFLOW_BUTTON_HEIGHT};H.prototype._checkResize=function(){if(!this.getDomRef()){return}clearTimeout(this._checkResizeDelayId);this._checkResizeDelayId=setTimeout(function(){this._rerenderPaneBarItems();this._checkToolPaletteSize()}.bind(this),100)};H.prototype._checkToolPaletteSize=function(e){if(!this.getDomRef()){return}if(e===undefined){e=!this.getShowTools()}var t=this.$("tp");var s=1;var i=9999999;var o=0;var a=true;if(e){s=0;a=false}do{var r=s*H.SIDE_BAR_BASE_WIDTH;var n=Math.floor(r/2);var h=Math.floor(r/4);var p=this._bRtl?"right":"left";this.$("canvas").css(p,r+"px");this.$("canvasBackground").css(p,r+"px");this.$("wBar").css("margin-"+p,r+"px");var d={};d[p]=r+"px";this.$("notify").css(d);t.css("width",r+"px");var d={};d["width"]=n+"px";d["margin-"+p]=h+"px";this.$("tp-separator").css(d);if(!a){break}l.forceRepaint(t[0]);o=t.children().last()[0].offsetTop;if(o>=i){s--;a=false;continue}i=o;s++;if(s>10){I.error("The ToolPalette is growing too much, this must be a bug.");break}}while(o>t.height());this.currentToolPaletteWidth=this.getShowTools()?r:0;this._updateOverlaysOnToolPaletteChange()};H.prototype._updateOverlaysOnToolPaletteChange=function(){var e=this._getSyncRefs();if(this._bRtl){e.css("right",this.currentToolPaletteWidth+"px")}else{e.css("left",this.currentToolPaletteWidth+"px")}};H.prototype._updatePaneBarItemNavigation=function(e){this._oPaneItemNavigation.setRootDomRef(e[0]);var t=e.children().toArray();this._oPaneItemNavigation.setItemDomRefs(t);if(this._oPaneItemNavigation.getFocusedIndex()>t.length){this._oPaneItemNavigation.setFocusedIndex(-1)}this._checkPaneBarOverflow(e)};H.prototype._checkPaneBarOverflow=function(e){clearTimeout(this._checkPaneBarOverflowDelayId);this._checkPaneBarOverflowDelayId=setTimeout(function(){this._delayedCheckPaneBarOverflow(e)}.bind(this),200)};H.prototype._delayedCheckPaneBarOverflow=function(e){if(!e){e=this.$("paneBarEntries")}if(e.length==0){this._checkPaneBarOverflow();return}var t=e.parent().height()-(this._bRtl?e.innerHeight():0);var s=0;var i=e.children();i.css("display","inline-block");var o=false;var a=i.length;for(var r=a-1;r>=0;--r){var n=i[r];if(this._bRtl){s=0-n.offsetLeft}else{s=n.offsetLeft+n.offsetWidth}var h=s<t;jQuery(n).css("display",h?"inline-block":"none");var p=sap.ui.getCore().byId(n.id+"-overflow");p&&p.setVisible(!h);if(h){continue}else{o=true}}var d=this.$("paneBarOverflowButton");if(o){d.css("display","block")}else{d.css("display","none");if(v.browser.firefox&&v.browser.version==17){l.forceRepaint(document.getElementsByTagName("body")[0])}}var c=this._changeOverflowButton();if(c){this._checkPaneBarOverflow()}};H.prototype._adaptOverflowButtonHeight=function(){var e=this.$("paneBarOverflowButton");var t=this.$("paneBarOverflowWrapper");var s=this.$("paneBarOverflowText");var i=this.$("paneBarRight");s.css("width","");var o=H.PANE_OVERFLOW_BUTTON_HEIGHT;var a=s[0].scrollWidth+5;if(a>H.PANE_OVERFLOW_BUTTON_MAX_HEIGHT){H.PANE_OVERFLOW_BUTTON_HEIGHT=H.PANE_OVERFLOW_BUTTON_MAX_HEIGHT}else{H.PANE_OVERFLOW_BUTTON_HEIGHT=a}e.css("height",H.PANE_OVERFLOW_BUTTON_HEIGHT);t.css("width",H.PANE_OVERFLOW_BUTTON_HEIGHT);s.css("width","100%");i.css("padding-bottom",H.PANE_OVERFLOW_BUTTON_HEIGHT+"px");return o!=H.PANE_OVERFLOW_BUTTON_HEIGHT};H.prototype._changeOverflowButton=function(){var e=null;if(this._sOpenPaneId){e=sap.ui.getCore().byId(this._sOpenPaneId+"-overflow")}var t=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3").getText("SHELL_MORE_BUTTON");var s=false;if(e&&e.getVisible()){t=e.getText();s=true}t=t.toUpperCase();var i=this.$("paneBarOverflowText");i.text(t);i.attr("title",t);i.toggleClass("sapUiUx3ShellPaneEntrySelected",s);return this._adaptOverflowButtonHeight()};H.prototype._getPaneOverflowMenu=function(){return this.getAggregation("_paneOverflowMenu")};H.prototype.getFocusInfo=function(){try{var e=document.activeElement;return e?{sFocusId:e.id,oFocusedElement:e}:{}}catch(e){return{}}};H.prototype.applyFocusInfo=function(e){var t=(e.sFocusId?window.document.getElementById(e.sFocusId):null)||e.oFocusedElement;if(t){t.focus()}};H._updateToolIcon=function(e){if(e&&e.firstChild){var t=jQuery(e);var s=e.id.substr(e.id.indexOf(H.TOOL_PREFIX)+6);var i=sap.ui.getCore().byId(s);var o;if(t.is(".sapUiUx3ShellToolSelected")){o=i.getIconSelected()}else if(t.is(".sapUiUx3ShellToolHover")){o=i.getIconHover()}else{o=i.getIcon()}e.firstChild.src=o}};H.prototype.onclick=function(e){this.onUserActivation(e)};H.prototype.onsapspace=function(e){this.onUserActivation(e)};H.prototype.onsapenter=function(e){this.onUserActivation(e)};H.prototype.onUserActivation=function(e){var t=e.target.id;var s=e.target.parentNode;var i=this.getId();if(e.target.className&&e.target.className.indexOf&&e.target.className.indexOf("sapUiUx3ShellHeader-logout")>-1){this.fireLogout()}else if(s&&s.parentNode&&s.parentNode.className&&s.parentNode.className.indexOf&&s.parentNode.className.indexOf("sapUiUx3ShellToolPaletteArea")>-1){this._handleToolItemClick(t)}else if(s&&s.parentNode&&s.parentNode.parentNode&&s.parentNode.parentNode.className&&s.parentNode.parentNode.className.indexOf&&s.parentNode.parentNode.className.indexOf("sapUiUx3ShellToolPaletteArea")>-1){this._handleToolItemClick(s.id)}else if(t===i+"-paneBarOverflowText"){var o=this.$("paneBarOverflowButton")[0];this._getPaneOverflowMenu().open(true,o,(this._bRtl?"left":"right")+" bottom","center center",o)}else if(t){if(s&&s.className&&s.className.indexOf&&s.className.indexOf("sapUiUx3ShellPaneEntries")>-1){this._handlePaneBarItemClick(t)}}};H.prototype._handleWorksetBarSelect=function(e){var t=this._handleWorksetItemClick(e.getParameter("item"));if(!t){e.preventDefault()}};H.prototype._handleFacetBarSelect=function(e){var t=this._handleWorksetItemClick(e.getParameter("item"));if(!t){e.preventDefault()}};H.prototype._handleWorksetItemClick=function(e){var t=e.getParent(),s=e.getId(),i=s,o=true;if(t instanceof H){if(s!=this._sSelectedWorksetId){var a=e.getSubItems();if(a.length>0){i=a[0].getId()}o=this._fireWorksetItemSelected(i);if(o){this._sSelectedWorksetId=s;if(a.length>0){this._sSelectedFacetId=a[0].getId();s=this._sSelectedFacetId}else{this._sSelectedFacetId=null}var a=e.getSubItems();this._oFacetBar.setAssociatedItems(a,true);var r=this.$("facetBar");var n=this._calcFacetBarHeight(r);if(a.length>0){if(!this._oFacetBar.isSelectedItemValid()){this._oFacetBar.setSelectedItem(a[0]);this._sSelectedFacetId=a[0].getId()}r.slideDown();this._adaptContentHeight(null,true,n)}else{this._oFacetBar.setSelectedItem(null);r.slideUp();this._adaptContentHeight(null,true,n)}}}}else{if(s!=this._sSelectedFacetId){o=this._fireWorksetItemSelected(i);if(o){this._sSelectedFacetId=s}}}return o};H.prototype._fireWorksetItemSelected=function(e){var t=sap.ui.getCore().byId(e);var s=t?t.getKey():null;var i=this.fireWorksetItemSelected({id:e,item:t,key:s});if(i){this.setAssociation("selectedWorksetItem",e,true)}return i};H.prototype._closeCurrentToolPopup=function(){var e;if(this._oOpenToolPopup){e=this._oOpenToolPopup.getId();jQuery(document.getElementById(this.getId()+H.TOOL_PREFIX+this._oOpenToolPopup.getId())).removeClass("sapUiUx3ShellToolSelected").attr("aria-pressed","false");if(e===this.getId()+"-feederTool"){var t=sap.ui.getCore().byId(this.getId()+"-feeder");t.setText("");t.rerender()}this._oOpenToolPopup.close();this._oOpenToolPopup=null}return e};H.prototype._handleToolItemClick=function(e){var t=this._closeCurrentToolPopup();var s;var i=e.substr(e.indexOf(H.TOOL_PREFIX)+6);if(i==this.getId()+"-searchTool"){s=this._getSearchTool()}else if(i==this.getId()+"-feederTool"){s=this._getFeederTool()}else{s=sap.ui.getCore().byId(i)}if(s&&s.getId()!=t){this._oOpenToolPopup=s;s.setPosition(x.BeginTop,x.EndTop,document.getElementById(e),"13 -6","fit");s.open();jQuery(document.getElementById(e)).addClass("sapUiUx3ShellToolSelected").attr("aria-pressed","true");H._updateToolIcon(document.getElementById(e));var o=this;var a=function(t){s.detachClosed(a);if(o._oOpenToolPopup&&o._oOpenToolPopup.getId()===t.getParameter("id")){o._closeCurrentToolPopup()}jQuery(document.getElementById(e)).removeClass("sapUiUx3ShellToolSelected");H._updateToolIcon(document.getElementById(e))};s.attachClosed(a)}else if(s.getId()==t){H._updateToolIcon(document.getElementById(e))}};H.prototype._hasDarkDesign=function(){return this.getDesignType()!==R.Light&&this.getDesignType()!==R.Crystal};H.prototype._getSearchTool=function(){if(!this._oSearchPopup){var e=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");this._oSearchPopup=new p(this.getId()+"-searchTool",{tooltip:e.getText("SHELL_SEARCH")}).addStyleClass("sapUiUx3TP-search");var t=this._hasDarkDesign();this._oSearchPopup.setInverted(t);var s=this;var i=new d(this.getId()+"-searchField",{enableListSuggest:false,search:function(e){s.fireSearch({text:e.getParameter("query")})}});var o=new c({text:e.getText("SHELL_SEARCH_LABEL")+":"}).setLabelFor(i);this._oSearchPopup.addContent(o).addContent(i);this._oSearchPopup.attachOpen(function(){window.setTimeout(function(){i.focus()},100)});this._oSearchField=i}return this._oSearchPopup};H.prototype.getSearchField=function(){if(!this._oSearchField){this._getSearchTool()}return this._oSearchField};H.prototype._getFeederTool=function(){if(!this._oFeederPopup){var e=this;var t=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");this._oFeederPopup=new p(this.getId()+"-feederTool",{tooltip:t.getText("SHELL_FEEDER")}).addStyleClass("sapUiUx3TP-feeder");var s=this._hasDarkDesign();this._oFeederPopup.setInverted(s);var i=new u(this.getId()+"-feeder",{type:B.Medium,submit:function(t){e.fireFeedSubmit({text:t.getParameter("text")});i.setText("");i.rerender();e._oFeederPopup.close()}});this._oFeederPopup.setInitialFocus(this.getId()+"-feeder");this._oFeederPopup.attachClose(function(){i.setText("")});this._oFeederPopup.addContent(i)}return this._oFeederPopup};H.prototype.openPane=function(e){var t=this;S(typeof e==="string","sPaneId must be given as string");var s=sap.ui.getCore().byId(e);if(s&&e!=this._sOpenPaneId&&this.getShowPane()){var i;if(s){if(s.getKey()==""){i=null}else{i=s.getKey()}}else{i=null}this.firePaneBarItemSelected({id:e,item:s,key:i});var o=jQuery(document.getElementById(e));o.siblings().removeClass("sapUiUx3ShellPaneEntrySelected");o.addClass("sapUiUx3ShellPaneEntrySelected");if(!this._sOpenPaneId){this._openPane(function(){t.focusPaneStart()})}else{jQuery(document.getElementById(this.getId()+"-pb_"+this._sOpenPaneId)).removeClass("sapUiUx3ShellPaneEntrySelected")}this._sOpenPaneId=e}return this};H.prototype.closePane=function(){this._closePane();return this};H.prototype.isPaneOpen=function(){return this._sOpenPaneId!=null};H.prototype._handlePaneBarItemClick=function(e){if(e===this._sOpenPaneId){this.closePane()}else{this.openPane(e)}this._checkPaneBarOverflow()};H._SHELL_OFFSET_RIGHT=0;H.prototype._closePane=function(e){if(!this._sOpenPaneId){if(e){e()}return}var t=this._sOpenPaneId;var s=this;var i=this.getShowPane()?this.$("paneBarRight").outerWidth()+H._SHELL_OFFSET_RIGHT:H._SHELL_OFFSET_RIGHT;var o={};o[this._bRtl?"left":"right"]=i+"px";var a={};a[this._bRtl?"marginLeft":"marginRight"]=i-H._SHELL_OFFSET_RIGHT+"px";this.$("content").css("overflow-x","hidden");this.$("canvas").stop().animate(o);this.$("notify").stop().animate(o);this._getSyncRefs().stop(false,true).animate(o);this.$("wBar").stop().animate(a);this.$("paneBar").removeClass("sapUiUx3ShellPaneBarOpened").addClass("sapUiUx3ShellPaneBarClose");this.$("canvasBackground").removeClass("sapUiUx3ShellCanvasBackgroundOpen").addClass("sapUiUx3ShellCanvasBackgroundClosed").stop().animate(o,function(){s.$("paneBar").removeClass("sapUiUx3ShellPaneBarOpen");s.$("content").css("overflow-x","");if(e){e()}s.firePaneClosed({id:t})});jQuery(document.getElementById(this._sOpenPaneId)).removeClass("sapUiUx3ShellPaneEntrySelected");this._sOpenPaneId=null};H.prototype._openPane=function(e){var t=this;var s=this.getPaneWidth();var i=this.$("paneBarRight").outerWidth();this.$("content").css("overflow-x","hidden");if(this._bRtl){this.$("paneBar").removeClass("sapUiUx3ShellPaneBarClose").addClass("sapUiUx3ShellPaneBarOpen");this.$("wBar").stop().animate({marginLeft:s+i+"px"});this.$("canvas").stop().animate({left:s+i+H._SHELL_OFFSET_RIGHT+"px"});this.$("notify").stop().animate({left:s+i+H._SHELL_OFFSET_RIGHT+"px"});this._getSyncRefs().stop(false,true).animate({left:s+i+H._SHELL_OFFSET_RIGHT+"px"});this.$("canvasBackground").stop().animate({left:s+i+H._SHELL_OFFSET_RIGHT+"px"},function(){t.$("content").css("overflow-x","");t.$("canvasBackground").removeClass("sapUiUx3ShellCanvasBackgroundClosed").addClass("sapUiUx3ShellCanvasBackgroundOpen");t.$("paneBar").addClass("sapUiUx3ShellPaneBarOpened");if(e){e()}})}else{this.$("paneBar").removeClass("sapUiUx3ShellPaneBarClose").addClass("sapUiUx3ShellPaneBarOpen");this.$("wBar").stop().animate({marginRight:s+i+"px"});this.$("canvas").stop().animate({right:s+i+H._SHELL_OFFSET_RIGHT+"px"});this.$("notify").stop().animate({right:s+i+H._SHELL_OFFSET_RIGHT+"px"});this._getSyncRefs().stop(false,true).animate({right:s+i+H._SHELL_OFFSET_RIGHT+"px"});this.$("canvasBackground").stop().animate({right:s+i+H._SHELL_OFFSET_RIGHT+"px"},function(){t.$("content").css("overflow-x","");t.$("canvasBackground").removeClass("sapUiUx3ShellCanvasBackgroundClosed").addClass("sapUiUx3ShellCanvasBackgroundOpen");t.$("paneBar").addClass("sapUiUx3ShellPaneBarOpened");if(e){e()}})}};H.prototype.setPaneWidth=function(e){if(typeof e=="number"&&e>0){e=Math.max(e,50);if(this.getDomRef()){this.$("paneContent").css("width",e+"px");this.$("paneBar").css("width",e+H.SIDE_BAR_BASE_WIDTH+"px");if(this._sOpenPaneId){if(this._bRtl){this.$("wBar").css("marginLeft",e+H.SIDE_BAR_BASE_WIDTH+"px");this.$("canvas").css("left",e+H.SIDE_BAR_BASE_WIDTH+H._SHELL_OFFSET_RIGHT+"px");this.$("notify").css("left",e+H.SIDE_BAR_BASE_WIDTH+H._SHELL_OFFSET_RIGHT+"px");this._getSyncRefs().css("left",e+H.SIDE_BAR_BASE_WIDTH+H._SHELL_OFFSET_RIGHT+"px");this.$("canvasBackground").css("left",e+H.SIDE_BAR_BASE_WIDTH+H._SHELL_OFFSET_RIGHT+"px")}else{this.$("wBar").css("marginRight",e+H.SIDE_BAR_BASE_WIDTH+"px");this.$("canvas").css("right",e+H.SIDE_BAR_BASE_WIDTH+H._SHELL_OFFSET_RIGHT+"px");this.$("notify").css("right",e+H.SIDE_BAR_BASE_WIDTH+H._SHELL_OFFSET_RIGHT+"px");this._getSyncRefs().css("right",e+H.SIDE_BAR_BASE_WIDTH+H._SHELL_OFFSET_RIGHT+"px");this.$("canvasBackground").css("right",e+H.SIDE_BAR_BASE_WIDTH+H._SHELL_OFFSET_RIGHT+"px")}}}this.setProperty("paneWidth",e,true)}return this};H.prototype.setOffsetRight=function(e,t,s){if(e<0){e=0}if(e>600){e=600}H._SHELL_OFFSET_RIGHT=e;var i=e+"px";var o=this._bRtl?{left:i}:{right:i};this.$("hdr").stop().animate(o);this.$("hdrImg").stop().animate(o);this.$("bg").stop().animate(o,function(){if(t){t()}});this.$("bgImg").stop().animate(o);this.$("wBar").stop().animate(o);this.$("paneBar").stop().animate(o);jQuery(document.getElementById(s)).stop().animate({width:i});if(!this.$().hasClass("sapUiUx3ShellNoPane")){i=e+(this._sOpenPaneId?this.getPaneWidth():0)+H.SIDE_BAR_BASE_WIDTH+"px"}o=this._bRtl?{left:i}:{right:i};this.$("notify").stop().animate(o);this._getSyncRefs().stop(false,true).animate(o);this.$("canvas").stop().animate(o);this.$("canvasBackground").stop().animate(o)};H.prototype._refreshCanvasOffsetRight=function(e){var t=this._bRtl?"left":"right";var s=H._SHELL_OFFSET_RIGHT;if(e){var i=this.$("paneBarRight").outerWidth();s=s+(this._sOpenPaneId?this.getPaneWidth():0)+i}s=s+"px";this.$("notify").css(t,s);this.$("canvas").css(t,s);this.$("canvasBackground").css(t,s);this._getSyncRefs().css(t,s)};H.prototype._setNotifyVisibility=function(e){var t=this.getNotificationBar();if(!t){return}if(!e){e=t.getVisibleStatus()}var s=this.$("notify");var i=this._topSyncRefId?jQuery(document.getElementById(this._topSyncRefId)):jQuery(null);var o=i.hasClass("sapUiUx3TI");var a=0;var r=0;if(e===P.Min){a=10}else if(e===P.Max||e===P.Default){if(this.getHeaderType()===O.BrandOnly&&o){a=parseInt(t.getHeightOfStatus(P.Default))}else{a=10}r=a}s.removeClass("sapUiUx3ShellNotifyTI").removeClass("sapUiUx3ShellNotifyOverlay");if(this._topSyncRefId){this._getSyncRefs().animate({bottom:r+"px"},"fast");if(r>0){s.addClass(o?"sapUiUx3ShellNotifyTI":"sapUiUx3ShellNotifyOverlay")}}if(e===P.Min){s.css("height",a+"px").css("z-index",1)}else{s.css("height",a+"px").css("z-index",1e5)}if(a>0&&!this.$().hasClass("sapUiUx3ShellNotifyVisible")){this.$().addClass("sapUiUx3ShellNotifyVisible")}else if(a==0&&this.$().hasClass("sapUiUx3ShellNotifyVisible")){this.$().removeClass("sapUiUx3ShellNotifyVisible")}this._adaptContentHeight(e)};H.prototype.syncWithCanvasSize=function(e,t,s,i,o){var a=this._aSyncRefStack.indexOf(e);if(t){var r={id:e,focusFirst:s,focusLast:i,applyChanges:o};if(a<0){this._aSyncRefStack.push(e)}this._mSyncRefs[e]=r;r.applyChanges({showOverlay:this.getHeaderType()!==O.BrandOnly})}else{if(a>=0){delete this._mSyncRefs[e];this._aSyncRefStack.splice(a,1)}}this.$("canvas").removeAttr("aria-hidden");this.$("focusDummyTPStart").removeAttr("tabindex").off("focusin");this.$("focusDummyTPEnd").removeAttr("tabindex").off("focusin");this.$("focusDummyHdrStart").removeAttr("tabindex").off("focusin");this.$("focusDummyHdrEnd").removeAttr("tabindex").off("focusin");this.$("focusDummyPane").removeAttr("tabindex").off("focusin");this.$().toggleClass("sapUiUx3ShellBlockHeaderAccess",false);delete this._topSyncRefId;if(this._aSyncRefStack.length>0){var r=this._mSyncRefs[this._aSyncRefStack[this._aSyncRefStack.length-1]];var n=this._getSyncRefs();var l=this.getDomRef("canvas");n.css(this._bRtl?"right":"left",(this.getShowTools()?this.currentToolPaletteWidth:0)+"px");var h=H._SHELL_OFFSET_RIGHT;if(this.getShowPane()){h+=H.SIDE_BAR_BASE_WIDTH;if(this._sOpenPaneId){h+=this.getPaneWidth()}}n.css(this._bRtl?"left":"right",h+"px");n.css("top",this.getDomRef(this.getAllowOverlayHeaderAccess()?"hdr":"hdrLine").offsetHeight+"px");n.css("bottom","0");jQuery(l).attr("aria-hidden","true");this.$("focusDummyTPEnd").attr("tabindex","0").on("focusin",r.focusFirst);this.$("focusDummyHdrStart").attr("tabindex","0").on("focusin",jQuery.proxy(this.focusPaneEnd,this));this.$("focusDummyHdrEnd").attr("tabindex","0").on("focusin",jQuery.proxy(this.focusFirstTool,this));this.$("focusDummyTPStart").attr("tabindex","0").on("focusin",jQuery.proxy(this.focusLastHdr,this));this.$("focusDummyPane").attr("tabindex","0").on("focusin",r.focusLast);this.$().toggleClass("sapUiUx3ShellBlockHeaderAccess",!this.getAllowOverlayHeaderAccess());this._topSyncRefId=r.id}if(this._sUpdateNotificationZIndex){clearTimeout(this._sUpdateNotificationZIndex);delete this._sUpdateNotificationZIndex}this._sUpdateNotificationZIndex=setTimeout(function(){delete this._sUpdateNotificationZIndex;this._setNotifyVisibility();if(this._oOpenToolPopup&&this._topSyncRefId){var e=jQuery(document.getElementById(this._topSyncRefId));this._oOpenToolPopup.$().css("z-index",parseInt(e.css("z-index"))+1)}}.bind(this),0)};H.prototype._getSyncRefs=function(){var e=[];var t;for(var s=0;s<this._aSyncRefStack.length;s++){t=this._aSyncRefStack[s]?window.document.getElementById(this._aSyncRefStack[s]):null;if(t){e.push(t)}}return jQuery(e)};H.prototype.focusFirstHdr=function(){var e=this.$("hdr-items").firstFocusableDomRef();if(e&&this.getAllowOverlayHeaderAccess()&&this.getHeaderType()!=O.BrandOnly){if(e){e.focus()}}else{this.focusFirstTool()}};H.prototype.focusLastHdr=function(){var e=this.$("hdr-items").lastFocusableDomRef();if(e&&this.getAllowOverlayHeaderAccess()&&this.getHeaderType()!=O.BrandOnly){if(e){e.focus()}}else{this.focusPaneEnd()}};H.prototype.focusFirstTool=function(){var e=this.$("tp").find(".sapUiUx3ShellTool").first();if(e.length&&this.getShowTools()){e[0].focus()}else{this._mSyncRefs[this._topSyncRefId].focusFirst()}};H.prototype.focusLastTool=function(){var e=this.$("tp").find(".sapUiUx3ShellTool").last();if(e.length&&this.getShowTools()){e[0].focus()}else{this.focusPaneEnd()}};H.prototype.focusPaneStart=function(){var e=this.$("paneBar").firstFocusableDomRef();if(e){e.focus()}else{this.focusFirstTool()}};H.prototype.focusPaneEnd=function(){var e=this.$("paneBar").lastFocusableDomRef();if(e){e.focus()}else{this._mSyncRefs[this._topSyncRefId].focusLast()}};H.prototype.setAppTitle=function(e){this.setProperty("appTitle",e,true);this._rerenderHeader();return this};H.prototype.setAppIcon=function(e){this.setProperty("appIcon",e,true);this._rerenderHeader();return this};H.prototype.setShowLogoutButton=function(e){this.setProperty("showLogoutButton",e,true);this._rerenderHeader();return this};H.prototype.setLogoutButtonTooltip=function(e){this.setProperty("logoutButtonTooltip",e,true);this._rerenderHeader();return this};H.prototype.insertHeaderItem=function(e,t){if(m.isA(e,"sap.ui.commons.Button")){e.setStyled(false)}this.insertAggregation("headerItems",e,t,true);this._rerenderHeader();return this};H.prototype.addHeaderItem=function(e){if(m.isA(e,"sap.ui.commons.Button")){e.setStyled(false)}this.addAggregation("headerItems",e,true);this._rerenderHeader();return this};H.prototype.removeHeaderItem=function(e){var t=this.removeAggregation("headerItems",e,true);this._rerenderHeader();return t};H.prototype.removeAllHeaderItems=function(){var e=this.removeAllAggregation("headerItems",true);this._rerenderHeader();return e};H.prototype.destroyHeaderItems=function(){this.destroyAggregation("headerItems",true);this._rerenderHeader();return this};H.prototype.setShowSearchTool=function(e){this.setProperty("showSearchTool",e,true);this._rerenderToolPalette();return this};H.prototype.setShowFeederTool=function(e){this.setProperty("showFeederTool",e,true);this._rerenderToolPalette();return this};H.prototype.setHeaderType=function(e){var t=this.getHeaderType();this.setProperty("headerType",e,true);this.$().removeClass("sapUiUx3ShellHead"+t).addClass("sapUiUx3ShellHead"+this.getHeaderType());var s=this._getSyncRefs();if(s.length){s.css("top",this.getDomRef(this.getAllowOverlayHeaderAccess()?"hdr":"hdrLine").offsetHeight+"px")}var i={showOverlay:e!==O.BrandOnly};jQuery.each(this._mSyncRefs,function(e,t){t.applyChanges(i)});return this};H.prototype.setAllowOverlayHeaderAccess=function(e){this.setProperty("allowOverlayHeaderAccess",e,true);var t=this._getSyncRefs();if(t.length){this.$().toggleClass("sapUiUx3ShellBlockHeaderAccess",!this.getAllowOverlayHeaderAccess());t.css("top",this.getDomRef(this.getAllowOverlayHeaderAccess()?"hdr":"hdrLine").offsetHeight+"px")}return this};H.prototype.setDesignType=function(e){var t=this.getDesignType();this.setProperty("designType",e,true);var s=this._hasDarkDesign();if(this._oSearchPopup){this._oSearchPopup.setInverted(s)}if(this._oFeederPopup){this._oFeederPopup.setInverted(s)}var i=this.getToolPopups();for(var o=0;o<i.length;++o){i[o].setInverted(s)}this.$().removeClass("sapUiUx3ShellDesign"+t).addClass("sapUiUx3ShellDesign"+e).toggleClass("sapUiUx3ShellDesignLight",!s);return this};H.prototype.setShowTools=function(e){this.setProperty("showTools",e,true);if(e){this.$().removeClass("sapUiUx3ShellNoTools");this._checkResize()}else{this.$().addClass("sapUiUx3ShellNoTools");this._closeCurrentToolPopup();this.$("tp").attr("style","")}this._checkToolPaletteSize(true);return this};H.prototype.setShowPane=function(e){this.setProperty("showPane",e,true);if(e){this.$().removeClass("sapUiUx3ShellNoPane");this._refreshCanvasOffsetRight(true);this._checkPaneBarOverflow()}else{var t=this;this._closePane(function(){t._refreshCanvasOffsetRight(false);t.$().addClass("sapUiUx3ShellNoPane")})}return this};H.prototype.insertToolPopup=function(e,t){this.insertAggregation("toolPopups",e,t,true);e.attachIconChanged(this._rerenderToolPalette,this);this._rerenderToolPalette();return this};H.prototype.addToolPopup=function(e){var t=this._hasDarkDesign();e.setInverted(t);this.addAggregation("toolPopups",e,true);e.attachIconChanged(this._rerenderToolPalette,this);this._rerenderToolPalette();return this};H.prototype.removeToolPopup=function(e){var t=this.removeAggregation("toolPopups",e,true);if(t===this._oOpenToolPopup){this._closeCurrentToolPopup()}this._rerenderToolPalette();return t};H.prototype.removeAllToolPopups=function(){var e=this.removeAllAggregation("toolPopups",true);this._rerenderToolPalette();return e};H.prototype.destroyToolPopups=function(){this.destroyAggregation("toolPopups",true);this._rerenderToolPalette();return this};H.prototype.insertContent=function(e,t){this.insertAggregation("content",e,t,true);this._rerenderContent();return this};H.prototype.addContent=function(e){this.addAggregation("content",e,true);this._rerenderContent();return this};H.prototype.removeContent=function(e){var t=this.removeAggregation("content",e,true);this._rerenderContent();return t};H.prototype.removeAllContent=function(){var e=this.removeAllAggregation("content",true);this._rerenderContent();return e};H.prototype.destroyContent=function(){this.destroyAggregation("content",true);this._rerenderContent();return this};H.prototype.addPaneBarItem=function(e){this.addAggregation("paneBarItems",e,true);this._rerenderPaneBarItems();return this};H.prototype.insertPaneBarItem=function(e,t){this.insertAggregation("paneBarItems",e,t,true);this._rerenderPaneBarItems();return this};H.prototype.removePaneBarItem=function(e){var t=this.removeAggregation("paneBarItems",e,true);if(t){var s=sap.ui.getCore().byId(t.getId()+"-overflow");if(s){s.destroy()}}this._rerenderPaneBarItems();return t};H.prototype.removeAllPaneBarItems=function(){var e=this.removeAllAggregation("paneBarItems",true);this._getPaneOverflowMenu().destroyItems();this._rerenderPaneBarItems();return e};H.prototype.destroyPaneBarItems=function(){this.destroyAggregation("paneBarItems",true);this._getPaneOverflowMenu().destroyItems();this._rerenderPaneBarItems();return this};H.prototype.addWorksetItem=function(e){this.addAggregation("worksetItems",e,true);this._rerenderWorksetItems();return this};H.prototype.insertWorksetItem=function(e,t){this.insertAggregation("worksetItems",e,t,true);this._rerenderWorksetItems();return this};H.prototype.removeWorksetItem=function(e){var t=this.removeAggregation("worksetItems",e,true);this._rerenderWorksetItems();return t};H.prototype.removeAllWorksetItems=function(){var e=this.removeAllAggregation("worksetItems",true);this._rerenderWorksetItems();return e};H.prototype.destroyWorksetItems=function(){this.destroyAggregation("worksetItems",true);this._rerenderWorksetItems();return this};function E(e){var t=e.getNotificationBar();if(t){e._setNotifyVisibility(P.None);t.setVisibleStatus=t.__orig_setVisibleStatus;t.detachDisplay(t.__fHandleNotifyDisplay);delete t.__orig_setVisibleStatus;delete t.__fHandleNotifyDisplay}}H.prototype.setNotificationBar=function(e){E(this);if(e){var t=this;e.__orig_setVisibleStatus=e.setVisibleStatus;e.setVisibleStatus=function(e){this.__orig_setVisibleStatus.apply(this,arguments);t._setNotifyVisibility()}}this.setAggregation("notificationBar",e,true);this._rerenderNotificationArea();if(e){e.__fHandleNotifyDisplay=function(t){var s=t?t.getParameter("show"):e.hasItems();e.setVisibleStatus(s?P.Default:P.None)};e.attachDisplay(e.__fHandleNotifyDisplay);e.__fHandleNotifyDisplay()}return this};H.prototype.destroyNotificationBar=function(){E(this);this.destroyAggregation("notificationBar",true);this._rerenderNotificationArea();return this};H.prototype._rerenderNotificationArea=function(){var e=this.$("notify");if(e.length>0){var t=sap.ui.getCore().createRenderManager();o.renderNotificationArea(t,this);t.flush(e[0],true);t.destroy()}};H.prototype._rerenderHeader=function(){var e=this.$("hdr");if(e.length>0){var t=sap.ui.getCore().createRenderManager();o.renderHeader(t,this);t.flush(e[0],true);t.destroy()}};H.prototype._rerenderToolPalette=function(){var e=this.$("tp");if(e.length>0){var t=sap.ui.getCore().createRenderManager();this._beforeRenderingToolPalette();o.renderToolPalette(t,this);t.flush(e[0],true);this._afterRenderingToolPalette();t.destroy();this._checkResize()}};H.prototype._beforeRenderingToolPalette=function(){this.$("tp").find(".sapUiUx3ShellTool").off("mouseenter mouseleave");this.$("focusDummyTPEnd").off("focusin");this.$("focusDummyTPStart").off("focusin")};H.prototype._afterRenderingToolPalette=function(){var e=this.getId()+H.TOOL_PREFIX;var t=this.getToolPopups();var s=false;if(this._oOpenToolPopup&&this._oOpenToolPopup.isOpen()&&(this.indexOfToolPopup(this._oOpenToolPopup)>=0||this._oOpenToolPopup===this._oSearchPopup||this._oOpenToolPopup===this._oFeederPopup)){this._oOpenToolPopup.setPosition(x.BeginTop,x.EndTop,e+this._oOpenToolPopup.getId()?window.document.getElementById(e+this._oOpenToolPopup.getId()):null,"13 -6","fit");var i=document.getElementById(e+this._oOpenToolPopup.getId());jQuery(i).toggleClass("sapUiUx3ShellToolSelected",true);H._updateToolIcon(i);s=true}if(!s&&this._oOpenToolPopup){this._closeCurrentToolPopup()}for(var o=0;o<t.length;o++){var a=t[o];if(a instanceof p){jQuery(document.getElementById(e+a.getId())).hover(function(e){jQuery(this).toggleClass("sapUiUx3ShellToolHover",e.type==="mouseenter");H._updateToolIcon(this)})}}if(this._topSyncRefId&&this._mSyncRefs[this._topSyncRefId].focusFirst){this.$("focusDummyTPEnd").attr("tabindex","0").on("focusin",this._mSyncRefs[this._topSyncRefId].focusFirst)}if(this._aSyncRefStack.length>0){this.$("focusDummyTPStart").attr("tabindex","0").on("focusin",jQuery.proxy(this.focusLastHdr,this))}};H.prototype._rerenderContent=function(e){var t=this.$("content");if(t.length>0){var s=this.getContent(),i=sap.ui.getCore().createRenderManager();for(var o=0;o<s.length;o++){i.renderControl(s[o])}i.flush(t[0],e);i.destroy()}};H.prototype._rerenderPane=function(e){var t=this.$("paneContent");if(t.length>0){var s=this.getPaneContent(),i=sap.ui.getCore().createRenderManager();for(var o=0;o<s.length;o++){i.renderControl(s[o])}i.flush(t[0],e);i.destroy()}};H.prototype._rerenderPaneBarItems=function(){var e=this.$("paneBar").find(".sapUiUx3ShellPaneEntries");if(e.length>0){var t=sap.ui.getCore().createRenderManager();o.renderPaneBarItems(t,this);t.flush(e[0]);t.destroy();this._updatePaneBarItemNavigation(e)}var s=this;var i=this._getPaneOverflowMenu();var a=this.getPaneBarItems();var r=function(e){var t={overflowItem:e.getParameter("item"),target:{id:e.getParameter("id").replace(/-overflow$/,""),parentNode:{className:"sapUiUx3ShellPaneEntries"}}};s.onUserActivation(t)};for(var n=0;n<a.length;++n){var l=a[n].getId()+"-overflow";var h=sap.ui.getCore().byId(l);if(!h){var p=new _(l,{text:a[n].getText(),visible:false,select:r});i.addItem(p)}}this._checkPaneBarOverflow(e)};H.prototype._rerenderWorksetItems=function(){if(this.$("wBar").length>0){o.renderWorksetItems(null,this);o.renderFacetBar(null,this);var e=this._oFacetBar.getAssociatedItems();this._oFacetBar.$().css("display",e&&e.length>0?"block":"none");this._adaptContentHeight()}};H.prototype.forceInvalidation=t.prototype.invalidate;H.prototype.invalidate=function(e){if(!e){this.forceInvalidation()}else if(e instanceof sap.ui.ux3.NavigationItem){if(this._oWorksetBar&&this._oFacetBar){this._oWorksetBar.setAssociatedItems(this.getWorksetItems());var t=this.getSelectedWorksetItem();if(t){var s;var i=sap.ui.getCore().byId(t);if(i&&i.getParent()instanceof sap.ui.ux3.NavigationItem){this._oFacetBar.setAssociatedItems(i.getParent().getSubItems())}else if(i&&(s=i.getSubItems())){if(s&&s.length>0){this._oFacetBar.setAssociatedItems(s)}}s=this._oFacetBar.getAssociatedItems();this._oFacetBar.$().css("display",s&&s.length>0?"block":"none");this._adaptContentHeight()}}}else if(e instanceof sap.ui.core.Item&&e.getParent()==this){this.forceInvalidation()}else if(e instanceof p){this._rerenderToolPalette()}else if(this.indexOfHeaderItem(e)>=0){this._rerenderHeader()}};H.prototype._setParent=t.prototype.setParent;H.prototype.setParent=function(e,t,s){this._setParent(e,t,s);this.forceInvalidation()};H.prototype.setContent=function(e,s){S(e===null||e instanceof t||Array.isArray(e)&&(e.length>0?e[0]instanceof t:true),"vContent must be a control or array of controls or null");S(s===undefined||s===true||s===false,"bDestruct must be true, false, or undefined");var i=[];var o=this.$("content");var a=false;if(!s){i=this.removeAllAggregation("content",true);if(o.length>0){l.preserveContent(o[0]);a=true;o.empty()}}else{this.destroyAggregation("content",true)}if(e instanceof t){this.addAggregation("content",e,true)}else if(e&&typeof e=="object"&&e.length){for(var r=0;r<e.length;r++){this.addAggregation("content",e[r],true)}}this._rerenderContent(a);return i};H.prototype.setPaneContent=function(e,s){S(e instanceof t||Array.isArray(e)&&(e.length>0?e[0]instanceof t:true),"vContent must be a control or array of controls");S(s===undefined||s===true||s===false,"bDestruct must be true, false, or undefined");var i=[];var o=this.$("paneContent");var a=false;if(!s){i=this.removeAllAggregation("paneContent",true);if(o.length>0){l.preserveContent(o[0]);a=true;o.empty()}}else{this.destroyAggregation("paneContent",true)}if(e instanceof t){this.addAggregation("paneContent",e,true)}else if(e&&typeof e=="object"&&e.length){for(var r=0;r<e.length;r++){this.addAggregation("paneContent",e[r],true)}}this._rerenderPane(a);return i};H.prototype.getSelectedWorksetItem=function(){return this.getAssociation("selectedWorksetItem")};H.prototype.setSelectedWorksetItem=function(e){var t=this.getSelectedWorksetItem();this.setAssociation("selectedWorksetItem",e,true);var s=this.getSelectedWorksetItem();if(t!=s){var i=sap.ui.getCore().byId(s);if(i){this._sSelectedWorksetId=s;this._sSelectedFacetId=null;var o=i.getSubItems();if(o.length>0){i=o[0]}if(i&&i.getParent()instanceof sap.ui.ux3.NavigationItem){var a=i.getParent();this._sSelectedWorksetId=a.getId();this._sSelectedFacetId=i.getId();this._oWorksetBar.setSelectedItem(a);this._oFacetBar.setAssociatedItems(a.getSubItems());this._oFacetBar.setSelectedItem(i);if(this.getDomRef()){var r=this.$("facetBar");var n=this._calcFacetBarHeight(r);r.slideDown();this._adaptContentHeight(null,true,n)}}else if(i){this._oWorksetBar.setSelectedItem(i);this._oFacetBar.setAssociatedItems([]);this._oFacetBar.setSelectedItem(null);if(this.getDomRef()){var r=this.$("facetBar");var n=this._calcFacetBarHeight(r);r.slideUp();this._adaptContentHeight(null,true,n)}}}else{throw new Error("WorksetItem with ID "+s+" cannot be found.")}}return this};H.prototype.setApplyContentPadding=function(e){this.setProperty("applyContentPadding",e,true);this.$().toggleClass("sapUiUx3ShellNoContentPadding",!e);this._adaptContentHeight();return this};H.prototype.setFullHeightContent=function(e){this.setProperty("fullHeightContent",e,true);this.$().toggleClass("sapUiUx3ShellFullHeightContent",e);this._adaptContentHeight();return this};H.prototype._calcFacetBarHeight=function(e){if(this._iFacetBarHeight===undefined){this._iFacetBarHeight=0}if(!e){e=this.$("facetBar")}if(e.length>0){var t=this.$("facetBar").outerHeight(true);this._iFacetBarHeight=Math.max(this._iFacetBarHeight,t)}return this._iFacetBarHeight};H.prototype._adaptContentHeight=function(e,t,s){if(!this.getDomRef()){return}var i=this.$("content");var o=this.$("canvas");if(this.getFullHeightContent()){var a=this.getApplyContentPadding();var r=!a?0:parseInt(o.css("paddingTop"));var n=!a?0:parseInt(o.css("paddingLeft"));var h=!a?0:parseInt(o.css("paddingRight"));var p=s?s:this._calcFacetBarHeight();var d=r+(this._oFacetBar.getAssociatedItems().length>0?p:0)+"px";if(t){i.stop().animate({top:d})}else{i.stop().css("top",d)}var c=this.getNotificationBar();if(c&&!e){e=c.getVisibleStatus()}if(e===P.Default||e===P.Max){i.css("bottom",c.getHeightOfStatus(P.Default))}else{var u=!a?0:parseInt(o.css("paddingBottom"));if(c&&e===P.Min){u+=y.HOVER_ITEM_HEIGHT}i.css("bottom",u+"px")}i.css(this._bRtl?"right":"left",n+"px");i.css(this._bRtl?"left":"right",h+"px")}else{i.removeAttr("style")}if(v.browser.webkit){l.forceRepaint(this.getId()+"-canvas")}};H.prototype._handleDragover=function(e){var t=e.target.id;if(!this._dragOverBlinking){var s=jQuery(document.getElementById(t));s.css("opacity","0.5");this._dragOverBlinking=true;var i=this;window.setTimeout(function(){s.css("opacity","1");window.setTimeout(function(){i._dragOverBlinking=null},300)},300)}return false};H.prototype._handleDragend=function(e){return false};H.prototype._handleDrop=function(e){var t=e.target.id;e.preventDefault();var s=e.originalEvent;var i=s.dataTransfer.files[0];if(i){var o=new window.FileReader;o.onload=jQuery.proxy(function(e){var s=e.target.result;if(t==this.getId()+"-bgImg"){this._getPersonalization()._handleBackgroundImageChange(s,true)}else if(t==this.getId()+"-hdr"){this._getPersonalization()._handleHeaderImageChange(s,true)}else if(t==this.getId()+"-logoImg"){this._getPersonalization()._handleLogoImageChange(s,true)}o=null},this);o.readAsDataURL(i)}};H.prototype._getPersonalization=function(){if(!this.oPersonalization){this.oPersonalization=new a(this)}return this.oPersonalization};H.prototype.openPersonalizationDialog=function(){this._getPersonalization().openDialog()};H.prototype.initializePersonalization=function(e){this._getPersonalization().initializeSettings(e)};H.prototype.onThemeChanged=function(e){this._iFacetBarHeight=undefined;if(!this.getDomRef()){return}var t="";if(!this.getAppIcon()){t=s._getThemeImage("sapUiUx3ShellApplicationImageURL",true);this.$("logoImg").attr("src",t)}t=s._getThemeImage("sapUiUx3ShellHeaderImageURL",true);this.$("hdrImg").attr("src",t);t=s._getThemeImage("sapUiUx3ShellBackgroundImageURL",true);this.$("bgImg").attr("src",t);this.$("facetBar").stop(true,true);this._adaptContentHeight();this._updateThemeVariables();this._checkResize()};return H});
//# sourceMappingURL=Shell.js.map