/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","sap/ui/core/Control","sap/ui/core/IconPool","sap/ui/core/Popup","sap/ui/core/theming/Parameters","sap/ui/core/RenderManager","./library","./ToolPopupRenderer","sap/ui/core/ResizeHandler","sap/ui/core/library","sap/base/assert","sap/base/Log","sap/ui/core/Configuration","sap/ui/dom/jquery/rect","sap/ui/dom/jquery/control","sap/ui/dom/jquery/Selectors"],function(jQuery,t,e,o,i,r,s,n,a,p,u,h,l){"use strict";var c=p.OpenState;var d=t.extend("sap.ui.ux3.ToolPopup",{metadata:{deprecated:true,interfaces:["sap.ui.core.PopupInterface"],library:"sap.ui.ux3",properties:{title:{type:"string",group:"Misc",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconHover:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconSelected:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},modal:{type:"boolean",group:"Behavior",defaultValue:false},inverted:{type:"boolean",group:"Misc",defaultValue:true},autoClose:{type:"boolean",group:"Misc",defaultValue:false},maxHeight:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},maxWidth:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},openDuration:{type:"int",group:"Misc",defaultValue:400},closeDuration:{type:"int",group:"Misc",defaultValue:400}},defaultAggregation:"content",aggregations:{buttons:{type:"sap.ui.core.Control",multiple:true,singularName:"button"},content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}},associations:{initialFocus:{type:"sap.ui.core.Control",multiple:false},opener:{type:"sap.ui.core.Control",multiple:false},defaultButton:{type:"sap.ui.core.Control",multiple:false}},events:{open:{},close:{allowPreventDefault:true},enter:{parameters:{originalEvent:{type:"object"},originalSrcControl:{type:"sap.ui.core.Control"}}},iconChanged:{},closed:{},opened:{}}}});d.ARROW_LEFT=new RegExp(/my:(left|begin)([-+]\d*\%?)?\|[a-z]+([-+]\d*\%?)? at:(right|end)\|[a-z]+/);d.ARROW_RIGHT=new RegExp(/my:(right|end)([-+]\d*\%?)?\|[a-z]+([-+]\d*\%?)? at:(left|begin)\|[a-z]+/);d.ARROW_UP=new RegExp(/my:[a-z]+([-+]\d*\%?)?\|top([-+]\d*\%?)? at:[a-z]+\|bottom/);d.ARROW_DOWN=new RegExp(/my:[a-z]+([-+]\d*\%?)?\|bottom([-+]\d*\%?)? at:[a-z]+\|top/);(function(){d.prototype.init=function(){this.oPopup=null;this._bPositionSet=false;this._mParameters={};this._mParameters.that=this;this._mParameters.firstFocusable=this.getId()+"-firstFocusable";this._mParameters.lastFocusable=this.getId()+"-lastFocusable";this._bFocusSet=false;this._proxyOpened=jQuery.proxy(p,this);this._proxyClosed=jQuery.proxy(y,this);this._proxyFixSize=jQuery.proxy(n,this);this._proxyOnResize=jQuery.proxy(_,this);g(this)};d.prototype.exit=function(){if(this.oPopup){this.oPopup.detachOpened(this._proxyOpened);this.oPopup.detachClosed(this._proxyClosed);this.oPopup.destroy();delete this.oPopup}delete this._bPositionSet;delete this._mParameters;delete this._bFocusSet;delete this._bPreventRestoreFocus;delete this._proxyOpened;delete this._proxyClosed;delete this._bRTL;delete this._sArrowDir;delete this._oArrowIcon;delete this._bThemeInverted;delete this._sInitialFocusId};var t=function(t){var o=t;u(!!o,"No ToolPopup instance given for _fnGetInitialFocus");if(!o._bFocusSet){e(o)}else{o._sInitialFocusId=o.oPopup._sInitialFocusId}return o._sInitialFocusId};var e=function(t){var e;var o;var i=t;var r=[i._mParameters.firstFocusable,i._mParameters.lastFocusable];var s=jQuery(":sapTabbable",i.$()).get();for(var n=0;n<s.length;n++){if(r.indexOf(s[n].id)===-1){e=s[n];break}}o=jQuery(e).control();if(o[0]){var a=o[0].getFocusDomRef();e=a||e}else{e=r[0]?window.document.getElementById(r[0]):null}if(e){if(e){e.focus()}i._sInitialFocusId=e.id}};function s(t,e){var o,i;if(!e){return null}o=sap.ui.getCore().byId(e);while(!o&&o!==t){if(!e||!document.getElementById(e)){return null}i=document.getElementById(e).parentNode;e=i.id;o=sap.ui.getCore().byId(e)}return o}d.prototype.getFocusDomRef=function(){var e;var o=s(this,this._sInitialFocusId);if(!o){this._bFocusSet=false;e=t(this);o=s(this,e)}return o?o.getDomRef():this.getDomRef()};d.prototype.onfocusin=function(t){this._mParameters.event=t;this._mParameters.$FocusablesContent=jQuery(":sapTabbable",this.$("content"));this._mParameters.$FocusablesFooter=jQuery(":sapTabbable",this.$("buttons"));this.oPopup.focusTabChain(this._mParameters)};var n=function(){var t=this.$();var e=0;var o=this.getMaxHeight();var i=o?parseInt(o):0;var r=this.getMaxWidth();if(r){var s=parseInt(r);var n=t.css("border-left-width");var a=parseInt(n);var p=t.css("border-right-width");var u=parseInt(p);var l=t.css("padding-left");var c=parseInt(l);var d=t.css("padding-right");var f=parseInt(d);s-=a+c+f+u;t.css("max-width",s+"px")}else{t.css("max-width","")}var g=t.css("padding-top");var P=parseInt(g);var y=t.css("padding-bottom");var _=parseInt(y);var m=t.css("border-top-width");var w=parseInt(m);var I=t.css("border-bottom-width");var b=parseInt(I);var x=P+_+w+b;var A=jQuery(document).scrollTop();var R=t.rect();var C=R.top-A+t.outerHeight(true);var T=jQuery(window).height();var U=C>T&&i===0;var O=0;if(U){var F=jQuery(document.getElementById(this.getOpener()));var D=F.rect();var H=D.top-A+F.outerHeight(true);var S=this.oPopup._getPositionOffset();if(C>H&&S.length>0){O=Math.abs(parseInt(S[1]));if(C-O<T){U=false;var W="Offset of "+O+" pushes ToolPopup out of the window";h.warning(W,"","sap.ui.ux3.ToolPopup")}}i=i?i:T-R.top}t.toggleClass("sapUiUx3TPLargeContent",U);if(i||U){t.css("max-height",i+"px");var M=this.$("title");var z=this.$("title-separator");var B=this.$("buttons");var E=this.$("buttons-separator");e=i>0?i:T-R.top-_-O;e-=x;e-=M.outerHeight(true);e-=z.outerHeight(true);e-=E.outerHeight(true);e-=B.length>0?B.outerHeight(true):0;e=parseInt(e);var L=this.$("content");L.css("max-height",e+"px");L.toggleClass("sapUiUx3TPLargeContent",true)}v(this)};var p=function(){this._proxyFixSize();if(!this._sInitialFocusId){var e=t(this);if(e!==sap.ui.getCore().getCurrentFocusedControlId()){var o=jQuery(document.getElementById(e));o.trigger("focus")}}if(!this._sResizeID){this._sResizeID=a.register(this.$("content")[0],this._proxyOnResize)}this.fireOpened()};d.prototype.isOpen=function(){return this.oPopup&&(this.oPopup.getOpenState()=="OPENING"||this.oPopup.getOpenState()=="OPEN")};d.prototype.willBeClosed=function(){var t=this.oPopup&&this.oPopup.getOpenState();return t!==c.OPENING&&t!==c.OPEN};d.prototype.open=function(t,e){this._my=t;this._at=e;this._sArrowDir=P(this);var i=null;this.sOffset="";b(this);if(!this._bPositionSet){var r=0;var s=0;if(!this._my){this._my=o.Dock.BeginTop}if(!this._at){this._at=o.Dock.EndTop}i=this.getOpener()?window.document.getElementById(this.getOpener()):null;if(i){switch(this._sArrowDir){case"Up":r=0;s=this.iArrowWidth;break;case"Down":r=0;s=-this.iArrowWidth;break;case"Right":r=-this.iArrowWidth;break;case"Left":default:r=this.iArrowWidth;break}r=parseInt(r);s=parseInt(s);this.sOffset=""+r+" "+s;this.setPosition(this._my,this._at,i,this.sOffset,"none")}else{this.setPosition(o.Dock.BeginTop,o.Dock.BeginTop,window,"0 0","fit");h.warning("No opener set. Using a default position for Popup","","sap.ui.ux3.ToolPopup")}this._bPositionSet=false}this._ensurePopup();var n=this.getAutoClose();var a=this.getModal();if(n&&a){h.warning("A modal & autoclose ToolPopup will not work properly. Therefore 'autoclose' will be deactived!");n=false}this.oPopup.setAutoClose(n);this.oPopup.setModal(a);this._oPreviousFocus=o.getCurrentFocusInfo();this.fireOpen();f(this);this.oPopup.open(this.getOpenDuration(),this._my,this._at,i,this.sOffset,"",true);v(this);return this};var f=function(t){if(!t.getOpener()){var e="";if(t.oPopup){if(t.oPopup._oPosition.of instanceof sap.ui.core.Element){e=t.oPopup._oPosition.of.getId()}else{if(t.oPopup._oPosition.of.length>0){e=t.oPopup._oPosition.of[0].id}else{e=t.oPopup._oPosition.of.id}}}if(e!==""){t.setAssociation("opener",e,true)}else{h.error("Neither an opener was set properly nor a corresponding one can be distinguished","","sap.ui.ux3.ToolPopup")}}};var g=function(t){var e=Object.assign({sapUiUx3ToolPopupArrowWidth:"13px",sapUiUx3ToolPopupArrowHeight:"24px",sapUiUx3ToolPopupArrowRightMarginCorrection:"-2px",sapUiUx3ToolPopupArrowRightMarginCorrectionInverted:"-7px"},i.get({name:["sapUiUx3ToolPopupArrowWidth","sapUiUx3ToolPopupArrowHeight","sapUiUx3ToolPopupArrowRightMarginCorrection","sapUiUx3ToolPopupArrowRightMarginCorrectionInverted"],callback:function(){t.invalidate()}}));var o="sapUiUx3ToolPopupArrowWidth";t.sArrowWidth=e[o];t.iArrowWidth=parseInt(t.sArrowWidth);o="sapUiUx3ToolPopupArrowHeight";t.sArrowHeight=e[o];t.iArrowHeight=parseInt(t.sArrowHeight);o="sapUiUx3ToolPopupArrowRightMarginCorrection";t.sArrowPadding=e[o];t.iArrowPadding=parseInt(t.sArrowPadding);o="sapUiUx3ToolPopupArrowRightMarginCorrectionInverted";t.sArrowPaddingInverted=e[o];t.iArrowPaddingInverted=parseInt(t.sArrowPaddingInverted)};var P=function(t){var e="Left";function o(t){return t.replace(/([a-z])([A-Z])/g,"$1 $2").toLowerCase().split(" ")}var i=t._my;var r=t._at;if(!i&&t.oPopup){i=t.oPopup._oPosition.my}if(!r&&t.oPopup){r=t.oPopup._oPosition.at}t._bHorizontalArrow=false;if(i&&r){var s=o(i);var n=o(r);var a="my:"+s[0]+"|"+s[1];a+=" at:"+n[0]+"|"+n[1];if(d.ARROW_LEFT.exec(a)){t._bHorizontalArrow=true;e="Left"}else if(d.ARROW_RIGHT.exec(a)){t._bHorizontalArrow=true;e="Right"}else if(d.ARROW_UP.exec(a)){e="Up"}else if(d.ARROW_DOWN.exec(a)){e="Down"}if(t.getDomRef()&&t.isOpen()){var p=t.$();var u=p.rect();var h=jQuery(document.getElementById(t.getOpener()));var l=h.rect();if(l){if(t._bHorizontalArrow){var c=u.left+p.outerWidth(true)+t.iArrowWidth;var f=l.left+h.outerWidth(true);if(c<=f){e="Right"}else{e="Left"}}else{var g=u.top+p.outerHeight(true)+t.iArrowWidth;var P=l.top+h.outerHeight(true);if(g<=P){e="Down"}else{e="Up"}}}}}return e};var v=function(t){var e="",o=0,i=0,r=t.iArrowHeight/2,s=l.getRTL(),n,a=t.$().rect(),p=jQuery(document.getElementById(t.getOpener())),u=p.rect(),c=0,d=t.$("arrow");if(!t.getDomRef()){return}t._sArrowDir=P(t);n=t._sArrowDir;if(s){if(t._sArrowDir==="Right"){n="Left"}else if(t._sArrowDir==="Left"){n="Right"}}if(!u){h.warning("Opener wasn't set properly. Therefore arrow will be at a default position","","sap.ui.ux3.ToolPopup")}if(!t._my&&t.oPopup){t._my=t.oPopup._oPosition.my}if(t._bHorizontalArrow){e="top";if(u){c=parseInt(t.$().css("border-top-width"))||0;i=parseInt(u.top-c-a.top);o=Math.round(i+u.height/2-r);o=o+r>a.height?o-t.iArrowHeight:o}}else{e="left";if(u){if(s){e="right";c=parseInt(t.$().css("border-right-width"))||0;i=parseInt(a.left+a.width-u.left-u.width-c)}else{c=parseInt(t.$().css("border-left-width"))||0;i=parseInt(u.left-a.left-c)}o=Math.round(i+u.width/2-r);o=o+r>a.width?o-t.iArrowHeight:o}}if(!u){o=t.iArrowHeight}var f="";if(d.hasClass("sapUiUx3TPNewArrow")){f="sapUiUx3TPNewArrow sapUiUx3TPNewArrow"}else{f=t.isInverted()?"sapUiUx3TPArrow sapUiTPInverted sapUiUx3TPArrow":"sapUiUx3TPArrow sapUiUx3TPArrow"}d.attr("class",f+n);if(n==="Right"){var g=a.width;if(t.isInverted()){g+=t.iArrowPaddingInverted}else{g+=t.iArrowPadding}if(s){d.css("right",g+"px")}else{d.css("left",g+"px")}}else{d.css({left:"",right:""})}o=parseInt(o);o=o<-c?-c:o;d.css(e,o+"px")};d.prototype.onsapescape=function(){if(this.fireClose()){this.close()}};var y=function(t){if(!this._bPreventRestoreFocus){o.applyFocusInfo(this._oPreviousFocus)}if(this.getDomRef()){r.preserveContent(this.getDomRef());this.$().remove()}this.fireClosed()};d.prototype.close=function(t){if(this.oPopup&&this.oPopup.isOpen()){if(this._sResizeID){a.deregister(this._sResizeID);delete this._sResizeID}this.oPopup.close(this.getCloseDuration());this._bPreventRestoreFocus=t}return this};d.prototype.getEnabled=function(){var t=this.oPopup?this.oPopup.getOpenState():c.CLOSED;return t===c.OPENING||t===c.OPEN};d.prototype.onsapenter=function(t){var e=this.getDefaultButton();var o=sap.ui.getCore().byId(e);if(e&&o&&jQuery.contains(this.getDomRef(),o.getDomRef())){if(o instanceof sap.ui.commons.Button){var i=o.$();i.trigger("click");i.trigger("focus")}}t.preventDefault();t.stopPropagation()};d.prototype.onBeforeRendering=function(){g(this);var t=this.getInitialFocus()||this._sInitialFocusId;var e=this.getDefaultButton();this._bFocusSet=true;if(t){this.oPopup.setInitialFocusId(t)}else if(e){this.oPopup.setInitialFocusId(e)}else{this._bFocusSet=false}this._bRTL=l.getRTL()};d.prototype._ensurePopup=function(){if(!this.oPopup){this.oPopup=new o(this,false,true,false);this.oPopup.attachOpened(this._proxyOpened);this.oPopup.attachClosed(this._proxyClosed);var t=this;this.oPopup._applyPosition=function(){o.prototype._applyPosition.apply(t.oPopup,arguments);var e=t.oPopup._oLastPosition.of;if(!e){t.oPopup.close()}else{var i=jQuery(document.getElementById(e.id));if(t._bPositionSet){if(!i.hasClass("sapUiUx3ShellTool")){t._my=t.oPopup._oLastPosition.my;t._at=t.oPopup._oLastPosition.at}}v(t)}}}return this.oPopup};var _=function(){if(this.getContent().length){this._proxyFixSize();this.oPopup._applyPosition(this.oPopup._oLastPosition)}};d.prototype.setPosition=function(){this._ensurePopup();this.oPopup.setPosition.apply(this.oPopup,arguments);this._bPositionSet=true;f(this);return this};var m=function(t,e){var o=t;if(e==="content"){w(o)}else if(e==="buttons"){I(o)}o._proxyFixSize();o.oPopup._applyPosition(o.oPopup._oLastPosition)};var w=function(t){var e=t.getDomRef("content");e.innerHTML="";var o=t.getContent();var i=sap.ui.getCore().createRenderManager();for(var r=0;r<o.length;r++){i.renderControl(o[r])}i.flush(e,true);i.destroy()};var I=function(t){var e=t.getDomRef("buttons");var o=t.getDomRef("buttons-separator");var i=t.getButtons();if(i.length===0){jQuery(e).addClass("sapUiUx3TPButtonRowHidden");jQuery(o).addClass("sapUiUx3TPButtonRowHidden")}else{jQuery(e).removeClass("sapUiUx3TPButtonRowHidden");jQuery(o).removeClass("sapUiUx3TPButtonRowHidden");e.innerHTML="";var r=sap.ui.getCore().createRenderManager();for(var s=0;s<i.length;s++){r.renderControl(i[s])}r.flush(e,true);r.destroy()}};d.prototype.addContent=function(t){this.addAggregation("content",t,true);if(this.isOpen()){m(this,"content")}return this};d.prototype.insertContent=function(t,e){this.insertAggregation("content",t,e,true);if(this.isOpen()){m(this,"content")}return this};d.prototype.removeContent=function(t){this.removeAggregation("content",t,true);if(this.isOpen()){m(this,"content")}return this};d.prototype.addButton=function(t){this.addAggregation("buttons",t,true);if(this.isOpen()){m(this,"buttons")}return this};d.prototype.insertButton=function(t,e){this.insertAggregation("buttons",t,e,true);if(this.isOpen()){m(this,"buttons")}return this};d.prototype.removeButton=function(t){this.removeAggregation("button",t,true);if(this.isOpen()){m(this,"buttons")}return this};var b=function(t){var e="sapUiUx3ToolPopupInverted";e=i.get({name:e,callback:function(o){t._bThemeInverted=e==="true";t.invalidate()}})||"true";t._bThemeInverted=e==="true"};d.prototype.onThemeChanged=function(){b(this)};d.prototype.isInverted=function(){b(this);return this.getInverted()&&this._bThemeInverted};d.prototype.setAutoCloseAreas=function(t){this._ensurePopup();return this.oPopup.setAutoCloseAreas(t)};d.prototype.addFocusableArea=function(t){this._ensurePopup();if(typeof t==="string"){this.oPopup._addFocusableArea("channelId","eventId",{id:t});return this}else{h.error("Wrong type of focusable area ID - string expected","","sap.ui.ux3.ToolPopup")}};d.prototype.removeFocusableArea=function(t){this._ensurePopup();if(typeof t==="string"){this.oPopup._removeFocusableArea("channelId","eventId",{id:t});return this}else{h.error("Wrong type of focusable area ID - string expected","","sap.ui.ux3.ToolPopup")}}})();d.prototype.setIcon=function(t){this.setProperty("icon",t,true);this.fireIconChanged();return this};d.prototype.setIconHover=function(t){this.setProperty("iconHover",t,true);this.fireIconChanged();return this};d.prototype.setIconSelected=function(t){this.setProperty("iconSelected",t,true);this.fireIconChanged();return this};d.prototype.getIconSelected=function(){return this.getProperty("iconSelected")||this.getProperty("iconHover")};d.prototype.setMaxWidth=function(t){var e=/[0-9]+px/;if(e.test(t)){this.setProperty("maxWidth",t)}else{h.error("Only values in pixels are possible","","sap.ui.ux3.ToolPopup")}return this};return d});
//# sourceMappingURL=ToolPopup.js.map