/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/i18n/Localization","sap/ui/core/Element","sap/ui/core/Lib","sap/ui/core/Theming","sap/ui/thirdparty/jquery","sap/m/Button","sap/m/MenuButton","sap/m/library","sap/m/Toolbar","sap/ui/core/IconPool","sap/ui/core/Item","sap/ui/core/ResizeHandler","sap/ui/core/delegate/ScrollEnablement","sap/ui/layout/HorizontalLayout","sap/ui/Device","sap/ui/core/CustomData","sap/ui/core/Control","./HierarchicalSelect","./library","sap/uxap/AnchorBarRenderer","sap/base/Log","sap/ui/base/ManagedObject","sap/ui/dom/jquery/scrollLeftRTL"],function(t,e,o,i,jQuery,r,s,n,a,l,c,h,u,f,p,d,_,g,S,y,A,B){"use strict";var m=n.SelectType;var C=2;var I=a.extend("sap.uxap.AnchorBar",{metadata:{library:"sap.uxap",properties:{showPopover:{type:"boolean",defaultValue:true},upperCase:{type:"boolean",defaultValue:false},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance"}},associations:{selectedButton:{type:"sap.m.Button",multiple:false}},aggregations:{_select:{type:"sap.uxap.HierarchicalSelect",multiple:false,visibility:"hidden"},_scrollArrowLeft:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_scrollArrowRight:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}}},renderer:y});I.ButtonDelegate={onAfterRendering:function(){var t=this.isA("sap.m.MenuButton")?this._getButtonControl():this,e=this.hasStyleClass("sapUxAPAnchorBarButtonSelected");if(this.data("bHasSubMenu")){t.$().attr("aria-haspopup","menu");t.$().find(".sapMBtn").attr("role","none").removeAttr("aria-haspopup")}t.$().attr("aria-controls",this.data("sectionId")).attr("aria-selected",e)}};I.prototype.init=function(){if(a.prototype.init){a.prototype.init.call(this)}this.addStyleClass("sapUxAPAnchorBar");this._oPressHandlers={};this._oSectionInfo={};this._oScroller=null;this._sSelectedKey=null;this._bRtl=t.getRTL();this._bHasButtonsBar=p.system.tablet||p.system.desktop;this.oLibraryResourceBundleOP=o.getResourceBundleFor("sap.uxap");this._oSelect=this._getHierarchicalSelect();if(this._bHasButtonsBar){this._oScroller=new u(this,this.getId()+"-scroll",{horizontal:true,vertical:false,nonTouchScrolling:true});this._iREMSize=0;this._iTolerance=0;this._iOffset=0;this._sResizeListenerId=undefined}this.setDesign("Transparent")};I.SCROLL_STEP=250;I.SCROLL_DURATION=500;I.DOM_CALC_DELAY=200;I.prototype.setSelectedButton=function(t){var o=this.getSelectedButton(),i,r=this._oSelect.getItems(),s=r.length>0;if(typeof t==="string"){t=e.getElementById(t)}if(t){if(t.getId()===o){return this}var n=t.data("sectionId");this._sSelectedKey=n;if(n&&s){this._oSelect.setSelectedKey(n)}if(this._bHasButtonsBar&&t.data("secondLevel")!==true){i=e.getElementById(o);this._toggleSelectionStyleClass(i,false);this._toggleSelectionStyleClass(t,true);if(n){this.scrollToSection(n,I.SCROLL_DURATION)}this._setAnchorButtonsTabFocusValues(t)}this.setAssociation("selectedButton",t,true)}return this};I.prototype.setShowPopover=function(t,e){if(this.getShowPopover()===t){return this}return this.setProperty("showPopover",t,true)};I.prototype.getSelectedSection=function(){var t=this.getSelectedButton();if(t&&typeof t==="string"){t=e.getElementById(t)}if(t&&t instanceof r&&t.data("sectionId")){return e.getElementById(t.data("sectionId"))}return null};I.prototype.onBeforeRendering=function(){if(this._bHasButtonsBar){this._iREMSize=parseInt(jQuery("body").css("font-size"));this._iTolerance=this._iREMSize*1;this._iOffset=this._iREMSize*3}if(a.prototype.onBeforeRendering){a.prototype.onBeforeRendering.call(this)}var t=this.getContent()||[],e=this.getUpperCase();this._oSelect.setUpperCase(e);this.toggleStyleClass("sapUxAPAnchorBarUpperCase",e);if(t.length>0&&this._sSelectedKey){this._oSelect.setSelectedKey(this._sSelectedKey)}};I.prototype.addContent=function(t,e){var o=t.data("secondLevel")===true||t.data("secondLevel")==="true";t.addStyleClass("sapUxAPAnchorBarButton");t.removeAllAriaDescribedBy();this._createSelectItem(t,o);if(o){t.destroy()}else{t.addEventDelegate(I.ButtonDelegate,t);this.addAggregation("content",t,e)}return this};I.prototype._removeButtonsDelegate=function(){var t=this.getContent();t.forEach(function(t){t.removeEventDelegate(I.ButtonDelegate)})};I.prototype._createSelectItem=function(t,e){var o=t.getBindingInfo("text"),i=t.getText().trim()!=""||o;if(i&&(!e||t.data("bTitleVisible")===true)){var r=new c({key:t.data("sectionId"),text:B.escapeSettingsValue(t.getText()),customData:[new d({key:"secondLevel",value:t.data("secondLevel")})]});if(o){r.bindProperty("text",Object.assign({},o))}this._oSelect.addItem(r)}};I.prototype._decorateSubMenuButtons=function(t){var e=t.getSource().getContent();e.forEach(function(t){t.$().attr("aria-controls",t.data("sectionId"))})};I.prototype._toggleSelectionStyleClass=function(t,e){if(t&&t.toggleStyleClass){t.toggleStyleClass("sapUxAPAnchorBarButtonSelected",e);if(t instanceof s){t._getButtonControl().$().attr("aria-selected",e)}else{t.$().attr("aria-selected",e)}}};I.prototype.onButtonPress=function(t){this.fireEvent("_anchorPress",{sectionBaseId:t.getSource().data("sectionId")})};I.prototype._onSelectChange=function(t){var o=t.getParameter("selectedItem"),i,r;if(!o){A.warning("AnchorBar :: no selected hierarchicalSelect item");return}i=e.getElementById(o.getKey());if(i){this.fireEvent("_anchorPress",{sectionBaseId:i.getId()});r=i.getDomRef();if(r){setTimeout(function(){r.focus()},0)}}else{A.error("AnchorBar :: cannot find corresponding section",o.getKey())}};I.prototype._getHierarchicalSelect=function(){if(!this.getAggregation("_select")){this.setAggregation("_select",new g({width:"100%",icon:"sap-icon://slim-arrow-down",tooltip:this.oLibraryResourceBundleOP.getText("ANCHOR_BAR_OVERFLOW"),change:jQuery.proxy(this._onSelectChange,this)}))}return this.getAggregation("_select")};I.prototype._createScrollArrow=function(t){var e,o,s,n,a,c=this,h=this.oLibraryResourceBundleOP.getText("TOOLTIP_OP_SCROLL_LEFT_ARROW"),u=this.oLibraryResourceBundleOP.getText("TOOLTIP_OP_SCROLL_RIGHT_ARROW");if(t){e=this.getId()+"-arrowScrollLeft";o="slim-arrow-left";s="anchorBarArrowLeft";n=this._bRtl?u:h}else{e=this.getId()+"-arrowScrollRight";o="slim-arrow-right";s="anchorBarArrowRight";n=this._bRtl?h:u}a=new r(e,{icon:l.getIconURI(o),type:"Transparent",press:function(e){e.preventDefault();c._handleScrollButtonTap(t)},tooltip:n});a.addEventDelegate({onAfterRendering:function(){if(i.getTheme()!="sap_hcb"){this.$().attr("tabindex",-1)}},onThemeChanged:function(){if(i.getTheme()=="sap_hcb"){this.$().removeAttr("tabindex")}else{this.$().attr("tabindex",-1)}}},a);return new f({content:[a]}).addStyleClass("anchorBarArrow").addStyleClass(s)};I.prototype._getScrollArrowLeft=function(){var t=this.getAggregation("_scrollArrowLeft");if(t){return t}else{t=this._createScrollArrow(true);this.setAggregation("_scrollArrowLeft",t);return t}};I.prototype._getScrollArrowRight=function(){var t=this.getAggregation("_scrollArrowRight");if(t){return t}else{t=this._createScrollArrow(false);this.setAggregation("_scrollArrowRight",t);return t}};I.prototype._applyHierarchicalSelectMode=function(){if(this._sHierarchicalSelectMode===y._AnchorBarHierarchicalSelectMode.Icon){this.$().find(".sapUxAPAnchorBarScrollContainer").show();this._oSelect.setWidth("auto");this._oSelect.setAutoAdjustWidth(true);this._oSelect.setType(m.IconOnly);this._computeBarSectionsInfo()}else{this.$().find(".sapUxAPAnchorBarScrollContainer").hide();this._oSelect.setWidth("100%");this._oSelect.setAutoAdjustWidth(false);this._oSelect.setType(m.Default)}this.$().toggleClass("sapUxAPAnchorBarOverflow",this._sHierarchicalSelectMode===y._AnchorBarHierarchicalSelectMode.Icon)};I.prototype._adjustSize=function(t){var e=p.media.getCurrentRange(p.media.RANGESETS.SAP_STANDARD,this._getWidth(this)),o=t&&t.size&&t.size.width!==t.oldSize.width,i=S.Utilities.isPhoneScenario(e)?y._AnchorBarHierarchicalSelectMode.Text:y._AnchorBarHierarchicalSelectMode.Icon;if(i!==this._sHierarchicalSelectMode){this._sHierarchicalSelectMode=i;this._applyHierarchicalSelectMode()}if(this._sHierarchicalSelectMode===y._AnchorBarHierarchicalSelectMode.Icon){if(this._iMaxPosition<0){return}var r=this.$(),s=r.find(".sapUxAPAnchorBarScrollContainer"),n,a,l,c,h=function t(){var e=n;n=a;a=e};if(o){this.scrollToSection(this._sSelectedKey)}l=s.width();c=this._bRtl?s.scrollLeftRTL():s.scrollLeft();n=c>=this._iTolerance;a=c+l<this._iMaxPosition-this._iTolerance;if(this._bRtl){h()}A.debug("AnchorBar :: scrolled at "+c,"scrollBegin ["+(n?"true":"false")+"] scrollEnd ["+(a?"true":"false")+"]");r.toggleClass("sapUxAPAnchorBarScrollLeft",n);r.toggleClass("sapUxAPAnchorBarScrollRight",a)}};I.prototype._handleScrollButtonTap=function(t){var e=!this._bRtl&&t||this._bRtl&&!t?-1:1;this._oScroller.scrollTo(this._iMaxPosition*e,0,I.SCROLL_DURATION*3)};I.prototype.scrollToSection=function(t,e){if(this._bHasButtonsBar){var o=p.media.getCurrentRange(p.media.RANGESETS.SAP_STANDARD,this._getWidth(this)),e=e||I.SCROLL_DURATION,i;if(!S.Utilities.isPhoneScenario(o)&&this._oSectionInfo[t]){if(this._bRtl&&p.browser.firefox){i=this._oSectionInfo[t].scrollLeft+this._iOffset}else{i=this._oSectionInfo[t].scrollLeft-this._iOffset;if(i<0){i=0}}A.debug("AnchorBar :: scrolling to section "+t+" of "+i);if(this._sCurrentScrollId!=t){this._sCurrentScrollId=t;if(this._iCurrentScrollTimeout){clearTimeout(this._iCurrentScrollTimeout);this.$("scroll").parent().stop(true,false)}this._iCurrentScrollTimeout=setTimeout(function(){this._sCurrentScrollId=undefined;this._iCurrentScrollTimeout=undefined}.bind(this),e);this._oScroller.scrollTo(i,0,e)}}else{A.debug("AnchorBar :: no need to scroll to "+t)}}};I.prototype.scrollToCurrentlySelectedSection=function(){var t=this.getSelectedButton(),o=e.getElementById(t),i;if(o){i=o.data("sectionId");this.scrollToSection(i,0)}};I.prototype.getScrollDelegate=function(){return this._oScroller};I.PAGEUP_AND_PAGEDOWN_JUMP_SIZE=5;I.prototype.onsapright=function(t){t.preventDefault();var e,o=this.getContent(),i;o.forEach(function(o,i){if(t.target.id.indexOf(o.getId())>-1){e=i+1;return}});if(e&&o[e]){i=o[e];i.focus()}else if(o[o.length-1]){i=o[o.length-1];i.focus()}this._forceScrollIfNeeded(i)};I.prototype.onsapleft=function(t){t.preventDefault();var e,o=this.getContent(),i;o.forEach(function(o,i){if(t.target.id.indexOf(o.getId())>-1){e=i-1;return}});if(e&&o[e]){i=o[e];i.focus()}else if(o[0]){i=o[0];i.focus()}this._forceScrollIfNeeded(i,true)};I.prototype._forceScrollIfNeeded=function(t,e){var o=t.getDomRef(),i=o.parentElement,r=i.offsetLeft,s=i.offsetWidth,n=o&&o.offsetWidth,a=o&&o.offsetLeft,l=this._oScroller.getScrollLeft(),c,h,u;if(!i||!n){return}if(!this._bRtl){h=a+n;u=s-(r+h-l);if(!e&&u<0&&s-h<0){this._scrollAnchorBar(e,u)}u=a-this._iOffset-r-C;if(e&&l>u){this._scrollAnchorBar(e,u)}}else{if(e){c=l+s-this._iOffset;h=a-r;if(h+n>c){u=h+n-c+C;this._scrollAnchorBar(e,u)}}else{if(a-r-this._iOffset-C<l){u=n-a+C;this._scrollAnchorBar(e,u)}}}};I.prototype._scrollAnchorBar=function(t,e){var o=!this._bRtl&&t||this._bRtl&&!t?-1:1,i=this._oScroller.getScrollLeft(),r=e;if(o===1){r=this._bRtl?i+e:i+Math.abs(e)}if(this._bRtl&&o===-1){r=e*o}this._oScroller.scrollTo(r,0,I.SCROLL_DURATION*3)};I.prototype.onsapdown=function(t){t.preventDefault()};I.prototype.onsapup=function(t){t.preventDefault()};I.prototype.onsaphome=function(t){t.preventDefault();var e=this.getContent();e[0].focus()};I.prototype.onsapend=function(t){t.preventDefault();var e=this.getContent();e[e.length-1].focus()};I.prototype.onsappageup=function(t){this._handlePageUp(t)};I.prototype.onsappagedown=function(t){this._handlePageDown(t)};I.prototype._handlePageUp=function(t){t.preventDefault();var e;var o=this.getContent();o.forEach(function(o,i){if(t.target.id.indexOf(o.getId())>-1){e=i-(I.PAGEUP_AND_PAGEDOWN_JUMP_SIZE+1);return}});if(e&&o[e]){o[e].focus()}else if(o[0]){o[0].focus()}};I.prototype._handlePageDown=function(t){t.preventDefault();var e;var o=this.getContent();o.forEach(function(o,i){if(t.target.id.indexOf(o.getId())>-1){e=i+I.PAGEUP_AND_PAGEDOWN_JUMP_SIZE+1;return}});if(e&&o[e]){o[e].focus()}else if(o[o.length-1]){o[o.length-1].focus()}};I.prototype._setAnchorButtonsTabFocusValues=function(t){var e=this.getContent()||[],o,i="0",r="-1",s="tabIndex";e.forEach(function(e){o=e.getAggregation("_button")?e.getAggregation("_button").$():e.$();if(e===t){o.attr(s,i)}else{o.attr(s,r)}})};I.prototype.onAfterRendering=function(){var t;if(a.prototype.onAfterRendering){a.prototype.onAfterRendering.call(this)}t=e.getElementById(this.getSelectedButton());this._setAnchorButtonsTabFocusValues(t);this._iMaxPosition=-1;this._sResizeListenerId=h.register(this,jQuery.proxy(this._adjustSize,this));this.$().find(".sapUxAPAnchorBarScrollContainer").on("scroll",jQuery.proxy(this._onScroll,this));if(t){this.setSelectedButton(t)}if(this._bHasButtonsBar){this._iComputeContentSizeTimeout=setTimeout(function(){if(this._sHierarchicalSelectMode===y._AnchorBarHierarchicalSelectMode.Icon){this._computeBarSectionsInfo()}this._adjustSize();this._iComputeContentSizeTimeout=null}.bind(this),I.DOM_CALC_DELAY)}};I.prototype.onThemeChanged=function(){if(this._sHierarchicalSelectMode===y._AnchorBarHierarchicalSelectMode.Icon){this._computeBarSectionsInfo()}};I.prototype._onScroll=function(){if(!this._iCurrentSizeCheckTimeout){this._iCurrentSizeCheckTimeout=setTimeout(function(){this._iCurrentSizeCheckTimeout=undefined;this._adjustSize()}.bind(this),I.SCROLL_DURATION)}};I.prototype._computeBarSectionsInfo=function(){this._iMaxPosition=0;var t=this.getContent()||[];t.forEach(this._computeNextSectionInfo,this);if(this._bRtl&&(p.browser.webkit||p.browser.firefox)){t.forEach(this._adjustNextSectionInfo,this);this._oScroller&&this._oScroller.scrollTo(this._iMaxPosition,0,0)}};I.prototype._computeNextSectionInfo=function(t){var e=t.$().outerWidth(true);this._oSectionInfo[t.data("sectionId")]={scrollLeft:this._iMaxPosition,width:e};this._iMaxPosition+=e};I.prototype._adjustNextSectionInfo=function(t){var e=this._oSectionInfo[t.data("sectionId")];if(p.browser.firefox){e.scrollLeft=-e.scrollLeft}else{e.scrollLeft=this._iMaxPosition-e.scrollLeft-e.width}};I.prototype._resetControl=function(){this._removeButtonsDelegate();this.destroyAggregation("content");this._oSelect.destroyAggregation("items",true);return this};I.prototype._getAccessibilityRole=function(){return"none"};I.prototype.enhanceAccessibilityState=function(t,e){var o=this.getContent(),i=o.indexOf(t);if(i!==-1){e.role="option";e.setsize=o.length;e.posinset=i+1}};I.prototype.exit=function(){if(this._sResizeListenerId){h.deregister(this._sResizeListenerId);this._sResizeListenerId=null}if(this._oScroller){this._oScroller.destroy();this._oScroller=null}if(this.oLibraryResourceBundleOP){this.oLibraryResourceBundleOP=null}if(this._iComputeContentSizeTimeout){clearTimeout(this._iComputeContentSizeTimeout);this._iComputeContentSizeTimeout=null}this._removeButtonsDelegate()};I.prototype._getWidth=function(t){var e=t.getDomRef();return!(t instanceof _)?0:e&&e.offsetWidth||0};I.prototype.setVisible=function(t){this.getParent()&&this.getParent().toggleStyleClass("sapUxAPObjectPageLayoutNoAnchorBar",!t);return this.setProperty("visible",t)};return I});
//# sourceMappingURL=AnchorBar.js.map