/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Element","sap/ui/thirdparty/jquery","sap/ui/Device","sap/ui/base/Object","./ObjectPageSubSection","./library","sap/base/Log","sap/base/util/isEmptyObject"],function(e,jQuery,t,i,o,s,n,r){"use strict";var a={};var u=i.extend("sap.uxap._helpers.LazyLoading",{constructor:function(e){this._oObjectPageLayout=e;this._$html=jQuery("html");this._iPreviousScrollTop=0;this._iScrollProgress=0;this._iPreviousScrollTimestamp=0;this._sLazyLoadingTimer=null;this._bSuppressed=false;this._oPrevSubSectionsInView={};this.setLazyLoadingParameters()},getInterface:function(){return this}});u.prototype.setLazyLoadingParameters=function(){this.LAZY_LOADING_DELAY=200;if(this._isPhone()){this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD={FirstRendering:1,ScrollToSection:1}}else if(this._isTablet()){this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD={FirstRendering:2,ScrollToSection:1}}else if(this._isTabletSize()){this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD={FirstRendering:2,ScrollToSection:2}}else{this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD={FirstRendering:3,ScrollToSection:3}}this.LAZY_LOADING_FAST_SCROLLING_THRESHOLD=5};u.prototype.suppress=function(){this._bSuppressed=true};u.prototype.resume=function(){this._bSuppressed=false};u.prototype._triggerVisibleSubSectionsEvents=function(){this._oPrevSubSectionsInView={};this._oObjectPageLayout._requestAdjustLayout(true);this.doLazyLoading()};u.prototype.lazyLoadDuringScroll=function(e,t,i,o){var s,r,a=false;if(this._bSuppressed){return}if(e){if(this._sLazyLoadingTimer){clearTimeout(this._sLazyLoadingTimer)}this._sLazyLoadingTimer=null;this.doLazyLoading(t);return}this._iScrollProgress=t-this._iPreviousScrollTop;s=Math.round(Math.abs(this._iScrollProgress)/o*100);if(s>=this.LAZY_LOADING_FAST_SCROLLING_THRESHOLD){a=true}this._iPreviousScrollTop=t;this._iPreviousScrollTimestamp=i||0;r=t===0?0:this.LAZY_LOADING_DELAY;if(a&&this._sLazyLoadingTimer){n.debug("ObjectPageLayout :: lazyLoading","delayed by "+r+" ms because of fast scroll");clearTimeout(this._sLazyLoadingTimer);this._sLazyLoadingTimer=null}if(!this._sLazyLoadingTimer){this._sLazyLoadingTimer=setTimeout(this.doLazyLoading.bind(this,t),r)}};u.prototype.doLazyLoading=function(t){var i=this._oObjectPageLayout._getHeightRelatedParameters(),o=this._oObjectPageLayout.getUseIconTabBar(),s=e.getElementById(this._oObjectPageLayout.getSelectedSection()),r=this._oObjectPageLayout._oSectionInfo,u,c,l,_={},h={},L,g,S;if(this._bSuppressed){return}l=i.iScreenHeight-i.iAnchorBarHeight-i.iHeaderTitleHeightStickied;u=t||i.iScrollTop;L=Date.now()-this._iPreviousScrollTimestamp;g=L<this.LAZY_LOADING_DELAY/2&&Math.abs(this._iScrollProgress)>5;if(g){if(this._iScrollProgress>=0){S=Math.round(Math.min(this._iScrollProgress*20,l/2))}else{S=-1*Math.round(Math.min(Math.abs(this._iScrollProgress)*20,l/2))}u+=S;n.debug("ObjectPageLayout :: lazyLoading","Visible page shifted from : "+S)}c=u+l;u+=16;jQuery.each(r,jQuery.proxy(function(e,t){if(!t.isSection&&t.sectionReference.getParent()&&t.sectionReference.getParent().getVisible()){if(o&&s&&s.indexOfSubSection(t.sectionReference)<0){return}if(t.positionTop<=c&&u<t.positionBottom-1){h[e]=e;if(!t.loaded){_[e]=e}}}},this));jQuery.each(_,jQuery.proxy(function(t,i){n.debug("ObjectPageLayout :: lazyLoading","connecting "+i);a[t]=true;e.getElementById(i).connectToModelsAsync().then(function(){a[t]=false;n.debug("ObjectPageLayout :: lazyLoading","subSectionEnteredViewPort "+i);this._oObjectPageLayout.fireEvent("subSectionEnteredViewPort",{subSection:e.getElementById(i)});this._oPrevSubSectionsInView[t]=e.getElementById(i)}.bind(this));r[i].loaded=true},this));jQuery.each(h,jQuery.proxy(function(t,i){if(!this._oPrevSubSectionsInView[t]&&!a[t]){n.debug("ObjectPageLayout :: lazyLoading","subSectionEnteredViewPort "+i);this._oObjectPageLayout.fireEvent("subSectionEnteredViewPort",{subSection:e.getElementById(i)});this._oPrevSubSectionsInView[t]=e.getElementById(i)}},this));if(g){this._sLazyLoadingTimer=setTimeout(this.doLazyLoading.bind(this),this.LAZY_LOADING_DELAY)}else{this._sLazyLoadingTimer=null}};u.prototype.getSubsectionsToPreload=function(e,t){var i,s;if(t){i=this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD.ScrollToSection;s=false}else{i=this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD.FirstRendering;s=true}var n=[];e.some(function(e){if(!s&&t){s=e.getId()==t}if(s&&e instanceof o){if(e.getVisible()&&e._getInternalVisible()){n.push(e);i--}}return i<=0});return n};u.prototype.destroy=function(){if(this._sLazyLoadingTimer){clearTimeout(this._sLazyLoadingTimer)}};u.prototype._isPhone=function(){return s.Utilities.isPhoneScenario(this._oObjectPageLayout._getCurrentMediaContainerRange())};u.prototype._isTablet=function(){return t.system.tablet};u.prototype._isTabletSize=function(){return s.Utilities.isTabletScenario(this._oObjectPageLayout._getCurrentMediaContainerRange())};return u});
//# sourceMappingURL=LazyLoading.js.map