/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/i18n/Localization","sap/ui/core/AnimationMode","sap/ui/core/ControlBehavior","sap/ui/core/Element","sap/ui/core/EventBus","sap/ui/core/Lib","sap/ui/core/RenderManager","sap/ui/thirdparty/jquery","sap/ui/base/ManagedObjectObserver","sap/ui/core/ResizeHandler","sap/ui/core/Configuration","sap/ui/core/Control","sap/ui/core/InvisibleText","sap/ui/Device","sap/ui/base/ManagedObject","sap/ui/core/delegate/ScrollEnablement","./ObjectPageSectionBase","./ObjectPageSection","./ObjectPageSubSection","./ObjectPageHeaderContent","./LazyLoading","./ObjectPageLayoutABHelper","./ThrottledTaskHelper","sap/ui/core/library","./library","./ObjectPageLayoutRenderer","sap/base/Log","sap/base/util/array/diff","sap/ui/dom/getScrollbarSize","sap/base/assert","sap/base/util/isEmptyObject","sap/base/util/merge","sap/ui/events/KeyCodes","sap/ui/dom/getFirstEditableInput","sap/ui/dom/units/Rem","sap/ui/base/Object"],function(e,t,i,o,n,r,s,jQuery,a,l,h,c,d,g,u,_,p,S,f,b,y,T,H,A,C,I,P,B,E,v,O,L,m,R,D,V){"use strict";var x=A.TitleLevel;var F=A.AccessibleLandmarkRole;var $=C.ObjectPageSubSectionLayout;var j=["toggleAnchorBar","_moveHeader"];var M=c.extend("sap.uxap.ObjectPageLayout",{metadata:{library:"sap.uxap",properties:{showAnchorBar:{type:"boolean",defaultValue:true},showAnchorBarPopover:{type:"boolean",defaultValue:true},upperCaseAnchorBar:{type:"boolean",defaultValue:true},backgroundDesignAnchorBar:{type:"sap.m.BackgroundDesign",group:"Appearance"},height:{type:"sap.ui.core.CSSSize",defaultValue:"100%"},enableLazyLoading:{type:"boolean",defaultValue:false},subSectionLayout:{type:"sap.uxap.ObjectPageSubSectionLayout",defaultValue:$.TitleOnTop},sectionTitleLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:x.Auto},useIconTabBar:{type:"boolean",group:"Misc",defaultValue:false},showHeaderContent:{type:"boolean",group:"Misc",defaultValue:true},useTwoColumnsForLargeScreen:{type:"boolean",group:"Appearance",defaultValue:false},showTitleInHeaderContent:{type:"boolean",group:"Appearance",defaultValue:false},showOnlyHighImportance:{type:"boolean",group:"Behavior",defaultValue:false},isChildPage:{type:"boolean",group:"Appearance",defaultValue:false},alwaysShowContentHeader:{type:"boolean",group:"Behavior",defaultValue:false},headerContentPinnable:{type:"boolean",group:"Behavior",defaultValue:true},headerContentPinned:{type:"boolean",group:"Behavior",defaultValue:false},toggleHeaderOnTitleClick:{type:"boolean",group:"Behavior",defaultValue:true},preserveHeaderStateOnScroll:{type:"boolean",group:"Behavior",defaultValue:false},showEditHeaderButton:{type:"boolean",group:"Behavior",defaultValue:false},flexEnabled:{type:"boolean",group:"Misc",defaultValue:false},showFooter:{type:"boolean",group:"Behavior",defaultValue:false}},associations:{selectedSection:{type:"sap.uxap.ObjectPageSection",multiple:false}},defaultAggregation:"sections",aggregations:{sections:{type:"sap.uxap.ObjectPageSection",multiple:true,singularName:"section"},headerTitle:{type:"sap.uxap.IHeaderTitle",multiple:false},headerContent:{type:"sap.ui.core.Control",multiple:true,singularName:"headerContent"},footer:{type:"sap.m.IBar",multiple:false},landmarkInfo:{type:"sap.uxap.ObjectPageAccessibleLandmarkInfo",multiple:false},_anchorBar:{type:"sap.m.IconTabHeader",multiple:false,visibility:"hidden"},_iconTabBar:{type:"sap.m.IconTabBar",multiple:false,visibility:"hidden"},_headerContent:{type:"sap.uxap.IHeaderContent",multiple:false,visibility:"hidden"}},events:{headerContentPinnedStateChange:{parameters:{pinned:{type:"boolean"}}},toggleAnchorBar:{parameters:{fixed:{type:"boolean"}}},sectionChange:{parameters:{section:{type:"sap.uxap.ObjectPageSection"},subSection:{type:"sap.uxap.ObjectPageSubSection"}}},editHeaderButtonPress:{},beforeNavigate:{allowPreventDefault:true,parameters:{section:{type:"sap.uxap.ObjectPageSection"},subSection:{type:"sap.uxap.ObjectPageSubSection"}}},navigate:{parameters:{section:{type:"sap.uxap.ObjectPageSection"},subSection:{type:"sap.uxap.ObjectPageSubSection"}}},subSectionVisibilityChange:{parameters:{visibleSubSections:{type:"object"}}}},dnd:{draggable:false,droppable:true},designtime:"sap/uxap/designtime/ObjectPageLayout.designtime"},renderer:I});M.HEADER_CALC_DELAY=350;M.DOM_CALC_DELAY=200;M.MAX_SNAP_POSITION_OFFSET=20;M.HEADER_MAX_ALLOWED_NON_SROLLABLE_PERCENTAGE=.6;M.TITLE_LEVEL_AS_ARRAY=Object.keys(x);M.SCROLLBAR_SIZE_FF=12;M.EVENTS={TITLE_PRESS:"_titlePress",TITLE_MOUSE_OVER:"_titleMouseOver",TITLE_MOUSE_OUT:"_titleMouseOut",PIN_UNPIN_PRESS:"_pinUnpinPress",VISUAL_INDICATOR_MOUSE_OVER:"_visualIndicatorMouseOver",VISUAL_INDICATOR_MOUSE_OUT:"_visualIndicatorMouseOut",HEADER_VISUAL_INDICATOR_PRESS:"_headerVisualIndicatorPress",TITLE_VISUAL_INDICATOR_PRESS:"_titleVisualIndicatorPress"};M.MEDIA_RANGESET_NAME="ObjectPageRangeSet";M.BREAK_POINTS={DESKTOP:1439,TABLET:1024,PHONE:600};M.MEDIA={PHONE:"sapUxAPObjectPageLayout-Std-Phone",TABLET:"sapUxAPObjectPageLayout-Std-Tablet",DESKTOP:"sapUxAPObjectPageLayout-Std-Desktop",DESKTOP_XL:"sapUxAPObjectPageLayout-Std-Desktop-XL"};M.DYNAMIC_HEADERS_MEDIA={PHONE:"sapFDynamicPage-Std-Phone",TABLET:"sapFDynamicPage-Std-Tablet",DESKTOP:"sapFDynamicPage-Std-Desktop",DESKTOP_XL:"sapFDynamicPage-Std-Desktop-XL"};M.DIV="div";M.HEADER="header";M.FOOTER="section";M.HEADER_CONTENT_PADDING_BOTTOM=D.toPx("1rem");M.SHOW_FOOTER_CLASS_NAME="sapUxAPObjectPageFloatingFooterShow";M.HIDE_FOOTER_CLASS_NAME="sapUxAPObjectPageFloatingFooterHide";M.NO_NAVIGATION_CLASS_NAME="sapUxAPObjectPageNoNavigation";M.ARIA={LABEL_TOOLBAR_FOOTER_ACTIONS:"ARIA_LABEL_TOOLBAR_FOOTER_ACTIONS"};M.prototype._getFirstEditableInput=function(e){var t=this.getDomRef(e);return R(t)};M.prototype._focusFirstEditableInput=function(e){this._getFirstEditableInput(e).focus()};M._getNextTitleLevelEntry=function(e){var t=M.TITLE_LEVEL_AS_ARRAY.indexOf(e),i=t!==-1,o=i&&t!==M.TITLE_LEVEL_AS_ARRAY.length-1;if(!i){return x.Auto}return M.TITLE_LEVEL_AS_ARRAY[o?t+1:t]};M._getLibraryResourceBundle=function(){return r.getResourceBundleFor("sap.uxap")};M.prototype.init=function(){this._bFirstRendering=true;this._bDomReady=false;this._bPinned=false;this._bStickyAnchorBar=false;this._bHeaderInTitleArea=false;this._bHeaderExpanded=true;this._bHeaderBiggerThanAllowedHeight=false;this._bDelayDOMBasedCalculations=true;this._iStoredScrollTop=0;this._oStoredScrolledSubSectionInfo={};this._bAllContentFitsContainer=false;this._bIsFooterAanimationGoing=false;this._bInternalAnchorBarVisible=true;this._oVisibleSubSections=0;this._initialABButtonsColorUpdateDone=false;this._bDomElementsCached=false;this._$footerWrapper=[];this._$opWrapper=[];this._$anchorBar=[];this._$titleArea=[];this._$stickyAnchorBar=[];this._$headerContent=[];this._$stickyHeaderContent=[];this._bMobileScenario=false;this._oSectionInfo={};this._aSectionBases=[];this._sScrolledSectionId="";this._iScrollToSectionDuration=600;this._$spacer=[];this.iHeaderContentHeight=0;this.iStickyHeaderContentHeight=0;this.iHeaderTitleHeight=0;this.iHeaderTitleHeightStickied=0;this.iAnchorBarHeight=0;this.iFooterHeight=0;this.iTotalHeaderSize=0;this._iHeaderContentPaddingBottom=0;this._oScrollContainerLastState={};this._iREMSize=parseInt(jQuery("body").css("font-size"));this._iOffset=parseInt(.25*this._iREMSize);this._iResizeId=null;this._iAfterRenderingDomReadyTimeout=null;this._oABHelper=new T(this);this._initializeScroller();this._attachSnapListeners();this._initRangeSet();this._attachMediaContainerWidthChange(this._onMediaRangeChange,this,M.MEDIA_RANGESET_NAME);this._oHeaderContentDelegate={onBeforeRendering:this._setSectionInfoIsDirty.bind(this,true)}};M.prototype.onBeforeRendering=function(){var e,t;this._deregisterScreenSizeListener();this._deregisterTitleSizeListener();if(this._oLazyLoading){this._oLazyLoading.destroy()}this._oLazyLoading=new y(this);this._deregisterCustomEvents();if(!this.getVisible()){return}if(!this.getSelectedSection()){this._bHeaderExpanded=true}this._bMobileScenario=C.Utilities.isPhoneScenario(this._getCurrentMediaContainerRange());this._bTabletScenario=C.Utilities.isTabletScenario(this._getCurrentMediaContainerRange());if(this._checkAlwaysShowContentHeader()){this._bHeaderExpanded=true}this._bHeaderInTitleArea=this._shouldPreserveHeaderInTitleArea();this._createHeaderContent();this._getHeaderContent().setContentDesign(this._getHeaderDesign());this._oABHelper._getAnchorBar().toggleStyleClass("sapUxAPAnchorBarUpperCase",this.getUpperCaseAnchorBar());this._storeScrollLocation();this._applyUxRules();if(!O(this._oSectionInfo)&&this._bFirstRendering){this._preloadSectionsOnBeforeFirstRendering();this._bFirstRendering=false}this._bStickyAnchorBar=this._shouldPreserveHeaderInTitleArea();this._handleExpandButtonPressEventLifeCycle(false);this._attachTitlePressHandler();e=this._getHeaderContent();if(e&&e.supportsPinUnpin()){t=this.getHeaderContentPinnable()&&!this.getPreserveHeaderStateOnScroll();this._getHeaderContent().setPinnable(t);if(t){this._attachPinPressHandler()}}this._attachVisualIndicatorsPressHandlers(this._handleDynamicTitlePress,this);if(g.system.desktop){this._attachVisualIndicatorMouseOverHandlers(this._addHoverClass,this._removeHoverClass,this);this._attachTitleMouseOverHandlers(this._addHoverClass,this._removeHoverClass,this)}if(this.getFooter()&&this._bIsFooterAanimationGoing){this._onToggleFooterAnimationEnd(this.getFooter())}this._$titleArea=[];this._setFooterAriaLabelledBy()};M.prototype._setFooterAriaLabelledBy=function(){var e=this.getFooter();if(e&&!e.getAriaLabelledBy().length){this._oInvisibleText=new d({id:e.getId()+"-FooterActions-InvisibleText",text:M._getLibraryResourceBundle().getText(M.ARIA.LABEL_TOOLBAR_FOOTER_ACTIONS)}).toStatic();e.addAriaLabelledBy(this._oInvisibleText)}};M.prototype._destroyInvisibleText=function(){if(this._oInvisibleText){this._oInvisibleText.destroy();this._oInvisibleText=null}};M.prototype.setBackgroundDesignAnchorBar=function(e){var t=this.getBackgroundDesignAnchorBar();if(t===e){return this}this.setProperty("backgroundDesignAnchorBar",e);this._oABHelper._getAnchorBar().setBackgroundDesign(e);return this};M.prototype.setToggleHeaderOnTitleClick=function(e){var t=this.getHeaderTitle(),i=this.setProperty("toggleHeaderOnTitleClick",e,true);if(!t||!t.supportsToggleHeaderOnTitleClick()){P.warning("Setting toggleHeaderOnTitleClick will not take effect as it is not supported in the ObjectPageHeader, read the API Doc for more information",this);return i}e=this.getProperty("toggleHeaderOnTitleClick");this._updateToggleHeaderVisualIndicators();this._updateTitleVisualState();return i};M.prototype._attachTitlePressHandler=function(){var e=this.getHeaderTitle();if(k(e)&&!this._bAlreadyAttachedTitlePressHandler){e.attachEvent(M.EVENTS.TITLE_PRESS,this._handleDynamicTitlePress,this);this._bAlreadyAttachedTitlePressHandler=true}};M.prototype._attachSnapListeners=function(){j.forEach(function(e){this.attachEvent(e,function(){this.fireEvent("_snapChange")})},this)};M.prototype._toggleHeaderVisibility=function(e){var t=this._getHeaderContent();if(k(t)){t.$().toggleClass("sapUxAPObjectPageHeaderContentHidden",!e)}};M.prototype._snapHeader=function(e,t){var i,o=this._getHeaderContent();if(o&&o.supportsPinUnpin()&&this._bPinned){this._unPin(t);o._togglePinButton(false);e=true}this._toggleHeaderTitle(false,true);this._toggleHeaderVisibility(e);this._moveAnchorBarToTitleArea();if(e){this._moveHeaderToContentArea();this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators();this._adjustHeaderHeights();this._requestAdjustLayout(true);i=this._$opWrapper.scrollTop()<=this._getSnapPosition()+1;if(i){this._scrollTo(this._getSnapPosition()+1)}return}this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators();this._adjustHeaderHeights();this._requestAdjustLayout()};M.prototype._expandHeader=function(e){this._toggleHeaderTitle(true,true);this._toggleHeaderVisibility(true);if(e){this._moveAnchorBarToTitleArea();this._moveHeaderToTitleArea();this._bHeaderExpanded=true;this._updateToggleHeaderVisualIndicators();this._adjustHeaderHeights();this._requestAdjustLayout();return}this._moveAnchorBarToContentArea();this._moveHeaderToContentArea();this._scrollTo(0,0);this._bHeaderExpanded=true;this._adjustHeaderHeights();this._updateToggleHeaderVisualIndicators();if(this._isHeaderPinnable()){this._getHeaderContent()._getPinButton().setVisible(!this._headerBiggerThanAllowedToBeExpandedInTitleArea())}};M.prototype._handleDynamicTitlePress=function(){if(!this.getToggleHeaderOnTitleClick()||!this._hasVisibleDynamicTitleAndHeader()){return}var e=!this._bHeaderExpanded,t,i,o;if(e){t=this._$opWrapper.scrollTop()<=this._getSnapPosition()+1;i=!this._headerBiggerThanAllowedToBeExpandedInTitleArea()&&(this._shouldPreserveHeaderInTitleArea()||!t);this._expandHeader(i);if(!i){this._scrollTo(0,0)}}else{o=!this._shouldPreserveHeaderInTitleArea()&&(!this._bAllContentFitsContainer||this._headerBiggerThanAllowedToBeExpandedInTitleArea());this._snapHeader(o,true)}this.getHeaderTitle()._getFocusSpan().trigger("focus")};M.prototype._attachPinPressHandler=function(){var e=this._getHeaderContent();if(k(e)&&!this._bAlreadyAttachedPinPressHandler){e.attachEvent(M.EVENTS.PIN_UNPIN_PRESS,this._onPinUnpinButtonPress,this);this._bAlreadyAttachedPinPressHandler=true}};M.prototype._handleExpandButtonPressEventLifeCycle=function(e){var t=this.getHeaderTitle(),i=this._hasDynamicTitle(),o;if(t&&!i){o=t.getAggregation("_expandButton");if(o){o[e?"attachPress":"detachPress"](this._handleExpandButtonPress,this)}}};M.prototype._adjustSelectedSectionByUXRules=function(){var e=o.getElementById(this.getSelectedSection()),t=e&&this._sectionCanBeRenderedByUXRules(e);if(!t){if(this._oFirstVisibleSection){e=this._oFirstVisibleSection;this.setAssociation("selectedSection",e.getId(),true)}else{this.setAssociation("selectedSection",null,true);return}}};M.prototype._sectionCanBeRenderedByUXRules=function(e){if(!(e instanceof p)){return false}var t=e.getBindingInfo("subSections");if(!t&&(!e.getVisible()||!e._getInternalVisible())){return false}var i=this._aSectionBases.map(function(e){return e.getId()});return i.indexOf(e.getId())>-1};M.prototype._getSectionsToRender=function(){this._adjustSelectedSectionByUXRules();var e=o.getElementById(this.getSelectedSection());if(this.getUseIconTabBar()&&e){return[e]}else{return this.getSections()}};M.prototype._preloadSectionsOnBeforeFirstRendering=function(){var e=this._getSectionsToPreloadOnBeforeFirstRendering();this._connectModelsForSections(e).then(function(){if(this.getEnableLazyLoading()){e.forEach(function(e){this.fireEvent("subSectionPreload",{subSection:e})},this)}}.bind(this))};M.prototype._getSectionsToPreloadOnBeforeFirstRendering=function(){var e,t,i;if(!this.getEnableLazyLoading()){return this._getSectionsToRender()}if(this.getUseIconTabBar()){return this._oLazyLoading.getSubsectionsToPreload(this._grepCurrentTabSectionBases())}this._adjustSelectedSectionByUXRules();t=o.getElementById(this.getSelectedSection());if(!t||t===this._oFirstVisibleSection){return this._oLazyLoading.getSubsectionsToPreload(this._aSectionBases)}i=this.indexOfSection(t);var n=function(e){var t=e.isA("sap.uxap.ObjectPageSection")?e:e.getParent();return this.indexOfSection(t)>=i}.bind(this);e=this._aSectionBases.filter(n);return this._oLazyLoading.getSubsectionsToPreload(e)};M.prototype._grepCurrentTabSectionBases=function(){var e=[],t,i,n,r;this._adjustSelectedSectionByUXRules();t=o.getElementById(this.getSelectedSection());if(t){i=t.getId();this._aSectionBases.forEach(function(t){n=t.getParent();r=n&&n.getId();if(t.getId()===i||r===i){e.push(t)}})}return e};M.prototype.onAfterRendering=function(){var e=this._getHeaderContent(),t=this._getWidth(this);this._bInvalidatedAndNotRerendered=false;this._ensureCorrectParentHeight();this._cacheDomElements();this._iResizeId=l.register(this,this._onUpdateScreenSize.bind(this));this._iTitleResizeId=l.register(this._$titleArea.get(0),this._adjustTitlePositioning.bind(this));if(this._hasDynamicTitle()){this.addStyleClass("sapUxAPObjectPageHasDynamicTitle")}if(t>0){this._updateMedia(t,M.MEDIA)}this._$opWrapper.on("scroll.OPL",this._onScroll.bind(this));if(this._bDomReady&&this.$().parents(":hidden").length===0){this._onAfterRenderingDomReady()}else{if(this._iAfterRenderingDomReadyTimeout){clearTimeout(this._iAfterRenderingDomReadyTimeout)}this._iAfterRenderingDomReadyTimeout=setTimeout(this._onAfterRenderingDomReady.bind(this),this._getDOMCalculationDelay());this._adjustTitlePositioning()}if(e&&e.supportsPinUnpin()){this._updatePinButtonState()}this._handleExpandButtonPressEventLifeCycle(true);if(k(e)&&e._setLandmarkInfo){e._setLandmarkInfo(this.getLandmarkInfo())}};M.prototype._onAfterRenderingDomReady=function(){var e,t,i,r,s=this._getWidth(this);if(this._bIsBeingDestroyed){return}this._adjustSelectedSectionByUXRules();e=this.getSelectedSection();t=o.getElementById(e);this._iAfterRenderingDomReadyTimeout=null;this._bDomReady=true;this._adjustHeaderHeights();this._initAnchorBarScroll();if(e){if(this.getUseIconTabBar()){this._setSelectedSectionId(e);this._setCurrentTabSection(t);this._bAllContentFitsContainer=this._hasSingleVisibleFullscreenSubSection(t);this._checkSubSectionVisibilityChange()}else{r=t?.getSelectedSubSection();this.scrollToSection(r||e,0)}}this._toggleScrolling(this._shouldAllowScrolling());this._registerOnContentResize();this.getHeaderTitle()&&this._shiftHeaderTitle();this.getFooter()&&this._shiftFooter();this._setSectionsFocusValues();if(this.getPreserveHeaderStateOnScroll()){this._overridePreserveHeaderStateOnScroll()}if(!this._bHeaderExpanded){i=!this._shouldPreserveHeaderInTitleArea()&&!this._bAllContentFitsContainer;this._snapHeader(i)}this._restoreScrollPosition();n.getInstance().publish("sap.ui","ControlForPersonalizationRendered",this);this._updateMedia(s,M.MEDIA);if(this._hasDynamicTitle()){this._updateMedia(s,M.DYNAMIC_HEADERS_MEDIA)}this._updateToggleHeaderVisualIndicators();this._updateTitleVisualState();this.fireEvent("onAfterRenderingDOMReady")};M.prototype.onfocusfail=function(e){var t=e.srcControl;if(t===this.getAggregation("footer")&&!t.getVisible()){return}c.prototype.onfocusfail.apply(this,arguments)};M.prototype._toggleScrolling=function(e){if(this._$opWrapper.length){this._$opWrapper.get(0).style.overflowY=e?"auto":"hidden"}};M.prototype._shouldAllowScrolling=function(){return!this._bAllContentFitsContainer||!this._getFirstVisibleSubSection()?._hasRestrictedHeight()};M.prototype._shiftFooter=function(){var e=this.$("footerWrapper"),t=this._calculateShiftOffset();e.css(t.sStyleAttribute,t.iMarginalsOffset+"px")};M.prototype._calculateShiftOffset=function(){var t=0,i=e.getRTL()?"left":"right",o=this._hasVerticalScrollBar(),n=this._iOffset,r;if(g.system.desktop){r=g.browser.firefox?M.SCROLLBAR_SIZE_FF:E().width;t=r;if(!o){t=0;n+=r}}return{sStyleAttribute:i,iActionsOffset:n,iMarginalsOffset:t}};M.prototype._getDOMCalculationDelay=function(){return this._bDelayDOMBasedCalculations?M.HEADER_CALC_DELAY:0};M.prototype.exit=function(){if(this._oScroller){this._oScroller.destroy();this._oScroller=null}if(this._oLazyLoading){this._oLazyLoading.destroy();this._oLazyLoading=null}if(this._asyncUpdateScreenSizeExec){clearTimeout(this._asyncUpdateScreenSizeExec)}this._destroyInvisibleText();this._deregisterScreenSizeListener();this._deregisterTitleSizeListener();if(this._iContentResizeId){l.deregister(this._iContentResizeId)}if(this._iAfterRenderingDomReadyTimeout){clearTimeout(this._iAfterRenderingDomReadyTimeout)}if(this._oObserver){this._oObserver.disconnect();this._oObserver=null}this._deregisterCustomEvents();this._oFirstVisibleSection=null;this._oFirstVisibleSubSection=null};M.prototype.setShowOnlyHighImportance=function(e){var t=this.getShowOnlyHighImportance();if(t!==e){this.setProperty("showOnlyHighImportance",e,true);this.getSections().forEach(function(e){e._updateImportance()})}return this};M.prototype.setIsHeaderContentAlwaysExpanded=function(e){var t=this.getAlwaysShowContentHeader();var i=g.system.phone||g.system.tablet;if(t!==e){this.setProperty("alwaysShowContentHeader",e,i)}return this};M.prototype.setShowEditHeaderButton=function(e){var t=this.getShowEditHeaderButton(),i=this.getAggregation("_headerContent");if(t!==e){this.setProperty("showEditHeaderButton",e,true);i&&i.invalidate()}return this};M.prototype._initializeScroller=function(){if(this._oScroller){return}this._oScroller=new _(this,this.getId()+"-scroll",{horizontal:false,vertical:true});this._oScroller.setOnAfterScrollToElement(this._onAfterScrollToElement.bind(this))};M.prototype._onAfterScrollToElement=function(){var e=this._$opWrapper.scrollTop(),t=this._bStickyAnchorBar;this._onScroll({target:{scrollTop:e}});if(this._bStickyAnchorBar&&!t&&this._$opWrapper.scrollTop()===e){this._$opWrapper.scrollTop(e-this.iAnchorBarHeight)}};M.prototype.setSelectedSection=function(e){var t,i;if(e instanceof p){e=e.getId()}else if(e!=null&&typeof e!=="string"){v(false,"setSelectedSection(): sId must be a string, an instance of sap.uxap.ObjectPageSection or null");return this}if(e===this.getSelectedSection()){return this}if(e===null){this.setAssociation("selectedSection",null,true);this._expandHeader(this._bHeaderInTitleArea);this._selectFirstVisibleSection();return this}this.scrollToSection(e);t=S._getClosestSection(e);i=t instanceof S?t.getId():t;this.setDirectScrollingToSection(i);return this.setAssociation("selectedSection",i,true)};M.prototype._selectFirstVisibleSection=function(){if(this.getUseIconTabBar()&&this._oFirstVisibleSection){this._adjustSelectedSectionByUXRules();this._setCurrentTabSection(this._oFirstVisibleSection);this._bAllContentFitsContainer=this._hasSingleVisibleFullscreenSubSection(this._oFirstVisibleSection);this._preloadSectionsOnBeforeScroll(this._oFirstVisibleSection);this._updateSelectionOnScroll(0);this._checkSubSectionVisibilityChange()}else if(this.$().is(":visible")){this._scrollTo(0,0);if(!this._bInvalidatedAndNotRerendered){this._sScrolledSectionId=null;this._updateSelectionOnScroll(0)}}};M.prototype._ensureCorrectParentHeight=function(){if(this._bCorrectParentHeightIsSet){return}if(this.getParent().getHeight&&["","auto"].indexOf(this.getParent().getHeight())!==-1){this.$().parent().css("height","100%")}this._bCorrectParentHeightIsSet=true};M.prototype._cacheDomElements=function(){this._$footerWrapper=this.$("footerWrapper");this._$titleArea=this.$("headerTitle");this._$anchorBar=this.$("anchorBar");this._$stickyAnchorBar=this.$("stickyAnchorBar");this._$opWrapper=this.$("opwrapper");this._$spacer=this.$("spacer");this._$headerContent=this.$("headerContent");this._$stickyHeaderContent=this.$("stickyHeaderContent");this._$contentContainer=this.$("scroll");this._$sectionsContainer=this.$("sectionsContainer");this._oScroller._$Container=this._$opWrapper;this._bDomElementsCached=true};M.prototype._handleExpandButtonPress=function(e){this._expandHeader(true)};M.prototype._toggleHeaderTitle=function(e,t){var i=this.getHeaderTitle();if(this._$titleArea.length){this._$titleArea.toggleClass("sapUxAPObjectPageHeaderStickied",!e);this._$titleArea.toggleClass("sapUxAPObjectPageHeaderSnappedTitleOnMobile",this._hasDynamicTitleWithSnappedTitleOnMobile()&&!e)}if(e){i&&i.unSnap(t)}else{i&&i.snap(t)}};M.prototype._moveHeaderToTitleArea=function(){this._$headerContent.children().appendTo(this._$stickyHeaderContent);this._bHeaderInTitleArea=true;this.fireEvent("_moveHeader",{fixed:true});this._bSupressModifyOnScrollOnce=true};M.prototype._moveHeaderToContentArea=function(){if(this._bHeaderInTitleArea){this._$headerContent.append(this._$stickyHeaderContent.children());this._$stickyHeaderContent.children().remove();this._bHeaderInTitleArea=false;this.fireEvent("_moveHeader",{fixed:false});return true}return false};M.prototype._updateNavigation=function(){if(this.getShowAnchorBar()){this._oABHelper._buildAnchorBar()}};M.prototype._applyUxRules=function(e){var t,i,n,r,s,a,l,h,c,d={};t=this.getSections()||[];r=0;a=this.getShowAnchorBar();l=this.getUseIconTabBar();h=null;this._cleanMemory();t.forEach(function(t){if(!t.getVisible()){return true}t.removeStyleClass("sapUxAPObjectPageSectionFirstVisible");this._registerSectionBaseInfo(t);i=t.getSubSections()||[];n=0;c=null;if(this._shouldApplySectionTitleLevel(t)){t._setInternalTitleLevel(this._determineSectionBaseInternalTitleLevel(t),e)}i.forEach(function(t){if(!t.getVisible()){return true}this._registerSectionBaseInfo(t);s=t.getVisibleBlocksCount();if(s===0){t._setInternalVisible(false,e);P.info("ObjectPageLayout :: noVisibleBlock UX rule matched","subSection "+t.getTitle()+" forced to hidden")}else{t._setInternalVisible(true,e);n++;if(!c){c=t}if(this._shouldApplySectionTitleLevel(t)){t._setInternalTitleLevel(this._determineSectionBaseInternalTitleLevel(t),e)}}},this);if(n>1){t._setHasPromotedSubSection(false,e);i.forEach(function(t){t._setIsPromoted(false,e)})}if(n==0){t._setInternalVisible(false,e);P.info("ObjectPageLayout :: noVisibleSubSection UX rule matched","section "+t.getTitle()+" forced to hidden")}else{t._setInternalVisible(true,e);d[t.getId()]=true;if(!h){h=t;h.addStyleClass("sapUxAPObjectPageSectionFirstVisible")}var o=this.getSubSectionLayout()===$.TitleOnTop&&n===1&&c.getTitle().trim()!=="";if(o){c._setIsPromoted(true,e);t._setHasPromotedSubSection(true,e)}if(n===1&&!c.getTitle().trim()){c._setBorrowedTitleDomId(t.getId()+"-title")}r++}if(l){d[t.getId()]=false;t.addStyleClass("sapUxAPObjectPageSectionFirstVisible")}},this);if(r<=1){a=false;P.info("ObjectPageLayout :: notEnoughVisibleSection UX rule matched","anchorBar forced to hidden");if(l&&h){d[h.getId()]=true}}this.toggleStyleClass(M.NO_NAVIGATION_CLASS_NAME,r<=1);Object.keys(d).forEach(function(t){o.getElementById(t)._setInternalTitleVisible(d[t],e)});if(a){this._oABHelper._buildAnchorBar()}this._setInternalAnchorBarVisible(a,e);this._oFirstVisibleSection=h;this._oFirstVisibleSubSection=this._getFirstVisibleSubSection(h);this._bAllContentFitsContainer=r===1&&n===1&&this._oFirstVisibleSubSection.hasStyleClass(f.FIT_CONTAINER_CLASS);this._checkSubSectionVisibilityChange()};M.prototype._checkSubSectionVisibilityChange=function(){var e=this.getUseIconTabBar(),t=e&&o.getElementById(this.getSelectedSection()),i=t?[t]:this._getVisibleSections(),n={},r;i.forEach(function(e){e.getSubSections().forEach(function(e){r=e.getVisible()&&e._getInternalVisible();if(r){n[e.getId()]=e}})});if(B(Object.keys(this._oVisibleSubSections),Object.keys(n)).length){this._oVisibleSubSections=n;this.fireEvent("subSectionVisibilityChange",{visibleSubSections:n})}};M.prototype.setUseIconTabBar=function(e){var t=this.getUseIconTabBar();if(e!=t){this._applyUxRules()}this.setProperty("useIconTabBar",e);this.toggleStyleClass("sapUxAPObjectPageLayoutIconTabBar",e);return this};M.prototype._setCurrentTabSection=function(e,t){if(!e){return}var i;if(V.isObjectA(e,"sap.uxap.ObjectPageSubSection")){i=e;e=e.getParent()}else{i=this._getFirstVisibleSubSection(e)}if(this._oCurrentTabSection!==e){this._renderSection(e);this._oCurrentTabSection=e}this._oCurrentTabSubSection=i};M.prototype._renderSection=function(e){var t=this.$().find(".sapUxAPObjectPageContainer"),i;if(e&&t.length){i=(new s).getInterface();this.getSections().forEach(function(t){if(t.getId()===e.getId()){i.renderControl(e)}else{i.cleanupControlWithoutRendering(t)}});i.flush(t[0]);i.destroy()}};M.prototype._isLazyLoadingEffectivelyEnabled=function(){return this.getEnableLazyLoading()||this.getUseIconTabBar()};M.prototype.setShowAnchorBarPopover=function(e,t){var i=this.getProperty("showAnchorBarPopover"),e=this.validateProperty("showAnchorBarPopover",e),o=this.getSelectedSection();if(e===i){return this}this.setProperty("showAnchorBarPopover",e,true);this._oABHelper._buildAnchorBar();this._setSelectedSectionId(o);return this};M.prototype._getInternalAnchorBarVisible=function(){return this._bInternalAnchorBarVisible};M.prototype._setInternalAnchorBarVisible=function(e,t){if(e!=this._bInternalAnchorBarVisible){this._bInternalAnchorBarVisible=e;if(t===true){this.invalidate()}}};M.prototype.setUpperCaseAnchorBar=function(e){this._oABHelper._getAnchorBar().toggleStyleClass("sapUxAPAnchorBarUpperCase",e);return this.setProperty("upperCaseAnchorBar",e,true)};M.prototype._requestAdjustLayout=function(e){if(!this._oLayoutTask){this._oLayoutTask=new H(this._updateScreenHeightSectionBasesAndSpacer,M.DOM_CALC_DELAY,this)}if(!e){P.debug("ObjectPageLayout :: _requestAdjustLayout","delayed by "+M.DOM_CALC_DELAY+" ms because of dom modifications")}return this._oLayoutTask.reSchedule(e,{}).catch(function(e){})};M.prototype._requestAdjustLayoutAndUxRules=function(e){if(!this._oUxRulesTask){this._oUxRulesTask=new H(this._adjustLayoutAndUxRules,M.DOM_CALC_DELAY,this)}if(!e){P.debug("ObjectPageLayout :: _requestAdjustLayoutAndUxRules","delayed by "+M.DOM_CALC_DELAY+" ms because of dom modifications")}return this._oUxRulesTask.reSchedule(e,{}).catch(function(e){})};M.prototype._adjustLayoutAndUxRules=function(){var e,t,i,n;P.debug("ObjectPageLayout :: _requestAdjustLayout","refreshing ux rules");this._applyUxRules(true);this._adjustSelectedSectionByUXRules();e=this.getSelectedSection();i=o.getElementById(e);t=i?.getSelectedSubSection();if(i){this._setSelectedSectionId(e);if(this.getUseIconTabBar()){this._setCurrentTabSection(i);this._bAllContentFitsContainer=this._hasSingleVisibleFullscreenSubSection(i)}this._requestAdjustLayout(true);if(this.getEnableLazyLoading()&&this._oLazyLoading){this._oLazyLoading.doLazyLoading()}if(!this._isClosestScrolledSection(e)||this._hasOngoingScrollToSection()){n=e;if(i.indexOfSubSection(o.getElementById(this.getOngoingScrollToSectionBaseId()))>-1){n=this.getOngoingScrollToSectionBaseId()}else if(t){n=t}this.scrollToSection(n,null,0,false,true)}}};M.prototype._isClosestScrolledSection=function(e){var t=this._$opWrapper.length>0?this._$opWrapper.scrollTop():0,i=this.iScreenHeight,n=this._getClosestScrolledSectionBaseId(t,i),r=o.getElementById(n),s=S._getClosestSection(r);return s&&e===s.getId()};M.prototype._hasOngoingScrollToSection=function(e){return this._oScroller._$Container&&this._oScroller._$Container.is(":animated")&&this.getOngoingScrollToSectionBaseId()};M.prototype._setSelectedSectionId=function(e){var t=this.getAggregation("_anchorBar"),i=e&&this._oSectionInfo[e];if(!i){return}if(t){this._oABHelper.selectAnchorForSection(e);this.setAssociation("selectedSection",e,true)}};M.prototype.isFirstRendering=function(){return this._bFirstRendering};M.prototype._cleanMemory=function(){this._oSectionInfo={};this._aSectionBases=[]};M.prototype._registerSectionBaseInfo=function(e){this._oSectionInfo[e.getId()]={$dom:[],positionTop:0,buttonId:"",isSection:e instanceof S,sectionReference:e};this._aSectionBases.push(e)};M.prototype._triggerVisibleSubSectionsEvents=function(){var e=this.getSelectedSection(),t=o.getElementById(e),i=t?.getSelectedSubSection(),n=this._bDomElementsCached;this._bDelayDOMBasedCalculations=false;if(i&&n&&this._oSectionInfo[i]?.positionTop!==this._$opWrapper.scrollTop()){this.scrollToSection(i,0)}else if(e&&n&&this._oSectionInfo[e]?.positionTop!==this._$opWrapper.scrollTop()){this.scrollToSection(e,0)}if(this.getEnableLazyLoading()&&this._oLazyLoading){this._oLazyLoading._triggerVisibleSubSectionsEvents()}};M.prototype.scrollToSection=function(e,n,r,s,a){var l=o.getElementById(e),h,c,d=i.getAnimationMode()!==t.none,g,u,_,p;if(!this.getDomRef()){P.warning("scrollToSection can only be used after the ObjectPage is rendered",this);return}if(!l){P.warning("scrollToSection aborted: unknown section",e,this);return}if(!this._oSectionInfo[e]||!l._getInternalVisible()){P.warning("scrollToSection aborted: section is hidden by UX rules",e,this);return}if(this.bIsDestroyed){P.debug("ObjectPageLayout :: scrollToSection","scrolling canceled as page is being destroyed");return}if(this.getUseIconTabBar()){var b=S._getClosestSection(l);var y=this._bAllContentFitsContainer,T;this._bAllContentFitsContainer=this._hasSingleVisibleFullscreenSubSection(b);T=this._bAllContentFitsContainer!==y;if(T&&!this._bHeaderExpanded){this._snapHeader(!this._bAllContentFitsContainer);this._bSupressModifyOnScrollOnce=true}if(this._oCurrentTabSection){this._oCurrentTabSection._allowPropagationToLoadedViews(false)}b._allowPropagationToLoadedViews(true);this._setCurrentTabSection(l);this._oABHelper.selectAnchorForSection(b.getId());this.setAssociation("selectedSection",b.getId(),true);this._checkSubSectionVisibilityChange()}c=l instanceof f?l:this._getFirstVisibleSubSection(l);r=r||0;l._expandSection();this._requestAdjustLayout(true);n=this._computeScrollDuration(n,l);g=d&&n>0;var H=this._computeScrollPosition(l);if(H>this._getSnapPosition()&&this._bHeaderInTitleArea&&!this._shouldPreserveHeaderInTitleArea()&&!this._bAllContentFitsContainer){var A=this._moveHeaderToContentArea();this._toggleHeaderTitle(false);this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators();A&&(H+=this._$headerContent.height())}if(this._sCurrentScrollId!=e||a){this._sCurrentScrollId=e;if(this._iCurrentScrollTimeout){clearTimeout(this._iCurrentScrollTimeout);if(this._$contentContainer){this._$contentContainer.parent().stop(true,false)}}if(this._bDomElementsCached){this._iCurrentScrollTimeout=setTimeout(function(){this._sCurrentScrollId=undefined;this._iCurrentScrollTimeout=undefined}.bind(this),n)}this._preloadSectionsOnBeforeScroll(l);H+=r;if(!this._bStickyAnchorBar&&this._shouldSnapHeaderOnScroll(H)){h=this._getSnapPosition();this._scrollTo(h,0);if(h===0){this._toggleHeader(true)}}u=g&&this.getEnableLazyLoading()&&this._oLazyLoading;_=function(e,t,i){t&&this.setOngoingScrollToSectionBaseId(e);i&&this._oLazyLoading.suppress()}.bind(this,e,g,u);p=function(e){if(e===this.getOngoingScrollToSectionBaseId()){this.setOngoingScrollToSectionBaseId(null);this._resumeLazyLoading()}}.bind(this,e);this._scrollTo(H,n,_,p);if(s){this.fireNavigate({section:S._getClosestSection(l),subSection:c})}}};M.prototype.onAnchorBarTabPress=function(e){var t=o.getElementById(e),i=t.isA("sap.uxap.ObjectPageSubSection"),n,r;if(!t){return}n=i?t.getParent():t;r=i?t:null;var s=this.fireBeforeNavigate({section:n,subSection:r});if(!s){return}this.setDirectScrollingToSection(n.getId());this._iCurrentScrollPositionWhenTabPressed=this._$opWrapper.length&&this._$opWrapper.scrollTop();this.scrollToSection(t.getId(),null,0,true);n.setAssociation("selectedSubSection",r,true);this.setAssociation("selectedSection",n,true);this._iCurrentScrollPositionWhenTabPressed=0};M.prototype._hasSingleVisibleFullscreenSubSection=function(e){var t=e.getSubSections().filter(function(e){return e.getVisible()&&e._getInternalVisible()&&e.getBlocks().length>0});return t.length===1&&t[0].hasStyleClass(f.FIT_CONTAINER_CLASS)};M.prototype._computeScrollDuration=function(e,t){var i=parseInt(e);i=i>=0?i:this._iScrollToSectionDuration;if(this.getUseIconTabBar()&&(t instanceof S||this._isFirstVisibleSectionBase(t))&&this._bStickyAnchorBar){i=0}return i};M.prototype._computeScrollPosition=function(e){var t=this._oSectionInfo[e.getId()].positionTop,i=this._bHeaderExpanded;if(i&&this._isFirstVisibleSectionBase(e)){t=this._iCurrentScrollPositionWhenTabPressed&&this._iCurrentScrollPositionWhenTabPressed<t?this._iCurrentScrollPositionWhenTabPressed:0}return t};M.prototype._preloadSectionsOnBeforeScroll=function(e){var t=e.getId(),i;if(!this.getEnableLazyLoading()&&this.getUseIconTabBar()){i=e instanceof S?e:e.getParent();this._connectModelsForSections([i])}if(this.getEnableLazyLoading()){var o=this.getUseIconTabBar()?this._grepCurrentTabSectionBases():this._aSectionBases;i=this._oLazyLoading.getSubsectionsToPreload(o,t);if(g.system.desktop){setTimeout(function(){this._doConnectModelsForSections(i)}.bind(this),50)}else{this._doConnectModelsForSections(i)}}};M.prototype._doConnectModelsForSections=function(e){this._connectModelsForSections(e).then(()=>this._fireSubSectionEnteredViewPortEvent(e))};M.prototype._fireSubSectionEnteredViewPortEvent=function(e){e.forEach(function(e){this.fireEvent("subSectionEnteredViewPort",{subSection:e})},this)};M.prototype.getScrollingSectionId=function(){return this._sScrolledSectionId};M.prototype.setDirectScrollingToSection=function(e){this.sDirectSectionId=e};M.prototype.getDirectScrollingToSection=function(){return this.sDirectSectionId};M.prototype.setOngoingScrollToSectionBaseId=function(e){this.sOngoingScrollToSectionBaseId=e};M.prototype.getOngoingScrollToSectionBaseId=function(){return this.sOngoingScrollToSectionBaseId};M.prototype.clearDirectScrollingToSection=function(){this.sDirectSectionId=null};M.prototype._scrollTo=function(e,t,i,o){if(this._oScroller&&this._bDomReady&&!this._bSuppressScroll){P.debug("ObjectPageLayout :: scrolling to "+e);if(t===0&&this._shouldSnapHeaderOnScroll(e)){this._toggleHeader(true)}i&&i();this._oScroller.scrollTo(0,e,t,o)}return this};M.prototype._resumeLazyLoading=function(){if(this._oLazyLoading){this._oLazyLoading.resume();this._oLazyLoading.lazyLoadDuringScroll(true)}};M.prototype._scrollBelowCollapseVisualIndicator=function(){var e=this._getHeaderContent(),t,i,o,n;if(!k(e)||!k(this._$opWrapper)){return}t=e._getCollapseButton().getDomRef();i=t.getBoundingClientRect().height;o=this._$opWrapper[0].getBoundingClientRect().height;n=t.offsetTop+i-o;this._scrollTo(n)};M.prototype._updateMedia=function(e,t){if(!e){return}var i=function(e){Object.keys(t).forEach(function(i){var o=t[i],n=e===o;this.toggleStyleClass(o,n)},this)}.bind(this),o=M.BREAK_POINTS;if(e<=o.PHONE){i(t.PHONE)}else if(e<=o.TABLET){i(t.TABLET)}else if(e<=o.DESKTOP){i(t.DESKTOP)}else{i(t.DESKTOP_XL)}};M.prototype._updateScreenHeightSectionBasesAndSpacer=function(){var e,t,i,n,r,s,a=this._bHeaderInTitleArea||!this._bHeaderExpanded,l,h,c,d=this.getDomRef(),g=this.getUseIconTabBar(),u=o.getElementById(this.getSelectedSection());if(!d||!this._bDomReady){return false}P.debug("ObjectPageLayout :: _updateScreenHeightSectionBasesAndSpacer","re-evaluating dom positions");this.iScreenHeight=this._getDOMRefHeight(d);if(this.iScreenHeight===0){return}if(g&&u){this._bAllContentFitsContainer=this._hasSingleVisibleFullscreenSubSection(u)}this.iFooterHeight=this._getFooterHeight();var _=-1;this._aSectionBases.forEach(function(e){var i=this._oSectionInfo[e.getId()],o=e.$(),s=false,a;if(!i||!o.length){return}if(!i.isSection){_++}i.$dom=o;var d=C.Utilities.getChildPosition(o,this._$contentContainer).top;i.positionTop=Math.ceil(d);if(!i.isSection&&(a=e.getParent())){s=a._getVisibleSubSections().length===1;if(s){var u=a.$().position().top;i.positionTop=Math.ceil(u)}}if(!this._bStickyAnchorBar&&!this._bHeaderInTitleArea){i.positionTop-=this.iAnchorBarHeight}if(this._bMobileScenario){var p=e.getParent();if(p instanceof S&&p._getIsHidden()){return}if(r){this._oSectionInfo[r].positionBottom=i.positionTop}r=e.getId();t=e}else{if(i.isSection){if(r){this._oSectionInfo[r].positionBottom=i.positionTop;if(n){this._oSectionInfo[n].positionBottom=i.positionTop}}r=e.getId();n=null}else{if(n){this._oSectionInfo[n].positionBottom=i.positionTop}n=e.getId();t=e}}if(!i.isSection){h=g||e.getParent()===this._oFirstVisibleSection;l=h&&_===0;c=e.hasStyleClass(f.FIT_CONTAINER_CLASS);e._setHeight(this._computeSubSectionHeight(l,c,e))}},this);if(t){e=this._computeLastVisibleHeight(t);if(this._bMobileScenario&&r){this._oSectionInfo[r].positionBottom=this._oSectionInfo[r].positionTop+e}else{if(n){this._oSectionInfo[n].positionBottom=this._oSectionInfo[n].positionTop+e}if(r&&n){this._oSectionInfo[r].positionBottom=this._oSectionInfo[n].positionTop+e}}s=this._bStickyAnchorBar||_>0||this._checkContentBottomRequiresSnap(t);if(this._bAllContentFitsContainer){s=false}if(s&&!this._shouldPreserveHeaderInTitleArea()){a=true}i=this._computeSpacerHeight(t,e,s,a);this._$spacer.height(i+"px");P.debug("ObjectPageLayout :: bottom spacer is now "+i+"px");L(this._oScrollContainerLastState,{iScrollableContentLength:Math.round(this._getScrollableContentLength()),iSpacerHeight:i})}this._adjustTitlePositioning();this._setSectionInfoIsDirty(false);this._updateSelectionOnScroll(this._$opWrapper.scrollTop());this._toggleScrolling(this._shouldAllowScrolling());return true};M.prototype._computeSubSectionHeight=function(e,t,i){var o,n,r,s,a,l;if(!t){return""}var h=this._bAllContentFitsContainer?this._bHeaderExpanded:e;o=this._getSectionsContainerHeight(h);if(this._bAllContentFitsContainer){n=this._$sectionsContainer[0].getBoundingClientRect();r=i.getDomRef().getBoundingClientRect();s=r.top-n.top;a=this.iFooterHeight+this._iREMSize;l=s+a;o-=l}return o+"px"};M.prototype._computeScrollableContentSize=function(e){var t=0;if(this._$contentContainer&&this._$contentContainer.length){t=this._$contentContainer[0].scrollHeight}if(!this._bStickyAnchorBar&&e){t-=this.iAnchorBarHeight}if(this._bStickyAnchorBar&&!e){t+=this.iAnchorBarHeight}return t};M.prototype._computeLastVisibleHeight=function(e){var t=this._bStickyAnchorBar||this._bHeaderInTitleArea;var i=this._getSectionPositionTop(e,t);return Math.floor(this._$spacer.position().top)-i};M.prototype._getStickyAreaHeight=function(e){if(e){return this.iHeaderTitleHeightStickied+this.iAnchorBarHeight}return this.iHeaderTitleHeight};M.prototype._getScrollableViewportHeight=function(e){return this.getDomRef().getBoundingClientRect().height-this._getStickyAreaHeight(e)};M.prototype._getSectionsContainerHeight=function(e){var t=!e,i=this._getScrollableViewportHeight(t);if(!t&&!this._bHeaderInTitleArea){i-=this.iHeaderContentHeight+this.iAnchorBarHeight}return i};M.prototype._getSectionPositionTop=function(e,t){var i=this._oSectionInfo[e.getId()].positionTop;if(!this._bStickyAnchorBar&&!this._bHeaderInTitleArea){i+=this.iAnchorBarHeight}return i};M.prototype._getSectionPositionBottom=function(e,t){var i=this._oSectionInfo[e.getId()].positionBottom;if(!t){i+=this.iAnchorBarHeight}return i};M.prototype._determineSectionBaseInternalTitleLevel=function(e){var t=this.getSectionTitleLevel(),i=e instanceof S;if(t===x.Auto){if(i){return x.H3}return x.H4}return i?t:M._getNextTitleLevelEntry(t)};M.prototype._shouldApplySectionTitleLevel=function(e){return e.getTitleLevel()===x.Auto};M.prototype._checkContentBottomRequiresSnap=function(e){var t=false;return this._getSectionPositionBottom(e,t)>this._getScrollableViewportHeight(t)+this._getSnapPosition()};M.prototype._computeSpacerHeight=function(e,t,i,o){var n,r;if(Object.keys(this._oVisibleSubSections).length===1&&this._bHeaderExpanded){n=0}else{r=this._getScrollableViewportHeight(o);if(i){r=Math.ceil(r);t=Math.floor(t)}else{t=this._$spacer.position().top}if(t<r){n=r-t}else{n=0}}if(this.iFooterHeight>n){n+=this.iFooterHeight}return n};M.prototype._isFirstVisibleSectionBase=function(e){var t,i,n,r=this.getSelectedSection(),s=this.getUseIconTabBar();if(!e||!e.getParent()){return}t=e.getId();if(s&&t===r){return true}if(s&&e.getParent().getId()===r){i=o.getElementById(r);n=this._getFirstVisibleSubSection(i);return n&&n.getId()===t}if(this._oFirstVisibleSection&&this._oFirstVisibleSubSection){return t===this._oFirstVisibleSection.getId()||t===this._oFirstVisibleSubSection.getId()}return false};M.prototype._getFirstVisibleSubSection=function(e){if(!e){e=this.getUseIconTabBar()?this._oCurrentTabSection:this._oFirstVisibleSection;if(!e){return}}var t;this._aSectionBases.every(function(i){if(i.getParent()&&i.getParent().getId()===e.getId()){t=i;return false}return true});return t};M.prototype._initAnchorBarScroll=function(){var e=o.getElementById(this.getSelectedSection()),t=e?.getSelectedSubSection(),i=o.getElementById(t),n,r=i&&this._oSectionInfo[t];this._requestAdjustLayout(true);n=e?this._computeScrollPosition(r&&i||e):0;this._sScrolledSectionId="";this._sCurrentScrollId="";this._onScroll({target:{scrollTop:n}},true)};M.prototype._setAsCurrentSection=function(e){var t,i,n,r;if(this._sScrolledSectionId===e){return}P.debug("ObjectPageLayout :: current section is "+e);this._sScrolledSectionId=e;t=this.getAggregation("_anchorBar");r=t&&this._getInternalAnchorBarVisible();i=o.getElementById(e);n=i&&i instanceof f&&(i.getTitle().trim()===""||i.getParent()._getIsHidden());if(n){e=i.getParent().getId();P.debug("ObjectPageLayout :: current section is a subSection with an empty or hidden title, selecting parent "+e)}if(i&&this._oSectionInfo[e]){r&&this._oABHelper.selectAnchorForSection(e);this.setAssociation("selectedSection",S._getClosestSection(e).getId(),true);this._setSectionsFocusValues(e)}};M.prototype._registerOnContentResize=function(){var e=this._$contentContainer.length&&this._$contentContainer[0];if(!e){return}if(this._iContentResizeId){l.deregister(this._iContentResizeId)}this._iContentResizeId=l.register(e,this._onUpdateContentSize.bind(this))};M.prototype._onUpdateContentSize=function(e){var t=e.size;this.iContentHeight=t.height;if(t.height===0||t.width===0){P.info("ObjectPageLayout :: not triggering calculations if height or width is 0");return}if(this.getPreserveHeaderStateOnScroll()){this._overridePreserveHeaderStateOnScroll()}this._adjustHeaderHeights();this._requestAdjustLayout(true);if(this.getEnableLazyLoading()&&this._oLazyLoading){this._oLazyLoading.doLazyLoading()}};M.prototype.triggerPendingLayoutUpdates=function(){if(this._hasPendingLayoutUpdate()){this._requestAdjustLayout(true)}};M.prototype._hasPendingLayoutUpdate=function(){return this._oLayoutTask&&this._oLayoutTask.isPending()||this._$contentContainer.length&&this._$contentContainer.get(0).offsetHeight!==this.iContentHeight};M.prototype._adjustTitlePositioning=function(t){if(!this._$titleArea?.length||!this._$opWrapper?.length){return}var i=this._$opWrapper.get(0),o=this._$titleArea.get(0),n=o.getBoundingClientRect().height,r=o.getBoundingClientRect().width,s=E().width,a;i.style.paddingTop=n+"px";i.style.scrollPaddingTop=n+"px";if(this._oScroller){this._oScroller.setScrollPaddingTop(n)}a="polygon(0px "+n+"px, "+Math.floor(r)+"px "+n+"px, "+Math.floor(r)+"px 0, 100% 0, 100% 100%, 0 100%)";if(e.getRTL()){a="polygon(0px 0px, "+s+"px 0px, "+s+"px "+n+"px, 100% "+n+"px, 100% 100%, 0 100%)"}i.style.clipPath=a;this.getHeaderTitle()&&this._shiftHeaderTitle()};M.prototype._onUpdateScreenSize=function(e){var t=this.getHeaderTitle(),i=this._getHeaderContent(),o=e.size.width,n=e.size.height,r=e.oldSize.height,s=n!==r,a,l=i&&i.supportsAlwaysExpanded()&&this.getAlwaysShowContentHeader();if(e.size.height===0||e.size.width===0){P.info("ObjectPageLayout :: not triggering calculations if height or width is 0");return}this._bMobileScenario=C.Utilities.isPhoneScenario(this._getCurrentMediaContainerRange());this._bTabletScenario=C.Utilities.isTabletScenario(this._getCurrentMediaContainerRange());if(!this._bDomReady){P.info("ObjectPageLayout :: cannot _onUpdateScreenSize before dom is ready");return}this._oLazyLoading.setLazyLoadingParameters();this._asyncUpdateScreenSizeExec=setTimeout(function(){if(l&&this._bHeaderInTitleArea!=this._checkAlwaysShowContentHeader()){this.invalidate()}if(this._bHeaderInTitleArea&&this._headerBiggerThanAllowedToBeExpandedInTitleArea()){if(this._isHeaderPinnable()){this._updatePinButtonState()}this._expandHeader(false);this._scrollTo(0,0)}else if(this._isHeaderPinnable()&&!this._headerBiggerThanAllowedToBeExpandedInTitleArea()){this._updatePinButtonState()}if(t&&t.isDynamic()){t._onResize(o);this._updateMedia(o,M.DYNAMIC_HEADERS_MEDIA)}this._updateMedia(o,M.MEDIA);this._adjustHeaderHeights();this._requestAdjustLayout(true);if(this.getFooter()&&this.getShowFooter()){this._shiftFooter()}a=this.getSelectedSection();if(r===0&&s&&!this._isClosestScrolledSection(a)){a!==null?this.scrollToSection(a,0):this._selectFirstVisibleSection()}this._scrollTo(this._$opWrapper.scrollTop(),0);if(r===0&&s&&this.getEnableLazyLoading()&&this._oLazyLoading&&!this._bDelayDOMBasedCalculations){this._oLazyLoading.doLazyLoading()}}.bind(this),this._getDOMCalculationDelay())};M.prototype._onUpdateHeaderTitleSize=function(e){if(e.size.height===0||e.size.width===0){P.info("ObjectPageLayout :: not triggering calculations if height or width is 0");return}if(!this._bDomReady){P.info("ObjectPageLayout :: cannot _onUpdateTitleSize before dom is ready");return}this._adjustHeaderHeights();this._requestAdjustLayout()};M.prototype._initRangeSet=function(){if(!g.media.hasRangeSet(M.MEDIA_RANGESET_NAME)){g.media.initRangeSet(M.MEDIA_RANGESET_NAME,[M.BREAK_POINTS.PHONE,M.BREAK_POINTS.TABLET,M.BREAK_POINTS.DESKTOP],"px",["phone","tablet","desktop"])}};M.prototype._onMediaRangeChange=function(){var e=this._getMediaContainerWidth();if(!e){return}if(this._hasDynamicTitle()){this._updateMedia(e,M.DYNAMIC_HEADERS_MEDIA)}this._updateMedia(e,M.MEDIA)};M.prototype._shouldSnapHeaderOnScroll=function(e){return e>0&&e>=this._getSnapPosition()&&!this._shouldPreserveHeaderInTitleArea()};M.prototype._getScrollableContentLength=function(){return this._$contentContainer.length?this._getDOMRefHeight(this._$contentContainer[0]):0};M.prototype._isContentScrolledToBottom=function(){return this._oScrollContainerLastState.iScrollableContentLength<=this._oScrollContainerLastState.iScrollTop+this._oScrollContainerLastState.iScrollableViewportHeight};M.prototype._isContentLengthDecreased=function(e){if(e){return e.iScrollableContentLength>this._oScrollContainerLastState.iScrollableContentLength&&e.iSpacerHeight===this._oScrollContainerLastState.iSpacerHeight}};M.prototype._canReachScrollTop=function(e,t){var i;t=t||0;i=this._oScrollContainerLastState.iScrollableContentLength+t+this._$contentContainer.get(0).offsetTop-this._oScrollContainerLastState.iScrollableViewportHeight;return i>=e};M.prototype._deregisterCustomEvents=function(){if(this._$opWrapper.length){this._$opWrapper.off(".OPL")}};M.prototype._deregisterScreenSizeListener=function(){if(this._iResizeId){l.deregister(this._iResizeId);this._iResizeId=null}};M.prototype._deregisterTitleSizeListener=function(){if(this._iTitleResizeId){l.deregister(this._iTitleResizeId);this._iTitleResizeId=null}};M.prototype._onScroll=function(e,t){var i=Math.max(Math.ceil(e.target.scrollTop),0),o=this._$opWrapper.length&&this._$opWrapper[0],n=this._$spacer.length&&this._$spacer[0],r=this._$spacer.height(),s,a=this.getHeaderTitle(),l=this._shouldSnapHeaderOnScroll(i),h=this._shouldPreserveHeaderInTitleArea(),c=false,d=this._oScrollContainerLastState;this._oScrollContainerLastState={iScrollTop:i,iScrollableContentLength:Math.round(this._getScrollableContentLength()),iScrollableViewportHeight:o.offsetHeight,iSpacerHeight:r};if(this._bSupressModifyOnScrollOnce){this._bSupressModifyOnScrollOnce=false;if(!t){return}}if(!o||!n){return}s=this.iScreenHeight;if(s===0){return}if(this._getSectionInfoIsDirty()){return}if(d&&this._isContentScrolledToBottom()&&this._isContentLengthDecreased(d)){var g=d.iScrollableContentLength-this._oScrollContainerLastState.iScrollableContentLength;if(!this._canReachScrollTop(d.iScrollTop)&&this._canReachScrollTop(d.iScrollTop,g)){var u=d.iScrollTop+this._oScrollContainerLastState.iScrollableViewportHeight,_=this._oScrollContainerLastState.iScrollableContentLength,p=u-_,S;if(p>0){S=r+p;this._$spacer.height(S+"px");this._scrollTo(d.iScrollTop);return}}}if(l&&!h){s-=this.iAnchorBarHeight+this.iHeaderTitleHeightStickied}if(this._bHeaderInTitleArea&&!h){this._moveHeaderToContentArea();this._toggleHeaderTitle(false);this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators();this._requestAdjustLayout()}if(!h&&(a&&this.getShowHeaderContent()||this.getShowAnchorBar())){this._toggleHeader(l,!!(e&&e.type==="scroll"))}if(!h){this._adjustHeaderTitleBackgroundPosition(i)}P.debug("ObjectPageLayout :: lazy loading : Scrolling at "+i,"----------------------------------------");this._updateSelectionOnScroll(i);if(this.getEnableLazyLoading()){this._oLazyLoading.lazyLoadDuringScroll(t,i,e.timeStamp,s)}if(a&&a.supportsTitleInHeaderContent()&&this.getShowHeaderContent()&&this.getShowTitleInHeaderContent()&&a.getShowTitleSelector()){if(i===0){this.$("scroll").css("z-index","1000");c=false}else if(!c){c=true;this.$("scroll").css("z-index","0")}}};M.prototype._updateSelectionOnScroll=function(e){var t=this.iScreenHeight,i,n,r,s;if(t===0){return}i=this._getClosestScrolledSectionBaseId(e,t);n=S._getClosestSection(i);r=n?n.getId():null;s=this._getClosestScrolledSectionBaseId(e,t,true);if(i){var a=this.getDirectScrollingToSection(),l=o.getElementById(a);if(i!==this._sScrolledSectionId){P.debug("ObjectPageLayout :: closest id "+i,"----------------------------------------");var a=this.getDirectScrollingToSection();if(a&&a!==r&&(l&&l.getDomRef()&&!this.isFirstRendering())){return}this.clearDirectScrollingToSection();this._setAsCurrentSection(i)}else if(r===this.getDirectScrollingToSection()){this.clearDirectScrollingToSection()}if(s!==this._sScrolledSubSectionId){var h=S._getClosestSection(i),c=o.getElementById(s);this._sScrolledSubSectionId=s;this.fireEvent("_sectionChange",{section:h,subSection:c});this.fireEvent("sectionChange",{section:h,subSection:c})}}};M.prototype._getSnapPosition=function(){var e=this.iHeaderContentHeight,t=this._getTitleHeightDelta();if(e){e-=Math.max(t,this._iHeaderContentPaddingBottom)}return e};M.prototype._getTitleHeightDelta=function(){var e=this.iHeaderTitleHeightStickied-this.iHeaderTitleHeight;e=Math.max(e,0);e=Math.min(e,M.MAX_SNAP_POSITION_OFFSET);return e};M.prototype._getClosestScrolledSectionBaseId=function(e,t,i){i=!!i;e=Math.ceil(e);var n=e+t,r,s=i||this._bMobileScenario;jQuery.each(this._oSectionInfo,function(t,a){var l,h,c,d,g,u=this.getSelectedSection();l=a.sectionReference;h=l.getParent();c=h instanceof S&&h._getIsHidden();if(this.getUseIconTabBar()&&u){g=o.getElementById(u);if(!g){return}if(a.isSection&&a.sectionReference!=g){return true}if(!a.isSection&&g.indexOfSubSection(a.sectionReference)<0){return true}}if(a.isSection||s&&!c){if(!r&&a.sectionReference._getInternalVisible()===true){d=this._getFirstVisibleSubSection(a.sectionReference);if(a.isSection&&i&&d){r=d.getId()}else{r=t}}if(a.isSection&&i){return true}if(a.positionTop<=n&&e<=a.positionBottom){if(a.positionTop<=e+1&&a.positionBottom>e){r=t}}}}.bind(this));return o.getElementById(r)?r:null};M.prototype._toggleHeader=function(e,t){var i;if(e===this._bStickyAnchorBar){return}i=this.getHeaderTitle();if(!this._shouldPreserveHeaderInTitleArea()&&!this._bHeaderInTitleArea){this._toggleHeaderTitle(!e,t)}if(!this._bStickyAnchorBar&&e){this._restoreFocusAfter(this._moveAnchorBarToTitleArea);i&&i.snap();this._bHeaderExpanded=false;this._adjustHeaderHeights();this._updateToggleHeaderVisualIndicators()}else if(this._bStickyAnchorBar&&!e){this._restoreFocusAfter(this._moveAnchorBarToContentArea);i&&i.unSnap();this._bHeaderExpanded=true;this._adjustHeaderHeights();this._updateToggleHeaderVisualIndicators();if(this._isHeaderPinnable()){this._getHeaderContent()._getPinButton().setVisible(!this._headerBiggerThanAllowedToBeExpandedInTitleArea())}}};M.prototype._restoreFocusAfter=function(e){var t=o.getActiveElement();e.call(this);if(g.system.phone!==true){if(!o.getActiveElement()){t&&t.$().trigger("focus")}}return this};M.prototype._moveAnchorBarToTitleArea=function(){this._$anchorBar.children().appendTo(this._$stickyAnchorBar);this._toggleHeaderStyleRules(true);if(this.iHeaderTitleHeight!=this.iHeaderTitleHeightStickied){this._adjustHeaderBackgroundSize()}return this};M.prototype._moveAnchorBarToContentArea=function(){if(!this._shouldPreserveHeaderInTitleArea()){var e=this._$opWrapper.scrollTop();this._$anchorBar.append(this._$stickyAnchorBar.children());this._$opWrapper.scrollTop(e);this._toggleHeaderStyleRules(false)}return this};M.prototype._toggleHeaderStyleRules=function(e){e=!!e;var t=e?"hidden":"inherit";this._bStickyAnchorBar=e;this._$headerContent.css("overflow",t);this._$headerContent.toggleClass("sapContrastPlus",!e);this._$headerContent.toggleClass("sapUxAPObjectPageHeaderDetailsHidden",e);this._$anchorBar.css("visibility",t);if(k(this._$stickyAnchorBar)){this._$stickyAnchorBar.attr("aria-hidden",!e)}this.fireToggleAnchorBar({fixed:e});if(!e&&!this.iAnchorBarHeight){this._requestAdjustLayout()}};M.prototype.getScrollDelegate=function(){return this._oScroller};M.prototype.setHeaderTitle=function(e,t){if(e&&typeof e.addEventDelegate==="function"){e.addEventDelegate({onAfterRendering:this._onAfterHeaderTitleRendering.bind(this)})}this.setAggregation("headerTitle",e,t);this._oObserver&&this._oObserver.disconnect();this._oObserver=new a(this._onModifyHeaderTitle.bind(this));this._oObserver.observe(e,{aggregations:["headerTitle"],properties:["backgroundDesign"]});if(e){this._createHeaderContent()}if(this._hasDynamicTitle()){this._iHeaderContentPaddingBottom=M.HEADER_CONTENT_PADDING_BOTTOM}return this};M.prototype._onAfterHeaderTitleRendering=function(){var e=this.getHeaderTitle(),t=e&&e.$(),i;if(!e||!t.length){return}i=t.height();if(i!==this._iCachedHeaderTitleHeight){this._adjustHeaderHeights();this._iCachedHeaderTitleHeight=i}};M.prototype._onModifyHeaderTitle=function(e){var t=this.getAggregation("_headerContent");t&&e.current&&t.setBackgroundDesign(e.current)};M.prototype.invalidate=function(e){this._bInvalidatedAndNotRerendered=true;if(this.getUseIconTabBar()&&e&&e instanceof S&&!e.isActive()&&this._oSectionInfo[e.getId()]){return}if(this._iAfterRenderingDomReadyTimeout){clearTimeout(this._iAfterRenderingDomReadyTimeout);this._iAfterRenderingDomReadyTimeout=null}c.prototype.invalidate.apply(this,arguments)};M.prototype._createHeaderContent=function(){var e=this.getHeaderTitle(),t=this.getAggregation("_headerContent"),i,o;var n=e?e.getCompatibleHeaderContentClass():b;if(!(t instanceof n)){i=this.getAggregation("_headerContent");if(i){i.destroy();i.removeEventDelegate(this._oHeaderContentDelegate)}o=n.createInstance(this.getAggregation("headerContent"),this.getShowHeaderContent(),"",this.getHeaderContentPinnable(),this.getId()+"-OPHeaderContent");o.addEventDelegate(this._oHeaderContentDelegate);o.getContent().forEach(this._replaceHeaderContentParent,this);this.setAggregation("_headerContent",o,true)}};M.prototype._adjustHeaderBackgroundSize=function(){var e=this.getHeaderTitle();if(e&&e.getHeaderDesign()=="Dark"){if(!this._shouldPreserveHeaderInTitleArea()){this.iTotalHeaderSize=this.iHeaderTitleHeight+this.iHeaderContentHeight;this._$headerContent.css("background-size","100% "+this.iTotalHeaderSize+"px")}else{this.iTotalHeaderSize=this.iHeaderTitleHeight-this._$stickyAnchorBar.height();this._$stickyHeaderContent.css("background-size","100% "+this.iTotalHeaderSize+"px")}e.$().css("background-size","100% "+this.iTotalHeaderSize+"px");this._adjustHeaderTitleBackgroundPosition(0)}};M.prototype._adjustHeaderTitleBackgroundPosition=function(e){var t=this.getHeaderTitle();if(t&&t.getHeaderDesign()=="Dark"){if(this._bStickyAnchorBar){t.$().css("background-position","0px "+(this.iTotalHeaderSize-this.iHeaderTitleHeightStickied)*-1+"px")}else{if(this._shouldPreserveHeaderInTitleArea()){t.$().css("background-position","0px 0px")}else{t.$().css("background-position","0px "+(this.iHeaderTitleHeight+this.iHeaderContentHeight-this.iTotalHeaderSize-e)+"px")}}}};M.prototype._adjustHeaderHeights=function(){var e=this.getHeaderTitle(),t=true;if(e&&!e.supportsAdaptLayoutForDomElement()){t=false}if(this._$titleArea.length>0){this.iHeaderContentHeight=this._$headerContent.length?Math.round(this._getDOMRefHeight(this._$headerContent[0])):0;this.iStickyHeaderContentHeight=this._$stickyHeaderContent.height();this.iAnchorBarHeight=this._bStickyAnchorBar?this._$stickyAnchorBar.outerHeight():this._$anchorBar.outerHeight();if(!this._bHeaderExpanded){this.iHeaderTitleHeightStickied=this._$titleArea.height()-this.iAnchorBarHeight;this.iHeaderTitleHeight=this._obtainExpandedTitleHeight(t)}else{this.iHeaderTitleHeight=this._$titleArea.is(":visible")?this._$titleArea.height():0;this.iHeaderTitleHeightStickied=this._obtainSnappedTitleHeight(t)}this._adjustHeaderBackgroundSize();this._adjustTitlePositioning();P.info("ObjectPageLayout :: adjustHeaderHeight","headerTitleHeight: "+this.iHeaderTitleHeight+" - headerTitleStickiedHeight: "+this.iHeaderTitleHeightStickied+" - headerContentHeight: "+this.iHeaderContentHeight)}else{P.debug("ObjectPageLayout :: adjustHeaderHeight","skipped as the objectPageLayout is being rendered")}};M.prototype._appendTitleCloneToDOM=function(e){var t=this.getHeaderTitle().$(),i=t.clone();i.css({left:"-10000px",top:"-10000px",width:t.width()+"px",position:"absolute"});i.toggleClass("sapUxAPObjectPageHeaderStickied",e);i.appendTo(this._$titleArea.parent());if(e){this.getHeaderTitle()&&this.getHeaderTitle()._adaptObjectPageHeaderIndentifierLine(i)}return i};M.prototype._obtainSnappedTitleHeight=function(e){var t=this.getHeaderTitle(),i,o;if(!t){return 0}if(e){i=this._appendTitleCloneToDOM(true);o=i.height();i.remove()}else if(t.snap){o=this._obtainTitleHeightViaStateChange(true)}return o};M.prototype._obtainExpandedTitleHeight=function(e){var t=this.getHeaderTitle(),i,o;if(!t){return 0}if(e){i=this._appendTitleCloneToDOM(false);o=i.is(":visible")?i.height():0;i.remove()}else if(t.unSnap){o=this._obtainTitleHeightViaStateChange(false)}return o};M.prototype._obtainTitleHeightViaStateChange=function(e){var t=this.getHeaderTitle(),i,o=this._$sectionsContainer.height(),n,r=e?t.snap:t.unSnap,s=e?t.unSnap:t.snap;r.call(t,false);i=t.$().outerHeight();s.call(t,false);n=this._$sectionsContainer.height();this._adjustSpacerHeightUponUnsnapping(o,n);return i};M.prototype._adjustSpacerHeightUponUnsnapping=function(e,t){var i;if(e!=t){i=this._$spacer.height()-(t-e);this._$spacer.height(i)}};M.prototype._getHeaderDesign=function(){var e=this.getHeaderTitle(),t=C.ObjectPageHeaderDesign.Light;if(e!=null){t=e.getHeaderDesign()}return t};M.prototype._getVisibleSections=function(){return this.getSections().filter(function(e){return e.getVisible()&&e._getInternalVisible()})};M.prototype._setSectionsFocusValues=function(e){var t=this._getVisibleSections()||[],i,o="0",n="-1",r="tabindex",s,a=t[0];t.forEach(function(t){i=t.$();if(e===t.getId()){i.attr(r,o);s=t;t._setSubSectionsFocusValues()}else{i.attr(r,n);t._disableSubSectionsFocus()}});if(!s&&t.length>0){a.$().attr(r,o);a._setSubSectionsFocusValues();s=a}return s};M.prototype.setShowHeaderContent=function(e){var t=this.getShowHeaderContent(),i;if(t!==e){if(t&&this._bHeaderInTitleArea&&!this._shouldPreserveHeaderInTitleArea()){this._moveHeaderToContentArea();this._toggleHeaderTitle(false)}this.setProperty("showHeaderContent",e,true);this._updateTitleVisualState();i=this._getHeaderContent();this.$().toggleClass("sapUxAPObjectPageLayoutNoHeaderContent",!e||!i);if(i){i.setProperty("visible",e)}if(e){this._updateToggleHeaderVisualIndicators()}}return this};M.prototype._headerTitleChangeHandler=function(e){var t;if(!this.getShowTitleInHeaderContent()){return}if(e){this._getHeaderContent()._destroyObjectImage(true)}t=(new s).getInterface();this.getRenderer()._rerenderHeaderContentArea(t,this);this._getHeaderContent().invalidate();t.destroy()};M.prototype._replaceHeaderContentParent=function(e){if(e.getParent().isA(["sap.uxap.ObjectPageHeaderContent","sap.uxap.ObjectPageDynamicHeaderContent"])){if(e.isA(["sap.uxap.ObjectPageHeaderContent","sap.uxap.ObjectPageDynamicHeaderContent"])){return}if(e._sOriginalParentAggregationName){return}e._sOriginalParentAggregationName=e.sParentAggregationName;e.sParentAggregationName="headerContent";e.getParent=function(){return this}.bind(this);e.destroy=function(){this._restoreParent(e);e.getMetadata().getClass().prototype.destroy.apply(e,arguments)}.bind(this)}};M.prototype._restoreParent=function(e){if(e&&e._sOriginalParentAggregationName){e.sParentAggregationName=e._sOriginalParentAggregationName;e.getParent=e.getMetadata().getClass().prototype.getParent;e.destroy=e.getMetadata().getClass().prototype.destroy;e._sOriginalParentAggregationName=null}};M.prototype.getHeaderContent=function(){if(!this._getHeaderContent()){return this.getAggregation("headerContent",[])}return this._getHeaderContent().getAggregation("content",[])};M.prototype.insertHeaderContent=function(e,t,i){if(!this._getHeaderContent()){return this.insertAggregation("headerContent",e,t,i)}this._getHeaderContent().insertAggregation("content",e,t,i);this._replaceHeaderContentParent(e);return this};M.prototype.addHeaderContent=function(e,t){if(!this._getHeaderContent()){return this.addAggregation("headerContent",e,t)}this._getHeaderContent().addAggregation("content",e,t);this._replaceHeaderContentParent(e);return this};M.prototype.removeAllHeaderContent=function(e){var t;if(!this._getHeaderContent()){return this.removeAllAggregation("headerContent",e)}t=this._getHeaderContent().removeAllAggregation("content",e);t.forEach(function(e){this._restoreParent(e)},this);return t};M.prototype.removeHeaderContent=function(e,t){if(!this._getHeaderContent()){return this.removeAggregation("headerContent",e,t)}this._getHeaderContent().removeAggregation("content",e,t);this._restoreParent(e);return this};M.prototype.destroyHeaderContent=function(e){if(!this._getHeaderContent()){return this.destroyAggregation("headerContent",e)}return this._getHeaderContent().destroyAggregation("content",e)};M.prototype.indexOfHeaderContent=function(e){if(!this._getHeaderContent()){return this.indexOfAggregation("headerContent",e)}return this._getHeaderContent().indexOfAggregation("content",e)};M.prototype._getHeaderContent=function(){return this.getAggregation("_headerContent")};M.prototype._getHeaderContentDomRef=function(){var e=this._getHeaderContent();if(!e||!this.getShowHeaderContent()){return null}if(this._bStickyAnchorBar&&!this._bHeaderInTitleArea){return this.$().find(".sapUxAPObjectPageHeaderTitle .sapUxAPObjectPageHeaderDetails").get(0)}return e.getDomRef()};M.prototype._connectModelsForSections=function(e){var t=[];e=e||[];e.forEach(function(e){t.push(e.connectToModelsAsync())});return Promise.all(t)};M.prototype._getHeightRelatedParameters=function(){return{iHeaderContentHeight:this.iHeaderContentHeight,iScreenHeight:this.iScreenHeight,iAnchorBarHeight:this.iAnchorBarHeight,iHeaderTitleHeightStickied:this.iHeaderTitleHeightStickied,iStickyHeaderContentHeight:this.iStickyHeaderContentHeight,iScrollTop:this._$opWrapper.scrollTop()}};M.prototype._hasVerticalScrollBar=function(){var e=this._$opWrapper.length&&this._$opWrapper.get(0);return e&&e.scrollHeight>e.offsetHeight};M.prototype._shiftHeaderTitle=function(){var e=this._calculateShiftOffset(),t=e.sStyleAttribute,i=e.iMarginalsOffset;this.$().find(".sapUxAPObjectPageHeaderTitle").css(t,i+"px")};M.prototype._isFirstSection=function(e){var t=this._getVisibleSections();if(e===t[0]){return true}return false};M.prototype._isValidStoredSubSectionInfo=function(){var e=this.getSelectedSection(),t=o.getElementById(e),i;if(!t||!this._oStoredScrolledSubSectionInfo){return false}i=o.getElementById(this._oStoredScrolledSubSectionInfo.sSubSectionId);return i&&this._sectionCanBeRenderedByUXRules(i)&&t.indexOfSubSection(i)>=0};M.prototype._restoreScrollPosition=function(){var e=this._isValidStoredSubSectionInfo(),t,i=o.getElementById(this.getSelectedSection()),n=i?.getSelectedSubSection();if(e){t=this._computeScrollPosition(o.getElementById(this._oStoredScrolledSubSectionInfo.sSubSectionId))+this._oStoredScrolledSubSectionInfo.iOffset;this._scrollTo(t,0)}else{this.scrollToSection(n||i?.getId(),0)}};M.prototype._storeScrollLocation=function(){var e=this.getDomRef()&&this.$().width()&&this.$().height();if(!e||!this._bDomReady||!this._oScroller){return false}this.triggerPendingLayoutUpdates();var t=this._$opWrapper.scrollTop(),i=this._getClosestScrolledSectionBaseId(this._oScroller.getScrollTop(),this.iScreenHeight,true),n;if(i){n=t-this._computeScrollPosition(o.getElementById(i))}this._iStoredScrollTop=t;this._oStoredScrolledSubSectionInfo={sSubSectionId:i,iOffset:n};this._oCurrentTabSection=null;return this._oStoredScrolledSubSectionInfo};M.prototype.onkeyup=function(e){var t;if(e.which===m.TAB){t=o.getActiveElement();if(t&&this._isFirstSection(t)){this._scrollTo(0,0)}}};M.prototype.setShowFooter=function(e){var t=this.setProperty("showFooter",e,true);this._toggleFooter(e);this.$().toggleClass("sapUxAPObjectPageLayoutFooterVisible",e);return t};M.prototype.destroyFooter=function(){this._destroyInvisibleText();return this.destroyAggregation("footer")};M.prototype._toggleFooter=function(e){var o,n=this.getFooter(),r=i.getAnimationMode();if(!k(n)||!k(this._$footerWrapper)){return}o=r!==t.none&&r!==t.minimal;if(o){this._toggleFooterAnimation(e,n)}else{this._$footerWrapper.toggleClass("sapUiHidden",!e)}this._requestAdjustLayout()};M.prototype._toggleFooterAnimation=function(e,t){this._$footerWrapper.on("webkitAnimationEnd animationend",this._onToggleFooterAnimationEnd.bind(this,t));this._bIsFooterAanimationGoing=true;if(e){this._$footerWrapper.removeClass("sapUiHidden")}t.toggleStyleClass(M.SHOW_FOOTER_CLASS_NAME,e);t.toggleStyleClass(M.HIDE_FOOTER_CLASS_NAME,!e)};M.prototype._onToggleFooterAnimationEnd=function(e){this._$footerWrapper.off("webkitAnimationEnd animationend");if(e.hasStyleClass(M.HIDE_FOOTER_CLASS_NAME)){this._$footerWrapper.addClass("sapUiHidden");e.removeStyleClass(M.HIDE_FOOTER_CLASS_NAME)}else{e.removeStyleClass(M.SHOW_FOOTER_CLASS_NAME)}this._bIsFooterAanimationGoing=false};M.prototype.clone=function(){var e,t,i;Object.keys(this.mAggregations).forEach(this._cloneProxiedAggregations,this);e=c.prototype.clone.apply(this,arguments);t=this._getHeaderContent();i=e._getHeaderContent();if(i){i.destroy()}if(t){e.setAggregation("_headerContent",t.clone(),true)}return e};M.prototype._cloneProxiedAggregations=function(e){var t=this.mAggregations[e];if(Array.isArray(t)&&t.length===0){t=this["get"+e.charAt(0).toUpperCase()+e.slice(1)]()}this.mAggregations[e]=t};M.prototype._shouldPreserveHeaderInTitleArea=function(){return this._bPinned||this._preserveHeaderStateOnScroll()||this._checkAlwaysShowContentHeader()};M.prototype._checkAlwaysShowContentHeader=function(){return!this._hasDynamicTitle()&&!this._bMobileScenario&&!this._bTabletScenario&&this.getShowHeaderContent()&&this.getAlwaysShowContentHeader()};M.prototype._headerBiggerThanAllowedToBeFixed=function(){var e=this._getOwnHeight();return this._getEntireHeaderHeight()>M.HEADER_MAX_ALLOWED_NON_SROLLABLE_PERCENTAGE*e};M.prototype._headerBiggerThanAllowedToBeExpandedInTitleArea=function(){return this._getEntireHeaderHeight()>=this._getOwnHeight()};M.prototype._getOwnHeight=function(){return this._getHeight(this)};M.prototype._getHeight=function(e){return!(e instanceof c)?0:e.$().outerHeight()||0};M.prototype._getEntireHeaderHeight=function(){var e=0,t=0,i=this.getHeaderTitle(),o=this._getHeaderContent();if(k(i)){e=i.$().outerHeight()}if(k(o)){t=o.$().outerHeight()}return e+t};M.prototype._onPinUnpinButtonPress=function(){if(this._bPinned){this._unPin(true)}else{this._pin(true);this._restorePinButtonFocus()}};M.prototype._restorePinButtonFocus=function(){var e=this._getHeaderContent();if(k(e)&&e.supportsPinUnpin()){e._focusPinButton()}};M.prototype._pin=function(e){if(this._bPinned){return}this._bPinned=true;if(e){this.setProperty("headerContentPinned",true,true);this.fireEvent("headerContentPinnedStateChange",{pinned:true})}this._toggleHeaderTitle(true);this._moveAnchorBarToTitleArea();this._moveHeaderToTitleArea();this._adjustHeaderHeights();this._requestAdjustLayout();this._updateToggleHeaderVisualIndicators();this.addStyleClass("sapUxAPObjectPageLayoutHeaderPinned")};M.prototype._unPin=function(e){if(!this._bPinned){return}this._bPinned=false;if(e){this.setProperty("headerContentPinned",false,true);this.fireEvent("headerContentPinnedStateChange",{pinned:false})}this._updateToggleHeaderVisualIndicators();this.removeStyleClass("sapUxAPObjectPageLayoutHeaderPinned")};M.prototype._isHeaderPinnable=function(){var e=this._getHeaderContent();return e&&e.supportsPinUnpin()&&e.getPinnable()};M.prototype._shouldPinUnpinHeader=function(){return this._bHeaderExpanded&&!this.getPreserveHeaderStateOnScroll()&&!this._headerBiggerThanAllowedToBeExpandedInTitleArea()};M.prototype._updatePinButtonState=function(){var e=this._isHeaderPinnable(),t=e&&this.getHeaderContentPinned()&&this._shouldPinUnpinHeader(),i=this._getHeaderContent();i._togglePinButton(t);this.$().toggleClass("sapUxAPObjectPageLayoutHeaderPinnable",e);i._getPinButton().setVisible(!this._headerBiggerThanAllowedToBeExpandedInTitleArea());if(t){this._pin()}else{this._unPin()}};M.prototype._preserveHeaderStateOnScroll=function(){return this._hasDynamicTitle()&&this.getPreserveHeaderStateOnScroll()&&!this._bHeaderBiggerThanAllowedHeight};M.prototype._overridePreserveHeaderStateOnScroll=function(){var e=this._bHeaderBiggerThanAllowedHeight,t;this._bHeaderBiggerThanAllowedHeight=this._headerBiggerThanAllowedToBeFixed();t=e!==this._bHeaderBiggerThanAllowedHeight;if(!this._bHeaderBiggerThanAllowedHeight||!t){return}if(this._bHeaderExpanded){this._moveAnchorBarToContentArea();this._moveHeaderToContentArea(true)}else{this._snapHeader(true)}this._adjustHeaderHeights();this._requestAdjustLayout()};M.prototype._hasDynamicTitle=function(){var e=this.getHeaderTitle();return e&&e.isDynamic()};M.prototype._attachVisualIndicatorsPressHandlers=function(e,t){var i=this.getHeaderTitle(),o=this._getHeaderContent();if(k(i)&&!this._bAlreadyAttachedTitleIndicatorPressHandler){i.attachEvent(M.EVENTS.TITLE_VISUAL_INDICATOR_PRESS,function(){e.call(t);if(this._headerBiggerThanAllowedToBeExpandedInTitleArea()){this._scrollBelowCollapseVisualIndicator()}this._focusCollapseVisualIndicator()},this);this._bAlreadyAttachedTitleIndicatorPressHandler=true}if(k(o)&&!this._bAlreadyAttachedHeaderIndicatorPressHandler){o.attachEvent(M.EVENTS.HEADER_VISUAL_INDICATOR_PRESS,function(){e.call(t);this._focusExpandVisualIndicator()},this);this._bAlreadyAttachedHeaderIndicatorPressHandler=true}};M.prototype._hasVisibleDynamicTitleAndHeader=function(){var e=this.getHeaderTitle(),t=this.getHeaderContent();return this._hasVisibleDynamicTitle(e)&&this._hasVisibleHeaderContent(t)};M.prototype._hasVisibleDynamicTitle=function(e){return k(e)&&e.isDynamic()&&e.getVisible()};M.prototype._hasVisibleHeaderContent=function(e){return k(e)&&e.length>0&&this.getShowHeaderContent()};M.prototype._hasDynamicTitleWithSnappedTitleOnMobile=function(){var e=this.getHeaderTitle();return k(e)&&e.isDynamic()&&!!e.getSnappedTitleOnMobile()&&g.system.phone};M.prototype._updateToggleHeaderVisualIndicators=function(){var e,t,i,o=this._hasVisibleDynamicTitleAndHeader();if(!this.getToggleHeaderOnTitleClick()||!o){t=false;i=false}else{e=this._bHeaderExpanded;t=e;i=!e&&!this._hasDynamicTitleWithSnappedTitleOnMobile()}this._toggleCollapseVisualIndicator(t);this._toggleExpandVisualIndicator(i)};M.prototype._updateTitleVisualState=function(){var e=this.getHeaderTitle(),t=this._hasVisibleDynamicTitleAndHeader()&&this.getToggleHeaderOnTitleClick()&&!this._hasDynamicTitleWithSnappedTitleOnMobile();this.$().toggleClass("sapUxAPObjectPageLayoutTitleClickEnabled",t);if(k(e)){e._toggleFocusableState(t)}};M.prototype._focusCollapseVisualIndicator=function(){var e=this._getHeaderContent();if(k(e)){e._focusCollapseButton()}};M.prototype._focusExpandVisualIndicator=function(){var e=this.getHeaderTitle();if(k(e)){e._focusExpandButton()}};M.prototype._toggleExpandVisualIndicator=function(e){var t=this.getHeaderTitle();if(k(t)){t._toggleExpandButton(e)}};M.prototype._toggleCollapseVisualIndicator=function(e){var t=this._getHeaderContent();if(k(t)){t._toggleCollapseButton(e)}};M.prototype._attachVisualIndicatorMouseOverHandlers=function(e,t,i){var o=this._getHeaderContent();if(k(o)&&!this._bAlreadyAttachedVisualIndicatorMouseOverOutHandler){o.attachEvent(M.EVENTS.VISUAL_INDICATOR_MOUSE_OVER,e,i);o.attachEvent(M.EVENTS.VISUAL_INDICATOR_MOUSE_OUT,t,i);this._bAlreadyAttachedVisualIndicatorMouseOverOutHandler=true}};M.prototype._attachTitleMouseOverHandlers=function(e,t,i){var o=this.getHeaderTitle();if(k(o)&&!this._bAlreadyAttachedTitleMouseOverOutHandler){o.attachEvent(M.EVENTS.TITLE_MOUSE_OVER,e,i);o.attachEvent(M.EVENTS.TITLE_MOUSE_OUT,t,i);this._bAlreadyAttachedTitleMouseOverOutHandler=true}};M.prototype._suppressScroll=function(){this._bSuppressScroll=true};M.prototype._resumeScroll=function(){this._bSuppressScroll=false;if(this._iStoredScrollTop){this._scrollTo(this._iStoredScrollTop,0)}else{this._onScroll({target:{scrollTop:this._$opWrapper.scrollTop()}})}};M.prototype._addHoverClass=function(){var e=this.$();if(e){e.addClass("sapUxAPObjectPageLayoutTitleForceHovered")}};M.prototype._removeHoverClass=function(){var e=this.$();if(e){e.removeClass("sapUxAPObjectPageLayoutTitleForceHovered")}};M.prototype._getHeight=function(e){return!(e instanceof c)?0:e.$().outerHeight()||0};M.prototype._getWidth=function(e){var t=e.getDomRef();return!(e instanceof c)?0:t&&t.offsetWidth||0};M.prototype._getSectionInfoIsDirty=function(){return this.bSectionInfoIsDirty};M.prototype._setSectionInfoIsDirty=function(e){this.bSectionInfoIsDirty=e};M.prototype._getAriaLabelText=function(e,t){var i=this.getHeaderTitle(),o=i?i.getTitleText():null,n;if(i&&o&&e!=="ROOT"){n=o;if(t){n+=" "+M._getLibraryResourceBundle().getText(e+"_ARIA_LABEL_WITH_TITLE")}}else{n=M._getLibraryResourceBundle().getText(e+"_ARIA_LABEL_WITHOUT_TITLE")}return n};M.prototype._getFooterHeight=function(){if(this.getFooter()&&this.getShowFooter()){var e=this.$("footerWrapper").get(0),t=this._getDOMRefHeight(e),i=e?parseFloat(getComputedStyle(e).marginBottom):0;return t+i}return 0};M.prototype._getDOMRefHeight=function(e){return e&&e.parentElement?e.getBoundingClientRect().height:0};M.prototype._updateAriaLabels=function(){var e=this.getLandmarkInfo(),t=this._getAriaLabelText("ROOT",true),i=this._getAriaLabelText("HEADER",true),o=this._getAriaLabelText("NAVIGATION",false),n=this._getAriaLabelText("NAVTOOLBAR",true),r=e&&e.getHeaderLabel(),s=e&&e.getRootLabel(),a=e&&e.getNavigationLabel();if(!s){this.$().attr("aria-label",t)}if(!r){this.$("headerTitle").attr("aria-label",i)}if(!a){this.$("anchorBar").attr("aria-label",o);this.$("stickyAnchorBar").attr("aria-label",o)}this.$("anchBar").attr("aria-label",n)};M.prototype._formatLandmarkInfo=function(e,t){if(e){var i=e["get"+t+"Role"]()||"",o=e["get"+t+"Label"]()||"";if(i===F.None){i="";o=""}return{role:i.toLowerCase(),label:o}}return{}};M.prototype._getHeaderTag=function(e){if(e&&e.getHeaderRole()!==F.None){return M.DIV}return M.HEADER};M.prototype._getFooterTag=function(e){if(e&&e.getFooterRole()!==F.None){return M.DIV}return M.FOOTER};function k(e){if(arguments.length===1){return Array.isArray(e)?e.length>0:!!e}return Array.prototype.slice.call(arguments).every(function(e){return k(e)})}return M});
//# sourceMappingURL=ObjectPageLayout.js.map