/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./ObjectPageSectionBase","sap/ui/Device","sap/m/Button","sap/m/Title","sap/ui/core/Element","sap/ui/core/Lib","sap/ui/core/StashedControlSupport","sap/ui/base/ManagedObjectObserver","./ObjectPageSubSection","./library","sap/m/library","./ObjectPageSectionRenderer","sap/ui/core/library"],function(t,e,i,o,n,s,r,a,l,u,p,h,c){"use strict";var d=p.ButtonType;var g=c.IconColor;var S=c.TitleLevel;var _=t.extend("sap.uxap.ObjectPageSection",{metadata:{library:"sap.uxap",properties:{showTitle:{type:"boolean",group:"Appearance",defaultValue:true},titleUppercase:{type:"boolean",group:"Appearance",defaultValue:true},wrapTitle:{type:"boolean",group:"Appearance",defaultValue:false},anchorBarButtonColor:{type:"sap.ui.core.IconColor",group:"Appearance",defaultValue:g.Default}},defaultAggregation:"subSections",aggregations:{subSections:{type:"sap.uxap.ObjectPageSubSection",multiple:true,singularName:"subSection",forwarding:{getter:"_getGrid",aggregation:"content"}},heading:{type:"sap.ui.core.Control",multiple:false},_title:{type:"sap.m.Title",multiple:false,visibility:"hidden"},_showHideAllButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"}},associations:{selectedSubSection:{type:"sap.uxap.ObjectPageSubSection",multiple:false}},designtime:"sap/uxap/designtime/ObjectPageSection.designtime"},renderer:h});_.MEDIA_RANGE=e.media.RANGESETS.SAP_STANDARD;_._getClosestSection=function(t){var e=typeof t==="string"&&n.getElementById(t)||t;return e instanceof l?e.getParent():e};_._getLibraryResourceBundle=function(){return s.getResourceBundleFor("sap.uxap")};_.prototype._expandSection=function(){t.prototype._expandSection.call(this)._updateShowHideAllButton(!this._thereAreHiddenSubSections())};_.prototype.init=function(){t.prototype.init.call(this);this._bInternalTitleVisible=true;this._sContainerSelector=".sapUxAPObjectPageSectionContainer";this._oGridContentObserver=new a(this._onGridContentChange.bind(this));this._sTitleStyle=S.H4;this._sTitleId=this.getId()+"-title";this._bHasPromotedSubSection=false;this._getTitleControl().addStyleClass("sapUxAPObjectPageSectionTitle")};_.prototype.exit=function(){this._detachMediaContainerWidthChange(this._updateImportance,this);this._getTitleControl().destroy();if(t.prototype.exit){t.prototype.exit.call(this)}};_.prototype._getTitleControl=function(){if(!this.getAggregation("_title")){this.setAggregation("_title",new o(this._sTitleId,{titleStyle:this._getTitleStyle(),level:this._getTitleLevel()}),true)}return this.getAggregation("_title")};_.prototype._setHasPromotedSubSection=function(t,e){if(t!=this._bHasPromotedSubSection){this._bHasPromotedSubSection=t;if(e){this.invalidate()}}};_.prototype._hasPromotedSubSection=function(){return this._bHasPromotedSubSection};_.prototype._getFirstVisibleSubSection=function(){return this._getVisibleSubSections().length&&this._getVisibleSubSections()[0]||null};_.prototype._updateImportance=function(t){var e=this._getObjectPageLayout(),i=this._getImportanceLevelToHide(t),o=this.bOutput&&this.getDomRef("header"),n;this.getSubSections().forEach(function(t){t._applyImportanceRules(i)});this._applyImportanceRules(i);this._updateShowHideAllButton(false);n=this._isTitleAriaVisible();o&&o.classList.toggle("sapUxAPObjectPageSectionHeaderHidden",!n);o&&o.setAttribute("aria-hidden",!n);if(e&&this.getDomRef()){e._requestAdjustLayout()}};_.prototype._getImportance=function(){if(this._hasPromotedSubSection()){return u.Importance.High}return this.getImportance()};_.prototype._getTitleUpperCaseStyleClass=function(){return"sapUxAPObjectPageSectionTitleUppercase"};_.prototype._getTitle=function(){return this._hasPromotedSubSection()?this._getFirstVisibleSubSection().getTitle():this.getTitle()};_.prototype.connectToModels=function(){this.getSubSections().forEach(function(t){t.connectToModels()})};_.prototype.connectToModelsAsync=function(){var t=[];this.getSubSections().forEach(function(e){t.push(e.connectToModelsAsync())});return Promise.all(t)};_.prototype._allowPropagationToLoadedViews=function(t){this.getSubSections().forEach(function(e){e._allowPropagationToLoadedViews(t)})};_.prototype.onBeforeRendering=function(){t.prototype.onBeforeRendering.call(this);this._detachMediaContainerWidthChange(this._updateImportance,this);this._applyLayout();this._updateImportance()};_.prototype.onAfterRendering=function(){this._attachMediaContainerWidthChange(this._updateImportance,this)};_.prototype._applyLayout=function(){var t={M:2,L:3,XL:4},e=this.getSubSections();this._resetLayoutData(e);this._assignLayoutData(e,t);return this};_.prototype.setAnchorBarButtonColor=function(t){if(t!==this.getProperty("anchorBarButtonColor")){this.setProperty("anchorBarButtonColor",t,true);this._notifyObjectPageLayout()}return this};_.prototype._getMinRequiredColspanForChild=function(t){return t?t._getMinRequiredColspan():0};_.prototype._allowAutoextendColspanForChild=function(t){return true};_.prototype._onGridContentChange=function(t){var e;if(t.type==="aggregation"&&["content","subSections"].indexOf(t.name)>-1){this.invalidate();e=t.mutation;if(e==="add"||e==="insert"){this._oGridContentObserver.observe(t.child,{properties:["visible","importance"]})}else if(t.mutation==="remove"){this._oGridContentObserver.unobserve(t.child)}}if(t.type==="property"){if(t.name==="visible"){this.invalidate()}else if(t.name==="importance"){this.setTitleVisible()}}};_.prototype._setInternalTitleVisible=function(t,e){if(t!=this._bInternalTitleVisible){this._bInternalTitleVisible=t;this.setTitleVisible();if(e){this.invalidate()}}};_.prototype._getInternalTitleVisible=function(){return this._bInternalTitleVisible};_.prototype._isTitleVisible=function(){var t;if(this._hasPromotedSubSection()){return false}t=this._getInternalTitleVisible()||this._shouldDisplayButtonsInHeader();return this.getShowTitle()&&t};_.prototype._isTitleAriaVisible=function(){if(this._hasPromotedSubSection()){return false}return this.getShowTitle()&&this._getInternalTitleVisible()||this._shouldDisplayButtonsInHeader()};_.prototype._shouldDisplayButtonsInHeader=function(){return this._getShouldDisplayExpandCollapseButton()||this._getShouldDisplayShowHideAllButton()};_.prototype._getAriaLabelledById=function(){if(this._hasPromotedSubSection()){return this._getFirstVisibleSubSection()?._getTitleControl().getId()}else{return this._getTitleControl().getId()}};_.prototype._setSubSectionsFocusValues=function(){var t=this._getVisibleSubSections()||[],e=this.getSelectedSubSection(),i;if(t.length===0){return this}if(t.length===1){t[0]._setToFocusable(false);return this}t.forEach(function(t){if(e===t.getId()&&t.getTitleVisible()){t._setToFocusable(true);i=true}else{t._setToFocusable(false)}});if(!i){var o=t.find(function(t){return t.getTitleVisible()});if(o){o._setToFocusable(true)}}return this};_.prototype._disableSubSectionsFocus=function(){var t=this.getSubSections()||[];t.forEach(function(t){t._setToFocusable(false)});return this};_.prototype._thereAreHiddenSubSections=function(){return this.getSubSections().some(function(t){return t._getIsHidden()})};_.prototype._updateShowHideSubSections=function(t){this.getSubSections().forEach(function(e){if(t&&e._shouldBeHidden()){e._updateShowHideState(true)}else if(!t){e._updateShowHideState(false)}})};_.prototype._getShouldDisplayShowHideAllButton=function(){return this.getSubSections().some(function(t){return t._shouldBeHidden()})};_.prototype._getShouldDisplayExpandCollapseButton=function(){return this._getIsHidden()};_.prototype._showHideContentAllContent=function(){var t=this._thereAreHiddenSubSections();if(this._getIsHidden()&&t){this._updateShowHideState(false)}this._updateShowHideSubSections(!t);this._updateShowHideAllButton(t)};_.prototype._updateShowHideState=function(e){if(this._getIsHidden()===e){return this}this._getShowHideAllButton().setVisible(this._getShouldDisplayShowHideAllButton());return t.prototype._updateShowHideState.call(this,e)};_.prototype._updateShowHideAllButton=function(t){this._getShowHideAllButton().setVisible(this._getShouldDisplayShowHideAllButton()).setText(this._getShowHideAllButtonText(t))};_.prototype._getVisibleSubSections=function(){return this.getSubSections().filter(function(t){return t.getVisible()&&t._getInternalVisible()})};_.prototype._getShowHideAllButton=function(){if(!this.getAggregation("_showHideAllButton")){this.setAggregation("_showHideAllButton",new i({visible:this._getShouldDisplayShowHideAllButton(),text:this._getShowHideAllButtonText(!this._thereAreHiddenSubSections()),press:this._showHideContentAllContent.bind(this),type:d.Transparent}).addStyleClass("sapUxAPShowHideButton"),true)}return this.getAggregation("_showHideAllButton")};_.prototype._getShowHideAllButtonText=function(t){return _._getLibraryResourceBundle().getText(t?"HIDE_ALL":"SHOW_ALL")};r.mixInto(_);return _});
//# sourceMappingURL=ObjectPageSection.js.map