/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/i18n/Localization","sap/ui/thirdparty/jquery","sap/ui/core/Control","sap/ui/core/library","sap/ui/core/Lib","./library","sap/m/library","sap/base/Log","sap/ui/events/KeyCodes","sap/ui/layout/Grid","sap/ui/layout/GridData","sap/m/Button","sap/ui/dom/jquery/Focusable"],function(t,jQuery,e,i,n,o,r,s,a,l,u,p){"use strict";var c=i.TitleLevel;var g=r.ButtonType;var h=e.extend("sap.uxap.ObjectPageSectionBase",{metadata:{abstract:true,library:"sap.uxap",properties:{title:{type:"string",group:"Appearance",defaultValue:null},titleLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:c.Auto},visible:{type:"boolean",group:"Appearance",defaultValue:true},titleVisible:{type:"boolean",group:"Appearance",defaultValue:true},importance:{type:"sap.uxap.Importance",group:"Behavior",defaultValue:o.Importance.High}},aggregations:{ariaLabelledBy:{type:"sap.ui.core.InvisibleText",multiple:false,visibility:"hidden"},customAnchorBarButton:{type:"sap.m.Button",multiple:false},_grid:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_showHideButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"}}},renderer:null});h._getLibraryResourceBundle=function(){return n.getResourceBundleFor("sap.uxap")};h.prototype.init=function(){this._bInternalVisible=true;this._sInternalTitleLevel=c.Auto;this._isHidden=false;this._oGridContentObserver=null;this._sTitleStyle="";this._bRtl=t.getRTL()};h.prototype.onBeforeRendering=function(){var t=this._getTitleControl();if(t){t.setProperty("visible",this._isTitleVisible(),true);t.setProperty("level",this.getEffectiveTitleLevel(),true);t.setProperty("wrapping",this._getWrapTitle(),true);t.setProperty("titleStyle",this._getTitleStyle(),true);t.toggleStyleClass(this._getTitleUpperCaseStyleClass(),this.getTitleUppercase())}this._getObjectPageLayout()?._setSectionInfoIsDirty(true)};h.prototype.onAfterRendering=function(){if(this._getObjectPageLayout()){this._getObjectPageLayout()._requestAdjustLayout().catch(function(){s.debug("ObjectPageSectionBase :: cannot adjustLayout",this)});this._getObjectPageLayout()._setSectionsFocusValues()}};h.prototype.exit=function(){if(this._oInvisibleText){this._oInvisibleText.destroy();this._oInvisibleText=null}};h.prototype._getTitleUpperCaseStyleClass=function(){return""};h.prototype._getWrapTitle=function(){return false};h.prototype.setShowTitle=function(t){this.setProperty("showTitle",t);this.setTitleVisible();return this};h.prototype.getEffectiveTitleLevel=function(){return this._getTitleLevel()};h.prototype.setTitleVisible=function(){return this.setProperty("titleVisible",this._isTitleVisible(),true)};h.prototype._isTitleVisible=function(){return true};h.prototype._isTitleAriaVisible=function(){return this.getShowTitle()||this._shouldDisplayButtonsInHeader()};h.prototype._shouldDisplayButtonsInHeader=function(){return this._getShouldDisplayExpandCollapseButton()};h.prototype._getShouldDisplayExpandCollapseButton=function(){return this._getIsHidden()};h.prototype._getTitleStyle=function(){return this._sTitleStyle};h.prototype._getGrid=function(){if(!this.getAggregation("_grid")&&!this._bIsBeingDestroyed){this.setAggregation("_grid",new l({id:this.getId()+"-innerGrid",defaultSpan:"XL12 L12 M12 S12",hSpacing:1,vSpacing:1,width:"100%",containerQuery:true}),true);if(this._oGridContentObserver){this._oGridContentObserver.observe(this.getAggregation("_grid"),{aggregations:["content","subSections"]})}}return this.getAggregation("_grid")};h.prototype._getTitleControl=function(){return null};h.prototype._resetLayoutData=function(t){t.forEach(function(t){if(t?.getLayoutData?.()){t.destroyLayoutData()}},this)};h.prototype._assignLayoutData=function(t,e){var i=12,n=[],o=[],r,s,a,l;r={iRemaining:e.M,iColumnConfig:e.M};s={iRemaining:e.L,iColumnConfig:e.L};a={iRemaining:e.XL,iColumnConfig:e.XL};l=[a,s,r];t.forEach(function(t){if(!t){return}if(t.getVisible?.()){n.push(t)}else{o.push(t)}});n.forEach(function(t,e){l.forEach(function(i){i.iCalculatedSize=this._getEffectiveColspanForGridItem(t,i.iRemaining,n,e,i.iColumnConfig)},this);t.setLayoutData(new u({spanS:i,spanM:r.iCalculatedSize*(i/r.iColumnConfig),spanL:s.iCalculatedSize*(i/s.iColumnConfig),spanXL:a.iCalculatedSize*(i/a.iColumnConfig),linebreakM:e>0&&r.iRemaining===r.iColumnConfig,linebreakL:e>0&&s.iRemaining===s.iColumnConfig,linebreakXL:e>0&&a.iRemaining===a.iColumnConfig}));if(t.isA("sap.uxap.ObjectPageSubSection")){t._oLayoutConfig={M:r.iCalculatedSize,L:s.iCalculatedSize,XL:a.iCalculatedSize}}l.forEach(function(t){t.iRemaining-=t.iCalculatedSize;if(t.iRemaining<1){t.iRemaining=t.iColumnConfig}})},this);o.forEach(function(t){t.setLayoutData?.(new u({visibleS:false,visibleM:false,visibleL:false,visibleXL:false}))});return n};h.prototype._getEffectiveColspanForGridItem=function(t,e,i,n,o){var r,s=o,a,l=this._getMinRequiredColspanForChild(t);if(!this._allowAutoextendColspanForChild(t)){return Math.min(o,l)}for(a=1;a<=s;a++){r=this._getMinRequiredColspanForChild(i[n+a]);if(r<=e-l){e-=r}else{break}}return e};h.prototype._getMinRequiredColspanForChild=function(t){};h.prototype._allowAutoextendColspanForChild=function(t){};h.prototype.setCustomAnchorBarButton=function(t){var e=this.setAggregation("customAnchorBarButton",t,true);if(this._getObjectPageLayout()){this._getObjectPageLayout()._updateNavigation()}return e};h.prototype._setInternalVisible=function(t,e){if(t!=this._bInternalVisible){this._bInternalVisible=t;if(e){this.invalidate()}}};h.prototype._getInternalVisible=function(){return this._bInternalVisible};h.prototype._getTitleLevel=function(){var t=this.getTitleLevel();return t===c.Auto?this._getInternalTitleLevel():t};h.prototype._setInternalTitleLevel=function(t,e){if(t!==this._sInternalTitleLevel){this._sInternalTitleLevel=t;this._getTitleControl().setLevel(t);if(e){this.invalidate()}}};h.prototype._getInternalTitleLevel=function(){return this._sInternalTitleLevel};h.prototype._getImportance=function(){return this.getImportance()};h.prototype._getObjectPageLayout=function(){return o.Utilities.getClosestOPL(this)};h.prototype._notifyObjectPageLayout=function(){if(this._getObjectPageLayout()&&this._getObjectPageLayout().$().length){this._getObjectPageLayout()._requestAdjustLayoutAndUxRules()}};h.prototype._getARIALevel=function(){var t=this._getTitleLevel();if(t===c.Auto){t=c.H2}return t.slice(-1)};["addAggregation","insertAggregation","removeAllAggregation","removeAggregation","destroyAggregation"].forEach(function(t){h.prototype[t]=function(i,n,o,r){if(["addAggregation","removeAggregation"].indexOf(t)>-1){r=o}if(["removeAllAggregation","destroyAggregation"].indexOf(t)>-1){r=n}var s=e.prototype[t].apply(this,arguments);if(r!==true){this._notifyObjectPageLayout()}return s}});h.prototype.setVisible=function(t,e){if(this.getVisible()===t){return this}if(!this._getObjectPageLayout()){return this.setProperty("visible",t,e)}this.setProperty("visible",t,true);this._notifyObjectPageLayout();this.invalidate();return this};h.prototype.setTitle=function(t,e){this.setProperty("title",t,e);this._notifyObjectPageLayout();this._getTitleControl().setText(t);this.setTitleVisible();return this};h.prototype.setTitleLevel=function(t){this.setProperty("titleLevel",t);this._getTitleControl().setLevel(t);return this};h.prototype._shouldBeHidden=function(){return h._importanceMap[this._getImportance()]>h._importanceMap[this._sCurrentLowestImportanceLevelToShow]};h._importanceMap={Low:3,Medium:2,High:1};h.prototype._updateShowHideState=function(t){var e=this._getObjectPageLayout();this._isHidden=t;this.setTitleVisible();this.$().children(this._sContainerSelector).toggle(!t);this._updateShowHideButton(t);if(e){e._requestAdjustLayout()}return this};h.prototype._getIsHidden=function(){return this._isHidden};h.prototype._expandSection=function(){return this._updateShowHideState(false)};h.prototype._showHideContent=function(){return this._updateShowHideState(!this._getIsHidden())};h.prototype._applyImportanceRules=function(t){var e=this._sCurrentLowestImportanceLevelToShow!==t,i;this._sCurrentLowestImportanceLevelToShow=t;this.setTitleVisible();i=e?this._shouldBeHidden():this._getIsHidden();if(this.getDomRef()){this._updateShowHideState(i)}else{this._isHidden=i;this.setTitleVisible()}};h.prototype._updateShowHideButton=function(t){this._getShowHideButton().setVisible(this._shouldBeHidden()).setText(this._getShowHideButtonText(!t))};h.prototype._getShowHideButton=function(){if(!this.getAggregation("_showHideButton")){this.setAggregation("_showHideButton",new p({visible:this._shouldBeHidden(),text:this._getShowHideButtonText(!this._getIsHidden()),press:this._showHideContent.bind(this),type:g.Transparent}).addStyleClass("sapUxAPShowHideButton"),true)}return this.getAggregation("_showHideButton")};h.prototype._getShowHideButtonText=function(t){return h._getLibraryResourceBundle().getText(t?"HIDE":"SHOW")};h.prototype._getImportanceLevelToHide=function(t){var e=this._getObjectPageLayout(),i=t||this._getCurrentMediaContainerRange(),n=e&&e.getShowOnlyHighImportance();return this._determineTheLowestLevelOfImportanceToShow(i.name,n)};h.prototype._determineTheLowestLevelOfImportanceToShow=function(t,e){if(e||t==="Phone"){return o.Importance.High}if(t==="Tablet"){return o.Importance.Medium}return o.Importance.Low};h.PAGEUP_AND_PAGEDOWN_JUMP_SIZE=5;h.prototype.onkeydown=function(t){if(t.keyCode===a.SPACE&&t.srcControl.isA("sap.uxap.ObjectPageSection")){t.preventDefault()}if(t.keyCode===a.F7){var e=this.getSubSections(),i=e[0],n;if(e.length===1){n=i._oLastFocusedControlF7;if(n){n.$().trigger("focus")}else{i.$().firstFocusableDomRef().focus()}}else{if(i.getActions().length){i.getActions()[0].$().trigger("focus")}}}};h.prototype.onsapdown=function(t){var e=t.currentTarget,i=e.nextSibling;if(e.classList.contains("sapUxAPObjectPageSubSection")){var n=e.parentElement;if(n.nextElementSibling){i=n.nextElementSibling.querySelector(".sapUxAPObjectPageSubSection")}}this._handleFocusing(t,i)};h.prototype._handleFocusing=function(t,e){var i;if(this._targetIsCorrect(t)&&e){i=jQuery(t.currentTarget).parent().children();t.preventDefault();e.focus();if(i.length>1){this._scrollParent(jQuery(e).attr("id"))}}};h.prototype._targetIsCorrect=function(t){return t.srcControl===this};h.prototype.onsapright=function(t){var e=this._bRtl?"onsapup":"onsapdown";this[e](t)};h.prototype.onsapup=function(t){var e=t.currentTarget,i=e.previousSibling;if(e.classList.contains("sapUxAPObjectPageSubSection")){var n=e.parentElement;if(n.previousElementSibling){i=n.previousElementSibling.querySelector(".sapUxAPObjectPageSubSection")}}this._handleFocusing(t,i)};h.prototype.onsapleft=function(t){var e=this._bRtl?"onsapdown":"onsapup";this[e](t)};h.prototype.onsaphome=function(t){var e=t.currentTarget,i=e.parentElement.firstChild;if(e.classList.contains("sapUxAPObjectPageSubSection")){i=e.closest(".sapUxAPObjectPageSection").querySelector(".sapUxAPObjectPageSubSection")}this._handleFocusing(t,i)};h.prototype.onsapend=function(t){var e=t.currentTarget,i=e.parentElement.lastChild,n;if(e.classList.contains("sapUxAPObjectPageSubSection")){n=e.closest(".sapUxAPObjectPageSection").querySelectorAll(".sapUxAPObjectPageSubSection");i=n[n.length-1]}this._handleFocusing(t,i)};h.prototype.onsappageup=function(t){if(!this._targetIsCorrect(t)){return}t.preventDefault();var e,i=t.currentTarget;var n=jQuery(i).parent().children();var o;if(i.classList.contains("sapUxAPObjectPageSubSection")){n=jQuery(i.closest(".sapUxAPObjectPageSection")).find(".sapUxAPObjectPageSubSection")}n.each(function(i,n){if(jQuery(n).attr("id")===t.currentTarget.id){e=i-(h.PAGEUP_AND_PAGEDOWN_JUMP_SIZE+1);return}});if(e&&n[e]){n[e].focus();o=jQuery(n[e]).attr("id")}else if(n[0]){n[0].focus();o=jQuery(n[0]).attr("id")}if(n.length>1){this._scrollParent(o)}};h.prototype.onsappagedown=function(t){if(!this._targetIsCorrect(t)){return}t.preventDefault();var e,i=t.currentTarget;var n=jQuery(i).parent().children();var o;if(i.classList.contains("sapUxAPObjectPageSubSection")){n=jQuery(i.closest(".sapUxAPObjectPageSection")).find(".sapUxAPObjectPageSubSection")}n.each(function(i,n){if(jQuery(n).attr("id")===t.currentTarget.id){e=i+h.PAGEUP_AND_PAGEDOWN_JUMP_SIZE+1;return}});if(e&&n[e]){n[e].focus();o=jQuery(n[e]).attr("id")}else if(n[n.length-1]){n[n.length-1].focus();o=jQuery(n[n.length-1]).attr("id")}if(n.length>1){this._scrollParent(o)}};h.prototype._scrollParent=function(t){if(this._getObjectPageLayout()){this._getObjectPageLayout().scrollToSection(t,0,10)}};return h});
//# sourceMappingURL=ObjectPageSectionBase.js.map