/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Element","sap/ui/core/Lib","sap/ui/core/library","sap/ui/thirdparty/jquery","sap/ui/core/ResizeHandler","./ObjectPageSectionBase","./ObjectPageLazyLoader","./BlockBase","sap/m/Button","sap/ui/core/StashedControlSupport","sap/ui/base/ManagedObjectObserver","sap/m/Title","sap/m/TitlePropagationSupport","sap/m/OverflowToolbar","sap/m/ToolbarSpacer","./library","sap/m/library","./ObjectPageSubSectionRenderer","sap/base/Log","sap/ui/base/DataType","sap/ui/events/KeyCodes","sap/ui/dom/jquery/Focusable"],function(t,e,o,jQuery,i,r,n,s,a,l,h,g,u,c,p,d,f,_,y,b,S){"use strict";var A=f.ButtonType;var P=f.ToolbarStyle;var m=f.ToolbarDesign;var C=d.ObjectPageSubSectionMode;var v=d.ObjectPageSubSectionLayout;var T=o.TitleLevel;var B=r.extend("sap.uxap.ObjectPageSubSection",{metadata:{library:"sap.uxap",properties:{showTitle:{type:"boolean",group:"Appearance",defaultValue:true},_columnSpan:{type:"string",group:"Appearance",defaultValue:"all",visibility:"hidden"},mode:{type:"sap.uxap.ObjectPageSubSectionMode",group:"Appearance",defaultValue:C.Collapsed},titleUppercase:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"blocks",aggregations:{blocks:{type:"sap.ui.core.Control",multiple:true,singularName:"block"},moreBlocks:{type:"sap.ui.core.Control",multiple:true,singularName:"moreBlock"},actions:{type:"sap.ui.core.Control",multiple:true,singularName:"action"},_headerToolbar:{type:"sap.m.OverflowToolbar",multiple:false,visibility:"hidden"}},designtime:"sap/uxap/designtime/ObjectPageSubSection.designtime"},renderer:_});u.call(B.prototype,"blocks",function(){return this._getTitleDomId()});B.FIT_CONTAINER_CLASS="sapUxAPObjectPageSubSectionFitContainer";B.NUMBER_OF_ADDITIONAL_ACTIONS=2;B.COLUMN_SPAN={all:"all",auto:"auto"};B._getLibraryResourceBundle=function(){return e.getResourceBundleFor("sap.uxap")};B.prototype.init=function(){r.prototype.init.call(this);this._aStashedControls=[];this._aUnStashedControls=[];this._bUnstashed=false;this._bRenderedFirstTime=false;this._aAggregationProxy={blocks:[],moreBlocks:[]};this._$spacer=[];this._sContainerSelector=".sapUxAPBlockContainer";this._sMoreContainerSelector=".sapUxAPSubSectionSeeMoreContainer";this._oObserver=new h(B.prototype._observeChanges.bind(this));this._oBlocksObserver=new h(this._onBlocksChange.bind(this));this._switchSubSectionMode(this.getMode());this._initTitlePropagationSupport();this._sBorrowedTitleDomId=false;this._height="";this._fnActionSubstituteParentFunction=function(){return this}.bind(this);this._oTitle=null;this._bPromoted=false;this._sTitleStyle=T.H5;this._sTitleId=this.getId()+"-headerTitle";this._getTitleControl().addStyleClass("sapUxAPObjectPageSubSectionTitle");var t=this._getHeaderToolbar();t.insertContent(this._getTitleControl(),0);t.insertContent(new p,1)};B.prototype.getParent=function(){var t=r.prototype.getParent.apply(this,arguments);if(t&&t.isA("sap.ui.layout.Grid")){t=t.getParent()}return t};B.prototype.setParent=function(){var t=r.prototype.setParent.apply(this,arguments),e=this.getParent();if(e&&e.isA("sap.uxap.ObjectPageSection")&&this.sParentAggregationName!=="subSections"){this.sParentAggregationName="subSections"}return t};B.prototype._getTitleControl=function(){if(!this._oTitle){this._oTitle=new g(this._sTitleId,{titleStyle:this._getTitleStyle(),level:this._getTitleLevel()})}return this._oTitle};B.prototype._getTitleUpperCaseStyleClass=function(){return"sapUxAPObjectPageSubSectionTitleUppercase"};B.prototype._getAriaLabelledById=function(){if(this._isPromoted()){return""}else{return this._getTitleControl().getId()}};B.prototype.addAction=function(t){this._getHeaderToolbar().insertContent(t,B.NUMBER_OF_ADDITIONAL_ACTIONS+this.getActions().length);this._preProcessAction(t,"actions");return this};B.prototype.insertAction=function(t,e){var o=e+B.NUMBER_OF_ADDITIONAL_ACTIONS;this._getHeaderToolbar().insertContent(t,o);this._preProcessAction(t,"actions");return this};B.prototype.removeAction=function(t){this._getHeaderToolbar().removeContent(t);this._postProcessAction(t);return this.removeAggregation("actions",t)};B.prototype.removeAllActions=function(){var t=this._getHeaderToolbar(),e=this.getActions();e.forEach(function(e){t.removeContent(e);this._postProcessAction(e)},this);return this};B.prototype.destroyActions=function(){this._getHeaderToolbar().destroyContent();this.getActions().forEach(function(t){this._postProcessAction(t)},this);return this};B.prototype.getActions=function(){return this._getHeaderToolbar().getContent().slice(B.NUMBER_OF_ADDITIONAL_ACTIONS)};B.prototype.indexOfAction=function(t){return this.getActions().indexOf(t)};B.prototype._setIsPromoted=function(t,e){if(t!=this._bPromoted){this._bPromoted=t;if(e){this.invalidate()}}this.toggleStyleClass("sapUxAPObjectPageSubSectionPromoted",t)};B.prototype._isPromoted=function(){return this._bPromoted};B.prototype._getHeaderToolbar=function(){var t=this.getId()+"-_headerToolbar";if(!this.getAggregation("_headerToolbar")){this.setAggregation("_headerToolbar",new c({id:t,style:P.Clear,design:m.Transparent,width:"100%"}).addStyleClass("sapUxAPObjectPageSubSectionHeaderToolbar"),true)}return this.getAggregation("_headerToolbar")};B.prototype._preProcessAction=function(t,e){if(M(t._fnOriginalGetParent)){return}this._observeAction(t);t._fnOriginalGetParent=t.getParent;t.getParent=this._fnActionSubstituteParentFunction;t._sOriginalParentAggregationName=t.sParentAggregationName;t.sParentAggregationName=e};B.prototype._postProcessAction=function(t){if(!M(t._fnOriginalGetParent)){return}this._unobserveAction(t);t.getParent=t._fnOriginalGetParent;t._fnOriginalGetParent=null;t.sParentAggregationName=t._sOriginalParentAggregationName;t._sOriginalParentAggregationName=null};function M(t){return typeof t==="function"}B.prototype._isTitleVisible=function(){return this.getShowTitle()&&this.getTitle().trim()!==""};B.prototype._getImportance=function(){if(!this._isPromoted()){return this.getImportance()}var t=this.getParent()?.getImportance(),e=function(t,e){return o(t)>o(e)?t:e},o=function(t){return r._importanceMap[t]};return e(t,this.getImportance())};B.prototype._getWrapTitle=function(){if(this._isPromoted()){return this.getParent()?._getWrapTitle()}return true};B.prototype.getEffectiveTitleLevel=function(){if(this._isPromoted()){return this.getParent()?._getTitleLevel()}else{return this._getTitleLevel()}};B.prototype._getTitleStyle=function(){if(this._isPromoted()){return this.getParent()?._getTitleStyle()}return r.prototype._getTitleStyle.call(this)};B.prototype._updateShowHideState=function(t){if(this._getIsHidden()===t){return this}this.$().children(this._sMoreContainerSelector).toggle(!t);return r.prototype._updateShowHideState.call(this,t)};B.prototype._shouldBeHidden=function(){return r.prototype._shouldBeHidden.call(this)};B.prototype._getColumnSpan=function(){return this.getProperty("_columnSpan")};B.prototype._setColumnSpan=function(t){var e=this.getProperty("_columnSpan"),o;if(e===t){return}this.setProperty("_columnSpan",t);o=this.getParent();o&&o.invalidate();return this};B.prototype._getHeight=function(){return this._height};B.prototype._setHeight=function(t){var e,o;if(this._height===t){return}e=b.getType("sap.ui.core.CSSSize");if(!e.isValid(t)){throw new Error('"'+t+'" is of type '+typeof t+", expected "+e.getName()+' for property "_height" of '+this)}this._height=t;o=this.getDomRef();if(o){o.style.height=this._height;this._adaptDomHeight()}};B.prototype._toggleContentResizeListener=function(t){if(t&&!this._iResizeId){this._iResizeId=i.register(this._getContentWrapper(),this._adaptDomHeight.bind(this))}if(!t&&this._iResizeId){i.deregister(this._iResizeId);this._iResizeId=null}};B.prototype._getContentWrapper=function(){return this.getAggregation("_grid")};B.prototype._getTitleDomId=function(){if(this._sBorrowedTitleDomId){return this._sBorrowedTitleDomId}if(!this.getTitle().trim()){return false}return this.getId()+"-headerTitle"};B.prototype._setBorrowedTitleDomId=function(t){this._sBorrowedTitleDomId=t};B.prototype._expandSection=function(){r.prototype._expandSection.call(this);var t=this.getParent();t&&typeof t._expandSection==="function"&&t._expandSection();return this};B.prototype._updateImportance=function(t){var e=this._getImportanceLevelToHide(t);this._applyImportanceRules(e)};B.prototype._hasVisibleActions=function(){var t=this.getActions();if(t.length===0){return false}return t.filter(function(t){return t.getVisible()}).length>0};B.prototype._observeChanges=function(t){var e=t.name,o;if(e==="visible"){o=this.getTitle().trim()!=="";if(!o){this.$("header").toggleClass("sapUiHidden",!this._hasVisibleActions())}}};B.prototype._onBlocksChange=function(){var t=this._getObjectPageLayout();if(!this._bRenderedFirstTime){return}this._applyLayout(t)};B.prototype._observeAction=function(t){this._oObserver.observe(t,{properties:["visible"]})};B.prototype._unobserveAction=function(t){this._oObserver.unobserve(t,{properties:["visible"]})};["addStyleClass","toggleStyleClass","removeStyleClass"].forEach(function(t){B.prototype[t]=function(e,o){if(e===B.FIT_CONTAINER_CLASS){this._notifyObjectPageLayout()}return r.prototype[t].apply(this,arguments)}});B.prototype._unStashControls=function(){var e;this._aStashedControls.forEach(function(o){o.control.unstash();e=t.getElementById(o.control.getId());this.addAggregation(o.aggregationName,e,true)}.bind(this));this._aStashedControls=[]};B.prototype._unStashControlsAsync=function(){var e;if(!this._bUnstashed){this._aStashedControls.forEach(function(o){this._aUnStashedControls.push(o.control.unstash(true).then(function(){e=t.getElementById(o.control.getId());this.addAggregation(o.aggregationName,e,true)}.bind(this)))}.bind(this));this._bUnstashed=true}return Promise.all(this._aUnStashedControls).then(()=>{this._bUnstashed=false;this._aUnStashedControls=[];this._aStashedControls=[]})};B.prototype.connectToModels=function(){var t=this.getBlocks()||[],e=this.getMoreBlocks()||[],o=this.getMode();this._unStashControls();t.forEach(function(t){if(t instanceof s){if(!t.getMode()){t.setMode(o)}t.connectToModels()}});if(e.length>0&&o===C.Expanded){e.forEach(function(t){if(t instanceof s){if(!t.getMode()){t.setMode(o)}t.connectToModels()}})}};B.prototype.connectToModelsAsync=function(){var t=this.getBlocks()||[],e=this.getMoreBlocks()||[],o=this.getMode();return this._unStashControlsAsync().then(function(){t.forEach(function(t){if(t instanceof s){if(!t.getMode()){t.setMode(o)}t.connectToModels()}});if(e.length>0&&o===C.Expanded){e.forEach(function(t){if(t instanceof s){if(!t.getMode()){t.setMode(o)}t.connectToModels()}})}})};B.prototype._allowPropagationToLoadedViews=function(t){var e=this.getBlocks()||[],o=this.getMoreBlocks()||[];e.forEach(function(e){if(e instanceof s){e._allowPropagationToLoadedViews(t)}});o.forEach(function(e){if(e instanceof s){e._allowPropagationToLoadedViews(t)}})};B.prototype.clone=function(){Object.keys(this._aAggregationProxy).forEach(function(t){var e=this.mAggregations[t];if(!e||e.length===0){this.mAggregations[t]=this._aAggregationProxy[t]}},this);return r.prototype.clone.apply(this,arguments)};B.prototype._cleanProxiedAggregations=function(){var t=this._aAggregationProxy;Object.keys(t).forEach(function(e){t[e].forEach(function(t){t.destroy()})})};B.prototype._unobserveBlocks=function(){var t=this.getBlocks().concat(this.getMoreBlocks());t.forEach(function(t){t&&this._oBlocksObserver.unobserve(t,{properties:["visible"]})},this)};B.prototype.exit=function(){if(this._oSeeMoreButton){this._oSeeMoreButton.destroy();this._oSeeMoreButton=null}if(this._oSeeLessButton){this._oSeeLessButton.destroy();this._oSeeLessButton=null}this._getTitleControl().destroy();this._unobserveBlocks();this._oCurrentlyVisibleSeeMoreLessButton=null;this._cleanProxiedAggregations();if(r.prototype.exit){r.prototype.exit.call(this)}};B.prototype.onAfterRendering=function(){var t=this._getObjectPageLayout(),e=this.getParent();if(r.prototype.onAfterRendering){r.prototype.onAfterRendering.call(this)}if(!t){return}if(this.hasStyleClass(B.FIT_CONTAINER_CLASS)){this._toggleContentResizeListener(true)}this._$spacer=t.$("spacer");if(this._bShouldFocusSeeMoreLessButton&&document.activeElement===document.body){this._oCurrentlyVisibleSeeMoreLessButton.focus()}this._bShouldFocusSeeMoreLessButton=false;if(e&&e.hasStyleClass("sapUiTableOnObjectPageAdjustmentsForSection")&&!this.hasStyleClass("sapUiAdjustedSectionSubsectionWithoutTable")){this.getAggregation("_grid").setProperty("hSpacing",0)}};B.prototype.onBeforeRendering=function(){var t=this._getObjectPageLayout();if(!t){return}if(r.prototype.onBeforeRendering){r.prototype.onBeforeRendering.call(this)}this._toggleContentResizeListener(false);this.setTitleVisible();this._setAggregationProxy();this._applyLayout(t);this.refreshSeeMoreVisibility();this.toggleStyleClass("sapUxAPObjectPageSubSectionStashed",this._aStashedControls.length?true:false);this.toggleStyleClass("sapUxAPObjectPageSubSectionFocusable",this.getTitleVisible());this._updateImportance()};B.prototype._adaptDomHeight=function(){var t=this.getDomRef(),e=this._height,o=this.hasStyleClass(B.FIT_CONTAINER_CLASS);if(!t){return}if(o&&e){var i=t.scrollHeight,r=Math.ceil(parseFloat(e));t.style.height=i>r?"":e;this._height=t.style.height}};B.prototype._hasRestrictedHeight=function(){var t=this.getDomRef();if(!t){return}return parseInt(t.style.height)>0};B.prototype._applyLayout=function(t){var e,o=this.getMode(),i=t.getSubSectionLayout(),r=this._calculateLayoutConfiguration(i,t),n=this.getBlocks(),s=n.concat(this.getMoreBlocks());this._oLayoutConfig=r;this._resetLayoutData(s);if(o===C.Expanded){e=s}else{e=n}this._assignLayoutData(e,r);try{e.forEach(function(t){this._setBlockMode(t,o)},this)}catch(t){y.error("ObjectPageSubSection :: error while building layout "+i+": "+t)}return this};B.prototype._calculateLayoutConfiguration=function(t,e){var o={M:2,L:3,XL:4},i=o.L,r=o.XL,n=t===v.TitleOnLeft,s=e.getUseTwoColumnsForLargeScreen();if(n){i-=1;r-=1}if(s){i-=1}o.L=i;o.XL=r;return o};B.prototype.refreshSeeMoreVisibility=function(){var t=this._getSeeMoreButton(),e=this._getSeeLessButton();this._bBlockHasMore=!!this.getMoreBlocks().length;if(!this._bBlockHasMore){this._bBlockHasMore=this.getBlocks().some(function(t){if(t instanceof s&&t.getVisible()&&t.getShowSubSectionMore()){return true}})}this.toggleStyleClass("sapUxAPObjectPageSubSectionWithSeeMore",this._bBlockHasMore);t.toggleStyleClass("sapUxAPSubSectionSeeMoreButtonVisible",this._bBlockHasMore);e.toggleStyleClass("sapUxAPSubSectionSeeMoreButtonVisible",this._bBlockHasMore);return this._bBlockHasMore};B.prototype.setMode=function(t){if(this.getMode()!==t){this._switchSubSectionMode(t);if(this._bRenderedFirstTime){this.invalidate()}}return this};B.prototype.onkeydown=function(e){if(e.keyCode===S.SPACE&&e.srcControl.isA("sap.uxap.ObjectPageSubSection")){e.preventDefault()}if(e.keyCode===S.F7){e.stopPropagation();var o=t.getElementById(e.target.id);if(o instanceof B){this._handleSubSectionF7()}else if(!e.isMarked()){this._handleInteractiveElF7();this._oLastFocusedControlF7=o}}};B.prototype._handleInteractiveElF7=function(){if(this.getParent().getSubSections().length>1){this.$().trigger("focus")}else{this.getParent().$().trigger("focus")}};B.prototype._handleSubSectionF7=function(t){if(this._oLastFocusedControlF7){this._oLastFocusedControlF7.$().trigger("focus")}else{this.$().firstFocusableDomRef().focus()}};B.prototype._getMinRequiredColspan=function(){var t=this._getColumnSpan(),e,o,i;if(t===B.COLUMN_SPAN.auto){e=this.getBlocks().concat(this.getMoreBlocks());o=e.filter(function(t){return t.getVisible&&t.getVisible()});return o.reduce(function(t,e){return t+this._getMinRequiredColspanForChild(e)}.bind(this),0)}i=parseInt(t);if(i>0&&i<=4){return i}return 4};B.prototype._getMinRequiredColspanForChild=function(t){var e=1;if(!t){e=0}else if(t instanceof s&&t.getColumnLayout()!="auto"){e=parseInt(t.getColumnLayout())}return e};B.prototype._allowAutoextendColspanForChild=function(t){return this._hasAutoLayout(t)};B.prototype._hasAutoLayout=function(t){return!(t instanceof s)||t.getColumnLayout()=="auto"};B.prototype._setAggregationProxy=function(){var t;if(this._bRenderedFirstTime){return}jQuery.each(this._aAggregationProxy,jQuery.proxy(function(e,o){t=this.removeAllAggregation(e,true);t.forEach(function(t){this._onAddBlock(t,e,true)},this);this._setAggregation(e,t,true)},this));this._bRenderedFirstTime=true};B.prototype.hasProxy=function(t){return this._bRenderedFirstTime&&this._aAggregationProxy.hasOwnProperty(t)};B.prototype._getAggregation=function(t){return this._aAggregationProxy[t]};B.prototype._setAggregation=function(t,e,o){this._aAggregationProxy[t]=e;if(o!==true){this._notifyObjectPageLayout();this.invalidate()}return this._aAggregationProxy[t]};B.prototype.addAggregation=function(t,e,o){var i;if(e instanceof n){if(e.isStashed()){this._aStashedControls.push({aggregationName:t,control:e})}else{e.getContent().forEach(function(e){this.addAggregation(t,e,true)},this);e.removeAllContent();e.destroy();this.invalidate()}}else if(this.hasProxy(t)){i=this._getAggregation(t);i.push(e);if(e instanceof s){e.setParent(this,t)}this._onAddBlock(e,t,o);this._setAggregation(t,i,o)}else{r.prototype.addAggregation.apply(this,arguments)}return this};B.prototype.insertBlock=function(t,e){y.warning("ObjectPageSubSection :: usage of insertBlock is not supported - addBlock is performed instead.");return this.addAggregation("blocks",t)};B.prototype._onAddBlock=function(t,e,o){if(!t){return}this._oBlocksObserver.observe(t,{properties:["visible"]});if(this._shouldForwardAggregationToGrid(e)){this._addBlockToGrid(t,o)}};B.prototype._shouldForwardAggregationToGrid=function(t){return t==="blocks"||t==="moreBlocks"&&this.getMode()===C.Expanded};B.prototype._addBlockToGrid=function(t,e){var o=this._getGrid();if(o?.indexOfContent(t)<0){o?.addAggregation("content",t,e)}};B.prototype._onRemoveBlock=function(t,e){if(!t){return}this._oBlocksObserver.unobserve(t,{properties:["visible"]});this._removeBlockFromGrid(t,e)};B.prototype._removeBlockFromGrid=function(t,e){var o=this._getGrid();if(o?.indexOfContent(t)>-1){o?.removeAggregation("content",t,e)}};B.prototype.insertMoreBlock=function(t,e){y.warning("ObjectPageSubSection :: usage of insertMoreBlock is not supported - addMoreBlock is performed instead.");return this.addAggregation("moreBlocks",t)};B.prototype.removeAllAggregation=function(t,e){var o;if(this.hasProxy(t)){o=this._getAggregation(t);this._setAggregation(t,[],e);o.forEach(function(t){this._onRemoveBlock(t)}.bind(this));return o.slice()}return r.prototype.removeAllAggregation.apply(this,arguments)};B.prototype.removeAggregation=function(t,e){var o=false,i;if(this.hasProxy(t)&&typeof e==="object"){i=this._getAggregation(t);i.forEach(function(r,n){if(r.getId()===e.getId()){i.splice(n,1);this._onRemoveBlock(e);this._setAggregation(t,i);o=true}return!o},this);return o?e:null}return r.prototype.removeAggregation.apply(this,arguments)};B.prototype.indexOfAggregation=function(t,e){var o=-1;if(this.hasProxy(t)){this._getAggregation(t).some(function(t,i){if(t.getId()===e.getId()){o=i;return true}},this);return o}return r.prototype.indexOfAggregation.apply(this,arguments)};B.prototype.getAggregation=function(t){if(this.hasProxy(t)){return this._getAggregation(t)}return r.prototype.getAggregation.apply(this,arguments)};B.prototype.destroyAggregation=function(t){if(this.hasProxy(t)){this._getAggregation(t).forEach(function(t){t.destroy()});this._setAggregation(t,[]);return this}return r.prototype.destroyAggregation.apply(this,arguments)};B.prototype.destroy=function(){this._aStashedControls.forEach(function(t){t.control.destroy()});r.prototype.destroy.apply(this,arguments)};B.prototype._getSeeMoreButton=function(){if(!this._oSeeMoreButton){this._oSeeMoreButton=new a(this.getId()+"--seeMore",{type:A.Transparent,iconFirst:false,text:B._getLibraryResourceBundle().getText("SHOW_MORE")}).addStyleClass("sapUxAPSubSectionSeeMoreButton").attachPress(this._seeMoreLessControlPressHandler,this)}return this._oSeeMoreButton};B.prototype._getSeeLessButton=function(){if(!this._oSeeLessButton){this._oSeeLessButton=new a(this.getId()+"--seeLess",{type:A.Transparent,iconFirst:false,text:B._getLibraryResourceBundle().getText("SHOW_LESS")}).addStyleClass("sapUxAPSubSectionSeeMoreButton").attachPress(this._seeMoreLessControlPressHandler,this)}return this._oSeeLessButton};B.prototype._seeMoreLessControlPressHandler=function(t){var e=this.getMode(),o,i=this.getMoreBlocks()||[];if(e===C.Expanded){o=C.Collapsed}else{o=C.Expanded;i.forEach(function(t){if(t instanceof s){t.setMode(e);t.connectToModels()}},this)}this._switchSubSectionMode(o);this._bShouldFocusSeeMoreLessButton=true};B.prototype._switchSubSectionMode=function(t){t=this.validateProperty("mode",t);if(t===C.Collapsed){this.setProperty("mode",C.Collapsed);this._oCurrentlyVisibleSeeMoreLessButton=this._getSeeMoreButton().setVisible(true);this._getSeeLessButton().setVisible(false);this.getMoreBlocks().forEach(function(t){this._removeBlockFromGrid(t)},this)}else{this.setProperty("mode",C.Expanded);this._getSeeMoreButton().setVisible(false);this._oCurrentlyVisibleSeeMoreLessButton=this._getSeeLessButton().setVisible(true);this.getMoreBlocks().forEach(function(t){this._addBlockToGrid(t)},this)}};B.prototype._setBlockMode=function(t,e){if(t instanceof s){t.setMode(e)}else{y.debug("ObjectPageSubSection :: cannot propagate mode "+e+" to "+t.getMetadata().getName())}};B.prototype._setToFocusable=function(t){if(this.getTitleVisible()){this.$().attr("tabindex",t?"0":"-1")}else{this.$().removeAttr("tabindex")}return this};B.prototype._getUseTitleOnTheLeft=function(){var t=this._getObjectPageLayout();return t&&t.getSubSectionLayout()===v.TitleOnLeft};B.prototype.getVisibleBlocksCount=function(){var t=this._aStashedControls.length;(this.getBlocks()||[]).forEach(function(e){if(!e){return}if(e.getVisible&&!e.getVisible()){return true}t++});(this.getMoreBlocks()||[]).forEach(function(e){if(e.getVisible&&!e.getVisible()){return true}t++});return t};return B});
//# sourceMappingURL=ObjectPageSubSection.js.map