// This file has been generated by the SAPUI5 CreateModule Ant-Task
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/** 
 * Device and Feature Detection API of the SAP UI5 Library.
 *
 * @version 1.20.6
 * @namespace
 * @name sap.ui.Device
 * @public
 */

//Declare Module if API is available
if(window.jQuery && window.jQuery.sap && window.jQuery.sap.declare){
	window.jQuery.sap.declare("sap.ui.Device", false);
}

//Introduce namespace if it does not yet exist
if(typeof window.sap !== "object" && typeof window.sap !== "function" ){
	  window.sap = {};
}
if(typeof window.sap.ui !== "object"){
	window.sap.ui = {};
}

(function() {

	//Skip initialization if API is already available
	if(typeof window.sap.ui.Device === "object" || typeof window.sap.ui.Device === "function" ){
		var apiVersion = "1.20.6";
		window.sap.ui.Device._checkAPIVersion(apiVersion);
		return;
	}
	
	var device = {};

////-------------------------- Logging -------------------------------------
	/* since we cannot use the logging from jquery.sap.global.js, we need to come up with a seperate
	 * solution for the device API
	 */
	// helper function for date formatting
	function pad0(i,w) { return ("000" + String(i)).slice(-w); }

	var FATAL=0, ERROR=1, WARNING=2, INFO=3, DEBUG=4, TRACE=5;

	var deviceLogger = function() {
		this.defaultComponent = 'DEVICE';
		this.sWindowName = (window.top == window) ? "" : "[" + window.location.pathname.split('/').slice(-1)[0] + "] ";
	// Creates a new log entry depending on its level and component.
		this.log = function (iLevel, sMessage, sComponent) {
			sComponent = sComponent || this.defaultComponent  || '';
				var oNow = new Date(),
					oLogEntry = {
						time     : pad0(oNow.getHours(),2)+":"+pad0(oNow.getMinutes(),2)+":"+pad0(oNow.getSeconds(),2),
						date     : pad0(oNow.getFullYear(),4) + "-" + pad0(oNow.getMonth()+1,2) + "-" + pad0(oNow.getDate(),2),
						timestamp: oNow.getTime(),
						level    : iLevel,
						message  : sMessage || "",
						component: sComponent || ""
					};
				if (window.console) { // in IE and FF, console might not exist; in FF it might even disappear
					var logText = oLogEntry.date + " " + oLogEntry.time + " " + this.sWindowName + oLogEntry.message + " - " + oLogEntry.component;
					switch(iLevel) {
					case FATAL:
					case ERROR: console.error(logText); break;
					case WARNING: console.warn(logText); break;
					case INFO: console.info ? console.info(logText) : console.log(logText); break;    // info not available in iOS simulator
					case DEBUG: console.debug ? console.debug(logText) : console.log(logText); break; // debug not available in IE, fallback to log
					case TRACE: console.trace ? console.trace(logText) : console.log(logText); break; // trace not available in IE, fallback to log (no trace)
					}
				}
				return oLogEntry;
		};
	};
// instantiate new logger		
	var logger = new deviceLogger();
	logger.log(INFO, "Device API logging initialized");
	
	
//******** Version Check ********
	
	//Only used internal to make clear when Device API is loaded in wrong version
	device._checkAPIVersion = function(sVersion){
		var v = "1.20.6";
		if(v != sVersion){
			logger.log(WARNING, "Device API version differs: "+v+" <-> "+sVersion);
		}
	}


//******** Event Management ******** (see Event Provider)

	var mEventRegistry = {};

	function attachEvent(sEventId, fnFunction, oListener) {
		if(!mEventRegistry[sEventId]){
			mEventRegistry[sEventId] = [];
		}
		mEventRegistry[sEventId].push({oListener: oListener, fFunction:fnFunction});
	};

	function detachEvent(sEventId, fnFunction, oListener) {
		var aEventListeners = mEventRegistry[sEventId];
		
		if (!aEventListeners) {
			return this;
		}

		for (var i = 0, iL = aEventListeners.length; i < iL; i++) {
			if (aEventListeners[i].fFunction === fnFunction && aEventListeners[i].oListener === oListener) {
				aEventListeners.splice(i,1);
				break;
			}
		}
		if(aEventListeners.length == 0) {
			delete mEventRegistry[sEventId];
		}
	};

	function fireEvent(sEventId, mParameters) {
		var aEventListeners = mEventRegistry[sEventId], oInfo;
		if (aEventListeners) {
			aEventListeners = aEventListeners.slice();
			for (var i = 0, iL = aEventListeners.length; i < iL; i++) {
				oInfo = aEventListeners[i];
				oInfo.fFunction.call(oInfo.oListener || window, mParameters);
			}
		}
	};

//******** OS Detection ********

	/** 
	 * Contains information about the operating system of the device.
	 * 
	 * @namespace
	 * @name sap.ui.Device.os
	 * @public
	 */
	/**
	 * Enumeration containing the names of known operating systems.
	 * 
	 * @namespace
	 * @name sap.ui.Device.os.OS
	 * @public
	 */
	/**
	 * The name of the operating system.
	 * 
	 * @see sap.ui.Device.os#OS
	 * @name sap.ui.Device.os#name
	 * @type String
	 * @public
	 */
	/**
	 * The version as string. Might be empty if no version can be determined.
	 * 
	 * @name sap.ui.Device.os#versionStr
	 * @type String
	 * @public
	 */
	/**
	 * The version as float. Might be -1 if no version can be determined.
	 * 
	 * @name sap.ui.Device.os#version
	 * @type float
	 * @public
	 */
	/**
	 * Flag indicating the Windows operating system.
	 * 
	 * @name sap.ui.Device.os#windows
	 * @type boolean
	 * @public
	 */
	/**
	 * Flag indicating the Linux operating system.
	 * 
	 * @name sap.ui.Device.os#linux
	 * @type boolean
	 * @public
	 */
	/**
	 * Flag indicating the MAC operating system.
	 * 
	 * @name sap.ui.Device.os#macintosh
	 * @type boolean
	 * @public
	 */
	/**
	 * Flag indicating the iOS operating system.
	 * 
	 * @name sap.ui.Device.os#ios
	 * @type boolean
	 * @public
	 */
	/**
	 * Flag indicating the Android operating system.
	 * 
	 * @name sap.ui.Device.os#android
	 * @type boolean
	 * @public
	 */
	/**
	 * Flag indicating the Blackberry operating system.
	 * 
	 * @name sap.ui.Device.os#blackberry
	 * @type boolean
	 * @public
	 */
	/**
	 * Flag indicating the Windows Phone operating system.
	 * 
	 * @name sap.ui.Device.os#windows_phone
	 * @type boolean
	 * @public
	 */
	
	/**
	 * Windows operating system name.
	 * 
	 * @see sap.ui.Device.os#name
	 * @name sap.ui.Device.os.OS#WINDOWS
	 * @public
	 */
	/**
	 * MAC operating system name.
	 * 
	 * @see sap.ui.Device.os#name
	 * @name sap.ui.Device.os.OS#MACINTOSH
	 * @public
	 */
	/**
	 * Linux operating system name.
	 * 
	 * @see sap.ui.Device.os#name
	 * @name sap.ui.Device.os.OS#LINUX
	 * @public
	 */
	/**
	 * iOS operating system name.
	 * 
	 * @see sap.ui.Device.os#name
	 * @name sap.ui.Device.os.OS#IOS
	 * @public
	 */
	/**
	 * Android operating system name.
	 * 
	 * @see sap.ui.Device.os#name
	 * @name sap.ui.Device.os.OS#ANDROID
	 * @public
	 */
	/**
	 * Blackberry operating system name.
	 * 
	 * @see sap.ui.Device.os#name
	 * @name sap.ui.Device.os.OS#BLACKBERRY
	 * @public
	 */
	/**
	 * Windows Phone operating system name.
	 * 
	 * @see sap.ui.Device.os#name
	 * @name sap.ui.Device.os.OS#WINDOWS_PHONE
	 * @public
	 */
	
	var OS = {
		"WINDOWS": "win",
		"MACINTOSH": "mac",
		"LINUX": "linux",
		"IOS": "iOS",
		"ANDROID": "Android",
		"BLACKBERRY": "bb",
		"WINDOWS_PHONE": "winphone"
	};

	function getOS(userAgent){ // may return null!!
		function getDesktopOS(){
			var pf = navigator.platform;
			if(pf.indexOf("Win") != -1 ){
				// userAgent in windows 7 contains: windows NT 6.1
				// userAgent in windows 8 contains: windows NT 6.2 or higher
				// TODO: update this after windows 9 is released
				var rVersion = /windows NT 6.(\d)/i;
				var result = userAgent.match(rVersion);
				var sVersionStr = "";
				if(result){
					if(result[1] == 1){
						sVersionStr = "7";
					}else if(result[1] > 1){
						sVersionStr = "8";
					}
				}
				return {"name": OS.WINDOWS, "versionStr": sVersionStr};
			}else if(pf.indexOf("Mac") != -1){
				return {"name": OS.MACINTOSH, "versionStr": ""};
			}else if(pf.indexOf("Linux") != -1){
				return {"name": OS.LINUX, "versionStr": ""};
			}
			logger.log(INFO, "OS detection returned no result");
			return null;
		}

		userAgent = userAgent || navigator.userAgent;
		var platform = /\(([a-zA-Z ]+);\s(?:[U]?[;]?)([\D]+)((?:[\d._]*))(?:.*[\)][^\d]*)([\d.]*)\s/;
		var result = userAgent.match(platform);
		if (result){
			var appleDevices = /iPhone|iPad|iPod/;
			var bbDevices = /PlayBook|BlackBerry/;
			if (result[0].match(appleDevices)){
				result[3] = result[3].replace(/_/g, ".");
				//result[1] contains info of devices
				return({"name": OS.IOS, "versionStr": result[3]});
			} else if (result[2].match(/Android/)) {
				result[2] = result[2].replace(/\s/g, "");
				return({"name": OS.ANDROID, "versionStr": result[3]});
			} else if (result[0].match(bbDevices)) {
				return({"name": OS.BLACKBERRY, "versionStr": result[4]});
			} else {
				// currently we only support iOS, Android, BlackBerry 6.0+ , everything else will be ignored, if more platforms should be supported, logic can be placed here
				return getDesktopOS();
			} 

		} else if (userAgent.indexOf("(BB10;") > 0) { 
			// BlackBery 10 has a different structure...
			platform = /\sVersion\/([\d.]+)\s/;
			result = userAgent.match(platform);
			if (result){
				return {"name": OS.BLACKBERRY, "versionStr": result[1]};
			} else {
				return {"name": OS.BLACKBERRY, "versionStr": '10'};
			}

		} else {
			// Windows phone has a different structure, so we need to check with another regExp.
			platform = /Windows Phone (?:OS )?([\d.]*)/;
			result = userAgent.match(platform);
			if (result){
				return({"name": OS.WINDOWS_PHONE, "versionStr": result[1]});
			} else {
				return getDesktopOS();
			}
		}
	};
	
	function setOS() {
		device.os = getOS() || {};
		device.os.OS = OS;
		device.os.version = device.os.versionStr ? parseFloat(device.os.versionStr) : -1;

		if(device.os.name){
			for(var b in OS){
				if(OS[b] === device.os.name){
					device.os[b.toLowerCase()] = true;
				}
			}
		}
	}
	setOS();



//******** Browser Detection ********
	
	/** 
	 * Contains information about the used browser.
	 * 
	 * @namespace
	 * @name sap.ui.Device.browser
	 * @public
	 */
	
	/**
	 * Enumeration containing the names of known browsers.
	 * 
	 * @namespace
	 * @name sap.ui.Device.browser.BROWSER
	 * @public
	 */
	
	/**
	 * The name of the browser.
	 * 
	 * @see sap.ui.Device.browser#BROWSER
	 * @name sap.ui.Device.browser#name
	 * @type String
	 * @public
	 */
	/**
	 * The version as string. Might be empty if no version can be determined.
	 * 
	 * @name sap.ui.Device.browser#versionStr
	 * @type String
	 * @public
	 */
	/**
	 * The version as float. Might be -1 if no version can be determined.
	 * 
	 * @name sap.ui.Device.browser#version
	 * @type float
	 * @public
	 */
	/**
	 * Flag indicating whether the mobile variant of the browser is used.
	 * 
	 * @name sap.ui.Device.browser#mobile
	 * @type boolean
	 * @public
	 */
	/**
	 * Flag indicating the Internet Explorer browser.
	 * 
	 * @name sap.ui.Device.browser#internet_explorer
	 * @type boolean
	 * @deprecated since 1.20: use sap.ui.Device.browser.msie
	 * @public
	 */
	/**
	 * Flag indicating the Internet Explorer browser.
	 * 
	 * @name sap.ui.Device.browser#msie
	 * @type boolean
	 * @since 1.20.0
	 * @public
	 */
	/**
	 * Flag indicating the Firefox browser.
	 * 
	 * @name sap.ui.Device.browser#firefox
	 * @type boolean
	 * @public
	 */
	/**
	 * Flag indicating the Chrome browser.
	 * 
	 * @name sap.ui.Device.browser#chrome
	 * @type boolean
	 * @public
	 */
	/**
	 * Flag indicating the Safari browser.
	 * 
	 * @name sap.ui.Device.browser#safari
	 * @type boolean
	 * @public
	 */
	/**
	 * Flag indicating a Webkit browser.
	 * 
	 * @name sap.ui.Device.browser#webkit
	 * @type boolean
	 * @since 1.20.0
	 * @public
	 */
	/**
	 * Flag indicating a Mozilla browser.
	 * 
	 * @name sap.ui.Device.browser#mozilla
	 * @type boolean
	 * @since 1.20.0
	 * @public
	 */
	/**
	 * Internet Explorer browser name.
	 * 
	 * @see sap.ui.Device.browser#name
	 * @name sap.ui.Device.browser.BROWSER#INTERNET_EXPLORER
	 * @public
	 */
	/**
	 * Firefox browser name.
	 * 
	 * @see sap.ui.Device.browser#name
	 * @name sap.ui.Device.browser.BROWSER#FIREFOX
	 * @public
	 */
	/**
	 * Chrome browser name.
	 * 
	 * @see sap.ui.Device.browser#name
	 * @name sap.ui.Device.browser.BROWSER#CHROME
	 * @public
	 */
	/**
	 * Safari browser name.
	 * 
	 * @see sap.ui.Device.browser#name
	 * @name sap.ui.Device.browser.BROWSER#SAFARI
	 * @public
	 */
	/**
	 * Android stock browser name.
	 * 
	 * @see sap.ui.Device.browser#name
	 * @name sap.ui.Device.browser.BROWSER#ANDROID
	 * @public
	 */
	
	var BROWSER = {
		"INTERNET_EXPLORER": "ie",
		"FIREFOX": "ff",
		"CHROME": "cr",
		"SAFARI": "sf",
		"ANDROID": "an"
	};

	var ua = navigator.userAgent;

	/*!
	 * Taken from jQuery JavaScript Library v1.7.1
	 * http://jquery.com/
	 *
	 * Copyright 2011, John Resig
	 * Dual licensed under the MIT or GPL Version 2 licenses.
	 * http://jquery.org/license
	 *
	 * Includes Sizzle.js
	 * http://sizzlejs.com/
	 * Copyright 2011, The Dojo Foundation
	 * Released under the MIT, BSD, and GPL Licenses.
	 *
	 * Date: Mon Nov 21 21:11:03 2011 -0500
	 */
	function calcBrowser(customUa){
		var _ua = (customUa || ua).toLowerCase(); // use custom user-agent if given

		var rwebkit = /(webkit)[ \/]([\w.]+)/;
		var ropera = /(opera)(?:.*version)?[ \/]([\w.]+)/;
		var rmsie = /(msie) ([\w.]+)/;
		//TODO this might needs to be adjusted in future IE version > 11
		var rmsienew = /(trident)\/[\w.]+;.*rv:([\w.]+)/;
		var rmozilla = /(mozilla)(?:.*? rv:([\w.]+))?/;

		var match = rwebkit.exec( _ua ) ||
					ropera.exec( _ua ) ||
					rmsie.exec( _ua ) ||
					rmsienew.exec( _ua ) ||
					_ua.indexOf("compatible") < 0 && rmozilla.exec( _ua ) ||
					[];

		var res = { browser: match[1] || "", version: match[2] || "0" };
		res[res.browser] = true;
		return res;
	};

	function getBrowser(customUa) {
		var b = calcBrowser(customUa);
		var _ua = customUa || ua;

		// jQuery checks for user agent strings. We differentiate between browsers
		if ( b.mozilla ) {
			if ( _ua.match(/Firefox\/(\d+\.\d+)/) ) {
				var version = parseFloat(RegExp.$1);
				return {
					name: BROWSER.FIREFOX,
					versionStr: ""+version,
					version: version,
					mozilla: true,
					mobile: false
				};
			} else {
				// unknown mozilla browser
				return {
					mobile: oExpMobile.test(_ua),
					mozilla: true
				};
			}
		} else if ( b.webkit ) {
			// webkit version is needed for calculation if the mobile android device is a tablet (calculation of other mobile devices work without)
			var regExpWebkitVersion = _ua.toLowerCase().match(/webkit[\/]([\d.]+)/);
			if (regExpWebkitVersion) {
				var webkitVersion = regExpWebkitVersion[1];
			}
			var oExpMobile = /Mobile/;
			if ( _ua.match(/Chrome\/(\d+\.\d+).\d+/) ) {
				var version = parseFloat(RegExp.$1);
				return {
					name: BROWSER.CHROME,
					versionStr: ""+version,
					version: version,
					mobile: oExpMobile.test(_ua),
					webkit: true,
					webkitVersion: webkitVersion
				};
			} else if( _ua.match(/Android .+ Version\/(\d+\.\d+)/) ) {
				var version = parseFloat(RegExp.$1);
				return {
					name: BROWSER.ANDROID,
					versionStr: ""+version,
					version: version,
					mobile: oExpMobile.test(_ua),
					webkit: true,
					webkitVersion: webkitVersion
				};
			} else { // Safari might have an issue with _ua.match(...); thus changing
				var oExp = /Version\/(\d+\.\d+).*Safari/;
				if(oExp.test(_ua)) {
					var version = parseFloat(oExp.exec(_ua)[1]);
					return {
						name: BROWSER.SAFARI,
						versionStr: ""+version,
						version: version,
						mobile: oExpMobile.test(_ua),
						webkit: true
					};
				}else{
					// unknown webkit browser
					return {
						mobile: oExpMobile.test(_ua),
						webkit: true,
						webkitVersion: webkitVersion
					};
				}
			}
		} else if ( b.msie || b.trident ) {
			var version;
			// recognize IE8 when running in compat mode (only then the documentMode property is there)
			if (document.documentMode && !customUa) { // only use the actual documentMode when no custom user-agent was given
				if(document.documentMode === 7) { // OK, obviously we are IE and seem to be 7... but as documentMode is there this cannot be IE7!
					version = 8.0;
				}else{
					version = parseFloat(document.documentMode);
				}
			} else {
				version = parseFloat(b.version);
			}
			return {
				name: BROWSER.INTERNET_EXPLORER,
				versionStr: ""+version,
				version: version,
				msie: true,
				mobile: false // TODO: really?
			};
		}
		return {
			name: "",
			versionStr: "",
			version: -1,
			mobile: false
		};
	};
	device._testUserAgent = getBrowser; // expose the user-agent parsing (mainly for testing), but don't let it be overwritten
	
	function setBrowser() {
		device.browser = getBrowser();
		device.browser.BROWSER = BROWSER;
		
		if(device.browser.name){
			for(var b in BROWSER){
				if(BROWSER[b] === device.browser.name){
					device.browser[b.toLowerCase()] = true;
				}
			}
		}
	}
	setBrowser();


	

//******** Support Detection ********
	
	/** 
	 * Contains information about detected capabilities of the used browser or device.
	 * 
	 * @namespace
	 * @name sap.ui.Device.support
	 * @public
	 */
	
	/**
	 * Flag indicating whether touch events are supported.
	 * 
	 * @name sap.ui.Device.support#touch
	 * @type boolean
	 * @public
	 */
	/**
	 * Flag indicating whether media queries via JavaScript are supported.
	 * 
	 * @name sap.ui.Device.support#matchmedia
	 * @type boolean
	 * @public
	 */
	/**
	 * Flag indicating whether events on JavaScript media queries are supported.
	 * 
	 * @name sap.ui.Device.support#matchmedialistener
	 * @type boolean
	 * @public
	 */
	/**
	 * Flag indicating whether the native orientationchange event is supported.
	 * 
	 * @name sap.ui.Device.support#orientation
	 * @type boolean
	 * @public
	 */
	/**
	 * Flag indicating whether the device has a Retina display.
	 * 
	 * @name sap.ui.Device.support#retina
	 * @type boolean
	 * @public
	 */
	/**
	 * Flag indicating whether WebSockets are supported.
	 * 
	 * @name sap.ui.Device.support#websocket
	 * @type boolean
	 * @public
	 */
	/**
	 * Flag indicating whether placeholder on input tags are supported.
	 * 
	 * @name sap.ui.Device.support#input.placeholder
	 * @type boolean
	 * @public
	 */

	device.support = {};

	//Maybe better to but this on device.browser because there are cases that a browser can touch but a device can't!
	device.support.touch = !!(('ontouchstart' in window) || window.DocumentTouch && document instanceof window.DocumentTouch);

	device.support.matchmedia = !!window.matchMedia;
	var m = device.support.matchmedia ? window.matchMedia("screen and (max-width:0px)") : null; //IE10 doesn't like empty string as argument for matchMedia, FF returns null when running within an iframe with display:none
	device.support.matchmedialistener = !!(m && m.addListener);
	if(device.browser.safari && device.browser.version < 6){
		//Safari seems to have addListener but no events are fired ?!
		device.support.matchmedialistener = false;
	}

	device.support.orientation = !!("orientation" in window && "onorientationchange" in window);

	device.support.retina = (window.retina||window.devicePixelRatio >= 2);

	device.support.websocket = ('WebSocket' in window);

	device.support.input = {};
	device.support.input.placeholder = ('placeholder' in document.createElement("input"));

//******** Match Media ********
	
	/** 
	 * Event API for Screen width media queries.
	 * 
	 * @namespace
	 * @name sap.ui.Device.media
	 * @public
	 */
	device.media = {};
	
	/**
	 * Enumeration containing the names of predefined Screen width media query range sets.
	 * 
	 * @namespace
	 * @name sap.ui.Device.media.RANGESETS
	 * @public
	 */
	
	/**
	 * A 3 step range set (S-L).
	 * 
	 * @name sap.ui.Device.media.RANGESETS#SAP_3STEPS
	 * @public
	 */
	/**
	 * A 4 step range set (S-XL).
	 * 
	 * @name sap.ui.Device.media.RANGESETS#SAP_4STEPS
	 * @public
	 */
	/**
	 * A 6 step range set (XS-XXL).
	 * 
	 * @name sap.ui.Device.media.RANGESETS#SAP_6STEPS
	 * @public
	 */
	/**
	 * A 3 step range set (Phone, Tablet, Desktop). <br/>
	 * <br/>
	 * This range set is initialized always by default.<br/>
	 * Phone is < 600px<br/>
	 * Tablet is 600px >= Tablet < 1024<br/>
	 * Desktop is > 1024px<br/>
	 * <br/>
	 * There are 5 css classes to hide elements based on the width of the screen:
	 * <ul>
	 * 	<li>sapUiHideOnPhone - will be hidden if the screen has 600px or more</li>
	 * 	<li>sapUiHideOnTablet - will be hidden if the screen has less than 600px or more than 1023px</li>
	 * 	<li>sapUiHideOnDesktop - will be hidden if the screen is smaller than 1024px</li>
	 * 	<li>sapUiVisibleOnlyOnPhone - will be visible if the screen has less than 600px</li>
	 * 	<li>sapUiVisibleOnlyOnTablet - will be visible if the screen has 600px or more but less than 1024px</li>
	 * 	<li>sapUiVisibleOnlyOnDesktop - will be visible if the screen has 1024px or more</li>
	 * </ul>
	 * @name sap.ui.Device.media.RANGESETS#SAP_STANDARD
	 * @public
	 */
	
	var RANGESETS = {
		"SAP_3STEPS": "3Step",
		"SAP_4STEPS": "4Step",
		"SAP_6STEPS": "6Step",
		"SAP_STANDARD": "Std"
	};
	device.media.RANGESETS = RANGESETS;
	
	device.media._predefinedRangeSets = {};
	device.media._predefinedRangeSets[RANGESETS.SAP_3STEPS] = {points: [520, 960], unit: "px", name: RANGESETS.SAP_3STEPS, names: ["S", "M", "L"]};
	device.media._predefinedRangeSets[RANGESETS.SAP_4STEPS] = {points: [520, 760, 960], unit: "px", name: RANGESETS.SAP_4STEPS, names: ["S", "M", "L", "XL"]};
	device.media._predefinedRangeSets[RANGESETS.SAP_6STEPS] = {points: [241, 400, 541, 768, 960], unit: "px", name: RANGESETS.SAP_6STEPS, names: ["XS", "S", "M", "L", "XL", "XXL"]};
	device.media._predefinedRangeSets[RANGESETS.SAP_STANDARD] = {points: [600, 1024], unit: "px", name: RANGESETS.SAP_STANDARD, names: ["Phone", "Tablet", "Desktop"]};
	
	var _defaultRangeSet = RANGESETS.SAP_STANDARD;
	var media_timeout = device.support.matchmedialistener ? 0 : 100;
	var _querysets = {};
	var media_currentwidth = null;
	
	function getQuery(from, to, unit){
		unit = unit || "px";
		var q = "screen";
		if(from > 0){
			q = q + " and (min-width:"+from+unit+")";
		}
		if(to > 0){
			q = q + " and (max-width:"+to+unit+")";
		}
		return q;
	};
	
	function handleChange(name){
		if(!device.support.matchmedialistener && media_currentwidth == windowSize()[0]){
			return; //Skip unnecessary resize events
		}
		
		if(_querysets[name].timer){
			clearTimeout(_querysets[name].timer);
			_querysets[name].timer = null;
		}
		
		_querysets[name].timer = setTimeout(function() {
			var mParams = checkQueries(name, false);
			if(mParams){
				fireEvent("media_"+name, mParams);
			}
		}, media_timeout);
	};
	
	function getRangeInfo(sSetName, iRangeIdx){
		var q = _querysets[sSetName].queries[iRangeIdx];
		var info = {from: q.from, unit: _querysets[sSetName].unit};
		if(q.to >= 0){
			info.to = q.to;
		}
		if(_querysets[sSetName].names){
			info.name = _querysets[sSetName].names[iRangeIdx];
		}
		return info;
	};
	
	function checkQueries(name, infoOnly){
		if(_querysets[name]){
			var aQueries = _querysets[name].queries;
			var info = null;
			for(var i=0, len = aQueries.length; i < len; i++){
				var q = aQueries[i];
				if((q != _querysets[name].currentquery || infoOnly) && device.media.matches(q.from, q.to, _querysets[name].unit)){
					if(!infoOnly){
						_querysets[name].currentquery = q;
					}
					if(!_querysets[name].noClasses && _querysets[name].names && !infoOnly){
						refreshCSSClasses(name, _querysets[name].names[i]);
					}
					info = getRangeInfo(name, i);
				}
			}
			
			return info;
		}
		logger.log(WARNING, "No queryset with name " + name + " found", 'DEVICE.MEDIA');
		return null;
	};
	
	function refreshCSSClasses(sSetName, sRangeName, bRemove){
		 var sClassPrefix = "sapUiMedia-"+sSetName+"-";
		 changeRootCSSClass(sClassPrefix+sRangeName, bRemove, sClassPrefix);
	};
	
	function changeRootCSSClass(sClassName, bRemove, sPrefix){
		var oRoot = document.documentElement;
		if (oRoot.className.length == 0){
			if(!bRemove){
				oRoot.className = sClassName;
			}
		}else{
			var aCurrentClasses = oRoot.className.split(" ");
			var sNewClasses = "";
			for(var i=0; i<aCurrentClasses.length; i++){
				if((sPrefix && aCurrentClasses[i].indexOf(sPrefix) != 0) || (!sPrefix && aCurrentClasses[i] != sClassName)){
					sNewClasses = sNewClasses + aCurrentClasses[i] + " ";
				}
			}
			if(!bRemove){
				sNewClasses = sNewClasses + sClassName;
			}
			oRoot.className = sNewClasses;
		}
	};
	
	function windowSize(){
		return [document.documentElement.clientWidth, document.documentElement.clientHeight];
	};
	
	function convertToPx(val, unit){
		if(unit === "em" || unit === "rem"){
			var s = window.getComputedStyle || function(e) {
	  			return e.currentStyle;
	  		};
	  		var x = s(document.documentElement).fontSize;
	  		var f = (x && x.indexOf("px") >= 0) ? parseFloat(x, 10) : 16;
	  		return val*f;
		}
		return val;
	};

	function match_legacy(from, to, unit){
		from = convertToPx(from, unit);
		to = convertToPx(to, unit);
		
		var width = windowSize()[0];
		var a = from < 0 || from <= width;
		var b = to < 0 || width <= to;
		return a && b;
	};

	function match(from, to, unit){
		var q = getQuery(from, to, unit);
		var m = window.matchMedia(q); //FF returns null when running within an iframe with display:none
		return m && m.matches;
	};

	device.media.matches = device.support.matchmedia ? match : match_legacy;
	
	/**
	 * Registers the given handler to the range change event, which is fired when a new range of the set is entered.
	 * 
	 * The handler has one map parameter <code>mParams</code>:
	 * <ul>
	 * <li>mParams.from: the range start value</li>
	 * <li>mParams.to: the range end value, not defined for the last range (INFINITY)</li>
	 * <li>mParams.unit: the used unit, e.g. px</li>
	 * <li>mParams.name: the range name if defined</li>
	 * </ul>
	 * 
	 * @param {Function} fnFunction The function to call, when the range change event occurs.
	 * @param {Object} [oListener] The 'this' context of the handler function.
	 * @param {String} sName The name of the range set to listen to.
	 * @name sap.ui.Device.media#attachHandler
	 * @function
	 * @public
	 */
	device.media.attachHandler = function(fnFunction, oListener, sName){
		var name = sName || _defaultRangeSet;
		attachEvent("media_"+name, fnFunction, oListener);
	};

	/**
	 * Deregisters a previously registered handler from the range change event.
	 * 
	 * @param {Function} fnFunction The function to call, when the range change event occurs.
	 * @param {Object} [oListener] The 'this' context of the handler function.
	 * @param {String} sName The name of the range set to listen to.
	 * @name sap.ui.Device.media#detachHandler
	 * @function
	 * @public
	 */
	device.media.detachHandler = function(fnFunction, oListener, sName){
		var name = sName || _defaultRangeSet;
		detachEvent("media_"+name, fnFunction, oListener);
	};
	
	/** 
	 * Initializes a Screen width media query range set.
	 * 
	 * This function can either be called only with the name parameter to initialize a predefined range set,
	 * e.g. <code>sap.ui.Device.media.initRangeSet(sap.ui.Device.media.RANGESETS.SAP_3STEPS)</code>.
	 * 
	 * Or it is possible to define a custom range set as in the following example:
	 * <code>sap.ui.Device.media.initRangeSet("MyRangeSet", [200, 400], "px", ["Small", "Medium", "Large"])</code> defines 3 ranges:
	 * <ul>
	 * <li>0px-199.999px with name "Small"</li>
	 * <li>200px-399.999px with name "Medium"</li>
	 * <li>400px-INFINITY with name "Large"</li>
	 * </ul>
	 * 
	 * The range names are optional. If they are specified also a CSS class (e.g. sapUiMedia-MyRangeSet-Small) is added to the document root
	 * depending on the current active range. This can be suppressed via parameter <code>bSuppressClasses</code>.
	 * 
	 * @param {String} sName The name of the range set. Either a predefined or custom one. The name must be a valid id (consist of letters and digits).
	 * @param {int[]} aRangeBorders The range borders
	 * @param {String} [sUnit] The unit which should be used. Allowed values are px (default), em or rem.
	 * @param {String[]} [aRangeNames] The names of the ranges. The names must be a valid id (consist of letters and digits).
	 * @param {boolean} [bSuppressClasses] Whether writing CSS classes to the document root should be suppressed
	 * @name sap.ui.Device.media#initRangeSet
	 * @function
	 * @public
	 */
	device.media.initRangeSet = function(sName, aRangeBorders, sUnit, aRangeNames, bSuppressClasses){	
		//TODO Do some Assertions and parameter checking
		var oConfig;
		if(!sName){
			oConfig = device.media._predefinedRangeSets[_defaultRangeSet];
		}else if(sName && device.media._predefinedRangeSets[sName]){
			oConfig = device.media._predefinedRangeSets[sName];
		}else{
			oConfig = {name: sName, unit: (sUnit || "px").toLowerCase(), points: aRangeBorders || [], names: aRangeNames, noClasses: !!bSuppressClasses};
		}
		
		if(device.media.hasRangeSet(oConfig.name)){
			return;
			logger.log(INFO, "Range set " + oConfig.name + " hase already been initialized", 'DEVICE.MEDIA');
		}
		
		sName = oConfig.name;
		oConfig.queries = [];
		oConfig.timer = null;
		oConfig.currentquery = null;
		oConfig.listener = function(){
			return handleChange(sName);
		};
			
		var from, to, query;
		var aPoints = oConfig.points;
		for(var i=0, len = aPoints.length; i <= len; i++){
			from = (i == 0) ? 0 : aPoints[i-1];
			to = (i == aPoints.length) ? -1 : aPoints[i];
			query = getQuery(from, to, oConfig.unit);
			oConfig.queries.push({
				query: query,
				from: from,
				to: to
			});
		};
		
		if(oConfig.names && oConfig.names.length != oConfig.queries.length){
			oConfig.names = null;
		}
		
		_querysets[oConfig.name] = oConfig;
			
		if(device.support.matchmedialistener){ //FF, Safari, Chrome, IE10?
			var queries = oConfig.queries;
			for(var i=0; i<queries.length; i++){
				var q = queries[i];
				q.media = window.matchMedia(q.query);
				q.media.addListener(oConfig.listener);
			}
		}else{ //IE, Safari (<6?)	
			if (window.addEventListener) {
				window.addEventListener("resize", oConfig.listener, false);
				window.addEventListener("orientationchange", oConfig.listener, false);
			}else{ //IE8
				window.attachEvent("onresize", oConfig.listener);
			}
		}
		
		oConfig.listener();
	};
	
	/**
	 * Returns information about the current active range of the range set with the given name.
	 * 
	 * @param {String} sName The name of the range set.
	 * @name sap.ui.Device.media#getCurrentRange
	 * @return {Map} the information about the current active range (same structure like the handler parameters (@see sap.ui.Device.media#attachHandler))
	 * @function
	 * @public
	 */
	device.media.getCurrentRange = function(sName){
		if(!device.media.hasRangeSet(sName)){
			return null;
		}
		return checkQueries(sName, true);
	};
	
	/**
	 * Returns whether a range set with the given name is initialized.
	 * 
	 * @param {String} sName The name of the range set.
	 * @name sap.ui.Device.media#hasRangeSet
	 * @return {boolean}
	 * @function
	 * @public
	 */
	device.media.hasRangeSet = function(sName){
		return sName && !!_querysets[sName];
	};
	
	/**
	 * Removes a previously initialized range set and detaches all registered handlers.
	 * 
	 * Initialized predefined range sets (@see sap.ui.Device.media#RANGESETS) cannot be removed.
	 * 
	 * @param {String} sName The name of the range set.
	 * @name sap.ui.Device.media#removeRangeSet
	 * @function
	 * @protected
	 */
	device.media.removeRangeSet = function(sName){
		if(!device.media.hasRangeSet(sName)){
			logger.log(INFO, "RangeSet " + sName + " not found, thus could not be removed.", 'DEVICE.MEDIA');
			return;
		}

		for(var x in RANGESETS){
			if(sName === RANGESETS[x]){
				logger.log(WARNING, "Cannot remove default rangeset - no action taken.", 'DEVICE.MEDIA');
				return; 
			}
		}
		
		var oConfig = _querysets[sName];
		if(device.support.matchmedialistener){ //FF, Safari, Chrome, IE10?
			var queries = oConfig.queries;
			for(var i=0; i<queries.length; i++){
				queries[i].media.removeListener(oConfig.listener);
			}
		}else{ //IE, Safari (<6?)	
			if (window.removeEventListener) {
				window.removeEventListener("resize", oConfig.listener, false);
				window.removeEventListener("orientationchange", oConfig.listener, false);
			}else{ //IE8
				window.detachEvent("onresize", oConfig.listener);
			}
		}
		
		refreshCSSClasses(sName, "", true);
		delete mEventRegistry["media_"+sName];
		delete _querysets[sName];
	};

//******** System Detection ********

	/** 
	 * Contains information about the system.
	 * 
	 * @namespace
	 * @name sap.ui.Device.system
	 * @public
	 */
	/**
	 * Enumeration containing the names of known types of the devices.
	 * 
	 * @namespace
	 * @name sap.ui.Device.system.SYSTEMTYPE
	 * @public
	 */
	/**
	 * Flag indicating if the device is a tablet.
	 * 
	 * @name sap.ui.Device.system#tablet
	 * @type boolean
	 * @public
	 */
	/**
	 * Flag indicating if the device is a phone.
	 * 
	 * @name sap.ui.Device.system#phone
	 * @type boolean
	 * @public
	 */
	/**
	 * Flag indicating if the device is a desktop.
	 * 
	 * @name sap.ui.Device.system#desktop
	 * @type boolean
	 * @public
	 */
	/**
	 * Flag indicating if the device is a combination of desktop and tablet.
	 * 
	 * This property is mainly targeting the windows 8 devices where the mouse and touch event may supported
	 * natively by the browser.
	 * 
	 * This property is set to true only when both mouse and touch event are natively supported.
	 * 
	 * @name sap.ui.Device.system#combi
	 * @type boolean
	 * @public
	 */

	var SYSTEMTYPE = {
			"TABLET" : "tablet",
			"PHONE" : "phone",
			"DESKTOP" : "desktop",
			"COMBI" : "combi"
	};

	var isWin8 = device.os.windows && device.os.version === 8;

	device.system = {};

	//TODO: Must also be called in the update function (see pending change https://git.wdf.sap.corp:8080/#/c/259290/)
	function getSystem(_simMobileOnDesktop) {
		var t = isTablet();
		
		var s = {};
		s.tablet = (device.support.touch || !!_simMobileOnDesktop) && t;
		s.phone = (device.support.touch || !!_simMobileOnDesktop) && !t;
		s.desktop = (!s.tablet && !s.phone) || isWin8;
		s.combi = (s.desktop && s.tablet);
		s.SYSTEMTYPE = SYSTEMTYPE;
		
		for(var type in SYSTEMTYPE){
			changeRootCSSClass("sap-"+SYSTEMTYPE[type], !s[SYSTEMTYPE[type]]);
		}
		return s;
	};

	function isTablet() {
		var android_phone = (/(?=android)(?=.*mobile)/i.test(navigator.userAgent));
		if (device.os.name === device.os.OS.IOS) {
			return /ipad/i.test(navigator.userAgent);
		} else {
			if(device.support.touch) {
				//in real mobile device
				var densityFactor = window.devicePixelRatio ? window.devicePixelRatio : 1; // may be undefined in Windows Phone devices
				if ((device.os.name === device.os.OS.ANDROID) && device.browser.webkit && (device.browser.webkitVersion > 537.10)) {
					// On Android sometimes window.screen.width returns the logical CSS pixels, sometimes the physical device pixels;
					// Tests on multiple devices suggest this depends on the Webkit version.
					// The Webkit patch which changed the behavior was done here: https://bugs.webkit.org/show_bug.cgi?id=106460
					// Chrome 27 with Webkit 537.36 returns the logical pixels,
					// Chrome 18 with Webkit 535.19 returns the physical pixels.
					// The BlackBerry 10 browser with Webkit 537.10+ returns the physical pixels.
					// So it appears like somewhere above Webkit 537.10 we do not hve to divide by the devicePixelRatio anymore.
					densityFactor = 1;
				}

				//this is how android distinguishes between tablet and phone
				//http://android-developers.blogspot.de/2011/07/new-tools-for-managing-screen-sizes.html
				var bTablet = (Math.min(window.screen.width / densityFactor, window.screen.height / densityFactor) >= 600);
				
				// special workaround for Nexus 7 where the window.screen.width is 600px or 601px in portrait mode (=> tablet) 
				// but window.screen.height 552px in landscape mode (=> phone), because the browser UI takes some space on top.
				// So the detected device type depends on the orientation :-(
				// actually this is a Chrome bug, as "width"/"height" should return the entire screen's dimensions and
				// "availWidth"/"availHeight" should return the size available after subtracting the browser UI
				if (isLandscape() 
						&& (window.screen.height === 552 || window.screen.height === 553) // old/new Nexus 7  
						&& (/Nexus 7/i.test(navigator.userAgent))) {
					bTablet = true;
				}
				
				return bTablet;

			} else {
				//in desktop browser
				var android_tablet = (device.os.name === device.os.OS.ANDROID) && !android_phone;
				return android_tablet;
			}
		}
	};
	
	function setSystem(_simMobileOnDesktop) {
		device.system = getSystem(_simMobileOnDesktop);
		if (device.system.tablet || device.system.phone) {
			device.browser.mobile = true;
		}
	}
	setSystem();

//******** Orientation Detection ********

	/** 
	 * Orientation Change Event API.
	 *
	 * @namespace
	 * @name sap.ui.Device.orientation
	 * @public
	 */

	device.orientation = {};

	/** 
	 * Resize Event API.
	 *
	 * @namespace
	 * @name sap.ui.Device.resize
	 * @public
	 */
	device.resize = {};
	
	/**
	 * Registers the given handler to the orientation change event.
	 *
	 * The handler has one map parameter <code>mParams</code>:
	 * <ul>
	 * <li>mParams.landscape: whether the orientation is currently landscape</li>
	 * </ul>
	 *
	 * @param {Function} fnFunction The function to call, when the orientation change event occurs.
	 * @param {Object} [oListener] The 'this' context of the handler function.
	 * @name sap.ui.Device.orientation#attachHandler
	 * @function
	 * @public
	 */
	device.orientation.attachHandler = function(fnFunction, oListener){
		attachEvent("orientation", fnFunction, oListener);
	};

	/**
	 * Registers the given handler to the resize event.
	 *
	 * The handler has one map parameter <code>mParams</code>:
	 * <ul>
	 * <li>mParams.height: new height of the window</li>
	 * <li>mParams.width: new width of the window</li>
	 * </ul>
	 *
	 * @param {Function} fnFunction The function to call, when the resize event occurs.
	 * @param {Object} [oListener] The 'this' context of the handler function.
	 * @name sap.ui.Device.resize#attachHandler
	 * @function
	 * @public
	 */
	device.resize.attachHandler = function(fnFunction, oListener){
		attachEvent("resize", fnFunction, oListener);
	};

	/**
	 * Deregisters a previously registered handler from the orientation change event.
	 * @param {Function} fnFunction The function to call, when the orientation change event occurs.
	 * @param {Object} [oListener] The 'this' context of the handler function.
	 * @name sap.ui.Device.orientation#detachHandler
	 * @function
	 * @public
	 */
	device.orientation.detachHandler = function(fnFunction, oListener){
		detachEvent("orientation", fnFunction, oListener);
	};

	/**
	 * Deregisters a previously registered handler from the resize event.
	 * @param {Function} fnFunction The function to call, when the resize event occurs.
	 * @param {Object} [oListener] The 'this' context of the handler function.
	 * @name sap.ui.Device.resize#detachHandler
	 * @function
	 * @public
	 */
	device.resize.detachHandler = function(fnFunction, oListener){
		detachEvent("resize", fnFunction, oListener);
	};

	function setOrientationInfo(oInfo){
		oInfo.landscape = isLandscape(true);
		oInfo.portrait = !oInfo.landscape;
	};

	function handleOrientationChange(){
		setOrientationInfo(device.orientation);
		fireEvent("orientation", {landscape: device.orientation.landscape});
	};

	function handleResizeChange(){
		setResizeInfo(device.resize);
		fireEvent("resize", {height: device.resize.height, width: device.resize.width});
	};

	function setResizeInfo(oInfo){
		oInfo.width = windowSize()[0];
		oInfo.height = windowSize()[1];
	};

	function handleOrientationResizeChange(){
		var wasL = device.orientation.landscape;
		var isL = isLandscape();
		if(wasL != isL){
			handleOrientationChange();
		}
		//throttle resize events because most browsers throw one or more resize events per pixel
		//for every resize event inside the period from 150ms (starting from the first resize event),
		//we only fire one resize event after this period
		if (!iResizeTimeout) {
			iResizeTimeout = window.setTimeout(handleResizeTimeout, 150);
		}
	};

	function handleResizeTimeout() {
		handleResizeChange();
		iResizeTimeout = null;
	};

	var bOrientationchange = false;
	var bResize = false;
	var iOrientationTimeout;
	var iResizeTimeout;
	var iClearFlagTimeout;
	var iWindowHeightOld = windowSize()[1];
	var iWindowWidthOld = windowSize()[0];
	var bKeyboardOpen = false;
	var iLastResizeTime;
	var rInputTagRegex = /INPUT|TEXTAREA|SELECT/;
	// On iPhone with iOS version 7.0.x and on iPad with iOS version 7.x (tested with all versions below 7.1.1), there's a invalide resize event fired
	// when changing the orientation while keyboard is shown.
	var bSkipFirstResize = device.os.ios && device.browser.name === "sf" && 
		((device.system.phone && device.os.version >= 7 && device.os.version < 7.1) || (device.system.tablet && device.os.version >= 7));
	
	function isLandscape(bFromOrientationChange){
		if (device.support.touch && device.support.orientation) {
			//if on screen keyboard is open and the call of this method is from orientation change listener, reverse the last value.
			//this is because when keyboard opens on android device, the height can be less than the width even in portrait mode.
			if(bKeyboardOpen && bFromOrientationChange){
				return !device.orientation.landscape;
			}
			//when keyboard opens, the last orientation change value will be retured.
			if(bKeyboardOpen){
				return device.orientation.landscape;
			}
			//otherwise compare the width and height of window
		} else {
			//most desktop browsers and windows phone/tablet which not support orientationchange
			if(device.support.matchmedia && device.support.orientation){
				return !!window.matchMedia("(orientation: landscape)").matches;
			}
		}
		var size = windowSize();
		return size[0] > size[1];
	};

	function handleMobileOrientationResizeChange(evt) {
		if (evt.type == "resize") {
			// supress the first invalid resize event fired before orientationchange event while keyboard is open on iPhone 7.0.x
			// because this event has wrong size infos
			if (bSkipFirstResize && rInputTagRegex.test(document.activeElement.tagName) && !bOrientationchange) {
				return;
			}

			var iWindowHeightNew = windowSize()[1];
			var iWindowWidthNew = windowSize()[0];
			var iTime = new Date().getTime();
			//skip multiple resize events by only one orientationchange
			if(iWindowHeightNew === iWindowHeightOld && iWindowWidthNew === iWindowWidthOld){
				return;
			}
			bResize = true;
			//on mobile devices opening the keyboard on some devices leads to a resize event
			//in this case only the height changes, not the width
			if ((iWindowHeightOld != iWindowHeightNew) && (iWindowWidthOld == iWindowWidthNew)) {
				//Asus Transformer tablet fires two resize events when orientation changes while keyboard is open.
				//Between these two events, only the height changes. The check of if keyboard is open has to be skipped because
				//it may be judged as keyboard closed but the keyboard is still open which will affect the orientation detection
				if(!iLastResizeTime || (iTime - iLastResizeTime > 300)){
					bKeyboardOpen = (iWindowHeightNew < iWindowHeightOld);
				}
				handleResizeChange();
			} else {
				iWindowWidthOld = iWindowWidthNew;
			}
			iLastResizeTime = iTime;
			iWindowHeightOld = iWindowHeightNew;

			if(iClearFlagTimeout){
				window.clearTimeout(iClearFlagTimeout);
				iClearFlagTimeout = null;
			}
			//Some Android build-in browser fires a resize event after the viewport is applied.
			//This resize event has to be dismissed otherwise when the next orientationchange event happens,
			//a UI5 resize event will be fired with the wrong window size.
			iClearFlagTimeout = window.setTimeout(clearFlags, 1200);
		} else if (evt.type == "orientationchange") {
			bOrientationchange = true;
		}

		if (iOrientationTimeout) {
			clearTimeout(iOrientationTimeout);
			iOrientationTimeout = null;
		}
		iOrientationTimeout = window.setTimeout(handleMobileTimeout, 50);
	};

	function handleMobileTimeout() {
		if (bOrientationchange && bResize) {
			handleOrientationChange();
			handleResizeChange();
			bOrientationchange = false;
			bResize = false;
			if(iClearFlagTimeout){
				window.clearTimeout(iClearFlagTimeout);
				iClearFlagTimeout = null;
			}
		}
		iOrientationTimeout = null;
	};

	function clearFlags(){
		bOrientationchange = false;
		bResize = false;
		iClearFlagTimeout = null;
	};

//******** Update browser settings for test purposes ********

	device._update = function(_simMobileOnDesktop) {
		ua = navigator.userAgent;
		logger.log(WARNING, "Device API values manipulated: NOT PRODUCTIVE FEATURE!!! This should be only used for test purposes. Only use if you know what you are doing.");
		setBrowser();
		setOS();
		setSystem(_simMobileOnDesktop);
	};

//********************************************************
	
	setResizeInfo(device.resize);
	setOrientationInfo(device.orientation);

	//Add API to global namespace
	window.sap.ui.Device = device;

	// Add handler for orientationchange and resize after initialization of Device API (IE8 fires onresize synchronously)
	if (device.support.touch && device.support.orientation) {
		//logic for mobile devices which support orientationchange (like ios, android, blackberry)
		window.addEventListener("resize", handleMobileOrientationResizeChange, false);
		window.addEventListener("orientationchange", handleMobileOrientationResizeChange, false);
	} else {
		if (window.addEventListener) {
			//most desktop browsers and windows phone/tablet which not support orientationchange
			window.addEventListener("resize", handleOrientationResizeChange, false);
		} else {
			//IE8
			window.attachEvent("onresize", handleOrientationResizeChange);
		}
	}

	//Always initialize the default media range set
	device.media.initRangeSet();

	// define module if API is available
	if (sap.ui.define) {
		sap.ui.define("sap/ui/Device", [], function() { return device; });
	}

}());

/*!
 * URI.js - Mutating URLs
 *
 * Version: 1.11.2
 *
 * Author: Rodney Rehm
 * Web: http://medialize.github.com/URI.js/
 *
 * Licensed under
 *   MIT License http://www.opensource.org/licenses/mit-license
 *   GPL v3 http://opensource.org/licenses/GPL-3.0
 *
 */
(function (root, factory) {
    // https://github.com/umdjs/umd/blob/master/returnExports.js
    if (typeof exports === 'object') {
        // Node
        module.exports = factory(require('./punycode'), require('./IPv6'), require('./SecondLevelDomains'));
    } else if (typeof define === 'function' && define.amd) {
        // AMD. Register as an anonymous module.
      // ##### BEGIN: MODIFIED BY SAP
      // define(['./punycode', './IPv6', './SecondLevelDomains'], factory);
      // we can't support loading URI.js via AMD define. URI.js is packaged with SAPUI5 code 
      // and define() doesn't execute synchronously. So the UI5 code executed after URI.js 
      // fails as it is missing the URI.js code.
      // Instead we use the standard init code and only expose the result via define()
      // The (optional) dependencies are lost or must be loaded in advance
      root.URI = factory(root.punycode, root.IPv6, root.SecondLevelDomains, root);
      define([], function() { return root.URI; });
      // ##### END: MODIFIED BY SAP
    } else {
        // Browser globals (root is window)
        root.URI = factory(root.punycode, root.IPv6, root.SecondLevelDomains, root);
    }
}(this, function (punycode, IPv6, SLD, root) {
"use strict";

// save current URI variable, if any
var _URI = root && root.URI;

function URI(url, base) {
    // Allow instantiation without the 'new' keyword
    if (!(this instanceof URI)) {
        return new URI(url, base);
    }

    if (url === undefined) {
        if (typeof location !== 'undefined') {
            url = location.href + "";
        } else {
            url = "";
        }
    }

    this.href(url);

    // resolve to base according to http://dvcs.w3.org/hg/url/raw-file/tip/Overview.html#constructor
    if (base !== undefined) {
        return this.absoluteTo(base);
    }

    return this;
};

var p = URI.prototype;
var hasOwn = Object.prototype.hasOwnProperty;

function escapeRegEx(string) {
    // https://github.com/medialize/URI.js/commit/85ac21783c11f8ccab06106dba9735a31a86924d#commitcomment-821963
    return string.replace(/([.*+?^=!:${}()|[\]\/\\])/g, '\\$1');
}

function getType(value) {
    // IE8 doesn't return [Object Undefined] but [Object Object] for undefined value
    if (value === undefined) {
        return 'Undefined';
    }

    return String(Object.prototype.toString.call(value)).slice(8, -1);
}

function isArray(obj) {
    return getType(obj) === "Array";
}

function filterArrayValues(data, value) {
    var lookup = {};
    var i, length;

    if (isArray(value)) {
        for (i = 0, length = value.length; i < length; i++) {
            lookup[value[i]] = true;
        }
    } else {
        lookup[value] = true;
    }

    for (i = 0, length = data.length; i < length; i++) {
        if (lookup[data[i]] !== undefined) {
            data.splice(i, 1);
            length--;
            i--;
        }
    }

    return data;
}

function arrayContains(list, value) {
    var i, length;
    
    // value may be string, number, array, regexp
    if (isArray(value)) {
        // Note: this can be optimized to O(n) (instead of current O(m * n))
        for (i = 0, length = value.length; i < length; i++) {
            if (!arrayContains(list, value[i])) {
                return false;
            }
        }
        
        return true;
    }
    
    var _type = getType(value);
    for (i = 0, length = list.length; i < length; i++) {
        if (_type === 'RegExp') {
            if (typeof list[i] === 'string' && list[i].match(value)) {
                return true;
            }
        } else if (list[i] === value) {
            return true;
        }
    }

    return false;
}

function arraysEqual(one, two) {
    if (!isArray(one) || !isArray(two)) {
        return false;
    }
    
    // arrays can't be equal if they have different amount of content
    if (one.length !== two.length) {
        return false;
    }

    one.sort();
    two.sort();

    for (var i = 0, l = one.length; i < l; i++) {
        if (one[i] !== two[i]) {
            return false;
        }
    }
    
    return true;
}

URI._parts = function() {
    return {
        protocol: null,
        username: null,
        password: null,
        hostname: null,
        urn: null,
        port: null,
        path: null,
        query: null,
        fragment: null,
        // state
        duplicateQueryParameters: URI.duplicateQueryParameters,
        escapeQuerySpace: URI.escapeQuerySpace
    };
};
// state: allow duplicate query parameters (a=1&a=1)
URI.duplicateQueryParameters = false;
// state: replaces + with %20 (space in query strings)
URI.escapeQuerySpace = true;
// static properties
URI.protocol_expression = /^[a-z][a-z0-9-+-]*$/i;
URI.idn_expression = /[^a-z0-9\.-]/i;
URI.punycode_expression = /(xn--)/i;
// well, 333.444.555.666 matches, but it sure ain't no IPv4 - do we care?
URI.ip4_expression = /^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/;
// credits to Rich Brown
// source: http://forums.intermapper.com/viewtopic.php?p=1096#1096
// specification: http://www.ietf.org/rfc/rfc4291.txt
URI.ip6_expression = /^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?\s*$/;
// gruber revised expression - http://rodneyrehm.de/t/url-regex.html
URI.find_uri_expression = /\b((?:[a-z][\w-]+:(?:\/{1,3}|[a-z0-9%])|www\d{0,3}[.]|[a-z0-9.\-]+[.][a-z]{2,4}\/)(?:[^\s()<>]+|\(([^\s()<>]+|(\([^\s()<>]+\)))*\))+(?:\(([^\s()<>]+|(\([^\s()<>]+\)))*\)|[^\s`!()\[\]{};:'".,<>?«»“”‘’]))/ig;
// http://www.iana.org/assignments/uri-schemes.html
// http://en.wikipedia.org/wiki/List_of_TCP_and_UDP_port_numbers#Well-known_ports
URI.defaultPorts = {
    http: "80",
    https: "443",
    ftp: "21",
    gopher: "70",
    ws: "80",
    wss: "443"
};
// allowed hostname characters according to RFC 3986
// ALPHA DIGIT "-" "." "_" "~" "!" "$" "&" "'" "(" ")" "*" "+" "," ";" "=" %encoded
// I've never seen a (non-IDN) hostname other than: ALPHA DIGIT . -
URI.invalid_hostname_characters = /[^a-zA-Z0-9\.-]/;
// map DOM Elements to their URI attribute
URI.domAttributes = {
    'a': 'href',
    'blockquote': 'cite',
    'link': 'href',
    'base': 'href',
    'script': 'src',
    'form': 'action',
    'img': 'src',
    'area': 'href',
    'iframe': 'src',
    'embed': 'src',
    'source': 'src',
    'track': 'src',
    'input': 'src' // but only if type="image"
};
URI.getDomAttribute = function(node) {
    if (!node || !node.nodeName) {
        return undefined;
    }
    
    var nodeName = node.nodeName.toLowerCase();
    // <input> should only expose src for type="image"
    if (nodeName === 'input' && node.type !== 'image') {
        return undefined;
    }
    
    return URI.domAttributes[nodeName];
};

function escapeForDumbFirefox36(value) {
    // https://github.com/medialize/URI.js/issues/91
    return escape(value);
}

// encoding / decoding according to RFC3986
function strictEncodeURIComponent(string) {
    // see https://developer.mozilla.org/en-US/docs/JavaScript/Reference/Global_Objects/encodeURIComponent
    return encodeURIComponent(string)
        .replace(/[!'()*]/g, escapeForDumbFirefox36)
        .replace(/\*/g, "%2A");
}
URI.encode = strictEncodeURIComponent;
URI.decode = decodeURIComponent;
URI.iso8859 = function() {
    URI.encode = escape;
    URI.decode = unescape;
};
URI.unicode = function() {
    URI.encode = strictEncodeURIComponent;
    URI.decode = decodeURIComponent;
};
URI.characters = {
    pathname: {
        encode: {
            // RFC3986 2.1: For consistency, URI producers and normalizers should
            // use uppercase hexadecimal digits for all percent-encodings.
            expression: /%(24|26|2B|2C|3B|3D|3A|40)/ig,
            map: {
                // -._~!'()*
                "%24": "$",
                "%26": "&",
                "%2B": "+",
                "%2C": ",",
                "%3B": ";",
                "%3D": "=",
                "%3A": ":",
                "%40": "@"
            }
        },
        decode: {
            expression: /[\/\?#]/g,
            map: {
                "/": "%2F",
                "?": "%3F",
                "#": "%23"
            }
        }
    },
    reserved: {
        encode: {
            // RFC3986 2.1: For consistency, URI producers and normalizers should
            // use uppercase hexadecimal digits for all percent-encodings.
            expression: /%(21|23|24|26|27|28|29|2A|2B|2C|2F|3A|3B|3D|3F|40|5B|5D)/ig,
            map: {
                // gen-delims
                "%3A": ":",
                "%2F": "/",
                "%3F": "?",
                "%23": "#",
                "%5B": "[",
                "%5D": "]",
                "%40": "@",
                // sub-delims
                "%21": "!",
                "%24": "$",
                "%26": "&",
                "%27": "'",
                "%28": "(",
                "%29": ")",
                "%2A": "*",
                "%2B": "+",
                "%2C": ",",
                "%3B": ";",
                "%3D": "="
            }
        }
    }
};
URI.encodeQuery = function(string, escapeQuerySpace) {
    var escaped = URI.encode(string + "");
    return escapeQuerySpace ? escaped.replace(/%20/g, '+') : escaped;
};
URI.decodeQuery = function(string, escapeQuerySpace) {
    string += "";
    try {
        return URI.decode(escapeQuerySpace ? string.replace(/\+/g, '%20') : string);
    } catch(e) {
        // we're not going to mess with weird encodings,
        // give up and return the undecoded original string
        // see https://github.com/medialize/URI.js/issues/87
        // see https://github.com/medialize/URI.js/issues/92
        return string;
    }
};
URI.recodePath = function(string) {
    var segments = (string + "").split('/');
    for (var i = 0, length = segments.length; i < length; i++) {
        segments[i] = URI.encodePathSegment(URI.decode(segments[i]));
    }

    return segments.join('/');
};
URI.decodePath = function(string) {
    var segments = (string + "").split('/');
    for (var i = 0, length = segments.length; i < length; i++) {
        segments[i] = URI.decodePathSegment(segments[i]);
    }

    return segments.join('/');
};
// generate encode/decode path functions
var _parts = {'encode':'encode', 'decode':'decode'};
var _part;
var generateAccessor = function(_group, _part) {
    return function(string) {
        return URI[_part](string + "").replace(URI.characters[_group][_part].expression, function(c) {
            return URI.characters[_group][_part].map[c];
        });
    };
};

for (_part in _parts) {
    URI[_part + "PathSegment"] = generateAccessor("pathname", _parts[_part]);
}

URI.encodeReserved = generateAccessor("reserved", "encode");

URI.parse = function(string, parts) {
    var pos;
    if (!parts) {
        parts = {};
    }
    // [protocol"://"[username[":"password]"@"]hostname[":"port]"/"?][path]["?"querystring]["#"fragment]

    // extract fragment
    pos = string.indexOf('#');
    if (pos > -1) {
        // escaping?
        parts.fragment = string.substring(pos + 1) || null;
        string = string.substring(0, pos);
    }

    // extract query
    pos = string.indexOf('?');
    if (pos > -1) {
        // escaping?
        parts.query = string.substring(pos + 1) || null;
        string = string.substring(0, pos);
    }

    // extract protocol
    if (string.substring(0, 2) === '//') {
        // relative-scheme
        parts.protocol = null;
        string = string.substring(2);
        // extract "user:pass@host:port"
        string = URI.parseAuthority(string, parts);
    } else {
        pos = string.indexOf(':');
        if (pos > -1) {
            parts.protocol = string.substring(0, pos) || null;
            if (parts.protocol && !parts.protocol.match(URI.protocol_expression)) {
                // : may be within the path
                parts.protocol = undefined;
            } else if (parts.protocol === 'file') {
                // the file scheme: does not contain an authority
                string = string.substring(pos + 3);
            } else if (string.substring(pos + 1, pos + 3) === '//') {
                string = string.substring(pos + 3);

                // extract "user:pass@host:port"
                string = URI.parseAuthority(string, parts);
            } else {
                string = string.substring(pos + 1);
                parts.urn = true;
            }
        }
    }

    // what's left must be the path
    parts.path = string;

    // and we're done
    return parts;
};
URI.parseHost = function(string, parts) {
    // extract host:port
    var pos = string.indexOf('/');
    var bracketPos;
    var t;

    if (pos === -1) {
        pos = string.length;
    }

    if (string.charAt(0) === "[") {
        // IPv6 host - http://tools.ietf.org/html/draft-ietf-6man-text-addr-representation-04#section-6
        // I claim most client software breaks on IPv6 anyways. To simplify things, URI only accepts
        // IPv6+port in the format [2001:db8::1]:80 (for the time being)
        bracketPos = string.indexOf(']');
        parts.hostname = string.substring(1, bracketPos) || null;
        parts.port = string.substring(bracketPos+2, pos) || null;
    } else if (string.indexOf(':') !== string.lastIndexOf(':')) {
        // IPv6 host contains multiple colons - but no port
        // this notation is actually not allowed by RFC 3986, but we're a liberal parser
        parts.hostname = string.substring(0, pos) || null;
        parts.port = null;
    } else {
        t = string.substring(0, pos).split(':');
        parts.hostname = t[0] || null;
        parts.port = t[1] || null;
    }

    if (parts.hostname && string.substring(pos).charAt(0) !== '/') {
        pos++;
        string = "/" + string;
    }

    return string.substring(pos) || '/';
};
URI.parseAuthority = function(string, parts) {
    string = URI.parseUserinfo(string, parts);
    return URI.parseHost(string, parts);
};
URI.parseUserinfo = function(string, parts) {
    // extract username:password
    var firstSlash = string.indexOf('/');
    var pos = firstSlash > -1 
        ? string.lastIndexOf('@', firstSlash) 
        : string.indexOf('@');
    var t;

    // authority@ must come before /path
    if (pos > -1 && (firstSlash === -1 || pos < firstSlash)) {
        t = string.substring(0, pos).split(':');
        parts.username = t[0] ? URI.decode(t[0]) : null;
        t.shift();
        parts.password = t[0] ? URI.decode(t.join(':')) : null;
        string = string.substring(pos + 1);
    } else {
        parts.username = null;
        parts.password = null;
    }

    return string;
};
URI.parseQuery = function(string, escapeQuerySpace) {
    if (!string) {
        return {};
    }

    // throw out the funky business - "?"[name"="value"&"]+
    string = string.replace(/&+/g, '&').replace(/^\?*&*|&+$/g, '');

    if (!string) {
        return {};
    }

    var items = {};
    var splits = string.split('&');
    var length = splits.length;
    var v, name, value;

    for (var i = 0; i < length; i++) {
        v = splits[i].split('=');
        name = URI.decodeQuery(v.shift(), escapeQuerySpace);
        // no "=" is null according to http://dvcs.w3.org/hg/url/raw-file/tip/Overview.html#collect-url-parameters
        value = v.length ? URI.decodeQuery(v.join('='), escapeQuerySpace) : null;

        if (items[name]) {
            if (typeof items[name] === "string") {
                items[name] = [items[name]];
            }

            items[name].push(value);
        } else {
            items[name] = value;
        }
    }

    return items;
};

URI.build = function(parts) {
    var t = "";

    if (parts.protocol) {
        t += parts.protocol + ":";
    }

    if (!parts.urn && (t || parts.hostname)) {
        t += '//';
    }

    t += (URI.buildAuthority(parts) || '');

    if (typeof parts.path === "string") {
        if (parts.path.charAt(0) !== '/' && typeof parts.hostname === "string") {
            t += '/';
        }

        t += parts.path;
    }

    if (typeof parts.query === "string" && parts.query) {
        t += '?' + parts.query;
    }

    if (typeof parts.fragment === "string" && parts.fragment) {
        t += '#' + parts.fragment;
    }
    return t;
};
URI.buildHost = function(parts) {
    var t = "";

    if (!parts.hostname) {
        return "";
    } else if (URI.ip6_expression.test(parts.hostname)) {
        if (parts.port) {
            t += "[" + parts.hostname + "]:" + parts.port;
        } else {
            // don't know if we should always wrap IPv6 in []
            // the RFC explicitly says SHOULD, not MUST.
            t += parts.hostname;
        }
    } else {
        t += parts.hostname;
        if (parts.port) {
            t += ':' + parts.port;
        }
    }

    return t;
};
URI.buildAuthority = function(parts) {
    return URI.buildUserinfo(parts) + URI.buildHost(parts);
};
URI.buildUserinfo = function(parts) {
    var t = "";

    if (parts.username) {
        t += URI.encode(parts.username);

        if (parts.password) {
            t += ':' + URI.encode(parts.password);
        }

        t += "@";
    }

    return t;
};
URI.buildQuery = function(data, duplicateQueryParameters, escapeQuerySpace) {
    // according to http://tools.ietf.org/html/rfc3986 or http://labs.apache.org/webarch/uri/rfc/rfc3986.html
    // being »-._~!$&'()*+,;=:@/?« %HEX and alnum are allowed
    // the RFC explicitly states ?/foo being a valid use case, no mention of parameter syntax!
    // URI.js treats the query string as being application/x-www-form-urlencoded
    // see http://www.w3.org/TR/REC-html40/interact/forms.html#form-content-type

    var t = "";
    var unique, key, i, length;
    for (key in data) {
        if (hasOwn.call(data, key) && key) {
            if (isArray(data[key])) {
                unique = {};
                for (i = 0, length = data[key].length; i < length; i++) {
                    if (data[key][i] !== undefined && unique[data[key][i] + ""] === undefined) {
                        t += "&" + URI.buildQueryParameter(key, data[key][i], escapeQuerySpace);
                        if (duplicateQueryParameters !== true) {
                            unique[data[key][i] + ""] = true;
                        }
                    }
                }
            } else if (data[key] !== undefined) {
                t += '&' + URI.buildQueryParameter(key, data[key], escapeQuerySpace);
            }
        }
    }

    return t.substring(1);
};
URI.buildQueryParameter = function(name, value, escapeQuerySpace) {
    // http://www.w3.org/TR/REC-html40/interact/forms.html#form-content-type -- application/x-www-form-urlencoded
    // don't append "=" for null values, according to http://dvcs.w3.org/hg/url/raw-file/tip/Overview.html#url-parameter-serialization
    return URI.encodeQuery(name, escapeQuerySpace) + (value !== null ? "=" + URI.encodeQuery(value, escapeQuerySpace) : "");
};

URI.addQuery = function(data, name, value) {
    if (typeof name === "object") {
        for (var key in name) {
            if (hasOwn.call(name, key)) {
                URI.addQuery(data, key, name[key]);
            }
        }
    } else if (typeof name === "string") {
        if (data[name] === undefined) {
            data[name] = value;
            return;
        } else if (typeof data[name] === "string") {
            data[name] = [data[name]];
        }

        if (!isArray(value)) {
            value = [value];
        }

        data[name] = data[name].concat(value);
    } else {
        throw new TypeError("URI.addQuery() accepts an object, string as the name parameter");
    }
};
URI.removeQuery = function(data, name, value) {
    var i, length, key;
    
    if (isArray(name)) {
        for (i = 0, length = name.length; i < length; i++) {
            data[name[i]] = undefined;
        }
    } else if (typeof name === "object") {
        for (key in name) {
            if (hasOwn.call(name, key)) {
                URI.removeQuery(data, key, name[key]);
            }
        }
    } else if (typeof name === "string") {
        if (value !== undefined) {
            if (data[name] === value) {
                data[name] = undefined;
            } else if (isArray(data[name])) {
                data[name] = filterArrayValues(data[name], value);
            }
        } else {
            data[name] = undefined;
        }
    } else {
        throw new TypeError("URI.addQuery() accepts an object, string as the first parameter");
    }
};
URI.hasQuery = function(data, name, value, withinArray) {
    if (typeof name === "object") {
        for (var key in name) {
            if (hasOwn.call(name, key)) {
                if (!URI.hasQuery(data, key, name[key])) {
                    return false;
                }
            }
        }
        
        return true;
    } else if (typeof name !== "string") {
        throw new TypeError("URI.hasQuery() accepts an object, string as the name parameter");
    }

    switch (getType(value)) {
        case 'Undefined':
            // true if exists (but may be empty)
            return name in data; // data[name] !== undefined;

        case 'Boolean':
            // true if exists and non-empty
            var _booly = Boolean(isArray(data[name]) ? data[name].length : data[name]);
            return value === _booly;

        case 'Function':
            // allow complex comparison
            return !!value(data[name], name, data);

        case 'Array':
            if (!isArray(data[name])) {
                return false;
            }

            var op = withinArray ? arrayContains : arraysEqual;
            return op(data[name], value);

        case 'RegExp':
            if (!isArray(data[name])) {
                return Boolean(data[name] && data[name].match(value));
            }

            if (!withinArray) {
                return false;
            }

            return arrayContains(data[name], value);

        case 'Number':
            value = String(value);
            // omit break;
        case 'String':
            if (!isArray(data[name])) {
                return data[name] === value;
            }

            if (!withinArray) {
                return false;
            }

            return arrayContains(data[name], value);

        default:
            throw new TypeError("URI.hasQuery() accepts undefined, boolean, string, number, RegExp, Function as the value parameter");
    }
};


URI.commonPath = function(one, two) {
    var length = Math.min(one.length, two.length);
    var pos;

    // find first non-matching character
    for (pos = 0; pos < length; pos++) {
        if (one.charAt(pos) !== two.charAt(pos)) {
            pos--;
            break;
        }
    }

    if (pos < 1) {
        return one.charAt(0) === two.charAt(0) && one.charAt(0) === '/' ? '/' : '';
    }
    
    // revert to last /
    if (one.charAt(pos) !== '/' || two.charAt(pos) !== '/') {
        pos = one.substring(0, pos).lastIndexOf('/');
    }

    return one.substring(0, pos + 1);
};

URI.withinString = function(string, callback) {
    // expression used is "gruber revised" (@gruber v2) determined to be the best solution in
    // a regex sprint we did a couple of ages ago at
    // * http://mathiasbynens.be/demo/url-regex
    // * http://rodneyrehm.de/t/url-regex.html

    return string.replace(URI.find_uri_expression, callback);
};

URI.ensureValidHostname = function(v) {
    // Theoretically URIs allow percent-encoding in Hostnames (according to RFC 3986)
    // they are not part of DNS and therefore ignored by URI.js

    if (v.match(URI.invalid_hostname_characters)) {
        // test punycode
        if (!punycode) {
            throw new TypeError("Hostname '" + v + "' contains characters other than [A-Z0-9.-] and Punycode.js is not available");
        }

        if (punycode.toASCII(v).match(URI.invalid_hostname_characters)) {
            throw new TypeError("Hostname '" + v + "' contains characters other than [A-Z0-9.-]");
        }
    }
};

// noConflict
URI.noConflict = function(removeAll) {
    if (removeAll) {
        var unconflicted = {
            URI: this.noConflict()
        };

        if (URITemplate && typeof URITemplate.noConflict == "function") {
            unconflicted.URITemplate = URITemplate.noConflict();
        }

        if (IPv6 && typeof IPv6.noConflict == "function") {
            unconflicted.IPv6 = IPv6.noConflict();
        }

        if (SecondLevelDomains && typeof SecondLevelDomains.noConflict == "function") {
            unconflicted.SecondLevelDomains = SecondLevelDomains.noConflict();
        }

        return unconflicted;
    } else if (root.URI === this) {
        root.URI = _URI;
    }

    return this;
};

p.build = function(deferBuild) {
    if (deferBuild === true) {
        this._deferred_build = true;
    } else if (deferBuild === undefined || this._deferred_build) {
        this._string = URI.build(this._parts);
        this._deferred_build = false;
    }

    return this;
};

p.clone = function() {
    return new URI(this);
};

p.valueOf = p.toString = function() {
    return this.build(false)._string;
};

// generate simple accessors
_parts = {protocol: 'protocol', username: 'username', password: 'password', hostname: 'hostname',  port: 'port'};
generateAccessor = function(_part){
    return function(v, build) {
        if (v === undefined) {
            return this._parts[_part] || "";
        } else {
            this._parts[_part] = v || null;
            this.build(!build);
            return this;
        }
    };
};

for (_part in _parts) {                                                                                                                                                                                        
    p[_part] = generateAccessor(_parts[_part]);
}

// generate accessors with optionally prefixed input
_parts = {query: '?', fragment: '#'};
generateAccessor = function(_part, _key){
    return function(v, build) {
        if (v === undefined) {
            return this._parts[_part] || "";
        } else {
            if (v !== null) {
                v = v + "";
                if (v.charAt(0) === _key) {
                    v = v.substring(1);
                }
            }

            this._parts[_part] = v;
            this.build(!build);
            return this;
        }
    };
};

for (_part in _parts) {
    p[_part] = generateAccessor(_part, _parts[_part]);
}

// generate accessors with prefixed output
_parts = {search: ['?', 'query'], hash: ['#', 'fragment']};
generateAccessor = function(_part, _key){
    return function(v, build) {
        var t = this[_part](v, build);
        return typeof t === "string" && t.length ? (_key + t) : t;
    };
};

for (_part in _parts) {
    p[_part] = generateAccessor(_parts[_part][1], _parts[_part][0]);
}

p.pathname = function(v, build) {
    if (v === undefined || v === true) {
        var res = this._parts.path || (this._parts.hostname ? '/' : '');
        return v ? URI.decodePath(res) : res;
    } else {
        this._parts.path = v ? URI.recodePath(v) : "/";
        this.build(!build);
        return this;
    }
};
p.path = p.pathname;
p.href = function(href, build) {
    var key;
    
    if (href === undefined) {
        return this.toString();
    }

    this._string = "";
    this._parts = URI._parts();

    var _URI = href instanceof URI;
    var _object = typeof href === "object" && (href.hostname || href.path || href.pathname);
    if (href.nodeName) {
        var attribute = URI.getDomAttribute(href);
        href = href[attribute] || "";
        _object = false;
    }
    
    // window.location is reported to be an object, but it's not the sort
    // of object we're looking for: 
    // * location.protocol ends with a colon
    // * location.query != object.search
    // * location.hash != object.fragment
    // simply serializing the unknown object should do the trick 
    // (for location, not for everything...)
    if (!_URI && _object && href.pathname !== undefined) {
        href = href.toString();
    }

    if (typeof href === "string") {
        this._parts = URI.parse(href, this._parts);
    } else if (_URI || _object) {
        var src = _URI ? href._parts : href;
        for (key in src) {
            if (hasOwn.call(this._parts, key)) {
                this._parts[key] = src[key];
            }
        }
    } else {
        throw new TypeError("invalid input");
    }

    this.build(!build);
    return this;
};

// identification accessors
p.is = function(what) {
    var ip = false;
    var ip4 = false;
    var ip6 = false;
    var name = false;
    var sld = false;
    var idn = false;
    var punycode = false;
    var relative = !this._parts.urn;

    if (this._parts.hostname) {
        relative = false;
        ip4 = URI.ip4_expression.test(this._parts.hostname);
        ip6 = URI.ip6_expression.test(this._parts.hostname);
        ip = ip4 || ip6;
        name = !ip;
        sld = name && SLD && SLD.has(this._parts.hostname);
        idn = name && URI.idn_expression.test(this._parts.hostname);
        punycode = name && URI.punycode_expression.test(this._parts.hostname);
    }

    switch (what.toLowerCase()) {
        case 'relative':
            return relative;

        case 'absolute':
            return !relative;

        // hostname identification
        case 'domain':
        case 'name':
            return name;

        case 'sld':
            return sld;

        case 'ip':
            return ip;

        case 'ip4':
        case 'ipv4':
        case 'inet4':
            return ip4;

        case 'ip6':
        case 'ipv6':
        case 'inet6':
            return ip6;

        case 'idn':
            return idn;

        case 'url':
            return !this._parts.urn;

        case 'urn':
            return !!this._parts.urn;

        case 'punycode':
            return punycode;
    }

    return null;
};

// component specific input validation
var _protocol = p.protocol;
var _port = p.port;
var _hostname = p.hostname;

p.protocol = function(v, build) {
    if (v !== undefined) {
        if (v) {
            // accept trailing ://
            v = v.replace(/:(\/\/)?$/, '');

            if (v.match(/[^a-zA-z0-9\.+-]/)) {
                throw new TypeError("Protocol '" + v + "' contains characters other than [A-Z0-9.+-]");
            }
        }
    }
    return _protocol.call(this, v, build);
};
p.scheme = p.protocol;
p.port = function(v, build) {
    if (this._parts.urn) {
        return v === undefined ? '' : this;
    }

    if (v !== undefined) {
        if (v === 0) {
            v = null;
        }

        if (v) {
            v += "";
            if (v.charAt(0) === ":") {
                v = v.substring(1);
            }

            if (v.match(/[^0-9]/)) {
                throw new TypeError("Port '" + v + "' contains characters other than [0-9]");
            }
        }
    }
    return _port.call(this, v, build);
};
p.hostname = function(v, build) {
    if (this._parts.urn) {
        return v === undefined ? '' : this;
    }

    if (v !== undefined) {
        var x = {};
        URI.parseHost(v, x);
        v = x.hostname;
    }
    return _hostname.call(this, v, build);
};

// compound accessors
p.host = function(v, build) {
    if (this._parts.urn) {
        return v === undefined ? '' : this;
    }

    if (v === undefined) {
        return this._parts.hostname ? URI.buildHost(this._parts) : "";
    } else {
        URI.parseHost(v, this._parts);
        this.build(!build);
        return this;
    }
};
p.authority = function(v, build) {
    if (this._parts.urn) {
        return v === undefined ? '' : this;
    }

    if (v === undefined) {
        return this._parts.hostname ? URI.buildAuthority(this._parts) : "";
    } else {
        URI.parseAuthority(v, this._parts);
        this.build(!build);
        return this;
    }
};
p.userinfo = function(v, build) {
    if (this._parts.urn) {
        return v === undefined ? '' : this;
    }

    if (v === undefined) {
        if (!this._parts.username) {
            return "";
        }

        var t = URI.buildUserinfo(this._parts);
        return t.substring(0, t.length -1);
    } else {
        if (v[v.length-1] !== '@') {
            v += '@';
        }

        URI.parseUserinfo(v, this._parts);
        this.build(!build);
        return this;
    }
};
p.resource = function(v, build) {
    var parts;
    
    if (v === undefined) {
        return this.path() + this.search() + this.hash();
    }
    
    parts = URI.parse(v);
    this._parts.path = parts.path;
    this._parts.query = parts.query;
    this._parts.fragment = parts.fragment;
    this.build(!build);
    return this;
};

// fraction accessors
p.subdomain = function(v, build) {
    if (this._parts.urn) {
        return v === undefined ? '' : this;
    }

    // convenience, return "www" from "www.example.org"
    if (v === undefined) {
        if (!this._parts.hostname || this.is('IP')) {
            return "";
        }

        // grab domain and add another segment
        var end = this._parts.hostname.length - this.domain().length - 1;
        return this._parts.hostname.substring(0, end) || "";
    } else {
        var e = this._parts.hostname.length - this.domain().length;
        var sub = this._parts.hostname.substring(0, e);
        var replace = new RegExp('^' + escapeRegEx(sub));

        if (v && v.charAt(v.length - 1) !== '.') {
            v += ".";
        }

        if (v) {
            URI.ensureValidHostname(v);
        }

        this._parts.hostname = this._parts.hostname.replace(replace, v);
        this.build(!build);
        return this;
    }
};
p.domain = function(v, build) {
    if (this._parts.urn) {
        return v === undefined ? '' : this;
    }

    if (typeof v === 'boolean') {
        build = v;
        v = undefined;
    }

    // convenience, return "example.org" from "www.example.org"
    if (v === undefined) {
        if (!this._parts.hostname || this.is('IP')) {
            return "";
        }

        // if hostname consists of 1 or 2 segments, it must be the domain
        var t = this._parts.hostname.match(/\./g);
        if (t && t.length < 2) {
            return this._parts.hostname;
        }

        // grab tld and add another segment
        var end = this._parts.hostname.length - this.tld(build).length - 1;
        end = this._parts.hostname.lastIndexOf('.', end -1) + 1;
        return this._parts.hostname.substring(end) || "";
    } else {
        if (!v) {
            throw new TypeError("cannot set domain empty");
        }

        URI.ensureValidHostname(v);

        if (!this._parts.hostname || this.is('IP')) {
            this._parts.hostname = v;
        } else {
            var replace = new RegExp(escapeRegEx(this.domain()) + "$");
            this._parts.hostname = this._parts.hostname.replace(replace, v);
        }

        this.build(!build);
        return this;
    }
};
p.tld = function(v, build) {
    if (this._parts.urn) {
        return v === undefined ? '' : this;
    }

    if (typeof v === 'boolean') {
        build = v;
        v = undefined;
    }

    // return "org" from "www.example.org"
    if (v === undefined) {
        if (!this._parts.hostname || this.is('IP')) {
            return "";
        }

        var pos = this._parts.hostname.lastIndexOf('.');
        var tld = this._parts.hostname.substring(pos + 1);

        if (build !== true && SLD && SLD.list[tld.toLowerCase()]) {
            return SLD.get(this._parts.hostname) || tld;
        }

        return tld;
    } else {
        var replace;
        
        if (!v) {
            throw new TypeError("cannot set TLD empty");
        } else if (v.match(/[^a-zA-Z0-9-]/)) {
            if (SLD && SLD.is(v)) {
                replace = new RegExp(escapeRegEx(this.tld()) + "$");
                this._parts.hostname = this._parts.hostname.replace(replace, v);
            } else {
                throw new TypeError("TLD '" + v + "' contains characters other than [A-Z0-9]");
            }
        } else if (!this._parts.hostname || this.is('IP')) {
            throw new ReferenceError("cannot set TLD on non-domain host");
        } else {
            replace = new RegExp(escapeRegEx(this.tld()) + "$");
            this._parts.hostname = this._parts.hostname.replace(replace, v);
        }

        this.build(!build);
        return this;
    }
};
p.directory = function(v, build) {
    if (this._parts.urn) {
        return v === undefined ? '' : this;
    }

    if (v === undefined || v === true) {
        if (!this._parts.path && !this._parts.hostname) {
            return '';
        }

        if (this._parts.path === '/') {
            return '/';
        }

        var end = this._parts.path.length - this.filename().length - 1;
        var res = this._parts.path.substring(0, end) || (this._parts.hostname ? "/" : "");

        return v ? URI.decodePath(res) : res;

    } else {
        var e = this._parts.path.length - this.filename().length;
        var directory = this._parts.path.substring(0, e);
        var replace = new RegExp('^' + escapeRegEx(directory));

        // fully qualifier directories begin with a slash
        if (!this.is('relative')) {
            if (!v) {
                v = '/';
            }

            if (v.charAt(0) !== '/') {
                v = "/" + v;
            }
        }

        // directories always end with a slash
        if (v && v.charAt(v.length - 1) !== '/') {
            v += '/';
        }

        v = URI.recodePath(v);
        this._parts.path = this._parts.path.replace(replace, v);
        this.build(!build);
        return this;
    }
};
p.filename = function(v, build) {
    if (this._parts.urn) {
        return v === undefined ? '' : this;
    }

    if (v === undefined || v === true) {
        if (!this._parts.path || this._parts.path === '/') {
            return "";
        }

        var pos = this._parts.path.lastIndexOf('/');
        var res = this._parts.path.substring(pos+1);

        return v ? URI.decodePathSegment(res) : res;
    } else {
        var mutatedDirectory = false;
        
        if (v.charAt(0) === '/') {
            v = v.substring(1);
        }

        if (v.match(/\.?\//)) {
            mutatedDirectory = true;
        }

        var replace = new RegExp(escapeRegEx(this.filename()) + "$");
        v = URI.recodePath(v);
        this._parts.path = this._parts.path.replace(replace, v);

        if (mutatedDirectory) {
            this.normalizePath(build);
        } else {
            this.build(!build);
        }

        return this;
    }
};
p.suffix = function(v, build) {
    if (this._parts.urn) {
        return v === undefined ? '' : this;
    }

    if (v === undefined || v === true) {
        if (!this._parts.path || this._parts.path === '/') {
            return "";
        }

        var filename = this.filename();
        var pos = filename.lastIndexOf('.');
        var s, res;

        if (pos === -1) {
            return "";
        }

        // suffix may only contain alnum characters (yup, I made this up.)
        s = filename.substring(pos+1);
        res = (/^[a-z0-9%]+$/i).test(s) ? s : "";
        return v ? URI.decodePathSegment(res) : res;
    } else {
        if (v.charAt(0) === '.') {
            v = v.substring(1);
        }

        var suffix = this.suffix();
        var replace;

        if (!suffix) {
            if (!v) {
                return this;
            }

            this._parts.path += '.' + URI.recodePath(v);
        } else if (!v) {
            replace = new RegExp(escapeRegEx("." + suffix) + "$");
        } else {
            replace = new RegExp(escapeRegEx(suffix) + "$");
        }

        if (replace) {
            v = URI.recodePath(v);
            this._parts.path = this._parts.path.replace(replace, v);
        }

        this.build(!build);
        return this;
    }
};
p.segment = function(segment, v, build) {
    var separator = this._parts.urn ? ':' : '/';
    var path = this.path();
    var absolute = path.substring(0, 1) === '/';
    var segments = path.split(separator);

    if (segment !== undefined && typeof segment !== 'number') {
        build = v;
        v = segment;
        segment = undefined;
    }

    if (segment !== undefined && typeof segment !== 'number') {
        throw new Error("Bad segment '" + segment + "', must be 0-based integer");
    }

    if (absolute) {
        segments.shift();
    }

    if (segment < 0) {
        // allow negative indexes to address from the end
        segment = Math.max(segments.length + segment, 0);
    }

    if (v === undefined) {
        return segment === undefined
            ? segments
            : segments[segment];
    } else if (segment === null || segments[segment] === undefined) {
        if (isArray(v)) {
            segments = [];
            // collapse empty elements within array
            for (var i=0, l=v.length; i < l; i++) {
                if (!v[i].length && (!segments.length || !segments[segments.length -1].length)) {
                    continue;
                }
                
                if (segments.length && !segments[segments.length -1].length) {
                    segments.pop();
                }
                
                segments.push(v[i]);
            }
        } else if (v || (typeof v === "string")) {
            if (segments[segments.length -1] === "") {
                // empty trailing elements have to be overwritten
                // to prevent results such as /foo//bar
                segments[segments.length -1] = v;
            } else {
                segments.push(v);
            }
        }
    } else {
        if (v || (typeof v === "string" && v.length)) {
            segments[segment] = v;
        } else {
            segments.splice(segment, 1);
        }
    }

    if (absolute) {
        segments.unshift("");
    }

    return this.path(segments.join(separator), build);
};
p.segmentCoded = function(segment, v, build) {
    var segments, i, l;

    if (typeof segment !== 'number') {
        build = v;
        v = segment;
        segment = undefined;
    }

    if (v === undefined) {
        segments = this.segment(segment, v, build);
        if (!isArray(segments)) {
            segments = segments !== undefined ? URI.decode(segments) : undefined;
        } else {
            for (i = 0, l = segments.length; i < l; i++) {
                segments[i] = URI.decode(segments[i]);
            }
        }

        return segments;
    }

    if (!isArray(v)) {
        v = typeof v === 'string' ? URI.encode(v) : v;
    } else {
        for (i = 0, l = v.length; i < l; i++) {
            v[i] = URI.decode(v[i]);
        }
    }

    return this.segment(segment, v, build);
};

// mutating query string
var q = p.query;
p.query = function(v, build) {
    if (v === true) {
        return URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
    } else if (typeof v === "function") {
        var data = URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
        var result = v.call(this, data);
        this._parts.query = URI.buildQuery(result || data, this._parts.duplicateQueryParameters, this._parts.escapeQuerySpace);
        this.build(!build);
        return this;
    } else if (v !== undefined && typeof v !== "string") {
        this._parts.query = URI.buildQuery(v, this._parts.duplicateQueryParameters, this._parts.escapeQuerySpace);
        this.build(!build);
        return this;
    } else {
        return q.call(this, v, build);
    }
};
p.setQuery = function(name, value, build) {
    var data = URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
    
    if (typeof name === "object") {
        for (var key in name) {
            if (hasOwn.call(name, key)) {
                data[key] = name[key];
            }
        }
    } else if (typeof name === "string") {
        data[name] = value !== undefined ? value : null;
    } else {
        throw new TypeError("URI.addQuery() accepts an object, string as the name parameter");
    }
    
    this._parts.query = URI.buildQuery(data, this._parts.duplicateQueryParameters, this._parts.escapeQuerySpace);
    if (typeof name !== "string") {
        build = value;
    }

    this.build(!build);
    return this;
};
p.addQuery = function(name, value, build) {
    var data = URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
    URI.addQuery(data, name, value === undefined ? null : value);
    this._parts.query = URI.buildQuery(data, this._parts.duplicateQueryParameters, this._parts.escapeQuerySpace);
    if (typeof name !== "string") {
        build = value;
    }

    this.build(!build);
    return this;
};
p.removeQuery = function(name, value, build) {
    var data = URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
    URI.removeQuery(data, name, value);
    this._parts.query = URI.buildQuery(data, this._parts.duplicateQueryParameters, this._parts.escapeQuerySpace);
    if (typeof name !== "string") {
        build = value;
    }

    this.build(!build);
    return this;
};
p.hasQuery = function(name, value, withinArray) {
    var data = URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
    return URI.hasQuery(data, name, value, withinArray);
};
p.setSearch = p.setQuery;
p.addSearch = p.addQuery;
p.removeSearch = p.removeQuery;
p.hasSearch = p.hasQuery;

// sanitizing URLs
p.normalize = function() {
    if (this._parts.urn) {
        return this
            .normalizeProtocol(false)
            .normalizeQuery(false)
            .normalizeFragment(false)
            .build();
    }

    return this
        .normalizeProtocol(false)
        .normalizeHostname(false)
        .normalizePort(false)
        .normalizePath(false)
        .normalizeQuery(false)
        .normalizeFragment(false)
        .build();
};
p.normalizeProtocol = function(build) {
    if (typeof this._parts.protocol === "string") {
        this._parts.protocol = this._parts.protocol.toLowerCase();
        this.build(!build);
    }

    return this;
};
p.normalizeHostname = function(build) {
    if (this._parts.hostname) {
        if (this.is('IDN') && punycode) {
            this._parts.hostname = punycode.toASCII(this._parts.hostname);
        } else if (this.is('IPv6') && IPv6) {
            this._parts.hostname = IPv6.best(this._parts.hostname);
        }

        this._parts.hostname = this._parts.hostname.toLowerCase();
        this.build(!build);
    }

    return this;
};
p.normalizePort = function(build) {
    // remove port of it's the protocol's default
    if (typeof this._parts.protocol === "string" && this._parts.port === URI.defaultPorts[this._parts.protocol]) {
        this._parts.port = null;
        this.build(!build);
    }

    return this;
};
p.normalizePath = function(build) {
    if (this._parts.urn) {
        return this;
    }

    if (!this._parts.path || this._parts.path === '/') {
        return this;
    }

    var _was_relative;
    var _path = this._parts.path;
    var _parent, _pos;

    // handle relative paths
    if (_path.charAt(0) !== '/') {
        _was_relative = true;
        _path = '/' + _path;
    }

    // resolve simples
    _path = _path
        .replace(/(\/(\.\/)+)|(\/\.$)/g, '/')
        .replace(/\/{2,}/g, '/');

    // resolve parents
    while (true) {
        _parent = _path.indexOf('/../');
        if (_parent === -1) {
            // no more ../ to resolve
            break;
        } else if (_parent === 0) {
            // top level cannot be relative...
            _path = _path.substring(3);
            break;
        }

        _pos = _path.substring(0, _parent).lastIndexOf('/');
        if (_pos === -1) {
            _pos = _parent;
        }
        _path = _path.substring(0, _pos) + _path.substring(_parent + 3);
    }

    // revert to relative
    if (_was_relative && this.is('relative')) {
        _path = _path.substring(1);
    }

    _path = URI.recodePath(_path);
    this._parts.path = _path;
    this.build(!build);
    return this;
};
p.normalizePathname = p.normalizePath;
p.normalizeQuery = function(build) {
    if (typeof this._parts.query === "string") {
        if (!this._parts.query.length) {
            this._parts.query = null;
        } else {
            this.query(URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace));
        }

        this.build(!build);
    }

    return this;
};
p.normalizeFragment = function(build) {
    if (!this._parts.fragment) {
        this._parts.fragment = null;
        this.build(!build);
    }

    return this;
};
p.normalizeSearch = p.normalizeQuery;
p.normalizeHash = p.normalizeFragment;

p.iso8859 = function() {
    // expect unicode input, iso8859 output
    var e = URI.encode;
    var d = URI.decode;

    URI.encode = escape;
    URI.decode = decodeURIComponent;
    this.normalize();
    URI.encode = e;
    URI.decode = d;
    return this;
};

p.unicode = function() {
    // expect iso8859 input, unicode output
    var e = URI.encode;
    var d = URI.decode;

    URI.encode = strictEncodeURIComponent;
    URI.decode = unescape;
    this.normalize();
    URI.encode = e;
    URI.decode = d;
    return this;
};

p.readable = function() {
    var uri = this.clone();
    // removing username, password, because they shouldn't be displayed according to RFC 3986
    uri.username("").password("").normalize();
    var t = '';
    if (uri._parts.protocol) {
        t += uri._parts.protocol + '://';
    }

    if (uri._parts.hostname) {
        if (uri.is('punycode') && punycode) {
            t += punycode.toUnicode(uri._parts.hostname);
            if (uri._parts.port) {
                t += ":" + uri._parts.port;
            }
        } else {
            t += uri.host();
        }
    }

    if (uri._parts.hostname && uri._parts.path && uri._parts.path.charAt(0) !== '/') {
        t += '/';
    }

    t += uri.path(true);
    if (uri._parts.query) {
        var q = '';
        for (var i = 0, qp = uri._parts.query.split('&'), l = qp.length; i < l; i++) {
            var kv = (qp[i] || "").split('=');
            q += '&' + URI.decodeQuery(kv[0], this._parts.escapeQuerySpace)
                .replace(/&/g, '%26');

            if (kv[1] !== undefined) {
                q += "=" + URI.decodeQuery(kv[1], this._parts.escapeQuerySpace)
                    .replace(/&/g, '%26');
            }
        }
        t += '?' + q.substring(1);
    }

    t += URI.decodeQuery(uri.hash(), true);
    return t;
};

// resolving relative and absolute URLs
p.absoluteTo = function(base) {
    var resolved = this.clone();
    var properties = ['protocol', 'username', 'password', 'hostname', 'port'];
    var basedir, i, p;

    if (this._parts.urn) {
        throw new Error('URNs do not have any generally defined hierarchical components');
    }

    if (!(base instanceof URI)) {
        base = new URI(base);
    }
    
    if (!resolved._parts.protocol) {
        resolved._parts.protocol = base._parts.protocol;
    }
    
    if (this._parts.hostname) {
        return resolved;
    }

    for (i = 0; p = properties[i]; i++) {
        resolved._parts[p] = base._parts[p];
    }
    
    properties = ['query', 'path'];
    for (i = 0; p = properties[i]; i++) {
        if (!resolved._parts[p] && base._parts[p]) {
            resolved._parts[p] = base._parts[p];
        }
    }

    if (resolved.path().charAt(0) !== '/') {
        basedir = base.directory();
        resolved._parts.path = (basedir ? (basedir + '/') : '') + resolved._parts.path;
        resolved.normalizePath();
    }

    resolved.build();
    return resolved;
};
p.relativeTo = function(base) {
    var relative = this.clone().normalize();
    var relativeParts, baseParts, common, relativePath, basePath;

    if (relative._parts.urn) {
        throw new Error('URNs do not have any generally defined hierarchical components');
    }

    base = new URI(base).normalize();
    relativeParts = relative._parts;
    baseParts = base._parts;
    relativePath = relative.path();
    basePath = base.path();

    if (relativePath.charAt(0) !== '/') {
        throw new Error('URI is already relative');
    }

    if (basePath.charAt(0) !== '/') {
        throw new Error('Cannot calculate a URI relative to another relative URI');
    }

    if (relativeParts.protocol === baseParts.protocol) {
        relativeParts.protocol = null;
    }

    if (relativeParts.username !== baseParts.username || relativeParts.password !== baseParts.password) {
        return relative.build();
    }

    if (relativeParts.protocol !== null || relativeParts.username !== null || relativeParts.password !== null) {
        return relative.build();
    }

    if (relativeParts.hostname === baseParts.hostname && relativeParts.port === baseParts.port) {
        relativeParts.hostname = null;
        relativeParts.port = null;
    } else {
        return relative.build();
    }

    if (relativePath === basePath) {
        relativeParts.path = '';
        return relative.build();
    }
    
    // determine common sub path
    common = URI.commonPath(relative.path(), base.path());

    // If the paths have nothing in common, return a relative URL with the absolute path.
    if (!common) {
        return relative.build();
    }

    var parents = baseParts.path
        .substring(common.length)
        .replace(/[^\/]*$/, '')
        .replace(/.*?\//g, '../');

    relativeParts.path = parents + relativeParts.path.substring(common.length);

    return relative.build();
};

// comparing URIs
p.equals = function(uri) {
    var one = this.clone();
    var two = new URI(uri);
    var one_map = {};
    var two_map = {};
    var checked = {};
    var one_query, two_query, key;

    one.normalize();
    two.normalize();

    // exact match
    if (one.toString() === two.toString()) {
        return true;
    }

    // extract query string
    one_query = one.query();
    two_query = two.query();
    one.query("");
    two.query("");

    // definitely not equal if not even non-query parts match
    if (one.toString() !== two.toString()) {
        return false;
    }

    // query parameters have the same length, even if they're permuted
    if (one_query.length !== two_query.length) {
        return false;
    }

    one_map = URI.parseQuery(one_query, this._parts.escapeQuerySpace);
    two_map = URI.parseQuery(two_query, this._parts.escapeQuerySpace);

    for (key in one_map) {
        if (hasOwn.call(one_map, key)) {
            if (!isArray(one_map[key])) {
                if (one_map[key] !== two_map[key]) {
                    return false;
                }
            } else if (!arraysEqual(one_map[key], two_map[key])) {
                return false;
            }

            checked[key] = true;
        }
    }

    for (key in two_map) {
        if (hasOwn.call(two_map, key)) {
            if (!checked[key]) {
                // two contains a parameter not present in one
                return false;
            }
        }
    }

    return true;
};

// state
p.duplicateQueryParameters = function(v) {
    this._parts.duplicateQueryParameters = !!v;
    return this;
};

p.escapeQuerySpace = function(v) {
    this._parts.escapeQuerySpace = !!v;
    return this;
};

return URI;
}));
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/*global URI *///declare unusual global vars for JSLint/SAPUI5 validation

/**
 * @class Provides base functionality of the SAP jQuery plugin as extension of the jQuery framework.<br/>
 * See also <a href="http://api.jquery.com/jQuery/">jQuery</a> for details.<br/>
 * Although these functions appear as static ones, they are meant to be used on jQuery instances.<br/>
 * If not stated differently, the functions follow the fluent interface paradigm and return the jQuery instance for chaining of statements.
 *
 * Example for usage of an instance method:
 * <pre>
 *   var oRect = jQuery("#myDiv").rect();
 *   alert("Top Position: " + oRect.top);
 * </pre>
 *
 * @name jQuery
 * @static
 * @public
 */

(function() {
	
	if (!window.jQuery ) {
		throw new Error("SAPUI5 requires jQuery as a prerequisite (>= version 1.7)");
	}

	// ensure not to initialize twice
	if (jQuery.sap) {
		return;
	}

	/**
	 * Window that the sap plugin has been initialized for.
	 * @private
	 */
	var _window = window;

	// early logging support
	var _earlyLogs = [];
	function _earlyLog(sLevel, sMessage) {
		_earlyLogs.push({
			level: sLevel,
			message: sMessage
		});
	}

	var _sBootstrapUrl = undefined;
	
	// -------------------------- VERSION -------------------------------------

	var rVersion = /^[0-9]+(?:\.([0-9]+)(?:\.([0-9]+))?)?(.*)$/; 

	/**
	 * Returns a Version instance created from the given parameters.
	 * 
	 * This function can either be called as a constructor (using <code>new</code>) or as a normal function.
	 * It always returns an immutable Version instance.
	 *   
	 * The parts of the version number (major, minor, patch, suffix) can be provided in several ways:
	 * <ul>
	 * <li>Version("1.2.3-SNAPSHOT") - as a dot-separated string. Any non-numerical char or a dot followed by a non-numerical char starts the suffix portion. 
	 * Any missing major, minor or patch versions will be set to 0.</li>
	 * <li>Version(1,2,3,"-SNAPSHOT") - as individual parameters. Major, minor and patch must be integer numbers or empty, suffix must be a string not starting with digits.</li>
	 * <li>Version([1,2,3,"-SNAPSHOT"]) - as an array with the individual parts. The same type restrictions apply as before.</li>
	 * <li>Version(otherVersion) - as a Version instance (cast operation). Returns the given instance instead of creating a new one.</li> 
	 * </ul>
	 * 
	 * To keep the code size small, this implementation mainly validates the single string variant. 
	 * All other variants are only validated to some degree. It is the responsibility of the caller to 
	 * provide proper parts.
	 *
	 * @param {int|string|any[]|jQuery.sap.Version} vMajor the major part of the version (int) or any of the single parameter variants explained above. 
	 * @param {int} iMinor the minor part of the version number 
	 * @param {int} iPatch the patch part of the version number
	 * @param {string} sSuffix the suffix part of the version number
	 * @return {jQuery.sap.Version} the version object as determined from the parameters
	 * 
	 * @class Represents a version consisting of major, minor, patch version and suffix, e.g. '1.2.7-SNAPSHOT'.
	 *
	 * @author SAP AG
	 * @version 1.20.6
	 * @constructor
	 * @public
	 * @since 1.15.0
	 * @name jQuery.sap.Version
	 */
	function Version(vMajor, iMinor, iPatch, sSuffix) {
		if ( vMajor instanceof Version ) {
			// note: even a constructor may return a value different from 'this' 
			return vMajor;
		}
		if ( !(this instanceof Version) ) {
			// act as a cast operator when called as function (not as a constructor)
			return new Version(vMajor, iMinor, iPatch, sSuffix);
		}
		
		var m = (typeof vMajor === "string" ? rVersion.exec(vMajor) : (jQuery.isArray(vMajor) ? vMajor : arguments)) || [];
		function norm(v) {
			v = parseInt(v,10);
			return isNaN(v) ? 0 : v;
		}
		vMajor = norm(m[0]);
		iMinor = norm(m[1]);
		iPatch = norm(m[2]);
		sSuffix = String(m[3] || "");
		
		/**
		 * Returns a string representation of this version.
		 *
		 * @return {string} a string representation of this version.
		 * @name jQuery.sap.Version#toString
		 * @public
		 * @since 1.15.0
		 * @function
		 */
		this.toString = function() {
			return vMajor + "." + iMinor + "." + iPatch + sSuffix; 
		};
		
		/**
		 * Returns the major version part of this version.
		 *
		 * @return {int} the major version part of this version
		 * @name jQuery.sap.Version#getMajor
		 * @public
		 * @since 1.15.0
		 * @function
		 */
		this.getMajor = function() { return vMajor; };
		
		/**
		 * Returns the minor version part of this version.
		 *
		 * @return {int} the minor version part of this version
		 * @name jQuery.sap.Version#getMinor
		 * @public
		 * @since 1.15.0
		 * @function
		 */
		this.getMinor = function() { return iMinor; };
		
		/**
		 * Returns the patch (or micro) version part of this version.
		 *
		 * @return {int} the patch version part of this version
		 * @name jQuery.sap.Version#getPatch
		 * @public
		 * @since 1.15.0
		 * @function
		 */
		this.getPatch = function() { return iPatch; };
		
		/**
		 * Returns the version suffix of this version.
		 *
		 * @return {string} the version suffix of this version
		 * @name jQuery.sap.Version#getSuffix
		 * @public
		 * @since 1.15.0
		 * @function
		 */
		this.getSuffix = function() { return sSuffix; };

		/**
		 * Compares this version with a given one.
		 *
		 * The version with which this version should be compared can be given as
		 * <code>jQuery.sap.Version</code> instance, as a string (e.g. <code>v.compareto("1.4.5")</code>)
		 * or major, minor, patch and suffix cab be given as separate parameters (e.g. <code>v.compareTo(1, 4, 5)</code>)
		 * or in an array (e.g. <code>v.compareTo([1, 4, 5])</code>).
		 * 
		 * @return {int} 0, if the given version is equal to this version, a negative value if the given version is greater and a positive value otherwise
		 * @name jQuery.sap.Version#compareTo
		 * @public
		 * @since 1.15.0
		 * @function
		 */
		this.compareTo = function() {
			var vOther = Version.apply(window, arguments);
			return vMajor - vOther.getMajor() ||
					iMinor - vOther.getMinor() ||
					iPatch - vOther.getPatch() || 
					((sSuffix < vOther.getSuffix()) ? -1 : (sSuffix === vOther.getSuffix()) ? 0 : 1);
		};
		
	}

	/**
	 * Checks whether this version is in the range of the given versions (start included, end excluded).
	 *
	 * The boundaries against which this version should be checked can be given as
	 * <code>jQuery.sap.Version</code> instances (e.g. <code>v.inRange(v1, v2)</code>), as strings (e.g. <code>v.inRange("1.4", "2.7")</code>)
	 * or as arrays (e.g. <code>v.inRange([1,4], [2,7])</code>).
	 * 
	 * @return {boolean} <code>true</code> if this version is greater or equal to <code>vMin</code> and smaller than <code>vMax</code>, <code>false</code> otherwise.
	 * @name jQuery.sap.Version#inRange
	 * @public
	 * @since 1.15.0
	 * @function
	 */
	Version.prototype.inRange = function(vMin, vMax) {
		return this.compareTo(vMin) >= 0 && this.compareTo(vMax) < 0; 
	};
	
	// -----------------------------------------------------------------------
	
	var oJQVersion = Version(jQuery.fn.jquery);
	if ( !oJQVersion.inRange("1.7.0", "2.0.0") ) {
		_earlyLog("error", "SAPUI5 requires a jQuery version of 1.7 or higher, but lower than 2.0; current version is " + jQuery.fn.jquery);
	}
	
	// TODO move to a separate module? Only adds 385 bytes (compressed), but...
	if ( !jQuery.browser ) {
		// re-introduce the jQuery.browser support if missing (jQuery-1.9ff) 
		jQuery.browser = (function( ua ) {
			
			var rwebkit = /(webkit)[ \/]([\w.]+)/,
				ropera = /(opera)(?:.*version)?[ \/]([\w.]+)/,
				rmsie = /(msie) ([\w.]+)/,
				rmozilla = /(mozilla)(?:.*? rv:([\w.]+))?/,
				ua = ua.toLowerCase(),
				match = rwebkit.exec( ua ) ||
					ropera.exec( ua ) ||
					rmsie.exec( ua ) ||
					ua.indexOf("compatible") < 0 && rmozilla.exec( ua ) ||
					[],
				browser = {};
			
			if ( match[1] ) {
				browser[ match[1] ] = true;
				browser.version = match[2] || "0";
				if ( browser.webkit ) {
					browser.safari = true;
				}
			}
			
			return browser;
			
		}(window.navigator.userAgent));
	}
	
	// Fixes the CORS issue (introduced by jQuery 1.7) when loading resources
	// (e.g. SAPUI5 script) from other domains for IE browsers.
	// The CORS check in jQuery filters out such browsers who do not have the
	// property "withCredentials" which is the IE and Opera and prevents those
	// browsers to request data from other domains with jQuery.ajax. The CORS
	// requests are simply forbidden nevertheless if it works. In our case we
	// simply load our script resources from another domain when using the CDN
	// variant of SAPUI5. The following fix is also recommended by jQuery:
	if (!!sap.ui.Device.browser.internet_explorer) {
		jQuery.support.cors = true;
	}


	/**
	 * Find the script URL where the SAPUI5 is loaded from and return an object which
	 * contains the identified script-tag and resource root
	 */
	var _oBootstrap = (function() {
		var oTag, sUrl, sResourceRoot,
			reConfigurator = /^(.*\/)?download\/configurator[\/\?]/,
			reBootScripts = /^(.*\/)?(sap-ui-(core|custom|boot|merged)(-.*)?)\.js([?#]|$)/,
			reResources = /^(.*\/)?resources\//;

		// check all script tags that have a src attribute
		jQuery("script[src]").each(function() {
			var src = this.getAttribute("src"),
				m;
			if ( m = src.match(reConfigurator) ) {
				// guess 1: script tag src contains "/download/configurator[/?]" (for dynamically created bootstrap files)
				oTag = this;
				sUrl = src;
				sResourceRoot = (m[1] || "") + "resources/";
				return false;
			} else if ( m = src.match(reBootScripts) ) {
				// guess 2: src contains one of the well known boot script names
				oTag = this;
				sUrl = src;
				sResourceRoot = m[1] || "";
				return false;
			} else if ( this.id == 'sap-ui-bootstrap' && (m=src.match(reResources)) ) {
				// guess 2: script tag has well known id and src contains "resources/"
				oTag = this;
				sUrl = src;
				sResourceRoot = m[0];
				return false;
			}
		});
		return {
			tag: oTag,
			url: sUrl,
			resourceRoot: sResourceRoot
		};
	})();

	/**
	 * Determine whether sap-bootstrap-debug is set, run debugger statement and allow
	 * to restart the core from a new URL
	 */
	(function() {
		if (/sap-bootstrap-debug=(true|x|X)/.test(location.search)) {
			window["sap-ui-bRestart"] = false;
			window["sap-ui-sRestartUrl"] = "http://localhost:8080/sapui5/resources/sap-ui-core.js";

			// function to replace the bootstrap tag with a newly created script tag to enable
			// restarting the core from a different server
			var restartCore = function() {
				var oScript = _oBootstrap.tag,
					sScript = "<script src=\"" + window["sap-ui-sRestartUrl"] + "\"";
				jQuery.each(oScript.attributes, function(i, oAttr) {
					if (oAttr.nodeName.indexOf("data-sap-ui-") == 0) {
						sScript += " " + oAttr.nodeName + "=\"" + oAttr.nodeValue + "\"";
					}
				});
				sScript += "></script>";
				oScript.parentNode.removeChild(oScript);
				
				// clean up cachebuster stuff
				jQuery("#sap-ui-bootstrap-cachebusted").remove();
				window["sap-ui-config"] && window["sap-ui-config"].resourceRoots && (window["sap-ui-config"].resourceRoots[""] = undefined);
				
				document.write(sScript);
				var oRestart = new Error("Aborting UI5 bootstrap and restarting from: " + window["sap-ui-sRestartUrl"]);
				oRestart.name = "Restart";
				
				// clean up
				delete window["sap-ui-bRestart"];
				delete window["sap-ui-sRestartUrl"];
				
				throw oRestart;
			};

			// debugger stops here. To restart UI5 from somewhere else (default: localhost), set:
			//    window["sap-ui-bRestart"] = true
			// If you want to restart from a different server than localhost, you can adapt the URL, e.g.: 
			//    window["sap-ui-sRestartUrl"] = "http://someserver:8080/sapui5/resources/sap-ui-core.js"
			debugger;
			if (window["sap-ui-bRestart"]) {
				restartCore();
			}
		}
	})();

	/**
	 * Determine whether to use debug sources depending on URL parameter and local storage
	 * and load debug library if necessary
	 */
	(function() {
		//Check URI param
		var bDebugSources = /sap-ui-debug=(true|x|X)/.test(location.search),
			bIsOptimized = window["sap-ui-optimized"];

		//Check local storage
		try { //Necessary for FF when Cookies are deactivated
			bDebugSources = bDebugSources || (window.localStorage.getItem("sap-ui-debug") == "X");
		} catch(e) {}

		window["sap-ui-debug"] = bDebugSources;

		// if bootstap URL already contains -dbg URL, just set sap-ui-loaddbg
		if (/-dbg\.js([?#]|$)/.test(_oBootstrap.url)) {
			window["sap-ui-loaddbg"] = true;
			window["sap-ui-debug"] = true;
		}

		// if current sources are optimized and debug sources are wanted, restart with debug URL
		if (bIsOptimized && bDebugSources) {
			var sDebugUrl = _oBootstrap.url.replace(/\/(?:sap-ui-cachebuster\/)?([^\/]+)\.js/, "/$1-dbg.js");
			window["sap-ui-optimized"] = false;
			window["sap-ui-loaddbg"] = true;
			document.write("<script type=\"text/javascript\" src=\"" + sDebugUrl + "\"></script>");
			var oRestart = new Error("Aborting UI5 bootstrap and restarting from: " + sDebugUrl);
			oRestart.name = "Restart";
			throw oRestart;
		}
	})();

	/*
	 * Merged, raw (un-interpreted) configuration data from the following sources
	 * (last one wins)
	 * <ol>
	 * <li>global configuration object <code>window["sap-ui-config"]</code> (could be either a string/url or a configuration object)</li>
	 * <li><code>data-sap-ui-config</code> attribute of the bootstrap script tag</li>
	 * <li>other <code>data-sap-ui-<i>xyz</i></code> attributes of the bootstrap tag</li>
	 * </ol>
	 */
	var oCfgData = _window["sap-ui-config"] = (function() {

		function normalize(o) {
			jQuery.each(o, function(i, v) {
				var il=i.toLowerCase();
				if ( !o.hasOwnProperty(il) ) {
					o[il] = v;
					delete o[i];
				}
			});
			return o;
		}

		var oScriptTag = _oBootstrap.tag,
		    oCfg = _window["sap-ui-config"],
		    sCfgFile = "sap-ui-config.json";
		
		// load the configuration from an external JSON file 
		if (typeof oCfg === "string") {
			_earlyLog("warning", "Loading external bootstrap configuration from \"" + oCfg + "\". This is a design time feature and not for productive usage!");
			if (oCfg !== sCfgFile) {
				_earlyLog("warning", "The external bootstrap configuration file should be named \"" + sCfgFile + "\"!");
			}
			jQuery.ajax({
				url : oCfg,
				dataType : 'json',
				async : false,
				success : function(oData, sTextStatus, jqXHR) {
					oCfg = oData;
				},
				error : function(jqXHR, sTextStatus, oError) {
					_earlyLog("error", "Loading externalized bootstrap configuration from \"" + oCfg + "\" failed! Reason: " + oError + "!");
					oCfg = undefined;
				}
			});
		}
		
		oCfg = normalize(oCfg || {});
		oCfg.resourceroots = oCfg.resourceroots || {};
		oCfg.themeroots = oCfg.themeroots || {};
		oCfg.resourceroots[''] = oCfg.resourceroots[''] || _oBootstrap.resourceRoot;

		oCfg['xx-loadallmode'] = /(^|\/)(sap-?ui5|[^\/]+-all).js([?#]|$)/.test(_oBootstrap.url);

		// if a script tag has been identified, collect its configuration info
		if ( oScriptTag ) {
			// evaluate the config attribute first - if present
			var sConfig = oScriptTag.getAttribute("data-sap-ui-config");
			if ( sConfig ) {
				try {
				  jQuery.extend(oCfg, normalize((new Function("return {" + sConfig + "};"))())); // TODO jQuery.parseJSON would be better but imposes unwanted restrictions on valid syntax
				} catch(e) {
				  // no log yet, how to report this error?
				  _earlyLog("error", "failed to parse data-sap-ui-config attribute: " + (e.message || e));
				}
			}

			// merge with any existing "data-sap-ui-" attributes
			jQuery.each(oScriptTag.attributes, function(i, attr) {
				var m = attr.name.match(/^data-sap-ui-(.*)$/);
				if ( m ) {
					// the following (deactivated) conversion would implement multi-word names like "resource-roots"
					m = m[1].toLowerCase(); // .replace(/\-([a-z])/g, function(s,w) { return w.toUpperCase(); })
					if ( m === 'resourceroots' ) {
						// merge map entries instead of overwriting map
						jQuery.extend(oCfg[m], jQuery.parseJSON(attr.value));
					} else if ( m === 'theme-roots' ) {
						// merge map entries, but rename to camelCase
						jQuery.extend(oCfg.themeroots, jQuery.parseJSON(attr.value));
					} else if ( m !== 'config' ) {
						oCfg[m] = attr.value;
					}
				}
			});
		}

		return oCfg;
	}());

	// check whether noConflict must be used...
	if ( oCfgData.noconflict === true || oCfgData.noconflict === "true"  || oCfgData.noconflict === "x" ) {
		jQuery.noConflict();
	}

	/**
	 * Root Namespace for the jQuery plug-in provided by SAP AG.
	 *
	 * @version 1.20.6
	 * @namespace
	 * @public
	 * @static
	 */
	jQuery.sap = {};
	
	// -------------------------- VERSION -------------------------------------
	
	jQuery.sap.Version = Version;

	// -------------------------- DEBUG LOCAL STORAGE -------------------------------------

	jQuery.sap.debug = function(bEnable) {
		if(!window.localStorage){
			return null;
		}

		function reloadHint(bUsesDbgSrc){
			alert("Usage of debug sources is " + (bUsesDbgSrc ? "on" : "off") + " now.\nFor the change to take effect, you need to reload the page.");
		};

		if (bEnable === true) {
			window.localStorage.setItem("sap-ui-debug", "X");
			reloadHint(true);
		} else if (bEnable === false) {
			window.localStorage.removeItem("sap-ui-debug");
			reloadHint(false);
		}

		return window.localStorage.getItem("sap-ui-debug") == "X";
	};

	// -------------------------- STATISTICS LOCAL STORAGE -------------------------------------

	jQuery.sap.statistics = function(bEnable) {
		if(!window.localStorage){
			return null;
		}

		function reloadHint(bUsesDbgSrc){
			alert("Usage of Gateway statistics " + (bUsesDbgSrc ? "on" : "off") + " now.\nFor the change to take effect, you need to reload the page.");
		};

		if (bEnable === true) {
			window.localStorage.setItem("sap-ui-statistics", "X");
			reloadHint(true);
		} else if (bEnable === false) {
			window.localStorage.removeItem("sap-ui-statistics");
			reloadHint(false);
		}

		return window.localStorage.getItem("sap-ui-statistics") == "X";
	};

	// -------------------------- Logging -------------------------------------

	(function() {

		var FATAL=0, ERROR=1, WARNING=2, INFO=3, DEBUG=4, TRACE=5,

		/**
		 * Unique prefix for this instance of the core in a multi-frame environment.
		 */
			sWindowName = (window.top == window) ? "" : "[" + window.location.pathname.split('/').slice(-1)[0] + "] ",
		// Note: comparison must use type coercion (==, not ===), otherwise test fails in IE

		/**
		 * The array that holds the log entries that have been recorded so far
		 */
			aLog = [],

		/**
		 * Maximum log level to be recorded (per component).
		 */
			mMaxLevel = { '' : ERROR },

		/**
		 * Registered listener to be informed about new log entries.
		 */
			oListener = null;

		function pad0(i,w) { return ("000" + String(i)).slice(-w); }

		function level(sComponent) {
			return (!sComponent || isNaN(mMaxLevel[sComponent])) ? mMaxLevel[''] : mMaxLevel[sComponent];
		}
		
		function listener(){
			if(!oListener){
				oListener = {
					listeners: [],
					onLogEntry: function(oLogEntry){
						for(var i=0; i<oListener.listeners.length; i++){
							if(oListener.listeners[i].onLogEntry){
								oListener.listeners[i].onLogEntry(oLogEntry);
							}
						}
					},
					attach: function(oLogger, oLstnr){
						if(oLstnr){
							oListener.listeners.push(oLstnr);
							if(oLstnr.onAttachToLog){
								oLstnr.onAttachToLog(oLogger);
							}
						}
					},
					detach: function(oLogger, oLstnr){
						for(var i=0; i<oListener.listeners.length; i++){
							if(oListener.listeners[i] === oLstnr){
								if(oLstnr.onDetachFromLog){
									oLstnr.onDetachFromLog(oLogger);
								}
								oListener.listeners.splice(i,1);
								return;
							}
						}
					}
				};
			}
			return oListener;
		}

		/**
		 * Creates a new log entry depending on its level and component.
		 *
		 * If the given level is higher than the max level for the given component
		 * (or higher than the global level, if no component is given),
		 * then no entry is created.
		 */
		function log(iLevel, sMessage, sDetails, sComponent) {
			if (iLevel <= level(sComponent) ) {
				var oNow = new Date(),
					oLogEntry = {
						time     : pad0(oNow.getHours(),2)+":"+pad0(oNow.getMinutes(),2)+":"+pad0(oNow.getSeconds(),2),
						date     : pad0(oNow.getFullYear(),4) + "-" + pad0(oNow.getMonth()+1,2) + "-" + pad0(oNow.getDate(),2),
						timestamp: oNow.getTime(),
						level    : iLevel,
						message  : String(sMessage || ""),
						details  : String(sDetails || ""),
						component: String(sComponent || "")
					};
				aLog.push( oLogEntry );
				if (oListener) {
					oListener.onLogEntry(oLogEntry);
				}

				/*
				 * Console Log, also tries to log to the window.console, if available.
				 *
				 * Unfortunately, the support for window.console is quite different between the UI5 browsers. The most important differences are:
				 * - in IE (checked until IE9), the console object does not exist in a window, until the developer tools are opened for that window.
				 *   After opening the dev tools, the console remains available even when the tools are closed again. Only using a new window (or tab)
				 *   restores the old state without console.
				 *   When the console is available, it provides most standard methods, but not debug and trace
				 * - in FF3.6 the console is not available, until FireBug is opened. It disappears again, when fire bug is closed.
				 *   But when the settings for a web site are stored (convenience), the console remains open
				 *   When the console is available, it supports all relevant methods
				 * - in FF9.0, the console is always available, but method assert is only available when firebug is open
				 * - in Webkit browsers, the console object is always available and has all required methods
				 *   - Exception: in the iOS Simulator, console.info() does not exist
				 */
				if (window.console) { // in IE and FF, console might not exist; in FF it might even disappear
					var logText = oLogEntry.date + " " + oLogEntry.time + " " + sWindowName + oLogEntry.message + " - " + oLogEntry.details + " " + oLogEntry.component;
					switch(iLevel) {
					case FATAL:
					case ERROR: console.error(logText); break;
					case WARNING: console.warn(logText); break;
					case INFO: console.info ? console.info(logText) : console.log(logText); break;    // info not available in iOS simulator
					case DEBUG: console.debug ? console.debug(logText) : console.log(logText); break; // debug not available in IE, fallback to log
					case TRACE: console.trace ? console.trace(logText) : console.log(logText); break; // trace not available in IE, fallback to log (no trace)
					}
				}
				return oLogEntry;
			}
		}

		/**
		 * @class A Logger class
		 * @param sDefaultComponent
		 * @name jQuery.sap.log.Logger
		 * @since 1.1.2
		 * @public
		 */
		function Logger(sDefaultComponent) {

			/**
			 * Creates a new fatal-level entry in the log with the given message, details and calling component.
			 *
			 * @param {string} sMessage Message text to display
			 * @param {string} [sDetails=''] Details about the message, might be omitted
			 * @param {string} [sComponent=''] Name of the component that produced the log entry
			 * @return {jQuery.sap.log.Logger} The log instance for method chaining
			 * @name jQuery.sap.log.Logger#fatal
			 * @function
			 * @public
			 * @SecSink {0 1 2|SECRET} Could expose secret data in logs
			 */
			this.fatal = function (sMessage, sDetails, sComponent) {
				log(FATAL, sMessage, sDetails, sComponent || sDefaultComponent);
				return this;
			};

			/**
			 * Creates a new error-level entry in the log with the given message, details and calling component.
			 *
			 * @param {string} sMessage Message text to display
			 * @param {string} [sDetails=''] Details about the message, might be omitted
			 * @param {string} [sComponent=''] Name of the component that produced the log entry
			 * @return {jQuery.sap.log.Logger} The log instance
			 * @name jQuery.sap.log.Logger#error
			 * @function
			 * @public
			 * @SecSink {0 1 2|SECRET} Could expose secret data in logs
			 */
			this.error = function error(sMessage, sDetails, sComponent) {
				log(ERROR, sMessage, sDetails, sComponent || sDefaultComponent);
				return this;
			};

			/**
			 * Creates a new warning-level entry in the log with the given message, details and calling component.
			 *
			 * @param {string} sMessage Message text to display
			 * @param {string} [sDetails=''] Details about the message, might be omitted
			 * @param {string} [sComponent=''] Name of the component that produced the log entry
			 * @return {jQuery.sap.log.Logger} The log instance
			 * @name jQuery.sap.log.Logger#warning
			 * @function
			 * @public
			 * @SecSink {0 1 2|SECRET} Could expose secret data in logs
			 */
			this.warning = function warning(sMessage, sDetails, sComponent) {
				log(WARNING, sMessage, sDetails, sComponent || sDefaultComponent);
				return this;
			};
			/**
			 * Creates a new info-level entry in the log with the given message, details and calling component.
			 *
			 * @param {string} sMessage Message text to display
			 * @param {string} [sDetails=''] Details about the message, might be omitted
			 * @param {string} [sComponent=''] Name of the component that produced the log entry
			 * @return {jQuery.sap.log.Logger} The log instance
			 * @name jQuery.sap.log.Logger#info
			 * @function
			 * @public
			 * @SecSink {0 1 2|SECRET} Could expose secret data in logs
			 */
			this.info = function info(sMessage, sDetails, sComponent) {
				log(INFO, sMessage, sDetails, sComponent || sDefaultComponent);
				return this;
			};
			/**
			 * Creates a new debug-level entry in the log with the given message, details and calling component.
			 *
			 * @param {string} sMessage Message text to display
			 * @param {string} [sDetails=''] Details about the message, might be omitted
			 * @param {string} [sComponent=''] Name of the component that produced the log entry
			 * @return {jQuery.sap.log.Logger} The log instance
			 * @name jQuery.sap.log.Logger#debug
			 * @function
			 * @public
			 * @SecSink {0 1 2|SECRET} Could expose secret data in logs
			 */
			this.debug = function debug(sMessage, sDetails, sComponent) {
				log(DEBUG, sMessage, sDetails, sComponent || sDefaultComponent);
				return this;
			};
			/**
			 * Creates a new trace-level entry in the log with the given message, details and calling component.
			 *
			 * @param {string} sMessage Message text to display
			 * @param {string} [sDetails=''] Details about the message, might be omitted
			 * @param {string} [sComponent=''] Name of the component that produced the log entry
			 * @return {jQuery.sap.log.Logger} The log-instance
			 * @name jQuery.sap.log.Logger#trace
			 * @function
			 * @public
			 * @SecSink {0 1 2|SECRET} Could expose secret data in logs
			 */
			this.trace = function trace(sMessage, sDetails, sComponent) {
				log(TRACE, sMessage, sDetails, sComponent || sDefaultComponent);
				return this;
			};

			/**
			 * Defines the maximum jQuery.sap.log.Level of log entries that will be recorded.
			 * Log entries with a higher (less important) log level will be omitted from the log.
			 * When a component name is given, the log level will be configured for that component
			 * only, otherwise the log level for the default component of this logger is set.
			 * For the global logger, the global default level is set.
			 *
			 * <b>Note</b>: Setting a global default log level has no impact on already defined
			 * component log levels. They always override the global default log level.
			 *
			 * @param {jQuery.sap.log.Level} iLogLevel
			 * @param {string} [sComponent] The log component to set the log level for.
			 * @return {jQuery.sap.log} The global logger to allow method chaining
			 * @name jQuery.sap.log.Logger#setLevel
			 * @function
			 * @public
			 */
			this.setLevel = function setLevel(iLogLevel, sComponent) {
				sComponent = sComponent || sDefaultComponent || '';
				mMaxLevel[sComponent] = iLogLevel;
				var mBackMapping = [];
				jQuery.each(jQuery.sap.log.LogLevel, function(idx, v){
					mBackMapping[v] = idx;
				});
				log(INFO, "Changing log level " + (sComponent ? "for '" + sComponent + "' " : "") + "to " + mBackMapping[iLogLevel], "", "jQuery.sap.log");
				return this;
			};

			/**
			 * Returns the log level currently effective for the given component.
			 * If no component is given or when no level has been configured for a
			 * given component, the log level for the default component of this logger is returned.
			 *
			 * @param {string} [sComponent] Name of the component to retrieve the log level for
			 * @return {int} The log level for the given component or the default log level
			 * @name jQuery.sap.log.Logger#getLevel
			 * @function
			 * @public
			 * @since 1.1.2
			 */
			this.getLevel = function getLevel(sComponent) {
				return level(sComponent || sDefaultComponent);
			};

			/**
			 * Checks whether logging is enabled for the given log level, 
			 * depending on the currently effective log level for the given component.
			 *
			 * If no component is given, the default component of this logger will be taken into account.
			 *
			 * @param {int} [iLevel=Level.DEBUG] the log level in question
			 * @param {string} [sComponent] Name of the component to check the log level for
			 * @return {boolean} Whether logging is enabled or not
			 * @name jQuery.sap.log.Logger#isLoggable
			 * @function
			 * @public
			 * @since 1.13.2
			 */
			this.isLoggable = function (iLevel, sComponent) {
				return (iLevel == null ? DEBUG : iLevel) <= level(sComponent || sDefaultComponent);
			};
		}

		/**
		 * A Logging API for JavaScript.
		 *
		 * Provides methods to manage a client-side log and to create entries in it. Each of the logging methods
		 * {@link jQuery.sap.log.#debug}, {@link jQuery.sap.log.#info}, {@link jQuery.sap.log.#warning},
		 * {@link jQuery.sap.log.#error} and {@link jQuery.sap.log.#fatal} creates and records a log entry,
		 * containing a timestamp, a log level, a message with details and a component info.
		 * The log level will be one of {@link jQuery.sap.log.Level} and equals the name of the concrete logging method.
		 *
		 * By using the {@link jQuery.sap.log#setLevel} method, consumers can determine the least important
		 * log level which should be recorded. Less important entries will be filtered out. (Note that higher numeric
		 * values represent less important levels). The initially set level depends on the mode that UI5 is running in.
		 * When the optimized sources are executed, the default level will be {@link jQuery.sap.log.Level.ERROR}.
		 * For normal (debug sources), the default level is {@link jQuery.sap.log.Level.DEBUG}.
		 *
		 * All logging methods allow to specify a <b>component</b>. These components are simple strings and
		 * don't have a special meaning to the UI5 framework. However they can be used to semantically group
		 * log entries that belong to the same software component (or feature). There are two APIs that help
		 * to manage logging for such a component. With <code>{@link jQuery.sap.log.getLogger}(sComponent)</code>,
		 * one can retrieve a logger that automatically adds the given <code>sComponent</code> as component
		 * parameter to each log entry, if no other component is specified. Typically, JavaScript code will
		 * retrieve such a logger once during startup and reuse it for the rest of its lifecycle.
		 * Second, the {@link jQuery.sap.log.Logger#setLevel}(iLevel, sComponent) method allows to set the log level
		 * for a specific component only. This allows a more fine granular control about the created logging entries.
		 * {@link jQuery.sap.log.Logger.getLevel} allows to retrieve the currently effective log level for a given
		 * component.
		 *
		 * {@link jQuery.sap.log#getLog} returns an array of the currently collected log entries.
		 *
		 * Furthermore, a listener can be registered to the log. It will be notified whenever a new entry
		 * is added to the log. The listener can be used for displaying log entries in a separate page area,
		 * or for sending it to some external target (server).
		 *
		 * @author SAP AG
		 * @since 0.9.0
		 * @namespace
		 * @public
		 * @borrows jQuery.sap.log.Logger#fatal as this.fatal
		 * @borrows jQuery.sap.log.Logger#error as this.error
		 * @borrows jQuery.sap.log.Logger#warning as this.warning
		 * @borrows jQuery.sap.log.Logger#info as this.info
		 * @borrows jQuery.sap.log.Logger#debug as this.debug
		 * @borrows jQuery.sap.log.Logger#trace as this.trace
		 * @borrows jQuery.sap.log.Logger#getLevel as this.getLevel
		 * @borrows jQuery.sap.log.Logger#setLevel as this.setLevel
		 * @borrows jQuery.sap.log.Logger#isLoggable as this.isLoggable
		 */
		jQuery.sap.log = jQuery.extend(new Logger(), /** @lends jQuery.sap.log */ {

			/**
			 * Enumeration of the configurable log levels that a Logger should persist to the log.
			 *
			 * Only if the current LogLevel is higher than the level {@link jQuery.sap.log.Level} of the currently added log entry,
			 * then this very entry is permanently added to the log. Otherwise it is ignored.
			 * @see jQuery.sap.log.Logger#setLevel
			 * @namespace
			 * @public
			 */
			Level : {

				/**
				 * Do not log anything
				 * @public
				 */
				NONE : FATAL-1,

				/**
				 * Fatal level. Use this for logging unrecoverable situations
				 * @public
				 */
				FATAL : FATAL,

				/**
				 * Error level. Use this for logging of erroneous but still recoverable situations
				 * @public
				 */
				ERROR : ERROR,

				/**
				 * Warning level. Use this for logging unwanted but foreseen situations
				 * @public
				 */
				WARNING : WARNING,

				/**
				 * Info level. Use this for logging information of purely informative nature
				 * @public
				 */
				INFO : INFO,

				/**
				 * Debug level. Use this for logging information necessary for debugging
				 * @public
				 */
				DEBUG : DEBUG,

				/**
				 * Trace level. Use this for tracing the program flow.
				 * @public
				 */
				TRACE : TRACE, /* TODO Think about changing to 10 and thus to pull out of logging... -> Make tracing explicit */

				/**
				 * Trace level to log everything.
				 */
				ALL : (TRACE + 1) /* TODO if TRACE is changed to make sure this is 6 again. There would then be some special TRACE handling. */
			},

			/**
			 * Returns a {@link jQuery.sap.log.Logger} for the given component.
			 *
			 * The method might or might not return the same logger object across multiple calls.
			 * While loggers are assumed to be light weight objects, consumers should try to
			 * avoid redundant calls and instead keep references to already retrieved loggers.
			 *
			 * The optional second parameter <code>iDefaultLogLevel</code> allows to specify 
			 * a default log level for the component. It is only applied when no log level has been 
			 * defined so far for that component (ignoring inherited log levels). If this method is 
			 * called multiple times for the same component but with different log levels, 
			 * only the first call one might be taken into account.
			 * 
			 * @param {string} sComponent Component to create the logger for
			 * @param {int} [iDefaultLogLevel] a default log level to be used for the component, 
			 *   if no log level has been defined for it so far.
			 * @return {jQuery.sap.log.Logger} A logger for the component.
			 * @public
			 * @static
			 * @since 1.1.2
			 */
			getLogger : function(sComponent, iDefaultLogLevel) {
				if ( !isNaN(iDefaultLogLevel) && mMaxLevel[sComponent] == null ) {
					mMaxLevel[sComponent] = iDefaultLogLevel;
				}
				return new Logger(sComponent);
			},

			/**
			 * Returns the logged entries recorded so far as an array.
			 *
			 * Log entries are plain JavaScript objects with the following properties
			 * <ul>
			 * <li>timestamp {number} point in time when the entry was created
			 * <li>level {int} LogLevel level of the entry
			 * <li>message {string} message text of the entry
			 * </ul>
			 *
			 * @return {object[]} an array containing the recorded log entries
			 * @public
			 * @static
			 * @since 1.1.2
			 */
			getLogEntries : function () {
				return aLog.slice();
			},
			
			/**
			 * Allows to add a new LogListener that will be notified for new log entries.
			 * The given object must provide method <code>onLogEntry</code> and can also be informed
			 * about <code>onDetachFromLog</code> and <code>onAttachToLog</code>
			 * @param {object} oListener The new listener object that should be informed
			 * @return {jQuery.sap.log} The global logger
			 * @public
			 * @static
			 */
			addLogListener : function(oListener) {
				listener().attach(this, oListener);
				return this;
			},
			
			/**
			 * Allows to remove a registered LogListener.
			 * @param {object} oListener The new listener object that should be removed
			 * @return {jQuery.sap.log} The global logger
			 * @public
			 * @static
			 */
			removeLogListener : function(oListener) {
				listener().detach(this, oListener);
				return this;
			}
			
		});

		/**
		 * Deprecated duplicate of {@link jQuery.sap.log.Level}.
		 * @deprecated Since 1.1.2. To streamline the Logging API a bit, the separation between Level and LogLevel has been given up.
		 * Use the (enriched) enumeration {@link jQuery.sap.log.Level} instead.
		 * @namespace Enumeration of levels that can be used in a call to {@link jQuery.sap.log.Logger#setLevel}(iLevel, sComponent).
		 * @public
		 */
		jQuery.sap.log.LogLevel = jQuery.sap.log.Level;

		/**
		 * Retrieves the currently recorded log entries.
		 * @deprecated Since 1.1.2. To avoid confusion with getLogger, this method has been renamed to {@link jQuery.sap.log.getLogEntries}.
		 * @function
		 * @public
		 * @static
		 */
		jQuery.sap.log.getLog = jQuery.sap.log.getLogEntries;

		/**
		 * A simple assertion mechanism that logs a message when a given condition is not met.
		 *
		 * <b>Note:</b> Calls to this method might be removed when the JavaScript code
		 *              is optimized during build. Therefore, callers should not rely on any side effects
		 *              of this method.
		 *
		 * @public
		 * @static
		 * @SecSink {1|SECRET} Could expose secret data in logs
		 */
		jQuery.sap.assert = function(bResult, sMessage) {
			if( !bResult ) {
				if ( window.console && console.assert ) {
					console.assert(bResult, sWindowName + sMessage);
				} else {
					// console is not always available (IE, FF) and IE doesn't support console.assert
					jQuery.sap.log.debug("[Assertions] " + sMessage);
				}
			}
		};

		// against all our rules: use side effect of assert to differentiate between optimized and productive code
		jQuery.sap.assert( !!(mMaxLevel[''] = DEBUG), "will be removed in optimized version");
		// evaluate configuration
		oCfgData.loglevel = oCfgData.loglevel || (function() { var m=/(?:\?|&)sap-ui-log(?:L|-l)evel=([^&]*)/.exec(window.location.search); return m && m[1];}());
		if ( oCfgData.loglevel ) {
			jQuery.sap.log.setLevel(jQuery.sap.log.Level[oCfgData.loglevel.toUpperCase()] || parseInt(oCfgData.loglevel,10));
		}

		jQuery.sap.log.info("SAP Logger started.");
		// log early logs
		jQuery.each(_earlyLogs, function(i,e) { jQuery.sap.log[e.level](e.message); }); _earlyLogs = null;


	}());

	// ---------------------------------------------------------------------------------------------------

	/**
	 * Returns a new constructor function that creates objects with
	 * the given prototype.
	 *
	 * @return {function} the newly created constructor function
	 * @public
	 * @static
	 */
	jQuery.sap.factory = function factory(oPrototype) {
		function Factory() {}
		Factory.prototype = oPrototype;
		return Factory;
	};

	/**
	 * Returns a new object which has the given oPrototype as its prototype.
	 *
	 * If several objects with the same prototype are to be created,
	 * {@link jQuery.sap.factory} should be used instead.
	 *
	 * @public
	 * @static
	 */
	jQuery.sap.newObject = function newObject(oPrototype) {
		return new (jQuery.sap.factory(oPrototype))();
	};

	/**
	 * Returns a new function that returns the given <code>oValue</code> (using its closure).
	 *
	 * Avoids the need for a dedicated member for the value.
	 *
	 * As closures don't come for free, this function should only be used when polluting
	 * the enclosing object is an absolute "must-not" (as it is the case in public base classes).
	 *
	 * @public
	 * @static
	 */
	jQuery.sap.getter = function getter(oValue) {
		return function() {
			return oValue;
		};
	};

	/**
	 * Returns a JavaScript object which is identified by a sequence of names.
	 *
	 * A call to <code>getObject("a.b.C")</code> has essentially the same effect
	 * as accessing <code>window.a.b.C</code> but with the difference that missing
	 * intermediate objects (a or b in the example above) don't lead to an exception.
	 *
	 * When the addressed object exists, it is simply returned. If it doesn't exists,
	 * the behavior depends on the value of the second, optional parameter
	 * <code>iNoCreates</code> (assuming 'n' to be the number of names in the name sequence):
	 * <ul>
	 * <li>NaN: if iNoCreates is not a number and the addressed object doesn't exist,
	 *          then <code>getObject()</code> returns <code>undefined</code>.
	 * <li>0 &lt; iNoCreates &lt; n: any non-existing intermediate object is created, except
	 *          the <i>last</i> <code>iNoCreates</code> ones.
	 * </ul>
	 *
	 * Example:
	 * <pre>
	 *   getObject()            -- returns the context object (either param or window)
	 *   getObject("a.b.C")     -- will only try to get a.b.C and return undefined if not found.
	 *   getObject("a.b.C", 0)  -- will create a, b, and C in that order if they don't exists
	 *   getObject("a.b.c", 1)  -- will create a and b, but not C.
	 * </pre>
	 *
	 * When a <code>oContext</code> is given, the search starts in that object.
	 * Otherwise it starts in the <code>window</code> object that this plugin
	 * has been created in.
	 *
	 * Note: Although this method internally uses <code>object["key"]</code> to address object
	 *       properties, it does not support all possible characters in a name.
	 *       Especially the dot ('.') is not supported in the individual name segments,
	 *       as it is always interpreted as a name separator.
	 *
	 * @param {string} sName  a dot separated sequence of names that identify the required object
	 * @param {int}    [iNoCreates=NaN] number of objects (from the right) that should not be created
	 * @param {object} [oContext=window] the context to execute the search in
	 *
	 * @public
	 * @static
	 */
	jQuery.sap.getObject = function getObject(sName, iNoCreates, oContext) {
		var oObject = oContext || _window,
			aNames = (sName || "").split("."),
			l = aNames.length,
			iEndCreate = isNaN(iNoCreates) ? 0 : l - iNoCreates,
			i;

		for (i=0; oObject && i<l; i++) {
			if (!oObject[aNames[i]] && i<iEndCreate ) {
				oObject[aNames[i]] = {};
			}
			oObject = oObject[aNames[i]];
		}
		return oObject;

	};

	/**
	 * Sets an object property to a given value, where the property is
	 * identified by a sequence of names (path).
	 *
	 * When a <code>oContext</code> is given, the path starts in that object.
	 * Otherwise it starts in the <code>window</code> object that this plugin
	 * has been created for.
	 *
	 * Note: Although this method internally uses <code>object["key"]</code> to address object
	 *       properties, it does not support all possible characters in a name.
	 *       Especially the dot ('.') is not supported in the individual name segments,
	 *       as it is always interpreted as a name separator.
	 *
	 * @param {string} sName  a dot separated sequence of names that identify the property
	 * @param {any}    vValue value to be set, can have any type
	 * @param {object} [oContext=window] the context to execute the search in
	 * @public
	 * @static
	 */
	jQuery.sap.setObject = function (sName, vValue, oContext) {
		var oObject = oContext || _window,
			aNames = (sName || "").split("."),
			l = aNames.length, i;

		if ( l>0 ) {
			for (i=0; oObject && i<l-1; i++) {
				if (!oObject[aNames[i]] ) {
					oObject[aNames[i]] = {};
				}
				oObject = oObject[aNames[i]];
			}
			oObject[aNames[l-1]] = vValue;
		}
	};

	// ---------------------- sync point -------------------------------------------------------------
	
	/*
	 * Internal class that can help to synchronize a set of asynchronous tasks.
	 * Each task must be registered in the sync point by calling startTask with 
	 * an (purely informative) title. The returned value must be used in a later 
	 * call to finishTask. 
	 * When finishTask has been called for all tasks that have been started, 
	 * the fnCallback will be fired. 
	 * When a timeout is given and reached, the callback is called at that 
	 * time, no matter whether all tasks have been finished or not. 
	 */
	function SyncPoint(sName, fnCallback, iTimeout) {
		var aTasks = [],
			iOpenTasks = 0,
			iFailures = 0,
			sTimer;

		this.startTask = function(sTitle) {
			var iId = aTasks.length;
			aTasks[iId] = { name : sTitle, finished : false };
			iOpenTasks++;
			return iId;
		};
		
		this.finishTask = function(iId, bSuccess) {
			if ( !aTasks[iId] || aTasks[iId].finished ) {
				throw new Error("trying to finish non existing or already finished task");
			}
			aTasks[iId].finished = true;
			iOpenTasks--;
			if ( bSuccess === false ) {
				iFailures++;
			}
			if ( iOpenTasks === 0 ) {
				jQuery.sap.log.info("Sync point '" + sName + "' finished (tasks:" + aTasks.length + ", open:" + iOpenTasks + ", failures:" + iFailures + ")");
				if ( sTimer ) {
					clearTimeout(sTimer);
					sTimer = null;
				};
				finish();
			}
		};

		function finish() {
			fnCallback && fnCallback(iOpenTasks, iFailures);
			fnCallback = null;
		}
		
		if ( !isNaN(iTimeout) ) {
			sTimer = setTimeout(function() {
				jQuery.sap.log.info("Sync point '" + sName + "' timed out (tasks:" + aTasks.length + ", open:" + iOpenTasks + ", failures:" + iFailures + ")");
				finish();
			}, iTimeout);
		};
		
		jQuery.sap.log.info("Sync point '" + sName + "' created" + (iTimeout ? "(timeout after " + iTimeout + " ms)" : ""));
		
	}
	
	/**
	 * Internal function to create a sync point.
	 * @private
	 */
	jQuery.sap.syncPoint = function(sName, fnCallback, iTimeout) {
		return new SyncPoint(sName, fnCallback, iTimeout);
	};
	
	// ---------------------- require/declare --------------------------------------------------------

	var getModuleSystemInfo = (function() {

		/**
		 * Local logger, by default only logging errors. Can be configured to DEBUG via config parameter.
		 * @private
		 */
		var log = jQuery.sap.log.getLogger("sap.ui.ModuleSystem",
				(oCfgData["xx-debugModuleLoading"] || /sap-ui-xx-debug(M|-m)odule(L|-l)oading=(true|x|X)/.test(location.search)) ? jQuery.sap.log.Level.DEBUG : jQuery.sap.log.Level.INFO
			),

		/**
		 * A map of URL prefixes keyed by the corresponding module name prefix.
		 * @see jQuery.sap.registerModulePath
		 *
		 * Note that the empty prefix ('') will always match and thus serves as a fallback.
		 * @private
		 */
			mUrlPrefixes = { '' : 'resources/' },

		/**
		 * Module neither has been required nor preloaded not declared, but someone asked for it.
		 */
			INITIAL = 0, 
		
		/**
		 * Module has been preloaded, but not required or declared
		 */
			PRELOADED = -1, 
			
		/**
		 * Module has been declared.
		 */
			LOADING = 1, 
		
		/** 
		 * Module has been loaded, but not yet executed.
		 */
			LOADED = 2, 
		
		/**
		 * Module is currently being executed 
		 */
			EXECUTING = 3, 
		 
		/**
		 * Module has been loaded and executed without errors.
		 */
			READY = 4, 
		
		/**
		 * Module either could not be loaded or execution threw an error 
		 */
			FAILED = 5,
		
		/**
		 * Set of modules that have been loaded (required) so far.
		 * 
		 * Each module is an object that can have the following members
		 * <ul>
		 * <li>{int} state one of the module states defined in this function
		 * <li>{string} url URL where the module has been loaded from
		 * <li>{any} data temp. raw content of the module (between loaded and ready)
		 * <li>{string} error an error description for state <code>FAILED</code>
		 * <li>{any} content the content of the module as exported via define()
		 * </ul>
		 * @private
		 */
			mModules = {
				// predefine already loaded modules to avoid redundant loading
				// "sap/ui/thirdparty/jquery/jquery-1.7.1.js" : { state : READY, url : _sBootstrapUrl, content : jQuery },
				"sap/ui/thirdparty/URI.js" : { state : READY, url : _sBootstrapUrl, content : URI },
				"sap/ui/Device.js" : { state : READY, url : _sBootstrapUrl, content : sap.ui.Device },
				"jquery.sap.global.js" : { state : READY, url : _sBootstrapUrl, content : jQuery }
			},

			mPreloadModules = {},

		/**
		 * Information about third party modules that react on AMD loaders and need a workaround 
		 * to be able to work with jQuery.sap.require no matter whether an AMD loader is present or not.
		 * 
		 * Note: this is a map for future extension
		 * Note: should be maintained together with raw-module info in .library files
		 * @private 
		 */
			mAMDShim = {
				'sap/ui/thirdparty/crossroads.js': true,
				'sap/ui/thirdparty/datajs.js': true,
				'sap/ui/thirdparty/hasher.js': true,
				'sap/ui/thirdparty/IPv6.js': true,
				'sap/ui/thirdparty/jquery/jquery-1.10.2.js': true,
				'sap/ui/thirdparty/jquery/jquery-1.10.1.js': true,
				'sap/ui/thirdparty/jquery/jquery.1.7.1.js': true,
				'sap/ui/thirdparty/jquery/jquery.1.8.1.js': true,
				'sap/ui/thirdparty/jquery-mobile-custom.js': true,
				'sap/ui/thirdparty/less.js': true,
				'sap/ui/thirdparty/punycode.js': true,
				'sap/ui/thirdparty/require.js': true,
				'sap/ui/thirdparty/SecondLevelDomains.js': true,
				'sap/ui/thirdparty/signals.js': true,
				'sap/ui/thirdparty/URI.js' : true
		  },
		  
		/**
		 * Stack of modules that are currently executed.
		 * 
		 * Allows to identify the containing module in case of multi module files (e.g. sap-ui-core)
		 * @private
		 */
			_execStack = [ ],
	
		/**
		 * A prefix that will be added to module loading log statements and which reflects the nesting of module executions.
		 * @private
		 */
			sLogPrefix = "",

		// max size a script should have when executing it with execScript (IE). Otherwise fallback to eval
			MAX_EXEC_SCRIPT_LENGTH = 512*1024,
		
			sDocumentLocation = document.location.href.replace(/\?.*|#.*/g, ""),

			FRAGMENT = "fragment",
			VIEW = "view",
			mKnownSubtypes = {
				js :  [VIEW, FRAGMENT, "controller"],
				xml:  [VIEW, FRAGMENT],
				json: [VIEW, FRAGMENT],
				html: [VIEW, FRAGMENT]
			},
		
			rJSSubtypes = new RegExp("(\\.(?:" + mKnownSubtypes.js.join("|") + "))?\\.js$"),
			rTypes, 
			rSubTypes;
		
		(function() {
			var s = "",
				sSub = "";
			
			jQuery.each(mKnownSubtypes, function(sType, aSubtypes) {
				s = (s ? s + "|" : "") + sType;
				sSub = (sSub ? sSub + "|" : "") + "(?:(?:" + aSubtypes.join("\\.|") + "\\.)?" + sType + ")";
			});
			s = "\\.(" + s + ")$";
			sSub = "\\.(?:" + sSub + "|[^./]+)$";
			log.debug("constructed regexp for file types :" + s);
			log.debug("constructed regexp for file sub-types :" + sSub);
			rTypes = new RegExp(s);
			rSubTypes = new RegExp(sSub);
		}());

		/**
		 * Name conversion function that converts a name in UI5 module name syntax to a name in requireJS module name syntax. 
		 * @private
		 */
		function ui5ToRJS(sName) {
			if ( /^sap\.ui\.thirdparty\.jquery\.jquery-/.test(sName) ) {
				return "sap/ui/thirdparty/jquery/jquery-" + sName.slice("sap.ui.thirdparty.jquery.jquery-".length);
			} else if ( /^jquery\.sap\./.test(sName) ) {
				return sName;
			}
			return sName.replace(/\./g, "/");
		}
		
		/**
		 * Name conversion function that converts a name in unified resource name syntax to a name in UI5 module name syntax.
		 * If the name cannot be converted (e.g. doesn't end with '.js'), then <code>undefined</code> is returned.
		 * 
		 * @private
		 */
		function urnToUI5(sName) {
			var sResult;
			
			// UI5 module name syntax is only defined for JS resources
			if ( !/\.js$/.test(sName) ) {
				return;
			}
			
			sName = sName.slice(0, -3);
			if ( /^sap\/ui\/thirdparty\/jquery\/jquery-/.test(sName) ) {
				return "sap.ui.thirdparty.jquery.jquery-" + sName.slice("sap/ui/thirdparty/jquery/jquery-".length);
			} else if ( /^jquery\.sap\./.test(sName) ) {
				return sName; // do nothing
			}
			return sName.replace(/\//g, ".");
		}
	
		// find longest matching prefix for resource name
		function getResourcePath(sResourceName, sSuffix) {
	
			// split name into segments
			var aSegments = sResourceName.split(/\//),
				l, sNamePrefix, sResult, m;
	
			// if no suffix was given and if the name is not empty, try to guess the suffix from the last segment 
			if ( arguments.length === 1  &&  aSegments.length > 0 ) {
				// only known types (and their known subtypes) are accepted 
				m = rSubTypes.exec(aSegments[aSegments.length-1]);
				if ( m ) {
					sSuffix = m[0];
					aSegments[aSegments.length-1] = aSegments[aSegments.length-1].slice(0, m.index);
				} else {
					sSuffix = "";
				}
			}
			
			// search for a defined name prefix, starting with the full name and successively removing one segment
			for(l=aSegments.length; l>=0; l--) {
				sNamePrefix = aSegments.slice(0, l).join('/');
				if ( mUrlPrefixes[sNamePrefix] ) {
					sResult = mUrlPrefixes[sNamePrefix];
					if ( l < aSegments.length ) {
						sResult += aSegments.slice(l).join('/');
					}
					if ( sResult.slice(-1) === '/' ) {
						sResult = sResult.slice(0, -1);
					}
					return sResult + (sSuffix || '');
				}
			}

			jQuery.sap.assert(false, "should never happen");
		}

		function guessResourceName(sURL) {
			var iLength = -1, 
				sResourceName, 
				sCandidate,
				sCandidateUrl;
			
			for(var sCandidate in mUrlPrefixes) {
				sCandidateUrl = mUrlPrefixes[sCandidate];
				sCandidateUrl = sCandidateUrl + (sCandidateUrl.slice(-1) !== '/' ? "/" : "");
				if ( mUrlPrefixes.hasOwnProperty(sCandidate)
						 && sCandidate.length > iLength
						 && (sURL === sCandidateUrl || sURL.indexOf(sCandidateUrl) === 0) ) {
					iLength = sCandidate.length;
					sResourceName = sCandidate + (sCandidate ? "/" : "") + sURL.slice(sCandidateUrl.length);
				}
			}
			
			return iLength < 0 ? undefined : sResourceName;
		}
		
		function declareModule(sModuleName) {
			var oModule;
			
			// sModuleName must be a unified resource name of type .js
			jQuery.sap.assert(/\.js$/.test(sModuleName), "must be a Javascript module");
			
			oModule = mModules[sModuleName] || (mModules[sModuleName] = { state : INITIAL });
			
			if ( oModule.state > INITIAL ) {
				return oModule;
			}
	
			if ( log.isLoggable() ) {
				log.debug(sLogPrefix + "declare module '" + sModuleName + "'");
			}
	
			// avoid cycles
			oModule.state = READY;
	
			// the first call to declareModule is assumed to identify the bootstrap module
			// Note: this is only a guess and fails e.g. when multiple modules are loaded via a script tag
			// to make it safe, we could convert 'declare' calls to e.g. 'subdeclare' calls at build time.
			if ( _execStack.length === 0 ) {
				_execStack.push(sModuleName);
				oModule.url = oModule.url || _sBootstrapUrl;
			}
			
			return oModule;
		}
	
		function requireModule(sModuleName) {
			var m = rJSSubtypes.exec(sModuleName),
				sBaseName, sType, oModule, aExtensions, i;
			
			// only for robustness, should not be possible by design (all callers append '.js')
			if ( !m ) {
				log.error("can only require Javascript module, not " + sModuleName);
				oModule.state = FAILED;
				return;
			}
			
			// in case of having a type specified ignore the type for the module path creation and add it as file extension
			sBaseName = sModuleName.slice(0, m.index);
			sType = m[0];			// must be a normalized resource name of type .js sType can be empty or one of view|controller|fragment
	
			oModule = mModules[sModuleName] || (mModules[sModuleName] = { state : INITIAL });
			
			if ( log.isLoggable() ) {
				log.debug(sLogPrefix + "require '" + sModuleName + "' of type '" + sType + "'");
			}
	
			// check if module has been loaded already
			if ( oModule.state !== INITIAL ) {
				if ( oModule.state === PRELOADED ) {
					oModule.state = LOADED;
					if ( mAMDShim[sModuleName] && typeof window.define === "function" && window.define.amd ) {
						var amd = window.define.amd;
						try {
							delete window.define.amd;
							execModule(sModuleName);
						} finally {
							window.define.amd = amd;
						}
					} else {
						execModule(sModuleName);
					}
					
				}
	
				if ( oModule.state === READY ) {
					if ( log.isLoggable() ) {
						log.debug(sLogPrefix + "module '" + sModuleName + "' has already been loaded (skipped).");
					}
					return this;
				} else if ( oModule.state === FAILED ) {
					throw new Error("found in negative cache: '" + sModuleName+  "' from " + oModule.url + ": " + oModule.error);
				} else {
					// currently loading
					return this;
				}
			}
	
			// set marker for loading modules (to break cycles)
			oModule.state = LOADING;
	
			// if debug is enabled, try to load debug module first
			aExtensions = window["sap-ui-loaddbg"] ? ["-dbg", ""] : [""];
			for(i=0; i<aExtensions.length && oModule.state !== LOADED; i++) {
				// create module URL for the current extension 
				oModule.url = getResourcePath(sBaseName, aExtensions[i] + sType);
				if ( log.isLoggable() ) {
					log.debug(sLogPrefix + "loading " + (aExtensions[i] ? aExtensions[i] + " version of " : "") + "'" + sModuleName + "' from '" + oModule.url + "'");
				}
				jQuery.ajax({
					url : oModule.url,
					dataType : 'text',
					async : false,
					success : function(response, textStatus, xhr) {
						oModule.state = LOADED;
						oModule.data = response;
					},
					error : function(xhr, textStatus, error) {
						oModule.state = FAILED;
						oModule.error = xhr ? xhr.status + " - " + xhr.statusText : textStatus;
					}
				});
			}
	
			// execute module __after__ loading it, this reduces the required stack space!
			if ( oModule.state === LOADED ) {
				if ( mAMDShim[sModuleName] && typeof window.define === "function" && window.define.amd ) {
					var amd = window.define.amd;
					try {
						delete window.define.amd;
						execModule(sModuleName);
					} finally {
						window.define.amd = amd;
					}
				} else {
					execModule(sModuleName);
				}
			}
	
			if ( oModule.state !== READY ) {
				throw new Error("failed to load '" + sModuleName+  "' from " + oModule.url + ": " + oModule.error);
			}
	
		}
	
		// sModuleName must be a normalized resource name of type .js
		function execModule(sModuleName) {
			
			var oModule = mModules[sModuleName],
				sOldPrefix, oUri, sAbsoluteUrl;
			
			if ( oModule && oModule.state === LOADED && typeof oModule.data !== "undefined" ) {
				try {
	
					if ( log.isLoggable() ) {
						log.debug(sLogPrefix + "executing '" + sModuleName + "'");
						sOldPrefix = sLogPrefix;
						sLogPrefix = sLogPrefix + ": ";
					}
	
					// execute the script in the window context
					oModule.state = EXECUTING;
					_execStack.push(sModuleName);
					if ( typeof oModule.data === "function" ) {
						oModule.data.apply(window);
					} else if (_window.execScript && (!oModule.data || oModule.data.length < MAX_EXEC_SCRIPT_LENGTH) ) { 
						try {
							oModule.data && _window.execScript(oModule.data); // execScript fails if data is empty
						} catch (e) {
							_execStack.pop();
							// eval again with different approach - should fail with a more informative exception
							jQuery.sap.globalEval(oModule.data);
							throw e; // rethrow err in case globalEval succeeded unexpectedly
						}
					} else {
						// make URL absolute so Chrome displays the file tree correctly
						oUri = URI(oModule.url);
						sAbsoluteUrl = oUri.absoluteTo(sDocumentLocation);
						_window.eval(oModule.data + "\r\n//# sourceURL=" + sAbsoluteUrl); // Firebug, Chrome and Safari debugging help, appending the string seems to cost ZERO performance
					}
					_execStack.pop();
					oModule.state = READY;
					oModule.data = undefined;
					// best guess for legacy modules that don't use sap.ui.define
					// TODO implement fallback for raw modules
					oModule.content = oModule.content || jQuery.sap.getObject(urnToUI5(sModuleName)); 
	
					if ( log.isLoggable() ) {
						sLogPrefix = sOldPrefix;
						log.debug(sLogPrefix + "finished executing '" + sModuleName + "'");
					}
	
				} catch (err) {
					oModule.state = FAILED;
					oModule.error = ((err.toString && err.toString()) || err.message) + (err.line ? "(line " + err.line + ")" : "" );
					oModule.data = undefined;
					if ( window["sap-ui-debug"] && (oCfgData["xx-showloaderrors"] || /sap-ui-xx-show(L|-l)oad(E|-e)rrors=(true|x|X)/.test(location.search)) ) {
						log.error("error while evaluating " + sModuleName + ", embedding again via script tag to enforce a stack trace (see below)");
						jQuery.sap.includeScript(oModule.url);
						return;
					}
				}
			}
		}
	
		function requireAll(aDependencies, fnCallback) {
			
			var aModules=[], 
				i, sDepModName, sType, m;
			
			for(i=0; i<aDependencies.length; i++) {
				sDepModName = aDependencies[i];
				log.debug(sLogPrefix + "require '" + sDepModName + "'");
				requireModule(sDepModName + ".js");
				// best guess for legacy modules that don't use sap.ui.define
				// TODO implement fallback for raw modules
				aModules[i] = mModules[sDepModName + ".js"].content || jQuery.sap.getObject(urnToUI5(sDepModName + ".js")); 
				log.debug(sLogPrefix + "require '" + sDepModName + "': done.");
			}
	
			fnCallback.apply(this, aModules);
		}
	
		/**
		 * Constructs an URL to load the module with the given name and file type (suffix).
		 *
		 * Searches the longest prefix of the given module name for which a registration
		 * exists (see {@link jQuery.sap.registerModulePath}) and replaces that prefix
		 * by the registered URL prefix.
		 *
		 * The remainder of the module name is appended to the URL, replacing any dot with a slash.
		 *
		 * Finally, the given suffix (typically a file name extension) is added (unconverted).
		 *
		 * The returned name (without the suffix) doesn't end with a slash.
		 *
		 * @public
		 * @static
		 */
		jQuery.sap.getModulePath = function(sModuleName, sSuffix) {
			return getResourcePath(ui5ToRJS(sModuleName), sSuffix);
		};
		
		jQuery.sap.getResourcePath = getResourcePath;
	
		/**
		 * Registers an URL prefix for a module name prefix.
		 *
		 * Before a module is loaded, the longest registered prefix of its module name
		 * is searched for and the associated URL prefix is used as a prefix for the request URL.
		 * The remainder of the module name is attached to the request URL by replacing
		 * dots ('.') with slashes ('/').
		 *
		 * The registration and search operates on full name segments only. So when a prefix
		 *
		 *    'sap.com'  ->  'http://www.sap.com/ui5/resources/'
		 *
		 * is registered, then it will match the name
		 *
		 *    'sap.com.Button'
		 *
		 * but not
		 *
		 *    'sap.commons.Button'
		 *
		 * Note that the empty prefix ('') will always match and thus serves as a fallback for
		 * any search.
		 *
		 * @public
		 * @static
		 * @SecSink {1|PATH} Parameter is used for future HTTP requests
		 */
		jQuery.sap.registerModulePath = function registerModulePath(sModuleName, sUrlPrefix) {
			jQuery.sap.assert(!/\//.test(sModuleName), "module path must not contain a slash.");
			sModuleName = sModuleName.replace(/\./g, "/");
			// URL must not be empty
			sUrlPrefix = sUrlPrefix || '.';
			jQuery.sap.registerResourcePath(sModuleName, sUrlPrefix);
		};
		
		/**
		 * Registers an URL prefix for a resource name prefix.
		 *
		 * Before a resource is loaded, the longest registered prefix of its module name
		 * is searched for and the associated URL prefix is used as a prefix for the request URL.
		 * The remainder of the resource name is attached to the request URL 1:1.
		 *
		 * The registration and search operates on full name segments only. So when a prefix
		 *
		 *    'sap/com'  ->  'http://www.sap.com/ui5/resources/'
		 *
		 * is registered, then it will match the name
		 *
		 *    'sap/com/Button'
		 *
		 * but not
		 *
		 *    'sap/commons/Button'
		 *
		 * Note that the empty prefix ('') will always match and thus serves as a fallback for
		 * any search.
		 *
		 * @public
		 * @static
		 * @SecSink {1|PATH} Parameter is used for future HTTP requests
		 */
		jQuery.sap.registerResourcePath = function(sResourceNamePrefix, sUrlPrefix) {
	
			sResourceNamePrefix = String(sResourceNamePrefix || "");
			
			if ( sUrlPrefix == null ) {
				delete mUrlPrefixes[sResourceNamePrefix]; 
			} else {
				sUrlPrefix = String(sUrlPrefix);
				// ensure that the prefix ends with a '/'
				if ( sUrlPrefix.slice(-1) != '/' ) {
					sUrlPrefix += '/';
				}
				mUrlPrefixes[sResourceNamePrefix] = sUrlPrefix;
			}
			
			log.info("registerResourcePath ('" + sResourceNamePrefix + "', '" + sUrlPrefix + "')");
	
		}
	
		/**
		 * Check whether a given module has been loaded / declared already.
		 * 
		 * Returns true as soon as a module has been required the first time, even when 
		 * loading/executing it has not finished yet. So the main assertion of a  
		 * return value of <code>true</code> is that the necessary actions have been taken
		 * to make the module available in the near future. It does not mean, that 
		 * the content of the module is already available!
		 * 
		 * This fuzzy behavior is necessary to avoid multiple requests for the same module. 
		 * As a consequence of the assertion above, a <i>preloaded</i> module does not
		 * count as <i>declared</i>. For preloaded modules, an explicit call to 
		 * <code>jQuery.sap.require</code> is necessary to make them available.
		 * 
		 * If a caller wants to know whether a module needs to be loaded from the server, 
		 * it can set <code>bIncludePreloaded</code> to true. Then, preloaded modules will 
		 * be reported as 'declared' as well by this method. 
		 * 
		 * @param {string} sModuleName name of the module to be checked
		 * @param {boolean} [bIncludePreloaded=false] whether preloaded modules should be reported as declared.
		 * @return {boolean} whether the module has been declared already
		 * @public
		 * @static
		 */
		jQuery.sap.isDeclared = function isDeclared(sModuleName, bIncludePreloaded) {
			sModuleName = ui5ToRJS(sModuleName) + ".js";
			return mModules[sModuleName] && (bIncludePreloaded || mModules[sModuleName].state !== PRELOADED);
		};
		
		/**
		 * Returns the names of all declared modules.
		 * @return {string[]} the names of all declared modules
		 * @see jQuery.sap.isDeclared
		 * @public
		 * @static
		 */
		jQuery.sap.getAllDeclaredModules = function() {
			var aModules = [];
			jQuery.each(mModules, function(sURN, oModule) {
				// filter out preloaded modules
				if ( oModule && oModule.state !== PRELOADED ) {
					var sModuleName = urnToUI5(sURN);
					if ( sModuleName ) {
						aModules.push(sModuleName);
					}
				}
			});
			return aModules;
		};
	
		// take resource roots from configuration
		if ( oCfgData.resourceroots ) {
			jQuery.each(oCfgData.resourceroots, jQuery.sap.registerModulePath);
		}
	
		// dump the URL prefixes
		log.info("URL prefixes set to:");
		for(var n in mUrlPrefixes) {
			log.info("  " + (n ? "'" + n + "'" : "(default)") + " : " + mUrlPrefixes[n]);
		}
	
		/**
		 * Declares a module as existing.
		 *
		 * By default, this function assumes that the module will create a JavaScript object
		 * with the same name as the module. As a convenience it ensures that the parent
		 * namespace for that object exists (by calling jQuery.sap.getObject).
		 * If such an object creation is not desired, <code>bCreateNamespace</code> must be set to false.
		 *
		 * @param {string || object} sModuleName name of the module to be declared
		 *                           or in case of an object {modName: "...", type: "..."}
		 *                           where modName is the name of the module and the type
		 *                           could be a specific dot separated extension e.g.
		 *                           <code>{modName: "sap.ui.core.Dev", type: "view"}</code>
		 *                           loads <code>sap/ui/core/Dev.view.js</code> and
		 *                           registers as <code>sap.ui.core.Dev.view</code>
		 * @param {boolean} [bCreateNamespace=true] whether to create the parent namespace
		 *
		 * @public
		 * @static
		 */
		jQuery.sap.declare = function(sModuleName, bCreateNamespace) {
			
			var sNamespaceObj = sModuleName;
	
			// check for an object as parameter for sModuleName
			// in case of this the object contains the module name and the type
			// which could be {modName: "sap.ui.core.Dev", type: "view"}
			if (typeof(sModuleName) === "object") {
				sNamespaceObj = sModuleName.modName;
				sModuleName = ui5ToRJS(sModuleName.modName) + (sModuleName.type ? "." + sModuleName.type : "") + ".js";
			} else {
				sModuleName = ui5ToRJS(sModuleName) + ".js";
			}
			
			declareModule(sModuleName);
			
			// ensure parent namespace even if module was declared already
			// (as declare might have been called by require)
			if (bCreateNamespace !== false) {
				// ensure parent namespace
				jQuery.sap.getObject(sNamespaceObj, 1);
			}
	
			return this; 
		}
		
		/**
		 * Ensures that the given module is loaded and executed before execution of the
		 * current script continues.
		 *
		 * By issuing a call to this method, the caller declares a dependency to the listed modules.
		 *
		 * Any required and not yet loaded script will be loaded and execute synchronously.
		 * Already loaded modules will be skipped.
		 *
		 * @param {string... || object} sModuleName one or more names of modules to be loaded
		 *                              or in case of an object {modName: "...", type: "..."}
		 *                              where modName is the name of the module and the type
		 *                              could be a specific dot separated extension e.g.
		 *                              <code>{modName: "sap.ui.core.Dev", type: "view"}</code>
		 *                              loads <code>sap/ui/core/Dev.view.js</code> and
		 *                              registers as <code>sap.ui.core.Dev.view</code>
		 *
		 * @public
		 * @static
		 * @function
		 * @SecSink {0|PATH} Parameter is used for future HTTP requests
		 */
		jQuery.sap.require = function(vModuleName, fnCallback) {
			
			if ( jQuery.isArray(vModuleName) && typeof fnCallback === "function" ) {
				// requireJS variant with multiple dependencies and a callback function 
				requireAll(vModuleName, fnCallback); 
			} else if ( arguments.length > 1 ) {
				// legacy mode with multiple arguments, each representing a dependency 
				for(var i=0; i<arguments.length; i++) {
					jQuery.sap.require(arguments[i]);
				}
				return this;
			}

			// check for an object as parameter for sModuleName
			// in case of this the object contains the module name and the type
			// which could be {modName: "sap.ui.core.Dev", type: "view"}
			if (typeof(vModuleName) === "object") {
				jQuery.sap.assert(!vModuleName.type || jQuery.inArray(vModuleName.type, mKnownSubtypes.js) >= 0, "type must be empty or one of " + mKnownSubtypes.js.join(", "));
				vModuleName = ui5ToRJS(vModuleName.modName) + (vModuleName.type ? "." + vModuleName.type : "") + ".js";
			} else {
				vModuleName = ui5ToRJS(vModuleName) + ".js";
			}

			requireModule(vModuleName);

			return this; // TODO
		}

		/**
		 * UI5 internal method that loads the given module, specified in requireJS notation (URL like, without extension).
		 * 
		 * Applications MUST NOT USE THIS METHOD as it will be removed in one of the future versions.
		 * It is only intended for sap.ui.component.
		 * 
		 * @param {string} sModuleName Module name in requireJS syntax
		 * @private
		 */
		jQuery.sap._requirePath = function(sModuleName) {
			requireModule(sModuleName + ".js");
		}

		window.sap = window.sap || {};
		sap.ui = sap.ui || {};

		/**
		 * Provides an AMD like way to define UI5 modules. 
		 * 
		 * MUST NOT BE USED BY CONTROLS OR APPLICATIONS YET, ONLY UI5 CORE TEAM INTERNALLY. 
		 *
		 * TODO document naming conventions: requireJs names, but no dots in them (other than jquery.sap. jquery-1....)
		 * @param {string} [sId] id of the module. When omitted, the loader should determine the id from the request
		 * @param {string[]} [aDependencies] ordered list of dependencies of the module. 
		 * @param {function|object} vFactory
		 * @param {boolean} [bExport]
		 * @private
		 */
		sap.ui.define = function(sId, aDependencies, vFactory, bExport) {
			var aModules = [],
				sModuleName,
				sDepModName,
				i;

			// optional id
			if ( typeof sId === "string" ) {
				sModuleName = sId + ".js";
			} else {
				// shift parameters
				bExport = vFactory;
				vFactory = aDependencies;
				aDependencies = sId;
				sModuleName = _execStack[_execStack.length-1]; 
			}
			sId = urnToUI5(sModuleName);

			// optional array of dependencies
			if ( !jQuery.isArray(aDependencies) ) {
				// shift parameters
				bExport = vFactory;
				vFactory = aDependencies;
				aDependencies = [];
			} else {
				// resolve relative module names
				var sPackage = sModuleName.slice(0,1+sModuleName.lastIndexOf('/'));
				for(i=0; i<aDependencies.length; i++) {
					if ( /^\.\//.test(aDependencies[i]) ) {
						aDependencies[i] = sPackage + aDependencies[i].slice(2); 
					}
				}
			}

			if ( log.isLoggable() ) {
				log.debug("define(" + sModuleName + ", " + "['" + aDependencies.join("','") + "']" + ")");
			}

			var oModule = declareModule(sModuleName);

			// note: dependencies will be converted from RJS to URN inside requireAll
			requireAll(aDependencies, function() {

				// factory
				if ( log.isLoggable() ) {
					log.debug("define(" + sModuleName + "): calling factory " + typeof vFactory);
				}

				if ( bExport ) {
					// ensure parent namespace
					jQuery.sap.getObject(sId, 1);
				}

				if ( typeof vFactory === "function" ) {
					oModule.content = vFactory.apply(window, arguments);
				} else {
					oModule.content = vFactory;
				}

				// HACK: global export
				if ( bExport ) {
					if ( oModule.content == null ) {
						log.error("module '" + sModuleName + "' returned no content, but should be exported");
					} else {
						if ( log.isLoggable() ) {
							log.debug("exporting content of '" + sModuleName + "': as global object");
						}
						jQuery.sap.setObject(sId, oModule.content);
					}
				}

			});

		};

		jQuery.sap.preloadModules = function(sPreloadModule, bAsync, oSyncPoint) {

			var sURL, iTask;

			jQuery.sap.assert(!bAsync ||oSyncPoint, "if mode is async, a syncpoint object must be given");

			if ( mPreloadModules[sPreloadModule] )
				return;
	
			mPreloadModules[sPreloadModule] = true;
	
			sURL = jQuery.sap.getModulePath(sPreloadModule, ".json");
			
			log.debug("preload file " + sPreloadModule);
			iTask = oSyncPoint && oSyncPoint.startTask("load " + sPreloadModule);
			jQuery.ajax({
				dataType : "json",
				async : bAsync,
				url : sURL,
				success : function(data) {
					if ( data ) {
						data.url = sURL;
					}
					jQuery.sap.registerPreloadedModules(data, bAsync, oSyncPoint);
					oSyncPoint && oSyncPoint.finishTask(iTask);
				},
				error : function(xhr, textStatus, error) {
					log.error("failed to preload '" + sPreloadModule + "': " + (error || textStatus));
					oSyncPoint && oSyncPoint.finishTask(iTask, false);
				}
			});

		};

		jQuery.sap.registerPreloadedModules = function(oData, bAsync, oSyncPoint) {

			var bOldSyntax = Version(oData.version || "1.0").compareTo("2.0") < 0;
			
			if ( log.isLoggable() ) {
				log.debug(sLogPrefix + "adding preloaded modules from '" + oData.url + "'");
			}

			if ( oData.name ) {
				mPreloadModules[oData.name] = true;
			}

			jQuery.each(oData.modules, function(sName,sContent) {
				sName = bOldSyntax ? ui5ToRJS(sName) + ".js" : sName;
				if ( !mModules[sName] ) {
					mModules[sName] = { state : PRELOADED, url : oData.url + "/" + sName, data : sContent, group: oData.name };
				}
				// when a library file is preloaded, also mark its preload file as loaded
				// for normal library preload, this is redundant, but for non-default merged entities
				// like sap/fiori/core.js it avoids redundant loading of library preload files
				if ( sName.match(/\/library\.js$/) ) {
					mPreloadModules[urnToUI5(sName) + "-preload"] = true;
				}
			});
			
			if ( oData.dependencies ) {
				jQuery.each(oData.dependencies, function(idx,sModuleName) {
					jQuery.sap.preloadModules(sModuleName, bAsync, oSyncPoint);
				});
			}
		};

		/**
		 * Removes a set of resources from the resource cache.
		 * 
		 * @param {string} sName unified resource name of a resource or the name of a preload group to be removed
		 * @param {boolean} [bPreloadGroup=true] whether the name specifies a preload group, defaults to true
		 * @param {boolean} [bUnloadAll] Whether all matching resources should be unloaded, even if they have been executed already. 
		 * @param {boolean} [bDeleteExports] Whether exportss (global variables) should be destroyed as well. Will be done for UI5 module names only. 
		 * @experimental Since 1.16.3 API might change completely, apps must not develop against it.
		 * @private
		 */
		jQuery.sap.unloadResources = function(sName, bPreloadGroup, bUnloadAll, bDeleteExports) {
			var aModules=[];
			
			if ( bPreloadGroup == null ) {
				bPreloadGroup = true;
			}

			if ( bPreloadGroup ) {
				// collect modules that belong to the given group
				jQuery.each(mModules, function(sURN, oModule) {
					if ( oModule && oModule.group === sName ) {
						aModules.push(sURN);
					}
				});
				// also remove a preload entry
				delete mPreloadModules[sName];
				
			} else {
				// single module
				if ( mModules[sName] ) {
					aModules.push(sName);
				}
			}

			jQuery.each(aModules, function(i, sURN) {
				var oModule = mModules[sURN];
				if ( oModule && bDeleteExports && sURN.match(/\.js$/) ) {
					jQuery.sap.setObject(urnToUI5(sURN), undefined); // TODO really delete property
				}
				if ( oModule && (bUnloadAll || oModule.state === PRELOADED) ) {
				  delete mModules[sURN];
				}
			});
			
		};

		/**
		 * Converts a UI5 module name to a unified resource name.
		 *
		 * @experimental Since 1.16.0, not for public usage yet.
		 * @private
		 */
		jQuery.sap.getResourceName = function(sModuleName, sSuffix) {
			return ui5ToRJS(sModuleName) + (sSuffix || ".js");
		};
		
		/**
		 * Retrieves the resource with the given name, either from the preload cache or from 
		 * the server. The expected data type of the resource can either be specified in the 
		 * options (<code>dataType</code>) or it will be derived from the suffix of the <code>sResourceName</code>.
		 * The only supported data types so far are xml, html, json and text. If the resource name extension
		 * doesn't match any of these extensions, the data type must be specified in the options.  
		 * 
		 * If the resource is found in the preload cache, it will be converted from text format
		 * to the requested <code>dataType</code> using a converter from <code>jQuery.ajaxSettings.converters</code>.
		 *  
		 * If it is not found, the resource name will be converted to a resource URL (using {@link #getResourcePath}) 
		 * and the resulting URL will be requested from the server with a synchronous jQuery.ajax call.
		 * 
		 * If the resource was found in the local preload cache and any necessary conversion succeeded
		 * or when the resource was retrieved from the backend successfully, the content of the resource will
		 * be returned. In any other case, an exception will be thrown, or if option failOnError is set to true,
		 * <code>null</code> will be returned.
		 * 
		 * Future implementations of this API might add more options, esp. asynchronous calls might 
		 * be possible. Generic implementations that accept an <code>mOptions</code> object and propagate it
		 * to this function should limit the options to the currently defined set of options or they might fail 
		 * for unknown options (e.g. async calls won't return the resource immediately). 
		 * 
		 * For asynchronous calls the return type of this method will change. 
		 * 
		 * @param {string} [sResourceName] resourceName in unified resource name syntax
		 * @param {object} [mOptions] options 
		 * @param {object} [mOptions.dataType] one of "xml", "html", "json" or "text". If not specified it will be derived from the resource name (extension)
		 * @param {string} [mOptions.name] name of the resource to load (alternative syntax)
		 * @param {string} [mOptions.url] url of a resource to load (alternative syntax, name will only be a guess)
		 * @param {string} [mOptions.headers] Http headers for an eventual XHR request
		 * @param {string} [mOptions.failOnError=true] whether to propagate load errors or not
		 * @return {string|Document|object} content of the resource. A string for text or html, an Object for JSON, a Document for XML
		 * @throws Error if loading the resource failed
		 * @private
		 * @experimental API is not yet fully mature and may change in future.
		 * @since 1.15.1 
		 */
		jQuery.sap.loadResource = function(sResourceName, mOptions) {

			var sType,
				oData,
				vConverter, 
				sUrl,
				oError;

			if ( typeof sResourceName === "string" ) {
				mOptions = mOptions || {};
			} else {
				mOptions = sResourceName || {};
				sResourceName = mOptions.name;
				if ( !sResourceName && mOptions.url) {
					sResourceName = guessResourceName(mOptions.url);
				}
			}
			// defaulting
			mOptions = jQuery.extend({ failOnError: true }, mOptions);
			
			sType = mOptions.dataType; 
			if ( sType == null && sResourceName ) {
				sType = (sType = rTypes.exec(sResourceName)) && sType[1];
			}

			jQuery.sap.assert(/^(xml|html|json|text)$/.test(sType), "type must be one of xml, html, json or text");

			oData = sResourceName && mModules[sResourceName] && mModules[sResourceName].data;
			if ( oData != null ) {

				vConverter = jQuery.ajaxSettings.converters["text " + sType];
				if ( typeof vConverter === "function" ) {
					oData = vConverter(oData);
				}

			} else {

				jQuery.ajax({
					url : sUrl = mOptions.url || getResourcePath(sResourceName),
					async : false,
					dataType : sType,
					headers: mOptions.headers,
					success : function(data, textStatus, xhr) {
						oData = data;
					},
					error : function(xhr, textStatus, error) {
						oData = null; // normalize 
						oError = new Error("resource " + sResourceName + " could not be loaded from " + sUrl + ". Check for 'file not found' or parse errors.");
						oError.status = textStatus;
						oError.error = error;
						oError.statusCode = xhr.status;
					}
				});

			}

			if ( oData == null && mOptions.failOnError ) {
				throw oError || new Error("no data returned for " + sResourceName);
			}

			return oData;
		};

		return function() {
			return { modules : mModules, prefixes : mUrlPrefixes };
		};

	}());

	// --------------------- script and stylesheet handling --------------------------------------------------

	// appends a link object to the head
	function appendHead(oElement) {
		var head = window.document.getElementsByTagName("head")[0];
		if (head) {
			head.appendChild(oElement);
		}
	}

	/**
	 * Includes the script (via &lt;script&gt;-tag) into the head for the
	 * specified <code>sUrl</code> and optional <code>sId</code>.
	 * <br>
	 * <i>In case of IE8 only the load callback will work ignoring in case of success and error.</i>
	 *
	 * @param {string}
	 *            sUrl the URL of the script to load
	 * @param {string}
	 *            [sId] id that should be used for the script include tag
	 * @param {function}
	 *            [fnLoadCallback] callback function to get notified once the script has been loaded
	 * @param {function}
	 *            [fnErrorCallback] callback function to get notified once the script loading failed (not supported by IE8)
	 *
	 * @public
	 * @static
	 * @SecSink {0|PATH} Parameter is used for future HTTP requests
	 */
	jQuery.sap.includeScript = function includeScript(sUrl, sId, fnLoadCallback, fnErrorCallback){
		var oScript = window.document.createElement("script");
		oScript.src = sUrl;
		oScript.type = "text/javascript";
		if (sId) {
			oScript.id = sId;
		}
		if (!!sap.ui.Device.browser.internet_explorer && sap.ui.Device.browser.version < 9) {
			// in case if IE8 the error callback is not supported!
			// we can only check the loading via the readystatechange event
			if (fnLoadCallback) {
				oScript.onreadystatechange = function() {
					if (oScript.readyState === "loaded" || oScript.readyState === "complete") {
						fnLoadCallback();
						oScript.onreadystatechange = null;
					}
				};
			}
		} else {
			if (fnLoadCallback) {
				jQuery(oScript).load(fnLoadCallback);
			}
			if (fnErrorCallback) {
				jQuery(oScript).error(fnErrorCallback);
			}
		}
		// jQuery("head").append(oScript) doesn't work because they filter for the script
		// and execute them directly instead adding the SCRIPT tag to the head
		var oOld;
		if ((sId && (oOld = jQuery.sap.domById(sId)) && oOld.tagName === "SCRIPT")) {
			jQuery(oOld).remove(); // replacing scripts will not trigger the load event
		}
		appendHead(oScript);
	};

	/**
	 * Includes the specified stylesheet via a &lt;link&gt;-tag in the head of the current document. If there is call to
	 * <code>includeStylesheet</code> providing the sId of an already included stylesheet, the existing element will be
	 * replaced.
	 * 
	 * @param {string}
	 *          sUrl the URL of the script to load
	 * @param {string}
	 *          [sId] id that should be used for the script include tag
	 * @param {function}
	 *          [fnLoadCallback] callback function to get notified once the link has been loaded
	 * @param {function}
	 *          [fnErrorCallback] callback function to get notified once the link loading failed
	 * 
	 * @public
	 * @static
	 * @SecSink {0|PATH} Parameter is used for future HTTP requests
	 */
	jQuery.sap.includeStyleSheet = function includeStyleSheet(sUrl, sId, fnLoadCallback, fnErrorCallback) {

		var _createLink = function(sUrl, sId, fnLoadCallback, fnErrorCallback){

			// create the new link element
			var oLink = document.createElement("link");
			oLink.type = "text/css";
			oLink.rel = "stylesheet";
			oLink.href = sUrl;
			if (sId) {
				oLink.id = sId;
			}

			jQuery(oLink).load(function() {
				jQuery(oLink).attr("sap-ui-ready", "true");
				if (fnLoadCallback) {
					fnLoadCallback();
				}
			});

			jQuery(oLink).error(function() {
				jQuery(oLink).attr("sap-ui-ready", "false");
				if (fnErrorCallback) {
					fnErrorCallback();
				}
			});
			return oLink;

		};

		var _appendStyle = function(sUrl, sId, fnLoadCallback, fnErrorCallback){

			if (sap.ui.Device.browser.internet_explorer && sap.ui.Device.browser.version <= 9 && document.styleSheets.length >= 29) {
				// in IE9 only 30 links are alowed, so use stylesheet object insted
				var sRootUrl = URI.parse(document.URL).path;
				jQuery.sap.log.warning("StlyeSheet "+sId+" not added as LINK because of IE limits", sUrl, "jQuery.sap.includeStyleSheet");
				if (!this._oIEStyleSheet) {
					// create a style sheet to add additional style sheet. But for this the Replace logic will not work any more
					// the callback functions are not used in this case
					// the sap-ui-ready attribute will not be set -> maybe problems with ThemeCheck
					this._oIEStyleSheet = document.createStyleSheet();
					this._oIEStyleSheet.addImport(URI(sUrl).absoluteTo(sRootUrl));
				} else {
					// add up to 30 style sheets to every of this style sheets. (result is a tree of style sheets)
					var bAdded = false;
					for ( var i = 0; i < this._oIEStyleSheet.imports.length; i++) {
						var oStyleSheet = this._oIEStyleSheet.imports[i];
						if (oStyleSheet.imports.length < 30) {
							oStyleSheet.addImport(URI(sUrl).absoluteTo(sRootUrl));
							bAdded = true;
							break;
						}
					}
					if (!bAdded) {
						this._oIEStyleSheet.addImport(URI(sUrl).absoluteTo(sRootUrl));
					}
				}
			}else {
				appendHead(_createLink(sUrl, sId, fnLoadCallback, fnErrorCallback));
			}

		};

		// check for existence of the link
		var oOld, bReplace;
		if ((sId && (oOld = jQuery.sap.domById(sId)) && (bReplace = oOld.tagName === "LINK" && oOld.rel ==="stylesheet")) || window.document.body) {
			if (bReplace) {
				// if link exists and URL would not change and if no callbacks are given, then don't touch the link 
				if ( oOld.getAttribute("href") !== sUrl || fnLoadCallback || fnErrorCallback ) {
					jQuery(oOld).replaceWith(_createLink(sUrl, sId, fnLoadCallback, fnErrorCallback));
				}
			} else {
				_appendStyle(sUrl, sId, fnLoadCallback, fnErrorCallback);
			}
		} else {
			_appendStyle(sUrl, sId, fnLoadCallback, fnErrorCallback);
		}

	};

	// TODO should be in core, but then the 'callback' could not be implemented
	if ( !(oCfgData.productive === true || oCfgData.productive === "true"  || oCfgData.productive === "x") ) {
		jQuery(function() {
			jQuery(document.body).keydown(function(e) {
				if ( e.keyCode == 80 && e.shiftKey && e.altKey && e.ctrlKey ) {
					try {
						jQuery.sap.require("sap.ui.debug.TechnicalInfo");
					} catch (e) {
						// alert("Sorry, failed to activate 'P'-mode!");
						return;
					}
					sap.ui.debug.TechnicalInfo.open(function() {
						var oInfo = getModuleSystemInfo();
						return { modules : oInfo.modules, prefixes : oInfo.urlPrefixes, config: oCfgData };
					});
				}
			});
		});
		
		jQuery(function() {
			jQuery(document.body).keydown(function(e) {
				if ( e.keyCode == 83 /*S*/ && e.shiftKey && e.altKey && e.ctrlKey ) { //TODO: Is this ok?
					try {
						jQuery.sap.require("sap.ui.core.support.Support");
						var oSupport = sap.ui.core.support.Support.getStub();
						if(oSupport.getType() != sap.ui.core.support.Support.StubType.APPLICATION){
							return;
						}
						oSupport.openSupportTool();
					} catch(e) {
					}
				}
			});
		});
	}

	// *********** Include E2E-Trace Scripts *************
	if (/sap-ui-xx-e2e-trace=(true|x|X)/.test(location.search)) {
		jQuery.sap.require("sap.ui.core.support.trace.E2eTraceLib" + "" /* Make dynamic dependency */);
	}

	// *********** feature detection, enriching jQuery.support *************
	// this might go into its own file once there is more stuff added

	/**
	 * Holds information about the browser's capabilities and quirks.
	 * This object is provided and documented by jQuery. 
	 * But it is extended by SAPUI5 with detection for features not covered by jQuery. This documentation ONLY covers the detection properties added by UI5.
	 * For the standard detection properties, please refer to the jQuery documentation.
	 * 
	 * These properties added by UI5 are only available temporarily until jQuery adds feature detection on their own.
	 * 
	 * @name jQuery.support
	 * @namespace
	 * @since 1.12
	 * @public
	 */
	
	if (!jQuery.support) {
		jQuery.support = {};
	}
	
	jQuery.extend(jQuery.support, {touch: "ontouchend" in document}); // this is also defined by jquery-mobile-custom.js, but this information is needed earlier

	var aPrefixes = ["Webkit", "ms", "Moz"];
	var oStyle = document.documentElement.style;
	
	var preserveOrTestCssPropWithPrefixes = function(detectionName, propName) {
		if (jQuery.support[detectionName] === undefined) {
			
			if (oStyle[propName] !== undefined) { // without vendor prefix
				jQuery.support[detectionName] = true;
				// If one of the flex layout properties is supported without the prefix, set the flexBoxPrefixed to false
				if(propName === "boxFlex" || propName === "flexOrder" || propName === "flexGrow") {
					jQuery.support.flexBoxPrefixed = false;
				}
				return;
				
			} else { // try vendor prefixes
				propName = propName.charAt(0).toUpperCase() + propName.slice(1);
				for (var i in aPrefixes) {
					if (oStyle[aPrefixes[i]+propName] !== undefined) {
						jQuery.support[detectionName] = true;
						return;
					}
				}
			}
			jQuery.support[detectionName] = false;
		}
	};

	/**
	 * Whether the current browser supports (2D) CSS transforms
	 * @type {boolean}
	 * @public
	 * @name jQuery.support.cssTransforms
	 */
	preserveOrTestCssPropWithPrefixes("cssTransforms", "transform");

	/**
	 * Whether the current browser supports 3D CSS transforms
	 * @type {boolean}
	 * @public
	 * @name jQuery.support.cssTransforms3d
	 */
	preserveOrTestCssPropWithPrefixes("cssTransforms3d", "perspective");

	/**
	 * Whether the current browser supports CSS transitions
	 * @type {boolean}
	 * @public
	 * @name jQuery.support.cssTransitions
	 */
	preserveOrTestCssPropWithPrefixes("cssTransitions", "transition");

	/**
	 * Whether the current browser supports (named) CSS animations
	 * @type {boolean}
	 * @public
	 * @name jQuery.support.cssAnimations
	 */
	preserveOrTestCssPropWithPrefixes("cssAnimations", "animationName");

	/**
	 * Whether the current browser supports CSS gradients. Note that ANY support for CSS gradients leads to "true" here, no matter what the syntax is.
	 * @type {boolean}
	 * @public
	 * @name jQuery.support.cssGradients
	 */
	if (jQuery.support.cssGradients === undefined) {
		var oElem = document.createElement('div'),
		oStyle = oElem.style;
		try {
			oStyle.backgroundImage = "linear-gradient(left top, red, white)";
			oStyle.backgroundImage = "-moz-linear-gradient(left top, red, white)";
			oStyle.backgroundImage = "-webkit-linear-gradient(left top, red, white)";
			oStyle.backgroundImage = "-ms-linear-gradient(left top, red, white)";
			oStyle.backgroundImage = "-webkit-gradient(linear, left top, right bottom, from(red), to(white))";
		} catch (e) {/* no support...*/}
		jQuery.support.cssGradients = (oStyle.backgroundImage && oStyle.backgroundImage.indexOf("gradient") > -1);
		
		oElem = null; // free for garbage collection
	}

	/**
	 * Whether the current browser supports only prefixed flexible layout properties
	 * @type {boolean}
	 * @public
	 * @name jQuery.support.flexBoxPrefixed
	 */
	jQuery.support.flexBoxPrefixed = true;	// Default to prefixed properties

	/**
	 * Whether the current browser supports the OLD CSS3 Flexible Box Layout directly or via vendor prefixes
	 * @type {boolean}
	 * @public
	 * @name jQuery.support.flexBoxLayout
	 */
	preserveOrTestCssPropWithPrefixes("flexBoxLayout", "boxFlex");

	/**
	 * Whether the current browser supports the IE10 CSS3 Flexible Box Layout directly or via vendor prefixes
	 * @type {boolean}
	 * @public
	 * @name jQuery.support.ie10FlexBoxLayout
	 * @since 1.12.0
	 */
	// Just using one of the IE10 properties that's not in the new FlexBox spec
	if (oStyle.msFlexOrder !== undefined) {
		jQuery.support.ie10FlexBoxLayout = true;
	}
	
	/**
	 * Whether the current browser supports the NEW CSS3 Flexible Box Layout directly or via vendor prefixes
	 * @type {boolean}
	 * @public
	 * @name jQuery.support.newFlexBoxLayout
	 */
	preserveOrTestCssPropWithPrefixes("newFlexBoxLayout", "flexGrow");	// Use a new property that IE10 doesn't support
	
	/**
	 * Whether the current browser supports any kind of Flexible Box Layout directly or via vendor prefixes
	 * @type {boolean}
	 * @public
	 * @name jQuery.support.hasFlexBoxSupport
	 */
	if(jQuery.support.flexBoxLayout || jQuery.support.newFlexBoxLayout || jQuery.support.ie10FlexBoxLayout) {
		jQuery.support.hasFlexBoxSupport = true;
	} else {
		jQuery.support.hasFlexBoxSupport = false;
	}

	// *********** fixes for (pending) jQuery bugs **********
	if (!jQuery.support.opacity) {
		(function() {
			// jQuery cssHook for setOpacity[IE8] doesn't properly cleanup the CSS filter property
			var oldSet = jQuery.cssHooks.opacity.set;
			jQuery.cssHooks.opacity.set = function( elem, value ) {
				oldSet.apply(this, arguments);
				if ( !jQuery.trim(elem.style.filter) ) {
					elem.style.removeAttribute("filter");
				}
			};
		}());
	}

	// *** Performance measure ***
	function PerfMeasurement(){

		function Measurement( sId, sInfo, iStart, iEnd ){
			this.id = sId;
			this.info = sInfo;
			this.start = iStart;
			this.end = iEnd;
			this.pause = 0;
			this.resume = 0;
			this.duration = 0; // used time
			this.time = 0; // time from start to end
		}

		var bActive = false;
		var fnAjax = jQuery.ajax;

		/**
		 * Gets the current state of the perfomance measurement functionality
		 *
		 * @return {boolean} current state of the perfomance measurement functionality
		 * @name jQuery.sap.measure#getActive
		 * @function
		 * @public
		 */
		this.getActive = function(){
			return bActive;
		};

		/**
		 * Activates or deactivates the performance measure functionality
		 *
		 * @param {boolean} bOn state of the perfomance measurement functionality to set
		 * @return {boolean} current state of the perfomance measurement functionality
		 * @name jQuery.sap.measure#setActive
		 * @function
		 * @public
		 */
		this.setActive = function( bOn ){

			if (bActive == bOn) {
				return bActive;
			}

			bActive = bOn;

			if (bActive){
				// redefine AJAX call
				jQuery.ajax = function( url, options ){
					jQuery.sap.measure.start(url.url, "Request for "+ url.url);
					fnAjax.apply(this,arguments);
					jQuery.sap.measure.end(url.url);
				};
			}else if(fnAjax){
				jQuery.ajax = fnAjax;
			}

			return bActive;

		};

		this.setActive(/sap-ui-measure=(true|x|X)/.test(location.search));

		this.mMeasurements = {};

		/**
		 * Starts a performance measure
		 *
		 * @param {string} sId ID of the measurement
		 * @param {string} sInfo Info for the measurement
		 * @return {object} current measurement containing id, info and start-timestamp (false if error)
		 * @name jQuery.sap.measure#start
		 * @function
		 * @public
		 */
		this.start = function( sId, sInfo ){
			if (!bActive) {
				return;
			}

			var iTime = new Date().getTime();
			var oMeasurement = new Measurement( sId, sInfo, iTime, 0);
//			jQuery.sap.log.info("Performance measurement start: "+ sId + " on "+ iTime);

			if (oMeasurement) {
				this.mMeasurements[sId] = oMeasurement;
				return({id: oMeasurement.id, info: oMeasurement.info, start: oMeasurement.start });
			}else{
				return false;
			}
		};

		/**
		 * Pauses a performance measure
		 *
		 * @param {string} sId ID of the measurement
		 * @return {object} current measurement containing id, info and start-timestamp, pause-timestamp (false if error)
		 * @name jQuery.sap.measure#pause
		 * @function
		 * @public
		 */
		this.pause = function( sId ){
			if (!bActive) {
				return;
			}

			var iTime = new Date().getTime();
			var oMeasurement = this.mMeasurements[sId];
			if(oMeasurement && oMeasurement.end > 0){
				// already ended -> no pause possible
				return false;
			}

			if (oMeasurement && oMeasurement.pause == 0) {
				// not already paused
				oMeasurement.pause = iTime;
				if (oMeasurement.pause >= oMeasurement.resume && oMeasurement.resume > 0) {
					oMeasurement.duration = oMeasurement.duration + oMeasurement.pause - oMeasurement.resume;
					oMeasurement.resume = 0;
				}else if (oMeasurement.pause >= oMeasurement.start) {
					oMeasurement.duration = oMeasurement.pause - oMeasurement.start;
				}
			}
//			jQuery.sap.log.info("Performance measurement pause: "+ sId + " on "+ iTime + " duration: "+ oMeasurement.duration);

			if (oMeasurement) {
				return({id: oMeasurement.id, info: oMeasurement.info, start: oMeasurement.start, pause: oMeasurement.pause });
			}else{
				return false;
			}
		};

		/**
		 * Resumes a performance measure
		 *
		 * @param {string} sId ID of the measurement
		 * @return {object} current measurement containing id, info and start-timestamp, resume-timestamp (false if error)
		 * @name jQuery.sap.measure#resume
		 * @function
		 * @public
		 */
		this.resume = function( sId ){
			if (!bActive) {
				return;
			}

			var iTime = new Date().getTime();
			var oMeasurement = this.mMeasurements[sId];
//			jQuery.sap.log.info("Performance measurement resume: "+ sId + " on "+ iTime + " duration: "+ oMeasurement.duration);

			if (oMeasurement && oMeasurement.pause > 0) {
				// already paused
				oMeasurement.pause = 0;
				oMeasurement.resume = iTime;
			}

			if (oMeasurement) {
				return({id: oMeasurement.id, info: oMeasurement.info, start: oMeasurement.start, resume: oMeasurement.resume });
			}else{
				return false;
			}
		};

		/**
		 * Ends a performance measure
		 *
		 * @param {string} sId ID of the measurement
		 * @return {object} current measurement containing id, info and start-timestamp, end-timestamp, time, duration (false if error)
		 * @name jQuery.sap.measure#end
		 * @function
		 * @public
		 */
		this.end = function( sId ){
			if (!bActive) {
				return;
			}

			var iTime = new Date().getTime();
			var oMeasurement = this.mMeasurements[sId];
//			jQuery.sap.log.info("Performance measurement end: "+ sId + " on "+ iTime);

			if (oMeasurement && !oMeasurement.end) {
				oMeasurement.end = iTime;
				if (oMeasurement.end >= oMeasurement.resume && oMeasurement.resume > 0) {
					oMeasurement.duration = oMeasurement.duration + oMeasurement.end - oMeasurement.resume;
					oMeasurement.resume = 0;
				}else if (oMeasurement.pause > 0) {
					// duration already calculated
					oMeasurement.pause = 0;
				}else if (oMeasurement.end >= oMeasurement.start) {
					oMeasurement.duration = oMeasurement.end - oMeasurement.start;
				}
				if (oMeasurement.end >= oMeasurement.start) {
					oMeasurement.time = oMeasurement.end - oMeasurement.start;
				}
			}

			if (oMeasurement) {
				return({id: oMeasurement.id,
					    info: oMeasurement.info,
					    start: oMeasurement.start,
					    end: oMeasurement.end,
					    time: oMeasurement.time,
					    duration: oMeasurement.duration});
			}else{
				return false;
			}
		};

		/**
		 * Gets a performance measure
		 *
		 * @param {string} sId ID of the measurement
		 * @return {object} current measurement containing id, info and start-timestamp, end-timestamp, time, duration (false if error)
		 * @name jQuery.sap.measure#getMeasurement
		 * @function
		 * @public
		 */
		this.getMeasurement = function( sId ){
			if (!bActive) {
				return;
			}

			var oMeasurement = this.mMeasurements[sId];

			if (oMeasurement) {
				return({id: oMeasurement.id,
						info: oMeasurement.info,
						start: oMeasurement.start,
						end: oMeasurement.end,
						time: oMeasurement.time,
						duration: oMeasurement.duration});
			}else{
				return false;
			}
		};

		/**
		 * Clears all performance measurements
		 *
		 * @return
		 * @name jQuery.sap.measure#clear
		 * @function
		 * @public
		 */
		this.clear = function( ){
			if (!bActive) {
				return;
			}

			this.mMeasurements = {};
			return;
		};

		/**
		 * Removes a performance measure
		 *
		 * @param {string} sId ID of the measurement
		 * @return
		 * @name jQuery.sap.measure#remove
		 * @function
		 * @public
		 */
		this.remove = function( sId ){
			if (!bActive) {
				return;
			}

			delete this.mMeasurements[sId];
			return;
		};

		/**
		 * Gets all performance measurements
		 *
		 * @return {object} [] current measurement containing id, info and start-timestamp, end-timestamp, time, duration (false if error)
		 * @name jQuery.sap.measure#getAllMeasurements
		 * @function
		 * @public
		 */
		this.getAllMeasurements = function( ){
			if (!bActive) {
				return;
			}

			var aMeasurements = new Array();

			jQuery.each(this.mMeasurements, function(sId, oMeasurement){
				aMeasurements.push({id: oMeasurement.id,
					                info: oMeasurement.info,
					                start: oMeasurement.start,
					                end: oMeasurement.end,
					                duration: oMeasurement.duration,
					                time: oMeasurement.time});
			});
			return aMeasurements;
		};

		/**
		 * Adds a performance measurement with all data 
		 * This is usefull to add external measurements (e.g. from a backend) to the common measurement UI
		 *
		 * @param {string} sId ID of the measurement
		 * @param {string} sInfo Info for the measurement
		 * @param {int} iStart start timestamp
		 * @param {int} iEnd end timestamp
		 * @param {int} iTime time in milliseconds
		 * @param {int} iDuration effective time in milliseconds
		 * @return {object} [] current measurement containing id, info and start-timestamp, end-timestamp, time, duration (false if error)
		 * @name jQuery.sap.measure#add
		 * @function
		 * @public
		 */
		this.add = function( sId, sInfo, iStart, iEnd, iTime, iDuration ){
			if (!bActive) {
				return;
			}

			var oMeasurement = new Measurement( sId, sInfo, iStart, iEnd);
			oMeasurement.time = iTime;
			oMeasurement.duration = iDuration;

			if (oMeasurement) {
				this.mMeasurements[sId] = oMeasurement;
				return({id: oMeasurement.id,
					    info: oMeasurement.info,
					    start: oMeasurement.start,
					    end: oMeasurement.end,
					    time: oMeasurement.time,
					    duration: oMeasurement.duration});
			}else{
				return false;
			}
		};
	}

	/**
	 * Namespace for the jQuery performance measurement plug-in provided by SAP AG.
	 *
	 * @namespace
	 * @name jQuery.sap.measure
	 * @public
	 * @static
	 */
	jQuery.sap.measure = new PerfMeasurement();

}());

/**
 * Executes an 'eval' for its arguments in the global context (without closure variables).
 *
 * This is a synchronous replacement for <code>jQuery.globalEval</code> which in some
 * browsers (e.g. FireFox) behaves asynchronously.
 *
 * @type void
 * @public
 * @static
 * @SecSink {0|XSS} Parameter is evaluated
 */
jQuery.sap.globalEval = function() {
	eval(arguments[0]);
};

jQuery.sap.declare('sap-ui-core-nojQuery');
jQuery.sap.declare('sap.ui.Device'); // raw module, declared by SAPUI5 CreateModule Ant-Task
jQuery.sap.declare('sap.ui.thirdparty.URI'); // raw module, declared by SAPUI5 CreateModule Ant-Task
jQuery.sap.declare('jquery.sap.global'); // raw module, declared by SAPUI5 CreateModule Ant-Task
if ( !jQuery.sap.isDeclared('sap.ui.core.Core') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides the real core class sap.ui.core.Core of SAPUI5
jQuery.sap.declare('sap.ui.core.Core'); // unresolved dependency added by SAPUI5 CreateModule Ant-Task
if ( !jQuery.sap.isDeclared('sap.ui.Global') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/**
 * @overview Initialization for the SAP UI Library
 *
 * This module creates the main SAP namespaces {@link sap} and automatically
 * registers it to the OpenAjax hub if that exists.
 *
 * This class provides method {@link #namespace} to register namespaces to the
 * SAP UI Library.
 *
 * @sample
 * Ensures a control can be used afterwards but does not load immediately
 * sap.ui.lazyRequire("sap.ui.core.Control");
 * sap.ui.lazyRequire("sap.ui.commons.Button");
 *
 * @version 1.20.6
 * @author  Martin Schaus, Daniel Brinkmann
 * @public
 */

/*global OpenAjax */// declare unusual global vars for JSLint/SAPUI5 validation

// Register to the OpenAjax Hub if it exists
if (window.OpenAjax && window.OpenAjax.hub) {
	OpenAjax.hub.registerLibrary("sap", "http://www.sap.com/", "0.1", {});
}

jQuery.sap.declare('sap.ui.Global'); // unresolved dependency added by SAPUI5 CreateModule Ant-Task
if ( !jQuery.sap.isDeclared('jquery.sap.dom') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides functionality related to DOM analysis and manipulation which is not provided by jQuery itself.
jQuery.sap.declare('jquery.sap.dom'); // unresolved dependency added by SAPUI5 CreateModule Ant-Task
sap.ui.define("jquery.sap.dom",['jquery.sap.global', 'sap/ui/Device'],
	function(jQuery, Device) {
	"use strict";

	/**
	 * Shortcut for document.getElementById() with additionally an IE6/7 bug fixed.
	 * Used to replace the jQuery.sap.domById when running in IE < v8.
	 *
	 * @param {string} sId the id of the DOM element to return
	 * @param {Window} oWindow the window (optional)
	 * @return {Element} the DOMNode identified by the given sId
	 * @private
	 */
	var domByIdInternal = function(sId, oWindow) {

		if (!oWindow) {
			oWindow = window;
		}
		if (!sId || sId=="") {
			return null;
		}

		var oDomRef = oWindow.document.getElementById(sId);

		// IE also returns the element with the name or id whatever is first
		// => the following line makes sure that this was the id
		if (oDomRef && oDomRef.id == sId) {
			return oDomRef;
		}

		// otherwise try to lookup the name
		var oRefs = oWindow.document.getElementsByName(sId);
		for (var i=0;i<oRefs.length;i++) {
			oDomRef = oRefs[i];
			if (oDomRef && oDomRef.id == sId) {
				return oDomRef;
			}
		}

		return null;

	};

	/**
	 * Shortcut for document.getElementById(), including a bug fix for older IE versions.
	 *
	 * @param {string} sId The id of the DOM element to return
	 * @param {Window} [oWindow=window] The window (optional)
	 * @return {Element} The DOMNode identified by the given sId
	 * @public
	 * @function
	 * @since 0.9.0
	 */
	jQuery.sap.domById = !!Device.browser.internet_explorer && Device.browser.version < 8 ? domByIdInternal : function domById(sId, oWindow) {
		return sId ? (oWindow || window).document.getElementById(sId) : null;
	};


	/**
	 * Shortcut for jQuery("#" + id) with additionally the id being escaped properly.
	 * I.e.: returns the jQuery object for the DOM element with the given id
	 *
	 * Use this method instead of jQuery(...) if you know the argument is exactly one id and
	 * the id is not known in advance because it is in a variable (as opposed to a string
	 * constant with known content).
	 *
	 * @param {string} sId The id to search for and construct the jQuery object
	 * @param {Element} oContext the context DOM Element
	 * @return {Object} The jQuery object for the DOM element identified by the given sId
	 * @public
	 * @since 0.9.1
	 */
	jQuery.sap.byId = function byId(sId, oContext) {
		var escapedId = "";
		if (sId) {
			escapedId = "#" + sId.replace(/(:|\.)/g,'\\$1');
		}
		return jQuery(escapedId, oContext);
	};


	/**
	 * Calls focus() on the given DOM element, but catches and ignores any errors that occur when doing so.
	 * (i.e. IE8 throws an error when the DOM element is invisible or disabled)
	 *
	 * @param {Element} oDomRef The DOM element to focus (or null - in this case the method does nothing)
	 * @return {boolean} Whether the focus() command was executed without an error
	 * @public
	 * @since 1.1.2
	 */
	jQuery.sap.focus = function focus(oDomRef) {
		if (!oDomRef) {
			return;
		}
		try {
			oDomRef.focus();
		} catch (e) {
			var id = (oDomRef && oDomRef.id) ? " (ID: '" + oDomRef.id + "')" : "";
			jQuery.sap.log.warning("Error when trying to focus a DOM element" + id + ": " + e.message);
			return false;
		}
		return true;
	};


	/**
	 * Sets or gets the position of the cursor in an element that supports cursor positioning
	 *
	 * @param {int} iPos The cursor position to set (or no parameter to retrieve the cursor position)
	 * @return {int | jQuery} The cursor position (or the jQuery collection if the position has been set)
	 * @public
	 * @methodOf jQuery.prototype
	 * @name cursorPos
	 * @author SAP AG
	 * @since 0.9.0
	 * @function
	 */
	jQuery.fn.cursorPos = function cursorPos(iPos) {
		var len = arguments.length,
			oTextRange,iLength,
			sTagName,
			sType;

		sTagName = this.prop("tagName");
		sType = this.prop("type");

		if( this.length === 1 && ((sTagName == "INPUT" && (sType == "text" || sType == "password" || sType == "search"))
				|| sTagName == "TEXTAREA" )) {

			var oDomRef = this.get(0);

			if (len > 0) { // SET

				if (typeof(oDomRef.selectionStart) == "number") { // FF and IE9+ method
					oDomRef.focus();
					oDomRef.selectionStart = iPos;
					oDomRef.selectionEnd = iPos;
				} else if (oDomRef.createTextRange) { // IE method
					oTextRange = oDomRef.createTextRange();
					var iMaxLength = oDomRef.value.length;

					if(iPos < 0 || iPos > iMaxLength) {
						iPos = iMaxLength;
					}
					if(oTextRange) {
						oTextRange.collapse();
						oTextRange.moveEnd("character",iPos);
						oTextRange.moveStart("character",iPos);
						oTextRange.select();
					}
				}

				return this;
				// end of SET

			} else { // GET
				if (typeof(oDomRef.selectionStart) == "number") { // Firefox etc.
					return oDomRef.selectionStart;
				} else if (oDomRef.createTextRange) { // IE 8
					oTextRange = window.document.selection.createRange();
					var oCopiedTextRange = oTextRange.duplicate();
					// Logic in TEXTAREA and INPUT is different in IE -> check for element type
					if(oDomRef.tagName == "TEXTAREA"){
						oCopiedTextRange.moveToElementText(oDomRef);
						var oCheckTextRange = oCopiedTextRange.duplicate();
						iLength = oCopiedTextRange.text.length;

						// first check if cursor on last position
						oCheckTextRange.moveStart("character", iLength);
						if(oCheckTextRange.inRange(oTextRange)){
							iStart = iLength;
						}else{
							// find out cursor position using a bisection algorithm
							var iCheckLength = iLength;
							var iStart = 0;
							while(iLength > 1){
								iCheckLength = Math.round(iLength / 2);
								iStart = iStart + iCheckLength;

								oCheckTextRange = oCopiedTextRange.duplicate();
								oCheckTextRange.moveStart("character", iStart);
								if(oCheckTextRange.inRange(oTextRange)){
									//cursor is after or on iStart -> Length = not checked Length
									iLength = iLength - iCheckLength;

								}else{
									//cursor is before iStart  -> Length = checked Length
									iStart = iStart - iCheckLength;
									iLength = iCheckLength;
								}
							}
						}
						return iStart;
					} else if (oCopiedTextRange.parentElement() === oDomRef) {
						// ensure there is only the cursor and not the range (as this would create erroneous position)!
						oCopiedTextRange.collapse();
						// now, move the selection range to the beginning of the inputField and simply get the selected range's length
						var iLength = oDomRef.value.length;
						oCopiedTextRange.moveStart('character', -iLength);
						return oCopiedTextRange.text.length;
					}
				}

				return -1;
			} // end of GET
		} else {
			// shouldn't really happen, but to be safe...
			return this;
		}
	};

	/**
	 * Sets the text selection in the first element of the collection
	 *
	 * @param {int} iStart Start position of the selection (inclusive)
	 * @param {int} iEnd End position of the selection (exclusive)
	 * @return {jQuery} The jQuery collection
	 * @public
	 * @methodOf jQuery.prototype
	 * @name selectText
	 * @author SAP AG
	 * @since 0.9.0
	 * @function
	 */
	jQuery.fn.selectText = function selectText(iStart, iEnd) {
		var oDomRef = this.get(0);

		if (oDomRef) {
			if (typeof(oDomRef.selectionStart) == "number") { // Firefox and IE9+
				// sanity checks
				if (iStart < 0) {
					iStart = 0;
				}
				if (iEnd > oDomRef.value.length) {
					iEnd = oDomRef.value.length;
				}
				if (!iEnd || iStart > iEnd) {
					iStart = 0;
					iEnd = 0;
				}
				oDomRef.selectionStart = iStart; // TODO: maybe need to decouple via setTimeout?
				oDomRef.selectionEnd = iEnd;
			} else if(oDomRef.createTextRange) { // IE
				var oTextEditRange = oDomRef.createTextRange();
				oTextEditRange.collapse();
				oTextEditRange.moveStart('character', iStart);
				oTextEditRange.moveEnd('character', iEnd - iStart);
				oTextEditRange.select();
			}
		}

		return this;
	};


	/**
	 * Returns the outer HTML of the given HTML element
	 *
	 * @return {string} outer HTML
	 * @public
	 * @methodOf jQuery.prototype
	 * @name outerHTML
	 * @author SAP AG
	 * @since 0.9.0
	 * @function
	 */
	jQuery.fn.outerHTML = function outerHTML() {
		var oDomRef = this.get(0);

		if (oDomRef && oDomRef.outerHTML) {
			return jQuery.trim(oDomRef.outerHTML);
		} else {
			var doc = this[0] ? this[0].ownerDocument : document;

			var oDummy = doc.createElement("div");
			oDummy.appendChild(oDomRef.cloneNode(true));
			return oDummy.innerHTML;
		}
	};


	/**
	 * Returns whether oDomRefChild is oDomRefContainer or is contained in oDomRefContainer.
	 *
	 * This is a browser-independent version of the .contains method of Internet Explorer.
	 * For compatibility reasons it returns true if oDomRefContainer and oDomRefChild are equal.
	 *
	 * This method intentionally does not operate on the jQuery object, as the original jQuery.contains()
	 * method also does not do so.
	 *
	 * @param {Element} oDomRefContainer The container element
	 * @param {Element} oDomRefChild The child element (must not be a text node, must be an element)
	 * @return {boolean} 'true' if oDomRefChild is contained in oDomRefContainer or oDomRefChild is oDomRefContainer
	 * @public
	 * @author SAP AG
	 * @since 0.9.0
	 */
	jQuery.sap.containsOrEquals = function containsOrEquals(oDomRefContainer, oDomRefChild) {
		if (oDomRefChild && oDomRefContainer && oDomRefChild != document && oDomRefChild != window) {
			return (oDomRefContainer === oDomRefChild) || jQuery.contains(oDomRefContainer, oDomRefChild);
		}
		return false;
	};


	/**
	 * Returns a rectangle describing the current visual positioning of the first DOM object in the collection
	 * (or null if no element was given)
	 *
	 * @return {object} An object with left, top, width and height
	 * @public
	 * @methodOf jQuery.prototype
	 * @name rect
	 * @author SAP AG
	 * @since 0.9.0
	 * @function
	 */
	jQuery.fn.rect = function rect() {
		var oDomRef = this.get(0);

		if (oDomRef) {
			// this should be available in all 'modern browsers'
			if (oDomRef.getBoundingClientRect) {
				var oClientRect = oDomRef.getBoundingClientRect();
				var oRect = { top : oClientRect.top,
						left : oClientRect.left,
						width : oClientRect.right - oClientRect.left,
						height : oClientRect.bottom - oClientRect.top };

				var oWnd = jQuery.sap.ownerWindow(oDomRef);
				oRect.left += jQuery(oWnd).scrollLeft();
				oRect.top += jQuery(oWnd).scrollTop();

				return oRect;
			} else {
				// IE6 and older; avoid crashing and give some hardcoded size
				return { top : 10, left : 10, width : oDomRef.offsetWidth, height : oDomRef.offsetWidth };
			}
		}
		return null;
	};


	/**
	 * Returns whether a point described by X and Y is inside this Rectangle's boundaries
	 *
	 * @param {int} iPosX
	 * @param {int} iPosY
	 * @return Whether X and Y are inside this Rectangle's boundaries
	 * @public
	 * @methodOf jQuery.prototype
	 * @name rectContains
	 * @author SAP AG
	 * @since 0.18.0
	 * @function
	 */
	jQuery.fn.rectContains = function rectContains(iPosX, iPosY) {
		jQuery.sap.assert(!isNaN(iPosX), "iPosX must be a number");
		jQuery.sap.assert(!isNaN(iPosY), "iPosY must be a number");

		var oRect = this.rect();

		if (oRect) {

			return iPosX >= oRect.left
				&& iPosX <= oRect.left + oRect.width
				&& iPosY >= oRect.top
				&& iPosY <= oRect.top + oRect.height;

		}
		return false;
	};


	/**
	 * Returns true if the first element has a set tabindex
	 *
	 * @return {boolean} If the first element has a set tabindex
	 * @public
	 * @methodOf jQuery.prototype
	 * @name hasTabIndex
	 * @author SAP AG
	 * @since 0.9.0
	 * @function
	 */
	jQuery.fn.hasTabIndex = function hasTabIndex() {
		var iTabIndex = this.prop("tabIndex");
		return !isNaN(iTabIndex) && iTabIndex >= 0;
	};


	/**
	 * Returns the first focusable domRef in a given container (the first element of the collection)
	 *
	 * @return {Element} The domRef
	 * @public
	 * @methodOf jQuery.prototype
	 * @name firstFocusableDomRef
	 * @author SAP AG
	 * @since 0.9.0
	 * @function
	 */
	jQuery.fn.firstFocusableDomRef = function firstFocusableDomRef() {
		var oContainerDomRef = this.get(0);
		var visibilityHiddenFilter = function (idx){return jQuery(this).css("visibility") == "hidden";};
		if (!oContainerDomRef || jQuery(oContainerDomRef).is(':hidden') ||
				jQuery(oContainerDomRef).filter(visibilityHiddenFilter).length == 1) {
			return null;
		}

		var oCurrDomRef = oContainerDomRef.firstChild,
			oDomRefFound = null;

		while (oCurrDomRef) {
			if(oCurrDomRef.nodeType == 1 && jQuery(oCurrDomRef).is(':visible')) {
				if (jQuery(oCurrDomRef).hasTabIndex()) {
					return oCurrDomRef;
				}

				if(oCurrDomRef.childNodes) {
					oDomRefFound = jQuery(oCurrDomRef).firstFocusableDomRef();
					if(oDomRefFound) {
						return oDomRefFound;
					}
				}
			}
			oCurrDomRef = oCurrDomRef.nextSibling;
		}

		return null;
	};


	/**
	 * Returns the last focusable domRef in a given container
	 *
	 * @return {Element} The last domRef
	 * @public
	 * @methodOf jQuery.prototype
	 * @name lastFocusableDomRef
	 * @author SAP AG
	 * @since 0.9.0
	 * @function
	 */
	jQuery.fn.lastFocusableDomRef = function lastFocusableDomRef() {
		var oContainerDomRef = this.get(0);
		var visibilityHiddenFilter = function (idx){return jQuery(this).css("visibility") == "hidden";};
		if (!oContainerDomRef || jQuery(oContainerDomRef).is(':hidden') ||
				jQuery(oContainerDomRef).filter(visibilityHiddenFilter).length == 1) {
			return null;
		}

		var oCurrDomRef = oContainerDomRef.lastChild,
			oDomRefFound = null;

		while (oCurrDomRef) {
			if(oCurrDomRef.nodeType == 1 && jQuery(oCurrDomRef).is(':visible')) {
				if(oCurrDomRef.childNodes) {
					oDomRefFound = jQuery(oCurrDomRef).lastFocusableDomRef();
					if(oDomRefFound) {
						return oDomRefFound;
					}
				}

				if (jQuery(oCurrDomRef).hasTabIndex()) {
					return oCurrDomRef;
				}
			}
			oCurrDomRef = oCurrDomRef.previousSibling;
		}

		return null;
	};


	/**
	 * Sets or returns the scrollLeft value of the first element in the given jQuery collection in right-to-left mode.
	 * Precondition: The element is rendered in RTL mode.
	 *
	 * Reason for this method is that the major browsers use three different values for the same scroll position when in RTL mode.
	 * This method hides those differences and returns/applies the same value that would be returned in LTR mode: The distance in px
	 * how far the given container is scrolled away from the leftmost scroll position.
	 *
	 * Returns "undefined" if no element and no iPos is given.
	 *
	 * @return {jQuery | int} The jQuery collection if iPos is given, otherwise the scroll position, counted from the leftmost position
	 * @public
	 * @methodOf jQuery.prototype
	 * @name scrollLeftRTL
	 * @author SAP AG
	 * @since 0.20.0
	 * @function
	 */
	jQuery.fn.scrollLeftRTL = function scrollLeftRTL(iPos) {
		var oDomRef = this.get(0);
		if (oDomRef) {

			if (iPos === undefined) { // GETTER code
				if (!!Device.browser.internet_explorer) {
					return oDomRef.scrollWidth - oDomRef.scrollLeft - oDomRef.clientWidth;

				} else if (!!Device.browser.webkit) {
					return oDomRef.scrollLeft;

				} else if (!!Device.browser.firefox) {
					return oDomRef.scrollWidth + oDomRef.scrollLeft - oDomRef.clientWidth;

				} else {
					// unrecognized browser; it is hard to return a best guess, as browser strategies are very different, so return the actual value
					return oDomRef.scrollLeft;
				}

			} else { // SETTER code
				oDomRef.scrollLeft = jQuery.sap.denormalizeScrollLeftRTL(iPos, oDomRef);
				return this;
			}
		}
	};

	/**
	 * Returns the MIRRORED scrollLeft value of the first element in the given jQuery collection in right-to-left mode.
	 * Precondition: The element is rendered in RTL mode.
	 *
	 * Reason for this method is that the major browsers return three different values for the same scroll position when in RTL mode.
	 * This method hides those differences and returns the value that would be returned in LTR mode if the UI would be mirrored horizontally:
	 * The distance in px how far the given container is scrolled away from the rightmost scroll position.
	 *
	 * Returns "undefined" if no element is given.
	 *
	 * @return {int} The scroll position, counted from the rightmost position
	 * @public
	 * @methodOf jQuery.prototype
	 * @name scrollRightRTL
	 * @author SAP AG
	 * @since 0.20.0
	 * @function
	 */
	jQuery.fn.scrollRightRTL = function scrollRightRTL() {
		var oDomRef = this.get(0);
		if (oDomRef) {

			if (!!Device.browser.internet_explorer) {
				return oDomRef.scrollLeft;

			} else if (!!Device.browser.webkit) {
				return oDomRef.scrollWidth - oDomRef.scrollLeft - oDomRef.clientWidth;

			} else if (!!Device.browser.firefox) {
				return (-oDomRef.scrollLeft);

			} else {
				// unrecognized browser; it is hard to return a best guess, as browser strategies are very different, so return the actual value
				return oDomRef.scrollLeft;
			}
		}
	};


	/**
	 * For the given scrollLeft value this method returns the scrollLeft value as understood by the current browser in RTL mode.
	 * This value is specific to the given DOM element, as the computation may involve its dimensions.
	 *
	 * So when oDomRef should be scrolled 2px from the leftmost position, the number "2" must be given as iNormalizedScrollLeft
	 * and the result of this method (which may be a large or even negative number, depending on the browser) can then be set as
	 * oDomRef.scrollLeft to achieve the desired (cross-browser-consistent) scrolling position.
	 *
	 * This method does no scrolling on its own, it only calculates the value to set (so it can also be used for animations).
	 *
	 * @param {int} iNormalizedScrollLeft The distance from the leftmost position to which the element should be scrolled
	 * @param {Element} oDomRef The DOM Element to which scrollLeft will be applied
	 * @return {int} The scroll position that must be set for the DOM element
	 * @public
	 * @author SAP AG
	 * @since 0.20.0
	 */
	jQuery.sap.denormalizeScrollLeftRTL = function(iNormalizedScrollLeft, oDomRef) {

		if (oDomRef) {
			if (!!Device.browser.internet_explorer) {
				return oDomRef.scrollWidth - oDomRef.clientWidth - iNormalizedScrollLeft;

			} else if (!!Device.browser.webkit) {
				return iNormalizedScrollLeft;

			} else if (!!Device.browser.firefox) {
				return oDomRef.clientWidth + iNormalizedScrollLeft - oDomRef.scrollWidth;

			} else {
				// unrecognized browser; it is hard to return a best guess, as browser strategies are very different, so return the actual value
				return iNormalizedScrollLeft;
			}
		}
	};




	/*!
	 * The following functions are taken from jQuery UI 1.8.17 but modified
	 *
	 * Copyright 2011, AUTHORS.txt (http://jqueryui.com/about)
	 * Dual licensed under the MIT or GPL Version 2 licenses.
	 * http://jquery.org/license
	 *
	 * http://docs.jquery.com/UI
	 */
	function visible( element ) {
		// check if one of the parents (until it's position parent) is invisible
		// prevent that elements in static area are always checked as invisible
		
		// list all items until the offsetParent item (with jQuery >1.6 you can use parentsUntil)
		var oOffsetParent = jQuery(element).offsetParent();
		var bOffsetParentFound = false;
		var $refs = jQuery(element).parents().filter(function() {
			if (this === oOffsetParent) {
				bOffsetParentFound = true;
			}
			return bOffsetParentFound;
		});
		
		// check for at least one item to be visible
		return !jQuery(element).add($refs).filter(function() {
			return jQuery.css( this, "visibility" ) === "hidden" || jQuery.expr.filters.hidden( this );
		}).length;
	}

	function focusable( element, isTabIndexNotNaN ) {
		var nodeName = element.nodeName.toLowerCase();
		if ( "area" === nodeName ) {
			var map = element.parentNode,
				mapName = map.name,
				img;
			if ( !element.href || !mapName || map.nodeName.toLowerCase() !== "map" ) {
				return false;
			}
			img = jQuery( "img[usemap=#" + mapName + "]" )[0];
			return !!img && visible( img );
		}
		return ( /input|select|textarea|button|object/.test( nodeName )
			? !element.disabled
			: "a" == nodeName
				? element.href || isTabIndexNotNaN
				: isTabIndexNotNaN)
			// the element and all of its ancestors must be visible
			&& visible( element );
	}


	if (!jQuery.expr[":"].focusable) {
		/*!
		 * The following function is taken from jQuery UI 1.8.17
		 *
		 * Copyright 2011, AUTHORS.txt (http://jqueryui.com/about)
		 * Dual licensed under the MIT or GPL Version 2 licenses.
		 * http://jquery.org/license
		 *
		 * http://docs.jquery.com/UI
		 *
		 * But since visible is modified, focusable is different too the jQuery UI version too.
		 */
		jQuery.extend( jQuery.expr[ ":" ], {
			/**
			 * This defines the jQuery ":focusable" selector; it is also defined in jQuery UI. If already present, nothing is
			 * done here, so we will not overwrite any previous implementation.
			 * If jQuery UI is loaded later on, this implementation here will be overwritten by that one, which is fine,
			 * as it is semantically the same thing and intended to do exactly the same.
			 */
			focusable: function( element ) {
				return focusable( element, !isNaN( jQuery.attr( element, "tabindex" ) ) );
			}
		});
	}

	if (!jQuery.expr[":"].sapTabbable) {
		/*!
		 * The following function is taken from
		 * jQuery UI Core 1.10.4
		 * http://jqueryui.com
		 *
		 * Copyright 2014 jQuery Foundation and other contributors
		 * Released under the MIT license.
		 * http://jquery.org/license
		 *
		 * http://api.jqueryui.com/category/ui-core/
		 */
		jQuery.extend( jQuery.expr[ ":" ], {
			/**
			 * This defines the jQuery ":tabbable" selector; it is also defined in jQuery UI. If already present, nothing is
			 * done here, so we will not overwrite any previous implementation.
			 * If jQuery UI is loaded later on, this implementation here will be overwritten by that one, which is fine,
			 * as it is semantically the same thing and intended to do exactly the same.
			 */
			sapTabbable: function( element ) {
				var tabIndex = jQuery.attr( element, "tabindex" ),
					isTabIndexNaN = isNaN( tabIndex );
				return ( isTabIndexNaN || tabIndex >= 0 ) && focusable( element, !isTabIndexNaN );
			}
		});
	}

	if (!jQuery.expr[":"].sapFocusable) {
		/*!
		 * Do not use jQuery UI focusable because this might be overwritten if jQuery UI is loaded
		 */
		jQuery.extend( jQuery.expr[ ":" ], {
			/**
			 * This defines the jQuery ":sapFocusable" selector; If already present, nothing is
			 * done here, so we will not overwrite any previous implementation.
			 * If jQuery UI is loaded later on, this implementation here will NOT be overwritten by.
			 */
			sapFocusable: function( element ) {
				return focusable( element, !isNaN( jQuery.attr( element, "tabindex" ) ) );
			}
		});
	}

	if (!jQuery.fn.zIndex) {
		/*!
		 * The following function is taken from
		 * jQuery UI Core 1.10.4
		 * http://jqueryui.com
		 *
		 * Copyright 2014 jQuery Foundation and other contributors
		 * Released under the MIT license.
		 * http://jquery.org/license
		 *
		 * http://api.jqueryui.com/category/ui-core/
		 */
		jQuery.fn.zIndex = function( zIndex ) {
			if ( zIndex !== undefined ) {
				return this.css( "zIndex", zIndex );
			}

			if ( this.length ) {
				var elem = jQuery( this[ 0 ] ), position, value;
				while ( elem.length && elem[ 0 ] !== document ) {
					// Ignore z-index if position is set to a value where z-index is ignored by the browser
					// This makes behavior of this function consistent across browsers
					// WebKit always returns auto if the element is positioned
					position = elem.css( "position" );
					if ( position === "absolute" || position === "relative" || position === "fixed" ) {
						// IE returns 0 when zIndex is not specified
						// other browsers return a string
						// we ignore the case of nested elements with an explicit value of 0
						// <div style="z-index: -10;"><div style="z-index: 0;"></div></div>
						value = parseInt( elem.css( "zIndex" ), 10 );
						if ( !isNaN( value ) && value !== 0 ) {
							return value;
						}
					}
					elem = elem.parent();
				}
			}

			return 0;
		};
	}

	/**
	 * Gets the next parent DOM element with a given attribute and attribute value starting above the first given element
	 *
	 * @param {string} sAttibute Name of the attribute
	 * @param {string} sValue Value of the attribute (optional)
	 * @return {Element} null or the DOM reference
	 * @public
	 * @methodOf jQuery.prototype
	 * @name parentByAttribute
	 * @author SAP AG
	 * @since 0.9.0
	 * @function
	 */
	jQuery.fn.parentByAttribute = function parentByAttribute(sAttribute, sValue) {
		if (this.length>0) {
			if (sValue) {
				return this.first().parents("["+sAttribute+"='"+sValue+"']").get(0);
			} else {
				return this.first().parents("["+sAttribute+"]").get(0);
			}
		}
	};


	/**
	 * Returns the window reference for a DomRef
	 *
	 * @param {Element} oDomRef The DOM reference
	 * @return {Window} Window reference
	 * @public
	 * @since 0.9.0
	 */
	jQuery.sap.ownerWindow = function ownerWindow(oDomRef){
		if (oDomRef.ownerDocument.parentWindow) {
			return oDomRef.ownerDocument.parentWindow;
		}
		return oDomRef.ownerDocument.defaultView;
	};
	
	
	var _oScrollbarSize = {};
	
	/**
	 * Returns the size (width of the vertical / height of the horizontal) native browser scrollbars.
	 * 
	 * This function must only be used when the DOM is ready.
	 *
	 * @param {string} [sClasses=null] the CSS class that should be added to the test element.
	 * @param {boolean} [bForce=false] force recalculation of size (e.g. when CSS was changed). When no classes are passed all calculated sizes are reset.
	 * @return {object} JSON object with properties <code>width</code> and <code>height</code> (the values are of type number and are pixels).
	 * @public
	 * @since 1.4.0
	 */
	jQuery.sap.scrollbarSize = function(sClasses, bForce) {
		if (typeof sClasses === "boolean") {
			bForce = sClasses;
			sClasses = null;
		}

		var sKey = sClasses || "#DEFAULT"; // # is an invalid character for CSS classes

		if (bForce) {
			if (sClasses) {
				delete _oScrollbarSize[sClasses];
			} else {
				_oScrollbarSize = {};
			}
		}
		
		if(_oScrollbarSize[sKey]) {
			return _oScrollbarSize[sKey];
		}

		if(!document.body){
			return {width: 0, height: 0};
		}
		
		var $Area = jQuery("<DIV/>")
			.css("visibility", "hidden")
			.css("height", "0")
			.css("width", "0")
			.css("overflow", "hidden");

		if (sClasses) {
			$Area.addClass(sClasses);
		}

		$Area.prependTo(document.body);
		
		var $Dummy = jQuery("<div style=\"visibility:visible;position:absolute;height:100px;width:100px;overflow:scroll;opacity:0;\"></div>");
		$Area.append($Dummy);

		var oDomRef = $Dummy.get(0);
		var iWidth = oDomRef.offsetWidth - oDomRef.scrollWidth;
		var iHeight = oDomRef.offsetHeight - oDomRef.scrollHeight;

		$Area.remove();
		
		_oScrollbarSize[sKey] = {width: iWidth, height: iHeight};

		return _oScrollbarSize[sKey];
	};

	return jQuery;

}, /* bExport= */ false);

}; // end of jquery.sap.dom.js
sap.ui.define("sap/ui/Global",['jquery.sap.global', 'jquery.sap.dom'],
	function(jQuery/* , jQuerySap */) {
	"use strict";

	/**
	 * Root namespace for JavaScript functionality provided by SAP AG.
	 *
	 * The <code>sap</code> namespace is automatically registered with the
	 * OpenAjax hub if it exists.
	 *
	 * @version 1.20.6
	 * @namespace
	 * @public
	 * @name sap
	 */
	if ( typeof window.sap !== "object" && typeof window.sap !== "function"  ) {
	  window.sap = {};
	}
	
	/**
	 * The <code>sap.ui</code> namespace is the central OpenAjax compliant entry
	 * point for UI related JavaScript functionality provided by SAP.
	 *
	 * @version 1.20.6
	 * @namespace
	 * @name sap.ui
	 * @public
	 */
	if ( typeof window.sap.ui !== "object") {
		window.sap.ui = {};
	}
	sap.ui = jQuery.extend(sap.ui, {
			/**
			 * The version of the SAP UI Library
			 * @type string
			 */
			version: "1.20.6",
			buildinfo : { lastchange : "${ldi.scm.revision}", buildtime : "201405261600" }
		});
	
	/**
	 * Ensures that a given a namespace or hierarchy of nested namespaces exists in the
	 * current <code>window</code>.
	 *
	 * @return {object} the innermost namespace of the hierarchy
	 * @public
	 * @static
	 * @deprecated Use jQuery.sap.declare or jQuery.sap.getObject(...,0) instead
	 */
	sap.ui.namespace = function(sNamespace){
	
		jQuery.sap.assert(false, "sap.ui.namespace is long time deprecated and shouldn't be used");
	
		return jQuery.sap.getObject(sNamespace, 0);
	};
	
	/**
	 * Creates a lazy loading stub for a given class <code>sClassName</code>.
	 *
	 * If the class has been loaded already, nothing is done. Otherwise a stub object
	 * or constructor and - optionally - a set of stub methods are created.
	 * All created stubs will load the corresponding module on execution
	 * and then delegate to their counterpart in the loaded module.
	 *
	 * When no methods are given or when the list of methods contains the special name
	 * "new" (which is an operator can't be used as method name in JavaScript), then a
	 * stub <b>constructor</b> for class <code>sClassName</code> is created.
	 * Otherwise, a plain object is created.
	 *
	 * <b>Note</b>: Accessing any stub as a plain object without executing it (no matter
	 * whether it is a function or an object) won't load the module and therefore most like
	 * won't work as expected. This is a fundamental restriction of the lazy loader approach.
	 * It could only be fixed with JavaScript 1.5 features that are not available in all
	 * UI5 target browsers (e.g. not in IE8).
	 *
	 * <b>Note</b>: As a side effect of this method, the namespace containing the given
	 * class is created <b>immediately</b>.
	 *
	 * @param {string} sClassName Fully qualified name (dot notation) of the class that should be prepared
	 * @param {string} [sMethods='new'] space separated list of additional (static) methods that should be created as stubs
	 * @param {string} [sModuleName] name of the module to load, defaults to the class name
	 * @public
	 * @static
	 */
	sap.ui.lazyRequire = function(sClassName, sMethods, sModuleName) {
	
		jQuery.sap.assert(typeof sClassName === "string" && sClassName, "lazyRequire: sClassName must be a non-empty string");
		jQuery.sap.assert(!sMethods || typeof sMethods === "string", "lazyRequire: sMethods must be empty or a string");
	
		var sFullClass = sClassName.replace(/\//gi,"\."),
			iLastDotPos = sFullClass.lastIndexOf("."),
			sPackage = sFullClass.substr(0, iLastDotPos),
			sClass = sFullClass.substr(iLastDotPos + 1),
			oPackage = jQuery.sap.getObject(sPackage, 0),
			oClass = oPackage[sClass],
			aMethods = (sMethods || "new").split(" "),
			iConstructor = jQuery.inArray("new", aMethods);
	
		sModuleName = sModuleName || sFullClass;
	
		if (!oClass) {
	
			if ( iConstructor >= 0 ) {
	
				// Create dummy constructor which loads the class on demand
				oClass = function() {
					jQuery.sap.log.debug("lazy stub for '" + sFullClass + "' (constructor) called.");
					jQuery.sap.require(sModuleName);
					var oRealClass = oPackage[sClass];
					jQuery.sap.assert(typeof oRealClass === "function", "lazyRequire: oRealClass must be a function after loading");
					if ( oRealClass._sapUiLazyLoader ) {
						throw new Error("lazyRequire: stub '" + sFullClass + "'has not been replaced by module '" + sModuleName + "'");
					}
	
					// create a new instance and invoke the constructor
					var oInstance = jQuery.sap.newObject(oRealClass.prototype);
					var oResult = oRealClass.apply(oInstance, arguments);
					if (oResult && (typeof oResult === "function" || typeof oResult === "object")) {
						oInstance = oResult;
					}
					return oInstance;
				};
				// mark the stub as lazy loader
				oClass._sapUiLazyLoader = true;
	
				aMethods.splice(iConstructor,1);
	
			} else {
	
				// Create dummy object
				oClass = {};
	
			}
	
			// remember the stub
			oPackage[sClass] = oClass;
	
		}
	
	
		// add stub methods to it
		jQuery.each(aMethods, function (i,sMethod) {
			// check whether method is already available
			if (!oClass[sMethod]) {
				oClass[sMethod] = function() {
					jQuery.sap.log.debug("lazy stub for '" + sFullClass + "." + sMethod + "' called.");
					jQuery.sap.require(sModuleName);
					var oRealClass = oPackage[sClass];
					jQuery.sap.assert(typeof oRealClass === "function" || typeof oRealClass === "object", "lazyRequire: oRealClass must be a function or object after loading");
					jQuery.sap.assert(typeof oRealClass[sMethod] === "function", "lazyRequire: method must be a function");
					if (oRealClass[sMethod]._sapUiLazyLoader ) {
						throw new Error("lazyRequire: stub '" + sFullClass + "." + sMethod + "' has not been replaced by loaded module '" + sModuleName + "'");
					}
					return oRealClass[sMethod].apply(oRealClass, arguments);
				};
				oClass[sMethod]._sapUiLazyLoader = true;
			}
		});
	
	};
	
	/**
	 * Returns the URL of a resource that belongs to the given library and has the given relative location within the library.
	 * This is mainly meant for static resources like images that are inside the library.
	 * It is NOT meant for access to JavaScript modules or anything for which a different URL has been registered with jQuery.sap.registerModulePath(). For
	 * these cases use jQuery.sap.getModulePath().
	 * It DOES work, however, when the given sResourcePath starts with "themes/" (= when it is a theme-dependent resource). Even when for this theme a different
	 * location outside the normal library location is configured.
	 *
	 * @param sLibraryName the name of a library, like "sap.ui.commons"
	 * @param sResourcePath the relative path of a resource inside this library, like "img/mypic.png" or "themes/my_theme/img/mypic.png"
	 * @returns {string} the URL of the requested resource
	 *
	 * @static
	 * @public
	 */
	sap.ui.resource = function(sLibraryName, sResourcePath) {
		jQuery.sap.assert(typeof sLibraryName === "string", "sLibraryName must be a string");
		jQuery.sap.assert(typeof sResourcePath === "string", "sResourcePath must be a string");
	
		// special handling for theme-dependent resources: move theme folder into module name
		var match = sResourcePath.match(/^themes\/([^\/]+)\//);
		if (match) {
			sLibraryName += ".themes." + match[1];
			sResourcePath = sResourcePath.substr(match[0].length);
		}
	
		return jQuery.sap.getModulePath(sLibraryName, '/') + sResourcePath;
	};
	
	/**
	 * Redirects access to resources that are part of the given namespace to a location
	 * relative to the assumed <b>application root folder</b>.
	 *
	 * Any UI5 managed resource (view, controller, control, JavaScript module, CSS file, etc.)
	 * whose resource name starts with <code>sNamespace</code>, will be loaded from an
	 * equally named subfolder of the <b>application root folder</b>.
	 * If the resource name consists of multiple segments (separated by a dot), each segment
	 * is assumed to represent an individual folder. In other words: when a resource name is
	 * converted to an URL, any dots ('.') are converted to slashes ('/').
	 *
	 * <b>Limitation:</b> For the time being, the <b>application root folder</b> is assumed to be
	 * the same as the folder where the current page resides in.
	 *
	 * Usage sample:
	 * <pre>
	 *   // Let UI5 know that resources, whose name starts with "com.mycompany.myapp"
	 *   // should be loaded from the URL location "./com/mycompany/myapp"
	 *   sap.ui.localResources("com.mycompany.myapp");
	 *
	 *   // The following call implicitly will use the mapping done by the previous line
	 *   // It will load a view from ./com/mycompany/myapp/views/Main.view.xml
	 *   sap.ui.view({ view : "com.mycompany.myapp.views.Main", type : sap.ui.core.mvc.ViewType.XML});
	 * </pre>
	 *
	 * When applications need a more flexible mapping between resource names and their location,
	 * they can use {@link jQuery.sap.registerModulePath}.
	 *
	 * It is intended to make this configuration obsolete in future releases, but for the time
	 * being, applications must call this method when they want to store resources relative to
	 * the assumed application root folder.
	 *
	 * @param {string} sNamespace Namespace prefix for which to load resources relative to the application root folder
	 * @public
	 * @static
	 * @see jQuery.sap.registerModulePath
	 */
	sap.ui.localResources = function(sNamespace) {
		jQuery.sap.assert(sNamespace, "sNamespace must not be empty");
		jQuery.sap.registerModulePath(sNamespace, "./" + sNamespace.replace(/\./g, "/"));
	};

	return sap.ui;

}, /* bExport= */ true);

}; // end of sap/ui/Global.js
if ( !jQuery.sap.isDeclared('sap.ui.base.DataType') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.base.DataType
jQuery.sap.declare('sap.ui.base.DataType'); // unresolved dependency added by SAPUI5 CreateModule Ant-Task
sap.ui.define("sap/ui/base/DataType",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * @class Describes the metadata of a data type and provides methods for validation.
	 * @author Frank Weigel
	 * @since 0.9.0
	 * @name sap.ui.base.DataType
	 */
	var DataType = function() {
		// Avoid construction of a DataType.
		// DataType is only a function to support the "instanceof" operator.
		throw new Error();
	};
	
	/**
	 * The qualified name of the data type.
	 * Note that this name usually equals the design time name of the type.
	 * Only for primitive types it differs, namely it omits the package 'sap.ui.core'.
	 * @return {string} name of the data type
	 * @public
	 * @name sap.ui.base.DataType#getName
	 * @function
	 */
	DataType.prototype.getName = function() {
		return undefined;
	};
	
	/**
	 * The base type of this type or undefined if this is a primitive type.
	 * @return {sap.ui.base.DataType} base type or undefined
	 * @public
	 * @name sap.ui.base.DataType#getBaseType
	 * @function
	 */
	DataType.prototype.getBaseType = function() {
		return undefined;
	};
	
	/**
	 * The component type of this type or undefined if this is not an array.
	 * @return {sap.ui.base.DataType} component type or undefined
	 * @public
	 * @name sap.ui.base.DataType#getComponentType
	 * @function
	 */
	DataType.prototype.getComponentType = function() {
		return undefined;
	};
	
	/**
	 * The default value for this type. Each type must define a default value.
	 * @return {any} default value of the data type. The type of the returned value
	 *    must match the JavaScript type of the data type (a string for string types etc.)
	 * @public
	 * @name sap.ui.base.DataType#getDefaultValue
	 * @function
	 */
	DataType.prototype.getDefaultValue = function() {
		return undefined;
	};
	
	/**
	 * Whether this type is an array type.
	 * @return {boolean} whether this type is an array type
	 * @public
	 * @name sap.ui.base.DataType#isArrayType
	 * @function
	 */
	DataType.prototype.isArrayType = function() {
		return undefined;
	};
	
	/**
	 * Parses the given string value and converts it into the specific data type.
	 * @param {string} sValue string representation for a value of this type
	 * @return the value in the correct internal format
	 * @public
	 * @name sap.ui.base.DataType#parseValue
	 * @function
	 */
	DataType.prototype.parseValue = function(sValue) {
		// currently this function considers to handle primitive values
		// - in future may be other values might be also relevant.
		var sType = this.getName();
		if (sType == "string") {
			return sValue;
		} else if (sType == "boolean") {
			return sValue == "true";
		} else if (sType == "int") {
			return parseInt(sValue, 10);
		} else if (sType == "float") {
			return parseFloat(sValue);
		} else if (sType == "object") {
			return sValue ? jQuery.parseJSON(sValue) : null;
		} else {
			// support for other types like e.g.
			// sap.ui.core.CSSSize (just apply)
			return sValue;
		}
	};
	
	/**
	 * A validation check. To be implemented by concrete types.
	 * @param {any} vValue the value to be checked
	 * @return {boolean} whether the given value is valid for this data type (without conversion)
	 * @public
	 * @name sap.ui.base.DataType#isValid
	 */
	DataType.prototype.isValid = undefined;
	
	/**
	 * Sets the normalizer function for that data type
	 * 
	 * @param {function} fnNormalizer the function to call for normalizing. Will be called with the value
	 * as the first parameter. It must return the (normalized) value.
	 * @public
	 * @name sap.ui.base.DataType#setNormalizer
	 * @function
	 */
	DataType.prototype.setNormalizer = function(fnNormalizer) {
		jQuery.sap.assert(typeof fnNormalizer === "function", "DataType.setNormalizer: fnNormalizer must be a function");
		this._fnNormalizer = fnNormalizer;
	};
	
	/**
	 * Changes a value using the normalizer specified for this datatype
	 * 
	 * @param the value to be normalized
	 * @return the normalized value
	 * @public
	 * @name sap.ui.base.DataType#normalize
	 * @function
	 */
	DataType.prototype.normalize = function(oValue) {
		if (typeof this._fnNormalizer === "function") {
			return this._fnNormalizer(oValue);
		} else {
			return oValue;
		}
	};
	
	
	(function() {
	
		function createType(name, s, base) {
	
			jQuery.sap.assert(typeof name === "string" && !!name, "DataType.<createType>: type name must be a string");
			jQuery.sap.assert(!base || base instanceof DataType, "DataType.<createType>: base type must be empty or a DataType");
			s = s || {};
			base = base || DataType.prototype;
	
			// create a new type object with the base type as prototype
			var type = jQuery.sap.newObject(base);
	
			// getter for the name
			type.getName = function() { return name; };
	
			// if a default value is specified, create a getter for it
			if ( s.hasOwnProperty("defaultValue") ) {
				var vDefault = s.defaultValue;
				type.getDefaultValue = function() { return vDefault; };
			}
	
			// if a validator is specified either chain it with the base type validator
			// or set it if no base validator exists
			if ( s.hasOwnProperty("isValid") ) {
				var fnIsValid = s.isValid;
				type.isValid = base.isValid ? function(vValue) {
					if ( !base.isValid(vValue) ) {
						return false;
					}
					return fnIsValid(vValue);
				} : fnIsValid;
			};
	
			// not an array type
			type.isArrayType = function() { return false; };
			
			return type;
		}
	
		function createArrayType(componentType) {
			jQuery.sap.assert(componentType instanceof DataType, "DataType.<createArrayType>: componentType must be a DataType");
	
			// create a new type object with the base type as prototype
			var type = jQuery.sap.newObject(DataType.prototype);
	
			// getter for the name
			type.getName = function() { return componentType.getName() + "[]"; };
	
			// getter for component type
			type.getComponentType = function() { return componentType; };
	
			// array validator
			type.isValid = function(aValues) {
				if (aValues === null) {
					return true;
				}
				if (jQuery.isArray(aValues)) {
					for (var i = 0; i < aValues.length; i++) {
						if (!componentType.isValid(aValues[i])) {
							return false;
						}
					}
					return true;
				}
				return false;
			};
	
			// array parser
			type.parseValue = function(sValue) {
				var aValues = sValue.split(",");
				for (var i = 0; i < aValues.length; i++) {
					aValues[i] = componentType.parseValue(aValues[i]);
				}
				return aValues;
			};
	
			// is an array type
			type.isArrayType = function() { return true; };
	
			return type;
		}
	
		var PREDEFINED_TYPES = {
	
			"any" :
					createType("any", {
						defaultValue : null,
						isValid : function(vValue) {
							return true;
						}
					}),
	
			"boolean" :
				createType("boolean", {
					defaultValue : false,
					isValid : function(vValue) {
						return typeof vValue === "boolean";
					}
				}),
	
			"int" :
				createType("int", {
					defaultValue : 0,
					isValid : function(vValue) {
						return typeof vValue === "number" && Math.floor(vValue) == vValue;
					}
				}),
	
			"float" :
				createType("float", {
					defaultValue : 0.0,
					isValid : function(vValue) {
						return typeof vValue === "number";
					}
				}),
	
			"string" :
				createType("string", {
					defaultValue : "",
					isValid : function(vValue) {
						return typeof vValue === "string" || vValue instanceof String;
					}
				}),
			"object" :
				createType("object", {
					defaultValue : null,
					isValid : function(vValue) {
						return typeof vValue === "object" || typeof vValue === "function";
					}
				})
		};
	
		/**
		 * Returns the type object for the type with the given name.
		 * 
		 * @param {string} sTypeName name of the type to be retrieved 
		 * @return the type object or undefined when no such type object exists.
		 * @public
		 * @name sap.ui.base.DataType.getType
		 * @function
		 */
		DataType.getType = function(sTypeName) {
			if (sTypeName.indexOf("[]") > 0) {
				var sComponentTypeName = sTypeName.substr(0, sTypeName.length - 2),
					oComponentType = this.getType(sComponentTypeName);
				return oComponentType && createArrayType(oComponentType);
			} else {
				return PREDEFINED_TYPES[sTypeName] || jQuery.sap.getObject(sTypeName);
			}
		};
	
		/**
		 * Creates a new type as a subtype of a given type.
		 * @param {string} sName the unique name of the new type
		 * @param {object} [mSettings settings] for the new type
		 * @param {any} [mSettings.defaultValue] the default value for the new type
		 * @param {function} [mSettings.isValid] a validator function for values of the new type
		 * @param {sap.ui.base.DataType} [base] the base type for the new type
		 * @public
		 * @name sap.ui.base.DataType.createType
		 */
		DataType.createType = createType;
	
		// ---- minimal support for interface types ----
		
		var mInterfaces = {};
		
		/**
		 * Registers the given array of type names as known interface types.
		 * Only purpose is to enable the {@link #isInterfaceType} check.
		 * @param {string[]} aTypes interface types to be reigstered  
		 * @private
		 * @name sap.ui.base.DataType.registerInterfaceTypes
		 * @function
		 */
		DataType.registerInterfaceTypes = function(aTypes) {
			for(var i=0; i<aTypes.length; i++) {
				jQuery.sap.setObject(aTypes[i], mInterfaces[aTypes[i]] = new String(aTypes[i]));
			}
		};
		
		/**
		 * @param {string} sType name of type to check
		 * @return {boolean} whether the given type is known to be an interface type
		 * @private 
		 * @name sap.ui.base.DataType.isInterfaceType
		 * @function
		 */
		DataType.isInterfaceType = function(sType) {
			return mInterfaces.hasOwnProperty(sType) && jQuery.sap.getObject(sType) === mInterfaces[sType];
		};
	
	}());

	return DataType;

}, /* bExport= */ true);

}; // end of sap/ui/base/DataType.js
if ( !jQuery.sap.isDeclared('sap.ui.base.EventProvider') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.base.EventProvider
jQuery.sap.declare('sap.ui.base.EventProvider'); // unresolved dependency added by SAPUI5 CreateModule Ant-Task
if ( !jQuery.sap.isDeclared('sap.ui.base.Event') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.base.Event
jQuery.sap.declare('sap.ui.base.Event'); // unresolved dependency added by SAPUI5 CreateModule Ant-Task
if ( !jQuery.sap.isDeclared('sap.ui.base.Object') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/**
 * SAPUI5 base classes
 *
 * @namespace
 * @name sap.ui.base
 * @public
 */

// Provides class sap.ui.base.Object
jQuery.sap.declare('sap.ui.base.Object'); // unresolved dependency added by SAPUI5 CreateModule Ant-Task
if ( !jQuery.sap.isDeclared('sap.ui.base.Interface') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.base.Interface
jQuery.sap.declare('sap.ui.base.Interface'); // unresolved dependency added by SAPUI5 CreateModule Ant-Task
sap.ui.define("sap/ui/base/Interface",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * Constructs an instance of sap.ui.base.Interface which restricts access to methods marked as public.
	 *
	 * @class A class that creates an Interface for an existing class. If a class returns the interface in its constructor,
	 *        only the defined functions will be visible, no internals of the class can be accessed.
	 *
	 * @author Malte Wedel, Daniel Brinkmann
	 * @version 1.20.6
	 * @param {sap.ui.base.Object}
	 *            oObject the instance that needs an interface created
	 * @param {string[]}
	 *            aMethods the names of the methods, that should be available on this interface
	 * @constructor
	 * @public
	 * @name sap.ui.base.Interface
	 */
	var Interface = function(oObject, aMethods) {
	
		// if object is null or undefined, return itself
		if (!oObject) {
			return oObject;
		}
	
		// this function is inline to not appear as a method on the interface
	
		function fCreateDelegator(oObject, sMethodName) {
			return function() {
	//				return oObject[sMethodName].apply(oObject, arguments);
					var tmp = oObject[sMethodName].apply(oObject, arguments);
					// to avoid to hide the implementation behind the interface you need
					// to override the getInterface function in the object
					return (tmp instanceof sap.ui.base.Object) ? tmp.getInterface() : tmp;
				};
		}
	
		// if there are no methods return
		if (!aMethods) {
			return {};
		}
	
		var sMethodName;
	
		// create functions for all delegated methods
		// PERFOPT: 'cache' length of aMethods to reduce # of resolutions
		for (var i = 0, ml = aMethods.length; i < ml; i++) {
			sMethodName = aMethods[i];
			this[sMethodName] = fCreateDelegator(oObject, sMethodName);
		}
	
	};

	return Interface;

}, /* bExport= */ true);

}; // end of sap/ui/base/Interface.js
if ( !jQuery.sap.isDeclared('sap.ui.base.Metadata') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.base.Metadata
jQuery.sap.declare('sap.ui.base.Metadata'); // unresolved dependency added by SAPUI5 CreateModule Ant-Task
if ( !jQuery.sap.isDeclared('jquery.sap.script') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides miscellaneous utility functions that might be useful for any script
jQuery.sap.declare('jquery.sap.script'); // unresolved dependency added by SAPUI5 CreateModule Ant-Task
sap.ui.define("jquery.sap.script",['jquery.sap.global'],
	function(jQuery) {
	"use strict";

	/**
	 * Some private variable used for creation of (pseudo-)unique ids.
	 * @type integer
	 * @private
	 */
	var iIdCounter = 0;

	/**
	 * Creates and returns a pseudo-unique id.
	 *
	 * No means for detection of overlap with already present or future UIDs.
	 *
	 * @return {string} A pseudo-unique id.
	 * @public
	 */
	jQuery.sap.uid = function uid() {
		return "id-" + new Date().valueOf() + "-" + iIdCounter++;
	};

	/**
	 * Calls a method after a given delay and returns an id for this timer
	 *
	 * @param {int} iDelay Delay time in milliseconds
	 * @param {object} oObject Object from which the method should be called
	 * @param {string|object} Method function pointer or name of the method
	 * @param {array} [aParameters] Method parameters
	 * @return {string} Id which can be used to cancel the timer with clearDelayedCall
	 * @public
	 */
	jQuery.sap.delayedCall = function delayedCall(iDelay, oObject, method, aParameters) {
		return setTimeout(function(){
			if (jQuery.type(method) == "string") {
				method = oObject[method];
			}
			method.apply(oObject, aParameters ||[]);
		}, iDelay);
	};

	/**
	 * Stops the delayed call.
	 *
	 * The function given when calling delayedCall is not called anymore.
	 *
	 * @param {string} sDelayedCallId The id returned, when calling delayedCall
	 * @public
	 */
	jQuery.sap.clearDelayedCall = function clearDelayedCall(sDelayedCallId) {
		clearTimeout(sDelayedCallId);
		return this;
	};

	/**
	 * Calls a method after a given interval and returns an id for this interval.
	 *
	 * @param {int} iInterval Interval time in milliseconds
	 * @param {object} oObject Object from which the method should be called
	 * @param {string|object} Method function pointer or name of the method
	 * @param {array} [aParameters] Method parameters
	 * @return {string} Id which can be used to cancel the interval with clearIntervalCall
	 * @public
	 */
	jQuery.sap.intervalCall = function intervalCall(iInterval, oObject, method, aParameters) {
		return setInterval(function(){
			if (jQuery.type(method) == "string") {
				method = oObject[method];
			}
			method.apply(oObject, aParameters ||[]);
		}, iInterval);
	};

	/**
	 * Stops the interval call.
	 *
	 * The function given when calling intervalCall is not called anymore.
	 *
	 * @param {string} sIntervalCallId The id returned, when calling intervalCall
	 * @public
	 */
	jQuery.sap.clearIntervalCall = function clearIntervalCall(sIntervalCallId) {
		clearInterval(sIntervalCallId);
		return this;
	};

	// Javadoc for private inner class "UriParams" - this list of comments is intentional!
	/**
	 * @interface	Encapsulates all URI parameters of the current windows location (URL).
	 *
	 * Use {@link jQuery.sap.getUriParameters} to create an instance of jQuery.sap.util.UriParameters.
	 *
	 * @author SAP AG
	 * @version 1.20.6
	 * @since 0.9.0
	 * @name jQuery.sap.util.UriParameters
	 * @public
	 */
	/**
	 * Returns the value(s) of the URI parameter with the given name sName.
	 *
	 * If the boolean parameter bAll is <code>true</code>, an array of string values of all
	 * occurrences of the URI parameter with the given name is returned. This array is empty
	 * if the URI parameter is not contained in the windows URL.
	 *
	 * If the boolean parameter bAll is <code>false</code> or is not specified, the value of the first
	 * occurrence of the URI parameter with the given name is returned. Might be <code>null</code>
	 * if the URI parameter is not contained in the windows URL.
	 *
	 * @param {string} sName The name of the URI parameter.
	 * @param {boolean} [bAll=false] Optional, specifies whether all or only the first parameter value should be returned.
	 * @return {string|array} The value(s) of the URI parameter with the given name
	 * @SecSource {return|XSS} Return value contains URL parameters
	 *
	 * @function
	 * @name jQuery.sap.util.UriParameters.prototype.get
	 */

	/*
	 * Implements jQuery.sap.util.UriParameters
	 */
	var UriParams = function(sUri) {
		this.mParams = {};
		var sQueryString = sUri || window.location.href;
		if ( sQueryString.indexOf('#') >= 0 ) {
			sQueryString = sQueryString.slice(0, sQueryString.indexOf('#'));
		}
		if(sQueryString.indexOf("?") >= 0){
			sQueryString = sQueryString.slice(sQueryString.indexOf("?") + 1);
			var aParameters = sQueryString.split("&"),
				mParameters = {},
				aParameter,
				sName,
				sValue;
			for(var i=0; i<aParameters.length; i++){
				aParameter = aParameters[i].split("=");
				sName = decodeURIComponent(aParameter[0]);
				sValue = aParameter.length > 1 ? decodeURIComponent(aParameter[1].replace(/\+/g,' ')) : "";
				if(sName){
					if(!Object.prototype.hasOwnProperty.call(mParameters, sName)){
						mParameters[sName] = [];
					}
					mParameters[sName].push(sValue);
				}
			}
			this.mParams = mParameters;
		}
	};

	UriParams.prototype = {};

	/*
	 * Implements jQuery.sap.util.UriParameters.prototype.get
	 */
	UriParams.prototype.get = function(sName, bAll) {
		var aValues = Object.prototype.hasOwnProperty.call(this.mParams, sName) ? this.mParams[sName] : [];
		return bAll === true ? aValues : (aValues[0] || null);
	};

	/**
	 * Creates and returns a new instance of {@link jQuery.sap.util.UriParameters}.
	 *
	 * Example for reading a single URI parameter (or the value of the first
	 * occurrence of the URI parameter):
	 * <pre>
	 *	var sValue = jQuery.sap.getUriParameters().get("myUriParam");
	 * </pre>
	 *
	 * Example for reading the values of the first of the URI parameter
	 * (with multiple occurrences):
	 * <pre>
	 *	var aValues = jQuery.sap.getUriParameters().get("myUriParam", true);
	 *	for(i in aValues){
	 *	var sValue = aValues[i];
	 *	}
	 * </pre>
	 *
	 * @public
	 * @return {jQuery.sap.util.UriParameters} A new URI parameters instance
	 */
	jQuery.sap.getUriParameters = function getUriParameters(sUri) {
		return new UriParams(sUri);
	};

	/**
	 * Sorts the given array in-place and removes any duplicates (identified by "===").
	 *
	 * Use <code>jQuery.unique()</code> for arrays of DOMElements.
	 *
	 * @param {Array} a An Array of any type
	 * @return {Array} Same array as given (for chaining)
	 * @public
	 */
	jQuery.sap.unique = function(a) {
		jQuery.sap.assert(a instanceof Array, "unique: a must be an array");
		var l=a.length;
		if ( l > 1 ) {
			a.sort();
			for(var i=1,j=0; i<l; i++) {
				// invariant: i is the entry to check, j is the last unique entry known so far
				if ( a[i] !== a[j] ) {
					a[++j] = a[i];
				}
			}
			// cut off the rest - if any
			if ( ++j < l ) {
				a.splice(j, l-j);
			}
		}
		return a;
	};

	/**
	 * Compares the two given values for equality, especially takes care not to compare
	 * arrays and objects by reference, but compares their content.
	 * Note: function does not work with comparing XML objects
	 *
	 * @param {any} a A value of any type
	 * @param {any} b A value of any type
	 * @param {int} [maxDepth=10] Maximum recursion depth
	 * @param {boolean} [contains] Whether all existing properties in a are equal as in b
	 * 
	 * @return {boolean} Whether a and b are equal
	 * @public
	 */
	jQuery.sap.equal = function(a, b, maxDepth, contains, depth) {
		// Optional parameter normalization
		if (typeof maxDepth == "boolean") {
			contains = maxDepth;
			maxDepth = undefined;
		}
		if (!depth) depth = 0;
		if (!maxDepth) maxDepth = 10;
		if (depth > maxDepth) return false;
		if (a === b) return true;
		if (jQuery.isArray(a) && jQuery.isArray(b)) {
			if (!contains) {
				if (a.length != b.length) { return false; }
			} else {
				if (a.length > b.length) { return false; }
			}
			for (var i = 0; i < a.length; i++) {
				if (!jQuery.sap.equal(a[i], b[i], maxDepth, contains, depth + 1)) { 
						return false;
				}
			}
			return true;
		}
		if (typeof a == "object" && typeof b == "object") {
			if (!a || !b) {
				return false;
			}
			if (a.constructor != b.constructor) {
				return false;
			}
			if (a.nodeName && b.nodeName && a.namespaceURI && b.namespaceURI) {
				return jQuery.sap.isEqualNode(a,b);
			}
			if (a instanceof Date) {
				return a.valueOf() == b.valueOf();
			}
			for (var i in a) {
				if (!jQuery.sap.equal(a[i], b[i], maxDepth, contains, depth + 1)) { 
					return false;
				}
			}
			if (!contains) {
				for (var i in b) {
					if (a[i] === undefined) { 
						return false;
					}
				}
			}
			return true;
		}
		return false;
	};
	
	/**
	 * Iterates over elements of the given object or array. 
	 * 
	 * Works similar to <code>jQuery.each</code>, but a numeric index is only used for 
	 * instances of <code>Array</code>. For all other objects, including those with a numeric 
	 * <code>length</code> property, the properties are iterated by name. 
	 * 
	 * The contract for the <code>fnCallback</code> is the same as for <code>jQuery.each</code>,
	 * when it returns <code>false</code>, then the iteration stops (break).
	 * 
	 * @param {object|any[]} oObject object or array to enumerate the properties of
	 * @param {function} fnCallback function to call for each property name
	 * @return {object|any[]} the given <code>oObject</code> 
	 * @since 1.11
	 */
	jQuery.sap.each = function(oObject, fnCallback) {
		var isArray = jQuery.isArray(oObject),
			length, i;

		if ( isArray ) {
			for (i=0,length=oObject.length; i < length; i++) {
				if ( fnCallback.call(oObject[i], i, oObject[i]) === false ) {
					break;
				}
			}
		} else {
			for ( i in oObject ) {
				if ( fnCallback.call(oObject[i], i, oObject[i] ) === false ) {
					break;
				}
			}
		}

		return oObject;
	};
	
	/**
	 * Substitute for <code>for(n in o)</code> loops which fixes the 'Don'tEnum' bug of IE8.
	 * 
	 * Iterates over all enumerable properties of the given object and calls the
	 * given callback function for each of them. The assumed signature of the 
	 * callback function is 
	 * 
	 *	 fnCallback(name, value)
	 *	 
	 * where name is the name of the property and value is its value.
	 * 
	 * When an object in IE8 overrides a property of Object.prototype
	 * that has been marked as 'don't enum', then IE8 by mistake also 
	 * doesn't enumerate the overriding property. 
	 * 
	 * A 100% complete substitute is hard to achieve. The current implementation 
	 * enumerates an overridden property when it either is an 'own' property 
	 * (hasOwnProperty(name) is true) or when the property value is different 
	 * from the value in the Object.prototype object.
	 * 
	 * @param {object} oObject object to enumerate the properties of
	 * @param {function} fnCallback function to call for each property name
	 * @function
	 * @since 1.7.1
	 */
	jQuery.sap.forIn = {toString:null}.propertyIsEnumerable("toString") ?
		// for browsers without the bug we use the straight forward implementation of a for in loop
		function(oObject, fnCallback) {
			for(var n in oObject) {
				if ( fnCallback(n, oObject[n]) === false ) {
					return;
				}
			}
		} : 
		// use a special implementation for IE8 
		(function() {
			var DONT_ENUM_KEYS = ["toString","valueOf","toLocaleString", "hasOwnProperty","isPrototypeOf","propertyIsEnumerable","constructor"],
					DONT_ENUM_KEYS_LENGTH = DONT_ENUM_KEYS.length,
					oObjectPrototype = Object.prototype,
					fnHasOwnProperty = oObjectPrototype.hasOwnProperty;
					
			return function(oObject, fnCallback) {
				var n,i;
				
				// standard for(in) loop
				for(n in oObject) {
					if ( fnCallback(n, oObject[n]) === false ) {
						return;
					}
				}
				// additionally check the known 'don't enum' names
				for(var i=0; i<DONT_ENUM_KEYS_LENGTH; i++) {
					n = DONT_ENUM_KEYS[i];
					// assume an enumerable property if it is either an own property
					// or if its value differes fro mthe value in the Object.prototype
					if ( fnHasOwnProperty.call(oObject,n) || oObject[n] !== oObjectPrototype[n] ) {
						if ( fnCallback(n, oObject[n]) === false ) {
							return;
						}
					}
				}
				// Note: this substitute implementation still fails in several regards
				// - it fails when oObject is identical to Object.prototype (iterates non-enumerable properties)
				// - it fails when one of the don't enum properties by intention has been overridden in the 
				//	 prototype chain with a value identical to the value in Object.prototype
				// - the don't enum properties are handled out of order. This is okay with the ECMAScript
				//	 spec but might be unexpected for some callers
			}
	 	}());
		

	/**
	 * Calculate delta of old list and new list
	 * This implements the algorithm described in "A Technique for Isolating Differences Between Files"
	 * (Commun. ACM, April 1978, Volume 21, Number 4, Pages 264-268)
	 * @public
	 * @param {Array} aOld Old Array
	 * @param {Array} aNew New Array
	 * @param {function} [fnCompare] Function to compare list entries
	 * @return {Array} List of changes
	 */
	jQuery.sap.arrayDiff = function(aOld, aNew, fnCompare){
		fnCompare = fnCompare || function(vValue1, vValue2) {
			return jQuery.sap.equal(vValue1, vValue2);
		}

		var aOldRefs = [];
		var aNewRefs = [];

		//Find references
		var aMatches = [];
		for (var i = 0; i < aNew.length; i++) {
			var oNewEntry = aNew[i];
			var iFound = 0;
			var iTempJ;
			for (var j = 0; j < aOld.length; j++) {
				if (fnCompare(aOld[j],oNewEntry)) {
					iFound++;
					iTempJ = j;
					if (iFound > 1) {
						break;
					}
				}
			}
			if (iFound == 1) {
				var oMatchDetails = {
					oldIndex: iTempJ,
					newIndex: i
				};
				if (aMatches[iTempJ]) {
					delete aOldRefs[iTempJ];
					delete aNewRefs[aMatches[iTempJ].newIndex];
				} else {
					aNewRefs[i] = {
						data: aNew[i],
						row: iTempJ
					};
					aOldRefs[iTempJ] = {
						data: aOld[iTempJ],
						row: i
					};
					aMatches[iTempJ] = oMatchDetails;
				}
			}
		}

		//Pass 4: Find adjacent matches in ascending order
		for (var i = 0; i < aNew.length - 1; i++) {
			if (aNewRefs[i] &&
				!aNewRefs[i+1] &&
				aNewRefs[i].row + 1 < aOld.length &&
				!aOldRefs[aNewRefs[i].row + 1] &&
				fnCompare(aOld[ aNewRefs[i].row + 1 ], aNew[i+1])) {

				aNewRefs[i+1] = {
					data: aNew[i+1],
					row: aNewRefs[i].row + 1
				};
				aOldRefs[aNewRefs[i].row+1] = {
					data: aOldRefs[aNewRefs[i].row+1],
					row: i + 1
				};

			}
		}

		//Pass 5: Find adjacent matches in descending order
		for (var i = aNew.length - 1; i > 0; i--) {
			if (aNewRefs[i] &&
				!aNewRefs[i-1] &&
				aNewRefs[i].row > 0 &&
				!aOldRefs[aNewRefs[i].row - 1] &&
				fnCompare(aOld[aNewRefs[i].row - 1], aNew[i-1])) {

				aNewRefs[i-1] = {
					data: aNew[i-1],
					row: aNewRefs[i].row - 1
				};
				aOldRefs[aNewRefs[i].row-1] = {
					data: aOldRefs[aNewRefs[i].row-1],
					row: i - 1
				};

			}
		}

		//Pass 6: Generate diff data
		var aDiff = [];

		if (aNew.length == 0) {
			//New list is empty, all items were deleted
			for (var i = 0; i < aOld.length; i++) {
				aDiff.push({
					index: 0,
					type: 'delete'
				});
			}
		} else {
			var iNewListIndex = 0;
			if (!aOldRefs[0]) {
				//Detect all deletions at the beginning of the old list
				for (var i = 0; i < aOld.length && !aOldRefs[i]; i++) {
					aDiff.push({
						index: 0,
						type: 'delete'
					});
					iNewListIndex = i + 1;
				}
			}

			for (var i = 0; i < aNew.length; i++) {
				if (!aNewRefs[i] || aNewRefs[i].row > iNewListIndex) {
					//Entry doesn't exist in old list = insert
					aDiff.push({
						index: i,
						type: 'insert'
					});
				} else {
					iNewListIndex = aNewRefs[i].row + 1;
					for (var j = aNewRefs[i].row + 1; j < aOld.length && (!aOldRefs[j] || aOldRefs[j].row < i); j++) {
						aDiff.push({
							index: i+1,
							type: 'delete'
						});
						iNewListIndex = j + 1;
					}
				}
			}
		}

		return aDiff;
	};

	/**
	 * Parse simple JS objects.
	 * 
	 * A parser for JS object literals. This is different from a JSON parser, as it does not have
	 * the JSON specification as a format description, but a subset of the JavaScript language.
	 * The main difference is, that keys in objects do not need to be quoted and strings can also
	 * be defined using apostrophes instead of quotation marks.
	 * 
	 * The parser does not support functions, but only boolean, number, string, object and array.
	 * 
	 * @param {string} The string containing the JS objects
	 * @throws an error, if the string does not contain a valid JS object
	 * @returns {object} the JS object
	 * 
	 * @since 1.11
	 */
	jQuery.sap.parseJS = (function() {

		var at, // The index of the current character
			ch, // The current character
			escapee = {
				'"': '"',
				'\'': '\'',
				'\\': '\\',
				'/': '/',
				b: '\b',
				f: '\f',
				n: '\n',
				r: '\r',
				t: '\t'
			},
			text,

			error = function(m) {

				// Call error when something is wrong.
				throw {
					name: 'SyntaxError',
					message: m,
					at: at,
					text: text
				};
			},

			next = function(c) {

				// If a c parameter is provided, verify that it matches the current character.
				if (c && c !== ch) {
					error("Expected '" + c + "' instead of '" + ch + "'");
				}

				// Get the next character. When there are no more characters,
				// return the empty string.
				ch = text.charAt(at);
				at += 1;
				return ch;
			},

			number = function() {

				// Parse a number value.
				var number, string = '';

				if (ch === '-') {
					string = '-';
					next('-');
				}
				while (ch >= '0' && ch <= '9') {
					string += ch;
					next();
				}
				if (ch === '.') {
					string += '.';
					while (next() && ch >= '0' && ch <= '9') {
						string += ch;
					}
				}
				if (ch === 'e' || ch === 'E') {
					string += ch;
					next();
					if (ch === '-' || ch === '+') {
						string += ch;
						next();
					}
					while (ch >= '0' && ch <= '9') {
						string += ch;
						next();
					}
				}
				number = +string;
				if (!isFinite(number)) {
					error("Bad number");
				} else {
					return number;
				}
			},

			string = function() {

				// Parse a string value.
				var hex, i, string = '', quote,
					uffff;

				// When parsing for string values, we must look for " and \ characters.
				if (ch === '"' || ch === '\'') {
					quote = ch;
					while (next()) {
						if (ch === quote) {
							next();
							return string;
						}
						if (ch === '\\') {
							next();
							if (ch === 'u') {
								uffff = 0;
								for (i = 0; i < 4; i += 1) {
									hex = parseInt(next(), 16);
									if (!isFinite(hex)) {
										break;
									}
									uffff = uffff * 16 + hex;
								}
								string += String.fromCharCode(uffff);
							} else if (typeof escapee[ch] === 'string') {
								string += escapee[ch];
							} else {
								break;
							}
						} else {
							string += ch;
						}
					}
				}
				error("Bad string");
			},

			name = function() {

				// Parse a name value.
				var name = '',
					charcode,
					allowed = function(ch) {
						return ch === "_" ||
							(ch >= "0" && ch <= "9") ||
							(ch >= "a" && ch <= "z") ||
							(ch >= "A" && ch <= "Z") 
					};

				if (allowed(ch)) {
					name += ch;
				} else {
					error("Bad name");
				}

				while (next()) {
					if (ch === ' ') {
						next();
						return name;
					}
					if (ch === ':') {
						return name;
					}
					if (allowed(ch)) {
						name += ch;
					} else {
						error("Bad name");
					}
				}
				error("Bad name");
			},

			white = function() {

				// Skip whitespace.
				while (ch && ch <= ' ') {
					next();
				}
			},

			word = function() {

				// true, false, or null.
				switch (ch) {
				case 't':
					next('t');
					next('r');
					next('u');
					next('e');
					return true;
				case 'f':
					next('f');
					next('a');
					next('l');
					next('s');
					next('e');
					return false;
				case 'n':
					next('n');
					next('u');
					next('l');
					next('l');
					return null;
				}
				error("Unexpected '" + ch + "'");
			},

			value, // Place holder for the value function.
			array = function() {

				// Parse an array value.
				var array = [];

				if (ch === '[') {
					next('[');
					white();
					if (ch === ']') {
						next(']');
						return array; // empty array
					}
					while (ch) {
						array.push(value());
						white();
						if (ch === ']') {
							next(']');
							return array;
						}
						next(',');
						white();
					}
				}
				error("Bad array");
			},

			object = function() {

				// Parse an object value.
				var key, object = {};

				if (ch === '{') {
					next('{');
					white();
					if (ch === '}') {
						next('}');
						return object; // empty object
					}
					while (ch) {
						if (ch >= "0" && ch <= "9") {
							key = number();
						} else if (ch === '"' || ch === '\''){
							key = string();
						} else {
							key = name();
						}
						white();
						next(':');
						if (Object.hasOwnProperty.call(object, key)) {
							error('Duplicate key "' + key + '"');
						}
						object[key] = value();
						white();
						if (ch === '}') {
							next('}');
							return object;
						}
						next(',');
						white();
					}
				}
				error("Bad object");
			};

		value = function() {

			// Parse a JS value. It could be an object, an array, a string, a number,
			// or a word.
			white();
			switch (ch) {
			case '{':
				return object();
			case '[':
				return array();
			case '"':
			case '\'':
				return string();
			case '-':
				return number();
			default:
				return ch >= '0' && ch <= '9' ? number() : word();
			}
		};

		// Return the parse function. It will have access to all of the above
		// functions and variables.
		return function(source, start) {
			var result;

			text = source;
			at = start || 0;
			ch = ' ';
			result = value();
			
			if ( isNaN(start) ) {
				white();
				if (ch) {
					error("Syntax error");
				}
				return result;
			} else {
				return { result : result, at : at-1 };
			}

		};
	}())

	return jQuery;

}, /* bExport= */ false);

}; // end of jquery.sap.script.js
sap.ui.define("sap/ui/base/Metadata",['jquery.sap.global', 'jquery.sap.script'],
	function(jQuery/* , jQuerySap */) {
	"use strict";


	/**
	 * Creates a new metadata object from the given static infos.
	 *
	 * @param {string} sClassName fully qualified name of the class that is described by this metadata object
	 * @param {object} oClassInfo info to construct the class and its metadata from
	 *
	 * @class Metadata for a class.
	 * @author Frank Weigel
	 * @version 1.20.6
	 * @since 0.8.6
	 * @public
	 * @name sap.ui.base.Metadata
	 */
	var Metadata = function(sClassName, oClassInfo) {
	
		jQuery.sap.assert(typeof sClassName === "string" && sClassName, "Metadata: sClassName must be a non-empty string");
		jQuery.sap.assert(typeof oClassInfo === "object", "Metadata: oClassInfo must be empty or an object");
	
		// support for old usage of Metadata
		if ( !oClassInfo || typeof oClassInfo.metadata !== "object" ) {
			oClassInfo = {
				metadata : oClassInfo || {},
				// retrieve class by its name. Using a lookup costs time but avoids the need for redundant arguments to this function
				constructor : jQuery.sap.getObject(sClassName)
			};
			oClassInfo.metadata.__version = 1.0;
		}
		oClassInfo.metadata.__version = oClassInfo.metadata.__version || 2.0;
		if ( typeof oClassInfo.constructor !== "function" ) {
			throw Error("constructor for class " + sClassName + " must have been declared before creating metadata for it");
		}
	
		// invariant: oClassInfo exists, oClassInfo.metadata exists, oClassInfo.constructor exists
		this._sClassName = sClassName;
		this._oClass = oClassInfo.constructor;
		this.extend(oClassInfo);
	};
	
	/**
	 * @private
	 * @final
	 * @name sap.ui.base.Metadata#extend
	 * @function
	 */
	Metadata.prototype.extend = function(oClassInfo) {
		this.applySettings(oClassInfo);
		this.afterApplySettings();
	};
	
	/**
	 * @private
	 * @since 1.3.1
	 * @name sap.ui.base.Metadata#applySettings
	 * @function
	 */
	Metadata.prototype.applySettings = function(oClassInfo) {
	
		var that = this,
		  oStaticInfo = oClassInfo.metadata,
			oPrototype, n;
	
		if ( oStaticInfo.baseType ) {
			// lookup base class by its name - same reasoning as above
			var oParentClass = jQuery.sap.getObject(oStaticInfo.baseType);
			if ( typeof oParentClass !== "function" ) {
				jQuery.sap.log.fatal("base class '" + oStaticInfo.baseType + "' does not exist");
			}
			// link metadata with base metadata
			if ( oParentClass.getMetadata ) {
				this._oParent = oParentClass.getMetadata();
				jQuery.sap.assert(oParentClass === oParentClass.getMetadata().getClass(), "Metadata: oParentClass must match the class in the parent metadata");
			} else {
				// fallback, if base class has no metadata
				this._oParent = new Metadata(oStaticInfo.baseType, {});
			}
		} else {
			this._oParent = undefined;
		}
	
		this._bAbstract = !!oStaticInfo["abstract"];
		this._bFinal = !!oStaticInfo["final"];
		this._sStereotype = oStaticInfo.stereotype || (this._oParent ? this._oParent._sStereotype : "object");
		
		// handle interfaces
		this._aInterfaces = jQuery.sap.unique(oStaticInfo.interfaces || []);
	
		// take over metadata from static info
		this._aPublicMethods = jQuery.sap.unique(oStaticInfo.publicMethods || []);
	
		// enrich prototype
		oPrototype = this._oClass.prototype;
		jQuery.sap.forIn(oClassInfo, function(n, v) {
			if ( n !== "metadata" && n !== "constructor" ) {
				oPrototype[n] = v;
				if ( !n.match(/^_|^on|^init$|^exit$/) ) {
					// TODO hard coded knowledge about event handlers ("on") and about init/exit hooks is not nice....
					that._aPublicMethods.push(n);
				}
			}
		});
		
	};
	
	/**
	 * Called after new settings have been applied.
	 *
	 * Typically, this method is used to do some cleanup (e.g. uniqueness)
	 * or to calculate an optimized version of some data.
	 * @private
	 * @since 1.3.1
	 * @name sap.ui.base.Metadata#afterApplySettings
	 * @function
	 */
	Metadata.prototype.afterApplySettings = function() {
		// create the flattened "all" view
		if ( this._oParent ) {
			//this._aAllInterfaces = jQuery.sap.unique(this._oParent._aAllInterfaces.concat(this._aInterfaces));
			this._aAllPublicMethods = jQuery.sap.unique(this._oParent._aAllPublicMethods.concat(this._aPublicMethods));
		} else {
			//this._aAllInterfaces = this._aInterfaces;
			this._aAllPublicMethods = this._aPublicMethods;
		}
	
	};
	
	/**
	 * Stereotype of the described class. 
	 * @experimental might be enhanced to a set of stereotypes
	 * @name sap.ui.base.Metadata#getStereotype
	 * @function
	 */
	Metadata.prototype.getStereotype = function() {
		return this._sStereotype;
	};
	
	/**
	 * Returns the fully qualified name of the class that is described by this metadata object
	 * @return {string} name of the described class
	 * @public
	 * @name sap.ui.base.Metadata#getName
	 * @function
	 */
	Metadata.prototype.getName = function() {
		return this._sClassName;
	};
	
	/**
	 * Returns the (constructor of the) class described by this metadata object.
	 * @return {function} class described by this metadata
	 * @public
	 * @name sap.ui.base.Metadata#getClass
	 * @function
	 */
	Metadata.prototype.getClass = function() {
		return this._oClass;
	};
	
	/**
	 * Returns the metadata object of the base class of the class described by this metadata object
	 * or null if the class has no (documented) base class.
	 *
	 * @return {sap.ui.base.Metadata} metadata of the base class
	 * @public
	 * @name sap.ui.base.Metadata#getParent
	 * @function
	 */
	Metadata.prototype.getParent = function() {
		return this._oParent;
	};
	
	/**
	 * Returns an array with the names of the public methods declared by this class.
	 *
	 * @return {string[]} array with names of public methods declared by this class
	 * @public
	 * @name sap.ui.base.Metadata#getPublicMethods
	 * @function
	 */
	Metadata.prototype.getPublicMethods = function() {
		return this._aPublicMethods;
	};
	
	/**
	 * Returns an array with the names of all public methods declared by this class
	 * and its ancestors.
	 *
	 * @return {string[]} array with names of all public methods provided by this class and its ancestors
	 * @public
	 * @name sap.ui.base.Metadata#getAllPublicMethods
	 * @function
	 */
	Metadata.prototype.getAllPublicMethods = function() {
		return this._aAllPublicMethods;
	};
	
	/**
	 * Returns the names of interfaces implemented by this class.
	 * As the representation of interfaces is not clear yet, this method is still private.
	 *
	 * @return {string} array of names of implemented interfaces
	 * @private
	 * @name sap.ui.base.Metadata#getInterfaces
	 * @function
	 */
	Metadata.prototype.getInterfaces = function() {
		return this._aInterfaces;
	};
	
	/**
	 * Checks whether the class described by this object or one of its ancestors
	 * implements the given interface.
	 *
	 * @param {string} sInterface name of the interface to test for (in dot notation)
	 * @return {boolean} whether this class implements the interface
	 * @public
	 * @name sap.ui.base.Metadata#isInstanceOf
	 * @function
	 */
	Metadata.prototype.isInstanceOf = function(sInterface) {
		if ( this._oParent ) {
			if ( this._oParent.isInstanceOf(sInterface) ) {
				return true;
			}
		};
	
		var a=this._aInterfaces;
		for(var i=0,l=a.length; i<l; i++) {
			// FIXME doesn't handle interface inheritance (requires object representation for interfaces)
			if ( a[i] === sInterface ) {
				return true;
			}
		}
	
		return false;
	};
	
	
	Metadata.prototype.isAbstract = function() {
		return this._bAbstract;
	};
	
	Metadata.prototype.isFinal = function() {
		return this._bFinal;
	};
	
	/**
	 * Adds one or more new methods to the list of API methods.
	 *
	 * Can be used by contributer classes (like the EnabledPropagator) to enrich the declared set of methods.
	 * The method can either be called with multiple names (strings) or with one array of strings.
	 *
	 * <b>Note</b>: the newly added method(s) will only be visible in {@link sap.ui.base.Interface interface}
	 * objects that are created <i>after</i> this method has been called.
	 *
	 * @param {string||string[]} sMethod name(s) of the new method(s)
	 * @name sap.ui.base.Metadata#addPublicMethods
	 * @function
	 */
	Metadata.prototype.addPublicMethods = function(sMethod /* ... */) {
		var aNames = (sMethod instanceof Array) ? sMethod : arguments;
		function upush(a,v) {
			Array.prototype.push.apply(a, v); // appends "inplace"
			jQuery.sap.unique(a);
		}
		upush(this._aPublicMethods, aNames);
		upush(this._aAllPublicMethods, aNames);
	};
	
	/**
	 * @since 1.3.1
	 * @private
	 * @name sap.ui.base.Metadata.createClass
	 * @function
	 */
	Metadata.createClass = function (fnBaseClass, sClassName, oClassInfo, FNMetaImpl) {
	
		if ( typeof fnBaseClass === "string" ) {
			FNMetaImpl = oClassInfo;
			oClassInfo = sClassName;
			sClassName = fnBaseClass;
			fnBaseClass = null;
		}
	
		jQuery.sap.assert(!fnBaseClass || typeof fnBaseClass === "function");
		jQuery.sap.assert(typeof sClassName === "string" && !!sClassName);
		jQuery.sap.assert(!oClassInfo || typeof oClassInfo === "object");
		jQuery.sap.assert(!FNMetaImpl || typeof FNMetaImpl === "function");
	
		// allow metadata class to preprocess 
		FNMetaImpl = FNMetaImpl || Metadata;
		if ( typeof FNMetaImpl.preprocessClassInfo === "function" ) {
			oClassInfo = FNMetaImpl.preprocessClassInfo(oClassInfo); 
		}
	  
		// normalize oClassInfo
		oClassInfo = oClassInfo || {};
		oClassInfo.metadata = oClassInfo.metadata || {};
		if ( !oClassInfo.hasOwnProperty('constructor') ) {
			oClassInfo.constructor = undefined;
		}
	
		var fnClass = oClassInfo.constructor;
		jQuery.sap.assert(!fnClass || typeof fnClass === "function");
	
		// ensure defaults
		if ( fnBaseClass ) {
			// default constructor just delegates to base class
			if ( !fnClass ) {
				if ( oClassInfo.metadata.deprecated ) {
				  // create default factory with deprecation warning
					fnClass = function() {
						jQuery.sap.log.warning("Usage of deprecated class: " + sClassName);
						fnBaseClass.apply(this, arguments); 
					};
				} else {
	        // create default factory 
					fnClass = function() { 
						fnBaseClass.apply(this, arguments); 
					};
				}
			}
			// create prototype chain
			fnClass.prototype = jQuery.sap.newObject(fnBaseClass.prototype);
			fnClass.prototype.constructor = fnClass;
			// enforce correct baseType
			oClassInfo.metadata.baseType = fnBaseClass.getMetadata().getName();
		} else {
			// default constructor does nothing
			fnClass = fnClass || function() { };
			// enforce correct baseType
			delete oClassInfo.metadata.baseType;
		}
		oClassInfo.constructor = fnClass;
	
		// make the class visible as JS Object
		jQuery.sap.setObject(sClassName, fnClass);
	
		// add metadata
		var oMetadata = new FNMetaImpl(sClassName, oClassInfo);
		fnClass.getMetadata = fnClass.prototype.getMetadata = jQuery.sap.getter(oMetadata);
	
		// enrich function
		if ( !fnClass.getMetadata().isFinal() ) {
			fnClass.extend = function(sSCName, oSCClassInfo, fnSCMetaImpl) {
				return Metadata.createClass(fnClass, sSCName, oSCClassInfo, fnSCMetaImpl || FNMetaImpl);
			};
		}
	
		return fnClass;
	};
	
	

	return Metadata;

}, /* bExport= */ true);

}; // end of sap/ui/base/Metadata.js
sap.ui.define("sap/ui/base/Object",['jquery.sap.global', './Interface', './Metadata'],
	function(jQuery, Interface, Metadata) {
	"use strict";


	/**
	 * Constructor for a sap.ui.base.Object.
	 *
	 * @class Base class for all SAPUI5 Objects
	 * @abstract
	 * @author Malte Wedel
	 * @version 1.20.6
	 * @public
	 * @name sap.ui.base.Object
	 */
	var BaseObject = Metadata.createClass("sap.ui.base.Object", {
	
		constructor : function() {
			// complain if 'this' is not an instance of a subclass
			if ( !(this instanceof BaseObject) ) {
				throw Error("Cannot instantiate object: \"new\" is missing!");
			}
		}
	
	});
	
	/**
	 * Destructor method for objects
	 * @public
	 * @name sap.ui.base.Object#destroy
	 * @function
	 */
	BaseObject.prototype.destroy = function() {
	};
	
	/**
	 * Returns the public interface of the object.
	 *
	 * @return {sap.ui.base.Interface} the public interface of the object
	 * @public
	 * @name sap.ui.base.Object#getInterface
	 * @function
	 */
	BaseObject.prototype.getInterface = function() {
		// New implementation that avoids the overhead of a dedicated member for the interface
		// initially, an Object instance has no associated Interface and the getInterface
		// method is defined only in the prototype. So the code here will be executed.
		// It creates an interface (basically the same code as in the old implementation)
		var oInterface = new Interface(this, this.getMetadata().getAllPublicMethods());
		// Now this Object instance gets a new, private implementation of getInterface
		// that returns the newly created oInterface. Future calls of getInterface on the
		// same Object therefore will return the already created interface
		this.getInterface = jQuery.sap.getter(oInterface);
		// as the first caller doesn't benefit from the new method implementation we have to
		// return the created interface as well.
		return oInterface;
	};
	
	/**
	 * Returns the metadata for the class that this object belongs to.
	 * 
	 * This method is only defined when metadata has been declared by using {@link sap.ui.base.Object.defineClass} 
	 * or {@link sap.ui.base.Object.extend}.
	 *
	 * @return {sap.ui.base.Metadata] metadata for the class of the object
	 * @name sap.ui.base.Object.prototype#getMetadata
	 * @function
	 * @public
	 */
	
	/**
	 * Creates a subclass of class sap.ui.base.Object with name <code>sClassName</code>
	 * and enriches it with the information contained in <code>oClassInfo</code>.
	 *
	 * <code>oClassInfo</code> might contain three kinds of informations:
	 * <ul>
	 * <li><code>metadata:</code> an (optional) object literal with metadata about the class.
	 * The information in the object literal will be wrapped by an instance of {@link sap.ui.base.Metadata Metadata}
	 * and might contain the following information
	 * <ul>
	 * <li><code>interfaces:</code> {string[]} (optional) set of names of implemented interfaces (defaults to no interfaces)</li>
	 * <li><code>publicMethods:</code> {string[]} (optional) list of methods that should be part of the public
	 * facade of the class</li>
	 * <li><code>abstract:</code> {boolean} (optional) flag that marks the class as abstract (purely informational, defaults to false)</li>
	 * <li><code>final:</code> {boolean} (optional) flag that marks the class as final (defaults to false)</li>
	 * </ul>
	 * Subclasses of sap.ui.base.Object can enrich the set of supported metadata (e.g. see {@link sap.ui.core.Element.extend}).
	 * </li>
	 *
	 * <li><code>constructor:</code> a function that serves as a constructor function for the new class.
	 * If no constructor function is given, the framework creates a default implementation that delegates all
	 * its arguments to the constructor function of the base class.
	 * </li>
	 *
	 * <li><i>any-other-name:</i> any other property in the <code>oClassInfo</code> is copied into the prototype
	 * object of the newly created class. Callers can thereby add methods or properties to all instances of the
	 * class. But be aware that the given values are shared between all instances of the class. Usually, it doesn't
	 * make sense to use primitive values here other than to declare public constants.
	 * </li>
	 *
	 * </ul>
	 *
	 * The prototype object of the newly created class uses the same prototype as instances of the base class
	 * (prototype chaining).
	 *
	 * A metadata object is always created, even if there is no <code>metadata</code> entry in the <code>oClassInfo</code>
	 * object. A getter for the metadata is always attached to the prototype and to the class (constructor function)
	 * itself.
	 *
	 * Last but not least, with the third argument <code>FNMetaImpl</code> the constructor of a metadata class
	 * can be specified. Instances of that class will be used to represent metadata for the newly created class
	 * and for any subclass created from it. Typically, only frameworks will use this parameter to enrich the
	 * metadata for a new class hierarchy they introduce (e.g. {@link sap.ui.core.Element.extend Element}).
	 *
	 * @param {string} sClassName name of the class to be created
	 * @param {object} [oClassInfo] structured object with informations about the class
	 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.base.Metadata.
	 * @return {function} the created class / constructor function
	 * @public
	 * @static
	 * @name sap.ui.base.Object.extend
	 * @function
	 * @since 1.3.1
	 */
	
	/**
	 * Creates metadata for a given class and attaches it to the constructor and prototype of that class.
	 *
	 * After creation, metadata can be retrieved with getMetadata().
	 *
	 * The static info can at least contain the following entries:
	 * <ul>
	 * <li>baseType: {string} fully qualified name of a base class or empty
	 * <li>publicMethods: {string} an array of method names that will be visible in the interface proxy returned by {@link #getInterface}
	 * </ul>
	 *
	 * @param {string} sClassName name of an (already declared) constructor function
	 * @param {object} oStaticInfo static info used to create the metadata object
	 * @param {string} oStaticInfo.baseType qualified name of a base class
	 * @param {string[]} oStaticInfo.publicMethods array of names of public methods
	 * @param {function} [xMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.base.Metadata.
	 *
	 * @return {sap.ui.base.Metadata} the created metadata object
	 * @public
	 * @static
	 * @deprecated Since 1.3.1. Use the static <code>extend</code> method of the desired base class (e.g. {@link sap.ui.base.Object.extend})
	 * @name sap.ui.base.Object.defineClass
	 * @function
	 */
	BaseObject.defineClass = function(sClassName, oStaticInfo, FNMetaImpl) {
		// create Metadata object
		var oMetadata = new (FNMetaImpl || Metadata)(sClassName, oStaticInfo);
		var fnClass = oMetadata.getClass();
		fnClass.getMetadata = fnClass.prototype.getMetadata = jQuery.sap.getter(oMetadata);
		// enrich function
		if ( !oMetadata.isFinal() ) {
			fnClass.extend = function(sSCName, oSCClassInfo, fnSCMetaImpl) {
				return Metadata.createClass(fnClass, sSCName, oSCClassInfo, fnSCMetaImpl || FNMetaImpl);
			};
		}
		jQuery.sap.log.debug("defined class '" + sClassName + "'" + (oMetadata.getParent() ? " as subclass of " + oMetadata.getParent().getName() : "") );
		return oMetadata;
	};
	

	return BaseObject;

}, /* bExport= */ true);

}; // end of sap/ui/base/Object.js
sap.ui.define("sap/ui/base/Event",['jquery.sap.global', './Object'],
	function(jQuery, BaseObject) {
	"use strict";


	/**
	 * Creates an event with the given sId, linked to the provided oSource and enriched with the mParameters.
	 *
	 * @param {string} sId The id of the event
	 * @param {sap.ui.base.EventProvider} oSource The source of the event
	 * @param {object} mParameters A map of parameters for this event
	 *
	 * @class An Event object consisting of an id, a source and a map of parameters
	 * @extends sap.ui.base.Object
	 * @implements sap.ui.base.Poolable
	 * @author Malte Wedel, Daniel Brinkmann
	 * @version 1.20.6
	 * @name sap.ui.base.Event
	 * @public
	 */
	var Event = BaseObject.extend("sap.ui.base.Event", /** @lends sap.ui.base.Event */ {
		constructor : function(sId, oSource, mParameters) {
		
			BaseObject.apply(this);
		
			if (arguments.length > 0) {
				this.init(sId, oSource, mParameters);
			}
		
		}
	});
	
	/**
	 * Init this event with its data.
	 *
	 * The <code>init</code> method is called by an object pool when the
	 * object is (re-)activated for a new caller.
	 *
	 * When no <code>mParameters</code> are given, an empty object is used instead.
	 *
	 * @param {string} sId The id of the event
	 * @param {sap.ui.base.EventProvider} oSource The source of the event
	 * @param {object} [mParameters] the event parameters
	 *
	 * @see sap.ui.base.Poolable.prototype#init
	 * @name sap.ui.base.Event#init
	 * @function
	 */
	Event.prototype.init = function(sId, oSource, mParameters) {
		jQuery.sap.assert(typeof sId === "string", "Event.init: sId must be a string");
		jQuery.sap.assert(oSource instanceof sap.ui.base.EventProvider, "Event.init: oSource must be an EventProvider");
	
		this.sId = sId;
		this.oSource = oSource;
		this.mParameters = mParameters || {};
		this.bCancelBubble = false;
		this.bPreventDefault = false;
	};
	
	/**
	 * Reset event data, needed for pooling
	 * @see sap.ui.base.Poolable.prototype#reset
	 * @name sap.ui.base.Event#reset
	 * @function
	 */
	Event.prototype.reset = function() {
		this.sId = "";
		this.oSource = null;
		this.mParameters = null;
		this.bCancelBubble = false;
		this.bPreventDefault = false;
	};
	
	/**
	 * Returns the id of the event
	 * @return {string} The id of the event
	 * @public
	 * @name sap.ui.base.Event#getId
	 * @function
	 */
	Event.prototype.getId = function() {
	
		return this.sId;
	
	};
	
	/**
	 * Returns the source of the event
	 * @return {sap.ui.base.EventProvider} The source of the event
	 * @public
	 * @name sap.ui.base.Event#getSource
	 * @function
	 */
	Event.prototype.getSource = function() {
	
		return this.oSource;
	
	};
	
	/**
	 * Returns all parameter values of the event keyed by their names.
	 * @return {map} All parameters of the event keyed by name
	 * @public
	 * @name sap.ui.base.Event#getParameters
	 * @function
	 */
	Event.prototype.getParameters = function() {
	
		return this.mParameters;
	
	};
	
	/**
	 * Returns the value of the parameter with the given sName.
	 *
	 * @param {string} sName the name of the parameter to return
	 * @return {any} the value for the named parameter
	 * @public
	 * @name sap.ui.base.Event#getParameter
	 * @function
	 */
	Event.prototype.getParameter = function(sName) {
	
		jQuery.sap.assert(typeof sName === "string" && sName, "Event.getParameter: sName must be a non-empty string");
	
		return this.mParameters[sName];
	
	};
	
	/**
	 * Cancel bubbling of the event.
	 * @public
	 * @name sap.ui.base.Event#cancelBubble
	 * @function
	 */
	Event.prototype.cancelBubble = function() {
	
		this.bCancelBubble = true;
	
	};
	
	/**
	 * Prevent the default action of this event.
	 * @public
	 * @name sap.ui.base.Event#preventDefault
	 * @function
	 */
	Event.prototype.preventDefault = function() {
	
		this.bPreventDefault = true;
	
	};
	
	

	return Event;

}, /* bExport= */ true);

}; // end of sap/ui/base/Event.js
if ( !jQuery.sap.isDeclared('sap.ui.base.ObjectPool') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.base.ObjectPool
jQuery.sap.declare('sap.ui.base.ObjectPool'); // unresolved dependency added by SAPUI5 CreateModule Ant-Task
sap.ui.define("sap/ui/base/ObjectPool",['jquery.sap.global', './Object'],
	function(jQuery, BaseObject) {
	"use strict";


	/**
	 * Creates an ObjectPool instance based on the given oObjectClass.&lt;br/&gt;
	 * If there is a free pooled instance, returns that one, otherwise creates a new one.&lt;br/&gt;
	 * In order to be maintained by the ObjectPool, oObjectClass must implement
	 * methods described in the class description.
	 *
	 * @param {function} oObjectClass constructor for the class of objects that this pool should manage
	 *
	 * @class Manages a pool of objects all of the same type;
	 * the type has to be specified at pool construction time.
	 *
	 * Maintains a list of free objects of the given type.
	 * If {@link sap.ui.base.ObjectPool.prototype.borrowObject} is called, an existing free object
	 * is taken from the pool and the <code>init</code> method is called on this
	 * object.
	 *
	 * When no longer needed, any borrowed object should be returned to
	 * the pool by calling {@link #returnObject}. At that point in time,
	 * the reset method is called on the object and the object is added to the
	 * list of free objects.
	 *
	 * See {@link sap.ui.base.Poolable} for a description of the contract for poolable objects.
	 *
	 * Example:
	 * <pre>
	 *   this.oEventPool = new sap.ui.base.ObjectPool(sap.ui.base.Event);
	 *   var oEvent = this.oEventPool.borrowObject(iEventId, mParameters);
	 * </pre>
	 *
	 * @extends sap.ui.base.Object
	 * @author Malte Wedel
	 * @version 1.20.6
	 * @constructor
	 * @name sap.ui.base.ObjectPool
	 * @public
	 */
	var ObjectPool = BaseObject.extend("sap.ui.base.ObjectPool", /** @lends sap.ui.base.ObjectPool */ {
		constructor: function(oObjectClass) {
		
			BaseObject.apply(this);
		
			this.oObjectClass = oObjectClass;
		
			this.aFreeObjects = [];
		//	this.aUsedObjects = []; //PERFOPT: Holding those is currently senseless.
		
		}
	});
	
	/**
	 * Borrows a free object from the pool. Any arguments to this method
	 * are forwarded to the init method of the borrowed object.
	 *
	 * @param {any} [any] optional initialization parameters for the borrowed object
	 * @return {object} the borrowed object of the same type that has been specified for this pool
	 * @public
	 * @name sap.ui.base.ObjectPool#borrowObject
	 * @function
	 */
	ObjectPool.prototype.borrowObject = function() {
	
		// PERFOPT: Reduced callstack
		var oObject = this.aFreeObjects.length == 0 ?
				new this.oObjectClass() :
					this.aFreeObjects.pop();
		oObject.init.apply(oObject, arguments);
	//	this.aUsedObjects.push(oObject); //PERFOPT: Holding those is currently senseless.
	
		return oObject;
	};
	
	/**
	 * Returns an object to the pool. The object must have been borrowed from this
	 * pool beforehand. The reset method is called on the object before it is added
	 * to the set of free objects.
	 *
	 * @param {object} the object to return to the pool
	 * @public
	 * @name sap.ui.base.ObjectPool#returnObject
	 * @function
	 */
	ObjectPool.prototype.returnObject = function(oObject) {
	
		oObject.reset();
		// If the next line is ever activated again, ensure not simply the topmost object is poped but the one returned!!
	//	this.aUsedObjects.pop(); //PERFOPT: Holding those is currently senseless.
		this.aFreeObjects.push(oObject);
	
	};
	
	
	/**
	 * Poolable objects must provide a no-arg constructor which is used by the pool
	 * to construct new, unused objects.
	 *
	 * To be more convenient to use, poolable objects should implement their constructor
	 * in a way that it either can be called with no arguments (used by the pool) or
	 * with the same signature as their {@link #init} method (to be used by applications).
	 *
	 * @name sap.ui.base.Poolable
	 * @interface Contract for objects that can be pooled by ObjectPool
	 * @constructor
	 * @public
	 */
	
	/**
	 * Called by the object pool when this instance will be actived for a caller.
	 * The same method will be called after a new instance has been created by an otherwise
	 * exhausted pool.
	 *
	 * If the caller provided any arguments to {@link sap.ui.base.ObjectPool#borrowObject}
	 * all arguments will be propagated to this method.
	 *
	 * @name sap.ui.base.Poolable.prototype.init
	 * @function
	 * @public
	 */
	
	/**
	 * Called by the object pool when an instance is returned to the pool.
	 * While no specific implementation is required, poolable objects in general
	 * should clean all caller specific state (set to null) in this method to
	 * avoid memory leaks and to enforce garbage collection of the caller state.
	 *
	 * @name sap.ui.base.Poolable.prototype.reset
	 * @function
	 * @public
	 */

	return ObjectPool;

}, /* bExport= */ true);

}; // end of sap/ui/base/ObjectPool.js
sap.ui.define("sap/ui/base/EventProvider",['jquery.sap.global', './Event', './Object', './ObjectPool'],
	function(jQuery, Event, BaseObject, ObjectPool) {
	"use strict";


	/**
	 * Creates an instance of EventProvider.
	 * @class Provides internal eventing facilities for objects, so other objects can attach
	 * and detach events, and are notified, when events are fired
	 *
	 * @abstract
	 * @extends sap.ui.base.Object
	 * @author Malte Wedel, Daniel Brinkmann
	 * @version 1.20.6
	 * @constructor
	 * @public
	 * @name sap.ui.base.EventProvider
	 */
	var EventProvider = BaseObject.extend("sap.ui.base.EventProvider", /* @lends sap.ui.base.EventProvider */ {
	
		constructor : function() {
	
			BaseObject.apply(this);
	
			/**
			 * A map of arrays of event registrations keyed by the event names
			 * @private
			 */
			this.mEventRegistry = {};
	
		}
	
	});
	
	/**
	 * Map of event names and ids, that are provided by this class
	 * @private
	 * @static
	 * @name sap.ui.base.EventProvider.M_EVENTS
	 */
	EventProvider.M_EVENTS = {EventHandlerChange:"EventHandlerChange"};
	
	/**
	 * Pool is defined on the prototype to be shared among all EventProviders
	 * @private
	 * @name sap.ui.base.EventProvider#oEventPool
	 */
	EventProvider.prototype.oEventPool = new ObjectPool(Event);
	
	/**
	 * Adds an event registration for the given object and given event name
	 *
	 * @param {string}
	 *            sEventId The identifier of the event to listen for
	 * @param {object}
	 *            [oData] The object, that should be passed along with the event-object when firing the event
	 * @param {function}
	 *            fnFunction The function to call, when the event occurs. This function will be called on the
	 *            oListener-instance (if present) or on the event provider-instance
	 * @param {object}
	 *            [oListener] The object, that wants to be notified, when the event occurs
	 * @return {sap.ui.base.EventProvider} Returns <code>this</code> to allow method chaining
	 * @public
	 * @name sap.ui.base.EventProvider#attachEvent
	 * @function
	 */
	EventProvider.prototype.attachEvent = function(sEventId, oData, fnFunction, oListener) {
		jQuery.sap.assert(typeof(sEventId) === "string" && sEventId, "EventProvider.attachEvent: sEventId must be a non-empty string");
		if(typeof(oData) === "function") {
		//one could also increase the check in the line above
		//if(typeof(oData) === "function" && oListener === undefined) {
			oListener = fnFunction;
			fnFunction = oData;
			oData = undefined;
		}
		jQuery.sap.assert(typeof(fnFunction) === "function", "EventProvider.attachEvent: fnFunction must be a function");
		jQuery.sap.assert(!oListener || typeof(oListener) === "object", "EventProvider.attachEvent: oListener must be empty or an object");
	
		if (!this.mEventRegistry[sEventId]) {
			this.mEventRegistry[sEventId] = [];
		}
		this.mEventRegistry[sEventId].push({oListener:oListener, fFunction:fnFunction, oData: oData});
	
		// Inform interested parties about changed EventHandlers
		this.fireEvent(EventProvider.M_EVENTS.EventHandlerChange, {EventId: sEventId, type: 'listenerAttached'});
	
		return this;
	};
	
	/**
	 * Adds a one time event registration for the given object and given event name. When the event occurs, the handler function is called and removed
	 * from registration.
	 *
	 * @param {string}
	 *            sEventId The identifier of the event to listen for
	 * @param {object}
	 *            [oData] The object, that should be passed along with the event-object when firing the event
	 * @param {function}
	 *            fnFunction The function to call, when the event occurs. This function will be called on the
	 *            oListener-instance (if present) or on the event provider-instance
	 * @param {object}
	 *            [oListener] The object, that wants to be notified, when the event occurs
	 * @return {sap.ui.base.EventProvider} Returns <code>this</code> to allow method chaining
	 * @public
	 * @name sap.ui.base.EventProvider#attachEventOnce
	 * @function
	 */
	EventProvider.prototype.attachEventOnce = function(sEventId, oData, fnFunction, oListener) {
		if(typeof(oData) === "function") {
			oListener = fnFunction;
			fnFunction = oData;
			oData = undefined;
		}
		function fnOnce() { 
			this.detachEvent(sEventId, fnOnce);  // ‘this’ is always the control, due to the context ‘undefined’ in the attach call below
			fnFunction.apply(oListener || this, arguments);  // needs to do the same resolution as in fireEvent
		}
		this.attachEvent(sEventId, oData, fnOnce, undefined);  // a listener of ‘undefined’ enforce a context of ‘this’ even after clone
		return this;
	};
	
	/**
	 * Removes an event registration for the given object and given event name.
	 *
	 * The passed parameters must match those used for registration with {@link #attachEvent } beforehand!
	 *
	 * @param {string}
	 *            sEventId The identifier of the event to detach from
	 * @param {function}
	 *            fnFunction The function to call, when the event occurs.
	 * @param {object}
	 *            [oListener] The object, that wants to be notified, when the event occurs
	 * @return {sap.ui.base.EventProvider} Returns <code>this</code> to allow method chaining
	 * @public
	 * @name sap.ui.base.EventProvider#detachEvent
	 * @function
	 */
	EventProvider.prototype.detachEvent = function(sEventId, fnFunction, oListener) {
		jQuery.sap.assert(typeof(sEventId) === "string" && sEventId, "EventProvider.detachEvent: sEventId must be a non-empty string" );
		jQuery.sap.assert(typeof(fnFunction) === "function", "EventProvider.detachEvent: fnFunction must be a function");
		jQuery.sap.assert(!oListener || typeof(oListener) === "object", "EventProvider.detachEvent: oListener must be empty or an object");
	
		var aEventListeners = this.mEventRegistry[sEventId];
		if (!aEventListeners) {
			return this;
		}
		
		var bListenerDetached = false;
		
		//PERFOPT use array. remember length to not re-calculate over and over again
		for (var i = 0, iL = aEventListeners.length; i < iL; i++) {
			//PERFOPT check for identity instead of equality... avoid type conversion
			if (aEventListeners[i].fFunction === fnFunction && aEventListeners[i].oListener === oListener) {
				//delete aEventListeners[i];
				aEventListeners.splice(i,1);
				bListenerDetached = true;
				break;
			}
		}
		// If we just deleted the last registered EventHandler, remove the whole entry from our map.
		if(aEventListeners.length == 0) {
			delete this.mEventRegistry[sEventId];
		}
	
		if(bListenerDetached){
			// Inform interested parties about changed EventHandlers
			this.fireEvent(EventProvider.M_EVENTS.EventHandlerChange, {EventId: sEventId, type: 'listenerDetached' });
		}
	
		return this;
	};
	
	/**
	 * Fires the given event and notifies all listeners. Listeners must not change
	 * the content of the event.
	 *
	 * @param {string} sEventId the event id
	 * @param {object} [mParameters] the parameter map
	 * @param {boolean} [bAllowPreventDefault] whether prevent default is allowed
	 * @param {boolean} [bEnableEventBubbling] whether event bubbling is enabled
	 * @return {sap.ui.base.EventProvider|boolean} Returns <code>this</code> to allow method chaining or
	 *		   whether the default action should be executed, when bAllowPreventDefault has been set to true
	 * @protected
	 * @name sap.ui.base.EventProvider#fireEvent
	 * @function
	 */
	EventProvider.prototype.fireEvent = function(sEventId, mParameters, bAllowPreventDefault, bEnableEventBubbling) {
		// at least in BrowserEventManager when firing events of its E_EVENTS enumeration, the type will be an integer... thus avoid this check
		//	jQuery.sap.assert(typeof (sEventId) == "string");
	
		// get optional parameters right
		if (typeof mParameters == "boolean") {
			bEnableEventBubbling = bAllowPreventDefault;
			bAllowPreventDefault = mParameters;
		}
	
		var aEventListeners = this.mEventRegistry[sEventId],
			bPreventDefault = false,
			oEvent, oParent, oInfo;
	
		if (bEnableEventBubbling || (aEventListeners && jQuery.isArray(aEventListeners))) {
	
			// this ensures no 'concurrent modification exception' occurs (e.g. an event listener deregisters itself).
			aEventListeners = aEventListeners ? aEventListeners.slice() : [];
	
			oEvent = this.oEventPool.borrowObject(sEventId, this, mParameters);
	
			//PERFOPT use array. remember length to not re-calculate over and over again
			for (var i = 0, iL = aEventListeners.length; i < iL; i++) {
				oInfo = aEventListeners[i];
				oInfo.fFunction.call(oInfo.oListener || this, oEvent, oInfo.oData);
			}
	
			// In case this is a bubbling event and object has a getParent method, also fire on parents
			if (bEnableEventBubbling) {
				oParent = this.getEventingParent();
				while (oParent && !oEvent.bCancelBubble) {
					aEventListeners = oParent.mEventRegistry[sEventId];
					if (aEventListeners && aEventListeners instanceof Array) {
						aEventListeners = aEventListeners.slice();
						for (var i = 0, iL = aEventListeners.length; i < iL; i++) {
							oInfo = aEventListeners[i];
							oInfo.fFunction.call(oInfo.oListener || oParent, oEvent, oInfo.oData);
						}
					}
					oParent = oParent.getEventingParent();
				}
			}
	
			// Store prevent default state, before returning event to the pool
			bPreventDefault = oEvent.bPreventDefault;
	
			this.oEventPool.returnObject(oEvent);
		}
	
		// Only return prevent default result in case it has been enabled, for compatibility
		if (bAllowPreventDefault) {
			return !bPreventDefault;
		}
		else {
			return this;
		}
	};
	
	/**
	 * Returns whether there are any listeners for the given event ID.
	 *
	 * @param {string} sEventId the ID of the event
	 * @return {boolean} whether there are any listeners
	 * @private
	 * @name sap.ui.base.EventProvider#hasListeners
	 * @function
	 */
	EventProvider.prototype.hasListeners = function(sEventId) {
		return !!this.mEventRegistry[sEventId];
	};
	
	/**
	 * Returns the list of events currently having listeners attached.
	 *
	 * Introduced for lightspeed support to ensure that only relevant events are attached to the LS-world.
	 *
	 * This is a static method to avoid the pollution of the Element/Control namespace.
	 * As the callers are limited and known and for performance reasons the internal event registry
	 * is returned. It contains more information than necessary, but needs no expensive conversion.
	 *
	 * @return {object} the list of events currently having listeners attached
	 * @private
	 * @static
	 * @name sap.ui.base.EventProvider.getEventList
	 * @function
	 */
	EventProvider.getEventList = function(oEventProvider) {
		return oEventProvider.mEventRegistry;
	};
	
	/**
	 * Returns the parent in the eventing hierarchy of this object.
	 *
	 * Per default this returns null, but if eventing is used in objects, which are hierarchically
	 * structured, this can be overwritten to make the object hierarchy visible to the eventing and
	 * enables the use of event bubbling within this object hierarchy.
	 *
	 * @return {sap.ui.base.EventProvider} the parent event provider
	 * @protected
	 * @name sap.ui.base.EventProvider#getEventingParent
	 * @function
	 */
	EventProvider.prototype.getEventingParent = function() {
		return null;
	};
	
	/**
	 * Returns a string representation of this object.
	 *
	 * In case there is no class or id information, a simple static string is returned.
	 * Subclasses should override this method.
	 *
	 * @return {string} a string description of this eventProvider
	 * @public
	 * @name sap.ui.base.EventProvider#toString
	 * @function
	 */
	EventProvider.prototype.toString = function() {
		if ( this.getMetadata ) {
			return "EventProvider " + this.getMetadata().getName();
		}
		else {
			return "EventProvider";
		}
	};
	
	
	/**
	 * @see sap.ui.base.Object.prototype.destroy
	 * @public
	 * @name sap.ui.base.EventProvider#destroy
	 * @function
	 */
	EventProvider.prototype.destroy = function() {
		this.mEventRegistry = {};
		BaseObject.prototype.destroy.apply(this, arguments);
	};
	

	return EventProvider;

}, /* bExport= */ true);

}; // end of sap/ui/base/EventProvider.js
if ( !jQuery.sap.isDeclared('sap.ui.core.Component') ) {
/*
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides base class sap.ui.core.Component for all components
jQuery.sap.declare('sap.ui.core.Component'); // unresolved dependency added by SAPUI5 CreateModule Ant-Task
if ( !jQuery.sap.isDeclared('sap.ui.base.ManagedObject') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides the base class for all objects with managed properties and aggregations.
jQuery.sap.declare('sap.ui.base.ManagedObject'); // unresolved dependency added by SAPUI5 CreateModule Ant-Task
if ( !jQuery.sap.isDeclared('sap.ui.base.BindingParser') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides static class sap.ui.base.BindingParser
jQuery.sap.declare('sap.ui.base.BindingParser'); // unresolved dependency added by SAPUI5 CreateModule Ant-Task
sap.ui.define("sap/ui/base/BindingParser",['jquery.sap.global', 'jquery.sap.script'],
	function(jQuery/* , jQuerySap */) {
	"use strict";

	/**
	 * Regular expression to check for a (new) object literal
	 */
	var rObject = /^\{\s*[a-zA-Z_][a-zA-Z0-9_]*\s*:/;
	
	/**
	 * Regular expression to split the binding string into hard coded string fragments and embedded bindings.
	 * 
	 * Also handles escaping of '{' and '}'.
	 */
	var rFragments = /(\\[\\\{\}])|(\{)/g;

	/**
	 * Regular expression to escape potential binding chars
	 */
	var rBindingChars = /([\\\{\}])/g;
	
	/**
	 * Helper to create a formatter function. Only used to reduce the closure size of the formatter
	 */
	function makeFormatter(aFragments) {
		var fnFormatter = function(aValues) {
			var aResult = [],
				l=aFragments.length,
				i;
			
			for(i=0; i<l; i++) {
				if ( typeof aFragments[i] === "number" ) {
					// a numerical fragment references the part with the same number 
					aResult.push(arguments[aFragments[i]])
				} else {
					// anything else is a string fragment 
					aResult.push(aFragments[i]);
				}
			}
			return aResult.join('');
		};
		fnFormatter.textFragments = aFragments;
		return fnFormatter;
	}

	/**
	 * Creates a binding info object with the given path. 
	 * 
	 * If the path contains a model specifier (prefix separated with a '>'),
	 * the <code>model</code> property is set as well and the prefix is 
	 * removed from the path. 
	 */
	function makeSimpleBindingInfo(sPath) {
		var iPos = sPath.indexOf(">"),
			oBindingInfo = { path : sPath };
		
		if ( iPos > 0 ) {
			oBindingInfo.model = sPath.slice(0,iPos);
			oBindingInfo.path = sPath.slice(iPos+1);
		}
		
		return oBindingInfo;
	}
	
	/**
	 * @static
	 * @namespace
	 * @name sap.ui.base.BindingParser
	 */
	var BindingParser = {};
	
	BindingParser._keepBindingStrings = false;
	
	BindingParser.simpleParser = function(sString, oContext) {

		if ( jQuery.sap.startsWith(sString, "{") && jQuery.sap.endsWith(sString, "}") ) {
			return makeSimpleBindingInfo(sString.slice(1,-1));
		}
	
	};
	
	BindingParser.simpleParser.escape = function(sValue) {
		// there was no escaping defined for the simple parser
		return sValue;
	};
	
	BindingParser.complexParser = function(sString, oContext, bUnescape) {
		var parseObject=jQuery.sap.parseJS,
			oBindingInfo = {parts:[]},
			aFragments=[],
			bUnescaped,
			oParseResult,
			p=0,
			m,end;

		function resolveRef(o,sProp) {
			if ( typeof o[sProp] === "string" ) {
				if ( jQuery.sap.startsWith(o[sProp], ".") ) {
					o[sProp] = jQuery.proxy(jQuery.sap.getObject(o[sProp].slice(1), undefined, oContext), oContext);
				} else {
					o[sProp] = jQuery.sap.getObject(o[sProp]);
				} 
			}
		}

		function resolveType(o,sProp) {
			var FNType;
			if ( typeof o[sProp] === "string" ) {
				if ( jQuery.sap.startsWith(o[sProp], ".") ) {
					FNType = jQuery.sap.getObject(o[sProp].slice(1), undefined, oContext);
				} else {
					FNType = jQuery.sap.getObject(o[sProp]);
				} 
				// TODO find another solution for the type parameters?
				if (typeof FNType === "function") {
					o[sProp] = new FNType(o.formatOptions, o.constraints);
				} else {
					o[sProp] = FNType;
				}
				delete o.formatOptions;
				delete o.constraints;
			}
		}

		function resolveObject(o,sProp, sParentProp) {
			var FNType;
			if (!(typeof o[sProp] === "object" || jQuery.isArray(o[sProp]))) {
				return;
			}
			if (jQuery.isArray(o[sProp])) {
				jQuery.each(o[sProp], function(iIndex, oObject) {
					resolveObject(o[sProp], iIndex, sProp);
				});
			} else {
				if (sProp === "filters" || sParentProp === "filters") {
					FNType = jQuery.sap.getObject("sap.ui.model.Filter");
				} else if (sProp === "sorter" || sParentProp === "sorter") {
					FNType = jQuery.sap.getObject("sap.ui.model.Sorter");
					resolveRef(o[sProp], "group");
				}
				if (FNType) {
					o[sProp] = new FNType(o[sProp]);
				}
			}
		}

		while ( m=rFragments.exec(sString) ) {
			
			// check for a skipped literal string fragment  
			if ( p < m.index ) {
				aFragments.push(sString.slice(p, m.index));
			}
			
			// handle the different kinds of matches
			if ( m[1] ) {
				
				// an escaped opening bracket, closing bracket or backslash
				aFragments.push(m[1].slice(1));
				bUnescaped = true;
				
			} else { 
				
				// an embedded binding: check for a property name that would indicate a complex object 
				if ( rObject.test(sString.slice(m.index)) ) {
					
					oParseResult = parseObject(sString, m.index);
					resolveType(oParseResult.result,'type');
					resolveObject(oParseResult.result,'filters');
					resolveObject(oParseResult.result,'sorter');
					resolveRef(oParseResult.result,'formatter');
					resolveRef(oParseResult.result,'factory'); // list binding
					aFragments.push(oBindingInfo.parts.length);
					oBindingInfo.parts.push(oParseResult.result);
					rFragments.lastIndex = oParseResult.at;
					
				} else {
					
					// otherwise it must be a simple binding (path only)
					
					// TODO find closing brace via regex as well?
					end = sString.indexOf('}', m.index);
					if ( end < m.index ) {
						throw new SyntaxError("no closing braces found in '" + sString + "' after pos:" + m.index);
					}
					
					aFragments.push(oBindingInfo.parts.length);
					oBindingInfo.parts.push(makeSimpleBindingInfo(sString.slice(m.index+1, end)));
					rFragments.lastIndex = end+1;
					
				}
			}
			
			// remember where we are
			p = rFragments.lastIndex;
		}
		
		// check for a trailing literal string fragment  
		if ( p < sString.length ) {
			aFragments.push(sString.slice(p));
		}

		// only if a part has been found we can return a binding info
		if (oBindingInfo.parts.length > 0) {
			if ( aFragments.length === 1 /* implies: && typeof aFragments[0] === "number" */ ) {
				// special case: a single binding only
				oBindingInfo = oBindingInfo.parts[0];
			} else /* if ( aFragments.length > 1 ) */ {
				// create the formatter function from the fragments
				oBindingInfo.formatter = makeFormatter(aFragments);
			}
			if (BindingParser._keepBindingStrings) {
				oBindingInfo.bindingString = sString;
			}
			return oBindingInfo;
		} else if ( bUnescape && bUnescaped ) {
			return aFragments.join('');
		}
		
	};

	BindingParser.complexParser.escape = function(sValue) {
		return sValue.replace(rBindingChars, "\\$1");
	};
	
	return BindingParser;

}, /* bExport= */ true);

}; // end of sap/ui/base/BindingParser.js
if ( !jQuery.sap.isDeclared('sap.ui.base.ManagedObjectMetadata') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.base.ManagedObjectMetadata
jQuery.sap.declare('sap.ui.base.ManagedObjectMetadata'); // unresolved dependency added by SAPUI5 CreateModule Ant-Task
sap.ui.define("sap/ui/base/ManagedObjectMetadata",['jquery.sap.global', './DataType', './Metadata'],
	function(jQuery, DataType, Metadata) {
	"use strict";


	/**
	 * Creates a new metadata object for a Element subclass.
	 *
	 * @param {string} sClassName fully qualified name of the class that is described by this metadata object
	 * @param {object} oStaticInfo static info to construct the metadata from
	 *
	 * @class
	 * @author Frank Weigel
	 * @version 1.20.6
	 * @since 0.8.6
	 * @name sap.ui.base.ManagedObjectMetadata
	 */
	var ManagedObjectMetadata = function(sClassName, oClassInfo) {
	
		// call super constructor
		Metadata.apply(this, arguments);
	
	};
	
	//chain the prototypes
	ManagedObjectMetadata.prototype = jQuery.sap.newObject(Metadata.prototype);
	
	/**
	 * @private
	 * @name sap.ui.base.ManagedObjectMetadata#applySettings
	 * @function
	 */
	ManagedObjectMetadata.prototype.applySettings = function(oClassInfo) {
	
		var oStaticInfo = oClassInfo.metadata;
	
		Metadata.prototype.applySettings.call(this, oClassInfo);
	
		var rPlural = /(children|ies|ves|oes|ses|ches|shes|xes|s)$/i;
		var mSingular = {'children' : -3, 'ies' : 'y', 'ves' : 'f', 'oes' : -2, 'ses' : -2, 'ches' : -2, 'shes' : -2, 'xes' : -2, 's' : -1 };
	
		function normalize(mInfoMap, sDefaultName, oDefaultValues) {
			var sName,oInfo;
			mInfoMap = mInfoMap || {};
			for(sName in mInfoMap) {
				oInfo = mInfoMap[sName];
				// if settings are not an object literal and if there is a default setting, set it
				if ( sDefaultName && typeof oInfo !== "object" ) {
					oInfo = {};
					oInfo[sDefaultName] = mInfoMap[sName];
				}
				oInfo = jQuery.extend({}, oDefaultValues, oInfo);
				oInfo.name = sName;
				// if info contains a multiple flag but no singular name, calculate one
				if ( oInfo.multiple === true && !oInfo.singularName) {
					oInfo.singularName = sName.replace(rPlural, function($,sPlural) {
						var vRepl = mSingular[sPlural.toLowerCase()];
						return typeof vRepl === "string" ? vRepl : sPlural.slice(0,vRepl);
					});
				}
				mInfoMap[sName] = oInfo;
			}
			return mInfoMap;
		}
	
		function filter(mInfoMap, bPublic) {
			var mResult={},sName;
			for(sName in mInfoMap) {
				if ( bPublic === (mInfoMap[sName].visibility === 'public') ) {
					mResult[sName] = mInfoMap[sName];
				}
			}
			return mResult;
		}
		
		var rLibName = /([a-z][^.]*(?:\.[a-z][^.]*)*)\./;
	
		function defaultLibName(sName) {
		  var m = rLibName.exec(sName);
		  return (m && m[1]) || "";
		}
	
		// init basic metadata from static infos and fallback to defaults
		this._sLibraryName = oStaticInfo.library || defaultLibName(this.getName());
		this._mProperties = normalize(oStaticInfo.properties, "type", { type : "string", group : "Misc" });
		var mAllAggregations = normalize(oStaticInfo.aggregations, "type", { type : "sap.ui.core.Control", multiple : true, visibility : 'public' });
		this._mAggregations = filter(mAllAggregations, true);
		this._mPrivateAggregations = filter(mAllAggregations, false);
		this._sDefaultAggregation = oStaticInfo.defaultAggregation || null;
		this._mAssociations = normalize(oStaticInfo.associations, "type", { type : "sap.ui.core.Control", multiple : false});
		this._mEvents = normalize(oStaticInfo.events, /* no default setting */ null, { allowPreventDefault : false });
	
		this._bEnriched = false;
	
		if ( oClassInfo.metadata.__version > 1.0 ) {
			this.generateAccessors();
		}
	
	};
	
	/**
	 * @private
	 * @name sap.ui.base.ManagedObjectMetadata#afterApplySettings
	 * @function
	 */
	ManagedObjectMetadata.prototype.afterApplySettings = function() {
	
		Metadata.prototype.afterApplySettings.call(this);
	
		// if there is a parent class, produce the flattened "all" views for the element specific metadata
		// PERFOPT: this could be done lazily
		var oParent = this.getParent();
		if ( oParent && oParent instanceof ManagedObjectMetadata ) {
			this._mAllEvents = jQuery.extend({},oParent._mAllEvents, this._mEvents);
			this._mAllProperties = jQuery.extend({},oParent._mAllProperties, this._mProperties);
			this._mAllPrivateAggregations = jQuery.extend({},oParent._mAllPrivateAggregations, this._mPrivateAggregations);
			this._mAllAggregations = jQuery.extend({},oParent._mAllAggregations, this._mAggregations);
			this._mAllAssociations = jQuery.extend({},oParent._mAllAssociations, this._mAssociations);
			this._sDefaultAggregation = this._sDefaultAggregation || oParent._sDefaultAggregation;
			if ( oParent._mHiddenAggregations ) {
			  this._mHiddenAggregations = jQuery.extend({},oParent._mHiddenAggregations);
			}
		} else {
			this._mAllEvents = this._mEvents;
			this._mAllProperties = this._mProperties;
			this._mAllPrivateAggregations = this._mPrivateAggregations;
			this._mAllAggregations = this._mAggregations;
			this._mAllAssociations = this._mAssociations;
		}
	
	};
	
	ManagedObjectMetadata.Kind = {
	  PROPERTY :0, SINGLE_AGGREGATION : 1, MULTIPLE_AGGREGATION : 2, SINGLE_ASSOCIATION : 3, MULTIPLE_ASSOCIATION : 4, EVENT : 5
	};
	
	
	/**
	 * Returns the name of the library that contains the described UIElement.
	 * @return {string} the name of the library
	 * @public
	 * @name sap.ui.base.ManagedObjectMetadata#getLibraryName
	 * @function
	 */
	ManagedObjectMetadata.prototype.getLibraryName = function() {
		return this._sLibraryName;
	};
	
	/**
	 * Returns whether the class/control is abstract
	 * @return {boolean} whether the class/control is abstract
	 * @public
	 * @name sap.ui.base.ManagedObjectMetadata#isAbstract
	 * @function
	 */
	ManagedObjectMetadata.prototype.isAbstract = function() {
		return this._bAbstract;
	};
	
	/**
	 * Declares an additional property for the UIElement class described by this metadata.
	 *
	 * Any property declaration via this method must happen before the described class
	 * is subclassed, or the added property will not be visible in the subclass.
	 *
	 * Typically used to enrich UIElement classes in an aspect oriented manner.
	 * @param {string} sName name of the property to add
	 * @param {object} oInfo metadata for the property
	 * @public
	 * @see sap.ui.core.EnabledPropagator
	 * @name sap.ui.base.ManagedObjectMetadata#addProperty
	 * @function
	 */
	ManagedObjectMetadata.prototype.addProperty = function(sName, oInfo) {
		oInfo.name = sName;
		this._mProperties[sName] = oInfo;
		if(!this._mAllProperties[sName]) {// ensure extended AllProperties meta-data is also enriched
			this._mAllProperties[sName] = oInfo;
		}
	
		if ( this._bEnriched ) { // does not seem right! this is the 'drop out' condition for _enrichChildInfos() -> senseless
			this._enrichChildInfos();
		}
		// TODO notify listeners (subclasses) about change
	};
	
	/**
	 * Checks the existance of the given property by its name
	 * @param {string} sName name of the property
	 * @return {boolean} true, if the property exists
	 * @public
	 * @name sap.ui.base.ManagedObjectMetadata#hasProperty
	 * @function
	 */
	ManagedObjectMetadata.prototype.hasProperty = function(sName) {
		return !!this._mAllProperties[sName];
	};
	
	/**
	 * Returns infos about the properties declared by the UIElement class
	 * described by this metadata object. Properties from ancestor classes
	 * are not returned.
	 *
	 * The returned map contains property info objects keyed by the property name.
	 *
	 * @return {map} Map of property infos keyed by property names
	 * @public
	 * @name sap.ui.base.ManagedObjectMetadata#getProperties
	 * @function
	 */
	ManagedObjectMetadata.prototype.getProperties = function() {
		return this._mProperties;
	};
	
	/**
	 * Returns infos about all properties declared by the UIElement class
	 * described by this metadata object as well as properties from base classes.
	 *
	 * The returned map contains property info objects keyed by the property name.
	 *
	 * @return {map} Map of property infos keyed by property names
	 * @public
	 * @name sap.ui.base.ManagedObjectMetadata#getAllProperties
	 * @function
	 */
	ManagedObjectMetadata.prototype.getAllProperties = function() {
		return this._mAllProperties;
	};
	
	/**
	 * Returns infos about the public aggregations declared by the UIElement class
	 * described by this metadata object. Aggregations from ancestor classes
	 * are not returned.
	 *
	 * The returned map contains aggregation info objects keyed by the aggregation name.
	 * In case of 0..1 aggregations this is the singular name, otherwise it is the plural
	 * name.
	 *
	 * @return {map} Map of aggregation infos keyed by aggregation names
	 * @public
	 * @name sap.ui.base.ManagedObjectMetadata#getAggregations
	 * @function
	 */
	ManagedObjectMetadata.prototype.getAggregations = function() {
		return this._mAggregations;
	};
	
	/**
	 * Checks the existance of the given aggregation by its name
	 * @param {string} sName name of the aggregation
	 * @return {boolean} true, if the aggregation exists
	 * @public
	 * @name sap.ui.base.ManagedObjectMetadata#hasAggregation
	 * @function
	 */
	ManagedObjectMetadata.prototype.hasAggregation = function(sName) {
		return !!this._mAllAggregations[sName];
	};
	
	/**
	 * Returns infos about all public aggregations declared by the UIElement class
	 * described by this metadata object as well as public aggregations from base classes.
	 *
	 * The returned map contains aggregation info objects keyed by the aggregation name.
	 * In case of 0..1 aggregations this is the singular name, otherwise it is the plural
	 * name.
	 *
	 * @return {map} Map of aggregation infos keyed by aggregation names
	 * @public
	 * @name sap.ui.base.ManagedObjectMetadata#getAllAggregations
	 * @function
	 */
	ManagedObjectMetadata.prototype.getAllAggregations = function() {
		return this._mAllAggregations;
	};
	
	/**
	 * Returns infos about all private (hidden) aggregations declared by the UIElement class
	 * described by this metadata object as well as private aggregations from base classes.
	 *
	 * The returned map contains aggregation info objects keyed by the aggregation name.
	 * In case of 0..1 aggregations this is the singular name, otherwise it is the plural
	 * name.
	 *
	 * @return {map} Map of aggregation infos keyed by aggregation names
	 * @protected
	 * @name sap.ui.base.ManagedObjectMetadata#getAllPrivateAggregations
	 * @function
	 */
	ManagedObjectMetadata.prototype.getAllPrivateAggregations = function() {
		return this._mAllPrivateAggregations;
	};
	
	/**
	 * Returns the info object for a public or private aggregation declared by the described 
	 * ManagedObject class or by any of its ancestors.
	 *
	 * @param {string} sAggregationName name of the aggregation to be retrieved 
	 * @return {object} aggregation info or null
	 * @protected
	 * @name sap.ui.base.ManagedObjectMetadata#getManagedAggregation
	 * @function
	 */
	ManagedObjectMetadata.prototype.getManagedAggregation = function(sAggregationName) {
		return this._mAllAggregations[sAggregationName] || this._mAllPrivateAggregations[sAggregationName] 
	};
	
	/**
	 * Returns the name of the default aggregation of this control.
	 * If the control itself does not define a default aggregation, then the
	 * default aggregation of the parent is returned. If no control in the
	 * hierarchy defines a default aggregation, null is returned.
	 *
	 * @return {string} Name of the default aggregation for this class
	 * @name sap.ui.base.ManagedObjectMetadata#getDefaultAggregationName
	 * @function
	 */
	ManagedObjectMetadata.prototype.getDefaultAggregationName = function() {
		return this._sDefaultAggregation;
	};
	
	/**
	 * Returns the name of the default aggregation of this control.
	 * If the control itself does not define a default aggregation, then the
	 * default aggregation of the parent is returned.
	 *
	 * @return {string} Name of the default aggregation for this class
	 * @name sap.ui.base.ManagedObjectMetadata#getDefaultAggregation
	 * @function
	 */
	ManagedObjectMetadata.prototype.getDefaultAggregation = function() {
		return this._sDefaultAggregation && this.getAllAggregations()[this._sDefaultAggregation];
	};
	
	/**
	 * Returns infos about the associations declared by the UIElement class
	 * described by this metadata object. Associations from ancestor classes
	 * are not returned.
	 *
	 * The returned map contains association info objects keyed by the association name.
	 * In case of 0..1 associations this is the singular name, otherwise it is the plural
	 * name.
	 *
	 * @return {map} Map of association infos keyed by association names
	 * @public
	 * @name sap.ui.base.ManagedObjectMetadata#getAssociations
	 * @function
	 */
	ManagedObjectMetadata.prototype.getAssociations = function() {
		return this._mAssociations;
	};
	
	/**
	 * Checks the existance of the given association by its name
	 * @param {string} sName name of the association
	 * @return {boolean} true, if the association exists
	 * @public
	 * @name sap.ui.base.ManagedObjectMetadata#hasAssociation
	 * @function
	 */
	ManagedObjectMetadata.prototype.hasAssociation = function(sName) {
		return !!this._mAllAssociations[sName];
	};
	
	/**
	 * Returns infos about all associations declared by the UIElement class
	 * described by this metadata object as well as associations from base classes.
	 *
	 * The returned map contains association info objects keyed by the association name.
	 * In case of 0..1 associations this is the singular name, otherwise it is the plural
	 * name.
	 *
	 * @return {map} Map of association infos keyed by association names
	 * @public
	 * @name sap.ui.base.ManagedObjectMetadata#getAllAssociations
	 * @function
	 */
	ManagedObjectMetadata.prototype.getAllAssociations = function() {
		return this._mAllAssociations;
	};
	
	/**
	 * Returns infos about the events declared by the UIElement class
	 * described by this metadata object. Events from ancestor classes
	 * are not returned.
	 *
	 * The returned map contains events info objects keyed by the events name.
	 *
	 * @return {map} Map of event infos keyed by event names
	 * @public
	 * @name sap.ui.base.ManagedObjectMetadata#getEvents
	 * @function
	 */
	ManagedObjectMetadata.prototype.getEvents = function() {
		return this._mEvents;
	};
	
	/**
	 * Checks the existance of the given event by its name
	 * @param {string} sName name of the event
	 * @return {boolean} true, if the event exists
	 * @public
	 * @name sap.ui.base.ManagedObjectMetadata#hasEvent
	 * @function
	 */
	ManagedObjectMetadata.prototype.hasEvent = function(sName) {
		return !!this._mAllEvents[sName];
	};
	
	/**
	 * Returns infos about all events declared by the UIElement class
	 * described by this metadata object as well as events from base classes.
	 *
	 * The returned map contains event info objects keyed by the event name.
	 *
	 * @return {map} Map of event infos keyed by event names
	 * @public
	 * @name sap.ui.base.ManagedObjectMetadata#getAllEvents
	 * @function
	 */
	ManagedObjectMetadata.prototype.getAllEvents = function() {
		return this._mAllEvents;
	};
	
	/**
	 * Returns a map of default values for all properties declared by the
	 * described class and its ancestors, keyed by the property name.
	 *
	 * @return {map} Map of default values keyed by property names
	 * @public
	 * @name sap.ui.base.ManagedObjectMetadata#getPropertyDefaults
	 * @function
	 */
	ManagedObjectMetadata.prototype.getPropertyDefaults = function() {
	
		var mDefaults = this._mDefaults,
			oType;
		if ( mDefaults ) {
			return mDefaults;
		}
	
		if ( this.getParent() instanceof ManagedObjectMetadata ) {
			mDefaults = jQuery.sap.newObject(this.getParent().getPropertyDefaults());
		} else {
			mDefaults = {};
		}
	
		for(var s in this._mProperties) {
			if ( this._mProperties[s].defaultValue !== null ) {
				mDefaults[s] = this._mProperties[s].defaultValue;
			} else {
				oType = DataType.getType(this._mProperties[s].type);
				if (oType instanceof DataType) {
					mDefaults[s] = oType.getDefaultValue();
				} else { // Enumeration
					for (var i in oType) {
						mDefaults[s] = oType[i];
						break;
					}
				}
			}
		}
		return (this._mDefaults = mDefaults);
	};
	
	
	ManagedObjectMetadata.prototype.createPropertyBag = function() {
		if ( !this._fnPropertyBagFactory ) {
			this._fnPropertyBagFactory = jQuery.sap.factory(this.getPropertyDefaults());
		}
		return new (this._fnPropertyBagFactory)();
	};
	
	/**
	 * Helper method that enriches the (generated) information objects for children
	 * (e.g. properties, aggregations, ...) of this Element.
	 *
	 * Also ensures that the parent metadata is enriched.
	 *
	 * @private
	 * @name sap.ui.base.ManagedObjectMetadata#_enrichChildInfos
	 * @function
	 */
	ManagedObjectMetadata.prototype._enrichChildInfos = function() {
	
		if ( this._bEnriched ) {
			return;
		}
	
		if ( this.getParent() instanceof ManagedObjectMetadata ) {
			this.getParent()._enrichChildInfos();
		}
	
		var m,sName,oInfo;
		function method(sPrefix, sName) {
			return sPrefix + sName.substring(0,1).toUpperCase() + sName.substring(1);
		}
	
		// adapt properties
		m=this._mProperties;
		for(sName in m) {
			oInfo = m[sName];
			oInfo._sName = sName;
			oInfo._sUID = sName;
			oInfo._oParent = this;
			oInfo._iKind = ManagedObjectMetadata.Kind.PROPERTY;
			oInfo._sMutator = method("set", sName);
			oInfo._sGetter = method("get", sName);
		}
	
		// adapt aggregations
		m=this._mAggregations;
		for(sName in m) {
			oInfo = m[sName];
			oInfo._sName = sName;
			oInfo._sUID = "aggregation:" + sName;
			oInfo._oParent = this;
			oInfo._sDestructor = method("destroy", sName);
			oInfo._sGetter = method("get", sName);
			if ( oInfo.multiple ) {
				oInfo._iKind = ManagedObjectMetadata.Kind.MULTIPLE_AGGREGATION;
				oInfo._sMutator = method("add", oInfo.singularName);
				oInfo._sRemoveMutator = method("remove", oInfo.singularName);
				oInfo._sRemoveAllMutator = method("removeAll", sName);
			} else {
				oInfo._iKind = ManagedObjectMetadata.Kind.SINGLE_AGGREGATION;
				oInfo._sMutator = method("set", sName);
			}
		}
	
		// adapt associations
		m=this._mAssociations;
		for(sName in m) {
			oInfo = m[sName];
			oInfo._sName = sName;
			oInfo._sUID = "association:" + sName;
			oInfo._oParent = this;
			oInfo._sGetter = method("get", sName);
			if ( oInfo.multiple ) {
				oInfo._iKind = ManagedObjectMetadata.Kind.MULTIPLE_ASSOCIATION;
				oInfo._sMutator = method("add", oInfo.singularName);
			} else {
				oInfo._iKind = ManagedObjectMetadata.Kind.SINGLE_ASSOCIATION;
				oInfo._sMutator = method("set", sName);
			}
		}
	
		// adapt events
		m=this._mEvents;
		for(sName in m) {
			oInfo = m[sName];
			oInfo._sName = sName;
			oInfo._sUID = "event:" + sName;
			oInfo._oParent = this;
			oInfo._iKind = ManagedObjectMetadata.Kind.EVENT;
			oInfo._sMutator = method("attach", sName);
		}
	
		this._bEnriched = true;
	};
	
	/**
	 * Builds a "reflection like" map of setters/type infos keyed by the possible JSON names.
	 * Mainly used for the {@link sap.ui.core.Element.applySettings} method.
	 *
	 * @see sap.ui.core.Element.prototype.applySettings
	 * @private
	 * @name sap.ui.base.ManagedObjectMetadata#getJSONKeys
	 * @function
	 */
	ManagedObjectMetadata.prototype.getJSONKeys = function() {
	
		if ( this._mJSONKeys ) {
			return this._mJSONKeys;
		}
	
		this._enrichChildInfos();
	
		var mJSONKeys = {};
		function addKeys(m) {
			var sName, oInfo;
			for(sName in m) {
				oInfo = m[sName];
				if ( !mJSONKeys[sName] || oInfo._iKind < mJSONKeys[sName]._iKind ) {
					mJSONKeys[sName] = oInfo;
				};
				mJSONKeys[oInfo._sUID] = oInfo;
			};
		}
	
		addKeys(this.getAllProperties());
		addKeys(this.getAllAggregations());
		addKeys(this.getAllAssociations());
		addKeys(this.getAllEvents());
	
		return (this._mJSONKeys = mJSONKeys);
	};
	
	ManagedObjectMetadata.prototype.generateAccessors = function() {
	
		var meta=this;
		var proto = this.getClass().prototype;
		function method(sPrefix, sName, fn, bDeprecated) {
			var sName = sPrefix + sName.substring(0,1).toUpperCase() + sName.substring(1);
			if ( !proto[sName] ) {
				proto[sName] = bDeprecated ? function() {
					jQuery.sap.log.warning("Usage of deprecated feature: " + meta.getName() + "." + sName);
					return fn.apply(this, arguments);
				} : fn; 
				meta._aPublicMethods.push(sName);
			}
		}
	
		jQuery.each(this._mProperties, function(n,info) {
			method("get", n, function() { return this.getProperty(n); });
			method("set", n, function(v) { this.setProperty(n,v); return this; }, info.deprecated);
			if ( info.bindable ) {
				method("bind", n, function(p,fn,m) { this.bindProperty(n,p,fn,m); return this; }, info.deprecated);
				method("unbind", n, function(p) { this.unbindProperty(n,p); return this; });
			}
		});
		jQuery.each(this._mAggregations, function(n,info) {
			if ( !info.multiple ) {
				method("get", n, function() { return this.getAggregation(n); });
				method("set", n, function(v) { this.setAggregation(n,v); return this; }, info.deprecated);
			} else {
				var n1 = info.singularName;
				method("get", n, function() { return this.getAggregation(n,[]); });
				method("add", n1, function(a) { this.addAggregation(n,a); return this; }, info.deprecated);
				method("insert", n1, function(i,a) { this.insertAggregation(n,i,a); return this; }, info.deprecated);
				method("remove", n1, function(a) { return this.removeAggregation(n,a); });
				method("removeAll", n, function() { return this.removeAllAggregation(n); });
				method("indexOf", n1, function(a) { return this.indexOfAggregation(n,a); });
			}
			method("destroy", n, function() { this.destroyAggregation(n); return this; });
			if ( info.bindable ) {
				method("bind", n, function(p,t,s,f) { this.bindAggregation(n,p,t,s,f); return this; }, info.deprecated);
				method("unbind", n, function(p) { this.unbindAggregation(n,p); return this; });
			}
		});
		jQuery.each(this._mAssociations, function(n,info) {
			if ( !info.multiple ) {
				method("get", n, function() { return this.getAssociation(n); });
				method("set", n, function(v) { this.setAssociation(n,v); return this; }, info.deprecated);
			} else {
				var n1 = info.singularName;
				method("get", n, function() { return this.getAssociation(n,[]); });
				method("add", n1, function(a) { this.addAssociation(n,a); return this; }, info.deprecated);
				method("remove", n1, function(a) { return this.removeAssociation(n,a); });
				method("removeAll", n, function() { return this.removeAllAssociation(n); });
			}
		});
		jQuery.each(this._mEvents, function(n,info) {
			method("attach", n, function(d,f,o) { this.attachEvent(n,d,f,o); return this; }, info.deprecated);
			method("detach", n, function(f,o) { this.detachEvent(n,f,o); return this; });
			var n1 = !!info.allowPreventDefault;
			var n2 = !!info.enableEventBubbling;
			method("fire", n, function(p) { return this.fireEvent(n,p, n1, n2); });
		});
	
	};
	
	(function() {
	
		/**
		 * Usage counters for the different UID tokens
		 */
		var mUIDCounts = {};
	
		function uid(sId) {
			jQuery.sap.assert(!/[0-9]+$/.exec(sId), "AutoId Prefixes must not end with numbers");
	
			sId = sap.ui.getCore().getConfiguration().getUIDPrefix() + sId;
	
			// initialize counter
			mUIDCounts[sId] = mUIDCounts[sId] || 0;
	
			// combine prefix + counter
			// concatenating sId and a counter is only safe because we don't allow trailing numbers in sId!
			return (sId + mUIDCounts[sId]++);
		}
	
		/**
		 * Calculates a new id based on a prefix.
		 *
		 * @return {string} A (hopefully unique) control id
		 * @public
		 * @function
		 * @name sap.ui.base.ManagedObjectMetadata.uid
		 */
		ManagedObjectMetadata.uid = uid;
	
		/**
		 * Calculates a new id for an instance of this class.
		 *
		 * Note that the calculated short name part is usually not unique across
		 * all classes, but doesn't have to be. It might even be empty when the
		 * class name consists of invalid characters only.
		 *
		 * @return {string} A (hopefully unique) control id
		 * @public
		 * @name sap.ui.base.ManagedObjectMetadata#uid
		 * @function
		 */
		ManagedObjectMetadata.prototype.uid = function() {
	
			var sId = this._sUIDToken;
			if ( typeof sId !== "string" ) {
				// start with qualified class name
				sId  = this.getName();
				// reduce to unqualified name
				sId = sId.slice(sId.lastIndexOf('.')+1);
				// reduce a camel case, multi word name to the last word
				sId = sId.replace(/([a-z])([A-Z])/g, "$1 $2").split(" ").slice(-1)[0];
				// remove unwanted chars (and no trailing digits!) and convert to lower case
				sId = this._sUIDToken = sId.replace(/([^A-Za-z0-9-_.:])|([0-9]+$)/g,"").toLowerCase();
			}
	
			return uid(sId);
		};
	
	}());

	return ManagedObjectMetadata;

}, /* bExport= */ true);

}; // end of sap/ui/base/ManagedObjectMetadata.js
if ( !jQuery.sap.isDeclared('sap.ui.model.CompositeBinding') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides an abstract property binding.
jQuery.sap.declare('sap.ui.model.CompositeBinding'); // unresolved dependency added by SAPUI5 CreateModule Ant-Task
if ( !jQuery.sap.isDeclared('sap.ui.model.PropertyBinding') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides an abstract property binding.
jQuery.sap.declare('sap.ui.model.PropertyBinding'); // unresolved dependency added by SAPUI5 CreateModule Ant-Task
if ( !jQuery.sap.isDeclared('sap.ui.model.Binding') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides an abstraction for model bindings
jQuery.sap.declare('sap.ui.model.Binding'); // unresolved dependency added by SAPUI5 CreateModule Ant-Task
if ( !jQuery.sap.isDeclared('sap.ui.model.ChangeReason') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides enumeration for changes in model
jQuery.sap.declare('sap.ui.model.ChangeReason'); // unresolved dependency added by SAPUI5 CreateModule Ant-Task
sap.ui.define("sap/ui/model/ChangeReason",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	* @class
	* Change Reason for ListBindings.
	*
	* @static
	* @public
	* @name sap.ui.model.ChangeReason
	*/
	var ChangeReason = {
	
			/**
			 * The list was sorted
			 * @public
			 */
			Sort: "sort",
	
			/**
			 * The List was filtered
			 * @public
			 */
			Filter: "filter",
	
			/**
			 * The list has changed
			 * @public
			 */
			Change: "change",
	
			/**
			 * The list context has changed
			 * @public
			 */
			Context: "context",
			/**
			 * The list was refreshed
			 * @public
			 */
			Refresh: "refresh"
	};

	return ChangeReason;

}, /* bExport= */ true);

}; // end of sap/ui/model/ChangeReason.js
sap.ui.define("sap/ui/model/Binding",['jquery.sap.global', 'sap/ui/base/EventProvider', './ChangeReason'],
	function(jQuery, EventProvider, ChangeReason) {
	"use strict";


	/**
	 * Constructor for Binding class.
	 *
	 * @class
	 * The Binding is the object, which holds the necessary information for a data binding,
	 * like the binding path and the binding context, and acts like an interface to the
	 * model for the control, so it is the event provider for changes in the data model
	 * and provides getters for accessing properties or lists.
	 *
	 * @param {sap.ui.model.Model} the model
	 * @param {String} sPath the path
	 * @param {sap.ui.model.Context} oContext the context object
	 * @param {object} [mParameters]
	 * @abstract
	 * @public
	 * @name sap.ui.model.Binding
	 */
	var Binding = EventProvider.extend("sap.ui.model.Binding", /** @lends sap.ui.model.Binding */ {
		
		constructor : function(oModel, sPath, oContext, mParameters){
			EventProvider.apply(this);
			
			this.oModel = oModel;
			this.bRelative = !jQuery.sap.startsWith(sPath,'/');
			this.sPath = sPath;
			this.oContext = oContext;
			this.mParameters = mParameters;
			this.bInitial = false;
			
		},
	
		metadata : {
			"abstract" : true,
			publicMethods : [
				// methods
				"getPath", "getContext", "getModel", "attachChange", "detachChange", "refresh", "isInitial","attachDataRequested","detachDataRequested","attachDataReceived","detachDataReceived"
			]
		}
	
	});
	
	/**
	 * Creates a new subclass of class sap.ui.model.Binding with name <code>sClassName</code> 
	 * and enriches it with the information contained in <code>oClassInfo</code>.
	 * 
	 * For a detailed description of <code>oClassInfo</code> or <code>FNMetaImpl</code> 
	 * see {@link sap.ui.base.Object.extend Object.extend}.
	 *   
	 * @param {string} sClassName name of the class to be created
	 * @param {object} [oClassInfo] object literal with informations about the class  
	 * @param {function} [FNMetaImpl] alternative constructor for a metadata object
	 * @return {function} the created class / constructor function
	 * @public
	 * @static
	 * @name sap.ui.model.Binding.extend
	 * @function
	 */
	
	// Getter
	/**
	 * Getter for path
	 * @return {String} the binding path
	 * @name sap.ui.model.Binding#getPath
	 * @function
	 */
	Binding.prototype.getPath = function() {
		return this.sPath;
	};
	
	/**
	 * Getter for context
	 * @return {Object} the context object
	 * @name sap.ui.model.Binding#getContext
	 * @function
	 */
	Binding.prototype.getContext = function() {
		return this.oContext;
	};
	
	/**
	 * Setter for context
	 * @param {Object} oContext the new context object
	 * @name sap.ui.model.Binding#setContext
	 * @function
	 */
	Binding.prototype.setContext = function(oContext) {
		if (this.oContext != oContext) {
			this.oContext = oContext;
			this._fireChange();
		}
	};
	
	/**
	 * Getter for model
	 * @return {sap.ui.core.Model} the model
	 * @name sap.ui.model.Binding#getModel
	 * @function
	 */
	Binding.prototype.getModel = function() {
		return this.oModel;
	};
	
	// Eventing and related
	/**
	 * Attach event-handler <code>fnFunction</code> to the 'change' event of this <code>sap.ui.model.Model</code>.<br/>
	 * @param {function} fnFunction The function to call, when the event occurs.
	 * @param {object} [oListener] object on which to call the given function.
	 * @protected
	 * @name sap.ui.model.Binding#attachChange
	 * @function
	 */
	Binding.prototype.attachChange = function(fnFunction, oListener) {
		if (!this.hasListeners("change")) {
			this.oModel.addBinding(this);
		}
		this.attachEvent("change", fnFunction, oListener);
	};
	
	/**
	 * Detach event-handler <code>fnFunction</code> from the 'change' event of this <code>sap.ui.model.Model</code>.<br/>
	 * @param {function} fnFunction The function to call, when the event occurs.
	 * @param {object} [oListener] object on which to call the given function.
	 * @protected
	 * @name sap.ui.model.Binding#detachChange
	 * @function
	 */
	Binding.prototype.detachChange = function(fnFunction, oListener) {
		this.detachEvent("change", fnFunction, oListener);
		if (!this.hasListeners("change")) {
			this.oModel.removeBinding(this);
		}
	};
	
	/**
	 * Fire event change to attached listeners.
	
	 * @param {Map}
	 *         mArguments the arguments to pass along with the event.
	 * @private
	 * @name sap.ui.model.Binding#_fireChange
	 * @function
	 */
	Binding.prototype._fireChange = function(mArguments) {
		this.fireEvent("change", mArguments);
	};
	
	/**
	 * Attach event-handler <code>fnFunction</code> to the 'dataRequested' event of this <code>sap.ui.model.Binding</code>.<br/>
	 * @param {function} fnFunction The function to call, when the event occurs.
	 * @param {object} [oListener] object on which to call the given function.
	 * @public
	 * @name sap.ui.model.Binding#attachDataRequested
	 * @function
	 */
	Binding.prototype.attachDataRequested = function(fnFunction, oListener) {
		this.attachEvent("dataRequested", fnFunction, oListener);
	};
	
	/**
	 * Detach event-handler <code>fnFunction</code> from the 'dataRequested' event of this <code>sap.ui.model.Binding</code>.<br/>
	 * @param {function} fnFunction The function to call, when the event occurs.
	 * @param {object} [oListener] object on which to call the given function.
	 * @public
	 * @name sap.ui.model.Binding#detachDataRequested
	 * @function
	 */
	Binding.prototype.detachDataRequested = function(fnFunction, oListener) {
		this.detachEvent("dataRequested", fnFunction, oListener);
	};
	
	/**
	 * Fire event dataRequested to attached listeners.
	
	 * @param {Map} mArguments the arguments to pass along with the event.
	 * @protected
	 * @name sap.ui.model.Binding#fireDataRequested
	 * @function
	 */
	Binding.prototype.fireDataRequested = function(mArguments) {
		this.fireEvent("dataRequested", mArguments);
	};
	
	/**
	 * Attach event-handler <code>fnFunction</code> to the 'dataReceived' event of this <code>sap.ui.model.Binding</code>.<br/>
	 * @param {function} fnFunction The function to call, when the event occurs.
	 * @param {object} [oListener] object on which to call the given function.
	 * @public
	 * @name sap.ui.model.Binding#attachDataReceived
	 * @function
	 */
	Binding.prototype.attachDataReceived = function(fnFunction, oListener) {
		this.attachEvent("dataReceived", fnFunction, oListener);
	};
	
	/**
	 * Detach event-handler <code>fnFunction</code> from the 'dataReceived' event of this <code>sap.ui.model.Binding</code>.<br/>
	 * @param {function} fnFunction The function to call, when the event occurs.
	 * @param {object} [oListener] object on which to call the given function.
	 * @public
	 * @name sap.ui.model.Binding#detachDataReceived
	 * @function
	 */
	Binding.prototype.detachDataReceived = function(fnFunction, oListener) {
		this.detachEvent("dataReceived", fnFunction, oListener);
	};
	
	/**
	 * Fire event dataReceived to attached listeners.
	
	 * @param {Map} mArguments the arguments to pass along with the event.
	 * @protected
	 * @name sap.ui.model.Binding#fireDataReceived
	 * @function
	 */
	Binding.prototype.fireDataReceived = function(mArguments) {
		this.fireEvent("dataReceived", mArguments);
	};
	
	/**
	 * Determines if the binding should be updated by comparing the current model against a specified model.
	 * @param {object} oModel The model instance to compare against
	 * @returns {boolean} true if this binding should be updated
	 * @protected
	 * @name sap.ui.model.Binding#updateRequired
	 * @function
	 */
	Binding.prototype.updateRequired = function(oModel) {
		return oModel && this.getModel() === oModel;
	};
	
	/**
	 * Checks whether an update of this bindings is required. If this is the case the change event of 
	 * the binding is fired.
	 * The default implementation just fires the change event, if the method is called, the bForceUpdate
	 * parameter is ignored. Subclasses should implement this, if possible.
	 * 
	 * @param {boolean} bForceUpdate
	 *  
	 * @private
	 * @name sap.ui.model.Binding#checkUpdate
	 * @function
	 */
	Binding.prototype.checkUpdate = function(bForceUpdate) {
		this._fireChange({reason: ChangeReason.Change});
	};
	
	/**
	 * Refreshes the binding, check whether the model data has been changed and fire change event
	 * if this is the case. For server side models this should refetch the data from the server.
	 * To update a control, even if no data has been changed, e.g. to reset a control after failed
	 * validation, please use the parameter bForceUpdate.
	 * 
	 * @param {boolean} bForceUpdate Update the bound control even if no data has been changed
	 * 
	 * @public
	 * @name sap.ui.model.Binding#refresh
	 * @function
	 */
	Binding.prototype.refresh = function(bForceUpdate) {
		this.checkUpdate(bForceUpdate);
	};
	
	/**
	 * Initialize the binding. The message should be called when creating a binding.
	 * The default implementation calls checkUpdate(true). 
	 * 
	 * @protected
	 * @name sap.ui.model.Binding#initialize
	 * @function
	 */
	Binding.prototype.initialize = function() {
		this.checkUpdate(true);
	};
	
	/**
	 * _refresh for compatibility
	 * @private
	 * @name sap.ui.model.Binding#_refresh
	 * @function
	 */
	Binding.prototype._refresh = function() {
		this.refresh();
	};
	
	
	/**
	 * Returns whether the binding is initial, which means it did not get an initial value yet
	 * @return {boolean} whether binding is initial
	 * @public
	 * @name sap.ui.model.Binding#isInitial
	 * @function
	 */
	Binding.prototype.isInitial = function() {
		return this.bInitial;
	};
	
	/**
	 * Returns whether the binding is relative, which means it did not start with a /
	 * @return {boolean} whether binding is relative
	 * @public
	 * @name sap.ui.model.Binding#isRelative
	 * @function
	 */
	Binding.prototype.isRelative = function() {
		return this.bRelative;
	};
	
	/**
	 * attach multiple events
	 * @protected
	 * @name sap.ui.model.Binding#attachEvents
	 * @function
	 */
	Binding.prototype.attachEvents = function(oEvents) {
		if (!oEvents) {
			return this;
		}
		var that = this;
		jQuery.each(oEvents, function(sEvent, fnHandler) {
			var sMethod = "attach" + sEvent.substring(0,1).toUpperCase() + sEvent.substring(1);
			if (that[sMethod]) {
				that[sMethod](fnHandler);
			} else {
				jQuery.sap.log.warning(that.toString()+ " has no handler for event '" +sEvent+"'");
			}
		});
		return this;
	};
	
	/**
	 * detach multiple events
	 * @protected
	 * @name sap.ui.model.Binding#detachEvents
	 * @function
	 */
	Binding.prototype.detachEvents = function(oEvents) {
		if (!oEvents) {
			return this;
		}
		var that = this;
		jQuery.each(oEvents, function(sEvent, fnHandler) {
			var sMethod = "detach" + sEvent.substring(0,1).toUpperCase() + sEvent.substring(1);
			if (that[sMethod]) {
				that[sMethod](fnHandler);
			} else {
				jQuery.sap.log.warning(that.toString()+ " has no handler for event '" +sEvent+"'");
			}
		});
		return this;
	};
	
	/**
	 * Attach event-handler <code>fnFunction</code> to the 'refresh' event of this <code>sap.ui.model.Binding</code>.<br/>
	 * @param {function} fnFunction The function to call, when the event occurs.
	 * @param {object} [oListener] object on which to call the given function.
	 * @protected
	 * @name sap.ui.model.Binding#attachRefresh
	 * @function
	 */
	Binding.prototype.attachRefresh = function(fnFunction, oListener) {
		this.attachEvent("refresh", fnFunction, oListener);
	};
	
	/**
	 * Detach event-handler <code>fnFunction</code> from the 'refresh' event of this <code>sap.ui.model.Binding</code>.<br/>
	 * @param {function} fnFunction The function to call, when the event occurs.
	 * @param {object} [oListener] object on which to call the given function.
	 * @protected
	 * @name sap.ui.model.Binding#detachRefresh
	 * @function
	 */
	Binding.prototype.detachRefresh = function(fnFunction, oListener) {
		this.detachEvent("refresh", fnFunction, oListener);
	};
	
	/**
	 * Fire event refresh to attached listeners.
	 * @param {Map} [mArguments] the arguments to pass along with the event.
	 * @private
	 * @name sap.ui.model.Binding#_fireRefresh
	 * @function
	 */
	Binding.prototype._fireRefresh = function(mArguments) {
		this.fireEvent("refresh", mArguments);
	};

	return Binding;

}, /* bExport= */ true);

}; // end of sap/ui/model/Binding.js
if ( !jQuery.sap.isDeclared('sap.ui.model.SimpleType') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides the base implementation for all model implementations
jQuery.sap.declare('sap.ui.model.SimpleType'); // unresolved dependency added by SAPUI5 CreateModule Ant-Task
if ( !jQuery.sap.isDeclared('sap.ui.model.FormatException') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides a filter for list bindings
jQuery.sap.declare('sap.ui.model.FormatException'); // unresolved dependency added by SAPUI5 CreateModule Ant-Task
if ( !jQuery.sap.isDeclared('sap.ui.base.Exception') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides a filter for list bindings
jQuery.sap.declare('sap.ui.base.Exception'); // unresolved dependency added by SAPUI5 CreateModule Ant-Task
sap.ui.define("sap/ui/base/Exception",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * Exception class
	 *
	 * This is the base exception class. In contrary to the Error an Exception
	 * should be thrown in cases, where the exception can, and should, be handled
	 * within the framework, instead of causing the application to exit.
	 *
	 * The try/catch statement in JavaScript can not catch specific exceptions, so
	 * when catching internal exceptions you should make sure to rethrow other errors:
	 *
	 * try {
	 *     ...
	 * }
	 * catch (oException) {
	 *     if (oException instanceof sap.ui.base.Exception) {
	 *         ... handle exception ...
	 *     }
	 *     else {
	 *         throw oException;
	 *     }
	 * }
	 *
	 * @name sap.ui.base.Exception
	 */
	var Exception = function(message) {
		this.name = "Exception";
		this.message = message;
	};
	

	return Exception;

}, /* bExport= */ true);

}; // end of sap/ui/base/Exception.js
sap.ui.define("sap/ui/model/FormatException",['jquery.sap.global', 'sap/ui/base/Exception'],
	function(jQuery, Exception) {
	"use strict";


	/**
	 * FormatException class
	 *
	 * This exception is thrown, when an error occurs while trying to convert a value of the model to
	 * a specific property value in the UI.
	 *
	 * @name sap.ui.model.FormatException
	 */
	var FormatException = function(message) {
		this.name = "FormatException";
		this.message = message;
	};
	FormatException.prototype = jQuery.sap.newObject(Exception.prototype);

	return FormatException;

}, /* bExport= */ true);

}; // end of sap/ui/model/FormatException.js
if ( !jQuery.sap.isDeclared('sap.ui.model.ParseException') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides a filter for list bindings
jQuery.sap.declare('sap.ui.model.ParseException'); // unresolved dependency added by SAPUI5 CreateModule Ant-Task
sap.ui.define("sap/ui/model/ParseException",['jquery.sap.global', 'sap/ui/base/Exception'],
	function(jQuery, Exception) {
	"use strict";


	/**
	 * ParseException class
	 *
	 * This exception is thrown, when a parse error occurs while converting a
	 * string value to a specific property type in the model.
	 * @name sap.ui.model.ParseException
	 */
	var ParseException = function(message) {
		this.name = "ParseException";
		this.message = message;
	};
	ParseException.prototype = jQuery.sap.newObject(Exception.prototype);

	return ParseException;

}, /* bExport= */ true);

}; // end of sap/ui/model/ParseException.js
if ( !jQuery.sap.isDeclared('sap.ui.model.Type') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides the base implementation for all model implementations
jQuery.sap.declare('sap.ui.model.Type'); // unresolved dependency added by SAPUI5 CreateModule Ant-Task
sap.ui.define("sap/ui/model/Type",['jquery.sap.global', 'sap/ui/base/Object'],
	function(jQuery, BaseObject) {
	"use strict";


	/**
	 * Constructor for a new Type.
	 *
	 * @class
	 * This is an abstract base class for type objects.
	 * @abstract
	 *
	 * @extends sap.ui.base.Object
	 *
	 * @author SAP AG
	 * @version 1.20.6
	 *
	 * @constructor
	 * @public
	 * @name sap.ui.model.Type
	 */
	var Type = BaseObject.extend("sap.ui.model.Type", /** @lends sap.ui.model.Type */ {
		
		constructor : function () {
			BaseObject.apply(this, arguments);
			this.sName = "Type";
		},
	
		metadata : {
			"abstract" : true,
			publicMethods : [
		    // methods
		    "getName"
		  ]
		}
		
	});
	
	/**
	 * Creates a new subclass of class sap.ui.model.Type with name <code>sClassName</code> 
	 * and enriches it with the information contained in <code>oClassInfo</code>.
	 * 
	 * For a detailed description of <code>oClassInfo</code> or <code>FNMetaImpl</code> 
	 * see {@link sap.ui.base.Object.extend Object.extend}.
	 *   
	 * @param {string} sClassName name of the class to be created
	 * @param {object} [oClassInfo] object literal with informations about the class  
	 * @param {function} [FNMetaImpl] alternative constructor for a metadata object
	 * @return {function} the created class / constructor function
	 * @public
	 * @static
	 * @name sap.ui.model.Type.extend
	 * @function
	 */
	
	
	/**
	 * Returns the name of this type.
	 *
	 * @return {String} the name of this type
	 * @public
	 * @name sap.ui.model.Type#getName
	 * @function
	 */
	Type.prototype.getName = function() {
		return this.sName;
	};

	return Type;

}, /* bExport= */ true);

}; // end of sap/ui/model/Type.js
if ( !jQuery.sap.isDeclared('sap.ui.model.ValidateException') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides a filter for list bindings
jQuery.sap.declare('sap.ui.model.ValidateException'); // unresolved dependency added by SAPUI5 CreateModule Ant-Task
sap.ui.define("sap/ui/model/ValidateException",['jquery.sap.global', 'sap/ui/base/Exception'],
	function(jQuery, Exception) {
	"use strict";


	/**
	 * ValidateException class
	 *
	 * This exception is thrown, when a validation error occurs while checking the
	 * defined constraints for a type.
	 * @name sap.ui.model.ValidateException
	 */
	var ValidateException = function(message, violatedConstraints) {
		this.name = "ValidateException";
		this.message = message;
		this.violatedConstraints = violatedConstraints;
	};
	ValidateException.prototype = jQuery.sap.newObject(Exception.prototype);
	

	return ValidateException;

}, /* bExport= */ true);

}; // end of sap/ui/model/ValidateException.js
sap.ui.define("sap/ui/model/SimpleType",['jquery.sap.global', './FormatException', './ParseException', './Type', './ValidateException'],
	function(jQuery, FormatException, ParseException, Type, ValidateException) {
	"use strict";


	
	/**
	 * Constructor for a new SimpleType.
	 *
	 * @class
	 * This is an abstract base class for simple types.
	 * @abstract
	 *
	 * @extends sap.ui.model.Type
	 *
	 * @author SAP AG
	 * @version 1.20.6
	 *
	 * @constructor
	 * @param {object} [oFormatOptions] options as provided by concrete subclasses
	 * @param {object} [oConstraints] constraints as supported by concrete subclasses
	 * @public
	 * @name sap.ui.model.SimpleType
	 */
	var SimpleType = Type.extend("sap.ui.model.SimpleType", /** @lends sap.ui.model.SimpleType */ {
	
		constructor : function(oFormatOptions, oConstraints) {
			Type.apply(this, arguments);
			this.setFormatOptions(oFormatOptions || {});
			this.setConstraints(oConstraints || {});
			this.sName = "SimpleType";
		},
	
	  metadata : {
	  	"abstract" : true,
	  	publicMethods : [
		    "setConstraints", "setFormatOptions", "formatValue", "parseValue", "validateValue"
		  ]
	  }
		
	});
	
	/**
	 * Creates a new subclass of class sap.ui.model.SimpleType with name <code>sClassName</code> 
	 * and enriches it with the information contained in <code>oClassInfo</code>.
	 * 
	 * For a detailed description of <code>oClassInfo</code> or <code>FNMetaImpl</code> 
	 * see {@link sap.ui.base.Object.extend Object.extend}.
	 *   
	 * @param {string} sClassName name of the class to be created
	 * @param {object} [oClassInfo] object literal with informations about the class  
	 * @param {function} [FNMetaImpl] alternative constructor for a metadata object
	 * @return {function} the created class / constructor function
	 * @public
	 * @static
	 * @name sap.ui.model.SimpleType.extend
	 * @function
	 */
	
	
	/**
	 * Format the given value in model representation to an output value in the given
	 * internal type. This happens according to the format options, if target type is 'string'.
	 * If oValue is not defined or null, null will be returned.
	 *
	 * @function
	 * @name sap.ui.model.SimpleType.prototype.formatValue
	 * @param {any} oValue the value to be formatted
	 * @param {string} sInternalType the target type
	 * @return {any} the formatted output value
	 *
	 * @public
	 */
	
	/**
	 * Parse a value of an internal type to the expected value of the model type.
	 *
	 * @function
	 * @name sap.ui.model.SimpleType.prototype.parseValue
	 * @param {any} oValue the value to be parsed
	 * @param {string} sInternalType the source type
	 * @return {any} the parse result
	 *
	 * @public
	 */
	
	/**
	 * Validate whether a given value in model representation is valid and meets the
	 * defined constraints (if any).
	 *
	 * @function
	 * @name sap.ui.model.SimpleType.prototype.validateValue
	 * @param {any} oValue the value to be validated
	 *
	 * @public
	 */
	
	/**
	 * Sets constraints for this type. This is meta information used when validating the
	 * value, to ensure it meets certain criteria, e.g. maximum length, minimal amount
	 *
	 * @param {object} oConstraints the constraints to set for this type
	 * @name sap.ui.model.SimpleType#setConstraints
	 * @function
	 */
	SimpleType.prototype.setConstraints = function(oConstraints) {
		this.oConstraints = oConstraints;
	};
	
	/**
	 * Set format options for this type. This is meta information used when formatting and
	 * parsing values, such as patterns for number and date formatting or maximum length
	 *
	 * @param {object} oFormatOptions the options to set for this type
	 * @name sap.ui.model.SimpleType#setFormatOptions
	 * @function
	 */
	SimpleType.prototype.setFormatOptions = function(oFormatOptions) {
		this.oFormatOptions = oFormatOptions;
	};

	return SimpleType;

}, /* bExport= */ true);

}; // end of sap/ui/model/SimpleType.js
sap.ui.define("sap/ui/model/PropertyBinding",['jquery.sap.global', './Binding', './SimpleType'],
	function(jQuery, Binding, SimpleType) {
	"use strict";


	/**
	 * Constructor for PropertyBinding
	 *
	 * @class
	 * The PropertyBinding is used to access single data values in the data model.
	 *
	 * @param {sap.ui.model.Model} oModel
	 * @param {string} sPath
	 * @param {sap.ui.model.Context} oContext
	 * @param {object} [mParameters]
	 * 
	 * @public
	 * @name sap.ui.model.PropertyBinding
	 */
	
	var PropertyBinding = Binding.extend("sap.ui.model.PropertyBinding", /** @lends sap.ui.model.PropertyBinding */ {
	
		constructor : function (oModel, sPath, oContext, mParameters) {
			Binding.apply(this, arguments);
		},
		metadata : {
			"abstract" : true,
			
		  publicMethods : [
			  "getValue", "setValue", "setType", "getType", "setFormatter", "getFormatter", "getExternalValue", "setExternalValue", "getBindingMode"
		  ]
		}
	
	});
	
	/**
	 * Creates a new subclass of class sap.ui.model.PropertyBinding with name <code>sClassName</code> 
	 * and enriches it with the information contained in <code>oClassInfo</code>.
	 * 
	 * For a detailed description of <code>oClassInfo</code> or <code>FNMetaImpl</code> 
	 * see {@link sap.ui.base.Object.extend Object.extend}.
	 *   
	 * @param {string} sClassName name of the class to be created
	 * @param {object} [oClassInfo] object literal with informations about the class  
	 * @param {function} [FNMetaImpl] alternative constructor for a metadata object
	 * @return {function} the created class / constructor function
	 * @public
	 * @static
	 * @name sap.ui.model.PropertyBinding.extend
	 * @function
	 */
	
	// the 'abstract methods' to be implemented by child classes
	/**
	 * Returns the current value of the bound target
	 *
	 * @function
	 * @name sap.ui.model.PropertyBinding.prototype.getValue
	 * @return {object} the current value of the bound target
	 *
	 * @public
	 */
	
	/**
	 * Sets the value for this binding. A model implementation should check if the current default binding mode permits
	 * setting the binding value and if so set the new value also in the model.
	 *
	 * @function
	 * @name sap.ui.model.PropertyBinding.prototype.setValue
	 * @param {object} oValue the value to set for this binding
	 *
	 * @public
	 */
	
	/**
	 * Returns the current external value of the bound target which is formatted via a type or formatter function. 
	 *
	 * @throws sap.ui.model.FormatException
	 *
	 * @return {object} the current value of the bound target
	 *
	 * @public
	 * @name sap.ui.model.PropertyBinding#getExternalValue
	 * @function
	 */
	PropertyBinding.prototype.getExternalValue = function() {	
		var oValue = this.getValue();
		if (this.oType) {
			oValue = this.oType.formatValue(oValue, this.sInternalType);
		}
		if (this.fnFormatter) {
			oValue = this.fnFormatter(oValue);
		}
		return oValue;
	};
	
	
	/**
	 * Sets the value for this binding. The value is parsed and validated against its type and then set to the binding.
	 * A model implementation should check if the current default binding mode permits
	 * setting the binding value and if so set the new value also in the model.
	 *
	 * @param {object} oValue the value to set for this binding
	 * 
	 * @throws sap.ui.model.ParseException
	 * @throws sap.ui.model.ValidateException
	 *
	 * @public
	 * @name sap.ui.model.PropertyBinding#setExternalValue
	 * @function
	 */
	PropertyBinding.prototype.setExternalValue = function(oValue) {
		// formatter doesn't support two way binding
		if (this.fnFormatter) {
			return;
		}
		if (this.oType) {
			oValue = this.oType.parseValue(oValue, this.sInternalType);
			this.oType.validateValue(oValue);
		}
		// if no type specified set value directly
		this.setValue(oValue);
	};
	
	/**
	 * Sets the optional type and internal type for the binding. The type and internal type are used to do the parsing/formatting correctly.
	 * The internal type is the property type of the element which the value is formatted to.  
	 *
	 * @param {sap.ui.model.Type} oType the type for the binding
	 * @param {String} sInternalType the internal type of the element property which this binding is bound against.
	 * 
	 * @public
	 * @name sap.ui.model.PropertyBinding#setType
	 * @function
	 */
	PropertyBinding.prototype.setType = function(oType, sInternalType) {
		this.oType = oType;
		this.sInternalType = sInternalType;
	};
	
	/**
	 *  Returns the type if any for the binding.
	 *  @returns {sap.ui.model.Type} the binding type
	 *  @public
	 * @name sap.ui.model.PropertyBinding#getType
	 * @function
	 */
	PropertyBinding.prototype.getType = function() {
		return this.oType;
	};
	
	/**
	 * Sets the optional formatter function for the binding.
	
	 * @param {function} fnFormatter the formatter function for the binding
	 * 
	 * @public
	 * @name sap.ui.model.PropertyBinding#setFormatter
	 * @function
	 */
	PropertyBinding.prototype.setFormatter = function(fnFormatter) {
		this.fnFormatter = fnFormatter;
	};
	
	/**
	 *  Returns the formatter function
	 *  @returns {Function} the formatter function
	 *  @public
	 * @name sap.ui.model.PropertyBinding#getFormatter
	 * @function
	 */
	PropertyBinding.prototype.getFormatter = function() {
		return this.fnFormatter;
	};
	
	/**
	 *  Returns the binding mode 
	 *  @returns {sap.ui.model.BindingMode} the binding mode
	 *  @public
	 * @name sap.ui.model.PropertyBinding#getBindingMode
	 * @function
	 */
	PropertyBinding.prototype.getBindingMode = function() {
		return this.sMode;
	};
	
	/**
	 *  Sets the binding mode 
	 *  @params {sap.ui.model.BindingMode} sBindingMode the binding mode
	 *  @protected
	 * @name sap.ui.model.PropertyBinding#setBindingMode
	 * @function
	 */
	PropertyBinding.prototype.setBindingMode = function(sBindingMode) {
		this.sMode = sBindingMode;
	};
	

	return PropertyBinding;

}, /* bExport= */ true);

}; // end of sap/ui/model/PropertyBinding.js
sap.ui.define("sap/ui/model/CompositeBinding",['jquery.sap.global', './PropertyBinding', './SimpleType'],
	function(jQuery, PropertyBinding, SimpleType) {
	"use strict";


	/**
	 * Constructor for CompositeBinding
	 *
	 * @class
	 * The CompositeBinding is used to bundle multiple property bindings which are be used to provide a single binding against
	 * these property bindings. Note: Only One Way binding is supported. So setValue and setExternalValue throw exceptions.
	 *
	 * @public
	 * @name sap.ui.model.CompositeBinding
	 */
	
	var CompositeBinding = PropertyBinding.extend("sap.ui.model.CompositeBinding", /** @lends sap.ui.model.CompositeBinding */ {
	
		constructor : function (aBindings, bRawValues) {
			PropertyBinding.apply(this, [null,""]);
			var that = this;
			this.aBindings = aBindings;
			this.bRawValues = bRawValues;
		},
		metadata : {
			
		  publicMethods : [
		          "getBindings", "attachChange", "detachChange"
		  ]
		}
	
	});
	
	CompositeBinding.prototype.getPath = function() {
		jQuery.sap.assert(null, "Composite Binding has no path!");
		return null;
	};
	
	CompositeBinding.prototype.getModel = function() {
		jQuery.sap.assert(null, "Composite Binding has no model!");
		return null;
	};
	
	CompositeBinding.prototype.getContext = function() {
		jQuery.sap.assert(null, "Composite Binding has no context!");
		return null;
	};
	
	CompositeBinding.prototype.getType = function() {
		jQuery.sap.assert(null, "Composite Binding type is not supported!");
		return null;
	};
	
	/**
	 * sets the context for each property binding in this composite binding
	 * @param {object} oContext the new context for the bindings
	 * @name sap.ui.model.CompositeBinding#setContext
	 * @function
	 */
	CompositeBinding.prototype.setContext = function(oContext) {
		jQuery.each(this.aBindings, function(i, oBinding){
			// null context could also be set
			if(!oContext || oBinding.updateRequired(oContext.getModel())) {
				oBinding.setContext(oContext);
			}
		});
	};
	
	/**
	 * Not supported for CompositeBinding as a composite binding contains an array of property bindings. 
	 * An exception will be thrown. 
	 *
	 * @param {object} oValue the value to set for this binding
	 * 
	 * @throws sap.ui.base.Exception
	 *
	 * @public
	 * @name sap.ui.model.CompositeBinding#setValue
	 * @function
	 */
	CompositeBinding.prototype.setValue = function(oValue) {
		throw new sap.ui.base.Exception("Composite Binding does not support setValue because it contains multiple property bindings!");
	};
	
	/**
	 * Returns the raw values of the property bindings in an array.
	 *
	 * @return {object} the values of the internal property bindings in an array
	 *
	 * @public
	 * @name sap.ui.model.CompositeBinding#getValue
	 * @function
	 */
	CompositeBinding.prototype.getValue = function() {	
		var aValues = [],
		oValue;
	
		jQuery.each(this.aBindings, function(i, oBinding) {
			oValue = oBinding.getValue();
			aValues.push(oValue);
		});
	
		return aValues;
	};
	
	/**
	 * Returns the current external value of the bound target which is formatted via a type or formatter function. 
	 *
	 * @return {object} the current value of the bound target
	 *
	 *@throws sap.ui.model.FormatException
	 *
	 * @public
	 * @name sap.ui.model.CompositeBinding#getExternalValue
	 * @function
	 */
	CompositeBinding.prototype.getExternalValue = function() {	
		var aValues = [],
			oValue;
		if (this.bRawValues) {
			// type of property bindings is ignored here because we call getValue().
			aValues = this.getValue();
		} else {
			// composite type is ignored here and the property binding types are used in getExternalValue()
			jQuery.each(this.aBindings, function(i, oBinding) {
				oValue = oBinding.getExternalValue();
				aValues.push(oValue);
			});
		}
		
		if (this.fnFormatter) {
			oValue = this.fnFormatter.apply(this, aValues);
		} else {
			if ( aValues.length > 1) {
				// default: multiple values are joined together if no formatter specified
				oValue = aValues.join(" ");
			} else {
				oValue = aValues[0];
			}
		}
		
		return oValue;
	};
	
	
	/**
	 * Not supported for CompositeBinding as a composite binding contains an array of property bindings. 
	 * An exception will be thrown. 
	 *
	 * @param {object} oValue the value to set for this binding
	 * 
	 * @throws sap.ui.base.Exception
	 *
	 * @public
	 * @name sap.ui.model.CompositeBinding#setExternalValue
	 * @function
	 */
	CompositeBinding.prototype.setExternalValue = function(oValue) {
		throw new sap.ui.base.Exception("Composite Binding does not support setExternalValue because it contains multiple property bindings!");
	};
	
	/**
	 * Returns the property bindings contained in this composite binding.
	 *
	 * @return {array} the property bindings in this composite binding
	 *
	 * @public
	 * @name sap.ui.model.CompositeBinding#getBindings
	 * @function
	 */
	CompositeBinding.prototype.getBindings = function() {
		return this.aBindings;
	};
	
	//Eventing and related
	/**
	* Attach event-handler <code>fnFunction</code> to the '_change' event of this <code>sap.ui.model.Model</code>.<br/>
	* @param {function} fnFunction The function to call, when the event occurs.
	* @param {object} [oListener] object on which to call the given function.
	* @protected
	* @name sap.ui.model.CompositeBinding#attachChange
	* @function
	*/
	CompositeBinding.prototype.attachChange = function(fnFunction, oListener) {
		this.attachEvent("change", fnFunction, oListener);
		if (this.aBindings) {
			var that = this;
			jQuery.each(this.aBindings, function(i,oBinding) {
				oBinding.attachChange(that.checkUpdate, that);
			});
		}
	};
	
	/**
	* Detach event-handler <code>fnFunction</code> from the '_change' event of this <code>sap.ui.model.Model</code>.<br/>
	* @param {function} fnFunction The function to call, when the event occurs.
	* @param {object} [oListener] object on which to call the given function.
	* @protected
	* @name sap.ui.model.CompositeBinding#detachChange
	* @function
	*/
	CompositeBinding.prototype.detachChange = function(fnFunction, oListener) {
		this.detachEvent("change", fnFunction, oListener);
		if (this.aBindings) {
			var that = this;
			jQuery.each(this.aBindings, function(i,oBinding) {
				oBinding.detachChange(that.checkUpdate, that);
			});
		}
	};
	
	/**
	 * Determines if the property bindings in the composite binding should be updated by calling updateRequired on all property bindings with the specified model.
	 * @param {object} oModel The model instance to compare against
	 * @returns {boolean} true if this binding should be updated
	 * @protected
	 * @name sap.ui.model.CompositeBinding#updateRequired
	 * @function
	 */
	CompositeBinding.prototype.updateRequired = function(oModel) {
		var bUpdateRequired = false;
		jQuery.each(this.aBindings, function(i, oBinding){
			bUpdateRequired = bUpdateRequired || oBinding.updateRequired(oModel);
		});
		return bUpdateRequired;
	};
	/**
	 * Check whether this Binding would provide new values and in case it changed,
	 * inform interested parties about this.
	 * 
	 * @param {boolean} bForceupdate
	 * 
	 * @name sap.ui.model.CompositeBinding#checkUpdate
	 * @function
	 */
	CompositeBinding.prototype.checkUpdate = function(bForceupdate){
		var oValue = this.getExternalValue();
		if(!jQuery.sap.equal(oValue, this.oValue) || bForceupdate) {// optimize for not firing the events when unneeded
			this.oValue = oValue;
			this._fireChange({reason: sap.ui.model.ChangeReason.Change});
		}
	};

	return CompositeBinding;

}, /* bExport= */ true);

}; // end of sap/ui/model/CompositeBinding.js
if ( !jQuery.sap.isDeclared('sap.ui.model.ContextBinding') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides an abstraction for list bindings
jQuery.sap.declare('sap.ui.model.ContextBinding'); // unresolved dependency added by SAPUI5 CreateModule Ant-Task
sap.ui.define("sap/ui/model/ContextBinding",['jquery.sap.global', './Binding'],
	function(jQuery, Binding) {
	"use strict";


	/**
	 * Constructor for ContextBinding
	 *
	 * @class
	 * The ContextBinding is a specific binding for a setting context for the model
	 *
	 * @param {sap.ui.model.Model} oModel
	 * @param {String} sPath
	 * @param {Object} oContext
	 * @param {Object} [mParameters]
	 * @param {Object} [oEvents] object defining event handlers
	 * @abstract
	 * @public
	 * @name sap.ui.model.ContextBinding
	 */
	var ContextBinding = Binding.extend("sap.ui.model.ContextBinding", /** @lends sap.ui.model.ContextBinding */ {
		
		constructor : function(oModel, sPath, oContext, mParameters, oEvents){
			Binding.call(this, oModel, sPath, oContext, mParameters, oEvents);
			this.oElementContext = null;
			this.bInitial = true;
		},
	
		metadata : {
			 publicMethods : [
			 // methods
			 	"getElementContext"
			 ]
		}
	});
	
	/**
	 * Creates a new subclass of class sap.ui.model.ContextBinding with name <code>sClassName</code> 
	 * and enriches it with the information contained in <code>oClassInfo</code>.
	 * 
	 * For a detailed description of <code>oClassInfo</code> or <code>FNMetaImpl</code> 
	 * see {@link sap.ui.base.Object.extend Object.extend}.
	 *   
	 * @param {string} sClassName name of the class to be created
	 * @param {object} [oClassInfo] object literal with informations about the class  
	 * @param {function} [FNMetaImpl] alternative constructor for a metadata object
	 * @return {function} the created class / constructor function
	 * @public
	 * @static
	 * @name sap.ui.model.ContextBinding.extend
	 * @function
	 */
	
	/**
	 * Check whether this Binding would provide new values and in case it changed,
	 * inform interested parties about this.
	 *
	 * @param {boolean} bForceupdate
	 * @name sap.ui.model.ContextBinding#checkUpdate
	 * @function
	 */
	ContextBinding.prototype.checkUpdate = function(bForceupdate) {
		// nothing to do here, data changes can not change the context
	};
	
	/**
	 * Refreshes the binding, check whether the model data has been changed and fire change event
	 * if this is the case. For server side models this should refetch the data from the server.
	 * 
	 * @param {boolean} bForceUpdate Does not have any effect on this binding
	 * 
	 * @public
	 */
	
	/**
	 * Return the bound context
	 * @name sap.ui.model.ContextBinding#getBoundContext
	 * @function
	 */
	ContextBinding.prototype.getBoundContext = function(oContext) {
		return this.oElementContext;
	};
	

	return ContextBinding;

}, /* bExport= */ true);

}; // end of sap/ui/model/ContextBinding.js
if ( !jQuery.sap.isDeclared('sap.ui.model.Model') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides the base implementation for all model implementations
jQuery.sap.declare('sap.ui.model.Model'); // unresolved dependency added by SAPUI5 CreateModule Ant-Task
if ( !jQuery.sap.isDeclared('sap.ui.model.BindingMode') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides enumeration sap.ui.model.FilterOperator
jQuery.sap.declare('sap.ui.model.BindingMode'); // unresolved dependency added by SAPUI5 CreateModule Ant-Task
sap.ui.define("sap/ui/model/BindingMode",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	* Binding type definitions.
	*
	* @namespace
	* @public
	* @name sap.ui.model.BindingMode
	*/
	var BindingMode = /** @lends sap.ui.model.BindingMode */ {
	
			/**
			 * BindingMode default means that the binding mode of the model is used
			 * @public
			 */
			Default: "Default",
	
			/**
			 * BindingMode one time means value is only read from the model once
			 * @public
			 */
			OneTime: "OneTime",
	
			/**
			 * BindingMode one way means from model to view
			 * @public
			 */
			OneWay: "OneWay",
	
			/**
			 * BindingMode two way means from model to view and vice versa
			 * @public
			 */
			TwoWay: "TwoWay"
	
	};

	return BindingMode;

}, /* bExport= */ true);

}; // end of sap/ui/model/BindingMode.js
if ( !jQuery.sap.isDeclared('sap.ui.model.Context') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides an abstraction for model bindings
jQuery.sap.declare('sap.ui.model.Context'); // unresolved dependency added by SAPUI5 CreateModule Ant-Task
sap.ui.define("sap/ui/model/Context",['jquery.sap.global', 'sap/ui/base/EventProvider'],
	function(jQuery, EventProvider) {
	"use strict";


	/**
	 * Constructor for Context class.
	 *
	 * @class
	 * The Context is a pointer to an object in the model data, which is used to 
	 * allow definition of relative bindings, which are resolved relative to the
	 * defined object.
	 * Context elements are created either by the ListBinding for each list entry
	 * or by using createBindingContext.
	 *
	 * @param {sap.ui.model.Model} the model
	 * @param {String} sPath the path
	 * @param {Object} oContext the context object
	 * @abstract
	 * @public
	 * @name sap.ui.model.Context
	 */
	var Context = sap.ui.base.Object.extend("sap.ui.model.Context", /** @lends sap.ui.model.Context */ {
		
		constructor : function(oModel, sPath){
	
			sap.ui.base.Object.apply(this);
		
			this.oModel = oModel;
			this.sPath = sPath;
		
		},
		
		metadata : {
			"abstract" : true,
		  publicMethods : [
				"getModel", "getPath", "getProperty", "getObject"
			]
		}
	
	});
	
	/**
	 * Creates a new subclass of class sap.ui.model.Context with name <code>sClassName</code> 
	 * and enriches it with the information contained in <code>oClassInfo</code>.
	 * 
	 * For a detailed description of <code>oClassInfo</code> or <code>FNMetaImpl</code> 
	 * see {@link sap.ui.base.C.extend Object.extend}.
	 *   
	 * @param {string} sClassName name of the class to be created
	 * @param {object} [oClassInfo] object literal with informations about the class  
	 * @param {function} [FNMetaImpl] alternative constructor for a metadata object
	 * @return {function} the created class / constructor function
	 * @public
	 * @static
	 * @name sap.ui.model.Context.extend
	 * @function
	 */
	
	// Getter
	/**
	 * Getter for model
	 * @public
	 * @return {sap.ui.core.Model} the model
	 * @name sap.ui.model.Context#getModel
	 * @function
	 */
	Context.prototype.getModel = function() {
		return this.oModel;
	};
	
	/**
	 * Getter for path
	 * @public
	 * @return {String} the binding path
	 * @name sap.ui.model.Context#getPath
	 * @function
	 */
	Context.prototype.getPath = function() {
		return this.sPath;
	};
	
	/**
	 * Gets the property with the given relative binding path
	 * @public
	 * @param {String} sPath the binding path
	 * @return {any} the property value
	 * @name sap.ui.model.Context#getProperty
	 * @function
	 */
	Context.prototype.getProperty = function(sPath) {
		return this.oModel.getProperty(sPath, this);
	};
	
	/**
	 * Gets the (model dependent) object the context points to
	 * @public
	 * @return {object} the context object
	 * @name sap.ui.model.Context#getObject
	 * @function
	 */
	Context.prototype.getObject = function() {
		return this.oModel.getObject(this.sPath);
	};
	
	/** 
	 * toString method returns path for compatbility
	 * @name sap.ui.model.Context#toString
	 * @function
	 */
	Context.prototype.toString = function() {
		return this.sPath;
	};
	

	return Context;

}, /* bExport= */ true);

}; // end of sap/ui/model/Context.js
sap.ui.define("sap/ui/model/Model",['jquery.sap.global', 'sap/ui/base/EventProvider', './BindingMode', './Context'],
	function(jQuery, EventProvider, BindingMode, Context) {
	"use strict";


	/**
	 * The SAPUI5 Data Binding API.
	 *
	 * The default binding mode for model implementations (if not implemented otherwise) is two way and the supported binding modes by the model
	 * are one way, two way and one time. The default binding mode can be changed by the application for each model instance.
	 * A model implementation should specify its supported binding modes and set the default binding mode accordingly
	 * (e.g. if the model supports only one way binding the default binding mode should also be set to one way).
	 *
	 * @namespace
	 * @name sap.ui.model
	 * @public
	 */
	
	/**
	 * Constructor for a new Model.
	 *
	 * @class
	 * This is an abstract base class for model objects.
	 * @abstract
	 *
	 * @extends sap.ui.base.Object
	 *
	 * @author SAP AG
	 * @version 1.20.6
	 *
	 * @constructor
	 * @public
	 * @name sap.ui.model.Model
	 */
	var Model = EventProvider.extend("sap.ui.model.Model", /** @lends sap.ui.model.Model */ {
		
		constructor : function () {
			EventProvider.apply(this, arguments);
		
			this.oData = {};
			this.bDestroyed = false;
			this.aBindings = [];
			this.mContexts = {};
			this.iSizeLimit = 100;
			this.sDefaultBindingMode = BindingMode.TwoWay;
			this.mSupportedBindingModes = {"OneWay": true, "TwoWay": true, "OneTime": true};
			this.bLegacySyntax = false;
		},
	
		metadata : {
	
			"abstract" : true,
			publicMethods : [
				// methods
				"bindProperty", "bindList", "bindTree", "bindContext", "createBindingContext", "destroyBindingContext", "getProperty",
				"getDefaultBindingMode", "setDefaultBindingMode", "isBindingModeSupported", "attachParseError", "detachParseError",
				"attachRequestCompleted", "detachRequestCompleted", "attachRequestFailed", "detachRequestFailed", "attachRequestSent",
				"detachRequestSent", "setSizeLimit", "refresh", "isList", "getObject"
		  ]
		
		  /* the following would save code, but requires the new ManagedObject (1.9.1) 
		  , events : {
		  	"parseError" : {},
		  	"requestFailed" : {},
		  	"requestSent" : {},
		  	"requestCompleted" ; {} 
		  }
		  */
		
		}
	
	});
	
	/**
	 * Creates a new subclass of class sap.ui.model.Model with name <code>sClassName</code> 
	 * and enriches it with the information contained in <code>oClassInfo</code>.
	 * 
	 * For a detailed description of <code>oClassInfo</code> or <code>FNMetaImpl</code> 
	 * see {@link sap.ui.base.Object.extend Object.extend}.
	 *   
	 * @param {string} sClassName name of the class to be created
	 * @param {object} [oClassInfo] object literal with informations about the class  
	 * @param {function} [FNMetaImpl] alternative constructor for a metadata object
	 * @return {function} the created class / constructor function
	 * @public
	 * @static
	 * @name sap.ui.model.Model.extend
	 * @function
	 */
	
	
	/**
	 * Map of event names, that are provided by the model.
	 * @name sap.ui.model.Model.M_EVENTS
	 */
	Model.M_EVENTS = {
		/**
		 * Depending on the model implementation a ParseError should be fired if a parse error occurred.
		 * Contains the parameters:
		 * errorCode, url, reason, srcText, line, linepos, filepos
		 */
		ParseError : "parseError",
	
		/**
		 * Depending on the model implementation a RequestFailed should be fired if a request to a backend failed.
		 * Contains the parameters:
		 * message, statusCode, statusText and responseText
		 */
		RequestFailed : "requestFailed",
	
		/**
		 * Depending on the model implementation a RequestSent should be fired when a request to a backend is sent.
		 * Contains Parameters: url, type, async, info (<strong>deprecated</strong>), infoObject
		 */
		RequestSent : "requestSent",
	
		/**
		 * Depending on the model implementation a RequestCompleted should be fired when a request to a backend is completed regardless if the request failed or succeeded.
		 * Contains Parameters: url, type, async, info (<strong>deprecated</strong>), infoObject, success, errorobject
		 */
		RequestCompleted : "requestCompleted"
	};
	
	/**
	 * The 'requestFailed' event is fired, when data retrieval from a backend failed.
	 *
	 * @name sap.ui.model.Model#requestFailed
	 * @event
	 * @param {sap.ui.base.Event} oControlEvent
	 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
	 * @param {object} oControlEvent.getParameters
	
	 * @param {string} oControlEvent.getParameters.message A text that describes the failure.
	 * @param {string} oControlEvent.getParameters.statusCode HTTP status code returned by the request (if available)
	 * @param {string} oControlEvent.getParameters.statusText The status as a text, details not specified, intended only for diagnosis output
	 * @param {string} oControlEvent.getParameters.responseText Response that has been received for the request ,as a text string
	 * @public
	 */
	
	/**
	 * Attach event-handler <code>fnFunction</code> to the 'requestFailed' event of this <code>sap.ui.model.Model</code>.<br/>
	 *
	 *
	 * @param {object}
	 *            [oData] The object, that should be passed along with the event-object when firing the event.
	 * @param {function}
	 *            fnFunction The function to call, when the event occurs. This function will be called on the
	 *            oListener-instance (if present) or in a 'static way'.
	 * @param {object}
	 *            [oListener] Object on which to call the given function. If empty, this Model is used.
	 *
	 * @return {sap.ui.model.Model} <code>this</code> to allow method chaining
	 * @public
	 * @name sap.ui.model.Model#attachRequestFailed
	 * @function
	 */
	Model.prototype.attachRequestFailed = function(oData, fnFunction, oListener) {
		this.attachEvent("requestFailed", oData, fnFunction, oListener);
		return this;
	};
	
	/**
	 * Detach event-handler <code>fnFunction</code> from the 'requestFailed' event of this <code>sap.ui.model.Model</code>.<br/>
	 *
	 * The passed function and listener object must match the ones previously used for event registration.
	 *
	 * @param {function}
	 *            fnFunction The function to call, when the event occurs.
	 * @param {object}
	 *            oListener Object on which the given function had to be called.
	 * @return {sap.ui.model.Model} <code>this</code> to allow method chaining
	 * @public
	 * @name sap.ui.model.Model#detachRequestFailed
	 * @function
	 */
	Model.prototype.detachRequestFailed = function(fnFunction, oListener) {
		this.detachEvent("requestFailed", fnFunction, oListener);
		return this;
	};
	
	/**
	 * Fire event requestFailed to attached listeners.
	 *
	 * @param {object} [mArguments] the arguments to pass along with the event.
	 * @param {string} [mArguments.message]  A text that describes the failure.
	 * @param {string} [mArguments.statusCode]  HTTP status code returned by the request (if available)
	 * @param {string} [mArguments.statusText] The status as a text, details not specified, intended only for diagnosis output
	 * @param {string} [mArguments.responseText] Response that has been received for the request ,as a text string
	 * 
	 * @return {sap.ui.model.Model} <code>this</code> to allow method chaining
	 * @protected
	 * @name sap.ui.model.Model#fireRequestFailed
	 * @function
	 */
	Model.prototype.fireRequestFailed = function(mArguments) {
		this.fireEvent("requestFailed", mArguments);
		return this;
	};
	
	
	/**
	 * The 'parseError' event is fired when parsing of a model document (e.g. XML response) fails.
	 *
	 * @name sap.ui.model.Model#parseError
	 * @event
	 * @param {sap.ui.base.Event} oControlEvent
	 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
	 * @param {object} oControlEvent.getParameters
	
	 * @param {int} oControlEvent.getParameters.errorCode
	 * @param {string} oControlEvent.getParameters.url
	 * @param {string} oControlEvent.getParameters.reason
	 * @param {string} oControlEvent.getParameters.srcText
	 * @param {int} oControlEvent.getParameters.line
	 * @param {int} oControlEvent.getParameters.linepos
	 * @param {int} oControlEvent.getParameters.filepos
	 * @public
	 */
	
	/**
	 * Attach event-handler <code>fnFunction</code> to the 'parseError' event of this <code>sap.ui.model.Model</code>.<br/>
	 *
	 *
	 * @param {object}
	 *            [oData] The object, that should be passed along with the event-object when firing the event.
	 * @param {function}
	 *            fnFunction The function to call, when the event occurs. This function will be called on the
	 *            oListener-instance (if present) or in a 'static way'.
	 * @param {object}
	 *            [oListener] Object on which to call the given function. If empty, the global context (window) is used.
	 *
	 * @return {sap.ui.model.Model} <code>this</code> to allow method chaining
	 * @public
	 * @name sap.ui.model.Model#attachParseError
	 * @function
	 */
	Model.prototype.attachParseError = function(oData, fnFunction, oListener) {
		this.attachEvent("parseError", oData, fnFunction, oListener);
		return this;
	};
	
	/**
	 * Detach event-handler <code>fnFunction</code> from the 'parseError' event of this <code>sap.ui.model.Model</code>.<br/>
	 *
	 * The passed function and listener object must match the ones previously used for event registration.
	 *
	 * @param {function}
	 *            fnFunction The function to call, when the event occurs.
	 * @param {object}
	 *            oListener Object on which the given function had to be called.
	 * @return {sap.ui.model.Model} <code>this</code> to allow method chaining
	 * @public
	 * @name sap.ui.model.Model#detachParseError
	 * @function
	 */
	Model.prototype.detachParseError = function(fnFunction, oListener) {
		this.detachEvent("parseError", fnFunction, oListener);
		return this;
	};
	
	/**
	 * Fire event parseError to attached listeners.
	 *
	 * @param {object} [mArguments] the arguments to pass along with the event.
	 * @param {int} [mArguments.errorCode]
	 * @param {string} [mArguments.url]
	 * @param {string} [mArguments.reason]
	 * @param {string} [mArguments.srcText]
	 * @param {int} [mArguments.line]
	 * @param {int} [mArguments.linepos]
	 * @param {int} [mArguments.filepos]
	 *
	 * @return {sap.ui.model.Model} <code>this</code> to allow method chaining
	 * @protected
	 * @name sap.ui.model.Model#fireParseError
	 * @function
	 */
	Model.prototype.fireParseError = function(mArguments) {
		this.fireEvent("parseError", mArguments);
		return this;
	};
	
	/**
	 * The 'requestSent' event is fired, after a request has been sent to a backend.
	 *
	 * Note: Subclasses might add additional parameters to the event object.
	 * 
	 * @name sap.ui.model.Model#requestSent
	 * @event
	 * @param {sap.ui.base.Event} oControlEvent
	 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
	 * @param {object} oControlEvent.getParameters
	 * @param {string} oControlEvent.getParameters.url The url which is sent to the backend
	 * @param {string} oControlEvent.getParameters.type The type of the request (if available)
	 * @param {boolean} [oControlEvent.getParameters.async] If the request is synchronous or asynchronous (if available)
	 * @param {string} [oControlEvent.getParameters.info] Additional information for the request (if available) <strong>deprecated</strong>
	 * @param {object} [oControlEvent.getParameters.infoObject] Additional information for the request (if available)
	 * @public
	 */
	
	/**
	 * Attach event-handler <code>fnFunction</code> to the 'requestSent' event of this <code>sap.ui.model.Model</code>.
	 *
	 *
	 * @param {object}
	 *            [oData] The object, that should be passed along with the event-object when firing the event.
	 * @param {function}
	 *            fnFunction The function to call, when the event occurs. This function will be called on the
	 *            oListener-instance (if present) or in a 'static way'.
	 * @param {object}
	 *            [oListener] Object on which to call the given function. If empty, the global context (window) is used.
	 *
	 * @return {sap.ui.model.Model} <code>this</code> to allow method chaining
	 * @public
	 * @name sap.ui.model.Model#attachRequestSent
	 * @function
	 */
	Model.prototype.attachRequestSent = function(oData, fnFunction, oListener) {
		this.attachEvent("requestSent", oData, fnFunction, oListener);
		return this;
	};
	
	/**
	 * Detach event-handler <code>fnFunction</code> from the 'requestSent' event of this <code>sap.ui.model.Model</code>.
	 *
	 * The passed function and listener object must match the ones previously used for event registration.
	 *
	 * @param {function}
	 *            fnFunction The function to call, when the event occurs.
	 * @param {object}
	 *            oListener Object on which the given function had to be called.
	 * @return {sap.ui.model.Model} <code>this</code> to allow method chaining
	 * @public
	 * @name sap.ui.model.Model#detachRequestSent
	 * @function
	 */
	Model.prototype.detachRequestSent = function(fnFunction, oListener) {
		this.detachEvent("requestSent", fnFunction, oListener);
		return this;
	};
	
	/**
	 * Fire event requestSent to attached listeners.
	 *
	 * @param {object} [mArguments] the arguments to pass along with the event.
	 * @param {string} [mArguments.url] The url which is sent to the backend.
	 * @param {string} [mArguments.type] The type of the request (if available)
	 * @param {boolean} [mArguments.async] If the request is synchronous or asynchronous (if available)
	 * @param {string} [mArguments.info] additional information for the request (if available) <strong>deprecated</strong>
	 * @param {object} [mArguments.infoObject] Additional information for the request (if available)
	 * @return {sap.ui.model.Model} <code>this</code> to allow method chaining
	 * @protected
	 * @name sap.ui.model.Model#fireRequestSent
	 * @function
	 */
	Model.prototype.fireRequestSent = function(mArguments) {
		this.fireEvent("requestSent", mArguments);
		return this;
	};
	
	/**
	 * The 'requestCompleted' event is fired, after a request has been completed (includes receiving a response), 
	 * no matter whether the request succeeded or not.
	 * 
	 * Note: Subclasses might add additional parameters to the event object.
	 * 
	 * @name sap.ui.model.Model#requestCompleted
	 * @event
	 * @param {sap.ui.base.Event} oControlEvent
	 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
	 * @param {object} oControlEvent.getParameters
	 * @param {string} oControlEvent.getParameters.url The url which was sent to the backend
	 * @param {string} oControlEvent.getParameters.type The type of the request (if available)
	 * @param {boolean} oControlEvent.getParameters.success if the request has been successful or not. In case of errors consult the optional errorobject parameter.
	 * @param {object} [oControlEvent.getParameters.errorobject] If the request failed the error if any can be accessed in this property.
	 * @param {boolean} [oControlEvent.getParameters.async] If the request is synchronous or asynchronous (if available)
	 * @param {string} [oControlEvent.getParameters.info] Additional information for the request (if available) <strong>deprecated</strong>
	 * @param {object} [oControlEvent.getParameters.infoObject] Additional information for the request (if available)
	 * @public
	 */
	
	/**
	 * Attach event-handler <code>fnFunction</code> to the 'requestCompleted' event of this <code>sap.ui.model.Model</code>.
	 *
	 *
	 * @param {object}
	 *            [oData] The object, that should be passed along with the event-object when firing the event.
	 * @param {function}
	 *            fnFunction The function to call, when the event occurs. This function will be called on the
	 *            oListener-instance (if present) or in a 'static way'.
	 * @param {object}
	 *            [oListener] Object on which to call the given function. If empty, the global context (window) is used.
	 *
	 * @return {sap.ui.model.Model} <code>this</code> to allow method chaining
	 * @public
	 * @name sap.ui.model.Model#attachRequestCompleted
	 * @function
	 */
	Model.prototype.attachRequestCompleted = function(oData, fnFunction, oListener) {
		this.attachEvent("requestCompleted", oData, fnFunction, oListener);
		return this;
	};
	
	/**
	 * Detach event-handler <code>fnFunction</code> from the 'requestCompleted' event of this <code>sap.ui.model.Model</code>.
	 *
	 * The passed function and listener object must match the ones previously used for event registration.
	 *
	 * @param {function}
	 *            fnFunction The function to call, when the event occurs.
	 * @param {object}
	 *            oListener Object on which the given function had to be called.
	 * @return {sap.ui.model.Model} <code>this</code> to allow method chaining
	 * @public
	 * @name sap.ui.model.Model#detachRequestCompleted
	 * @function
	 */
	Model.prototype.detachRequestCompleted = function(fnFunction, oListener) {
		this.detachEvent("requestCompleted", fnFunction, oListener);
		return this;
	};
	
	/**
	 * Fire event requestCompleted to attached listeners.
	 *
	 * @param {object} [mArguments] the arguments to pass along with the event.
	 * @param {string} [mArguments.url] The url which was sent to the backend.
	 * @param {string} [mArguments.type] The type of the request (if available)
	 * @param {boolean} [mArguments.async] If the request was synchronous or asynchronous (if available)
	 * @param {string} [mArguments.info] additional information for the request (if available) <strong>deprecated</strong>
	 * @param {object} [mArguments.infoObject] Additional information for the request (if available)
	 *
	 * @return {sap.ui.model.Model} <code>this</code> to allow method chaining
	 * @protected
	 * @name sap.ui.model.Model#fireRequestCompleted
	 * @function
	 */
	Model.prototype.fireRequestCompleted = function(mArguments) {
		this.fireEvent("requestCompleted", mArguments);
		return this;
	};
	
	
	// the 'abstract methods' to be implemented by child classes
	
	/**
	 * Implement in inheriting classes
	 * @abstract
	 *
	 * @name sap.ui.model.Model.prototype.bindProperty
	 * @function
	 * @param {string}
	 *         sPath the path pointing to the property that should be bound
	 * @param {object}
	 *         [oContext=null] the context object for this databinding (optional)
	 * @param {object}
	 *         [mParameters=null] additional model specific parameters (optional)
	 * @return {sap.ui.model.PropertyBinding}
	 *
	 * @public
	 */
	
	/**
	 * Implement in inheriting classes
	 * @abstract
	 *
	 * @name sap.ui.model.Model.prototype.bindList
	 * @function
	 * @param {string}
	 *         sPath the path pointing to the list / array that should be bound
	 * @param {object}
	 *         [oContext=null] the context object for this databinding (optional)
	 * @param {sap.ui.model.Sorter}
	 *         [aSorters=null] initial sort order (can be either a sorter or an array of sorters) (optional)
	 * @param {array}
	 *         [aFilters=null] predefined filter/s (can be either a filter or an array of filters) (optional)
	 * @param {object}
	 *         [mParameters=null] additional model specific parameters (optional)
	 * @return {sap.ui.model.ListBinding}
	
	 * @public
	 */
	
	/**
	 * Implement in inheriting classes
	 * @abstract
	 *
	 * @name sap.ui.model.Model.prototype.bindTree
	 * @function
	 * @param {string}
	 *         sPath the path pointing to the tree / array that should be bound
	 * @param {object}
	 *         [oContext=null] the context object for this databinding (optional)
	 * @param {array}
	 *         [aFilters=null] predefined filter/s contained in an array (optional)
	 * @param {object}
	 *         [mParameters=null] additional model specific parameters (optional)
	 * @return {sap.ui.model.TreeBinding}
	
	 * @public
	 */
	
	/**
	 * Implement in inheriting classes
	 * @abstract
	 *
	 * @name sap.ui.model.Model.prototype.createBindingContext
	 * @function
	 * @param {string}
	 *         sPath the path to create the new context from
	 * @param {object}
	 *		   [oContext=null] the context which should be used to create the new binding context
	 * @param {object}
	 *		   [mParameters=null] the parameters used to create the new binding context
	 * @param {function}
	 *         fnCallBack the function which should be called after the binding context has been created
	 * @param {boolean}
	 *         [bReload] force reload even if data is already available. For server side models this should 
	 *                   refetch the data from the server 
	 *         
	 * @public
	 */
	
	/**
	 * Implement in inheriting classes
	 * @abstract
	 *
	 * @name sap.ui.model.Model.prototype.destroyBindingContext
	 * @function
	 * @param {object}
	 *         oContext to destroy
	
	 * @public
	 */
	
	/**
	 * Implement in inheriting classes
	 * @abstract
	 *
	 * @name sap.ui.model.Model.prototype.getProperty
	 * @function
	 * @param {string}
	 *         sPath the path to where to read the attribute value
	 * @param {object}
	 *		   [oContext=null] the context with which the path should be resolved
	 * @public
	 */
	
	/**
	 * Implement in inheriting classes
	 * @abstract
	 *
	 * @name sap.ui.model.Model.prototype.getObject
	 * @function
	 * @param {string}
	 *         sPath the path to where to read the object
	 * @param {object}
	 *		   [oContext=null] the context with which the path should be resolved
	 * @public
	 */
	Model.prototype.getObject = function(sPath, oContext) {
		return this.getProperty(sPath, oContext);
	};
	
	
	/**
	 * Create ContextBinding
	 * @abstract
	 * 
	 * @name sap.ui.model.Model.prototype.bindContext
	 * @function
	 * @param {string | object}
	 *         sPath the path pointing to the property that should be bound or an object 
	 *         which contains the following parameter properties: path, context, parameters
	 * @param {object}
	 *         [oContext=null] the context object for this databinding (optional)
	 * @param {object}
	 *         [mParameters=null] additional model specific parameters (optional)
	 * @param {object}
	 *         [oEvents=null] event handlers can be passed to the binding ({change:myHandler})
	 * @return {sap.ui.model.ContextBinding}
	 *
	 * @public
	 */
	
	/**
	 * Gets a binding context. If context already exists, return it from the map,
	 * otherwise create one using the context constructor.
	 *
	 * @param {string} sPath the path
	 * @name sap.ui.model.Model#getContext
	 * @function
	 */
	Model.prototype.getContext = function(sPath) {
		if (!jQuery.sap.startsWith(sPath, "/")) {
			throw new Error("Path " +sPath+" must start with a / ");
		}
		var oContext = this.mContexts[sPath];
		if (!oContext) {
			oContext = new Context(this, sPath);
			this.mContexts[sPath] = oContext;
		}
		return oContext;
	};
	
	/**
	 * Resolve the path relative to the given context.
	 * 
	 * If a relative path is given (not starting with a '/') but no context,
	 * then the path can't be resolved and undefined is returned.
	 *
	 * For backward compatibility, the behavior of this method can be changed by 
	 * setting the 'legacySyntax' property. Then an unresolvable, relative path 
	 * is automatically converted into an absolute path.
	 * 
	 * @param {string} sPath path to resolve
	 * @param {sap.ui.core.Context} [oContext] context to resolve a relative path against
	 * @return {string} resolved path or undefined
	 * @name sap.ui.model.Model#resolve
	 * @function
	 */
	Model.prototype.resolve = function(sPath, oContext) {
		var bIsRelative = !jQuery.sap.startsWith(sPath, "/"),
			sResolvedPath = sPath,
			sContextPath;
		if (bIsRelative) {
			if (oContext) {
				sContextPath = oContext.getPath();
				sResolvedPath = sContextPath + (jQuery.sap.endsWith(sContextPath, "/") ? "" : "/") + sPath;
			}
			else {
				sResolvedPath = this.isLegacySyntax() ? "/" + sPath : undefined;
			}
		}
		
		// invariant: path never ends with a slash ... if root is requested we return /
		if (sResolvedPath && sResolvedPath !== "/" && jQuery.sap.endsWith(sResolvedPath, "/")) {
			sResolvedPath = sResolvedPath.substr(0, sResolvedPath.length - 1);
		}
		return sResolvedPath;
	};
	
	/**
	 * Add a binding to this model
	 *
	 * @param {sap.ui.model.Binding} oBinding the binding to be added
	 * @name sap.ui.model.Model#addBinding
	 * @function
	 */
	Model.prototype.addBinding = function(oBinding) {
		this.aBindings.push(oBinding);
	};
	
	/**
	 * Remove a binding from the model
	 *
	 * @param {sap.ui.model.Binding} oBinding the binding to be removed
	 * @name sap.ui.model.Model#removeBinding
	 * @function
	 */
	Model.prototype.removeBinding = function(oBinding) {
		for (var i = 0; i < this.aBindings.length; i++) {
			if (this.aBindings[i] == oBinding) {
				this.aBindings.splice(i, 1);
				break;
			}
		}
	};
	
	/**
	 * Get the default binding mode for the model
	 *
	 * @return {sap.ui.model.BindingMode} default binding mode of the model
	 *
	 * @public
	 * @name sap.ui.model.Model#getDefaultBindingMode
	 * @function
	 */
	Model.prototype.getDefaultBindingMode = function() {
		return this.sDefaultBindingMode;
	};
	
	/**
	 * Set the default binding mode for the model. If the default binding mode should be changed,
	 * this method should be called directly after model instance creation and before any binding creation.
	 * Otherwise it is not guaranteed that the existing bindings will be updated with the new binding mode.
	 *
	 * @param {sap.ui.model.BindingMode} sMode the default binding mode to set for the model
	 *
	 * @public
	 * @name sap.ui.model.Model#setDefaultBindingMode
	 * @function
	 */
	Model.prototype.setDefaultBindingMode = function(sMode) {
		if (this.isBindingModeSupported(sMode)) {
			this.sDefaultBindingMode = sMode;
		}
		else {
			throw new Error("Binding mode " + sMode + " is not supported by this model.");
		}
	};
	
	/**
	 * Check if the specified binding mode is supported by the model.
	 *
	 * @param {sap.ui.model.BindingMode} sMode the binding mode to check
	 *
	 * @public
	 * @name sap.ui.model.Model#isBindingModeSupported
	 * @function
	 */
	Model.prototype.isBindingModeSupported = function(sMode) {
		return (sMode in this.mSupportedBindingModes);
	};
	
	/**
	 * Enables legacy path syntax handling
	 * 
	 * This defines, whether relative bindings, which do not have a defined
	 * binding context, should be compatible to earlier releases which means
	 * they are resolved relative to the root element or handled strict and
	 * stay unresolved until a binding context is set
	 *
	 * @param {boolean} bCompatibleSyntax the path syntax to use
	 *
	 * @public
	 * @name sap.ui.model.Model#setLegacySyntax
	 * @function
	 */
	Model.prototype.setLegacySyntax = function(bLegacySyntax) {
		this.bLegacySyntax = bLegacySyntax;
	};
	
	/**
	 * Returns whether legacy path syntax is used
	 *
	 * @return {boolean} 
	 * 
	 * @public
	 * @name sap.ui.model.Model#isLegacySyntax
	 * @function
	 */
	Model.prototype.isLegacySyntax = function() {
		return this.bLegacySyntax;
	};
	
	/**
	 * Set the maximum number of entries which are used for for list bindings.
	 * @param {int} collection size limit  
	 * @public
	 * @name sap.ui.model.Model#setSizeLimit
	 * @function
	 */
	Model.prototype.setSizeLimit = function(iSizeLimit) {
		this.iSizeLimit = iSizeLimit;
	};
	
	/**
	 * Override getInterface method to avoid creating an Interface object for models
	 * @name sap.ui.model.Model#getInterface
	 * @function
	 */
	Model.prototype.getInterface = function() {
		return this;
	};
	
	/**
	 * Refresh the model.
	 * This will check all bindings for updated data and update the controls if data has been changed. 
	 * 
	 * @param {boolean} bForceUpdate Update controls even if data has not been changed
	 * @public
	 * @name sap.ui.model.Model#refresh
	 * @function
	 */
	Model.prototype.refresh = function(bForceUpdate) {
		this.checkUpdate(bForceUpdate);
	};
	
	/**
	 * Private method iterating the registered bindings of this model instance and initiating their check for update
	 * @param {boolean} bForceUpdate
	 * @private
	 * @name sap.ui.model.Model#checkUpdate
	 * @function
	 */
	Model.prototype.checkUpdate = function(bForceUpdate) {
		var aBindings = this.aBindings.slice(0);
		jQuery.each(aBindings, function(iIndex, oBinding) {
			oBinding.checkUpdate(bForceUpdate);
		});
	};
	
	/**
	 * Destroys the model and clears the model data. 
	 * A model implementation may override this function and perform model specific cleanup tasks e.g. 
	 * abort requests, prevent new requests, etc.
	 * 
	 * @see sap.ui.base.Object.prototype.destroy
	 * @public
	 * @name sap.ui.model.Model#destroy
	 * @function
	 */
	Model.prototype.destroy = function() {
		this.oData = {};
		this.aBindings = [];
		this.mContexts = {};
		this.bDestroyed = true;
		EventProvider.prototype.destroy.apply(this, arguments);
	};
	
	/**
	 * Returns id the provided path is a list (aggregation) or an entity
	 *
	 * @abstract
	 * @name sap.ui.model.Model.prototype.bindContext
	 * @function
	 * @param {string} sPath the path pointing to the property that should be bound
	 * @param {object} [oContext=null] the context object for this databinding (optional)
	 * @return {boolean} 
	 * @since 1.17.1 
	 * @public
	 */
	

	return Model;

}, /* bExport= */ true);

}; // end of sap/ui/model/Model.js
if ( !jQuery.sap.isDeclared('jquery.sap.act') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides functionality for activity detection
jQuery.sap.declare('jquery.sap.act'); // unresolved dependency added by SAPUI5 CreateModule Ant-Task
sap.ui.define("jquery.sap.act",['jquery.sap.global'],
	function(jQuery) {
	"use strict";

	if(typeof window.jQuery.sap.act === "object" || typeof window.jQuery.sap.act === "function" ){
		return;
	}
	
//	Date.now = Date.now || function() {
//		return new Date().getTime();
//	};
	
	/**
	 * @public
	 * @name jQuery.sap.act
	 * @namespace
	 * @static
	 */
	
	var _act = {},
		_active = true,
		_deactivatetimer = null,
		_I_MAX_IDLE_TIME = 10000, //max. idle time in ms
		_deactivateSupported = !!window.addEventListener, //Just skip IE8
		_aActivateListeners = [],
		_aDeactivateListeners = [],
		_activityDetected = false,
		_domChangeObserver = null;

	function _onDeactivate(){
		_deactivatetimer = null;
		
		if(_activityDetected){
			_onActivate();
			return;
		}
		
		_active = false;
		//_triggerEvent(_aDeactivateListeners); //Maybe provide later
		_domChangeObserver.observe(document.documentElement, {childList: true, attributes: true, subtree: true, characterData: true});
	};
	
	function _onActivate(){
		if(!_active){
			_active = true;
			_triggerEvent(_aActivateListeners);
			_domChangeObserver.disconnect();
		}
		if(_deactivatetimer){
			_activityDetected = true;
		}else{
			_deactivatetimer = setTimeout(_onDeactivate, _I_MAX_IDLE_TIME);
			_activityDetected = false;
		}
	};
	
	function _triggerEvent(aListeners){
		if(aListeners.length == 0) {
			return;
		}
		var aEventListeners = aListeners.slice();
		setTimeout(function(){
			var oInfo;
			for (var i = 0, iL = aEventListeners.length; i < iL; i++) {
				oInfo = aEventListeners[i];
				oInfo.fFunction.call(oInfo.oListener || window);
			}
		}, 0);
	};
	
	
	/**
	 * Registers the given handler to the activity event, which is fired when an activity was detected after a certain period of inactivity.
	 * 
	 * The Event is not fired for Internet Explorer 8.
	 * 
	 * @param {Function} fnFunction The function to call, when an activity event occurs.
	 * @param {Object} [oListener] The 'this' context of the handler function.
	 * @protected
	 * 
	 * @function
	 * @name jQuery.sap.act#attachActivate
	 */
	_act.attachActivate = function(fnFunction, oListener){
		_aActivateListeners.push({oListener: oListener, fFunction:fnFunction});
	};
	
	/**
	 * Deregisters a previously registered handler from the activity event.
	 * 
	 * @param {Function} fnFunction The function to call, when an activity event occurs.
	 * @param {Object} [oListener] The 'this' context of the handler function.
	 * @protected
	 * 
	 * @function
	 * @name jQuery.sap.act#detachActivate
	 */
	_act.detachActivate = function(fnFunction, oListener){
		for (var i = 0, iL = _aActivateListeners.length; i < iL; i++) {
			if (_aActivateListeners[i].fFunction === fnFunction && _aActivateListeners[i].oListener === oListener) {
				_aActivateListeners.splice(i,1);
				break;
			}
		}
	};
	
	/**
	 * Checks whether recently an activity was detected.
	 * 
	 * Not supported for Internet Explorer 8.
	 * 
	 * @return true if recently an activity was detected, false otherwise
	 * @protected
	 * 
	 * @function
	 * @name jQuery.sap.act#isActive
	 */
	_act.isActive = !_deactivateSupported ? function(){return true;} : function(){return _active;};
	
	/**
	 * Reports an activity.
	 * 
	 * @public
	 * 
	 * @function
	 * @name jQuery.sap.act#refresh
	 */
	_act.refresh = !_deactivateSupported ? function(){} : _onActivate;
	
	
	// Setup and registering handlers
	
	if (_deactivateSupported) {
		var aEvents = ["resize", "orientationchange", "mousemove", "mousedown", "mouseup", //"mouseout", "mouseover",
		               "touchstart", "touchmove", "touchend", "touchcancel", "paste", "cut", "keydown", "keyup",
		               "DOMMouseScroll", "mousewheel"];
		for(var i=0; i<aEvents.length; i++){
			window.addEventListener(aEvents[i], _act.refresh, true);
		}
		
		if(window.MutationObserver){
			_domChangeObserver = new window.MutationObserver(_act.refresh);
    	}else if(window.WebKitMutationObserver){
    		_domChangeObserver = new window.WebKitMutationObserver(_act.refresh);
    	}else{
    		_domChangeObserver = {
    			observe : function(){
    				document.documentElement.addEventListener("DOMSubtreeModified", _act.refresh);
    			},
    			disconnect : function(){
    				document.documentElement.removeEventListener("DOMSubtreeModified", _act.refresh);
    			}
    		};
    	}
		
		_onActivate();
	}
	
	jQuery.sap.act = _act;

	return jQuery;
	
}, /* bExport= */ false);

}; // end of jquery.sap.act.js
if ( !jQuery.sap.isDeclared('jquery.sap.strings') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides useful string operations not available in pure JavaScript.
jQuery.sap.declare('jquery.sap.strings'); // unresolved dependency added by SAPUI5 CreateModule Ant-Task
sap.ui.define("jquery.sap.strings",['jquery.sap.global'],
	function(jQuery) {
	"use strict";

	/**
	 * Checks whether a given sString ends with sEndString
	 * respecting the case of the strings.
	 *
	 * @param {string} sString The string to be checked
	 * @param {string} sEndString The end string to be searched
	 * @return True if sString ends with sEndString
	 * @type {boolean}
	 * @see jQuery.sap.endsWithIgnoreCase
	 * @public
	 */
	jQuery.sap.endsWith = function endsWith(sString, sEndString) {
		if (typeof(sEndString)!="string" || sEndString=="") {
			return false;
		}
		var iPos = sString.lastIndexOf(sEndString);
		return iPos >= 0 && iPos == sString.length - sEndString.length;
	};

	/**
	 * Checks whether a given sString ends with sEndString
	 * ignoring the case of the strings.
	 *
	 * @param {string} sString the string to be checked
	 * @param {string} sEndString the end string to be searched
	 * @return true if sString ends with sEndString
	 * @type {boolean}
	 * @see jQuery.sap.endsWith
	 * @public
	 */
	jQuery.sap.endsWithIgnoreCase = function endsWithIgnoreCase(sString, sEndString) {
		if (typeof(sEndString)!="string" || sEndString=="") {
			return false;
		}
		sString = sString.toUpperCase();
		sEndString = sEndString.toUpperCase();
		return jQuery.sap.endsWith(sString,sEndString);
	};

	/**
	 * Checks whether a given sString starts with sStartString
	 * respecting the case of the strings.
	 *
	 * @param {string} sString The string to be checked
	 * @param {string} sStartString The start string to be searched
	 * @return True if sString ends with sEndString
	 * @type {boolean}
	 * @see jQuery.sap.startsWithIgnoreCase
	 * @public
	 */
	jQuery.sap.startsWith = function startsWith(sString, sStartString) {
		if (typeof(sStartString)!="string" || sStartString=="") {
			return false;
		}
		if (sString == sStartString) {
			return true;
		}
		return sString.indexOf(sStartString) == 0;
	};

	/**
	 * Checks whether a given sString starts with sStartString
	 * ignoring the case of the strings.
	 *
	 * @param {string} sString The string to be checked
	 * @param {string} sStartString The start string to be searched
	 * @return True if sString ends with sEndString
	 * @type {boolean}
	 * @see jQuery.sap.startsWith
	 * @public
	 */
	jQuery.sap.startsWithIgnoreCase = function startsWithIgnoreCase(sString, sStartString) {
		if (typeof(sStartString)!="string" || sStartString=="") {
			return false;
		}
		sString = sString.toUpperCase();
		sStartString = sStartString.toUpperCase();
		return jQuery.sap.startsWith(sString,sStartString);
	};

	/**
	 * Converts a character of the string to upper case.<br/>
	 * If no pos is defined as second parameter or pos is negative or greater than sString the first character will be
	 * converted into upper case. the first char position is 0.
	 *
	 * @param {string} sString The string to be checked
	 * @param {int} iPos the position of the character that will be uppercase
	 * @return The string with the firstletter in upper case
	 * @type {string}
	 * @public
	 * @SecPassthrough {0|return}
	 */
	jQuery.sap.charToUpperCase = function charToUpperCase(sString,iPos) {
		if (!sString) {
			return sString;
		}
		if (!iPos || isNaN(iPos) || iPos <= 0 || iPos >= sString.length) {
			iPos = 0;
		}
		var sChar = sString.charAt(iPos).toUpperCase();
		if (iPos>0) {
			return sString.substring(0,iPos) + sChar + sString.substring(iPos+1);
		}
		return sChar + sString.substring(iPos+1);
	};

	/**
	 * Pads a string on the left side until is has the given length.<br/>
	 *
	 * @param {string} sString The string to be padded
	 * @param {string} sPadChar The char to use for the padding
	 * @param {int} iLength the target length of the string
	 * @return The padded string
	 * @type {string}
	 * @public
	 * @SecPassthrough {0 1|return}
	 */
	jQuery.sap.padLeft = function padLeft(sString, sPadChar, iLength) {
		if (!sString) {
			sString = "";
		}
		while (sString.length < iLength) {
			sString = sPadChar + sString;
		}
		return sString;
	};

	/**
	 * Pads a string on the right side until is has the given length.<br/>
	 *
	 * @param {string} sString The string to be padded
	 * @param {string} sPadChar The char to use for the padding
	 * @param {int} iLength the target length of the string
	 * @return The padded string
	 * @type {string}
	 * @public
	 * @SecPassthrough {0 1|return}
	 */
	jQuery.sap.padRight = function padRight(sString, sPadChar, iLength) {
		if (!sString) {
			sString = "";
		}
		while (sString.length < iLength) {
			sString = sString + sPadChar;
		}
		return sString;
	};


	var rCamelCase = /-(.)/ig;

	/**
	 * Transforms a hyphen separated string to an camel case string. 
	 *
	 * @param {string} sString Hyphen separated string
	 * @return The transformed string
	 * @type {string}
	 * @since 1.7.0
	 * @public
	 * @SecPassthrough {0|return}
	 */
	jQuery.sap.camelCase = function camelCase(sString) { 
		return sString.replace( rCamelCase, function( sMatch, sChar ) {
			return sChar.toUpperCase();
		});
	};

	
	var rHyphen = /([A-Z])/g;
	
	/**
	 * Transforms a camel case string into a hyphen separated string.
	 * 
	 * @param {string} sString camel case string
	 * @return The transformed string
	 * @type {string}
	 * @since 1.15.0
	 * @public
	 * @SecPassthrough {0|return}
	 */
	jQuery.sap.hyphen = function hyphen(sString) {
		return sString.replace( rHyphen, function(sMatch, sChar) { 
			return "-" + sChar.toLowerCase(); 
		});
	};

	
	var rEscapeRegExp = /[-[\]{}()*+?.,\\^$|#\s]/g;

	/**
	 * This function escapes the reserved letters in Regular Expression
   * @param {string} sString string to escape
   * @return The escaped string
   * @type {string}
   * @since 1.9.3
   * @public
   * @SecPassthrough {0|return}
	 */
	jQuery.sap.escapeRegExp = function escapeRegExp(sString) {
		return sString.replace(rEscapeRegExp, "\\$&");
	};
	
	/**
	 * Creates a string from a pattern by replacing placeholders with concrete values.
	 *
	 * The syntax of the pattern is inspired by (but not fully equivalent to) the 
	 * java.util.MessageFormat.
	 *
	 * Placeholders have the form <code>{ integer }</code>, where any occurrence of 
	 * <code>{0}</code> is replaced by the value with index 0 in <code>aValues</code>,
	 * <code>{1}</code> y the value with index 1 in <code>aValues</code> etc.
	 *
	 * To avoid interpretation of curly braces as placeholders, any non-placeholder fragment 
	 * of the pattern can be enclosed in single quotes. The surrounding single quotes will be 
	 * omitted from the result. Single quotes that are not meant to escape a fragment and 
	 * that should appear in the result, need to be doubled. In the result, only a single 
	 * single quote will occur.
	 *
	 * Example Pattern Strings:
	 * <pre>
	 *   jQuery.sap.formatMessage("Say {0}", ["Hello"]) -> "Say Hello"  // normal use case
	 *   jQuery.sap.formatMessage("Say '{0}'", ["Hello"]) -> "Say {0}"  // escaped placeholder
	 *   jQuery.sap.formatMessage("Say ''{0}''", ["Hello"]) -> "Say 'Hello'" // doubled single quote 
	 *   jQuery.sap.formatMessage("Say '{0}'''", ["Hello"]) -> "Say {0}'" // doubled single quote in quoted fragment
	 * </pre>
	 * 
	 * In contrast to java.util.MessageFormat, format types or format styles are not supported. 
	 * Everything after the argument index and up to the first closing curly brace is ignored.
	 * Nested placeholders (as supported by java.lang.MessageFormat for the format type choice)
	 * are not ignored but reported as a parse error. 
	 *
	 * This method throws an Error when the pattern syntax is not fulfilled (e.g. unbalanced curly 
	 * braces, nested placeholders or a non-numerical argument index).
	 *
	 * This method can also be used as a formatter within a binding. The first part of a composite binding 
	 * will be used as pattern, the following parts as aValues. If there is only one value and this
	 * value is an array it will be handled like the default described above.
	 *  
	 * @param {string} sPattern A pattern string in the described syntax 
	 * @param {any[]} [aValues=[]] The values to be used instead of the placeholders.
	 * 										 
	 * @return {string} The formatted result string 
	 * @since 1.12.5
	 * @SecPassthrough {*|return}
	 * @public
	 */
	jQuery.sap.formatMessage = function formatMessage(sPattern, aValues) {
		jQuery.sap.assert(typeof sPattern === "string" || sPattern instanceof String, "pattern must be string");
		if (arguments.length > 2 || (aValues != null && !jQuery.isArray(aValues))) {
			aValues = Array.prototype.slice.call(arguments,1);
		} 
		aValues = aValues || [];
		return sPattern.replace(rMessageFormat, function($0,$1,$2,$3,offset) {
			if ( $1 ) {
				// a doubled single quote in a normal string fragment 
				//   --> emit a single quote
				return "'";
			} else if ( $2 ) {
				// a quoted sequence of chars, potentially containing doubled single quotes again 
				//   --> emit with doubled single quotes replaced by a single quote 
				return $2.replace(/''/g, "'");
			} else if ( $3 ) {
				// a welformed curly brace
				//   --> emit the argument but ignore other parameters 
				return String(aValues[parseInt($3, 10)]);
			}
			// e.g. malformed curly braces 
			//   --> throw Error 
			throw new Error("formatMessage: pattern syntax error at pos. " + offset);
		});
	}
	
	/**
	 * Pattern to analyze MessageFormat strings.
	 * 
	 * Group 1: captures doubled single quotes within the string
	 * Group 2: captures quoted fragments within the string. 
	 *            Note that java.util.MessageFormat silently forgives a missing single quote at 
	 *            the end of a pattern. This special case is handled by the RegEx as well.  
	 * Group 3: captures placeholders
	 *            Checks only for numerical argument index, any remainder is ignored up to the next 
	 *            closing curly brace. Nested placeholdes are not accepted!
	 * Group 4: captures any remaining curly braces and indicates syntax errors
	 *
	 * @private
	 *                    [-1] [----- quoted string -----] [------ placeholder ------] [--]
	 */
	var rMessageFormat = /('')|'([^']+(?:''[^']*)*)(?:'|$)|\{([0-9]+(?:\s*,[^{}]*)?)\}|[{}]/g;

	return jQuery;

}, /* bExport= */ false);

}; // end of jquery.sap.strings.js
sap.ui.define("sap/ui/base/ManagedObject",['jquery.sap.global', './BindingParser', './DataType', './EventProvider', './ManagedObjectMetadata', 'sap/ui/model/CompositeBinding', 'sap/ui/model/ContextBinding', 'sap/ui/model/Model', 'sap/ui/model/Type', 'jquery.sap.act', 'jquery.sap.script', 'jquery.sap.strings'],
	function(jQuery, BindingParser, DataType, EventProvider, ManagedObjectMetadata, CompositeBinding, ContextBinding, Model, Type/* , jQuerySap2, jQuerySap, jQuerySap1 */) {
	"use strict";


	
	/**
	 * Constructs and initializes a managed object with the given <code>sId</code> and settings.
	 *
	 * If the optional <code>mSettings</code> are given, they must be a simple object  
	 * that defines values for properties, aggregations, associations or events keyed by their name.
	 *
	 * <b>Valid Names:</b>
	 *
	 * The property (key) names supported in the object literal are exactly the (case sensitive)
	 * names documented in the JSDoc for the properties, aggregations, associations and events
	 * of the managed object and its base classes. Note that for  0..n aggregations and associations this
	 * usually is the plural name, whereas it is the singular name in case of 0..1 relations.
	 *
	 * If a key name is ambiguous for a specific managed object class (e.g. a property has the same
	 * name as an event), then this method prefers property, aggregation, association and
	 * event in that order. To resolve such ambiguities, the keys can be prefixed with
	 * <code>aggregation:</code>, <code>association:</code> or <code>event:</code>.
	 * In that case the keys must be quoted due to the ':'.
	 *
	 * Each subclass should document the set of supported names in its constructor documentation.
	 *
	 * <b>Valid Values:</b>
	 *
	 * <ul>
	 * <li>for normal properties, the value has to be of the correct simple type (no type conversion occurs)
	 * <li>for 0..1 aggregations, the value has to be an instance of the aggregated type
	 * <li>for 0..n aggregations, the value has to be an array of instances of the aggregated type
	 * <li>for 0..1 associations, an instance of the associated type or an id (string) is accepted
	 * <li>0..n associations are not supported yet
	 * <li>for events either a function (event handler) is accepted or an array of length 2
	 *     where the first element is a function and the 2nd element is an object to invoke the method on.
	 * </ul>
	 *
	 * @param {string} [sId] id for the new managed object; generated automatically if no non-empty id is given
	 *      Note: this can be omitted, no matter whether <code>mSettings</code> will be given or not!
	 * @param {object} [mSettings] optional map/JSON-object with initial property values, aggregated objects etc. for the new object
	 * @param {object} [oScope] scope object for resolving string based type and formatter references in bindings
	 *
	 * @class Base Class for managed objects.
	 * @extends sap.ui.base.EventProvider
	 * @author SAP
	 * @version 1.20.6
	 * @public
	 * @name sap.ui.base.ManagedObject
	 * @experimental Since 1.11.2. support for the optional parameter oScope is still experimental 
	 */
	var ManagedObject = EventProvider.extend("sap.ui.base.ManagedObject", {
	
		metadata : {
		  "abstract" : true,
		  publicMethods : [ "getId", "getMetadata", "getModel", "setModel", "hasModel", "bindProperty", "unbindProperty", "bindAggregation", "unbindAggregation", "bindObject", "unbindObject", "getObjectBinding"],
		  library : "sap.ui.core", // UI Library that contains this class
		  properties : {
		  },
		  aggregations : {
		  },
		  associations : {},
		  events : { 
			  "validationSuccess" : { enableEventBubbling : true },
			  "validationError" : { enableEventBubbling : true },
			  "parseError" : { enableEventBubbling : true }, 
			  "formatError" : { enableEventBubbling : true } 
		  }
		},
	
		constructor : function(sId, mSettings, oScope) {
	
			EventProvider.apply(this); // no use to pass our arguments
			if (typeof(sId) != "string" && arguments.length>0) {
				// shift arguments in case sId was missing, but mSettings was given
				oScope = mSettings;
				mSettings = sId;
				if (mSettings && mSettings.id) {
					sId = mSettings["id"];
				} else {
					sId = null;
				}
			}
	
			if (!sId) {
				sId = this.getMetadata().uid() || jQuery.sap.uid();
			} else {
				var preprocessor = ManagedObject._fnIdPreprocessor;
				sId = (preprocessor ? preprocessor.call(this, sId) : sId);
				var oType = DataType.getType("sap.ui.core.ID");
				if (!oType.isValid(sId)) {
					throw new Error("\"" + sId + "\" is not a valid ID.");
				}
			}
			this.sId = sId;
	
			// managed object interface
			// create an empty property bag that uses a map of defaultValues as its prototype
			this.mProperties = this.getMetadata().createPropertyBag();
			this.mAggregations = {};
			this.mAssociations = {};
			this.mMethods = {};
	
			// private properties
			this.oParent = null;
	
			this.aDelegates = [];
			this.aBeforeDelegates = [];
			this.iSuppressInvalidate = 0;
			this.oPropagatedProperties = {oModels:{}, oBindingContexts:{}};
	
			// data binding
			this.oModels = {};
			this.oBindingContexts = {};
			this.mBindingInfos = {};
			this.sBindingPath = null;
			this.mBindingParameters = null;
			this.mBoundObjects = {};
			
			// apply the owner id if defined
			this._sOwnerId = ManagedObject._sOwnerId; 
			
			// make sure that the object is registered before initializing
			// and to deregister the object in case of errors
			try {
				
				// registers the object in the Core
				if (this.register) this.register();
	
				// TODO: generic concept for init hooks?
				if ( this._initCompositeSupport ) {
					this._initCompositeSupport(mSettings);
				}
	
				// Call init method here instead of specific Controls constructor.
				if (this.init) {
					this.init();
				}
	
				// apply the settings
				this.applySettings(mSettings, oScope);
	
			} catch (ex) {
				
				// unregisters the object in the Core
				if (this.deregister) this.deregister();
	
				// forward the exception
				throw ex;
				
			}
			
		}
	
	}, /* Metadata constructor */ ManagedObjectMetadata);
	
	
	
	/**
	 * Creates a new ManagedObject from the given data.
	 *
	 * If vData is a managed object already, that object is returned.
	 * If vData is an object (literal), then a new object is created with vData as settings.
	 * The type of the object is either determined by a "Type" entry in the vData or
	 * by a type information in the oKeyInfo object
	 * @param {sap.ui.base.ManagedObject|object} vData the data to create the object from
	 * @param {object} oKeyInfo
	 * @public
	 * @static
	 * @name sap.ui.base.ManagedObject.create
	 * @function
	 */
	ManagedObject.create = function(vData, oKeyInfo) {
		if ( !vData || vData instanceof ManagedObject || typeof vData !== "object" || vData instanceof String) {
			return vData;
		}
	
		function getClass(vType) {
			if ( typeof vType === "function" ) {
				return vType;
			} 
			if (typeof vType === "string" ) {
				return jQuery.sap.getObject(vType);
			}
		}
	
		var fnClass = getClass(vData.Type) || getClass(oKeyInfo && oKeyInfo.type);
		if ( typeof fnClass === "function" ) {
			return new fnClass(vData);
		}
	
		// we don't know how to create the ManagedObject from vData, so fail
		// extension points could be integrated here
		var message = "Don't know how to create a ManagedObject from " + vData + " (" + (typeof vData) + ")";
		jQuery.sap.log.fatal(message);
		throw new Error(message);
	};
	
	/**
	 * A global preprocessor for the ID of a ManagedObject (used internally).
	 * If set, this function will be called before the ID is applied to any ManagedObject.
	 * If the original ID was empty, the hook will not be called (to be discussed).
	 *
	 * The expected signature is <code>function(sId)</code>, and <code>this</code> will
	 * be the current ManagedObject.
	 *
	 * @return new ID of the ManagedObject
	 * @type function
	 * @private
	 * @name sap.ui.base.ManagedObject._fnIdPreprocessor
	 */
	ManagedObject._fnIdPreprocessor = null;
	
	/**
	 * A global preprocessor for the settings of a ManagedObject (used internally).
	 * If set, this function will be called before the settings are applied to any ManagedObject.
	 * If the original settings are empty, the hook will not be called (to be discussed).
	 *
	 * The expected signature is <code>function(mSettings)</code>, and <code>this</code> will
	 * be the current ManagedObject.
	 *
	 * @type function
	 * @private
	 * @name sap.ui.base.ManagedObject._fnSettingsPreprocessor
	 */
	ManagedObject._fnSettingsPreprocessor = null;
	
	ManagedObject.runWithPreprocessors = function(fn, oPreprocessors) {
		jQuery.sap.assert(typeof fn === "function", "fn must be a function");
		jQuery.sap.assert(!oPreprocessors || typeof oPreprocessors === "object", "oPreprocessors must be an object");
	
		var oOldPreprocessors = { id : this._fnIdPreprocessor, settings : this._fnSettingsPreprocessor };
		oPreprocessors = oPreprocessors || {};
	
		this._fnIdPreprocessor = oPreprocessors.id; 
		this._fnSettingsPreprocessor = oPreprocessors.settings;
	
		try {
			var result = fn.call();
			this._fnIdPreprocessor = oOldPreprocessors.id; 
			this._fnSettingsPreprocessor = oOldPreprocessors.settings;
			return result;
		} catch (e) {
			this._fnIdPreprocessor = oOldPreprocessors.id; 
			this._fnSettingsPreprocessor = oOldPreprocessors.settings;
			throw e;
		}
	
	};
	
	/*
	 * Returns the ID of the owner ManagedObject in which context the given 
	 * ManagedObject has been created. 
	 * @name sap.ui.base.ManagedObject.getOwnerIdFor
	 * @function
	 */
	ManagedObject.getOwnerIdFor = function(oObject) {
		return oObject && oObject._sOwnerId;
	};
	
	/*
	 * Internal function to assign the ID of the owner in which the creation of 
	 * a ManagedObject will be done.
	 * @name sap.ui.base.ManagedObject.runWithOwner
	 * @function
	 */
	ManagedObject.runWithOwner = function(fn, oObject) {
		
		jQuery.sap.assert(typeof fn === "function", "fn must be a function");
		jQuery.sap.assert(oObject instanceof ManagedObject, "oObject is not an instance of sap.ui.core.ManagedObject");
	
		var oldOwnerId = ManagedObject._sOwnerId;
		try {
			ManagedObject._sOwnerId = oObject.getId();
			var result = fn.call();
			ManagedObject._sOwnerId = oldOwnerId;
			return result;
		} catch (e) {
			ManagedObject._sOwnerId = oldOwnerId;
			throw e;
		}
	
	};
	
	/**
	 * Sets all the properties, aggregations, associations and event handlers as given in
	 * the object literal <code>mSettings</code>. If a property, aggregation, etc.
	 * is not listed in <code>mSettings</code>, then its value is not changed by this method.
	 *
	 * For properties and 0..1 aggregations/associations, any given setting overwrites
	 * the current value. For 0..n aggregations, the given values are appended; event
	 * listeners are registered in addition to existing ones.
	 *
	 * For the possible keys and values in <code>mSettings</code> see the general
	 * documentation in {@link sap.ui.base.ManagedObject} or the specific documentation
	 * of the constructor of the concrete managed object class.
	 *
	 * @param {object} mSettings the settings to apply to this managed object
	 * @param {object} [oScope] Scope object to resolve types and formatters
	 * @return {sap.ui.base.ManagedObject} Returns <code>this</code> to allow method chaining
	 * @public
	 * @experimental Since 1.11.2. support for complex string binding syntax as well as the 
	 * 				scope object for resolving string based type and formatter references 
	 * 				in bindings is still experimental
	 * @name sap.ui.base.ManagedObject#applySettings
	 * @function
	 */
	ManagedObject.prototype.applySettings = function(mSettings, oScope) {
	
		// PERFOPT: don't retrieve (expensive) JSONKeys if no settings are given
		if ( !mSettings || jQuery.isEmptyObject(mSettings) ) {
			return this;
		}
	
		var oMetadata = this.getMetadata(),
			mValidKeys = oMetadata.getJSONKeys(),
			makeObject = ManagedObject.create,
			preprocessor = ManagedObject._fnSettingsPreprocessor,
			sKey, oValue, oKeyInfo;
	
		// call the preprocessor if it has been defined
		preprocessor && preprocessor.call(this, mSettings); // TODO: decide whether to call for empty settings as well?
		
		// process models
		if ( mSettings.models ) {
			if ( typeof mSettings.models !== "object" ) {
				throw new Error("models must be a simple object");
			}
			if ( mSettings.models instanceof Model) {
				this.setModel(mSettings.models);
			} else {
				for(sKey in mSettings.models ) {
					this.setModel(mSettings.models[sKey], sKey === "undefined" ? undefined : sKey);
				}
			}
			delete mSettings.models;
		}
		//process BindingContext
		if ( mSettings.bindingContexts ) {
			if ( typeof mSettings.bindingContexts !== "object" ) {
				throw new Error("bindingContexts must be a simple object");
			}
			if ( mSettings.bindingContexts instanceof sap.ui.model.Context) {
				this.setBindingContext(mSettings.bindingContexts);
			} else {
				for(sKey in mSettings.bindingContexts ) {
					this.setBindingContext(mSettings.bindingContexts[sKey], sKey === "undefined" ? undefined : sKey);
				}
			}
			delete mSettings.bindingContexts;
		}
		//process object bindings
		if ( mSettings.objectBindings ) {
			if ( typeof mSettings.objectBindings !== "string" && typeof mSettings.objectBindings !== "object" ) {
				throw new Error("binding must be a string or simple object");
			}
			if ( typeof mSettings.objectBindings === "string" || mSettings.objectBindings.path ) { // excludes "path" as model name
				this.bindObject(mSettings.objectBindings);
			} else {
				for(var sKey in mSettings.objectBindings ) {
					mSettings.objectBindings.model = sKey;
					this.bindObject(mSettings.objectBindings[sKey]);
				}
			}
			delete mSettings.objectBindings;
		}
		// process all settings
		// process settings
		for(sKey in mSettings) {
			// get info object for the key
			if ( oKeyInfo = mValidKeys[sKey] ) {
				oValue = mSettings[sKey];
				switch(oKeyInfo._iKind) {
				case 0: // PROPERTY
					var oBindingInfo = this.extractBindingInfo(oValue, oScope);
					if (oBindingInfo && typeof oBindingInfo === "object") {
						this.bindProperty(sKey, oBindingInfo);
					} else {
						this[oKeyInfo._sMutator](oBindingInfo || oValue);
					}
					break;
				case 1: // SINGLE_AGGREGATION
					var oBindingInfo = oKeyInfo.altTypes && this.extractBindingInfo(oValue, oScope); 
					if ( oBindingInfo && typeof oBindingInfo === "object" ) {
						this.bindProperty(sKey, oBindingInfo);
					} else {
						this[oKeyInfo._sMutator](makeObject(oBindingInfo || oValue, oKeyInfo));
					}
					break;
				case 2: // MULTIPLE_AGGREGATION
					var oBindingInfo = this.extractBindingInfo(oValue, oScope); 
					if (oBindingInfo && typeof oBindingInfo === "object" ) {
						this.bindAggregation(sKey, oBindingInfo);
					} else {
						oValue = oBindingInfo || oValue; // could be an unescaped string if altTypes contains 'string'
						if ( oValue && !jQuery.isArray(oValue) ) {
							oValue = [oValue];
						}
						if ( oValue ) {
							for(var i=0,l=oValue.length; i<l; i++) {
								this[oKeyInfo._sMutator](makeObject(oValue[i], oKeyInfo));
							}
						}
					}
					break;
				case 3: // SINGLE_ASSOCIATION
					this[oKeyInfo._sMutator](oValue);
					break;
				case 4: // MULTIPLE_ASSOCIATION
					if ( oValue && !jQuery.isArray(oValue) ) {
						oValue = [oValue];
					}
					if ( oValue ) {
						for(var i=0,l=oValue.length; i<l; i++) {
							this[oKeyInfo._sMutator](oValue[i]);
						}
					}
					break;
				case 5: // EVENT
					if ( typeof oValue == "function" ) {
						this[oKeyInfo._sMutator](oValue);
					}
					else {
						this[oKeyInfo._sMutator](oValue[0], oValue[1], oValue[2]);
					}
						//this[oKeyInfo._sMutator].apply(this, oValue); // could be replacement for line before
					break;
				default:
					break;
				}
			}
		}
	
		return this;
	};
	
	/**
	 * Returns a simple string representation of this managed object.
	 *
	 * Mainly useful for tracing purposes.
	 * @public
	 * @return {string} a string description of this managed object
	 * @name sap.ui.base.ManagedObject#toString
	 * @function
	 */
	ManagedObject.prototype.toString = function() {
		return "ManagedObject " + this.getMetadata().getName() + "#" + this.getId();
	};
	
	/**
	 * Returns the object's Id.
	 *
	 * @return {string} the objects's Id.
	 * @public
	 * @name sap.ui.base.ManagedObject#getId
	 * @function
	 */
	ManagedObject.prototype.getId = function() {
		return this.sId;
	};
	
	
	/**
	 * Sets a new value for the given property <code>sPropertyName</code> and marks
	 * this object as changed. If the given <code>oValue</code> equals the
	 * current value, nothing happens.
	 *
	 * @param {string}  sPropertyName name of the property to set
	 * @param {any}     oValue value to set the property to
	 * @param {boolean} [bSuppressInvalidate] if true, the managed is not marked as changed
	 * @return {sap.ui.base.ManagedObject} Returns <code>this</code> to allow method chaining
	 * TODO better name bSuppressInvalidate positive, e.g. "bStayValid"
	 * @protected
	 * @name sap.ui.base.ManagedObject#setProperty
	 * @function
	 */
	ManagedObject.prototype.setProperty = function(sPropertyName, oValue, bSuppressInvalidate) {
	
		// check for a value change
		var oOldValue = this.mProperties[sPropertyName];
	
		// value validation
		oValue = this.validateProperty(sPropertyName, oValue);
	
		if (jQuery.sap.equal(oOldValue, oValue)) {
			return this;
		} // no change
		
		// set suppress invalidate flag
		if (bSuppressInvalidate) {
			//Refresh only for property changes with suppressed invalidation (others lead to rerendering and refresh is handled there)
			jQuery.sap.act.refresh();
			this.iSuppressInvalidate++;
		}
	
		// change the property (and invalidate if the rendering should be updated)
		this.mProperties[sPropertyName] = oValue;
		if (!this.isInvalidateSuppressed()) {
			this.invalidate();
		}
	
		// check whether property is bound and update model in case of two way binding
		this.updateModelProperty(sPropertyName, oValue, oOldValue);
	
		// prototype for generic property change events
		// TODO: THINK ABOUT CONFIGURATION TO ENABLE THIS
		EventProvider.prototype.fireEvent.apply(this, ["_change", {
			"id": this.getId(),
			"name": sPropertyName,
			"oldValue": oOldValue,
			"newValue": oValue
		}]);
	
		// reset suppress invalidate flag
		if (bSuppressInvalidate) {
			this.iSuppressInvalidate--;
		}
	
		return this;
	};
	
	/**
	 * Returns the value for the property with the given <code>sPropertyName</code>
	 *
	 * @param {string} sPropertyName the name of the property
	 * @type any
	 * @return the value of the property
	 * @protected
	 * @name sap.ui.base.ManagedObject#getProperty
	 * @function
	 */
	ManagedObject.prototype.getProperty = function(sPropertyName) {
		var oValue = this.mProperties[sPropertyName],
			oMetadata = this.getMetadata(),
			oProperty = oMetadata.getAllProperties()[sPropertyName],
			oType;
	
		if (!oProperty) {
			throw new Error("Property \"" + sPropertyName + "\" does not exist in " + this);
		}
	
		oType = DataType.getType(oProperty.type);
	
		// If property has an array type, clone the array to avoid modification of original data
		if (oType instanceof DataType && oType.isArrayType() && jQuery.isArray(oValue)) {
			oValue = oValue.slice(0);
		}
		
		// If proprerty is of type String instead of string, convert with valueOf()
		if (oValue instanceof String) {
			oValue = oValue.valueOf();
		}
		
		return oValue;
	};
	
	/**
	 * Checks whether the given value is of the proper type for the given property name. In case null or undefined is
	 * passed, the default value for this property is returned.
	 *
	 * @param {string} sPropertyName the name of the property
	 * @param {any} oValue the value
	 * @return {any} the passed value or the property's default value if null or undefined was passed
	 * @throws Error if no property with the given name is found or the given value does not fit to the property type
	 * @protected
	 * @name sap.ui.base.ManagedObject#validateProperty
	 * @function
	 */
	ManagedObject.prototype.validateProperty = function(sPropertyName, oValue) {
		var oMetadata = this.getMetadata(),
			oProperty = oMetadata.getAllProperties()[sPropertyName],
			oType;
	
		if (!oProperty) {
			throw new Error("Property \"" + sPropertyName + "\" does not exist in " + this);
		}
	
		oType = DataType.getType(oProperty.type);
	
		// If property has an array type, clone the array to avoid modification of original data
		if (oType instanceof DataType && oType.isArrayType() && jQuery.isArray(oValue)) {
			oValue = oValue.slice(0);
		}
		
		// In case null is passed as the value return the default value, either from the property or from the type
		if (oValue === null || oValue === undefined) {
			if (oProperty.defaultValue !== null) {
				oValue = oProperty.defaultValue;
			} else {
				oValue = oType.getDefaultValue();
			}
		} else if (oType instanceof DataType) {
			// Implicit casting for string only, other types are causing errors
	
			if (oType.getName() == "string") {
				if (!(typeof oValue == "string" || oValue instanceof String)) {
					oValue = "" + oValue;
				}
			} else if (oType.getName() == "string[]") {
				for (var i = 0; i < oValue.length; i++) {
					if (!typeof oValue[i] == "string") {
						oValue[i] = "" + oValue[i];
					}
				}
			} else if (!oType.isValid(oValue)) {
				throw new Error("\"" + oValue + "\" is of type " + typeof oValue + ", expected " +
						oType.getName() + " for property \"" + sPropertyName + "\" of " + this);
			}
		} else if (!(oValue in oType)){ // Enumeration
			throw new Error("\"" + oValue + "\" is not a valid entry of the enumeration for property \"" + sPropertyName + "\" of " + this);
		}
	
		// Normalize the value (if a normalizer was set using the setNormalizer method on the type)
		if (oType && oType.normalize && typeof oType.normalize === "function") {
			oValue = oType.normalize(oValue);
		}
	
		return oValue;
	};
	
	/**
	 * Returns the origin info on the property value of the given property name
	 *
	 * @param {string} sPropertyName the name of the property
	 * @return {object} a map of properties describing the origin of this property value or null
	 * @public
	 * @name sap.ui.base.ManagedObject#getOriginInfo
	 * @function
	 */
	ManagedObject.prototype.getOriginInfo = function(sPropertyName) {
		var oValue = this.mProperties[sPropertyName];
		if (!(oValue instanceof String && oValue.originInfo)) {
			return null;
		}
		return oValue.originInfo;
	};
	
	
	// ######################################################################################################
	// Associations
	// ######################################################################################################
	
	/**
	 * Sets an association for the managed object
	 *
	 * @param {string}
	 *            sAssociationName name of the association
	 * @param {string | sap.ui.base.ManagedObject}
	 *            sId the ID of the managed object that is set as an association, or the managed object itself or null
	 * @param {boolean}
	 *            [bSuppressInvalidate] if true, the managed objects invalidate method is not called
	 * @return {sap.ui.base.ManagedObject} Returns <code>this</code> to allow method chaining
	 * @protected
	 * @name sap.ui.base.ManagedObject#setAssociation
	 * @function
	 */
	ManagedObject.prototype.setAssociation = function(sAssociationName, sId, bSuppressInvalidate) {
		if (sId instanceof ManagedObject) {
			sId = sId.getId();
		} else if (sId != null && typeof sId !== "string") {
			jQuery.sap.assert(false, "setAssociation(): sId must be a string, an instance of sap.ui.base.ManagedObject or null");
			return this;
		}
	
		if (this.mAssociations[sAssociationName] === sId) {
			return this;
		} // no change
	
		// set suppress invalidate flag
		if (bSuppressInvalidate) {
			this.iSuppressInvalidate++;
		}
	
		this.mAssociations[sAssociationName] = sId;
	
		if (!this.isInvalidateSuppressed()) {
			this.invalidate();
		}
	
		// reset suppress invalidate flag
		if (bSuppressInvalidate) {
			this.iSuppressInvalidate--;
		}
	
		return this;
	};
	
	/**
	 * Returns an association of the managed object with a given sAssociationName
	 *
	 * @param {string} sAssociationName the name of the association
	 * @param {object}
	 *			  oDefaultForCreation the object that is used in case the current aggregation is empty (only null or empty array allowed)
	 * @return {string | string[]} the ID of the associated managed object or an array of such IDs; may be null if the association has not been populated
	 * @protected
	 * @name sap.ui.base.ManagedObject#getAssociation
	 * @function
	 */
	ManagedObject.prototype.getAssociation = function(sAssociationName, oDefaultForCreation) {
		var result = this.mAssociations[sAssociationName];
	
		if (!result) {
			result = this.mAssociations[sAssociationName] = oDefaultForCreation || null;
		} else {
			if (typeof result.length === 'number' && !(result.propertyIsEnumerable('length')) ) {
				// Return a copy of the array instead of the array itself as reference!!
				return result.slice();
			}
			// simple type or ManagedObject
			return result;
		}
	
		return result;
	};
	
	/**
	 * Adds some entity with the ID <code>sId</code> to the association identified by <code>sAssociationName</code>.
	 *
	 * @param {string}
	 *            sAssociationName the string identifying the association the object should be added to.
	 * @param {string | sap.ui.base.ManagedObject}
	 *            sId the ID of the managed object to add; if empty, nothing is added; if a <code>sap.ui.base.ManagedObject</code> is given, its ID is added
	 * @param {boolean}
	 *            [bSuppressInvalidate] if true, this managed object as well as the newly associated object are not marked as changed
	 * @return {sap.ui.base.ManagedObject} Returns <code>this</code> to allow method chaining
	 * @protected
	 * @name sap.ui.base.ManagedObject#addAssociation
	 * @function
	 */
	ManagedObject.prototype.addAssociation = function(sAssociationName, sId, bSuppressInvalidate) {
		if (sId instanceof ManagedObject) {
			sId = sId.getId();
		} else if (typeof sId !== "string") {
		  // TODO what about empty string?
	    jQuery.sap.assert(false, "addAssociation(): sId must be a string or an instance of sap.ui.base.ManagedObject");
			return this;
		}
	
		// set suppress invalidate flag
		if (bSuppressInvalidate) {
			this.iSuppressInvalidate++;
		}
	
		var aIds = this.mAssociations[sAssociationName];
		if (!aIds) {
			aIds = this.mAssociations[sAssociationName] = [sId];
		} else {
			aIds.push(sId);
		}
	
		if (!this.isInvalidateSuppressed()) {
			this.invalidate();
		}
	
		// reset suppress invalidate flag
		if (bSuppressInvalidate) {
			this.iSuppressInvalidate--;
		}
	
		return this;
	};
	
	/**
	 * Removes a ManagedObject from the association named <code>sAssociationName</code>.
	 *
	 * @param {string}
	 *            sAssociationName the string identifying the association the ManagedObject should be removed from.
	 * @param {int | string | sap.ui.base.ManagedObject}
	 *            vObject the position or ID of the ManagedObject to remove or the ManagedObject itself; if <code>vObject</code> is invalid input,
	 *            a negative value or a value greater or equal than the current size of the association, nothing is removed
	 * @param {boolean}
	 *            [bSuppressInvalidate] if true, the managed object is not marked as changed
	 * @return the ID of the removed ManagedObject or null
	 * @protected
	 * @name sap.ui.base.ManagedObject#removeAssociation
	 * @function
	 */
	ManagedObject.prototype.removeAssociation = function(sAssociationName, vObject, bSuppressInvalidate) {
		var aIds = this.mAssociations[sAssociationName];
		var sId = null;
	
		// set suppress invalidate flag
		if (bSuppressInvalidate) {
			this.iSuppressInvalidate++;
		}
	
		if (typeof(vObject) == "object" && vObject.getId) { // object itself is given
			vObject = vObject.getId();
		}
	
		if (typeof(vObject) == "string") { // ID of the object is given or has just been retrieved
			for (var i = 0; i < aIds.length; i++) {
				if (aIds[i] == vObject) {
					vObject = i;
					break;
				}
			}
		}
	
		if (typeof(vObject) == "number") { // "object" is the index now
			if (vObject < 0 || vObject >= aIds.length) {
				jQuery.sap.log.warning("ManagedObject.removeAssociation called with invalid index: " + sAssociationName + ", " + vObject);
			} else {
				sId = aIds[vObject];
				aIds.splice(vObject, 1);
				if (!this.isInvalidateSuppressed()) {
					this.invalidate();
				}
			}
		}
	
		// reset suppress invalidate flag
		if (bSuppressInvalidate) {
			this.iSuppressInvalidate--;
		}
	
		return sId;
	};
	
	/**
	 * Removes all the objects in the 0..n-association named <code>sAssociationName</code> (and returns them in an array).<br/>
	 *
	 * @param {string}
	 *            sAssociationName the name of the association
	 * @param {boolean}
	 *            [bSuppressInvalidate] if true, this ManagedObject is not marked as changed
	 * @type Array
	 * @return an array with the IDs of the removed objects (might be empty)
	 * @protected
	 * @name sap.ui.base.ManagedObject#removeAllAssociation
	 * @function
	 */
	ManagedObject.prototype.removeAllAssociation = function(sAssociationName, bSuppressInvalidate){
		var aIds = this.mAssociations[sAssociationName];
		if (!aIds)	{
			return [];
		}
	
		// set suppress invalidate flag
		if (bSuppressInvalidate) {
			this.iSuppressInvalidate++;
		}
	
		delete this.mAssociations[sAssociationName];
		if (!this.isInvalidateSuppressed()) {
			this.invalidate();
		}
	
		// reset suppress invalidate flag
		if (bSuppressInvalidate) {
			this.iSuppressInvalidate--;
		}
	
		return aIds;
	};
	
	// ######################################################################################################
	// End of Associations
	// ######################################################################################################
	
	
	// ######################################################################################################
	// Aggregations
	// ######################################################################################################
	
	/**
	 * Checks whether the given value is of the proper type for the given aggregation name. 
	 *
	 * @param {string} sAggregationName the name of the aggregation
	 * @param {sap.ui.base.ManagedObject|any} oObject the aggregated object or a primitive value
	 * @param {boolean} bMultiple whether the aggregation must have cardinality 0..n
	 * @return {sap.ui.base.ManagedObject|any} the passed object
	 * @throws Error if no aggregation with the given name is found or the given value does not fit to the aggregation type
	 * @protected
	 * @name sap.ui.base.ManagedObject#validateAggregation
	 * @function
	 */
	ManagedObject.prototype.validateAggregation = function(sAggregationName, oObject, bMultiple) {
		var oMetadata = this.getMetadata(),
			oAggregation = oMetadata.getManagedAggregation(sAggregationName), // public or private
			aAltTypes,
			oType,
			i,
			msg;
	
		// undeclared aggregation 
		if (!oAggregation) {
			if(sAggregationName && oMetadata._mHiddenAggregations && oMetadata._mHiddenAggregations[sAggregationName]){
				oAggregation = oMetadata._mHiddenAggregations[sAggregationName];
				jQuery.sap.log.error("Support for '_mHiddenAggregations' is about to be removed (with 1.12 latest). Hidden aggregations like '" + oMetadata.getName() + "." + sAggregationName + "' instead can be declared like normal aggregations but with visibility:'hidden'.");
			}else{
				msg = "Aggregation \"" + sAggregationName + "\" does not exist in " + this;
				
				if ( /^sap\.(ui\.core|ui\.commons|ui\.table|ui\.ux3|m|makit|viz|uiext\.inbox)$/.test(oMetadata.getLibraryName() || "") ) {
					throw new Error(msg);
				} else {
					// TODO throw for any lib as soon as "hidden" aggregations are a public feature.
					// Otherwise, composite controls currently would have no legal way to react 
					jQuery.sap.log.error("Support for undeclared aggregations is about to be removed (with 1.12 latest). Hidden aggregations like '" + oMetadata.getName() + "." + sAggregationName + "' can be declared like normal aggregations but with visibility:'hidden'.");
					jQuery.sap.assert(false, msg);
					return oObject;
				}
			}
		}
	
		if (oAggregation.multiple !== bMultiple ) {
			throw new Error("Aggregation '" + sAggregationName + "' of " + this + " used with wrong cardinality (declared as " + (oAggregation.multiple ? "0..n" : "0..1") + ")");
		}
		
		//Null is a valid value for 0..1 aggregations
		if(!oAggregation.multiple && !oObject){
			return oObject;
		}
		
		oType = jQuery.sap.getObject(oAggregation.type);
		// class types
		if ( typeof oType === "function" && oObject instanceof oType ) {
			return oObject;
		}
		// interfaces 
		if ( oObject && oObject.getMetadata && oObject.getMetadata().isInstanceOf(oAggregation.type) ) {
			return oObject;
		}
		// alternative types
		aAltTypes = oAggregation.altTypes;
		if ( aAltTypes && aAltTypes.length ) {
			// for primitive types, null or undefined is valid as well 
			if ( oObject == null ) {
				return oObject;
			}
			for (i=0; i<aAltTypes.length; i++) {
				oType = DataType.getType(aAltTypes[i]);
				if (oType instanceof DataType) {
					if (oType.isValid(oObject)) {
						return oObject;
					}
				} else if (oObject in oType) { // Enumeration
					return oObject;
				}
			}
		}
	
		// TODO make this stronger again (e.g. for FormattedText)
		msg = "\"" + oObject + "\" is not valid for aggregation \"" + sAggregationName + "\" of " + this;
		if ( DataType.isInterfaceType(oAggregation.type) ) {
			jQuery.sap.assert(false, msg);
			return oObject;
		} else {
		  throw new Error(msg);
		}
	};
	
	/**
	 * Sets an aggregation for the managed object
	 *
	 * @param {string}
	 *            sAggregationName name of the aggregation
	 * @param {object}
	 *            oObject the managed object that is set as an aggregation
	 * @param {boolean}
	 *            [bSuppressInvalidate] if true, this ManagedObject is not marked as changed
	 * @return {sap.ui.base.ManagedObject} Returns <code>this</code> to allow method chaining
	 * @protected
	 * @name sap.ui.base.ManagedObject#setAggregation
	 * @function
	 */
	ManagedObject.prototype.setAggregation = function(sAggregationName, oObject, bSuppressInvalidate) {
		var oOldChild = this.mAggregations[sAggregationName];
		if (oOldChild === oObject) {
			return this;
		} // no change
		oObject = this.validateAggregation(sAggregationName, oObject, /* multiple */ false); 
	
		// set suppress invalidate flag
		if (bSuppressInvalidate) {
			this.iSuppressInvalidate++;
		}
	
		if (oOldChild instanceof ManagedObject) { // remove old child
			oOldChild.setParent(null);
		}
		this.mAggregations[sAggregationName] = oObject;
		if (oObject instanceof ManagedObject) { // adopt new child
			oObject.setParent(this, sAggregationName, bSuppressInvalidate);
		} else {
			if (!this.isInvalidateSuppressed()) {
				this.invalidate();
			}
		}
	
		// reset suppress invalidate flag
		if (bSuppressInvalidate) {
			this.iSuppressInvalidate--;
		}
	
		return this;
	};
	
	/**
	 * Returns an aggregation of the managed object with a given sAggregationName
	 *
	 * @param {string}
	 *            sAggregationName the name of the aggregation
	 * @param {sap.ui.base.ManagedObject | Array}
	 *			  oDefaultForCreation the object that is used in case the current aggregation is empty
	 * @type sap.ui.base.ManagedObject|Array
	 * @return the aggregation array in case of 0..n-aggregations or the managed object or null in case of 0..1-aggregations
	 * @protected
	 * @name sap.ui.base.ManagedObject#getAggregation
	 * @function
	 */
	ManagedObject.prototype.getAggregation = function(sAggregationName, oDefaultForCreation) {
		var aChildren = this.mAggregations[sAggregationName];
		if (!aChildren) {
			aChildren = this.mAggregations[sAggregationName] = oDefaultForCreation || null;
		}
		if (aChildren) {
			if (typeof aChildren.length === 'number' && !(aChildren.propertyIsEnumerable('length')) ) {
				// Return a copy of the array instead of the array itself as reference!!
				return aChildren.slice();
			}
			// simple type or ManagedObject
			return aChildren;
		} else {
			return null;
		}
	};
	
	/**
	 * Checks for the provided managed object <code>oObject</code> in the aggregation
	 * named <code>sAggregationName</code> and returns its index if found, or -1
	 * otherwise. Returns -2 if the given named aggregation is not a multiple one
	 * (and does not contain the given child).
	 *
	 * @param {string}
	 *            sAggregationName the name of the aggregation
	 * @param {sap.ui.base.ManagedObject}
	 *            oObject the ManagedObject whose index is looked for.
	 * @return {int} the index of the provided managed object in the aggregation.
	 * @protected
	 * @name sap.ui.base.ManagedObject#indexOfAggregation
	 * @function
	 */
	ManagedObject.prototype.indexOfAggregation = function(sAggregationName, oObject) {
		var aChildren = this.mAggregations[sAggregationName];
		if (aChildren) {
			if (aChildren.length == undefined) {
				return -2;
			} // not a multiple aggregation
	
			for (var i = 0; i < aChildren.length; i++) {
				if (aChildren[i] == oObject) {
					return i;
				}
			}
		}
		return -1;
	};
	
	/**
	 * Inserts managed object <code>oObject</code> to the aggregation named <code>sAggregationName</code> at
	 * position <code>iIndex</code>.
	 *
	 * @param {string}
	 *            sAggregationName the string identifying the aggregation the managed object <code>oObject</code>
	 *            should be inserted into.
	 * @param {sap.ui.base.ManagedObject}
	 *            oObject the ManagedObject to add; if empty, nothing is inserted.
	 * @param {int}
	 *            iIndex the <code>0</code>-based index the managed object should be inserted at; for a negative
	 *            value <code>iIndex</code>, <code>oObject</code> is inserted at position 0; for a value
	 *            greater than the current size of the aggregation, <code>oObject</code> is inserted at
	 *            the last position
	 * @param {boolean}
	 *            [bSuppressInvalidate] if true, this ManagedObject as well as the added child are not marked as changed
	 * @return {sap.ui.base.ManagedObject} Returns <code>this</code> to allow method chaining
	 * @protected
	 * @name sap.ui.base.ManagedObject#insertAggregation
	 * @function
	 */
	ManagedObject.prototype.insertAggregation = function(sAggregationName, oObject, iIndex, bSuppressInvalidate) {
		if (!oObject) {
			return this;
		}
		oObject = this.validateAggregation(sAggregationName, oObject, /* multiple */ true);
	
		var aChildren = this.mAggregations[sAggregationName] || (this.mAggregations[sAggregationName] = []);
		// force index into valid range 
		var i = iIndex < 0 ? 0 : (iIndex > aChildren.length ? aChildren.length : iIndex);
		if (i !== iIndex) {
			jQuery.sap.log.warning("ManagedObject.insertAggregation: index '" + iIndex + "' out of range [0," + aChildren.length + "], forced to " + i);
		}
		aChildren.splice(i, 0, oObject);
		oObject.setParent(this, sAggregationName, bSuppressInvalidate);
	
		return this;
	};
	
	/**
	 * Adds some entity <code>oObject</code> to the aggregation identified by <code>sAggregationName</code>.
	 *
	 * @param {string}
	 *            sAggregationName the string identifying the aggregation that <code>oObject</code> should be added to.
	 * @param {sap.ui.base.ManagedObject}
	 *            oObject the object to add; if empty, nothing is added
	 * @param {boolean}
	 *            [bSuppressInvalidate] if true, this ManagedObject as well as the added child are not marked as changed
	 * @return {sap.ui.base.ManagedObject} Returns <code>this</code> to allow method chaining
	 * @protected
	 * @name sap.ui.base.ManagedObject#addAggregation
	 * @function
	 */
	ManagedObject.prototype.addAggregation = function(sAggregationName, oObject, bSuppressInvalidate) {
		if (!oObject) {
			return this;
		}
		oObject = this.validateAggregation(sAggregationName, oObject, /* multiple */ true);
	
		var aChildren = this.mAggregations[sAggregationName];
		if (!aChildren) {
			aChildren = this.mAggregations[sAggregationName] = [oObject];
		} else {
			aChildren.push(oObject);
		}
		oObject.setParent(this, sAggregationName, bSuppressInvalidate);
		return this;
	};
	
	/**
	 * Removes an object from the aggregation named <code>sAggregationName</code>.
	 *
	 * @param {string}
	 *            sAggregationName the string identifying the aggregation the ManagedObject should be removed from
	 * @param {int | string | sap.ui.base.ManagedObject}
	 *            vObject the position or ID of the ManagedObject to remove or the ManagedObject itself; if <code>vObject</code> is invalid,
	 *            a negative value or a value greater or equal than the current size of the aggregation, nothing is removed
	 * @param {boolean}
	 *            [bSuppressInvalidate] if true, this ManagedObject is not marked as changed
	 * @type sap.ui.base.ManagedObject
	 * @return the removed object or null
	 * @protected
	 * @name sap.ui.base.ManagedObject#removeAggregation
	 * @function
	 */
	ManagedObject.prototype.removeAggregation = function(sAggregationName, vObject, bSuppressInvalidate) {
		var aChildren = this.mAggregations[sAggregationName],
			oChild=null,
			i;
	
		if ( !aChildren ) {
			return null;
		}
		
		// set suppress invalidate flag
		if (bSuppressInvalidate) {
			this.iSuppressInvalidate++;
		}
	
		if (typeof(vObject) == "string") { // ID of the object is given
			// Note: old lookup via sap.ui.getCore().byId(vObject) only worked for Elements, not for managed objects in general!
			for (i = 0; i < aChildren.length; i++) {
				if (aChildren[i] && aChildren[i].getId() === vObject) {
					vObject = i;
					break;
				}
			}
		}
		
		if (typeof(vObject) == "object") { // the object itself is given or has just been retrieved
			for (i = 0; i < aChildren.length; i++) {
				if (aChildren[i] == vObject) {
					vObject = i;
					break;
				}
			}
		}
	
		if (typeof(vObject) == "number") { // "vObject" is the index now
			if (vObject < 0 || vObject >= aChildren.length) {
				jQuery.sap.log.warning("ManagedObject.removeAggregation called with invalid index: " + sAggregationName + ", " + vObject);
		
			} else {
				oChild = aChildren[vObject];
				aChildren.splice(vObject, 1); // first remove it from array, then call setParent (avoids endless recursion)
				oChild.setParent(null);
				if (!this.isInvalidateSuppressed()) {
					this.invalidate();
				}
			}
		}
	
		// reset suppress invalidate flag
		if (bSuppressInvalidate) {
			this.iSuppressInvalidate--;
		}
	
		return oChild;
	};
	
	/**
	 * Removes all the controls in the 0..n-aggregation named <code>sAggregationName</code> (and returns them in an array).<br/>
	 * Additionally unregisters them from the hosting UIArea.
	 *
	 * @param {string}
	 *            sAggregationName the name of the aggregation
	 * @param {boolean}
	 *            [bSuppressInvalidate] if true, this ManagedObject is not marked as changed
	 * @type Array
	 * @return an array of the removed elements (might be empty)
	 * @protected
	 * @name sap.ui.base.ManagedObject#removeAllAggregation
	 * @function
	 */
	ManagedObject.prototype.removeAllAggregation = function(sAggregationName, bSuppressInvalidate){
		var aChildren = this.mAggregations[sAggregationName];
		if (!aChildren)	{
			return [];
		}
	
		// set suppress invalidate flag
		if (bSuppressInvalidate) {
			this.iSuppressInvalidate++;
		}
	
		delete this.mAggregations[sAggregationName];
		for (var i = 0; i < aChildren.length; i++) {
			aChildren[i].setParent(null);
		}
		if (!this.isInvalidateSuppressed()) {
			this.invalidate();
		}
	
		// reset suppress invalidate flag
		if (bSuppressInvalidate) {
			this.iSuppressInvalidate--;
		}
	
		return aChildren;
	};
	
	/**
	 * Destroys (all) the managed object(s) in the aggregation named <code>sAggregationName</code> and afterwards empties the
	 * aggregation.
	 *
	 * @param {string}
	 *            sAggregationName the name of the aggregation
	 * @param {boolean}
	 *            [bSuppressInvalidate] if true, this ManagedObject is not marked as changed
	 * @return {sap.ui.base.ManagedObject} Returns <code>this</code> to allow method chaining
	 * @protected
	 * @name sap.ui.base.ManagedObject#destroyAggregation
	 * @function
	 */
	ManagedObject.prototype.destroyAggregation = function(sAggregationName, bSuppressInvalidate){
		var aChildren = this.mAggregations[sAggregationName],
			i, aChild;
		
		if (!aChildren) {
			return this;
		}
	
		// set suppress invalidate flag
		if (bSuppressInvalidate) {
			this.iSuppressInvalidate++;
		}
	
		// Deleting the aggregation here before destroying the children is a BUG:
		//
		// The destroy() method on the children calls _removeChild() on this instance
		// to properly remove each child from the bookkeeping by executing the named
		// removeXYZ() method. But as the aggegation is deleted here already, 
		// _removeChild() doesn't find the child in the bookkeeping and therefore 
		// refuses to work. Asa result ,side effects from removeXYZ() are missing.
		// 
		// The lines below marked with 'FIXME DESTROY' sketch a potential fix, but 
		// that fix has proven to be incompatible for several controls that don't 
		// properly implement removeXYZ(). As this might affect custom controls
		// as well, the fix has been postponed.
		//
		delete this.mAggregations[sAggregationName]; //FIXME DESTROY: should be removed here
		
		if (aChildren instanceof ManagedObject) {
			// FIXME DESTROY: this._removeChild(aChildren, sAggregationName, bSuppressInvalidate); // (optional, done by destroy())
			aChildren.destroy(bSuppressInvalidate);
		} else if (jQuery.isArray(aChildren)) {
			for (i = aChildren.length-1; i >= 0; i--) {
				aChild = aChildren[i];
				if (aChild) {
					// FIXME DESTROY: this._removeChild(aChild, sAggregationName, bSuppressInvalidate); // (optional, done by destroy())
					aChild.destroy(bSuppressInvalidate);
				}
			}
		}
		
		// FIXME DESTROY: // 'delete' aggregation only now so that _removeChild() can still do its cleanup
		// FIXME DESTROY: delete this.mAggregations[sAggregationName];
	
		if (!this.isInvalidateSuppressed()) {
			this.invalidate();
		}
	
		// reset suppress invalidate flag
		if (bSuppressInvalidate) {
			this.iSuppressInvalidate--;
		}
	
		return this;
	};
	
	// ######################################################################################################
	// End of Aggregations
	// ######################################################################################################
	
	
	/**
	 * This triggers rerendering of itself and its children.<br/> As <code>sap.ui.base.ManagedObject</code> "bubbles up" the
	 * invalidate, changes to child-<code>Elements</code> will also result in rerendering of the whole sub tree.
	 * @protected
	 * @name sap.ui.base.ManagedObject#invalidate
	 * @function
	 */
	ManagedObject.prototype.invalidate = function() {
		if (this.oParent) {
			this.oParent.invalidate(this);
		}
	};
	
	
	/**
	 * Returns whether rerendering is currently suppressed on this ManagedObject
	 * @return boolean
	 * @protected
	 * @name sap.ui.base.ManagedObject#isInvalidateSuppressed
	 * @function
	 */
	ManagedObject.prototype.isInvalidateSuppressed = function() {
		var bInvalidateSuppressed = this.iSuppressInvalidate > 0;
		if (this.oParent && this.oParent instanceof ManagedObject) {
			bInvalidateSuppressed = bInvalidateSuppressed || this.oParent.isInvalidateSuppressed();
		}
		return bInvalidateSuppressed;
	};
	
	
	/**
	 * Removes the given child from this object's named aggregation.
	 * @see sap.ui.core.UIArea#_removeChild
	 * @see sap.ui.base.ManagedObject#setParent
	 *
	 * @param {sap.ui.base.ManagedObject}
	 *            oChild the child object to be removed
	 * @param {string}
	 *            sAggregationName the name of this object's aggregation
	 * @param {boolean}
	 *            [bSuppressInvalidate] if true, this ManagedObject is not marked as changed
	 * @private
	 * @name sap.ui.base.ManagedObject#_removeChild
	 * @function
	 */
	ManagedObject.prototype._removeChild = function(oChild, sAggregationName, bSuppressInvalidate) {
		if (!sAggregationName) {
			// an aggregation name has to be specified!
			jQuery.sap.log.error("Cannot remove aggregated child without aggregation name.", null, this);
		} else {
			// set suppress invalidate flag
			if (bSuppressInvalidate) {
				this.iSuppressInvalidate++;
			}
	
			var iIndex = this.indexOfAggregation(sAggregationName, oChild);
			var oAggregationInfo = this.getMetadata().getJSONKeys()[sAggregationName];
			// Note: we assume that this is the given child's parent, i.e. -1 not expected!
			if (iIndex == -2) { // 0..1
				if(oAggregationInfo && this[oAggregationInfo._sMutator]) { // TODO properly deal with hidden aggregations
					this[oAggregationInfo._sMutator](null);
				}
				else {
					this.setAggregation(sAggregationName, null, bSuppressInvalidate);
				}
			} else if(iIndex > -1 ) { // 0..n
				if(oAggregationInfo && this[oAggregationInfo._sRemoveMutator]) { // TODO properly deal with hidden aggregations
					this[oAggregationInfo._sRemoveMutator](iIndex);
				}
				else {
					this.removeAggregation(sAggregationName, iIndex, bSuppressInvalidate);
				}
			} else {
				// already removed!?
				// this is the unexpected -1
				// TODO: What would be better? Explicit removeCompositeChild callback on subclass?
			}
			if (!this.isInvalidateSuppressed()) {
				this.invalidate();
			}
	
			// reset suppress invalidate flag
			if (bSuppressInvalidate) {
				this.iSuppressInvalidate--;
			}
		}
	};
	
	/**
	 * Defines this object's new parent. If no new parent is given, the parent is
	 * just unset and we assume that the old parent has removed this child from its
	 * aggregation. But if a new parent is given, this child is first removed from
	 * its old parent.
	 *
	 * @param {sap.ui.base.ManagedObject}
	 *            oParent the object that becomes this objects's new parent
	 * @param {string}
	 *            sAggregationName the name of the parent objects's aggregation
	 * @param {boolean}
	 *            [bSuppressInvalidate] if true, this ManagedObject is not marked as changed. The old parent, however, is marked.
	 * @return {sap.ui.base.ManagedObject}
	 *            Returns <code>this</code> to allow method chaining
	 * @private
	 * @name sap.ui.base.ManagedObject#setParent
	 * @function
	 */
	ManagedObject.prototype.setParent = function(oParent, sAggregationName, bSuppressInvalidate) {
		var that = this;
	
		if ( !oParent ) {
			this.oParent = null;
			this.sParentAggregationName = null;
			this.oPropagatedProperties = {oModels:{}, oBindingContexts:{}};
			
			jQuery.sap.act.refresh();
			
			// Note: no need (and no way how) to invalidate
			return;
		}
	
		// set suppress invalidate flag
		if (bSuppressInvalidate) {
			//Refresh only for changes with suppressed invalidation (others lead to rerendering and refresh is handled there)
			jQuery.sap.act.refresh();
			this.iSuppressInvalidate++;
		}
	
		var oOldParent = this.getParent();
		if (oOldParent) { // remove this object from its old parent
			// Note: bSuppressInvalidate  by intention is not propagated to the old parent.
			// It is not sure whether the (direct or indirect) caller of setParent
			// has enough knowledge about the old parent to automatically propagate this.
			// If needed, callers can first remove the object from the oldParent (specifying a 
			// suitable value for bSuppressInvalidate there) and only then call setParent.
			oOldParent._removeChild(this, this.sParentAggregationName);  
		}
		// adopt new parent
		this.oParent = oParent;
		this.sParentAggregationName = sAggregationName;
		
		//get properties to propagate
		this.oPropagatedProperties = oParent._getPropertiesToPropagate();
		
		// update bindings
		if (this.hasModel()) {
			this.updateBindingContext(false, true, undefined, true);
			this.updateBindings(true,null); // TODO could be restricted to models that changed
			this.propagateProperties(true);
		}
	
		// only the parent knows where to render us, so we have to invalidate it
		if ( oParent && !this.isInvalidateSuppressed() ) {
			oParent.invalidate(this);
		}
	
		// reset suppress invalidate flag
		if (bSuppressInvalidate) {
			this.iSuppressInvalidate--;
		}
	
		return this;
	};
	
	/**
	 * Returns the parent managed object or <code>null</code> if this object hasn't been added to a parent yet.
	 *
	 * @return {sap.ui.base.ManagedObject} The parent managed object or <code>null</code>
	 * @public
	 * @name sap.ui.base.ManagedObject#getParent
	 * @function
	 */
	ManagedObject.prototype.getParent = function() {
		/* Be aware that internally this.oParent is used to reduce method calls. 
		 * Check for side effects when overriding this method */
		return this.oParent;
	};
	
	
	/**
	 * Cleans up the resources associated with this object and all its aggregated children.
	 *
	 * After an object has been destroyed, it can no longer be used in!
	 *
	 * Applications should call this method if they don't need the object any longer.
	 *
	 * @param {boolean}
	 *            [bSuppressInvalidate] if true, this ManagedObject is not marked as changed
	 * @public
	 * @name sap.ui.base.ManagedObject#destroy
	 * @function
	 */
	ManagedObject.prototype.destroy = function(bSuppressInvalidate) {
		var that = this;
	
		// jQuery.sap.log.debug("destroying " + this);
	
		// set suppress invalidate flag
		if (bSuppressInvalidate) {
			this.iSuppressInvalidate++;
		}
	
		if (this.exit) {
			this.exit();
		}
	
		// TODO: generic concept for exit hooks?
		if ( this._exitCompositeSupport ) {
			this._exitCompositeSupport();
		}
	
		// ensure that also our children are destroyed!!
		for(var oAggr in this.mAggregations){
			this.destroyAggregation(oAggr, bSuppressInvalidate);
		}
		
		// Deregister, if available
		if (this.deregister) this.deregister();
	
		// remove this child from parent aggregation
		if (this.oParent && this.sParentAggregationName) {
			this.oParent._removeChild(this, this.sParentAggregationName, bSuppressInvalidate);
		}
		// for robustness only - should have been cleared by _removeChild already
		delete this.oParent;
		
		// Data Binding
		jQuery.each(this.mBindingInfos, function(sName, oBindingInfo) {
			if (oBindingInfo.factory) {
				that.unbindAggregation(sName, true);
			} else {
				that.unbindProperty(sName, true);
			}
		});
	
		// reset suppress invalidate flag
		if (bSuppressInvalidate) {
			this.iSuppressInvalidate--;
		}
		
		EventProvider.prototype.destroy.apply(this, arguments);
	
		// finally make the object unusable
		this.setParent = function(){
			throw Error("The object with ID "+that.getId()+" was destroyed and cannot be used anymore.");
		};
	
		// make visible that it's been destroyed.
		this.bIsDestroyed = true;
	
	};
	
	
	// DataBinding
	/**
	 * Binding parser to use.
	 * @name sap.ui.base.ManagedObject.bindingParser
	 */
	ManagedObject.bindingParser = BindingParser.simpleParser;
	
	/**
	 * Determines whether a given object contains binding information instead of a
	 * value or aggregated controls. The method is used in applySettings for processing
	 * the JSON notation of properties/aggregations in the constructor.
	 *
	 * @param {object} oValue the value
	 * @param {object} oKeyInfo the metadata of the property
	 *
	 * @returns {boolean} whether the value contains binding information
	 *
	 * @private
	 * @deprecated
	 * @name sap.ui.base.ManagedObject#isBinding
	 * @function
	 */
	ManagedObject.prototype.isBinding = function(oValue, oKeyInfo) {
		return "object" === typeof this.extractBindingInfo(oValue);
	};
	
	/**
	 * Checks whether the given value can be interpreted as a binding info and 
	 * returns that binding info or an unescaped string or undefined when it is not.
	 *  
	 * When the 'complex' binding syntax is enabled, the function might also return
	 * a string value in case the given value was a string, did not represent a binding
	 * but contained escaped special characters.
	 * 
	 * There are two possible notations for binding information in the object literal notation 
	 * of the ManagedObject constructor and ManagedObject.applySettings:
	 * <ul>
	 *   <li>property: "{path}"
	 *   This is used for property binding and can only contain the path.
	 *   </li>
	 *   <li>property:{path:"path", template:oTemplate}
	 *   This is used for aggregation binding, where a template is required or can
	 *   be used for property binding when additional data is required (e.g. formatter).
	 *   </li>
	 * </ul>
	 * 
	 * @param {object} oValue
	 * @param {object} oScope
	 *
	 * @returns {object} the binding info object or an unescaped string or undefined. 
	 *     If a binding info is returned, it contains at least a path property
	 *     or nested bindings (parts) and, dependant of the binding type, 
	 *     additional properties
	 *
	 * @private
	 * @name sap.ui.base.ManagedObject#extractBindingInfo
	 * @function
	 */
	ManagedObject.prototype.extractBindingInfo = function(oValue, oScope) {
	
		// property:{path:"path", template:oTemplate}
		if (oValue && typeof oValue === "object") {
			if (oValue.ui5object) { 
				// if value contains ui5object property, this is not a binding info,
				// remove it and not check for path or parts property
				delete oValue.ui5object;
			} else if (oValue.path || oValue.parts) {
				// allow JSON syntax for templates
				if (oValue.template) {
					oValue.template = ManagedObject.create(oValue.template);
				}
				return oValue;
			}
		}
	
		// property:"{path}" or "\{path\}"
		if (typeof oValue === "string") {
			// either returns a binding info or an unescaped string or undefined - depending on binding syntax 
			return ManagedObject.bindingParser(oValue, oScope, true);
		}
	
		// return undefined;
	};
	
	/**
	 * Returns the binding infos for the given property or aggregation. The binding info contains information about path, binding object, format options,
	 * sorter, filter etc. for the property or aggregation.
	 *
	 * @param {string} sName the name of the property or aggregation
	 *
	 * @returns {object} the binding info object, containing at least a path property
	 *                   and, dependant of the binding type, additional properties
	 *
	 * @protected
	 * @name sap.ui.base.ManagedObject#getBindingInfo
	 * @function
	 */
	ManagedObject.prototype.getBindingInfo = function(sName) {
		return this.mBindingInfos[sName];
	};
	
	/**
	 * Bind the object to the referenced entity in the model, which is used as the binding context
	 * to resolve bound properties or aggregations of the object itself and all of its children
	 * relatively to the given path.
	 * If a relative binding path is used, this will be applied whenever the parent context changes.
	 * @param {string} sPath the binding path
	 * @param {object} [mParameters] map of additional parameters for this binding
	 *
	 * @return {sap.ui.base.ManagedObject} reference to the instance itself
	 * @public 
	 * @name sap.ui.base.ManagedObject#bindObject
	 * @function
	 */
	ManagedObject.prototype.bindObject = function(sPath, mParameters) {
		var boundObject = {},
			oldBoundObject,
			sModelName,
			iSeparatorPos;
		// support object notation
		if (typeof sPath == "object") {
			var oBindingInfo = sPath;
			sPath = oBindingInfo.path;
			mParameters = oBindingInfo.parameters;
			sModelName = oBindingInfo.model;
			boundObject.events = oBindingInfo.events;
		}
		// if a model separator is found in the path, extract model name and path
		iSeparatorPos = sPath.indexOf(">");
		boundObject.sBindingPath = sPath;
		boundObject.mBindingParameters = mParameters;
		if (iSeparatorPos > 0) {
			sModelName = sPath.substr(0, iSeparatorPos);
			boundObject.sBindingPath = sPath.substr(iSeparatorPos + 1);
		} 
		
		//if old binding exists detach handler
		oldBoundObject = this.mBoundObjects[sModelName];
		if (oldBoundObject && oldBoundObject.binding) {
			oldBoundObject.binding.detachChange(oldBoundObject.fChangeHandler);
			oldBoundObject.binding.detachEvents(oldBoundObject.events);
		}
		this.mBoundObjects[sModelName] = boundObject;
	
		// if the models are already available, create the binding
		if (this.getModel(sModelName)) {
			this._bindObject(sModelName, boundObject);
		}
		return this;
	};
	
	/**
	 * Create object binding
	 * 
	 * @private
	 * @name sap.ui.base.ManagedObject#_bindObject
	 * @function
	 */
	ManagedObject.prototype._bindObject = function(sModelName, oBoundObject) {
		var oBinding, 
			oParentContext, 
			oModel, 
			that = this;
		
		var fChangeHandler = function(oEvent) {
			that.setBindingContext(oBinding.getBoundContext(), sModelName);
		};
		
		oModel = this.getModel(sModelName);
		
		if (this.oParent && oModel == this.oParent.getModel(sModelName)) {
			oParentContext= this.oParent.getBindingContext(sModelName); 
		}
		
		oBinding = oModel.bindContext(oBoundObject.sBindingPath, oParentContext, oBoundObject.mBindingParameters);
		oBinding.attachChange(fChangeHandler);
		oBoundObject.binding = oBinding;
		oBoundObject.fChangeHandler = fChangeHandler;
		
		oBinding.attachEvents(oBoundObject.events);
		
		oBinding.initialize();
	};
	
	/**
	 * Bind the object to the referenced entity in the model, which is used as the binding context
	 * to resolve bound properties or aggregations of the object itself and all of its children
	 * relatively to the given path. 
	 * 
	 * @deprecated Since 1.11.1, please use bindElement instead.
	 * @param {string} sPath the binding path
	 * @return {sap.ui.base.ManagedObject} reference to the instance itself
	 * @public
	 * @name sap.ui.base.ManagedObject#bindContext
	 * @function
	 */
	ManagedObject.prototype.bindContext = function(sPath) {
		return this.bindElement(sPath);
	};
	
	/**
	 * Removes the defined binding context of this object, all bindings will now resolve
	 * relative to the parent context again.
	 *
	 * @deprecated Since 1.11.1, please use unbindElement instead.
	 * @param {string} [sModelName] name of the model to remove the context for. 
	 * @return {sap.ui.base.ManagedObject} reference to the instance itself
	 * @public
	 * @name sap.ui.base.ManagedObject#unbindContext
	 * @function
	 */
	ManagedObject.prototype.unbindContext = function(sModelName) {
		return this.unbindElement(sModelName);
	};
	
	/**
	 * Removes the defined binding context of this object, all bindings will now resolve
	 * relative to the parent context again.
	 *
	 * @param {string} [sModelName] name of the model to remove the context for. 
	 * @return {sap.ui.base.ManagedObject} reference to the instance itself
	 * @public
	 * @name sap.ui.base.ManagedObject#unbindObject
	 * @function
	 */
	ManagedObject.prototype.unbindObject = function(sModelName) {
		//TODO detach changerHandler
		var oBoundObject = this.mBoundObjects[sModelName]; 
		if (oBoundObject) {
			if (oBoundObject.binding) {
				oBoundObject.binding.detachChange(oBoundObject.fChangeHandler)
				oBoundObject.binding.detachEvents(oBoundObject.events);
			}
			delete this.mBoundObjects[sModelName]
			delete this.oBindingContexts[sModelName];
			this.updateBindingContext(false, false, sModelName);
		}
		return this;
	};
	
	/**
	 * Bind a property to the model.
	 * The Setter for the given property will be called with the value retrieved
	 * from the data model.
	 * This is a generic method which can be used to bind any property to the
	 * model. A managed object may flag properties in the metamodel with
	 * bindable="bindable" to get typed bind methods for a property.
	 *
	 * @param {string} sName the name of the property
	 * @param {object} oBindingInfo the binding information
	 * @param {string} oBindingInfo.path the binding path
	 * @param {string} [oBindingInfo.model] the model identifier
	 * @param {function} [oBindingInfo.formatter] the formatter function
	 * @param {boolean} [oBindingInfo.useRawValues] determines if the parameters in the formatter functions should be passed as raw values or not. In this case
	 * 					the specified type for the binding is not used and the values are not formatted. Note: use this flag only when using multiple bindings.
	 * 					If you use only one binding and want raw values then simply don't specify a type for that binding. 
	 * @param {sap.ui.model.Type|string} [oBindingInfo.type] the sap.ui.model.Type object or class name
	 * @param {object} [oBindingInfo.formatOptions] the format options to be used
	 * @param {object} [oBindingInfo.constraints] the constraints for this value
	 * @param {sap.ui.model.BindingMode} [oBindingInfo.mode=Default] the binding mode to be used for this property binding (e.g. one way)
	 * @param {object} [oBindingInfo.parameters] a map of parameters which is passed to the binding
	 *
	 * @return {sap.ui.base.ManagedObject} reference to the instance itself
	 * @public
	 * @name sap.ui.base.ManagedObject#bindProperty
	 * @function
	 */
	ManagedObject.prototype.bindProperty = function(sName, oBindingInfo) {
		var sPath,
			oFormat,
			sMode,
			sModelName,
			fnFormatter,
			oType,
			iSeparatorPos,
			bAvailable = true,
			that = this,
			oMetadata = this.getMetadata(),
			oProperty = oMetadata.getAllProperties()[sName],
			oKeyInfo = oMetadata.getJSONKeys()[sName];
	
		// check whether property or alternative type on aggregation exists
		if (!oProperty && !(oKeyInfo && oKeyInfo.altTypes)) {
			throw new Error("Property \"" + sName + "\" does not exist in " + this);
		}
	
		// old API compatbility (sName, sPath, oFormat, sMode)
		if (typeof oBindingInfo == "string") {
			sPath = arguments[1];
			oFormat = arguments[2];
			sMode = arguments[3];
	
			// find out whether formatter or type has been provided
			if (typeof oFormat == "function") {
				fnFormatter = oFormat;
			}
			else if (oFormat instanceof Type) {
				oType = oFormat;
			}
			oBindingInfo = {formatter: fnFormatter, parts : [ {path: sPath, type: oType, mode: sMode} ]};
		}
		
		// only one binding object with one binding specified
		if (!oBindingInfo.parts) {
			oBindingInfo.parts = [];
			oBindingInfo.parts[0] = {
				path: oBindingInfo.path,
				type: oBindingInfo.type,
				formatOptions: oBindingInfo.formatOptions,
				constraints: oBindingInfo.constraints,
				model: oBindingInfo.model,
				mode: oBindingInfo.mode 
			};
			delete oBindingInfo.path;
			delete oBindingInfo.mode;
			delete oBindingInfo.model;
		}
		
		jQuery.each(oBindingInfo.parts, function(i, oPart) {
			if (typeof oPart == "string") {
				oPart = { path: oPart };
				oBindingInfo.parts[i] = oPart;
			}
			// if a model separator is found in the path, extract model name and path
			iSeparatorPos = oPart.path.indexOf(">");
			if (iSeparatorPos > 0) {
				oPart.model = oPart.path.substr(0, iSeparatorPos);
				oPart.path = oPart.path.substr(iSeparatorPos + 1);
			}
			// if we have multiple bindings the binding mode can be one way only
			if (oBindingInfo.parts.length > 1) {
				oPart.mode = sap.ui.model.BindingMode.OneWay;
			}
			
			if (!that.getModel(oPart.model)) {
				bAvailable = false;
			}
			
		});
		
		// if property is already bound, unbind it first
		if (this.isBound(sName)){
			this.unbindProperty(sName, true);
		}
	
		// store binding info to create the binding, as soon as the model is available, or when the model is changed
		this.mBindingInfos[sName] = oBindingInfo;
	
		// if the models are already available, create the binding
		if (bAvailable) {
			this._bindProperty(sName, oBindingInfo);
		}
		return this;
	};
	
	ManagedObject.prototype._bindProperty = function(sName, oBindingInfo) {
		var oModel,
			sMode,
			oContext,
			oBinding,
			oType,
			clType,
			oPropertyInfo = this.getMetadata().getJSONKeys()[sName], // TODO fix handling of hidden entitites?
			that = this,
			aBindings = [],
			fModelChangeHandler = function() {
				try {			
					var oValue = oBinding.getExternalValue();
					oBindingInfo.skipModelUpdate = true;
					that[oPropertyInfo._sMutator](oValue);
					oBindingInfo.skipModelUpdate = false;
				}catch (oException) {
					if (oException instanceof sap.ui.model.FormatException) {
						that.fireFormatError({
							element : that,
							property : sName,
							type : oBinding.getType(),
							newValue : oBinding.getValue(),
							oldValue : that.getProperty(sName),
							exception: oException
						}, false, true); // bAllowPreventDefault, bEnableEventBubbling
					}else {
						throw oException;
					}
				}
			};
	
		// Only use context for bindings on the primary model
		oContext = this.getBindingContext(oBindingInfo.model);
		
		jQuery.each(oBindingInfo.parts, function(i, oPart) {
			// Only use context for bindings on the primary model
			oContext = that.getBindingContext(oPart.model);
			// Create binding object
			oModel = that.getModel(oPart.model);
			// Create type instance if needed
			oType = oPart.type;
			if (typeof oType == "string") {
				clType = jQuery.sap.getObject(oType);
				oType = new clType(oPart.formatOptions, oPart.constraints);
			}
			
			oBinding = oModel.bindProperty(oPart.path, oContext, oBindingInfo.parameters);
			oBinding.setType(oType, oPropertyInfo.type);
			oBinding.setFormatter(oPart.formatter);
			
			sMode = !oPart.mode ? oModel.getDefaultBindingMode() : oPart.mode; 
			oBinding.setBindingMode(sMode);
			
			aBindings.push(oBinding);
		});
	
		// check if we have a composite binding or a formatter function created by the BindingParser which has property textFragments
		if (aBindings.length > 1 || ( oBindingInfo.formatter && oBindingInfo.formatter.textFragments )) {
			// Create type instance if needed
			oType = oBindingInfo.type;
			if (typeof oType == "string") {
				clType = jQuery.sap.getObject(oType);
				oType = new clType(oBindingInfo.formatOptions, oBindingInfo.constraints);
			}
			oBinding = new CompositeBinding(aBindings, oBindingInfo.useRawValues);
			oBinding.setType(oType, oPropertyInfo.type);
			oBinding.setBindingMode(oBindingInfo.mode);
		} else {
			oBinding = aBindings[0];
		}
		
		oBinding.attachChange(fModelChangeHandler);
		
		// set only one formatter function if any
	    // because the formatter gets the context of the element we have to set the context via proxy to ensure compatibility 
		// for formatter function which is now called by the property binding
		// proxy formatter here because "this" is the correct cloned object
		oBinding.setFormatter(jQuery.proxy(oBindingInfo.formatter, this));  
		
		// Set additional information on the binding info
		oBindingInfo.skipModelUpdate = false;
		oBindingInfo.binding = oBinding;
		oBindingInfo.modelChangeHandler = fModelChangeHandler;
		
		oBinding.attachEvents(oBindingInfo.events);
	
		oBinding.initialize();
		
		if (oBinding.getBindingMode() === sap.ui.model.BindingMode.OneTime) {
			oBinding.detachChange(fModelChangeHandler);
			oBinding.detachEvents(oBindingInfo.events);
		}
	};
	
	/**
	 * Unbind the property from the model
	 *
	 * @param {string} sName the name of the property
	 * @param {boolean} bSuppressReset whether the reset to the default value when unbinding should be suppressed
	 * @return {sap.ui.base.ManagedObject} reference to the instance itself
	 * @public
	 * @name sap.ui.base.ManagedObject#unbindProperty
	 * @function
	 */
	ManagedObject.prototype.unbindProperty = function(sName, bSuppressReset){
		var oBindingInfo = this.mBindingInfos[sName],
			oPropertyInfo = this.getMetadata().getJSONKeys()[sName];
		if(oBindingInfo) {
			if (oBindingInfo.binding) {
				oBindingInfo.binding.detachChange(oBindingInfo.modelChangeHandler);
				oBindingInfo.binding.detachEvents(oBindingInfo.events);
			}
			delete this.mBindingInfos[sName];
			if (!bSuppressReset) {
				this[oPropertyInfo._sMutator](null);
			}
		}
		return this;
	};
	
	/**
	 * Update the property in the model if two way data binding mode is enabled
	 *
	 * @param sName the name of the property to update
	 * @param oValue the new value to set for the property in the model
	 * @private
	 * @name sap.ui.base.ManagedObject#updateModelProperty
	 * @function
	 */
	ManagedObject.prototype.updateModelProperty = function(sName, oValue, oOldValue){
		if (this.isBound(sName)){
			var oBindingInfo = this.mBindingInfos[sName],
				oBinding = oBindingInfo.binding;
			// only one property binding should work with two way mode...composite binding does not work with two way binding 
			if (oBinding && oBinding.getBindingMode() == sap.ui.model.BindingMode.TwoWay
					&& !oBindingInfo.skipModelUpdate) {
				try {
					oBinding.setExternalValue(oValue);
					// Only fire validation success, if a type is used
					if (oBinding.getType()) {
						this.fireValidationSuccess({
							element : this,
							property : sName,
							type : oBinding.getType(),
							newValue : oValue,
							oldValue : oOldValue
						}, false, true); // bAllowPreventDefault, bEnableEventBubbling
					}
				}
				catch (oException) {
					if (oException instanceof sap.ui.model.ParseException) {
						this.fireParseError({
							element : this,
							property : sName,
							type : oBinding.getType(),
							newValue : oValue,
							oldValue : oOldValue,
							exception: oException
						}, false, true); // bAllowPreventDefault, bEnableEventBubbling
					}else if (oException instanceof sap.ui.model.ValidateException) {
						this.fireValidationError({
							element : this,
							property : sName,
							type : oBinding.getType(),
							newValue : oValue,
							oldValue : oOldValue,
							exception: oException
						}, false, true); // bAllowPreventDefault, bEnableEventBubbling
					}
					else {
						throw oException;
					}
				}
			}
		}
	};
	
	/**
	 * Bind an aggregation to the model.
	 * 
	 * The bound aggregation will use the given template, clone it for each item
	 * which exists in the bound list and set the appropriate binding context.
	 * This is a generic method which can be used to bind any aggregation to the
	 * model. A managed object may flag aggregations in the metamodel with
	 * bindable="bindable" to get typed bind<i>Something</i> methods for those aggregations.
	 *
	 * @param {string} sName the aggregation to bind
	 * @param {object} oBindingInfo the binding info
	 * @param {string} oBindingInfo.path the binding path
	 * @param {sap.ui.base.ManagedObject} oBindingInfo.template the template to clone for each item in the aggregation
	 * @param {function} oBindingInfo.factory the factory function
	 * @param {number} oBindingInfo.startIndex the first entry of the list to be created
	 * @param {number} oBindingInfo.length the amount of entries to be created (may exceed the sizelimit of the model)
	 * @param {sap.ui.model.Sorter|sap.ui.model.Sorter[]} [oBindingInfo.sorter] the initial sort order (optional)
	 * @param {sap.ui.model.Filter[]} [oBindingInfo.filters] the predefined filters for this aggregation (optional)
	 * @param {object} [oBindingInfo.parameters] a map of parameters which is passed to the binding
	 * @param {function} [oBindingInfo.groupHeaderFactory] a factory function to generate custom group visualization (optional)
	 *
	 * @return {sap.ui.base.ManagedObject} reference to the instance itself
	 * @public
	 * @name sap.ui.base.ManagedObject#bindAggregation
	 * @function
	 */
	ManagedObject.prototype.bindAggregation = function(sName, oBindingInfo) {
		var sPath,
			oTemplate,
			aSorters,
			aFilters,
			oMetadata = this.getMetadata(),
			oAggregation = oMetadata.getAllAggregations()[sName];
	
		// check whether aggregation exists
		if (!oAggregation) {
			throw new Error("Aggregation \"" + sName + "\" does not exist in " + this);
		}
		
		// Old API compatibility (sName, sPath, oTemplate, oSorter, aFilters)
		if (typeof oBindingInfo == "string") {
			sPath = arguments[1];
			oTemplate = arguments[2];
			aSorters = arguments[3];
			aFilters = arguments[4];
			oBindingInfo = {path: sPath, sorter: aSorters, filters: aFilters};
			// allow either to pass the template or the factory function as 3rd parameter
			if (oTemplate instanceof ManagedObject) {
				oBindingInfo.template = oTemplate;
			} else if (typeof oTemplate === "function") {
				oBindingInfo.factory = oTemplate;
			}
		}
		
		// if aggregation is already bound, unbind it first
		if (this.isBound(sName)){
			this.unbindAggregation(sName, true);
		}
		
		// check whether a template has been provided, which is required for proper processing of the binding
		// If aggregation is marked correspondingly in the metadata, factory can be omitted (usually requires an updateXYZ method)
		if (!(oBindingInfo.template || oBindingInfo.factory)) {
			if ( oAggregation._doesNotRequireFactory ) {
				// add a dummy factory as property 'factory' is used to distinguish between property- and list-binding
				oBindingInfo.factory = function() { throw new Error("dummy factory called unexpectedly "); };
			} else {
				throw new Error("Missing template or factory function for aggregation " + sName + " of " + this + " !");
			}
		}
		
		// if we have a template we will create a factory function
		if (oBindingInfo.template) {
			oBindingInfo.factory = function(sId) {
				return oBindingInfo.template.clone(sId);
			} 
		}
		
		// if a model separator is found in the path, extract model name and path
		var iSeparatorPos = oBindingInfo.path.indexOf(">");
		if (iSeparatorPos > 0) {
			oBindingInfo.model = oBindingInfo.path.substr(0, iSeparatorPos);
			oBindingInfo.path = oBindingInfo.path.substr(iSeparatorPos + 1);
		}
		
		// store binding info to create the binding, as soon as the model is available, or when the model is changed
		this.mBindingInfos[sName] = oBindingInfo;
	
		// if the model is already available create the binding
		if (this.getModel(oBindingInfo.model)) {
			this._bindAggregation(sName, oBindingInfo);
		}
		return this;
	};
	
	ManagedObject.prototype._bindAggregation = function(sName, oBindingInfo) {
		var that = this,
			oBinding,
			fModelChangeHandler = function(oEvent){
				var sUpdater = "update" + sName.substr(0,1).toUpperCase() + sName.substr(1);
				if (that[sUpdater]) {
					var sChangeReason = oEvent && oEvent.getParameter("reason");
					if (sChangeReason) {
						that[sUpdater](sChangeReason);
					} else {
						that[sUpdater]();
					}
				} else {
					that.updateAggregation(sName);
				}
			},
			fModelRefreshHandler = function(oEvent){
				var sRefresher = "refresh" + sName.substr(0,1).toUpperCase() + sName.substr(1);
				if (that[sRefresher]) {
					that[sRefresher](oEvent.getParameter("reason"));
				} else {
					fModelChangeHandler(oEvent);
				}
			};
			var oModel = this.getModel(oBindingInfo.model);
			if (this.isTreeBinding(sName)) {
				oBinding = oModel.bindTree(oBindingInfo.path, this.getBindingContext(oBindingInfo.model), oBindingInfo.filters, oBindingInfo.parameters);
			} else {
				oBinding = oModel.bindList(oBindingInfo.path, this.getBindingContext(oBindingInfo.model), oBindingInfo.sorter, oBindingInfo.filters, oBindingInfo.parameters);
			}
			
		if (this.bUseExtendedChangeDetection === true) {
			oBinding.enableExtendedChangeDetection();
		}
	
		oBindingInfo.binding = oBinding;
		oBindingInfo.modelChangeHandler = fModelChangeHandler;
		oBindingInfo.modelRefreshHandler = fModelRefreshHandler;
	
		oBinding.attachChange(fModelChangeHandler);
		
		oBinding.attachRefresh(fModelRefreshHandler);
		
		oBinding.attachEvents(oBindingInfo.events);
		
		oBinding.initialize();
	};
	
	/**
	 * Unbind the aggregation from the model
	 *
	 * @param {string} sName the name of the aggregation
	 * @param {boolean} bSuppressReset whether the reset to empty aggregation when unbinding should be suppressed
	 * @return {sap.ui.base.ManagedObject} reference to the instance itself
	 * @public
	 * @name sap.ui.base.ManagedObject#unbindAggregation
	 * @function
	 */
	ManagedObject.prototype.unbindAggregation = function(sName, bSuppressReset){
		var oBindingInfo = this.mBindingInfos[sName],
			oAggregationInfo = this.getMetadata().getJSONKeys()[sName];
		if(oBindingInfo) {
			if (oBindingInfo.binding) {
				oBindingInfo.binding.detachChange(oBindingInfo.modelChangeHandler);
				oBindingInfo.binding.detachRefresh(oBindingInfo.modelRefreshHandler);
				oBindingInfo.binding.detachEvents(oBindingInfo.events);
			}
			delete this.mBindingInfos[sName];
			if (!bSuppressReset) {
				this[oAggregationInfo._sDestructor]();
			}
		}
		return this;
	};
	
	/**
	 *  This method is used internally and should only be overridden by a tree managed object which utilizes the tree binding.
	 *  In this case and if the aggregation is a tree node the overridden method should then return true.
	 *  If true is returned the tree binding will be used instead of the list binding.
	 *
	 *  @param {string} sName the aggregation to bind (e.g. nodes for a tree managed object)
	 *  @return {boolean} whether tree binding should be used or list binding. Default is false. Override method to change this behavior.
	 *
	 *  @protected
	 * @name sap.ui.base.ManagedObject#isTreeBinding
	 * @function
	 */
	ManagedObject.prototype.isTreeBinding = function(sName) {
		return false;
	};
	
	/**
	 * Create or update local bindings.
	 * 
	 * Called when model or binding contexts have changed. Creates bindings when the model was not available 
	 * at the time bindProperty or bindAggregation was called. Recreates the bindings when they exist already 
	 * and when the model has changed.
	 *
	 * @param {boolean} bUpdateAll forces an update of all bindings, sModelName will be ignored
	 * @param {string|undefined} sModelName name of a model whose bindings should be updated
	 * 
	 * @private
	 * @name sap.ui.base.ManagedObject#updateBindings
	 * @function
	 */
	ManagedObject.prototype.updateBindings = function(bUpdateAll, sModelName) {
		var that = this;
	
		/*
		 * Checks whether the binding for the given oBindingInfo became invalid because 
		 * of the current model change (as identified by bUpdateAll and sModelName). 
		 * 
		 * Precondition: oBindingInfo contains a 'binding' object
		 * 
		 * @param oBindingInfo 
		 * @returns {boolean}
		 */
		function becameInvalid(oBindingInfo) {
			var aParts = oBindingInfo.parts,
				i;
			
			if (aParts && aParts.length>1) {
				// composite binding: invalid when for any part the model has the same name (or updateall) and when the model instance for that part differs 
				for(i=0; i<aParts.length; i++) {
					if ( (bUpdateAll || aParts[i].model == sModelName) && !oBindingInfo.binding.aBindings[i].updateRequired(that.getModel(aParts[i].model)) ) {
						return true;
					}
				}
			} else if (oBindingInfo.factory) {
				// list binding: invalid when  the model has the same name (or updateall) and when the model instance differs 
				return (bUpdateAll || oBindingInfo.model == sModelName) && !oBindingInfo.binding.updateRequired(that.getModel(oBindingInfo.model));
			} else {
				// simple property binding: invalid when the model has the same name (or updateall) and when the model instance differs 
				return (bUpdateAll || aParts[0].model == sModelName) && !oBindingInfo.binding.updateRequired(that.getModel(aParts[0].model)); 
			}
			return false;
		}
	
		/*
		 * Checks whether a binding can be created for the given oBindingInfo 
		 * @param oBindingInfo
		 * @returns {boolean} 
		 */
		function canCreate(oBindingInfo) {
			var aParts = oBindingInfo.parts,
				i;
			
			if (aParts) {
				for(i=0; i<aParts.length; i++) {
					if ( !that.getModel(aParts[i].model) ) {
						return false;
					}
				}
				return true;
			} else if (oBindingInfo.factory) { // List binding check
				return !!that.getModel(oBindingInfo.model); 
			} 
			// there should be no other cases
			return false;
		}
		
		// create property and aggregation bindings if they don't exist yet
		jQuery.each(this.mBindingInfos, function(sName, oBindingInfo) {
	
			// if there is a binding and if it became invalid through the current model change, then remove it 
			if ( oBindingInfo.binding && becameInvalid(oBindingInfo) ) {
				oBindingInfo.binding.detachChange(oBindingInfo.modelChangeHandler);
				if (oBindingInfo.modelRefreshHandler) { // only list bindings currently have a refresh handler attached
					oBindingInfo.binding.detachRefresh(oBindingInfo.modelRefreshHandler);				
				}
				oBindingInfo.binding.detachEvents(oBindingInfo.events);
				delete oBindingInfo.binding;
			}
	
			// if there is no binding and if all required information is available, create a binding object
			if ( !oBindingInfo.binding && canCreate(oBindingInfo) ) {
				if (oBindingInfo.factory) {
					that._bindAggregation(sName, oBindingInfo);
				} else {
					that._bindProperty(sName, oBindingInfo);
				}
			}
	
		});
		
	};
	
	/**
	 * Generic method which is called, whenever an aggregation binding is changed.
	 * This method deletes all elements in this aggregation and recreates them
	 * according to the data model.
	 * In case a managed object needs special handling for a aggregation binding, it can create
	 * a typed update-method (e.g. "updateRows") which will be used instead of the
	 * default behaviour.
	 *
	 * @private
	 * @name sap.ui.base.ManagedObject#updateAggregation
	 * @function
	 */
	ManagedObject.prototype.updateAggregation = function(sName) {
		var oBindingInfo = this.mBindingInfos[sName],
			oBinding = oBindingInfo.binding,
			fnFactory = oBindingInfo.factory,
			oAggregationInfo = this.getMetadata().getJSONKeys()[sName],  // TODO fix handling of hidden aggregations
			oClone,
			oNewGroup = null,
			sGroupFunction = null,
			bGrouped = null,
			sGroup = null,
			that = this;
		this[oAggregationInfo._sDestructor]();
		if (this.isTreeBinding(sName)) {
			var iNodeIndex = 0,
				update = function(aContexts, fnFactory, oBinding, oParent){
					jQuery.each(aContexts, function(iIndex, oContext) {
						var sId = that.getId() + "-" + iNodeIndex++;
						oClone = fnFactory(sId, oContext);
						oClone.setBindingContext(oContext, oBindingInfo.model);
						oParent[oAggregationInfo._sMutator](oClone); // also sets the Parent
						update(oBinding.getNodeContexts(oContext), fnFactory, oBinding, oClone);
					});
				};
			update(oBinding.getRootContexts(), fnFactory, oBinding, this);
		} 
		else {
			sGroupFunction = oAggregationInfo._sMutator + "Group";
			bGrouped = oBinding.isGrouped() && this[sGroupFunction];
			jQuery.each(oBinding.getContexts(oBindingInfo.startIndex, oBindingInfo.length), function(iIndex, oContext) {
				if (bGrouped && oBinding.aSorters.length > 0) {
					oNewGroup = oBinding.aSorters[0].fnGroup(oContext);
					if (typeof oNewGroup == "string") {
						oNewGroup = {
							key: oNewGroup
						};
					} 
					if (oNewGroup.key !== sGroup) {
						var oGroupHeader;
						//If factory is defined use it
						if (oBindingInfo.groupHeaderFactory) {
							oGroupHeader = oBindingInfo.groupHeaderFactory(oNewGroup);
						}
						that[sGroupFunction](oNewGroup, oGroupHeader);
						sGroup = oNewGroup.key;
					}
				}
				var sId = that.getId() + "-" + iIndex;
				oClone = fnFactory(sId, oContext);
				oClone.setBindingContext(oContext, oBindingInfo.model);
				that[oAggregationInfo._sMutator](oClone);
			});
		}
	};
	
	/**
	 * Find out whether a property or aggregation is bound
	 *
	 * @param {string} sName the name of the property or aggregation
	 * @return {boolean} whether a binding exists for the given name
	 * @public
	 * @name sap.ui.base.ManagedObject#isBound
	 * @function
	 */
	ManagedObject.prototype.isBound = function(sName){
		return (sName in this.mBindingInfos);
	};
	
	/**
	 * Get the object binding object for a specific model
	 *
	 * @param {string} sModelName the name of the model
	 * @return {sap.ui.model.Binding} the element binding for the given model name
	 * @public
	 * @name sap.ui.base.ManagedObject#getObjectBinding
	 * @function
	 */
	ManagedObject.prototype.getObjectBinding = function(sModelName){
		return this.mBoundObjects[sModelName] && this.mBoundObjects[sModelName].binding;
	};
	
	/**
	 * Returns the parent managed object as new eventing parent to enable control event bubbling
	 * or <code>null</code> if this object hasn't been added to a parent yet. 
	 * 
	 * @return {sap.ui.base.EventProvider} the parent event provider
	 * @protected
	 * @name sap.ui.base.ManagedObject#getEventingParent
	 * @function
	 */
	ManagedObject.prototype.getEventingParent = function() {
		return this.oParent;
	};
	
	/**
	 * Get the binding object for a specific aggregation/property
	 *
	 * @param {string} sName the name of the property or aggregation
	 * @return {sap.ui.model.Binding} the binding for the given name
	 * @public
	 * @name sap.ui.base.ManagedObject#getBinding
	 * @function
	 */
	ManagedObject.prototype.getBinding = function(sName){
		return this.mBindingInfos[sName] && this.mBindingInfos[sName].binding;
	};
	
	/**
	 * Get the binding path for a specific aggregation/property
	 *
	 * @param {string} sName the name of the property or aggregation
	 * @return {string} the binding path for the given name
	 * @protected
	 * @name sap.ui.base.ManagedObject#getBindingPath
	 * @function
	 */
	ManagedObject.prototype.getBindingPath = function(sName){
		var oInfo = this.mBindingInfos[sName];
		return oInfo && (oInfo.path || (oInfo.parts && oInfo.parts[0] && oInfo.parts[0].path));
	};
	
	/**
	 * Set the binding context for this ManagedObject for the model with the given name.
	 *
	 * Note: to be compatible with future versions of this API, applications must not use the value <code>null</code>,
	 * the empty string <code>""</code> or the string literals <code>"null"</code> or <code>"undefined"</code> as model name. 
	 *  
	 * Note: A ManagedObject inherits binding contexts from the Core only when it is a descendant of an UIArea.
	 *  
	 * @param {Object} oContext the new binding context for this object
	 * @param {string} [sName] the name of the model to set the context for or <code>undefined</code>
	 *
	 * @return {sap.ui.base.ManagedObject} reference to the instance itself
	 * @public
	 * @name sap.ui.base.ManagedObject#setBindingContext
	 * @function
	 */
	ManagedObject.prototype.setBindingContext = function(oContext, sModelName){
		jQuery.sap.assert(sModelName === undefined || (typeof sModelName === "string" && !/^(undefined|null)?$/.test(sModelName)), "sModelName must be a string or omitted");
		var oOldContext = this.oBindingContexts[sModelName];
		
		if (oOldContext !== oContext) {
			this.oBindingContexts[sModelName] = oContext;
			this.updateBindingContext(true, true, sModelName);
			this.propagateProperties(sModelName);
		}
		return this;
	};
	
	/**
	 * Update the binding context in this object and all aggregated children
	 * @private
	 * @name sap.ui.base.ManagedObject#updateBindingContext
	 * @function
	 */
	ManagedObject.prototype.updateBindingContext = function(bSkipLocal, bSkipChildren, sModelName, bUpdateAll){
	
		var oModel,
			oModelNames= {},
			oParentContext,
			oBoundObject,
			that = this;
		
		// find models that need an context update
		if (bUpdateAll) {
			for(sModelName in this.oModels) {
				if ( this.oModels.hasOwnProperty(sModelName) ){
					oModelNames[sModelName] = sModelName;
				}
			}
			for(sModelName in this.oPropagatedProperties.oModels) {
				if ( this.oPropagatedProperties.oModels.hasOwnProperty(sModelName) ){
					oModelNames[sModelName] = sModelName;
				}
			}
		} else {
			oModelNames[sModelName] = sModelName;
		}
	
		for(sModelName in oModelNames ) {
			if ( oModelNames.hasOwnProperty(sModelName) ){
				sModelName = sModelName === "undefined" ? undefined : sModelName;
				oModel = this.getModel(sModelName); 
				oBoundObject = this.mBoundObjects[sModelName];
				
				if (oModel && oBoundObject && oBoundObject.sBindingPath && !bSkipLocal) {
					if(!oBoundObject.binding) {
						this._bindObject(sModelName, oBoundObject);
					} else {
						oParentContext = null;
						if (this.oParent && oModel == this.oParent.getModel(sModelName)) {
							oParentContext= this.oParent.getBindingContext(sModelName); 
						}
						if (oParentContext !== oBoundObject.binding.getContext()) {
							oBoundObject.binding.setContext(oParentContext);
						}
					}
					continue;
				}			
				// update context in existing bindings
				jQuery.each(this.mBindingInfos, function(sName, oBindingInfo) {
					var oBinding = oBindingInfo.binding;
					var aParts = oBindingInfo.parts,
					 	i;
					if (!oBinding) {
						return;
					}
					if (aParts && aParts.length>1) {
						// composite binding: update required  when a part use the model with the same name
						for(i=0; i<aParts.length; i++) {
							if ( aParts[i].model == sModelName ) {
								oBinding.aBindings[i].setContext(that.getBindingContext(aParts[i].model));
							}
						}
					} else if (oBindingInfo.factory) {
						// list binding: update required when the model has the same name (or updateall) 
						if ( oBindingInfo.model == sModelName) { 
							oBinding.setContext(that.getBindingContext(oBindingInfo.model));
						}
						
					} else {
						// simple property binding: update required when the model has the same name 
						if ( aParts[0].model == sModelName) { 
							oBinding.setContext(that.getBindingContext(aParts[0].model));
						} 
					}
				});
				if (!bSkipChildren) {
					var oContext = this.getBindingContext(sModelName);
					// also update context in all child elements
					jQuery.each(this.mAggregations, function(sName, oAggregation) {
						if (oAggregation instanceof ManagedObject) {
							oAggregation.oPropagatedProperties.oBindingContexts[sModelName] = oContext;
							oAggregation.updateBindingContext(false,false,sModelName);
						} else if (oAggregation instanceof Array) {
							for (var i = 0; i < oAggregation.length; i++) {
								oAggregation[i].oPropagatedProperties.oBindingContexts[sModelName] = oContext;
								oAggregation[i].updateBindingContext(false,false,sModelName);
							}
						}
					});
				}
			}
		}
	};
	
	
	/**
	 * Get the binding context of this object for the given model name.
	 * 
	 * If the object does not have a binding context set on itself and has no own Model set, 
	 * it will use the first binding context defined in its parent hierarchy.
	 *
	 * Note: to be compatible with future versions of this API, applications must not use the value <code>null</code>,
	 * the empty string <code>""</code> or the string literals <code>"null"</code> or <code>"undefined"</code> as model name. 
	 *  
	 * Note: A ManagedObject inherits binding contexts from the Core only when it is a descendant of an UIArea.
	 *  
	 * @param {string} [sName] the name of the model or <code>undefined</code>
	 * @return {Object} the binding context of this object
	 * @public
	 * @name sap.ui.base.ManagedObject#getBindingContext
	 * @function
	 */
	ManagedObject.prototype.getBindingContext = function(sModelName){
		var oModel = this.getModel(sModelName);
		
		if (this.oBindingContexts[sModelName]) {
			return this.oBindingContexts[sModelName];
		} else if (oModel && this.oParent && this.oParent.getModel(sModelName) && oModel != this.oParent.getModel(sModelName)) {
			return undefined;
		} else {
			return this.oPropagatedProperties.oBindingContexts[sModelName];
		}
	};
	
	/**
	 * Sets or unsets a model for the given model name for this ManagedObject. 
	 * 
	 * The <code>sName</code> must either be <code>undefined</code> (or omitted) or a non-empty string.
	 * When the name is omitted, the default model is set/unset. 
	 * 
	 * When <code>oModel</code> is <code>null</code> or <code>undefined</code>, a previously set model 
	 * with that name is removed from this ManagedObject. If an ancestor (parent, UIArea or Core) has a model 
	 * with that name, this ManagedObject will immediately inherit that model from its ancestor.
	 *  
	 * All local bindings that depend on the given model name, are updated (created if the model references 
	 * became complete now; updated, if any model reference has changed; removed if the model references 
	 * became incomplete now).
	 *  
	 * Any change (new model, removed model, inherited model) is also applied to all aggregated descendants 
	 * as long as a descendant doesn't have its own model set for the given name.
	 * 
	 * Note: to be compatible with future versions of this API, applications must not use the value <code>null</code>,
	 * the empty string <code>""</code> or the string literals <code>"null"</code> or <code>"undefined"</code> as model name. 
	 *  
	 * Note: By design, it is not possible to hide an inherited model by setting a <code>null</code> or 
	 * <code>undefined</code> model. Applications can set an empty model to achieve the same. 
	 * 
	 * Note: A ManagedObject inherits models from the Core only when it is a descendant of an UIArea.
	 *  
	 * @param {sap.ui.model.Model} oModel the model to be set or <code>null</code> or <code>undefined</code>
	 * @param {string} [sName] the name of the model or <code>undefined</code>
	 * @return {sap.ui.base.ManagedObject} <code>this</code> to allow method chaining
	 * @public
	 * @name sap.ui.base.ManagedObject#setModel
	 * @function
	 */
	ManagedObject.prototype.setModel = function(oModel, sName) {
		jQuery.sap.assert(oModel == null || oModel instanceof Model, "oModel must be an instance of sap.ui.model.Model, null or undefined");
		jQuery.sap.assert(sName === undefined || (typeof sName === "string" && !/^(undefined|null)?$/.test(sName)), "sName must be a string or omitted");
		if (!oModel && this.oModels[sName]) {
			delete this.oModels[sName];
			// propagate Models to children
			// model changes are propagated until (including) the first descendant that has its own model with the same name 
			this.propagateProperties(sName);
			// if the model instance for a name changes, all bindings for that model name have to be updated
			this.updateBindings(false, sName);
		} else if ( oModel && oModel !== this.oModels[sName] ) { 
			//TODO: handle null!
			this.oModels[sName] = oModel;
			// propagate Models to children
			// model changes are propagated until (including) the first descendant that has its own model with the same name 
			this.propagateProperties(sName);
			// update binding context, for primary model only
			this.updateBindingContext(false, true, sName);
			// if the model instance for a name changes, all bindings for that model name have to be updated
			this.updateBindings(false, sName);
		} else {
			// nothing to do
		} 
		return this;
	};
	
	/**
	 * Propagate Properties (models and bindingContext) to aggregated objects.
	 * @param {string|undefined|true} sName when <code>true</code>, all bindings are updated.
	 *           Otherwise only those for the given model name (undefined == name of default model)
	 * 
	 * @private
	 * @name sap.ui.base.ManagedObject#propagateProperties
	 * @function
	 */
	ManagedObject.prototype.propagateProperties = function(vName) {
		var oProperties = this._getPropertiesToPropagate(),
			bUpdateAll = vName === true, // update all bindings when no model name parameter has been specified
			sName = bUpdateAll ? undefined : vName,
			that = this;
		jQuery.each(this.mAggregations, function(sAggregationName, oAggregation) {
			if (oAggregation instanceof ManagedObject) {
				that._propagateProperties(vName, oAggregation, oProperties, bUpdateAll, sName);
			} else if (oAggregation instanceof Array) {
				for (var i = 0; i < oAggregation.length; i++) {
					if (oAggregation[i] instanceof ManagedObject) {
						that._propagateProperties(vName, oAggregation[i], oProperties, bUpdateAll, sName);
					}
				}
			}
		});
	};
	
	ManagedObject.prototype._propagateProperties = function(vName, oObject, oProperties, bUpdateAll, sName) {
		if (!oProperties) {
			oProperties = this._getPropertiesToPropagate(),
			bUpdateAll = vName === true,
			sName = bUpdateAll ? undefined : vName;
		}
		oObject.oPropagatedProperties = oProperties;
		oObject.updateBindings(bUpdateAll,sName);
		oObject.updateBindingContext(false, true, sName, bUpdateAll);
		oObject.propagateProperties(vName);
	};
	
	/**
	 * Get properties for propagation
	 * @return {object} oProperties
	 * @private
	 * @name sap.ui.base.ManagedObject#_getPropertiesToPropagate
	 * @function
	 */
	ManagedObject.prototype._getPropertiesToPropagate = function() {
		var bNoOwnModels = jQuery.isEmptyObject(this.oModels),
			bNoOwnContexts = jQuery.isEmptyObject(this.oBindingContexts);
	
		function merge(empty,o1,o2) {
			return empty ? o1 : jQuery.extend({}, o1, o2);
		}
		
		if (bNoOwnContexts && bNoOwnModels) {
			//propagate the existing container
			return this.oPropagatedProperties;
		} else {
			//merge propagated and own properties
			return {
					oModels : merge(bNoOwnModels, this.oPropagatedProperties.oModels, this.oModels),
					oBindingContexts : merge(bNoOwnContexts, this.oPropagatedProperties.oBindingContexts, this.oBindingContexts)
			};
		}
	};
	
	/**
	 * Get the model to be used for data bindings with the given model name.
	 * If the object does not have a model set on itself, it will use the first 
	 * model defined in its parent hierarchy.
	 * 
	 * The name can be omitted to reference the default model or it must be a non-empty string.
	 * 
	 * Note: to be compatible with future versions of this API, applications must not use the value <code>null</code>,
	 * the empty string <code>""</code> or the string literals <code>"null"</code> or <code>"undefined"</code> as model name. 
	 * 
	 * @param {string|undefined} [sName] name of the model to be retrieved
	 * @return {sap.ui.model.Model} oModel
	 * @public
	 * @name sap.ui.base.ManagedObject#getModel
	 * @function
	 */
	ManagedObject.prototype.getModel = function(sName) {
		jQuery.sap.assert(sName === undefined || (typeof sName === "string" && !/^(undefined|null)?$/.test(sName)), "sName must be a string or omitted");
		return this.oModels[sName] || this.oPropagatedProperties.oModels[sName];
	};
	
	/**
	 * Check if any model is set to the ManagedObject or to one of its parents (including UIArea and Core).
	 *
	 * Note: A ManagedObject inherits models from the Core only when it is a descendant of an UIArea.
	 * 
	 * @return {boolean} whether a model reference exists or not
	 * @public
	 * @name sap.ui.base.ManagedObject#hasModel
	 * @function
	 */
	ManagedObject.prototype.hasModel = function() {
		return !(jQuery.isEmptyObject(this.oModels) && jQuery.isEmptyObject(this.oPropagatedProperties.oModels));
	};
	
	/**
	 * Clones a tree of objects starting with the object on which clone is called first (root object).
	 * 
	 * The ids within the newly created clone tree are derived from the original ids by appending
	 * the given <code>sIdSuffix</code> (if no suffix is given, one will be created; it will be 
	 * unique across multiple clone calls).
	 *  
	 * The <code>oOptions</code> configuration object can have the following properties:
	 * <ul>
	 * <li>The boolean value <code>cloneChildren</code> specifies wether associations/aggregations will be cloned</li>
	 * <li>The boolean value <code>cloneBindings</code> specifies if bindings will be cloned</li>
	 * </ul>
	 * 
	 * For each cloned object the following settings are cloned based on the metadata of the object and the defined options:
	 * <ul>
	 * <li>all properties that are not bound. If cloneBinding is false even these properties will be cloned; 
	 * the values are used by reference, they are not cloned</li>
	 * <li>all aggregated objects that are not bound. If cloneBinding is false even the ones that are bound will be cloned;
	 * they are all cloned recursively using the same <code>sIdSuffix</code></li>
	 * <li>all associated controls; when an association points to an object inside the cloned object tree,
	 *     then the cloned association will be modified to that it points to the clone of the target object.
	 *     When the association points to a managed object outside of the cloned object tree, then its 
	 *     target won't be changed.</li>  
	 * <li>all models set via setModel(); used by reference </li>
	 * <li>all property and aggregation bindings (if cloneBindings is true); the pure binding infos (path, model name) are 
	 *     cloned, but all other information like template control or factory function, 
	 *     data type or formatter function are copied by reference. The bindings themselves 
	 *     are created anew as they are specific for the combination (object, property, model).
	 *     As a result, any later changes to a binding of the original object are not reflected 
	 *     in the clone, but changes to e.g the type or template etc. are.</li> 
	 * </ul>
	 *
	 * Each clone is created by first collecting the above mentioned settings and then creating 
	 * a new instance with the normal constructor function. As a result, any side effects of 
	 * mutator methods (setProperty etc.) or init hooks are repeated during clone creation. 
	 * There is no need to override <code>clone()</code> just to reproduce these internal settings!
	 * 
	 * Custom controls however can override <code>clone()</code> to implement additional clone steps. 
	 * They usually will first call <code>clone()</code> on the super class and then modify the   
	 * returned clone accordingly.  
	 * 
	 * Applications <b>must never provide</b> the second parameter <code>aLocaleIds</code>. 
	 * It is determined automatically for the root object (and its non-existance also serves as 
	 * an indicator for the root object). Specifying it will break the implementation of <code>clone()</code>. 
	 * 
	 * @param {string} [sIdSuffix] a suffix to be appended to the cloned object id
	 * @param {string[]} [aLocalIds] an array of local IDs within the cloned hierarchy (internally used)
	 * @param {Object} [oOptions] configuration object 
	 * @return {sap.ui.base.ManagedObject} reference to the newly created clone
	 * @protected
	 * @name sap.ui.base.ManagedObject#clone
	 * @function
	 */
	ManagedObject.prototype.clone = function(sIdSuffix, aLocalIds, oOptions) {
		var that = this,
			bCloneChildren = true, 
			bCloneBindings = true;
		
		if (oOptions) {
			bCloneChildren = !!oOptions.cloneChildren;
			bCloneBindings = !!oOptions.cloneBindings;
		}
		// if no id suffix has been provided use a generated UID
		if (!sIdSuffix) {
			sIdSuffix = ManagedObjectMetadata.uid("clone") || jQuery.sap.uid();
		}
		// if no local ID array has been passed, collect IDs of all aggregated objects to
		// be able to properly adapt associations, which are within the cloned object hierarchy
		if (!aLocalIds && bCloneChildren) {
			aLocalIds = jQuery.map(this.findAggregatedObjects(true), function(oObject) {return oObject.getId();});
		}
	
		var oMetadata = this.getMetadata(),
			oClass = oMetadata._oClass,
			sId = this.getId() + "-" + sIdSuffix,
			mSettings = {},
			mProps = this.mProperties,
			sKey,
			oClone;
		
		// Clone properties (only those with non-default value)
		for(sKey in mProps) {
			//do not clone properties if property is bound and bindings are cloned; Property is set on update
			if ( mProps.hasOwnProperty(sKey) && !(this.isBound(sKey) && bCloneBindings)){
				mSettings[sKey] = mProps[sKey];
			}
		}
		
		// Clone models		
		mSettings["models"] = this.oModels;		
		
		// Clone BindingContext
		mSettings["bindingContexts"] = this.oBindingContexts;
	
		if(bCloneChildren) {
			// Clone aggregations
			jQuery.each(this.mAggregations, function(sName, oAggregation) {
				//do not clone aggregation if aggregation is bound and bindings are cloned; aggregation is filled on update
				if (oMetadata.hasAggregation(sName) && !(that.isBound(sName) && bCloneBindings)) {
					if (oAggregation instanceof ManagedObject) {
						mSettings[sName] = oAggregation.clone(sIdSuffix, aLocalIds);
					} else if (jQuery.isArray(oAggregation)) {
						mSettings[sName] = [];
						for (var i = 0; i < oAggregation.length; i++) {
							mSettings[sName].push(oAggregation[i].clone(sIdSuffix, aLocalIds));
						}
					} else {
						// must be an alt type
						mSettings[sName] = oAggregation;
					}
				}
			});
	
			// Clone associations
			jQuery.each(this.mAssociations, function(sName, oAssociation) {
				// Check every associated ID against the ID array, to make sure associations within
				// the template are properly converted to associations within the clone
				if (jQuery.isArray(oAssociation)) {
					oAssociation = oAssociation.slice(0);
					for (var i = 0; i < oAssociation.length; i++) {
						if (jQuery.inArray(oAssociation[i], aLocalIds) >= 0) {
							oAssociation[i] += "-" + sIdSuffix;
						}
					}
				} else if (jQuery.inArray(oAssociation, aLocalIds) >= 0) {
					oAssociation += "-" + sIdSuffix;
				}
				mSettings[sName] = oAssociation;
			});
		}
		// Create clone instance
		oClone = new oClass(sId, mSettings);
		
		/* Clone element bindings: Clone the objects not the parameters
		 * Context will only be updated when adding the control to the control tree;
		 * Maybe we have to call updateBindingcontext() here?
		 */
		jQuery.each(this.mBoundObjects, function(sName, oBoundObject) {
			oClone.mBoundObjects[sName] = jQuery.extend({}, oBoundObject);
		});
		
		// Clone events
		jQuery.each(this.mEventRegistry, function(sName, aListeners) {
			oClone.mEventRegistry[sName] = aListeners.slice();
		});
		
		// Clone bindings
		if (bCloneBindings) {
			jQuery.each(this.mBindingInfos, function(sName, oBindingInfo) {
				var oCloneBindingInfo = jQuery.extend({}, oBindingInfo);
				delete oCloneBindingInfo.binding; // remove the runtime binding info (otherwise the property will not be connected again!)
				if (oBindingInfo.factory) {
					oClone.bindAggregation(sName, oCloneBindingInfo);
				} else {
					oClone.bindProperty(sName, oCloneBindingInfo);
				}
			});
		}
		return oClone;
	};
	
	/**
	 * Update all localization dependant objects that this managedObject can reach,
	 * except for its children (which will be updated from the Core).
	 * 
	 * To make the update work as smooth as possible, it happens in two phases:
	 * <ol>
	 *  <li>In phase 1 all known models are updated.
	 *  <li>In phase 2 all bindings are updated.
	 * </ol>
	 * This separation is necessary as the models for the bindings might be updated 
	 * in some ManagedObject or in the Core and the order in which the objects are visited 
	 * is not defined (Core.mElements order)
	 * 
	 * @private
	 * @name sap.ui.base.ManagedObject._handleLocalizationChange
	 * @function
	 */
	ManagedObject._handleLocalizationChange = function(iPhase) {
		var i;
		
		if ( iPhase === 1 ) {
			
			/*
			 * phase 1: update the models
			 */
			jQuery.each(this.oModels, function(sName, oModel) {
				if ( oModel && oModel._handleLocalizationChange ) {
					oModel._handleLocalizationChange(); 
				}
			});
			
		} else if ( iPhase === 2 ) {
			
			/*
			 * phase 2: update bindings and types
			 */
			jQuery.each(this.mBindingInfos, function(sName, oBindingInfo) {
				var aParts = oBindingInfo.parts;
				if (aParts) {
					// property or composite binding: visit all parts 
					for(i=0; i<aParts.length; i++) {
						if ( oBindingInfo.type && oBindingInfo.type._handleLocalizationChange ) {
							oBindingInfo.type._handleLocalizationChange();
						}
					}
					if ( oBindingInfo.modelChangeHandler ) {
						oBindingInfo.modelChangeHandler();
					}
				} // else: don't update list bindings
				// Note: the template for a list binding will be visited by the core! 
			});
			
		}
	}
	
	/**
	 * Maps the given aggregation with name <code>sOldAggrName</code>
	 * on aggregation <code>sNewAggrName</code> (When calling an accessor function
	 * of the old aggregation the call is forwarded to the corresponding accessor
	 * function of the new aggregation).
	 *
	 * This function should help to perform a smooth transition for users of a managed object
	 * when an aggregation must be renamed.
	 *
	 * Both aggregations must have a mutiple cardinality (0..n) and must have the same
	 * aggregated type!
	 *
	 * @param {object} oPrototype prototype of the ManagedObject class for which a mapping should be defined
	 * @param {string} sOldAggrName Name of the old deprecated aggregation
	 * @param {string} sNewAggrName Name of the new aggregation
	 * @deprecated
	 * @name sap.ui.base.ManagedObject._mapAggregation
	 * @function
	 */
	ManagedObject._mapAggregation = function(oPrototype, sOldAggrName, sNewAggrName){
		var mKeys = oPrototype.getMetadata().getJSONKeys(); // TODO fix handling of hidden entitites?
		var oOldAggrInfo = mKeys[sOldAggrName];
		var oNewAggrInfo = mKeys[sNewAggrName];
	
		//Check whether aggregations exist and are multiple.
		if(!oOldAggrInfo || !oNewAggrInfo || oOldAggrInfo._iKind != 2 || oNewAggrInfo._iKind != 2) {
			return;
		}
	
		var mFunc = {"insert" : true, "add" : true, "remove" : true, "removeAll" : false, "indexOf" : true, "destroy" : false, "get" : false};
	
		function method(sPrefix, sName) {
			return sPrefix + sName.substring(0,1).toUpperCase() + sName.substring(1);
		}
	
		function fAggrDelegator(sFuncName){
			return function() {
				return this[sFuncName].apply(this, arguments);
			};
		}
	
		for(var sPrefix in mFunc){
			var sOldFuncName = method(sPrefix, mFunc[sPrefix] ? oOldAggrInfo.singularName : oOldAggrInfo._sName);
			var sNewFuncName = method(sPrefix, mFunc[sPrefix] ? oNewAggrInfo.singularName : oNewAggrInfo._sName);
			oPrototype[sOldFuncName] = fAggrDelegator(sNewFuncName);
		}
	};
	
	/**
	 * Searches and returns an array of child elements and controls which are
	 * referenced within an aggregation or aggregations of child elements/controls.
	 * This can be either done recursive or not.
	 * <br>
	 * <b>Take care: this operation might be expensive.</b>
	 * @param {boolean}
	 *          bRecursive true, if all nested children should be returned.
	 * @return {sap.ui.base.ManagedObject[]} array of child elements and controls
	 * @public
	 * @name sap.ui.base.ManagedObject#findAggregatedObjects
	 * @function
	 */
	ManagedObject.prototype.findAggregatedObjects = function(bRecursive) {
	
		var aAggregatedObjects = [];
		function fFindObjects(oObject) {
			for (var n in oObject.mAggregations) {
				var a = oObject.mAggregations[n];
				if (jQuery.isArray(a)) {
					for (var i = 0; i < a.length; i++) {
						aAggregatedObjects.push(a[i]);
						if (bRecursive) {
							fFindObjects(a[i]);
						}
					}
				} else if (a instanceof ManagedObject) {
					aAggregatedObjects.push(a);
					if (bRecursive) {
						fFindObjects(a);
					}
				}
			}
		}
		fFindObjects(this);
		return aAggregatedObjects;
	
	};
	

	return ManagedObject;

}, /* bExport= */ true);

}; // end of sap/ui/base/ManagedObject.js
if ( !jQuery.sap.isDeclared('sap.ui.core.ComponentMetadata') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.core.ComponentMetadata
jQuery.sap.declare('sap.ui.core.ComponentMetadata'); // unresolved dependency added by SAPUI5 CreateModule Ant-Task
sap.ui.define("sap/ui/core/ComponentMetadata",['jquery.sap.global', 'sap/ui/base/ManagedObjectMetadata'],
	function(jQuery, ManagedObjectMetadata) {
	"use strict";


		
	/**
	 * Creates a new metadata object for a Component subclass.
	 *
	 * @param {string} sClassName fully qualified name of the class that is described by this metadata object
	 * @param {object} oStaticInfo static info to construct the metadata from
	 *
	 * @experimental Since 1.9.2. The Component concept is still under construction, so some implementation details can be changed in future.
	 * @class
	 * @author SAP
	 * @version 1.20.6
	 * @since 1.9.2
	 * @name sap.ui.core.ComponentMetadata
	 */
	var ComponentMetadata = function(sClassName, oClassInfo) {
		
		// call super constructor
		ManagedObjectMetadata.apply(this, arguments);
		
	};
	
	//chain the prototypes
	ComponentMetadata.prototype = jQuery.sap.newObject(ManagedObjectMetadata.prototype);
	
	ComponentMetadata.preprocessClassInfo = function(oClassInfo) {
		// if the component is a string we convert this into a "_src" metadata entry
		// the specific metadata object can decide to support this or gracefully ignore it
		// basically the ComponentMetadata makes use of this feature
		if (oClassInfo && typeof oClassInfo.metadata === "string") {
			oClassInfo.metadata = {
				_src: oClassInfo.metadata
			};
		}
		return oClassInfo;
	};
	
	ComponentMetadata.prototype.applySettings = function(oClassInfo) {
	
		var oStaticInfo = oClassInfo.metadata;
	
		ManagedObjectMetadata.prototype.applySettings.call(this, oClassInfo);
	
		// if the component specifies the metadata property: loadFromFile then
		// the component metadata will be loaded from the specified file 
		// which needs to be located next to the Component.js file.
		var sName = this.getName(),
		    sPackage = sName.replace(/\.\w+?$/, "");
		if (oStaticInfo._src) {
			jQuery.sap.log.warning("The metadata of the component " + sName + " is loaded from file " + oStaticInfo._src + ". This is a design time feature and not for productive usage!");
			var sUrl = jQuery.sap.getModulePath(sPackage, "/" + oStaticInfo._src);
			var oResponse = jQuery.sap.syncGetJSON(sUrl);
			if (oResponse.success) {
				jQuery.extend(oStaticInfo, oResponse.data);
			} else {
				jQuery.sap.log.error("Failed to load component metadata from \"" + oStaticInfo._src + "\"! Reason: " + oResponse.error);
			}
		}
		
		// keep the infor about the component name (for customizing)
		this._sComponentName = sPackage;
		
		// static initialization flag & instance count
		this._bInitialized = false;
		this._iInstanceCount = 0;
		
		// extract the custom component data from the static info 
		this._sVersion = oStaticInfo.version;
		this._mDependencies = oStaticInfo.dependencies;
		this._aIncludes = oStaticInfo.includes;
		this._mConfig = oStaticInfo.config;
		this._mCustomizing = oStaticInfo.customizing;
	
		// extract the models and services custom component data
		// (as models and services are experimental the default value is applied here
		//  to avoid mentioning those options in the component metadata section!) 
		this._mModels = oStaticInfo.models || {}; 
		this._mServices = oStaticInfo.services || {};
		
		// some metadata needs to be merged with the metadata for the parent component
		// except of the version, dependencies and includes => they are handled by the
		// specific component metadata implementation and no merge is required here!
		var oParent = this.getParent();
		if (oParent instanceof ComponentMetadata) {
			this._mConfig = jQuery.extend(true, {}, oParent._mConfig, this._mConfig);
			this._mCustomizing = jQuery.extend(true, {}, oParent._mCustomizing, this._mCustomizing);
			this._mModels = jQuery.extend(true, {}, oParent._mModels, this._mModels);
			this._mServices = jQuery.extend(true, {}, oParent._mServices, this._mServices);
		}
		
	};
	
	/**
	 * Static initialization of components. This function will be called by the 
	 * component and the metadata decides whether to execute the static init code
	 * or not. It will be called the first time a component is initialized.
	 * @private
	 * @name sap.ui.core.ComponentMetadata#init
	 * @function
	 */
	ComponentMetadata.prototype.init = function() {
		if (!this._bInitialized) {
	
			// first we load the dependencies of the parent
			var oParent = this.getParent();
			if (oParent instanceof ComponentMetadata) {
				oParent.init();
			}
			
			// first the dependencies have to be loaded (other UI5 libraries)
			this._loadDependencies();
			
			// then load the custom scripts and CSS files
			this._loadIncludes();
			
			this._bInitialized = true;
			
		}
	};
	
	/**
	 * Static termination of components.
	 *  
	 * TODO: Right now it is unclear when this function should be called. Just to
	 *       make sure that we do not forget this in future. 
	 * @private
	 * @name sap.ui.core.ComponentMetadata#exit
	 * @function
	 */
	ComponentMetadata.prototype.exit = function() {
		if (this._bInitialized) {
			var oParent = this.getParent();
			if (oParent instanceof ComponentMetadata) {
				oParent.exit();
			}
			// TODO: implement unload of CSS, ...
			this._bInitialized = false;
		}
	};
	
	/**
	 * Component instances need to register themselves in this method to enable 
	 * the customizing for this component. This will only be done for the first
	 * instance and only if a customizing configuration is available.
	 * @private
	 * @name sap.ui.core.ComponentMetadata#onInitComponent
	 * @function
	 */
	ComponentMetadata.prototype.onInitComponent = function() {
		if (this._iInstanceCount === 0 && !jQuery.isEmptyObject(this._mCustomizing)) {
			jQuery.sap.require("sap.ui.core.CustomizingConfiguration");
			sap.ui.core.CustomizingConfiguration.activateForComponent(this._sComponentName);
		}
		this._iInstanceCount++;
	};
	
	/**
	 * Component instances need to unregister themselves in this method to disable 
	 * the customizing for this component. This will only be done for the last
	 * instance and only if a customizing configuration is available.
	 * @private
	 * @name sap.ui.core.ComponentMetadata#onExitComponent
	 * @function
	 */
	ComponentMetadata.prototype.onExitComponent = function() {
		this._iInstanceCount--;
		if (this._iInstanceCount === 0 && !jQuery.isEmptyObject(this._mCustomizing)) {
			if (sap.ui.core.CustomizingConfiguration) {
				sap.ui.core.CustomizingConfiguration.deactivateForComponent(this._sComponentName);
			}
		}
	};
	
	/**
	 * Returns the dependencies defined in the metadata of the component. If not specified, the return value is null.
	 * @return {Object} Component dependencies. 
	 * @public
	 * @name sap.ui.core.ComponentMetadata#getDependencies
	 * @function
	 */
	ComponentMetadata.prototype.getDependencies = function() {
		return this._mDependencies;
	};
	
	/**
	 * Returns the array of the included files that the Component requires such as css and js. If not specified or the array is empty, the return value is null.
	 * @return {string[]} Included files.
	 * @public
	 * @name sap.ui.core.ComponentMetadata#getIncludes
	 * @function
	 */
	ComponentMetadata.prototype.getIncludes = function() {
		return (this._aIncludes && this._aIncludes.length > 0) ? this._aIncludes : null;
	};
	
	/**
	 * Returns the required version of SAP UI5 defined in the metadata of the Component. If returned value is null, then no special UI5 version is required.
	 * @return {string} Required version of UI5 or if not specified then null.
	 * @public
	 * @name sap.ui.core.ComponentMetadata#getUI5Version
	 * @function
	 */
	ComponentMetadata.prototype.getUI5Version = function() {
		return this._mDependencies ? this._mDependencies.ui5version : null;
	};   
	
	/**
	 * Returns array of components specified in the metadata of the Component. If not specified or the array is empty, the return value is null.
	 * @return {string[]} Required Components.
	 * @public
	 * @name sap.ui.core.ComponentMetadata#getComponents
	 * @function
	 */
	ComponentMetadata.prototype.getComponents = function() {
		var aComponents = null;
		if (this._mDependencies) {
			if (this._mDependencies.components && (this._mDependencies.components.length > 0) ) {
				aComponents = this._mDependencies.components;
			}
		} 
		return aComponents;
	};
	
	/**
	 * Returns array of libraries specified in metadata of the Component, that are automatically loaded when an instance of the component is created.
	 * If not specified or the array is empty, the return value is null.
	 * @return {string[]} Required libraries.
	 * @public
	 * @name sap.ui.core.ComponentMetadata#getLibs
	 * @function
	 */
	ComponentMetadata.prototype.getLibs = function() {
		var aLibs = null;
		if (this._mDependencies) {
			if (this._mDependencies.libs && (this._mDependencies.libs.length > 0) ) {
				aLibs = this._mDependencies.libs;
			}
		} 
		return aLibs;
	};
	
	/**
	 * Returns the version of the component. If not specified, the return value is null.
	 * @return {string} The version of the component.
	 * @public
	 * @name sap.ui.core.ComponentMetadata#getVersion
	 * @function
	 */
	ComponentMetadata.prototype.getVersion = function() {
		return this._sVersion;
	};
	
	
	/**
	 * Returns a copy of the configuration property to disallow modifications. If no 
	 * key is specified it returns the complete configuration property.
	 * @param {string} [sKey] the key of the configuration property
	 * @return {object} the value of the configuration property
	 * @public
	 * @since 1.15.1
	 * @name sap.ui.core.ComponentMetadata#getConfig
	 * @function
	 */
	ComponentMetadata.prototype.getConfig = function(sKey) {
		return this._mConfig ? jQuery.extend({}, sKey ? this._mConfig[sKey] : this._mConfig) : undefined;
	};
	
	
	/**
	 * Returns a copy of the customizing property
	 * @return {object} the value of the customizing property
	 * @private
	 * @since 1.15.1
	 * @experimental Since 1.15.1. Implementation might change. 
	 * @name sap.ui.core.ComponentMetadata#getCustomizing
	 * @function
	 */
	ComponentMetadata.prototype.getCustomizing = function() {
		return this._mCustomizing ? jQuery.extend({}, this._mCustomizing) : undefined;
	};
	
	
	/**
	 * Returns the models configuration which defines the available models of the
	 * component. 
	 * @return {object} models configuration
	 * @private
	 * @since 1.15.1 
	 * @experimental Since 1.15.1. Implementation might change. 
	 * @name sap.ui.core.ComponentMetadata#getModels
	 * @function
	 */
	ComponentMetadata.prototype.getModels = function() {
		return this._mModels;
	};
	
	/**
	 * Returns the services configuration which defines the available services of the
	 * component. 
	 * @return {object} services configuration
	 * @private
	 * @since 1.15.1 
	 * @experimental Since 1.15.1. Implementation might change. 
	 * @name sap.ui.core.ComponentMetadata#getServices
	 * @function
	 */
	ComponentMetadata.prototype.getServices = function() {
		return this._mServices;
	};
	
	/**
	 * Loads the included CSS and JavaScript resources. The resources will be 
	 * resoloved relative to the component location. 
	 * 
	 * @private
	 * @name sap.ui.core.ComponentMetadata#_loadIncludes
	 * @function
	 */
	ComponentMetadata.prototype._loadIncludes = function() {
	
		// afterwards we load our includes!
		var aIncludes = this.getIncludes();
		if (aIncludes && aIncludes.length > 0) {
			var that = this;
			var sLibName = this.getLibraryName();
			jQuery.each(aIncludes, function(i, sFile) {
				if (sFile.match(/\.css$/i)) { 
					var sCssUrl = sap.ui.resource(sLibName, sFile);
					jQuery.sap.log.info("Component \"" + that.getName() + "\" is loading CSS: \"" + sCssUrl + "\"");
					jQuery.sap.includeStyleSheet(sCssUrl /* TODO: , sId (do we have a good idea how to create the id?!) */ );
				} else {
					// load javascript file
					var m = sFile.match(/\.js$/i);
					if (m) {
						// prepend lib name to path, remove extension
						var sPath = sLibName.replace(/\./g, '/') + (sFile.slice(0, 1) === '/' ? '' : '/') + sFile.slice(0, m.index);
						jQuery.sap.log.info("Component \"" + that.getName() + "\" is loading JS: \"" + sPath + "\"");
						// call internal require variant that accepts a requireJS path
						jQuery.sap._requirePath(sPath);
					}
				}
			});
		}
		
	};
	
	/**
	 * Load external dependencies (like libraries and components)
	 * 
	 * @private
	 * @name sap.ui.core.ComponentMetadata#_loadDependencies
	 * @function
	 */
	ComponentMetadata.prototype._loadDependencies = function() {
	
		// afterwards we load our dependencies!
		var that = this,
		    oDep = this.getDependencies();
		if (oDep) {
			
			// load the libraries
			var aLibraries = oDep.libs;
			if (aLibraries) {
				jQuery.each(aLibraries, function(i, sLib) {
					jQuery.sap.log.info("Component \"" + that.getName() + "\" is loading library: \"" + sLib + "\"");
					sap.ui.getCore().loadLibrary(sLib);
				});
			}
			
			// load the components
			var aComponents = oDep.components;
			if (aComponents){
				jQuery.each(aComponents, function(i, sName){
					jQuery.sap.log.info("Component \"" + that.getName() + "\" is loading component: \"" + sName + ".Component\"");
					sap.ui.component.load({
						name: sName
					});
				});
			}
			
		}
		
	};
	

	return ComponentMetadata;

}, /* bExport= */ true);

}; // end of sap/ui/core/ComponentMetadata.js
sap.ui.define("sap/ui/core/Component",['jquery.sap.global', 'sap/ui/base/ManagedObject', './ComponentMetadata', './Core'],
	function(jQuery, ManagedObject, ComponentMetadata, Core) {
	"use strict";

//jQuery.sap.require("sap.ui.model.json.JSONModel");
	
	/**
	 * Creates and initializes a new component with the given <code>sId</code> and
	 * settings.
	 * 
	 * The set of allowed entries in the <code>mSettings</code> object depends on
	 * the concrete subclass and is described there. See {@link sap.ui.core.Component}
	 * for a general description of this argument.
	 * 
	 * @param {string}
	 *            [sId] optional id for the new control; generated automatically if
	 *            no non-empty id is given Note: this can be omitted, no matter
	 *            whether <code>mSettings</code> will be given or not!
	 * @param {object}
	 *            [mSettings] optional map/JSON-object with initial settings for the
	 *            new component instance
	 * @public
	 * 
	 * @class Base Class for Component.
	 * @extends sap.ui.base.ManagedObject
	 * @abstract
	 * @author SAP
	 * @version 1.20.6
	 * @name sap.ui.core.Component
	 * @experimental Since 1.9.2. The Component concept is still under construction, so some implementation details can be changed in future.
	 */
	var Component = ManagedObject.extend("sap.ui.core.Component", /** @lends sap.ui.core.Component */
	
	{
		constructor : function(sId, mSettings) {
	
			ManagedObject.apply(this, arguments);
	
		},
	
		metadata : {
			stereotype : "component",
			"abstract": true,
			version : "0.0",
			includes : [],  // css, javascript files that should be used in the component
			dependencies : { // external dependencies
				libs : [],
				components : [],
				ui5version : ""
			},
			config: {}, // static configuration
			customizing: { // component/view customizing
				// TODO: custom customizing data? not prefixed with sap.ui.
				//       e.g. sap.ext.viewExtensions => to be handled by custom hook!
				/*
				"sap.ui.viewReplacements": {
					"sap.xx.org.Main": {
						viewName: "sap.xx.new.Main",
						type: "XML"
					}
				},
				"sap.ui.controllerReplacements": {
					"sap.xx.org.Main": "sap.xx.new.Main"
				},
				"sap.ui.viewExtensions": {
					"sap.xx.new.Main": { // TODO: global or view dependant names for extensions? ==> locally in the view / use the new name!
						"extensionX": {
							name: "sap.xx.new.Fragment1",
							type: "sap.ui.core.XMLFragment"
						},
						"extensionY": {
							...
						}
					}
				},
				"sap.ui.viewModification": { // ?????
					"sap.xx.new.Main": {
						"myControlId": {
							text: "{i18n_custom>mytext}"
						}
					}
				}
				*/
			},
			/*
			properties: {
				config : "any"
			},
			*/
			library: "sap.ui.core"
		}
	
	}, /* Metadata constructor */ ComponentMetadata);
	
	
	/**
	 * Activates the customizing configuration for the given component.
	 * @param {string} sComponentName the name of the component to activate
	 * @private
	 * @name sap.ui.core.Component.activateCustomizing
	 * @function
	 */
	Component.activateCustomizing = function(sComponentName) {
		// noop since it will be handled by component instantiation
	};
	
	/**
	 * Deactivates the customizing configuration for the given component.
	 * @param {string} sComponentName the name of the component to activate
	 * @private
	 * @name sap.ui.core.Component.deactivateCustomizing
	 * @function
	 */
	Component.deactivateCustomizing = function(sComponentName) {
		// noop since it will be handled by component termination
	};
	
	/**
	 * Returns the ID of the owner component in which the given ManagedObject has been
	 * created. 
	 * @param {sap.ui.core.ManagedObject} oObject the ManagedObject to return the owner component ID for
	 * @return {string} the owner component ID
	 * @static
	 * @protected
	 * @experimental Since 1.15.1. The location of this function might change.
	 * @name sap.ui.core.Component.getOwnerIdFor
	 * @function
	 */
	Component.getOwnerIdFor = function(oObject) {
		// the owner id is only supported for Components and Views
		if (oObject && (oObject instanceof Component ||
				            oObject instanceof sap.ui.core.mvc.View)) {
			return ManagedObject.getOwnerIdFor(oObject);
		} 
	};
	
	/**
	 * @see sap.ui.base.Object#getInterface
	 * @public
	 * @name sap.ui.core.Component#getInterface
	 * @function
	 */
	Component.prototype.getInterface = function() {
		return this;
	};
	
	/*
	 * initialize the Component and keep the component data
	 * @name sap.ui.core.Component#_initCompositeSupport
	 * @function
	 */
	Component.prototype._initCompositeSupport = function(mSettings) {
	
		// registry of mock servers
		this._mMockServers = {};
		
		// register the component instance
		this.getMetadata().onInitComponent();
		
		// make user specific data available during component instantiation
		this.oComponentData = mSettings && mSettings.componentData;
	
		// static initialization
		this.getMetadata().init();
		
		// init the component models
		this.initComponentModels();
		
		// error handler (if exists)
		if (this.onWindowError) {
			this._fnWindowErrorHandler = jQuery.proxy(function(oEvent) {
				var oError = oEvent.originalEvent;
				this.onWindowError(oError.message, oError.filename, oError.lineno);
			}, this);
			jQuery(window).bind("error", this._fnWindowErrorHandler);
		}
	
		// before unload handler (if exists)
		if (this.onWindowBeforeUnload) {
			this._fnWindowBeforeUnloadHandler = jQuery.proxy(this.onWindowBeforeUnload, this);
			jQuery(window).bind("beforeunload", this._fnWindowBeforeUnloadHandler);
		}
	
		// unload handler (if exists)
		if (this.onWindowUnload) {
			this._fnWindowUnloadHandler = jQuery.proxy(this.onWindowUnload, this);
			jQuery(window).bind("unload", this._fnWindowUnloadHandler);
		}
		
	};
	
	/*
	 * clean up mock server and event handlers
	 * @name sap.ui.core.Component#destroy
	 * @function
	 */
	Component.prototype.destroy = function() {
		
		// kill the mock servers
		if (this._mMockServers) {
			jQuery.each(this._mMockServers, function(sName, oMockServer) {
				oMockServer.stop();
			});
			delete this._mMockServers;
		}
		
		// remove the event handlers
		if (this._fnWindowErrorHandler) {
			jQuery(window).unbind("error", this._fnWindowErrorHandler);
			delete this._fnWindowErrorHandler;
		}
		if (this._fnWindowBeforeUnloadHandler) {
			jQuery(window).unbind("beforeunload", this._fnWindowBeforeUnloadHandler);
			delete this._fnWindowBeforeUnloadHandler; 
		}
		if (this._fnWindowUnloadHandler) {
			jQuery(window).unbind("unload", this._fnWindowUnloadHandler);
			delete this._fnWindowUnloadHandler;
		}
		
		// destroy event bus
		if(this._oEventBus){
			this._oEventBus.destroy();
			delete this._oEventBus;
		}
		
		// destroy the object
		ManagedObject.prototype.destroy.apply(this, arguments);
		
		// unregister the component instance
		this.getMetadata().onExitComponent();
		
	};
	
	
	/**
	 * Returns user specific data object
	 *
	 * @return object componentData
	 * @public
	 * @since 1.15.0
	 * @name sap.ui.core.Component#getComponentData
	 * @function
	 */
	Component.prototype.getComponentData = function() {
		return this.oComponentData;
	};
	
	
	/**
	 * Returns the event bus of this component.
	 * @return {sap.ui.core.EventBus} the event bus
	 * @since 1.20.0
	 * @public
	 * @name sap.ui.core.Component#getEventBus
	 * @function
	 */
	Component.prototype.getEventBus = function() {
		if(!this._oEventBus){
			jQuery.sap.require("sap.ui.core.EventBus");
			this._oEventBus = new sap.ui.core.EventBus();
		}
		return this._oEventBus;
	};
	
	
	/**
	 * Initializes the component models and services.
	 * 
	 * @private
	 * @name sap.ui.core.Component#initComponentModels
	 * @function
	 */
	Component.prototype.initComponentModels = function(mModels, mServices) {
		
		var oMetadata = this.getMetadata();
		
		// get the application configuration
		var oModelsConfig = mModels || oMetadata.getModels(),
		    oServicesConfig = mServices || oMetadata.getServices();
	
		// iterate over the model configurations and create and register the 
		// models base on the configuration if available
		if (oModelsConfig) {
			
			// create and start the mock server
			var fnCreateMockServer = function(sName, sUri, sMetadataUrl, sMockdataBaseUrl) {
				
				// kill the existing mock server
				if (this._mMockServers[sName]) {
					this._mMockServers[sName].stop();
				}
				
				// start the mock server
				jQuery.sap.require("sap.ui.core.util.MockServer");
				this._mMockServers[sName] = new sap.ui.core.util.MockServer({
					rootUri: sUri
				});
				
				this._mMockServers[sName].simulate(sMetadataUrl, sMockdataBaseUrl);
				this._mMockServers[sName].start();
					
			};
			
			// helper to create a model depending on the type
			// TODO: models could have generic instantiation to pass the JSON object 
			//       of the configuration directly instead of individual handling 
			var fnCreateModel = function(sName, oConfig) {
				
				// extract uri and type
				var sUri = oConfig.uri, sType = oConfig.type;
				
				// require the model and instantiate it
				jQuery.sap.require(sType);
				var oClass = jQuery.sap.getObject(sType);
				jQuery.sap.assert(oClass !== undefined, "The specified model type \"" + sType + "\" could not be found!");
				
				// create the model and apply the configuration
				var oModel;
				if (sType === "sap.ui.model.resource.ResourceModel") {
					oModel = new oClass({bundleUrl: sUri});
				} else if (sType === "sap.ui.model.odata.ODataModel") {
					// check for a mock server configuration and start the mock server
					if (oConfig.mockserver) {
						fnCreateMockServer.call(this, sName, sUri, oConfig.mockserver.model, oConfig.mockserver.data);
					}
					// create the model
					oModel = new oClass(sUri, oConfig.settings);
				} else if (sType === "sap.ui.model.json.JSONModel" || sType === "sap.ui.model.xml.XMLModel") {
					oModel = new oClass();
					if (sUri) {
						oModel.loadData(sUri);
					}
				} /* else {
					TODO: what about custom models / analog to ODataModel & setting? 
				} */
	
				// check the model to be an instance of sap.ui.model.Model
				jQuery.sap.assert(oModel instanceof sap.ui.model.Model, "The specified model type \"" + sType + "\" must be an instance of sap.ui.model.Model!");
				return oModel;
	
			};
			
			// create the models
			var that = this;
			jQuery.each(oModelsConfig, function(sKey, oModelConfig) {
				
				// if the model refer to a service configuration we use the service configuration 
				var sService = oModelConfig.service, 
				    oModel;
				if (sService) {
					var oServiceConfig = oServicesConfig[sService]; 
					jQuery.sap.assert(oServiceConfig, "The service configuration for service \"" + sService + "\" is not available!");
					oModel = fnCreateModel.call(that, sKey, oServiceConfig);
				} else if (oModelConfig.type) {
					oModel = fnCreateModel.call(that, sKey, oModelConfig);
				}
				
				// we apply the model to the root component if created
				if (oModel) {
					that.setModel(oModel, sKey || undefined);
				}
				
			});
			
		}
		
	};
	
	
	/* * TODO: RETHINK THIS CONCEPT!
	 * Sets the configuration model. The configuration model is named "config" and
	 * can be accessed via <code>getModel("config")</code>.
	 * 
	 * @param {string|object|sap.ui.model.Model} vConfig the configuration model, the configuration object or a URI string to load a JSON configuration file.
	 * @since 1.15.1
	 * @public
	 */
	/* 
	sap.ui.core.Component.prototype.setConfig = function(vConfig) {
		this.setProperty("config", vConfig);
		if (typeof vConfig === "string") {
			var sUri = vConfig;
			var vConfig = new sap.ui.model.json.JSONModel();
			var oResponse = jQuery.sap.sjax({url:sUri, dataType:'json'});
			if (oResponse.success) {
				vConfig.setData(oResponse.data);
			} else {
				throw new Error("Could not load config file: " + sUri);
			}
		}
		if (typeof vConfig === "object" && !vConfig instanceof sap.ui.model.Model) {
			vConfig = new sap.ui.model.json.JSONModel(vConfig);
		}
		jQuery.sap.assert(vConfig === undefined || vConfig instanceof sap.ui.model.Model, "the config property value must be a string, an object or an instance of sap.ui.model.Model");
		this.setModel("config", vConfig);
	},
	*/
	
	
	/**
	 * Initializes the Component instance after creation.
	 *
	 * Applications must not call this hook method directly, it is called by the
	 * framework while the constructor of an Component is executed.
	 *
	 * Subclasses of Component should override this hook to implement any necessary
	 * initialization.
	 *
	 * @function
	 * @name sap.ui.core.Component.prototype.init
	 * @protected
	 */
	//sap.ui.core.Component.prototype.init = function() {};
	
	/**
	 * Cleans up the component instance before destruction.
	 *
	 * Applications must not call this hook method directly, it is called by the
	 * framework when the element is {@link #destroy destroyed}.
	 * 
	 * Subclasses of Component should override this hook to implement any necessary
	 * cleanup.
	 *
	 * @function
	 * @name sap.ui.core.Component.prototype.exit
	 * @protected
	 */
	//sap.ui.core.Component.prototype.exit = function() {};
	
	
	/**
	 * The window before unload hook. Override this method in your Component class 
	 * implementation, to handle cleanup before the real unload or to prompt a question 
	 * to the user, if the component should be exited.
	 * 
	 * @return {string} return a string if a prompt should be displayed to the user 
	 *                  confirming closing the component (e.g. when the component is not yet saved).
	 * @public
	 * @since 1.15.1
	 * @name sap.ui.core.Component.prototype.onWindowBeforeUnload
	 * @function
	 */
	//onWindowBeforeUnload : function() {},
	
	
	/**
	 * The window unload hook. Override this method in your Component class 
	 * implementation, to handle cleanup of the component once the window
	 * will be unloaded (e.g. closed).
	 * 
	 * @public
	 * @since 1.15.1
	 * @name sap.ui.core.Component.prototype.onWindowUnload
	 * @function
	 */
	//onWindowUnload : function() {},
	
	
	/**
	 * The window error hook. Override this method in your Component class implementation 
	 * to listen to unhandled errors.
	 * 
	 * @param {string} sMessage The error message.
	 * @param {string} sFile The file where the error occurred
	 * @param {number} iLine The line number of the error
	 * @public
	 * @since 1.15.1
	 * @name sap.ui.core.Component.prototype.onError
	 * @function
	 */
	//onWindowError : null, // function(sMessage, sFile, iLine) - function not added directly as it might result in bad stack traces in older browsers
	
	
	/**
	 * The hook which gets called when the static configuration of the component 
	 * has been changed by some configuration extension.
	 * 
	 * @param {string} sConfigKey The error message.
	 * @public
	 * @since 1.15.1
	 * @name sap.ui.core.Component.prototype.onConfigChange
	 * @function
	 */
	//onConfigChange : null, // function(sConfigKey)
	
	
	/**
	 * Creates a new instance of a <code>Component</code> or returns the instance
	 * of an existing <code>Component</code>.
	 * 
	 * If you want to lookup all an existing <code>Component</code> you can call
	 * this function with a component ID as parameter:
	 * <pre> 
	 *   var oComponent = sap.ui.component(sComponentId);
	 * </pre>
	 * 
	 * To create a new instance of a component you pass a component configuration
	 * object into this function:
	 * <pre>
	 *   var oComponent = sap.ui.component({
	 *     name: "my.Component",
	 *     url: "my/component/location",
	 *     id: "myCompId1"
	 *   });
	 * </pre>
	 * 
	 * @param {string|object} oComponent the id of an existing Component or the configuration object to create the Component
	 * @param {string} oComponent.name the name of the Component to load
	 * @param {string} [oComponent.url] an alternate location from where to load the Component
	 * @param {object} [oComponent.componentData] initial data of the Component (@see sap.ui.core.Component#getComponentData)
	 * @param {string} [oComponent.id] the sId of the new Component
	 * @param {object} [oComponent.settings] the mSettings of the new Component 
	 * @return {sap.ui.core.Component} the Component instance 
	 * 
	 * @public
	 * @static
	 * @since 1.15.0
	 */
	sap.ui.component = function(oComponent) {
		
		// a parameter must be given!
		if (!oComponent) {
			throw new Error("sap.ui.component cannot be called without parameter!");
		}
		
		// when only a string is given then this function behaves like a 
		// getter and returns an existing component instance
		if (typeof oComponent === "string") {
			
			// lookup and return the component
			return sap.ui.getCore().getComponent(oComponent);
			
		} else {
			
			// retrieve the required properties
			var sName = oComponent.name,
			    sId = oComponent.id,
			    oComponentData = oComponent.componentData,
			    sController = sName + ".Component",
			    mSettings = oComponent.settings;
			
			// load the component class 
			var oClass = sap.ui.component.load(oComponent);
			
			// create an instance
			var oInstance = new oClass(jQuery.extend({}, mSettings, {
				id: sId,
				componentData: oComponentData
			}));
			jQuery.sap.assert(oInstance instanceof Component, "The specified component \"" + sController + "\" must be an instance of sap.ui.core.Component!");
			jQuery.sap.log.info("Component instance Id = " + oInstance.getId());
			return oInstance;
			
		}
		
	};
	
	/**
	 * Load a component without instantiating it.
	 * 
	 * @experimental since 1.16.3
	 * @static
	 * @public
	 */
	sap.ui.component.load = function(oComponent) {
	
		var sName = oComponent.name,
			sUrl = oComponent.url,
			sController = sName + ".Component",
			sPreloadModule = sController + "-preload",
			sPreloadMode = sap.ui.getCore().getConfiguration().getComponentPreload();
			
		// check for an existing name
		if (!sName) {
			throw new Error("The name of the component is undefined.");
		}
		
		// check the type of the name
		jQuery.sap.assert(typeof sName === "string", "sName must be a string");
	
		// if a URL is given we register this URL for the name of the component:
		// the name is the package in which the component is located (dot separated)
		if (sUrl) {
			jQuery.sap.registerModulePath(sName, sUrl);
		}
	
		if ( sPreloadMode === "sync" || sPreloadMode === "async" ) {
			try {
				// only load the Component-preload file if the Component module is not yet available
				if ( !jQuery.sap.isDeclared(sController, /* bIncludePreloaded=*/ true) ) {
					jQuery.sap.require(sPreloadModule);
				}
			} catch(e) {
				jQuery.sap.log.warning("couldn't preload component from " + sPreloadModule + ": " + ((e && e.message) || e));
			}
	  }
		
		// require the component controller
		jQuery.sap.require(sController);
		var oClass = jQuery.sap.getObject(sController);
	
		jQuery.sap.assert(oClass !== undefined, "The specified component \"" + sController + "\" could not be found!");
		
		return oClass;
	}
	

	return Component;

}, /* bExport= */ true);

}; // end of sap/ui/core/Component.js
if ( !jQuery.sap.isDeclared('sap.ui.core.Configuration') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

//Provides class sap.ui.core.Configuration
jQuery.sap.declare('sap.ui.core.Configuration'); // unresolved dependency added by SAPUI5 CreateModule Ant-Task
if ( !jQuery.sap.isDeclared('sap.ui.core.Locale') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

//Provides the locale object sap.ui.core.Locale
jQuery.sap.declare('sap.ui.core.Locale'); // unresolved dependency added by SAPUI5 CreateModule Ant-Task
sap.ui.define("sap/ui/core/Locale",['jquery.sap.global', 'sap/ui/base/Object'],
	function(jQuery, BaseObject) {
	"use strict";


	
	
		/**
		 * A regular expression that describes language tags according to BCP-47.
		 * @see BCP47 "Tags for Identifying Languages" (http://www.ietf.org/rfc/bcp/bcp47.txt)
		 *
		 * The matching groups are
		 *  0=all
		 *  1=language (shortest ISO639 code + ext. language sub tags | 4digits (reserved) | registered language sub tags)
		 *  2=script (4 letters)
		 *  3=region (2letter language or 3 digits)
		 *  4=variants (separated by '-', Note: capturing group contains leading '-' to shorten the regex!)
		 *  5=extensions (including leading singleton, multiple extensions separated by '-')
		 *  6=private use section (including leading 'x', multiple sections separated by '-')
		 *  
		 *            [-------------------- language ----------------------][--- script ---][------- region --------][------------ variants --------------][--------- extensions --------------][------ private use -------]
		 */
		var rLocale=/^((?:[A-Z]{2,3}(?:-[A-Z]{3}){0,3})|[A-Z]{4}|[A-Z]{5,8})(?:-([A-Z]{4}))?(?:-([A-Z]{2}|[0-9]{3}))?(-[0-9A-Z]{5,8}|(?:[0-9][0-9A-Z]{3}))*(?:-([0-9A-WYZ](?:-[0-9A-Z]{2,8})+))*(?:-(X(?:-[0-9A-Z]{1,8})+))?$/i;
	
		/**
		 * Creates an instance of the Locale.
		 *
		 * @class Locale represents a locale setting, consisting of a language, script, region, variants, extensions and private use section
		 *
		 * @param {string} sLocaleId the locale identifier, in format en-US or en_US.
		 *
		 * @extends sap.ui.base.Object
		 * @author SAP AG
		 * @version 1.20.6
		 * @constructor
		 * @public
		 * @name sap.ui.core.Locale
		 */
		var Locale = BaseObject.extend("sap.ui.core.Locale", /** @lends sap.ui.core.Locale.prototype */ {
	
			constructor : function(sLocaleId) {
				BaseObject.apply(this);
				var aResult = rLocale.exec(sLocaleId.replace(/_/g, "-"));
				
				// If the given Locale string cannot be parsed by the regular expression above we 
				// should at least tell the developer why the core fails to load.
				if (aResult === null) {
					throw "The given language does not adhere to BCP-47.";
				}
				
				this.sLocaleId = sLocaleId;
				this.sLanguage = aResult[1] || null;
				this.sScript = aResult[2] || null;
				this.sRegion = aResult[3] || null;
				this.sVariant = (aResult[4] && aResult[4].slice(1)) || null; // remove leading dash from capturing group
				this.sExtension = aResult[5] || null;
				this.sPrivateUse = aResult[6] || null;
	
				// normalization according to BCP47:
				if ( this.sLanguage ) {
					this.sLanguage = this.sLanguage.toLowerCase();
				}
				if ( this.sScript ) {
					this.sScript = this.sScript.toLowerCase().replace(/^[a-z]/, function($) { return $.toUpperCase(); });
				} 
				if ( this.sRegion ) {
					this.sRegion = this.sRegion.toUpperCase();
				} 
			},
	
			/**
			 * Get the locale language.
			 *
			 * Note that the case might differ from the original script tag 
			 * (Lower case is enforced as recommended by BCP47/ISO639).
			 * 
			 * @return {string} the language code
			 * @public
			 */
			getLanguage : function() {
				return this.sLanguage;
			},
	
			/**
			 * Get the locale script or null if none was specified.
			 * 
			 * Note that the case might differ from the original language tag
			 * (Upper case first letter and lower case reminder enforced as 
			 * recommended by BCP47/ISO15924)  
			 * 
			 * @return {string} the script code or null
			 * @public
			 */
			getScript : function() {
				return this.sScript;
			},
	
			/**
			 * Get the locale region or null if none was specified.
			 *
			 * Note that the case might differ from the original script tag 
			 * (Upper case is enforced as recommended by BCP47/ISO3166-1).
			 * 
			 * @return {string} the ISO3166-1 region code (2-letter or 3-digits)
			 * @public
			 */
			getRegion : function() {
				return this.sRegion;
			},
	
			/**
			 * Get the locale variants as a single string or null.
			 * 
			 * Multiple variants are separated by a dash '-'.
			 * 
			 * @return {string} the variant or null
			 * @public
			 */
			getVariant : function() {
				return this.sVariant;
			},
	
			/**
			 * Get the locale variants as an array of individual variants.
			 * 
			 * The separating dashes are not part of the result.
			 * If there is no variant section in the locale tag, an empty array is returned.
			 * 
			 * @return {string[]} the individual variant sections 
			 * @public
			 */
			getVariantSubtags : function() {
				return this.sVariant ? this.sVariant.split('-') : [];
			},
	
			/**
			 * Get the locale extension as a single string or null.
			 * 
			 * The extension always consists of a singleton character (not 'x'), 
			 * a dash '-' and one or more extension token, each separated 
			 * again with a dash.
			 * 
			 * Use {@link #getExtensions} to get the individual extension tokens as an array.
			 * 
			 * @return {string} the extension
			 * @public
			 */
			getExtension : function() {
				return this.sExtension;
			},
	
			/**
			 * Get the locale extensions as an array of tokens.
			 * 
			 * The leading singleton and the separating dashes are not part of the result.
			 * If there is no extensions section in the locale tag, an empty array is returned.
			 * 
			 * @return {string[]} the individual extension sections
			 * @public
			 */
			getExtensionSubtags : function() {
				return this.sExtension ? this.sExtension.slice(2).split('-') : [];
			},
	
			/**
			 * Get the locale private use section or null.
			 *
			 * @return {string} the private use section
			 * @public
			 */
			getPrivateUse : function() {
				return this.sPrivateUse;
			},
	
			/**
			 * Get the locale private use section
			 *
			 * @return {string} the private use section
			 * @public
			 */
			getPrivateUseSubtags : function() {
				return this.sPrivateUse ? this.sPrivateUse.slice(2).split('-') : [];
			},
	
			hasPrivateUseSubtag : function(sSubtag) {
				jQuery.sap.assert(sSubtag && sSubtag.match(/^[0-9A-Z]{1,8}$/i), "subtag must be a valid BCP47 private use tag");
				return jQuery.inArray(sSubtag, this.getPrivateUseSubtags()) >= 0;
			},
	
			toString : function() {
				var r=[this.sLanguage];
				if ( this.sScript ) {
					r.push(this.sScript);
				}
				if ( this.sRegion ) {
					r.push(this.sRegion);
				}
				if ( this.sVariant ) {
					r.push(this.sVariant);
				}
				if ( this.sExtension ) {
					r.push(this.sExtension );
				}
				if ( this.sPrivateUse ) {
					r.push(this.sPrivateUse );
				}
				return r.join("-");
			},
			
			/**
			 * Best guess to get a proper SAP Logon Language for this locale.
			 * 
			 * Conversions taken into account:
			 * <ul>
			 * <li>use the language part only</li> 
			 * <li>convert old ISO639 codes to newer ones (e.g. 'iw' to 'he')</li>
			 * <li>for Chinese, map 'Traditional Chinese' to SAP proprietary code 'zf'</li>
			 * <li>map private extensions x-sap1q and x-sap2q to SAP pseudo languages '1Q' and '2Q'</li>
			 * <li>remove ext. language sub tags</li>
			 * <li>convert to uppercase</li>
			 * </ul>
			 * 
			 * Note that the conversion also returns a result for languages that are not 
			 * supported by the default set of SAP languages. This method has no knowledge 
			 * about the concrete languages of any given backend system.
			 * 
			 * @return {string} a language code that should
			 * @public
			 * @since 1.17.0
			 */
			getSAPLogonLanguage : function() {
				var sLanguage = this.sLanguage || "",
					m;
	
				// cut off any ext. language sub tags 
				if ( sLanguage.indexOf("-") >= 0 ) {
					sLanguage = sLanguage.slice(0, sLanguage.indexOf("-"));
				}
	
				// convert to new ISO codes
				sLanguage = M_ISO639_OLD_TO_NEW[sLanguage] || sLanguage;
	
				// handle special cases for Chinese: map 'Traditional Chinese' (or region TW which implies Traditional) to 'zf'  
				if ( sLanguage === "zh" ) {
					if ( this.sScript === "Hant" || (!this.sScript && this.sRegion === "TW") ) {
						sLanguage = "zf";
					}
				}
	
				// recognize SAP supportability pseudo languages
				if ( this.sPrivateUse && (m = /-(saptrc|sappsd)(?:-|$)/i.exec(this.sPrivateUse)) ) {
					sLanguage = (m[1].toLowerCase() === "saptrc") ? "1Q" : "2Q";
				}
	
				// by convention, SAP systems seem to use uppercase letters 
				return sLanguage.toUpperCase();
			}
	
		});
	
		var M_ISO639_OLD_TO_NEW = {
				"iw" : "he",
				"ji" : "yi",
				"in" : "id", 
				"sh" : "sr"
		};
	
		/**
		 * A list of locales for which the CLDR specifies "right-to-left"
		 * as the character orientation.
		 * 
		 * The string literal below is substituted during the build.
		 * The value is determined from the CLDR JSON files which are 
		 * bundled with the UI5 runtime.
		 */ 
		var A_RTL_LOCALES = "ar,fa,he".split(",");
	
		/**
		 * Checks whether the given language tag implies a character orientation 
		 * of 'right-to-left' ('RTL').
		 * 
		 * The implementation of this method and the configuration above assume 
		 * that when a language (e.g. 'ar') is marked as 'RTL', then all language/region
		 * combinations for that language (e.g. 'ar_SA') will be 'RTL' as well, 
		 * even if the combination is not mentioned in the above configuration.
		 * There is no mean to define RTL=false for a language/region, when RTL=true for 
		 * the language alone. 
		 *
		 * As of 3/2013 this is true for all supported locales/regions of UI5.
		 * 
		 * @private
		 * @name sap.ui.core.Locale._impliesRTL
		 * @function
		 */
		Locale._impliesRTL = function(sLanguage) {
			var oLocale = new Locale(sLanguage);
			sLanguage = oLocale.getLanguage() || "";
			sLanguage = (sLanguage && M_ISO639_OLD_TO_NEW[sLanguage]) || sLanguage;
			var sRegion = oLocale.getRegion() || "";
			
			if ( sRegion && jQuery.inArray(sLanguage + "_" + sRegion, A_RTL_LOCALES) >= 0 ) {
				return true;
			}
			return jQuery.inArray(sLanguage, A_RTL_LOCALES) >= 0;
		};
		
	
	

	return Locale;

}, /* bExport= */ true);

}; // end of sap/ui/core/Locale.js
sap.ui.define("sap/ui/core/Configuration",['jquery.sap.global', 'sap/ui/base/Object', './Locale', 'sap/ui/thirdparty/URI'],
	function(jQuery, BaseObject, Locale, URI1) {
	"use strict";

	/*global URI *///declare unusual global vars for JSLint/SAPUI5 validation

	/**
	 * Creates a new Configuration object.
	 *
	 * @class Collects and stores the configuration of the current environment.
	 *
	 * The Configuration is initialized once when the {@link sap.ui.core.Core} is created.
	 * There are different ways to set the environment configuration (in ascending priority):
	 * <ol>
	 * <li>System defined defaults
	 * <li>Server wide defaults, read from /sap-ui-config.json
	 * <li>Properties of the global configuration object window["sap-ui-config"]
	 * <li>A configuration string in the data-sap-ui-config attribute of the bootstrap tag
	 * <li>Individual data-sap-ui-xyz attributes of the bootstrap tag
	 * <li>Using URL parameters
	 * <li>Setters in this Configuration object (only for some parameters)
	 * </ol>
	 *
	 * That is, attributes of the DOM reference override the system defaults, URL parameters
	 * override the DOM attributes (where empty URL parameters set the parameter back to its
	 * system default). Calling setters at runtime will override any previous settings
	 * calculated during object creation.
	 *
	 * The naming convention for parameters is:
	 * <ul>
	 * <li>in the URL : sap-ui-<i>PARAMETER-NAME</i>="value"
	 * <li>in the DOM : data-sap-ui-<i>PARAMETER-NAME</i>="value"
	 * </ul>
	 * where <i>PARAMETER-NAME</i> is the name of the parameter in lower case.
	 *
	 * Values of boolean parameters are case insensitive where "true" and "x" are interpreted as true.
	 *
	 * @extends sap.ui.base.Object
	 * @author Frank Weigel (Martin Schaus)
	 * @constructor
	 * @public
	 * @name sap.ui.core.Configuration
	 */
	var Configuration = BaseObject.extend("sap.ui.core.Configuration", /** @lends sap.ui.core.Configuration.prototype */ {

		constructor : function(oCore) {
			
			this._oCore = oCore;
			
			function detectLanguage() {
				var match;
				if (!!sap.ui.Device.os.android) {
					// on Android, navigator.language is hardcoded to 'en', so check UserAgent string instead 
					match = navigator.userAgent.match(/\s([a-z]{2}-[a-z]{2})[;)]/i);
					if ( match ) {
						return match[1];
					}
					// okay, we couldn't find a language setting. It might be better to fallback to 'en' instead of having no language 
				} 
				return navigator.language || navigator.userLanguage || navigator.browserLanguage;
			}

			// definition of supported settings
			var M_SETTINGS = {
					"theme"                 : { type : "string",   defaultValue : "base" },
					"language"              : { type : "string",   defaultValue : detectLanguage() },
					"formatLocale"          : { type : "string",   defaultValue : null },
					// "timezone"              : "UTC",
					"accessibility"         : { type : "boolean",  defaultValue : true },
					"animation"             : { type : "boolean",  defaultValue : true },
					"rtl"                   : { type : "boolean",  defaultValue : null },
					"debug"                 : { type : "boolean",  defaultValue : false },
					"inspect"               : { type : "boolean",  defaultValue : false },
					"originInfo"            : { type : "boolean",  defaultValue : false },
					"noConflict"            : { type : "boolean",  defaultValue : false,     noUrl:true },
					"noDuplicateIds"        : { type : "boolean",  defaultValue : true },
					"trace"                 : { type : "boolean",  defaultValue : false,     noUrl:true },
					"modules"               : { type : "string[]", defaultValue : [],        noUrl:true },
					"areas"                 : { type : "string[]", defaultValue : null,      noUrl:true },
					// "libs"                  : { type : "string[]", defaultValue : [],        noUrl:true }, deprecated, handled below
					"onInit"                : { type : "code",     defaultValue : undefined, noUrl:true },
					"uidPrefix"             : { type : "string",   defaultValue : "__",      noUrl:true },
					"ignoreUrlParams"       : { type : "boolean",  defaultValue : false,     noUrl:true },
					"weinreServer"          : { type : "string",   defaultValue : "",        noUrl:true },
					"weinreId"              : { type : "string",   defaultValue : "" },
					"preload"               : { type : "string",   defaultValue : "auto" },
					"rootComponent"         : { type : "string",   defaultValue : "",        noUrl:true },
					"xx-rootComponentNode"  : { type : "string",   defaultValue : "",        noUrl:true },
					"application"           : { type : "string",   defaultValue : "" },
					"appCacheBuster"        : { type : "string[]", defaultValue : [] },
					"xx-appCacheBusterMode" : { type : "string",   defaultValue : "sync" },
					"xx-disableCustomizing" : { type : "boolean",  defaultValue : false,     noUrl:true },
					"xx-loadAllMode"        : { type : "boolean",  defaultValue : false,     noUrl:true },
					"xx-test-mobile"        : { type : "boolean",  defaultValue : false },
					"xx-preloadLibCss"      : { type : "string[]", defaultValue : [] },
					"xx-componentPreload"   : { type : "string",   defaultValue : "" },
					"xx-bindingSyntax"      : { type : "string",   defaultValue : "simple",  noUrl:true }, // simple|complex...
					"xx-designMode"         : { type : "boolean",  defaultValue : false },
					"xx-accessibilityMode"  : { type : "boolean",  defaultValue : false },
					"xx-supportedLanguages" : { type : "string[]", defaultValue : [] }, // *=any, sapui5 or list of locales
					"xx-bootTask"           : { type : "function", defaultValue : undefined, noUrl:true },
					"xx-suppressDeactivationOfControllerCode" : { type : "boolean",  defaultValue : false }, //temporarily to suppress the deactivation of controller code in design mode
					"xx-noNativeScroll"		: { type : "boolean",  defaultValue : false }, // suppress native scrolling on touch devices
					"statistics"            : { type : "boolean",  defaultValue : false }
			};

			var M_COMPAT_FEATURES = {
					"xx-test"               : "1.15", //for testing purposes only
					"flexBoxPolyfill"       : "1.14",
					"sapMeTabContainer"     : "1.14",
					"sapMeProgessIndicator" : "1.14",
					"sapMGrowingList"       : "1.14",
					"sapMListAsTable"       : "1.14",
					"sapMDialogWithPadding" : "1.14"
			};

			this.oFormatSettings = new Configuration.FormatSettings(this);

			/* Object that carries the real configuration data */
			var config = this;

			function setValue(sName, sValue) {
				if ( typeof sValue === "undefined" || sValue === null ) {
					return;
				}
				switch(M_SETTINGS[sName].type) {
				case "boolean":
					if ( typeof sValue === "string" ) {
						if (M_SETTINGS[sName].defaultValue) {
							config[sName] = sValue.toLowerCase() != "false";
						} else {
							config[sName] = sValue.toLowerCase() === "true" || sValue.toLowerCase() === "x";
						}
					} else {
						// boolean etc.
						config[sName] = !!sValue;
					}
					break;
				case "string":
					config[sName] = "" + sValue; // enforce string
					break;
				case "code":
					config[sName] = typeof sValue === "function" ? sValue : String(sValue);
					break;
				case "function":
					if ( typeof sValue !== "function" ) {
						throw new Error("unsupported value");
					}
					config[sName] = sValue;
					break;
				case "string[]":
					if ( jQuery.isArray(sValue) ) {
						config[sName] = sValue;
					} else if ( typeof sValue === "string" ) {
						config[sName] = jQuery.map(sValue.split(/[ ,;]/), function($) { return jQuery.trim($); });
					} else {
						throw new Error("unsupported value");
					}
					break;
				default:
					throw new Error("illegal state");
				}
			}

			function validateThemeRoot(sThemeRoot) {
				var oThemeRoot,
					sPath;

				try {
					oThemeRoot = new URI(sThemeRoot, window.location.href).normalize();
					sPath = oThemeRoot.path();
					return sPath + (sPath.slice(-1) === '/' ? '' : '/') + "UI5/";
				} catch (e) {
					// malformed URL are also not accepted 
				}
			}

			// 1. collect the defaults
			for (var n in M_SETTINGS ) {
				config[n] = M_SETTINGS[n].defaultValue;
			}

			// 2. read server wide sapui5 configuration
			/* TODO: RETHINK server wide sapui5 configuration to make it optional
    			 currently it is forcing a request which is annoying customers :
    			   - Think about an option which enables loading of server wide config!
    	var sUrl = "/sap-ui-config.json";
    	var oResponse = jQuery.sap.sjax({url:sUrl});
    	if (oResponse.success) {
    		var oServerCfg = {};
    		if (typeof oResponse.data == "string") {
    			try {
    				oServerCfg = jQuery.parseJSON(oResponse.data);
    			} catch(ex) {
    				jQuery.sap.log.warning("Error when parsing the JSON configuration content from " + sUrl + " : " + ex);
    			}
    		} else {
    			oServerCfg = oResponse.data;
    		}
    		for (var n in M_SETTINGS) {
    			if (oServerCfg[n]) {
    				setValue(n, oServerCfg[n]);
    			}
    		}
    	}
			 */

			// 3.-5. apply settings from global config object (already merged with script tag attributes)
			var oCfg = window["sap-ui-config"] || {};
			oCfg.oninit = oCfg.oninit || oCfg["evt-oninit"];
			for (var n in M_SETTINGS) {
				setValue(n, oCfg[n.toLowerCase()]);
			}
			// if libs are configured, convert them to modules and prepend them to the existing modules list
			if ( oCfg.libs ) {
				config.modules = jQuery.map(oCfg.libs.split(","), function($) { return jQuery.trim($)+".library"; }).concat(config.modules);
			}

			var PARAM_CVERS = "compatversion";
			var DEFAULT_CVERS = oCfg[PARAM_CVERS];
			var BASE_CVERS = jQuery.sap.Version("1.14");
			this._compatversion = {};

			function _getCVers(key){
				var v = !key ? DEFAULT_CVERS || BASE_CVERS.toString()
						: oCfg[PARAM_CVERS+"-"+key.toLowerCase()] || DEFAULT_CVERS || M_COMPAT_FEATURES[key] || BASE_CVERS.toString();
				v = jQuery.sap.Version(v.toLowerCase() === "edge" ? sap.ui.version : v);
				//Only major and minor version are relevant
				return jQuery.sap.Version(v.getMajor(), v.getMinor());
			}

			this._compatversion._default = _getCVers();
			for(var n in M_COMPAT_FEATURES){
				this._compatversion[n] = _getCVers(n);
			}


			// 6. apply the settings from the url (only if not blocked by app configuration)
			if ( !config.ignoreUrlParams ) {
				var sUrlPrefix = "sap-ui-";
				var oUriParams = jQuery.sap.getUriParameters();

				// map SAP parameters (if later as sap-ui parameter set this wins)
				if (oUriParams.mParams['sap-locale'] || oUriParams.mParams['sap-language']) {
					// map sap-locale or sap-language to sap-ui-language
					// if sap-language is used, handle some legacy language codes
					var sValue = oUriParams.get('sap-locale') || M_ABAP_LANGUAGE_TO_LOCALE[oUriParams.get('sap-language').toUpperCase()] || oUriParams.get('sap-language');
					if (sValue === "") {
						//empty URL parameters set the parameter back to its system default
						config['language'] = M_SETTINGS['language'].defaultValue;
					} else {
						//sets the value (null or empty value ignored)
						setValue('language', sValue);
					}
				}

				if (oUriParams.mParams['sap-accessibility']) {
					// "" = false, "X", "x" = true
					var sValue = oUriParams.get('sap-accessibility');
					if (sValue === "X" || sValue === "x") {
						setValue('xx-accessibilityMode', true);
					} else {
						setValue('xx-accessibilityMode', false);
					}
				}

				if (oUriParams.mParams['sap-rtl']) {
					// "" = false, "X", "x" = true
					var sValue = oUriParams.get('sap-rtl');
					if (sValue === "X" || sValue === "x") {
						setValue('rtl', true);
					} else {
						setValue('rtl', false);
					}
				}

				if (oUriParams.mParams['sap-theme']) {
					var sValue = oUriParams.get('sap-theme');
					if (sValue === "") {
						// empty URL parameters set the parameter back to its system default
						config['theme'] = M_SETTINGS['theme'].defaultValue;
					} else {
						setValue('theme', sValue);
					}
				}

				if (oUriParams.mParams['sap-statistics']) {
					var sValue = oUriParams.get('sap-statistics');
					setValue('statistics', sValue);
				}

				// now analyze sap-ui parameters
				for (var n in M_SETTINGS) {
					if ( M_SETTINGS[n].noUrl ) {
						continue;
					}
					var sValue = oUriParams.get(sUrlPrefix + n);
					if (sValue === "") {
						//empty URL parameters set the parameter back to its system default
						config[n] = M_SETTINGS[n].defaultValue;
					} else {
						//sets the value (null or empty value ignored)
						setValue(n, sValue);
					}
				}
			}

		  // calculate RTL mode
			this.derivedRTL = Locale._impliesRTL(config.language);
			
			// analyze theme parameter
			var sTheme = config.theme;
			var sThemeRoot;
			var iIndex = sTheme.indexOf("@");
			if (iIndex >= 0) {
				sThemeRoot = validateThemeRoot(sTheme.slice(iIndex+1));
				if ( sThemeRoot ) {
					config.theme = sTheme.slice(0, iIndex);
					config.themeRoot = sThemeRoot;
				} else {
					// fallback to non-URL parameter (if not equal to sTheme)
					config.theme = (oCfg.theme && oCfg.theme !== sTheme) ? oCfg.theme : "base";
					iIndex = -1; // enable theme mapping below 
				}
			}

			config.theme = this._normalizeTheme(config.theme, sThemeRoot); 

			// the following placeholder is replaced during the build with a list of locales supported by the UI5 core  
			var aCoreLangs = ",ar,bg,ca,cs,da,de,el,en,es,et,fi,fr,hi,hr,hu,it,iw,ja,ko,lt,lv,nl,no,pl,pt,ro,ru,sh,sk,sl,sv,th,tr,uk,vi,zh_CN,zh_TW".split(/,/);
			if ( aCoreLangs.length === 1 && aCoreLangs[0].slice(0,1) === '@' ) {
				aCoreLangs = undefined;
			}
			config['languagesDeliveredWithCore'] = aCoreLangs;

			var aLangs = config['xx-supportedLanguages'];
			if ( aLangs.length === 0 || (aLangs.length === 1 && aLangs[0] === '*') ) {
				aLangs = [];
			} else if ( aLangs.length === 1 && aLangs[0] === 'default' ) {
				aLangs = aCoreLangs || [];
			}
			config['xx-supportedLanguages'] = aLangs; 
			
			// log  all non default value
			for (var n in M_SETTINGS) {
				if ( config[n] !== M_SETTINGS[n].defaultValue ) {
					jQuery.sap.log.info("  " + n + " = " + config[n]);
				}
			}
		},
		
		/**
		 * Returns the version of the framework.
		 * 
		 * Similar to <code>sap.ui.version</code>.
		 * 
		 * @return {jQuery.sap.Version} the version
		 * @public
		 */
		getVersion : function () {
			if(this._version){
				return this._version;
			}
			
			this._version = new jQuery.sap.Version(sap.ui.version);
			return this._version;
		},
		
		/**
		 * Returns the used compatibility version for the given feature.
		 * 
		 * @param {string} sFeature the key of desired feature
		 * @return {jQuery.sap.Version} the used compatibility version
		 * @public
		 */
		getCompatibilityVersion : function (sFeature) {
			if(typeof(sFeature) === "string" && this._compatversion[sFeature]){
				return this._compatversion[sFeature];
			}
			
			return this._compatversion._default;
		},

		/**
		 * Returns the theme name
		 * @return {string} the theme name
		 * @public
		 */
		getTheme : function () {
			return this.theme;
		},

		/**
		 * Allows setting the theme name
		 * @param {string} sTheme the theme name
		 * @return {sap.ui.core.Configuration} <code>this</code> to allow method chaining
		 * @private
		 */
		_setTheme : function (sTheme) {
			this.theme = sTheme;
			return this;
		},

		/**
		 * Normalize the given theme, resolve known aliases
		 * @private
		 */
		_normalizeTheme : function (sTheme, sThemeBaseUrl) {
			if ( sTheme && sThemeBaseUrl == null && sTheme.match(/^sap_corbu$/i) ) 
				return "sap_goldreflection";
			return sTheme;
		},

		/**
		 * Returns the language string with language and country code
		 * @return {string} the language string with language and country code
		 * @public
		 */
		getLanguage : function () {
			return this.language;
		},

		/**
		 * Sets a new language tag to be used from now on for language/region dependent 
		 * functionality (e.g. formatting, data types, translated texts, ...). 
		 * 
		 * When the language has changed, the Core will fire its 
		 * {@link sap.ui.core.Core#event:localizationChanged localizationChanged} event.
		 * 
		 * The framework <strong>does not</strong> guarantee that already created, language 
		 * dependent objects will be updated by this call. It therefore remains best practice 
		 * for applications to switch the language early, e.g. before any language dependent 
		 * objects are created. Applications that need to support more dynamic changes of 
		 * the language should listen to the <code>localizationChanged</code> event and adapt 
		 * all language dependent objects that they use (e.g. by rebuilding their UI).
		 * 
		 * Currently, the framework notifies the following objects about a change of the
		 * localization settings before it fires the <code>localizationChanged</code> event:
		 * 
		 * <ul>
		 * <li>date and number data types that are used in property bindings or composite 
		 *     bindings in existing Elements, Controls, UIAreas or Components</li>
		 * <li>ResourceModels currently assigned to the Core, an UIArea, Component, 
		 *     Element or Control</li>
		 * <li>Elements or Controls that implement the <code>onLocalizationChanged</code> hook. 
		 * </ul>
		 * 
		 * It furthermore derives the RTL mode from the new language, if no explicit RTL
		 * mode has been set. If the RTL mode changes, the following additional actions will be taken:
		 * 
		 * <ul>
		 * <li>the URLs of already loaded library theme files will be changed</li>
		 * <li>the <code>dir</code> attribute of the page will be changed to reflect the new mode.</li> 
		 * <li>all UIAreas will be invalidated (which results in a rendering of the whole UI5 UI)</li> 
		 * </ul>
		 * 
		 * @param {string} sLanguage the new language as a BCP47 compliant language tag; case doesn't matter
		 *   and underscores can be used instead of a dashes to separate components (compatibility with Java Locale Ids)
		 * @return {sap.ui.core.Configuration} <code>this</code> to allow method chaining
		 * 
		 * @experimental Since 1.11.1 - See method documentation for restrictions.
		 * @public
		 */
		setLanguage : function (sLanguage) {
			check(typeof sLanguage === "string" && sLanguage, "sLanguage must be a BCP47 language tag or Java Locale id or null"); // TODO delegate to Locale?
			var bOldRTL = this.getRTL(),
				mChanges;
			
			if ( sLanguage != this.language ) {
				mChanges = this._collect();
				this.language = mChanges.language = sLanguage;
				this.derivedRTL = Locale._impliesRTL(sLanguage);
				if ( bOldRTL != this.getRTL() ) {
					mChanges.rtl = this.getRTL();
				}
				this._endCollect();
			}
			return this;
		},

		/**
		 * Returns the active locale for the current session. 
		 * The locale is derived from the {@link #getLanguage language} property.
		 * @return {sap.ui.core.Locale} the locale
		 * @public
		 */
		getLocale : function () {
			return new Locale(this.language);
		},

		/**
		 * Returns the format locale string with language and region code. Falls back to 
		 * language configuration, in case it has not been explicitly defined.
		 * 
		 * @return {string} the format locale string with language and country code
		 * @public
		 */
		getFormatLocale : function () {
			return this.formatLocale || this.language;
		},

		/**
		 * Sets a new formatLocale to be used from now on for retrieving locale
		 * specific formatters. Modifying this setting does not have an impact on 
		 * the retrieval of translated texts!
		 * 
		 * Can either be set to a concrete value (a BCP-47 or Java locale compliant 
		 * language tag) or to <code>null</code>. When set to <code>null</code> (default 
		 * value) then locale specific formatters are retrieved for the current language.
		 * 
		 * After changing the formatLocale, the framework tries  to update localization 
		 * specific parts of the UI. See the documentation of {@link #setLanguage} for 
		 * details and restrictions.
		 * 
		 * @param {string|null} sFormatLocale the new format locale as a BCP47 compliant language tag; 
		 *   case doesn't matter and underscores can be used instead of a dashes to separate 
		 *   components (compatibility with Java Locale Ids)
		 * @return {sap.ui.core.Configuration} <code>this</code> to allow method chaining
		 * 
		 * @experimental Since 1.11.1 - See documentation of {@link #setLanguage} for restrictions.
		 */
		setFormatLocale : function(sFormatLocale) {
			check(sFormatLocale === null || typeof sFormatLocale === "string" && sFormatLocale, "sFormatLocale must be a BCP47 language tag or Java Locale id or null");
			var mChanges;
			if ( sFormatLocale != this.formatLocale ) {
				mChanges = this._collect();
				this.formatLocale = mChanges.formatLocale = sFormatLocale;
				this._endCollect();
			}
			return this;
		},

		/**
		 * List of languages that the SAPUI5 core deliveres.
		 * 
		 * Might return undefined if the information is not available.
		 *  
		 * @experimental 
		 */
		getLanguagesDeliveredWithCore : function() {
			return this["languagesDeliveredWithCore"];
		},
		
		/**
		 * @experimental 
		 */
		getSupportedLanguages : function() {
			return this["xx-supportedLanguages"];
		},
		
		/**
		 * Returns whether the accessibility mode is used or not
		 * @return {boolean} whether the accessibility mode is used or not
		 * @public
		 */
		getAccessibility : function () {
			return this.accessibility;
		},

		/**
		 * Returns whether the animations are globally used
		 * @return {boolean} whether the animations are globally used
		 * @public
		 */
		getAnimation : function () {
			return this.animation;
		},

		/**
		 * Returns whether the page uses the RTL text direction.
		 * 
		 * If no mode has been explicitly set (neither true nor false),
		 * the mode is derived from the current language setting.
		 * 
		 * @return {boolean} whether the page uses the RTL text direction
		 * @public
		 */
		getRTL : function () {
			// if rtl has not been set (still null), return the rtl mode derived from the language 
			return this.rtl === null ? this.derivedRTL : this.rtl;
		},

		/**
		 * Sets the character orientation mode to be used from now on.
		 * 
		 * Can either be set to a concrete value (true meaning right-to-left,
		 * false meaning left-to-right) or to <code>null</code> which means that 
		 * the character orientation mode should be derived from the current 
		 * language (incl. region) setting.
		 * 
		 * After changing the character orientation mode, the framework tries  
		 * to update localization specific parts of the UI. See the documentation of 
		 * {@link #setLanguage} for details and restrictions.
		 * 
		 * @param {boolean|null} bRTL new character orientation mode or <code>null</code>
		 * @return {sap.ui.core.Configuration} <code>this</code> to allow method chaining
		 * 
		 * @experimental Since 1.11.1 - See documentation of {@link #setLanguage} for restrictions.
		 */
		setRTL : function(bRTL) {
			check(bRTL === null || typeof bRTL === "boolean", "bRTL must be null or a boolean");
			var mChanges;
			if ( bRTL != this.rtl ) {
				mChanges = this._collect();
				this.rtl = mChanges.rtl = this.getRTL();
				this._endCollect();
			}
			return this;
		},

		/**
		 * Returns whether the page runs in debug mode
		 * @return {boolean} whether the page runs in debug mode
		 * @public
		 */
		getDebug : function () {
			return this.debug;
		},

		/**
		 * Returns whether the UI5 control inspector is displayed
		 * Has only an effect when the sap-ui-debug module has been loaded
		 * @return {boolean} whether the UI5 control inspector is displayed
		 * @public
		 */
		getInspect : function () {
			return this.inspect;
		},

		/**
		 * Returns whether the text origin information is collected
		 * @return {boolean} whether the text info is collected
		 * @public
		 */
		getOriginInfo : function () {
			return this.originInfo;
		},

		/**
		 * Returns whether there should be an exception on any duplicate element IDs
		 * @return {boolean} whether there should be an exception on any duplicate element IDs
		 * @public
		 */
		getNoDuplicateIds : function () {
			return this.noDuplicateIds;
		},

		/**
		 * Whether a trace view should be shown or not.
		 * Has only an effect when the sap-ui-debug module has been loaded
		 * either by explicitly loading it or by setting the 'debug' option to true.
		 * @return {boolean} whether a trace view should be shown
		 */
		getTrace : function () {
			return this.trace;
		},

		/**
		 * Prefix to be used for automatically generated control IDs.
		 * Default is a double underscore "__".
		 *
		 * @returns {string} the prefix to be used
		 * @public
		 */
		getUIDPrefix : function() {
			return this.uidPrefix;
		},


		/**
		 * Return whether the design mode is active or not.
		 *
		 * @returns {boolean} whether the design mode is active or not.
		 * @since 1.13.2
		 * @experimental Since 1.13.2 
		 * @public
		 */
		getDesignMode : function() {
			return this["xx-designMode"];
		},

		/**
		 * Return whether the activation of the controller code is suppressed
		 *
		 * @returns {boolean} whether the activation of the controller code is suppressed or not
		 * @since 1.13.2
		 * @experimental Since 1.13.2
		 * @public
		 */
		getSuppressDeactivationOfControllerCode : function() {
			return this["xx-suppressDeactivationOfControllerCode"];
		},

		/**
		 * WEINRE server URL
		 *
		 * @returns {string} the base URL of the WEINRE server
		 * @public
		 */
		getWeinreServer : function() {
			var sWeinreServer = this.weinreServer;
			if (!sWeinreServer) {
				// if not weinre server is configured - we expect that the weinre server
				// is installed on the same machine with port no of the app + 1
				sWeinreServer = window.location.protocol + "//" + window.location.hostname + ":";
				sWeinreServer += (parseInt(window.location.port, 10) || 8080) + 1;
			}
			return sWeinreServer;
		},

		/**
		 * WEINRE session ID
		 *
		 * @returns {string} the ID to use for the WEINRE server
		 * @public
		 */
		getWeinreId : function() {
			return this.weinreId;
		},

		/**
		 * The name of the application to start or empty
		 *
		 * @returns {string} name of the application
		 * @public
		 * @experimental Since 1.13.2
		 * @deprecated Since 1.15.1. Please use the rootComponent configuration option {@link sap.ui.core.Configuration#getRootComponent}.
		 */
		getApplication : function() {
			return this.application;
		},

		/**
		 * The name of the root component to start or empty
		 *
		 * @returns {string} name of the root component
		 * @public
		 * @experimental Since 1.15.1
		 */
		getRootComponent : function() {
			return this.rootComponent;
		},

		/**
		 * Base URLs to AppCacheBuster Etag-Index files
		 *
		 * @returns {string[]} array of base URLs
		 * @public
		 */
		getAppCacheBuster : function() {
			return this.appCacheBuster;
		},

		/**
		 * The loading mode (sync|async|batch) of the AppCacheBuster (sync is default)
		 *
		 * @returns {string} sync | async
		 * @public
		 * @experimental Since 1.12.5
		 */
		getAppCacheBusterMode : function() {
			return this["xx-appCacheBusterMode"];
		},

		/**
		 * Flag, whether the customizing is disabled or not
		 *
		 * @returns {boolean} true if customizing is disabled
		 * @private
		 * @experimental Since 1.15.1
		 */
		getDisableCustomizing : function() {
			return this["xx-disableCustomizing"];
		},

		/**
		 * Currently active preload mode for libraries or falsy value
		 *
		 * @returns {string} preload mode
		 * @private
		 * @since 1.16.3
		 */
		getPreload : function() {
			return this.preload;
		},

		/**
		 * Currently active preload mode for components or falsy value
		 *
		 * @returns {string} component preload mode
		 * @private
		 * @experimental Since 1.16.3, might change completely.
		 */
		getComponentPreload : function() {
			return this['xx-componentPreload'] || this.preload;
		},

		/**
		 * Returns a configuration object that bundles the format settings of UI5.
		 *
		 * @return {sap.ui.core.Configuration.FormatSettings} A FormatSettings object.
		 * @public
		 */
		getFormatSettings : function() {
			return this.oFormatSettings;
		},

		_collect : function() {
			var mChanges = this.mChanges || (this.mChanges = { __count : 0});
			mChanges.__count++;
			return mChanges;
		},

		_endCollect : function() {
			var mChanges = this.mChanges;
			if ( mChanges && (--mChanges.__count) === 0 ) {
				delete mChanges.__count;
				this._oCore && this._oCore.fireLocalizationChanged(mChanges);
				delete this.mChanges;
			}
		},

		/**
		 * Flag if statistics are requested
		 *
		 * Flag set by TechnicalInfo Popup will also be checked
		 * So its active if set by ULP parameter or by TechnicalInfo property
		 *
		 * @returns {boolean} statistics flag
		 * @private
		 * @since 1.20.0
		 */
		getStatistics : function() {
			return this.statistics || window.localStorage.getItem("sap-ui-statistics") == "X";
		},

		/**
		 * Return whether native scrolling should be suppressed on touch devices
		 *
		 * @returns {boolean} whether native scrolling is suppressed on touch devices
		 * @since 1.20.0
		 * @private
		 */
		getNoNativeScroll : function() {
			return this["xx-noNativeScroll"];
		}

	});

	var M_ABAP_LANGUAGE_TO_LOCALE = {
		"ZH" : "zh-Hans",
		"ZF" : "zh-Hant",
		"1Q" : "en-US-x-saptrc",
		"2Q" : "en-US-x-sappsd"
	};

	var M_ABAP_DATE_FORMAT_PATTERN = {
		"" : {pattern: null},
		"1": {pattern: "dd.MM.yyyy"},
		"2": {pattern: "MM/dd/yyyy"},
		"3": {pattern: "MM-dd-yyyy"},
		"4": {pattern: "yyyy.MM.dd"},
		"5": {pattern: "yyyy/MM/dd"},
		"6": {pattern: "yyyy-MM-dd"},
		"7": {pattern: "Gyy.MM.dd", ignore:true},
		"8": {pattern: "Gyy/MM/dd", ignore:true},
		"9": {pattern: "Gyy-MM-dd", ignore:true},
		"A": {pattern: "yyyy/MM/dd", ignore:true},
		"B": {pattern: "yyyy/MM/dd", ignore:true},
		"C": {pattern: "yyyy/MM/dd", ignore:true}
	};

	var M_ABAP_TIME_FORMAT_PATTERN = {
		"" : {"short": null,      medium:  null,        dayPeriods: null},
		"0": {"short": "HH:mm",   medium: "HH:mm:ss",   dayPeriods: null},
		"1": {"short": "hh:mm a", medium: "hh:mm:ss a", dayPeriods: ["AM", "PM"]},
		"2": {"short": "hh:mm a", medium: "hh:mm:ss a", dayPeriods: ["am", "pm"]},
		"3": {"short": "KK:mm a", medium: "KK:mm:ss a", dayPeriods: ["AM", "PM"]},
		"4": {"short": "KK:mm a", medium: "KK:mm:ss a", dayPeriods: ["am", "pm"]}
	};

	var M_ABAP_NUMBER_FORMAT_SYMBOLS = {
		"" : {groupingSeparator: null, decimalSeparator: null},
		" ": {groupingSeparator: ".", decimalSeparator: ","},
		"X": {groupingSeparator: ",", decimalSeparator: "."},
		"Y": {groupingSeparator: " ", decimalSeparator: ","}
	};

	function check(bCondition, sMessage) {
		if ( !bCondition ) {
			throw new Error(sMessage);
		}
	}

	/**
	 * @class Encapsulates configuration settings that are related to data formatting/parsing.
	 * 
	 * <b>Note:</b> When format configuration settings are modified through this class, 
	 * UI5 only ensures that formatter objects created after that point in time will honor
	 * the modifications. To be on the safe side, applications should do any modifications 
	 * early in their lifecycle or recreate any model/UI that is locale dependent. 
	 * 
	 * @name sap.ui.core.Configuration.FormatSettings
	 * @extends sap.ui.base.Object
	 * @public
	 */
	BaseObject.extend("sap.ui.core.Configuration.FormatSettings", /** @lends sap.ui.core.Configuration.FormatSettings.prototype */ {
		constructor : function(oConfiguration) {
			this.oConfiguration = oConfiguration;
			this.mSettings = {};
			this.sLegacyDateFormat = undefined;
			this.sLegacyTimeFormat = undefined;
			this.sLegacyNumberFormatSymbolSet = undefined;
		},

		/**
		 * Returns the locale to be used for formatting. 
		 * 
		 * If no such locale has been defined, this method falls back to the language,
		 * see {@link sap.ui.core.Configuration#getLanguage Configuration.getLanguage()}.
		 * 
		 * If any user preferences for date, time or number formatting have been set,
		 * and if no format locale has been specified, then a special private use subtag
		 * is added to the locale, indicating to the framework that these user preferences 
		 * should be applied. 
		 *  
		 * @return {sap.ui.core.Locale} the format locale 
		 * @public
		 */
		getFormatLocale : function() {
			function fallback(that) {
				var l=that.oConfiguration.language;
				// if any user settings have been defined, add the private use subtag "sapufmt"    
				if ( !jQuery.isEmptyObject(that.mSettings) ) {
					// TODO move to Locale/LocaleData
					if ( l.indexOf("-x-") < 0 ) {
						l = l + "-x-sapufmt";
					} else if ( l.indexOf("-sapufmt") <= l.indexOf("-x-") ) {
						l = l + "-sapufmt";
					}
				}
				return l;
			}
			return new Locale(this.oConfiguration.formatLocale || fallback(this));
		},

		_set : function(sKey, oValue) {
			var oOldValue = this.mSettings[sKey];
			if ( oValue != null ) {
				this.mSettings[sKey] = oValue;
			} else {
				delete this.mSettings[sKey];
			}
			if ( (oOldValue == null != oValue == null) || !jQuery.sap.equal(oOldValue, oValue) ) {
				var mChanges = this.oConfiguration._collect();
				mChanges[sKey] = oValue;
				this.oConfiguration._endCollect();
			}
		},

		/**
		 * Returns the currently set date pattern or undefined if no pattern has been defined. 
		 * @public
		 */
		getDatePattern : function(sStyle) {
			jQuery.sap.assert(sStyle == "short" || sStyle == "medium" || sStyle == "long" || sStyle == "full", "sStyle must be short, medium, long or full");
			return this.mSettings["dateFormat-" + sStyle];
		},

		/**
		 * Defines the preferred format pattern for the given date format style. 
		 * Calling this method with a null or undefined pattern removes a previously set pattern. 
		 * 
		 * If a pattern is defined, it will be preferred over patterns derived from the current locale.
		 * 
		 * See class {@link sap.ui.core.format.DateFormat} for details about the pattern syntax.
		 *  
		 * After changing the date pattern, the framework tries to update localization 
		 * specific parts of the UI. See the documentation of {@link sap.ui.core.Configuration#setLanguage} 
		 * for details and restrictions.
		 * 
		 * @param {string} sStyle must be one of short, medium, long or full.
		 * @param {string} sPattern the format pattern to be used in LDML syntax.
		 * @return {sap.ui.core.Configuration.FormatSettings} Returns <code>this</code> to allow method chaining
		 * @public   
		 */
		setDatePattern : function(sStyle, sPattern) {
			check(sStyle == "short" || sStyle == "medium" || sStyle == "long" || sStyle == "full", "sStyle must be short, medium, long or full");
			this._set("dateFormat-" + sStyle, sPattern);
			return this;
		},

		/**
		 * Returns the currently set time pattern or undefined if no pattern has been defined.
		 * @public
		 */
		getTimePattern : function(sStyle) {
			jQuery.sap.assert(sStyle == "short" || sStyle == "medium" || sStyle == "long" || sStyle == "full", "sStyle must be short, medium, long or full");
			return this.mSettings["timeFormat-" + sStyle];
		},

		/**
		 * Defines the preferred format pattern for the given time format style.
		 * Calling this method with a null or undefined pattern removes a previously set pattern. 
		 *  
		 * If a pattern is defined, it will be preferred over patterns derived from the current locale.
		 * 
		 * See class {@link sap.ui.core.format.DateFormat} for details about the pattern syntax.
		 *  
		 * After changing the time pattern, the framework tries to update localization 
		 * specific parts of the UI. See the documentation of {@link sap.ui.core.Configuration#setLanguage} 
		 * for details and restrictions.
		 * 
		 * @param {string} sStyle must be one of short, medium, long or full.
		 * @param {string} sPattern the format pattern to be used in LDML syntax.
		 * @return {sap.ui.core.Configuration.FormatSettings} Returns <code>this</code> to allow method chaining
		 * @public
		 */
		setTimePattern : function(sStyle, sPattern) {
			check(sStyle == "short" || sStyle == "medium" || sStyle == "long" || sStyle == "full", "sStyle must be short, medium, long or full");
			this._set("timeFormat-" + sStyle, sPattern);
			return this;
		},

		/**
		 * Returns the currently set number symbol of the given type or undefined if no symbol has been defined.
		 * @public
		 */
		getNumberSymbol : function(sType) {
			jQuery.sap.assert(sType == "decimal" || sType == "group" || sType == "plusSign" || sType == "minusSign", "sType must be decimal, group, plusSign or minusSign");
			return this.mSettings["symbols-latn-" + sType];
		},

		/**
		 * Defines the string to be used for the given number symbol.
		 * Calling this method with a null or undefined symbol removes a previously set symbol string.
		 * Note that an empty string is explicitly allowed.  
		 * 
		 * If a symbol is defined, it will be preferred over symbols derived from the current locale.
		 * 
		 * See class {@link sap.ui.core.format.NumberFormat} for details about the symbols.
		 *  
		 * After changing the number symbol, the framework tries to update localization 
		 * specific parts of the UI. See the documentation of {@link sap.ui.core.Configuration#setLanguage} 
		 * for details and restrictions.
		 * 
		 * @param {string} sStyle must be one of decimal, group, plusSign, minusSign.
		 * @param {string} sSymbol will be used to represent the given symbol type
		 * @return {sap.ui.core.Configuration.FormatSettings} Returns <code>this</code> to allow method chaining
		 * @public   
		 */
		setNumberSymbol : function(sType, sSymbol) {
			check(sType == "decimal" || sType == "group" || sType == "plusSign" || sType == "minusSign", "sType must be decimal, group, plusSign or minusSign");
			this._set("symbols-latn-" + sType, sSymbol);
			return this;
		},

		_setDayPeriods : function(sWidth, aTexts) {
			jQuery.sap.assert(sWidth == "narrow" || sWidth == "abbreviated" || sWidth == "wide", "sWidth must be narrow, abbreviated or wide");
			this._set("dayPeriods-format-" + sWidth, aTexts);
			return this;
		},

		/**
		 * Returns the currently set legacy ABAP date format (its id) or undefined if none has been set.
		 *  
		 * @public
		 */
		getLegacyDateFormat : function() {
			return this.sLegacyDateFormat || undefined;
		},

		/**
		 * Allows to specify one of the legacy ABAP date formats. 
		 * 
		 * This method modifies the date patterns for 'short' and 'medium' style with the corresponding ABAP 
		 * format. When called with a null or undefined format id, any previously applied format will be removed.
		 * 
		 * After changing the legacy date format, the framework tries to update localization 
		 * specific parts of the UI. See the documentation of {@link sap.ui.core.Configuration#setLanguage} 
		 * for details and restrictions.
		 * 
		 * Note: those date formats that are not based on the Gregorian calendar (Japanese date formats '7', '8' and '9', 
		 * Islamic date formats 'A' and 'B' and Iranian date format 'C') are not yet supported by UI5. They are accepted 
		 * by this method for convenience (user settings from ABAP system can be used without filtering), but they are 
		 * ignored. Instead, the formats from the current format locale will be used and a warning will be logged.
		 *   
		 * @param {string} sFormatId id of the ABAP data format (one of '1','2','3','4','5','6','7','8','9','A','B','C')
		 * @return {sap.ui.core.Configuration.FormatSettings} Returns <code>this</code> to allow method chaining
		 * @public
		 */
		setLegacyDateFormat : function(sFormatId) {
			sFormatId = sFormatId ? String(sFormatId).toUpperCase() : "";
			check(!sFormatId || M_ABAP_DATE_FORMAT_PATTERN.hasOwnProperty(sFormatId), "sFormatId must be one of ['1','2','3','4','5','6','7','8','9','A','B','C'] or empty");
			if ( M_ABAP_DATE_FORMAT_PATTERN[sFormatId].ignore ) {
				jQuery.sap.log.warning("The ABAP date format '" + sFormatId + "' (" + M_ABAP_DATE_FORMAT_PATTERN[sFormatId].pattern + ") is not supported yet. Falling back to locale specific date formats.");
				sFormatId = "";
			} 
			var mChanges = this.oConfiguration._collect();
			this.sLegacyDateFormat = mChanges.legacyDateFormat = sFormatId;
			this.setDatePattern("short", M_ABAP_DATE_FORMAT_PATTERN[sFormatId].pattern);
			this.setDatePattern("medium", M_ABAP_DATE_FORMAT_PATTERN[sFormatId].pattern);
			this.oConfiguration._endCollect();
			return this;
		},

		/**
		 * Returns the currently set legacy ABAP time format (its id) or undefined if none has been set.
		 *  
		 * @public
		 */
		getLegacyTimeFormat : function() {
			return this.sLegacyTimeFormat || undefined;
		},

		/**
		 * Allows to specify one of the legacy ABAP time formats.
		 * 
		 * This method sets the time patterns for 'short' and 'medium' style to the corresponding ABAP 
		 * formats and sets the day period texts to "AM"/"PM" or "am"/"pm" respectively. When called 
		 * with a null or undefined format id, any previously applied format will be removed.
		 * 
		 * After changing the legacy time format, the framework tries to update localization 
		 * specific parts of the UI. See the documentation of {@link sap.ui.core.Configuration#setLanguage} 
		 * for details and restrictions.
		 * 
		 * @param {string} sFormatId id of the ABAP time format (one of '0','1','2','3','4')
		 * @return {sap.ui.core.Configuration.FormatSettings} Returns <code>this</code> to allow method chaining
		 * @public
		 */
		setLegacyTimeFormat : function(sFormatId) {
			check(!sFormatId || M_ABAP_TIME_FORMAT_PATTERN.hasOwnProperty(sFormatId), "sFormatId must be one of ['0','1','2','3','4'] or empty");
			var mChanges = this.oConfiguration._collect();
			this.sLegacyTimeFormat = mChanges.legacyTimeFormat = sFormatId = sFormatId || "";
			this.setTimePattern("short", M_ABAP_TIME_FORMAT_PATTERN[sFormatId]["short"]);
			this.setTimePattern("medium", M_ABAP_TIME_FORMAT_PATTERN[sFormatId]["medium"]);
			this._setDayPeriods("abbreviated", M_ABAP_TIME_FORMAT_PATTERN[sFormatId].dayPeriods);
			this.oConfiguration._endCollect();
			return this;
		},

		/**
		 * Returns the currently set legacy ABAP number format (its id) or undefined if none has been set.
		 *  
		 * @public
		 */
		getLegacyNumberFormat : function() {
			return this.sLegacyNumberFormat || undefined;
		},

		/**
		 * Allows to specify one of the legacy ABAP number format.
		 * 
		 * This method will modify the 'group' and 'decimal' symbols. When called with a null 
		 * or undefined format id, any previously applied format will be removed.
		 * 
		 * After changing the legacy number format, the framework tries to update localization 
		 * specific parts of the UI. See the documentation of {@link sap.ui.core.Configuration#setLanguage} 
		 * for details and restrictions.
		 * 
		 * @param {string} sFormatId id of the ABAP number format set (one of ' ','X','Y')
		 * @return {sap.ui.core.Configuration.FormatSettings} Returns <code>this</code> to allow method chaining
		 * @public
		 */
		setLegacyNumberFormat : function(sFormatId) {
			sFormatId = sFormatId ? sFormatId.toUpperCase() : "";
			check(!sFormatId || M_ABAP_NUMBER_FORMAT_SYMBOLS.hasOwnProperty(sFormatId), "sFormatId must be one of [' ','X','Y'] or empty");
			var mChanges = this.oConfiguration._collect();
			this.sLegacyNumberFormat = mChanges.legacyNumberFormat = sFormatId;
			this.setNumberSymbol("group", M_ABAP_NUMBER_FORMAT_SYMBOLS[sFormatId].groupingSeparator);
			this.setNumberSymbol("decimal", M_ABAP_NUMBER_FORMAT_SYMBOLS[sFormatId].decimalSeparator);
			this.oConfiguration._endCollect();
		},

		/*
		 * Returns a live object with the current settings
		 * TODO this method is part of the facade to be accessible from LocaleData, but it shouldn't be
		 * @private
		 */
		getCustomLocaleData : function() {
			return this.mSettings;
		}
	});

	return Configuration;

}, /* bExport= */ true);

}; // end of sap/ui/core/Configuration.js
if ( !jQuery.sap.isDeclared('sap.ui.core.Control') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides base class sap.ui.core.Control for all controls
jQuery.sap.declare('sap.ui.core.Control'); // unresolved dependency added by SAPUI5 CreateModule Ant-Task
if ( !jQuery.sap.isDeclared('sap.ui.core.CustomStyleClassSupport') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides helper sap.ui.core.CustomStyleClassSupport
jQuery.sap.declare('sap.ui.core.CustomStyleClassSupport'); // unresolved dependency added by SAPUI5 CreateModule Ant-Task
if ( !jQuery.sap.isDeclared('sap.ui.core.Element') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides the base class for all controls and UI elements.
jQuery.sap.declare('sap.ui.core.Element'); // unresolved dependency added by SAPUI5 CreateModule Ant-Task
if ( !jQuery.sap.isDeclared('sap.ui.core.ElementMetadata') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.core.ElementMetadata
jQuery.sap.declare('sap.ui.core.ElementMetadata'); // unresolved dependency added by SAPUI5 CreateModule Ant-Task
sap.ui.define("sap/ui/core/ElementMetadata",['jquery.sap.global', 'sap/ui/base/ManagedObjectMetadata'],
	function(jQuery, ManagedObjectMetadata) {
	"use strict";


	/**
	 * Creates a new metadata object for a UIElement subclass.
	 *
	 * @param {string} sClassName fully qualified name of the class that is described by this metadata object
	 * @param {object} oStaticInfo static info to construct the metadata from
	 *
	 * @class
	 * @author SAP
	 * @version 1.20.6
	 * @since 0.8.6
	 * @name sap.ui.core.ElementMetadata
	 */
	var ElementMetadata = function(sClassName, oClassInfo) {
	
		// call super constructor
		ManagedObjectMetadata.apply(this, arguments);
	};
	
	//chain the prototypes
	ElementMetadata.prototype = jQuery.sap.newObject(ManagedObjectMetadata.prototype);
	
	/**
	 * Calculates a new id based on a prefix.
	 *
	 * @return {string} A (hopefully unique) control id
	 * @public
	 * @function
	 * @name sap.ui.core.ElementMetadata.uid
	 */
	ElementMetadata.uid = ManagedObjectMetadata.uid;
	
	/**
	 * By default, the element name is equal to the class name
	 * @return {string} the qualified name of the UIElement class
	 * @public
	 * @name sap.ui.core.ElementMetadata#getElementName
	 * @function
	 */
	ElementMetadata.prototype.getElementName = function() {
		return this._sClassName;
	};
	
	/**
	 * Determines the class name of the renderer for the described control class.
	 * @name sap.ui.core.ElementMetadata#getRendererName
	 * @function
	 */
	ElementMetadata.prototype.getRendererName = function() {
		return this._sRendererName;
	};
	
	/**
	 * Retrieves the renderer for the described control class
	 * @name sap.ui.core.ElementMetadata#getRenderer
	 * @function
	 */
	ElementMetadata.prototype.getRenderer = function() {
	
		// determine name via function for those legacy controls that override getRendererName()
		var sRendererName = this.getRendererName();
	
		if ( !sRendererName ) {
			return;
		}
	
		// check if renderer class exists already
		var fnRendererClass = jQuery.sap.getObject(sRendererName);
		if(fnRendererClass) {
			return fnRendererClass;
		}
	
		// if not, try to load a module with the same name
		jQuery.sap.require(sRendererName);
		return jQuery.sap.getObject(sRendererName);
	};
	
	ElementMetadata.prototype.applySettings = function(oClassInfo) {
	
		var oStaticInfo = oClassInfo.metadata;
	
		this._sVisibility = oStaticInfo["visibility"] || "public";
	
		// remove renderer stuff before calling super.
		var vRenderer = oClassInfo.hasOwnProperty("renderer") ? (oClassInfo.renderer || "") : undefined;
		delete oClassInfo.renderer;
	
		ManagedObjectMetadata.prototype.applySettings.call(this, oClassInfo);
	
		this._sRendererName = this.getName() + "Renderer";
	
		if ( typeof vRenderer !== "undefined" ) {
	
			if ( typeof vRenderer === "string" ) {
				this._sRendererName = vRenderer || undefined;
				return;
			}
			if ( typeof vRenderer === "function" ) {
				vRenderer = { render : vRenderer };
			}
	
			var oParent = this.getParent();
			var oBaseRenderer;
			if ( oParent && oParent instanceof ElementMetadata ) {
				oBaseRenderer = oParent.getRenderer();
			}
			if ( !oBaseRenderer ) {
				jQuery.sap.require("sap.ui.core.Renderer");
				oBaseRenderer = sap.ui.core.Renderer;
			}
			var oRenderer = jQuery.sap.newObject(oBaseRenderer);
			jQuery.extend(oRenderer, vRenderer);
			jQuery.sap.setObject(this.getRendererName(), oRenderer);
		}
	};
	
	ElementMetadata.prototype.afterApplySettings = function() {
		ManagedObjectMetadata.prototype.afterApplySettings.apply(this, arguments);
		this.register && this.register(this);
	};
	
	ElementMetadata.prototype.isHidden = function() {
		return this._sVisibility === "hidden";
	};
	

	return ElementMetadata;

}, /* bExport= */ true);

}; // end of sap/ui/core/ElementMetadata.js
sap.ui.define("sap/ui/core/Element",['jquery.sap.global', 'sap/ui/base/ManagedObject', './Core', './ElementMetadata', 'sap/ui/model/SimpleType', 'jquery.sap.strings'],
	function(jQuery, ManagedObject, Core, ElementMetadata, SimpleType/* , jQuerySap */) {
	"use strict";


	
	/**
	 * Constructs and initializes an UI Element with the given <code>sId</code> and settings.
	 *
	 * If the optional <code>mSettings</code> are given, they must be a JSON-like object (object literal)
	 * that defines values for properties, aggregations, associations or events keyed by their name.
	 *
	 * <b>Valid Names:</b>
	 *
	 * The property (key) names supported in the object literal are exactly the (case sensitive)
	 * names documented in the JSDoc for the properties, aggregations, associations and events
	 * of the control and its base classes. Note that for  0..n aggregations and associations this
	 * usually is the plural name, whereas it is the singular name in case of 0..1 relations.
	 *
	 * If a key name is ambiguous for a specific control class (e.g. a property has the same
	 * name as an event), then this method prefers property, aggregation, association and
	 * event in that order. To resolve such ambiguities, the keys can be prefixed with
	 * <code>aggregation:</code>, <code>association:</code> or <code>event:</code>.
	 * In that case the keys must be quoted due to the ':'.
	 *
	 * Each subclass should document the set of supported names in its constructor documentation.
	 *
	 * <b>Valid Values:</b>
	 *
	 * <ul>
	 * <li>for normal properties, the value has to be of the correct simple type (no type conversion occurs)
	 * <li>for 0..1 aggregations, the value has to be an instance of the aggregated control or element type
	 * <li>for 0..n aggregations, the value has to be an array of instances of the aggregated type
	 * <li>for 0..1 associations, an instance of the associated type or an id (string) is accepted
	 * <li>0..n associations are not supported yet
	 * <li>for events either a function (event handler) is accepted or an array of length 2
	 *     where the first element is a function and the 2nd element is an object to invoke the method on.
	 * </ul>
	 *
	 * Special aggregation "dependents" is connected to the lifecycle management and databinding,
	 * but not rendered automatically and can be used for popups or other dependent controls. This allows
	 * definition of popup controls in declarative views and enables propagation of model and context
	 * information to them.
	 *
	 * @param {string} [sId] id for the new control; generated automatically if no non-empty id is given
	 *      Note: this can be omitted, no matter whether <code>mSettings</code> will be given or not!
	 * @param {object} [mSettings] optional map/JSON-object with initial property values, aggregated objects etc. for the new element
	 *
	 * @class Base Class for Elements.
	 * @extends sap.ui.base.ManagedObject
	 * @author SAP
	 * @version 1.20.6
	 * @public
	 * @name sap.ui.core.Element
	 */
	var Element = ManagedObject.extend("sap.ui.core.Element", {
	
		metadata : {
			stereotype : "element",
		  "abstract" : true,
		  publicMethods : [ "getId", "getMetadata", "getTooltip_AsString", "getTooltip_Text", "getModel", "setModel", "hasModel", "bindElement", "unbindElement", "getElementBinding", "prop", "getLayoutData", "setLayoutData" ],
		  library : "sap.ui.core",
		  properties : {
			// TODO can't yet declare id as a property: would show up in ControlTree and applySettings would allow to modify id
			// id : {name : "id", type : "string", group : "Identification", defaultValue : '', readOnly : true}
		  },
		  aggregations : {
			tooltip : {name : "tooltip", type : "sap.ui.core.TooltipBase", altTypes : ["string"], multiple : false},
			customData : {name : "customData", type : "sap.ui.core.CustomData", multiple : true, singularName : "customData"},
			layoutData : {name : "layoutData", type : "sap.ui.core.LayoutData", multiple : false, singularName : "layoutData"},
			dependents : {name : "dependents", type : "sap.ui.core.Control", multiple : true}
		  },
		  associations : {},
		  events : {}
		},
	
		constructor : function(sId, mSettings) {
			ManagedObject.apply(this, arguments);
		},
	
		renderer : null // Element has no renderer
	
	}, /* Metadata constructor */ ElementMetadata);
	
	/**
	 * Creates a new subclass of class sap.ui.core.Element with name <code>sClassName</code>
	 * and enriches it with the information contained in <code>oClassInfo</code>.
	 *
	 * <code>oClassInfo</code> might contain the following:
	 * <ul>
	 * <li><code>metadata:</code> an (optional) object literal containing meta information about the class.
	 * The information in the object literal will be wrapped by an instance of ElementMetadata
	 * and might contain the following information:
	 * <ul>
	 * <li>all values accepted for metadata as documented for the {@link sap.ui.base.Object.extend Object.extend} method</li>
	 * <li>library: {string} (optional) name of the library that contains the element/control
	 * <li>properties: a map of property info objects, mapped by the property name
	 *     Each info object should be a simple object literal and may contain the following information
	 *     <ul>
	 *     <li>type {string} optional type of the property, defaults to type "string"
	 *     <li>[defaultValue] {any} default value of the property. When omitted, defaults to the default value for the type
	 *     <li>group {string} optional semantic group of the property. Defaults to "Misc"
	 *     </ul>
	 *     If the property info object is not an object literal, it is assumed to be a string and
	 *     interpreted as the type of the property. All other informations use their default values.
	 * <li>aggregations: a map of aggregation info objects, mapped by the aggregation name
	 *     By convention, the name should be a singular name for aggregations of cardinality 0..1 and
	 *     should be a plural name for aggregations of cardinality 0..n.
	 *
	 *     The info object should contain the following information
	 *     <ul>
	 *     <li>type {string} (optional) type of the aggregated controls/elements, defaults to sap.ui.core.Control
	 *     <li>altTypes {string[]} (optional) alternative primitive types that the aggregation can have (like string etc.). Defaults to no alternative types.
	 *     <li>multiple {boolean} (optional) information about the cardinality, defaults to true (multiple aggregation)
	 *     <li>singularName {string} (optional) singular name for 0..n aggregations. If not specified, a singular name is guessed from the plural name.
	 *     </ul>
	 *     If the aggregation info object is not an object literal, it is assumed to be a string and
	 *     interpreted as the type of the aggregation. All other informations use their default values.
	 * <li>associations: a map of association info objects, mapped by the association name
	 *     By convention, the name should be a singular name for aggregations of cardinality 0..1 and
	 *     should be a plural name for aggregations of cardinality 0..n.
	 *
	 *     The info object should contain the following information
	 *     <ul>
	 *     <li>type {string} type of the associated controls/elements, defaults to sap.ui.core.Control
	 *     <li>multiple {boolean} (optional) information about the cardinality, defaults to false (single aggregation)
	 *     <li>singularName {string} (optional) singular name for 0..n aggregations. If not specified, a singular name is guessed from the plural name.
	 *     </ul>
	 *     If the association info object is not an object literal, it is assumed to be a string and
	 *     interpreted as the type of the aggregation. All other informations then use their default values.
	 * <li>events: a map of event info objects, mapped by the event name
	 *     The info object can contain the following information
	 *     <ul>
	 *     <li><code>allowPreventDefault:</code> {boolean} whether the control allows to prevent its default behavior for this event (defaults to false) </li>
	 *     </ul>
	 * </ul>
	 * For all properties, aggregations, associations and events, the usual access methods are created and added to the public facade.
	 * They don't need to be listed in the publicMethods array.
	 * </li>
	 *
	 * <li><code>constructor:</code> a function that serves as a constructor function for the new element class.
	 * If no constructor function is given, the framework creates a default implementation that delegates all
	 * its arguments to the constructor function of the base class.
	 * <b>Note:</b> most of the time, subclasses of Element don't need to specify their own constructor function.
	 * They should use the symmetric {@link #init} and {@link #exit} hooks instead.
	 * </li>
	 *
	 * <li><code>renderer:</code> definition of a renderer. This can be any of the following
	 * <ul>
	 * <li>the class name of a renderer class (a string)</li>
	 * <li>a render function with signature <code>function(oRenderManager, oControl)</code> that implements the rendering for the new class</li>
	 * <li>an object literal that contains functions/properties that should be mixed into a new render class which is
	 * created as a subclass of the renderer of the current class.</li>
	 * </ul>
	 * <b>Note:</b> usually only controls have a renderer. But to keep the control creation APIs simple and to honor future
	 * extensions of the current policy, the definition of a renderer is supported for direct subclasses of Element as well.
	 * </li>
	 *
	 * <li><i>any-other-name:</i> any other property in the <code>oClassInfo</code> is copied into the prototype
	 * object of the newly created class. Callers can thereby add methods or properties to all instances of the
	 * class. But be aware that the given values are shared between all instances of the class. Usually, it doesn't
	 * make sense to use primitive values here other than to declare public constants.
	 *
	 * All methods added this way and whose name is not 'init' nor 'exit' nor does it start with an underscore ('_')
	 * nor with the prefix 'on' are assumed to be public methods and are automatically added to the list of public facade methods.
	 * </ul>
	 *
	 * The prototype object of the newly created class uses the same prototype as instances of the base class
	 * (prototype chaining).
	 *
	 * A metadata object is always created, even if there is no <code>metadata</code> entry in the <code>oClassInfo</code>
	 * object. A getter for the metadata is always attached to the prototype and to the class (constructor function)
	 * itself.
	 *
	 * Last but not least, with the third argument <code>FNMetaImpl</code> the constructor of a metadata class
	 * can be specified. Instances of that class will be used to represent metadata for the newly created class
	 * and for any subclass created from it. Typically, only frameworks will use this parameter to enrich the
	 * metadata for a new class hierarchy they introduce (as done by  {@link sap.ui.core.Element Element}).
	 *
	 * @param {string} sClassName name of the class to be created
	 * @param {object} [oClassInfo] structured object with informations about the class
	 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
	 * @return {function} the created class / constructor function
	 * @public
	 * @static
	 * @name sap.ui.core.Element.extend
	 * @function
	 * @since 1.3.1
	 */
	
	/**
	 * Creates metadata for an UI Element by extending the Object Metadata.
	 *
	 * In addition to the entries defined by {@link sap.ui.base.Object.defineClass}, the following
	 * entries can be specified in the static info object:
	 *
	 * <ul>
	 * <li>library: {string} name of the library that contains the element/control
	 * <li>properties: a map of property info objects, mapped by the property name
	 *     Info object should contain the following information
	 *     <ul>
	 *     <li>name {string} name of the property (redundant to map key)
	 *     <li>type {string} type of the property
	 *     <li>[defaultValue] {any} default value of the property. Can be omitted
	 *     </ul>
	 * <li>aggregations: a map of aggregation info objects, mapped by the aggregation name
	 *     Info object should contain the following information
	 *     <ul>
	 *     <li>name {string} name of the aggregation, singular for 0..1, plural for 0..n
	 *     <li>type {string} type of the aggregated controls/elements
	 *     <li>multiple {boolean}
	 *     <li>singularName {string} singular name for 0..n aggregations
	 *     </ul>
	 * <li>associations: a map of association info objects, mapped by the association name
	 *     Info object should contain the following information
	 *     <ul>
	 *     <li>name {string} name of the association, singular for 0..1, plural for 0..n
	 *     <li>type {string} type of the associated controls/elements
	 *     <li>multiple {boolean}
	 *     <li>singularName {string} singular name for 0..n associations
	 *     </ul>
	 * <li>events: map from event names to event names
	 * </ul>
	 *
	 * @see sap.ui.core.Object.defineClass
	 *
	 * @param {string} sClassName name of the class to build the metadata for
	 * @param {object} oStaticInfo static information used to build the metadata
	 * @param {function} [fnMetaImpl] constructor to be used for the metadata
	 * @return {object} the created metadata
	 * @static
	 * @public
	 * @deprecated Since 1.3.1. Use the static <code>extend</code> method of the desired base class (e.g. {@link sap.ui.core.Element.extend})
	 * @name sap.ui.core.Element.defineClass
	 * @function
	 */
	Element.defineClass = function(sClassName, oStaticInfo, fnMetaImpl) {
		// create and attach metadata but with an Element specific implementation
		return sap.ui.base.Object.defineClass(sClassName, oStaticInfo, fnMetaImpl || ElementMetadata);
	};
	
	/**
	 * @see sap.ui.base.Object#getInterface
	 * @public
	 * @name sap.ui.core.Element#getInterface
	 * @function
	 */
	Element.prototype.getInterface = function() {
		return this;
	};
	
	/**
	 * Handles the given browser event.
	 * @private
	 * @name sap.ui.core.Element#_handleEvent
	 * @function
	 */
	Element.prototype._handleEvent = function (oEvent) {
		var sHandlerName = "on" + oEvent.type;
		this._callEventHandles(this.aBeforeDelegates, sHandlerName, oEvent, true);
		this._callEventHandles([this], sHandlerName, oEvent);
		this._callEventHandles(this.aDelegates, sHandlerName, oEvent, true);
	};
	
	/**
	 * Calls event handler of the given event handles with the given browser event.
	 * @private
	 * @name sap.ui.core.Element#_callEventHandles
	 * @function
	 */
	Element.prototype._callEventHandles = function (aHandles, sHandlerName, oEvent, bDelegateHolder) {
		if (aHandles.length > 0) {
			for (var i = 0; i < aHandles.length; i++) {
				if (oEvent.isImmediateHandlerPropagationStopped()) {
					break;
				}
				var oHandle = bDelegateHolder ? aHandles[i].oDelegate : aHandles[i];
				var oThis = (bDelegateHolder && aHandles[i].vThis) ? aHandles[i].vThis : oHandle;
				if (oThis === true) { // special case, means the control should be the context
					oThis = this;
				}
				if (oHandle[sHandlerName]) {
					oHandle[sHandlerName].call(oThis, oEvent);
				}
			}
		}
	};
	
	
	// Element is granted "friend" access by Core for (de-)registration
	/**
	 * Registers this instance of sap.ui.core.Element with the Core.
	 *
	 * The implementation of this method is provided with "friend" access by Core.
	 * @see sap.ui.core.Core.constructor
	 *
	 * @function
	 * @name sap.ui.core.Element.prototype.register
	 * @private
	 */
	//sap.ui.core.Element.prototype.register = function() {...}
	
	/**
	 * Deregisters this instance of sap.ui.core.Element from the Core.
	 *
	 * The implementation of this method is provided with "friend" access by Core.
	 * @see sap.ui.core.Core.constructor
	 *
	 * @function
	 * @name sap.ui.core.Element.prototype.deregister
	 * @private
	 */
	//sap.ui.core.Element.prototype.deregister = function() {...}
	
	/**
	 * Initializes the element instance after creation.
	 *
	 * Applications must not call this hook method directly, it is called by the framework
	 * while the constructor of an element is executed.
	 *
	 * Subclasses of Element should override this hook to implement any necessary initialization.
	 *
	 * @function
	 * @name sap.ui.core.Element.prototype.init
	 * @protected
	 */
	//sap.ui.core.Element.prototype.init = function() {};
	
	/**
	 * Cleans up the element instance before destruction.
	 *
	 * Applications must not call this hook method directly, it is called by the framework
	 * when the element is {@link #destroy destroyed}.
	 *
	 * Subclasses of Element should override this hook to implement any necessary cleanup.
	 *
	 * @function
	 * @name sap.ui.core.Element.prototype.exit
	 * @protected
	 */
	//sap.ui.core.Element.prototype.exit = function() {};
	
	/**
	 * Creates a new Element from the given data.
	 *
	 * If vData is an Element already, that element is returned.
	 * If vData is an object (literal), then a new element is created with vData as settings.
	 * The type of the element is either determined by a "Type" entry in the vData or
	 * by a type information in the oKeyInfo object
	 * @param {sap.ui.core.Element|object} vData the data to create the element from
	 * @param {object} [oKeyInfo] an entity information (e.g. aggregation info)
	 * @param {string} [oKeyInfo.type] type info for the entity
	 * @public
	 * @static
	 * @name sap.ui.core.Element.create
	 * @function
	 */
	Element.create = function(vData, oKeyInfo) {
		if ( !vData || vData instanceof Element || typeof vData !== "object" || vData instanceof String) {
			return vData;
		}
	
		function getClass(vType) {
			if ( typeof vType === "function" ) {
				return vType;
			} 
			if (typeof vType === "string" ) {
				return jQuery.sap.getObject(vType);
			}
		}
	
		var fnClass = getClass(vData.Type) || getClass(oKeyInfo && oKeyInfo.type);
		if ( typeof fnClass === "function" ) {
			return new fnClass(vData);
		}
	
		// we don't know how to create the Element from vData, so fail
		// extension points could be integrated here
		var message = "Don't know how to create an Element from " + vData + " (" + (typeof vData) + ")";
		jQuery.sap.log.fatal(message);
		throw new Error(message);
	};
	
	
	/**
	 * Returns a simple string representation of this element.
	 *
	 * Mainly useful for tracing purposes.
	 * @public
	 * @return {string} a string descripition of this element
	 * @name sap.ui.core.Element#toString
	 * @function
	 */
	Element.prototype.toString = function() {
		if ( this.getMetadata ) {
			return "Element " + this.getMetadata().getName() + "#" + this.sId;
		}
		else {
			return "Element {unknown class}#" + this.sId;
		}
	};
	
	
	/**
	 * Returns the best suitable DOM Element that represents this UI5 Element.
	 * By default the DOM Element with the same ID as this Element is returned.
	 * Subclasses should override this method if the lookup via id is not sufficient.
	 *
	 * Note that such a DOM Element does not necessarily exist in all cases.
	 * Some elements or controls might not have a DOM representation at all (e.g.
	 * a naive FlowLayout) while others might not have one due to their current
	 * state (e.g. an initial, not yet rendered control).
	 *
	 * If an ID suffix is given, the ID of this Element is concatenated with the suffix 
	 * (separated by a single dash) and the DOM node with that compound ID will be returned.
	 * This matches the UI5 naming convention for named inner DOM nodes of a control. 
	 * 
	 * @param {string} [sSuffix] ID suffix to get the DOMRef for
	 * @return {Element} The Element's DOM Element sub DOM Element or null
	 * @protected
	 * @name sap.ui.core.Element#getDomRef
	 * @function
	 */
	Element.prototype.getDomRef = function(sSuffix) {
		return jQuery.sap.domById(sSuffix ? this.getId() + "-" + sSuffix : this.getId());
	};
	
	/**
	 * Returns the best suitable DOM node that represents this Element wrapped as jQuery object.
	 * I.e. the element returned by {@link sap.ui.core.Element#getDomRef} is wrapped and returned.
	 *
	 * If an ID suffix is given, the ID of this Element is concatenated with the suffix 
	 * (separated by a single dash) and the DOM node with that compound ID will be wrapped by jQuery.
	 * This matches the UI5 naming convention for named inner DOM nodes of a control. 
	 * 
	 * @param {string} [sSuffix] ID suffix to get a jQuery object for
	 * @return {jQuery} The jQuery wrapped element's DOM reference
	 * @protected
	 * @name sap.ui.core.Element#$
	 * @function
	 */
	
	Element.prototype.$ = function(sSuffix) {
		return jQuery(this.getDomRef(sSuffix));
	};
	
	/**
	 * Checks whether this element has an active parent.
	 *
	 * @type boolean
	 * @return true if this element has an active parent
	 * @private
	 * @name sap.ui.core.Element#isActive
	 * @function
	 */
	Element.prototype.isActive = function() {
		return this.oParent && this.oParent.isActive();
	};
	
	/**
	 * This function either calls set[sPropertyName] or get[sPropertyName] with the specified property name
	 * depending if an <code>oValue</code> is provided or not.
	 *
	 * @param {string}  sPropertyName name of the property to set
	 * @param {any}     [oValue] value to set the property to
	 * @return {any|sap.ui.core.Element} Returns <code>this</code> to allow method chaining in case of setter and the property value in case of getter
	 * @public
	 * @name sap.ui.core.Element#prop
	 * @function
	 */
	Element.prototype.prop = function(sPropertyName, oValue) {
	
		var oPropertyInfo = this.getMetadata().getJSONKeys()[sPropertyName];
		if (oPropertyInfo) {
			if (arguments.length == 1) {
				// getter
				return this[oPropertyInfo._sGetter]();
			} else {
				// setter
				this[oPropertyInfo._sMutator](oValue);
				return this;
			}
		}
	};
	
	
	/**
	 * Getter for aggregation <code>customData</code>.<br/>
	 *
	 * @return {sap.ui.core.CustomData[]}
	 * @function
	 * @name sap.ui.core.Element.prototype.getCustomData
	 * @public
	 */
	
	/**
	 * Inserts a CustomData element into the aggregation named <code>customData</code>.
	 *
	 * @param {sap.ui.core.CustomData}
	 *          oCustomData the customData to insert; if empty, nothing is inserted
	 * @param {int}
	 *             iIndex the <code>0</code>-based index the customData should be inserted at; for
	 *             a negative value of <code>iIndex</code>, the customData is inserted at position 0; for a value
	 *             greater than the current size of the aggregation, the customData is inserted at
	 *             the last position
	 * @return {sap.ui.core.Element} <code>this</code> to allow method chaining
	 * @function
	 * @name sap.ui.core.Element.prototype.insertCustomData
	 * @public
	 */
	
	/**
	 * Adds some customData element <code>oCustomData</code>
	 * to the aggregation named <code>customData</code>.
	 *
	 * @param {sap.ui.core.CustomData}
	 *            oCustomData the customData to add; if empty, nothing is inserted
	 * @return {sap.ui.core.Element} <code>this</code> to allow method chaining
	 * @function
	 * @name sap.ui.core.Element.prototype.addCustomData
	 * @public
	 */
	
	/**
	 * Removes a CustomData element from the aggregation named <code>customData</code>.
	 *
	 * @param {int | string | sap.ui.core.CustomData} vCustomData the customData to remove or its index or id
	 * @return {sap.ui.core.CustomData} the removed customData element or null
	 * @function
	 * @name sap.ui.core.Element.prototype.removeCustomData
	 * @public
	 */
	
	/**
	 * Removes all the data elements in the aggregation named <code>customData</code>.<br/>
	 *
	 * @return {sap.ui.core.CustomData[]} an array of the removed data elements (might be empty)
	 * @function
	 * @name sap.ui.core.Element.prototype.removeAllCustomData
	 * @public
	 */
	
	/**
	 * Checks for the provided <code>sap.ui.core.CustomData</code> in the aggregation named <code>customData</code>
	 * and returns its index if found or -1 otherwise.
	 *
	 * @param {sap.ui.core.CustomData}
	 *            oCustomData the customData whose index is looked for.
	 * @return {int} the index of the provided customData element in the aggregation if found, or -1 otherwise
	 * @function
	 * @name sap.ui.core.Element.prototype.indexOfCustomData
	 * @public
	 */
	
	/**
	 * Destroys all the customData elements in the aggregation
	 * named <code>customData</code>.
	 * @return {sap.ui.core.Element} <code>this</code> to allow method chaining
	 * @function
	 * @name sap.ui.core.Element.prototype.destroyCustomData
	 * @public
	 */
	
	/**
	 * Getter for aggregation <code>dependents</code>.<br/>
	 *
	 * @return {sap.ui.core.Control[]}
	 * @function
	 * @name sap.ui.core.Element.prototype.getDependents
	 * @since 1.19
	 * @public
	 */
	
	/**
	 * Inserts a control into the aggregation named <code>dependents</code>.
	 *
	 * @param {sap.ui.core.Control}
	 *          oControl the control to insert; if empty, nothing is inserted
	 * @param {int}
	 *             iIndex the <code>0</code>-based index the control should be inserted at; for
	 *             a negative value of <code>iIndex</code>, the control is inserted at position 0; for a value
	 *             greater than the current size of the aggregation, the control is inserted at
	 *             the last position
	 * @return {sap.ui.core.Element} <code>this</code> to allow method chaining
	 * @function
	 * @name sap.ui.core.Element.prototype.insertDependent
	 * @since 1.19
	 * @public
	 */
	Element.prototype.insertDependent = function(oControl, iIndex) {
		return this.insertAggregation("dependents", oControl, iIndex, true);
	};
	
	/**
	 * Adds some control <code>oControl</code>
	 * to the aggregation named <code>dependents</code>.
	 *
	 * @param {sap.ui.core.Control}
	 *            oControl the control to add; if empty, nothing is inserted
	 * @return {sap.ui.core.Element} <code>this</code> to allow method chaining
	 * @function
	 * @name sap.ui.core.Element.prototype.addDependent
	 * @since 1.19
	 * @public
	 */
	Element.prototype.addDependent = function(oControl) {
		return this.addAggregation("dependents", oControl, true);
	};
	
	/**
	 * Removes a control from the aggregation named <code>dependents</code>.
	 *
	 * @param {int | string | sap.ui.core.Control} vControl the control to remove or its index or id
	 * @return {sap.ui.core.Control} the removed control or null
	 * @function
	 * @name sap.ui.core.Element.prototype.removeDependent
	 * @since 1.19
	 * @public
	 */
	Element.prototype.removeDependent = function(vControl) {
		return this.removeAggregation("dependents", vControl, true);
	};
	
	/**
	 * Removes all the controls in the aggregation named <code>dependents</code>.<br/>
	 *
	 * @return {sap.ui.core.Control[]} an array of the removed controls (might be empty)
	 * @function
	 * @name sap.ui.core.Element.prototype.removeAllDependents
	 * @since 1.19
	 * @public
	 */
	Element.prototype.removeAllDependents = function() {
		return this.removeAllAggregation("dependents", true);
	};
	
	/**
	 * Checks for the provided <code>sap.ui.core.Control</code> in the aggregation named <code>dependents</code>
	 * and returns its index if found or -1 otherwise.
	 *
	 * @param {sap.ui.core.Control}
	 *            oControl the control whose index is looked for.
	 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
	 * @function
	 * @name sap.ui.core.Element.prototype.indexOfDependent
	 * @since 1.19
	 * @public
	 */
	
	/**
	 * Destroys all the controls in the aggregation
	 * named <code>dependents</code>.
	 * @return {sap.ui.core.Element} <code>this</code> to allow method chaining
	 * @function
	 * @name sap.ui.core.Element.prototype.destroyDependents
	 * @since 1.19
	 * @public
	 */
	Element.prototype.destroyDependents = function() {
		return this.destroyAggregation("dependents", true);
	};
	
	
	/// cyclic dependency
	//jQuery.sap.require("sap.ui.core.TooltipBase"); /// cyclic dependency
	
	
	/**
	 * This triggers immediate rerendering of its parent and thus of itself and its children.<br/> As <code>sap.ui.core.Element</code> "bubbles up" the
	 * rerender, changes to child-<code>Elements</code> will also result in immediate rerendering of the whole sub tree.
	 * @protected
	 * @name sap.ui.core.Element#rerender
	 * @function
	 */
	Element.prototype.rerender = function() {
		if (this.oParent) {
			this.oParent.rerender();
		}
	};
	
	
	/**
	 * Returns the UI area of this element, if any.
	 *
	 * @return {sap.ui.core.UIArea} The UI area of this element or null
	 * @private
	 * @name sap.ui.core.Element#getUIArea
	 * @function
	 */
	Element.prototype.getUIArea = function() {
		return this.oParent ? this.oParent.getUIArea() : null;
	};
	
	/**
	 * Cleans up the resources associated with this element and all its children.
	 *
	 * After an element has been destroyed, it can no longer be used in the UI!
	 *
	 * Applications should call this method if they don't need the element any longer.
	 *
	 * @param {boolean}
	 *            [bSuppressInvalidate] if true, the UI element is not marked for redraw
	 * @public
	 * @name sap.ui.core.Element#destroy
	 * @function
	 */
	Element.prototype.destroy = function(bSuppressInvalidate) {
	
		ManagedObject.prototype.destroy.call(this, bSuppressInvalidate);
	
		// remove this control from DOM, e.g. if there is no parent (e.g. Dialog or already removed control) or this.sParentAggregationName is not properly set
		this.$().remove();
	};
	
	
	/**
	 * Fires the given event and notifies all listeners. Listeners must not change
	 * the content of the event.
	 *
	 * @param {string} sEventId the event id
	 * @param {object} mParameters the parameter map
	 * @return {sap.ui.core.Element} Returns <code>this</code> to allow method chaining
	 * @protected
	 * @name sap.ui.core.Element#fireEvent
	 * @function
	 */
	Element.prototype.fireEvent = function(sEventId, mParameters) {
		// clone 'arguments' and modify clone to be strict mode compatible
		var aArgs = Array.prototype.slice.apply(arguments);
		// TODO 'id' is somewhat redundant to getSource(), but it is commonly used - fade out with next major release?
		aArgs[1] = mParameters = mParameters || {};
		mParameters.id = mParameters.id || this.getId();
		// 'aArgs' is necessary, as the EventProvider.fireEvent signature has more parameters
		return sap.ui.base.EventProvider.prototype.fireEvent.apply(this, aArgs);
	};
	
	
	/**
	 * Adds a delegate that listens to the events of this element.
	 * 
	 * Note that the default behavior (delegate attachments are not cloned when a control is cloned) is usually the desired behavior in control development 
	 * where each control instance typically creates a delegate and adds it to itself. (As opposed to application development where the application may add 
	 * one delegate to a template and then expects aggregation binding to add the same delegate to all cloned elements.)
	 *
	 * To avoid double registrations, all registrations of the given delegate are first removed and then the delegate is added.
	 * 
	 * @param {object} oDelegate the delegate object
	 * @param {boolean} [bCallBefore=false] if true, the delegate event listeners are called before the event listeners of the element; default is "false". In order to also set bClone, this parameter must be given.
	 * @param {object} [oThis] if given, this object will be the "this" context in the listener methods; default is the delegate object itself
	 * @param {boolean} [bClone=false] if true, this delegate will also be attached to any clones of this element; default is "false"
	 * @return {sap.ui.core.Element} Returns <code>this</code> to allow method chaining
	 * @private
	 * @name sap.ui.core.Element#addDelegate
	 * @function
	 */
	Element.prototype.addDelegate = function (oDelegate, bCallBefore, oThis, bClone) {
		this.removeDelegate(oDelegate);
		
		// shift parameters
		if (typeof bCallBefore === "object") {
			bClone = oThis;
			oThis = bCallBefore;
			bCallBefore = false;
		}
		
		if (typeof oThis === "boolean") {
			bClone = oThis;
			oThis = undefined;
		}
	
		(bCallBefore ? this.aBeforeDelegates : this.aDelegates).push({oDelegate:oDelegate, bClone: !!bClone, vThis: ((oThis === this) ? true : oThis)}); // special case: if this element is the given context, set a flag, so this also works after cloning (it should be the cloned element then, not the given one)
		return this;
	};
	
	/**
	 * Removes the given delegate from this element.
	 *
	 * This method will remove all registrations of the given delegate, not only one.
	 * If the delegate was marked to be cloned and this element has been cloned, the delegate will not be removed from any clones.
	 * 
	 * @param {object} oDelegate the delegate object
	 * @return {sap.ui.core.Element} Returns <code>this</code> to allow method chaining
	 * @private
	 * @name sap.ui.core.Element#removeDelegate
	 * @function
	 */
	Element.prototype.removeDelegate = function (oDelegate) {
		for (var i=0;i<this.aDelegates.length;i++) {
			if (this.aDelegates[i].oDelegate==oDelegate) {
				this.aDelegates.splice(i,1);
			}
		}
		for (var i=0;i<this.aBeforeDelegates.length;i++) {
			if (this.aBeforeDelegates[i].oDelegate==oDelegate) {
				this.aBeforeDelegates.splice(i,1);
			}
		}
		return this;
	};
	
	
	/**
	 * Adds a delegate that listens to the events that are fired on this element (as opposed to events which are fired BY this element).
	 * 
	 * When this element is cloned, the same delegate will be added to all clones. This behavior is well-suited for applications which want to add delegates
	 * that also work with templates in aggregation bindings.
	 * For control development the internal "addDelegate" method which does not clone delegates by default may be more suitable, as typically each control instance takes care of its own delegates.
	 *
	 * To avoid double registrations, all registrations of the given delegate are first
	 * removed and then the delegate is added.
	 *
	 * @param {object} oDelegate the delegate object
	 * @param {object} [oThis] if given, this object will be the "this" context in the listener methods; default is the delegate object itself
	 * @return {sap.ui.core.Element} Returns <code>this</code> to allow method chaining
	 * @since 1.9.0
	 * @public
	 * @name sap.ui.core.Element#addEventDelegate
	 * @function
	 */
	Element.prototype.addEventDelegate = function (oDelegate, oThis) {
		return this.addDelegate(oDelegate, false, oThis, true);
	};
	
	/**
	 * Removes the given delegate from this element.
	 *
	 * This method will remove all registrations of the given delegate, not only one.
	 * 
	 * @param {object} oDelegate the delegate object
	 * @return {sap.ui.core.Element} Returns <code>this</code> to allow method chaining
	 * @since 1.9.0
	 * @public
	 * @name sap.ui.core.Element#removeEventDelegate
	 * @function
	 */
	Element.prototype.removeEventDelegate = function (oDelegate) {
		return this.removeDelegate(oDelegate);
	};
	
	/**
	 * Returns the DOM Element that should get the focus.
	 * 
	 * To be overwritten by the specific control method.
	 * 
	 * @return {Element} Returns the DOM Element that should get the focus
	 * @protected
	 * @name sap.ui.core.Element#getFocusDomRef
	 * @function
	 */
	Element.prototype.getFocusDomRef = function () {
		return this.getDomRef() || null;
	};
	
	/**
	 * Sets the focus to the stored focus DOM reference
	 * @private
	 * @name sap.ui.core.Element#focus
	 * @function
	 */
	Element.prototype.focus = function () {
		var oFocusDomRef = this.getFocusDomRef();
	
		if(oFocusDomRef) {
			try {
				oFocusDomRef.focus();
			} catch (ex) { // IE8 fails on focusing certain elements; IE9+10 and all other current browsers don't fail
				// the element does not exist or is not focusable; there is no information what to focus instead
				var id = oFocusDomRef.id ? " (id: " + oFocusDomRef.id + ")" : " ";
				jQuery.sap.log.warning("DOM element" + id + " in " + this.toString() + " which should be focused cannot be focused: " + ex.message);
			}
		}
	};
	
	/**
	 * Returns an object representing the serialized focus information
	 * To be overwritten by the specific control method
	 * @type object
	 * @return an object representing the serialized focus information
	 * @protected
	 * @name sap.ui.core.Element#getFocusInfo
	 * @function
	 */
	Element.prototype.getFocusInfo = function () {
		return {id:this.getId()};
	};
	
	/**
	 * Applies the focus info.
	 * 
	 * To be overwritten by the specific control method.
	 * 
	 * @param {object} oFocusInfo
	 * @protected
	 * @name sap.ui.core.Element#applyFocusInfo
	 * @function
	 */
	Element.prototype.applyFocusInfo = function (oFocusInfo) {
		this.focus();
		return this;
	};
	
	
	/**
	 * @see sap.ui.core.Element#setTooltip
	 * @private
	 * @name sap.ui.core.Element#_refreshTooltipBaseDelegate
	 * @function
	 */
	Element.prototype._refreshTooltipBaseDelegate = function (oTooltip) {
		var oOldTooltip = this.getTooltip();
		// if the old tooltip was a Tooltip object, remove it as a delegate
		if (oOldTooltip instanceof sap.ui.core.TooltipBase){
			this.removeDelegate(oOldTooltip);
		}
		// if the new tooltip is a Tooltip object, add it as a delegate
		if (oTooltip instanceof sap.ui.core.TooltipBase){
			oTooltip._currentControl = this;
			this.addDelegate(oTooltip);
		}
	};
	
	
	/**
	 * Sets a new tooltip for this object. The tooltip can either be a simple string
	 * (which in most cases will be rendered as the <code>title</code> attribute of this
	 * Element) or an instance of {@link sap.ui.core.TooltipBase}.
	 *
	 * If a new tooltip is set, any previously set tooltip is deactivated.
	 *
	 * @param {string|sap.ui.core.TooltipBase} oTooltip.
	 * @public
	 * @name sap.ui.core.Element#setTooltip
	 * @function
	 */
	Element.prototype.setTooltip = function(oTooltip) {
	
		this._refreshTooltipBaseDelegate(oTooltip);
		this.setAggregation("tooltip", oTooltip);
	
		return this;
	};
	
	/**
	 * Returns the tooltip for this element if any or an undefined value.
	 * The tooltip can either be a simple string or a subclass of
	 * {@link sap.ui.core.TooltipBase}.
	 *
	 * Callers that are only interested in tooltips of type string (e.g. to render
	 * them as a <code>title</code> attribute), should call the convenience method
	 * {@link #getTooltip_AsString} instead. If they want to get a tooltip text no
	 * matter where it comes from (be it a string tooltip or the text from a TooltipBase
	 * instance) then they could call {@link #getTooltip_Text} instead.
	 *
	 * @return {string|sap.ui.core.TooltipBase} The tooltip for this Element.
	 * @public
	 * @name sap.ui.core.Element#getTooltip
	 * @function
	 */
	Element.prototype.getTooltip = function() {
		return this.getAggregation("tooltip");
	};
	
	Element.runWithPreprocessors = ManagedObject.runWithPreprocessors;
	
	/**
	 * Returns the tooltip for this element but only if it is a simple string.
	 * Otherwise an undefined value is returned.
	 *
	 * @return {string} string tooltip or undefined
	 * @public
	 * @name sap.ui.core.Element#getTooltip_AsString
	 * @function
	 */
	Element.prototype.getTooltip_AsString = function() {
		var oTooltip = this.getTooltip();
		if (typeof oTooltip === "string" || oTooltip instanceof String ) {
			return oTooltip;
		}
		return undefined;
	};
	
	/**
	 * Returns the main text for the current tooltip or undefined if there is no such text.
	 * If the tooltip is an object derived from sap.ui.core.Tooltip, then the text property
	 * of that object is returned. Otherwise the object itself is returned (either a string
	 * or undefined or null).
	 *
	 * @return {string} text of the current tooltip or undefined
	 * @public
	 * @name sap.ui.core.Element#getTooltip_Text
	 * @function
	 */
	Element.prototype.getTooltip_Text = function() {
		var oTooltip = this.getTooltip();
		if (oTooltip && typeof oTooltip.getText === "function" ) {
			return oTooltip.getText();
		}
		return oTooltip;
	};
	
	/**
	 * Returns the runtime metadata for this UI element.
	 *
	 * When using the defineClass method, this function is automatically created and returns
	 * a runtime representation of the design time metadata.
	 *
	 * @function
	 * @name sap.ui.core.Element.prototype.getMetadata
	 * @return {object} runtime metadata
	 * @public
	 */
	// sap.ui.core.Element.prototype.getMetadata = sap.ui.base.Object.ABSTRACT_METHOD;
	
	//data container
	
	(function(){
	
		/**
		 * Returns the data object with the given key
		 */
		var getDataObject = function(element, key) {
			var aData = element.getAggregation("customData");
			if (aData) {
				for (var i = 0; i < aData.length; i++) {
					if (aData[i].getKey() == key) {
						return aData[i];
					}
				}
			}
			return null;
		};
	
		/**
		 * Contains the data modification logic
		 */
		var setData = function(element, key, value, writeToDom) {
	
			// DELETE
			if (value === null) { // delete this property
				var dataObject = getDataObject(element, key);
				if (!dataObject) {
					return;
				}
	
				var dataCount = element.getAggregation("customData").length;
				if (dataCount == 1) {
					element.destroyAggregation("customData", true); // destroy if there is no other data
				} else {
					element.removeAggregation("customData", dataObject, true);
					dataObject.destroy();
				}
	
				// ADD or CHANGE
			} else {
				var dataObject = getDataObject(element, key);
				if (dataObject) {
					dataObject.setValue(value);
					dataObject.setWriteToDom(writeToDom);
				} else {
					var dataObject = new sap.ui.core.CustomData({key:key,value:value, writeToDom:writeToDom});
					element.addAggregation("customData", dataObject, true);
				}
			}
		};
	
		/**
		 * Attaches custom data to an Element or retrieves attached data.
		 *
		 * Usage:
		 *    data("myKey", myData)
		 * attaches myData (which can be any JS data type, e.g. a number, a string, an object, or a function) to this element, under the given key "myKey". If the key already exists,the value will be updated.
		 *
		 *    data("myKey", myData, writeToDom)
		 * attaches myData to this element, under the given key "myKey" and (if writeToDom is true) writes key and value to the HTML. If the key already exists,the value will be updated. While oValue can be any JS data type to be attached, it must be a string to be also written to DOM. The key must also be a valid HTML attribute name (it must conform to sap.ui.core.ID and may contain no colon) and may not start with "sap-ui". When written to HTML, the key is prefixed with "data-".
		 *
		 *    data("myKey")
		 * retrieves whatever data has been attached to this Element (using the key "myKey") before
		 *
		 *    data("myKey", null)
		 * removes whatever data has been attached to this Element (using the key "myKey") before
		 *
		 *    data(null)
		 * removes all data
		 *
		 *    data()
		 * returns all data, as a map
		 *
		 * @public
		 * @name sap.ui.core.Element#data
		 * @function
		 */
		Element.prototype.data = function() {
			var argLength = arguments.length;
	
			if (argLength == 0) {                    // return ALL data as a map
				var aData = this.getAggregation("customData"),
					result = {};
				if (aData) {
					for (var i = 0; i < aData.length; i++) {
						result[aData[i].getKey()] = aData[i].getValue();
					}
				}
				return result;
	
			} else if (argLength == 1) {
				var arg0 = arguments[0];
	
				if (arg0 === null) {                  // delete ALL data
					this.destroyAggregation("customData", true); // delete whole map
					return this;
	
				} else if (typeof arg0 == "string") { // return requested data element
					var dataObject = getDataObject(this, arg0);
					return dataObject ? dataObject.getValue() : null;
	
				} else if (typeof arg0 == "object") { // should be a map - set multiple data elements
					for (var key in arg0) { // TODO: improve performance and avoid executing setData multiple times
						setData(this, key, arg0[key]);
					}
					return this;
	
				} else {
					// error, illegal argument
					throw new Error("When data() is called with one argument, this argument must be a string, an object or null, but is " + (typeof arg0) + ":" + arg0 + " (on UI Element with ID '" + this.getId() + "')");
				}
	
			} else if (argLength == 2) {            // set or remove one data element
				setData(this, arguments[0], arguments[1]);
				return this;
	
			} else if (argLength == 3) {            // set or remove one data element
				setData(this, arguments[0], arguments[1], arguments[2]);
				return this;
	
			} else {
				// error, illegal arguments
				throw new Error("data() may only be called with 0-3 arguments (on UI Element with ID '" + this.getId() + "')");
			}
		};
	
	})();
	
	/** 
	 * Clone delegates
	 * @param {string} [sIdSuffix] a suffix to be appended to the cloned element id
	 * @param {string[]} [aLocalIds] an array of local IDs within the cloned hierarchy (internally used)
	 * @return {sap.ui.base.ManagedObject} reference to the newly created clone
	 * @protected
	 * @name sap.ui.core.Element#clone
	 * @function
	 */
	Element.prototype.clone = function(sIdSuffix, aLocalIds){
	
		var oClone = ManagedObject.prototype.clone.apply(this, arguments);
		// Clone delegates
		for ( var i = 0; i < this.aDelegates.length; i++) {
			if (this.aDelegates[i].bClone) {
				oClone.aDelegates.push(this.aDelegates[i]);
			}
		}
		for ( var i = 0; i < this.aBeforeDelegates.length; i++) {
			if (this.aBeforeDelegates[i].bClone) {
				oClone.aBeforeDelegates.push(this.aBeforeDelegates[i]);
			}
		}
	
		return oClone;
	};
	
	/**
	* Searches and returns an array of child elements and controls which are
	* referenced within an aggregation or aggregations of child elements/controls.
	* This can be either done recursive or not.
	* <br>
	* <b>Take care: this operation might be expensive.</b>
	* @param {boolean}
	*          bRecursive true, if all nested children should be returned.
	* @return {sap.ui.core.Element[]} array of child elements and controls
	* @public
	* @name sap.ui.core.Element#findElements
	* @function
	*/
	Element.prototype.findElements = function(bRecursive) {
		var aControls = ManagedObject.prototype.findAggregatedObjects.call(this, bRecursive);
		return aControls;
	};
	
	/**
	 * Sets the {@link sap.ui.core.LayoutData} defining the layout constraints 
	 * for this control when it is used inside a layout.
	 *
	 * @function
	 * @name sap.ui.core.Element.prototype.setLayoutData
	 * @public
	 */
	Element.prototype.setLayoutData = function(oLayoutData) {
		this.setAggregation("layoutData", oLayoutData, true); // No invalidate because layout data changes does not affect the control / element itself
		var oLayout = this.getParent();
		if(oLayout){
			var oEvent = jQuery.Event("LayoutDataChange");
			oEvent.srcControl = this;
			oLayout._handleEvent(oEvent);
		}
		return this;
	};
	
	/**
	 * Returns the {@link sap.ui.core.LayoutData} defining the layout constraints 
	 * for this control when it is used inside a layout.
	 *
	 * @function
	 * @name sap.ui.core.Element.prototype.getLayoutData
	 * @public
	 */
	
	/**
	 * Allows the parent of a control to enhance the aria information during rendering
	 *
	 * This function is called by the RenderManager's writeAccessibilityState method 
	 * for the parent of the currently rendered control - if the parent implements it.
	 *
	 * @function
	 * @name sap.ui.core.Element.prototype.enhanceAccessibilityState
	 * @param {sap.ui.core.Element} oElement the Control/Element for which aria properties are rendered
	 * @param {object} mAriaProps map of aria properties keyed by there name (withour prefix "aria-")
	 * @return {object} map of enhanced aria properties
	 * @protected
	 * @abstract
	 */
	
	/**
	 * Bind the object to the referenced entity in the model, which is used as the binding context
	 * to resolve bound properties or aggregations of the object itself and all of its children
	 * relatively to the given path.
	 * If a relative binding path is used, this will be applied whenever the parent context changes.
	 * @param {string} sPath the binding path
	 * @param {object} [mParameters] map of additional parameters for this binding
	 *
	 * @return {sap.ui.base.ManagedObject} reference to the instance itself
	 * @public 
	 * @name sap.ui.core.Element#bindElement
	 * @function
	 */
	Element.prototype.bindElement = function(sPath, mParameters) {
		return this.bindObject(sPath, mParameters);
	};
	
	/**
	 * Removes the defined binding context of this object, all bindings will now resolve
	 * relative to the parent context again.
	 *
	 * @return {sap.ui.base.ManagedObject} reference to the instance itself
	 * @public
	 * @name sap.ui.core.Element#unbindElement
	 * @function
	 */
	Element.prototype.unbindElement = function(sModelName) {
		return this.unbindObject(sModelName);
	};
	
	/**
	 * Get the element binding object for a specific model
	 *
	 * @param {string} sModelName the name of the model
	 * @return {sap.ui.model.Binding} the element binding for the given model name
	 * @public
	 * @name sap.ui.core.Element#getElementBinding
	 * @function
	 */
	Element.prototype.getElementBinding = function(sModelName){
		return this.getObjectBinding(sModelName);
	};
	
	

	return Element;

}, /* bExport= */ true);

}; // end of sap/ui/core/Element.js
sap.ui.define("sap/ui/core/CustomStyleClassSupport",['jquery.sap.global', './Element'],
	function(jQuery, Element) {
	"use strict";


	/**
	 * If called on the prototype of a sap.ui.core.Element, the Element (and its prototype) is extended
	 * to support custom style classes.
	 *
	 * WARNING: only to be used WITHIN a control implementation. An application cannot add style class support by calling this method!
	 *
	 * The methods "addStyleClass", "removeStyleClass", toggleStyleClass and "hasStyleClass" are added to the Element and the clone() method
	 * is extended to also clone the custom classes.
	 *
	 * Usage example:
	 * jQuery.sap.require("sap.ui.core.CustomStyleClassSupport");
	 * sap.ui.core.CustomStyleClassSupport.apply(sap.ui.commons.layout.MatrixLayoutCell.prototype);
	 *
	 * Each renderer handling the given Element MUST then call
	 * renderManager.writeClasses(oElement);
	 * when writing the root tag of the Element. This makes sure the classes are written to the HTML.
	 *
	 * @public
	 * @name sap.ui.core.CustomStyleClassSupport
	 * @function
	 */
	var CustomStyleClassSupport = function () {
		// "this" is the prototype now when called with apply()
	
		// Ensure only Elements are enhanced
		if(!(this instanceof Element)) {
			return;
		}
	
		// enrich original clone function
		var fOriginalClone = this.clone;
		this.clone = function() {
			// call original clone function
			var oClone = fOriginalClone.apply(this, arguments);
	
			// add the style classes of "this" to the clone
			if (this.aCustomStyleClasses) {
				oClone.aCustomStyleClasses = this.aCustomStyleClasses.slice();
			}
			return oClone;
		};
	
	
		this.addStyleClass = function(sStyleClass, bSuppressRerendering) { // bSuppressRerendering is experimental and hence undocumented
			jQuery.sap.assert(sStyleClass && typeof sStyleClass === "string", "sStyleClass must be a string");
	
			if (!this.aCustomStyleClasses) {
				this.aCustomStyleClasses = [];
			}
			if (sStyleClass) {
				// ensure the "class" attribute is not closed
				if (sStyleClass.indexOf("\"") > -1) {
					return this;
				}
				if (sStyleClass.indexOf("'") > -1) {
					return this;
				} // TODO: maybe check for quotes in different charsets or encodings
	
				// multiple calls should not add the class multiple times
				for (var i = this.aCustomStyleClasses.length-1; i >= 0; i--) {
					if (this.aCustomStyleClasses[i] == sStyleClass) {
						return this;
					}
				}
	
				this.aCustomStyleClasses.push(sStyleClass);
				var oRoot = this.getDomRef();
				if (oRoot) { // non-rerendering shortcut
					jQuery(oRoot).addClass(sStyleClass);
				} else if (bSuppressRerendering === false) {
					this.invalidate();
				}
			}
	
			return this;
		};
	
	
		this.removeStyleClass = function(sStyleClass, bSuppressRerendering) { // bSuppressRerendering is experimental and hence undocumented
			jQuery.sap.assert(sStyleClass && typeof sStyleClass === "string", "sStyleClass must be a string");
	
			if (sStyleClass && this.aCustomStyleClasses) {
				for (var i = this.aCustomStyleClasses.length-1; i >= 0; i--) {
					if (this.aCustomStyleClasses[i] == sStyleClass) {
						this.aCustomStyleClasses.splice(i, 1);
						var oRoot = this.getDomRef();
						if (oRoot) { // non-rerendering shortcut
							jQuery(oRoot).removeClass(sStyleClass);
						} else if (bSuppressRerendering === false) {
							this.invalidate();
						}
					}
				}
			}
	
			return this;
		};
	
	
		this.toggleStyleClass = function(sStyleClass, bAdd) {
			jQuery.sap.assert(sStyleClass && typeof sStyleClass === "string", "sStyleClass must be a string");
			
			if (sStyleClass && typeof sStyleClass === "string") {
				if (bAdd === true) {
					this.addStyleClass(sStyleClass);
				} else if (bAdd === false) {
					this.removeStyleClass(sStyleClass);
				} else if (bAdd === undefined) {
					this.hasStyleClass(sStyleClass) ? this.removeStyleClass(sStyleClass) : this.addStyleClass(sStyleClass);
				} else {
					jQuery.sap.log.warning(this.toString() + "- toggleStyleClass(): bAdd should be a boolean or undefined, but is '" + bAdd + "'");
				}
			}
			
			return this; // we could (depending on bAdd) return either this or the boolean result of removeStyleClass, but at least in the bAdd===undefined case the caller wouldn't even know which return type to expect...
		};
	
	
		this.hasStyleClass = function(sStyleClass) {
			jQuery.sap.assert(sStyleClass && typeof sStyleClass === "string", "sStyleClass must be a string");
	
			if (sStyleClass && this.aCustomStyleClasses) {
				for (var i = this.aCustomStyleClasses.length-1; i >= 0; i--) {
					if (this.aCustomStyleClasses[i] == sStyleClass) {
						return true;
					}
				}
			}
			return false;
		};
	
		this.getMetadata().addPublicMethods(["addStyleClass", "removeStyleClass", "toggleStyleClass", "hasStyleClass"]);
	
	};
	
	// moved here to fix the cyclic dependency CustomStyleClassSupport, Element, Core, Control
	

	return CustomStyleClassSupport;

}, /* bExport= */ true);

}; // end of sap/ui/core/CustomStyleClassSupport.js
sap.ui.define("sap/ui/core/Control",['jquery.sap.global', './CustomStyleClassSupport', './Element'],
	function(jQuery, CustomStyleClassSupport, Element) {
	"use strict";

//jQuery.sap.require("sap.ui.core.RenderManager"); // cyclic
	
	/**
	 * Creates and initializes a new control with the given <code>sId</code> and settings.
	 *
	 * The set of allowed entries in the <code>mSettings</code> object depends on the concrete
	 * subclass and is described there. See {@link sap.ui.core.Element} for a general description of this
	 * argument.
	 *
	 * @param {string} [sId] optional id for the new control; generated automatically if no non-empty id is given
	 *      Note: this can be omitted, no matter whether <code>mSettings</code> will be given or not!
	 * @param {object} [mSettings] optional map/JSON-object with initial settings for the new control
	 * @public
	 *
	 * @class Base Class for Controls.
	 * @extends sap.ui.core.Element
	 * @abstract
	 * @author Martin Schaus, Daniel Brinkmann
	 * @version 1.20.6
	 * @name sap.ui.core.Control
	 */
	var Control = Element.extend("sap.ui.core.Control", /* @lends sap.ui.core.Control */ {
	
		metadata : {
			stereotype : "control",
			"abstract" : true,
			publicMethods: ["placeAt", "attachBrowserEvent", "detachBrowserEvent"],
			library: "sap.ui.core",
			properties : {
				"busy" : {type: "boolean", defaultValue: false},
				"busyIndicatorDelay" : {type: "int", defaultValue: 1000}
			},
			aggregations : {},
			associations : {},
			events : {}
		},
	
		constructor : function(sId, mSettings) {
	
			// TODO initialization should happen in init
			// but many of the existing controls don't call super.init()
			// As a workaround I moved the initialization of bAllowTextSelection here
			// so that it doesn't overwrite settings in init() (e.g. ListBox)
			this.bAllowTextSelection = true;
	
			Element.apply(this,arguments);
			this.bOutput = this.getDomRef() != null; // whether this control has already produced output
			
			if (this._sapUiCoreLocalBusy_initBusyIndicator) {
				this._sapUiCoreLocalBusy_initBusyIndicator();
			}
		},
	
		renderer : null // Control has no renderer
	
	});
	
	/**
	 * Creates a new subclass of class sap.ui.core.Control with name <code>sClassName</code> 
	 * and enriches it with the information contained in <code>oClassInfo</code>.
	 * 
	 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
	 *   
	 * @param {string} sClassName name of the class to be created
	 * @param {object} [oClassInfo] object literal with informations about the class  
	 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
	 * @return {function} the created class / constructor function
	 * @public
	 * @static
	 * @name sap.ui.core.Control.extend
	 * @function
	 */
	
	/**
	 * Overrides {@link sap.ui.core.Element#clone Element.clone} to clone additional 
	 * internal state.
	 * 
	 * The additionally cloned information contains:
	 * <ul>
	 * <li>browser event handlers attached with {@link #attachBrowserEvent}
	 * <li>text selection behavior
	 * <li>style classes added with {@link #addStyleClass}
	 * </ul>
	 * 
	 * @param {string} [sIdSuffix] a suffix to be appended to the cloned element id
	 * @param {string[]} [aLocalIds] an array of local IDs within the cloned hierarchy (internally used)
	 * @return {sap.ui.core.Element} reference to the newly created clone
	 * @protected
	 * @name sap.ui.core.Control#clone
	 * @function
	 */
	Control.prototype.clone = function() {
		var oClone = Element.prototype.clone.apply(this, arguments);
	
		if ( this.aBindParameters ) {
			for(var i=0, l=this.aBindParameters.length; i<l; i++) {
				var aParams = this.aBindParameters[i];
				oClone.attachBrowserEvent(aParams.sEventType, aParams.fnHandler, aParams.oListener !== this ? aParams.oListener : undefined);
			}
		}
		oClone.bAllowTextSelection = this.bAllowTextSelection;
		return oClone;
	};
	
	// must appear after clone() method and metamodel definition
	CustomStyleClassSupport.apply(Control.prototype);
	
	
	/**
	 * Checks whether the control is still active (part of the active DOM)
	 *
	 * @return {boolean} whether the control is still in the active DOM
	 * @private
	 * @name sap.ui.core.Control#isActive
	 * @function
	 */
	Control.prototype.isActive = function() {
		return jQuery.sap.domById(this.sId) != null;
	};
	
	/**
	 * Triggers rerendering of this element and its children.
	 *
	 * As <code>sap.ui.core.Element</code> "bubbles up" the invalidate, changes to children
	 * potentially result in rerendering of the whole sub tree.
	 * @protected
	 * @name sap.ui.core.Control#invalidate
	 * @function
	 */
	Control.prototype.invalidate = function(oOrigin) {
		var oUIArea;
		if ( this.bOutput && (oUIArea = this.getUIArea()) ) {
			// if this control has been rendered before (bOutput)
			// and if it is contained in an UIArea (!!oUIArea)
			// then control re-rendering can be used (see UIArea.rerender() for details)
			//
			// The check for bOutput is necessary as the control
			// re-rendering needs to identify the previous rendering results.
			// Otherwise it wouldn't be able to replace them.
			oUIArea.addInvalidatedControl(this);
		} else {
			// else we bubble up the hierarchy
			var oParent = this.getParent();
			if (oParent && (
					this.bOutput /* && !this.getUIArea() */ ||
					/* !this.bOutput && */ !(this.getVisible && this.getVisible() === false))) {
	
				// Note: the two comments in the condition above show additional conditions
				//       that help to understand the logic. As they are always fulfilled,
				//       they have been omitted for better performance.
				//
				// If this control has a parent but either
				//  - has produced output before ('this.bOutput') but is not part of an UIArea (!this.getUIArea())
				//  - or if it didn't produce output (!this.bOutput') before and is/became visible
				// then invalidate the parent to request re-rendering
				//
				// The first commented condition is always true, otherwise the initial if condition
				// in this method would have been met. The second one must be true as well because of the
				// short evaluation logic of JavaScript. When bOutput is true the second half of the Or won't be processed.
	
				oParent.invalidate(this);
			}
		}
	};
	
	/**
	 * Tries to replace its DOM reference by re-rendering.
	 * @protected
	 * @name sap.ui.core.Control#rerender
	 * @function
	 */
	Control.prototype.rerender = function() {
		sap.ui.core.UIArea.rerenderControl(this);
	};
	
	/**
	 * Defines whether the user can select text inside this control.
	 * Defaults to <code>true</code> as long as this method has not been called.
	 *
	 * <b>Note:</b>This only works in IE and Safari; for Firefox the element's style must
	 * be set to:
	 * <pre>
	 *   -moz-user-select: none;
	 * </pre>
	 * in order to prevent text selection.
	 *
	 * @param {boolean} whether to allow text selection or not
	 * @return {sap.ui.core.Control} Returns <code>this</code> to allow method chaining
	 * @public
	 * @name sap.ui.core.Control#allowTextSelection
	 * @function
	 */
	Control.prototype.allowTextSelection = function(bAllow) {
		this.bAllowTextSelection = bAllow;
		return this;
	};
	
	/**
	 * The string given as "sStyleClass" will be added to the "class" attribute of this control's root HTML element.
	 *
	 * This method is intended to be used to mark controls as being of a special type for which
	 * special styling can be provided using CSS selectors that reference this style class name.
	 *
	 * <pre>
	 * Example:
	 *    myButton.addStyleClass("myRedTextButton"); // add a CSS class to one button instance
	 *
	 * ...and in CSS:
	 *    .myRedTextButton {
	 *       color: red;
	 *    }
	 * </pre>
	 *
	 * This will add the CSS class "myRedTextButton" to the Button HTML and the CSS code above will then
	 * make the text in this particular button red.
	 *
	 * Only characters allowed inside HTML attributes are allowed.
	 * Quotes are not allowed and this method will ignore any strings containing quotes.
	 * Strings containing spaces are interpreted as ONE custom style class (even though CSS selectors interpret them
	 * as different classes) and can only removed later by calling removeStyleClass() with exactly the
	 * same (space-containing) string as parameter.
	 * Multiple calls with the same sStyleClass will have no different effect than calling once.
	 * If sStyleClass is null, the call is ignored.
	 *
	 * @name sap.ui.core.Control.prototype.addStyleClass
	 * @function
	 *
	 * @param {string} sStyleClass the CSS class name to be added
	 * @return {sap.ui.core.Control} Returns <code>this</code> to allow method chaining
	 * @public
	 */
	
	/**
	 * Removes the given string from the list of custom style classes that have been set previously.
	 * Regular style classes like "sapUiBtn" cannot be removed.
	 *
	 * @name sap.ui.core.Control.prototype.removeStyleClass
	 * @function
	 *
	 * @param {string} sStyleClass the style to be removed
	 * @return {sap.ui.core.Control} Returns <code>this</code> to allow method chaining
	 * @public
	 */
	
	/**
	 * The string given as "sStyleClass" will be be either added to or removed from the "class" attribute of this control's root HTML element,
	 * depending on the value of "bAdd": if bAdd is true, sStyleClass will be added.
	 * If bAdd is not given, sStyleClass will be removed if it is currently present and will be added if not present.
	 * If sStyleClass is null, the call is ignored.
	 * 
	 * See addStyleClass and removeStyleClass for further documentation.
	 *
	 * @name sap.ui.core.Control.prototype.toggleStyleClass
	 * @function
	 *
	 * @param {string} sStyleClass the CSS class name to be added or removed
	 * @param {boolean} bAdd whether sStyleClass should be added (or removed); when this parameter is not given, sStyleClass will be toggled (removed, if present, and added if not present) 
	 * @return {sap.ui.core.Control} Returns <code>this</code> to allow method chaining
	 * @public
	 */
	
	/**
	 * Returns true if the given style class string is valid and if this control has this style class set
	 * via a previous call to addStyleClass().
	 *
	 * @name sap.ui.core.Control.prototype.hasStyleClass
	 * @function
	 *
	 * @param {string} sStyleClass the style to check for
	 * @type boolean
	 * @return whether the given style has been set before
	 * @public
	 */
	
	
	/**
	 * Allows binding handlers for any native browser event to the root HTML element of this Control. This internally handles
	 * DOM element replacements caused by re-rendering.
	 *
	 * IMPORTANT:
	 * This should be only used as FALLBACK when the Control events do not cover a specific use-case! Always try using
	 * SAPUI5 control events, as e.g. accessibility-related functionality is then provided automatically.
	 * E.g. when working with a sap.ui.commons.Button, always use the Button's "press" event, not the native "click" event, because
	 * "press" is also guaranteed to be fired when certain keyboard activity is supposed to trigger the Button.
	 *
	 * In the event handler, "this" refers to the Control - not to the root DOM element like in jQuery. While the DOM element can
	 * be used and modified, the general caveats for working with SAPUI5 control DOM elements apply. In particular the DOM element
	 * may be destroyed and replaced by a new one at any time, so modifications that are required to have permanent effect may not
	 * be done. E.g. use Control.addStyleClass() instead if the modification is of visual nature.
	 *
	 * Use detachBrowserEvent() to remove the event handler(s) again.
	 *
	 * @param {string} [sEventType] A string containing one or more JavaScript event types, such as "click" or "blur".
	 * @param {function} [fnHandler] A function to execute each time the event is triggered.
	 * @param {object} [oListener] The object, that wants to be notified, when the event occurs
	 * @return {sap.ui.core.Control} Returns <code>this</code> to allow method chaining
	 * @public
	 * @name sap.ui.core.Control#attachBrowserEvent
	 * @function
	 */
	Control.prototype.attachBrowserEvent = function(sEventType, fnHandler, oListener) {
		if (sEventType && (typeof(sEventType) === "string")) { // do nothing if the first parameter is empty or not a string
			if (fnHandler && typeof(fnHandler) === "function") {   // also do nothing if the second parameter is not a function
				// store the parameters for bind()
				if (!this.aBindParameters) {
					this.aBindParameters = [];
				}
				oListener = oListener || this;
	
				// FWE jQuery.proxy can't be used as it breaks our contract when used with same function but different listeners
				var fnProxy=function() { fnHandler.apply(oListener, arguments); };
	
				this.aBindParameters.push({
					sEventType: sEventType,
					fnHandler: fnHandler,
					oListener: oListener,
					fnProxy : fnProxy
				});
	
				// if control is rendered, directly call bind()
				this.$().bind(sEventType, fnProxy);
			}
		}
	
		return this;
	};
	
	
	/**
	 * Removes event handlers which have been previously attached using {@link #attachBrowserEvent}.
	 *
	 * Note: listeners are only removed, if the same combination of event type, callback function 
	 * and context object is given as in the call to <code>attachBrowserEvent</code>.
	 *  
	 * @param {string} [sEventType] A string containing one or more JavaScript event types, such as "click" or "blur".
	 * @param {function} [fnHandler] The function that is to be no longer executed.
	 * @param {object} [oListener] The context object that was given in the call to attachBrowserEvent.
	 * @public
	 * @name sap.ui.core.Control#detachBrowserEvent
	 * @function
	 */
	Control.prototype.detachBrowserEvent = function(sEventType, fnHandler, oListener) {
		if (sEventType && (typeof(sEventType) === "string")) { // do nothing if the first parameter is empty or not a string
			if (fnHandler && typeof(fnHandler) === "function") {   // also do nothing if the second parameter is not a function
				var $ = this.$(),i,oParamSet;
				oListener=oListener || this;
	
				// remove the bind parameters from the stored array
				if (this.aBindParameters) {
					for (i = this.aBindParameters.length - 1; i >= 0; i--) {
						oParamSet = this.aBindParameters[i];
						if ( oParamSet.sEventType === sEventType  && oParamSet.fnHandler === fnHandler  &&  oParamSet.oListener === oListener ) {
							this.aBindParameters.splice(i, 1);
							// if control is rendered, directly call unbind()
							$.unbind(sEventType, oParamSet.fnProxy);
						}
					}
				}
	
			}
		}
	
		return this;
	};
	
	
	
	/**
	 * Returns a renderer for this control instance.
	 *
	 * It is retrieved using the RenderManager as done during rendering.
	 *
	 * @return {object} a Renderer suitable for this Control instance.
	 * @protected
	 * @name sap.ui.core.Control#getRenderer
	 * @function
	 */
	Control.prototype.getRenderer = function () {
		//TODO introduce caching?
		return sap.ui.core.RenderManager.getRenderer(this);
	};
	
	/**
	 * Puts <code>this</code> control into the specified container (<code>oRef</code>) at the given
	 * position (<code>oPosition</code>).
	 *
	 * First it is checked whether <code>oRef</code> is a container element / control (has a
	 * multiple aggregation with type <code>sap.ui.core.Control</code> and name 'content') or is an Id String
	 * of such an container.
	 * If this is not the case <code>oRef</code> can either be a Dom Reference or Id String of the UIArea
	 * (if it does not yet exist implicitly a new UIArea is created),
	 *
	 * The <code>oPosition</code> can be one of the following:
	 *
	 * <ul>
	 *  <li>"first": The control is added as the first element to the container.</li>
	 *  <li>"last": The control is added as the last element to the container (default).</li>
	 *  <li>"only": All existing children of the container are removed (not destroyed!) and the control is added as new child.</li>
	 *  <li><i>index</i>: The control is added at the specified <i>index</i> to the container.</li>
	 * </ul>
	 * 
	 * @param {string|Element|sap.ui.core.Control} oRef container into which the control should be put
	 * @param {string|int} oPosition Describes the position where the control should be put into the container
	 * @return {sap.ui.core.Control} Returns <code>this</code> to allow method chaining
	 * @public
	 * @name sap.ui.core.Control#placeAt
	 * @function
	 */
	Control.prototype.placeAt = function(oRef, oPosition) {
		var oCore = sap.ui.getCore();
		if(oCore.isInitialized()){
			// core already initialized, do it now
	
			// 1st try to resolve the oRef as a Container control
			var oContainer = oRef;
			if(typeof oContainer === "string"){
				oContainer = oCore.byId(oRef);
			}
			// if no container control is found use the corresponding UIArea
			var bIsUIArea = false;
			if(!(oContainer instanceof Element)) {
				oContainer = oCore.createUIArea(oRef);
				bIsUIArea = true;
			}
	
			if(!oContainer) {
				return;
			}
	
			if(!bIsUIArea){
				var oContentAggInfo = oContainer.getMetadata().getAllAggregations()["content"];
				var bContainerSupportsPlaceAt = true;
				if(oContentAggInfo){
					if(!oContentAggInfo.multiple || oContentAggInfo.type != "sap.ui.core.Control"){
						bContainerSupportsPlaceAt = false;
					}
				}else{
					//Temporary workaround for sap.ui.commons.AbsoluteLayout to enable placeAt even when no content aggregation is available. TODO: Find a proper solution
					if(!oContainer.addContent || !oContainer.insertContent || !oContainer.removeAllContent) {
						bContainerSupportsPlaceAt = false;
					}
				}
				if(!bContainerSupportsPlaceAt) {
					jQuery.sap.log.warning("placeAt cannot be processed because container "+oContainer+" does not have an aggregation 'content'.");
					return;
				}
			}
	
			if(typeof oPosition === "number"){
				oContainer.insertContent(this, oPosition);
			}else{
				oPosition = oPosition || "last"; //"last" is default
				switch(oPosition){
					case "last":
						oContainer.addContent(this);
						break;
					case "first":
						oContainer.insertContent(this, 0);
						break;
					case "only":
						oContainer.removeAllContent();
						oContainer.addContent(this);
						break;
					default:
						jQuery.sap.log.warning("Position "+oPosition+" is not supported for function placeAt.");
				}
			}
		}else{
			// core not yet initialized, defer execution
			var that = this;
			oCore.attachInitEvent(function () {
				that.placeAt(oRef, oPosition);
			});
		}
		return this;
	};
	
	/*
	 * Event handling
	 */
	
	/**
	 * Cancels user text selection if text selection is disabled for this control.
	 * See the {@link #allowTextSelection} method.
	 * @private
	 * @name sap.ui.core.Control#onselectstart
	 * @function
	 */
	Control.prototype.onselectstart = function (oBrowserEvent) {
		if(!this.bAllowTextSelection) {
			oBrowserEvent.preventDefault();
			oBrowserEvent.stopPropagation();
		}
	};
	
	/*
	 * Rendering
	 */
	
	/**
	 * Function is called before the rendering of the control is started.
	 *
	 * Applications must not call this hook method directly, it is called by the framework.
	 *
	 * Subclasses of Control should override this hook to implement any necessary actions before the rendering.
	 *
	 * @function
	 * @name sap.ui.core.Control.prototype.onBeforeRendering
	 * @protected
	 */
	//sap.ui.core.Control.prototype.onBeforeRendering = function() {};
	
	/**
	 * Function is called when the rendering of the control is completed.
	 *
	 * Applications must not call this hook method directly, it is called by the framework.
	 *
	 * Subclasses of Control should override this hook to implement any necessary actions after the rendering.
	 *
	 * @function
	 * @name sap.ui.core.Control.prototype.onAfterRendering
	 * @protected
	 */
	//sap.ui.core.Control.prototype.onAfterRendering = function() {};
	
	/**
	 * Returns the DOMNode Id to be used for the "labelFor" attribute of the label.
	 * 
	 * By default, this is the Id of the control itself.
	 * 
	 * @return {string} Id to be used for the <code>labelFor</code> 
	 * @public
	 * @name sap.ui.core.Control#getIdForLabel
	 * @function
	 */
	Control.prototype.getIdForLabel = function () {
		return this.getId();
	};
	
	Control.prototype.destroy = function(bSuppressInvalidate) {
		//Cleanup Busy Indicator
		this._cleanupBusyIndicator();
		
		sap.ui.core.ResizeHandler.deregisterAllForControl(this.getId());
	
		Element.prototype.destroy.call(this, bSuppressInvalidate);
	};
	
	(function() {
		var sPreventedEvents = "focusin focusout keydown keypress keyup",
			oBusyIndicatorDelegate = {
				onAfterRendering: function() {
					if (this.getProperty("busy") === true && this.$()) {
						fnAppendBusyIndicator.apply(this);
					}
				}
			},
			fnAppendBusyIndicator = function() {
				var $this = this.$(),
					aForbiddenTags = ["area", "base", "br", "col", "embed", "hr", "img", "input", "keygen", "link", "menuitem", "meta", "param", "source", "track", "wbr"];
				
	
				//If there is a pending delayed call to append the busy indicator, we can clear it now
				if (this._busyIndicatorDelayedCallId) {
					jQuery.sap.clearDelayedCall(this._busyIndicatorDelayedCallId);
					delete this._busyIndicatorDelayedCallId;
				}
	
				//Check if DOM Element where the busy indicator is supposed to be placed can handle content
				var sTag = $this.get(0) && $this.get(0).tagName;
				if (sTag && jQuery.inArray(sTag.toLowerCase(), aForbiddenTags) >= 0) {
					jQuery.sap.log.warning("Busy Indicator cannot be placed in elements with tag " + sTag);
					return;
				}
				
				//check if the control has static position, if this is the case we need to change it,
				//because we relay on relative/absolute/fixed positioning
				if ($this.css('position') == 'static') {
					this._busyStoredPosition = 'static';
					$this.css('position', 'relative');
				}
	
				//Append busy indicator to control DOM
				var $BusyIndicator = jQuery('<div class="sapUiLocalBusyIndicator"><div class="sapUiLocalBusyIndicatorAnimation"><div class="sapUiLocalBusyIndicatorBox"></div><div class="sapUiLocalBusyIndicatorBox"></div><div class="sapUiLocalBusyIndicatorBox"></div></div></div>');
				$BusyIndicator.attr("id",this.getId() + "-busyIndicator")
				$this.append($BusyIndicator);
				if (this._busyDelayedCallId) {
					jQuery.sap.clearDelayedCall(this._busyDelayedCallId);
				}
				this._busyDelayedCallId = jQuery.sap.delayedCall(1200, this, fnAnimate);
				fnHandleInteraction.apply(this, [true]);
			},
			fnHandleInteraction = function(bBusy) {
				if (bBusy) {
					var $this = this.$(),
						$TabRefs = $this.find('[tabindex]'),
						that = this;
					this._busyTabIndices = [];
					$TabRefs.each(function(iIndex, oObject) {
						var $Ref = jQuery(oObject),
							iTabIndex = $Ref.attr('tabindex');
						
						if (iTabIndex < 0) return true;
						
						that._busyTabIndices.push({
							ref: $Ref,
							tabindex: iTabIndex
						});
						$Ref.attr('tabindex', -1);
						$Ref.bind(sPreventedEvents, fnPreserveEvents);
					});
				} else {
					if (this._busyTabIndices) {
						jQuery.each(this._busyTabIndices, function(iIndex, oObject) {
							oObject.ref.attr('tabindex', oObject.tabindex);
							oObject.ref.unbind(sPreventedEvents, fnPreserveEvents);
						});
					}
					this._busyTabIndices = [];
				}
			},
			fnPreserveEvents = function(oEvent) {
				oEvent.preventDefault();
				oEvent.stopImmediatePropagation();
			},
			fnAnimate = function() {
				var $bubbles = this.$().children('.sapUiLocalBusyIndicator').children('.sapUiLocalBusyIndicatorAnimation');
				var that = this;
				that._busyAnimationTimer1 = setTimeout(function() {
					$bubbles.children(":eq(0)").addClass('active');
					$bubbles.children(":not(:eq(0))").removeClass('active');
					that._busyAnimationTimer2 = setTimeout(function() {
						$bubbles.children(":eq(1)").addClass('active');
						$bubbles.children(":not(:eq(1))").removeClass('active');
						that._busyAnimationTimer3 = setTimeout(function() {
							$bubbles.children(":eq(2)").addClass('active');
							$bubbles.children(":not(:eq(2))").removeClass('active');
							that._busyAnimationTimer4 = setTimeout(function() {
								$bubbles.children().removeClass('active');
							}, 150)
						}, 150);
					}, 150);
				}, 150);
				this._busyDelayedCallId = jQuery.sap.delayedCall(1200, this, fnAnimate);
			};
	
		/**
		 * Set the controls busy state
		 * 
		 * @public
		 * @param boolean The state to be set
		 * @return {Control} reference to control for chaining
		 * @name sap.ui.core.Control#setBusy
		 * @function
		 */
		Control.prototype.setBusy = function (bBusy) {
			var $this = this.$();
	
			//If the new state is already set, we don't need to do anything
			if (bBusy == this.getProperty("busy")) {
				return;
			}
	
			//No rerendering
			this.setProperty("busy", bBusy, true);
			
			if (bBusy) {
				this.addDelegate(oBusyIndicatorDelegate, false, this);
			} else {
				this.removeDelegate(oBusyIndicatorDelegate);
			}
			
			//If no domref exists stop here.
			if (!this.getDomRef()) {
				return;
			}
			
			if (bBusy) {
				if (this.getBusyIndicatorDelay() <= 0) {
					fnAppendBusyIndicator.apply(this);
				} else {
					this._busyIndicatorDelayedCallId = jQuery.sap.delayedCall(this.getBusyIndicatorDelay(), this, fnAppendBusyIndicator);
				}
			} else {
				//If there is a pending delayed call we clear it
				if (this._busyIndicatorDelayedCallId) {
					jQuery.sap.clearDelayedCall(this._busyIndicatorDelayedCallId);
					delete this._busyIndicatorDelayedCallId;
				}
				
				//Remove the busy indicator from the DOM
				this.$("busyIndicator").remove();
				
				//Reset the position style to its original state
				if (this._busyStoredPosition) {
					$this.css('position', this._busyStoredPosition);
					delete this._busyStoredPosition;
				}
				fnHandleInteraction.apply(this, [false]);
				if (this._busyDelayedCallId) {
					jQuery.sap.clearDelayedCall(this._busyDelayedCallId);
					delete this._busyDelayedCallId;
				}
			}
		};
		
		/**
		 * Check if the control is currently in busy state
		 * 
		 * @public
		 * @deprecated Use getBusy instead
		 * @return boolean
		 * @name sap.ui.core.Control#isBusy
		 * @function
		 */
		Control.prototype.isBusy = function() {
			return this.getProperty("busy");
		};
		
		/**
		 * Define the delay, after which the busy indicator will show up
		 * 
		 * @public
		 * @param int The delay in ms
		 * @return {Control} reference to control for chaining
		 * @name sap.ui.core.Control#setBusyIndicatorDelay
		 * @function
		 */
		Control.prototype.setBusyIndicatorDelay = function(iDelay) {
			this.setProperty("busyIndicatorDelay", iDelay, true);
			return this;
		};
		
		/**
		 * Cleanup all timers which might have been created by the busy indicator
		 * 
		 * @private
		 * @name sap.ui.core.Control#_cleanupBusyIndicator
		 * @function
		 */
		Control.prototype._cleanupBusyIndicator = function() {
			if (this._busyIndicatorDelayedCallId) {
				jQuery.sap.clearDelayedCall(this._busyIndicatorDelayedCallId);
				delete this._busyIndicatorDelayedCallId;
			}
			if (this._busyDelayedCallId) {
				jQuery.sap.clearDelayedCall(this._busyDelayedCallId);
				delete this._busyDelayedCallId;
			}
			if (this._busyAnimationTimer1) {
				clearTimeout(this._busyAnimationTimer1);
				delete this._busyAnimationTimer1;
			}
			if (this._busyAnimationTimer2) {
				clearTimeout(this._busyAnimationTimer2);
				delete this._busyAnimationTimer2;
			}
			if (this._busyAnimationTimer3) {
				clearTimeout(this._busyAnimationTimer3);
				delete this._busyAnimationTimer3;
			}
			if (this._busyAnimationTimer4) {
				clearTimeout(this._busyAnimationTimer4);
				delete this._busyAnimationTimer4;
			}
		}
	})();
	

	return Control;

}, /* bExport= */ true);

}; // end of sap/ui/core/Control.js
if ( !jQuery.sap.isDeclared('sap.ui.core.FocusHandler') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.core.FocusHandler
jQuery.sap.declare('sap.ui.core.FocusHandler'); // unresolved dependency added by SAPUI5 CreateModule Ant-Task
sap.ui.define("sap/ui/core/FocusHandler",['jquery.sap.global', 'sap/ui/Device', 'sap/ui/Global', 'sap/ui/base/Object', 'jquery.sap.script'],
	function(jQuery, Device, Global, BaseObject/* , jQuerySap */) {
	"use strict";


	
	
		/**
		 * Constructs an instance of a sap.ui.core.FocusHandler.
		 * Keeps track of the focused element.
		 *
		 * @class Keeps track of the focused element.
		 * @param {Element} oRootRef e.g. document.body
		 * @param {sap.ui.core.Core} oCore Reference to the Core implementation
		 * @name sap.ui.core.FocusHandler
		 */
		var FocusHandler = BaseObject.extend("sap.ui.core.FocusHandler", /** @lends sap.ui.core.FocusHandler */ {
			constructor : function(oRootRef, oCore) {
				BaseObject.apply(this);
		
				this.oCore = oCore;
		
				// keep track of element currently in focus
				this.oCurrent = null;
				// keep track of the element previously had the focus
				this.oLast = null;
				// buffer the focus/blur events for correct order
				this.aEventQueue = [];
		
				this.fEventHandler = jQuery.proxy(this.onEvent, this);
				this.fDestroyHandler = jQuery.proxy(this.destroy, this);
		
				// initialize event handling
				if(oRootRef.addEventListener && !!!Device.browser.internet_explorer){ //FF, Safari
					oRootRef.addEventListener("focus", this.fEventHandler, true);
					oRootRef.addEventListener("blur", this.fEventHandler, true);
				}else{ //IE
					jQuery(oRootRef).bind("activate", this.fEventHandler);
					jQuery(oRootRef).bind("deactivate", this.fEventHandler);
				}
				jQuery.sap.log.debug("FocusHandler setup on Root " + oRootRef.type + (oRootRef.id?": " + oRootRef.id:""), null, "sap.ui.core.FocusHandler");
		
				// TODO: Or should we be destroyed by the Core?
				jQuery(window).bind("unload", {"oRootRef": oRootRef}, this.fDestroyHandler);
			}
		});
	
		/**
		 * Returns the Id of the control/element currently in focus.
		 * @return {string} the Id of the control/element currently in focus.
		 * @public
		 * @name sap.ui.core.FocusHandler#getCurrentFocusedControlId
		 * @function
		 */
		FocusHandler.prototype.getCurrentFocusedControlId = function(){
			var aCtrls = null;
			try{
				var $Act = jQuery(document.activeElement);
				if($Act.is(":focus") || (Device.browser.internet_explorer && Device.browser.version == 8 && document.hasFocus())){
					aCtrls = $Act.control();
				}
			}catch(err){}
			return aCtrls && aCtrls.length > 0 ? aCtrls[0].getId() : null;
		};
	
		/**
		 * Destroy method of the Focus Handler.
		 * It unregisters the event handlers.
		 *
		 * @param {jQuery.Event} event the event that initiated the destruction of the FocusHandler
		 * @private
		 * @name sap.ui.core.FocusHandler#destroy
		 * @function
		 */
		FocusHandler.prototype.destroy = function(event) {
			var oRootRef = event.data.oRootRef;
			if(oRootRef){
				if(oRootRef.removeEventListener && !!!Device.browser.internet_explorer){ //FF, Safari
					oRootRef.removeEventListener("focus", this.fEventHandler, true);
					oRootRef.removeEventListener("blur", this.fEventHandler, true);
				}else{ //IE
					jQuery(oRootRef).unbind("activate", this.fEventHandler);
					jQuery(oRootRef).unbind("deactivate", this.fEventHandler);
				}
			}
			jQuery(window).unbind("unload", this.fDestroyHandler);
			this.oCore = null;
		};
	
		/**
		 * Handles the focus/blur events.
		 *
		 * @param oRootRef e.g. document.body
		 * @private
		 * @name sap.ui.core.FocusHandler#onEvent
		 * @function
		 */
		FocusHandler.prototype.onEvent = function(oBrowserEvent){
			var oEvent = jQuery.event.fix(oBrowserEvent);
	
			jQuery.sap.log.debug("Event "+oEvent.type+" reached Focus Handler (target: "+oEvent.target+(oEvent.target ? oEvent.target.id : "")+")", null, "sap.ui.core.FocusHandler");
	
			var type = (oEvent.type == "focus" || oEvent.type == "focusin" || oEvent.type == "activate") ? "focus" : "blur";
			this.aEventQueue.push({type:type, controlId: getControlIdForDOM(oEvent.target)});
			if(this.aEventQueue.length == 1) {
				this.processEvent();
			}
		};
	
		/**
		 * Processes the focus/blur events in the event queue.
		 *
		 * @private
		 * @name sap.ui.core.FocusHandler#processEvent
		 * @function
		 */
		FocusHandler.prototype.processEvent = function(){
			var oEvent = this.aEventQueue[0];
			if(!oEvent) {
				return;
			}
			if(oEvent.type == "focus"){
				this.onfocusEvent(oEvent.controlId);
			}else if(oEvent.type == "blur"){
				this.onblurEvent(oEvent.controlId);
			}
			this.aEventQueue.shift();
			if(this.aEventQueue.length > 0) {
				this.processEvent();
			}
		};
	
		/**
		 * Processes the focus event taken from the event queue.
		 *
		 * @param sControlId Id of the event related control
		 * @private
		 * @name sap.ui.core.FocusHandler#onfocusEvent
		 * @function
		 */
		FocusHandler.prototype.onfocusEvent = function(sControlId){
			this.oCurrent = sControlId;
			if (!this.oLast) {
				// No last active element to be left... 
				return;
			}
			
			triggerFocusleave(this.oLast, sControlId, this.oCore);
			this.oLast = null;
		};
	
		/**
		 * Processes the blur event taken from the event queue.
		 *
		 * @param sControlId Id of the event related control
		 * @private
		 * @name sap.ui.core.FocusHandler#onblurEvent
		 * @function
		 */
		FocusHandler.prototype.onblurEvent = function(sControlId){
			if (!this.oCurrent) {
				// No current Item, so nothing to lose focus...
				return;
			}
			this.oLast = sControlId;
				
			this.oCurrent = null;
			jQuery.sap.delayedCall(0, this, "checkForLostFocus");
		};
	
		/**
		 * Checks for lost focus and provides events in case of losing the focus.
		 * Called in delayed manner from {@link sap.ui.core.FocusHandler#onblurEvent}.
		 *
		 * @private
		 * @name sap.ui.core.FocusHandler#checkForLostFocus
		 * @function
		 */
		FocusHandler.prototype.checkForLostFocus = function(){
			if(this.oCurrent == null && this.oLast != null){
				triggerFocusleave(this.oLast, null, this.oCore);
			}
			this.oLast = null;
		};
	
	
		//***********************************************************
		// Utility / convenience
		//***********************************************************
	
		/**
		 * Returns the id of the control/element to which the given DOM
		 * reference belongs to or <code>null</code> if no such
		 * control/element exists.
		 *
		 * @param {Element} oDOM the DOM reference
		 * @returns {string} Id of the control or null
		 * @private
		 */
		var getControlIdForDOM = function(oDOM){
			var sId = jQuery(oDOM).closest("[data-sap-ui]").attr("id");
			if(sId) {
				return sId;
			}
			return null;
		};
	
		/**
		 * Calls the onsapfocusleave function on the control with id sControlId
		 * with the information about the given related control.
		 *
		 * @param {string} sControlId
		 * @param {string} sRelatedControlId
		 * @private
		 */
		var triggerFocusleave = function(sControlId, sRelatedControlId, oCore){
			var oControl = sControlId ? sap.ui.getCore().byId(sControlId) : null;
			if(oControl){
				var oRelatedControl = sRelatedControlId ? sap.ui.getCore().byId(sRelatedControlId) : null;
				var oEvent = jQuery.Event("sapfocusleave");
				oEvent.target = oControl.getDomRef();
				oEvent.relatedControlId = oRelatedControl ? oRelatedControl.getId() : null;
				oEvent.relatedControlFocusInfo = oRelatedControl ? oRelatedControl.getFocusInfo() : null;
				//TODO: Cleanup the popup! The following is shit
				var oControlUIArea = oControl.getUIArea();
				var oUiArea = null;
				if(oControlUIArea){
					oUiArea = oCore.getUIArea(oControlUIArea.getId());
				}else{
					var oPopupUIAreaDomRef = sap.ui.getCore().getStaticAreaRef();
					if(jQuery.sap.containsOrEquals(oPopupUIAreaDomRef, oEvent.target)){
						oUiArea = oCore.getUIArea(oPopupUIAreaDomRef.id);
					}
				}
				if(oUiArea) {
					oUiArea._handleEvent(oEvent);
				}
			}
		};
	
		/*
		 * Checks if the passed DOM reference is nested in the active DOM of the document
		 * @param {Element} oDomRef The new active element
		 * @private
		 * @type boolean
		 * @returns {boolean} whether the passed DOM reference is nested in the active DOM of the document
		 */
		/*function isInActiveDom(oDomRef) {
			jQuery.sap.assert(oDomRef != null);
			var oCurrDomRef = oDomRef;
			while(oCurrDomRef) {
				if(oCurrDomRef === document) return true;
				oCurrDomRef = oCurrDomRef.parentNode;
			}
			return false;
		};*/
	
	

	return FocusHandler;

}, /* bExport= */ true);

}; // end of sap/ui/core/FocusHandler.js
if ( !jQuery.sap.isDeclared('sap.ui.core.RenderManager') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides the render manager sap.ui.core.RenderManager
jQuery.sap.declare('sap.ui.core.RenderManager'); // unresolved dependency added by SAPUI5 CreateModule Ant-Task
if ( !jQuery.sap.isDeclared('jquery.sap.encoder') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides encoding functions for JavaScript.
jQuery.sap.declare('jquery.sap.encoder'); // unresolved dependency added by SAPUI5 CreateModule Ant-Task
sap.ui.define("jquery.sap.encoder",['jquery.sap.global'],
	function(jQuery) {
	"use strict";

	/*
	 * Encoding according to the Secure Programming Guide
	 * https://wiki.wdf.sap.corp/wiki/display/NWCUIAMSIM/XSS+Secure+Programming+Guide
	 */

	/**
	 * Create hex and pad to length
	 * @private
	 */
	function hex(iChar, iLength) {
		var sHex = iChar.toString(16);
		if (iLength) {
			while (iLength > sHex.length) {
				sHex = "0" + sHex;
			}
		}
		return sHex;
	}

	/**
	 * RegExp and escape function for HTML escaping
	 */
	var rHtml = /[\x00-\x2b\x2f\x3a-\x40\x5b-\x5e\x60\x7b-\xff\u2028\u2029]/g,
		rHtmlReplace = /[\x00-\x08\x0b\x0c\x0e-\x1f\x7f-\x9f]/,
		mHtmlLookup = {
			"<": "&lt;",
			">": "&gt;",
			"&": "&amp;",
			"\"": "&quot;"
		};

	var fHtml = function(sChar) {
		var sEncoded = mHtmlLookup[sChar];
		if (!sEncoded) {
			if (rHtmlReplace.test(sChar)) {
				sEncoded = "&#xfffd;";
			}
			else {
				sEncoded = "&#x" + hex(sChar.charCodeAt(0)) + ";";
			}
			mHtmlLookup[sChar] = sEncoded;
		}
		return sEncoded;
	};

	/**
	 * Encode the string for inclusion into HTML content/attribute
	 *
	 * @param {string} sString The string to be escaped
	 * @return The escaped string
	 * @type {string}
	 * @public
	 * @SecValidate {0|return|XSS} validates the given string for HTML contexts
	 */
	jQuery.sap.encodeHTML = function(sString) {
		return sString.replace(rHtml, fHtml);
	};

	/**
	 * Encode the string for inclusion into XML content/attribute
	 *
	 * @param {string} sString The string to be escaped
	 * @return The escaped string
	 * @type {string}
	 * @public
	 * @SecValidate {0|return|XSS} validates the given string for XML contexts
	 */
	jQuery.sap.encodeXML = function(sString) {
		return sString.replace(rHtml, fHtml);
	};

	/**
	 * Encode the string for inclusion into HTML content/attribute.
	 * Old name "escapeHTML" kept for backward compatibility
	 *
	 * @param {string} sString The string to be escaped
	 * @return The escaped string
	 * @type {string}
	 * @public
	 * @deprecated Has been renamed, use {@link jQuery.sap.encodeHTML} instead.
	 */
	jQuery.sap.escapeHTML = function(sString) {
		return sString.replace(rHtml, fHtml);
	};

	/**
	 * RegExp and escape function for JS escaping
	 */
	var rJS = /[\x00-\x2b\x2d\x2f\x3a-\x40\x5b-\x5e\x60\x7b-\xff\u2028\u2029]/g,
		mJSLookup = {};

	var fJS = function(sChar) {
		var sEncoded = mJSLookup[sChar];
		if (!sEncoded) {
			var iChar = sChar.charCodeAt(0);
			if (iChar < 256) {
				sEncoded = "\\x" + hex(iChar, 2);
			}
			else {
				sEncoded = "\\u" + hex(iChar, 4);
			}
			mJSLookup[sChar] = sEncoded;
		}
		return sEncoded;
	};

	/**
	 * Encode the string for inclusion into a JS string literal
	 *
	 * @param {string} sString The string to be escaped
	 * @return The escaped string
	 * @type {string}
	 * @public
	 * @SecValidate {0|return|XSS} validates the given string for a JavaScript contexts
	 */
	jQuery.sap.encodeJS = function(sString) {
		return sString.replace(rJS, fJS);
	};

	/**
	 * Encode the string for inclusion into a JS string literal.
	 * Old name "escapeJS" kept for backward compatibility
	 *
	 * @param {string} sString The string to be escaped
	 * @return The escaped string
	 * @type {string}
	 * @public
	 * @deprecated Since 1.3.0. Has been renamed, use {@link jQuery.sap.encodeJS} instead.
	 */
	jQuery.sap.escapeJS = function(sString) {
		return sString.replace(rJS, fJS);
	};

	/**
	 * RegExp and escape function for URL escaping
	 */
	var rURL = /[\x00-\x2c\x2f\x3a-\x40\x5b-\x5e\x60\x7b-\uffff]/g,
		mURLLookup = {};

	var fURL = function(sChar) {
		var sEncoded = mURLLookup[sChar];
		if (!sEncoded) {
			var iChar = sChar.charCodeAt(0);
			if (iChar < 128) {
				sEncoded = "%" + hex(iChar, 2);
			}
			else if (iChar < 2048) {
				sEncoded = "%" + hex((iChar >> 6) | 192, 2) +
						   "%" + hex((iChar & 63) | 128, 2);
			}
			else {
				sEncoded = "%" + hex((iChar >> 12) | 224, 2) +
						   "%" + hex(((iChar >> 6) & 63) | 128, 2) +
						   "%" + hex((iChar & 63) | 128, 2);
			}
			mURLLookup[sChar] = sEncoded;
		}
		return sEncoded;
	};

	/**
	 * Encode the string for inclusion into an URL parameter
	 *
	 * @param {string} sString The string to be escaped
	 * @return The escaped string
	 * @type {string}
	 * @public
	 * @SecValidate {0|return|XSS} validates the given string for a URL context
	 */
	jQuery.sap.encodeURL = function(sString) {
		return sString.replace(rURL, fURL);
	};

	/**
	 * RegExp and escape function for CSS escaping
	 */
	var rCSS = /[\x00-\x2f\x3a-\x40\x5b-\x60\x7b-\xff\u2028\u2029][0-9A-Fa-f]?/g;

	var fCSS = function(sChar) {
		var iChar = sChar.charCodeAt(0);
		if (sChar.length == 1) {
			return "\\" + hex(iChar);
		}
		else {
			return "\\" + hex(iChar) + " " + sChar.substr(1);
		}
	};

	/**
	 * Encode the string for inclusion into CSS string literals or identifiers
	 *
	 * @param {string} sString The string to be escaped
	 * @return The escaped string
	 * @type {string}
	 * @public
	 * @SecValidate {0|return|XSS} validates the given string for a CSS context
	 */
	jQuery.sap.encodeCSS = function(sString) {
		return sString.replace(rCSS, fCSS);
	};

	/**
	 * WhitelistEntry object
	 * @param {string} protocol The protocol of the URL
	 * @param {string} host The host of the URL
	 * @param {string} port The port of the URL
	 * @param {string} path the path of the URL
	 * @public
	 */
	function WhitelistEntry(protocol, host, port, path){
		if (protocol) {
			this.protocol = protocol.toUpperCase();
		}
		if (host) {
			this.host = host.toUpperCase();
		}
		this.port = port;
		this.path = path;
	}

	var aWhitelist = new Array();

	/**
	 * clears the whitelist for URL valiadtion
	 *
	 * @public
	 */
	jQuery.sap.clearUrlWhitelist = function() {

		aWhitelist.splice(0,aWhitelist.length);

	};

	/**
	 * Adds a whitelist entry for URL valiadtion
	 *
	 * @param {string} protocol The protocol of the URL
	 * @param {string} host The host of the URL
	 * @param {string} port The port of the URL
	 * @param {string} path the path of the URL
	 * @public
	 */
	jQuery.sap.addUrlWhitelist = function(protocol, host, port, path) {
		var oEntry = new WhitelistEntry(protocol, host, port, path);
		var iIndex = aWhitelist.length;
		aWhitelist[iIndex] = oEntry;
	};

	/**
	 * Removes a whitelist entry for URL valiadtion
	 *
	 * @param {int} iIndex index of entry
	 * @public
	 */
	jQuery.sap.removeUrlWhitelist = function(iIndex) {
		aWhitelist.splice(iIndex,1)
	};

	/**
	 * Gets the whitelist for URL valiadtion
	 *
	 * @return {string[]} whitelist
	 * @public
	 */
	jQuery.sap.getUrlWhitelist = function() {
		return aWhitelist.slice();
	};

	/**
	 * Validates an URL. Check if it's not a script or other security issue.
	 *
	 * @param {string} sUrl
	 * @return true if valid, false if not valid
	 * @public
	 */
	jQuery.sap.validateUrl = function(sUrl) {

		var result = /(?:([^:\/?#]+):)?(?:\/\/([^\/?#:]*)(?::([0-9]+))?)?([^?#]*)(?:\?([^#]*))?(?:#(.*))?/.exec(sUrl);
		if (!result) {
			return result;
		}

		var sProtocol = result[1],
			sHost = result[2],
			sPort = result[3],
			sPath = result[4],
			sQuery = result[5],
			sHash = result[6];

		var rCheck = /[\x00-\x24\x26-\x29\x2b\x2c\x2f\x3a-\x40\x5b-\x5e\x60\x7b-\x7d\x7f-\uffff]/;
		var rCheckMail = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;

		// protocol
		if (sProtocol) {
			sProtocol = sProtocol.toUpperCase();
			if (aWhitelist.length <= 0) {
				// no whitelist -> check for default protocols
				if (!/^(https?|ftp)/i.test(sProtocol)) {
					return false;
				}
			}
		}

		// Host -> whitelist + character check (TBD)
		if (sHost) {
			sHost = sHost.toUpperCase();
		}

		// Path -> split for "/" and check if forbidden characters exist
		if (sPath) {
			if (sProtocol === "MAILTO") {
				var bCheck = rCheckMail.test(sPath);
				if (!bCheck) {
					return false;
				}
			} else {
				var aComponents = sPath.split("/");
				for ( var i = 0; i < aComponents.length; i++) {
					var bCheck = rCheck.test(aComponents[i]);
					if (bCheck) {
						// forbidden character found
						return false;
					}
				}
			}
		}

		// query -> Split on & and = and check if forbidden characters exist
		if (sQuery) {
			var aComponents = sQuery.split("&");
			for ( var i = 0; i < aComponents.length; i++) {
				var iPos = aComponents[i].search("=");
				if (iPos != -1) {
					var sPart1 = aComponents[i].substring(0,iPos);
					var sPart2 = aComponents[i].substring(iPos+1);
					var bCheck1 = rCheck.test(sPart1);
					var bCheck2 = rCheck.test(sPart2);
					if (bCheck1 || bCheck2) {
						// forbidden character found
						return false;
					}
				}
			}
		}

		// hash
		if (sHash) {
			if (rCheck.test(sHash)) {
				// forbidden character found
				return false;
			}
		}

		//filter whitelist
		if (aWhitelist.length > 0) {
			var bFound = false;
			for(var i=0; i<aWhitelist.length; i++){
				jQuery.sap.assert(aWhitelist[i] instanceof WhitelistEntry, "whitelist entry type wrong");
				if (!sProtocol || !aWhitelist[i].protocol || sProtocol == aWhitelist[i].protocol) {
					// protocol OK
					var bOk = false;
					if (sHost && aWhitelist[i].host && /^\*/.test(aWhitelist[i].host)) {
						// check for wildcard search at begin
						var sHostEscaped = aWhitelist[i].host.slice(1).replace(/[-[\]{}()*+?.,\\^$|#\s]/g, "\\$&");
						var rFilter = RegExp(sHostEscaped + "$");
						if (rFilter.test(sHost)) {
							bOk = true;
						}
					}else if (!sHost || !aWhitelist[i].host || sHost == aWhitelist[i].host){
						bOk = true;
					}
					if (bOk){
						// host OK
						if ((!sHost && !sPort) || !aWhitelist[i].port || sPort == aWhitelist[i].port) {
							// port OK
							if (aWhitelist[i].path && /\*$/.test(aWhitelist[i].path)) {
								// check for wildcard search at end
								var sPathEscaped = aWhitelist[i].path.slice(0,-1).replace(/[-[\]{}()*+?.,\\^$|#\s]/g, "\\$&");
								var rFilter = RegExp("^"+sPathEscaped);
								if (rFilter.test(sPath)) {
									bFound = true;
								}
							} else if (!aWhitelist[i].path || sPath == aWhitelist[i].path) {
								// path OK
								bFound = true;
							}
						}
					}
				}
				if (bFound) {
					break;
				}
			}
			if (!bFound) {
				return false;
			}
		}

		return true;
	};

	/**
	 * Strips unsafe tags and attributes from HTML.
	 * 
	 * @param {string} sHTML the HTML to be sanitized. 
	 * @param {object} [mOptions={}] options for the sanitizer
	 * @return {string} sanitized HTML
	 * @private
	 */
	jQuery.sap._sanitizeHTML = function(sHTML, mOptions) {
		return fnSanitizer(sHTML, mOptions || {
			uriRewriter: function(sUrl) {
				// by default we use the URL whitelist to check the URL's 
				if (jQuery.sap.validateUrl(sUrl)) {
					return sUrl;
				}
			} 
		});
	};
	
	/**
	 * Registers an application defined sanitizer to be used instead of the built-in one.
	 * 
	 * The given sanitizer function must have the same signature as 
	 * {@link jQuery.sap._sanitizeHTML}:
	 * 
	 * <pre>
	 *   function sanitizer(sHtml, mOptions);
	 * </pre>
	 * 
	 * The parameter <code>mOptions</code> will always be provided, but might be empty. 
	 * The set of understood options is defined by the sanitizer. If no specific 
	 * options are given, the sanitizer should run with the most secure settings.
	 * Sanitizers should ignore unknown settings. Known, but misconfigured settings should be 
	 * reported as error.
	 *  
	 * @param {function} fnSanitizer
	 * @private
	 */
	jQuery.sap._setHTMLSanitizer = function (fnSanitizer) {
		jQuery.sap.assert(typeof fnSanitizer === "function", "Sanitizer must be a function");
		fnSanitizer = fnSanitizer || defaultSanitizer;
	};

	function defaultSanitizer(sHTML, mOptions) {
		if ( !window.html || !window.html.sanitize ) {
			jQuery.sap.require("sap.ui.thirdparty.caja-html-sanitizer");
			jQuery.sap.assert(window.html && window.html.sanitize, "Sanitizer should have been loaded");
		}
		
		var oTagPolicy = mOptions.tagPolicy || window.html.makeTagPolicy(mOptions.uriRewriter, mOptions.tokenPolicy);
		return window.html.sanitizeWithPolicy(sHTML, oTagPolicy);
	}
	
	/**
	 * Globally configured sanitizer.
	 * @private
	 */
	var fnSanitizer = defaultSanitizer;

	return jQuery;

}, /* bExport= */ false);

}; // end of jquery.sap.encoder.js
sap.ui.define("sap/ui/core/RenderManager",['jquery.sap.global', 'sap/ui/base/Interface', 'sap/ui/base/Object', 'jquery.sap.act', 'jquery.sap.encoder'],
	function(jQuery, Interface, BaseObject/* , jQuerySap1, jQuerySap */) {
	"use strict";

	var aCommonMethods = ["renderControl", "write", "writeEscaped", "translate", "writeAcceleratorKey", "writeControlData",
						  "writeElementData", "writeAttribute", "writeAttributeEscaped", "addClass", "writeClasses",
						  "addStyle", "writeStyles", "writeAccessibilityState", "writeIcon",
						  "getConfiguration", "getHTML"];
	var aNonRendererMethods = ["render", "flush", "destroy"];
	
	/**
	 * Creates an instance of the RenderManager.
	 *
	 * @class RenderManager that will take care for rendering Controls.
	 *
	 * The RenderManager will be available from the sap.ui.core.Core instance (available via <code>sap.ui.getCore()</code>).<br/>It
	 * can be used to render Controls and Control-Trees.
	 *
	 * The convention for renderers belonging to some controls is the following:
	 * <ul>
	 * <li>for a Control e.g. <code>sap.ui.controls.InputField</code> there shall be </li>
	 * <li>a renderer named <code>sap.ui.controls.InputFieldRenderer</code></li>
	 * <ul>
	 *
	 * @see sap.ui.core.Core
	 * @see sap.ui.getCore()
	 *
	 * @extends sap.ui.base.Object
	 * @author Jens Pflueger
	 * @version 1.20.6
	 * @constructor
	 * @name sap.ui.core.RenderManager
	 * @public
	 */
	var RenderManager = BaseObject.extend("sap.ui.core.RenderManager", /** @lends sap.ui.core.RenderManager */ {

		constructor : function() {
			BaseObject.apply(this, arguments);
			this.aBuffer = [];
			this.aRenderedControls = [];
			this.aStyleStack = [{}];
		},

		metadata : {
			publicMethods : aCommonMethods.concat(aNonRendererMethods)
		}

	});

	/**
	 * Returns the public interface of the RenderManager which can be used by Renderers.
	 *
	 * @return {sap.ui.base.Interface} the interface
	 * @private
	 * @name sap.ui.core.RenderManager#getRendererInterface
	 * @function
	 */
	RenderManager.prototype.getRendererInterface = function() {
		// see sap.ui.base.Object.getInterface for reference
		var oInterface = new Interface(this, aCommonMethods);
		this.getRendererInterface = jQuery.sap.getter(oInterface);
		return oInterface;
	};
	
	/**
	 * Cleans up the resources associated with this instance.
	 * After the instance has been destroyed, it must not be used anymore.
	 * Applications should call this function if they don't need the instance any longer.
	 *
	 * @public
	 * @name sap.ui.core.RenderManager#destroy
	 * @function
	 */
	RenderManager.prototype.destroy = function() {
		this.aBuffer = [];
		this.aRenderedControls = [];
		this.aStyleStack = [{}];
	};
	
	/**
	 * Returns the configuration object
	 * Shortcut for <code>sap.ui.getCore().getConfiguration()</code>
	 * @return {sap.ui.core.Configuration} the configuration object
	 * @public
	 * @name sap.ui.core.RenderManager#getConfiguration
	 * @function
	 */
	RenderManager.prototype.getConfiguration = function() {
		return sap.ui.getCore().getConfiguration();
	};
	
	/**
	 * Returns the renderer class for a given control instance
	 *
	 * @param {sap.ui.core.Control} oControl the control that should be rendered
	 * @return the renderer class for a given control instance
	 * @public
	 * @name sap.ui.core.RenderManager#getRenderer
	 * @function
	 */
	RenderManager.prototype.getRenderer = function(oControl) {
		jQuery.sap.assert(oControl && oControl instanceof sap.ui.core.Control, "oControl must be a sap.ui.core.Control");
		return RenderManager.getRenderer(oControl);
	};
	
	/**
	 * Turns the given control into its HTML representation and appends it to the
	 * rendering buffer.
	 *
	 * If the given control is undefined or null, then nothing is rendered.
	 *
	 * @param {sap.ui.core.Control} oControl the control that should be rendered
	 * @public
	 * @name sap.ui.core.RenderManager#renderControl
	 * @function
	 */
	RenderManager.prototype.renderControl = function(oControl) {
		jQuery.sap.assert(!oControl || oControl instanceof sap.ui.core.Control, "oControl must be a sap.ui.core.Control or empty");
		// don't render a NOTHING
		if (!oControl) {
			return;
		}
	
		// create stack to determine rendered parent
		if (!this.aRenderStack) {
			this.aRenderStack = new Array();
		}
		// stop the measurement of parent
		if (this.aRenderStack && this.aRenderStack.length > 0) {
			jQuery.sap.measure.pause(this.aRenderStack[0]+"---renderControl");
		}else if(oControl.getParent() && oControl.getParent().getMetadata().getName() == "sap.ui.core.UIArea"){
			jQuery.sap.measure.pause(oControl.getParent().getId()+"---rerender");
		}
		this.aRenderStack.unshift(oControl.getId());
		// start performance measurement
		jQuery.sap.measure.start(oControl.getId()+"---renderControl","Rendering of "+oControl.getMetadata().getName());
	
		//Remember the current buffer size to check later whether the control produced output
		var iBufferLength = this.aBuffer.length;
	
		var oControlStyles = {};
		if (oControl.aCustomStyleClasses && oControl.aCustomStyleClasses.length > 0) {
			oControlStyles.aCustomStyleClasses = oControl.aCustomStyleClasses; //cleared again in the writeClasses function
		}
	
		this.aStyleStack.push(oControlStyles);
	
		jQuery.sap.measure.pause(oControl.getId()+"---renderControl"); 
		// don't measure getRenderer because if Load needed its measured in Ajax call
		// but start measurement before is to see general rendering time including loading time
		var oRenderer = this.getRenderer(oControl);
		jQuery.sap.measure.resume(oControl.getId()+"---renderControl");
	
		// notify the control that it will be rendered soon (e.g. detached from DOM)
		this._bLocked = true;
		try {
			var oEvent = jQuery.Event("BeforeRendering");
			// store the element on the event (aligned with jQuery syntax)
			oEvent.srcControl = oControl;
			oControl._handleEvent(oEvent);
		} finally {
			this._bLocked = false;
		}
		// unbind any generically bound browser event handlers
		var aBindings = oControl.aBindParameters;
		if (aBindings && aBindings.length > 0) { // if we have stored bind calls...
			var jDomRef = jQuery(oControl.getDomRef());
			if (jDomRef && jDomRef[0]) { // ...and we have a DomRef
				for (var i = 0; i < aBindings.length; i++) {
					var oParams = aBindings[i];
					jDomRef.unbind(oParams.sEventType, oParams.fnProxy);
				}
			}
		}
	
		//Render the control using the RenderManager interface
		oRenderer.render(this.getRendererInterface(), oControl);
	
		this.aStyleStack.pop();
	
		//Remember the rendered control
		this.aRenderedControls.push(oControl);
	
		//Check whether the control has produced HTML
		oControl.bOutput = this.aBuffer.length != iBufferLength;
	
		// end performance measurement
		jQuery.sap.measure.end(oControl.getId()+"---renderControl");
		this.aRenderStack.shift();
		// resume the measurement of parent
		if (this.aRenderStack && this.aRenderStack.length > 0) {
			jQuery.sap.measure.resume(this.aRenderStack[0]+"---renderControl");
		}else if(oControl.getParent() && oControl.getParent().getMetadata().getName() == "sap.ui.core.UIArea"){
			jQuery.sap.measure.resume(oControl.getParent().getId()+"---rerender");
		}
	};
	
	/**
	 * Renders the given {@link sap.ui.core.Control} and finally returns
	 * the content of the rendering buffer.
	 * Ensures the buffer is restored to the state before calling this method.
	 *
	 * @param {sap.ui.core.Control}
	 *            oControl the Control whose HTML should be returned.
	 * @return {string} the resulting HTML of the provided control
	 * @deprecated Since version 0.15.0. Use <code>flush()</code> instead render content outside the rendering phase.
	 * @public
	 * @name sap.ui.core.RenderManager#getHTML
	 * @function
	 */
	RenderManager.prototype.getHTML = function(oControl) {
		jQuery.sap.assert(oControl && oControl instanceof sap.ui.core.Control, "oControl must be a sap.ui.core.Control");
	
		var tmp = this.aBuffer;
		var aResult = this.aBuffer = [];
		this.renderControl(oControl);
		this.aBuffer = tmp;
		return aResult.join("");
	};
	
	(function() {
	
		//Returns the information of the current focus
		var storeCurrentFocus = function(){
			var oCore = sap.ui.getCore();
	
			// Store current focus
			var sFocusedControlId = oCore.getCurrentFocusedControlId(),
				oFocusInfo = null,
				oFocusedDomRef = null;
	
			if(sFocusedControlId){
				var oFocusedControl = oCore.getElementById(sFocusedControlId);
				if(oFocusedControl){
					oFocusInfo = oFocusedControl.getFocusInfo();
					oFocusedDomRef = oFocusedControl.getFocusDomRef();
				}
			}
	
			return {focusedControlId: sFocusedControlId, focusInfo: oFocusInfo, focusDomRef: oFocusedDomRef};
		};
	
		//Does everything needed after the rendering (restore focus, calling "onAfterRendering", initialize event binding)
		var finalizeRendering = function(oRM, aRenderedControls, oStoredFocusInfo){
			// Notify the behavior object that the controls will be attached to DOM
			for (var i = 0, size = aRenderedControls.length; i < size; i++) {
				var oControl = aRenderedControls[i];
				if (oControl.bOutput) {
					oRM._bLocked = true;
					try {
						var oEvent = jQuery.Event("AfterRendering");
						// store the element on the event (aligned with jQuery syntax)
						oEvent.srcControl = oControl;
						// start performance measurement
						jQuery.sap.measure.start(oControl.getId()+"---AfterRendering","AfterRendering of "+oControl.getMetadata().getName());
						oControl._handleEvent(oEvent);
						// end performance measurement
						jQuery.sap.measure.end(oControl.getId()+"---AfterRendering");
					} finally {
						oRM._bLocked = false;
					} 
				}
			}
	
			//finally restore focus
			try{
				if (oStoredFocusInfo && oStoredFocusInfo.focusedControlId) {
					var oFocusedControl = sap.ui.getCore().getElementById(oStoredFocusInfo.focusedControlId);
					if (oFocusedControl && oFocusedControl.getFocusDomRef() != oStoredFocusInfo.focusDomRef ) {
						oFocusedControl.applyFocusInfo(oStoredFocusInfo.focusInfo);
					}
				}
			}catch(e){
				jQuery.sap.log.warning("Problems while restore focus after rendering: " + e, null, oRM);
			}
	
			// Re-bind any generically bound browser event handlers (must happen after restoring focus to avoid focus event)
			for (var i = 0, size = aRenderedControls.length; i < size; i++) {
				var oControl = aRenderedControls[i],
					aBindings = oControl.aBindParameters;
	
				if (aBindings && aBindings.length > 0) { // if we have stored bind calls...
					var jDomRef = jQuery(oControl.getDomRef());
					if (jDomRef && jDomRef[0]) { // ...and we have a DomRef - TODO: this check should not be required right after rendering...
						for (var j = 0; j < aBindings.length; j++) {
							var oParams = aBindings[j];
							jDomRef.bind(oParams.sEventType, oParams.fnProxy);
						}
					}
				}
			}
		};
	
		/**
		 * Renders the content of the rendering buffer into the provided DOMNode.
		 *
		 * This function must not be called within control renderers.
		 *
		 * Usage:
		 * <pre>
		 * // Create a new instance of the RenderManager
		 * var rm = sap.ui.getCore().createRenderManager();
		 * // Use the writer API to fill the buffers
		 * rm.write(...);
		 * rm.renderControl(oControl);
		 * rm.write(...);
		 * ...
		 * // Finally flush the buffer into the provided DOM node (The current content is removed)
		 * rm.flush(oDomNode);
		 * // If the instance is not needed anymore, destroy it
		 * rm.destroy();
		 * </pre>
		 *
		 * @param {Element} oTargetDomNode The node in the dom where the buffer should be flushed into.
		 * @param {boolean} bDoNotPreserve flag, whether to not preserve (true) the content or to preserve it (false).
		 * @param {boolean|int} vInsert flag, whether to append (true) or replace (false) the buffer of the target dom node or to insert at a certain position (int)
		 * @public
		 * @name sap.ui.core.RenderManager#flush
		 * @function
		 */
		RenderManager.prototype.flush = function(oTargetDomNode, bDoNotPreserve, vInsert) {
			jQuery.sap.assert((typeof oTargetDomNode === "object") && (oTargetDomNode.ownerDocument == document), "oTargetDomNode must be a DOM element");
			if(this.bRendererMode){
				jQuery.sap.log.info("Flush must not be called from control renderers. Call ignored.", null, this);
				return;
			}
			
			// preserve HTML content before flushing HTML into target DOM node
			if (!bDoNotPreserve && (typeof vInsert !== "number") && !vInsert) { // expression mimics the conditions used below
				RenderManager.preserveContent(oTargetDomNode);
			}
	
			var oStoredFocusInfo = storeCurrentFocus();
	
			var vHTML = RenderManager.prepareHTML5(this.aBuffer.join("")); // Note: string might have been converted to a node list!
	
			if(this._fPutIntoDom){
				//Case when render function was called
				this._fPutIntoDom(oTargetDomNode, vHTML);
			}else{
				for(var i=0; i<this.aRenderedControls.length; i++){
					//TODO It would be enough to loop over the controls for which renderControl was initially called but for this
					//we have to manage an additional array. Rethink about later.
					var oldDomNode = this.aRenderedControls[i].getDomRef();
					if(oldDomNode && !RenderManager.isPreservedContent(oldDomNode)) {
						if (RenderManager.isInlineTemplate(oldDomNode)) {
							jQuery(oldDomNode).empty();
						} else {
							jQuery(oldDomNode).remove();
						}
					}
				}
				if (typeof vInsert === "number") {
					if (vInsert <= 0) { // new HTML should be inserted at the beginning
						jQuery(oTargetDomNode).prepend(vHTML);
					} else { // new element should be inserted at a certain position > 0
						var $predecessor = jQuery(oTargetDomNode).children().eq(vInsert - 1); // find the element which should be directly before the new one
						if ($predecessor.length === 1) { 
							// element found - put the HTML in after this element
							$predecessor.after(vHTML);
						} else { 
							// element not found (this should not happen when properly used), append the new HTML
							jQuery(oTargetDomNode).append(vHTML);
						}
					}
				} else if (!vInsert) {
					jQuery(oTargetDomNode).html(vHTML); // Put the HTML into the given DOM Node
				} else {
					jQuery(oTargetDomNode).append(vHTML); // Append the HTML into the given DOM Node
				}
			}
			
			finalizeRendering(this, this.aRenderedControls, oStoredFocusInfo);
	
			this.aRenderedControls = [];
			this.aBuffer = [];
			this.aStyleStack = [{}];
			
			jQuery.sap.act.refresh();
		};
	
		/**
		 * Renders the given control to the provided DOMNode.
		 *
		 * If to control is already rendered in the provided DOMNode the DOM of the control is replaced. If the control
		 * is already rendered somewhere else the current DOM of the control is removed and the new DOM is appended
		 * to the provided DOMNode.
		 *
		 * This function must not be called within control renderers.
		 *
		 * @param {sap.ui.core.Control} oControl the Control that should be rendered.
		 * @param {Element} oTargetDomNode The node in the dom where the result of the rendering should be inserted.
		 * @public
		 * @name sap.ui.core.RenderManager#render
		 * @function
		 */
		RenderManager.prototype.render = function(oControl, oTargetDomNode) {
			jQuery.sap.assert(oControl && oControl instanceof sap.ui.core.Control, "oControl must be a control");
			jQuery.sap.assert(typeof oTargetDomNode === "object" && oTargetDomNode.ownerDocument == document, "oTargetDomNode must be a DOM element");
			if(this.bRendererMode){
				jQuery.sap.log.info("Render must not be called from control renderers. Call ignored.", null, this);
				return;
			}
			if(this._bLocked){
				jQuery.sap.log.error("Render must not be called within Before or After Rendering Phase. Call ignored.", null, this);
				return;
			}
	
			// Reset the buffer before rendering
			this.aBuffer = [];
	
			// Retrieve the markup (the rendering phase)
			this.renderControl(oControl);
	
			// FIXME: MULTIPLE ROOTS
			// The implementation of this method doesn't support multiple roots for a control.
			// Affects all places where 'oldDomNode' is used
			this._fPutIntoDom = function(oTarget, vHTML){
	
				if(oControl && oTargetDomNode){
	
					var oldDomNode = oControl.getDomRef();
					if ( RenderManager.isPreservedContent(oldDomNode) ) {
						// use placeholder instead
						oldDomNode = jQuery.sap.byId("sap-ui-dummy-" + oControl.getId())[0] || oldDomNode;
					}
					var bNewTarget = oldDomNode && oldDomNode.parentNode != oTargetDomNode;
	
					var fAppend = function(){
						var jTarget = jQuery(oTargetDomNode);
						if(oTargetDomNode.innerHTML == ""){
							jTarget.html(vHTML);
						}else{
							jTarget.append(vHTML);
						}
					};
	
					if(bNewTarget){ //Control was rendered already and is now moved to different location
	
						if(!RenderManager.isPreservedContent(oldDomNode)) {
							if (RenderManager.isInlineTemplate(oldDomNode)) {
								jQuery(oldDomNode).empty();
							} else {
								jQuery(oldDomNode).remove();
							}
						}
	
						if(vHTML) {
							fAppend();
						}
	
					}else{ //Control either rendered initially or rerendered at the same location
	
						if(vHTML){
							if(oldDomNode){
								if (RenderManager.isInlineTemplate(oldDomNode)) {
									jQuery(oldDomNode).html(vHTML);
								} else {
									jQuery(oldDomNode).replaceWith(vHTML);
								}
							}else{
								fAppend();
							}
						}else{
							if (RenderManager.isInlineTemplate(oldDomNode)) {
								jQuery(oldDomNode).empty();
							} else {
								// give parent control a chance to handle emptied children properly (e.g. XMLView)
								if ( !oControl.getParent() 
										 || !oControl.getParent()._onChildRerenderedEmpty 
										 || !oControl.getParent()._onChildRerenderedEmpty(oControl, oldDomNode) ) {
									jQuery(oldDomNode).remove();
								}
							}

						}
	
					}
	
				}
	
			};
	
			this.flush(oTargetDomNode, true);
	
			this._fPutIntoDom = null;
		};
	
	}());
	
	
	//#################################################################################################
	// Static Methods
	//#################################################################################################
	
	/**
	 * Returns the renderer class for a given control instance
	 *
	 * @param {sap.ui.core.Control}
	 *            oControl the control that should be rendered
	 * @type function
	 * @return the renderer class for a given control instance
	 * @static
	 * @public
	 * @name sap.ui.core.RenderManager.getRenderer
	 * @function
	 */
	RenderManager.getRenderer = function(oControl) {
		jQuery.sap.assert(oControl && oControl instanceof sap.ui.core.Control, "oControl must be a sap.ui.core.Control");
	
		return oControl.getMetadata().getRenderer();
	};
	
	/**
	 * Makes the HTML5 tags known to older IE browsers; to be called once before rendering happens.
	 *
	 * Applies two workarounds
	 * <ol>
	 * <li>1. "SHIV": create each HTML5 tag once in the window document to make IE8 aware of it
	 * <li>2. "INNERSHIV": IE8 fails when using innerHTML in conjunction with HTML5 tags for a DOM element __not__ part of the document.
	 *        prepareHTML5 uses a dummy DOM element to convert the innerHTML to a set of DOM nodes first.
	 * </ol>
	 * @static
	 * @private
	 */
	//Called once by the Core during initialization
	RenderManager.initHTML5Support = function() {
		if(!!sap.ui.Device.browser.internet_explorer && (sap.ui.Device.browser.version === 8 || sap.ui.Device.browser.version === 7)){ // IE8 is recognized as "7.0"!!
	
			var aTags = [ "article", "aside", "audio", "canvas", "command", "datalist", "details",
					"figcaption", "figure", "footer", "header", "hgroup", "keygen", "mark", "meter", "nav",
					"output", "progress", "rp", "rt", "ruby", "section", "source", "summary", "template", "time", "video", "wbr" ];
	
			// 1. SHIV, create each HTML5 element once to make IE8 recognize it
			// see http://paulirish.com/2011/the-history-of-the-html5-shiv/ for an explanation
			for (var i = 0; i < aTags.length; i++) {
				document.createElement(aTags[i]);
			}
	
			// 2. INNERSHIV, converts string with HTML5 tags to DOM nodes before using them with jQuery
			// see http://jdbartlett.com/innershiv/ for an explanation of the matter
			var rhtmltags = new RegExp("<(" + aTags.join("|") + ")(\\s|>)", "i");
			var d = null;
			RenderManager.prepareHTML5 = function(sHTML) {
				if ( sHTML && sHTML.match(rhtmltags) ) {
					if(!d){
						d = document.createElement('div');
						d.style.display = 'none';
					}
	
					var e = d.cloneNode(true);
					document.body.appendChild(e);
					e.innerHTML = sHTML.replace(/^\s\s*/, '').replace(/\s\s*$/, '');
					document.body.removeChild(e);
	
					return e.childNodes;
				}
				return sHTML;
			};
	
			jQuery.sap.log.info("IE8 HTML5 support activated");
	
		}else{
	
			jQuery.sap.log.info("no IE8 HTML5 support required");
	
			RenderManager.prepareHTML5 = function(sHTML) {
				return sHTML;
			};
		}
	};
	
	/**
	 * Helper to enforce a repaint for a given dom node.
	 * 
	 * Introduced to fix repaint issues in Webkit browsers, esp. Chrome.
	 * @param {Element} vDomNode a DOM node or ID of a DOM node
	 * 
	 * @private
	 * @name sap.ui.core.RenderManager.forceRepaint
	 * @function
	 */
	RenderManager.forceRepaint = function(vDomNode) {
		var oDomNode = typeof vDomNode == "string" ? jQuery.sap.domById(vDomNode) : vDomNode;
		if ( oDomNode ) {
			jQuery.sap.log.debug("forcing a repaint for " + (oDomNode.id || String(oDomNode)));
			var sOriginalDisplay = oDomNode.style.display;
			var oActiveElement = document.activeElement;
			oDomNode.style.display = "none";
			oDomNode.offsetHeight;
			oDomNode.style.display = sOriginalDisplay;
			if (document.activeElement !== oActiveElement) {
				jQuery.sap.focus(oActiveElement);
			}
		}
	};
	
	//#################################################################################################
	// Methods for preserving HTML content
	//#################################################################################################
	
	(function() {
	
		var ID_PRESERVE_AREA = "sap-ui-preserve";
		var ATTR_PRESERVE_MARKER = "data-sap-ui-preserve";
	
		function getPreserveArea() {
			var $preserve = jQuery("#"+ID_PRESERVE_AREA);
			if ($preserve.length === 0){
				$preserve = jQuery("<DIV/>",{role:"application",id:ID_PRESERVE_AREA}).
					addClass("sapUiHidden").css("width", "0").css("height", "0").css("overflow", "hidden").
					appendTo(document.body);
			}
			return $preserve;
		}
	
		/**
		 * Collects descendants of the given root node that need to be preserved before the root node
		 * is wiped out. The "to-be-preserved" nodes are moved to a special, hidden 'preserve' area.
		 *
		 * A node is declared "to-be-preserved" when it has the <code>data-sap-ui-preserve</code>
		 * attribute set. When the optional parameter <code>bPreserveNodesWithId</code> is set to true,
		 * then nodes with an id are preserved as well and their <code>data-sap-ui-preserve</code> attribute
		 * is set automatically. This option is used by UIAreas when they render for the first time and
		 * simplifies the handling of predefined HTML content in a web page.
		 *
		 * The "to-be-preserved" nodes are searched with a depth first search and moved to the 'preserve'
		 * area in the order that they are found. So for direct siblings the order should be stable.
		 *
		 * @param {Element} oRootNode to search for "to-be-preserved" nodes
		 * @param {boolean} [bPreserveRoot=false] whether to preserve the root itself
		 * @param {boolean} [bPreserveNodesWithId=false] whether to preserve nodes with an id as well
		 * @public
		 * @static
		 * @name sap.ui.core.RenderManager.preserveContent
		 * @function
		 */
		RenderManager.preserveContent = function(oRootNode, bPreserveRoot, bPreserveNodesWithId) {
			jQuery.sap.assert(typeof oRootNode === "object" && oRootNode.ownerDocument == document, "oRootNode must be a DOM element");
	
			sap.ui.getCore().getEventBus().publish("sap.ui","__preserveContent", { domNode : oRootNode});
	
			var $preserve = getPreserveArea();
	
			function check($candidates) {
	
				$candidates.each(function(i,candidate) {
	
					// don't process the preserve area or the static area
					if ( candidate.id === ID_PRESERVE_AREA || sap.ui.getCore().isStaticAreaRef(candidate)) {
						return;
					}
	
					var $candidate = jQuery(candidate);
	
					if ( $candidate.attr(ATTR_PRESERVE_MARKER) )  { // node is marked with the preserve marker
						// when the current node is the root node then we're doing a single control rerendering
						if ( candidate === oRootNode ) {
							var $placeholder = jQuery("<DIV/>", { id: "sap-ui-dummy-" + candidate.id}).addClass("sapUiHidden");
							$placeholder.insertBefore($candidate);
						}
						$preserve.append($candidate);
					} else if ( bPreserveNodesWithId && candidate.id ) {
						RenderManager.markPreservableContent($candidate, candidate.id);
						$preserve.append($candidate);
						return;
					}
	
					// don't dive into nested UIAreas. They are preserved together with any preserved parent (e.g. HTML control)
					if ( !$candidate.attr("data-sap-ui-area") ) {
						check($candidate.children());
					}
				});
			}
	
			jQuery.sap.measure.start(oRootNode.id+"---preserveContent","preserveContent for "+oRootNode.id);
			check(bPreserveRoot? jQuery(oRootNode) : jQuery(oRootNode).children());
			jQuery.sap.measure.end(oRootNode.id+"---preserveContent");
		};
	
		/**
		 * Searches "to-be-preserved" nodes for the given control id.
		 *
		 * @param {string} sId control id to search content for.
		 * @return {jQuery} a jQuery collection representing the found content
		 * @public
		 * @static
		 * @name sap.ui.core.RenderManager.findPreservedContent
		 * @function
		 */
		RenderManager.findPreservedContent = function(sId) {
			jQuery.sap.assert(typeof sId === "string", "sId must be a string");
			var $preserve = getPreserveArea(),
				$content = $preserve.children("[" + ATTR_PRESERVE_MARKER + "='" + sId.replace(/(:|\.)/g,'\\$1') + "']");
			return $content;
		};
	
		/**
		 * Marks the given content as "to-be-preserved" for a control with the given id.
		 * When later on the content has been preserved, it can be found by giving the same id.
		 *
		 * @param {jQuery} $content a jQuery collection of DOM objects to be marked
		 * @param {string} sId id of the control to associate the content with
		 * @static
		 * @name sap.ui.core.RenderManager.markPreservableContent
		 * @function
		 */
		RenderManager.markPreservableContent = function($content, sId) {
			$content.attr(ATTR_PRESERVE_MARKER, sId);
		};
	
		/**
		 * Checks whether the given DOM node is part of the 'preserve' area.
		 *
		 * @param {Element} oDomNode
		 * @return {boolean} whether node is part of 'preserve' area
		 * @private
		 * @static
		 * @name sap.ui.core.RenderManager.isPreservedContent
		 * @function
		 */
		RenderManager.isPreservedContent = function(oDomNode) {
			return ( oDomNode && oDomNode.getAttribute(ATTR_PRESERVE_MARKER) && oDomNode.parentNode && oDomNode.parentNode.id == ID_PRESERVE_AREA );
		};
	
		/**
		 * Returns the hidden area reference belonging to this window instance.
		 *
		 * @return {Element} the hidden area reference belonging to this core instance.
		 * @public
		 * @static
		 * @name sap.ui.core.RenderManager.getPreserveAreaRef
		 * @function
		 */
		RenderManager.getPreserveAreaRef = function() {
			return getPreserveArea()[0];
		};
	
		var ATTR_INLINE_TEMPLATE_MARKER = "data-sap-ui-template";
	
		/**
		 * Marks the given content as "inline template".
		 *
		 * @param {jQuery} $content a jQuery collection of DOM objects to be marked
		 * @private
		 * @static
		 * @name sap.ui.core.RenderManager.markInlineTemplate
		 * @function
		 */
		RenderManager.markInlineTemplate = function($content) {
			$content.attr(ATTR_INLINE_TEMPLATE_MARKER, "");
		};
	
		/**
		 * Checks whether the given DOM node is an 'inline template' area.
		 *
		 * @param {Element} oDomNode
		 * @return {boolean} whether node is an 'inline template' area
		 * @private
		 * @static
		 * @name sap.ui.core.RenderManager.isInlineTemplate
		 * @function
		 */
		RenderManager.isInlineTemplate = function(oDomNode) {
			return ( oDomNode && oDomNode.hasAttribute(ATTR_INLINE_TEMPLATE_MARKER) );
		};
	
	}());
	
	
	//#################################################################################################
	// Methods for 'Buffered writer' functionality... (all public)
	// i.e. used methods in render-method of Renderers
	//#################################################################################################
	
	/**
	 * Write the given texts to the buffer
	 * @param {string|number ...} sText (can be a number too)
	 * @return {sap.ui.core.RenderManager} this render manager instance to allow chaining
	 * @public
	 * @SecSink {*|XSS}
	 * @name sap.ui.core.RenderManager#write
	 * @function
	 */
	RenderManager.prototype.write = function(/** string|number */ sText /* ... */) {
		jQuery.sap.assert(( typeof sText === "string") || ( typeof sText === "number"), "sText must be a string or number");
		this.aBuffer.push.apply(this.aBuffer, arguments);
		return this;
	};
	
	/**
	 * Escape text for HTML and write it to the buffer
	 * @param {string} sText
	 * @param {boolean} bLineBreaks Whether to convert linebreaks into <br> tags
	 * @return {sap.ui.core.RenderManager} this render manager instance to allow chaining
	 * @public
	 * @name sap.ui.core.RenderManager#writeEscaped
	 * @function
	 */
	RenderManager.prototype.writeEscaped = function(/** string */ sText, bLineBreaks) {
		jQuery.sap.assert( typeof sText === "string", "sText must be a string");
		if (bLineBreaks) {
			var aLines = sText.split("\n");
			for (var i = 0; i < aLines.length; i++) {
				aLines[i] = jQuery.sap.encodeHTML(aLines[i]);
			}
			sText = aLines.join("<br>");
		} else {
			sText = jQuery.sap.encodeHTML(sText);
		}
		this.aBuffer.push(sText);
		return this;
	};
	
	
	/**
	 * @deprecated Not implemented - DO NOT USE
	 * @public
	 * @name sap.ui.core.RenderManager#translate
	 * @function
	 */
	RenderManager.prototype.translate = function(/** string */ sKey) {
		// TODO
	};
	
	/**
	 * @deprecated Not implemented - DO NOT USE
	 * @return {sap.ui.core.RenderManager} this render manager instance to allow chaining
	 * @public
	 * @name sap.ui.core.RenderManager#writeAcceleratorKey
	 * @function
	 */
	RenderManager.prototype.writeAcceleratorKey = function() {
		/*
		if (bAlt && !bCtrl && !bArrowKey) {
			// Keyboard helper provides means for visualizing access keys.
			// keydown modifies some CSS rule for showing underlines
			// <span><u class="sapUiAccessKey">H</u>elp me</span>
			UCF_KeyboardHelper.showAccessKeys();
		}
		*/
		return this;
	};
	
	/**
	 * Adds a style property to the style collection if the value is not empty or null
	 * The style collection is flushed if it is written to the buffer using {@link #writeStyle}
	 *
	 * @param {string} sName name of the CSS property to write
	 * @param {string|float|int} value value to write
	 * @return {sap.ui.core.RenderManager} this render manager instance to allow chaining
	 * @public
	 * @SecSink {0 1|XSS} Styles are written to HTML without validation
	 * @name sap.ui.core.RenderManager#addStyle
	 * @function
	 */
	RenderManager.prototype.addStyle = function(sName, value) {
		jQuery.sap.assert(typeof sName === "string", "sName must be a string");
		if (value !== undefined && value !== null) {
			jQuery.sap.assert((typeof value === "string" || typeof value === "number"), "value must be a string or number");
			var oStyle = this.aStyleStack[this.aStyleStack.length-1];
			if (!oStyle.aStyle) {
				oStyle.aStyle = [];
			}
			oStyle.aStyle.push(sName + ":" + value);
		}
		return this;
	};
	
	/**
	 * Writes and flushes the style collection
	 * @return {sap.ui.core.RenderManager} this render manager instance to allow chaining
	 * @public
	 * @name sap.ui.core.RenderManager#writeStyles
	 * @function
	 */
	RenderManager.prototype.writeStyles = function() {
		var oStyle = this.aStyleStack[this.aStyleStack.length-1];
		if (oStyle.aStyle) {
			this.write(" style=\"" +oStyle.aStyle.join(";") +"\" ");
		}
		oStyle.aStyle = null;
		return this;
	};
	
	/**
	 * Adds a class to the class collection if the name is not empty or null.
	 * The class collection is flushed if it is written to the buffer using {@link #writeClasses}
	 *
	 * @param {string} sName name of the class to be added; null values are ignored
	 * @return {sap.ui.core.RenderManager} this render manager instance to allow chaining
	 * @public
	 * @SecSink {0|XSS} Classes are written to HTML without validation
	 * @name sap.ui.core.RenderManager#addClass
	 * @function
	 */
	RenderManager.prototype.addClass = function(sName) {
		if (sName) {
			jQuery.sap.assert(typeof sName === "string", "sName must be a string");
			var oStyle = this.aStyleStack[this.aStyleStack.length-1];
			if (!oStyle.aClasses) {
				oStyle.aClasses = [];
			}
			oStyle.aClasses.push(sName);
		}
		return this;
	};
	
	/**
	 * Writes and flushes the class collection (all CSS classes added by "addClass()" since the last flush).
	 * Also writes the custom style classes added by the application with "addStyleClass(...)". Custom classes are
	 * added by default from the currently rendered control. If an oElement is given, this Element's custom style
	 * classes are added instead. If oElement === false, no custom style classes are added.
	 *
	 * @param {sap.ui.core.Element | boolean} [oElement] an Element from which to add custom style classes (instead of adding from the control itself)
	 * @return {sap.ui.core.RenderManager} this render manager instance to allow chaining
	 * @public
	 * @name sap.ui.core.RenderManager#writeClasses
	 * @function
	 */
	RenderManager.prototype.writeClasses = function(oElement) {
		jQuery.sap.assert(!oElement || typeof oElement === "boolean" || oElement instanceof sap.ui.core.Element, "oElement must be empty, a boolean, or a sap.ui.core.Element");
		var oStyle = this.aStyleStack[this.aStyleStack.length-1];
	
		// Custom classes are added by default from the currently rendered control. If an oElement is given, this Element's custom style
		// classes are added instead. If oElement === false, no custom style classes are added.
		var aCustomClasses = oElement ? oElement.aCustomStyleClasses : ((oElement === false) ? [] : oStyle.aCustomStyleClasses);
	
		if (oStyle.aClasses || aCustomClasses) {
			var aClasses = [].concat(oStyle.aClasses || [], aCustomClasses || []);
			aClasses.sort();
			aClasses = jQuery.map(aClasses, function(n, i){
				return (i==0 || n != aClasses[i-1]) ? n : null;
			});
			this.write(" class=\"", aClasses.join(" "), "\" "); 
		}
		
		if (!oElement) {
			oStyle.aCustomStyleClasses = null;
		}
		oStyle.aClasses = null;
		return this;
	};
	
	/**
	 * Writes the controls data into the HTML.
	 * Control Data consists at least of the id of a control
	 * @param {sap.ui.core.Control} oControl the control whose identifying information should be written to the buffer
	 * @return {sap.ui.core.RenderManager} this render manager instance to allow chaining
	 * @public
	 * @name sap.ui.core.RenderManager#writeControlData
	 * @function
	 */
	RenderManager.prototype.writeControlData = function(oControl) {
		jQuery.sap.assert(oControl && oControl instanceof sap.ui.core.Control, "oControl must be a sap.ui.core.Control");
		this.writeElementData(oControl);
		return this;
	};
	
	/**
	 * Writes the elements data into the HTML.
	 * Element Data consists at least of the id of a element
	 * @param {sap.ui.core.Element} oElement the element whose identifying information should be written to the buffer
	 * @return {sap.ui.core.RenderManager} this render manager instance to allow chaining
	 * @public
	 * @name sap.ui.core.RenderManager#writeElementData
	 * @function
	 */
	RenderManager.prototype.writeElementData = function(oElement) {
		jQuery.sap.assert(oElement && oElement instanceof sap.ui.core.Element, "oElement must be a sap.ui.core.Element");
		var sId = oElement.getId();
		if(sId) {
			this.writeAttribute("id", sId).writeAttribute("data-sap-ui", sId);
		}
		var aData = oElement.getCustomData();
		var l = aData.length;
		for (var i = 0; i < l; i++) {
			var oData = aData[i];
			if (oData.getWriteToDom()) { // application wants this to be written to the DOM, but there are some conditions for this to work
				var key = oData.getKey();
				if (typeof oData.getValue() === "string") {
					if ((sap.ui.core.ID.isValid(key)) && (key.indexOf(":") == -1) && (key.indexOf("sap-ui") !== 0)) {
						this.writeAttributeEscaped("data-" + key, oData.getValue());
					} else { // error case
						jQuery.sap.log.error("CustomData with key " + key + " should be written to HTML of " + this + " but the key is not valid (must be a valid sap.ui.core.ID without any colon and may not start with 'sap-ui').");
					}
				} else { // error case: non-string value
					jQuery.sap.log.error("CustomData with key " + key + " should be written to HTML of " + this + " but the value is not a string.");
				}
			}
		}
		return this;
	};
	
	/**
	 * Writes the attribute and its value into the HTML
	 * @param {string} sName the name of the attribute
	 * @param {string | number | boolean} value the value of the attribute
	 * @return {sap.ui.core.RenderManager} this render manager instance to allow chaining
	 * @public
	 * @SecSink {0 1|XSS} Attributes are written to HTML without validation
	 * @name sap.ui.core.RenderManager#writeAttribute
	 * @function
	 */
	RenderManager.prototype.writeAttribute = function(sName, value) {
		jQuery.sap.assert(typeof sName === "string", "sName must be a string");
		jQuery.sap.assert(typeof value === "string" || typeof value === "number" || typeof value === "boolean", "value must be a string, number or boolean");
		this.write(" ", sName, "=\"", value, "\"");
		return this;
	};
	
	/**
	 * Writes the attribute and its value into the HTML
	 * 
	 * The value is properly escaped to avoid XSS attacks.
	 * 
	 * @param sName the name of the attribute
	 * @param vValue the value of the attribute
	 * @return {sap.ui.core.RenderManager} this render manager instance to allow chaining
	 * @public
	 * @SecSink {0|XSS}
	 * @name sap.ui.core.RenderManager#writeAttributeEscaped
	 * @function
	 */
	RenderManager.prototype.writeAttributeEscaped = function(sName, vValue) {
		// writeAttribute asserts
		this.writeAttribute(sName, jQuery.sap.escapeHTML(String(vValue)));
		return this;
	};
	
	/**
	 * Writes the accessibility state (see WAI-ARIA specification) of the provided element into the HTML
	 * based on the element's properties and associations.
	 *
	 * The ARIA properties are only written when the accessibility feature is activated in the UI5 configuration.
	 *
	 * The following properties/values to ARIA attribute mappings are done (if the element does have such properties):
	 * <code>editable===false</code> => <code>aria-readonly="true"</code>
	 * <code>enabled===false</code> => <code>aria-disabled="true"</code>
	 * <code>visible===false</code> => <code>aria-hidden="true"</code>
	 * <code>required===true</code> => <code>aria-required="true"</code>
	 * <code>selected===true</code> => <code>aria-selected="true"</code>
	 * <code>checked===true</code> => <code>aria-checked="true"</code>
	 *
	 * Additionally the association <code>ariaDescribedBy</code> and <code>ariaLabelledBy</code> are used to write
	 * the id lists of the ARIA attributes <code>aria-describedby</code> and <code>aria-labelledby</code>.
	 *
	 * Note: This function is only a heuristic of a control property to ARIA attribute mapping. Control developers
	 * have to check whether it fullfills their requirements. In case of problems (for example the RadioButton has a
	 * <code>selected</code> property but must provide an <code>aria-checked</code> attribute) the auto-generated
	 * result of this function can be influenced via the parameter <code>mProps</code> as described below.
	 *
	 * The parameter <code>mProps</code> can be used to either provide additional attributes which should be added and/or
	 * to avoid the automatic generation of single ARIA attributes. The 'aria-' prefix will be prepended automatically to the keys
	 * (Exception: Attribute 'role' does not get the prefix 'aria-').
	 *
	 * Examples:
	 * <code>{hidden : true}</code> results in <code>aria-hidden="true"</code> independent of the precense or absence of
	 * the visibility property.
	 * <code>{hidden : null}</code> ensures that no <code>aria-hidden</code> attribute is written independent of the precense
	 * or absence of the visibility property.
	 * The function behaves in the same way for the associations <code>ariaDescribedBy</code> and <code>ariaLabelledBy</code>.
	 * To append additional values to the auto-generated <code>aria-describedby</code> and <code>aria-labelledby</code> attributes
	 * the following format can be used:
	 * <code>{describedby : {value: "id1 id2", append: true}}</code> => <code>aria-describedby="ida idb id1 id2"</code> (assuming that "ida idb"
	 * is the auto-generated part based on the association <code>ariaDescribedBy</code>).
	 *
	 * @param {sap.ui.core.Element}
	 *            [oElement] the element whose accessibility state should be rendered
	 * @param {Object}
	 *            [mProps] a map of properties that should be added additionally or changed.
	 * @return {sap.ui.core.RenderManager} this render manager instance to allow chaining
	 * @public
	 * @name sap.ui.core.RenderManager#writeAccessibilityState
	 * @function
	 */
	RenderManager.prototype.writeAccessibilityState = function(oElement, mProps) {
		if(!sap.ui.getCore().getConfiguration().getAccessibility()){
			return this;
		}
	
		if(arguments.length == 1 && !(oElement instanceof sap.ui.core.Element)) {
			mProps = oElement;
			oElement = null;
		}
	
		var mAriaProps = {};
	
		if(oElement != null) {
			var oMetadata = oElement.getMetadata();
			oMetadata._enrichChildInfos();
	
			var addACCForProp = function(sElemProp, sACCProp, oVal){
				var oProp = oMetadata.getAllProperties()[sElemProp];
				if(oProp && oElement[oProp._sGetter]() === oVal){
					mAriaProps[sACCProp] = "true";
				}
			}
	
			var addACCForAssoc= function(sElemAssoc, sACCProp){
				var oAssoc = oMetadata.getAllAssociations()[sElemAssoc];
				if(oAssoc && oAssoc.multiple){
					var aIds = oElement[oAssoc._sGetter]();
					if(aIds.length > 0){
						mAriaProps[sACCProp] = aIds.join(" ");
					}
				}
			}
	
			addACCForProp("editable", "readonly", false);
			addACCForProp("enabled", "disabled", false);
			addACCForProp("visible", "hidden", false);
			addACCForProp("required", "required", true);
			addACCForProp("selected", "selected", true);
			addACCForProp("checked", "checked", true);
			addACCForAssoc("ariaDescribedBy", "describedby");
			addACCForAssoc("ariaLabelledBy", "labelledby");
		}
	
		if(mProps){
			var checkValue = function(v){
				var type = typeof(v);
				return v === null || v === "" || type === "number" || type === "string" || type === "boolean";
			}
			
			var prop = {};
			var x, val, type, autoVal;
			
			for(x in mProps){
				val = mProps[x];
				if(checkValue(val)){
					prop[x] = val;
				}else if(typeof(val) === "object" && checkValue(val.value)){
					autoVal = "";
					if(val.append && (x === "describedby" || x === "labelledby")){
						autoVal = mAriaProps[x] ? mAriaProps[x]+" " : "";
					}
					prop[x] = autoVal + val.value;
				}
			}
			
			//The auto-generated values above can be overridden or reset (via null)
			jQuery.extend(mAriaProps, prop);
		}
	
		// allow parent (e.g. FormElement) to overwrite or enhance aria attributes
		if (oElement instanceof sap.ui.core.Element && oElement.getParent() && oElement.getParent().enhanceAccessibilityState) {
			oElement.getParent().enhanceAccessibilityState(oElement, mAriaProps);
		}
	
		for(var p in mAriaProps) {
			if(mAriaProps[p] != null && mAriaProps[p] !== ""){ //allow 0 and false but no null, undefined or empty string
				this.writeAttributeEscaped(p === "role" ? p : "aria-"+p, mAriaProps[p]);
			}
		}
	
		return this;
	};
	
	
	/**
	 * Writes either an img tag for normal URI or an span tag with needed properties for icon URI.
	 * 
	 * Additional classes and attributes can be added to the tag by given the second and third parameter.
	 * All of the given attributes are escaped for security consideration.
	 * 
	 * when img tag is rendered, the following two attributes are added by default which can be overwritten by the provided mAttributes parameter:
	 * 1. role: presentation
	 * 2. alt: ""
	 * 
	 * @param {sap.ui.core.URI} sURI is the URI of an image or an icon registered in sap.ui.core.IconPool.
	 * @param {array|string} aClasses are additional classes that are added to the rendered tag.
	 * @param {object} mAttributes are additional attributes that are added to the rendered tag.
	 * @returns {sap.ui.core.RenderManager} this render manager instance to allow chaining
	 * @name sap.ui.core.RenderManager#writeIcon
	 * @function
	 */
	RenderManager.prototype.writeIcon = function(sURI, aClasses, mAttributes){
		jQuery.sap.require("sap.ui.core.IconPool");
	
		var bIconURI = sap.ui.core.IconPool.isIconURI(sURI),
			sStartTag = bIconURI ? "<span " : "<img ",
			bTextNeeded = (sap.ui.Device.browser.internet_explorer && sap.ui.Device.browser.version < 9),
			sClasses, sProp, oIconInfo;
	
		if(typeof aClasses === "string"){
			aClasses = [aClasses];	
		}
	
		if(bIconURI){
			oIconInfo = sap.ui.core.IconPool.getIconInfo(sURI);
	
			if(!oIconInfo){
				jQuery.sap.log.error("An unregistered icon: " + sURI + " is used in sap.ui.core.RenderManager's writeIcon method.");
				return;
			}
	
			if(!aClasses){
				aClasses = [];
			}
			aClasses.push("sapUiIcon");
			if(!oIconInfo.suppressMirroring){
				aClasses.push("sapUiIconMirrorInRTL")
			}
		}
	
		this.write(sStartTag);
	
		if(jQuery.isArray(aClasses) && aClasses.length){
			sClasses = aClasses.join(" ");
			this.write("class=\"" + sClasses + "\" ");
		}
	
		if(bIconURI){
			if(!mAttributes){
				mAttributes = {};
			}
			if(!bTextNeeded){
				mAttributes["data-sap-ui-icon-content"] = oIconInfo.content;
			}
			this.write("style=\"font-family: " + oIconInfo.fontFamily +";\" ");
		} else {
			mAttributes = jQuery.extend({
				role: "presentation",
				alt: "",
				src: sURI
			}, mAttributes);
		}
	
		if(typeof mAttributes === "object"){
			for(sProp in mAttributes){
				if(mAttributes.hasOwnProperty(sProp)){
					this.writeAttributeEscaped(sProp, mAttributes[sProp]);
				}
			}
		}
	
		this.write(bIconURI ? ">" : "/>");
	
		if(bIconURI){
			bTextNeeded && this.write(oIconInfo.content);
			this.write("</span>");
		}
	};
	

	return RenderManager;

}, /* bExport= */ true);

}; // end of sap/ui/core/RenderManager.js
if ( !jQuery.sap.isDeclared('sap.ui.core.ResizeHandler') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.core.ResizeHandler
jQuery.sap.declare('sap.ui.core.ResizeHandler'); // unresolved dependency added by SAPUI5 CreateModule Ant-Task
sap.ui.define("sap/ui/core/ResizeHandler",['jquery.sap.global', 'sap/ui/Global', 'sap/ui/base/Object', 'jquery.sap.act', 'jquery.sap.script'],
	function(jQuery, Global, BaseObject/* , jQuerySap1, jQuerySap */) {
	"use strict";


	
	
		// local logger, by default only logging errors
		var log = jQuery.sap.log.getLogger("sap.ui.core.ResizeHandler", jQuery.sap.log.Level.ERROR);
	
		/**
		 * Reference to the Core (implementation view, not facade)
		 * @type {sap.ui.core.Core} 
		 */
		var oCoreRef = null;
	
		/** 
		 * API for resize handling on registered DOM elements and controls.
		 * 
		 * This API provides firing of resize events on all browsers by regularly 
		 * checking width and height of registered DOM elements and controls and firing events accordingly.
		 * 
		 * @namespace
		 * @name sap.ui.core.ResizeHandler
		 * @public
		 */
		
		var ResizeHandler = BaseObject.extend("sap.ui.core.ResizeHandler", /** @lends sap.ui.core.ResizeHandler */ {
	
			constructor : function(oCore) {
				BaseObject.apply(this);
	
				oCoreRef = oCore;
	
				this.aResizeListeners = [];
				this.bRegistered = false;
	
				this.iIdCounter = 0;
	
				this.fDestroyHandler = jQuery.proxy(this.destroy, this);
	
				jQuery(window).bind("unload", this.fDestroyHandler);
				
				jQuery.sap.act.attachActivate(initListener, this);
			}
	
		});
		
		function clearListener(){
			if(this.bRegistered){
				this.bRegistered = false;
				sap.ui.getCore().detachIntervalTimer(this.checkSizes, this);
			}
		};
		
		function initListener(){
			if(!this.bRegistered && this.aResizeListeners.length > 0){
				this.bRegistered = true;
				sap.ui.getCore().attachIntervalTimer(this.checkSizes, this);
			}
		};
	
		/**
		 * Destroy method of the Resize Handler.
		 * It unregisters the event handlers.
		 *
		 * @param {jQuery.Event} oEvent the event that initiated the destruction of the ResizeHandler
		 * @private
		 * @name sap.ui.core.ResizeHandler#destroy
		 * @function
		 */
		ResizeHandler.prototype.destroy = function(oEvent) {
			jQuery.sap.act.detachActivate(initListener, this);
			jQuery(window).unbind("unload", this.fDestroyHandler);
			oCoreRef = null;
			this.aResizeListeners = [];
			clearListener.apply(this);
		};
	
		/**
		 * Attaches listener to resize event.
		 *
		 * @param {Element|sap.ui.core.Control} oRef the DOM reference or a control
		 * @param {function} fHandler the event handler function
		 * @return {string} Registration-ID for later detaching.
		 * @private
		 * @name sap.ui.core.ResizeHandler#attachListener
		 * @function
		 */
		ResizeHandler.prototype.attachListener = function(oRef, fHandler){
			var bIsControl = oRef instanceof sap.ui.core.Control,
				oDom = bIsControl ? oRef.getDomRef() : oRef,
				iWidth = oDom ? oDom.offsetWidth : 0,
				iHeight = oDom ? oDom.offsetHeight : 0,
				sId = "rs-" + new Date().valueOf() + "-" + this.iIdCounter++,
				dbg = (bIsControl ? ("Control " + oRef.getId()) : (oRef.id ? oRef.id : String(oRef)));
	
			this.aResizeListeners.push({sId: sId, oDomRef: bIsControl ? null : oRef, oControl: bIsControl ? oRef : null, fHandler: fHandler, iWidth: iWidth, iHeight: iHeight, dbg: dbg});
			log.debug("registered " + dbg);
	
			initListener.apply(this);
			
			return sId;
		};
	
		/**
		 * Detaches listener from resize event.
		 *
		 * @param {string} Registration-ID returned from attachListener
		 * @private
		 * @name sap.ui.core.ResizeHandler#detachListener
		 * @function
		 */
		ResizeHandler.prototype.detachListener = function(sId){
			var that = this;
			jQuery.each(this.aResizeListeners, function(index, oResizeListener){
				if(oResizeListener.sId == sId){
					that.aResizeListeners.splice(index,1);
					log.debug("deregistered " + sId);
					return false; //break the loop
				};
			});
	
			// if list is empty now, stop interval
			if(this.aResizeListeners.length == 0){
				clearListener.apply(this);
			}
		};
	
	
		/**
		 * Check sizes of resize elements.
		 * @private
		 * @name sap.ui.core.ResizeHandler#checkSizes
		 * @function
		 */
		ResizeHandler.prototype.checkSizes = function() {
			var bDebug = log.isLoggable();
			if ( bDebug ) { 
				log.debug("checkSizes:"); 
			} 
			jQuery.each(this.aResizeListeners, function(index, oResizeListener){
				if(oResizeListener){
					var bCtrl = !!oResizeListener.oControl,
						oDomRef = bCtrl ? oResizeListener.oControl.getDomRef() : oResizeListener.oDomRef;
						
					if ( oDomRef && jQuery.contains(document.documentElement, oDomRef)) { //check that domref is still active 
						
						var iOldWidth = oResizeListener.iWidth,
							iOldHeight = oResizeListener.iHeight,
							iNewWidth = oDomRef.offsetWidth,
							iNewHeight = oDomRef.offsetHeight;
					
						if(iOldWidth != iNewWidth || iOldHeight != iNewHeight){
							oResizeListener.iWidth = iNewWidth;
							oResizeListener.iHeight = iNewHeight;
							
							var oEvent = jQuery.Event("resize");
							oEvent.target = oDomRef;
							oEvent.currentTarget = oDomRef;
							oEvent.size = {width: iNewWidth, height: iNewHeight};
							oEvent.oldSize = {width: iOldWidth, height: iOldHeight};
							oEvent.control = bCtrl ? oResizeListener.oControl : null;
							
							if ( bDebug ) { 
								log.debug("resize detected for '" + oResizeListener.dbg + "': " + oEvent.oldSize.width + "x" + oEvent.oldSize.height + " -> " + oEvent.size.width + "x" + oEvent.size.height); 
							}
							
							oResizeListener.fHandler(oEvent);
						}
	
					}
				}
			});
			
			if(ResizeHandler._keepActive != true && ResizeHandler._keepActive != false){
				//initialize default
				ResizeHandler._keepActive = false;
			}
			
			if(!jQuery.sap.act.isActive() && !ResizeHandler._keepActive){
				clearListener.apply(this);
			}
		};
	
		/**
		 * Registers the given handler for resize events on the given
		 * DOM reference or Control.
		 *
		 * @param {Element|sap.ui.core.Control} oRef the Control or the DOM reference for which the given handler should be registered (beside the window)
		 * @param {function} fHandler the handler which should be called on a resize event
		 * @return {string} Registration ID which can be used for deregistering
		 * @name sap.ui.core.ResizeHandler#register
		 * @function
		 * @public
		 */
		ResizeHandler.register = function(oRef, fHandler) {
			if(!oCoreRef || !oCoreRef.oResizeHandler) {
				return null;
			}
			return oCoreRef.oResizeHandler.attachListener(oRef, fHandler);
		};
	
		/**
		 * Deregisters the registered handler for resize events with the given ID.
		 *
		 * @param {string} Registration ID
		 * @name sap.ui.core.ResizeHandler#deregister
		 * @function
		 * @public
		 */
		ResizeHandler.deregister = function(sId) {
			if(!oCoreRef || !oCoreRef.oResizeHandler) {
				return;
			}
			oCoreRef.oResizeHandler.detachListener(sId);
		};
		
		/**
		 * Deregisters all registered handler for resize events for the given control.
		 *
		 * @param {string} sControlId the control Id
		 * @name sap.ui.core.ResizeHandler#deregisterAllForControl
		 * @function
		 * @private
		 */
		ResizeHandler.deregisterAllForControl = function(sControlId) {
			if(!oCoreRef || !oCoreRef.oResizeHandler) {
				return;
			}
			
			var aIds = [];
			jQuery.each(oCoreRef.oResizeHandler.aResizeListeners, function(index, oResizeListener){
				if(oResizeListener && oResizeListener.oControl && oResizeListener.oControl.getId() === sControlId){
					aIds.push(oResizeListener.sId);
				};
			});
			jQuery.each(aIds, function(index, sId){
				ResizeHandler.deregister(sId);
			});
		};
	
	

	return ResizeHandler;

}, /* bExport= */ true);

}; // end of sap/ui/core/ResizeHandler.js
if ( !jQuery.sap.isDeclared('sap.ui.core.ThemeCheck') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.core.ThemeCheck
jQuery.sap.declare('sap.ui.core.ThemeCheck'); // unresolved dependency added by SAPUI5 CreateModule Ant-Task
sap.ui.define("sap/ui/core/ThemeCheck",['jquery.sap.global', 'sap/ui/base/Object', 'jquery.sap.script'],
	function(jQuery, BaseObject/* , jQuerySap */) {
	"use strict";


	
	
	
	sap.ui._maxThemeCheckCycles = 100;
	
	/**
	 * Creates a new ThemeCheck object.
	 *
	 * @class Helper class used by the UI5 Core to check whether the themes are applied correctly.
	 *
	 * It could happen that e.g. in onAfterRendering not all themes are available. In these cases the
	 * check waits until the CSS is applied and fires an onThemeChanged event.
	 *
	 * @extends sap.ui.base.Object
	 * @since 1.10.0
	 * @author SAP AG
	 * @constructor
	 * @private
	 * @name sap.ui.core.ThemeCheck
	 */
	var ThemeCheck = BaseObject.extend("sap.ui.core.ThemeCheck", /** @lends sap.ui.core.ThemeCheck.prototype */ {
	
		constructor : function(oCore) {
			this._oCore = oCore;
			this._iCount = 0; // Prevent endless loop
			this._CUSTOMCSSCHECK = /\.sapUiThemeDesignerCustomCss/i;
			this._CUSTOMID = "sap-ui-core-customcss";
			this._customCSSAdded = false;
			this._themeCheckedForCustom = null;
		},
	
		getInterface : function() {
			return this;
		},
	
		fireThemeChangedEvent : function(bOnlyOnInitFail, bForceCheck) {
			clear(this);
			var bUseThemeCheck = sap.ui._maxThemeCheckCycles > 0; //Possibility to switch off theme check (except of force mode (for Core.applyTheme))
	
			if(bUseThemeCheck || bForceCheck){
				delayedCheckTheme.apply(this, [true]);
			}else{
				ThemeCheck.themeLoaded = true;
			}
	
			if(!bOnlyOnInitFail && !this._sThemeCheckId){
				this._oCore.fireThemeChanged({theme: this._oCore.getConfiguration().getTheme()});
			}
	
		}
	
	});
	
	ThemeCheck.themeLoaded = false;
	
	ThemeCheck.checkStyle = function(oStyle, bLog){
		if(typeof(oStyle) === "string"){
			oStyle = jQuery.sap.domById(oStyle);
		}
		var $Style = jQuery(oStyle);
	
		try {
			var res = !oStyle || !!((oStyle.sheet && oStyle.sheet.cssRules.length > 0) ||
	        		!!(oStyle.styleSheet && oStyle.styleSheet.cssText.length > 0) ||
	        		!!(oStyle.innerHTML && oStyle.innerHTML.length > 0));
			var res2 = $Style.attr("sap-ui-ready");
			res2 = !!(res2 === "true" || res2 === "false");
			if(bLog){
				jQuery.sap.log.debug("ThemeCheck: Check styles '"+$Style.attr("id")+"': "+res+"/"+res2+"/"+!!oStyle);
			}
			return res || res2;
		}catch(e){}
	
		if(bLog){
			jQuery.sap.log.debug("ThemeCheck: Error during check styles '"+$Style.attr("id")+"': false/false/"+!!oStyle);
		}
		return false;
	};
	
	function clear(oThemeCheck){
		ThemeCheck.themeLoaded = false;
		if(oThemeCheck._sThemeCheckId){
			jQuery.sap.clearDelayedCall(oThemeCheck._sThemeCheckId);
			oThemeCheck._sThemeCheckId = null;
			oThemeCheck._iCount = 0;
		}
	}
	
	function checkTheme(oThemeCheck) {
		var mLibs = oThemeCheck._oCore.getLoadedLibraries();
		var sThemeName = oThemeCheck._oCore.getConfiguration().getTheme();
		var sPath = oThemeCheck._oCore._getThemePath("sap.ui.core", sThemeName) + "custom.css";
		var res = true;
	
		if (!!oThemeCheck._customCSSAdded && oThemeCheck._themeCheckedForCustom === sThemeName){
			// include custom style sheet here because it has already been added using jQuery.sap.includeStyleSheet
			// hence, needs to be checked for successful inclusion, too
			mLibs["sap-ui-theme-"+oThemeCheck._CUSTOMID] = {};
		}
	
		jQuery.each(mLibs, function(lib) {
			res = res && ThemeCheck.checkStyle("sap-ui-theme-"+lib, true);
			if (!!res){
			/* as soon as css has been loaded, look if there is a flag for custom css inclusion inside, but only
				 * if this has not been checked successfully before for the same theme
				 */
			if(oThemeCheck._themeCheckedForCustom != sThemeName){
					if (checkCustom(oThemeCheck, lib)){
							//load custom css available at sap/ui/core/themename/library.css
						jQuery.sap.includeStyleSheet(sPath,  oThemeCheck._CUSTOMID);
						oThemeCheck._customCSSAdded = true;
						jQuery.sap.log.warning("ThemeCheck delivered custom CSS needs to be loaded, Theme not yet applied");
						oThemeCheck._themeCheckedForCustom = sThemeName;
						res = false;
						return false;
					}
					else{
						// remove stylesheet once the particular class is not available (e.g. after theme switch)
						/*check for custom theme was not successful, so we need to make sure there are no custom style sheets attached*/
						var customCssLink = jQuery("LINK[id='"+  oThemeCheck._CUSTOMID + "']");
						if (customCssLink.length > 0){
							customCssLink.remove();
							jQuery.sap.log.debug("Custom CSS removed");
						}
						oThemeCheck._customCSSAdded = false;
					}
				}
			}
		});
		if(!res){
			jQuery.sap.log.warning("ThemeCheck: Theme not yet applied.");
		}
		else{
			oThemeCheck._themeCheckedForCustom = sThemeName;
		}
		return res;
	}
	
	/* checks if a particular class is available at the beginning of the core styles
	 */
	function checkCustom (oThemeCheck, lib){
		var ruleName = null,
		bSuccess = false;
	 var lib = new RegExp(lib);
		//get the core styles
		jQuery.each(document.styleSheets, function(iIndex, oStyleSheet) {
				if (!!oStyleSheet.ownerNode && lib.test(oStyleSheet.ownerNode.id) && oStyleSheet.cssRules && oStyleSheet.cssRules.length > 0){
					ruleName = oStyleSheet.cssRules[0].selectorText;
					if(oThemeCheck._CUSTOMCSSCHECK.test(ruleName)){
						bSuccess = true;
						return false;
					}
				}
				else if(!!oStyleSheet.owningElement && lib.test(oStyleSheet.owningElement.id) && oStyleSheet.rules && oStyleSheet.rules.length > 0){
						//ie8 doesn't know ownerNode
					ruleName = oStyleSheet.rules[0].selectorText;
					if(oThemeCheck._CUSTOMCSSCHECK.test(ruleName)){
						bSuccess = true;
						return false;
					}
				}
		});
		// we should now have some rule name ==> try to match against custom check
		return bSuccess;
	}
	
	function delayedCheckTheme(bFirst) {
		this._iCount++;
	
		var bEmergencyExit = this._iCount > sap.ui._maxThemeCheckCycles;
	
		if(!checkTheme(this) && !bEmergencyExit){
			this._sThemeCheckId = jQuery.sap.delayedCall(2, this, delayedCheckTheme);
		}else if(!bFirst){
			clear(this);
			ThemeCheck.themeLoaded = true;
			this._oCore.fireThemeChanged({theme: this._oCore.getConfiguration().getTheme()});
			if(bEmergencyExit){
				jQuery.sap.log.warning("ThemeCheck: max. check cycles reached.");
			}
		}else{
			ThemeCheck.themeLoaded = true;
		}
	}
	
	
	

	return ThemeCheck;

}, /* bExport= */ true);

}; // end of sap/ui/core/ThemeCheck.js
if ( !jQuery.sap.isDeclared('sap.ui.core.UIArea') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.core.UIArea
jQuery.sap.declare('sap.ui.core.UIArea'); // unresolved dependency added by SAPUI5 CreateModule Ant-Task
if ( !jQuery.sap.isDeclared('jquery.sap.ui') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// A bridge between the jQuery.sap plugin and the SAPUI5 Core
jQuery.sap.declare('jquery.sap.ui'); // unresolved dependency added by SAPUI5 CreateModule Ant-Task
sap.ui.define("jquery.sap.ui",['jquery.sap.global', 'sap/ui/Global'],
	function(jQuery, Global) {
	"use strict";

//jQuery.sap.require("sap.ui.core.Core"); // cyclic
	
	// !!!!!!!!!!!!!!!!!!!!!!!!!!
	// !!     EXPERIMENTAL     !!
	// !!!!!!!!!!!!!!!!!!!!!!!!!!
	
	
	// FIXME Too tough or just right?
	if(!jQuery.sap) {
		throw "Initialisation of jQuery.sap.ui failed. jQuery.sap plugin required!";
	}
	if(!window.sap || !window.sap.ui) {
		jQuery.sap.fatal("Initialisation of jQuery.sap.ui failed. Global SAP UI namespace required!");
	}

	//ensure not to initialize twice
	if(jQuery.sap.ui) {
		return;
	}

//	/**
//	 * Root Namespace for the jQuery UI-Layer plugin provided by SAP AG.
//	 *
//	 * @version 1.20.6
//	 * @namespace
//	 * @public
//	 */
//	jQuery.sap.ui = {};

	function fUIAreaFilter(idx){
		return sap.ui.getCore().getUIArea(this.id) != null;
	}
	function fgetUIArea(idx, odomref){
		return sap.ui.getCore().getUIArea(this.id);
	}
	function fgetUIAreaOfCtrl(oCtrl, idx){
		return oCtrl.getUIArea().getInterface();
	}

	/**
	 * @public
	 * @author SAP AG
	 */
	jQuery.fn.root = function(oRootControl) {
		var tmp;
		// handle 'setRoot'
		if(oRootControl) {
			sap.ui.getCore().setRoot(this.get(0), oRootControl);
			return this;
		}
		// and 'getRoot' behavior.
		var aControls = this.control();
		if (aControls.length > 0) {
			return jQuery.map(aControls, fgetUIAreaOfCtrl);
		}

		var aUIAreas = this.uiarea();

		if (aUIAreas.length > 0) {
			// we have UIAreas
			return aUIAreas;
		}

		// create UIAreas
		this.each(function(idx){
			sap.ui.getCore().createUIArea(this);
		});
		return this;
	};

	/**
	 * @public
	 */
	jQuery.fn.uiarea = function(iIdx) {
		// UIAreas need to have IDs... so reduce to those elements first
		var aUIAreas = this.slice("[id]").filter(fUIAreaFilter).map(fgetUIArea).get();
		return typeof(iIdx) === "number"?aUIAreas[iIdx]:aUIAreas;
	};

	/**
	 * Function identifying the closest SAPUI5 Control in the given jQuery context (provided via jQuery.map method).
	 * @private
	 */
	function fgetControl() {
		// as with jQuery 1.4.3 and 1.4.4 there is a big problem here, we increase checks here
		if(!this || !this.nodeType || this.nodeType === 9) {
			return null;
		} // in this case, we are on the HTML Document and cannot do anything
		// in IE8 'closest' might fail (e.g. when the element is not in the current document tree)
		// The following line would probably also work for the 'try-catch' below but induce performance penalty in EVERY call of this method.
		// if(jQuery(document.documentElement).has(this)) {
		try{
			var sId = jQuery(this).closest("[data-sap-ui]").attr("id");
			return sId ? sap.ui.getCore().byId(sId) : null;
		} catch(e){
			// probably IE8 case where element is not in current document tree... ==> there is no current control
			return null;
		}
	}

	/**
	 * Extension function to the jQuery.fn which identifies SAPUI5 controls in the given jQuery context.
	 *
	 * @param {int} [idx] optional parameter to return the control instance at the given idx's position in the array.
	 * @methodOf jQuery.prototype
	 * @returns {sap.ui.core.Control[] | sap.ui.core.Control | null} depending on the given context and idx parameter an array of controls, an instance or null.
	 * @public
	 */
	jQuery.fn.control = function(idx) {
		var aControls = this.map(fgetControl);
		if(idx === undefined || isNaN(idx)) {
			return aControls.get();
		}
		else {
			return aControls.get(idx);
		}
	};


	/**
	 * EXPERIMENTAL!!
	 * Creates a new control of the given type and places it into the first DOM object of the jQuery collection.
	 * The type string is case sensitive.
	 *
	 * @param {string} sControlType the control type (fully qualified, like "sap.ui.dev.GoogleMap"; if no package is given, the package "sap.ui.commons" is assumed)
	 * @param {string} [sId] optional id for the new control; generated automatically if no non-empty id is given
	 * @param {object} [oConfiguration] optional map/JSON-object with initial values for the new control
	 * @returns {jQuery} the given jQuery object
	 * @private
	 */
	jQuery.fn.sapui = function(sControlType, sId, oConfiguration) {

		return this.each(function() { // TODO: hack for Steffen; (point is not clear, as this adds identical controls to many DOM elements...); remove soon

			var oControl = null;
			if (this) {
				// allow omitting the package prefix because this looks less Java-like...  sap.ui.commons is the default package
				if (sControlType.indexOf(".") == -1)  {
					sControlType = "sap.ui.commons." + sControlType;
				}

				// instantiate the control
				var fnClass = jQuery.sap.getObject(sControlType);
				if (fnClass) {

					// TODO: hack for Steffen; remove later
					if(typeof oConfiguration == 'object' && typeof oConfiguration.press == 'function') {
			  oConfiguration.press = jQuery.proxy(oConfiguration.press,this);
			}

					oControl = new (fnClass)(sId, oConfiguration); // sId might actually contain oConfiguration, the Element constructor will take care of this

					// placeAt first DomRef in collection
					oControl.placeAt(this);
					// TODO: avoid the direct call to applyChanges() in favor of a delayed version that potentially bundles several changes
					//sap.ui.getCore().applyChanges();
				}
			}

		});
	};

	return jQuery;

}, /* bExport= */ false);

}; // end of jquery.sap.ui.js
sap.ui.define("sap/ui/core/UIArea",['jquery.sap.global', 'sap/ui/base/ManagedObject', './Element', 'jquery.sap.act', 'jquery.sap.ui'],
	function(jQuery, ManagedObject, Element/* , jQuerySap1, jQuerySap */) {
	"use strict";


	/**
	 * @class An area in a page that hosts a tree of UI elements.
	 *
	 * Provides means for event-handling, rerendering, etc.
	 * 
	 * Special aggregation "dependents" is connected to the lifecycle management and databinding,
	 * but not rendered automatically and can be used for popups or other dependent controls. This allows
	 * definition of popup controls in declarative views and enables propagation of model and context
	 * information to them.
	 *
	 * @extends sap.ui.base.ManagedObject
	 * @author SAP AG
	 * @version 1.20.6
	 * @param {sap.ui.Core} oCore internal API of the <core>Core</code> that manages this UIArea
	 * @param {object} [oRootNode] reference to the Dom Node that should be 'hosting' the UI Area.
	 * @public
	 */
	var UIArea = ManagedObject.extend("sap.ui.core.UIArea", {
		constructor: function(oCore, oRootNode) {
			if(arguments.length === 0) {
				return;
			}
	
			// Note: UIArea has a modifiable Id. This doesn't perfectly match the default behavior of ManagedObject
			// But UIArea overrides getId().
			ManagedObject.apply(this);
	
			//TODO we could get rid of oCore here, if we wanted to...
			this.oCore = oCore;
			this.bLocked = false;
			this.bInitial = true;
			this.aContentToRemove = [];
			
			this.bNeedsRerendering = false;
			if (oRootNode != null) {
				this.setRootNode(oRootNode);
				// Figure out whether UI Area is pre-rendered (server-side JS rendering)!
				this.bNeedsRerendering = this.bNeedsRerendering && !jQuery.sap.domById(oRootNode.id + "-Init");
			}
			this.mInvalidatedControls = {};
	
			if(!this.bNeedsRerendering) {
				this.oRenderControl = null;
			} else {
				// Core needs to be notified about an invalid UIArea
				this.oCore.addInvalidatedUIArea(this);
			}
	
		},
		metadata: {
			// ---- object ----
			publicMethods : ["setRootNode", "getRootNode", "setRootControl", "getRootControl", "lock","unlock", "isLocked"],
			aggregations : {
				content : {name : "content", type : "sap.ui.core.Control", multiple : true, singularName : "content"},
				dependents : {name : "dependents", type : "sap.ui.core.Control", multiple : true}
			}
		}
	});
	
	/**
	 * Returns whether rerendering is currently suppressed on this UIArea
	 * @return boolean
	 * @protected
	 * @name sap.ui.core.UIArea#isInvalidateSuppressed
	 * @function
	 */
	UIArea.prototype.isInvalidateSuppressed = function() {
		return this.iSuppressInvalidate > 0;
	};
	
	/**
	 * Returns this <code>UIArea</code>'s id (as determined from provided RootNode).
	 * @return {string} id of this UIArea
	 * @public
	 *
	 * TODO what is this needed for? ID can change and getRootNode() is also there...
	 * Is this part of "UI area is like an Element" contract?
	 * @name sap.ui.core.UIArea#getId
	 * @function
	 */
	UIArea.prototype.getId = function() {
		return this.oRootNode ? this.oRootNode.id : null;
	};
	
	/**
	 * Returns this UI area. Needed to stop recursive calls from an element to its parent.
	 *
	 * @return {sap.ui.core.UIArea} this
	 * @protected
	 * @name sap.ui.core.UIArea#getUIArea
	 * @function
	 */
	UIArea.prototype.getUIArea = function() {
		return this;
	};
	
	/**
	 * Allows setting the Root Node hosting this instance of <code>UIArea</code>.<br/> The Dom Ref must have an Id that
	 * will be used as Id for this instance of <code>UIArea</code>.
	 *
	 * @param {object}
	 *            oRootNode the hosting Dom Ref for this instance of <code>UIArea</code>.
	 * @public
	 * @name sap.ui.core.UIArea#setRootNode
	 * @function
	 */
	UIArea.prototype.setRootNode = function(oRootNode) {
		if(this.oRootNode === oRootNode) {
			return;
		}
	
		// oRootNode must either be empty or must be a DOMElement and must not be root node of some other UIArea
		jQuery.sap.assert(!oRootNode || (oRootNode.nodeType === 1 && !jQuery(oRootNode).attr("data-sap-ui-area")), "UIArea root node must be a DOMElement");
	
		//TODO IS there something missing
		if(this.oRootNode) {
			this._ondetach();
		}
	
		this.oRootNode = oRootNode;
		if ( this.getContent().length > 0 ) {
		  this.invalidate();
		}
	
		if(this.oRootNode) {
			// prepare eventing
			this._onattach();
		}
	};
	
	/**
	 * Returns the Root Node hosting this instance of <code>UIArea</code>.
	 *
	 * @return {Element} the Root Node hosting this instance of <code>UIArea</code>.
	 * @public
	 * @name sap.ui.core.UIArea#getRootNode
	 * @function
	 */
	UIArea.prototype.getRootNode = function() {
		return this.oRootNode;
	};
	
	/**
	 * Sets the root control to be displayed in this UIArea.
	 *
	 * First, all old content controls (if any) will be detached from this UIArea (e.g. their parent
	 * relationship to this UIArea will be cut off). Then the parent relationship for the new
	 * content control (if not empty) will be set to this UIArea and finally, the UIArea will
	 * be marked for re-rendering.
	 *
	 * The real re-rendering happens whenever the re-rendering is called. Either implicitly
	 * at the end of any control event or by calling sap.ui.getCore().applyChanges().
	 *
	 * @param {sap.ui.base.Interface | sap.ui.core.Control}
	 *            oRootControl the Control that should be the Root for this <code>UIArea</code>.
	 * @public
	 * @deprecated use functions <code>removeAllContent</code> and <code>addContent</code> instead
	 * @name sap.ui.core.UIArea#setRootControl
	 * @function
	 */
	UIArea.prototype.setRootControl = function(oRootControl) {
		this.removeAllContent();
		this.addContent(oRootControl);
	};
	
	/**
	 * Returns the content control of this <code>UIArea</code> at the specified index.
	 * If no index is given the first content control is returned.
	 *
	 * @param {int} idx index of the control in the content of this <code>UIArea</code>
	 * @return {sap.ui.core.Control} the content control of this <code>UIArea</code> at the specified index.
	 * @public
	 * @deprecated use function <code>getContent</code> instead
	 * @name sap.ui.core.UIArea#getRootControl
	 * @function
	 */
	UIArea.prototype.getRootControl = function(idx) {
		var aContent = this.getContent();
		if(aContent.length > 0){
			if(idx >=0 && idx < aContent.length) {
				return aContent[idx];
			}
			return aContent[0];
		}
		return null;
	};
	
	UIArea.prototype._addRemovedContent = function(oDomRef) {
		if(this.oRootNode && oDomRef) {
			this.aContentToRemove.push(oDomRef);
		}
	};
	
	/**
	 * Getter for aggregation <code>content</code>.<br/>
	 *
	 * @return {sap.ui.core.Control[]}
	 * @public
	 * @name sap.ui.core.UIArea.prototype.getContent
	 */
	
	/**
	 * Inserts a content into the aggregation named <code>content</code>.
	 *
	 * @param {sap.ui.core.Control}
	 *          oContent the content to insert; if empty, nothing is inserted
	 * @param {int}
	 *			iIndex the <code>0</code>-based index the content should be inserted at; for
	 *             a negative value of <code>iIndex</code>, the content is inserted at position 0; for a value
	 *             greater than the current size of the aggregation, the content is inserted at
	 *             the last position
	 * @return {sap.ui.core.UIArea} <code>this</code> to allow method chaining
	 * @public
	 * @name sap.ui.core.UIArea.prototype.insertContent
	 */
	
	/**
	 * Adds some content <code>oContent</code>
	 * to the aggregation named <code>content</code>.
	 *
	 * @param {sap.ui.core.Control}
	 *            oContent the content to add; if empty, nothing is inserted
	 * @return {sap.ui.core.UIArea} <code>this</code> to allow method chaining
	 * @public
	 * @name sap.ui.core.UIArea#addContent
	 * @function
	 */
	UIArea.prototype.addContent = function(oContent, _bSuppressInvalidate) {
		this.addAggregation("content", oContent, _bSuppressInvalidate);
		// TODO this remains here just to make the UX3 Shell work which doesn't invalidate properly
		if ( _bSuppressInvalidate !== true ) {
			this.invalidate();
		}
		return this;
	};
	
	/**
	 * Removes an content from the aggregation named <code>content</code>.
	 *
	 * @param {int | string | sap.ui.core.Control} vContent the content to remove or its index or id
	 * @return {sap.ui.core.Control} the removed element or null
	 * @public
	 * @name sap.ui.core.UIArea#removeContent
	 * @function
	 */
	UIArea.prototype.removeContent = function(vContent, _bSuppressInvalidate) {
		var oContent = this.removeAggregation("content", vContent, _bSuppressInvalidate);
		if ( !_bSuppressInvalidate ) {
			var oDomRef;
			if(oContent && oContent.getDomRef) {
				oDomRef = oContent.getDomRef();
			}
			this._addRemovedContent(oDomRef);
			//this.invalidate();
		}
		return oContent;
	};
	
	/**
	 * Removes all the controls in the aggregation named <code>content</code>.<br/>
	 * Additionally unregisters them from the hosting UIArea.
	 * @return {sap.ui.core.Control[]} an array of the removed elements (might be empty)
	 * @public
	 * @name sap.ui.core.UIArea#removeAllContent
	 * @function
	 */
	UIArea.prototype.removeAllContent = function() {
		var aContent = this.removeAllAggregation("content");
		for(var idx=0; idx<aContent.length; idx++){
			var oDomRef;
			var oContent = aContent[idx];
			if(oContent && oContent.getDomRef) {
				oDomRef = oContent.getDomRef();
			}
			this._addRemovedContent(oDomRef);
		}
		//this.invalidate();
		return aContent;
	};
	
	/**
	 * Checks for the provided <code>sap.ui.core.Control</code> in the aggregation named <code>content</code>
	 * and returns its index if found or -1 otherwise.
	 *
	 * @param {sap.ui.core.Control}
	 *            oContent the content whose index is looked for.
	 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
	 * @public
	 * @name sap.ui.core.UIArea.prototype.indexOfContent
	 */
	
	/**
	 * Destroys all the content in the aggregation
	 * named <code>content</code>.
	 * @return {sap.ui.core.UIArea} <code>this</code> to allow method chaining
	 * @public
	 * @name sap.ui.core.UIArea#destroyContent
	 * @function
	 */
	UIArea.prototype.destroyContent = function() {
		var aContent = this.getContent();
		for(var idx=0; idx<aContent.length; idx++){
			var oDomRef;
			var oContent = aContent[idx];
			if(oContent && oContent.getDomRef) {
				oDomRef = oContent.getDomRef();
			}
			this._addRemovedContent(oDomRef);
		}
		this.destroyAggregation("content");
		//this.invalidate();
		return this;
	};
	
	
	/**
	 * Getter for aggregation <code>dependents</code>.<br/>
	 *
	 * @return {sap.ui.core.Control[]}
	 * @function
	 * @name sap.ui.core.UIArea.prototype.getDependents
	 * @since 1.19
	 * @public
	 */
	
	/**
	 * Inserts a control into the aggregation named <code>dependents</code>.
	 *
	 * @param {sap.ui.core.Control}
	 *          oControl the control to insert; if empty, nothing is inserted
	 * @param {int}
	 *             iIndex the <code>0</code>-based index the control should be inserted at; for
	 *             a negative value of <code>iIndex</code>, the control is inserted at position 0; for a value
	 *             greater than the current size of the aggregation, the control is inserted at
	 *             the last position
	 * @return {sap.ui.core.UIArea} <code>this</code> to allow method chaining
	 * @function
	 * @name sap.ui.core.UIArea.prototype.insertDependent
	 * @since 1.19
	 * @public
	 */
	
	/**
	 * Adds some control <code>oControl</code>
	 * to the aggregation named <code>dependents</code>.
	 *
	 * @param {sap.ui.core.Control}
	 *            oControl the control to add; if empty, nothing is inserted
	 * @return {sap.ui.core.UIArea} <code>this</code> to allow method chaining
	 * @function
	 * @name sap.ui.core.UIArea.prototype.addDependent
	 * @since 1.19
	 * @public
	 */
	
	/**
	 * Removes a control from the aggregation named <code>dependents</code>.
	 *
	 * @param {int | string | sap.ui.core.Control} vControl the control to remove or its index or id
	 * @return {sap.ui.core.Control} the removed control or null
	 * @function
	 * @name sap.ui.core.UIArea.prototype.removeDependent
	 * @since 1.19
	 * @public
	 */
	
	/**
	 * Removes all the controls in the aggregation named <code>dependents</code>.<br/>
	 *
	 * @return {sap.ui.core.Control[]} an array of the removed controls (might be empty)
	 * @function
	 * @name sap.ui.core.UIArea.prototype.removeAllDependents
	 * @since 1.19
	 * @public
	 */
	
	/**
	 * Checks for the provided <code>sap.ui.core.Control</code> in the aggregation named <code>dependents</code>
	 * and returns its index if found or -1 otherwise.
	 *
	 * @param {sap.ui.core.Control}
	 *            oControl the control whose index is looked for.
	 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
	 * @function
	 * @name sap.ui.core.UIArea.prototype.indexOfDependent
	 * @since 1.19
	 * @public
	 */
	
	/**
	 * Destroys all the controls in the aggregation
	 * named <code>dependents</code>.
	 * @return {sap.ui.core.UIArea} <code>this</code> to allow method chaining
	 * @function
	 * @name sap.ui.core.UIArea.prototype.destroyDependents
	 * @since 1.19
	 * @public
	 */
	
	
	/**
	 * Locks this instance of UIArea.
	 *
	 * Rerendering and eventing will not be active as long as no
	 * {@link #unlock} is called.
	 *
	 * @public
	 * @name sap.ui.core.UIArea#lock
	 * @function
	 */
	UIArea.prototype.lock = function() {
		this.bLocked = true;
	};
	
	/**
	 * Un-Locks this instance of UIArea.
	 *
	 * Rerendering and eventing will now be enabled again.
	 *
	 * @public
	 * @name sap.ui.core.UIArea#unlock
	 * @function
	 */
	UIArea.prototype.unlock = function() {
		if ( this.bLocked && this.bNeedsRerendering ) {
			// While being locked, we might have ignored a call to rerender()
			// Therefore notify the Core (again)
			this.oCore.addInvalidatedUIArea(this);
		}
		this.bLocked = false;
	};
	
	/**
	 * Returns the locked state of the <code>sap.ui.core.UIArea</code>
	 * @type boolean
	 * @return locked state
	 * @public
	 * @name sap.ui.core.UIArea#isLocked
	 * @function
	 */
	UIArea.prototype.isLocked = function () {
		return this.bLocked;
	};
	
	/**
	 * Provide getBindingContext, as UIArea can be parent of an element.
	 * Always returns null.
	 *
	 * @protected
	 * @name sap.ui.core.UIArea#getBindingContext
	 * @function
	 */
	UIArea.prototype.getBindingContext = function(){
		return null;
	};
	
	/**
	 * Returns the Core as new eventing parent to enable control event bubbling to the core to ensure compatibility with the core validation events. 
	 * 
	 * @return {sap.ui.base.EventProvider} the parent event provider
	 * @protected
	 * @name sap.ui.core.UIArea#getEventingParent
	 * @function
	 */
	UIArea.prototype.getEventingParent = function() {
		return this.oCore;
	};
	
	// ###########################################################################
	// Convenience for methods
	// e.g. Process Events for inner Controls
	// or figure out whether control is part of this area.
	// ###########################################################################
	
	/**
	 * Checks whether the control is still valid (is in the DOM)
	 *
	 * @return {boolean} True if the control is still in the active DOM
	 * @protected
	 * @name sap.ui.core.UIArea#isActive
	 * @function
	 */
	UIArea.prototype.isActive = function() {
		return jQuery.sap.domById(this.getId()) != null;
	};
	
	/**
	 * Will be used as end-point for invalidate-bubbling from controls up their hierarchy.<br/> Triggers re-rendering of
	 * the UIAreas content.
	 * @protected
	 * @name sap.ui.core.UIArea#invalidate
	 * @function
	 */
	UIArea.prototype.invalidate = function() {
		this.addInvalidatedControl(this);
	};
	
	/**
	 * Notifies the UIArea about an just invalidated control.
	 *
	 * The UIArea internally decides whether to re-render just the modified
	 * controls or the complete content. It also informs the Core when it
	 * becomes invalid the first time.
	 *
	 * TODO this.oRenderControl is either NULL or THIS. change to boolean?!
	 * @protected
	 * @name sap.ui.core.UIArea#addInvalidatedControl
	 * @function
	 */
	UIArea.prototype.addInvalidatedControl = function(oControl){
		if (this.oRenderControl == this) {
			return;
		}
	
		// inform the Core, if we are getting invalid now
		if ( !this.bNeedsRerendering ) {
			this.oCore.addInvalidatedUIArea(this);
		}
	
		var sId = oControl.getId();
		//check whether the control is already invalidated
		if (/*jQuery.inArray(oControl, this.getContent()) || */oControl == this ) {
			this.oRenderControl = this; //everything in this UIArea
			this.bNeedsRerendering = true;
			return;
		}
		if (this.mInvalidatedControls[sId]) {
			return;
		}
		if (!this.oRenderControl) {
			//add it to the list of controls
			this.mInvalidatedControls[sId] = oControl;
			this.bNeedsRerendering = true;
		}
	};
	
	/**
	 * TODO review and maybe refactor this complex algorithm
	 * TODO documentation
	 * TODO detach current "rerendering infos" before starting rerendering. Necessary to properly deal with concurrent modifications 
	 * @param force {boolean} true, if the rerendering of the UI area should be forced
	 * @return {boolean} whether a redraw was necessary or not
	 * @private
	 * @name sap.ui.core.UIArea#rerender
	 * @function
	 */
	UIArea.prototype.rerender = function(force){
		if (force) {
			this.bNeedsRerendering = true;
		}
		if ( this.bLocked || !this.bNeedsRerendering ) {
			return false;
		}
		
		var that = this;
	
		// pause performance measurement for all UI Areas
		jQuery.sap.measure.pause("rerenderAllUIAreas");
		// start performance measurement
		jQuery.sap.measure.start(this.getId()+"---rerender","Rerendering of "+this.getMetadata().getName());
	
		if (this.oRenderControl == this) {
			if (this.oRootNode) {
				jQuery.sap.log.info("Rerendering of UI area: " + this.getId());
	
				// save old content
				sap.ui.core.RenderManager.preserveContent(this.oRootNode, /* bPreserveRoot */ false, /* bPreserveNodesWithId */ this.bInitial);
				this.bInitial = false;
				
				var cleanUpDom = function(aCtnt, bCtrls){
					var len = aCtnt.length;
					var oDomRef;
					for(var i=0; i<len; i++) {
						oDomRef = bCtrls ? aCtnt[i].getDomRef() : aCtnt[i];
						if ( oDomRef && !sap.ui.core.RenderManager.isPreservedContent(oDomRef) && that.oRootNode === oDomRef.parentNode) {
							jQuery(oDomRef).remove();
						}
					}
					return len;
				}
	
				//First remove the old Dom nodes and then render the controls again
				cleanUpDom(this.aContentToRemove);
				this.aContentToRemove = [];
	
				var aContent = this.getContent();
				var len = cleanUpDom(aContent, true);
	
				for(var i=0; i<len; i++){
					this.oCore.oRenderManager.render(aContent[i], this.oRootNode, true);
				}
			} else { // cannot re-render now; wait!
				// end performance measurement
				jQuery.sap.measure.end(this.getId()+"---rerender");
				// resume performance measurement for all UI Areas
				jQuery.sap.measure.resume("rerenderAllUIAreas");
				return false;
			}
		} else {
			var isAncestorInvalidated = function(oAncestor) {
				while ( oAncestor && oAncestor !== that ) {
					if ( that.mInvalidatedControls.hasOwnProperty(oAncestor.getId()) ) {
						return true;
					}
					// Controls that implement marker interface sap.ui.core.PopupInterface are by contract not rendered by their parent.
					// Therefore the search for invalid ancestors must be stopped when such a control is reached. 
					if ( oAncestor && oAncestor.getMetadata && oAncestor.getMetadata().isInstanceOf("sap.ui.core.PopupInterface") ) {
						break;
					}
					oAncestor = oAncestor.getParent();
				}
				return false;
			}
			for (var n in this.mInvalidatedControls) { // TODO for in skips some names in IE8!
				var oControl = this.oCore.byId(n);
				// CSN 0000834961 2011: control may have been destroyed since invalidation happened
				if ( oControl && !isAncestorInvalidated(oControl.getParent()) ) {
					oControl.rerender();
				}
			}
	
		}
	
		this.oRenderControl = null;
		this.mInvalidatedControls = {};
		this.bNeedsRerendering = false;
	
		// end performance measurement
		jQuery.sap.measure.end(this.getId()+"---rerender");
		// resume performance measurement for all UI Areas
		jQuery.sap.measure.resume("rerenderAllUIAreas");
		return true;
	
	};
	
	/**
	 * Rerenders the given control
	 * @see sap.ui.core.Control.rerender()
	 * @param oControl
	 * @private
	 * @name sap.ui.core.UIArea.rerenderControl
	 * @function
	 */
	UIArea.rerenderControl = function(oControl){
		var oDomRef = oControl ? oControl.getDomRef() : null;
		var oParentDomRef = oDomRef && oDomRef.parentNode; // remember parent here as preserveContent() might move the node!
		if(oParentDomRef){
			var uiArea = oControl.getUIArea();
			var rm = uiArea ? uiArea.oCore.oRenderManager : sap.ui.getCore().createRenderManager();
			jQuery.sap.log.info("Rerendering of control (using Core-RenderManager: "+(!!uiArea)+"): " + oControl.getId());
			sap.ui.core.RenderManager.preserveContent(oDomRef, /* bPreserveRoot */ true, /* bPreserveNodesWithId */ false);
			rm.render(oControl, oParentDomRef);
		} else {
			jQuery.sap.log.warning("Couldn't rerender '" + oControl.getId() + "', as its DOM location couldn't be determined");
		}
	};
	
	/**
	 * Handles all incoming DOM events centrally and dispatches the event to the
	 * registered event handlers.
	 * @param {jQuery.Event} oEvent the jQuery event object
	 * @private
	 * @name sap.ui.core.UIArea#_handleEvent
	 * @function
	 */
	UIArea.prototype._handleEvent = function(/**event*/oEvent) {
	
		// execute the registered event handlers
		var oElement = null;
	
		// TODO: this should be the 'lowest' SAPUI5 Control of this very
		// UIArea instance's scope -> nesting scenario
		oElement = jQuery(oEvent.target).control(0);
		
		jQuery.sap.act.refresh();
		
		if(oElement === null){
			return;
		}
		
	// the mouse event which is fired by mobile browser with a certain delay after touch event should be suppressed
	// in event delegation.
	if(oEvent.isMarked("delayedMouseEvent")){
		return;
	}
	
		//if event is already handled by inner UIArea (as we use the bubbling phase now), returns.
		//if capturing phase would be used, here means event is already handled by outer UIArea.
	if(oEvent.isMarked("handledByUIArea")){
		oEvent.setMark("firstUIArea", false);
			return;
		}
	oEvent.setMarked("firstUIArea");
	
		// store the element on the event (aligned with jQuery syntax)
		oEvent.srcControl = oElement;
	
		// forward the control event:
		// if the control propagation has been stopped or the default should be
		// prevented then do not forward the control event.
		this.oCore._handleControlEvent(oEvent, this.getId());
	
		// if the UIArea or the Core is locked then we do not dispatch
		// any event to the control => but they will still be dispatched
		// as control event afterwards!
		if (this.bLocked || this.oCore.isLocked()) {
			return;
		}
	
		// retrieve the pseudo event types
		var aEventTypes = [];
		if(oEvent.getPseudoTypes){
			aEventTypes = oEvent.getPseudoTypes();
		}
		aEventTypes.push(oEvent.type);
	
		// dispatch the event to the controls (callback methods: onXXX)
		while (oElement && oElement instanceof Element && oElement.isActive() && !oEvent.isPropagationStopped()) {
	
			// for each event type call the callback method
			// if the execution should be stopped immediately
			// then no further callback method will be executed
			for (var i = 0, is = aEventTypes.length; i < is; i++) {
				var sType = aEventTypes[i];
				oEvent.type = sType;
				// ensure currenTarget is the DomRef of the handling Control
				oEvent.currentTarget = oElement.getDomRef();
				oElement._handleEvent(oEvent);
				if(oEvent.isImmediatePropagationStopped()) {
					break;
				}
			}
	
			// if the propagation is stopped do not bubble up further
			if(oEvent.isPropagationStopped()) {
				break;
			}
	
			// Secret property on the element to allow to cancel bubbling of all events.
			// This is a very special case, so there is no API method for this in the control. 
			if (oElement.bStopEventBubbling) {
				break;
			}
			
			// This is the (not that common) situation that the element was deleted in its own event handler.
			// i.e. the Element became 'inactive' (see Element#isActive())
			var oDomRef = oElement.getDomRef();
			if(!oDomRef) {
				break;
			}
	
			// bubble up to the parent
			oDomRef = oDomRef.parentNode;
			oElement = null;
	
		// Only process the touchend event which is emulated from mouseout event when the current domRef 
		// doesn't equal or contain the relatedTarget
		if (oEvent.isMarked("fromMouseout") && jQuery.sap.containsOrEquals(oDomRef, oEvent.relatedTarget)) {
			break;
		}

			// ensure we do not bubble the control tree higher than our rootNode
			while (oDomRef && oDomRef !== this.getRootNode()) {
				if (oDomRef.id) {
					oElement = jQuery(oDomRef).control(0);
					if (oElement) {
						break;
					}
				}
				oDomRef = oDomRef.parentNode;
			}
	
		}
	
		// reset previously changed currentTarget
		oEvent.currentTarget = this.getRootNode();
		
		// mark on the event that it's already handled by this UIArea
		(oEvent.originalEvent || oEvent)._sapui_handledByUIArea = true;
	
		// TODO: rethink about logging levels!
	
		// logging: propagation stopped
		if (oEvent.isPropagationStopped()) {
			jQuery.sap.log.debug("'" + oEvent.type + "' propagation has been stopped");
		}
	
		// logging: prevent the logging of some events and for others do some
		//          info logging into the console
		var sName = oEvent.type;
		if (sName!="mousemove" && sName!="mouseover" && sName!="scroll" && sName!="mouseout") {
			var oElem = jQuery(oEvent.target).control(0);
			if(oElem) {
				jQuery.sap.log.debug("Event fired: '" + oEvent.type + "' on " + oElem, "", "sap.ui.core.UIArea");
			}
			else {
				jQuery.sap.log.debug("Event fired: '" + oEvent.type + "'", "", "sap.ui.core.UIArea");
			}
		}
	
	};
	
	/*
	* The onattach function is called when the Element is attached to the DOM
	* @private
	* @name sap.ui.core.UIArea#_onattach
	* @function
	*/
	UIArea.prototype._onattach = function() {
	
	// TODO optimizations for 'matching event list' could be done here.
	//	// create the events string (space separated list of event names):
	//	// the first time a control is attached - it will determine the required
	//	// events and store this information in the controls metadata which is
	//	// shared across the control instances.
	//	if (!this.getMetadata().sEvents) {
	//
	//		// shorten the access to the array of events and pseudo events
	//		var aEv = jQuery.sap.ControlEvents;
	//		var oPsEv = jQuery.sap.PseudoEvents;
	//
	//		// create the data structures for the event handler registration
	//		this.sEvents = "";
	//		var aEvents = [];
	//
	//		// check for pseudo events and register them for their relevant types
	//		for (var evt in oPsEv) {
	//				for (j = 0, js = oPsEv[evt].aTypes.length; j < js; j++) {
	//					var type = oPsEv[evt].aTypes[j];
	//					if (jQuery.inArray(type, aEvents) == -1) {
	//						aEvents.push(type);
	//					}
	//				}
	//		}
	//
	//		// check for events and register them
	//		for (var i = 0, is = aEv.length; i < is; i++) {
	//			var type = aEv[i];
	//				if (jQuery.inArray(type, aEvents) == -1) {
	//					aEvents.push(type);
	//				}
	//		}
	//
	//		// keep the list of events for the jQuery bind/unbind method
	//		this.sEvents = aEvents.join(" ");
	//
	//		// cache the event handlers registry map
	//		this.getMetadata().sEvents = this.sEvents;
	//
	//	} else {
	//		// use the cached map of event handlers
	//		this.sEvents = this.getMetadata().sEvents;
	//	}
	
		// check for existing root node
		var oDomRef = this.getRootNode();
		if (oDomRef == null) {
			return;
		}
	
		//	mark the DOM as UIArea and bind the required events
		jQuery(oDomRef).attr("data-sap-ui-area", oDomRef.id).bind(jQuery.sap.ControlEvents.join(" "), jQuery.proxy(this._handleEvent, this));
	
	};
	
	/**
	* The ondetach function is called when the Element is detached out of the DOM
	* @private
	* @name sap.ui.core.UIArea#_ondetach
	* @function
	*/
	UIArea.prototype._ondetach = function() {
	
		// check for existing root node
		var oDomRef = this.getRootNode();
		if (oDomRef == null) {
			return;
		}
	
		// remove UIArea marker and unregister all event handlers of the control
		jQuery(oDomRef).removeAttr("data-sap-ui-area").unbind();
	
		// TODO: when optimizing the events => take care to unbind only the
		//       required. additionally consider not to remove other event handlers.
	//	var ojQRef = jQuery(oDomRef);
	//	if (this.sEvents) {
	//		ojQRef.unbind(this.sEvents, this._handleEvent);
	//	}
	//
	//	var oFH = this.oCore.oFocusHandler;
	//	ojQRef.unbind("focus",oFH.onfocusin);
	//	ojQRef.unbind("blur", oFH.onfocusout);
	
	};
	
	/**
	 * An UIArea can't be cloned and throws an error when trying to do so.
	 * @name sap.ui.core.UIArea#clone
	 * @function
	 */
	UIArea.prototype.clone = function() {
		throw new Error("UIArea can't be cloned");
	};
	
	

	return UIArea;

}, /* bExport= */ true);

}; // end of sap/ui/core/UIArea.js
if ( !jQuery.sap.isDeclared('sap.ui.core.tmpl.Template') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides base class sap.ui.core.tmpl.Template for all templates
jQuery.sap.declare('sap.ui.core.tmpl.Template'); // unresolved dependency added by SAPUI5 CreateModule Ant-Task
sap.ui.define("sap/ui/core/tmpl/Template",['jquery.sap.global', 'sap/ui/base/ManagedObject'],
	function(jQuery, ManagedObject) {
	"use strict";


	
	/**
	 * Creates and initializes a new template with the given <code>sId</code> and
	 * settings.
	 * 
	 * The set of allowed entries in the <code>mSettings</code> object depends on
	 * the concrete subclass and is described there. 
	 * 
	 * @param {string}
	 *            [sId] optional id for the new template; generated automatically if
	 *            no non-empty id is given Note: this can be omitted, no matter
	 *            whether <code>mSettings</code> will be given or not!
	 * @param {object}
	 *            [mSettings] optional map/JSON-object with initial settings for the
	 *            new component instance
	 * @public
	 * 
	 * @class Base Class for Template.
	 * @extends sap.ui.base.ManagedObject
	 * @abstract
	 * @author SAP
	 * @version 1.20.6
	 * @name sap.ui.core.tmpl.Template
	 * @experimental Since 1.15.0. The Template concept is still under construction, so some implementation details can be changed in future.
	 */
	var Template = ManagedObject.extend("sap.ui.core.tmpl.Template", /** @lends sap.ui.core.tmpl.Template */
	{
		
		constructor : function(sId, mSettings) {
			ManagedObject.apply(this, arguments);
		},
	
		metadata : {
			stereotype : "template",
			"abstract" : true,
			properties : {
				"content" : {type : "string", group : "Data", defaultValue : null}
			},
			publicMethods : [
				// methods
				"declareControl", /* protected */
				"createControl",  /* protected */
				"placeAt", 
				"createMetadata", 
				"createRenderer"
			],
			library : "sap.ui.core"
		}
	
	});
	
	
	/**
	 * @see sap.ui.base.Object#getInterface
	 * @public
	 * @name sap.ui.core.tmpl.Template#getInterface
	 * @function
	 */
	Template.prototype.getInterface = function() {
		return this;
	};
	
	
	/**
	 * Creates a new subclass of class sap.ui.core.tmpl.Template with name <code>sClassName</code> 
	 * and enriches it with the information contained in <code>oClassInfo</code>.
	 * 
	 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
	 *   
	 * @param {string} sClassName name of the class to be created
	 * @param {object} [oClassInfo] object literal with informations about the class  
	 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
	 * @return {function} the created class / constructor function
	 * @public
	 * @static
	 * @name sap.ui.core.tmpl.Template.extend
	 * @function
	 */
	
	
	/**
	 * Getter for property <code>content</code>.
	 * The Template definition as String.
	 *
	 * Default value is empty/<code>undefined</code>
	 *
	 * @return {string} the value of property <code>content</code>
	 * @public
	 * @name sap.ui.core.tmpl.Template#getContent
	 * @function
	 */
	
	/**
	 * Setter for property <code>content</code>.
	 *
	 * Default value is empty/<code>undefined</code> 
	 *
	 * @param {string} sContent  new value for property <code>content</code>
	 * @return {sap.ui.core.tmpl.Template} <code>this</code> to allow method chaining
	 * @public
	 * @name sap.ui.core.tmpl.Template#setContent
	 * @function
	 */
	
	
	/**
	 * registry for supported template types
	 * @private
	 * @name sap.ui.core.tmpl.Template._mSupportedTypes
	 */
	Template._mSupportedTypes = {};
	
	
	/**
	 * Registers a new Template type which is used to compile the template.
	 * 
	 * @param {string} sType type of the template
	 * @param {string} sClass the class of the specifc Template element
	 * 
	 * @static
	 * @name sap.ui.core.tmpl.Template.registerType
	 * @function
	 */
	Template.registerType = function(sType, sClass) {
		Template._mSupportedTypes[sType] = sClass;
	};
	
	/**
	 * Unregisters a Template type which is used to compile the template.
	 * 
	 * @param {string} sType type of the template
	 * 
	 * @static
	 * @name sap.ui.core.tmpl.Template.unregisterType
	 * @function
	 */
	Template.unregisterType = function(sType) {
		delete Template._mSupportedTypes[sType];
	};
	
	
	/**
	 * parses the given path and extracts the model and path
	 * 
	 * @param {string} sPath the path
	 * @return {object} the model and the path 
	 *
	 * @protected
	 * @static
	 * @name sap.ui.core.tmpl.Template.parsePath
	 * @function
	 */
	Template.parsePath = function(sPath) {
	
		// TODO: wouldn't this be something central in ManagedObject?
	
		// parse the path
		var sModelName = undefined, 
		    iSeparatorPos = sPath.indexOf(">");
	
		// if a model name is specified in the binding path
		// we extract this binding path
		if (iSeparatorPos > 0) {
			sModelName = sPath.substr(0, iSeparatorPos);
			sPath = sPath.substr(iSeparatorPos + 1);
		}
		
		// returns the path information 
		return {
			path: sPath,
			model: sModelName
		};
			
	};
						
	/*
	 * overridden to prevent instantiation of Template
	 * @name sap.ui.core.tmpl.Template#init
	 * @function
	 */
	Template.prototype.init = function(mSettings, oScope) {
		if (this.getMetadata().getName() === "sap.ui.core.tmpl.Template") {
			throw new Error("The class 'sap.ui.core.tmpl.Template' is abstract and must not be instantiated!");
		}
		// check for complex binding syntax
		if (ManagedObject.bindingParser === sap.ui.base.BindingParser.complexParser) {
			/*
			 * we disable the complex binding parser for Templates
			 * TODO: reconsider a better solution later
			 * @name sap.ui.core.tmpl.Template#extractBindingInfo
			 * @function
			 */
			Template.prototype.extractBindingInfo = function(oValue, bIgnoreObjects, oScope) {
				ManagedObject.bindingParser = sap.ui.base.BindingParser.simpleParser;
				var oReturnValue = sap.ui.core.Control.prototype.extractBindingInfo.apply(this, arguments);
				ManagedObject.bindingParser = sap.ui.base.BindingParser.complexParser;
				return oReturnValue;
			};
		};
	};
	
	
	/**
	 * Declares a new control based on this template and returns the created 
	 * class / constructor function. The class is based on the information coming 
	 * from the abstract functions <code>createMetadata</code> and 
	 * <code>createRenderer</code>.
	 * 
	 * @param {string} sControl the fully qualified name of the control
	 * @return {function} the created class / constructor function
	 * @public
	 * @name sap.ui.core.tmpl.Template#declareControl
	 * @function
	 */
	Template.prototype.declareControl = function(sControl) {
	
		jQuery.sap.assert(!!sControl, "A fully qualified name must be specified!");
		
		if (sControl) {
			
			// create the new control type
			var oMetadata = this.createMetadata(),
			    fnRenderer = this.createRenderer(),
			    that = this;
			jQuery.sap.require("sap.ui.core.tmpl.TemplateControl");
			sap.ui.core.tmpl.TemplateControl.extend(sControl, {
				
				// the new control metadata
				metadata: oMetadata,
				
				// set the reference to the template
				init: function() {
					sap.ui.core.tmpl.TemplateControl.prototype.init.apply(this, arguments);
					// link to the template
					this.setTemplate(that);
				},
	
				// add the custom renderer function
				renderer: {
					renderTemplate: fnRenderer
				}
				
			});
			
			// returns the constructor function
			return jQuery.sap.getObject(sControl);
					
		}
	
	};
	
	
	/**
	 * Creates an anonymous TemplateControl for the Template.
	 * 
	 * @param {string} sId the control ID
	 * @param {object} [oContext] the context for the renderer/templating
	 * @return {sap.ui.core.tmpl.TemplateControl} the created control instance
	 * @public
	 * @name sap.ui.core.tmpl.Template#createControl
	 * @function
	 */
	Template.prototype.createControl = function(sId, oContext, oView) {
		
		// create the anonymous control instance
		jQuery.sap.require("sap.ui.core.tmpl.TemplateControl");
		var oControl = new sap.ui.core.tmpl.TemplateControl({
		  id: sId,
		  template: this,
		  context: oContext
		});
		
		// for anonymous controls the renderer functions is added to the control instance
		oControl.setTemplateRenderer(this.createRenderer(oView));
		
		// return the control
		return oControl;
			
	};
	
	
	/**
	 * Creates an anonymous TemplateControl for the Template and places the control 
	 * into the specified DOM element.
	 * 
	 * @param {string|DomRef} oRef the id or the DOM reference where to render the template
	 * @param {object} [oContext] The context to use to evaluate the Template. It will be applied as value for the context property of the created control.
	 * @param {string|int} [oPosition] Describes the position where the control should be put into the container
	 * @return {sap.ui.core.tmpl.TemplateControl} the created control instance
	 * @public
	 * @name sap.ui.core.tmpl.Template#placeAt
	 * @function
	 */
	Template.prototype.placeAt = function(oRef, oContext, vPosition, bInline) {
	
		// parameter fallback
		if (typeof oContext === "string" || typeof oContext === "number") {
			vPosition = oContext;
			oContext = undefined;
		}
		
		// if the oRef is an ID or DomRef and the template should be rendered
		// inline we lookup the context from DOM element and mark the template
		// as an inline template to avoid additional elements around the template.
		var sId;
		if (!(oRef instanceof sap.ui.core.Control) && bInline) {
			
			// lookup the DOM element in which to place the template
			var $this = typeof oRef === "string" ? jQuery.sap.byId(oRef) : jQuery(oRef);
	
			// the DOM element must exist
			if ($this.length > 0) {
	
				// reuse the id for the template control
				sId = $this.attr("id");
				oRef = $this.get(0);
				
				// by default the context coming from sap.ui.template method will be used   
				// but it can be also defined on the root DOM element for inline templates
				// in case of inline templates we mark them
				var sContext = $this.attr("data-context");
				oContext = oContext || sContext && jQuery.parseJSON(sContext);
	
				// mark the template as inline template (to avoid extra DOM for the TemplateControl)
				// for inline templates the UIArea and the TemplateControl are the same DOM element  
				sap.ui.core.RenderManager.markInlineTemplate($this);
				
			}
			
		}
		
		// create the control (ID will be generated if not inline)
		var oControl = this.createControl(sId, oContext);
	
		// render the control into the specified domref
		oControl.placeAt(oRef, vPosition);
		
		// return the control
		return oControl;
			
	};
	
	
	/**
	 * Returns the metadata object for the new Control class. 
	 * This function needs to be implemented by sub classes of the Template.
	 * 
	 * @return {object} the metadata object of the new control class
	 * @abstract
	 * @name sap.ui.core.tmpl.Template#createMetadata
	 * @function
	 */
	Template.prototype.createMetadata = function() {
		jQuery.sap.log.error("The function createMetadata is an abstract function which needs to be implemented by subclasses.");
	};
	
	
	/**
	 * Returns the renderer function for the new Control class.
	 * This function needs to be implemented by sub classes of the Template.
	 * 
	 * @return {any} the renderer function for the new Control class.
	 * @abstract
	 * @name sap.ui.core.tmpl.Template#createRenderer
	 * @function
	 */
	Template.prototype.createRenderer = function() {
		jQuery.sap.log.error("The function createRenderer is an abstract function which needs to be implemented by subclasses.");
	};
	
	
	
	/**
	 * Creates a Template for the given id, dom reference or a configuration object.
	 * If no parameter is defined this function makes a lookup of DOM elements 
	 * which are specifying a type attribute. If the value of this type attribute
	 * matches an registered type then the content of this DOM element will be 
	 * used to create a new <code>Template</code> instance.
	 * 
	 * If you want to lookup all kind of existing and known templates and parse them
	 * directly you can simply call:
	 * <pre> 
	 *   sap.ui.template();
	 * </pre>
	 * 
	 * To parse a concrete DOM element you can do so by using this function in the 
	 * following way:
	 * <pre>
	 *   sap.ui.template("theTemplateId");
	 * </pre>
	 * 
	 * Or you can pass the reference to a DOM element and use this DOM element as 
	 * a source for the template:
	 * <pre>
	 *   sap.ui.template(oDomRef);
	 * </pre>
	 * 
	 * The last option to use this function is to pass the information via a 
	 * configuration object. This configuration object can be used to pass a 
	 * context for the templating framework when compiling the template:
	 * <pre>
	 *   var oTemplateById = sap.ui.template({
	 *     id: "theTemplateId",
	 *     context: { ... }
	 *   });
	 *
	 *   var oTemplateByDomRef = sap.ui.template({
	 *     domref: oDomRef,
	 *     context: { ... }
	 *   });
	 * </pre>
	 * 
	 * It can also be used to load a template from another file:
	 * <pre>
	 *   var oTemplate = sap.ui.template({
	 *     id: "myTemplate",
	 *     src: "myTemplate.tmpl"
	 *   });
	 * 
	 *   var oTemplateWithContext = sap.ui.template({
	 *     id: "myTemplate",
	 *     src: "myTemplate.tmpl",
	 *     context: { ... }
	 *   });
	 * </pre>
	 *
	 * The properties of the configuration object are the following:
	 * <ul>
	 * <li><code>id</code> - the ID of the Template / the ID  of the DOM element containing the source of the Template</li>
	 * <li><code>domref</code> - the DOM element containing the source of the Template</li>
	 * <li><code>type</code> - the type of the Template</li>
	 * <li><code>src</code> - the URL to lookup the template</li> (<i>experimental!</i>)
	 * <li><code>control</code> - the fully qualified name of the control to declare</li> (<i>experimental!</i>)
	 * </ul>
	 * 
	 * @param {string|DomRef|object} [oTemplate] the id or the DOM reference to the template to lookup or an configuration object containing the src, type and eventually the id of the Template.
	 * @return {sap.ui.core.tmpl.Template | sap.ui.core.tmpl.Template[]} the created Template instance 
	 *         or in case of usage without parametes any array of templates is returned
	 * 
	 * @public
	 * @static
	 */
	sap.ui.template = function(oTemplate) {
	
		// when no oTemplate is defined we need to lookup the elements in the document
		// and retrieve elements which have a type attribute which contains a value
		// of the supported types: 
		if (!oTemplate) {
		
			// lookup all kind of DOM elements for having a type which is supported
			var aTemplates = [];
			jQuery.each(Template._mSupportedTypes, function(sType, sClass) {
				jQuery("script[type='" + sType + "'], [data-type='" + sType + "']").each(function(iIndex, oElement) {
					aTemplates.push(sap.ui.template({
						id: oElement.id,
						domref: oElement,
						type: sType,
						_class: sClass /* helper to save lookup time in the supported types */
					}));
				});
			});
			return aTemplates;
			
		} else {
		
			// check the settings for being a string or a DOM element
			if (typeof oTemplate === "string") {
				return sap.ui.template({
					id: oTemplate
				});
			} else if (oTemplate && oTemplate.tagName && oTemplate.nodeName && oTemplate.ownerDocument && oTemplate.nodeType === 1) {
				// instanceof HTMLElement only works for modern browsers!
				return sap.ui.template({
					id: oTemplate.id,
					domref: oTemplate
				});
			} 
	
			// apply the default values
			oTemplate = jQuery.extend({
				type: Template.DEFAULT_TEMPLATE
			}, oTemplate);
	
			// in case of specifiying a src attribute for the configuration object
			// we load the template from a remote resource 
			var sId, sType, sControl, sContent, bRender, sController = false,
			    bLoadTemplate = typeof oTemplate.src === "string";
			if (bLoadTemplate) {
			
				// load the template from the specified URL
				var oResponse = jQuery.sap.sjax({
					url : oTemplate.src,
					dataType: "text"
				});
				
				// apply the content as template content
				// set the id, type and control if defined in the object
				if (oResponse.success) {
					sId = oTemplate.id,
					sType = oTemplate.type,
					sControl = oTemplate.control,
					sContent = oResponse.data;
					
					//Check for inline template information
					var rTmplInfo = /^<!--\sUI5:Template\stype=([a-z\/\-]*)\s(?:controller=([A-Za-z.]*)\s)?-->/,
						aTmplInfo = sContent.match(rTmplInfo);
					if (aTmplInfo) {
						sType = aTmplInfo[1];
						if (aTmplInfo.length == 3) {
							sController = aTmplInfo[2];
						}
						sContent = sContent.substr(aTmplInfo[0].length);
					}
				} else {
					throw new Error("The template could not be loaded from " + oTemplate.src + "!");
				}
			
			} else {
				
				// retrieve the required properties
				var oElement = oTemplate.domref || jQuery.sap.domById(oTemplate.id),
						$element = jQuery(oElement),
						bInline = false;
	
				// lookup the missing properties
				sId = oTemplate.id || oElement && oElement.id;
				sType = $element.attr("type") || oTemplate.type,
				sControl = $element.attr("data-control") || oTemplate.control;
						
				// lookup if the template for the current id and check this element for
				// beeing a subclass of sap.ui.core.tmpl.Template and return the existing
				// instance if found
				if (sId) {
					var theTemplate = sap.ui.getCore().getTemplate(sId);
					if (!theTemplate instanceof Template) {
						throw new Error("Object for id \"" + sId + "\" is no sap.ui.core.tmpl.Template!");
					} else {
						if (theTemplate) {
							return theTemplate;
						}
					}
				}
				
				// the element to parse must exist
				if ($element.length === 0) {
					throw new Error("DOM element for the Template with the id \"" + sId + "\" not found!");
				}
				
				// retrieve the content 
				sContent = $element.html();
	
				// check the preconditions for rendering and set the render property
				// if the DOM ref is part of the documents body
				var sTagName = oElement.tagName.toLowerCase();
				if (sTagName !== "script") {
					bInline = $element.parents("body").length === 1;
				}
				
			}
			
			// if not class is given we fallback to the type attribute on the 
			// template defintion.
			var sClass = oTemplate._class;
			if (!sClass) {
				sClass = Template._mSupportedTypes[sType];
				if (!sClass) {
					//sType = sap.ui.core.tmpl.Template.DEFAULT_TEMPLATE;
					throw new Error("The type \"" + sType + "\" is not supported.");
				}
			}
	
			// require and instantiate the proper template
			jQuery.sap.require(sClass);
			var oClass = jQuery.sap.getObject(sClass);
			    
			// create a new instance of the template
			var oInstance = new oClass({
				id: sId,
				content: sContent
			});
			
			// declare the control if specified
			if (sControl) {
				oInstance.declareControl(sControl);
			}
	
			// render inline templates immediately
			if (sController) {
				oInstance._sControllerName = sController
			}
	
			// render inline templates immediately
			if (bInline) {
				oInstance.placeAt(sId, oTemplate.context, undefined, true);
			}
	
			// return the template instance
			return oInstance;
			
		}
		
	};
	
	// define and register the default template
	Template.DEFAULT_TEMPLATE = "text/x-handlebars-template";
	Template.registerType(Template.DEFAULT_TEMPLATE, "sap.ui.core.tmpl.HandlebarsTemplate");
	

	return Template;

}, /* bExport= */ true);

}; // end of sap/ui/core/tmpl/Template.js
if ( !jQuery.sap.isDeclared('jquery.sap.events') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides functionality related to eventing.
jQuery.sap.declare('jquery.sap.events'); // unresolved dependency added by SAPUI5 CreateModule Ant-Task
if ( !jQuery.sap.isDeclared('jquery.sap.keycodes') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/*
 * Provides constants for key codes. Useful in the implementation of keypress/keydown event handlers.
 */
jQuery.sap.declare('jquery.sap.keycodes'); // unresolved dependency added by SAPUI5 CreateModule Ant-Task
sap.ui.define("jquery.sap.keycodes",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * Enumeration of key codes.
	 *
	 * @namespace
	 * @public
	 * @since 0.9.0
	 */
	jQuery.sap.KeyCodes = {
	
		/**
		 * @type number
		 * @public
		 */
		BACKSPACE : 8,
	
		/**
		 * @type number
		 * @public
		 */
		TAB : 9,
	
		/**
		 * @type number
		 * @public
		 */
		ENTER : 13,
	
		/**
		 * @type number
		 * @public
		 */
		SHIFT : 16,
	
		/**
		 * @type number
		 * @public
		 */
		CONTROL : 17,
	
		/**
		 * @type number
		 * @public
		 */
		ALT : 18,
	
		/**
		 * @type number
		 * @public
		 */
		BREAK : 19,
	
		/**
		 * @type number
		 * @public
		 */
		CAPS_LOCK : 20,
	
		/**
		 * @type number
		 * @public
		 */
		ESCAPE : 27,
	
		/**
		 * @type number
		 * @public
		 */
		SPACE : 32,
	
		/**
		 * @type number
		 * @public
		 */
		PAGE_UP : 33,
	
		/**
		 * @type number
		 * @public
		 */
		PAGE_DOWN : 34,
	
		/**
		 * @type number
		 * @public
		 */
		END : 35,
	
		/**
		 * @type number
		 * @public
		 */
		HOME : 36,
	
		/**
		 * @type number
		 * @public
		 */
		ARROW_LEFT : 37,
	
		/**
		 * @type number
		 * @public
		 */
		ARROW_UP : 38,
	
		/**
		 * @type number
		 * @public
		 */
		ARROW_RIGHT : 39,
	
		/**
		 * @type number
		 * @public
		 */
		ARROW_DOWN : 40,
	
		/**
		 * @type number
		 * @public
		 */
		PRINT : 44,
	
		/**
		 * @type number
		 * @public
		 */
		INSERT : 45,
	
		/**
		 * @type number
		 * @public
		 */
		DELETE : 46,
	
		/**
		 * @type number
		 * @public
		 */
		DIGIT_0 : 48,
	
		/**
		 * @type number
		 * @public
		 */
		DIGIT_1 : 49,
	
		/**
		 * @type number
		 * @public
		 */
		DIGIT_2 : 50,
	
		/**
		 * @type number
		 * @public
		 */
		DIGIT_3 : 51,
	
		/**
		 * @type number
		 * @public
		 */
		DIGIT_4 : 52,
	
		/**
		 * @type number
		 * @public
		 */
		DIGIT_5 : 53,
	
		/**
		 * @type number
		 * @public
		 */
		DIGIT_6 : 54,
	
		/**
		 * @type number
		 * @public
		 */
		DIGIT_7 : 55,
	
		/**
		 * @type number
		 * @public
		 */
		DIGIT_8 : 56,
	
		/**
		 * @type number
		 * @public
		 */
		DIGIT_9 : 57,
	
		/**
		 * @type number
		 * @public
		 */
		A : 65,
	
		/**
		 * @type number
		 * @public
		 */
		B : 66,
	
		/**
		 * @type number
		 * @public
		 */
		C : 67,
	
		/**
		 * @type number
		 * @public
		 */
		D : 68,
	
		/**
		 * @type number
		 * @public
		 */
		E : 69,
	
		/**
		 * @type number
		 * @public
		 */
		F : 70,
	
		/**
		 * @type number
		 * @public
		 */
		G : 71,
	
		/**
		 * @type number
		 * @public
		 */
		H : 72,
	
		/**
		 * @type number
		 * @public
		 */
		I : 73,
	
		/**
		 * @type number
		 * @public
		 */
		J : 74,
	
		/**
		 * @type number
		 * @public
		 */
		K : 75,
	
		/**
		 * @type number
		 * @public
		 */
		L : 76,
	
		/**
		 * @type number
		 * @public
		 */
		M : 77,
	
		/**
		 * @type number
		 * @public
		 */
		N : 78,
	
		/**
		 * @type number
		 * @public
		 */
		O : 79,
	
		/**
		 * @type number
		 * @public
		 */
		P : 80,
	
		/**
		 * @type number
		 * @public
		 */
		Q : 81,
	
		/**
		 * @type number
		 * @public
		 */
		R : 82,
	
		/**
		 * @type number
		 * @public
		 */
		S : 83,
	
		/**
		 * @type number
		 * @public
		 */
		T : 84,
	
		/**
		 * @type number
		 * @public
		 */
		U : 85,
	
		/**
		 * @type number
		 * @public
		 */
		V : 86,
	
		/**
		 * @type number
		 * @public
		 */
		W : 87,
	
		/**
		 * @type number
		 * @public
		 */
		X : 88,
	
		/**
		 * @type number
		 * @public
		 */
		Y : 89,
	
		/**
		 * @type number
		 * @public
		 */
		Z : 90,
	
		/**
		 * @type number
		 * @public
		 */
		WINDOWS : 91,
	
		/**
		 * @type number
		 * @public
		 */
		CONTEXT_MENU : 93,
	
		/**
		 * @type number
		 * @public
		 */
		TURN_OFF : 94,
	
		/**
		 * @type number
		 * @public
		 */
		SLEEP : 95,
	
		/**
		 * @type number
		 * @public
		 */
		NUMPAD_0 : 96,
	
		/**
		 * @type number
		 * @public
		 */
		NUMPAD_1 : 97,
	
		/**
		 * @type number
		 * @public
		 */
		NUMPAD_2 : 98,
	
		/**
		 * @type number
		 * @public
		 */
		NUMPAD_3 : 99,
	
		/**
		 * @type number
		 * @public
		 */
		NUMPAD_4 : 100,
	
		/**
		 * @type number
		 * @public
		 */
		NUMPAD_5 : 101,
	
		/**
		 * @type number
		 * @public
		 */
		NUMPAD_6 : 102,
	
		/**
		 * @type number
		 * @public
		 */
		NUMPAD_7 : 103,
	
		/**
		 * @type number
		 * @public
		 */
		NUMPAD_8 : 104,
	
		/**
		 * @type number
		 * @public
		 */
		NUMPAD_9 : 105,
	
		/**
		 * @type number
		 * @public
		 */
		NUMPAD_ASTERISK : 106,
	
		/**
		 * @type number
		 * @public
		 */
		NUMPAD_PLUS : 107,
	
		/**
		 * @type number
		 * @public
		 */
		NUMPAD_MINUS : 109,
	
		/**
		 * @type number
		 * @public
		 */
		NUMPAD_COMMA : 110,
	
		/**
		 * @type number
		 * @public
		 */
		NUMPAD_SLASH : 111,
	
		/**
		 * @type number
		 * @public
		 */
		F1 : 112,
	
		/**
		 * @type number
		 * @public
		 */
		F2 : 113,
	
		/**
		 * @type number
		 * @public
		 */
		F3 : 114,
	
		/**
		 * @type number
		 * @public
		 */
		F4 : 115,
	
		/**
		 * @type number
		 * @public
		 */
		F5 : 116,
	
		/**
		 * @type number
		 * @public
		 */
		F6 : 117,
	
		/**
		 * @type number
		 * @public
		 */
		F7 : 118,
	
		/**
		 * @type number
		 * @public
		 */
		F8 : 119,
	
		/**
		 * @type number
		 * @public
		 */
		F9 : 120,
	
		/**
		 * @type number
		 * @public
		 */
		F10 : 121,
	
		/**
		 * @type number
		 * @public
		 */
		F11 : 122,
	
		/**
		 * @type number
		 * @public
		 */
		F12 : 123,
	
		/**
		 * @type number
		 * @public
		 */
		NUM_LOCK : 144,
	
		/**
		 * @type number
		 * @public
		 */
		SCROLL_LOCK : 145,
	
		/**
		 * @type number
		 * @public
		 */
		OPEN_BRACKET : 186,
	
		/**
		 * @type number
		 * @public
		 */
		PLUS : 187,
	
		/**
		 * @type number
		 * @public
		 */
		COMMA : 188,
	
		/**
		 * @type number
		 * @public
		 */
		SLASH : 189,
	
		/**
		 * @type number
		 * @public
		 */
		DOT : 190,
	
		/**
		 * @type number
		 * @public
		 */
		PIPE : 191,
	
		/**
		 * @type number
		 * @public
		 */
		SEMICOLON : 192,
	
		/**
		 * @type number
		 * @public
		 */
		MINUS : 219,
	
		/**
		 * @type number
		 * @public
		 */
		GREAT_ACCENT : 220,
	
		/**
		 * @type number
		 * @public
		 */
		EQUALS : 221,
	
		/**
		 * @type number
		 * @public
		 */
		SINGLE_QUOTE : 222,
	
		/**
		 * @type number
		 * @public
		 */
		BACKSLASH : 226
	};

	return jQuery;

}, /* bExport= */ false);

}; // end of jquery.sap.keycodes.js
sap.ui.define("jquery.sap.events",['jquery.sap.global', 'jquery.sap.keycodes'],
	function(jQuery/* , jQuerySap1 */) {
	"use strict";

	jQuery.sap._touchToMouseEvent = true;

	var onTouchStart,
		onTouchMove,
		onTouchEnd,
		onTouchCancel,
		onMouseEvent,
		aMouseEvents,
		bIsSimulatingTouchToMouseEvent = false;

	if (sap.ui.Device.browser.webkit && /Mobile/.test(navigator.userAgent) && sap.ui.Device.support.touch) {

		bIsSimulatingTouchToMouseEvent = true;

		var simulateTouchToMouseEvent = (function() {
			var document = window.document,
				bHandleEvent = false,
				oTarget = null,
				bIsMoved = false,
				iStartX,
				iStartY,
				i = 0;

			aMouseEvents = ["mousedown", "mouseover", "mouseup", "mouseout", "click"];

			/**
			 * Fires a synthetic mouse event for a given type and native touch event.
			 * @param {String} sType the type of the synthetic event to fire, e.g. "mousedown"
			 * @param {jQuery.Event} oEvent the event object
			 * @private
			 */
			var fireMouseEvent = function(sType, oEvent) {

				if (!bHandleEvent) {
					return;
				}

				// we need mapping of the different event types to get the correct target
				var oMappedEvent = oEvent.type == "touchend" ? oEvent.changedTouches[0] : oEvent.touches[0]; 

				// create the synthetic event
				var newEvent = document.createEvent('MouseEvent');  // trying to create an actual TouchEvent will create an error
				newEvent.initMouseEvent(sType, true, true, window, oEvent.detail,
						oMappedEvent.screenX, oMappedEvent.screenY, oMappedEvent.clientX, oMappedEvent.clientY,
						oEvent.ctrlKey, oEvent.shiftKey, oEvent.altKey, oEvent.metaKey,
						oEvent.button, oEvent.relatedTarget);

				newEvent.isSynthetic = true;

				// Timeout needed. Do not interrupt the native event handling.
				window.setTimeout(function() {
						oTarget.dispatchEvent(newEvent);
				}, 0);
			};

			/**
			 * Checks if the target of the event is an input field.
			 * @param {jQuery.Event} oEvent the event object
			 * @return {Boolean} whether the target of the event is an input field.
			 */
			var isInputField = function(oEvent) {
				return oEvent.target.tagName.match(/input|textarea|select/i);
			};

			/**
			 * Mouse event handler. Prevents propagation for native events. 
			 * @param {jQuery.Event} oEvent the event object
			 * @private
			 */
			onMouseEvent = function(oEvent) {
				if (!oEvent.isSynthetic && !isInputField(oEvent)) {
					oEvent.stopPropagation();
					oEvent.preventDefault();
				}
			};

			/**
			 * Touch start event handler. Called whenever a finger is added to the surface. Fires mouse start event.
			 * @param {jQuery.Event} oEvent the event object
			 * @private
			 */
			onTouchStart = function(oEvent) {
				var oTouches = oEvent.touches,
					oTouch;

				bHandleEvent = (oTouches.length == 1 && !isInputField(oEvent));

				bIsMoved = false;
				if (bHandleEvent) {
					oTouch = oTouches[0];

					// As we are only interested in the first touch target, we remember it
					oTarget = oTouch.target;
					if (oTarget.nodeType === 3) {

						// no text node
						oTarget = oTarget.parentNode;
					}

					// Remember the start position of the first touch to determine if a click was performed or not.
					iStartX = oTouch.clientX;
					iStartY = oTouch.clientY;
					fireMouseEvent("mousedown", oEvent);
				}
			};

			/**
			 * Touch move event handler. Fires mouse move event.
			 * @param {jQuery.Event} oEvent the event object
			 * @private
			 */
			onTouchMove = function(oEvent) {
				var oTouch;

				if (bHandleEvent) {
					oTouch = oEvent.touches[0];

					// Check if the finger is moved. When the finger was moved, no "click" event is fired.
					if (Math.abs(oTouch.clientX - iStartX) > 10 || Math.abs(oTouch.clientY - iStartY) > 10) {
						bIsMoved = true;
					}

					if (bIsMoved) {

						// Fire "mousemove" event only when the finger was moved. This is to prevent unwanted movements. 
						fireMouseEvent("mousemove", oEvent);
					}
				}
			};

			/**
			 * Touch end event handler. Fires mouse up and click event.
			 * @param {jQuery.Event} oEvent the event object
			 * @private
			 */
			onTouchEnd = function(oEvent) {
				fireMouseEvent("mouseup", oEvent);
				if (!bIsMoved) {
					fireMouseEvent("click", oEvent);
				}
			};

			/**
			 * Touch cancel event handler. Fires mouse up event.
			 * @param {jQuery.Event} oEvent the event object
			 * @private
			 */
			onTouchCancel = function(oEvent) {
				fireMouseEvent("mouseup", oEvent);
			};

			// Bind mouse events
			for (; i < aMouseEvents.length; i++) {

				// Add click on capturing phase to prevent propagation if necessary
				document.addEventListener(aMouseEvents[i], onMouseEvent, true);
			}

			// Bind touch events
			document.addEventListener('touchstart', onTouchStart, true);
			document.addEventListener('touchmove', onTouchMove, true);
			document.addEventListener('touchend', onTouchEnd, true);
			document.addEventListener('touchcancel', onTouchCancel, true);
		}());
	}

	/**
	 * Disable touch to mouse handling
	 *
	 * @public
	 */
	jQuery.sap.disableTouchToMouseHandling = function() {
		var i = 0;

		if (!bIsSimulatingTouchToMouseEvent) {
			return;
		}

		// unbind touch events
		document.removeEventListener('touchstart', onTouchStart, true);
		document.removeEventListener('touchmove', onTouchMove, true);
		document.removeEventListener('touchend', onTouchEnd, true);
		document.removeEventListener('touchcancel', onTouchCancel, true);

		// unbind mouse events
		for (; i < aMouseEvents.length; i++) {
			document.removeEventListener(aMouseEvents[i], onMouseEvent, true);
		}
	};

	/**
	 * List of DOM events that a UIArea automatically takes care of.
	 *
	 * A control/element doesn't have to bind listeners for these events.
	 * It instead can implement an <code>on<i>event</i>(oEvent)</code> method
	 * for any of these events that it wants to be notified about.
	 *
	 * @public
	 */
	jQuery.sap.ControlEvents = [  // IMPORTANT: update the public documentation when extending this list
		"click",
		"dblclick",
		"focusin",
		"focusout",
		"keydown",
		"keypress",
		"keyup",
		"mousedown",
		"mouseout",
		"mouseover",
		"mouseup",
		"select",
		"selectstart",
		"dragstart",
		"dragenter",
		"dragover",
		"dragleave",
		"dragend",
		"drop",
		"paste",
		"cut"
	];

	// touch events natively supported
	if (sap.ui.Device.support.touch) {

		// Define additional native events to be added to the event list.
		// TODO: maybe add "gesturestart", "gesturechange", "gestureend" later?
		jQuery.sap.ControlEvents.push("touchstart", "touchend", "touchmove", "touchcancel");
	}

	/**
	 * Enumeration of all so called "pseudo events", a useful classification
	 * of standard browser events as implied by SAP product standards.
	 *
	 * Whenever a browser event is recognized as one or more pseudo events, then this
	 * classification is attached to the original {@link jQuery.Event} object and thereby
	 * delivered to any jQuery-style listeners registered for that browser event.
	 *
	 * Pure JavaScript listeners can evaluate the classification information using
	 * the {@link jQuery.Event#isPseudoType} method.
	 *
	 * Instead of using the procedure as described above, the SAPUI5 controls and elements
	 * should simply implement an <code>on<i>pseudo-event</i>(oEvent)</code> method. It will
	 * be invoked only when that specific pseudo event has been recognized. This simplifies event
	 * dispatching even further.
	 *
	 * @namespace
	 * @public
	 */
	jQuery.sap.PseudoEvents = { // IMPORTANT: update the public documentation when extending this list

		/* Pseudo keyboard events */

		/**
		 * Pseudo event for keyboard arrow down without modifiers (Ctrl, Alt or Shift)
		 * @public
		 */
		sapdown: {sName: "sapdown", aTypes: ["keydown"], fnCheck: function (oEvent) {
			return oEvent.keyCode == jQuery.sap.KeyCodes.ARROW_DOWN && !hasModifierKeys(oEvent);
		}},

		/**
		 * Pseudo event for keyboard arrow down with modifiers (Ctrl, Alt or Shift)
		 * @public
		 */
		sapdownmodifiers: {sName: "sapdownmodifiers", aTypes: ["keydown"], fnCheck: function(oEvent) {
			return oEvent.keyCode == jQuery.sap.KeyCodes.ARROW_DOWN && hasModifierKeys(oEvent);
		}},

		/**
		 * Pseudo event for pseudo 'show' event (F4, Alt + down-Arrow)
		 * @public
		 */
		sapshow: {sName: "sapshow", aTypes: ["keydown"], fnCheck: function(oEvent) {
			return (oEvent.keyCode == jQuery.sap.KeyCodes.F4 && !hasModifierKeys(oEvent)) ||
				(oEvent.keyCode == jQuery.sap.KeyCodes.ARROW_DOWN && checkModifierKeys(oEvent, /*Ctrl*/false, /*Alt*/true, /*Shift*/false));
		}},

		/**
		 * Pseudo event for keyboard arrow up without modifiers (Ctrl, Alt or Shift)
		 * @public
		 */
		sapup: {sName: "sapup", aTypes: ["keydown"], fnCheck: function(oEvent) {
			return oEvent.keyCode == jQuery.sap.KeyCodes.ARROW_UP && !hasModifierKeys(oEvent);
		}},

		/**
		 * Pseudo event for keyboard arrow up with modifiers (Ctrl, Alt or Shift)
		 * @public
		 */
		sapupmodifiers: {sName: "sapupmodifiers", aTypes: ["keydown"], fnCheck: function(oEvent) {
			return oEvent.keyCode == jQuery.sap.KeyCodes.ARROW_UP && hasModifierKeys(oEvent);
		}},

		/**
		 * Pseudo event for pseudo 'hide' event (Alt + up-Arrow)
		 * @public
		 */
		saphide: {sName: "saphide", aTypes: ["keydown"], fnCheck: function(oEvent) {
			return oEvent.keyCode == jQuery.sap.KeyCodes.ARROW_UP && checkModifierKeys(oEvent, /*Ctrl*/false, /*Alt*/true, /*Shift*/false);
		}},

		/**
		 * Pseudo event for keyboard arrow left without modifiers (Ctrl, Alt or Shift)
		 * @public
		 */
		sapleft: {sName: "sapleft", aTypes: ["keydown"], fnCheck: function(oEvent) {
			return oEvent.keyCode == jQuery.sap.KeyCodes.ARROW_LEFT && !hasModifierKeys(oEvent);
		}},

		/**
		 * Pseudo event for keyboard arrow left with modifiers (Ctrl, Alt or Shift)
		 * @public
		 */
		sapleftmodifiers: {sName: "sapleftmodifiers", aTypes: ["keydown"], fnCheck: function(oEvent) {
			return oEvent.keyCode == jQuery.sap.KeyCodes.ARROW_LEFT && hasModifierKeys(oEvent);
		}},

		/**
		 * Pseudo event for keyboard arrow right without modifiers (Ctrl, Alt or Shift)
		 * @public
		 */
		sapright: {sName: "sapright", aTypes: ["keydown"], fnCheck: function(oEvent) {
			return oEvent.keyCode == jQuery.sap.KeyCodes.ARROW_RIGHT && !hasModifierKeys(oEvent);
		}},

		/**
		 * Pseudo event for keyboard arrow right with modifiers (Ctrl, Alt or Shift)
		 * @public
		 */
		saprightmodifiers: {sName: "saprightmodifiers", aTypes: ["keydown"], fnCheck: function(oEvent) {
			return oEvent.keyCode == jQuery.sap.KeyCodes.ARROW_RIGHT && hasModifierKeys(oEvent);
		}},

		/**
		 * Pseudo event for keyboard Home/Pos1 with modifiers (Ctrl, Alt or Shift)
		 * @public
		 */
		saphome: {sName: "saphome", aTypes: ["keydown"], fnCheck: function(oEvent) {
			return oEvent.keyCode == jQuery.sap.KeyCodes.HOME && !hasModifierKeys(oEvent);
		}},

		/**
		 * Pseudo event for keyboard Home/Pos1 without modifiers (Ctrl, Alt or Shift)
		 * @public
		 */
		saphomemodifiers: {sName: "saphomemodifiers", aTypes: ["keydown"], fnCheck: function(oEvent) {
			return oEvent.keyCode == jQuery.sap.KeyCodes.HOME && hasModifierKeys(oEvent);
		}},

		/**
		 * Pseudo event for  pseudo top event
		 * @public
		 */
		saptop: {sName: "saptop", aTypes: ["keydown"], fnCheck: function(oEvent) {
			return oEvent.keyCode == jQuery.sap.KeyCodes.HOME && checkModifierKeys(oEvent, /*Ctrl*/true, /*Alt*/false, /*Shift*/false);
		}},

		/**
		 * Pseudo event for keyboard End without modifiers (Ctrl, Alt or Shift)
		 * @public
		 */
		sapend: {sName: "sapend", aTypes: ["keydown"], fnCheck: function(oEvent) {
			return oEvent.keyCode == jQuery.sap.KeyCodes.END && !hasModifierKeys(oEvent);
		}},

		/**
		 * Pseudo event for keyboard End with modifiers (Ctrl, Alt or Shift)
		 * @public
		 */
		sapendmodifiers: {sName: "sapendmodifiers", aTypes: ["keydown"], fnCheck: function(oEvent) {
			return oEvent.keyCode == jQuery.sap.KeyCodes.END && hasModifierKeys(oEvent);
		}},

		/**
		 * Pseudo event for pseudo bottom event
		 * @public
		 */
		sapbottom: {sName: "sapbottom", aTypes: ["keydown"], fnCheck: function(oEvent) {
			return oEvent.keyCode == jQuery.sap.KeyCodes.END && checkModifierKeys(oEvent, /*Ctrl*/true, /*Alt*/false, /*Shift*/false);
		}},

		/**
		 * Pseudo event for keyboard page up without modifiers (Ctrl, Alt or Shift)
		 * @public
		 */
		sappageup: {sName: "sappageup", aTypes: ["keydown"], fnCheck: function(oEvent) {
			return oEvent.keyCode == jQuery.sap.KeyCodes.PAGE_UP && !hasModifierKeys(oEvent);
		}},

		/**
		 * Pseudo event for keyboard page up with modifiers (Ctrl, Alt or Shift)
		 * @public
		 */
		sappageupmodifiers: {sName: "sappageupmodifiers", aTypes: ["keydown"], fnCheck: function(oEvent) {
			return oEvent.keyCode == jQuery.sap.KeyCodes.PAGE_UP && hasModifierKeys(oEvent);
		}},

		/**
		 * Pseudo event for keyboard page down without modifiers (Ctrl, Alt or Shift)
		 * @public
		 */
		sappagedown: {sName: "sappagedown", aTypes: ["keydown"], fnCheck: function(oEvent) {
			return oEvent.keyCode == jQuery.sap.KeyCodes.PAGE_DOWN && !hasModifierKeys(oEvent);
		}},

		/**
		 * Pseudo event for keyboard page down with modifiers (Ctrl, Alt or Shift)
		 * @public
		 */
		sappagedownmodifiers: {sName: "sappagedownmodifiers", aTypes: ["keydown"], fnCheck: function(oEvent) {
			return oEvent.keyCode == jQuery.sap.KeyCodes.PAGE_DOWN && hasModifierKeys(oEvent);
		}},

		/**
		 * Pseudo event for pseudo 'select' event... space, enter, ... without modifiers (Ctrl, Alt or Shift)
		 * @public
		 */
		sapselect: {sName: "sapselect", aTypes: ["keydown"], fnCheck: function(oEvent) {
			return (oEvent.keyCode == jQuery.sap.KeyCodes.ENTER || oEvent.keyCode == jQuery.sap.KeyCodes.SPACE) && !hasModifierKeys(oEvent);
		}},

		/**
		 * Pseudo event for pseudo 'select' event... space, enter, ... with modifiers (Ctrl, Alt or Shift)
		 * @public
		 */
		sapselectmodifiers: {sName: "sapselectmodifiers", aTypes: ["keydown"], fnCheck: function(oEvent) {
			return (oEvent.keyCode == jQuery.sap.KeyCodes.ENTER || oEvent.keyCode == jQuery.sap.KeyCodes.SPACE) && hasModifierKeys(oEvent);
		}},

		/**
		 * Pseudo event for keyboard space without modifiers (Ctrl, Alt or Shift)
		 * @public
		 */
		sapspace: {sName: "sapspace", aTypes: ["keydown"], fnCheck: function(oEvent) {
			return oEvent.keyCode == jQuery.sap.KeyCodes.SPACE && !hasModifierKeys(oEvent);
		}},

		/**
		 * Pseudo event for keyboard space with modifiers (Ctrl, Alt or Shift)
		 * @public
		 */
		sapspacemodifiers: {sName: "sapspacemodifiers", aTypes: ["keydown"], fnCheck: function(oEvent) {
			return oEvent.keyCode == jQuery.sap.KeyCodes.SPACE && hasModifierKeys(oEvent);
		}},

		/**
		 * Pseudo event for keyboard enter without modifiers (Ctrl, Alt or Shift)
		 * @public
		 */
		sapenter: {sName: "sapenter", aTypes: ["keydown"], fnCheck: function(oEvent) {
			return oEvent.keyCode == jQuery.sap.KeyCodes.ENTER && !hasModifierKeys(oEvent);
		}},

		/**
		 * Pseudo event for keyboard enter with modifiers (Ctrl, Alt or Shift)
		 * @public
		 */
		sapentermodifiers: {sName: "sapentermodifiers", aTypes: ["keydown"], fnCheck: function(oEvent) {
			return oEvent.keyCode == jQuery.sap.KeyCodes.ENTER && hasModifierKeys(oEvent);
		}},

		/**
		 * Pseudo event for keyboard backspace without modifiers (Ctrl, Alt or Shift)
		 * @public
		 */
		sapbackspace: {sName: "sapbackspace", aTypes: ["keydown"], fnCheck: function(oEvent) {
			return oEvent.keyCode == jQuery.sap.KeyCodes.BACKSPACE && !hasModifierKeys(oEvent);
		}},

		/**
		 * Pseudo event for keyboard backspace with modifiers (Ctrl, Alt or Shift)
		 * @public
		 */
		sapbackspacemodifiers: {sName: "sapbackspacemodifiers", aTypes: ["keydown"], fnCheck: function(oEvent) {
			return oEvent.keyCode == jQuery.sap.KeyCodes.BACKSPACE && hasModifierKeys(oEvent);
		}},

		/**
		 * Pseudo event for keyboard delete without modifiers (Ctrl, Alt or Shift)
		 * @public
		 */
		sapdelete: {sName: "sapdelete", aTypes: ["keydown"], fnCheck: function(oEvent) {
			return oEvent.keyCode == jQuery.sap.KeyCodes.DELETE && !hasModifierKeys(oEvent);
		}},

		/**
		 * Pseudo event for keyboard delete with modifiers (Ctrl, Alt or Shift)
		 * @public
		 */
		sapdeletemodifiers: {sName: "sapdeletemodifiers", aTypes: ["keydown"], fnCheck: function(oEvent) {
			return oEvent.keyCode == jQuery.sap.KeyCodes.DELETE && hasModifierKeys(oEvent);
		}},

		/**
		 * Pseudo event for pseudo expand event (keyboard numpad +) without modifiers (Ctrl, Alt or Shift)
		 * @public
		 */
		sapexpand: {sName: "sapexpand", aTypes: ["keydown"], fnCheck: function(oEvent) {
			return oEvent.keyCode == jQuery.sap.KeyCodes.NUMPAD_PLUS && !hasModifierKeys(oEvent);
		}},

		/**
		 * Pseudo event for pseudo expand event (keyboard numpad +) with modifiers (Ctrl, Alt or Shift)
		 * @public
		 */
		sapexpandmodifiers: {sName: "sapexpandmodifiers", aTypes: ["keydown"], fnCheck: function(oEvent) {
			return oEvent.keyCode == jQuery.sap.KeyCodes.NUMPAD_PLUS && hasModifierKeys(oEvent);
		}},

		/**
		 * Pseudo event for pseudo collapse event (keyboard numpad -) without modifiers (Ctrl, Alt or Shift)
		 * @public
		 */
		sapcollapse: {sName: "sapcollapse", aTypes: ["keydown"], fnCheck: function(oEvent) {
			return oEvent.keyCode == jQuery.sap.KeyCodes.NUMPAD_MINUS && !hasModifierKeys(oEvent);
		}},

		/**
		 * Pseudo event for pseudo collapse event (keyboard numpad -) with modifiers (Ctrl, Alt or Shift)
		 * @public
		 */
		sapcollapsemodifiers: {sName: "sapcollapsemodifiers", aTypes: ["keydown"], fnCheck: function(oEvent) {
			return oEvent.keyCode == jQuery.sap.KeyCodes.NUMPAD_MINUS && hasModifierKeys(oEvent);
		}},

		/**
		 * Pseudo event for pseudo collapse event (keyboard numpad *)
		 * @public
		 */
		sapcollapseall: {sName: "sapcollapseall", aTypes: ["keydown"], fnCheck: function(oEvent) {
			return oEvent.keyCode == jQuery.sap.KeyCodes.NUMPAD_ASTERISK && !hasModifierKeys(oEvent);
		}},

		/**
		 * Pseudo event for keyboard escape
		 * @public
		 */
		sapescape: {sName: "sapescape", aTypes: ["keydown"], fnCheck: function(oEvent) {
			return oEvent.keyCode == jQuery.sap.KeyCodes.ESCAPE && !hasModifierKeys(oEvent);
		}},

		/**
		 * Pseudo event for keyboard tab (TAB + no modifier)
		 * @public
		 */
		saptabnext: {sName: "saptabnext", aTypes: ["keydown"], fnCheck: function(oEvent) {
			return oEvent.keyCode == jQuery.sap.KeyCodes.TAB && !hasModifierKeys(oEvent);
		}},

		/**
		 * Pseudo event for keyboard tab (TAB + shift modifier)
		 * @public
		 */
		saptabprevious: {sName: "saptabprevious", aTypes: ["keydown"], fnCheck: function(oEvent) {
			return oEvent.keyCode == jQuery.sap.KeyCodes.TAB && checkModifierKeys(oEvent, /*Ctrl*/false, /*Alt*/false, /*Shift*/true);
		}},

		/**
		 * Pseudo event for pseudo skip forward (F6 + no modifier)
		 * @public
		 */
		sapskipforward: {sName: "sapskipforward", aTypes: ["keydown"], fnCheck: function(oEvent) {
			return oEvent.keyCode == jQuery.sap.KeyCodes.F6 && !hasModifierKeys(oEvent);
		}},

		/**
		 * Pseudo event for pseudo skip back (F6 + shift modifier)
		 * @public
		 */
		sapskipback: {sName: "sapskipback", aTypes: ["keydown"], fnCheck: function(oEvent) {
			return oEvent.keyCode == jQuery.sap.KeyCodes.F6 && checkModifierKeys(oEvent, /*Ctrl*/false, /*Alt*/false, /*Shift*/true);
		}},

		//// contextmenu Shift-F10 hack
		//{sName: "sapcontextmenu", aTypes: ["keydown"], fnCheck: function(oEvent) {
		//	return oEvent.keyCode == jQuery.sap.KeyCodes.F10 && checkModifierKeys(oEvent, /*Ctrl*/false, /*Alt*/false, /*Shift*/true);
		//}},

		/**
		 * Pseudo event for pseudo 'decrease' event without modifiers (Ctrl, Alt or Shift)
		 * @public
		 */
		sapdecrease: {sName: "sapdecrease", aTypes: ["keydown"], fnCheck: function(oEvent) {
			var bRtl = sap.ui.getCore().getConfiguration().getRTL();
			var iPreviousKey = bRtl ? jQuery.sap.KeyCodes.ARROW_RIGHT : jQuery.sap.KeyCodes.ARROW_LEFT;
			return (oEvent.keyCode == iPreviousKey || oEvent.keyCode == jQuery.sap.KeyCodes.ARROW_DOWN) && !hasModifierKeys(oEvent);
		}},

		/**
		 * Pseudo event for pseudo 'decrease' event with modifiers (Ctrl, Alt or Shift)
		 * @public
		 */
		sapdecreasemodifiers: {sName: "sapdecreasemodifiers", aTypes: ["keydown"], fnCheck: function(oEvent) {
			var bRtl = sap.ui.getCore().getConfiguration().getRTL();
			var iPreviousKey = bRtl ? jQuery.sap.KeyCodes.ARROW_RIGHT : jQuery.sap.KeyCodes.ARROW_LEFT;
			return (oEvent.keyCode == iPreviousKey || oEvent.keyCode == jQuery.sap.KeyCodes.ARROW_DOWN) && hasModifierKeys(oEvent);
		}},

		/**
		 * Pseudo event for pseudo 'increase' event without modifiers (Ctrl, Alt or Shift)
		 * @public
		 */
		sapincrease: {sName: "sapincrease", aTypes: ["keydown"], fnCheck: function(oEvent) {
			var bRtl = sap.ui.getCore().getConfiguration().getRTL();
			var iNextKey = bRtl ? jQuery.sap.KeyCodes.ARROW_LEFT : jQuery.sap.KeyCodes.ARROW_RIGHT;
			return (oEvent.keyCode == iNextKey || oEvent.keyCode == jQuery.sap.KeyCodes.ARROW_UP) && !hasModifierKeys(oEvent);
		}},

		/**
		 * Pseudo event for pseudo 'increase' event with modifiers (Ctrl, Alt or Shift)
		 * @public
		 */
		sapincreasemodifiers: {sName: "sapincreasemodifiers", aTypes: ["keydown"], fnCheck: function(oEvent) {
			var bRtl = sap.ui.getCore().getConfiguration().getRTL();
			var iNextKey = bRtl ? jQuery.sap.KeyCodes.ARROW_LEFT : jQuery.sap.KeyCodes.ARROW_RIGHT;
			return (oEvent.keyCode == iNextKey || oEvent.keyCode == jQuery.sap.KeyCodes.ARROW_UP) && hasModifierKeys(oEvent);
		}},

		/**
		 * Pseudo event for pseudo 'previous' event without modifiers (Ctrl, Alt or Shift)
		 * @public
		 */
		sapprevious: {sName: "sapprevious", aTypes: ["keydown"], fnCheck: function(oEvent) {
			var bRtl = sap.ui.getCore().getConfiguration().getRTL();
			var iPreviousKey = bRtl ? jQuery.sap.KeyCodes.ARROW_RIGHT : jQuery.sap.KeyCodes.ARROW_LEFT;
			return (oEvent.keyCode == iPreviousKey || oEvent.keyCode == jQuery.sap.KeyCodes.ARROW_UP) && !hasModifierKeys(oEvent);
		}},

		/**
		 * Pseudo event for pseudo 'previous' event with modifiers (Ctrl, Alt or Shift)
		 * @public
		 */
		sappreviousmodifiers: {sName: "sappreviousmodifiers", aTypes: ["keydown"], fnCheck: function(oEvent) {
			var bRtl = sap.ui.getCore().getConfiguration().getRTL();
			var iPreviousKey = bRtl ? jQuery.sap.KeyCodes.ARROW_RIGHT : jQuery.sap.KeyCodes.ARROW_LEFT;
			return (oEvent.keyCode == iPreviousKey || oEvent.keyCode == jQuery.sap.KeyCodes.ARROW_UP) && hasModifierKeys(oEvent);
		}},

		/**
		 * Pseudo event for pseudo 'next' event without modifiers (Ctrl, Alt or Shift)
		 * @public
		 */
		sapnext: {sName: "sapnext", aTypes: ["keydown"], fnCheck: function(oEvent) {
			var bRtl = sap.ui.getCore().getConfiguration().getRTL();
			var iNextKey = bRtl ? jQuery.sap.KeyCodes.ARROW_LEFT : jQuery.sap.KeyCodes.ARROW_RIGHT;
			return (oEvent.keyCode == iNextKey || oEvent.keyCode == jQuery.sap.KeyCodes.ARROW_DOWN) && !hasModifierKeys(oEvent);
		}},

		/**
		 * Pseudo event for pseudo 'next' event with modifiers (Ctrl, Alt or Shift)
		 * @public
		 */
		sapnextmodifiers: {sName: "sapnextmodifiers", aTypes: ["keydown"], fnCheck: function(oEvent) {
			var bRtl = sap.ui.getCore().getConfiguration().getRTL();
			var iNextKey = bRtl ? jQuery.sap.KeyCodes.ARROW_LEFT : jQuery.sap.KeyCodes.ARROW_RIGHT;
			return (oEvent.keyCode == iNextKey || oEvent.keyCode == jQuery.sap.KeyCodes.ARROW_DOWN) && hasModifierKeys(oEvent);
		}},

		//// pseudo hotkey event
		//{sName: "saphotkey", aTypes: ["keydown"], fnCheck: function(oEvent) {
		//  return false;
		//}},
		/* TODO: hotkeys: all other events could be hotkeys
		if(UCF_KeyboardHelper.bIsValidHotkey(iKey, bCtrl, bAlt, bShift)) {

			if (iKey == jQuery.sap.KeyCodes.F1 && bNoModifiers) {
				//special handling for FF - in IE the help is handeled by onHelp
				if (UCF_System.sDevice == "ff1") {
					this.fireSapEvent(this.E_SAP_EVENTS.hotkey, oEvent);
				}
			}
			else if (bCtrlOnly && iKey == jQuery.sap.KeyCodes.C && document.selection) {
				//handle ctrl+c centrally if text is selected to allow to copy it instead of firing the hotkey
				var oTextRange = document.selection.createRange();
				if (!oTextRange || oTextRange.text.length <= 0) {
					this.fireSapEvent(this.E_SAP_EVENTS.hotkey, oEvent);
				}
			}
			else {
				this.fireSapEvent(this.E_SAP_EVENTS.hotkey, oEvent);
			}
		}
		*/

		/*
		 * Other pseudo events
		 * @public
		 */

		/**
		 * Pseudo event indicating delayed double click (e.g. for inline edit)
		 * @public
		 */
		sapdelayeddoubleclick: {sName: "sapdelayeddoubleclick", aTypes: ["click"], fnCheck: function(oEvent) {
			var element = jQuery(oEvent.target);
			var currentTimestamp = oEvent.timeStamp;
			var data = element.data("sapdelayeddoubleclick_lastClickTimestamp");
			var lastTimestamp = data || 0;
			element.data("sapdelayeddoubleclick_lastClickTimestamp", currentTimestamp);
			var diff = currentTimestamp - lastTimestamp;
			return (diff >= 300 && diff <= 1300);
		}}
	};

	/**
	 * Ordered array of the {@link jQuery.sap.PseudoEvents}.
	 *
	 * Order is significant as some check methods rely on the fact that they are tested before other methods.
	 * The array is processed during event analysis (when classifying browser events as pseudo events).
	 * @private
	 */
	var PSEUDO_EVENTS = ["sapdown", "sapdownmodifiers", "sapshow", "sapup", "sapupmodifiers", "saphide", "sapleft", "sapleftmodifiers", "sapright", "saprightmodifiers", "saphome", "saphomemodifiers", "saptop", "sapend", "sapendmodifiers", "sapbottom", "sappageup", "sappageupmodifiers", "sappagedown", "sappagedownmodifiers", "sapselect", "sapselectmodifiers", "sapspace", "sapspacemodifiers", "sapenter", "sapentermodifiers", "sapexpand", "sapbackspace", "sapbackspacemodifiers", "sapdelete", "sapdeletemodifiers", "sapexpandmodifiers", "sapcollapse", "sapcollapsemodifiers", "sapcollapseall", "sapescape", "saptabnext", "saptabprevious", "sapskipforward", "sapskipback", "sapprevious", "sappreviousmodifiers", "sapnext", "sapnextmodifiers", "sapdecrease", "sapdecreasemodifiers", "sapincrease", "sapincreasemodifiers", "sapdelayeddoubleclick"];

	//Add mobile touch events if touch is supported
	(function initTouchEventSupport() {
		jQuery.sap.touchEventMode = "SIM";

		var aAdditionalControlEvents = [];
		var aAdditionalPseudoEvents = [];

		if (sap.ui.Device.support.touch){ // touch events natively supported
			jQuery.sap.touchEventMode = "ON";

			// ensure that "oEvent.touches", ... works (and not only "oEvent.originalEvent.touches", ...)
			jQuery.event.props.push("touches", "targetTouches", "changedTouches");
		}

		/**
		 * This function adds the simulated event prefixed with string "sap" to jQuery.sap.ControlEvents.
		 * 
		 * When UIArea binds to the simulated event with prefix, it internally binds to the original events with the given handler and 
		 * also provides the additional configuration data in the follwing format:
		 * 
		 * {
		 * 	domRef: // the dom reference of the UIArea
		 * 	eventName: // the simulated event name
		 * 	sapEventName: // the simulated event name with sap prefix
		 * 	eventHandle: // the handler that should be registered to simulated event with sap prefix
		 * }
		 * 
		 * @param {string} sSimEventName The name of the simulated event
		 * @param {array} aOrigEvents The array of original events that should be simulated from
		 * @param {function} fnHandler The function which is bound to the original events
		 * 
		 * @private
		 */
		var createSimulatedEvent = function(sSimEventName, aOrigEvents, fnHandler) {
			var sHandlerKey = "__"+sSimEventName+"Handler";
			var sSapSimEventName = "sap"+sSimEventName;
			aAdditionalControlEvents.push(sSapSimEventName);
			aAdditionalPseudoEvents.push({sName: sSimEventName, aTypes: [sSapSimEventName], fnCheck: function (oEvent) { return true; }});

			jQuery.event.special[sSapSimEventName] = {
				// When binding to the simulated event with prefix is done through jQuery, this function is called and redirect the registration
				// to the original events. Doing in this way we can simulate the event from listening to the original events.
				add: function(oHandle) {
					var that = this,
						$this = jQuery(this),
						oAdditionalConfig = {
							domRef: that,
							eventName: sSimEventName,
							sapEventName: sSapSimEventName,
							eventHandle: oHandle
						};

					var fnHandlerWrapper = function(oEvent){
						fnHandler(oEvent, oAdditionalConfig);
					};

					$this.data(sHandlerKey + oHandle.guid, fnHandlerWrapper);
					for(var i=0; i<aOrigEvents.length; i++){
						$this.on(aOrigEvents[i], fnHandlerWrapper);
					}
				},

				// When unbinding to the simulated event with prefix is done through jQuery, this function is called and redirect the deregistration
				// to the original events.
				remove: function(oHandle) {
					var $this = jQuery(this);
					var fnHandler = $this.data(sHandlerKey + oHandle.guid);
					$this.removeData(sHandlerKey + oHandle.guid);
					for(var i=0; i<aOrigEvents.length; i++){
						jQuery.event.remove(this, aOrigEvents[i], fnHandler);
					}
				}
			};
		};

		/**
		 * This function simulates the corresponding touch event by listening to mouse event.
		 * 
		 * The simulated event will be dispatch through UI5 event delegation which means that the on"EventName" function is called
		 * on control's prototype.
		 * 
		 * @param {jQuery.Event} oEvent The original event object
		 * @param {object} oConfig Additional configuration passed from createSimulatedEvent function
		 * @private
		 */
		var fnMouseToTouchHandler = function(oEvent, oConfig) {
			var $DomRef = jQuery(oConfig.domRef);
			// Suppress the delayed mouse events simulated on touch enabled device
			// the mark is done within jquery-mobile-custom.js
			if(oEvent.isMarked("delayedMouseEvent")){
				return;
			}

			// Checks if the mouseout event should be handled, the mouseout of the inner dom shouldn't be handled when the mouse cursor
			// is still inside the control's root dom node
			if(!(oEvent.type != "mouseout" || (oEvent.type === "mouseout" && jQuery.sap.checkMouseEnterOrLeave(oEvent, oConfig.domRef)))){
				var bSkip = true;
				var sControlId = $DomRef.data("__touchstart_control");
				if(sControlId){
					var oCtrlDom = jQuery.sap.domById(sControlId);
					if(oCtrlDom && jQuery.sap.checkMouseEnterOrLeave(oEvent, oCtrlDom)){
						bSkip = false;
					}
				}
				if(bSkip){
					return;
				}
			}

			var oNewEvent = jQuery.event.fix(oEvent.originalEvent || oEvent);
			oNewEvent.type = oConfig.sapEventName;

			//reset the _sapui_handledByUIArea flag
			if (oNewEvent.isMarked("firstUIArea")) {
				oNewEvent.setMark("handledByUIArea", false);
			}

			var aTouches = [{
				identifier: 1,
				pageX: oNewEvent.pageX,
				pageY: oNewEvent.pageY,
				clientX: oNewEvent.clientX,
				clientY: oNewEvent.clientY,
				screenX: oNewEvent.screenX,
				screenY: oNewEvent.screenY,
				target: oNewEvent.target,
				radiusX: 1,
				radiusY: 1,
				rotationAngle: 0
			}];

			switch (oConfig.eventName) {
				case "touchstart":
				case "touchmove":
					oNewEvent.touches = oNewEvent.changedTouches = oNewEvent.targetTouches = aTouches;
					break;

				case "touchend":
					oNewEvent.changedTouches = aTouches;
					oNewEvent.touches = oNewEvent.targetTouches = [];
					break;
				// no default
			}

			if(oConfig.eventName === "touchstart" || $DomRef.data("__touch_in_progress")){
				$DomRef.data("__touch_in_progress", "X");
				var oControl = jQuery.fn.control ? jQuery(oEvent.target).control(0) : null;
				if(oControl){
					$DomRef.data("__touchstart_control", oControl.getId());
				}

				// When saptouchend event is generated from mouseout event, it has to be marked for being correctly handled inside UIArea.
				// for example, when sap.m.Image control is used inside sap.m.Button control, the following situation can happen:
				// 	1. Mousedown on image.
				// 	2. Keep mousedown and move mouse out of image.
				// 	3. ontouchend function will be called on image control and bubbled up to button control
				// 	4. However, the ontouchend function shouldn't be called on button.
				//
				// With this parameter, UIArea can check if the touchend is generated from mouseout event and check if the target is still
				// inside the current target. Executing the corresponding logic only when the target is out of the current target.
				if(oEvent.type === "mouseout"){
					oNewEvent.setMarked("fromMouseout");
				}
				oConfig.eventHandle.handler.call(oConfig.domRef, oNewEvent);
				// here the fromMouseout flag is checked, terminate the touch progress only when touchend event is not marked with fromMouseout.
				if(oConfig.eventName === "touchend" && !oNewEvent.isMarked("fromMouseout")){
					$DomRef.removeData("__touch_in_progress");
					$DomRef.removeData("__touchstart_control");
				}
			}
		};
		createSimulatedEvent("touchstart", ["mousedown"], fnMouseToTouchHandler);
		createSimulatedEvent("touchend", ["mouseup", "mouseout"], fnMouseToTouchHandler);
		createSimulatedEvent("touchmove", ["mousemove"], fnMouseToTouchHandler);

		/**
		 * This methods decides when extra events are needed. Extra events are: tap, swipe and the new touch to mouse event simulation.
		 * 
		 * The old touch to mouse simulation is done in a way that a real mouse event is fired when there's a corresponding touch event. But this will mess up
		 * the mouse to touch event simulation and is not consistent with the mouse to touch event simulation. That's why when certain condition is met, the old
		 * touch to mouse event simluation will be replaced with the new touch to mouse event simulation.
		 * 
		 * The new one can't completely replace the old one because the desktop controls which bind to events using jQuery or browser API directly have to be change.
		 * Then the new one can replace the old one completely not under certain condition anymore.
		 * 
		 * @private
		 */
		function needsExtraEventSupport(){
			var oCfgData = window["sap-ui-config"] || {},
				sLibs = oCfgData.libs || "";

			// TODO: should be replaced by some function in jQuery.sap.global (e.g. jQuery.sap.config(sKey))
			function hasConfig(sKey) {
				return document.location.search.indexOf("sap-ui-"+sKey) > -1 || // URL 
					!!oCfgData[sKey.toLowerCase()]; // currently, properties of oCfgData are converted to lower case (DOM attributes)
			}

			return sap.ui.Device.support.touch || // tap, swipe, etc. events are needed when touch is supported
				hasConfig("xx-test-mobile") || // see sap.ui.core.Configuration -> M_SETTINGS
				// also simulate touch events when sap-ui-xx-fakeOS is set (independently of the value and the current browser)
				hasConfig("xx-fakeOS") || 
				// always simulate touch events when the mobile lib is involved (FIXME: hack for Kelley, this does currently not work with dynamic library loading)
				sLibs.match(/sap.m\b/);
		}

		// If extra event support is needed, jQuery mobile event plugin is loaded to support tap, swipe and scrollstart/stop events.
		// The old touch to mouse event simulation ((see line 25 in this file)) will be deregistered and the new one will be active.
		if(needsExtraEventSupport()){
			jQuery.sap.require("sap.ui.thirdparty.jquery-mobile-custom");

			if(sap.ui.Device.support.touch){
				var bFingerIsMoved = false,
					iMoveThreshold = jQuery.vmouse.moveDistanceThreshold,
					iStartX, iStartY;

				/**
				 * This function simulates the corresponding mouse event by listening to touch event.
				 * 
				 * The simulated event will be dispatch through UI5 event delegation which means that the on"EventName" function is called
				 * on control's prototype.
				 * 
				 * @param {jQuery.Event} oEvent The original event object
				 * @param {object} oConfig Additional configuration passed from createSimulatedEvent function
				 */
				var fnTouchToMouseHandler = function(oEvent, oConfig) {
					var oTouch = oEvent.originalEvent.touches[0];
					if(oEvent.type === "touchstart"){
						bFingerIsMoved = false;
						iStartX = oTouch.pageX;
						iStartY = oTouch.pageY;
					}else if(oEvent.type === "touchmove"){
						bFingerIsMoved = bFingerIsMoved ||
									(Math.abs(oTouch.pageX - iStartX) > iMoveThreshold ||
											Math.abs(oTouch.pageY - iStartY) > iMoveThreshold) ;
					}

					var oNewEvent = jQuery.event.fix(oEvent.originalEvent || oEvent);
					oNewEvent.type = oConfig.sapEventName;
					//reset the _sapui_handledByUIArea flag
					if (oNewEvent.isMarked("firstUIArea")) {
						oNewEvent.setMark("handledByUIArea", false);
					}

					delete oNewEvent.touches;
					delete oNewEvent.changedTouches;
					delete oNewEvent.targetTouches;

					var oMappedEvent = (oConfig.eventName === "mouseup" ? oEvent.changedTouches[0] : oEvent.touches[0]);

					//TODO: add other properties that should be copied to the new event
					oNewEvent.screenX = oMappedEvent.screenX;
					oNewEvent.screenY = oMappedEvent.screenY;
					oNewEvent.clientX = oMappedEvent.clientX;
					oNewEvent.clientY = oMappedEvent.clientY;
					oNewEvent.ctrlKey = oMappedEvent.ctrlKey;
					oNewEvent.altKey = oMappedEvent.altKey;
					oNewEvent.shiftKey = oMappedEvent.shiftKey;

					oConfig.eventHandle.handler.call(oConfig.domRef, oNewEvent);

					// also call the onclick event handler when touchend event is received and the movement is within threshold
					if(oEvent.type === "touchend" && !bFingerIsMoved){
						oNewEvent.type = "click";
						oNewEvent.setMark("handledByUIArea", false);
						oConfig.eventHandle.handler.call(oConfig.domRef, oNewEvent);
					}
				};

				// Deregister the previous touch to mouse event simulation (see line 25 in this file)
				jQuery.sap.disableTouchToMouseHandling();
				jQuery.sap._touchToMouseEvent = false;

				createSimulatedEvent("mousedown", ["touchstart"], fnTouchToMouseHandler);
				createSimulatedEvent("mousemove", ["touchmove"], fnTouchToMouseHandler);
				createSimulatedEvent("mouseup", ["touchend", "touchcancel"], fnTouchToMouseHandler);
			}

			// Define additional jQuery Mobile events to be added to the event list
			// TODO taphold cannot be used (does not bubble / has no target property) -> Maybe provide own solution
			// IMPORTANT: update the public documentation when extending this list
			aAdditionalControlEvents.push("swipe", "tap", "swipeleft", "swiperight", "scrollstart", "scrollstop");

			//Define additional pseudo events to be added to the event list
			aAdditionalPseudoEvents.push({sName: "swipebegin", aTypes: ["swipeleft", "swiperight"], fnCheck: function (oEvent) {
				var bRtl = sap.ui.getCore().getConfiguration().getRTL();
				return (bRtl && oEvent.type === "swiperight") || (!bRtl && oEvent.type === "swipeleft");
			}});
			aAdditionalPseudoEvents.push({sName: "swipeend", aTypes: ["swipeleft", "swiperight"], fnCheck: function (oEvent) {
				var bRtl = sap.ui.getCore().getConfiguration().getRTL();
				return (!bRtl && oEvent.type === "swiperight") || (bRtl && oEvent.type === "swipeleft");
			}});
		}

		// Add all defined events to the event infrastructure
		//
		// jQuery has inversed the order of event registration when multiple events are passed into jQuery.on method from version 1.9.1.
		//
		// UIArea binds to both touchstart and saptouchstart event and saptouchstart internally also binds to touchstart event. Before
		// jQuery version 1.9.1, the touchstart event handler is called before the saptouchstart event handler and our flags (e.g. _sapui_handledByUIArea)
		// still work. However since the order of event registration is inversed from jQuery version 1.9.1, the saptouchstart event hanlder is called
		// before the touchstart one, our flags don't work anymore.
		//
		// Therefore jQuery version needs to be checked in order to decide the event order in jQuery.sap.ControlEvents.
		if(jQuery.sap.Version(jQuery.fn.jquery).compareTo("1.9.1") < 0){
			jQuery.sap.ControlEvents = jQuery.sap.ControlEvents.concat(aAdditionalControlEvents);
		}else{
			jQuery.sap.ControlEvents = aAdditionalControlEvents.concat(jQuery.sap.ControlEvents);
		}

		for(var i=0; i<aAdditionalPseudoEvents.length; i++){
			jQuery.sap.PseudoEvents[aAdditionalPseudoEvents[i].sName] = aAdditionalPseudoEvents[i];
			PSEUDO_EVENTS.push(aAdditionalPseudoEvents[i].sName);
		}
	}());

	/**
	 * Function for initialization of an Array containing all basic event types of the available pseudo events.
	 * @private
	 */
	function initPseudoEventBasicTypes(){
		var mEvents = jQuery.sap.PseudoEvents,
			aResult = [];

		for (var sName in mEvents) {
			if (mEvents[sName].aTypes) {
				for (var j = 0, js = mEvents[sName].aTypes.length; j < js; j++) {
					var sType = mEvents[sName].aTypes[j];
					if (jQuery.inArray(sType, aResult) == -1) {
						aResult.push(sType);
					}
				}
			}
		}

		return aResult;
	}

	/**
	 * Array containing all basic event types of the available pseudo events.
	 * @private
	 */
	var PSEUDO_EVENTS_BASIC_TYPES = initPseudoEventBasicTypes();

	/**
	 * Convenience method to check an event for a certain combination of modifier keys
	 *
	 * @private
	 */
	function checkModifierKeys(oEvent, bCtrlKey, bAltKey, bShiftKey) {
		return oEvent.shiftKey == bShiftKey && oEvent.altKey == bAltKey && getCtrlKey(oEvent) == bCtrlKey;
	}

	/**
	 * Convenience method to check an event for any modifier key
	 *
	 * @private
	 */
	function hasModifierKeys(oEvent) {
		return oEvent.shiftKey || oEvent.altKey || getCtrlKey(oEvent);
	}

	/**
	 * Convenience method for handling of Ctrl key, meta key etc.
	 *
	 * @private
	 */
	function getCtrlKey(oEvent) {
		return !!(oEvent.metaKey || oEvent.ctrlKey); // double negation doesn't have effect on boolean but ensures null and undefined are equivalent to false.
	}

	/**
	 * Returns an array of names (as strings) identifying {@link jQuery.sap.PseudoEvents} that are fulfilled by this very Event instance.
	 *
	 * @returns {String[]} Array of names identifying {@link jQuery.sap.PseudoEvents} that are fulfilled by this very Event instance.
	 * @public
	 */
	jQuery.Event.prototype.getPseudoTypes = function() {
		var aPseudoTypes = [];

		if (jQuery.inArray(this.type, PSEUDO_EVENTS_BASIC_TYPES) != -1) {
			var aPseudoEvents = PSEUDO_EVENTS;
			var ilength = aPseudoEvents.length;
			var oPseudo = null;

			for(var i=0; i<ilength; i++){
				oPseudo = jQuery.sap.PseudoEvents[aPseudoEvents[i]];
				if(oPseudo.aTypes
						&& jQuery.inArray(this.type, oPseudo.aTypes) > -1
						&& oPseudo.fnCheck
						&& oPseudo.fnCheck(this)){
					aPseudoTypes.push(oPseudo.sName);
				}
			}
		}

		this.getPseudoTypes = function(){return aPseudoTypes.slice();};

		return aPseudoTypes.slice();
	};

	/**
	 * Checks whether this instance of {@link jQuery.Event} is of the given <code>sType</code> pseudo type.
	 *
	 * @param {string} sType The name of the pseudo type this event should be checked for.
	 * @returns {boolean} <code>true</code> if this instance of jQuery.Event is of the given sType, <code>false</code> otherwise.
	 * @public
	 */
	jQuery.Event.prototype.isPseudoType = function(sType) {
		var aPseudoTypes = this.getPseudoTypes();

		if (sType) {
			return jQuery.inArray(sType, aPseudoTypes) > -1;
		} else {
			return aPseudoTypes.length > 0;
		}
	};


	/*
	 * store reference to original preventDefault method
	 */
	var _preventDefault = jQuery.Event.prototype.preventDefault;
	/*
	 * and introduce some keyCode fixing for IE...
	 * this e.g. suppresses the address-field drop down opening in case of sapshow (i.e. F4) in ComboBoxes
	 */
	jQuery.Event.prototype.preventDefault = function() {
		_preventDefault.apply(this, arguments);

		var e = this.originalEvent;

		if ( !e ) {
			return;
		}

		if ( e.keyCode != 0 ) {
			try { // Sometimes setting keycode results in "Access Denied"
				if(!sap.ui.Device.browser.firefox) {
					e.keyCode = 0;
				}
			} catch(ex) {}
		}

	};

	/**
	 * Binds all events for listening with the given callback function.
	 *
	 * @param {function} fnCallback Callback function
	 * @public
	 */
	jQuery.sap.bindAnyEvent = function bindAnyEvent(fnCallback) {
		if (fnCallback) {
			jQuery(document).bind(jQuery.sap.ControlEvents.join(" "), fnCallback);
		}
	};

	/**
	 * Unbinds all events for listening with the given callback function.
	 *
	 * @param {function} fnCallback Callback function
	 * @public
	 */
	jQuery.sap.unbindAnyEvent = function unbindAnyEvent(fnCallback) {
		if (fnCallback) {
			jQuery(document).unbind(jQuery.sap.ControlEvents.join(" "), fnCallback);
		}
	};

	/**
	 * Checks a given mouseover or mouseout event whether it is
	 * equivalent to a mouseenter or mousleave event regarding the given DOM reference.
	 *
	 * @param {jQuery.Event} oEvent
	 * @param {element} oDomRef
	 * @public
	 */
	jQuery.sap.checkMouseEnterOrLeave = function checkMouseEnterOrLeave(oEvent, oDomRef) {
		if(oEvent.type != "mouseover" && oEvent.type != "mouseout") {
			return false;
		}

		var isMouseEnterLeave = false;
		var element = oDomRef;
		var parent = oEvent.relatedTarget;

		try {
			while ( parent && parent !== element ) {
				parent = parent.parentNode;
			}

			if ( parent !== element ) {
				isMouseEnterLeave = true;
			}
		} catch(e) { }

		return isMouseEnterLeave;
	};

	/**
	 * Constructor for a jQuery.Event object.<br/>
	 * @see "http://www.jquery.com" and "http://api.jquery.com/category/events/event-object/".
	 *
	 * @class Check the jQuery.Event class documentation available under "http://www.jquery.com"<br/>
	 * and "http://api.jquery.com/category/events/event-object/" for details.
	 *
	 * @name jQuery.Event
	 * @public
	 */

	/**
	 * Returns OffsetX of Event. In jQuery there is a bug. In IE the value is in offsetX, in FF in layerX
	 *
	 * @returns offsetX
	 * @public
	 */
	jQuery.Event.prototype.getOffsetX = function() {

		if (this.type == 'click'){
			if (this.offsetX){
				return this.offsetX;
			}
			if (this.layerX){
				return this.layerX;
			}
			if (this.originalEvent.layerX){
				return this.originalEvent.layerX;
			}
		}
		// nothing defined -> offset = 0
		return 0;
	};

	/**
	 * Returns OffsetY of Event. In jQuery there is a bug. in IE the value is in offsetY, in FF in layerY.
	 *
	 * @returns offsetY
	 * @public
	 */
	jQuery.Event.prototype.getOffsetY = function() {

		if (this.type == 'click'){
			if (this.offsetY){
				return this.offsetY;
			}
			if (this.layerY){
				return this.layerY;
			}
			if (this.originalEvent.layerY){
				return this.originalEvent.layerY;
			}
		}
		// nothing defined -> offset = 0
		return 0;
	};

	// we still call the original stopImmediatePropagation
	var fnStopImmediatePropagation = jQuery.Event.prototype.stopImmediatePropagation;
	
	/**
	 * PRIVATE EXTENSION: allows to immediately stop the propagation of events in
	 * the event handler execution - means that "before" delegates can stop the
	 * propagation of the event to other delegates or the element and so on.
	 *
	 * @see sap.ui.core.Element.prototype._callEventHandles
	 * @param {boolean} bStopDelegate
	 */
	jQuery.Event.prototype.stopImmediatePropagation = function(bStopHandlers) {

		// execute the original function
		fnStopImmediatePropagation.apply(this, arguments);

		// only set the stop handlers flag if it is wished...
		if (bStopHandlers) {
			this._bIsStopHandlers = true;
		}
	};

	/**
	 * PRIVATE EXTENSION: check if the handler propagation has been stopped.
	 *
	 * @see sap.ui.core.Element.prototype._callEventHandles
	 */
	jQuery.Event.prototype.isImmediateHandlerPropagationStopped = function() {
		return !!this._bIsStopHandlers;
	};

	/**
	 * Mark the event object for components that needs to know if the event was handled by a child component.
	 * PRIVATE EXTENSION
	 *
	 * @param {string} [sKey="handledByControl"]
	 * @param {string} [vValue=true]
	 */
	jQuery.Event.prototype.setMark = function(sKey, vValue) {
		sKey = sKey || "handledByControl";
		vValue = arguments.length < 2 ? true : vValue;
		(this.originalEvent || this)["_sapui_" + sKey] = vValue;
	};

	/**
	 * Mark the event object for components that needs to know if the event was handled by a child component.
	 * PRIVATE EXTENSION
	 *
	 * @see jQuery.Event.prototype.setMark
	 * @param {string} [sKey="handledByControl"]
	 */
	jQuery.Event.prototype.setMarked = jQuery.Event.prototype.setMark;

	/**
	 * Check whether the event object is marked by the child component or not.
	 * PRIVATE EXTENSION
	 *
	 * @param {string} [sKey="handledByControl"]
	 * @returns {boolean}
	 */
	jQuery.Event.prototype.isMarked = function(sKey) {
		sKey = sKey || "handledByControl";
		return !!(this.originalEvent || this)["_sapui_" + sKey];
	};

	return jQuery;

}, /* bExport= */ false);
}; // end of jquery.sap.events.js
if ( !jQuery.sap.isDeclared('jquery.sap.mobile') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

//Provides common helper functions for the mobile version of UI5 
jQuery.sap.declare('jquery.sap.mobile'); // unresolved dependency added by SAPUI5 CreateModule Ant-Task
sap.ui.define("jquery.sap.mobile",['jquery.sap.global', 'sap/ui/Device', 'jquery.sap.dom', 'jquery.sap.events'],
	function(jQuery, Device/* , jQuerySap1, jQuerySap2 */) {
	"use strict";


	(function($) { // TODO get rid of inner scope function, rename $ to jQuery
		var FAKE_OS_PATTERN = /(?:\?|&)sap-ui-xx-fakeOS=([^&]+)/;
	
		$.sap.simulateMobileOnDesktop = false;
	
		// OS overriding mechanism
		if ((Device.browser.webkit || (Device.browser.msie && Device.browser.version >= 10)) && !jQuery.support.touch) { // on non-touch webkit browsers and IE10 we are interested in overriding
	
			var result = document.location.search.match(FAKE_OS_PATTERN);
			var resultUA = result && result[1] || jQuery.sap.byId("sap-ui-bootstrap").attr("data-sap-ui-xx-fakeOS");
	
			if (resultUA) {
	
				$.sap.simulateMobileOnDesktop = true;
	
				var ua = { // for "ios"/"android"/"blackberry" we have defined fake user-agents; these will affect all other browser/platform detection mechanisms
						ios: "Mozilla/5.0 (iPhone; CPU iPhone OS 5_0_1 like Mac OS X) AppleWebKit/534.48 (KHTML, like Gecko) Version/5.1 Mobile/9A406 Safari/7534.48.3",
						iphone: "Mozilla/5.0 (iPhone; CPU iPhone OS 5_0_1 like Mac OS X) AppleWebKit/534.48 (KHTML, like Gecko) Version/5.1 Mobile/9A406 Safari/7534.48.3",
						ipad: "Mozilla/5.0 (iPad; CPU OS 5_1_1 like Mac OS X) AppleWebKit/534.46 (KHTML, like Gecko) Mobile/9B206",
						android: "Mozilla/5.0 (Linux; U; Android 4.0.3; en-us; GT-I9100 Build/IML74K) AppleWebKit/534.46 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.46",
						android_phone: "Mozilla/5.0 (Linux; U; Android 4.0.3; en-us; GT-I9100 Build/IML74K) AppleWebKit/534.46 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.46",
						android_tablet: "Mozilla/5.0 (Linux; Android 4.1.2; Nexus 7 Build/JZ054K) AppleWebKit/535.19 (KHTML, like Gecko) Chrome/18.0.1025.166 Safari/535.19",
						blackberry: "Mozilla/5.0 (BB10; Touch) AppleWebKit/537.10+ (KHTML, like Gecko) Version/10.0.9.2372 Mobile Safari/537.10+",
						winphone: "Mozilla/5.0 (compatible; MSIE 10.0; Windows Phone 8.0; Trident/6.0; IEMobile/10.0; ARM; Touch; NOKIA; Lumia 920)"
				}[resultUA];
	
				if (ua &&
						(Device.browser.webkit && resultUA !== "winphone" || Device.browser.msie && resultUA === "winphone")) { // only for the working combinations
	
					// code for modifying the real user-agent
					if (Device.browser.safari) {
						var __originalNavigator = window.navigator;
						window.navigator = new Object();
						window.navigator.__proto__ = __originalNavigator;
						window.navigator.__defineGetter__('userAgent', function(){ return ua; });
					} else { // Chrome, IE10
						Object.defineProperty(navigator, "userAgent", {
							get: function() {
								return ua;
							}
						});
					}
	
					if (Device.browser.webkit) {
	
						// all downstream checks will be fine with the faked user-agent.
						// But now we also need to adjust the wrong upstream settings in jQuery:
						jQuery.browser.msie = jQuery.browser.opera = jQuery.browser.mozilla = false;
						jQuery.browser.webkit = true;
						jQuery.browser.version = "534.46"; // this is not exactly true for all UAs, but there are much bigger shortcomings of this approach than a minor version of the browser, so giving the exact value is not worth the effort
					} else {
	
						// in IE10 with winphone emulation, jQuery.browser has already the correct information
					}
	
					// update the sap.ui.Device.browser.* information
					Device._update($.sap.simulateMobileOnDesktop);
				}
			}
		}
	
		/**
		 * Holds information about the current operating system
		 * 
		 * @name jQuery.os
		 * @namespace
		 * @deprecated since 1.20: use sap.ui.Device.os
		 * @public
		 */
		$.os = $.extend(/** @lends jQuery.os */ {
	
			/**
			 * The name of the operating system; currently supported are: "ios", "android", "blackberry"
			 * @type {string}
			 * @deprecated since 1.20: use sap.ui.Device.os.name
			 * @public
			 */
			os: Device.os.name,
	
			/**
			 * The version of the operating system as a string (including minor versions)
			 * @type {string}
			 * @deprecated since 1.20: use sap.ui.Device.os.versionStr
			 * @public
			 */
			version: Device.os.versionStr,
	
			/**
			 * The version of the operating system parsed as a float (major and first minor version)
			 * @type {float}
			 * @deprecated since 1.20: use sap.ui.Device.os.version
			 * @public
			 */
			fVersion: Device.os.version
		}, $.os);
	
		$.os[Device.os.name] = true;
	
		/**
		 * Whether the current operating system is Android
		 * @type {boolean}
		 * @public
		 * @deprecated since 1.20: use sap.ui.Device.os.android
		 * @name jQuery.os.android
		 */
	
		/**
		 * Whether the current operating system is BlackBerry
		 * @type {boolean}
		 * @public
		 * @deprecated since 1.20: use sap.ui.Device.os.blackberry
		 * @name jQuery.os.blackberry
		 */
	
		/**
		 * Whether the current operating system is Apple iOS
		 * @type {boolean}
		 * @public
		 * @deprecated since 1.20: use sap.ui.Device.os.ios
		 * @name jQuery.os.ios
		 */
		
		/**
		 * Whether the current operating system is Windows Phone
		 * @type {boolean}
		 * @public
		 * @deprecated since 1.20: use sap.ui.Device.os.winphone
		 * @name jQuery.os.winphone
		 */
	
	
		// feature and state detection
		$.extend( $.support, {
	
			/**
			 * Whether the device has a retina display (window.devicePixelRatio >= 2)
			 * @type {boolean}
			 * @public
			 */
			retina: window.devicePixelRatio >= 2
		});
	
		
		/**
		 * @name jQuery.device
		 * @namespace
		 * @deprecated since 1.20: use the respective functions of sap.ui.Device
		 * @public
		 */
		$.device = $.extend({}, $.device);
	
		/**
		 * Holds information about the current device and its state
		 * 
		 * @name jQuery.device.is
		 * @namespace
		 * @deprecated since 1.20: use the respective functions of sap.ui.Device
		 * @public
		 */
		$.device.is = $.extend( /** @lends jQuery.device.is */ {
	
			/**
			 * Whether the application runs in standalone mode without browser UI (launched from the iOS home screen)
			 * @type {boolean}
			 * @deprecated since 1.20: use window.navigator.standalone
			 * @public
			 */
			standalone: window.navigator.standalone,
	
			/**
			 * Whether the device is in "landscape" orientation (also "true" when the device does not know about the orientation)
			 * @type {boolean}
			 * @deprecated since 1.20: use sap.ui.Device.orientation.landscape
			 * @public
			 */
			landscape: Device.orientation.landscape,
	
			/**
			 * Whether the device is in portrait orientation
			 * @type {boolean}
			 * @deprecated since 1.20: use sap.ui.Device.orientation.portrait
			 * @public
			 */
			portrait: Device.orientation.portrait,
	
			/**
			 * Whether the application runs on an iPhone
			 * @type {boolean}
			 * @deprecated since 1.20: shouldn't do device specific coding; if still needed, use sap.ui.Device.os.ios &amp;&amp; sap.ui.Device.system.phone
			 * @public
			 */
			iphone: Device.os.ios && Device.system.phone,
	
			/**
			 * Whether the application runs on an iPad
			 * @type {boolean}
			 * @deprecated since 1.20: shouldn't do device specific coding; if still needed, use sap.ui.Device.os.ios &amp;&amp; sap.ui.Device.system.tablet
			 * @public
			 */
			ipad: Device.os.ios && Device.system.tablet,
	
			/**
			 * Whether the application runs on an Android phone - based not on screen size but user-agent (so this is not guaranteed to be equal to jQuery.device.is.phone on Android)
			 * https://developers.google.com/chrome/mobile/docs/user-agent
			 * Some device vendors however do not follow this rule
			 * @deprecated since 1.17.0: use sap.ui.Device.system.phone &amp;&amp; sap.ui.Device.os.android  instead
			 * @type {boolean}
			 * @public
			 */
			android_phone: Device.system.phone && Device.os.android,
	
			/**
			 * Whether the application runs on an Android tablet - based not on screen size but user-agent (so this is not guaranteed to be equal to jQuery.device.is.tablet on Android)
			 * https://developers.google.com/chrome/mobile/docs/user-agent
			 * Some device vendors however do not follow this rule
			 * @type {boolean}
			 * @deprecated since 1.17.0: use sap.ui.Device.system.tablet &amp;&amp; sap.ui.Device.os.android  instead
			 * @public
			 */
			android_tablet: Device.system.tablet && Device.os.android,
	
			/**
			 * Whether the running device is a tablet.
			 * If a desktop browser runs in mobile device simulation mode (with URL parameter sap-ui-xx-fakeOS or sap-ui-xx-test-mobile), 
			 * this property will also be set according to the simulated platform.
			 * This property will be false when runs in desktop browser.
			 * @type {boolean}
			 * @deprecated since 1.17.0: use sap.ui.Device.system.tablet instead
			 * @public
			 */
			tablet: Device.system.tablet,
	
			/**
			 * Whether the running device is a phone.
			 * If a desktop browser runs in mobile device simulation mode (with URL parameter sap-ui-xx-fakeOS or sap-ui-xx-test-mobile), 
			 * this property will also be set according to the simulated platform.
			 * This property will be false when runs in desktop browser.
			 * @type {boolean}
			 * @deprecated since 1.17.0: use sap.ui.Device.system.phone instead
			 * @public
			 */
			phone: Device.system.phone,
	
			/**
			 * Whether the running device is a desktop browser.
			 * If a desktop browser runs in mobile device simulation mode (with URL parameter sap-ui-xx-fakeOS or sap-ui-xx-test-mobile), 
			 * this property will be false.
			 * @type {boolean}
			 * @deprecated since 1.17.0: use sap.ui.Device.system.desktop instead
			 * @public
			 */
			desktop: Device.system.desktop
		},$.device.is);
	
	
		var _bInitMobileTriggered = false;
	
		/**
		 * Does some basic modifications to the HTML page that make it more suitable for mobile apps.
		 * Only the first call to this method is executed, subsequent calls are ignored. Note that this method is also called by the constructor of toplevel controls like sap.m.App, sap.m.SplitApp and sap.m.Shell.
		 * Exception: if no homeIcon was set, subsequent calls have the chance to set it.
		 *
		 * The "options" parameter configures what exactly should be done.
		 *
		 * It can have the following properties:
		 * <ul>
		 * <li>viewport: whether to set the viewport in a way that disables zooming (default: true)</li>
		 * <li>statusBar: the iOS status bar color, "default", "black" or "black-translucent" (default: "default")</li>
		 * <li>hideBrowser: whether the browser UI should be hidden as far as possible to make the app feel more native (default: true)</li>
		 * <li>preventScroll: whether native scrolling should be disabled in order to prevent the "rubber-band" effect where the whole window is moved (default: true)</li>
		 * <li>preventPhoneNumberDetection: whether Safari Mobile should be prevented from transforming any numbers that look like phone numbers into clickable links; this should be left as "true", otherwise it might break controls because Safari actually changes the DOM. This only affects all page content which is created after initMobile is called.</li>
		 * <li>rootId: the ID of the root element that should be made fullscreen; only used when hideBrowser is set (default: the document.body)</li>
		 * <li>useFullScreenHeight: a boolean that defines whether the height of the html root element should be set to 100%, which is required for other elements to cover the full height (default: true)</li>
		 * <li>homeIcon: deprecated since 1.12, use jQuery.sap.setIcons instead.
		 * </ul>
		 *
		 * @param {object}  [options] configures what exactly should be done
		 * @param {boolean} [options.viewport=true] whether to set the viewport in a way that disables zooming
		 * @param {string}  [options.statusBar='default'] the iOS status bar color, "default", "black" or "black-translucent"
		 * @param {boolean} [options.hideBrowser=true] whether the browser UI should be hidden as far as possible to make the app feel more native
		 * @param {boolean} [options.preventScroll=true] whether native scrolling should be disabled in order to prevent the "rubber-band" effect where the whole window is moved
		 * @param {boolean} [options.preventPhoneNumberDetection=true] whether Safari mobile should be prevented from transforming any numbers that look like phone numbers into clickable links
		 * @param {string}  [options.rootId] the ID of the root element that should be made fullscreen; only used when hideBrowser is set. If not set, the body is used
		 * @param {boolean} [options.useFullScreenHeight=true] whether the height of the html root element should be set to 100%, which is required for other elements to cover the full height
		 * @param {string}  [options.homeIcon=undefined] deprecated since 1.12, use jQuery.sap.setIcons instead.
		 * @param {boolean} [options.homeIconPrecomposed=false] deprecated since 1.12, use jQuery.sap.setIcons instead.
		 *
		 * @name jQuery.sap.initMobile
		 * @function
		 * @public
		 */
		$.sap.initMobile = function(options) {
			var $head = $("head");
	
			if (!_bInitMobileTriggered) { // only one initialization per HTML page
				_bInitMobileTriggered = true;
	
				options = $.extend({}, { // merge in the default values
					viewport: true,
					statusBar: "default",
					hideBrowser: true,
					preventScroll: true,
					preventPhoneNumberDetection: true,
					useFullScreenHeight: true,
					homeIconPrecomposed: false
				}, options);
	
				// en-/disable automatic link generation for phone numbers
				if (Device.os.ios && options.preventPhoneNumberDetection) {
					$head.append($('<meta name="format-detection" content="telephone=no">')); // this only works for all DOM created afterwards
				} else if (Device.browser.msie) {
					$head.append($('<meta http-equiv="cleartype" content="on">'));
					$head.append($('<meta name="msapplication-tap-highlight" content="no"/>'));
				}
	
				var bIsIOS7Safari = Device.os.ios && Device.os.version >= 7 && Device.os.version < 8 && Device.browser.name === "sf";
				// initialize viewport
				if (options.viewport) {
					var sMeta;
					if (bIsIOS7Safari && Device.system.phone) {
						//if the softkeyboard is open in orientation change, we have to do this to solve the zoom bug on the phone -
						//the phone zooms into the view although it shouldn't so these two lines will zoom out again see orientation change below
						//the important part seems to be setting the device height.
						sMeta = 'minimal-ui, initial-scale=1.0, maximum-scale=1.0, user-scalable=0';
					} else if ($.device.is.iphone && (Math.max(window.screen.height, window.screen.width) === 568)) {
						// iPhone 5
						sMeta = "user-scalable=0, initial-scale=1.0";
					} else if (Device.os.android && Device.os.version < 3){
						sMeta = "width=device-width, height=device-height, initial-scale=1.0, maximum-scale=1.0, user-scalable=no";
					} else if (Device.os.winphone){
						sMeta = "width=320, user-scalable=no";
					} else {
	
						// all other devices
						sMeta = "width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no";
					}
					$head.append($('<meta name="viewport" content="' + sMeta + '">'));
				}
	
				if (Device.os.ios) {
	
					// enable fullscreen when possible
					$head.append($('<meta name="apple-mobile-web-app-capable" content="yes">')); // since iOS 2.1
	
					// set the status bar style on Apple devices
					$head.append($('<meta name="apple-mobile-web-app-status-bar-style" content="' + options.statusBar + '">')); // "default" or "black" or "black-translucent", since iOS 2.1
	
					// splash screen
					//<link rel="apple-touch-startup-image" href="/startup.png">
				}
	
				if (options.preventScroll) {
					$(window).bind("touchmove", function sapInitMobileTouchMoveHandle(oEvent) {
						if (!oEvent.isMarked()) {
							oEvent.preventDefault(); // prevent the rubber-band effect
						}
					});
				}
	
				if (options.useFullScreenHeight) {
					$(function() {
						document.documentElement.style.height = "100%"; // set html root tag to 100% height
					});
				}
			}
	
			if (options.homeIcon) {
	
				var oIcons;
	
				if (typeof options.homeIcon === "string") {
					oIcons = { phone: options.homeIcon };
				} else {
					oIcons = $.extend({}, options.homeIcon);
				}
	
				oIcons.precomposed = options.homeIconPrecomposed || oIcons.precomposed;
				oIcons.favicon = options.homeIcon.icon || oIcons.favicon;
				oIcons.icon = undefined;
				$.sap.setIcons(oIcons);
			}
		};
	
		
	
		
	
		/**
		 * Sets the bookmark icon for desktop browsers and the icon to be displayed on the home screen of iOS devices after the user does "add to home screen".
		 *
		 * Only call this method once and call it early when the page is loading: browsers behave differently when the favicon is modified while the page is alive.
		 * Some update the displayed icon inside the browser but use an old icon for bookmarks.
		 * When a favicon is given, any other existing favicon in the document will be removed.
		 * When at least one home icon is given, all existing home icons will be removed and new home icon tags for all four resolutions will be created.
		 *
		 * The home icons must be in PNG format and given in different sizes for iPad/iPhone with and without retina display.
		 * The favicon is used in the browser and for desktop shortcuts and should optimally be in ICO format:
		 * PNG does not seem to be supported by Internet Explorer and ICO files can contain different image sizes for different usage locations. E.g. a 16x16px version
		 * is used inside browsers.
		 *
		 * All icons are given in an an object holding icon URLs and other settings. The properties of this object are:
		 * <ul>
		 * <li>phone: a 57x57 pixel version for non-retina iPhones</li>
		 * <li>tablet: a 72x72 pixel version for non-retina iPads</li>
		 * <li>phone@2: a 114x114 pixel version for retina iPhones</li>
		 * <li>tablet@2: a 144x144 pixel version for retina iPads</li>
		 * <li>precomposed: whether the home icons already have some glare effect (otherwise iOS will add it) (default: false)</li>
		 * <li>favicon: the ICO file to be used inside the browser and for desktop shortcuts</li>
		 * </ul>
		 *
		 * One example is:
		 * <pre>
		 * {
		 *    'phone':'phone-icon_57x57.png',
		 *    'phone@2':'phone-retina_117x117.png',
		 *    'tablet':'tablet-icon_72x72.png',
		 *    'tablet@2':'tablet-retina_144x144.png',
		 *    'precomposed':true,
		 *    'favicon':'desktop.ico'
		 * }
		 * </pre>
		 * If one of the sizes is not given, the largest available alternative image will be used instead for this size.
		 * On Android these icons may or may not be used by the device. Apparently chances can be improved by using icons with glare effect, so the "precomposed" property can be set to "true". Some Android devices may also use the favicon for bookmarks instead of the home icons.</li>
		 * 
		 * @name jQuery.sap.setIcons
		 * @function
		 * @public
		 */
		$.sap.setIcons = function(oIcons) {
	
			if (!oIcons || (typeof oIcons !== "object")) {
				$.sap.log.warning("Call to jQuery.sap.setIcons() has been ignored because there were no icons given or the argument was not an object.");
				return;
			}
	
			var $head = $("head"),
				precomposed = oIcons.precomposed ? "-precomposed" : "",
				getBestFallback = function(res) {
					return oIcons[res] || oIcons['tablet@2'] || oIcons['phone@2'] || oIcons['phone'] || oIcons['tablet']; // fallback logic
				},
				mSizes = {
					"phone": "",
					"tablet": "72x72",
					"phone@2": "114x114",
					"tablet@2": "144x144"
				};
	
			// desktop icon
			if (oIcons["favicon"]) {
	
				// remove any other favicons
				var $fav = $head.find("[rel^=shortcut]"); // cannot search for "shortcut icon"
	
				$fav.each(function(){
					if (this.rel === "shortcut icon") {
						$(this).remove();
					}
				});
	
				// create favicon
				$head.append($('<link rel="shortcut icon" href="' + oIcons["favicon"] + '" />'));
			}
	
			// mobile home screen icons
			if (getBestFallback("phone")) {
	
				// if any home icon is given remove old ones
				$head.find("[rel=apple-touch-icon]").remove();
				$head.find("[rel=apple-touch-icon-precomposed]").remove();
			}
	
			for (var platform in mSizes) {
				oIcons[platform] = oIcons[platform] || getBestFallback(platform);
				if (oIcons[platform]) {
					var size = mSizes[platform];
					$head.append($('<link rel="apple-touch-icon' + precomposed + '" ' + (size ? 'sizes="' + size + '"' : "") + ' href="' + oIcons[platform] + '" />'));
				}
			}
		};
	
	})(jQuery);
	
	return jQuery;
	
}, /* bExport= */ false);

}; // end of jquery.sap.mobile.js
if ( !jQuery.sap.isDeclared('jquery.sap.properties') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides access to Java-like properties files
jQuery.sap.declare('jquery.sap.properties'); // unresolved dependency added by SAPUI5 CreateModule Ant-Task
if ( !jQuery.sap.isDeclared('jquery.sap.sjax') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/*
 * Provides convenience functions for synchronous communication, based on the jQuery.ajax() function.
 */
jQuery.sap.declare('jquery.sap.sjax'); // unresolved dependency added by SAPUI5 CreateModule Ant-Task
sap.ui.define("jquery.sap.sjax",['jquery.sap.global'],
	function(jQuery) {
	"use strict";

	jQuery.sap.sjaxSettings = {
		/**
		 * Whether to return an object consisting of data and status and error codes or only the simple data
		 */
		complexResult: true,

		/**
		 * fallback value when complexResult is set to false and an error occurred. Then fallback will be returned.
		 */
		fallback: undefined
	};

	/**
	 * Convenience wrapper around <code>jQuery.ajax()</code> that avoids the need for callback functions when
	 * synchronous calls are made. If the setting <code>complexResult</code> is true (default), then the return value
	 * is an object with the following properties
	 * <ul>
	 * <li><code>success</code> boolean whether the call succeeded or not
	 * <li><code>data</code> any the data returned by the call. For dataType 'text' this is a string,
	 *                       for JSON it is an object, for XML it is a document. When the call failed, then data is not defined
	 * <li><code>status</code> string a textual status ('success,', 'error', 'timeout',...)
	 * <li><code>statusCode</code> string the HTTP status code of the request
	 * <li><code>error</code> Error an error object (exception) in case an error occurred
	 * </ul>
	 *
	 * When <code>complexResult</code> is false, then in the case of success, only 'data' is returned, in case of an error the
	 * 'fallback' setting is returned (defaults to undefined).
	 *
	 * Note that async=false is always enforced by this method.
	 *
	 * @param {string} oOrigSettings the ajax() settings
	 * @return result, see above
	 *
	 * @public
	 * @since 0.9.0
	 * @SecSink {0|PATH} Parameter is used for future HTTP requests
	 */
	jQuery.sap.sjax = function sjax(oOrigSettings) {

		var s = jQuery.extend(true, {}, jQuery.sap.sjaxSettings, oOrigSettings,

			// the following settings are enforced as this is the rightmost object in the extend call
			{
				async: false,
				success : function(data, textStatus, xhr) {
//					oResult = { success : true, data : data, status : textStatus, statusCode : xhr.status };
					oResult = { success : true, data : data, status : textStatus, statusCode : xhr&&xhr.status };
				},
				error : function(xhr, textStatus, error) {
					oResult = { success : false, data : undefined, status : textStatus, error : error, statusCode : xhr.status };
				}
			});

		var oResult = undefined;

		jQuery.ajax(s);

		if (!s.complexResult) {
			return oResult.success ? oResult.data : s.fallback;
		}

		return oResult;
	};

	/**
	 * Convenience wrapper that checks whether a given web resource could be accessed.
	 * @SecSink {0|PATH} Parameter is used for future HTTP requests
	 * @SecSource {return} Returned value is under control of an external resource
	 */
	jQuery.sap.syncHead = function(sUrl) {
		return jQuery.sap.sjax({type:'HEAD', url: sUrl}).success;
	};

	/**
	 * Convenience wrapper for {@link jQuery.sap.sjax} that enforeces the Http method GET and defaults the
	 * data type of the result to 'text'.
	 *
	 * @param {string} sUrl the URL
	 * @param {string|object} data request parameters in the format accepted by jQuery.ajax()
	 * @param {string} [sDataType='text'] the type of data expected from the server, default is "text"
	 * @return result @see jQuery.sap.sjax
	 *
	 * @public
	 * @since 0.9.0
	 * @SecSink {0 1|PATH} Parameter is used for future HTTP requests
	 * @SecSource {return} Returned value is under control of an external resource
	 */
	jQuery.sap.syncGet = function syncGet(sUrl, data, sDataType) {
		return jQuery.sap.sjax({
			url: sUrl,
			data: data,
			type: 'GET',
			dataType: sDataType || 'text'
		});
	};

	/**
	 * Convenience wrapper for {@link jQuery.sap.sjax} that enforces the Http method POST and defaults the
	 * data type of the result to 'text'.
	 *
	 * @param {string} sUrl the URL
	 * @param {string|object} data request parameters in the format accepted by jQuery.ajax()
	 * @param {string} [sDataType='text'] the type of data expected from the server, default is "text"
	 * @return result @see jQuery.sap.sjax
	 *
	 * @public
	 * @since 0.9.0
	 * @SecSink {0 1|PATH} Parameter is used for future HTTP requests
	 * @SecSource {return} Returned value is under control of an external resource
	 */
	jQuery.sap.syncPost = function syncPost(sUrl, data, sDataType) {
		return jQuery.sap.sjax({
			url: sUrl,
			data: data,
			type: 'POST',
			dataType: sDataType || 'text'
		});
	};

	/**
	 * Convenience wrapper for {@link jQuery.sap.sjax} that enforces the Http method GET and the data type 'text'.
	 * If a fallback value is given, the function simply returns the response as a text or - if some error occurred -
	 * the fallback value. This is useful for applications that don't require detailed error diagnostics.
	 *
	 * If applications need to know about occurring errors, they can either call <code>sjax()</code> directly
	 * or they can omit the fallback value (providing only two parameters to syncGetText()).
	 * They then receive the same complex result object as for the sjax() call.
	 *
	 * @param {string} sUrl the URL
	 * @param {string|object} data request parameters in the format accepted by jQuery.ajax()
	 * @param {string} [fallback] if set, only data is returned (and this fallback instead in case of errors); if unset, a result structure is returned
	 * @return  result @see jQuery.sap.sjax
	 *
	 * @public
	 * @since 0.9.0
	 * @SecSink {0 1|PATH} Parameter is used for future HTTP requests
	 */
	jQuery.sap.syncGetText = function syncGetText(sUrl, data, fallback) {
		return jQuery.sap.sjax({
			url: sUrl,
			data: data,
			type: 'GET',
			dataType: 'text',
			fallback: fallback,
			complexResult : (arguments.length < 3)
		});
	};

	/**
	 * Convenience wrapper for {@link jQuery.sap.sjax} that enforces the Http method GET and the data type 'json'.
	 * If a fallback value is given, the function simply returns the response as an object or - if some error occurred -
	 * the fallback value. This is useful for applications that don't require detailed error diagnostics.
	 *
	 * If applications need to know about occurring errors, they can either call <code>sjax()</code> directly
	 * or they can omit the fallback value (providing only two parameters to syncGetJSON()).
	 * They then receive the same complex result object as for the sjax() call.
	 *
	 * Note that providing "undefined" or "null" as a fallback is different from omitting the fallback (complex result).
	 *
	 * @param {string} sUrl the URL
	 * @param {string|object} data request parameters in the format accepted by jQuery.ajax()
	 * @param {object} [fallback] if set, only data is returned (and this fallback instead in case of errors); if unset, a result structure is returned
	 * @return result @see jQuery.sap.sjax
	 *
	 * @public
	 * @since 0.9.0
	 * @SecSink {0 1|PATH} Parameter is used for future HTTP requests
	 */
	jQuery.sap.syncGetJSON = function syncGetJSON(sUrl, data, fallback) {
		return jQuery.sap.sjax({
			url: sUrl,
			data: data || null,
			type: 'GET',
			dataType: 'json',
			fallback: fallback,
			complexResult : (arguments.length < 3)
		});
	};

	return jQuery;

}, /* bExport= */ false);

}; // end of jquery.sap.sjax.js
sap.ui.define("jquery.sap.properties",['jquery.sap.global', 'jquery.sap.sjax'],
	function(jQuery/* , jQuerySap1 */) {
	"use strict";

	// Javadoc for private inner class "Properties" - this list of comments is intentional!
	/**
	 * @interface  Represents a list of properties (key/value pairs).
	 *
	 * Each key and its corresponding value in the property list is a string.
	 * Values are unicode escaped \ue0012.
	 * Keys are case-sensitive and only alpha-numeric characters with a leading character are allowed.
	 *
	 * Use {@link jQuery.sap.properties} to create an instance of jQuery.sap.util.Properties.
	 *
	 * The getProperty method is used to retrieve a value from the list.
	 * The setProperty method is used to store or change a property in the list.
	 * Additionally, the getKeys method can be used to retrieve an array of all keys that are
	 * currently in the list.
	 *
	 * @author SAP AG
	 * @version 1.20.6
	 * @since 0.9.0
	 * @name jQuery.sap.util.Properties
	 * @public
	 */
	/**
	 * Returns the value of a given key. Optionally, a given default value is returned if the requested key is not in the list.
	 * @param {string} sKey The key of the property
	 * @param {string} [sDefaultValue] Optional, the default value if the requested key is not in the list.
	 * @return {string} The value of a given key. The default value (if given) is returned if the requested key is not in the list.
	 *
	 * @function
	 * @name jQuery.sap.util.Properties.prototype.getProperty
	 */
	/**
	 * Returns an array of all keys in the property list.
	 * @return {array} All keys in the property list.
	 *
	 * @function
	 * @name jQuery.sap.util.Properties.prototype.getKeys
	 */
	/**
	 * Adds or changes a given key to/in the list.
	 * @param {string} sKey The key of the property
	 * @param {string} sValue The value for the key with unicode encoding.
	 *
	 * @function
	 * @name jQuery.sap.util.Properties.prototype.setProperty
	 */
	/**
	 * Creates and returns a clone of the property list.
	 * @return {jQuery.sap.util.Properties} A clone of the property list
	 *
	 * @function
	 * @name jQuery.sap.util.Properties.prototype.clone
	 */

	/*
	 * Implements jQuery.sap.util.Properties
	 */
	var Properties = function() {
		this.mProperties = {};
		this.aKeys = [];
	};

	/*
	 * Implements jQuery.sap.util.Properties.prototype.getProperty
	 */
	Properties.prototype.getProperty = function(sKey, sDefaultValue) {
		var sValue = this.mProperties[sKey];
		if (typeof(sValue)=="string") {
			return sValue;
		}
		else if(sDefaultValue) {
			return sDefaultValue;
		}
		return null;
	};

	/*
	 * Implements jQuery.sap.util.Properties.prototype.getKeys
	 */
	Properties.prototype.getKeys = function() {
		return this.aKeys;
	};

	/*
	 * Implements jQuery.sap.util.Properties.prototype.setProperty
	 */
	Properties.prototype.setProperty = function(sKey, sValue) {
		if (typeof(sValue) != "string") {
			return;
		}		
		if (typeof(this.mProperties[sKey])!="string") {
			this.aKeys.push(sKey);
		}
		this.mProperties[sKey] = sValue;
	};

	/*
	 * Implements jQuery.sap.util.Properties.prototype.clone
	 */
	Properties.prototype.clone = function() {
		var oClone = new Properties();
		oClone.mProperties = jQuery.extend({}, this.mProperties);
		oClone.aKeys = jQuery.merge([], this.aKeys);
		return oClone;
	};

	/*
	 * Saves the property list to a given URL using a POST request.
	 */
	//sap.ui.resource.Properties.prototype.save = function(sUrl) {
	//	return jQuery.sap.syncPost(sUrl, this.mProperties);
	//};

	/**
	 * RegExp used to split file into lines, also removes leading whitespace.
	 * Note: group must be non-capturing, otherwise the line feeds will be part of the split result.
	 */
	var rLines = /(?:^|\r\n|\r|\n)[ \t\f]*/;

	/**
	 * RegExp that handles escapes, continuation line markers and key/value separators
	 * 
	 *              [---unicode escape--] [esc] [cnt] [---key/value separator---]
	 */
	var rEscapes = /(\\u[0-9a-fA-F]{0,4})|(\\.)|(\\$)|([ \t\f]*[ \t\f:=][ \t\f]*)/g;
	
	/**
	 * Special escape characters as supported by properties format
	 * @see JDK API doc for java.util.Properties
	 */
	var mEscapes = {
		'\\f' : '\f',
		'\\n' : '\n',
		'\\r' : '\r',
		'\\t' : '\t'
	};

	/*
	 * Parses the given text sText and sets the properties
	 * in the properties object oProp accordingly.
	 * @param {string} sText the text to parse
	 * @param oProp the properties object to fill
	 * @private
	 */
	function parse(sText, oProp) {
		
		var aLines = sText.split(rLines), // split file into lines
			sLine,sKey,sValue,bKey,i,m,iLastIndex;
		
		oProp.mProperties = {};
		oProp.aKeys = [];

		for (i=0; i<aLines.length; i++) {
			sLine = aLines[i];
			// ignore empty lines
			if (sLine === "" || sLine.charAt(0) === "#" || sLine.charAt(0) === "!" ) {
				continue;
			}

			rEscapes.lastIndex = iLastIndex = 0;
			sValue = ""; 
			bKey = true;

			while ( m = rEscapes.exec(sLine) ) {
				// handle any raw, unmatched input
				if ( iLastIndex < m.index ) {
					sValue += sLine.slice(iLastIndex, m.index);
				}
				iLastIndex = rEscapes.lastIndex;
				if ( m[1] ) { 
					// unicode escape
					if ( m[1].length !== 6 ) {
						throw new Error("Incomplete Unicode Escape '" + m[1] + "'");
					}
					sValue += String.fromCharCode(parseInt(m[1].slice(2), 16));
				} else if ( m[2] ) { 
					// special or simple escape
					sValue += mEscapes[m[2]] || m[2].slice(1);
				} else if ( m[3] ) { 
					// continuation line marker
					sLine = aLines[++i];
					rEscapes.lastIndex = iLastIndex = 0;
				} else if ( m[4] ) { 
					// key/value separator					
					if ( bKey ) {
						bKey = false;
						sKey = sValue;
						sValue = "";
					} else {
						sValue += m[4];
					}
				}
			}
			if ( iLastIndex < sLine.length ) {
				sValue += sLine.slice(iLastIndex);
			}
			if ( bKey ) {
				sKey = sValue;
				sValue = "";
			}
			oProp.aKeys.push(sKey);
			oProp.mProperties[sKey] = sValue;
		}
		
		// remove duplicates from keyset (sideeffect:sort)
		jQuery.sap.unique(oProp.aKeys);
	}

	/**
	 * Creates and returns a new instance of {@link jQuery.sap.util.Properties}.
	 *
	 * If option 'url' is passed, immediately a load request for the given target is triggered.
	 * A property file that is loaded can contain comments with a leading ! or #.
	 * The loaded property list does not contain any comments.
	 *
	 * <b>Example for loading a property file:</b>
	 * <pre>
	 *  jQuery.sap.properties({url : "../myProperty.properties"});
	 * </pre>
	 *
	 * <b>Example for creating an empty properties instance:</b>
	 * <pre>
	 *  jQuery.sap.properties();
	 * </pre>
	 *
	 * <b>Examples for getting and setting properties:</b>
	 * <pre>
	 *	var oProperties = jQuery.sap.properties();
	 *	oProperties.setProperty("KEY_1","Test Key");
	 *	var sValue1 = oProperties.getProperty("KEY_1");
	 *	var sValue2 = oProperties.getProperty("KEY_2","Default");
	 * </pre>
	 *
	 * @public
	 * @param {object} [mParams] Parameters used to initialize the property list
	 * @param {string} [mParams.url] The URL to the .properties file which should be loaded.
	 * @param {object} [mParams.headers] A map of additional header key/value pairs to send along with the request (see headers option of jQuery.ajax). 
	 * @return {jQuery.sap.util.Properties} A new property list instance
	 * @SecSink {0|PATH} Parameter is used for future HTTP requests
	 */
	jQuery.sap.properties = function properties(mParams) {
		var oProp = new Properties();
		mParams = jQuery.extend({url: undefined, headers: {}}, mParams);
		if (typeof(mParams.url) == "string"){
			var sText = jQuery.sap.loadResource({
				url: mParams.url,
				dataType: 'text',
				headers: mParams.headers,
				failOnError: false
			});
		
			if (typeof(sText) == "string") {
				parse(sText, oProp);
			}
		}
		return oProp;
	};

	return jQuery;

}, /* bExport= */ false);

}; // end of jquery.sap.properties.js
if ( !jQuery.sap.isDeclared('jquery.sap.resources') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides access to Java-like resource bundles in properties file format
jQuery.sap.declare('jquery.sap.resources'); // unresolved dependency added by SAPUI5 CreateModule Ant-Task
sap.ui.define("jquery.sap.resources",['jquery.sap.global', 'jquery.sap.properties', 'jquery.sap.strings'],
	function(jQuery/* , jQuerySap1, jQuerySap2 */) {
	"use strict";

	// Javadoc for private inner class "Bundle" - this list of comments is intentional!
	/**
	 * @interface  Contains locale-specific texts.
	 *
	 * If you need a locale-specific text within your application, you can use the
	 * resource bundle to load the locale-specific file from the server and access
	 * the texts of it.
	 *
	 * Use {@link jQuery.sap.resources} to create an instance of jQuery.sap.util.ResourceBundle.
	 * There you have to specify the URL to the base .properties file of a bundle
	 * (.properties without any locale information, e.g. "mybundle.properties"), and optionally
	 * a locale. The locale is defined as a string of the language and an optional country code
	 * separated by underscore (e.g. "en_GB" or "fr"). If no locale is passed, the default
	 * locale is "en" if the SAPUI5 framework is not available. Otherwise the default locale is taken from
	 * the SAPUI5 configuration.
	 *
	 * With the getText() method of the resource bundle, a locale-specific string value
	 * for a given key will be returned.
	 *
	 * With the given locale, the ResourceBundle requests the locale-specific properties file
	 * (e.g. "mybundle_fr_FR.properties"). If no file is found for the requested locale or if the file
	 * does not contain a text for the given key, a sequence of fall back locales is tried one by one. 
	 * First, if the locale contains a region information (fr_FR), then the locale without the region is
	 * tried (fr). If that also can't be found or doesn't contain the requested text, the english file 
	 * is used (en - assuming that most development projects contain at least english texts).    
	 * If that also fails, the file without locale (base URL of the bundle) is tried.
	 * 
	 * If none of the requested files can be found or none of them contains a text for the given key,
	 * then the key itself is returned as text. 
	 *
	 * Exception: Fallback for "zh_HK" is "zh_TW" before zh.
	 *
	 * @author SAP AG
	 * @version 1.20.6
	 * @since 0.9.0
	 * @name jQuery.sap.util.ResourceBundle
	 * @public
	 */
	
	/**
	 * Returns a locale-specific string value for the given key sKey. 
	 * 
	 * The text is searched in this resource bundle according to the fallback chain described in 
	 * {@link jQuery.sap.util.ResourceBundle}. If no text could be found, the key itself is used as text.
	 * 
	 * If text parameters are given, then any occurrences of the pattern "{<i>n</i>}" with <i>n</i> being an integer 
	 * are replaced by the parameter value with index <i>n</i>.  Note: This replacement is also applied if no text had been found (key).
	 * For more details on this replacement mechanism refer also:
	 * @see jQuery.sap#formatMessage
	 * 
	 * @param {string} sKey
	 * @param {string[]} [aArgs] List of parameters which should replace the place holders "{n}" (n is the index) in the found locale-specific string value.
	 * @return {string} The value belonging to the key, if found; otherwise the key itself.
	 *
	 * @function
	 * @name jQuery.sap.util.ResourceBundle.prototype.getText
	 * @public
	 */

	/**
	 * Enhances the resource bundle with a custom resource bundle. The bundle
	 * can be enhanced with multiple resource bundles. The last enhanced resource
	 * bundle wins against the previous ones and the original ones. This function
	 * can be called several times.
	 *
	 * @param {jQuery.sap.util.ResourceBundle} oBundle an instance of a <code>jQuery.sap.util.ResourceBundle</code>
	 * @since 1.16.5
	 * @private
	 * 
	 * @function
	 * @name jQuery.sap.util.ResourceBundle.prototype._enhance
	 */
	
	/**
	 * A regular expression that describes language tags according to BCP-47.
	 * @see BCP47 "Tags for Identifying Languages" (http://www.ietf.org/rfc/bcp/bcp47.txt)
	 *
	 * The matching groups are
	 *  0=all
	 *  1=language (shortest ISO639 code + ext. language sub tags | 4digits (reserved) | registered language sub tags)
	 *  2=script (4 letters)
	 *  3=region (2letter language or 3 digits)
	 *  4=variants (separated by '-', Note: capturing group contains leading '-' to shorten the regex!)
	 *  5=extensions (including leading singleton, multiple extensions separated by '-')
	 *  6=private use section (including leading 'x', multiple sections separated by '-')
	 *  
	 *            [-------------------- language ----------------------][--- script ---][------- region --------][------------ variants --------------][--------- extensions --------------][------ private use -------]
	 */
	var rlocale=/^((?:[A-Z]{2,3}(?:-[A-Z]{3}){0,3})|[A-Z]{4}|[A-Z]{5,8})(?:-([A-Z]{4}))?(?:-([A-Z]{2}|[0-9]{3}))?(-[0-9A-Z]{5,8}|(?:[0-9][0-9A-Z]{3}))*(?:-([0-9A-WYZ](?:-[0-9A-Z]{2,8})+))*(?:-(X(?:-[0-9A-Z]{1,8})+))?$/i;

	/**
	 * Resource bundles are stored according to the Java Development Kit conventions.
	 * JDK uses old language names for a few ISO639 codes ("iw" for "he", "ji" for "yi", "in" for "id" and "sh" for "sr").
	 * Make sure to convert newer codes to older ones before creating file names.
	 */
	var M_ISO639_NEW_TO_OLD = {
		"he" : "iw",
		"yi" : "ji",
		"id" : "in", 
		"sr" : "sh" 
	};

	var M_ISO639_OLD_TO_NEW = {
		"iw" : "he",
		"ji" : "yi",
		"in" : "id",
		"sn" : "sr"
	};

	var rSAPSupportabilityLocales = /-(saptrc|sappsd)(?:-|$)/i;

	/**
	 * Helper to normalize the given locale (in BCP-47 syntax) to the java.util.Locale format.
	 * @return {string} Normalized locale or undefined if the locale can't be normalized
	 */
	function normalize(sLocale) {
		var m;
		if ( typeof sLocale === 'string' && (m = rlocale.exec(sLocale.replace(/_/g, '-'))) ) {
			var sLanguage = m[1].toLowerCase();
			sLanguage = M_ISO639_NEW_TO_OLD[sLanguage] || sLanguage;
			var sScript = m[2] ? m[2].toLowerCase() : undefined;
			var sRegion = m[3] ? m[3].toUpperCase() : undefined;
			var sVariants = m[4];
			var sPrivate = m[6];
			// recognize and convert special SAP supportability locales (overwrites m[]!)
			if ( (sPrivate && (m = rSAPSupportabilityLocales.exec(sPrivate)))
					 || (sVariants && (m = rSAPSupportabilityLocales.exec(sVariants))) ) {
				return "en_US_" + m[1].toLowerCase(); // for now enforce en_US (agreed with SAP SLS)
			}
			// Chinese: when no region but a script is specified, use default region for each script 
			if ( sLanguage === "zh" && !sRegion ) {
				if ( sScript === "hans" ) {
					sRegion = "CN"; 
				} else if ( sScript === "hant" ) {
					sRegion = "TW";
				}
			}
			return sLanguage + (sRegion ? "_" + sRegion + (sVariants ? "_" + sVariants.slice(1).replace("-","_") : "") : "");
		}
	}
	
	/**
	 * Returns the default locale (the locale defined in UI5 configuration if available, else "en")
	 * @return {string} The default locale
	 */
	function defaultLocale() {
		var sLocale;
		if(window.sap && sap.ui && sap.ui.getCore){
			sLocale = sap.ui.getCore().getConfiguration().getLanguage();
			sLocale = normalize(sLocale);
		}
		return sLocale || "en";
	}
	
	/**
	 * Helper to normalize the given locale (java.util.Locale format) to the BCP-47 syntax.
	 * @return {string} Normalized locale or undefined if the locale can't be normalized
	 */
	function convertLocaleToBCP47(sLocale) {
		var m;
		if ( typeof sLocale === 'string' && (m = rlocale.exec(sLocale.replace(/_/g, '-'))) ) {
			var sLanguage = m[1].toLowerCase();
			sLanguage = M_ISO639_OLD_TO_NEW[sLanguage] || sLanguage;
			return sLanguage + (m[3] ? "-" + m[3].toUpperCase() + (m[4] ? "-" + m[4].slice(1).replace("_","-") : "") : "");
		}
	}

    /**
     * A regular expression to split a URL into
     * <ol> 
     * <li>a part before the file extension 
     * <li>the file extension itself
     * <li>any remaining part after the file extension (query, hash - optional)
     * </ol>.
     * 
     * Won't match for URLs without a file extension.
     *
     *           [------- prefix ------][----ext----][-------suffix--------]
     *                                               ?[--query--]#[--hash--]
     */
	var rUrl = /^((?:[^?#]*\/)?[^\/?#]*)(\.[^.\/?#]+)((?:\?([^#]*))?(?:#(.*))?)$/;

    /**
     * List of supported file extensions. 
     *
     * Could be enriched in future or even could be made
     * extensible to support other formats as well.
     */
	var aValidFileTypes = [ ".properties", ".hdbtextbundle"]; 

    /**
     * Helper to split a URL with the above regex.
     * Either returns an object with the parts or undefined.
     */
	function splitUrl(sUrl) {
		var m = rUrl.exec(sUrl);
		return m && { url : sUrl, prefix : m[1], ext : m[2], query: m[4], hash: (m[5] || ""), suffix : m[2] + (m[3] || "") };
	}

	/*
	 * Implements jQuery.sap.util.ResourceBundle
	 */
	var Bundle = function(sUrl, sLocale, bIncludeInfo){
		//last fallback is english if no or no valid locale is given
		//TODO: If the browsers allow to access the users language preference this should be the fallback
		this.sLocale = normalize(sLocale) || defaultLocale();
		this.oUrlInfo = splitUrl(sUrl);
		if ( !this.oUrlInfo || jQuery.inArray(this.oUrlInfo.ext, aValidFileTypes) < 0 ) {
			throw new Error("resource URL '" + sUrl + "' has unknown type (should be one of " + aValidFileTypes.join(",") + ")");
		}
		this.bIncludeInfo = bIncludeInfo;
		// list of custom bundles
		this.aCustomBundles = [];
		//declare list of property files that are loaded
		this.aPropertyFiles = [];
		this.aLocales = [];
		//load the most specific property file
		load(this, this.sLocale);
	};

	Bundle.prototype = {};

	/*
	 * Implements jQuery.sap.util.ResourceBundle.prototype._enhance
	 */
	Bundle.prototype._enhance = function(oCustomBundle) {
		if (oCustomBundle && oCustomBundle instanceof Bundle) {
			this.aCustomBundles.push(oCustomBundle);
		} else {
			// we report the error but do not break the execution
			jQuery.sap.log.error("Custom ResourceBundle is either undefined or not an instanceof jQuery.sap.util.ResourceBundle. Therefore this custom ResourceBundle will be ignored!");
		}
	};
	
	/*
	 * Implements jQuery.sap.util.ResourceBundle.prototype.getText
	 */
	Bundle.prototype.getText = function(sKey, aArgs, bCustomBundle){
		var sValue = null;
		
		// loop over the custom bundles before resolving this one
		// lookup the custom resource bundles (last one first!)
		for (var i = this.aCustomBundles.length - 1; i >= 0; i--) {
			sValue = this.aCustomBundles[i].getText(sKey, aArgs, true /* bCustomBundle */);
			// value found - so return it!
			if (sValue != null) {
				return sValue; // found!
			}
		}
		
		//loop over all loaded property files and return the value for the key if any
		for(var i=0; i<this.aPropertyFiles.length; i++){
			sValue = this.aPropertyFiles[i].getProperty(sKey);
			if(typeof(sValue)==="string") {
				break;
			}
		}

		//value for this key was not found in the currently loaded property files,
		//load the fallback locales
		if(typeof(sValue)!=="string"){
			var sTempLocale = this.aLocales[0];
			while(sTempLocale.length > 0){
				// TODO: validate why, maybe remove? Introduced by Martin S.
				// keep in sync with fallback mechanism in Java, ABAP (MIME & BSP)
				// resource handler (Java: Peter M., MIME: Sebastian A., BSP: Silke A.)
				if(sTempLocale == "zh_HK"){
					sTempLocale = "zh_TW";
				}else{
					var p = sTempLocale.lastIndexOf('_');
					if(p >= 0){
						sTempLocale = sTempLocale.substring(0,p);
					}else if(sTempLocale != "en"){
						sTempLocale = "en";
					}else{
						sTempLocale = "";
					}
				}

				var oProperties = load(this, sTempLocale);
				if(oProperties == null) {
					continue;
				}

				//check whether the key is included in the newly loaded property file
				sValue = oProperties.getProperty(sKey);
				if (typeof(sValue)==="string") {
					break;
				}
			}
		}

		if(!bCustomBundle && typeof(sValue)!=="string"){
			jQuery.sap.assert(false, "could not find any translatable text for key '" + sKey + "' in bundle '" + this.oUrlInfo.url + "'");
			sValue = sKey;
		}

		if(typeof(sValue)==="string") {
			if(aArgs){
				sValue = jQuery.sap.formatMessage(sValue, aArgs);
			}

			if (this.bIncludeInfo) {
				sValue = new String(sValue);
				sValue.originInfo = {
					source: "Resource Bundle",
					url: this.oUrlInfo.url,
					locale: this.sLocale,
					key: sKey
				};
			}
		} 

		return sValue;
	};

	/*
	 * If a .properties file for the given locale is not loaded yet
	 * in the given bundle, this method loads the .properties file and
	 * adds it to the bundle.
	 * @param {string} sLocale the text to parse
	 * @param oBundle the resource bundle to extend
	 * @return The newly loaded properties or <code>null</code>
	 *         when the properties for the given locale already loaded.
	 * @private
	 */
	function load(oBundle, sLocale) {
		var oUrl = oBundle.oUrlInfo,
			oRequest,
			oProperties; 

		if( jQuery.inArray(sLocale, oBundle.aLocales) == -1 ){
			if ( shouldRequest(sLocale) ) {
				switch (oUrl.ext) {
					case '.hdbtextbundle':
						oRequest = {
							url: oUrl.url,
							// Alternative: add locale as query:
							// url: oUrl.prefix + oUrl.suffix + '?' + (oUrl.query ? oUrl.query + "&" : "") + "locale=" + sLocale + (oUrl.hash ? "#" + oUrl.hash : ""),
							headers : {
								"Accept-Language": convertLocaleToBCP47(sLocale) || ""
							}
						};
						break;
					default:
						oRequest = {
							url: oUrl.prefix + (sLocale ? "_" + sLocale : "") + oUrl.suffix
						};
						break;
				}
				oProperties = jQuery.sap.properties(oRequest);
			} else {
				// dummy result (empty)
				oProperties = {
						getProperty : function() { return undefined; }
				}
			}
			
			// remember result and locales that have been loaded so far (to avoid repeated roundtrips) 
			oBundle.aPropertyFiles.push(oProperties);
			oBundle.aLocales.push(sLocale);
			
			return oProperties;
		}
		return null;
	}

	function shouldRequest(sLocale) {
		var aLanguages = window.sap && sap.ui && sap.ui.getCore && sap.ui.getCore().getConfiguration().getSupportedLanguages();
		if ( aLanguages && aLanguages.length > 0 ) {
			return jQuery.inArray(sLocale, aLanguages) >= 0;
		}
		return true;
	}
	
	/**
	 * Creates and returns a new instance of {@link jQuery.sap.util.ResourceBundle}
	 * using the given URL and locale to determine what to load.
	 *
	 * @public
	 * @param {object} [mParams] Parameters used to initialize the resource bundle
	 * @param {string} [mParams.url=''] The URL to the base .properties file of a bundle (.properties file without any locale information, e.g. "mybundle.properties")
	 * @param {string} [mParams.locale='en'] Optional string of the language and an optional country code separated by underscore (e.g. "en_GB" or "fr")
	 * @param {boolean} [mParams.includeInfo=false] Optional boolean whether to include origin information into the returned property values
	 * @return {jQuery.sap.util.ResourceBundle} A new resource bundle instance
	 * @SecSink {0|PATH} Parameter is used for future HTTP requests
	 */
	jQuery.sap.resources = function resources(mParams) {
		mParams = jQuery.extend({url: "", locale: undefined, includeInfo: false}, mParams);
		var oBundle = new Bundle(mParams.url, mParams.locale, mParams.includeInfo);
		return oBundle;
	};

	jQuery.sap.resources._getFallbackLocales = function(sLocale, aSupportedLocales) {
		var sTempLocale = normalize(sLocale),
			aLocales=[];

		function supported(sLocale) {
			return !aSupportedLocales || aSupportedLocales.length === 0 || jQuery.inArray(sLocale, aSupportedLocales) >= 0;
		}
		
		while (sTempLocale) {
			if ( supported(sTempLocale) ) {
				aLocales.push(sTempLocale);
			}
			// TODO: validate why, maybe remove? Introduced by Martin S.
			// keep in sync with fallback mechanism in Java, ABAP (MIME & BSP)
			// resource handler (Java: Peter M., MIME: Sebastian A., BSP: Silke A.)
			if ( sTempLocale === "zh_HK" ) {
				sTempLocale = "zh_TW";
			} else {
				var p = sTempLocale.lastIndexOf('_');
				if (p > 0 ) {
					sTempLocale = sTempLocale.slice(0, p);
				} else if ( sTempLocale !== "en" ) {
					sTempLocale = "en";
				} else {
				  sTempLocale = "";
				}
			}
		}
		if ( supported("") ) {
			aLocales.push("");
		}
		return aLocales;
	};

	return jQuery;

}, /* bExport= */ false);

}; // end of jquery.sap.resources.js
sap.ui.define("sap/ui/core/Core",['jquery.sap.global', 'sap/ui/Device', 'sap/ui/Global', 'sap/ui/base/DataType', 'sap/ui/base/EventProvider', './Component', './Configuration', './Control', './Element', './ElementMetadata', './FocusHandler', './RenderManager', './ResizeHandler', './ThemeCheck', './UIArea', './tmpl/Template', 'jquery.sap.act', 'jquery.sap.dom', 'jquery.sap.events', 'jquery.sap.mobile', 'jquery.sap.properties', 'jquery.sap.resources', 'jquery.sap.script'],
	function(jQuery, Device, Global, DataType, EventProvider, Component, Configuration, Control, Element, ElementMetadata, FocusHandler, RenderManager, ResizeHandler, ThemeCheck, UIArea, Template/* , jQuerySap6, jQuerySap, jQuerySap1, jQuerySap2, jQuerySap3, jQuerySap4, jQuerySap5 */) {
	"use strict";


	
	/**
	 * @class Core Class of the SAP UI Library.
	 *
	 * This class boots the Core framework and makes it available for the Application
	 * via the method <code>sap.ui.getCore()</code>.
	 *
	 * Example:<br/>
	 * <pre>   var oCore = sap.ui.getCore();</pre><br/>
	 *
	 * It provides events where the Application can attach to.<br/>
	 * Example:<br/>
	 * <pre>
	 * oCore.attachInit(function () {
	 *   //do the needful, do it lean
	 * });
	 * </pre><br/>
	 *
	 * It registers the Browser Eventing.
	 *
	 * @extends sap.ui.base.EventProvider
	 * @final
	 * @author SAP
	 * @version 1.20.6
	 * @constructor
	 * @name sap.ui.core.Core 
	 * @public
	 */
	var Core = EventProvider.extend("sap.ui.core.Core", /** @lends sap.ui.core.Core */ {
		constructor : function() {
		
			//make this class only available once
			if(sap.ui.getCore && sap.ui.getCore()) {
				return sap.ui.getCore();
			}
		
			var that=this,
				log = jQuery.sap.log,
				METHOD="sap.ui.core.Core";
		
			//inheritance to be able to fire internal events
			EventProvider.apply(this);
		
			/**
			 * Whether the core has been booted
			 * @private
			 */
			this.bBooted = false;
		
			/**
			 * Whether the core has been initialized
			 * @private
			 */
			this.bInitialized = false;
		
			/**
			 * Available plugins in the order of registration.
			 * @private
			 */
			this.aPlugins = [];
		
			/**
			 * Collection of loaded libraries, keyed by their name.
			 * @private
			 */
			this.mLibraries = {};
		
			/**
			 * Already loaded resource bundles keyed by library and locale.
			 * @private
			 * @see sap.ui.core.Core.getLibraryResourceBundle
			 */
			this.mResourceBundles = {};
		
			/**
			 * Currently created UIAreas keyed by their id.
			 * @private
			 * FIXME how can a UI area ever be removed?
			 */
			this.mUIAreas = {};
		
			/**
			 * Default model used for databinding
			 * @private
			 */
			this.oModels = {};
			
			/**
			 * The event bus (initialized lazily)
			 * @private
			 */
			this.oEventBus = null;
			
			/**
			 * Map of of created Elements keyed by their id.
			 *
			 * Each element registers itself in its constructor and deregisters itself in its
			 * destroy method.
			 *
			 * @private
			 * TODO get rid of this collection as it represents a candidate for memory leaks
			 */
			this.mElements = {};
		
			/**
			 * Map of of created objects structured by their type which contains a map
			 * containing the created objects keyed by their type.
			 *
			 * Each object registers itself in its constructor and deregisters itself in its
			 * destroy method.
			 * 
			 * @private
			 * TODO get rid of this collection as it represents a candidate for memory leaks
			 */
			this.mObjects = {
				"component": {}, 
				"template": {}
			};
		
			/**
			 * The instance of the root component (defined in the configuration {@link sap.ui.core.Configuration#getRootComponent})
			 * @private
			 */
			this.oRootComponent = null;
		
			/**
			 * Ordered collection of initEvent listeners
			 * Moved here (before boot()) so that the libraries can be registered for lazy load!!
			 * @private
			 */
			this.aInitListeners = [];
		
			/**
			 * Whether the legacy library has to be loaded.
			 * @private
			 */
			this.bInitLegacyLib = false;
		
			log.info("Creating Core",null,METHOD);
		
			/**
			 * Object holding the interpreted configuration
			 * Initialized from the global "sap-ui-config" object and from Url parameters
			 * @private
			 */
			this.oConfiguration = new Configuration(this);
		
			// enable complex bindings if configured
			if ( this.oConfiguration["xx-bindingSyntax"] === "complex" ) {
				sap.ui.base.ManagedObject.bindingParser = sap.ui.base.BindingParser.complexParser;
			}
			// switch bindingParser to designTime mode if configured 
			if (this.oConfiguration["xx-designMode"] == true ) {
				sap.ui.base.BindingParser._keepBindingStrings = true;
			}	
			// grant ElementMetadata "friend" access to Core for registration
			ElementMetadata.prototype.register = function(oMetadata) {
				that.registerElementClass(oMetadata);
			};
			// grant Element "friend" access to Core for (de-)registration
			Element.prototype.register = function() {
				that.registerElement(this);
			};
			Element.prototype.deregister = function() {
				that.deregisterElement(this);
			};
		
			// grant Component "friend" access to Core for (de-)registration
			Component.prototype.register = function() {
				that.registerObject(this);
			};
			Component.prototype.deregister = function() {
				that.deregisterObject(this);
			};
		
			// grant Template "friend" access to Core for (de-)registration
			Template.prototype.register = function() {
				that.registerObject(this);
			};
			Template.prototype.deregister = function() {
				that.deregisterObject(this);
			};
		
			// handle modules
			var aModules = this.oConfiguration.modules;
			if ( this.oConfiguration.getDebug() ) {
				// add debug module if configured
				aModules.unshift("sap-ui-debug");
			}
			// enforce the core library as the first loaded module
			var i=jQuery.inArray("sap.ui.core.library", aModules);
			if ( i!=0 ) {
				if ( i>0 ) {
					aModules.splice(i,1);
				}
				aModules.unshift("sap.ui.core.library");
			}
			
			log.info("Declared modules: " + aModules, METHOD);
		
			var oCfgData = window["sap-ui-config"];
			// Configuration might have a themeRoot, if so integrate it in themeroots
			if ( this.oConfiguration.themeRoot ) {
				oCfgData = oCfgData || {};
				oCfgData.themeroots = oCfgData.themeroots || {};
				oCfgData.themeroots[this.oConfiguration.getTheme()] = this.oConfiguration.themeRoot;
			}
			if (oCfgData) {
				// read themeRoots configuration
				if (oCfgData.themeroots) {
					for (var themeName in oCfgData.themeroots) {
						var themeRoot = oCfgData.themeroots[themeName];
						if (typeof themeRoot === "string") {
							this.setThemeRoot(themeName, themeRoot);
						} else {
							for (var lib in themeRoot) {
								if (lib.length > 0) {
									this.setThemeRoot(themeName, [lib], themeRoot[lib]);
								} else {
									this.setThemeRoot(themeName, themeRoot[lib]);
								}
							}
						}
					}
				}
			}
		
			// set CSS class for the theme name
			this.sTheme = this.oConfiguration.getTheme();
			jQuery(document.documentElement).addClass("sapUiTheme-" + this.sTheme);
			log.info("Declared theme " + this.sTheme,null,METHOD);
		
			if (this.oConfiguration.getRTL()) {
				jQuery(document.documentElement).attr("dir", "rtl"); // webkit does not allow setting document.dir before the body exists
				log.info("RTL mode activated",null,METHOD);
			}
		
		
			//set the browser for css attribute selectors. do not move this to the onload function because sf and ie do not
			//use the classes
			var $html = jQuery("html");
			
			var b = Device.browser;
			var id = b.name;
			
			if(id === b.BROWSER.CHROME){
				jQuery.browser.safari = false;
				jQuery.browser.chrome = true;
			}else if(id === b.BROWSER.SAFARI){
				jQuery.browser.safari = true;
				jQuery.browser.chrome = false;
				if(b.mobile){
					id = "m"+id;
				}
			}
			
			if(id){
				jQuery.browser.fVersion = b.version;
				jQuery.browser.mobile = b.mobile;
				
				id = id + Math.floor(b.version);
				$html.attr("data-sap-ui-browser", id);
				log.debug("Browser-Id: " + id, null, METHOD);
			}
			
		
			$html.attr("data-sap-ui-os", Device.os.name + Device.os.versionStr);
			var osCSS = null;
			switch(Device.os.name){
				case Device.os.OS.IOS:
					osCSS = "sap-ios";
					break;
				case Device.os.OS.ANDROID:
					osCSS = "sap-android";
					break;
				case Device.os.OS.BLACKBERRY:
					osCSS = "sap-bb";
					break;
				case Device.os.OS.WINDOWS_PHONE:
					osCSS = "sap-winphone";
					break;
			}
			if(osCSS){
				$html.addClass(osCSS);
			}
		
			//if weinre id is set, load weinre target script
			if (this.oConfiguration.getWeinreId()) {
				log.info("Starting WEINRE Remote Web Inspector");
				var sWeinreScript = "<script src=\"";
				sWeinreScript += this.oConfiguration.getWeinreServer();
				sWeinreScript += "/target/target-script-min.js#";
				sWeinreScript += jQuery.sap.encodeURL(this.oConfiguration.getWeinreId());
				sWeinreScript += "\"></script>";
				document.write(sWeinreScript);
			}
		
			// create accessor to the Core API early so that initLibrary and others can use it
			/**
			 * Retrieve the {@link sap.ui.core.Core SAPUI5 Core} instance for the current window.
			 * @returns {sap.ui.core.Core} the API of the current SAPUI5 Core instance.
			 * @public
			 * @function
			 */
			sap.ui.getCore = jQuery.sap.getter(this.getInterface());
		
			//Init the HTML5 support if necessary before initialize the RenderManager
			RenderManager.initHTML5Support();
			// create the RenderManager so it can be used already
			this.oRenderManager = new RenderManager();
		
			// sync point 1 synchronizes document ready and rest of UI5 boot
			var oSyncPoint1 = jQuery.sap.syncPoint("UI5 Document Ready", function(iOpenTasks, iFailures) {
				that.handleLoad();
			});
			var iDocumentReadyTask = oSyncPoint1.startTask("document.ready");
			var iCoreBootTask = oSyncPoint1.startTask("preload and boot");
		
			// task 1 is to wait for document.ready 
			jQuery(function() {
				log.trace("document is ready");
				oSyncPoint1.finishTask(iDocumentReadyTask);
			}); 
			
			// sync point 2 synchronizes all preload script loads and the end of the bootstrap script
			var oSyncPoint2 = jQuery.sap.syncPoint("UI5 Core Preloads and Bootstrap Script", function(iOpenTasks, iFailures) {
				log.trace("Core loaded: open=" + iOpenTasks + ", failures=" + iFailures);
				that._boot();
				oSyncPoint1.finishTask(iCoreBootTask);
			});
		
			// when a boot task is configured, add it to syncpoint2
			var fnCustomBootTask = this.oConfiguration["xx-bootTask"]; 
			if ( fnCustomBootTask ) {
			    var iCustomBootTask = oSyncPoint2.startTask("custom boot task");
			    fnCustomBootTask( function(bSuccess) { 
						oSyncPoint2.finishTask(iCustomBootTask, typeof bSuccess === "undefined" || bSuccess === true );
			    });
			}
	
			/**
			 * Whether the current browser needs a polyfill as a fallback for flex box support
			 * @type {boolean}
			 * @private
			 * @name jQuery.support.useFlexBoxPolyfill
			 * @since 1.12.0
			 * @deprecated since version 1.16.0
			 *
			 * For backwards compatibility we can't remove the deprecated flexbox polyfill.
			 * However, if the compatibility version is 1.16 or higher then the polyfill
			 * should not be used.
			 */
			var useFlexBoxPolyfillCompatVersion = new jQuery.sap.Version(this.oConfiguration.getCompatibilityVersion("flexBoxPolyfill"));
	
			// Always false if version is >= 1.16
			if(useFlexBoxPolyfillCompatVersion.compareTo("1.16") >= 0) {
	