/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare("sap.ui.ux3.OverlayDialog");jQuery.sap.require("sap.ui.ux3.library");jQuery.sap.require("sap.ui.ux3.Overlay");sap.ui.ux3.Overlay.extend("sap.ui.ux3.OverlayDialog",{metadata:{library:"sap.ui.ux3",properties:{"width":{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'auto'},"height":{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'auto'}},aggregations:{"content":{type:"sap.ui.core.Control",multiple:true,singularName:"content"}}}});jQuery.sap.require("sap.ui.core.IntervalTrigger");
sap.ui.ux3.OverlayDialog.prototype.init=function(){sap.ui.ux3.Overlay.prototype.init.apply(this);this.setProperty("openButtonVisible",false);sap.ui.ux3.OverlayDialog.Trigger=new sap.ui.core.IntervalTrigger(300)};
sap.ui.ux3.OverlayDialog.prototype._setFocusLast=function(){var f=this.$("content").lastFocusableDomRef();if(!f&&this.getCloseButtonVisible()){f=this.getDomRef("close")}jQuery.sap.focus(f)};
sap.ui.ux3.OverlayDialog.prototype._setFocusFirst=function(){if(this.getCloseButtonVisible()){jQuery.sap.focus(this.getDomRef("close"))}else{jQuery.sap.focus(this.$("content").firstFocusableDomRef())}};
sap.ui.ux3.OverlayDialog.prototype.setOpenButtonVisible=function(v){jQuery.sap.log.warning("OverlayDialog does not support an openButton.");return undefined};
sap.ui.ux3.OverlayDialog.prototype.setWidth=function(w){if(w=="auto"||w=="inherit"){w="auto"}return this.setProperty("width",w)};
sap.ui.ux3.OverlayDialog.prototype.setHeight=function(h){if(h=="auto"||h=="inherit"){h="auto"}return this.setProperty("height",h)};
sap.ui.ux3.OverlayDialog.prototype.onBeforeRendering=function(){sap.ui.ux3.Overlay.prototype.onBeforeRendering.apply(this,arguments);this._cleanup()};
sap.ui.ux3.OverlayDialog.prototype.onAfterRendering=function(){sap.ui.ux3.Overlay.prototype.onAfterRendering.apply(this,arguments);sap.ui.ux3.OverlayDialog.Trigger.addListener(this._checkChange,this)};
sap.ui.ux3.OverlayDialog.prototype._cleanup=function(){sap.ui.ux3.OverlayDialog.Trigger.removeListener(this._checkChange,this);this.contentWidth=null;this.contentHeight=null;this.overlayWidth=null;this.overlayHeight=null};
sap.ui.ux3.OverlayDialog.prototype.exit=function(){this._cleanup();sap.ui.ux3.Overlay.prototype.exit.apply(this,arguments)};
sap.ui.ux3.OverlayDialog.prototype._checkChange=function(){if(!this.getDomRef()){return}var $=this.$("content"),a=this.$(),A=this.getWidth()==="auto",b=this.getHeight()==="auto";var c=A?a.width()/2:$.width(),d=b?a.height()/2:$.height(),o=a.width(),e=a.height();if(c!=this.contentWidth||d!=this.contentHeight||o!=this.overlayWidth||e!=this.overlayHeight){$.css("left","0").css("right","auto").css("top","0").css("bottom","auto").css("width",this.getWidth()).css("height",this.getHeight());this.contentWidth=A?a.width()/2:$.width();this.contentHeight=b?a.height()/2:$.height();this.overlayWidth=o;this.overlayHeight=e;var f=this.$("close");if(this.contentWidth<this.overlayWidth){$.css("left","50%");$.css("right","auto");$.css("margin-left",(-1)*this.contentWidth/2+"px");$.css("width",b?this.contentWidth:this.getWidth());f.css("right","50%");f.css("margin-right",(-1)*this.contentWidth/2-10+"px")}else{$.css("left","0");$.css("right","10px");$.css("margin-left","0");$.css("width","auto");f.css("right","0");f.css("margin-right","0")}if(this.contentHeight<this.overlayHeight-30){$.css("top","50%");$.css("bottom","auto");$.css("margin-top",(-1)*this.contentHeight/2+"px");$.css("height",b?this.contentHeight:this.getHeight());f.css("top","50%");f.css("margin-top",(-1)*this.contentHeight/2-10+"px")}else{$.css("top","10px");$.css("bottom","30px");$.css("margin-top","0");$.css("height","auto");f.css("top","0");f.css("margin-top","0")}}};
