/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.m.CustomTile.
jQuery.sap.declare("sap.m.CustomTile");
jQuery.sap.require("sap.m.library");
jQuery.sap.require("sap.m.Tile");


/**
 * Constructor for a new CustomTile.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul></ul>
 * </li>
 * <li>Aggregations
 * <ul>
 * <li>{@link #getContent content} <strong>(default aggregation)</strong> : sap.ui.core.Control</li></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 
 *
 * 
 * In addition, all settings applicable to the base type {@link sap.m.Tile#constructor sap.m.Tile}
 * can be used as well.
 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * Use the Custom Tile to show a application specific content in the tile.
 * The tile width is 8.5em and height is 10em
 * @extends sap.m.Tile
 *
 * @author  
 * @version 1.20.6
 *
 * @constructor   
 * @public
 * @since 1.12
 * @name sap.m.CustomTile
 */
sap.m.Tile.extend("sap.m.CustomTile", { metadata : {

	// ---- object ----

	// ---- control specific ----
	library : "sap.m",
	defaultAggregation : "content",
	aggregations : {
    	"content" : {type : "sap.ui.core.Control", multiple : false}
	}
}});


/**
 * Creates a new subclass of class sap.m.CustomTile with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.m.CustomTile.extend
 * @function
 */


/**
 * Getter for aggregation <code>content</code>.<br/>
 * Defines the Content of the CustomTile
 * 
 * <strong>Note</strong>: this is the default aggregation for CustomTile.
 * @return {sap.ui.core.Control}
 * @public
 * @name sap.m.CustomTile#getContent
 * @function
 */


/**
 * Setter for the aggregated <code>content</code>.
 * @param {sap.ui.core.Control} oContent
 * @return {sap.m.CustomTile} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.CustomTile#setContent
 * @function
 */
	

/**
 * Destroys the content in the aggregation 
 * named <code>content</code>.
 * @return {sap.m.CustomTile} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.CustomTile#destroyContent
 * @function
 */


// Start of sap\m\CustomTile.js

