/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare("sap.m.ObjectListItem");jQuery.sap.require("sap.m.library");jQuery.sap.require("sap.m.ListItemBase");sap.m.ListItemBase.extend("sap.m.ObjectListItem",{metadata:{library:"sap.m",properties:{"title":{type:"string",group:"Misc",defaultValue:null},"number":{type:"string",group:"Misc",defaultValue:null},"numberUnit":{type:"string",group:"Misc",defaultValue:null},"intro":{type:"string",group:"Misc",defaultValue:null},"icon":{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},"activeIcon":{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},"iconDensityAware":{type:"boolean",group:"Misc",defaultValue:true},"markFavorite":{type:"boolean",group:"Misc",defaultValue:null},"markFlagged":{type:"boolean",group:"Misc",defaultValue:null},"showMarkers":{type:"boolean",group:"Misc",defaultValue:null},"numberState":{type:"sap.ui.core.ValueState",group:"Misc",defaultValue:sap.ui.core.ValueState.None}},defaultAggregation:"attributes",aggregations:{"attributes":{type:"sap.m.ObjectAttribute",multiple:true,singularName:"attribute"},"firstStatus":{type:"sap.m.ObjectStatus",multiple:false},"secondStatus":{type:"sap.m.ObjectStatus",multiple:false}}}});jQuery.sap.require("sap.ui.core.IconPool");
sap.m.ObjectListItem.prototype.exit=function(e){if(this._oImageControl){this._oImageControl.destroy()}if(this._oPlaceholderIcon){this._oPlaceholderIcon.destroy();this._oPlaceholderIcon=undefined}if(this._oFavIcon){this._oFavIcon.destroy();this._oFavIcon=undefined}if(this._oFlagIcon){this._oFlagIcon.destroy();this._oFlagIcon=undefined}if(this._oTitleText){this._oTitleText.destroy();this._oTitleText=undefined}sap.m.ListItemBase.prototype.exit.apply(this)};
sap.m.ObjectListItem.prototype._hasAttributes=function(){var a=this.getAttributes();if(a.length>0){for(var i=0;i<a.length;i++){if(!a[i]._isEmpty()){return true}}}return false};
sap.m.ObjectListItem.prototype._hasStatus=function(){return((this.getFirstStatus()&&!this.getFirstStatus()._isEmpty())||(this.getSecondStatus()&&!this.getSecondStatus()._isEmpty()))};
sap.m.ObjectListItem.prototype._hasBottomContent=function(){return(this._hasAttributes()||this._hasStatus()||this.getShowMarkers())};
sap.m.ObjectListItem.prototype._getVisibleAttributes=function(){var a=this.getAttributes();var v=[];for(var i=0;i<a.length;i++){if(a[i].getVisible()){v.push(a[i])}};return v};
sap.m.ObjectListItem.prototype._getImageControl=function(){var i=this.getId()+'-img';var s="2.5rem";var p={src:this.getIcon(),height:s,width:s,size:s,densityAware:this.getIconDensityAware()};var c=['sapMObjLIcon'];this._oImageControl=sap.m.ImageHelper.getImageControl(i,this._oImageControl,this,p,c);return this._oImageControl};
sap.m.ObjectListItem.prototype._activeHandlingInheritor=function(){var a=this.getActiveIcon();if(!!this._oImageControl&&!!a){this._oImageControl.setSrc(a)}};
sap.m.ObjectListItem.prototype._inactiveHandlingInheritor=function(){var s=this.getIcon();if(!!this._oImageControl){this._oImageControl.setSrc(s)}};
sap.m.ObjectListItem.prototype._getPlaceholderIcon=function(){if(!this._oPlaceholderIcon){var p=sap.ui.core.IconPool.getIconURI("fridge");this._oPlaceholderIcon=sap.ui.core.IconPool.createControlByURI({id:this.getId()+"-placeholder",src:p});this._oPlaceholderIcon.addStyleClass("sapMObjStatusMarkerInvisible")}return this._oPlaceholderIcon};
sap.m.ObjectListItem.prototype._getFlagIcon=function(){if(!this._oFlagIcon){var f=sap.ui.core.IconPool.getIconURI("flag");this._oFlagIcon=sap.ui.core.IconPool.createControlByURI({id:this.getId()+"-flag",src:f})}return this._oFlagIcon};
sap.m.ObjectListItem.prototype._getFavoriteIcon=function(){if(!this._oFavIcon){var f=sap.ui.core.IconPool.getIconURI("favorite");this._oFavIcon=sap.ui.core.IconPool.createControlByURI({id:this.getId()+"-favorite",src:f})}return this._oFavIcon};
sap.m.ObjectListItem.prototype._getTitleText=function(){if(!this._oTitleText){this._oTitleText=new sap.m.Text(this.getId()+"-titleText",{maxLines:2})}return this._oTitleText};
