/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare("sap.m.PullToRefresh");jQuery.sap.require("sap.m.library");jQuery.sap.require("sap.ui.core.Control");sap.ui.core.Control.extend("sap.m.PullToRefresh",{metadata:{publicMethods:["hide"],library:"sap.m",properties:{"visible":{type:"boolean",group:"Appearance",defaultValue:true},"description":{type:"string",group:"Misc",defaultValue:null},"showIcon":{type:"boolean",group:"Appearance",defaultValue:false},"customIcon":{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},"iconDensityAware":{type:"boolean",group:"Appearance",defaultValue:true}},events:{"refresh":{}}}});sap.m.PullToRefresh.M_EVENTS={'refresh':'refresh'};jQuery.sap.require("sap.ui.core.theming.Parameters");
sap.m.PullToRefresh.prototype.init=function(){this._bTouchMode=sap.ui.Device.support.touch||jQuery.sap.simulateMobileOnDesktop;this._bPltfDpndnt=sap.ui.core.theming.Parameters.get("sapMPlatformDependent")=="true";this._iState=0;this.oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m")};
sap.m.PullToRefresh.prototype._loadBI=function(){if(this.getVisible()&&!this._oBusyIndicator){jQuery.sap.require("sap.m.BusyIndicator");this._oBusyIndicator=new sap.m.BusyIndicator({size:this._bTouchMode?"2em":"1.7em",design:this._bPltfDpndnt?"light":"auto"});this._oBusyIndicator.setParent(this)}};
sap.m.PullToRefresh.prototype.onBeforeRendering=function(){this._loadBI();if(this._bTouchMode){jQuery(window).off("resize.sapMP2R",this.calculateTopTrigger);var p=this.getParent();this._oScroller=p&&p.getScrollDelegate?p.getScrollDelegate():null;if(this._oScroller){this._oScroller.setBounce(true);this._oScroller.setPullDown(this.getVisible()?this:null)}}};
sap.m.PullToRefresh.prototype.calculateTopTrigger=function(){this._iTopTrigger=1;if(this._oDomRef&&this._oDomRef.parentNode&&this._oDomRef.parentNode.parentNode&&this._oDomRef.parentNode.parentNode.offsetHeight<this._oDomRef.offsetHeight*1.5){this._iTopTrigger=this.getDomRef("T").offsetTop}};
sap.m.PullToRefresh.prototype.onAfterRendering=function(){this._oDomRef=this.getDomRef();if(this._bTouchMode){if(this._oScroller){this._oScroller.refresh()}if(this.getVisible()&&this._oScroller&&this._oScroller._bIScroll){jQuery(window).on("resize.sapMP2R",jQuery.proxy(this.calculateTopTrigger,this));this.calculateTopTrigger()}}};
sap.m.PullToRefresh.prototype.exit=function(){if(this._bTouchMode&&this._oScroller&&this._oScroller._bIScroll){jQuery(window).off("resize.sapMP2R",this.calculateTopTrigger)}if(this._oScroller){this._oScroller.setPullDown(null);this._oScroller=null}if(this._oCustomImage){this._oCustomImage.destroy();this._oCustomImage=null}if(this._oBusyIndicator){this._oBusyIndicator.destroy();this._oBusyIndicator=null}};
sap.m.PullToRefresh.prototype.doScrollMove=function(){if(!this._oScroller){return}var d=this._oDomRef;var _=this._oScroller._scroller;if(_.y>-this._iTopTrigger&&this._iState<1){this.setState(1);_.minScrollY=0}else if(_.y<-this._iTopTrigger&&this._iState==1){this.setState(0);_.minScrollY=-d.offsetHeight}};
sap.m.PullToRefresh.prototype.doPull=function(p){if(this._bTouchMode&&this._iState<2){this.setState(p>=-1?1:0)}};
sap.m.PullToRefresh.prototype.doRefresh=function(){this.setState(0)};
sap.m.PullToRefresh.prototype.doScrollEnd=function(){if(this._iState==1){this.setState(2);this.fireRefresh()}};
sap.m.PullToRefresh.prototype.setState=function(s){if(this._iState==s)return;this._iState=s;if(!this._oDomRef)return;var $=this.$();var a=$.find(".sapMPullDownText");switch(s){case 0:$.toggleClass("sapMFlip",false).toggleClass("sapMLoading",false);a.html(this.oRb.getText(this._bTouchMode?"PULL2REFRESH_PULLDOWN":"PULL2REFRESH_REFRESH"));$.find(".sapMPullDownInfo").html(this.getDescription());break;case 1:$.toggleClass("sapMFlip",true);a.html(this.oRb.getText("PULL2REFRESH_RELEASE"));break;case 2:$.toggleClass("sapMFlip",false).toggleClass("sapMLoading",true);this._oBusyIndicator.setVisible(true);a.html(this.oRb.getText("PULL2REFRESH_LOADING"));$.find(".sapMPullDownInfo").html(this._bTouchMode?this.oRb.getText("PULL2REFRESH_LOADING_LONG"):"");break}};
sap.m.PullToRefresh.prototype.setDescription=function(d){if(this._oDomRef){this.$().find(".sapMPullDownInfo").html(jQuery.sap.encodeHTML(d))}return this.setProperty("description",d,true)};
sap.m.PullToRefresh.prototype.getCustomIconImage=function(){var p={src:this.getCustomIcon(),densityAware:this.getIconDensityAware()};var c=['sapMPullDownCIImg'];this._oCustomImage=sap.m.ImageHelper.getImageControl(null,this._oCustomImage,this,p,c);return this._oCustomImage};
sap.m.PullToRefresh.prototype.onclick=function(){if(!this._bTouchMode){this.setState(2);this.fireRefresh()}};
sap.m.PullToRefresh.prototype.onkeydown=function(e){if(e.which==jQuery.sap.KeyCodes.F5){this.onclick();e.stopPropagation();e.preventDefault()}};
sap.m.PullToRefresh.prototype.hide=function(){this.setState(0);if(this._oScroller){this._oScroller.refresh()}};
sap.m.PullToRefresh.prototype.setVisible=function(v){if(this.getVisible()==v)return this;if(this._oDomRef&&this._oScroller&&this._oScroller._oControl){this._oScroller._oControl.invalidate()}return this.setProperty("visible",v)};
