/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare("sap.m.SplitContainer");jQuery.sap.require("sap.m.library");jQuery.sap.require("sap.ui.core.Control");sap.ui.core.Control.extend("sap.m.SplitContainer",{metadata:{publicMethods:["to","backToPage","toMaster","toDetail","backMaster","backDetail","showMaster","hideMaster","getCurrentPage","getCurrentMasterPage","getCurrentDetailPage","backToTopMaster","backToTopDetail","addPage","getMasterPage","getDetailPage","getPage","insertPreviousPage","getPreviousPage","isMasterShown"],library:"sap.m",properties:{"defaultTransitionNameDetail":{type:"string",group:"Appearance",defaultValue:"slide"},"defaultTransitionNameMaster":{type:"string",group:"Appearance",defaultValue:"slide"},"mode":{type:"sap.m.SplitAppMode",group:"Appearance",defaultValue:sap.m.SplitAppMode.ShowHideMode},"masterButtonText":{type:"string",group:"Appearance",defaultValue:null},"backgroundColor":{type:"string",group:"Appearance",defaultValue:null},"backgroundImage":{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},"backgroundRepeat":{type:"boolean",group:"Appearance",defaultValue:false},"backgroundOpacity":{type:"float",group:"Appearance",defaultValue:1}},aggregations:{"masterPages":{type:"sap.ui.core.Control",multiple:true,singularName:"masterPage"},"detailPages":{type:"sap.ui.core.Control",multiple:true,singularName:"detailPage"},"_navMaster":{type:"sap.m.NavContainer",multiple:false,visibility:"hidden"},"_navDetail":{type:"sap.m.NavContainer",multiple:false,visibility:"hidden"},"_navPopover":{type:"sap.m.Popover",multiple:false,visibility:"hidden"}},associations:{"initialDetail":{type:"sap.ui.core.Control",multiple:false},"initialMaster":{type:"sap.ui.core.Control",multiple:false}},events:{"masterNavigate":{},"afterMasterNavigate":{},"masterButton":{},"beforeMasterOpen":{},"afterMasterOpen":{},"beforeMasterClose":{},"afterMasterClose":{},"detailNavigate":{},"afterDetailNavigate":{}}}});sap.m.SplitContainer.M_EVENTS={'masterNavigate':'masterNavigate','afterMasterNavigate':'afterMasterNavigate','masterButton':'masterButton','beforeMasterOpen':'beforeMasterOpen','afterMasterOpen':'afterMasterOpen','beforeMasterClose':'beforeMasterClose','afterMasterClose':'afterMasterClose','detailNavigate':'detailNavigate','afterDetailNavigate':'afterDetailNavigate'};jQuery.sap.require("sap.ui.core.theming.Parameters");jQuery.sap.require("sap.ui.core.IconPool");
sap.m.SplitContainer.prototype.init=function(){var s=this;this._isMie9=false;this._isPlatformDependent=sap.ui.core.theming.Parameters.get("sapMPlatformDependent")=="true";if(sap.ui.Device.browser.internet_explorer&&sap.ui.Device.browser.version<10){this._isMie9=true}this.oCore=sap.ui.getCore();this._aMasterPages=[];this._aDetailPages=[];if(!sap.ui.Device.system.phone){this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._oMasterNav=new sap.m.NavContainer(this.getId()+"-Master",{width:"",navigate:function(e){s._handleNavigationEvent(e,false,true)},afterNavigate:function(e){s._handleNavigationEvent(e,true,true)}});this._oDetailNav=new sap.m.NavContainer(this.getId()+"-Detail",{width:"",navigate:function(e){s._handleNavigationEvent(e,false,false)},afterNavigate:function(e){s._handleNavigationEvent(e,true,false)}});this.setAggregation("_navMaster",this._oMasterNav,true);this.setAggregation("_navDetail",this._oDetailNav,true);this._createShowMasterButton();this._oPopOver=new sap.m.Popover(this.getId()+"-Popover",{placement:sap.m.PlacementType.Bottom,showHeader:false,contentWidth:"320px",contentHeight:"600px",beforeOpen:function(){s.fireBeforeMasterOpen()},beforeClose:function(){s.fireAfterMasterOpen()},afterOpen:function(){s.fireAfterMasterOpen();s._bMasterisOpen=true},afterClose:function(){s.fireAfterMasterClose();s._bMasterisOpen=false}}).addStyleClass("sapMSplitContainerPopover");this.setAggregation("_navPopover",this._oPopOver,true)}else{this._oMasterNav=this._oDetailNav=new sap.m.NavContainer();this.setAggregation("_navMaster",this._oMasterNav,true)}this._oldIsLandscape=sap.ui.Device.orientation.landscape;this._bMasterisOpen=false;var t=this;var p=function(r,n,P){return function(c,a,S){r.apply(t[n],arguments);if(a==="pages"&&jQuery.inArray(c,t[P])){t._removePageFromArray(t[P],c)}}};var m=this._oMasterNav._removeChild;this._oMasterNav._removeChild=p(m,"_oMasterNav","_aMasterPages");if(this._oDetailNav){var d=this._oDetailNav._removeChild;this._oDetailNav._removeChild=p(d,"_oDetailNav","_aDetailPages")}};
sap.m.SplitContainer.prototype.onBeforeRendering=function(){if(this._fnOrientationChange){sap.ui.Device.resize.detachHandler(this._fnOrientationChange)}if(this._bMasterisOpen&&(this._portraitHide()||this._hideMode())){this._oShowMasterBtn.removeStyleClass("sapMSplitContainerMasterBtnHidden");this._bMasterisOpen=false}};
sap.m.SplitContainer.prototype.exit=function(){if(this._fnOrientationChange){sap.ui.Device.resize.detachHandler(this._fnOrientationChange)}delete this._aMasterPages;delete this._aDetailPages;if(this._oShowMasterBtn){this._oShowMasterBtn.destroy();this._oShowMasterBtn=null}};
sap.m.SplitContainer.prototype.onAfterRendering=function(){if(!sap.ui.Device.system.phone){if(this._oPopOver&&this._oPopOver.isOpen()){this._oPopOver.close()}if(!this._fnOrientationChange){this._fnOrientationChange=jQuery.proxy(this._handleOrientationChange,this)}sap.ui.Device.resize.attachHandler(this._fnOrientationChange)}if(sap.ui.Device.browser.internet_explorer){this._oMasterNav.$().append('<iframe class="sapMSplitContainerMasterBlindLayer" src="about:blank"></iframe>')}};
sap.m.SplitContainer.prototype.ontouchstart=function(e){if(!sap.ui.Device.system.phone){if(e.originalEvent&&e.originalEvent._sapui_handledByControl){this._bIgnoreSwipe=true}else{this._bIgnoreSwipe=false}}};
sap.m.SplitContainer.prototype.onswiperight=function(e){if((sap.ui.Device.system.tablet||(sap.ui.Device.os.windows&&sap.ui.Device.os.version>=8))&&(this._portraitHide()||this._hideMode())&&!this._bIgnoreSwipe){if(!this._bDetailNavButton){this.showMaster()}}};
sap.m.SplitContainer.prototype.ontap=function(e){if(sap.ui.Device.system.phone){return}var i=true;if(jQuery(e.target).parents(".sapMSplitContainerDetail").length>0){i=false}if(((!this._oldIsLandscape&&this.getMode()=="ShowHideMode")||this.getMode()=="HideMode")&&!i&&this._bMasterisOpen&&!jQuery.sap.containsOrEquals(this._oShowMasterBtn.getDomRef(),e.target)){this.hideMaster()}};
sap.m.SplitContainer.prototype.onswipeleft=function(e){if((sap.ui.Device.system.tablet||(sap.ui.Device.os.windows&&sap.ui.Device.os.version>=8))&&(this._portraitHide()||this._hideMode())&&!this._bIgnoreSwipe){this.hideMaster()}};
sap.m.SplitContainer.prototype._onMasterButtonTap=function(e){if(sap.ui.Device.system.phone){return}if(!this._oldIsLandscape){if(this.getMode()=="PopoverMode"){if(!this._oPopOver.isOpen()){this._oPopOver.openBy(this._oShowMasterBtn,true)}else{this._oPopOver.close()}}else{this.showMaster()}}else{if(this.getMode()==="HideMode"){this.showMaster()}}};
sap.m.SplitContainer.prototype.to=function(p,t,d,T){if(this._oMasterNav.getPage(p)){this._oMasterNav.to(p,t,d,T)}else{this._oDetailNav.to(p,t,d,T)}};
sap.m.SplitContainer.prototype.backToPage=function(p,b,t){if(this._oMasterNav.getPage(p)){this._oMasterNav.backToPage(p,b,t)}else{this._oDetailNav.backToPage(p,b,t)}};
sap.m.SplitContainer.prototype.insertPreviousPage=function(p,t,d){if(this._oMasterNav.getPage(p)){this._oMasterNav.insertPreviousPage(p,t,d)}else{this._oDetailNav.insertPreviousPage(p,t,d)}return this};
sap.m.SplitContainer.prototype.toMaster=function(p,t,d,T){this._oMasterNav.to(p,t,d,T)};
sap.m.SplitContainer.prototype.backMaster=function(b,t){this._oMasterNav.back(b,t)};
sap.m.SplitContainer.prototype.backMasterToPage=function(p,b,t){this._oMasterNav.backToPage(p,b,t)};
sap.m.SplitContainer.prototype.toDetail=function(p,t,d,T){this._oDetailNav.to(p,t,d,T)};
sap.m.SplitContainer.prototype.backDetail=function(b,t){this._oDetailNav.back(b,t)};
sap.m.SplitContainer.prototype.backDetailToPage=function(p,b,t){this._oDetailNav.backToPage(p,b,t)};
sap.m.SplitContainer.prototype.backToTopMaster=function(b,t){this._oMasterNav.backToTop(b,t)};
sap.m.SplitContainer.prototype.backToTopDetail=function(b,t){this._oDetailNav.backToTop(b,t)};
sap.m.SplitContainer.prototype.addMasterPage=function(p){var r=this._getRealPage(p);if(this._hasPageInArray(this._aMasterPages,p)){return}if(this._oMasterNav===this._oDetailNav&&jQuery.inArray(p,this._oDetailNav.getPages())){this._removePageFromArray(this._aDetailPages,p)}this._oMasterNav.addPage(p);this._aMasterPages.push(p);return this};
sap.m.SplitContainer.prototype.addDetailPage=function(p){var s=this,r=this._getRealPage(p),c=this.oCore,P=r?r.getId():"";if(this._hasPageInArray(this._aDetailPages,p)){return}p.addDelegate({onBeforeFirstShow:function(){if(r){var n=c.byId(P+"-navButton"),i=c.byId(P+"-icon");if(!sap.ui.Device.system.phone){if(n){}if(i){}}}},onBeforeShow:function(){if(r){if(!sap.ui.Device.system.phone){if((s._portraitHide()||s._hideMode()||s._portraitPopover())&&(!s._bMasterisOpen||s._bMasterClosing)){s._setMasterButton(r,jQuery.proxy(s._setTitleVisibility,s))}else{s._setTitleVisibility(r)}}}}});if(r){r.addDelegate({onBeforeRendering:function(){if(!sap.ui.Device.system.phone){if(s._portraitHide()||s._hideMode()){if(!s._bMasterisOpen||s._bMasterClosing){s._setMasterButton(r)}}else if(s._portraitPopover()){s._setMasterButton(r)}else{s._removeMasterButton(r)}}}})}if(this._oMasterNav===this._oDetailNav&&jQuery.inArray(p,this._oMasterNav.getPages())){this._removePageFromArray(this._aMasterPages,p)}this._oDetailNav.addPage(p);this._aDetailPages.push(p);return this};
sap.m.SplitContainer.prototype.getMasterPages=function(){return this._aMasterPages};
sap.m.SplitContainer.prototype.getDetailPages=function(){return this._aDetailPages};
sap.m.SplitContainer.prototype.indexOfMasterPage=function(p){return this._indexOfMasterPage(p)};
sap.m.SplitContainer.prototype.indexOfDetailPage=function(p){return this._indexOfDetailPage(p)};
sap.m.SplitContainer.prototype.insertMasterPage=function(p,i,s){return this._insertPage(this._aMasterPages,"masterPages",p,i,s)};
sap.m.SplitContainer.prototype.removeMasterPage=function(p,s){return this._removePage(this._aMasterPages,"masterPages",p,s)};
sap.m.SplitContainer.prototype.removeAllMasterPages=function(s){this._aMasterPages=[];return this.removeAllAggregation("masterPages",s)};
sap.m.SplitContainer.prototype.insertDetailPage=function(p,i,s){return this._insertPage(this._aDetailPages,"detailPages",p,i,s)};
sap.m.SplitContainer.prototype.removeDetailPage=function(p,s){return this._removePage(this._aDetailPages,"detailPages",p,s)};
sap.m.SplitContainer.prototype.removeAllDetailPages=function(s){this._aDetailPages=[];return this.removeAllAggregation("detailPages",s)};
sap.m.SplitContainer.prototype.addPage=function(p,m){if(m){return this.addMasterPage(p)}else{return this.addDetailPage(p)}};
sap.m.SplitContainer.prototype.showMaster=function(){var _=this._oMasterNav.$(),t=this,a=this._getRealPage(this._oDetailNav.getCurrentPage());if(this._portraitPopover()){if(!this._oPopOver.isOpen()){function b(){this._oPopOver.detachAfterOpen(b,this);this._bMasterOpening=false;this._bMasterisOpen=true;this.fireAfterMasterOpen()};this._oPopOver.attachAfterOpen(b,this);this.fireBeforeMasterOpen();this._oPopOver.openBy(this._oShowMasterBtn,true);this._bMasterOpening=true}}else{if((this._portraitHide()||this._hideMode())&&(!this._bMasterisOpen||this._bMasterClosing)){if(this._isMie9){this._oMasterNav.$().css("width","320px");_.animate({left:"+=320"},{duration:300});this._bMasterisOpen=true;t._bMasterOpening=false;this._removeMasterButton(a,jQuery.proxy(this._setTitleVisibility,this))}_.bind((sap.ui.Device.os.ios||!this._isPlatformDependent)?"webkitTransitionEnd transitionend":"webkitAnimationEnd animationend",function(){jQuery(this).unbind("webkitTransitionEnd transitionend");jQuery(this).unbind("webkitAnimationEnd animationend");t._bMasterOpening=false;t._bMasterisOpen=true;t._removeMasterButton(a,jQuery.proxy(t._setTitleVisibility,t));t.fireAfterMasterOpen()});this.fireBeforeMasterOpen();_.toggleClass("sapMSplitContainerMasterVisible",true);_.toggleClass("sapMSplitContainerMasterHidden",false);this._bMasterOpening=true;if(sap.ui.Device.browser.webkit){var m=this._oMasterNav;window.setTimeout(function(){m.$().css("box-shadow","none");window.setTimeout(function(){m.$().css("box-shadow","")},50)},0)}}}return this};
sap.m.SplitContainer.prototype.hideMaster=function(){var _=this._oMasterNav.$(),t=this,a=t._getRealPage(t._oDetailNav.getCurrentPage());if(this._portraitPopover()){if(this._oPopOver.isOpen()){function b(){this._oPopOver.detachAfterClose(b,this);this._bMasterClosing=false;this._bMasterisOpen=false;this.fireAfterMasterClose()};this._oPopOver.attachAfterClose(b,this);this.fireBeforeMasterClose();this._oPopOver.close();this._bMasterClosing=true}}else{if((this._portraitHide()||this._hideMode())&&this._bMasterisOpen){if(this._isMie9){_.animate({left:"-=320"},{duration:300});this._bMasterisOpen=false;this._setMasterButton(a,jQuery.proxy(this._setTitleVisibility,this))}_.bind((sap.ui.Device.os.ios||!this._isPlatformDependent)?"webkitTransitionEnd transitionend":"webkitAnimationEnd animationend",function(){jQuery(this).unbind("webkitTransitionEnd transitionend");jQuery(this).unbind("webkitAnimationEnd animationend");t._bMasterClosing=false;t._bMasterisOpen=false;t._setMasterButton(a,jQuery.proxy(t._setTitleVisibility,t));t.fireAfterMasterClose()});this.fireBeforeMasterClose();_.toggleClass("sapMSplitContainerMasterVisible",false);_.toggleClass("sapMSplitContainerMasterHidden",true);this._bMasterClosing=true}}return this};
sap.m.SplitContainer.prototype.getCurrentMasterPage=function(){return this._oMasterNav.getCurrentPage()};
sap.m.SplitContainer.prototype.getCurrentDetailPage=function(){return this._oDetailNav.getCurrentPage()};
sap.m.SplitContainer.prototype.getCurrentPage=function(m){if(m){return this.getCurrentMasterPage()}else{return this.getCurrentDetailPage()}};
sap.m.SplitContainer.prototype.getPreviousPage=function(m){if(m){return this._oMasterNav.getPreviousPage()}else{return this._oDetailNav.getPreviousPage()}};
sap.m.SplitContainer.prototype.getMasterPage=function(p){return this._oMasterNav.getPage(p)};
sap.m.SplitContainer.prototype.getDetailPage=function(p){return this._oDetailNav.getPage(p)};
sap.m.SplitContainer.prototype.getPage=function(p,m){if(m){return this.getMasterPage(p)}else{return this.getDetailPage(p)}};
sap.m.SplitContainer.prototype.isMasterShown=function(){if(sap.ui.Device.system.phone){var c=this._oMasterNav.getCurrentPage();return this._indexOfMasterPage(c)!==-1}else{var m=this.getMode();switch(m){case sap.m.SplitAppMode.StretchCompressMode:return true;case sap.m.SplitAppMode.HideMode:return this._bMasterisOpen;case sap.m.SplitAppMode.PopoverMode:case sap.m.SplitAppMode.ShowHideMode:return sap.ui.Device.orientation.landscape||this._bMasterisOpen;default:return false}}};
sap.m.SplitContainer.prototype.setInitialMaster=function(p){this._oMasterNav.setInitialPage(p);this.setAssociation('initialMaster',p,true);return this};
sap.m.SplitContainer.prototype.setInitialDetail=function(p){if(!sap.ui.Device.system.phone){this._oDetailNav.setInitialPage(p)}this.setAssociation('initialDetail',p,true);return this};
sap.m.SplitContainer.prototype.setDefaultTransitionNameDetail=function(t){this.setProperty("defaultTransitionNameDetail",t,true);this._oDetailNav.setDefaultTransitionName(t);return this};
sap.m.SplitContainer.prototype.setDefaultTransitionNameMaster=function(t){this.setProperty("defaultTransitionNameMaster",t,true);this._oMasterNav.setDefaultTransitionName(t);return this};
sap.m.SplitContainer.prototype.setMasterButtonText=function(t){if((sap.ui.Device.os.ios||!this._isPlatformDependent)&&!sap.ui.Device.system.phone){if(!t){t=this._rb.getText("SplitContainer_NAVBUTTON_TEXT")}this._oShowMasterBtn.setText(t)}this.setProperty("masterButtonText",t,true);return this};
sap.m.SplitContainer.prototype.setMode=function(m){var o=this.getMode();if(o===m){return}this.setProperty("mode",m,true);this._bMasterisOpen=false;if(!sap.ui.Device.system.phone&&this.getDomRef()){if(o==="HideMode"&&this._oldIsLandscape){this._removeMasterButton(this._oDetailNav.getCurrentPage(),jQuery.proxy(this._setTitleVisibility,this));if(this._isMie9){this._oMasterNav.$().css({left:0,width:""})}}if(m!=="PopoverMode"&&this._oPopOver.getContent().length>0){this._updateMasterPosition("landscape")}else if(m=="PopoverMode"){if(!this._oldIsLandscape){if(this._oPopOver.getContent().length===0){this._updateMasterPosition("popover")}this._setMasterButton(this._oDetailNav.getCurrentPage(),jQuery.proxy(this._setTitleVisibility,this))}this.$().toggleClass("sapMSplitContainerShowHide",false);this.$().toggleClass("sapMSplitContainerStretchCompress",false);this.$().toggleClass("sapMSplitContainerHideMode",false);this.$().toggleClass("sapMSplitContainerPopover",true)}if(m=="StretchCompressMode"){this.$().toggleClass("sapMSplitContainerShowHide",false);this.$().toggleClass("sapMSplitContainerPopover",false);this.$().toggleClass("sapMSplitContainerHideMode",false);this.$().toggleClass("sapMSplitContainerStretchCompress",true);this._removeMasterButton(this._oDetailNav.getCurrentPage(),jQuery.proxy(this._setTitleVisibility,this))}if(m=="ShowHideMode"){this.$().toggleClass("sapMSplitContainerPopover",false);this.$().toggleClass("sapMSplitContainerStretchCompress",false);this.$().toggleClass("sapMSplitContainerHideMode",false);this.$().toggleClass("sapMSplitContainerShowHide",true);if(!sap.ui.Device.orientation.landscape){this._setMasterButton(this._oDetailNav.getCurrentPage(),jQuery.proxy(this._setTitleVisibility,this))}}if(m==="HideMode"){this.$().toggleClass("sapMSplitContainerPopover",false);this.$().toggleClass("sapMSplitContainerStretchCompress",false);this.$().toggleClass("sapMSplitContainerShowHide",false);this.$().toggleClass("sapMSplitContainerHideMode",true);this._setMasterButton(this._oDetailNav.getCurrentPage(),jQuery.proxy(this._setTitleVisibility,this));if(this._isMie9){this._oMasterNav.$().css({left:"",width:"auto"})}}}return this};
sap.m.SplitContainer.prototype.setBackgroundOpacity=function(o){if(o>1||o<0){jQuery.sap.log.warning("Invalid value "+o+" for SplitContainer.setBackgroundOpacity() ignored. Valid values are: floats between 0 and 1.");return this;}this.$("BG").css("opacity",o);return this.setProperty("backgroundOpacity",o,true)};
sap.m.SplitContainer.prototype._indexOfMasterPage=function(p){return jQuery.inArray(p,this._aMasterPages)};
sap.m.SplitContainer.prototype._indexOfDetailPage=function(p){return jQuery.inArray(p,this._aDetailPages)};
sap.m.SplitContainer.prototype._insertPage=function(p,a,P,I,s){this.insertAggregation(a,P,I,s);var i=I<0?0:(I>p.length?p.length:I);var o=jQuery.inArray(P,p);;p.splice(i,0,P);if(o!=-1){this._removePageFromArray(p,P)}return this};
sap.m.SplitContainer.prototype._removePage=function(p,a,P,s){var r=this.removeAggregation(a,P,s);if(r){this._removePageFromArray(p,r)}return r};
sap.m.SplitContainer.prototype._removePageFromArray=function(p,P){var i=jQuery.inArray(P,p);if(i!=-1){p.splice(i,1)}};
sap.m.SplitContainer.prototype._handleNavigationEvent=function(e,a,m){var E=(a?"After":"")+(m?"Master":"Detail")+"Navigate";E=E.charAt(0).toLowerCase()+E.slice(1);this.fireEvent(E,e.mParameters)};
sap.m.SplitContainer.prototype._handleOrientationChange=function(){var i=sap.ui.Device.orientation.landscape,_=this._oDetailNav.getCurrentPage(),m=this.getMode();if(this._oldIsLandscape!==i){this._oldIsLandscape=i;if(!sap.ui.Device.system.phone){this.$().toggleClass("sapMSplitContainerPortrait",!i);if(m==="HideMode"){return}if(m==="ShowHideMode"){if(i){this.fireBeforeMasterOpen()}else{this.fireBeforeMasterClose()}}if(this._isMie9){if(i){this._oMasterNav.$().css({left:0,width:""})}else{if(m==="ShowHideMode"||m==="PopoverMode"){this._oMasterNav.$().css({left:-320,width:"auto"})}}}if(m==="ShowHideMode"||m==="PopoverMode"){if(i){this._oMasterNav.$().toggleClass("sapMSplitContainerMasterVisible",false);this._oMasterNav.$().toggleClass("sapMSplitContainerMasterHidden",false)}}if(m==="ShowHideMode"){if(i){this._bMasterisOpen=true;this.fireAfterMasterOpen()}else{this._bMasterisOpen=false;this.fireAfterMasterClose()}}if(this.getMode()=="PopoverMode"){if(this._oPopOver.oPopup.isOpen()){this._oPopOver.attachAfterClose(this._handlePopClose,this);this._oPopOver.close()}else{this._handlePopClose()}}_=this._getRealPage(_);if(!this._oldIsLandscape&&m!="StretchCompressMode"){this._setMasterButton(_,jQuery.proxy(this._setTitleVisibility,this))}else{this._removeMasterButton(_,jQuery.proxy(this._setTitleVisibility,this))}}}};
sap.m.SplitContainer.prototype._setTitleVisibility=function(p){var r=p||this._getRealPage(this._oDetailNav.getCurrentPage()),c=this.oCore,P=r?r.getId():"";if(P){var t=c.byId(P+"-title");if(!sap.ui.Device.os.ios&&this._isPlatformDependent){if((this._portraitHide()||this._portraitPopover()||this._hideMode())&&(!this._bMasterisOpen||this._bMasterClosing)){t&&t.removeStyleClass("sapMSplitContainerHiddenChild")}else{t&&t.addStyleClass("sapMSplitContainerHiddenChild")}}}};
sap.m.SplitContainer.prototype._handlePopClose=function(e){this._oPopOver.detachAfterClose(this._handlePopClose,this);if(this._oldIsLandscape){this._updateMasterPosition("landscape")}else{this._updateMasterPosition("popover")}};
sap.m.SplitContainer.prototype._getRealPage=function(p){var r=p,c;while(r){if(r instanceof sap.m.Page){return r}if(r instanceof sap.ui.core.mvc.View){c=r.getContent();if(c.length===1){r=c[0];continue}}r=null}return r};
sap.m.SplitContainer.prototype._updateMasterPosition=function(p){var t=this;if(p=="popover"){this.removeAggregation("_navMaster",this._oMasterNav,true);this._oMasterNav.$().remove();this._oPopOver.addContent(this._oMasterNav);this._bMasterisOpen=false}if(p=="landscape"){var r=function(){t._oPopOver.removeAggregation("content",t._oMasterNav,false);t.setAggregation("_navMaster",t._oMasterNav,true);var $=t.$();if($[0]){var b=sap.ui.getCore().createRenderManager();b.renderControl(t._oMasterNav.addStyleClass("sapMSplitContainerMaster"));b.flush($[0],false,1);b.destroy()}};if(this._oPopOver.isOpen()){var a=function(){this._oPopOver.detachAfterClose(a,this);this._bMasterisOpen=false;r()};this._oPopOver.attachAfterClose(a,this);this._oPopOver.close()}else{r()}}};
sap.m.SplitContainer.prototype._portraitHide=function(){if(!this._oldIsLandscape&&!sap.ui.Device.system.phone&&this.getMode()==="ShowHideMode"){return true}else{return false}};
sap.m.SplitContainer.prototype._portraitPopover=function(){if(!this._oldIsLandscape&&!sap.ui.Device.system.phone&&this.getMode()==="PopoverMode"){return true}else{return false}};
sap.m.SplitContainer.prototype._hideMode=function(){return this.getMode()==="HideMode"&&!sap.ui.Device.system.phone};
sap.m.SplitContainer.prototype._createShowMasterButton=function(){if(this._oShowMasterBtn&&!this._oShowMasterBtn.bIsDestroyed){return}this._oShowMasterBtn=new sap.m.Button(this.getId()+"-MasterBtn",{text:(sap.ui.Device.os.ios&&this._isPlatformDependent)?this._rb.getText("SPLITCONTAINER_NAVBUTTON_TEXT"):"",icon:!this._isPlatformDependent?sap.ui.core.IconPool.getIconURI("menu2"):"",type:(sap.ui.Device.os.ios||!this._isPlatformDependent)?sap.m.ButtonType.Default:sap.m.ButtonType.Up,press:jQuery.proxy(this._onMasterButtonTap,this)}).addStyleClass("sapMSplitContainerMasterBtn")};
sap.m.SplitContainer.prototype._setMasterButton=function(p,c){if(!p){return}p=this._getRealPage(p);var h=p._getAnyHeader().getContentLeft();for(var i=0;i<h.length;i++){if(h[i]instanceof sap.m.Button&&(h[i].getType()==sap.m.ButtonType.Back||(h[i].getType()==sap.m.ButtonType.Up&&h[i]!==this._oShowMasterBtn))){this._bDetailNavButton=true;return}}this._bDetailNavButton=false;if(p){var P=p._getAnyHeader(),C=P.getContentLeft(),I=p.getIcon();var b=false;if(C){for(var i=0;i<C.length;i++){if(C[i]===this._oShowMasterBtn){b=true}}}if(!b){this._createShowMasterButton();this._oShowMasterBtn.removeStyleClass("sapMSplitContainerMasterBtnHidden");if(!sap.ui.Device.os.ios&&I&&this._isPlatformDependent){sap.ui.getCore().byId(p.getId()+"-icon").addStyleClass("sapMSplitContainerHiddenChild");this._oShowMasterBtn.setIcon(I)}if(P){if(!sap.ui.Device.os.ios&&this._isPlatformDependent&&C.length===0){p._titleIndex=1}P.insertContentLeft(this._oShowMasterBtn,0)}}else{if(this._isMie9){this._oShowMasterBtn.$().fadeIn()}this._oShowMasterBtn.$().parent().toggleClass("sapMSplitContainerMasterBtnHide",false);this._oShowMasterBtn.removeStyleClass("sapMSplitContainerMasterBtnHidden");this._oShowMasterBtn.$().parent().toggleClass("sapMSplitContainerMasterBtnShow",true)}if(c){c(p)}this.fireMasterButton({show:true})}};
sap.m.SplitContainer.prototype._removeMasterButton=function(p,c){if(!p){return}var s=this,h;if(!this._oShowMasterBtn.$().is(":hidden")){p=this._getRealPage(p);h=p._getAnyHeader();if(p&&h){var C=h.getContentLeft();for(var i=0;i<C.length;i++){if(C[i]===this._oShowMasterBtn){if(this._isMie9){this._oShowMasterBtn.$().fadeOut();if(c){c(p)}}this._oShowMasterBtn.$().parent().toggleClass("sapMSplitContainerMasterBtnShow",false);this._oShowMasterBtn.$().parent().toggleClass("sapMSplitContainerMasterBtnHide",true);this._oShowMasterBtn.$().parent().bind("webkitAnimationEnd animationend",function(){jQuery(this).unbind("webkitAnimationEnd animationend");s._oShowMasterBtn.addStyleClass("sapMSplitContainerMasterBtnHidden");if(c){c(p)}});return}}}this.fireMasterButton({show:false})}else{if(c){c(p)}}};
sap.m.SplitContainer.prototype._callMethodInManagedObject=function(f,a){var b=Array.prototype.slice.call(arguments);if(a==="masterPages"){if(f==="indexOfAggregation"){return this._indexOfMasterPage.apply(this,b.slice(2))}else{return this._callNavContainerMethod(f,this._oMasterNav,b)}}else if(a==="detailPages"){if(f==="indexOfAggregation"){return this._indexOfDetailPage.apply(this,b.slice(2))}else{return this._callNavContainerMethod(f,this._oDetailNav,b)}}else{return sap.ui.base.ManagedObject.prototype[f].apply(this,b.slice(1))}};
sap.m.SplitContainer.prototype._callNavContainerMethod=function(f,n,a){a[1]="pages";a=a.slice(1);var r=sap.m.SplitContainer._mFunctionMapping[f];if(r){a.shift();f=r}return n[f].apply(n,a)};
sap.m.SplitContainer.prototype.validateAggregation=function(a,o,m){return this._callMethodInManagedObject("validateAggregation",a,o,m)};
sap.m.SplitContainer.prototype.setAggregation=function(a,o,s){this._callMethodInManagedObject("setAggregation",a,o,s);return this};
sap.m.SplitContainer.prototype.getAggregation=function(a,d){return this._callMethodInManagedObject("getAggregation",a,d)};
sap.m.SplitContainer.prototype.indexOfAggregation=function(a,o){return this._callMethodInManagedObject("indexOfAggregation",a,o)};
sap.m.SplitContainer.prototype.insertAggregation=function(a,o,i,s){this._callMethodInManagedObject("insertAggregation",a,o,i,s);return this};
sap.m.SplitContainer.prototype.addAggregation=function(a,o,s){this._callMethodInManagedObject("addAggregation",a,o,s);return this};
sap.m.SplitContainer.prototype.removeAggregation=function(a,o,s){return this._callMethodInManagedObject("removeAggregation",a,o,s)};
sap.m.SplitContainer.prototype.removeAllAggregation=function(a,s){return this._callMethodInManagedObject("removeAllAggregation",a,s)};
sap.m.SplitContainer.prototype.destroyAggregation=function(a,s){this._callMethodInManagedObject("destroyAggregation",a,s);return this};
sap.m.SplitContainer._mFunctionMapping={"getAggregation":"getPage","addAggregation":"addPage","insertAggregation":"insertPage","removeAggregation":"removePage","removeAllAggregation":"removeAllPages"};
sap.m.SplitContainer.prototype._hasPageInArray=function(a,p){var f=false;a.forEach(function(A){if(p===A){f=true}});return f}
