// This file has been generated by the SAPUI5 'AllInOne' Builder
jQuery.sap.declare('sap.m.library-all');
if ( !jQuery.sap.isDeclared('sap.m.ActionSheetRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare("sap.m.ActionSheetRenderer");

/**
 * @class ActionSheet renderer. 
 * @static
 */
sap.m.ActionSheetRenderer = {
};


/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 * 
 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.m.ActionSheetRenderer.render = function(oRm, oControl){ 
	var aActionButtons = oControl.getButtons(), i, bMixedButtons;
	
	for(i = 0 ; i < aActionButtons.length ; i++){
		if(aActionButtons[i].getIcon()){
			bMixedButtons = true;
			break;
		}
	}
	
	// write the HTML into the render manager
	oRm.write("<div");
	oRm.writeControlData(oControl);
	oRm.addClass("sapMActionSheet");
	if(bMixedButtons){
		oRm.addClass("sapMActionSheetMixedButtons");
	}
	oRm.writeClasses();
	
	var sTooltip = oControl.getTooltip_AsString();
	if (sTooltip) {
		oRm.writeAttributeEscaped("title", sTooltip);
	}
	
	oRm.write(">");
	
	for(i = 0 ; i < aActionButtons.length ; i++){
		oRm.renderControl(aActionButtons[i].addStyleClass("sapMActionSheetButton"));
	}
	 
	if((jQuery.device.is.iphone || (sap.m.Dialog._bOneDesign && sap.ui.Device.system.phone)) && oControl.getShowCancelButton()){
		oRm.renderControl(oControl._getCancelButton());
	}
	
	oRm.write("</div>");
};

}; // end of sap/m/ActionSheetRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.BarRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare("sap.m.BarRenderer");

/**
 * @class Bar renderer.
 * @static
 */
sap.m.BarRenderer = {};

/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 * 
 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.m.BarRenderer.render = function(oRenderManager, oControl) { 
	var i = 0;

	//_context is set by the page control
	switch (oControl._context) {
	case 'header':
		//render header element 
		oRenderManager.write("<header");
		break;
	case 'footer':
		//render footer element 
		oRenderManager.write("<footer");
		oRenderManager.addClass("sapMFooter-CTX");
		break;
	default: 
		//render div element as default 
		oRenderManager.write("<div");
		break;
	}
	oRenderManager.writeControlData(oControl);
	oRenderManager.addClass("sapMBar");

	if (oControl.getTranslucent() && (sap.ui.Device.support.touch  || jQuery.sap.simulateMobileOnDesktop)) {
		oRenderManager.addClass("sapMBarTranslucent");
	}

	oRenderManager.addClass("sapMBar-CTX");
	oRenderManager.writeClasses();
	
	var sTooltip = oControl.getTooltip_AsString();
	if (sTooltip) {
		oRenderManager.writeAttributeEscaped("title", sTooltip);
	}
	
	oRenderManager.write(">"); 

	//left content area
	oRenderManager.write("<div id='"); 
	oRenderManager.write(oControl.getId());
	oRenderManager.write("-BarLeft' class='sapMBarLeft' >");
	var aLContent = oControl.getContentLeft();
	for(i=0; i< aLContent.length; i++){
		oRenderManager.renderControl(aLContent[i]);
	}
	oRenderManager.write("</div>");

	//middle content area 
	oRenderManager.write("<div id='"); 
	oRenderManager.write(oControl.getId());
	oRenderManager.write("-BarMiddle' class='sapMBarMiddle' >");
	if (oControl.getEnableFlexBox()){
		oControl._oflexBox = oControl._oflexBox || new sap.m.HBox(oControl.getId() + "-BarPH", {alignItems: "Center"}).addStyleClass("sapMBarPH").setParent(oControl, null, true);
		aMContent = oControl.getContentMiddle();
		for(i=0; i<aMContent.length; i++){
			oControl._oflexBox.addItem(aMContent[i]);
		}
		oRenderManager.renderControl(oControl._oflexBox);
	} else {
		oRenderManager.write("<div id='" + oControl.getId() + "-BarPH' class='sapMBarPH' >"); //place holder
		var aMContent = oControl.getContentMiddle();
		for(i=0; i<aMContent.length; i++){
			oRenderManager.renderControl(aMContent[i]);
		}
		oRenderManager.write("</div>");
	}
	oRenderManager.write("</div>");


	//right content area
	oRenderManager.write("<div id='" + oControl.getId() + "-BarRight'");
	oRenderManager.addClass('sapMBarRight');
	if(sap.ui.getCore().getConfiguration().getRTL()){
		oRenderManager.addClass("sapMRTL");
	}
	oRenderManager.writeClasses();
	oRenderManager.write(">");
	var aRContent = oControl.getContentRight();
	for(i=0; i<aRContent.length; i++){
		oRenderManager.renderControl(aRContent[i]);
	}
	oRenderManager.write("</div>");
	
	switch (oControl._context) {
	case 'header':
		oRenderManager.write("</header>");
		break;
	case 'footer':
		oRenderManager.write("</footer>");
		break;
	default: 
		oRenderManager.write("</div>");
		break;
	}
	
};
}; // end of sap/m/BarRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.BusyDialogRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare("sap.m.BusyDialogRenderer");

/**
 * @class BusyDialog renderer. 
 * @static
 */
sap.m.BusyDialogRenderer = {
};

/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 * 
 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.m.BusyDialogRenderer.render = function(oRm, oControl){ 
	// write the HTML into the render manager
	oRm.write("<div");
	oRm.writeControlData(oControl);
	oRm.addClass("sapMBusyDialog sapMCommonDialog");
	if(jQuery.device.is.iphone){
		oRm.addClass("sapMDialogHidden");
	}
	if(!oControl._isPlatformDependent) {
		if(!oControl.getText() && !oControl.getTitle() && !oControl.getShowCancelButton()) {
			oRm.addClass("sapMBusyDialogSimple");
		}
	}
	oRm.writeClasses();
	var sTooltip = oControl.getTooltip_AsString();
	if (sTooltip) {
		oRm.writeAttributeEscaped("title", sTooltip);
	}
	oRm.write(">");
	if(oControl.getTitle()) {
		oRm.write("<header class=\"sapMDialogTitle\">");
		oRm.writeEscaped(oControl.getTitle());
		oRm.write("</header>");
	}
	if(sap.ui.Device.os.ios || !oControl._isPlatformDependent) {
		oRm.renderControl(oControl._oLabel);
		oRm.renderControl(oControl._busyIndicator);
	} else {
		oRm.renderControl(oControl._busyIndicator);
		oRm.renderControl(oControl._oLabel);
	}
	
	if(oControl.getShowCancelButton()){
		oRm.write("<footer class='sapMBusyDialogFooter sapMFooter-CTX'>");
		oRm.renderControl(oControl._oButton);
		oRm.write("</footer>");
	}
	oRm.write("</div>");
};

}; // end of sap/m/BusyDialogRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.BusyIndicatorRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare("sap.m.BusyIndicatorRenderer");

/**
 * @class BusyIndicator renderer. 
 * @static
 */
sap.m.BusyIndicatorRenderer = {
};


/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 * 
 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.m.BusyIndicatorRenderer.render = function(oRm, oControl){ 

	var sSize = oControl.getSize();
	var iDesignClass = "";
	
	if(oControl.getDesign() == "auto") {
		iDesignClass = "sapMBusyIndicator";
	} else {
		iDesignClass = oControl.getDesign() == "dark" ? "sapMBusyIndicatorDark" : "sapMBusyIndicatorLight";
	}
	
	oRm.write("<div");
	oRm.writeControlData(oControl);
	oRm.addClass(iDesignClass);
	oRm.writeClasses();
	var sTooltip = oControl.getTooltip_AsString();
	if (sTooltip) {
		oRm.writeAttributeEscaped("title", sTooltip);
	}
	if(!oControl.getVisible()) {
		oRm.addStyle("visibility", "hidden");
		oRm.writeStyles();
	}
	oRm.write(">");
	
	if(oControl.getCustomIcon()){
		oRm.renderControl(oControl._iconImage);
	}else if (oControl._bUseSvg){
		this._renderSvg(oRm, oControl, sSize);
	}else if (oControl._bUseCanvas){
		this._renderCanvas(oRm, oControl, sSize);
	}else{
		this._renderNative(oRm, oControl, sSize);
	}
	
	if (oControl.getText()) {
		oRm.renderControl(oControl._oLabel);
	}
	
	oRm.write("</div>");
};

// SVG based loading indicator for blue crystal 
sap.m.BusyIndicatorRenderer._renderSvg = function(oRm, oControl, sSize){
	oRm.write('<svg');
	oRm.writeAttribute('id', oControl.getId() +  '-svg');
	oRm.writeAttribute('viewBox','0 0 100 100'); 
	oRm.writeAttribute('class','sapMBusySvg'); 
	if(sSize){
		oRm.addStyle('width', sSize);
		oRm.addStyle('height', sSize);
		oRm.writeStyles();
	}
	oRm.write('><g transform = translate(50,50)>');
	oRm.write('<path d="M0,-36A36,36 0 1,0 36,0" stroke-width="20%" fill="none" class="sapMSpinSvg">');
	oRm.write('<animateTransform attributeName="transform" attributeType="XML" type="rotate" ');
	oRm.write('from="0" to="360" dur="1.1s" repeatCount="indefinite" />');
	oRm.write('</path></g></svg>');
};

// Canvas based loading indicator for blue crystal 
sap.m.BusyIndicatorRenderer._renderCanvas = function(oRm, oControl, sSize){
	oRm.write('<canvas');
	oRm.writeAttribute("id", oControl.getId() +  "-canvas");
	oRm.writeAttribute("class","sapMSpinCanvas"); 
	oRm.writeAttribute("width","32"); // initially 2em * 16px
	oRm.writeAttribute("height","32");
	if(sSize){
		oRm.addStyle('width', sSize);
		oRm.addStyle('height', sSize);
		oRm.writeStyles();
	}
	oRm.write('></canvas>');
};

// "Native" ios and android style for mvi
sap.m.BusyIndicatorRenderer._renderNative = function(oRm, oControl, sSize){

	var iSpinBar = (oControl._bIosStyle) ? 13 :4;
	
	oRm.write("<div");
	oRm.writeAttribute("class","sapMSpinner"); 
	if(sSize){
		oRm.addStyle('width', sSize);
		oRm.addStyle('height', sSize);
		oRm.writeStyles();
	}
	oRm.write(">");

	for (var i=1; i<iSpinBar; i++) {
		var sBarClass = 'sapMSpinBar' + i;
		if(!oControl._bIosStyle) {
			if(i === 3) {
				var sBarClass1 = 'sapMSpinBar' + 4;
				oRm.write('<div class="'+ sBarClass + '"><div class="'+ sBarClass1 + '"></div></div>');
				break;
			}
		}
		oRm.write('<div class="'+ sBarClass + '"></div>');
	}
	oRm.write("</div>");
}; 

}; // end of sap/m/BusyIndicatorRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.ButtonRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare("sap.m.ButtonRenderer");

/**
 * @class Button renderer.
 * @static
 */
sap.m.ButtonRenderer = {};

/**
 * Renders the HTML for the given control, using the provided
 * {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager}
 *            oRenderManager the RenderManager that can be used for writing to
 *            the Render-Output-Buffer
 * @param {sap.ui.core.Control}
 *            oControl an object representation of the control that should be
 *            rendered
 */
sap.m.ButtonRenderer.render = function(rm, oButton) {

	// return immediately if control is invisible
	if (!oButton.getVisible()) {
		return;
	}

	// get control properties
	var sType = oButton.getType();
	var sWidth = oButton.getWidth();
	var bEnabled = oButton.getEnabled();
	var bExtraContentDiv = false;

	// start button tag
	rm.write("<button type=\"button\"");
	rm.writeControlData(oButton);

	// button style class
	if (sType !== sap.m.ButtonType.Unstyled) {
		rm.addClass("sapMBtn");
	}

	if (sap.ui.Device.system.desktop) {
		rm.addClass("sapMBtnDesktop");
	}

	// special for platform independent themes (like BlueCrystal)
	if (!oButton._isPlatformDependent) {

		// set padding depending on icons left or right or none
		if (!oButton.getIcon()) {
			if (sType != sap.m.ButtonType.Back && sType != sap.m.ButtonType.Up) {
				rm.addClass("sapMBtnPaddingLeft");
			}

			if (oButton.getText()) {
				rm.addClass("sapMBtnPaddingRight");
			}
		} else {
			if (oButton.getIcon() && oButton.getText() && oButton.getIconFirst()) {
				rm.addClass("sapMBtnPaddingRight");
			}

			if (oButton.getIcon() && oButton.getText() && !oButton.getIconFirst()) {
				rm.addClass("sapMBtnPaddingLeft");
			}
		}
	}

	if (oButton._isPlatformDependent) { //platform dependent themes (like MVI)

		// check if button is disabled
		if (!bEnabled) {
			if (sType == sap.m.ButtonType.Back || sType == sap.m.ButtonType.Up) {
				rm.addClass("sapMBtn" + jQuery.sap.escapeHTML(sType) + "Disabled");
			} else {
				if (sType != sap.m.ButtonType.Unstyled) {
					rm.addClass("sapMBtnDisabled");
				}
			}
		} else {
			if (sType != "" && sType != sap.m.ButtonType.Unstyled) {
				rm.addClass("sapMBtn" + jQuery.sap.escapeHTML(sType));
			}
		}
	} else if (sType !== sap.m.ButtonType.Unstyled) {

		// platform independent themes (like BlueCrystal)
		if (sType !== "") {
			rm.addClass("sapMBtn" + jQuery.sap.escapeHTML(sType));
		}

		// check if button is disabled
		if (!bEnabled) {
			rm.addClass("sapMBtnDisabled");
			rm.writeAttribute("tabindex", "-1");
		} else if( sap.ui.Device.system.desktop ) {
			rm.writeAttribute("tabindex", "0");

			// add classes for focus outline;
			rm.addClass("sapMFocusable");
			switch (sType) {
				case sap.m.ButtonType.Accept:
				case sap.m.ButtonType.Reject:
				case sap.m.ButtonType.Emphasized:
					rm.addClass("sapMBtnInverted");
			}
		}
	}

	// only for iOS buttons in bar control: if only an icon and no text is provided the button should be transparent and the active state is a background glow 
	if (oButton.getIcon() && !oButton.getText() && sType != sap.m.ButtonType.Back){
		if (!bEnabled) {
			rm.addClass("sapMBtnIconDisabled");
		} else {
			rm.addClass("sapMBtnIcon");
		}
	}

	// set user defined width
	if (sWidth != "" || sWidth.toLowerCase() == "auto") {
		bExtraContentDiv = false;
		rm.writeAttribute("style", "width:" + sWidth + ";");
	}

	// add all classes to button tag
	rm.writeClasses();

	var sTooltip = oButton.getTooltip_AsString();

	if (sTooltip) {
		rm.writeAttributeEscaped("title", sTooltip);
	}

	// close start button tag
	rm.write(">");

	// hook for inheriting controls to add their HTML
	if (this.renderButtonContentBefore) {
		this.renderButtonContentBefore(rm, oButton);
	}

	// check if additional content-DIV needs to rendered
	if (sType === sap.m.ButtonType.Accept) {
		bExtraContentDiv = true;
	}

	if (sType === sap.m.ButtonType.Reject) {
		bExtraContentDiv = true;
	}

	if (sType === sap.m.ButtonType.Up) {
		bExtraContentDiv = true;
	}

	// special for platform independent themes (like BlueCrystal)
	if (!oButton._isPlatformDependent && sType === sap.m.ButtonType.Back) {
		bExtraContentDiv = true;
	}

	if (oButton.getIcon()) {
		bExtraContentDiv = true;
	}

	// render button content tag if image control is loaded	
	if (bExtraContentDiv) {
		rm.write("<div");
		if (sType != sap.m.ButtonType.Unstyled) {
			rm.addClass("sapMBtnContent");

			if(oButton.getIcon()) {
				rm.addClass("sapMBtnContentWithIcon");
			}

			rm.writeClasses();
		}
		rm.write(">");
	}

	// special for platform independent themes (like BlueCrystal)
	if (!oButton._isPlatformDependent) {

		// set image for internal image control (back)
		var sBackURI = sap.ui.core.IconPool.getIconURI("nav-back");
		this.writeInternalIconPoolHtml(rm, oButton, sType, sap.m.ButtonType.Back, sBackURI);
		this.writeInternalIconPoolHtml(rm, oButton, sType, sap.m.ButtonType.Up, sBackURI);
	} else {

		// special for non iOS
		if (!sap.ui.Device.os.ios) {

			// set image for internal image control (accept)
			var sAcceptURI = sap.ui.core.IconPool.getIconURI("accept");
			this.writeInternalIconPoolHtml(rm, oButton, sType, sap.m.ButtonType.Accept, sAcceptURI);
	
			// set image for internal image control (reject)
			var sRejectURI = sap.ui.core.IconPool.getIconURI("decline");
			this.writeInternalIconPoolHtml(rm, oButton, sType, sap.m.ButtonType.Reject, sRejectURI);

			// set image for internal image control (up)
			var sUpURI = sap.ui.core.IconPool.getIconURI("navigation-left-arrow");
			this.writeInternalIconPoolHtml(rm, oButton, sType, sap.m.ButtonType.Up, sUpURI);
		}
	}

	// write icon left
	if (oButton.getIcon() && oButton.getIconFirst()) {
		this.writeImgHtml(rm, oButton);
	}

	// write button text
	this.writeTextHtml(rm, oButton, bExtraContentDiv, sType);

	// write icon right
	if (oButton.getIcon() && !oButton.getIconFirst()) {
		this.writeImgHtml(rm, oButton);
	}

	// close button content tag
	if (bExtraContentDiv) {
		rm.write("</div>");
	}

	// hook for inheriting controls to add their HTML
	if(this.renderButtonContentAfter){
		this.renderButtonContentAfter(rm, oButton);
	}

	// end button tag
	rm.write("</button>");
};

/**
 * HTML for button text
 */
sap.m.ButtonRenderer.writeTextHtml = function(rm, oButton, bExtraContentDiv, sType) {
	if (oButton.getText()) {
		rm.write("<span");

		if (!bExtraContentDiv && sType !== sap.m.ButtonType.Unstyled) {
			rm.addClass("sapMBtnContent");
			rm.writeClasses();
		}

		if (oButton.getIcon() && oButton.getText()) {
			rm.addClass("sapMBtnContentSpan");
			rm.writeClasses();
		}

		rm.write(">");
		rm.writeEscaped(oButton.getText());
		rm.write("</span>");
	}
};

/**
 * HTML for image
 */
sap.m.ButtonRenderer.writeImgHtml = function(rm, oButton) {
	rm.renderControl(oButton._getImage((oButton.getId() + "-img"), oButton.getIcon(), oButton.getActiveIcon(), oButton.getIconDensityAware()));	
};

/**
 * HTML for internal image (icon pool)
 */
sap.m.ButtonRenderer.writeInternalIconPoolHtml = function(rm, oButton, sType, sCheckType, sURI) {
	if (sType === sCheckType) {

		if (oButton._imageBtn) {
			oButton._imageBtn.setSrc(sURI);
		} else {
			rm.renderControl(oButton._getInternalIconBtn((oButton.getId() + "-iconBtn"), sURI));
		}
	}
};

}; // end of sap/m/ButtonRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.CarouselRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
 
jQuery.sap.declare("sap.m.CarouselRenderer");

/**
 * @class Carousel renderer. 
 * @static
 */
sap.m.CarouselRenderer = {
};

/**
 * Renders the Carousel's HTML, using the provided {@link sap.ui.core.RenderManager}.
 * 
 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.m.CarouselRenderer.render = function(rm, oCarousel){ 
	// Return immediately if control is invisible or if there are no pages to be rendered
	if (!oCarousel.getVisible()) {
		return;
	}
	

	//Outer carousel div
	rm.write("<div");
	rm.writeControlData(oCarousel);

	rm.addStyle("width", oCarousel.getWidth());
	rm.addStyle("height", oCarousel.getHeight());
	rm.writeStyles();
	
	rm.addClass("sapMCrsl");
	//'sapMCrslFluid' is originally from mobify-carousel
	rm.addClass("sapMCrslFluid");
	
	
	// add all classes (also custom classes) to carousel tag
	rm.writeClasses();
	
	var sTooltip = oCarousel.getTooltip_AsString();
	if (sTooltip) {
		rm.writeAttributeEscaped("title", sTooltip);
	}
	
	rm.write(">");
	
	var aPages = oCarousel.getPages();
	var iPageCount = aPages.length;
	var sPageIndicatorPlacement = oCarousel.getShowPageIndicator() ? 
		oCarousel.getPageIndicatorPlacement() : null; 
	
	
	//visual indicator
	if(sPageIndicatorPlacement === sap.m.PlacementType.Top) {
		this._renderPageIndicator(rm, iPageCount);
	}
	
	//inner carousel div
	rm.write("<div class='sapMCrslInner'>");
	//do housekeeping
	oCarousel._cleanUpScrollContainer();
	
	var fnRenderPage = function(oPage, iIndex) {
		//item div
		rm.write("<div class='sapMCrslItem");
		if(sPageIndicatorPlacement === sap.m.PlacementType.Bottom) {
			rm.write(" sapMCrslBottomOffset");
		}
		rm.write("'>");
			//Invisible element which is used to determine when desktop keyboard navigation
			//has reached the FIRST focusable element of a page and went beyond. In that case, the controller
			//will focus the last focusable element of the previous page
			rm.write("<span class='sapMCrslFirstFE' pageIndex=\"" + iIndex + "\" tabIndex=\"0\"/>");
			rm.renderControl(oCarousel._createScrollContainer(oPage, iIndex));
			//Invisible element which is used to determine when desktop keyboard navigation
			//has reached the LAST focusable element of a page and went beyond. In that case, the controller
			//will focus the first focusable element of the next page
			rm.write("<span class='sapMCrslLastFE' pageIndex=\"" + iIndex + "\" tabIndex=\"0\"/>");
		rm.write("</div>");	
	};
	
	//Render Pages
	aPages.forEach(fnRenderPage);
	
	
	rm.write("</div>");	
	//inner div ends
	
	
	if (sap.ui.Device.system.desktop && iPageCount > 1) {
		//heads up controls for desktop browsers
		rm.write("<div class='sapMCrslControls sapMCrslHud'>");
			rm.write("<a class='sapMCrslPrev' href='#' data-slide='prev' tabIndex=1><div class='sapMCrslHudInner'>");
			rm.renderControl(oCarousel._getNavigationArrow('left'));
			rm.write("</div></a>");
			
			rm.write("<a class='sapMCrslNext' href='#' data-slide='next' tabIndex=1><div class='sapMCrslHudInner'>");
			rm.renderControl(oCarousel._getNavigationArrow('right'));
			rm.write("</div></a>");
		rm.write("</div>");
	}
	
	
	//visual indicator
	if(sPageIndicatorPlacement === sap.m.PlacementType.Bottom) {
		this._renderPageIndicator(rm, iPageCount, true);
	}
	rm.write("</div>");	
	
	//page-wrap ends
};


/**
 * Renders the page indicator, using the provided {@link sap.ui.core.RenderManager}.
 * 
 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
 * @param aPages array of controls to be rendered
 * @private
 */
sap.m.CarouselRenderer._renderPageIndicator = function(rm, iPageCount, bBottom){
	//page indicator div
	rm.write("<div class='sapMCrslControls sapMCrslBulleted" + 
			(bBottom ? " sapMCrslBottomOffset" : "") +
			"'>");
	for ( var i = 1; i <= iPageCount; i++) {
		//item span
		rm.write("<span data-slide=" + i + ">" + i + "</span>");
	}
	rm.write("</div>");	
};




}; // end of sap/m/CarouselRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.CheckBoxRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare("sap.m.CheckBoxRenderer");
jQuery.sap.require('sap.ui.core.ValueStateSupport'); // unlisted dependency retained


/**
 * @class CheckBox renderer.
 * @static
 */
sap.m.CheckBoxRenderer = {
};


/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.core.Control} oCheckBox an object representation of the control that should be rendered
 */
sap.m.CheckBoxRenderer.render = function(oRm, oCheckBox){
	// Return immediately if control is invisible
	if (!oCheckBox.getVisible()) {
		return;
	}

	// get control properties
	var bEnabled = oCheckBox.getEnabled();
	var iTabIndex = bEnabled ? 0 : -1;

	// CheckBox wrapper
	oRm.write("<div");
	oRm.addClass("sapMCb");
	if(bEnabled) {
		oRm.addClass("sapMPointer");
	}
	oRm.writeControlData(oCheckBox);
	oRm.writeClasses();

	var sTooltip = sap.ui.core.ValueStateSupport.enrichTooltip(oCheckBox, oCheckBox.getTooltip_AsString());
	if (sTooltip) {
		oRm.writeAttributeEscaped("title", sTooltip);
	}

	oRm.write(">");		// DIV element

	// write the HTML into the render manager
	oRm.write("<div id='");
	oRm.write(oCheckBox.getId() + "-CbBg'");

	// CheckBox style class
	oRm.addClass("sapMCbBg");

	if (!bEnabled) {
		oRm.addClass("sapMCbBgDis");
	} else if(sap.ui.Device.system.desktop) {
		oRm.addClass("sapMCbHoverable");
	}

	if (!oCheckBox.getActiveHandling()){
		oRm.addClass("sapMCbActiveStateOff");
	}
	oRm.writeAttribute("tabindex", oCheckBox.hasOwnProperty("_iTabIndex") ? oCheckBox._iTabIndex : iTabIndex);
	oRm.addClass("sapMCbMark"); // TODO: sapMCbMark is redundant, remove it and simplify CSS

	if (oCheckBox.getSelected()) {
		oRm.addClass("sapMCbMarkChecked");
	}
	oRm.writeClasses();

	oRm.write(">");		// DIV element

	oRm.write("<input type='CheckBox' tabindex='-1' id='");
	oRm.write(oCheckBox.getId() + "-CB'");

	if (oCheckBox.getSelected()) {
		oRm.writeAttribute("checked", "checked");
	}

	if (oCheckBox.getName()) {
		oRm.writeAttributeEscaped('name', oCheckBox.getName());
	}

	if (!bEnabled) {
		oRm.write(" disabled='disabled'");
	}

	oRm.write(" /></div>");
	oRm.renderControl(oCheckBox._oLabel);
	oRm.write("</div>");
};

}; // end of sap/m/CheckBoxRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.DialogRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare("sap.m.DialogRenderer");


/**
 * @class Dialog renderer. 
 * @static
 */
sap.m.DialogRenderer = {};


/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 * 
 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.m.DialogRenderer.render = function(oRm, oControl) {
	var id = oControl.getId(),
		bShowHeader = oControl.getShowHeader(),
		sType = oControl.getType(),
		oHeader = oControl._getAnyHeader(),
		oSubHeader = oControl.getSubHeader(),
		bMessage = (sType === sap.m.DialogType.Message),
		oLeftButton = oControl.getBeginButton(),
		oRightButton = oControl.getEndButton(),
		bHorizontalScrolling = oControl.getHorizontalScrolling(),
		bVerticalScrolling = oControl.getVerticalScrolling();
	
	if(oHeader){
		oHeader._context = "header";
	}
	
	if(oSubHeader){
		oSubHeader._context = "header";
	}

	// write the HTML into the render manager
	oRm.write("<div");
	oRm.writeControlData(oControl);
	oRm.addClass("sapMDialog");
	oRm.addClass("sapMDialog-CTX");
	oRm.addClass("sapMPopup-CTX");
	oRm.addClass(sap.m.Dialog._mStateClasses[oControl.getState()]);
	if(oControl._forceDisableScrolling){
		oRm.addClass("sapMDialogWithScrollCont");
	}
	
	if(oSubHeader){
		oRm.addClass("sapMDialogWithSubHeader");
	}
	
	if(bMessage){
		oRm.addClass("sapMMessageDialog");
	}
	
	if(!bVerticalScrolling) {
		oRm.addClass("sapMDialogVerScrollDisabled");
	}
	if(!bHorizontalScrolling) {
		oRm.addClass("sapMDialogHorScrollDisabled");
	}
	
	if(!sap.m.Dialog._bOneDesign){
		if(sap.ui.Device.os.ios && !oHeader){
			oRm.addClass("sapMDialogNoHeader");
		}
		
		if(bMessage){
			oRm.addClass("sapMCommonDialog");
		}else{
			if(jQuery.device.is.iphone){
				oRm.addClass("sapMDialogHidden sapMDialogIPhone");
			}
		}
	}else{
		if(sap.ui.Device.system.phone){
			oRm.addClass("sapMDialogPhone");
		}
	}
	
	oRm.writeClasses();
	
	var sTooltip = oControl.getTooltip_AsString();
	if (sTooltip) {
		oRm.writeAttributeEscaped("title", sTooltip);
	}

	oRm.writeAttribute("tabindex", "-1");

	oRm.write(">");
	if(sap.ui.Device.system.desktop) {
		//Invisible element which is used to determine when desktop keyboard navigation
		//has reached the first focusable element of a dialog and went beyond. In that case, the controller
		//will focus the last focusable element
		oRm.write("<span id='" + oControl.getId() + "-firstfe' tabindex='0'/>");
	}

	if(!sap.m.Dialog._bOneDesign){
		if(sap.ui.Device.os.ios) {
			if(bMessage){
				if(bShowHeader && oControl.getTitle()) {
					oRm.write("<header class=\"sapMDialogTitle\">");
					oRm.writeEscaped(oControl.getTitle());
					oRm.write("</header>");
				}
			}else{
				if(oHeader){
					oRm.renderControl(oHeader);
				}
			}
		} else {
			if(bShowHeader && (oControl.getIcon() || oControl.getTitle())){
				oRm.write("<header class=\"sapMDialogTitle\">");
				oRm.write("<h1>");
				if(oControl._iconImage){
					oRm.renderControl(oControl._iconImage);
				}
				oRm.write("<span>");
				oRm.renderControl(oControl._headerTitle);
				oRm.write("</span>");
				oRm.write("</h1>");
				oRm.write("</header>");
			}
		}
	}else{
		if(oHeader){
			oRm.renderControl(oHeader);
		}
	}
	
	if(oSubHeader){
		oRm.renderControl(oSubHeader.addStyleClass("sapMDialogSubHeader"));
	} 

	oRm.write("<section id='" + id + "-cont' style='width:" + oControl.getContentWidth() + "'>");
	oRm.write("<div id='" + id + "-scroll' class='sapMDialogScroll'>");
	oRm.write("<div id='" + id + "-scrollCont' class='sapMDialogScrollCont'>");
	var aContent = oControl.getContent();
	for(var i = 0; i < aContent.length; i++) {
		oRm.renderControl(aContent[i]);
	}
	oRm.write("</div>");
	oRm.write("</div>");
	oRm.write("</section>");
	
	if((sap.m.Dialog._bOneDesign || !sap.ui.Device.os.ios || bMessage) && (oLeftButton || oRightButton)) {
		
		oRm.write("<footer class='sapMDialogActions sapMBar-CTX sapMFooter-CTX'>");

		// Render actions
		if(oLeftButton){
			oRm.write("<div class='sapMDialogAction'>");
			oRm.renderControl(oLeftButton.addStyleClass("sapMDialogBtn", true));
			oRm.write("</div>");
		}
		if(oRightButton){
			oRm.write("<div class='sapMDialogAction'>");
			oRm.renderControl(oRightButton.addStyleClass("sapMDialogBtn", true));
			oRm.write("</div>");
		}
		
		oRm.write("</footer>");
	}
	if(sap.ui.Device.system.desktop) {
		//Invisible element which is used to determine when desktop keyboard navigation
		//has reached the last focusable element of a dialog and went beyond. In that case, the controller
		//will focus the first focusable element
		oRm.write("<span id='" + oControl.getId() + "-lastfe' tabindex='0'/>");
	}
	oRm.write("</div>");
};
}; // end of sap/m/DialogRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.FacetFilterRenderer') ) {
/*
* @copyright
*/

jQuery.sap.declare("sap.m.FacetFilterRenderer");

/**
 * @class FacetFilter renderer. 
 * @static
 */
sap.m.FacetFilterRenderer = {
};


/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 * 
 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.m.FacetFilterRenderer.render = function(oRm, oControl){ 
	
	// Return immediately if control is invisible
	if (!oControl.getVisible()) {
		return;
	}

	switch (oControl.getType()) {

	case sap.m.FacetFilterType.Simple:
		sap.m.FacetFilterRenderer.renderSimpleFlow(oRm, oControl);
		break;

	case sap.m.FacetFilterType.Light:
		sap.m.FacetFilterRenderer.renderSummaryBar(oRm, oControl);
		break;
	}
};

/**
 * 
 * 
 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.m.FacetFilterRenderer.renderSimpleFlow = function(oRm, oControl) {
	
	oRm.write("<div");
	oRm.writeControlData(oControl);		
	oRm.addClass("sapMFF");
	
	if(oControl.getShowSummaryBar()) {
		
		oRm.write(">");
		sap.m.FacetFilterRenderer.renderSummaryBar(oRm, oControl);
	} else {
		
		if (oControl._lastScrolling) { 
			
			oRm.addClass("sapMFFScrolling");
		} else {
			
			oRm.addClass("sapMFFNoScrolling");
		}		
		
		if(oControl.getShowReset()) {		
			
			oRm.addClass("sapMFFResetSpacer");
		}
		oRm.writeClasses();
		oRm.write(">");		
		
		
		if (sap.ui.Device.system.desktop) {
			oRm.renderControl(oControl._getScrollingArrow("left"));
		}		
		
		// Render the div for the carousel
		oRm.write("<div");
		oRm.writeAttribute("id", oControl.getId() + "-head");
		oRm.writeControlData(oControl);
		oRm.addClass("sapMFFHead");
		oRm.writeClasses();
		oRm.write(">");	
		
		var aLists = oControl._getSequencedLists();
		for(var i=0; i < aLists.length; i++) {
			
			oRm.renderControl(oControl._getButtonForList(aLists[i]));
			if (oControl.getShowPersonalization()) {
				
				oRm.renderControl(oControl._getFacetRemoveIcon(aLists[i]));
			}			
		}
		
		if (oControl.getShowPersonalization()) {
			oRm.renderControl(oControl.getAggregation("addFacetButton"));
		}		
		oRm.write("</div>"); // Close carousel div
		
		if (sap.ui.Device.system.desktop) {
			oRm.renderControl(oControl._getScrollingArrow("right"));
		}	
		
		if(oControl.getShowReset()) {
			
			oRm.write("<div");
			oRm.addClass("sapMFFResetDiv");
			oRm.writeClasses();
			oRm.write(">");
			oRm.renderControl(oControl.getAggregation("resetButton"));
			oRm.write("</div>");
		}				
	}
	oRm.write("</div>");
};


/**
 * 
 * 
 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.m.FacetFilterRenderer.renderSummaryBar = function(oRm, oControl) {

	// We cannot just render the toolbar without the parent div.  Otherwise it is
	// not possible to switch type from light to simple.
	oRm.write("<div");
	oRm.writeControlData(oControl);		
	oRm.addClass("sapMFF");
	oRm.writeClasses();
	oRm.write(">");		
	var oSummaryBar = oControl.getAggregation("summaryBar");
	oRm.renderControl(oSummaryBar);
	oRm.write("</div>");
};

}; // end of sap/m/FacetFilterRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.FlexBoxCssPropertyMap') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare("sap.m.FlexBoxCssPropertyMap");

sap.m.FlexBoxCssPropertyMap = {
	'spec0907': {
		'display': {
			'flex': {
				'display': 'box'
			},
			'inline-flex': {
				'display': 'inline-box'
			}
		},
		'flex-direction': {
			'row': {
				'box-orient': 'horizontal',
				'box-direction': 'normal'
			},
			'row-reverse': {
				'box-orient': 'horizontal',
				'box-direction': 'reverse'
			},
			'column': {
				'box-orient': 'vertical',
				'box-direction': 'normal'
			},
			'column-reverse': {
				'box-orient': 'vertical',
				'box-direction': 'reverse'
			}
		},
		'flex-wrap': {
			'no-wrap': {
				'box-lines': 'single'
			},
			'wrap': {
				'box-lines': 'multiple'
			},
			'wrap-reverse': null
		},
		'flex-flow': null,
		'order': {
			'<number>': {
				'box-ordinal-group': '<integer>'
			}
		},
		'flex-grow': {
			'<number>': {
				'box-flex': '<number>'
			}
		},
		'flex-shrink': null,
		'flex-basis': null,
		'flex': {
			'[flex-grow] | [flex-shrink] | [flex-basis]': {
				'box-flex': '[flex-grow]'
			}
		},
		'justify-content': {
			'flex-start': {
				'box-pack': 'start'
			},
			'flex-end': {
				'box-pack': 'end'
			},
			'center': {
				'box-pack': 'center'
			},
			'space-between': {
				'box-pack': 'justify'
			},
			'space-around': null
		},
		'align-items': {
			'flex-start': {
				'box-align': 'start'
			},
			'flex-end':{
				'box-align': 'end'
			},
			'center': {
				'box-align': 'center'
			},
			'baseline': {
				'box-align': 'baseline'
			},
			'stretch': {
				'box-align': 'stretch'
			}
		},
		'align-self': null,
		'align-content': null
	},
	'specie10': {
		'display': {
			'flex': {
				'display': 'flexbox'
			},
			'inline-flex': {
				'display': 'inline-flexbox'
			}
		},
		'flex-direction': {
			'row': {
				'flex-direction': 'row'
			},
			'row-reverse': {
				'flex-direction': 'row-reverse'
			},
			'column': {
				'flex-direction': 'column'
			},
			'column-reverse': {
				'flex-direction': 'column-reverse'
			}
		},
		'flex-wrap': {
			'no-wrap': {
				'flex-wrap': 'none'
			},
			'wrap': {
				'flex-wrap': 'wrap'
			},
			'wrap-reverse': 'wrap-reverse'
		},
		'flex-flow': null,
		'order': {
			'<number>': {
				'flex-order': '<integer>'
			}
		},
		'flex-grow': {
			'<number>': {
				'flex-positive': '<number>',
				'flex-preferred-size': 'auto'
			}
		},
		'flex-shrink': {
			'<number>': {
				'flex-negative': '<number>' 
			}
		},
		'flex-basis': {
			'<number>': {
				'flex-preferred-size': '<number>'
			}
		},
		'flex': {
			'[flex-grow] | [flex-shrink] | [flex-basis]': {
				'flex': '[flex-grow] | [flex-shrink] | [flex-basis]'
			}
		},
		'justify-content': {
			'flex-start': {
				'flex-pack': 'start'
			},
			'flex-end': {
				'flex-pack': 'end'
			},
			'center': {
				'flex-pack': 'center'
			},
			'space-between': {
				'flex-pack': 'justify'
			},
			'space-around': null
		},
		'align-items': {
			'flex-start': {
				'flex-align': 'start'
			},
			'flex-end':{
				'flex-align': 'end'
			},
			'center': {
				'flex-align': 'center'
			},
			'baseline': {
				'flex-align': 'baseline'
			},
			'stretch': {
				'flex-align': 'stretch'
			}
		},
		'align-self': null,
		'align-content': null
	}
};
}; // end of sap/m/FlexBoxCssPropertyMap.js
if ( !jQuery.sap.isDeclared('sap.m.FlexBoxStylingHelper') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */


if(jQuery.support.useFlexBoxPolyfill) {
	jQuery.sap.require('sap.ui.thirdparty.flexie'); // unlisted dependency retained

}
jQuery.sap.declare("sap.m.FlexBoxStylingHelper");

/**
 * @class FlexBox styling helper
 * @static
 */
sap.m.FlexBoxStylingHelper = {};

/**
 * Goes through applicable styles and calls function to sets them on the given control.
 *
 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.m.FlexBoxStylingHelper.setFlexBoxStyles = function(oRm, oControl) {
	var sDisplay;

	// Prepare values by converting camel-case to dash and lower-casing
	var bInline = oControl.getDisplayInline();
	var sDirection = oControl.getDirection().replace(/\W+/g, "-").replace(/([a-z\d])([A-Z])/g, "$1-$2").toLowerCase();
	var bFitContainer = oControl.getFitContainer();
	var sJustifyContent = oControl.getJustifyContent().replace(/\W+/g, "-").replace(/([a-z\d])([A-Z])/g, "$1-$2").toLowerCase();
	var sAlignItems = oControl.getAlignItems().replace(/\W+/g, "-").replace(/([a-z\d])([A-Z])/g, "$1-$2").toLowerCase();

	if(bInline) {
		sDisplay = "inline-flex";
	} else {
		sDisplay = "flex";
	}

	// Set width and height for outermost FlexBox only if FitContainer is set
	if(bFitContainer && !(oControl.getParent() instanceof sap.m.FlexBox)) {
		if(oControl.getParent() instanceof sap.m.Page) {
			var $page = oControl.getParent().$();
			$page.find("sapMPageScroll").height("100%"); // Set height of scroll area to 100% because it's currently not automatically set
		}
		//jQuery.sap.log.info("FlexBox fitContainer set to true. Remember, if the FlexBox is inserted into a Page, the property 'enableScrolling' of the Page needs to be set to 'false' for the FlexBox to fit the entire viewport.");
		oRm.addStyle("width", "auto");
		oRm.addStyle("height", "100%");
	}

	// Add flex prefix to start and end values
	if(sJustifyContent === "start" || sJustifyContent === "end") {
		sJustifyContent = "flex-" + sJustifyContent;
	}

	if(sAlignItems === "start" || sAlignItems === "end") {
		sAlignItems = "flex-" + sAlignItems;
	}

	// Set values (if different from default)
	sap.m.FlexBoxStylingHelper.setStyle(oRm, oControl, "display", sDisplay);
	if(sDirection !== "row") {
		sap.m.FlexBoxStylingHelper.setStyle(oRm, oControl, "flex-direction", sDirection);
	}

	if(sJustifyContent !== "flex-start") {
		sap.m.FlexBoxStylingHelper.setStyle(oRm, oControl, "justify-content", sJustifyContent);
	}
	if(sAlignItems !== "stretch") {
		sap.m.FlexBoxStylingHelper.setStyle(oRm, oControl, "align-items", sAlignItems);
	}
//	if(jQuery.support.newFlexBoxLayout) {
//		var sWrap = oControl.getWrap().replace(/\W+/g, "-").replace(/([a-z\d])([A-Z])/g, "$1-$2").toLowerCase();
//		var sAlignContent = oControl.getAlignContent().replace(/\W+/g, "-").replace(/([a-z\d])([A-Z])/g, "$1-$2").toLowerCase();
//
//		if(sWrap !== "nowrap") {
//			sap.m.FlexBoxStylingHelper.setStyle(oRm, oControl, "flex-wrap", sWrap);
//		}
//		if(sAlignContent === "start" || sAlignContent === "end") {
//			sAlignContent = "flex-" + sAlignContent;
//		}
//		if(sAlignContent !== "stretch") {
//			sap.m.FlexBoxStylingHelper.setStyle(oRm, oControl, "align-content", sAlignContent);
//		}
//	}
};

/**
 * Goes through applicable item styles and sets them on the given control.
 *
 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.m.FlexItemData} oLayoutData an object representation of the layout data
 */
sap.m.FlexBoxStylingHelper.setFlexItemStyles = function(oRm, oLayoutData) {
	var order = "";
	var growFactor = "";
	var alignSelf = "";

	// Set values if different from default
	order = oLayoutData.getOrder();
	if(order) {
		sap.m.FlexBoxStylingHelper.setStyle(oRm, null, "order", order);
	}

	growFactor = oLayoutData.getGrowFactor();
	if(growFactor !== undefined) {
		sap.m.FlexBoxStylingHelper.setStyle(oRm, null, "flex-grow", growFactor);
	}

	alignSelf = oLayoutData.getAlignSelf().toLowerCase();

	// Add flex prefix to start and end values to create CSS value
	if(alignSelf === "start" || alignSelf === "end") {
		alignSelf = "flex-" + alignSelf;
	}

	if(alignSelf && alignSelf !== "auto") {
		sap.m.FlexBoxStylingHelper.setStyle(oRm, null, "align-self", alignSelf);
	}

//	if(jQuery.support.newFlexBoxLayout) {
//		var shrinkFactor = "";
// 		var baseSize = "";
//
//		shrinkFactor = oLayoutData.getShrinkFactor();
//		if(shrinkFactor !== 1) {
//			sap.m.FlexBoxStylingHelper.setStyle(oRm, null, "flex-shrink", shrinkFactor);
//		}
//
//		baseSize = oLayoutData.getBaseSize().toLowerCase();
//		if(baseSize !== undefined) {
//			sap.m.FlexBoxStylingHelper.setStyle(oRm, null, "flex-basis", baseSize);
//		}
//	}
};

/**
 * Sets style (including fall-back styles) to the given control, using the provided {@link sap.ui.core.RenderManager}.
 * This method does NOT apply a polyfill in browsers that don't support flex box natively.
 *
 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 * @param sProperty name of the property
 * @param sValue value of the property
 */
sap.m.FlexBoxStylingHelper.setStyle = function(oRm, oControl, sProperty, sValue) {
	if(typeof(sValue) === "string") {
		sValue = sValue.toLowerCase();
	}

	// Determine vendor prefix
	var sVendorPrefix = "";

	if(jQuery.support.flexBoxPrefixed) {
		if(sap.ui.Device.browser.webkit) {
			sVendorPrefix = "-webkit-";
		} else if(jQuery.browser.mozilla) {
			sVendorPrefix = "-moz-";
		} else if(sap.ui.Device.browser.internet_explorer) {
			sVendorPrefix = "-ms-";
		}
	}

	// Choose flex box styling method
	if(jQuery.support.newFlexBoxLayout) {
		// New spec
		sap.m.FlexBoxStylingHelper.setFinalSpecStyle(oRm, oControl, sProperty, sValue, sVendorPrefix);
	} else if(jQuery.support.flexBoxLayout || jQuery.support.ie10FlexBoxLayout) {
		// Old spec
		sap.m.FlexBoxStylingHelper.setOldSpecStyle(oRm, oControl, sProperty, sValue, sVendorPrefix);
	}
};

/**
 * Sets style for the FINAL flex box spec to the given control, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 * @param sProperty name of the property
 * @param sValue value of the property
 * @param sVendorPrefix vendor prefix
 */
sap.m.FlexBoxStylingHelper.setFinalSpecStyle = function(oRm, oControl, sProperty, sValue, sVendorPrefix) {
	if(jQuery.support.flexBoxPrefixed) {
		// With vendor prefix
		sap.m.FlexBoxStylingHelper.writeStyle(oRm, oControl, sProperty, sValue, sVendorPrefix);
	}

	// Pure standard
	sap.m.FlexBoxStylingHelper.writeStyle(oRm, oControl, sProperty, sValue);
};

/**
 * Sets style for the OLD or the IE10 flex box spec to the given control, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 * @param sProperty name of the property
 * @param sValue value of the property
 * @param sVendorPrefix vendor prefix
 */
sap.m.FlexBoxStylingHelper.setOldSpecStyle = function(oRm, oControl, sProperty, sValue, sVendorPrefix) {
	// Choose specification
	var sSpec = "";
	if(sVendorPrefix == "-ms-") {
		sSpec = "specie10"; // IE10 specification
	} else {
		sSpec = "spec0907";	// old specification
	}

	// Nothing to do if final standard is supported or property doesn't exist in this spec or is the same as standard
	// Else map to old property
	if(sap.m.FlexBoxCssPropertyMap[sSpec][sProperty] !== null && sap.m.FlexBoxCssPropertyMap[sSpec][sProperty] !== "<idem>") {
		// Prepare mapped properties and values
		var mLegacyMap = null;
		if(typeof(sap.m.FlexBoxCssPropertyMap[sSpec][sProperty]) === "object") {
			if(sap.m.FlexBoxCssPropertyMap[sSpec][sProperty]["<number>"]) {
				mLegacyMap = sap.m.FlexBoxCssPropertyMap[sSpec][sProperty]["<number>"];
				for(var key in mLegacyMap) {
					mLegacyMap[key] = sValue;
				}
			} else {
				mLegacyMap = sap.m.FlexBoxCssPropertyMap[sSpec][sProperty][sValue];
			}
		} else {
			mLegacyMap = sap.m.FlexBoxCssPropertyMap[sSpec][sProperty][sValue];
		}

		// Nothing to do if value doesn't exist or is the same as standard
		if(mLegacyMap !== null && mLegacyMap !== "<idem>") {
			if(typeof(mLegacyMap) === "object") {
				for(var sLegacyProperty in mLegacyMap) {
					// Write property/value to control
					sap.m.FlexBoxStylingHelper.writeStyle(oRm, oControl, sLegacyProperty, mLegacyMap[sLegacyProperty], sVendorPrefix);
				}
			}
		}
	}
};

/**
 * Writes the style to the given control, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 * @param sProperty name of the property
 * @param sValue value of the property
 * @param sVendorPrefix vendor prefix
 */
sap.m.FlexBoxStylingHelper.writeStyle = function(oRm, oControl, sProperty, sValue, sVendorPrefix) {
	var sPropertyPrefix = "";
	var sValuePrefix = "";
	sVendorPrefix = typeof sVendorPrefix !== "undefined" ? sVendorPrefix : "";	// default: empty string

	// Set prefix to value for display property
	// As display is a long-standing standard property the values are vendor-prefixed instead of the property name
	if(sProperty !== "display") {
		sPropertyPrefix = sVendorPrefix;
	} else {
		sValuePrefix = sVendorPrefix;
	}

	// Finally write property value to control using either renderer or element directly
	if(oRm) {
		oRm.addStyle(sPropertyPrefix + sProperty, sValuePrefix + sValue);
	} else {
		jQuery(oControl).css(sPropertyPrefix + sProperty, sValuePrefix + sValue);
	}
};

/**
 * Applies flex box polyfill styling to the given DOM element and its children (if polyfill is being used at all)
 *
 * @param sId DOM ID of the control that should be turned into a flex box
 * @param oSettings object holding the flex box settings
 */
sap.m.FlexBoxStylingHelper.applyFlexBoxPolyfill = function(sId, oSettings) {
	// Return if polyfill is not being used
	if(!jQuery.support.useFlexBoxPolyfill) {
		jQuery.sap.log.warning("FlexBox Polyfill is not being used");
		return;
	}
	var justifyContent = {
		Start: "start",
		Center: "center",
		End: "end",
		SpaceBetween : "justify"
	};
	var alignItems = {
		Start: "start",
		Center: "center",
		End: "end",
		Stretch : "stretch"
	};
	
	var orient = "";
	var direction = "";
	
	switch(oSettings.direction) {
		case "Column" :
			orient = "vertical";
			direction = "normal";
			break;
		case "RowReverse" : 
			orient = "horizontal";
			direction = "reverse";
			break;
		case "ColumnReverse" : 
			orient = "vertical";
			direction = "reverse";
			break;
		case "Row" :
		default:
			orient = "horizontal";
			direction = "normal";
	}

	var box = new window.Flexie.box({
		target : document.getElementById(sId),
		orient : orient,
		align : alignItems[oSettings.alignItems],
		direction : direction,
		pack : justifyContent[oSettings.justifyContent],
		flexMatrix : oSettings.flexMatrix,
		ordinalMatrix : oSettings.ordinalMatrix,
	    dynamic: true
	});
	
	return box;
};
}; // end of sap/m/FlexBoxStylingHelper.js
if ( !jQuery.sap.isDeclared('sap.m.GrowingEnablement') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.m.GrowingEnablement
jQuery.sap.declare("sap.m.GrowingEnablement");
jQuery.sap.require('sap.ui.base.Object'); // unlisted dependency retained


sap.ui.base.Object.extend("sap.m.GrowingEnablement", {

	/**
	 * Creates a GrowingEnablement delegate that can be attached to ListBase Controls requiring capabilities for growing
	 *
	 * @extends sap.ui.base.Object
	 * @name sap.m.GrowingEnablement
	 * @experimental Since 1.16. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 *
	 * @param {sap.m.ListBase} oControl the ListBase control of which this Growing is the delegate
	 *
	 * @constructor
	 * @protected
	 */
	constructor : function(oControl) {
		sap.ui.base.Object.apply(this);
		this._oControl = oControl;
		this._oControl.bUseExtendedChangeDetection = true;
		this._oControl.addDelegate(this);

		/* init growing list */
		var iRenderedItemsLength = this._oControl.getItems().length;
		this._iRenderedDataItems = iRenderedItemsLength;
		this._iItemCount = iRenderedItemsLength;
		this._bRebuilding = false;
		this._fnRebuildQ = null;
		this._bLoading = false;
		this._sGroupingPath = "";
		this._bDataRequested = false;
	},

	/**
	 * Destroys this GrowingEnablement delegate.
	 * This function must be called by the control which uses this delegate in the <code>exit</code> function.
	 */
	destroy : function() {
		if (this._oBusyIndicator) {
			this._oBusyIndicator.destroy();
			delete this._oBusyIndicator;
		}
		if (this._oTrigger) {
			this._oTrigger.destroy();
			delete this._oTrigger;
		}
		if (this._oLoading) {
			this._oLoading.destroy();
			delete this._oLoading;
		}
		if (this._oScrollDelegate) {
			this._oScrollDelegate.setGrowingList(null);
			this._oScrollDelegate = null;
		}

		jQuery(this._oControl.getId() + "-triggerList").remove();
		this._oControl.bUseExtendedChangeDetection = false;
		this._oControl.removeDelegate(this);
		this._sGroupingPath = "";
		this._bLoading = false;
		this._oControl = null;
	},

	/**
	 * Renders loading indicator or load more trigger
	 */
	render : function(rm) {
		var bHasScrollToLoadAndScrollbars = this._oControl.getGrowingScrollToLoad() && this._getHasScrollbars();

		rm.write("<ul id='" + this._oControl.getId() + "-triggerList'");

		if (bHasScrollToLoadAndScrollbars) {
			rm.addStyle("display", "none");
			rm.writeStyles();
		}

		// no header or footer no div
		rm.addClass("sapMListUl");
		rm.addClass("sapMGrowingList");
		if (this._oControl.setBackgroundDesign) {
			rm.addClass("sapMListBG" + this._oControl.getBackgroundDesign());
		}
		if (this._oControl.getInset()) {
			rm.addClass("sapMListInset");
		}
		rm.writeClasses();
		rm.write(">");

		var oActionItem;
		if (bHasScrollToLoadAndScrollbars) {
			this._showsLoading = true;
			oActionItem = this._getLoading(this._oControl.getId() + "-loading");
		} else {
			this._showsTrigger = true;
			oActionItem = this._getTrigger(this._oControl.getId() + "-trigger");
		}

		// this variable is needed to render loading indicator in list even in table mode
		oActionItem._renderInList = true;
		rm.renderControl(oActionItem);
		rm.write("</ul>");
	},

	/**
	 * Called after rendering phase of the given control
	 */
	onAfterRendering : function() {
		if (this._oControl.getGrowingScrollToLoad()) {
			var oScrollDelegate = sap.m.getScrollDelegate(this._oControl);
			if (oScrollDelegate) {
				this._oScrollDelegate = oScrollDelegate;
				oScrollDelegate.setGrowingList(this._oControl, jQuery.proxy(this._triggerLoadingByScroll, this));
			}
		} else if (this._oScrollDelegate) {
			this._oScrollDelegate.setGrowingList(null);

			this._oScrollDelegate = null;
		}

		this._updateTrigger();
	},

	setTriggerText : function(sText) {
		if (this._oTrigger) {
			this._oTrigger.$().find(".sapMSLITitle").text(sText);
		}
	},

	// call to reset paging
	reset : function() {
		this._iItemCount = 0;
		this._bLastAsyncCheck = false;
	},

	// get actual and total info
	getInfo : function() {
		return {
			total : this._oControl.getMaxItemsCount(),
			actual : this._iRenderedDataItems
		};
	},

	// call to request new page
	requestNewPage : function(oEvent) {
		// if max item count not reached
		if (this._oControl && !this._bLoading && this._iItemCount < this._oControl.getMaxItemsCount()) {
			this._showIndicator();
			this._iItemCount += this._oControl.getGrowingThreshold();
			this.updateItems("Growing");
		}
	},

	// called before new page loaded
	_onBeforePageLoaded : function(sChangeReason) {
		this._bLoading = true;
		this._oControl.onBeforePageLoaded(this.getInfo(), sChangeReason);
	},

	// called after new page loaded
	_onAfterPageLoaded : function(sChangeReason) {
		this._hideIndicator();
		this._updateTrigger();
		this._bLoading = false;
		this._oControl.onAfterPageLoaded(this.getInfo(), sChangeReason);
	},

	/**
	 *
	 * this._oRenderManager is optionally used if defined in order to improve performance. It indicates a state where multiple items can be subsequently rendered.
	 * If this._oRenderManager is defined, it is the responsibility of the caller to flush and destroy the RenderManager after the last call.
	 */
	_renderItemIntoContainer : function(oItem, bDoNotPreserve, vInsert, oDomRef) {
		oDomRef = oDomRef || this._oContainerDomRef;
		if (oDomRef) {
			var rm = this._oRenderManager || sap.ui.getCore().createRenderManager();
			rm.renderControl(oItem);
			if (!this._oRenderManager) {
				rm.flush(oDomRef, bDoNotPreserve, vInsert);
				rm.destroy();
			}
		}
	},

	_getBusyIndicator : function() {
		return this._oBusyIndicator || (this._oBusyIndicator = new sap.m.BusyIndicator({
			size : "2.0em"
		}));
	},

	/**
	 * returns loading indicator
	 */
	_getLoading : function(sId) {
		var that = this;
		return this._oLoading || (this._oLoading = new sap.m.CustomListItem({
			id : sId,
			content : new sap.ui.core.HTML({
				content :	"<div class='sapMSLIDiv sapMGrowingListLoading'>" +
								"<div class='sapMGrowingListBusyIndicator' id='" + sId + "-busyIndicator'></div>" +
							"</div>",
				afterRendering : function(e) {
					var oBusyIndicator = that._getBusyIndicator();
					var rm = sap.ui.getCore().createRenderManager();
					rm.render(oBusyIndicator, this.getDomRef().firstChild);
					rm.destroy();
				}
			})
		}).setParent(this._oControl, null, true));
	},

	/**
	 * returns load more trigger
	 */
	_getTrigger : function(sId) {
		var that = this;

		var sTriggerText = sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("LOAD_MORE_DATA");
		if (this._oControl.getGrowingTriggerText()) {
			sTriggerText = this._oControl.getGrowingTriggerText();
		}

		this._oControl.addNavSection(sId);

		return this._oTrigger || (this._oTrigger = new sap.m.CustomListItem({
			id : sId,
			content : new sap.ui.core.HTML({
				content :	"<div class='sapMGrowingListTrigger'>" +
								"<div class='sapMGrowingListBusyIndicator' id='" + sId + "-busyIndicator'></div>" +
								"<div class='sapMSLITitleDiv sapMGrowingListTitel'>" +
									"<h1 class='sapMSLITitle'>" + jQuery.sap.encodeHTML(sTriggerText) + "</h1>" +
								"</div>" +
								"<div class='sapMGrowingListDescription'>" +
									"<div class='sapMSLIDescription' id='" + sId + "-itemInfo'>" + that._getListItemInfo() + "</div>" +
								"</div>" +
							"</div>",
				afterRendering : function(e) {
					var oBusyIndicator = that._getBusyIndicator();
					var rm = sap.ui.getCore().createRenderManager();
					rm.render(oBusyIndicator, this.getDomRef().firstChild);
					rm.destroy();
				}
			}),
			type : sap.m.ListType.Active
		}).setParent(this._oControl, null, true).attachPress(this.requestNewPage, this).addEventDelegate({
			onsapenter : function(oEvent) {
				this.requestNewPage();
				oEvent.preventDefault();
			},
			onsapspace : function(oEvent) {
				this.requestNewPage(oEvent);
				oEvent.preventDefault();
			}
		}, this));
	},

	/**
	 * Returns the information about the list items.
	 * -> how many items are displayed
	 * -> maximum items to be displayed
	 */
	_getListItemInfo : function() {
		return ("[ " + this._iRenderedDataItems + " / " + this._oControl.getMaxItemsCount() + " ]");
	},

	/**
	 * Only call when grouped
	 */
	_getGroupForContext : function(oContext) {
		// TODO: we should document that group header depends on the first sorter
		var oNewGroup = this._oControl.getBinding("items").aSorters[0].fnGroup(oContext);
		if (typeof oNewGroup == "string") {
			oNewGroup = {
				key: oNewGroup
			};
		}
		return oNewGroup;
	},

	/**
	 * returns the first sorters grouping path when available
	 */
	_getGroupingPath : function(oBinding) {
		oBinding = oBinding || this._oControl.getBinding("items") || {};
		var aSorters = oBinding.aSorters || [];
		var oSorter = aSorters[0] || {};
		if (oSorter.fnGroup) {
			return oSorter.sPath;
		}
		return "";
	},

	/**
	 * If table has pop-in then we have two rows for one item
	 * So this method finds the correct DOM position to insert item
	 * This function should not be called within insertItem
	 */
	_getDomIndex : function(iIndex) {
		if (this._oControl.hasPopin && this._oControl.hasPopin()) {
			iIndex *= 2;
		}
		return iIndex;
	},

	/**
	 * Checks if the Scrollcontainer of the list has scrollbars
	 * @returns {Boolean}
	 */
	_getHasScrollbars : function() {
		//the containter height is needed because it gets hidden if there are scrollbars and this might lead to the list not having scrollbars again
		return this._oScrollDelegate && this._oScrollDelegate.getMaxScrollTop() > this._oControl.$("triggerList").height();
	},

	/**
	 * function is called to destroy all items in list
	 */
	destroyListItems : function() {
		this._oControl.destroyAggregation("items");
		this._iRenderedDataItems = 0;
	},

	/**
	 * function is called to add single list item or row
	 */
	addListItem : function(oItem, bSuppressInvalidate) {
		this._iRenderedDataItems++;

		// Grouping support
		var oBinding = this._oControl.getBinding("items"),
			oBindingInfo = this._oControl.getBindingInfo("items");

		if (oBinding.isGrouped() && oBindingInfo) {
			var bNewGroup = false,
				aItems = this._oControl.getItems(),
				sModelName = oBindingInfo.model || undefined,
				oNewGroup = this._getGroupForContext(oItem.getBindingContext(sModelName));

			if (aItems.length == 0) {
				bNewGroup = true;
			} else if (oNewGroup.key !== this._getGroupForContext(aItems[aItems.length-1].getBindingContext(sModelName)).key) {
				bNewGroup = true;
			}

			if (bNewGroup) {
				var oGroupHeader = null;
				if (oBindingInfo.groupHeaderFactory) {
					oGroupHeader = oBindingInfo.groupHeaderFactory(oNewGroup);
				}
				this.addItemGroup(oNewGroup, oGroupHeader);
			}
		}

		this._oControl.addAggregation("items", oItem, bSuppressInvalidate);
		if (bSuppressInvalidate) {
			this._renderItemIntoContainer(oItem, false, true);
		}
		return this;
	},

	/**
	 * function is called to add multiple items
	 */
	addListItems : function(aContexts, oBindingInfo, bSuppressInvalidate) {
		if (oBindingInfo && aContexts) {
			for (var i = 0, l = aContexts.length; i < l; i++) {
				var oClone = oBindingInfo.factory("", aContexts[i]);
				oClone.setBindingContext(aContexts[i], oBindingInfo.model);
				this.addListItem(oClone, bSuppressInvalidate);
			}
		}
	},

	/**
	 * destroy all list items and then insert
	 * this function take care async calls during the insertion
	 */
	rebuildListItems : function(aContexts, oBindingInfo, bSuppressInvalidate) {
		// check if building already started
		if (this._bRebuilding) {
			this._fnRebuildQ = jQuery.proxy(this, "rebuildListItems", aContexts, oBindingInfo, bSuppressInvalidate);
			return;
		}

		// rebuild list items
		this._bRebuilding = true;
		this.destroyListItems();
		this.addListItems(aContexts, oBindingInfo, bSuppressInvalidate);
		this._bRebuilding = false;

		// check if something is in the queue
		if (this._fnRebuildQ) {
			var fnRebuildQ = this._fnRebuildQ;
			this._fnRebuildQ = null;
			fnRebuildQ();
		}
	},

	/**
	 * adds a new GroupHeaderListItem
	 */
	addItemGroup : function(oGroup, oHeader) {
		oHeader = this._oControl.addItemGroup(oGroup, oHeader, true);
		this._renderItemIntoContainer(oHeader, false, true);
		return this;
	},

	/**
	 * function is called to insert single list item or row.
	 */
	insertListItem : function(oItem, iIndex) {
		this._oControl.insertAggregation("items", oItem, iIndex, true);
		this._iRenderedDataItems++;
		this._renderItemIntoContainer(oItem, false, this._getDomIndex(iIndex));
		return this;
	},

	/**
	 * function is called to remove single list item or row
	 */
	deleteListItem : function(oItem) {
		this._iRenderedDataItems--;
		oItem.destroy(true);
		return this;
	},

	/**
	 * refresh items ... called from oData model.
	 */
	refreshItems : function(sChangeReason) {
		// set iItemCount to initial value if not set or filtered
		if (!this._iItemCount || sChangeReason == sap.ui.model.ChangeReason.Filter) {
			this._iItemCount = this._oControl.getGrowingThreshold();
		}
		if (!this._bDataRequested) {
			this._bDataRequested = true;
			this._onBeforePageLoaded(sChangeReason);
		}
		this._oControl.getBinding("items").getContexts(0, this._iItemCount);
	},

	/**
	 * update loaded items ... 2nd time called from oData model.
	 */
	updateItems : function(sChangeReason) {
		var oBindingInfo = this._oControl.getBindingInfo("items"),
			oBinding = oBindingInfo.binding,
			fnFactory = oBindingInfo.factory,
			oChangeReason = sap.ui.model.ChangeReason;

		// set iItemCount to initial value if not set or filtered
		if (!this._iItemCount || sChangeReason == sap.ui.model.ChangeReason.Filter) {
			this._iItemCount = this._oControl.getGrowingThreshold();
		}

		// fire growing started event
		if (this._bDataRequested) {
			// if data is already requested this should be oDataModel
			// here items binding is updated because data is came from server
			// so we can convert the internal flag for the next request
			this._bDataRequested = false;
		} else {
			// here we handle the JSON model
			this._onBeforePageLoaded(sChangeReason);
		}

		// get the context from binding
		var aContexts = oBinding ? oBinding.getContexts(0, this._iItemCount) || [] : [];

		// if the binding context is already requested
		if (aContexts.dataRequested) {
			this._bDataRequested = true;
			return;
		}

		// cache dom ref for internal functions not to lookup again and again
		this._oContainerDomRef = this._oControl.getItemsContainerDomRef();

		// aContexts.diff ==> undefined : New data we should build from scratch
		// aContexts.diff ==> [] : There is no diff, means data did not changed but maybe it was already grouped and we need to handle group headers
		// aContexts.diff ==> [{index : 0, type: "delete"}, ...] :Run the diff logic
		if (oBinding.isGrouped()) {
			var bFromScratch = true;
			if (aContexts.length > 0) {
				if (this._oContainerDomRef) {
					// check if diff array exists
					if (aContexts.diff) {
						// check if the model diff-array is empty
						if (!aContexts.diff.length) {
							// no diff, we do not need to rebuild list when grouping is not changed
							if (this._sGroupingPath == this._getGroupingPath(oBinding)) {
								bFromScratch = false;
							}
						} else {
							// check the diff array and whether rebuild is required
							bFromScratch = false;
							var bFirstAddedItemChecked = false;
							for (var i = 0, l = aContexts.diff.length; i < l; i++) {
								if (aContexts.diff[i].type === "delete") {
									bFromScratch = true;
									break;
								}
								else if (aContexts.diff[i].type === "insert") {
									if (!bFirstAddedItemChecked && aContexts.diff[i].index !== this._iRenderedDataItems) {
										bFromScratch = true;
										break;
									}
									bFirstAddedItemChecked = true;
									var oClone = fnFactory("", aContexts[aContexts.diff[i].index]);
									oClone.setBindingContext(aContexts[aContexts.diff[i].index], oBindingInfo.model);
									this.addListItem(oClone, true);
								}
							}
						}
					}
					if (bFromScratch) {
						// renderer available - fill the aggregation and render list items
						this.rebuildListItems(aContexts, oBindingInfo, false);
					}
				} else {
					// no renderer - fill only the aggregation
					this.rebuildListItems(aContexts, oBindingInfo, true);
				}
			} else {
				// no context
				this.destroyListItems();
			}

		} else { // no grouping, stable implementation
			if (aContexts.length > 0) {
				if (this._oContainerDomRef) {
					// check if model diff-array exists and execute
					if (aContexts.diff) {
						// if previously grouped
						if (this._sGroupingPath) {
							// we need to remove all GroupHeaders first
							this._oControl.removeGroupHeaders(true);
						}

						this._oRenderManager = sap.ui.getCore().createRenderManager(); // one shared RenderManager for all the items that need to be rendered

						var aItems, oClone, iIndex, iFlushIndex = -1, iLastIndex = -1;
						for (var i = 0, l = aContexts.diff.length; i < l; i++) {
							iIndex = aContexts.diff[i].index;

							if (aContexts.diff[i].type === "delete") { // case 1: element is removed
								if (iFlushIndex !== -1) {
									this._oRenderManager.flush(this._oContainerDomRef, false, this._getDomIndex(iFlushIndex));
									iFlushIndex = -1;
									iLastIndex = -1;
								}

								aItems = this._oControl.mAggregations["items"]; // access via getItems() copies the array, so direct access... it is only used in the next line to give the item instance, so it's fine
								this.deleteListItem(aItems[iIndex]);
							}
							else if (aContexts.diff[i].type === "insert") { // case 2: element is added
								oClone = fnFactory("", aContexts[iIndex]);
								oClone.setBindingContext(aContexts[iIndex], oBindingInfo.model);

								// start a new burst of subsequent items
								if (iFlushIndex === -1) {
									iFlushIndex = iIndex; // the subsequent run/burst of items needs to be inserted at this position

								// otherwise check for the end of a burst of subsequent items
								} else if (iLastIndex >= 0 && iIndex !== iLastIndex + 1) { // this item is not simply appended to the last one that has been inserted, so we need to flush what we have so far
									this._oRenderManager.flush(this._oContainerDomRef, false, this._getDomIndex(iFlushIndex));
									iFlushIndex = iIndex;
								}

								this.insertListItem(oClone, iIndex);
								iLastIndex = iIndex;
							}
						}
						// update context on all items after applying diff
						aItems = this._oControl.getItems();
						for (var i = 0, l = aContexts.length; i < l; i++) {
							aItems[i].setBindingContext(aContexts[i], oBindingInfo.model);
						}

						if (iFlushIndex !== -1) {
							this._oRenderManager.flush(this._oContainerDomRef, false, this._getDomIndex(iFlushIndex));
						}
						// clean up the shared RenderManager
						this._oRenderManager.destroy();
						delete this._oRenderManager; // make sure there is no instance anymore

					} else {
						// most likely a new binding is set in this case - therefore remove all items and fill again
						this.rebuildListItems(aContexts, oBindingInfo, false);
					}
				} else {
					// no renderer - fill only the aggregation
					this.rebuildListItems(aContexts, oBindingInfo, true);
				}
			} else {
				// there is no context
				this.destroyListItems();
			}
		}

		// remove dom cache
		this._oContainerDomRef = null;

		// remember the old grouping path
		this._sGroupingPath = this._getGroupingPath(oBinding);

		// fire growing finished event
		this._onAfterPageLoaded(sChangeReason);

	},

	/**
	 * hide or show loading trigger according to list item count.
	 */
	_updateTrigger : function() {
		if (this._oControl.getGrowingScrollToLoad() && this._getHasScrollbars()) {
			return;
		}

		// check trigger list DOM first
		var oTriggerListDomRef = document.getElementById(this._oControl.getId() + "-triggerList");
		if (!oTriggerListDomRef) {
			return;
		}

		// hide trigger if no items or maximum of items reached
		var iMaxItems = this._oControl.getMaxItemsCount();
		var iItemsLength = this._oControl.getItems().length;
		var sDisplay = (!iItemsLength || !this._iItemCount || this._iItemCount >= iMaxItems) ? "none" : "block";

		// if we are in the popover then hiding the trigger removes focus and closes popup
		if (sap.ui.Device.system.desktop && sDisplay == "none" && oTriggerListDomRef.contains(document.activeElement)) {
			jQuery(oTriggerListDomRef).closest("[data-sap-ui-popup]").focus();
		}

		// update trigger info
		oTriggerListDomRef.style.display = sDisplay;
		this._oControl.$("trigger-itemInfo").text(this._getListItemInfo());
	},

	/**
	 * show loading indicator
	 */
	_showIndicator : function() {
		var bHasScrollToLoad = this._oControl.getGrowingScrollToLoad(),
			bHasScrollbars = this._getHasScrollbars();

		if (bHasScrollToLoad && bHasScrollbars) {

			this._checkTriggerType(bHasScrollToLoad, bHasScrollbars);

			var $trigger = this._oControl.$("triggerList").css("display", "block");
			if (sap.ui.Device.support.touch && this._oScrollDelegate) {
				if (this._oScrollDelegate.getMaxScrollTop() - this._oScrollDelegate.getScrollTop() < $trigger.height()) {
					this._oScrollDelegate.refresh();
					this._oScrollDelegate.scrollTo(this._oScrollDelegate.getScrollLeft(), this._oScrollDelegate.getMaxScrollTop());
				}
			}
		} else {
			this._oControl.$("trigger-busyIndicator").addClass("sapMGrowingListBusyIndicatorVisible");
		}

		this._getBusyIndicator().setVisible(true);
	},

	/**
	 * Emties the trigger and puts the Loading indicator in it, without rerendering the whole control.
	 *
	 * If scroll to load is disabled, this will do nothing.
	 * If the button is shown and there are scrollbars, the loading indicator will show up.
	 * If the button is not shown and there are no scrollbars, the button will show up.
	 *
	 * @private
	 */
	_checkTriggerType : function(bHasScrollToLoad, bHasScrollbars) {

		if (!bHasScrollToLoad) {
			this._showsTrigger = this._showsLoading = false;
			return;
		}

		if (!this._showsLoading && bHasScrollbars) {
			this._showsLoading = true;
			this._showsTrigger = false;
			this._switchTriggerWithLoadingIndicator(true);
		}

		if (!this._showsTrigger && !bHasScrollbars) {
			this._showsTrigger = true;
			this._showsLoading = false;
			this._switchTriggerWithLoadingIndicator(false);
		}
	},

	/**
	 * Empties the trigger and puts the Loading indicator in it, without rerendering the whole control.
	 *
	 * @private
	 */
	_switchTriggerWithLoadingIndicator : function(bShowLoading) {
		var rm = sap.ui.getCore().createRenderManager(),
			oActionItem,
			$TriggerList = this._oControl.$("triggerList");

		if (bShowLoading) {
			oActionItem = this._getLoading();
		} else {
			oActionItem = this._getTrigger();
		}

		// this variable is needed to render loading indicator in list even in table mode
		oActionItem._renderInList = true;

		$TriggerList.empty();

		rm.render(oActionItem, $TriggerList[0]);
	},

	/**
	 * hide loading indicator
	 */
	_hideIndicator : function() {
		jQuery.sap.delayedCall(0, this, function() {
			if (this._oControl) {	// maybe control is already destroyed
				this._getBusyIndicator().setVisible(false);
				if (this._oControl.getGrowingScrollToLoad() && this._getHasScrollbars()) {
					this._oControl.$("triggerList").css("display", "none");
				} else {
					this._oControl.$("trigger-itemInfo").html(this._getListItemInfo());
					this._oControl.$("trigger-busyIndicator").removeClass("sapMGrowingListBusyIndicatorVisible");
				}
			}
		});
	},

	/**
	 * ScrollDelegate call this method to inform new page needs to load
	 */
	_triggerLoadingByScroll : function() {
		this.requestNewPage();
	}
});

}; // end of sap/m/GrowingEnablement.js
if ( !jQuery.sap.isDeclared('sap.m.IconTabBarRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare("sap.m.IconTabBarRenderer");
jQuery.sap.require('sap.ui.core.IconPool'); // unlisted dependency retained

/**
 * @class HBox renderer.
 * @static
 */
sap.m.IconTabBarRenderer = {
};

/**
 * Array of all available icon color CSS classes
 * 
 * @private
 */
sap.m.IconTabBarRenderer._aAllIconColors = ['sapMITBFilterCritical', 'sapMITBFilterPositive', 'sapMITBFilterNegative', 'sapMITBFilterDefault'];


/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.m.IconTabBarRenderer.render = function(oRM, oControl){
	
	// return immediately if control is not visible
	if (!oControl.getVisible()) {
		return;
	}
	
	var aItems = oControl.getItems();
	var bTextOnly = oControl._checkTextOnly(aItems);
	var bNoText = oControl._checkNoText(aItems);

	oRM.write("<div ");
	oRM.addClass("sapMITB sapMITBNotScrollable");
	oRM.writeControlData(oControl);
	oRM.writeClasses();
	oRM.write(">");
	oRM.renderControl(oControl._getScrollingArrow("left"));

	if (!sap.ui.Device.system.desktop || (sap.ui.Device.os.windows && sap.ui.Device.os.version === 8)) {
		oRM.write("<div id='" + oControl.getId() + "-scrollContainer' class='sapMITBScrollContainer'>");
	}

	oRM.write("<div id='" + oControl.getId() + "-head'");
	oRM.addClass("sapMITBHead");

	if (bTextOnly) {
		oRM.addClass("sapMITBTextOnly");
	}

	if (bNoText) {
		oRM.addClass("sapMITBNoText");
	}

	oRM.writeClasses();
	oRM.write(">");

	jQuery.each(aItems, function(iIndex, oItem) {
		if(!(oItem instanceof sap.m.IconTabSeparator) && !oItem.getVisible()) {
			return; // only render visible items
		}
		oRM.write("<div ");
		oRM.writeElementData(oItem);
		oRM.addClass("sapMITBItem");

		if (oItem instanceof sap.m.IconTabFilter) {

			if(oItem.getDesign() === sap.m.IconTabFilterDesign.Vertical) {
				oRM.addClass("sapMITBVertical");
			} else if (oItem.getDesign() === sap.m.IconTabFilterDesign.Horizontal) {
				oRM.addClass("sapMITBHorizontal");
			}

			if (oItem.getShowAll()) {
				oRM.addClass("sapMITBAll");
			} else {
				oRM.addClass("sapMITBFilter");
				oRM.addClass("sapMITBFilter" + oItem.getIconColor());
			}

			if (!oItem.getEnabled()) {
				oRM.addClass("sapMITBDisabled");
			}

			var sTooltip = oItem.getTooltip_AsString();
			if (sTooltip) {
				oRM.writeAttributeEscaped("title", sTooltip);
			}

			oRM.writeClasses();
			oRM.write(">");
			oRM.write("<div id='" + oItem.getId() + "-tab' class='sapMITBTab'>");

			if (!oItem.getShowAll() || !oItem.getIcon()) {
				oRM.renderControl(oItem._getImageControl(['sapMITBFilterIcon', 'sapMITBFilter' + oItem.getIconColor()], oControl, sap.m.IconTabBarRenderer._aAllIconColors));	
			}

			if (!oItem.getShowAll() && !oItem.getIcon() && !bTextOnly)  {
				oRM.write("<span class='sapMITBFilterNoIcon'> </span>");
			}

			if (oItem.getDesign() === sap.m.IconTabFilterDesign.Horizontal) {
				oRM.write("</div>");
				oRM.write("<div class='sapMITBHorizontalWrapper'>");
			}

			oRM.write("<span ");
			oRM.addClass("sapMITBCount");
			oRM.writeClasses();
			oRM.write(">");

			if ((oItem.getCount() === "") && (oItem.getDesign() === sap.m.IconTabFilterDesign.Horizontal)) {
				//this is needed for the correct placement of the text in the horizontal design
				oRM.write("&nbsp;");
			} else {
				oRM.writeEscaped(oItem.getCount());
			}

			oRM.write("</span>");

			if (oItem.getDesign() === sap.m.IconTabFilterDesign.Vertical) {
				oRM.write("</div>");
			}

			if (oItem.getText().length) {
				oRM.write("<div id='" + oItem.getId() + "-text' class=\"sapMITBText\">");
				oRM.writeEscaped(oItem.getText());
				oRM.write("</div>");
			}

			if (oItem.getDesign() === sap.m.IconTabFilterDesign.Horizontal) {
				oRM.write("</div>");
			}

		} else { // separator
			oRM.addClass("sapMITBSep");

			if (!oItem.getIcon()) {
				oRM.addClass("sapMITBSepLine");
			}
			oRM.writeClasses();
			oRM.write(">");
			
			if (oItem.getIcon()) {
				oRM.renderControl(oItem._getImageControl(['sapMITBSepIcon'], oControl));	
			}
		}
		oRM.write("</div>");
	});

	oRM.write("</div>");

	if (!sap.ui.Device.system.desktop || (sap.ui.Device.os.windows && sap.ui.Device.os.version === 8)) {
		oRM.write("</div>"); //scrollContainer
	}

		oRM.renderControl(oControl._getScrollingArrow("right"));

	var oContent = oControl.getContent();

	oRM.write("<div id=\"" + oControl.getId() + "-containerContent\" ");
	oRM.addClass("sapMITBContainerContent");

	if(!oControl.getExpanded()) { // add special styles  when closed
		oRM.addClass("sapMITBContentClosed");
	}

	oRM.writeClasses();
	oRM.write(">");

	// content arrow
	oRM.write("<div id=\"" + oControl.getId() + "-contentArrow\" ");
	oRM.addClass("sapMITBContentArrow");

	if(!oControl.getExpanded()) { // hide arrow when closed
		oRM.addClass("sapMITBNoContentArrow");
	}

	oRM.writeClasses();
	oRM.write("></div>");

	// inner content div
	oRM.write("<div id=\"" + oControl.getId() + "-content\" class=\"sapMITBContent\" ");
	if(!oControl.getExpanded()) { // hide content when closed
		oRM.write("style=\"display: none\"");
	}
	oRM.write(">");
		
	if (oControl.getExpanded()) {
		// content from selected item
		if (oControl.oSelectedItem && oControl.oSelectedItem.getContent()) {
			var oContentSelectedTab = oControl.oSelectedItem.getContent();
			if (oContentSelectedTab.length > 0) {
				oContent = oContentSelectedTab;
			}
		}
		// render the content
		if (oContent.length > 0) {
			for (var i = 0; i < oContent.length; i++) {
				oRM.renderControl(oContent[i]);
			}
		}
	}

	oRM.write("</div>");
	oRM.write("</div>");
	oRM.write("</div>");
};


}; // end of sap/m/IconTabBarRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.ImageRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
 
// Provides default renderer for control sap.m.Image
jQuery.sap.declare("sap.m.ImageRenderer");

/**
 * @class Image renderer. 
 * @author D051016
 * @static
 */
sap.m.ImageRenderer = {
};


/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 * 
 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.m.ImageRenderer.render = function(rm, oImage){ 
	// Return immediately if control is invisible
	if (!oImage.getVisible()) {
		return;
	}
	
	// Open the <img> tag
	rm.write("<img");

	rm.writeAttributeEscaped("src", oImage._getDensityAwareSrc());
	rm.writeControlData(oImage);
	
	rm.addClass("sapMImg");
	if(oImage.hasListeners("press") || oImage.hasListeners("tap")){
		rm.addClass("sapMPointer");
	}
	rm.writeClasses();
	
	//TODO need further discussion to decide if tooltip is still needed for mobile
	var tooltip = oImage.getTooltip_AsString();
	if (tooltip) {
		rm.writeAttributeEscaped("title", tooltip);
	}

	//TODO implement the ImageMap control
	var sUseMap = oImage.getUseMap();
	if (sUseMap) {
		if (!(jQuery.sap.startsWith(sUseMap, "#"))) {
			sUseMap = "#" + sUseMap;
		}
		rm.writeAttributeEscaped("useMap", sUseMap);
	}
	
	// determine tab index and write alt attribute - both depending on "decorative" state (which is overridden by the "useMap" property
	var myTabIndex = 0;
	if ((oImage.getDecorative() && (!sUseMap))) {
		myTabIndex = -1;
		rm.writeAttribute("role", "presentation");
		rm.write(" alt=''"); // accessibility requirement: write always empty alt attribute for decorative images
	} else {
		if (oImage.getAlt()) {
			rm.writeAttributeEscaped("alt", oImage.getAlt() || tooltip); // accessibility requirement: use tooltip for alt if alt is not set
		} else if (tooltip) {
			rm.writeAttributeEscaped("alt", tooltip);
		}
	}
	rm.writeAttribute("tabIndex", myTabIndex);
	
	// Dimensions

	if (oImage.getWidth() && oImage.getWidth() != '') {
		rm.addStyle("width", oImage.getWidth());
	}
	if (oImage.getHeight() && oImage.getHeight() != '') {
		rm.addStyle("height", oImage.getHeight());
	}
	rm.writeStyles();
	
	var sTooltip = oImage.getTooltip_AsString();
	if (sTooltip) {
		rm.writeAttributeEscaped("title", sTooltip);
	}
	
	rm.write(" />"); // close the <img> element
};

}; // end of sap/m/ImageRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.InputBaseRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare("sap.m.InputBaseRenderer");
jQuery.sap.require('sap.ui.core.ValueStateSupport'); // unlisted dependency retained


/**
 * @class Input renderer.
 * @static
 */
sap.m.InputBaseRenderer = {};

sap.m.InputBaseRenderer.render = function(rm, oControl) {
	if (!oControl.getVisible()) {
		return;
	}

	rm.write("<div");
	rm.writeControlData(oControl);

	// outer styles
	this.addOuterStyles(rm, oControl);
	oControl.getWidth() && rm.addStyle("width", oControl.getWidth());
	rm.writeStyles();

	// outer classes
	rm.addClass("sapMInputBase");
	this.addCursorClass(rm, oControl);
	this.addOuterClasses(rm, oControl);
	!oControl.getEnabled() && rm.addClass("sapMInputBaseDisabled");
	!oControl.getEditable() && rm.addClass("sapMInputBaseReadonly");
	oControl.getValueState() != "None" && rm.addClass("sapMInputBase" + oControl.getValueState());
	rm.writeClasses();

	// outer attributes
	this.writeOuterAttributes(rm, oControl);
	var sTooltip = sap.ui.core.ValueStateSupport.enrichTooltip(oControl, oControl.getTooltip_AsString());
	sTooltip && rm.writeAttributeEscaped("title", sTooltip);
	rm.write(">");

	// enable self-made placeholder
	if (oControl._bShowLabelAsPlaceholder) {
		rm.write("<label class='sapMInputBasePlaceholder'");
		rm.writeAttribute("id", oControl.getId() + "-placeholder");
		rm.writeAttribute("for", oControl.getId() + "-inner");
		rm.write(">");
		rm.writeEscaped(oControl.getPlaceholder());
		rm.write("</label>");
	}

	// start inner
	this.openInputTag(rm, oControl);

	// inner attributes
	rm.writeAttribute("id", oControl.getId() + "-inner");

	// write the name of input
	if (oControl.getName()) {
		rm.writeAttributeEscaped("name", oControl.getName());
	}

	// let the browser handle placeholder
	if (!oControl._bShowLabelAsPlaceholder && oControl.getPlaceholder()) {
		rm.writeAttributeEscaped("placeholder", oControl.getPlaceholder());
	}

	// check if there is a maxLength property
	if (oControl.getMaxLength && oControl.getMaxLength() > 0) {
		rm.writeAttribute("maxlength", oControl.getMaxLength());
	}

	// check disable and readonly
	if (!oControl.getEnabled()) {
		rm.writeAttribute("disabled", "disabled");
	} else  if (!oControl.getEditable()) {
		rm.writeAttribute("tabindex", "-1");
		rm.writeAttribute("readonly", "readonly");
		rm.addClass("sapMInputBaseReadonlyInner");
	}

	this.writeInnerValue(rm, oControl);
	this.writeInnerAttributes(rm, oControl);

	// inner classes
	rm.addClass("sapMInputBaseInner");
	this.addInnerClasses(rm, oControl);
	oControl.getValueState() != "None" && rm.addClass("sapMInputBase" + oControl.getValueState() + "Inner");
	rm.writeClasses();

	// inner styles
	this.addInnerStyles(rm, oControl);
	rm.writeStyles();
	rm.write(">");

	// finish inner
	this.writeInnerContent(rm, oControl);
	this.closeInputTag(rm, oControl);

	// finish outer
	rm.write("</div>");
};

/**
 * This function is reserved for derived class to add extra attributes to Input
 *
 * @deprecated sap.m.InputBaseRenderer#writeInnerAttributes should be called instead of this method
 *
 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.m.InputBaseRenderer.writeAttributes = function(oRm, oControl) {
	jQuery.sap.log.warning("Usage of deprecated function: sap.m.InputBaseRenderer#writeAttributes");
	this.writeInnerAttributes(oRm, oControl);
};

/**
 * Adds extra CSS class
 *
 * @deprecated sap.m.InputBaseRenderer#addOuterClasses should be called instead of this method
 *
 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.m.InputBaseRenderer.addClasses = function(oRm, oControl) {
	jQuery.sap.log.warning("Usage of deprecated function: sap.m.InputBaseRenderer#addClasses");
	this.addOuterClasses(oRm, oControl);
};


/**
 * Write the opening tag name of the input
 *
 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.m.InputBaseRenderer.openInputTag = function(oRm, oControl) {
	oRm.write("<input");
};

/**
 * Write the value of the input
 *
 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.m.InputBaseRenderer.writeInnerValue = function(oRm, oControl) {
	oRm.writeAttributeEscaped("value", oControl.getValue());
};


/**
 * Add cursor class to input container
 *
 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.m.InputBaseRenderer.addCursorClass = function(oRm, oControl) {
	if (oControl.getEnabled()) {
		oRm.addClass("sapMInputBaseCursor");
	}
};


/**
 * This function is reserved for derived class to add extra styles for input container
 *
 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.m.InputBaseRenderer.addOuterStyles = function(oRm, oControl) {
};

/**
 * This function is reserved for derived class to add extra classes for input container
 *
 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.m.InputBaseRenderer.addOuterClasses = function(oRm, oControl) {
};

/**
 * This function is reserved for derived class to add extra attributes for input container
 *
 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.m.InputBaseRenderer.writeOuterAttributes = function(oRm, oControl) {
};

/**
 * This function is reserved for derived class to add extra styles for input element
 *
 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.m.InputBaseRenderer.addInnerStyles = function(oRm, oControl) {
};

/**
 * This function is reserved for derived class to add extra classes for input element
 *
 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.m.InputBaseRenderer.addInnerClasses = function(oRm, oControl) {
};

/**
 * This function is reserved for derived class to add extra attributes for input element
 *
 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.m.InputBaseRenderer.writeInnerAttributes = function(oRm, oControl) {
};

/**
 * Write the value of the input
 *
 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.m.InputBaseRenderer.writeInnerContent = function(oRm, oControl) {
};

/**
 * Write the closing tag name of the input
 *
 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.m.InputBaseRenderer.closeInputTag = function(oRm, oControl) {
};
}; // end of sap/m/InputBaseRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.InputRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained


jQuery.sap.declare("sap.m.InputRenderer");

/**
 * @class Input renderer.
 * @static
 *
 * InputRenderer extends the InputBaseRenderer
 */
sap.m.InputRenderer = sap.ui.core.Renderer.extend(sap.m.InputBaseRenderer);

/**
 * Adds control specific class
 *
 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.m.InputRenderer.addOuterClasses = function(oRm, oControl) {
	oRm.addClass("sapMInput");
	if(oControl.getShowValueHelp() && oControl.getEnabled() && oControl.getEditable()) {
		oRm.addClass("sapMInputVH");
	}
};

/**
 * add extra attributes to Input
 *
 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.m.InputRenderer.writeInnerAttributes = function(oRm, oControl) {
	oRm.writeAttribute("type", oControl.getType().toLowerCase());
	if ((!oControl.getEnabled() && oControl.getType() == "Password")
			|| (oControl.getShowSuggestion() && sap.ui.Device.system.phone)){
		// required for JAWS reader on password fields on desktop:
		oRm.writeAttribute("readonly", "readonly");
	}
};

/**
 * Adds inner css classes to the input field
 *
 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.m.InputRenderer.addInnerClasses = function(oRm, oControl) {
};

/**
 * add extra content to Input
 *
 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.m.InputRenderer.writeInnerContent = function(oRm, oControl) {
	 if(oControl.getShowValueHelp() && oControl.getEnabled() && oControl.getEditable()) {
		oRm.write('<div class="sapMInputValHelp">');
		oRm.renderControl(oControl._getValueHelpIcon());
		oRm.write("</div>");
	 }
};
}; // end of sap/m/InputRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.InstanceManager') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.m.InstanceManager
jQuery.sap.declare("sap.m.InstanceManager");
/**
 * @class Provides methods to manage instances. This is specifically designed for managing the opened Popover, Dialog, ActionSheet,
 * and it's possible to close all of the opened Popover, Dialog, ActionSheet in history handling.
 *
 * As <code>InstanceManager</code> is a static class, a <code>jQuery.sap.require("sap.m.InstanceManager");</code> statement
 * must be explicitly executed before the class can be used. Example:
 * <pre>
 *   jQuery.sap.require("sap.m.InstanceManager");
 *   sap.m.InstanceManager.closeAllPopovers();
 * </pre>
 *
 * @static
 * @public
 * @since 1.9.2
 */
sap.m.InstanceManager = {};

(function() {
	var mRegistry = {},
		aEmptyArray = [];
	
	var sPopoverCategoryId = "_POPOVER_",
		sDialogCategoryId = "_DIALOG_";

	/**
	 * Adds an instance to the given category.
	 *
	 * @param {string} sCategoryId The category's id.
	 * @param {object} oInstance The instance that will be added to the given category.
	 * @returns {sap.m.InstanceManager} Enable method chaining.
	 * @protected
	 * @function
	*/
	sap.m.InstanceManager.addInstance = function(sCategoryId, oInstance) {
		jQuery.sap.assert(sCategoryId, "In sap.m.InstanceManager.addInstance method, the parameter sCategoryId can't be null or empty string");
		jQuery.sap.assert(oInstance instanceof Object, "In sap.m.InstanceManager.addInstance method, the parameter oInstance should be an object");

		if (!mRegistry[sCategoryId]) {
			mRegistry[sCategoryId] = [];
		}

		mRegistry[sCategoryId].push(oInstance);

		return this;
	};

	/**
	 * Removes a managed instance from the given category.
	 *
	 * @param {string} sCategoryId The category's id.
	 * @param {object} oInstance The instance that will be removed from the given category.
	 * @returns The removed instance or null. If the instance isn't managed, this method returns null instead of the instance object.
	 * @protected
	 * @function
	*/
	sap.m.InstanceManager.removeInstance = function(sCategoryId, oInstance) {
		var aCategory = mRegistry[sCategoryId],
			i;

		jQuery.sap.assert(sCategoryId, "In sap.m.InstanceManager.removeInstance method, the parameter sCategoryId can't be null or empty string");
		jQuery.sap.assert(oInstance instanceof Object, "In sap.m.InstanceManager.removeInstance method, the parameter oInstance should be an object");

		if (!aCategory) {
			jQuery.sap.log.warning("Can't remove control from a non-managed category id: " + sCategoryId);
			return null;
		}

		i = aCategory.indexOf(oInstance);

		return (i === -1) ? null : aCategory.splice(i, 1);
	};

	/**
	 * Returns an array of managed instances in the given category.
	 *
	 * @param {string} sCategoryId The category's id.
	 * @returns {object} Managed instances in the given category.
	 * @protected
	 * @function
	*/
	sap.m.InstanceManager.getInstancesByCategoryId = function(sCategoryId) {
		jQuery.sap.assert(sCategoryId, "In sap.m.InstanceManager.getInstancesByCategoryId method, the parameter sCategoryId can't be null or empty string");

		return mRegistry[sCategoryId] || aEmptyArray;
	};

	/**
	 * Checks if an instance is managed under the given category.
	 * 
	 * @param {string} sCategoryId The category that the instance is supposed to be in.
	 * @param {object} oInstance The instance that needs to be checked.
	 * @returns {boolean} Whether the instance is managed in the given category.
	 * @protected
	 * @function
	 */
	sap.m.InstanceManager.isInstanceManaged = function(sCategoryId, oInstance) {
		jQuery.sap.assert(sCategoryId, "In sap.m.InstanceManager.isInstanceManaged method, the parameter sCategoryId can't be null or empty string");
		jQuery.sap.assert(oInstance instanceof Object, "In sap.m.InstanceManager.isInstanceManaged method, the parameter oInstance should be an object");

		var aCategory = mRegistry[sCategoryId];

		if (!aCategory || !oInstance) {
			return false;
		}

		return aCategory.indexOf(oInstance) !== -1;
	};

	/**
	 * Returns if there's no managed instance in the given category.
	 *
	 * @param {string} sCategoryId The category's id.
	 * @returns {boolean} Whether the category is empty.
	 * @protected
	 * @function
	*/
	sap.m.InstanceManager.isCategoryEmpty = function(sCategoryId) {
		jQuery.sap.assert(sCategoryId, "In sap.m.InstanceManager.isCategoryEmpty method, the parameter sCategoryId can't be null or empty string");

		var aCategory = mRegistry[sCategoryId];

		return !aCategory || aCategory.length === 0;
	};

	/**
	 * Adds a control to predefined popover category in instance manager.
	 *
	 * @param {sap.ui.core.Control} oPopover Popover to be added to instance manager. Custom popover which doesn't inherit from sap.m.Popover can also be added as long as it has a close method.
	 * @returns {sap.m.InstanceManager} Enable method chaining.
	 * @protected
	 * @function
	*/
	sap.m.InstanceManager.addPopoverInstance = function(oPopover){
		if (typeof oPopover.close === "function") {
			sap.m.InstanceManager.addInstance(sPopoverCategoryId, oPopover);
		}else{
			jQuery.sap.log.warning("In method addPopoverInstance: the parameter doesn't have a close method and can't be managed.");
		}
		return this;
	};
	
	/**
	 * Adds a control to predefined dialog category in instance manager.
	 *
	 * @param {sap.ui.core.Control} oDialog Dialog to be added to instance manager. Dialog which doesn't inherit from sap.m.Dialog can also be added as long as it has a close method.
	 * @returns {sap.m.InstanceManager} Enable method chaining.
	 * @protected
	 * @function
	*/
	sap.m.InstanceManager.addDialogInstance = function(oDialog){
		if (typeof oDialog.close === "function" ) {
			sap.m.InstanceManager.addInstance(sDialogCategoryId, oDialog);
		}else{
			jQuery.sap.log.warning("In method addDialogInstance: the parameter doesn't have a close method and can't be managed.");
		}
		return this;
	};
	
	/**
	 * Removes control from predefined popover category in instance manager.
	 *
	 * @param {sap.ui.core.Control} Popover to be removed from instance manager.
	 * @returns The removed popover or null. If the popover isn't managed, this method returns null instead of the removed popover.
	 * @protected
	 * @function
	*/
	sap.m.InstanceManager.removePopoverInstance = function(oPopover){
		return sap.m.InstanceManager.removeInstance(sPopoverCategoryId, oPopover);
	};
	
	/**
	 * Removes control from predefined dialog category in instance manager.
	 *
	 * @param {sap.ui.core.Control} Dialog to be removed from instance manager.
	 * @returns The removed popover or null. If the popover isn't managed, this method returns null instead of the removed popover.
	 * @protected
	 * @function
	*/
	sap.m.InstanceManager.removeDialogInstance = function(oDialog){
		return sap.m.InstanceManager.removeInstance(sDialogCategoryId, oDialog);
	};
	
	/**
	 * Returns true if there's popover(s) managed in predefined popover category, otherwise it returns false.
	 *
	 * @returns {boolean} Whether there's popover(s) open.
	 * @public
	 * @function
	*/
	sap.m.InstanceManager.hasOpenPopover = function(){
		return !sap.m.InstanceManager.isCategoryEmpty(sPopoverCategoryId);
	};
	
	/**
	 * Returns true if there's dialog(s) managed in predefined dialog category, otherwise it returns false.
	 *
	 * @returns {boolean} Whether there's dialog(s) open.
	 * @public
	 * @function
	*/
	sap.m.InstanceManager.hasOpenDialog = function(){
		return !sap.m.InstanceManager.isCategoryEmpty(sDialogCategoryId);
	};
	
	/**
	 * Check if the given dialog instance is managed under the dialog category.
	 * For dialog instances, managed means the dialog is open.
	 * 
	 * This function is specially provided for customized controls which doesn't have the possibility to check whether it's open.
	 * If the given dialog is an instance of sap.m.Dialog, sap.m.ActionSheet, the isOpen() method on the instance is 
	 * preferred to be called than this function.
	 * 
	 * @param {sap.ui.core.Control} oDialog The dialog that is checked for the openness.
	 * @returns Whether the given dialog is open.
	 * @public
	 * @function
	 */
	sap.m.InstanceManager.isDialogOpen = function(oDialog){
		return sap.m.InstanceManager.isInstanceManaged(sDialogCategoryId, oDialog);
	};
	
	/**
	 * Check if the given popover instance is managed under the popover category.
	 * For popover instances, managed means the popover is open.
	 * 
	 * This function is specially provided for customized controls which doesn't have the possibility to check whether it's open. 
	 * If the given popover is an instance of sap.m.Popover, sap.m.ActionSheet, the isOpen() method on the instance is 
	 * preferred to be called than this function.
	 * 
	 * @param {sap.ui.core.Control} oPopover The popover that is checked for the openness.
	 * @returns Whether the given popover is open.
	 * @public
	 * @function
	 */
	sap.m.InstanceManager.isPopoverOpen= function(oPopover){
		return sap.m.InstanceManager.isInstanceManaged(sPopoverCategoryId, oPopover);
	};
	
	/**
	 * Gets all of the open popovers. If there's no popover open, it returns an empty array.
	 *
	 * @return {sap.ui.core.Control[]} The open popovers.
	 * @public
	 * @function
	*/
	sap.m.InstanceManager.getOpenPopovers = function(){
		return sap.m.InstanceManager.getInstancesByCategoryId(sPopoverCategoryId);
	};
	
	/**
	 * Gets all of the open dialogs. If there's no dialog open, it returns an empty array.
	 *
	 * @return {sap.ui.core.Control[]} The open dialogs.
	 * @public
	 * @function
	*/
	sap.m.InstanceManager.getOpenDialogs = function(){
		return sap.m.InstanceManager.getInstancesByCategoryId(sDialogCategoryId);
	};
	
	/**
	 * Closes all open popovers.
	 *
	 * @public
	 * @returns {sap.m.InstanceManager} Enable method chaining.
	 * @function
	*/
	sap.m.InstanceManager.closeAllPopovers = function(){
		var aIntances = sap.m.InstanceManager.getOpenPopovers(), i;
		for(i = 0 ; i < aIntances.length ; i++){
			aIntances[i].close();
		}
		return this;
	};
	
	/**
	 * Closes all of the open dialogs.
	 *
	 * @public
	 * @returns {sap.m.InstanceManager} Enable method chaining.
	 * @function
	*/
	sap.m.InstanceManager.closeAllDialogs = function(fnCallback) {
		var oDeferred,
			aDeferred = [], 
			aIntances = sap.m.InstanceManager.getOpenDialogs(), 
			dialog,
			i;
		
		for(i = 0 ; i < aIntances.length; i++){
			dialog = aIntances[i];
			
			if (fnCallback) {
				oDeferred = new jQuery.Deferred().done();
				aDeferred.push(oDeferred);

				dialog.attachEvent("afterClose", function(def){
					return function() {
						def.resolve();
					};
				} (oDeferred));

			}
			
			dialog.close();
		}
		
		if(fnCallback) {
			jQuery.when.apply(this, aDeferred).then(fnCallback);
		}
  
		return this;
	};
}());
}; // end of sap/m/InstanceManager.js
if ( !jQuery.sap.isDeclared('sap.m.LabelRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */


jQuery.sap.declare("sap.m.LabelRenderer");
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained


/**
 * @class Label renderer.
 * @static
 */
sap.m.LabelRenderer = {
};


/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} rm the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.core.Control} oLabel an object representation of the control that should be rendered
 */
sap.m.LabelRenderer.render = function(rm, oLabel){
	// return immediately if control is invisible
	if (!oLabel.getVisible()) {
		return;
	}

	// convenience variable
	var r = sap.m.LabelRenderer;

	// write the HTML into the render manager
	rm.write("<label");
	rm.writeControlData(oLabel);

	// Styles
	rm.addClass("sapMLabel");
	//set design to bold
	if (oLabel.getDesign() == sap.m.LabelDesign.Bold) {
		rm.addStyle("font-weight", "bold");
	}

	if (oLabel.getRequired()) {
		rm.addClass("sapMLabelRequired");
	}

	if (oLabel.getLabelForRendering()) {
		var oFor = sap.ui.getCore().byId(oLabel.getLabelForRendering());
		rm.write(" for=\"");
		// for some controls the label must point to a special HTML element, not the outer one.
		if ( oFor && oFor.getIdForLabel) {
			rm.write(oFor.getIdForLabel());
		} else{
			rm.write(oLabel.getLabelForRendering());
		}
		rm.write("\"");
	}

	// Text direction
	var sTextDir = oLabel.getTextDirection();
	if (sTextDir) {
		rm.addStyle("direction", sTextDir.toLowerCase());
	}

	// Style for width
	var sWidth = oLabel.getWidth();
	if (sWidth) {
		rm.addStyle("width", sWidth);
	} else {
		rm.addClass("sapMLabelMaxWidth");
	}

	// Style for text alignment
	var sTextAlign = oLabel.getTextAlign();
	if(sTextAlign) {
		var sTextAlign = r.getTextAlign(sTextAlign, sTextDir);
		if (sTextAlign) {
			rm.addStyle("text-align", sTextAlign);
		}
	}

	var sLabelText = oLabel.getText();
	if (sLabelText =="") {
		rm.addClass("sapMLabelNoText");
	}

	rm.writeStyles();
	rm.writeClasses();

	var sTooltip = oLabel.getTooltip_AsString();
	if (sTooltip) {
		rm.writeAttributeEscaped("title", sTooltip);
	}

	rm.write(">");

	// Write the label text

	if (sLabelText) {
		rm.writeEscaped(sLabelText);
	}
	rm.write("</label>");
};

/**
 * Dummy inheritance of static methods/functions.
 * @see sap.ui.core.Renderer.getTextAlign
 * @private
 */
sap.m.LabelRenderer.getTextAlign = sap.ui.core.Renderer.getTextAlign;

}; // end of sap/m/LabelRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.LinkRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

 jQuery.sap.declare("sap.m.LinkRenderer");

/**
 * @class Link renderer
 * @static
 */
sap.m.LinkRenderer = {
};


/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.m.LinkRenderer.render = function(rm, oControl) {
	// Return immediately if control is invisible
	if (!oControl.getVisible()) {
		return;
	}

	// Link is rendered as a "<a>" element
	rm.write("<a");
	rm.writeControlData(oControl);

	rm.addClass("sapMLnk");
	if (!oControl.getEnabled()) {
		rm.addClass("sapMLnkDsbl");
		rm.writeAttribute("disabled", "true");
		rm.writeAttribute("tabIndex", "-1");
	} else {
		rm.writeAttribute("tabIndex", "0");
	}
	if (oControl.getWrapping()) {
		rm.addClass("sapMLnkWrapping");
	}

	if (oControl.getTooltip_AsString()) {
		rm.writeAttributeEscaped("title", oControl.getTooltip_AsString());
	}

	if (oControl.getHref()) {
		rm.writeAttributeEscaped("href", oControl.getHref());
	}	else {
		rm.writeAttribute("href", "javascript:void(0);");
	}

	if (oControl.getTarget()) {
		rm.writeAttributeEscaped("target", oControl.getTarget());
	}

	if (oControl.getWidth()) {
		rm.addStyle("width", oControl.getWidth());
	} else {
		rm.addClass("sapMLnkMaxWidth");
	}

	rm.writeClasses();
	rm.writeStyles();
	rm.write(">"); // opening <a> tag

	if (oControl.getText()) {
		rm.writeEscaped(oControl.getText());
	}

	rm.write("</a>");
};

}; // end of sap/m/LinkRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.ListBaseRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare("sap.m.ListBaseRenderer");
jQuery.sap.require('sap.ui.core.theming.Parameters'); // unlisted dependency retained


/**
 * @class List renderer.
 * @static
 */
sap.m.ListBaseRenderer = {};

/**
 * Renders the HTML for the given control, using the provided
 * {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager}
 *          oRenderManager the RenderManager that can be used for writing to the
 *          Render-Output-Buffer
 * @param {sap.ui.core.Control}
 *          oControl an object representation of the control that should be
 *          rendered
 */
sap.m.ListBaseRenderer.render = function(rm, oControl) {
	// return immediately if control is invisible
	if (!oControl.getVisible()) {
		return;
	}

	// container
	rm.write("<div");
	rm.addClass("sapMList");
	rm.writeControlData(oControl);
	rm.writeAttribute("tabindex", "-1");
	if (oControl.getInset()) {
		rm.addClass("sapMListInsetBG");
	}
	if (oControl.getWidth()) {
		rm.addStyle("width", oControl.getWidth());
	}

	// background
	if (oControl.getBackgroundDesign) {
		rm.addClass("sapMListBG" + oControl.getBackgroundDesign());
	}

	// run hook method
	this.renderContainerAttributes(rm, oControl);

	rm.writeStyles();
	rm.writeClasses();
	rm.write(">");

	// dummy before focusable area
	rm.write("<div tabindex='-1'");
	rm.writeAttribute("id", oControl.getId("before"));
	rm.write("></div>");

	// render header
	var sHeaderText = oControl.getHeaderText();
	var oHeaderTBar = oControl.getHeaderToolbar();
	if (oHeaderTBar) {
		oHeaderTBar.setDesign(sap.m.ToolbarDesign.Transparent, true);
		rm.renderControl(oHeaderTBar);
	} else if (sHeaderText) {
		rm.write("<div class='sapMListHdr'>");
		rm.writeEscaped(sHeaderText);
		rm.write("</div>");
	}

	// render info bar
	var oInfoTBar = oControl.getInfoToolbar();
	if (oInfoTBar) {
		oInfoTBar.setDesign(sap.m.ToolbarDesign.Info, true);
		rm.renderControl(oInfoTBar);
	}

	// run hook method to start building list
	this.renderListStartAttributes(rm, oControl);

	// list attributes
	rm.addClass("sapMListUl");
	rm.writeAttribute("tabindex", "-1");
	rm.writeAttribute("id", oControl.getId("listUl"));

	// separators
	rm.addClass("sapMListShowSeparators" + oControl.getShowSeparators());

	// modes
	rm.addClass("sapMListMode" + oControl.getMode());

	// inset
	oControl.getInset() && rm.addClass("sapMListInset");

	// write inserted styles and classes
	rm.writeClasses();
	rm.writeStyles();
	rm.write(">");

	// run hook method to render list head attributes
	this.renderListHeadAttributes(rm, oControl);

	// render child controls
	var aItems = oControl.getItems();
	var bRenderItems = oControl.shouldRenderItems();

	//TODO: There should be a better way to set these private variables
	bRenderItems && aItems.forEach(function(oItem) {
		oControl._applySettingsToItem(oItem, true);
		rm.renderControl(oItem);
	});

	// render no-data if needed
	if ((!bRenderItems || !aItems.length) && oControl.getShowNoData()) {
		// hook method to render no data
		this.renderNoData(rm, oControl);
	}

	// run hook method to finish building list
	this.renderListEndAttributes(rm, oControl);

	// render growing delegate if available
	if (bRenderItems && oControl._oGrowingDelegate) {
		oControl._oGrowingDelegate.render(rm);
	}

	// footer
	if (oControl.getFooterText()) {
		rm.write("<footer class='sapMListFtr'>");
		rm.writeEscaped(oControl.getFooterText());
		rm.write("</footer>");
	}

	// dummy after focusable area
	rm.write("<div tabindex='-1'");
	rm.writeAttribute("id", oControl.getId("after"));
	rm.write("></div>");

	// done
	rm.write("</div>");
};

/**
 * This hook method is called to render container attributes
 *
 * @param {sap.ui.core.RenderManager} rm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.m.ListBaseRenderer.renderContainerAttributes = function(rm, oControl) {
};

/**
 * This hook method is called after <ul> and before first <li>
 *
 * @param {sap.ui.core.RenderManager} rm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.m.ListBaseRenderer.renderListHeadAttributes = function(rm, oControl) {
};

/**
 * This hook method is called to render list tag
 *
 * @param {sap.ui.core.RenderManager} rm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.m.ListBaseRenderer.renderListStartAttributes = function(rm, oControl) {
	rm.write("<ul");
	oControl.addNavSection(oControl.getId("listUl"));
};

/**
 * This hook method is called to finish list rendering
 *
 * @param {sap.ui.core.RenderManager} rm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.m.ListBaseRenderer.renderListEndAttributes = function(rm, oControl) {
	rm.write("</ul>");
};

/**
 * This hook method is called to render no data field
 *
 * @param {sap.ui.core.RenderManager} rm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.m.ListBaseRenderer.renderNoData = function(rm, oControl) {
	rm.write("<li id='" + oControl.getId("nodata") + "' class='sapMLIB sapMListNoData sapMLIBTypeInactive'>");
	rm.write("<span id='" + oControl.getId("nodata-text") + "'>");
	rm.writeEscaped(oControl.getNoDataText());
	rm.write("</span></li>");
};
}; // end of sap/m/ListBaseRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.ListItemBaseRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare("sap.m.ListItemBaseRenderer");
jQuery.sap.require('sap.ui.core.theming.Parameters'); // unlisted dependency retained

jQuery.sap.require('sap.ui.core.IconPool'); // unlisted dependency retained


/**
 * @class ListitemBase renderer.
 * @static
 */
sap.m.ListItemBaseRenderer = {};

/**
 * Renders the HTML for the given control, using the provided
 * {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager}
 *          oRenderManager the RenderManager that can be used for writing to the
 *          Render-Output-Buffer
 * @param {sap.ui.core.Control}
 *          oControl an object representation of the control that should be
 *          rendered
 */
sap.m.ListItemBaseRenderer.render = function(rm, oLI) {
	// return immediately if control is invisible
	if (!oLI.getVisible()) {
		return;
	}

	var _bShowUnreadBubble = (sap.ui.core.theming.Parameters.get("sapUiLIUnreadAsBubble") == "true");

	// define behavior: list or table
	var sId = oLI.getId(),
		oParent = oLI.getParent(),
		isTable = !oLI.hasOwnProperty("_renderInList") && oParent && oParent.getColumns && oParent.getColumns().length,
		bNoFlex = oLI._bNoFlex, // IE9 does not support flex-box: render as a table
		rowEndTag, rowStartTag, openCellTag, closeCellTag, hasPopin = false,
		sTooltip = oLI.getTooltip_AsString();

	if (!isTable) {
		rowEndTag = "</li>";
		rowStartTag = "<li tabindex='-1'";
		openCellTag = function() {
			rm.write("<div");
		};
		closeCellTag = function() {
			rm.write("</div>");
		};
	} else {
		rowEndTag = "</tr>";
		rowStartTag = "<tr tabindex='-1'";
		hasPopin = oParent.hasPopin() && sap.m.ColumnListItem && oLI instanceof sap.m.ColumnListItem;
		openCellTag = function(cls, bDontCreateDiv) {
			rm.write("<td");
			if (cls) {
				rm.addClass(cls);
				rm.writeClasses();
			}
			if (!bDontCreateDiv) {
				rm.write("><div");
			}
		};
		closeCellTag = function(bDontCreateDiv) {
			if (!bDontCreateDiv) {
				rm.write("</div>");
			}
			rm.write("</td>");
		};
	}

	rm.write(rowStartTag);
	sTooltip && rm.writeAttributeEscaped("title", sTooltip);
	rm.writeControlData(oLI);
	rm.addClass("sapMLIB");
	rm.addClass("sapMLIB-CTX");
	if(!isTable && bNoFlex){ // switch to the no-flex rendering
		rm.addClass("sapMLIBNoFlex");
	}

	rm.addClass("sapMLIBShowSeparator");

	if (oLI._includeItemInSelection || oLI._mode == "SingleSelectMaster" || (oLI.getType() != "Inactive" && oLI.getType() != "Detail")) {
		rm.addClass("sapMLIBCursor");
	}

	//unread switch... bubble or is shown as bold text
	if (oLI._showUnread && oLI.getUnread()) {
		rm.addClass("sapMLIBUnread");
		if(!_bShowUnreadBubble){
			rm.addClass("sapMLIBUnreadBold");
		}
	}
	if (hasPopin) {
		rm.addClass("sapMListTblSupRow");
	}

	// TODO: Remove this unnecessary class name sapMLIBUnread is enough
	if (oLI._showUnread && oLI.getUnread()) {
		rm.addClass("sapMLIBUnreadRow");
	}

	// LI attributes hook
	if (this.renderLIAttributes) {
		this.renderLIAttributes(rm, oLI);
	}

	rm.addClass("sapMLIBType" + oLI.getType());

	// LI content hook
	if (this.renderLIContent) {

		// depending on the mode of the list a checkbox or radiobutton will be
		// rendered. If a switch between list modes happens, an animation will be
		// added for the selection area
		var oSelectControl = null;

		switch (oLI._mode) {
		case "SingleSelectLeft":
			oSelectControl = oLI._getRadioButton((sId + "-selectSingle"), oLI._listId + "_selectGroup");
			if (oLI.getSelected()) {
				rm.addClass("sapMLIBSelected");
			}
			rm.writeClasses();
			rm.write(">");

			openCellTag("sapMListTblSelCol");
			rm.addClass("sapMLIBSelectSL");
			if (oLI._oldMode === "None" && oLI._modeAnimationOn) {
				rm.addClass("sapMLIBSelectAnimation");
			}
			rm.writeAttribute("id", sId + "-mode");
			rm.writeClasses();
			rm.write(">");
			rm.renderControl(oSelectControl);
			closeCellTag();
			oLI._oldMode = oLI._mode;
			break;
		case "SingleSelect":
			oSelectControl = oLI._getRadioButton((sId + "-selectSingle"), oLI._listId + "_selectGroup");
			if (oLI.getSelected()) {
				rm.addClass("sapMLIBSelected");
			}
			rm.writeClasses();
			rm.write(">");
			break;
		case "SingleSelectMaster":
			oSelectControl = oLI._getRadioButton((sId + "-selectSingleMaster"), oLI._listId + "_selectMasterGroup");
			if (oLI.getSelected()) {
				rm.addClass("sapMLIBSelected");
			}
			rm.writeClasses();
			rm.write(">");
			openCellTag("sapMListTblNone");
			rm.addClass("sapMLIBSelectSM");
			rm.writeAttribute("id", sId + "-mode");
			rm.writeClasses();
			rm.write(">");
			rm.renderControl(oSelectControl);
			closeCellTag();
			oLI._oldMode = oLI._mode;
			break;
		case "MultiSelect":
			oSelectControl = oLI._getCheckBox((sId + "-selectMulti"));
			if (oLI.getSelected()) {
				rm.addClass("sapMLIBSelected");
			}
			rm.writeClasses();
			rm.write(">");
			openCellTag("sapMListTblSelCol");
			rm.addClass("sapMLIBSelectM");
			if (oLI._oldMode === "None" && oLI._modeAnimationOn) {
				rm.addClass("sapMLIBSelectAnimation");
			}
			rm.writeAttribute("id", sId + "-mode");
			rm.writeClasses();
			rm.write(">");
			rm.renderControl(oSelectControl);
			closeCellTag();
			oLI._oldMode = oLI._mode;
			break;
		case "Delete":
			rm.writeClasses();
			rm.write(">");
			if(sap.ui.core.theming.Parameters.get("sapMPlatformDependent") === "true"){
				openCellTag("sapMListTblSelCol");
				rm.addClass("sapMLIBSelectD");
				if (oLI._oldMode === "None" && oLI._modeAnimationOn) {
					rm.addClass("sapMLIBSelectAnimation");
				}
				rm.writeAttribute("id", sId + "-mode");
				rm.writeClasses();
				rm.write(">");
				var delIcon = null;
				if (sap.ui.core.theming.Parameters.get("sapUiLIDelIcon") == "false"){
					delIcon = oLI._getDelImage((sId + "-imgDel"), "sapMLIBImgDel", "delete_icon.png");
				}
				else{
					var sURI = sap.ui.core.IconPool.getIconURI("sys-cancel");
					delIcon = oLI._delIcon || new sap.ui.core.Icon(sId + "-imgDel",{src:sURI}).setParent(oLI, null, true).addStyleClass("sapMLIBIconDel").attachPress(oLI._delete);;
				}
				if (delIcon) {
					oLI._delIcon = delIcon;
					rm.renderControl(delIcon);
				}
				closeCellTag();
				oLI._oldMode = oLI._mode;
			}
			break;
		case "None":
			rm.writeClasses();
			rm.write(">");
			if (!isTable && !bNoFlex && oLI._oldMode && oLI._oldMode !== "None"
					&& oLI._oldMode !== "SingleSelect" && oLI._oldMode !== "SingleSelectMaster"
					&& !(oLI._oldMode == "Delete" && sap.ui.core.theming.Parameters.get("sapMPlatformDependent") !== "true")
					&& oLI._modeAnimationOn) {
				openCellTag();
				rm.addClass("sapMLIBUnselectAnimation");
				rm.writeAttribute("id", sId + "-mode");
				rm.writeClasses();
				rm.write(">");
				closeCellTag();
			}
			break;
		}

		if (oLI._showUnread && _bShowUnreadBubble) {
			openCellTag("sapMListTblUnreadCol");
			rm.writeAttribute("id", sId + "-unread");
			rm.addClass("sapMLIBUnreadBase");
			if (oLI.getUnread()) {
				rm.addClass("sapMLIBUnreadBubble");
			}
			rm.writeClasses();
			rm.write(">");
			closeCellTag();
		}

		var type = oLI.getType(), navIcon = "";
		switch (type) {
			case "Navigation":
				navIcon = "NAV";
				break;
			case "Detail":
			case "DetailAndActive":
				navIcon = "DET";
				break;
		}

		if (isTable) {
			this.renderLIContent(rm, oLI, oParent);
		} else {
			openCellTag();
			rm.addClass("sapMLIBContent");

			// there will be a margin on the right, if no navigation icon or counter is shown
			if ((type == "Active" || type == "Inactive")  && !oLI.getCounter()) {
				rm.addClass("sapMLIBContentMargin");
			}

			rm.writeClasses();
			rm.write(">");
			if(bNoFlex){
				// additional content table inside for the no-flex case
				rm.write('<div class="sapMLIBContentNF">');
			}
			this.renderLIContent(rm, oLI);
			if(bNoFlex){
				rm.write("</div>");
			}
			closeCellTag();
		}

		// if we are not in table mode than counter different than 0 bubble will be shown
		if (!isTable && oLI.getCounter()) {
			rm.write("<div");
			rm.writeAttribute("id", sId + "-counter");
			rm.addClass("sapMLIBCounter");
			if (!navIcon) {
				rm.addClass("sapMLIBContentMargin");
			}
			rm.writeClasses();
			rm.write(">");
			rm.write(oLI.getCounter());
			rm.write("</div>");
		}
		if (navIcon == "NAV" && (jQuery.os.ios || sap.ui.core.theming.Parameters.get("sapMPlatformDependent") !== "true") && oLI.getType() == "Navigation") {
			isTable && openCellTag("sapMListTblNavCol", true);
			if(jQuery.os.ios && sap.ui.core.theming.Parameters.get("sapMPlatformDependent") == "true"){
				!isTable && rm.write("<div");
				rm.addClass("sapMLIBImgNav");
				rm.writeAttribute("id", sId + "-imgNav");
				rm.writeClasses();
				rm.write(">");
				!isTable && rm.write("</div>");
			} else {
				isTable && rm.write(">");
				var sURI = sap.ui.core.IconPool.getIconURI("slim-arrow-right");
				var	oNavIcon = oLI._navIcon || new sap.ui.core.Icon(sId + "-imgNav",{src:sURI}).setParent(oLI, null, true).addStyleClass("sapMLIBImgNav");
				if (oNavIcon) {
					oLI._navIcon = oNavIcon;
					rm.renderControl(oNavIcon);
				}
			}
			isTable && closeCellTag(true);
			oParent._navRenderedBy = sId + "-imgNav";
		} else if (navIcon == "DET") {
			openCellTag("sapMListTblNavCol");
			rm.addClass("sapMLIBCursor");
			rm.writeClasses();
			rm.write(">");
			var detailIcon = null;
			if (sap.ui.core.theming.Parameters.get("sapUiLIDetailIcon") == "false"){
				detailIcon = oLI._getNavImage((sId + "-imgDet"), "sapMLIBImgDet", "detail_disclosure.png", "detail_disclosure_pressed.png");
			}
			else{
				var sURI = sap.ui.core.IconPool.getIconURI("edit");
				detailIcon = oLI._detailIcon || new sap.ui.core.Icon(sId + "-imgDet",{src:sURI}).setParent(oLI, null, true).addStyleClass("sapMLIBIconDet");
			}
			if (detailIcon) {
				oLI._detailIcon = detailIcon;
				rm.renderControl(detailIcon);
			}

			closeCellTag();
			oParent._navRenderedBy = sId + "-imgDet";
		} else if (isTable) {
			// create empty cells for table
			rm.write("<td></td>");
		}

		switch (oLI._mode) {
		case "SingleSelect":
			openCellTag("sapMListTblSelCol");
			rm.addClass("sapMLIBSelectS");
			if (oLI._oldMode === "None" && oLI._modeAnimationOn) {
				rm.addClass("sapMLIBSelectAnimation");
			}
			rm.writeAttribute("id", sId + "-mode");
			rm.writeClasses();
			rm.write(">");
			rm.renderControl(oSelectControl);
			closeCellTag();
			oLI._oldMode = oLI._mode;
			break;
		case "Delete":
			if(sap.ui.core.theming.Parameters.get("sapMPlatformDependent") !== "true"){
				openCellTag("sapMListTblSelCol");
				rm.addClass("sapMLIBSelectD");
				if (oLI._oldMode === "None" && oLI._modeAnimationOn) {
					rm.addClass("sapMLIBSelectAnimation");
				}
				rm.writeAttribute("id", sId + "-mode");
				rm.writeClasses();
				rm.write(">");
				//toDo: this happens twice...put it in a method...
				var delIcon = null;
				if (sap.ui.core.theming.Parameters.get("sapUiLIDelIcon") == "false"){
					delIcon = oLI._getDelImage((sId + "-imgDel"), "sapMLIBImgDel", "delete_icon.png");
				}
				else{
					var sURI = sap.ui.core.IconPool.getIconURI("sys-cancel");
					delIcon = oLI._delIcon || new sap.ui.core.Icon(sId + "-imgDel",{src:sURI}).setParent(oLI, null, true).addStyleClass("sapMLIBIconDel").attachPress(oLI._delete);;
				}
				if (delIcon) {
					oLI._delIcon = delIcon;
					rm.renderControl(delIcon);
				}
				closeCellTag();
				oLI._oldMode = oLI._mode;
			}
			break;
		case "None":
			if (!isTable && !bNoFlex && oLI._oldMode && oLI._oldMode !== "None" && (oLI._oldMode === "SingleSelect" || (oLI._oldMode === "Delete" && sap.ui.core.theming.Parameters.get("sapMPlatformDependent") !== "true")) && oLI._modeAnimationOn) {
				openCellTag();
				rm.addClass("sapMLIBUnselectAnimation");
				rm.writeAttribute("id", sId + "-mode");
				rm.writeClasses();
				rm.write(">");
				closeCellTag();
			}
			oLI._oldMode = oLI._mode;
			break;
		}
	} else {
		rm.writeClasses();
		rm.write(">");
	}
	rm.write(rowEndTag);

	if (hasPopin) {
		this.renderPopin(rm, oLI, oParent);
	}
};
}; // end of sap/m/ListItemBaseRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.ListRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained


jQuery.sap.declare("sap.m.ListRenderer");

/**
 * @class List renderer.
 * @static
 *
 * ListRenderer extends the ListBaseRenderer
 */
sap.m.ListRenderer = sap.ui.core.Renderer.extend(sap.m.ListBaseRenderer);

sap.m.ListRenderer.render = function(rm, oControl) {
	// if "columns" aggregation is not in use then we do not need backwards compatibility
	if (!oControl.getColumns().length) {
		sap.m.ListBaseRenderer.render.call(this, rm, oControl);
		return;
	}
	
	/**
	 * For backwards compatibility we need to render List with columns
	 * However, if the compatibility version is 1.16 or higher then
	 * we stop rendering to force using Table control with columns
	 */
	if (oControl._isColumnsIncompatible()) {
		jQuery.sap.log.warning("Does not render sap.m.List#" + oControl.getId() + " with columns aggregation when compatibility version is 1.16 or higher. Instead use sap.m.Table control!");
		return;
	}
	
	/**
	 * FIXME: Here to support old API if columns are set
	 * We are trying to extend renderer to render list as table
	 * This is so ugly and we need to get rid of it ASAP
	 */
	jQuery.sap.require("sap.m.TableRenderer");
	var oRenderer = jQuery.extend({}, this, sap.m.TableRenderer);
	sap.m.ListBaseRenderer.render.call(oRenderer, rm, oControl);
};


}; // end of sap/m/ListRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.MessageToast') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare("sap.m.MessageToast");
jQuery.sap.require('sap.ui.core.Popup'); // unlisted dependency retained



/**
 * @class
 * A message toast notification offers simple feedback about an operation in a pop-up.
 * Toasts automatically disappear after a timeout and will never receive focus in order
 * to be unobtrusive as possible.
 * Toasts appears close the bottom of the screen, centered horizontally, but you can change
 * this position which is not dependent on the default values of the position settings.
 * The default position applies as long as the application does not do any position setting.
 * Position settings are "my", "at", "of" and "offset".
 *
 * Beware that only one message toast can be shown at a time in the same place.
 * If you want to have multiple message toasts visible at the same time, you need to position
 * the message toasts in different places.
 * This positioning needs to be handled in the application logic.
 *
 * Message toast example:
 *
 * <pre>
 * sap.m.MessageToast.show("This message should appear in the message toast", {
 *     duration: 3000,                  // default
 *     width: "15em",                   // default
 *     my: "center bottom",             // default
 *     at: "center bottom",             // default
 *     of: window,                      // default
 *     offset: "0 0",                   // default
 *     collision: "fit fit"             // default
 *     onClose: null,                   // default
 *     autoClose: true,                 // default
 *     animationTimingFunction: "ease", // default
 *     animationDuration: 1000,         // default
 *     closeOnBrowserNavigation: true   // default
 * });
 * </pre>
 *
 * @author SAP AG
 * @since 1.9.2
 *
 * @static
 * @public
 * @name sap.m.MessageToast
 */
sap.m.MessageToast = {};

/* =========================================================== */
/* Internal methods and properties                             */
/* =========================================================== */

sap.m.MessageToast._OFFSET = "0 -64";

sap.m.MessageToast._CSSCLASS = "sapMMessageToast";

sap.m.MessageToast._mSettings = {
	duration: 3000,
	width: "15em",
	my: "center bottom",
	at: "center bottom",
	of: document.defaultView,
	offset: "0 0",
	collision: "fit fit",
	onClose: null,
	animationTimingFunction: "ease",
	animationDuration: 1000,
	autoClose: true,
	closeOnBrowserNavigation: true
};

sap.m.MessageToast._aPopups = [];

sap.m.MessageToast._iOpenedPopups = 0;

sap.m.MessageToast._bBoundedEvents = false;

sap.m.MessageToast._validateSettings = function(mSettings) {

	// duration
	this._isFiniteInteger(mSettings.duration);

	// width
	this._validateWidth(mSettings.width);

	// my
	this._validateDockPosition(mSettings.my);

	// at
	this._validateDockPosition(mSettings.at);

	// of
	this._validateOf(mSettings.of);

	// offset
	this._validateOffset(mSettings.offset);

	// collision
	this._validateCollision(mSettings.collision);

	// onClose
	this._validateOnClose(mSettings.onClose);

	// autoClose
	this._validateAutoClose(mSettings.autoClose);

	// animationTimingFunction
	this._validateAnimationTimingFunction(mSettings.animationTimingFunction);

	// animationDuration
	this._isFiniteInteger(mSettings.animationDuration);
};

sap.m.MessageToast._isFiniteInteger = function(iNumber) {
	if (typeof iNumber !== "number" || !isFinite(iNumber) || !(Math.floor(iNumber) === iNumber) || iNumber <= 0) {
		jQuery.sap.log.error('"iNumber" needs to be a finite positive nonzero integer on ' + this + "._isFiniteInteger");
	}
};

sap.m.MessageToast._validateWidth = function(sWidth) {
	if (!sap.ui.core.CSSSize.isValid(sWidth)) {
		jQuery.sap.log.error(sWidth + ' is not of type ' + '"sap.ui.core.CSSSize" for property "width" on ' + this + "._validateWidth");
	}
};

sap.m.MessageToast._validateDockPosition = function(sDock) {
	if (!sap.ui.core.Dock.isValid(sDock)) {
		jQuery.sap.log.error('"' + sDock + '"' + ' is not of type ' + '"sap.ui.core.Popup.Dock" on ' + this + "._validateDockPosition");
	}
};

sap.m.MessageToast._validateOf = function(vElement) {
	if (!(vElement instanceof jQuery) &&
		!jQuery.isWindow(vElement) &&
		!(vElement && vElement.nodeType === 1) &&
		!(vElement instanceof sap.ui.core.Control)) {

		jQuery.sap.log.error('"of" needs to be an instance of sap.ui.core.Control or an Element or a jQuery object or the window on ' + this + "._validateOf");
	}
};

sap.m.MessageToast._validateOffset = function(sOffset) {
	if (typeof sOffset !== "string") {
		jQuery.sap.log.error(sOffset + ' is of type ' + typeof sOffset + ', expected "string" for property "offset" on ' + this + "._validateOffset");
	}
};

sap.m.MessageToast._validateCollision = function(sCollision) {
	var rValidCollisions = /^(fit|flip|none|flipfit|flipflip|flip flip|flip fit|fitflip|fitfit|fit fit|fit flip)$/i;

	if (!rValidCollisions.test(sCollision)) {
		jQuery.sap.log.error('"collision" needs to be a single value “fit”, “flip”, or “none”, or a pair for horizontal and vertical e.g. "fit flip”, "fit none", "flipfit" on ' + this + "._validateOffset");
	}
};

sap.m.MessageToast._validateOnClose = function(fn) {
	if (typeof fn !== "function" && fn !== null) {
		jQuery.sap.log.error('"onClose" should be a function or null on ' + this + "._validateOnClose");
	}
};

sap.m.MessageToast._validateAutoClose = function(b) {
	if (typeof b !== "boolean") {
		jQuery.sap.log.error('"autoClose" should be a boolean on ' + this + "._validateAutoClose");
	}
};

sap.m.MessageToast._validateAnimationTimingFunction = function(sTimingFunction) {
	var rValidTimingFn = /^(ease|linear|ease-in|ease-out|ease-in-out)$/i;

	if (!rValidTimingFn.test(sTimingFunction)) {
		jQuery.sap.log.error('"animationTimingFunction" should be a string, expected values: ' + "ease, linear, ease-in, ease-out, ease-in-out on " + this + "._validateAnimationTimingFunction");
	}
};

sap.m.MessageToast._hasDefaulPosition = function(mOptions) {
	for (var aPositionOptions = ["my", "at", "of", "offset"], i = 0; i < aPositionOptions.length; i++) {
		if (mOptions[aPositionOptions[i]] !== undefined) {
			return false;
		}
	}

	return true;
};

sap.m.MessageToast._createHTMLMarkup = function(mSettings) {
	var oMessageToastDomRef = document.createElement("div");

	oMessageToastDomRef.style.width = mSettings.width;
	oMessageToastDomRef.className = sap.m.MessageToast._CSSCLASS;
	oMessageToastDomRef.appendChild(document.createTextNode(mSettings.message));

	return oMessageToastDomRef;
};

sap.m.MessageToast._normalizeOptions = function(mOptions) {
	if (mOptions) {

		// if no position options are provided
		if (this._hasDefaulPosition(mOptions)) {

			// change the default offset
			mOptions.offset = this._OFFSET;
		}

		// if the document object is provided as an option, replace it with the window object,
		// the message toast should be showed relative to the visual viewport instead to the layout viewport
		if (mOptions.of && mOptions.of.nodeType === 9) {
			mOptions.of = document.defaultView;
		}
	} else {

		mOptions = {

			// if no options are provided, change the default offset
			offset: this._OFFSET
		};
	}

	return mOptions;
};

/* =========================================================== */
/* Event handlers                                              */
/* =========================================================== */

sap.m.MessageToast._handleResizeEvent = function() {

	if (sap.ui.Device.system.phone || sap.ui.Device.system.tablet) {
		this._resetPosition(this._aPopups);
	}

	jQuery.sap.delayedCall(0, this, "_applyPositions", [this._aPopups]);
};

sap.m.MessageToast._handleMouseDownEvent = function(oEvent) {

	if (oEvent.isMarked("delayedMouseEvent")) {
		return;
	}

	this._aPopups.forEach(function(oPopup) {
		oPopup && oPopup.getAutoClose() && oPopup.close();
	});
};

sap.m.MessageToast._resetPosition = function(aPopups) {
	for (var i = 0, oMessageToastDomRef; i < aPopups.length; i++) {
		oMessageToastDomRef = aPopups[i] && aPopups[i].getContent();

		if (oMessageToastDomRef) {
			oMessageToastDomRef.style.visibility = "hidden";
			oMessageToastDomRef.style.left = 0;
		}
	};
};

sap.m.MessageToast._applyPositions = function(aPopups) {
	for (var i = 0, oPopup, mPosition; i < aPopups.length; i++) {
		oPopup = aPopups[i];
		if (oPopup) {
			mPosition = oPopup._oPosition;	// TODO _oPosition is a private property

			if (sap.ui.Device.system.phone || sap.ui.Device.system.tablet) {
				jQuery.sap.delayedCall(0, this, "_applyPosition", [oPopup, mPosition]);
			} else {
				oPopup.setPosition(mPosition.my, mPosition.at, mPosition.of, mPosition.offset);
			}
		}
	}
};

sap.m.MessageToast._applyPosition = function(oPopup, mPosition) {
	var mPosition = mPosition || oPopup._oPosition,
		oMessageToastDomRef = oPopup.getContent();

	oPopup.setPosition(mPosition.my, mPosition.at, mPosition.of, mPosition.offset);
	oMessageToastDomRef.style.visibility = "visible";
};

sap.m.MessageToast._setCloseAnimation = function($MessageToastDomRef, iDuration, fnClose, mSettings) {
	var sCssTransition = "opacity " + mSettings.animationTimingFunction + " " + mSettings.animationDuration + "ms",
		sTransitionEnd = "webkitTransitionEnd." + sap.m.MessageToast._CSSCLASS + " transitionend." + sap.m.MessageToast._CSSCLASS;

	if (mSettings.animationDuration > 0) {
		$MessageToastDomRef[0].style.webkitTransition = sCssTransition;
		$MessageToastDomRef[0].style.transition = sCssTransition;
		$MessageToastDomRef[0].style.opacity = 0;

		$MessageToastDomRef.on(sTransitionEnd, function handleMTTransitionEnd() {

			// unbound the event handler after its first invocation
			$MessageToastDomRef.off(sTransitionEnd);

			// handleMTClosed() function is called
			fnClose();
		});
	} else {
		fnClose();
	}
};

/* =========================================================== */
/* API methods                                                 */
/* =========================================================== */

/**
 * Creates and displays a simple message toast notification message with the given text, and optionally other options.
 *
 * The only mandatory parameter is <code>sMessage</code>.
 *
 * @param {string} sMessage The message to be displayed.
 * @param {object} [mOptions] Optionally other options.
 * @param {int} [mOptions.duration=3000] Time in milliseconds before the close animation starts. Needs to be a finite positive nonzero integer.
 * @param {sap.ui.core.CSSSize} [mOptions.width='15em'] The width of the message toast, this value can be provided in %, em, px and all possible CSS measures.
 * @param {sap.ui.core.Popup.Dock} [mOptions.my='center bottom'] Specifies which point of the message toast should be aligned.
 * @param {sap.ui.core.Popup.Dock} [mOptions.at='center bottom'] Specifies the point of the reference element to which the message toast should be aligned.
 * @param {sap.ui.core.Control|Element|jQuery|Window|undefined} [mOptions.of=window] Specifies the reference element to which the message toast should be aligned, by default it is aligned to the browser visual viewport.
 * @param {string} [mOptions.offset='0 0'] The offset relative to the docking point, specified as a string with space-separated pixel values (e.g. "0 10" to move the message toast 10 pixels to the right).
 * @param {string} [mOptions.collision='fit fit'] Specifies how the position of the message toast should be adjusted in case it overflows the screen in some direction. Possible values “fit”, “flip”, “none”, or a pair for horizontal and vertical e.g. "fit flip”, "fit none".
 * @param {function} [mOptions.onClose=null] Function to be called when the message toast closes.
 * @param {boolean} [mOptions.autoClose=true] Specify whether the message toast should close as soon as the end user touches the screen.
 * @param {string} [mOptions.animationTimingFunction='ease'] Describes how the close animation will progress. Possible values "ease", "linear", "ease-in", "ease-out", "ease-in-out". This feature is not supported in android and ie9 browsers.
 * @param {int} [mOptions.animationDuration=1000] Time in milliseconds that the close animation takes to complete. Needs to be a finite positive integer. For not animation set to 0. This feature is not supported in android and ie9 browsers.
 * @param {boolean} [mOptions.closeOnBrowserNavigation=true] Whether the message toast closes on browser navigation.
 *
 * @type void
 * @public
 * @name sap.m.MessageToast.show
 * @function
 */
sap.m.MessageToast.show = function(sMessage, mOptions) {
	var self = this,
		mSettings = jQuery.extend({}, this._mSettings, { message: sMessage }),
		oPopup = new sap.ui.core.Popup(),
		handleMTClosed,
		iPos,
		oMessageToastDomRef;

	mOptions = this._normalizeOptions(mOptions);

	// merge mOptions into mSettings
	jQuery.extend(mSettings, mOptions);

	// validate all settings
	this._validateSettings(mSettings);

	// create the message toast HTML markup
	oMessageToastDomRef = this._createHTMLMarkup(mSettings);

	// save this pop-up instance and the position,
	// to be used inside fnMTAttachClosed closure
	iPos = this._aPopups.push(oPopup) - 1;

	// sets the content of the pop-up
	oPopup.setContent(oMessageToastDomRef);

	// sets the position of the pop-up
	oPopup.setPosition(mSettings.my, mSettings.at, mSettings.of, mSettings.offset, mSettings.collision);

	if (jQuery.support.cssTransitions) {

		// sets the animation functions to use for opening and closing the message toast
		// note: this custom animations are using CSS3 transitions
		oPopup.setAnimations(function fnMessageToastOpen($MessageToast, iDuration, fnOpened) {
			fnOpened();
		}, function fnMessageToastClose($MessageToastDomRef, iDuration, fnClose) {
			self._setCloseAnimation($MessageToastDomRef, iDuration, fnClose, mSettings);
		});
	}

	// no shadow
	oPopup.setShadow(false);

	//
	oPopup.setAutoClose(mSettings.autoClose);

	if (mSettings.closeOnBrowserNavigation) {

		// add the pop-up instance to the InstanceManager to handle browser back navigation
		sap.m.InstanceManager.addPopoverInstance(oPopup);
	}

	// do not bind if already bound
	if (!this._bBoundedEvents) {

		// bind to the resize event to handle orientation change and resize events
		jQuery(window).on("resize." + sap.m.MessageToast._CSSCLASS, jQuery.proxy(this._handleResizeEvent, this));
		jQuery(document).on("mousedown." + sap.m.MessageToast._CSSCLASS, jQuery.proxy(this._handleMouseDownEvent, this));

		this._bBoundedEvents = true;
	}

	// opens the popup's content at the position specified via #setPosition
	oPopup.open();
	this._iOpenedPopups++;

	// attach event handler fnFunction to the "closed" event
	oPopup.attachClosed(function handleMTClosed() {
		sap.m.InstanceManager.removePopoverInstance(self._aPopups[iPos]);
		jQuery(self._aPopups[iPos].getContent()).remove();
		self._aPopups[iPos].detachClosed(handleMTClosed);
		self._aPopups[iPos].destroy();
		self._aPopups[iPos] = null;
		self._iOpenedPopups--;

		if (self._iOpenedPopups === 0) {
			self._aPopups = [];
			jQuery(window).off("resize." + sap.m.MessageToast._CSSCLASS);
			jQuery(document).off("mousedown." + sap.m.MessageToast._CSSCLASS);

			self._bBoundedEvents = false;
		}

		if (typeof mSettings.onClose === "function") {
			mSettings.onClose.call(self);
		}
	});

	// close the message toast
	jQuery.sap.delayedCall(mSettings.duration, oPopup, "close");
};

sap.m.MessageToast.toString = function() {
	return "sap.m.MessageToast";
};
}; // end of sap/m/MessageToast.js
if ( !jQuery.sap.isDeclared('sap.m.NavContainerRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare("sap.m.NavContainerRenderer");

/**
 * @class NavContainer renderer. 
 * @static
 */
sap.m.NavContainerRenderer = {
};


/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 * 
 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.m.NavContainerRenderer.render = function(rm, oControl) { 
	// return immediately if control is invisible
	if (!oControl.getVisible()) {
		return;
	}
	
	rm.write("<div");
	rm.writeControlData(oControl);
	
	rm.addClass("sapMNav");
	rm.addStyle("width", oControl.getWidth());
	rm.addStyle("height", oControl.getHeight());

	if (this.renderAttributes) {
		this.renderAttributes(rm, oControl); // may be used by inheriting renderers, but DO NOT write class or style attributes! Instead, call addClass/addStyle.
	}
	
	rm.writeClasses();
	rm.writeStyles();
	
	var sTooltip = oControl.getTooltip_AsString();
	if (sTooltip) {
		rm.writeAttributeEscaped("title", sTooltip);
	}
	rm.write(">"); // div element

	if (this.renderBeforeContent) {
		this.renderBeforeContent(rm, oControl); // may be used by inheriting renderers
	}
	
	var oContent = oControl.getCurrentPage();
	if (oContent) {
		rm.renderControl(oContent);
	}

	rm.write("</div>");
};

}; // end of sap/m/NavContainerRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.ObjectAttributeRenderer') ) {
/*
 * @copyright
 */
jQuery.sap.declare("sap.m.ObjectAttributeRenderer");

/**
 * @class ObjectAttributeA renderer. 
 * @static
 */
sap.m.ObjectAttributeRenderer = {
};


/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 * 
 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.m.ObjectAttributeRenderer.render = function(oRm, oOA) {

	// return immediately if control is invisible
	if(oOA.getVisible() && !oOA._isEmpty()) {
		oRm.write("<div");
		oRm.writeControlData(oOA);
		oRm.addClass("sapMObjectAttributeDiv"); 
		if(oOA.getActive()){
			oRm.addClass("sapMObjectAttributeActive");
		}
		oRm.writeClasses();
		
		var sTooltip = oOA.getTooltip_AsString();
		if (sTooltip) {
			oRm.writeAttributeEscaped("title", sTooltip);
		}		
		
		oRm.write(">");
		oRm.write("<span>");
		var oText = new sap.m.Text({text: oOA.getText()});
		oText.setMaxLines(2);
		oRm.renderControl(oText);
		oRm.write("</span>");
		oRm.write("</div>");
	}
};

}; // end of sap/m/ObjectAttributeRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.ObjectHeaderRenderer') ) {
/*
 * @copyright
 */
jQuery.sap.declare("sap.m.ObjectHeaderRenderer");
jQuery.sap.require('sap.ui.core.IconPool'); // unlisted dependency retained


/**
 * @class ObjectHeader renderer.
 * @static
 */
sap.m.ObjectHeaderRenderer = {};

/**
 * Check if the object exists. In case object has _isEmpty() method then this method is called. If there is no such method then object is not empty.
 * 
 * @param {sap.ui.core.Control}
 *            oObject to be checked
 * 
 * @returns true is the object is not empty, false - otherwise.
 * 
 * @private
 */
sap.m.ObjectHeaderRenderer._isEmptyObject = function(oObject) {

	if (!oObject) {
		return true;
	}

	if ((!oObject._isEmpty || !oObject._isEmpty())&&(!oObject.getVisible || oObject.getVisible())) {
		return false;
	}
	return true;
};

/**
 * Array is considered empty if it is null or undefined or has no controls or all the controls are empty.
 * 
 * @param {sap.ui.core.Control[]}
 *            aArray array of controls to be checked
 * 
 * @returns true if array is empty, false - otherwise.
 * @private
 */
sap.m.ObjectHeaderRenderer._isEmptyArray = function(aArray) {

	if (aArray) {
		for ( var i = 0; i < aArray.length; i++) {
			if (!sap.m.ObjectHeaderRenderer._isEmptyObject(aArray[i])) {
				return false;
			}
		}
	}
	return true;
};

/**
 * A row is considered empty if both input parameters are empty.
 * 
 * @param {sap.ui.core.Control}
 *            aLeft control to be checked
 * 
 * @param {sap.ui.core.Control[]}
 *            aRight array of controls to be checked
 * 
 * @returns true if array is empty, false - otherwise.
 * @private
 */
sap.m.ObjectHeaderRenderer._isEmptyRow = function(oLeft, aRight) {

	return sap.m.ObjectHeaderRenderer._isEmptyObject(oLeft) && sap.m.ObjectHeaderRenderer._isEmptyArray(aRight);
};

/**
 * Render an array of controls.
 * 
 * @param {sap.ui.core.RenderManager}
 *            rm the RenderManager that can be used for writing to the render output buffer
 * 
 * @param {sap.ui.core.Control[]}
 *            aObjects array of controls to be rendered
 * @private
 */
sap.m.ObjectHeaderRenderer._renderObjects = function(rm, aObjects) {

	for ( var i = 0; i < aObjects.length; i++) {
		if (aObjects[i] instanceof sap.ui.core.Control) {
			rm.renderControl(aObjects[i]);
		}
	}
};

/**
 * Returns the array of icons from ObjectHeader.
 * 
 * @param {sap.m.ObjectHeader}
 *            oOH the ObjectHeader that contains icons
 * 
 * @returns array of {sap.m.Image} controls
 * 
 * @private
 */
sap.m.ObjectHeaderRenderer._getIcons = function(oOH) {

	var icons = [];

	if (oOH.getShowMarkers()) {
		oOH._oFavIcon.setVisible(oOH.getMarkFavorite());
		oOH._oFlagIcon.setVisible(oOH.getMarkFlagged());

		icons.push(oOH._oPlaceholderIcon);
		icons.push(oOH._oFavIcon);
		icons.push(oOH._oFlagIcon);
	}

	return icons;
};




/**
 * Renders the HTML for Attribute.
 * 
 * @param {sap.ui.core.RenderManager}
 *            rm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.m.ObjectHeader}
 *            oOH an object to be rendered
 * @param {sap.m.ObjectAttribute}
 *            oAttr an attribute to be rendered
 * @param {boolean} bFullWidth set the attribute width to 100%
 */
sap.m.ObjectHeaderRenderer.renderAttribute = function(rm, oOH, oAttr, bFullWidth) {
	rm.write("<div");
	rm.addClass("sapMOHAttr");
	rm.writeClasses();
	if (bFullWidth) {
		rm.addStyle("width", "100%");
		rm.writeStyles();
	}
	rm.write(">");
	rm.renderControl(oAttr);
	rm.write("</div>");
};

/**
 * Renders the HTML for single line of Attribute and Status.
 * 
 * @param {sap.ui.core.RenderManager}
 *            rm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.m.ObjectHeader}
 *            oOH an object to be rendered
 * @param {sap.m.ObjectAttribute}
 *            oLeft an attribute to be rendered
 * @param {sap.ui.core.Control[]} aRight a status or Progress Indicator Array to be rendered
 */
sap.m.ObjectHeaderRenderer.renderRow = function(rm, oOH, oLeft, aRight) {

	if (sap.m.ObjectHeaderRenderer._isEmptyRow(oLeft, aRight)) {
		return; // nothing to render
	}
    
	rm.write("<div"); // Start attribute row container
	rm.addClass("sapMOHAttrRow");
	rm.writeClasses();
	rm.write(">");

	if (!sap.m.ObjectHeaderRenderer._isEmptyObject(oLeft)) {
		this.renderAttribute(rm, oOH, oLeft, sap.m.ObjectHeaderRenderer._isEmptyArray(aRight));
	} else if (sap.m.ObjectHeaderRenderer._isEmptyObject(oLeft) && !sap.m.ObjectHeaderRenderer._isEmptyArray(aRight)) {						
		if (aRight[0] instanceof sap.m.ProgressIndicator) {				
			rm.write("<div");
			rm.addClass("sapMOHAttr");
			rm.writeClasses();
			rm.write(">");
			rm.write("</div>");
		}		
	}

	if (!sap.m.ObjectHeaderRenderer._isEmptyArray(aRight)) {
		rm.write("<div");
		if (aRight[0] instanceof sap.m.ProgressIndicator) {
			rm.addClass("sapMOHStatusFixedWidth");
		}
		else if (aRight[0] instanceof sap.ui.core.Icon) {
			rm.addClass("sapMOHStatusFixedWidth");
			rm.addClass("sapMObjStatusMarker");
		}
		else {
			rm.addClass("sapMOHStatus");
		}
		rm.writeClasses();
		rm.write(">");
		sap.m.ObjectHeaderRenderer._renderObjects(rm, aRight);
		rm.write("</div>");
	}

	rm.write("</div>"); // Start attribute row container
};

/**
 * Renders the HTML for attributes and statuses, using the provided {@link sap.ui.core.RenderManager}. Validate the statuses control list to only display ObjectStatus and
 * ProgressIndicator
 * 
 * @param {sap.ui.core.RenderManager}
 *            rm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.m.ObjectHeader}
 *            oOH an object to be rendered
 */
sap.m.ObjectHeaderRenderer.renderAttributesAndStatuses = function(rm, oOH) {

	var aAttribs = oOH.getAttributes();
	var aVisibleAttribs = [];

	for( var i = 0; i < aAttribs.length; i ++){
		if( aAttribs[i].getVisible()){
			aVisibleAttribs.push(aAttribs[i]);
		}
	}

	var iAttribsLength = aVisibleAttribs.length;

	var aIconsAndStatuses = [];
	var aIcons = sap.m.ObjectHeaderRenderer._getIcons(oOH);
	if (!sap.m.ObjectHeaderRenderer._isEmptyArray(aIcons)) {
		aIconsAndStatuses.push(aIcons);
	}

	if (oOH.getFirstStatus()) {
		aIconsAndStatuses.push([ oOH.getFirstStatus() ]);
	}
	if (oOH.getSecondStatus()) {
		aIconsAndStatuses.push([ oOH.getSecondStatus() ]);
	}
	if (oOH.getStatuses()) {
		var aStatuses = oOH.getStatuses();
		for ( var i = 0; i < aStatuses.length; i++) {
			if(!aStatuses[i].getVisible || aStatuses[i].getVisible()){
				if (aStatuses[i] instanceof sap.m.ObjectStatus || aStatuses[i] instanceof sap.m.ProgressIndicator) {
					aIconsAndStatuses.push([ aStatuses[i] ]);
				} else {
					jQuery.sap.log.warning("Only sap.m.ObjectStatus or sap.m.ProgressIndicator are allowed in \"sap.m.ObjectHeader.statuses\" aggregation." + " Current object is "
							+ aStatuses[i].constructor.getMetadata().getName() + " with id \"" + aStatuses[i].getId() + "\"");
				}
			}
		}
	}

	var iIconsAndStatusesLength = aIconsAndStatuses.length;

	var iNoOfRows = iAttribsLength > iIconsAndStatusesLength ? iAttribsLength : iIconsAndStatusesLength;

	for ( var i = 0; i < iNoOfRows; i++) {
		this.renderRow(rm, oOH, aVisibleAttribs[i], aIconsAndStatuses[i]);
	}
};

/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 * 
 * @param {sap.ui.core.RenderManager}
 *            rm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.m.Control}
 *            oOH an object representation of the control that should be rendered
 */
sap.m.ObjectHeaderRenderer.renderNumber = function(rm, oOH) {
	if (oOH.getNumber()) {
		// Container for a number and a units qualifier.
		rm.write("<div"); // Start Number/units container
		rm.writeAttribute("id", oOH.getId() + "-numberdiv");
		rm.addClass("sapMOHNumberDiv");
		rm.writeClasses();
		rm.write(">");

		rm.write("<span");
		rm.writeAttribute("id", oOH.getId() + "-number");
		rm.addClass("sapMOHNumber");
		rm.addClass("sapMOHNumberState" + oOH.getNumberState());

		rm.writeClasses();
		rm.write(">");
		rm.writeEscaped(oOH.getNumber());

		rm.write("</span>");

		if (oOH.getNumberUnit()) {
			rm.write("<span");
			rm.writeAttribute("id", oOH.getId() + "-numberUnit");
			rm.addClass("sapMOHNumberUnit");
			rm.addClass("sapMOHNumberState" + oOH.getNumberState());
			
			rm.writeClasses();
			rm.write(">");
			rm.writeEscaped(oOH.getNumberUnit());
			rm.write("</span>");
		}

		rm.write("</div>"); // End Number/units container
	}
};

/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 * 
 * @param {sap.ui.core.RenderManager}
 *            rm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.m.Control}
 *            oOH an object representation of the control that should be rendered
 */
sap.m.ObjectHeaderRenderer.renderTitle = function(rm, oOH) {
	// Start title text and title arrow container
	oOH._oTitleArrowIcon.setVisible(oOH.getShowTitleSelector());
	if(oOH.getShowTitleSelector() && oOH._oTitleArrowIcon.getVisible()){
		rm.write("<div");
		rm.addClass("sapMOHTitleAndArrow");
		rm.writeClasses();
		rm.write(">");
	}

	if (oOH.getTitle()) {
		oOH._titleText.setText(oOH.getTitle());
		rm.write("<span"); // Start Title Text container
		rm.writeAttribute("id", oOH.getId() + "-title");
		rm.addClass("sapMOHTitle");
		if (oOH.getTitleActive()) {
			rm.addClass("sapMOHTitleActive");
		}
		if(oOH.getShowTitleSelector()){
			rm.addClass("sapMOHTitleFollowArrow");
		}
		rm.writeClasses();
		rm.write(">");	
		oOH._titleText.addStyleClass("sapMOHTitle");
		
		rm.renderControl(oOH._titleText);
		rm.write("</span>"); // End Title Text container
	}	
	
	if(oOH.getShowTitleSelector()){
		rm.write("<span"); // Start title arrow container				
		rm.addClass("sapMOHTitleArrow");
		rm.writeClasses();
		rm.write(">");
		rm.renderControl(oOH._oTitleArrowIcon);
		rm.write("</span>"); // end title arrow container	
	}
	
	if(oOH.getShowTitleSelector() && oOH._oTitleArrowIcon.getVisible()){
		rm.write("</div>"); // end title text and title arrow container	
	}
};

/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 * 
 * @param {sap.ui.core.RenderManager}
 *            rm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.m.Control}
 *            oOH an object representation of the control that should be rendered
 */
sap.m.ObjectHeaderRenderer.renderFullTitle = function(rm, oOH) {
	if (!oOH.getNumber()) {
		rm.addClass("sapMOHTitleDivFull");
	}
};

/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 * 
 * @param {sap.ui.core.RenderManager}
 *            rm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.m.Control}
 *            oOH an object representation of the control that should be rendered
 */
sap.m.ObjectHeaderRenderer.renderFullOH = function(rm, oOH) {
	// Introductory text at the top of the item, like "On behalf of Julie..."
	if (oOH.getIntro()) {
		rm.write("<div");
		rm.addClass("sapMOHIntro");
		if (oOH.getIntroActive()) {
			rm.addClass("sapMOHIntroActive");
		}
		rm.writeClasses();
		rm.write(">");
		rm.write("<span");
		rm.writeAttribute("id", oOH.getId() + "-intro");
		rm.write(">");
		rm.writeEscaped(oOH.getIntro());
		rm.write("</span>");
		rm.write("</div>");
	}

	// Container for fields placed on the top half of the item, below the intro. This
	// includes title icon, title, title arrow, number, and number units.
	rm.write("<div"); // Start Top row container
	rm.addClass("sapMOHTopRow");
	rm.writeClasses();
	rm.write(">");

	// Title container displayed to the left of the number and number units container.
	rm.write("<div"); // Start Title container
	rm.writeAttribute("id", oOH.getId() + "-titlediv");
	rm.addClass("sapMOHTitleDiv");
	if (oOH._hasIcon()) {
		rm.addClass("sapMOHTitleIcon");
	}
	
	this.renderFullTitle(rm, oOH);
	rm.writeClasses();
	rm.write(">");

	// Container for icon
	if (oOH._hasIcon()) {
		rm.write("<div"); // Start icon container
		rm.addClass("sapMOHIcon");
		if (oOH.getIconActive()) {
			rm.addClass("sapMPointer");
		}
		rm.writeClasses();
		rm.write(">");
		rm.renderControl(oOH._getImageControl());
		rm.write("</div>"); // end icon container
	}
	
	this.renderTitle(rm, oOH);
	
	rm.write("</div>"); // End Title container

	this.renderNumber(rm, oOH);
	
	rm.write("<div class=\"sapMOHDivider\"/>");
	rm.write("</div>"); // End Top row container

	if (oOH._hasBottomContent()) {
		rm.write("<div"); // Start Bottom row container
		rm.addClass("sapMOHBottomRow");
		rm.writeClasses();
		rm.write(">");

		this.renderAttributesAndStatuses(rm, oOH);

		rm.write("<div class=\"sapMOHDivider\"/>");
		rm.write("</div>"); // End Bottom row container
	}
};

/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 * 
 * @param {sap.ui.core.RenderManager}
 *            rm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.m.Control}
 *            oOH an object representation of the control that should be rendered
 */
sap.m.ObjectHeaderRenderer.renderCondensedOH = function(rm, oOH) {
	// Title container displayed to the left of the number and number units container.
	rm.write("<div"); // Start Title container
	rm.writeAttribute("id", oOH.getId() + "-titlediv");
	rm.addClass("sapMOHTitleDiv");
	
	this.renderFullTitle(rm, oOH);

	rm.writeClasses();
	rm.write(">");
	
	this.renderTitle(rm, oOH);
	
	rm.write("</div>"); // End Title container
	
	this.renderNumber(rm, oOH);
	
	var oFirstAttr = oOH.getAttributes()[0];
	
	if (oFirstAttr && !oFirstAttr._isEmpty()){
		this.renderAttribute(rm, oOH, oFirstAttr);
	}
};

/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 * 
 * @param {sap.ui.core.RenderManager}
 *            rm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.m.Control}
 *            oOH an object representation of the control that should be rendered
 */
sap.m.ObjectHeaderRenderer.render = function(rm, oOH) {

	// return immediately if control is invisible
	if (!oOH.getVisible()) {
		return;
	}

	var bCondensed = oOH.getCondensed();
	
	rm.write("<div"); // Start Main container
	rm.writeControlData(oOH);
	rm.addClass("sapMOH");
	if (bCondensed){
		rm.addClass("sapMOHC");
		rm.addClass("sapMOHBg" + oOH.getBackgroundDesign());
	}
	
	rm.writeClasses();
	var sTooltip = oOH.getTooltip_AsString();
	if (sTooltip) {
		rm.writeAttributeEscaped("title", sTooltip);
	}

	rm.write(">");

	if (bCondensed) {
		this.renderCondensedOH(rm, oOH);
	} else {
		this.renderFullOH(rm, oOH);
	}
	
	rm.write("<div class=\"sapMOHLastDivider\"/>");

	rm.write("</div>"); // End Main container\

};

}; // end of sap/m/ObjectHeaderRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.ObjectIdentifierRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare("sap.m.ObjectIdentifierRenderer");

/**
 * @class ObjectIdentifier renderer.
 * @static
 */
sap.m.ObjectIdentifierRenderer = {};

/**
 * Renders the HTML for the given control, using the provided
 * {@link sap.ui.core.RenderManager}.
 * 
 * @param {sap.ui.core.RenderManager}
 *            oRm the RenderManager that can be used for writing to the render
 *            output buffer
 * @param {sap.ui.core.Control}
 *            oOI an object representation of the control that should be
 *            rendered
 */
sap.m.ObjectIdentifierRenderer.render = function(oRm, oOI) {

	// write the HTML into the render manager
	oRm.write("<div"); // Identifier begins
	oRm.writeControlData(oOI);
	oRm.addClass("sapMObjectIdentifier");
	oRm.writeClasses();
	oRm.write(">");

	oRm.write("<div"); // Top row begins
	oRm.addClass("sapMObjectIdentifierTopRow");
	oRm.writeClasses();
	oRm.write(">");

	oRm.write("<div"); // Icons begin
	oRm.addClass("sapMObjectIdentifierIcons");
	oRm.writeClasses();
	oRm.write(">");

	if (oOI.getBadgeAttachments()) {
		oRm.write("<span"); // Icon span begins
		oRm.addClass("sapMObjectIdentifierIconSpan");
		oRm.writeClasses();
		oRm.write(">");
		oRm.renderControl(oOI._getAttachmentsIcon());
		oRm.write("</span>"); // Icon span ends
	}
	if (oOI.getBadgeNotes()) {
		oRm.write("<span"); // Icon span begins
		oRm.addClass("sapMObjectIdentifierIconSpan");
		oRm.writeClasses();
		oRm.write(">");
		oRm.renderControl(oOI._getNotesIcon());
		oRm.write("</span>"); // Icon span ends
	}
	if (oOI.getBadgePeople()) {
		oRm.write("<span"); // Icon span begins
		oRm.addClass("sapMObjectIdentifierIconSpan");
		oRm.writeClasses();
		oRm.write(">");
		oRm.renderControl(oOI._getPeopleIcon());
		oRm.write("</span>"); // Icon span ends
	}
	
	oRm.write("</div>"); // Icons end

	oRm.write("<div"); // Title begins
	oRm.addClass("sapMObjectIdentifierTitle");
	oRm.writeClasses();
	oRm.write(">");
	oRm.writeEscaped(oOI.getTitle());
	oRm.write("</div>"); // Title ends

	oRm.write("</div>"); // Top row ends

	oRm.write("<div"); // Text begins
	oRm.addClass("sapMObjectIdentifierText");
	oRm.writeClasses();
	oRm.write(">");
	oRm.writeEscaped(oOI.getText());
	oRm.write("</div>"); // Text ends

	oRm.write("</div>"); // Identifier ends
};

}; // end of sap/m/ObjectIdentifierRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.ObjectListItemRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare("sap.m.ObjectListItemRenderer");
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained



/**
 * @class ObjectListItem renderer.
 * @static
 */
sap.m.ObjectListItemRenderer = sap.ui.core.Renderer.extend(sap.m.ListItemBaseRenderer);

/**
 * Renders the HTML for single line of Attribute and Status.
 * 
 * @param {sap.ui.core.RenderManager}
 *            rm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.m.ObjectListItem}
 *            oLI an object to be rendered
 * @param {sap.m.ObjectAttribute}
 *            oAttribute an attribute to be rendered
 * @param {sap.m.ObjectStatus}
 *            oStatus a status to be rendered
 */
sap.m.ObjectListItemRenderer.renderAttributeStatus = function(rm, oLI, oAttribute, oStatus) {

	if (!oAttribute && !oStatus || (oAttribute && oAttribute._isEmpty() && oStatus && oStatus._isEmpty())) {
		return; // nothing to render
	}

	rm.write("<div"); // Start attribute row container
	rm.addClass("sapMObjLAttrRow");
	rm.writeClasses();
	rm.write(">");

	if (oAttribute && !oAttribute._isEmpty()) {
		rm.write("<div");
		rm.addClass("sapMObjLAttrDiv");
		
		// Add padding to push attribute text down since it will be raised up due
		// to markers height
		if (oStatus && (!oStatus._isEmpty())) {
			if(oStatus instanceof Array) {
				rm.addClass("sapMObjAttrWithMarker");
			}
		}
		
		rm.writeClasses();
		
		if (!oStatus || oStatus._isEmpty()) {
			rm.addStyle("width", "100%");
			rm.writeStyles();
		}
		rm.write(">");
		rm.renderControl(oAttribute);		
		rm.write("</div>");
	}

	if (oStatus && (!oStatus._isEmpty())) {
		rm.write("<div");		
		rm.addClass("sapMObjLStatusDiv");
		
		// Object marker icons (flag, favorite) are passed as an array
		if(oStatus instanceof Array) {
			rm.addClass("sapMObjStatusMarker");
		}
		rm.writeClasses();
		if (!oAttribute || oAttribute._isEmpty()) {
			rm.addStyle("width", "100%");
			rm.writeStyles();
		}
		rm.write(">");
		if(oStatus instanceof Array) {
			while(oStatus.length > 0) {
				rm.renderControl(oStatus.shift());
			}
		} else {
			rm.renderControl(oStatus);
		}		
		rm.write("</div>");
	}

	rm.write("</div>"); // Start attribute row container
};

/**
 * Renders the HTML for the given control, using the provided
 * {@link sap.ui.core.RenderManager}.
 * 
 * @param {sap.ui.core.RenderManager}
 *          oRenderManager the RenderManager that can be used for writing to the
 *          Render-Output-Buffer
 * @param {sap.ui.core.Control}
 *          oControl an object representation of the control that should be
 *          rendered
 */
sap.m.ObjectListItemRenderer.renderLIAttributes = function(rm, oLI) {
	rm.addClass("sapMObjLItem");
	rm.addClass("sapMObjLListModeDiv");
};

sap.m.ObjectListItemRenderer.renderLIContent = function(rm, oLI) {
	
	rm.write("<div"); // Start Main container
	rm.writeControlData(oLI);
	rm.write(">");

	// Introductory text at the top of the item, like "On behalf of Julie..."
	if(oLI.getIntro()) {
		rm.write("<div");
		rm.addClass("sapMObjLIntro");
		rm.writeClasses();
		rm.writeAttribute("id", oLI.getId() + "-intro");
		rm.write(">");
		rm.write("<span>");
		rm.writeEscaped(oLI.getIntro());
		rm.write("</span>");
		rm.write("</div>");
	}

	
	// Container for fields placed on the top half of the item, below the intro. This
	// includes title, number, and number units.
	rm.write("<div");  // Start Top row container     
	rm.addClass("sapMObjLTopRow");
	rm.writeClasses();
	rm.write(">");
	
	if(!!oLI.getIcon()) {
		rm.write("<div");
		rm.addClass("sapMObjLIconDiv");
		rm.writeClasses();
		rm.write(">");
		rm.renderControl(oLI._getImageControl());
		rm.write("</div>");
	}
	
	// Container for a number and a units qualifier.
	rm.write("<div"); // Start Number/units container
	rm.addClass("sapMObjLNumberDiv");
	rm.writeClasses();
	rm.write(">");
	
	if (oLI.getNumber()) {
		rm.write("<div");
		rm.writeAttribute("id", oLI.getId() + "-number");
		rm.addClass("sapMObjLNumber");
		rm.addClass("sapMObjLNumberState" + oLI.getNumberState());
		rm.writeClasses();
		
		rm.write(">");
		rm.writeEscaped(oLI.getNumber());
		rm.write("</div>");
		
		if (oLI.getNumberUnit()) {
			rm.write("<div");
			rm.writeAttribute("id", oLI.getId() + "-numberUnit");
			rm.addClass("sapMObjLNumberUnit");
			rm.addClass("sapMObjLNumberState" + oLI.getNumberState());
			rm.writeClasses();
			rm.write(">");
			rm.writeEscaped(oLI.getNumberUnit());
			rm.write("</div>");
		}
	}
	
	rm.write("</div>"); // End Number/units container
	
	// Title container displayed to the left of the number and number units container.
	rm.write("<div"); // Start Title container
	rm.addStyle("display","-webkit-box");
	rm.addStyle("overflow","hidden");
	rm.writeStyles();
	rm.write(">");
	var oTitleText = oLI._getTitleText();
	if (oTitleText) {
		oTitleText.setText(oLI.getTitle());
		oTitleText.addStyleClass("sapMObjLTitle");
		rm.renderControl(oTitleText);
	}
	
	rm.write("</div>"); // End Title container	
	
	rm.write("</div>"); // End Top row container
	
	rm.write('<div style="clear:both"/>');
	
	// Bottom row container.
	if(oLI._hasBottomContent()) {
		rm.write("<div"); // Start Bottom row container
		rm.addClass("sapMObjLBottomRow");
		rm.writeClasses();
		rm.write(">");

		var aAttribs = oLI._getVisibleAttributes();
		var statuses = new Array();
		var markers = null;
		
		if(oLI.getShowMarkers()) {
			var placeholderIcon = oLI._getPlaceholderIcon();
			var favIcon = oLI._getFavoriteIcon();
			var flagIcon = oLI._getFlagIcon();
			favIcon.setVisible(oLI.getMarkFavorite());
			flagIcon.setVisible(oLI.getMarkFlagged());
			
			//Markers will be rendered LTR in the order they're added to the array
			markers = [placeholderIcon, favIcon, flagIcon];
			statuses.push(markers);
			
			markers._isEmpty = function() {
				return false;
			};			
		}
		
		statuses.push(oLI.getFirstStatus());
		statuses.push(oLI.getSecondStatus());
		
		while(aAttribs.length > 0) {
			this.renderAttributeStatus(rm, oLI, aAttribs.shift(), statuses.shift());
		}
		
		while(statuses.length > 0) {
			this.renderAttributeStatus(rm, oLI, null, statuses.shift());
		}

		rm.write("</div>"); // End Bottom row container
	}
	rm.write("</div>"); // End Main container
};

}; // end of sap/m/ObjectListItemRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.ObjectNumberRenderer') ) {
/*
 * @copyright
 */

jQuery.sap.declare("sap.m.ObjectNumberRenderer");

/**
 * @class ObjectNumber renderer. 
 * @static
 */
sap.m.ObjectNumberRenderer = {
};


/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 * 
 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.m.ObjectNumberRenderer.render = function(oRm, oON){
	// return immediately if control is invisible
	if (!oON.getVisible()) {
		return;
	}

	// write the HTML into the render manager
	oRm.write("<div"); // Number begins
	oRm.writeControlData(oON);
	oRm.addClass("sapMObjectNumber");
	if (oON.getEmphasized()) {
		oRm.addClass("sapMObjectNumberEmph");
	}
	oRm.addClass(oON._sCSSPrefixObjNumberStatus + oON.getState());
	oRm.writeClasses();
	oRm.write(">");

	oRm.write("<span"); // Number text begins
	oRm.addClass("sapMObjectNumberText");
	oRm.writeClasses();
	oRm.write(">");
	oRm.writeEscaped(oON.getNumber()); 
	oRm.write("</span>"); // Number text ends

	oRm.write("<span"); // Number unit begins
	oRm.addClass("sapMObjectNumberUnit");
	oRm.writeClasses();
	oRm.write(">");
	
	var unit = oON.getUnit();
	if(!unit){
		unit = oON.getNumberUnit(); 
	}
	oRm.writeEscaped(unit);		
	oRm.write("</span>"); // Number unit ends

	oRm.write("</div>"); // Number ends
};

}; // end of sap/m/ObjectNumberRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.ObjectStatusRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare("sap.m.ObjectStatusRenderer");

/**
 * @class ObjectStatus renderer. 
 * @static
 */
sap.m.ObjectStatusRenderer = {
};


/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 * 
 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.m.ObjectStatusRenderer.render = function(oRm, oObjStatus){
	// Return immediately if control is invisible
	if (!oObjStatus.getVisible()) {
		return;
	}
	
	if(!oObjStatus._isEmpty()) {
		oRm.write("<div");
		oRm.writeControlData(oObjStatus);
		
		var sTooltip = oObjStatus.getTooltip_AsString();
		if (sTooltip) {
			oRm.writeAttributeEscaped("title", sTooltip);
		}
		
		oRm.addClass("sapMObjStatus"); 
		oRm.addClass("sapMObjStatus" + oObjStatus.getState());
		oRm.writeClasses();
		oRm.write(">");
				
		if (oObjStatus.getIcon()) {
			oRm.write("<span");
			oRm.addClass("sapMObjStatusIcon");
			oRm.writeClasses();
			oRm.write(">");
			oRm.renderControl(oObjStatus._getImageControl());
			oRm.write("</span>");
		}

		if (oObjStatus.getText()) {
			oRm.write("<span");
			oRm.addClass("sapMObjStatusText");
			oRm.writeClasses();
			oRm.write(">");
			oRm.writeEscaped(oObjStatus.getText());
			oRm.write("</span>");
		}
		oRm.write("</div>");			
	}
};
}; // end of sap/m/ObjectStatusRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.PageRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare("sap.m.PageRenderer");

/**
 * @class Page renderer.
 * @static
 */
sap.m.PageRenderer = {};

/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.m.PageRenderer.render = function(rm, oPage) {
	var oHeader = null,
		oFooter = null,
		sEnableScrolling = oPage.getEnableScrolling() ? " sapMPageScrollEnabled" : "";

	if (oPage.getShowHeader()) {
		oHeader = oPage._getAnyHeader();
	}

	var oSubHeader = oPage.getSubHeader();
	
	if (oPage.getShowFooter()){
		oFooter = oPage.getFooter();
	}
	rm.write("<div");
	rm.writeControlData(oPage);
	rm.addClass("sapMPage");

	rm.addClass("sapMPageBg" + oPage.getBackgroundDesign());
	
	if (oHeader) {
		rm.addClass("sapMPageWithHeader");
	}

	if (oSubHeader) {
		rm.addClass("sapMPageWithSubHeader");
	}

	if (oFooter) {
		// it is used in the PopOver to remove additional margin bottom for page with footer
		rm.addClass("sapMPageWithFooter");
	}

	rm.writeClasses();

	var sTooltip = oPage.getTooltip_AsString();

	if (sTooltip) {
		rm.writeAttributeEscaped("title", sTooltip);
	}

	rm.write(">");

	// render header
	if (oHeader) {
		rm.renderControl(oHeader);
	}

	if (oSubHeader) {
		oSubHeader._context = 'header';
		rm.renderControl(oSubHeader.addStyleClass("sapMSubHeader-CTX sapMPageSubHeader"));
	}

	// render child controls
	rm.write('<section id="' + oPage.getId() + '-cont">');
	rm.write('<div id="' + oPage.getId() + '-scroll" class="sapMPageScroll' + sEnableScrolling + '">');

	var aContent = oPage.getContent();
	var l = aContent.length;

	for (var i = 0; i < l; i++) {
		rm.renderControl(aContent[i]);
	}

	rm.write("</div>");

	rm.write("</section>");

	// render footer Element
	if (oFooter) {
		oFooter._context = 'footer';
		rm.renderControl(oFooter);
	}

	rm.write("</div>");
};
}; // end of sap/m/PageRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.PanelRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare("sap.m.PanelRenderer");

/**
 * @class Panel renderer
 * @static
 */
sap.m.PanelRenderer = {};

/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.m.PanelRenderer.render = function(oRm, oControl) {
	// Return immediately if control is invisible
	if (!oControl.getVisible()) {
		return;
	}

	// start Panel
	oRm.write("<section");
	oRm.writeControlData(oControl);
	oRm.addClass("sapMPanel");
	oRm.addStyle("width", oControl.getWidth());
	oRm.addStyle("height", oControl.getHeight());
	oRm.writeClasses();
	oRm.writeStyles();
	oRm.write(">");

	// render header
	var sHeaderText = oControl.getHeaderText();
	var oHeaderTBar = oControl.getHeaderToolbar();
	if (oHeaderTBar) {
		oHeaderTBar.setDesign(sap.m.ToolbarDesign.Transparent, true);
		oRm.renderControl(oHeaderTBar);
	} else if (sHeaderText) {
		oRm.write("<div class='sapMPanelHdr'>");
		oRm.writeEscaped(sHeaderText);
		oRm.write("</div>");
	}

	// render info bar
	var oInfoTBar = oControl.getInfoToolbar();
	if (oInfoTBar) {
		oInfoTBar.setDesign(sap.m.ToolbarDesign.Info, true);
		oRm.renderControl(oInfoTBar);
	}

	// render content
	oRm.write("<div");
	oRm.addClass("sapMPanelContent");
	oRm.addClass("sapMPanelBG");
	oRm.writeClasses();
	oRm.write(">");
	var aChildren = oControl.getContent();
	var iLength = aChildren.length;
	for (var i = 0; i < iLength; i++) {
		oRm.renderControl(aChildren[i]);
	}
	oRm.write("</div>");
	oRm.write("</section>");
};
}; // end of sap/m/PanelRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.PopoverRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare("sap.m.PopoverRenderer");

/**
 * @class Popover renderer. 
 * @static
 */
sap.m.PopoverRenderer = {
};


/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 * 
 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.m.PopoverRenderer.render = function(rm, oControl){ 
	var aClassNames,
		oSubHeader = oControl.getSubHeader();
	
	if(oSubHeader){
		oSubHeader._context = "header";
	}
	
	//container
	rm.write("<div");
	rm.writeControlData(oControl);

	aClassNames= this.generateRootClasses(oControl);
	aClassNames.forEach(function(sClassName, index){
		rm.addClass(sClassName);
	});
	rm.writeClasses();
	
	var sTooltip = oControl.getTooltip_AsString();
	if (sTooltip) {
		rm.writeAttributeEscaped("title", sTooltip);
	}
	rm.writeAttribute("tabindex", "-1");

	rm.write(">");

	this.renderContent(rm, oControl);

	rm.write("</div>");// container
};

sap.m.PopoverRenderer.isButtonFooter = function(footer){
	if(footer instanceof sap.m.Bar){
		var aContentLeft = footer.getContentLeft(),
			aContentRight = footer.getContentRight(),
			aContentMiddle = footer.getContentMiddle(),
			bLeftEmpty = (!aContentLeft || aContentLeft.length === 0),
			bRightEmpty = (!aContentRight || aContentRight.length === 0),
			bMiddleTwoButtons = false;

		if(aContentMiddle && aContentMiddle.length ===2){
			if((aContentMiddle[0] instanceof sap.m.Button) && (aContentMiddle[1] instanceof sap.m.Button)){
				bMiddleTwoButtons = true;
			}
		}
		
		return bLeftEmpty && bRightEmpty && bMiddleTwoButtons;
	}else{
		return false;
	}
};

sap.m.PopoverRenderer.renderContent = function(rm, oControl){
	var oHeaderControl,
		sId = oControl.getId(),
		i = 0,
		contents = oControl.getContent(),
		oFooter = oControl.getFooter(),
		oSubHeader = oControl.getSubHeader(),
		sContentWidth = oControl.getContentWidth(),
		sContentHeight = oControl.getContentHeight(),
		sFooterClass = "sapMPopoverFooter ";
	
	if(oControl.getShowHeader()){
		oHeaderControl = oControl._getAnyHeader();
	}
	
	if(sap.ui.Device.system.desktop) {
		//Invisible element for cycling keyboard navigation
		rm.write("<span id='" + oControl.getId() + "-firstfe' tabindex='0'></span>");
	}

	if(!sap.ui.Device.os.ios && !sap.m.Popover._bOneDesign){
		//arrow
		rm.write("<span");
		rm.writeAttribute("id", sId+"-arrow");
		rm.addClass("sapMPopoverArr");
		rm.writeClasses();
		rm.write("></span>");//arrow tip
	}

	//header
	if(oHeaderControl){
		rm.renderControl(oControl._getAnyHeader().addStyleClass("sapMPopoverHeader sapMPageHeader"));
	}//header
	
	if(oSubHeader){
		rm.renderControl(oSubHeader.addStyleClass("sapMPopoverSubHeader"));
	}
	
	// content container
	rm.write("<div");
	rm.writeAttribute("id",sId + "-cont");
	if(sContentWidth){
		rm.addStyle("width",sContentWidth);
	}
	if(sContentHeight){
		rm.addStyle("height",sContentHeight);
	}
	rm.writeStyles();
	rm.addClass("sapMPopoverCont");
	rm.writeClasses();
	rm.write(">");
	
	//scroll area
	rm.write("<div id='" + oControl.getId() + "-scroll" +"' class='sapMPopoverScroll " +"'>");
	for(i = 0 ; i < contents.length ; i++){
		rm.renderControl(contents[i]);
	}
	rm.write("</div>");//scrollArea
	
	rm.write("</div>");//content container
	
	//footer
	if (oFooter) {
		oFooter._context = 'footer';
		if(this.isButtonFooter(oFooter)){
			sFooterClass += "sapMPopoverSpecialFooter";
		}
		rm.renderControl(oFooter.addStyleClass(sFooterClass));
	}//footer
	
	if(sap.ui.Device.os.ios || sap.m.Popover._bOneDesign){
		//arrow
		rm.write("<span");
		rm.writeAttribute("id", sId+"-arrow");
		rm.addClass("sapMPopoverArr");
		rm.writeClasses();
		rm.write("></span>");//arrow tip
	}

	if(sap.ui.Device.system.desktop) {
		//Invisible element for desktop keyboard navigation
		rm.write("<span id='" + oControl.getId() + "-lastfe' tabindex='0'></span>");
	}
};

sap.m.PopoverRenderer.generateRootClasses = function(oControl){
	var aClassNames = ["sapMPopover"],
		oSubHeader = oControl.getSubHeader(),
		oFooter = oControl.getFooter(),
		bVerScrollable = oControl.getVerticalScrolling() && !oControl._forceDisableScrolling,
		bHorScrollable = oControl.getHorizontalScrolling() && !oControl._forceDisableScrolling,
		oHeaderControl;
	
	if(oControl.getShowHeader()){
		oHeaderControl = oControl._getAnyHeader();
	}
	
	if(oHeaderControl){
		aClassNames.push("sapMPopoverWithBar");
	}else{
		aClassNames.push("sapMPopoverWithoutBar");
	}
	
	if(oSubHeader){
		aClassNames.push("sapMPopoverWithSubHeader");
	}else{
		aClassNames.push("sapMPopoverWithoutSubHeader");
	}
	
	if(oControl._hasSingleNavContent()){
		aClassNames.push("sapMPopoverNav");
	}
	
	if(oControl._hasSinglePageContent()){
		aClassNames.push("sapMPopoverPage");
	}
	if(oFooter){
		aClassNames.push("sapMPopoverWithFooter");
	}else{
		aClassNames.push("sapMPopoverWithoutFooter");
	}
	
	if(oControl.getPlacement() === sap.m.PlacementType.Top){
		aClassNames.push("sapMPopoverPlacedTop");
	}
	if(!bVerScrollable) {
		aClassNames.push("sapMPopoverVerScrollDisabled");
	}
	if(!bHorScrollable) {
		aClassNames.push("sapMPopoverHorScrollDisabled");
	}
	
	aClassNames.push("sapMPopup-CTX");
	
	return aClassNames;
};

sap.m.PopoverRenderer.rerenderContentOnly = function(oControl){
	var $Popover = oControl.$(),
		oPopoverDomRef = oControl.getDomRef(),
		aClassNames, oRm;

	if(!oPopoverDomRef){
		//popover isn't rendered yet, just return
		return;
	}

	$Popover.removeClass();
	aClassNames = this.generateRootClasses(oControl);
	$Popover.addClass(aClassNames.join(" "));

	oRm = sap.ui.getCore().createRenderManager();
	this.renderContent(oRm, oControl);

	oRm.flush(oPopoverDomRef, true);
	oRm.destroy();

	//recalculate the size and position of popover
	oControl._onOrientationChange();
};
}; // end of sap/m/PopoverRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.ProgressIndicatorRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare("sap.m.ProgressIndicatorRenderer");

/**
 * @class ProgressIndicator renderer.
 * @static
 */
sap.m.ProgressIndicatorRenderer = {};

/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.m.ProgressIndicatorRenderer.render = function(oRm, oC) {

	// return immediately if control is not visible
	if (!oC.getVisible()) {
		return;
	}

	var fWidthBar = oC.getPercentValue();
	var iWidthControl = oC.getWidth();
	var iHeightControl = oC.getHeight();
	var sTextValue = oC.getDisplayValue();
	var bShowText = oC.getShowValue();
	var sState = oC.getState();

	// write the HTML into the render manager
	//PI border
	oRm.write("<div");
	oRm.writeControlData(oC);
	oRm.addClass("sapMPI");
	if (fWidthBar > 50) {
		oRm.addClass("sapMPIValueGreaterHalf");
	}
	oRm.writeAttribute("style", "width:" + iWidthControl + "; height:" + iHeightControl);

	if (oC.getEnabled()) {
		oRm.writeAttribute('tabIndex', '-1');
	} else {
		oRm.addClass("sapMPIBarDisabled");
	}
	oRm.writeClasses();
	oRm.write(">"); // div element

	//PI bar
	oRm.write("<div");
	oRm.addClass("sapMPIBar");

	switch (sState) {
	case sap.ui.core.ValueState.Warning:
		oRm.addClass("sapMPIBarCritical");
		break;
	case sap.ui.core.ValueState.Error:
		oRm.addClass("sapMPIBarNegative");
		break;
	case sap.ui.core.ValueState.Success:
		oRm.addClass("sapMPIBarPositive");
		break;
	case sap.ui.core.ValueState.None:
		oRm.addClass("sapMPIBarNeutral");
		break;
	default:
		oRm.addClass("sapMPIBarNeutral");
		break;
	}

	oRm.writeClasses();
	oRm.writeAttribute("id", oC.getId() + "-bar");
	oRm.writeAttribute("style", "width:" + fWidthBar + "%");
	oRm.write(">"); // div element

	//PI textLeft
	oRm.write("<span class='sapMPIText sapMPITextLeft' id='" + oC.getId() + "-textLeft'>");
	
	//textvalue is only showed if showValue set
	if (bShowText) {
		oRm.writeEscaped(sTextValue);
	}

	oRm.write("</span>");
	oRm.write("</div>"); // div element pi bar
	
	//PI textRight
	oRm.write("<span class='sapMPIText sapMPITextRight' id='" + oC.getId() + "-textRight'>");

	//textvalue is only showed if showValue set
	if (bShowText) {
		oRm.writeEscaped(sTextValue);
	}
	oRm.write("</span>");

	oRm.write("</div>"); //div element pi text
};

}; // end of sap/m/ProgressIndicatorRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.PullToRefreshRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare("sap.m.PullToRefreshRenderer");
jQuery.sap.require('sap.ui.core.IconPool'); // unlisted dependency retained
 // TODO: consider making this conditional 
sap.ui.core.IconPool.insertFontFaceStyle();

/**
 * @class PullToRefresh renderer. 
 * @static
 */
sap.m.PullToRefreshRenderer = {
};

/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 * 
 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.m.PullToRefreshRenderer.render = function(oRm, oControl){

	// do not render invisible P2R
	if(!oControl.getVisible()) return;
	
	var bShowIcon = oControl.getShowIcon();
	var sCustomIcon = oControl.getCustomIcon();

	oRm.write("<div");
	oRm.writeControlData(oControl);
	oRm.addClass("sapMPullDown");
	if (!oControl._bTouchMode) {
		oRm.addClass("sapMPullDownNontouch");
	} else {
		oRm.addClass("sapMPullDownTouch");
	}
	if(bShowIcon && !sCustomIcon){ // if no custom icon is provided, use SAP logo as background
		oRm.addClass("sapMPullDownLogo");
	}
	oRm.writeClasses();
	oRm.write(">"); // div element

	if(bShowIcon && sCustomIcon){
		var oCustomImage = oControl.getCustomIconImage();
		if(oCustomImage){
			oRm.write("<div class=\"sapMPullDownCI\">");
			oRm.renderControl(oCustomImage);
			oRm.write("</div>");
		}
	}

	// Pull down arrow icon
	oRm.write("<span class=\"sapMPullDownIcon\"></span>");

	// Busy Indicator
	oRm.write("<span class=\"sapMPullDownBusy\">");
	oRm.renderControl(oControl._oBusyIndicator);
	oRm.write("</span>");

	// Text - Pull down to refresh
	oRm.write("<span id=" + oControl.getId() + "-T class=\"sapMPullDownText\">");
	oRm.writeEscaped(oControl.oRb.getText(oControl._bTouchMode ? "PULL2REFRESH_PULLDOWN" : "PULL2REFRESH_REFRESH"));
	oRm.write("</span>");

	// Info - last updated at xx:xx:xx
	oRm.write("<span id=" + oControl.getId() + "-I class=\"sapMPullDownInfo\">");
	oRm.writeEscaped(oControl.getDescription());
	oRm.write("</span>");

	oRm.write("</div>");
};

}; // end of sap/m/PullToRefreshRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.RadioButtonRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare("sap.m.RadioButtonRenderer");
jQuery.sap.require('sap.ui.core.ValueStateSupport'); // unlisted dependency retained


/**
 * @class RadioButton renderer.
 * @static
 */
sap.m.RadioButtonRenderer = {
};

/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.core.Control} oRadioButton an object representation of the control that should be rendered
 */
sap.m.RadioButtonRenderer.render = function(oRm, oRadioButton){
	// Return immediately if control is invisible
	if (!oRadioButton.getVisible()) {
		return;
	}

	// get control properties
	var bEnabled = oRadioButton.getEnabled();
	var iTabIndex = bEnabled ? 0 : -1;
	var bReadOnly = false;

	// Radio Button style class
	oRm.addClass("sapMRb");

	if(bEnabled) {
		oRm.addClass("sapMPointer");
	}

	// write the HTML into the render manager
	oRm.write("<div");						// Control - DIV
	oRm.writeControlData(oRadioButton);

	// ARIA
	oRm.writeAccessibilityState(oRadioButton, {
		role: "radio",
		checked: oRadioButton.getSelected() === true,
		disabled: !bEnabled
	});

	// Add classes and properties depending on the state
	if (oRadioButton.getSelected()) {
		oRm.addClass("sapMRbSel");
	}

	if (!bEnabled) {
		bReadOnly = true;
		oRm.addClass("sapMRbDis");
	}

	oRm.writeClasses();
	oRm.writeAttribute("tabIndex", "-1");

	var sTooltip = sap.ui.core.ValueStateSupport.enrichTooltip(oRadioButton, oRadioButton.getTooltip_AsString());
	if (sTooltip) {
		oRm.writeAttributeEscaped("title", sTooltip);
	}

	oRm.write(">");		// DIV element

	oRm.write("<div class='sapMRbB'");

	//set an id on this this to be able to focus it, on ApplyFocusInfo (rerenderAllUiAreas)
	oRm.writeAttribute("id", oRadioButton.getId() + "-Button");

	oRm.writeAttribute("tabindex", oRadioButton.hasOwnProperty("_iTabIndex") ? oRadioButton._iTabIndex : iTabIndex);
	oRm.write(">");

	oRm.write("<div");
	oRm.addClass("sapMRbBOut");

	if(bEnabled && sap.ui.Device.system.desktop) {
		oRm.addClass("sapMRbHoverable");
	}

	oRm.writeAttribute("id", oRadioButton.getId() + "-out");
	oRm.writeAttribute("tabindex", oRadioButton.hasOwnProperty("_iTabIndex") ? oRadioButton._iTabIndex : iTabIndex);
	oRm.writeClasses();
	oRm.write(">");		// DIV element
	oRm.write("<div");
	oRm.addClass("sapMRbBInn");
	oRm.writeClasses();
	oRm.write(">");		// DIV element

	// Write the real - potentially hidden - HTML RadioButton element
	oRm.write("<input type='radio' tabindex='-1'");
	oRm.writeAttribute("id", oRadioButton.getId() + "-RB");
	oRm.writeAttributeEscaped("name", oRadioButton.getGroupName());
	if (oRadioButton.getSelected()) {
		oRm.writeAttribute("checked", "checked");
	}
	if (!bEnabled) {
		oRm.writeAttribute("disabled", "disabled");
	}
	//oRm.writeAttributeEscaped("title", oRadioButton.getTooltip_AsString());
	if(bReadOnly) {
		oRm.writeAttribute("readonly", "readonly");
		oRm.writeAttribute("disabled", "disabled");
	}
	oRm.write(" />");	// Close RadioButton-input-element
//	if(sap.ui.Device.os.android || sap.ui.Device.os.blackberry) {
		oRm.write("</div></div>");	// Control - DIVs close
//	}
	oRm.write("</div>");
	oRm.renderControl(oRadioButton._oLabel);
	oRm.write("</div>");	// Control - DIVs close
};

}; // end of sap/m/RadioButtonRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.RatingIndicatorRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare("sap.m.RatingIndicatorRenderer");
jQuery.sap.require('sap.ui.core.theming.Parameters'); // unlisted dependency retained


/* =========================================================== */
/*           temporary flags for jslint syntax check           */
/* =========================================================== */
/*jslint nomen: false */

/**
 * @class RatingIndicator renderer.
 * @static
 */
sap.m.RatingIndicatorRenderer = {
};

/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.m.RatingIndicatorRenderer.render = function (oRm, oControl) {

	var fRatingValue = oControl._roundValueToVisualMode(oControl.getValue()),
		iSymbolCount = oControl.getMaxValue(),
		fIconSize = oControl._iPxIconSize,
		fIconPadding = oControl._iPxPaddingSize,
		sIconSizeMeasure = 'px',
		iSelectedWidth = fRatingValue * fIconSize + (Math.round(fRatingValue) - 1) * fIconPadding,
		iWidth = iSymbolCount * (fIconSize + fIconPadding) - fIconPadding,
		oIconSel,
		oIconUnsel,
		oIconHov,
		i = 0,
		sTooltip = oControl.getTooltip_AsString();

	// return immediately if control is invisible
	if (!oControl.getVisible()) {
		return;
	}

	if (iSelectedWidth < 0) { //width should not be negative
		iSelectedWidth = 0;
	}

	// render the control container div
	oRm.write("<div");
	oRm.writeControlData(oControl);
	oRm.writeAttribute("style", "width: " + iWidth + sIconSizeMeasure);
	if (!oControl.getEnabled()) {
		oRm.writeAttribute("tabindex", "-1");
	} else {
		oRm.writeAttribute("tabindex", "0");
	}
	oRm.addClass("sapMRI");
	if (oControl.getEnabled()) {
		oRm.addClass("sapMPointer");
	} else {
		oRm.addClass("sapMRIDisabled");
	}
	oRm.writeClasses();
	// add tooltip if available
	if (sTooltip) {
		oRm.writeAttributeEscaped("title", sTooltip);
	}	
	oRm.write(">");
	

	// render selected items div
	oRm.write("<div class='sapMRISel'");
	oRm.writeAttribute("id", oControl.getId() + "-sel");
	oRm.writeAttribute("style", "width: " + iSelectedWidth + sIconSizeMeasure);
	oRm.write(">");
	// for defined count of icons, create selected icons with oControl._getIcon(0)
	for (i = 0; i < iSymbolCount; i++) {
		oIconSel = oControl._getIcon(0);
		//check if icon is icon or image
		if (oIconSel instanceof sap.ui.core.Icon) {
			oIconSel.setSize(fIconSize +sIconSizeMeasure);
		}
		// always set width and height because icon fonts can have different dimensions
		oIconSel.setWidth(fIconSize + sIconSizeMeasure);
		oIconSel.setHeight(fIconSize + sIconSizeMeasure);

		oIconSel.addStyleClass("sapMRIIconSel");
		oRm.renderControl(oIconSel);
	}
	oRm.write("</div>");

	// render unselected items div (container and relative child)
	oRm.write("<div class='sapMRIUnselWrapper'");
	oRm.writeAttribute("id", oControl.getId() + "-unsel-wrapper");
	oRm.writeAttribute("style", "width: " + (iWidth - iSelectedWidth) + sIconSizeMeasure);
	oRm.write(">");
	oRm.write("<div class='sapMRIUnsel' id='" + oControl.getId() + "-unsel'>");
	// for defined count of icons, create unselected icons with oControl._getIcon(1)
	for (i = 0; i < iSymbolCount; i++) {
		oIconUnsel = oControl._getIcon(1);
		//check if icon is icon or image
		if (oIconUnsel instanceof sap.ui.core.Icon) {
			oIconUnsel.setSize(fIconSize + sIconSizeMeasure);
		}
		// always set width and height because icon fonts can have different dimensions
		oIconUnsel.setWidth(fIconSize + sIconSizeMeasure);
		oIconUnsel.setHeight(fIconSize + sIconSizeMeasure);

		oIconUnsel.addStyleClass("sapMRIIconUnsel");
		if (fIconSize <= 1) {
			oIconUnsel.addStyleClass("sapMRIIconUnselSmall");
		}
		oRm.renderControl(oIconUnsel);
	}
	oRm.write("</div>");
	oRm.write("</div>");

	// render hovered item div
	if (oControl.getEnabled()) {
		oRm.write("<div class='sapMRIHov' id='" + oControl.getId() + "-hov'>");
		// for defined count of icons, create hovered icons with oControl._getIcon(2)
		for (i = 0; i < iSymbolCount; i++) {
			oIconHov = oControl._getIcon(2);
			//check if icon is icon or image
			if (oIconHov instanceof sap.ui.core.Icon) {
				oIconHov.setSize(fIconSize + sIconSizeMeasure);
			}
			// always set width and height because icon fonts can have different dimensions
			oIconHov.setWidth(fIconSize + sIconSizeMeasure);
			oIconHov.setHeight(fIconSize + sIconSizeMeasure);

			oIconHov.addStyleClass("sapMRIIconHov");
			oRm.renderControl(oIconHov);
		}
		oRm.write("</div>");

		// render selector items div
		oRm.write("<div class='sapMRISelector' id='" + oControl.getId() + "-selector'>");
		oRm.write("</div>");
	}

	// close control div
	oRm.write("</div>");
};
}; // end of sap/m/RatingIndicatorRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.ResponsivePopoverRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare("sap.m.ResponsivePopoverRenderer");

/**
 * @class ResponsivePopover renderer.
 * @static
 */
sap.m.ResponsivePopoverRenderer = {
};

/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.m.ResponsivePopoverRenderer.render = function (oRm, oControl) {
};
}; // end of sap/m/ResponsivePopoverRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.ScrollContainerRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare("sap.m.ScrollContainerRenderer");

/**
 * @class ScrollContainer renderer. 
 * @static
 */
sap.m.ScrollContainerRenderer = {
};


/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 * 
 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.m.ScrollContainerRenderer.render = function(oRm, oControl) { 
	// return immediately if control is invisible
	if (!oControl.getVisible()) {
		return;
	}

	oRm.write("<div");
	oRm.writeControlData(oControl);

	var width = oControl.getWidth(),
	height = oControl.getHeight();
	if (width) {
		oRm.addStyle("width", width);
	}
	if (height) {
		oRm.addStyle("height", height);
	}
	oRm.writeStyles();

	if (oControl.getVertical()) {
		if (!oControl.getHorizontal()) {
			oRm.addClass("sapMScrollContV");
		} else {
			oRm.addClass("sapMScrollContVH");
		}
	} else if (oControl.getHorizontal()) {
		oRm.addClass("sapMScrollContH");
	}

	oRm.addClass("sapMScrollCont");
	oRm.writeClasses();
	
	var sTooltip = oControl.getTooltip_AsString();
	if (sTooltip) {
		oRm.writeAttributeEscaped("title", sTooltip);
	}
	
	oRm.write("><div id='" + oControl.getId() + "-scroll' class='sapMScrollContScroll'>");

	// render child controls
	var aContent = oControl.getContent(), 
	l = aContent.length;
	for (var i = 0; i < l; i++) {
		oRm.renderControl(aContent[i]);
	}

	oRm.write("</div></div>");
};

}; // end of sap/m/ScrollContainerRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.SearchFieldRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare("sap.m.SearchFieldRenderer");

/**
 * @class SearchField renderer.
 * @static
 */
sap.m.SearchFieldRenderer = {
};

/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.m.SearchFieldRenderer.render = function(oRenderManager, oSF){
	// render nothing if control is invisible
	if (!oSF.getVisible()) {
		return;
	}

	var rm = oRenderManager;
	var bShowMagnifier = oSF.getShowMagnifier();
	var sPlaceholder = oSF.getPlaceholder();
	var sValue = oSF.getValue();
	var sWidth = oSF.getProperty("width");

	// container
	rm.write("<div");
	rm.writeControlData(oSF);
	if (sWidth) { rm.writeAttribute("style", "width:" + sWidth + ";"); }

	rm.addClass("sapMSF");
	if (bShowMagnifier) { rm.addClass("sapMSFM"); }
	if(sap.ui.Device.os.android && !(sap.ui.Device.browser.chrome)){
		if(sap.ui.Device.os.version < 3){
			rm.addClass("sapMSFA2"); // specific Android 2.+ rendering
		} else if (sap.ui.Device.os.version <= 4){
			rm.addClass("sapMSFA4"); // specific Android 4.0* rendering
		}
	}
	if(sValue){
		rm.addClass("sapMSFVal");
	}
	if (!oSF.getEnabled()){
		rm.addClass("sapMSFDisabled");
	}
	rm.writeClasses();
	var sTooltip = oSF.getTooltip_AsString();
	if (sTooltip) {
		rm.writeAttributeEscaped("title", sTooltip);
	}
	rm.write(">");

	if(oSF._sDesign){
		this.renderBcd(rm, oSF, bShowMagnifier, sPlaceholder, sValue);
	} else {
		this.renderMvi(rm, oSF, bShowMagnifier, sPlaceholder, sValue);
	}

	rm.write("</div>");

};

/**
 * Render MVI style (platform dependent, magnifier to the left, no button)
 */
sap.m.SearchFieldRenderer.renderMvi = function(rm, oSF, bShowMagnifier, sPlaceholder, sValue){

	var sId = oSF.getId();

	// 1. magnifier icon
	if (bShowMagnifier) { rm.write('<div class="sapMSFMG"></div>'); }

	// 2. Input type="search".
	//    Enclose input into a <form> to show a correct keyboard
	//    method="post" to prevent unneeded "?" at the end of URL
	rm.write('<form method="post" action="javascript:void(0);">');

	// self-made placeholder
	if (!oSF._hasPlacehoder && sPlaceholder) {
		rm.write("<label ");
		rm.writeAttribute("id", sId + "-P");
		rm.writeAttribute("for", sId + "-I");

		rm.addClass("sapMSFPlaceholder");
		rm.writeClasses();
		rm.write(">");
		rm.writeEscaped(sPlaceholder);
		rm.write("</label>");
	}

	rm.write('<input type="search" autocorrect="off"');
	rm.writeAttribute("id", oSF.getId() + "-I");

	rm.addClass("sapMSFI");

	if (sap.ui.Device.os.ios && sap.ui.Device.os.version > 5) {
			rm.addClass("sapMSFIIos6"); // specific Ios6+ rendering
	}

	if (!oSF.getEnabled()){
		// hide the reset button even if value is not empty: user cannot press it
		rm.addClass("sapMSFIDisabled");
	}
	rm.writeClasses();

	if (!oSF.getEnabled()) { rm.writeAttribute("disabled","disabled"); }
	if (bShowMagnifier) { rm.writeAttribute("results", 0); }
	if (sPlaceholder) { rm.writeAttributeEscaped("placeholder", sPlaceholder); }
	if (oSF.getMaxLength()) { rm.writeAttribute("maxLength", oSF.getMaxLength()); }
	if (sValue) { rm.writeAttributeEscaped("value", sValue); }

	rm.write("></form>");

	// 3. Reset button (transparent, lies over "X" of input, reacts on touch correctly)
	// in sap_bluecrystal: x is placed on the reset button
	if (oSF.getEnabled()) {
		rm.write("<div");
		rm.writeAttribute("id", oSF.getId() + "-reset");
		rm.addClass("sapMSFR");
		rm.writeClasses();
		rm.write("></div>");
	}
}; // render MVI

/**
 * Render blue-crystal design (platform independent, magnifier to the right, with the button)
 */
sap.m.SearchFieldRenderer.renderBcd = function(rm, oSF, bShowMagnifier, sPlaceholder, sValue){

	var sId = oSF.getId();

	// 1. extra block around input form
	rm.write('<div');
	rm.addClass('sapMSFB');
	if(oSF.getShowRefreshButton() && !oSF.getValue()){
		rm.addClass('sapMSFReload');
	}
	if(oSF._bNoFlex){
		rm.addClass('sapMSFNoFlex');
	}
	rm.writeClasses();
	rm.write('>');

	// 2. Input type="search".
	//    Enclose input into a <form> to show a correct keyboard
	//    method="post" to prevent unneeded "?" at the end of URL
	rm.write('<form method="post" action="javascript:void(0);">');

	// self-made placeholder
	if (!oSF._hasPlacehoder && sPlaceholder) {
		rm.write("<label ");
		rm.writeAttribute("id", sId + "-P");
		rm.writeAttribute("for", sId + "-I");

		rm.addClass("sapMSFPlaceholder");
		rm.writeClasses();
		rm.write(">");
		rm.writeEscaped(sPlaceholder);
		rm.write("</label>");
	}

	rm.write('<input type="search" autocorrect="off"');
	rm.writeAttribute("id", oSF.getId() + "-I");

	rm.addClass("sapMSFI");

	if(sap.ui.Device.os.android && sap.ui.Device.os.version >= 4 && sap.ui.Device.os.version < 4.1 ){
		rm.addClass("sapMSFIA4"); // specific CSS layout for Android 4.0x
	}

	if (!oSF.getEnabled()){
		// hide the reset button even if value is not empty: user cannot press it
		rm.addClass("sapMSFIDisabled");
	}
	rm.writeClasses();

	if (!oSF.getEnabled()) { rm.writeAttribute("disabled","disabled"); }
	//if (bShowMagnifier) { rm.writeAttribute("results", 0); }
	if (sPlaceholder) { rm.writeAttributeEscaped("placeholder", sPlaceholder); }
	if (oSF.getMaxLength()) { rm.writeAttribute("maxLength", oSF.getMaxLength()); }
	if (sValue) { rm.writeAttributeEscaped("value", sValue); }
	rm.write(">");

	// 3. Reset button (transparent, lies over "X" of input, reacts on touch correctly)
	// in sap_bluecrystal: x is placed on the reset button
	if (oSF.getEnabled()) {
		rm.write("<div");
		rm.writeAttribute("id", oSF.getId() + "-reset");
		rm.addClass("sapMSFR");
		rm.writeClasses();
		rm.write("></div>");
	}

	rm.write("</form>");

	if(oSF._oButton){
		rm.renderControl(oSF._oButton);
	}

	rm.write("</div>"); // extra block
}; // render BC
}; // end of sap/m/SearchFieldRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.SegmentedButtonRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare("sap.m.SegmentedButtonRenderer");

/**
 * @class Segmented renderer. 
 * @static
 */
sap.m.SegmentedButtonRenderer = {
};


/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 * 
 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.m.SegmentedButtonRenderer.render = function(rm, oControl){ 
	// return immediately if control is invisible
	if (!oControl.getVisible()) {
		return;
	}

	var aItems = oControl.getButtons(),
	aItemsLength = aItems.length;
	if(!oControl.getVisible()) {
		return;
	}
	// write the HTML into the render manager
	rm.write("<ul");
	rm.addClass("sapMSegB");
	rm.addClass("sapMSegBHide");
	rm.writeClasses();
	if (oControl.getWidth() && oControl.getWidth() !== '') {
		rm.addStyle('width', oControl.getWidth());
	}
	rm.writeStyles();
	rm.writeControlData(oControl);
	var sTooltip = oControl.getTooltip_AsString();
	if (sTooltip) {
		rm.writeAttributeEscaped("title", sTooltip);
	}
	rm.write(">");
	
	if(!oControl.getSelectedButton()) {
		if(aItems.length > 0)
			oControl.setSelectedButton(aItems[0].getId(), true);
	}
	
	for (var i = 0; i < aItemsLength; i++) {
		var oItem = aItems[i];
		
		rm.write("<li");
		rm.writeControlData(oItem);
		rm.addClass("sapMSegBBtn");
		if(oControl.getSelectedButton() === oItem.getId()) {
			rm.addClass("sapMSegBBtnSel");
		}
		if(!oItem.getEnabled()) {
			rm.addClass("sapMSegBBtnDis");
		}
		var tooltip = oItem.getTooltip_AsString();
		if (tooltip) {
			rm.writeAttributeEscaped("title", tooltip);
		}
		rm.writeAttribute("tabindex", oItem.getEnabled() ? "0" : "-1");
		rm.writeClasses();
		var buttonWidth = oItem.getWidth();
		if(buttonWidth){
			rm.addStyle('width', buttonWidth);
			rm.writeStyles();
		}
		rm.write('>');
		if(oItem.getIcon() === '' && oItem.getText() !== '') {
			rm.writeEscaped(oItem.getText(), false);
		} else if (oItem.getIcon() !== '' && oItem.getText() === '') {
			var oImage = oItem._getImage((oItem.getId() + "-img"), oItem.getIcon());
			oImage.onload = function() {
				sap.m.Image.prototype.onload.call(oImage);
				window.setTimeout(function() {
					oControl._fCalcBtnWidth();
				},20);
			}
			rm.renderControl(oImage);	

		} else if(oItem.getIcon() !== '' && oItem.getText() !== '' ){
			jQuery.sap.log.error("SEGMENTED: "+oItem.getId()+": Icon and Label is not allowed");
		}
		rm.write("</li>");
	}
	rm.write("</ul>");
	
};

}; // end of sap/m/SegmentedButtonRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.SelectDialogRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare("sap.m.SelectDialogRenderer");

/**
 * @class SelectDialog renderer.
 * @static
 */
sap.m.SelectDialogRenderer = {
};

/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.m.SelectDialogRenderer.render = function (oRm, oControl) {
};
}; // end of sap/m/SelectDialogRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.SelectRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare("sap.m.SelectRenderer");
jQuery.sap.require('sap.ui.core.ValueStateSupport'); // unlisted dependency retained


/**
 * @class Select renderer.
 * @static
 */
sap.m.SelectRenderer = {};

/**
 * CSS class to be applied to the HTML root element of the Select control.
 *
 * @type {string}
 */
sap.m.SelectRenderer.CSS_CLASS = "sapMSlt";

/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
 * @param {sap.m.Select} oSelect An object representation of the control that should be rendered.
 */
sap.m.SelectRenderer.render = function(oRm, oSelect) {
	var	oSelectedItem = oSelect.getSelectedItem(),
		sSelectedItemText = oSelectedItem ? oSelectedItem.getText() : "",
		sTooltip = sap.ui.core.ValueStateSupport.enrichTooltip(oSelect, oSelect.getTooltip_AsString()),
		sId = oSelect.getId() + "-nat",
		sType = oSelect.getType(),
		sIconURI = oSelect.getIcon(),
		bAutoAdjustWidth = oSelect.getAutoAdjustWidth(),
		bEnabled = oSelect.getEnabled(),
		CSS_CLASS = sap.m.SelectRenderer.CSS_CLASS;

	// suppress rendering if not visible
	if (!oSelect.getVisible()) {
		return;
	}

	oRm.write("<div");
	this.addStyleClass(oRm, oSelect);
	oRm.addClass(CSS_CLASS);

	oRm.addClass(CSS_CLASS + oSelect.getType());

	if (!bEnabled) {
		oRm.addClass(CSS_CLASS + "Disabled");
	}

	if (bAutoAdjustWidth) {
		oRm.addClass(CSS_CLASS + "AutoAdjustedWidth");
	} else {
		oRm.addStyle("width", oSelect.getWidth());
	}

	if (sIconURI) {
		oRm.addClass(CSS_CLASS + "WithIcon");
	}

	oRm.addClass(CSS_CLASS + "WithArrow");

	oRm.addStyle("max-width", oSelect.getMaxWidth());

	oRm.writeControlData(oSelect);

	oRm.writeStyles();
	oRm.writeClasses();

	if (sTooltip) {
		oRm.writeAttributeEscaped("title", sTooltip);
	}

	if (bEnabled) {
		oRm.writeAttribute("tabindex", "0");
	}

	oRm.write(">");

		switch (sType) {
			case sap.m.SelectType.Default:
				this._renderLabel(oRm, oSelect, sId, sSelectedItemText);
				this._renderArrow(oRm);
				break;

			case sap.m.SelectType.IconOnly:
				this._renderIcon(oRm, sIconURI);
				break;

			// no default
		}

		if (oSelect._isRequiredSelectElement()) {
			this._renderSelectElement(oRm, oSelect, sId, bEnabled, sSelectedItemText);
		}

	oRm.write("</div>");
};

/**
 * Renders the select's label, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
 * @param {sap.m.Select} oSelect An object representation of the control that should be rendered.
 * @param {string} sId
 * @param {string} sSelectedItemText
 * @private
 */
sap.m.SelectRenderer._renderLabel = function(oRm, oSelect, sId, sSelectedItemText) {
	oRm.write('<label class="' + sap.m.SelectRenderer.CSS_CLASS + 'Label"');
	oRm.writeAttribute("for", sId);

	oRm.write(">");
		oRm.writeEscaped(sSelectedItemText);
	oRm.write('</label>');
};

/**
 * Renders the select's arrow, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
 * @private
 */
sap.m.SelectRenderer._renderArrow = function(oRm) {
	oRm.write('<span class="' + sap.m.SelectRenderer.CSS_CLASS + 'Arrow"></span>');
};

/**
 * Renders the select's icon, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
 * @param {string} sIconURI
 * @private
 */
sap.m.SelectRenderer._renderIcon = function(oRm, sIconURI) {
	oRm.writeIcon(sIconURI, sap.m.SelectRenderer.CSS_CLASS + "Icon");
};

/**
 * Renders the HTMLSelectElement for the select control, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
 * @param {sap.m.Select} oSelect An object representation of the select that should be rendered.
 * @param {string} sId
 * @param {boolean} bEnabled
 * @param {string} sSelectedItemText
 * @private
 */
sap.m.SelectRenderer._renderSelectElement = function(oRm, oSelect, sId, bEnabled, sSelectedItemText) {
	var sName = oSelect.getName();

	oRm.write("<select");
	oRm.writeAttribute("id", sId);

	if (sName) {
		oRm.writeAttributeEscaped("name", sName);
	}

	if (!bEnabled) {
		oRm.write(" disabled");
	}

	oRm.writeAttribute("tabindex", "-1");

	oRm.write(">");

		this._renderOptions(oRm, oSelect, sSelectedItemText);

	oRm.write("</select>");
};

/**
 * Renders the HTMLOptionElement(s) for the select control, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
 * @param {sap.m.Select} oSelect An object representation of the select that should be rendered.
 * @param {string} sSelectedItemText
 * @private
 */
sap.m.SelectRenderer._renderOptions = function(oRm, oSelect, sSelectedItemText) {
	var aItems = oSelect.getItems(),
		aItemsLength = aItems.length,
		sSelectedItemId = oSelect.getAssociation("selectedItem"),
		i = 0;

	// rendering options
	for (; i < aItemsLength; i++) {
		oRm.write("<option");
			oRm.writeAttribute("id", aItems[i].getId());
			oRm.writeAttributeEscaped("value", (aItems[i].getKey() !== "") ? aItems[i].getKey() : aItems[i].getId());

			if (aItems[i].getId() === sSelectedItemId) {
				oRm.write(" selected");
			}

			if (!aItems[i].getEnabled()) {
				oRm.write(" disabled");
			}

			oRm.write(">");
			oRm.writeEscaped(aItems[i].getText());
		oRm.write("</option>");
	}

	if (aItemsLength === 0) {
		oRm.write("<option>" + sSelectedItemText + "</option>");
	}
};

/**
 * This method is reserved for derived class to add extra classes to the HTML root element of the control.
 *
 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
 * @param {sap.ui.core.Control} oSelect An object representation of the control that should be rendered.
 * @protected
 */
sap.m.SelectRenderer.addStyleClass = function(oRm, oSelect) {};
}; // end of sap/m/SelectRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.ShellRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
 
 jQuery.sap.declare("sap.m.ShellRenderer");

/**
 * @class Shell renderer. 
 * @static
 */
sap.m.ShellRenderer = {
};


/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 * 
 * @param {sap.ui.core.RenderManager} rm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.m.ShellRenderer.render = function(rm, oControl) { 
	rm.write("<div");
	rm.writeControlData(oControl);
	rm.addClass("sapMShell");
	if (oControl.getAppWidthLimited()) {
		rm.addClass("sapMShellAppWidthLimited");
	}
	
	sap.m.BackgroundHelper.addBackgroundColorStyles(rm, oControl.getBackgroundColor(),  oControl.getBackgroundImage());
	
	rm.writeClasses();
	rm.writeStyles();
	
	var sTooltip = oControl.getTooltip_AsString();
	if (sTooltip) {
		rm.writeAttributeEscaped("title", sTooltip);
	}
	
	rm.write(">");
	
	sap.m.BackgroundHelper.renderBackgroundImageTag(rm, oControl, "sapMShellBG",  oControl.getBackgroundImage(), oControl.getBackgroundRepeat(), oControl.getBackgroundOpacity());
	
	rm.write("<div class='sapMShellBrandingBar'></div>");
	
	
	rm.write("<div class='sapMShellCentralBox'>");
	
	
	// header
	var extraHeaderClass= "", extraBGClass= ""; 
	if (!oControl.getBackgroundImage()) {
		extraHeaderClass = "sapMShellBackgroundColorOnlyIfDefault";
		extraBGClass = "sapMGlobalBackgroundImageOnlyIfDefault";
	}
	rm.write("<header class='sapMShellHeader " + extraHeaderClass + "' id='" + oControl.getId() + "-hdr'>");
	rm.write("<div class='" + extraBGClass + "'></div>");
	// logo
	rm.write(sap.m.ShellRenderer.getLogoImageHtml(oControl));
	
	// header title
	rm.write("<h1 id='" + oControl.getId() + "-hdrTxt' class='sapMShellHeaderText'>");
	rm.writeEscaped(oControl.getTitle());
	rm.write("</h1>");
	
	// header right area
	rm.write("<span class='sapMShellHeaderRight'>");
	
	// headerRightText
	rm.write("<span id='" + oControl.getId() + "-hdrRightTxt' ");
	if (!oControl.getHeaderRightText()) {
		rm.writeAttribute("style", "display:none;");
	}
	rm.write("class='sapMShellHeaderRightText'>" + jQuery.sap.encodeHTML(oControl.getHeaderRightText()) + "</span>");

	
	// logout button
	if (oControl.getShowLogout()) {
		var rb = sap.ui.getCore().getLibraryResourceBundle("sap.m");
		rm.write("<a id='" + oControl.getId() + "-logout' tabindex='0' role='button' class='sapMShellHeaderLogout'>" + rb.getText("SHELL_LOGOUT") + "</a>");
	}
	
	rm.write("</span></header>");
	
	
	
	// content
	rm.write("<section class='sapMShellContent' id='" + oControl.getId() + "-content' data-sap-ui-root-content='true'>");

	rm.renderControl(oControl.getApp());
	
	rm.write("</section></div></div>");
};

sap.m.ShellRenderer.getLogoImageHtml = function(oControl) {
	var sImage = oControl.getLogo(); // configured logo
	if (!sImage) {
		jQuery.sap.require("sap.ui.core.theming.Parameters");
		sImage = sap.ui.core.theming.Parameters.get('sapUiGlobalLogo'); // theme logo
		if (sImage) {
			var match = /url[\s]*\('?"?([^\'")]*)'?"?\)/.exec(sImage);
			if (match) {
				sImage = match[1];
			} else if (sImage === "''"){ // theme default
				sImage = null;
			}
		}
	}
	
	var result = "";
	if (sImage) {
		result = "<div class='sapMShellLogo'>";
		if (sap.ui.Device.browser.internet_explorer) {
			result += "<span class='sapMShellLogoImgAligner'></span>";
		}
		result += "<img id='" + oControl.getId() + "-logo' class='sapMShellLogoImg' src='";
		result += jQuery.sap.encodeHTML(sImage);
		result += "' /></div>";
	}
	return result;
};
}; // end of sap/m/ShellRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.SliderRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare("sap.m.SliderRenderer");

/**
 * @class Slider renderer.
 * @static
 */
sap.m.SliderRenderer = {};

/**
 * CSS class to be applied to the HTML root element of the Slider control.
 *
 * @type {string}
 */
sap.m.SliderRenderer.CSS_CLASS = "sapMSlider";

/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
 * @param {sap.ui.core.Control} oSlider An object representation of the slider that should be rendered.
 */
sap.m.SliderRenderer.render = function(oRm, oSlider) {
	var fValue = oSlider.getValue(),
		sName = oSlider.getName(),
		bEnabled = oSlider.getEnabled(),
		sTooltip = oSlider.getTooltip_AsString();

	// avoid render when not visible
	if (!oSlider.getVisible()) {
		return;
	}

	oRm.write("<div");
	oRm.addClass(sap.m.SliderRenderer.CSS_CLASS);

	if (!bEnabled) {
		oRm.addClass(sap.m.SliderRenderer.CSS_CLASS + "Disabled");
	}

	oRm.addStyle("width", oSlider.getWidth());
	oRm.addStyle("visibility", "hidden");
	oRm.writeClasses();
	oRm.writeStyles();
	oRm.writeControlData(oSlider);

	if (sTooltip) {
		oRm.writeAttributeEscaped("title", sTooltip);
	}

	oRm.write(">");

		oRm.write('<div');
			oRm.addClass(sap.m.SliderRenderer.CSS_CLASS + "Inner");

			if (!bEnabled) {
				oRm.addClass(sap.m.SliderRenderer.CSS_CLASS + "InnerDisabled");
			}

			oRm.writeClasses();
			oRm.writeStyles();
			oRm.write(">");

			if (oSlider.getProgress()) {
				oRm.write('<div class="' + sap.m.SliderRenderer.CSS_CLASS + 'Progress" style="width: ' +  oSlider._sProgressValue + '"></div>');
			}

			this._renderHandle(oRm, oSlider, fValue, bEnabled);

		oRm.write("</div>");

		if (sName) {
			this._renderInput(oRm, oSlider, fValue, bEnabled, sName);
		}

	oRm.write("</div>");
};

sap.m.SliderRenderer._renderHandle = function(oRm, oSlider, fValue, bEnabled) {
	oRm.write("<span");
	oRm.addClass(sap.m.SliderRenderer.CSS_CLASS + "Handle");
	oRm.addStyle(sap.m.Slider._bRtl ? "right" : "left", oSlider._sProgressValue);

	// WAI-ARIA
	oRm.writeAccessibilityState(oSlider, {
		role: "slider",
		orientation: "horizontal",
		valuemin: oSlider.getMin(),
		valuemax: oSlider.getMax(),
		valuenow: fValue,
		valuetext: fValue,
		live: "assertive",
		disabled: !oSlider.getEnabled()
	});

	oRm.writeClasses();
	oRm.writeStyles();

	oRm.writeAttribute("title", fValue);

	if (bEnabled) {
		oRm.writeAttribute("tabindex", "0");
	}

	oRm.write("></span>");
};

sap.m.SliderRenderer._renderInput = function(oRm, oSlider, fValue, bEnabled, sName) {
	oRm.write('<input type="text" class="' + sap.m.SliderRenderer.CSS_CLASS + 'Input"');

	if (!bEnabled) {
		oRm.write("disabled");
	}

	oRm.writeAttributeEscaped("name", sName);
	oRm.writeAttribute("value", fValue);

	oRm.write("/>");
};
}; // end of sap/m/SliderRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.SplitContainerRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare("sap.m.SplitContainerRenderer");

/**
 * @class SplitContainer renderer. 
 * @static
 */
sap.m.SplitContainerRenderer = {
};


/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 * 
 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.m.SplitContainerRenderer.render = function(oRm, oControl){ 
	oRm.write("<div");
	oRm.writeControlData(oControl);
	oRm.addClass("sapMSplitContainer");
	
	if (this.renderAttributes) {
		this.renderAttributes(oRm, oControl); // may be used by inheriting renderers, but DO NOT write class or style attributes! Instead, call addClass/addStyle.
	}
	
	if(!sap.ui.Device.system.phone) {
		if(sap.ui.Device.orientation.portrait) {
			oRm.addClass("sapMSplitContainerPortrait");
		}
		switch(oControl.getMode()) {
			case "ShowHideMode":
				oRm.addClass("sapMSplitContainerShowHide");
				break;
			case "StretchCompress":
				oRm.addClass("sapMSplitContainerStretchCompress");
				break;
			case "PopoverMode":
				oRm.addClass("sapMSplitContainerPopover");
				break;
			case "HideMode":
				oRm.addClass("sapMSplitContainerHideMode");
		}
	}
	oRm.writeClasses();
	oRm.writeStyles();
	var sTooltip = oControl.getTooltip_AsString();
	if (sTooltip) {
		oRm.writeAttributeEscaped("title", sTooltip);
	}
	oRm.write(">"); // div element
	
	if(this.renderBeforeContent){
		this.renderBeforeContent(oRm, oControl);
	}
	
	if(!sap.ui.Device.system.phone) {
		if(oControl.getMode() === "PopoverMode" && sap.ui.Device.orientation.portrait) {
			oControl._oDetailNav.addStyleClass("sapMSplitContainerDetail");
			oRm.renderControl(oControl._oDetailNav);
			//add master to popover if it's not yet added
			if(oControl._oPopOver.getContent().length === 0){
				oControl._oPopOver.addAggregation("content", oControl._oMasterNav, true);
			}
		} else {
			oControl._oMasterNav.addStyleClass("sapMSplitContainerMaster");
			oRm.renderControl(oControl._oMasterNav);
			
			oControl._oDetailNav.addStyleClass("sapMSplitContainerDetail");
			oRm.renderControl(oControl._oDetailNav);
		}
	}else {
		oControl._oMasterNav.addStyleClass("sapMSplitContainerMobile");
		oRm.renderControl(oControl._oMasterNav);
	}
	
	 oRm.write("</div>");
};

}; // end of sap/m/SplitContainerRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.StandardListItemRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare("sap.m.StandardListItemRenderer");
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained



/**
 * @class StandardListItem renderer.
 * @static
 */
sap.m.StandardListItemRenderer = sap.ui.core.Renderer.extend(sap.m.ListItemBaseRenderer);

/**
 * Renders the HTML for the given control, using the provided
 * {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager}
 *          oRenderManager the RenderManager that can be used for writing to the
 *          Render-Output-Buffer
 * @param {sap.ui.core.Control}
 *          oControl an object representation of the control that should be
 *          rendered
 */
sap.m.StandardListItemRenderer.renderLIAttributes = function(rm, oLI) {
	rm.addClass("sapMSLI");
	if(oLI._showSeparators  == sap.m.ListSeparators.None && !oLI.getIconInset()){
		rm.addClass("sapMSLIShowSeparatorNone");
	}
	if(oLI.getIcon())
		rm.addClass("sapMSLIIcon");
	if(!oLI.getIconInset())
		rm.addClass("sapMSLIIconThumb");
	if((oLI.getDescription() || !oLI.getAdaptTitleSize()) && oLI.getIcon() &&  oLI.getIconInset())
		rm.addClass("sapMSLIDescIcon");
	if((oLI.getDescription() || !oLI.getAdaptTitleSize()) && !oLI.getIcon())
		rm.addClass("sapMSLIDescNoIcon");
	if(!oLI.getDescription() && oLI.getIcon())
		rm.addClass("sapMSLINoDescIcon");
	if(oLI.getType() == sap.m.ListType.Detail || oLI.getType() == sap.m.ListType.DetailAndActive)
		rm.addClass("sapMSLIDetail");

};

sap.m.StandardListItemRenderer.renderLIContent = function(rm, oLI) {

	// image
	if (oLI.getIcon()) {
		if (oLI.getIconInset()) {
			var oList = sap.ui.getCore().byId(oLI._listId);
			if(oList && oList.getMode() == sap.m.ListMode.None &! oList.getShowUnread()){
				rm.renderControl(oLI._getImage((oLI.getId() + "-img"), "sapMSLIImgFirst", oLI.getIcon(), oLI.getIconDensityAware()));
			}
			else{
				rm.renderControl(oLI._getImage((oLI.getId() + "-img"), "sapMSLIImg", oLI.getIcon(), oLI.getIconDensityAware()));
			}
		} else {
			rm.renderControl(oLI._getImage((oLI.getId() + "-img"), "sapMSLIImgThumb", oLI.getIcon(), oLI.getIconDensityAware()));
		}
	}

	var isDescription = oLI.getTitle() && (oLI.getDescription() || !oLI.getAdaptTitleSize())  || (oLI._showSeparators  == sap.m.ListSeparators.None && !oLI.getIconInset());
	var isInfo = oLI.getInfo();

	if (isDescription) {
		rm.write("<div");
		rm.addClass("sapMSLIDiv");
		rm.writeClasses();
		rm.write(">");
	}

	rm.write("<div");
	if (!isDescription){
		rm.addClass("sapMSLIDiv");
	}
	rm.addClass("sapMSLITitleDiv");
	rm.writeClasses();
	rm.write(">");

	//noFlex: make an additional div for the contents table
	if(!isDescription && oLI._bNoFlex){
		rm.write('<div class="sapMLIBNoFlex">');
	}
	// List item text (also written when no title for keeping the space)
	rm.write("<div");
	if (isDescription) {
		rm.addClass("sapMSLITitle");
	} else {
		rm.addClass("sapMSLITitleOnly");
	}
	rm.writeClasses();
	rm.write(">");
	rm.writeEscaped(oLI.getTitle());
	rm.write("</div>");

	//info div top when @sapUiInfoTop: true;
	if(isInfo && (sap.ui.core.theming.Parameters.get("sapUiInfoTop") == "true" || !isDescription)){
		rm.write("<div");
		rm.writeAttribute("id", oLI.getId() + "-info");
		rm.addClass("sapMSLIInfo");
		rm.addClass("sapMSLIInfo" + oLI.getInfoState());
		rm.writeClasses();
		rm.write(">");
		rm.writeEscaped(isInfo);
		rm.write("</div>");
	}

	//noFlex: make an additional div for the contents table
	if(!isDescription && oLI._bNoFlex){
		rm.write('</div>');
	}
	rm.write("</div>");

	rm.write("<div");
	rm.addClass("sapMSLIDescriptionDiv");
	rm.writeClasses();
	rm.write(">");

	// List item text
	if (isDescription) {
		rm.write("<div");
		rm.addClass("sapMSLIDescription");
		rm.writeClasses();
		rm.write(">");
		if (oLI.getDescription()) {
			rm.writeEscaped(oLI.getDescription());
		} else {
			rm.write("&nbsp;");
		}
		rm.write("</div>");
	}

	if(isInfo && sap.ui.core.theming.Parameters.get("sapUiInfoTop") == "false" && isDescription){
		rm.write("<div");
		rm.writeAttribute("id", oLI.getId() + "-info");
		rm.addClass("sapMSLIInfo");
		if(oLI._showSeparators == sap.m.ListSeparators.None && oLI.getInfoState() == sap.ui.core.ValueState.None)
			rm.addClass("sapMSLIInfo" + oLI.getInfoState() + "ShowSeparatorNone");
		else
			rm.addClass("sapMSLIInfo" + oLI.getInfoState());
		rm.writeClasses();
		rm.write(">");
		rm.writeEscaped(isInfo);
		rm.write("</div>");
	}
	rm.write("</div>");

	if (isDescription) {
		rm.write("</div>");
	}

};

}; // end of sap/m/StandardListItemRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.Support') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare("sap.m.Support");

/**
 * @class
 * <code>sap.m.Support</code> shows the technical information for SAPUI5 Mobile Applications.
 * This technical information includes
 *  * SAPUI5 Version
 *  * User Agent
 *  * Configurations (Bootstrap and Computed)
 *  * URI parameters
 *  * All loaded module names
 *
 * In order to show the device information, the user must follow the following gestures.
 * 	1 - Hold the device in "landscape" mode
 * 	2 - Tap on any element (possibly element which does not have touch event e.g text or header (because of the stopPropagation))
 * 	3 - Hold finger minimum 2 seconds, up to 5 seconds
 * 	4 - Change device rotation to "portrait" mode
 *  5 - Release finger
 *
 * NOTE: This class is internal and all its functions must not be used by an application
 *
 * As <code>sap.m.Support</code> is a static class, a <code>jQuery.sap.require("sap.m.Support");</code>
 * statement must be implicitly executed before the class is used.
 *
 * Enable Support:
 * <pre>
 * //import library
 * jQuery.sap.require("sap.m.Support");
 *
 * //By default after require, support is enabled but implicitly we can call
 * sap.m.Support.on();
 * </pre>
 *
 * Disable Support:
 * <pre>
 * sap.m.Support.off();
 * </pre>
 *
 * @author SAP AG
 * @since 1.11.0
 *
 * @static
 * @protected
 * @namespace
 * @name sap.m.Support
 */
sap.m.Support = (function($, document) {

	var dialog,
		startTime,
		isEventRegistered,
		timeMinLimit = 2000,
		timeMaxLimit = 5000,
		orientations = {
		    start : "landscape",
		    end : "portrait"
		};

	// copied from core
	function line(buffer, right, border, label, content) {
		buffer.push("<tr><td class='sapUiSupportTechInfoBorder'><label class='sapUiSupportLabel'>", jQuery.sap.escapeHTML(label), "</label><br>");
		var ctnt = content;
		if ($.isFunction(content)) {
			ctnt = content(buffer) || "";
		}
		buffer.push($.sap.escapeHTML(ctnt));
		buffer.push("</td></tr>");
	}

	// copied from core
	function multiline(buffer, right, border, label, content) {
		line(buffer, right, border, label, function(buffer) {
			buffer.push("<table border='0' cellspacing='5' cellpadding='5' width='100%'>");
			$.each(content, function(i, v) {
				var val = "";
				if (v) {
					if (typeof(v) == "string" || typeof(v) == "boolean" || ($.isArray(v) && v.length == 1)) {
						val = v;
					} else if(($.isArray(v) || $.isPlainObject(v)) && window.JSON) {
						val = window.JSON.stringify(v);
					}
				}
				line(buffer, false, false, i, "" + val);
			});
			buffer.push("</table>");
		});
	}

	// copied from core
	function getTechnicalContent() {
		var html,
			oConfig = sap.ui.getCore().getConfiguration(),
			oData = {
				version: sap.ui.version,
				build: sap.ui.buildinfo.buildtime,
				change: sap.ui.buildinfo.lastchange,
				useragent: navigator.userAgent,
				docmode: document.documentMode ||  "",
				debug: $.sap.debug(),
				bootconfig: window["sap-ui-config"] || {},
				modules: $.sap.getAllDeclaredModules(),
				uriparams: $.sap.getUriParameters().mParams,
				appurl: window.location.href,
				config: {
					theme: oConfig.getTheme(),
					language: oConfig.getLanguage(),
					formatLocale: oConfig.getFormatLocale(),
					accessibility: "" + oConfig.getAccessibility(),
					animation: "" + oConfig.getAnimation(),
					rtl: "" + oConfig.getRTL(),
					debug: "" + oConfig.getDebug(),
					inspect: "" + oConfig.getInspect(),
					originInfo: "" + oConfig.getOriginInfo(),
					noDuplicateIds: "" + oConfig.getNoDuplicateIds()
				}
			};

		html = ["<table border='0' cellspacing='5' cellpadding='5' width='100%'>"];
		line(html, true, true, "SAPUI5 Version", function(buffer) {
			buffer.push(oData.version, " (built at ", oData.build, ", last change ", oData.change, ")");
		});
		line(html, true, true, "User Agent", function(buffer) {
			buffer.push(oData.useragent, (oData.docmode ? ", Document Mode '" + oData.docmode + "'" : ""));
		});
		line(html, true, true, "Debug Sources", function(buffer) {
			buffer.push((oData.debug ? "ON" : "OFF") );
		});
		line(html, true, true, "Application", oData.appurl);
		multiline(html, true, true, "Configuration (bootstrap)", oData.bootconfig);
		multiline(html, true, true, "Configuration (computed)", oData.config);
		multiline(html, true, true, "URI Parameters", oData.uriparams);
		line(html, true, true, "Loaded Modules (" + oData.modules.length + ")", function(buffer) {
			buffer.push("<ul>");
			$.each(oData.modules.sort(), function(i, v) {
				if (v.indexOf("sap.ui.core.support") < 0) {
					buffer.push("<li>", v, "</li>");
				}
			});
			buffer.push("</ul>");
		});
		html.push("</table>");

		return new sap.ui.core.HTML({
			content : html.join("").replace(/\{/g, "&#123;").replace(/\}/g, "&#125;")
		});
	}

	// get or create dialog instance and return
	function getDialog() {
		if (dialog) {
			return dialog;
		}

		$.sap.require("sap.m.Dialog");
		$.sap.require("sap.m.Button");
		$.sap.require("sap.ui.core.HTML");

		dialog = new sap.m.Dialog({
			title : "Technical Information",
			horizontalScrolling: true,
			verticalScrolling: true,
			stretch: jQuery.device.is.phone,
			leftButton : new sap.m.Button({
				text : "Close",
				type : "Reject",
				press : function() {
					dialog.close();
				}
			}),
			afterOpen : function() {
				sap.m.Support.off();
			},
			afterClose : function() {
				sap.m.Support.on();
			}
		}).addStyleClass("sapMSupport");
		
		return dialog;
	}

	function onTouchStart() {
		var orientation = $.event.special.orientationchange.orientation();
		if (orientation == orientations.start) {
			startTime = Date.now();
			document.addEventListener('touchend', onTouchEnd);
		}
	}

	function onTouchEnd() {
		var timeDiff = Date.now() - startTime,
			orientation = $.event.special.orientationchange.orientation();
		
		document.removeEventListener('touchend', onTouchEnd);
		if (orientation == orientations.end && timeDiff > timeMinLimit && timeDiff < timeMaxLimit) {
			show();
		}
	}

	function show() {
		var container = getDialog();
		container.removeAllAggregation("content");
		container.addAggregation("content", getTechnicalContent());
		dialog.open();
	}

	return ({
		/**
		 * Enables support.
		 *
		 * @return {object} sap.m.Support
		 * @protected
		 * @name sap.m.Support.on
		 * @function
		 */
		on : function() {
			if (!isEventRegistered && "ontouchstart" in document) {
				isEventRegistered = true;
				document.addEventListener("touchstart", onTouchStart);
			}
			return this;
		},

		/**
		 * Disables support.
		 *
		 * @return {object} sap.m.Support
		 * @protected
		 * @name sap.m.Support.off
		 * @function
		 */
		off : function() {
			if (isEventRegistered) {
				isEventRegistered = false;
				document.removeEventListener("touchstart", onTouchStart);
			}
			return this;
		},
		
		open : function() {
			show();
		}
	}).on();

}(jQuery, document));
}; // end of sap/m/Support.js
if ( !jQuery.sap.isDeclared('sap.m.SwitchRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare("sap.m.SwitchRenderer");

/**
 * @class Switch renderer.
 * @static
 */
sap.m.SwitchRenderer = {};

/**
 * CSS class to be applied to the HTML root element of the Switch control.
 *
 * @type {string}
 */
sap.m.SwitchRenderer.CSS_CLASS = "sapMSwt";

/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the Render-Output-Buffer.
 * @param {sap.ui.core.Control} oSwitch An object representation of the control that should be rendered.
 */
sap.m.SwitchRenderer.render = function(oRm, oSwitch) {
	var bState = oSwitch.getState(),
		sState = bState ? oSwitch._sOn : oSwitch._sOff,
		sTooltip = oSwitch.getTooltip_AsString(),
		sType = oSwitch.getType(),
		bDefault = (sType === "Default"),
		bDisabled =  !oSwitch.getEnabled(),
		sName = oSwitch.getName(),
		CSS_CLASS = sap.m.SwitchRenderer.CSS_CLASS;

	// suppress rendering if not visible
	if (!oSwitch.getVisible()) {
		return;
	}

	oRm.write('<div');
	oRm.addClass(CSS_CLASS + "Cont");

	if (bDisabled) {
		oRm.addClass(CSS_CLASS + "ContDisabled");
	}

	oRm.writeClasses();
	oRm.writeStyles();
	oRm.writeControlData(oSwitch);

	if (sTooltip) {
		oRm.writeAttributeEscaped("title", sTooltip);
	}

	oRm.write(">");

		oRm.write("<div");
		oRm.addClass(CSS_CLASS);
		oRm.addClass(bState ? CSS_CLASS + "On" : CSS_CLASS + "Off");
		oRm.addClass(CSS_CLASS + sType);

		if (bDisabled) {
			oRm.addClass(CSS_CLASS + "Disabled");
		}

		oRm.writeClasses();
		oRm.write(">");
			oRm.write('<div class="' + CSS_CLASS + 'Inner">');

				// text
				this._renderText(oRm, oSwitch, bDefault);

				// handle
				this._renderHandle(oRm, oSwitch, sState, bDisabled);

			oRm.write("</div>");

		oRm.write("</div>");

		if (sName) {

			// checkbox
			this._renderCheckbox(oRm, oSwitch, sName, sState, bState, bDisabled);
		}

	oRm.write("</div>");
};

sap.m.SwitchRenderer._renderText = function(oRm, oSwitch, bDefault) {
	var CSS_CLASS = sap.m.SwitchRenderer.CSS_CLASS;

	// on
	oRm.write('<div class="' + CSS_CLASS + 'Text ' + CSS_CLASS + 'TextOn">');
		oRm.write("<span>");
			if (bDefault) {
				oRm.writeEscaped(oSwitch._sOn);
			}
		oRm.write("</span>");
	oRm.write("</div>");

	// off
	oRm.write('<div class="' + CSS_CLASS + 'Text ' + CSS_CLASS + 'TextOff">');
		oRm.write("<span>");
			if (bDefault) {
				oRm.writeEscaped(oSwitch._sOff);
			}
		oRm.write("</span>");
	oRm.write("</div>");
};

sap.m.SwitchRenderer._renderHandle = function(oRm, oSwitch, sState, bDisabled) {
	var CSS_CLASS = sap.m.SwitchRenderer.CSS_CLASS;

	oRm.write("<div");
	oRm.addClass(CSS_CLASS + "Handle");

	if (sap.ui.Device.browser.webkit && Number(sap.ui.Device.browser.webkitVersion).toFixed(2) === "537.35") {
		oRm.addClass(CSS_CLASS + "WebKit537-35");
	}

	oRm.writeClasses();

	if (!bDisabled) {
		oRm.writeAttribute("tabindex", "0");
	}

	oRm.writeAttributeEscaped("data-sap-ui-swt", sState);
	oRm.write(">");
	oRm.write("</div>");
};

sap.m.SwitchRenderer._renderCheckbox = function(oRm, oSwitch, sName, sState, bState, bDisabled) {
	oRm.write('<input type="checkbox"');

	oRm.writeAttributeEscaped("name", sName);

	oRm.writeAttribute("id", oSwitch.getId() + "-input");

	if (bState) {
		oRm.writeAttribute("checked", "checked");
	}

	if (bDisabled) {
		oRm.writeAttribute("disabled", "disabled");
	}

	oRm.writeAttributeEscaped("value", sState);

	oRm.write(">");
};
}; // end of sap/m/SwitchRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.TablePersoProvider') ) {
/*
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides TablePersoProvider
jQuery.sap.declare("sap.m.TablePersoProvider");
jQuery.sap.require('sap.ui.base.ManagedObject'); // unlisted dependency retained



/**
 * This is an abstract TablePersoProvider, describing the interface for a real
 * TablePersoProvider.
 *
 * @public
 *
 * @class Table Personalization Provider
 * @extends sap.ui.base.ManagedObject
 * @abstract
 * @author SAP
 * @version 1.20.6
 * @name sap.m.TablePersoProvider
 */
sap.ui.base.ManagedObject.extend("sap.m.TablePersoProvider", /** @lends sap.m.TablePersoProvider */

{
	constructor: function(sId, mSettings) {

		sap.ui.base.ManagedObject.apply(this, arguments);

	},

	metadata: {
		"abstract": true,
		library: "sap.m"
	}

});


/**
 * Initializes the TablePersoProvider instance after creation.
 *
 * @function
 * @name sap.m.TablePersoDialog.prototype.init
 * @protected
 */
sap.m.TablePersoProvider.prototype.init = function() {

	jQuery.sap.log.warning("This is the abstract base class for a TablePersoProvider. Do not create instances of this class, but use a concrete sub class instead.");
	jQuery.sap.log.debug("TablePersoProvider init");

};

/**
 * Retrieves the personalization bundle. 
 * This must return a jQuery promise (see http://api.jquery.com/promise/)
 * @public
 */
sap.m.TablePersoProvider.prototype.getPersData = function() {

	jQuery.sap.log.debug("TablePersoProvider getPersData");

};

/**
 * Stores the personalization bundle, overwriting any
 * previous bundle completely
 * This must return a jQuery promise (see http://api.jquery.com/promise/)
 * @public
 */
sap.m.TablePersoProvider.prototype.setPersData = function(oBundle) {

	jQuery.sap.log.debug("TablePersoProvider setPersData");

};

/**
 * Removes the personalization bundle
 * This must return a jQuery promise (see http://api.jquery.com/promise/)
 * @public
 */
sap.m.TablePersoProvider.prototype.delPersData = function() {

	jQuery.sap.log.debug("TablePersoProvider delPersData");

};

/**
 * Callback function which can be used to determine the title of a given column
 * within the TablePersoDialog. As a default, the column header controls are
 * asked for their 'text' or 'title' property. This works in most cases, for example
 * if the header control is a sap.m.Label (has 'text' property) or a sap.m.ObjectListItem
 * (has 'title' property). 
 * 
 * If the header control used in a column has neither 'text' nor 'title' property, or if you would like to 
 * display a modified column name for a certain column, this callback function can be used.
 * 
 * If the callback delivers null for a column (which is the default implementation), the default
 * texts described above are displayed for that column in the TablePersoDialog. 
 * 
 * In case neither the callback delovers null and neither 'text' nor ' title' property are at hand,
 * the TablePersoDialog will display the column id and a warning message is logged.
 * 
 * @param oColumn column control instance whose caption shall be determined
 * @public
 */
sap.m.TablePersoProvider.prototype.getCaption = function(oColumn) {
	return null;
};

}; // end of sap/m/TablePersoProvider.js
if ( !jQuery.sap.isDeclared('sap.m.TableRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained


jQuery.sap.declare("sap.m.TableRenderer");

/**
 * @class List renderer.
 * @static
 *
 * TableRenderer extends the ListBaseRenderer
 */
sap.m.TableRenderer = sap.ui.core.Renderer.extend(sap.m.ListBaseRenderer);


/**
 * Renders the Header and/or Footer of the Table like List Control
 *
 * @param {sap.ui.core.RenderManager} rm RenderManager
 * @param {sap.m.ListBase} oTable Table control
 * @param {String} type Whether "Head" or "Foot"
 */
sap.m.TableRenderer.renderColumns = function(rm, oTable, type) {
	var index = 0,
		hiddens = 0,
		hasPopin = false,
		hasFooter = false,
		mode = oTable.getMode(),
		clsPrefix = "sapMListTbl",
		idPrefix = oTable.getId("tbl"),
		cellTag = (type == "Head") ? "th" : "td",
		groupTag = "t" + type.toLowerCase(),
		aColumns = oTable.getColumns(),
		isHeaderHidden = (type == "Head") && aColumns.every(function(oColumn) {
			return	!oColumn.getHeader() ||
					!oColumn.getVisible() ||
					oColumn.isPopin() ||
					oColumn.isNeverVisible() ||
					oColumn.isHidden();
		}),
		hasOneHeader = (type == "Head") && aColumns.filter(function(oColumn) {
			return	oColumn.getVisible() &&
					!oColumn.isPopin() &&
					!oColumn.isNeverVisible() &&
					!oColumn.isHidden();
		}).length == 1,
		isDeleteOnRight = (sap.ui.core.theming.Parameters.get("sapMPlatformDependent") != "true" && mode == "Delete"),
		createBlankCell = function(cls, id) {
			rm.write("<");
			rm.write(cellTag);
			id && rm.writeAttribute("id", idPrefix + id);
			rm.addClass(clsPrefix + cls);
			rm.writeClasses();
			rm.write("></");
			rm.write(cellTag);
			rm.write(">");
			index++;
		};

	rm.write("<" + groupTag + ">");
	rm.write("<tr");
	rm.writeAttribute("tabindex", -1);
	rm.writeAttribute("id", oTable.addNavSection(idPrefix + type + "er" ));

	if (isHeaderHidden) {
		rm.addClass("sapMListTblHeaderNone");
	} else {
		rm.addClass("sapMListTblRow sapMListTbl" + type + "er");
	}

	rm.writeClasses();
	rm.write(">");

	if (mode != "None" && mode != "SingleSelect" && !isDeleteOnRight) {
		if (mode == "SingleSelectMaster") {
			createBlankCell("None");
			hiddens++;
		} else if (mode == "MultiSelect" && type == "Head" && !isHeaderHidden) {
			rm.write("<th class='" + clsPrefix + "SelCol'><div class='sapMLIBSelectM'>");
			rm.renderControl(oTable._getSelectAllCheckbox());
			rm.write("</div></th>");
			index++;
		} else {
			createBlankCell("SelCol");
		}
	}

	if (sap.ui.core.theming.Parameters.get("sapUiLIUnreadAsBubble") == "true" && oTable.getShowUnread()) {
		createBlankCell("UnreadCol");
	}

	aColumns.forEach(function(oColumn, order) {
		oColumn.setIndex(-1);
		oColumn.setInitialOrder(order);
	});

	oTable.getColumns(true).forEach(function(oColumn, order) {
		if (!oColumn.getVisible()) {
			return;
		}
		if (oColumn.isPopin()) {
			hasPopin = true;
			return;
		}
		if (oColumn.isNeverVisible()) {
			return;
		}
		if (oColumn.isHidden()) {
			hiddens++;
		}

		var control = oColumn["get" + type + "er"](),
			width = hasOneHeader ? "" : oColumn.getWidth(),
			cls = oColumn.getStyleClass(true);

		rm.write("<" + cellTag);
		cls && rm.addClass(cls);
		rm.addClass(clsPrefix + "Cell");
		rm.writeAttribute("id", idPrefix + type + index);
		rm.writeAttribute("data-sap-orig-width", oColumn.getWidth());
		width && rm.addStyle("width", width);
		rm.addStyle("text-align", oColumn.getCssAlign());
		rm.writeClasses();
		rm.writeStyles();
		rm.write(">");
		if (control) {
			oColumn.applyAlignTo(control);
			rm.renderControl(control);
		}
		if (type == "Head" && !hasFooter) {
			hasFooter = !!oColumn.getFooter();
		}
		rm.write("</" + cellTag + ">");
		oColumn.setIndex(index++);
	});

	createBlankCell("NavCol", type + "Nav");

	if (mode == "SingleSelect" || isDeleteOnRight) {
		createBlankCell("SelCol");
	}

	rm.write("</tr></" + groupTag + ">");

	if (type == "Head") {
		oTable._hasPopin = hasPopin;
		oTable._colCount = index - hiddens;
		oTable._hasFooter = hasFooter;
		oTable._headerHidden = isHeaderHidden;
	}
};


/**
 * add table container class name
 */
sap.m.TableRenderer.renderContainerAttributes = function(rm, oControl) {
	oControl._bRendering = true;
	rm.addClass("sapMListTblCnt");
};

/**
 * render table tag and add required classes
 */
sap.m.TableRenderer.renderListStartAttributes = function(rm, oControl) {
	rm.write("<table");
	rm.addClass("sapMListTbl");
};

/**
 * generate table columns
 */
sap.m.TableRenderer.renderListHeadAttributes = function(rm, oControl) {
	this.renderColumns(rm, oControl, "Head");
	rm.write("<tbody");
	rm.writeAttribute("id", oControl.addNavSection(oControl.getId("tblBody")));
	rm.write(">");
};

/**
 * render footer and finish rendering table
 */
sap.m.TableRenderer.renderListEndAttributes = function(rm, oControl) {
	rm.write("</tbody>");	// items should be rendered before foot
	oControl._hasFooter && this.renderColumns(rm, oControl, "Foot");
	oControl._bRendering = false;
	rm.write("</table>");
};

/**
 * render no data
 */
sap.m.TableRenderer.renderNoData = function(rm, oControl) {
	rm.write("<tr");
	rm.writeAttribute("id", oControl.getId("nodata"));
	rm.addClass("sapMLIB sapMListTblRow sapMLIBTypeInactive");
	if (!oControl._headerHidden || (!oControl.getHeaderText() && !oControl.getHeaderToolbar()) ) {
		rm.addClass("sapMLIBShowSeparator");
	}
	rm.writeClasses();
	rm.write("><td");
	rm.writeAttribute("id", oControl.getId("nodata-text"));
	rm.writeAttribute("colspan", oControl.getColCount());
	rm.addClass("sapMListTblCell sapMListTblCellNoData");
	rm.writeClasses();
	rm.write(">");
	rm.writeEscaped(oControl.getNoDataText());
	rm.write("</td></tr>");
};

}; // end of sap/m/TableRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.TableSelectDialogRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare("sap.m.TableSelectDialogRenderer");

/**
 * @class SelectDialog renderer.
 * @static
 */
sap.m.TableSelectDialogRenderer = {
};

/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.m.TableSelectDialogRenderer.render = function (oRm, oControl) {
};
}; // end of sap/m/TableSelectDialogRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.TextAreaRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained


jQuery.sap.declare("sap.m.TextAreaRenderer");

/**
 * @class TextArea renderer.
 * @static
 */
sap.m.TextAreaRenderer = {};


/**
 * @class Input renderer.
 * @static
 *
 * TextAreaRenderer extends the TextAreaRenderer
 */
sap.m.TextAreaRenderer = sap.ui.core.Renderer.extend(sap.m.InputBaseRenderer);

// Adds control specific class
sap.m.TextAreaRenderer.addOuterClasses = function(oRm, oControl) {
	oRm.addClass("sapMTextArea");
};

// Write the opening tag name of the TextArea
sap.m.TextAreaRenderer.openInputTag = function(oRm, oControl) {
	oRm.write("<textarea");
};

// Write the closing tag name of the TextArea
sap.m.TextAreaRenderer.closeInputTag = function(oRm, oControl) {
	oRm.write("</textarea>");
};

// TextArea does not have value property as HTML element, so overwrite base method
sap.m.TextAreaRenderer.writeInnerValue = function() {
};

// Write the value of the TextArea
sap.m.TextAreaRenderer.writeInnerContent = function(oRm, oControl) {
	oRm.writeEscaped(oControl.getValue());
};

// Add extra classes for TextArea element
sap.m.TextAreaRenderer.addInnerClasses = function(oRm, oControl) {
	oRm.addClass("sapMTextAreaInner");
};

// Add extra attributes to TextArea
sap.m.TextAreaRenderer.writeInnerAttributes = function(oRm, oControl) {
	if (oControl.getWrapping() && oControl.getWrapping() != "None") {
		oRm.writeAttribute("wrap", oControl.getWrapping());
	}
	oRm.writeAttribute("rows", oControl.getRows());
	oRm.writeAttribute("cols", oControl.getCols());
};

// Add extra styles to TextArea
sap.m.TextAreaRenderer.addInnerStyles = function(oRm, oControl) {
	oControl.getHeight() && oRm.addStyle("height", oControl.getHeight());
};
}; // end of sap/m/TextAreaRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.TextRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.m.Text
jQuery.sap.declare("sap.m.TextRenderer");
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained


/**
 * @class Text renderer
 * @author SAP AG
 * @static
 */
sap.m.TextRenderer = {};

/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
 * @param {sap.m.Text} oText An object representation of the control that should be rendered.
 */
sap.m.TextRenderer.render = function(oRm, oText) {
	// return immediately if control is invisible
	if (!oText.getVisible()) {
		return;
	}

	// get control values
	var sWidth = oText.getWidth(),
		sText = oText.getText(true),
		sTextDir = oText.getTextDirection(),
		sTooltip = oText.getTooltip_AsString(),
		nMaxLines = oText.getMaxLines(),
		bWrapping = oText.getWrapping(),
		sTextAlign = oText.getTextAlign();

	// start writing html
	oRm.write("<span");
	oRm.writeControlData(oText);
	oRm.addClass("sapMText");

	// set classes for wrapping
	if (!bWrapping || nMaxLines == 1) {
		oRm.addClass("sapMTextNoWrap");
	} else if (bWrapping) {
		// no space text must break
		if (!/\s/.test(sText)) {
			oRm.addClass("sapMTextBreakWord");
		}
	}

	// write style and attributes
	sWidth ? oRm.addStyle("width", sWidth) : oRm.addClass("sapMTextMaxWidth");
	sTextDir && oRm.addStyle("direction", sTextDir.toLowerCase());
	sTooltip && oRm.writeAttributeEscaped("title", sTooltip);
	if (sTextAlign) {
		sTextAlign = sap.ui.core.Renderer.getTextAlign(sTextAlign, sTextDir);
		if (sTextAlign) {
			oRm.addStyle("text-align", sTextAlign);
		}
	}

	// finish writing html
	oRm.writeClasses();
	oRm.writeStyles();
	oRm.write(">");

	// handle max lines
	if (oText.hasMaxLines()) {
		this.renderMaxLines(oRm, oText);
	} else {
		this.renderText(oRm, oText);
	}

	// finalize
	oRm.write("</span>");
};

/**
 * Renders the max lines inner wrapper
 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
 * @param {sap.m.Text} oText An object representation of the control that should be rendered.
 */
sap.m.TextRenderer.renderMaxLines = function(oRm, oText) {
	oRm.write("<div");
	oRm.writeAttribute("id", oText.getId() + "-inner");
	oRm.addClass("sapMTextMaxLine");

	// check native line clamp support
	if (oText.canUseNativeLineClamp()) {
		oRm.addClass("sapMTextLineClamp");
		oRm.addStyle("-webkit-line-clamp", oText.getMaxLines());
	}

	oRm.writeClasses();
	oRm.writeStyles();
	oRm.write(">");
	this.renderText(oRm, oText);
	oRm.write("</div>");
};

/**
 * Renders the normalized text property.
 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
 * @param {sap.m.Text} oText An object representation of the control that should be rendered.
 */
sap.m.TextRenderer.renderText = function(oRm, oText) {
	var sText = oText.getText(true);
	oRm.writeEscaped(sText);
};
}; // end of sap/m/TextRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.TileContainerRenderer') ) {

/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare("sap.m.TileContainerRenderer");

/**
 * @class Bar renderer. 
 * @static
 */
sap.m.TileContainerRenderer = {
};


/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 * 
 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.m.TileContainerRenderer.render = function(rm, oControl) { 
	var id =  oControl.getId();

	rm.write("<div tabindex=\"-1\""); 
	rm.writeControlData(oControl);
	rm.addStyle("height",oControl.getHeight());
	rm.addStyle("width",oControl.getWidth());
	rm.writeStyles();
	rm.addClass("sapMTC");
	rm.writeClasses();
	rm.write(" >");
	rm.write("<div id=\""+ id+"-scrl\" class=\"sapMTCScrl\" style=\"height:0px;");
	if(!oControl.bRtl){ 
		rm.write(" overflow: hidden;");
	}
	rm.write("\">");
	rm.write("<div id=\""+ id+"-blind\" class=\"sapMTCBlind\"></div>");
	rm.write("<div id=\""+ id+"-cnt\" class=\"sapMTCCnt sapMTCAnim\" style=\"height:0px; width:0px;\">");
	var aTiles = oControl.getTiles();
	for (var i=0;i<aTiles.length;i++) {
		aTiles[i]._setVisible(false);
		rm.renderControl(aTiles[i]);
	}
	rm.write("</div>");
	rm.write("</div>");
	rm.write("<div id=\""+ id+"-pager\" class=\"sapMTCPager\">"); 
	rm.write("</div>");
	rm.write("<div id=\""+ id+"-leftedge\" class=\"sapMTCEdgeLeft\"></div>"); 
	rm.write("<div id=\""+ id+"-rightedge\" class=\"sapMTCEdgeRight\"></div>"); 
	rm.write("<div id=\""+ id+"-leftscroller\" class=\"sapMTCScroller sapMTCLeft\"><div class=\"sapMTCInner\"></div></div>"); 
	rm.write("<div id=\""+ id+"-rightscroller\" class=\"sapMTCScroller sapMTCRight\"><div class=\"sapMTCInner\"></div></div>"); 
	rm.write("</div>");
};
}; // end of sap/m/TileContainerRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.TileRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.m.Text
jQuery.sap.declare("sap.m.TileRenderer");
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained


/**
 * @class Text renderer
 * @author SAP AG
 * @static
 */
sap.m.TileRenderer = {};

/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 * @param {sap.ui.core.RenderManager} oRenderManager The RenderManager that can be used for writing to the render output buffer.
 * @param {sap.ui.core.Control} oControl An object representation of the control that should be rendered.
 */
sap.m.TileRenderer.render = function(rm, oControl) {
	rm.write("<div tabindex=\"0\"");
	rm.writeControlData(oControl);
	rm.addClass("sapMTile");
	rm.addClass("sapMPointer");
	rm.writeClasses();
	if(oControl._invisible){
		rm.addStyle("visibility", "hidden");
		rm.writeStyles();
	}
	var sTooltip = oControl.getTooltip_AsString();
	if (sTooltip) {
		rm.writeAttributeEscaped("title", sTooltip);
	}
	rm.write(">");
	if (oControl.getRemovable()) {
		rm.write("<div id=\"" + oControl.getId() + "-remove\" class=\"sapMTCRemove\"></div>");
	} else {
		rm.write("<div id=\"" + oControl.getId() + "-remove\" class=\"sapMTCNoRemove\"></div>");
	}
	rm.write("<div class=\"sapMTileContent\">");
	this._renderContent(rm,oControl);
	rm.write("</div></div>");
};


sap.m.TileRenderer._renderContent = function(rm, oControl) {
};


}; // end of sap/m/TileRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.ToolbarRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare("sap.m.ToolbarRenderer");
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained


/**
 * @class Toolbar renderer.
 * @static
 */
sap.m.ToolbarRenderer = {};

sap.m.ToolbarRenderer.render = function(rm, oToolbar) {
	if (oToolbar._isInvisible()) {
		return this.renderInvisible(rm, oToolbar);
	}

	rm.write("<div");
	rm.writeControlData(oToolbar);
	rm.addClass("sapMTB");

	if (!sap.m.Toolbar.hasFlexBoxSupport) {
		rm.addClass("sapMTBNoFlex");
	} else if (!sap.m.Toolbar.hasNewFlexBoxSupport) {
		rm.addClass("sapMTBOldFlex");
	} else {
		rm.addClass("sapMTBNewFlex");
	}

	if (oToolbar.getActive()) {
		rm.addClass("sapMTBActive");
		rm.writeAttribute("tabindex", "0");
	} else {
		rm.addClass("sapMTBInactive");
	}

	rm.addClass("sapMTB-" + oToolbar.getActiveDesign() + "-CTX");

	var sWidth = oToolbar.getWidth();
	var sHeight = oToolbar.getHeight();
	sWidth && rm.addStyle("width", sWidth);
	sHeight && rm.addStyle("height", sHeight);

	rm.writeClasses();
	rm.writeStyles();
	rm.write(">");

	oToolbar.getContent().forEach(function(oContent) {
		rm.renderControl(oContent);
	});

	rm.write("</div>");
};


// TODO: Add this functionality to more central place that every control can use
sap.m.ToolbarRenderer.renderInvisible = function(rm, oToolbar) {
	rm.write("<div");
	rm.writeControlData(oToolbar);
	rm.addStyle("display", "none");
	rm.writeStyles();
	rm.write("></div>");
};
}; // end of sap/m/ToolbarRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.ToolbarSpacerRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare("sap.m.ToolbarSpacerRenderer");
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained


/**
 * @class ToolbarSpacer renderer.
 * @static
 */
sap.m.ToolbarSpacerRenderer = {};

sap.m.ToolbarSpacerRenderer.render = function(rm, oControl) {
	rm.write("<div");
	rm.writeControlData(oControl);
	rm.addClass("sapMTBSpacer");

	var sWidth = oControl.getWidth();
	if (sWidth) {
		rm.addStyle("width", oControl.getWidth());
	} else {
		rm.addClass(sap.m.ToolbarSpacer.flexClass);
	}

	rm.writeStyles();
	rm.writeClasses();
	rm.write("></div>");
};
}; // end of sap/m/ToolbarSpacerRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.library') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* -----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ----------------------------------------------------------------------------------- */

/**
 * Initialization Code and shared classes of library sap.m (1.20.6)
 */
jQuery.sap.declare("sap.m.library");
jQuery.sap.require('sap.ui.core.Core'); // unlisted dependency retained

/**
 * SAPUI5 library with controls specialized for mobile devices.
 *
 * @namespace
 * @name sap.m
 * @public
 */


// library dependencies
jQuery.sap.require('sap.ui.core.library'); // unlisted dependency retained


// delegate further initialization of this library to the Core
sap.ui.getCore().initLibrary({
  name : "sap.m",
  dependencies : ["sap.ui.core"],
  types: [
    "sap.m.BackgroundDesign",
    "sap.m.ButtonType",
    "sap.m.DateTimeInputType",
    "sap.m.DialogType",
    "sap.m.FacetFilterType",
    "sap.m.FlexAlignItems",
    "sap.m.FlexAlignSelf",
    "sap.m.FlexDirection",
    "sap.m.FlexJustifyContent",
    "sap.m.FlexRendertype",
    "sap.m.HeaderLevel",
    "sap.m.IconTabFilterDesign",
    "sap.m.InputType",
    "sap.m.LabelDesign",
    "sap.m.ListHeaderDesign",
    "sap.m.ListMode",
    "sap.m.ListSeparators",
    "sap.m.ListType",
    "sap.m.PageBackgroundDesign",
    "sap.m.PlacementType",
    "sap.m.PopinDisplay",
    "sap.m.RatingIndicatorVisualMode",
    "sap.m.ScreenSize",
    "sap.m.SelectType",
    "sap.m.SplitAppMode",
    "sap.m.StandardTileType",
    "sap.m.SwipeDirection",
    "sap.m.SwitchType",
    "sap.m.ToolbarDesign"
  ],
  interfaces: [
    "sap.m.IconTab"
  ],
  controls: [
    "sap.m.ActionListItem",
    "sap.m.ActionSelect",
    "sap.m.ActionSheet",
    "sap.m.App",
    "sap.m.Bar",
    "sap.m.BusyDialog",
    "sap.m.BusyIndicator",
    "sap.m.Button",
    "sap.m.Carousel",
    "sap.m.CheckBox",
    "sap.m.ColumnListItem",
    "sap.m.CustomListItem",
    "sap.m.CustomTile",
    "sap.m.DateTimeInput",
    "sap.m.Dialog",
    "sap.m.DisplayListItem",
    "sap.m.FacetFilter",
    "sap.m.FacetFilterItem",
    "sap.m.FacetFilterList",
    "sap.m.FeedListItem",
    "sap.m.FlexBox",
    "sap.m.GroupHeaderListItem",
    "sap.m.GrowingList",
    "sap.m.HBox",
    "sap.m.IconTabBar",
    "sap.m.Image",
    "sap.m.Input",
    "sap.m.InputBase",
    "sap.m.InputListItem",
    "sap.m.Label",
    "sap.m.Link",
    "sap.m.List",
    "sap.m.ListBase",
    "sap.m.ListItemBase",
    "sap.m.NavContainer",
    "sap.m.ObjectAttribute",
    "sap.m.ObjectHeader",
    "sap.m.ObjectIdentifier",
    "sap.m.ObjectListItem",
    "sap.m.ObjectNumber",
    "sap.m.ObjectStatus",
    "sap.m.Page",
    "sap.m.Panel",
    "sap.m.Popover",
    "sap.m.ProgressIndicator",
    "sap.m.PullToRefresh",
    "sap.m.RadioButton",
    "sap.m.RatingIndicator",
    "sap.m.ResponsivePopover",
    "sap.m.ScrollContainer",
    "sap.m.SearchField",
    "sap.m.SegmentedButton",
    "sap.m.Select",
    "sap.m.SelectDialog",
    "sap.m.Shell",
    "sap.m.Slider",
    "sap.m.SplitApp",
    "sap.m.SplitContainer",
    "sap.m.StandardListItem",
    "sap.m.StandardTile",
    "sap.m.Switch",
    "sap.m.Table",
    "sap.m.TableSelectDialog",
    "sap.m.Text",
    "sap.m.TextArea",
    "sap.m.Tile",
    "sap.m.TileContainer",
    "sap.m.Toolbar",
    "sap.m.ToolbarSpacer",
    "sap.m.VBox",
    "sap.m.ViewSettingsDialog"
  ],
  elements: [
    "sap.m.Column",
    "sap.m.FlexItemData",
    "sap.m.IconTabFilter",
    "sap.m.IconTabSeparator",
    "sap.m.ToolbarLayoutData",
    "sap.m.ViewSettingsCustomItem",
    "sap.m.ViewSettingsFilterItem",
    "sap.m.ViewSettingsItem"
  ],
  version: "1.20.6"});

/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.m.BackgroundDesign.
jQuery.sap.declare("sap.m.BackgroundDesign");


/**
 * @class Available Background Design.
 *
 * @version 1.20.6
 * @static
 * @public
 */
sap.m.BackgroundDesign = {
  
    /**
     * A solid background color dependent on the theme. 
     * @public
     */
    Solid : "Solid",

    /**
     * Transparent background. 
     * @public
     */
    Transparent : "Transparent",

    /**
     * A translucent background depending on the opacity value of the theme. 
     * @public
     */
    Translucent : "Translucent"

  };
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.m.ButtonType.
jQuery.sap.declare("sap.m.ButtonType");


/**
 * @class Different types for a button (predefined types)
 *
 * @version 1.20.6
 * @static
 * @public
 */
sap.m.ButtonType = {
  
    /**
     * default type (no special styling) 
     * @public
     */
    Default : "Default",

    /**
     * back type (back navigation button for header) 
     * @public
     */
    Back : "Back",

    /**
     * accept type (blue button) 
     * @public
     */
    Accept : "Accept",

    /**
     * reject style (red button) 
     * @public
     */
    Reject : "Reject",

    /**
     * transparent type 
     * @public
     */
    Transparent : "Transparent",

    /**
     * up type (up navigation button for header) 
     * @public
     */
    Up : "Up",

    /**
     * Unstyled type (no styling) 
     * @public
     */
    Unstyled : "Unstyled",

    /**
     * emphasized type 
     * @public
     */
    Emphasized : "Emphasized"

  };
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.m.DateTimeInputType.
jQuery.sap.declare("sap.m.DateTimeInputType");


/**
 * @class A subset of DateTimeInput types that fit to a simple API returning one string.
 *
 * @version 1.20.6
 * @static
 * @public
 */
sap.m.DateTimeInputType = {
  
    /**
     * An input control for specifying a date value. The user can select a month, day of the month, and year. 
     * @public
     */
    Date : "Date",

    /**
     * An input control for specifying a date and time value. The user can select a month, day of the month, year, and time of day. 
     * @public
     */
    DateTime : "DateTime",

    /**
     * An input control for specifying a time value. The user can select the hour, minute, and optionally AM or PM. 
     * @public
     */
    Time : "Time"

  };
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.m.DialogType.
jQuery.sap.declare("sap.m.DialogType");


/**
 * @class Enum for the type of sap.m.Dialog control.
 *
 * @version 1.20.6
 * @static
 * @public
 */
sap.m.DialogType = {
  
    /**
     * This is the default value for Dialog type. Stardard dialog in iOS has a header on the top and the left, right buttons are put inside the header. In android, the left, right buttons are put to the bottom of the Dialog. 
     * @public
     */
    Standard : "Standard",

    /**
     * Dialog with type Message looks the same as the Stardard Dialog in Android. And it puts the left, right buttons to the bottom of the Dialog in iOS. 
     * @public
     */
    Message : "Message"

  };
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.m.FacetFilterType.
jQuery.sap.declare("sap.m.FacetFilterType");


/**
 * @class Used by the FacetFilter control to adapt its design according to type.
 * 
 *
 * @version 1.20.6
 * @static
 * @public
 */
sap.m.FacetFilterType = {
  
    /**
     * Forces FacetFilter to display facet lists as a row of buttons, one button per facet. The FacetFilter will automatically adapt to the Light type when it detects smart phone sized displays. 
     * @public
     */
    Simple : "Simple",

    /**
     * Forces FacetFilter to display in light mode. 
     * @public
     */
    Light : "Light"

  };
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.m.FlexAlignItems.
jQuery.sap.declare("sap.m.FlexAlignItems");


/**
 * @class Available options for the layout of all elements along the cross axis of the flexbox layout.
 *
 * @version 1.20.6
 * @static
 * @public
 */
sap.m.FlexAlignItems = {
  
    /**
     * The cross-start margin edges of the box items are placed flush with the cross-start edge of the line. 
     * @public
     */
    Start : "Start",

    /**
     * The cross-start margin edges of the box items are placed flush with the cross-end edge of the line. 
     * @public
     */
    End : "End",

    /**
     * The box items' margin boxes are centered in the cross axis within the line. 
     * @public
     */
    Center : "Center",

    /**
     * If the box items' inline axes are the same as the cross axis, this value is identical to ?start?. Otherwise, it participates in baseline alignment: all participating box items on the line are aligned such that their baselines align, and the item with the largest distance between its baseline and its cross-start margin edge is placed flush against the cross-start edge of the line. 
     * @public
     */
    Baseline : "Baseline",

    /**
     * Make the cross size of the items' margin boxes as close to the same size as the line as possible. 
     * @public
     */
    Stretch : "Stretch",

    /**
     * Inherits the value from its parent. 
     * @public
     */
    Inherit : "Inherit"

  };
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.m.FlexAlignSelf.
jQuery.sap.declare("sap.m.FlexAlignSelf");


/**
 * @class Available options for the layout of individual elements along the cross axis of the flexbox layout overriding the default alignment.
 *
 * @version 1.20.6
 * @static
 * @public
 */
sap.m.FlexAlignSelf = {
  
    /**
     * Takes up the value of alignItems from the parent FlexBox 
     * @public
     */
    Auto : "Auto",

    /**
     * The cross-start margin edges of the box item is placed flush with the cross-start edge of the line. 
     * @public
     */
    Start : "Start",

    /**
     * The cross-start margin edges of the box item is placed flush with the cross-end edge of the line. 
     * @public
     */
    End : "End",

    /**
     * The box item's margin box is centered in the cross axis within the line. 
     * @public
     */
    Center : "Center",

    /**
     * If the box item's inline axis is the same as the cross axis, this value is identical to ?start?. Otherwise, it participates in baseline alignment: all participating box items on the line are aligned such that their baselines align, and the item with the largest distance between its baseline and its cross-start margin edge is placed flush against the cross-start edge of the line. 
     * @public
     */
    Baseline : "Baseline",

    /**
     * Make the cross size of the item's margin box as close to the same size as the line as possible. 
     * @public
     */
    Stretch : "Stretch",

    /**
     * Inherits the value from its parent. 
     * @public
     */
    Inherit : "Inherit"

  };
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.m.FlexDirection.
jQuery.sap.declare("sap.m.FlexDirection");


/**
 * @class Available directions for flex layouts.
 *
 * @version 1.20.6
 * @static
 * @public
 */
sap.m.FlexDirection = {
  
    /**
     * Elements are layed out along the direction of the inline axis (text direction). 
     * @public
     */
    Row : "Row",

    /**
     * Elements are layed out along the direction of the block axis (usually top to bottom). 
     * @public
     */
    Column : "Column",

    /**
     * Elements are layed out along the reverse direction of the inline axis (against the text direction). 
     * @public
     */
    RowReverse : "RowReverse",

    /**
     * Elements are layed out along the reverse direction of the block axis (usually bottom to top). 
     * @public
     */
    ColumnReverse : "ColumnReverse",

    /**
     * Inherits the value from its parent. 
     * @public
     */
    Inherit : "Inherit"

  };
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.m.FlexJustifyContent.
jQuery.sap.declare("sap.m.FlexJustifyContent");


/**
 * @class Available options for the layout of elements along the main axis of the flexbox layout.
 *
 * @version 1.20.6
 * @static
 * @public
 */
sap.m.FlexJustifyContent = {
  
    /**
     * Box items are packed toward the start of the line. 
     * @public
     */
    Start : "Start",

    /**
     * Box items are packed toward the end of the line. 
     * @public
     */
    End : "End",

    /**
     * Box items are packed toward the center of the line. 
     * @public
     */
    Center : "Center",

    /**
     * Box items are evenly distributed in the line. 
     * @public
     */
    SpaceBetween : "SpaceBetween",

    /**
     * Box items are evenly distributed in the line, with half-size spaces on either end. 
     * @public
     */
    SpaceAround : "SpaceAround",

    /**
     * Inherits the value from its parent. 
     * @public
     */
    Inherit : "Inherit"

  };
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.m.FlexRendertype.
jQuery.sap.declare("sap.m.FlexRendertype");


/**
 * @class Determines the type of HTML elements used for rendering controls.
 *
 * @version 1.20.6
 * @static
 * @public
 */
sap.m.FlexRendertype = {
  
    /**
     * DIV elements are used for rendering 
     * @public
     */
    Div : "Div",

    /**
     * Unordered lists are used for rendering. 
     * @public
     */
    List : "List"

  };
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.m.HeaderLevel.
jQuery.sap.declare("sap.m.HeaderLevel");


/**
 * @class Different levels for headers
 *
 * @version 1.20.6
 * @static
 * @public
 */
sap.m.HeaderLevel = {
  
    /**
     * Header level 1 
     * @public
     */
    H1 : "H1",

    /**
     * Header level 2 
     * @public
     */
    H2 : "H2",

    /**
     * Header level 3 
     * @public
     */
    H3 : "H3",

    /**
     * Header level 4 
     * @public
     */
    H4 : "H4",

    /**
     * Header level 5 
     * @public
     */
    H5 : "H5",

    /**
     * Header level 6 
     * @public
     */
    H6 : "H6"

  };
/**
 * 
 *   Marker interface for controls which are suitable as items for the IconTabBar.
 *   These controls must implement a method isSelectable().
 *   
 *
 * @name sap.m.IconTab
 * @interface
 * @public
 */

/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.m.IconTabFilterDesign.
jQuery.sap.declare("sap.m.IconTabFilterDesign");


/**
 * @class Available Filter Item Design.
 *
 * @version 1.20.6
 * @static
 * @public
 */
sap.m.IconTabFilterDesign = {
  
    /**
     * A horizontally layouted design providing more space for texts. 
     * @public
     */
    Horizontal : "Horizontal",

    /**
     * A vertically layouted design using minimum horizontal space. 
     * @public
     */
    Vertical : "Vertical"

  };
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.m.InputType.
jQuery.sap.declare("sap.m.InputType");


/**
 * @class A subset of input types that fit to a simple API returning one string.
 * Not available on purpose: button, checkbox, hidden, image, password, radio, range, reset, search, submit.
 *
 * @version 1.20.6
 * @static
 * @public
 */
sap.m.InputType = {
  
    /**
     * default (text) 
     * @public
     */
    Text : "Text",

    /**
     * An input control for specifying a date value. The user can select a month, day of the month, and year. 
     * @public
     * @deprecated Since version 1.9.1. 
     * Please use sap.m.DateTimeInput control with type "Date" to create date input.
     */
    Date : "Date",

    /**
     * An input control for specifying a date and time value. The user can select a month, day of the month, year, and time of day. 
     * @public
     * @deprecated Since version 1.9.1. 
     * Please use dedicated sap.m.DateTimeInput control with type "DateTime" to create date-time input.
     */
    Datetime : "Datetime",

    /**
     * An input control for specifying a date and time value where the format depends on the locale. 
     * @public
     * @deprecated Since version 1.9.1. 
     * Please use dedicated sap.m.DateTimeInput control with type "DateTime" to create date-time input.
     */
    DatetimeLocale : "DatetimeLocale",

    /**
     * A text field for specifying an email address. Brings up a keyboard optimized for email address entry. 
     * @public
     */
    Email : "Email",

    /**
     * An input control for selecting a month. 
     * @public
     * @deprecated Since version 1.9.1. 
     * There is no cross-platform support. Please do not use this Input type.
     */
    Month : "Month",

    /**
     * A text field for specifying a number. Brings up a number pad keyboard. Specifying an input type of \d* or [0-9]* is equivalent to using this type. 
     * @public
     */
    Number : "Number",

    /**
     * A text field for specifying a phone number. Brings up a phone pad keyboard. 
     * @public
     */
    Tel : "Tel",

    /**
     * An input control for specifying a time value. The user can select the hour, minute, and optionally AM or PM. 
     * @public
     * @deprecated Since version 1.9.1. 
     * Please use dedicated sap.m.DateTimeInput control with type "Time" to create time input.
     */
    Time : "Time",

    /**
     * A text field for specifying a URL. Brings up a keyboard optimized for URL entry. 
     * @public
     */
    Url : "Url",

    /**
     * An input control for selecting a week. 
     * @public
     * @deprecated Since version 1.9.1. 
     * There is no cross-platform support. Please do not use this Input type.
     */
    Week : "Week",

    /**
     * Password input where the user entry cannot be seen. 
     * @public
     */
    Password : "Password"

  };
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.m.LabelDesign.
jQuery.sap.declare("sap.m.LabelDesign");


/**
 * @class Available label display modes.
 *
 * @version 1.20.6
 * @static
 * @public
 */
sap.m.LabelDesign = {
  
    /**
     * Displays the label in bold. 
     * @public
     */
    Bold : "Bold",

    /**
     * Displays the label in normal mode. 
     * @public
     */
    Standard : "Standard"

  };
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.m.ListHeaderDesign.
jQuery.sap.declare("sap.m.ListHeaderDesign");


/**
 * @class Defines the differnet header styles.
 *
 * @version 1.20.6
 * @static
 * @public
 * @deprecated Since version 1.16. 
 * Has no functionality since 1.16.
 */
sap.m.ListHeaderDesign = {
  
    /**
     * Standard header style 
     * @public
     */
    Standard : "Standard",

    /**
     * Plain header style 
     * @public
     */
    Plain : "Plain"

  };
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.m.ListMode.
jQuery.sap.declare("sap.m.ListMode");


/**
 * @class Different modes for the list selection (predefined modes)
 *
 * @version 1.20.6
 * @static
 * @public
 */
sap.m.ListMode = {
  
    /**
     * default mode (no selection) 
     * @public
     */
    None : "None",

    /**
     * right positioned single selection mode (only one list item can be selected) 
     * @public
     */
    SingleSelect : "SingleSelect",

    /**
     * multi selection mode (whole list item including checkbox will be selected) 
     * @public
     */
    MultiSelect : "MultiSelect",

    /**
     * delete mode (only one list item can be deleted) 
     * @public
     */
    Delete : "Delete",

    /**
     * Single selection master mode (only one list item can be selected), selected item is highlighted but no radiobutton is visible. 
     * @public
     */
    SingleSelectMaster : "SingleSelectMaster",

    /**
     * left positioned single selection mode (only one list item can be selected) 
     * @public
     */
    SingleSelectLeft : "SingleSelectLeft"

  };
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.m.ListSeparators.
jQuery.sap.declare("sap.m.ListSeparators");


/**
 * @class Defines which separator style will be taken.
 *
 * @version 1.20.6
 * @static
 * @public
 */
sap.m.ListSeparators = {
  
    /**
     * Separators around all items. 
     * @public
     */
    All : "All",

    /**
     * Separators only between the items. 
     * @public
     */
    Inner : "Inner",

    /**
     * No Separators are used. 
     * @public
     */
    None : "None"

  };
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.m.ListType.
jQuery.sap.declare("sap.m.ListType");


/**
 * @class List types
 *
 * @version 1.20.6
 * @static
 * @public
 */
sap.m.ListType = {
  
    /**
     * Inactive 
     * @public
     */
    Inactive : "Inactive",

    /**
     * Detail 
     * @public
     */
    Detail : "Detail",

    /**
     * Navigation 
     * @public
     */
    Navigation : "Navigation",

    /**
     * Active 
     * @public
     */
    Active : "Active",

    /**
     * DetailAndActive 
     * @public
     */
    DetailAndActive : "DetailAndActive"

  };
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.m.PageBackgroundDesign.
jQuery.sap.declare("sap.m.PageBackgroundDesign");


/**
 * @class Available Page Background Design.
 *
 * @version 1.20.6
 * @static
 * @public
 */
sap.m.PageBackgroundDesign = {
  
    /**
     * Standard Page background color. 
     * @public
     */
    Standard : "Standard",

    /**
     * Page background color when a List is set as the Page content. 
     * @public
     */
    List : "List",

    /**
     * A solid background color dependent on the theme. 
     * @public
     */
    Solid : "Solid",

    /**
     * Transparent background for the page. 
     * @public
     */
    Transparent : "Transparent"

  };
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.m.PlacementType.
jQuery.sap.declare("sap.m.PlacementType");


/**
 * @class Types for the placement of popover control.
 *
 * @version 1.20.6
 * @static
 * @public
 */
sap.m.PlacementType = {
  
    /**
     * Popover will be placed at the left side of the reference control. 
     * @public
     */
    Left : "Left",

    /**
     * Popover will be placed at the right side of the reference control. 
     * @public
     */
    Right : "Right",

    /**
     * Popover will be placed at the top of the reference control. 
     * @public
     */
    Top : "Top",

    /**
     * Popover will be placed at the bottom of the reference control. 
     * @public
     */
    Bottom : "Bottom",

    /**
     * Popover will be placed at the top or bottom of the reference control. 
     * @public
     */
    Vertical : "Vertical",

    /**
     * Popover will be placed at the right or left side of the reference control. 
     * @public
     */
    Horizontal : "Horizontal",

    /**
     * Popover will be placed automatically at the reference control. 
     * @public
     */
    Auto : "Auto"

  };
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.m.PopinDisplay.
jQuery.sap.declare("sap.m.PopinDisplay");


/**
 * @class Defines the display of table pop-ins
 *
 * @version 1.20.6
 * @static
 * @public
 * @since 1.13.2
 */
sap.m.PopinDisplay = {
  
    /**
     * Inside the table popin, header is displayed in first line and value field is displayed in next line. 
     * @public
     */
    Block : "Block",

    /**
     * Inside the table popin, value field is displayed next to the header in the same line. Note: If there is no enough space for the value field then goes to next line. 
     * @public
     */
    Inline : "Inline"

  };
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.m.RatingIndicatorVisualMode.
jQuery.sap.declare("sap.m.RatingIndicatorVisualMode");


/**
 * @class Possible values for the visualization of float values in the RatingIndicator Control.
 *
 * @version 1.20.6
 * @static
 * @public
 */
sap.m.RatingIndicatorVisualMode = {
  
    /**
     * Values are rounded to the nearest integer value (e.g. 1.7 -> 2). 
     * @public
     */
    Full : "Full",

    /**
     * Values are rounded to the nearest half value (e.g. 1.7 -> 1.5). 
     * @public
     */
    Half : "Half"

  };
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.m.ScreenSize.
jQuery.sap.declare("sap.m.ScreenSize");


/**
 * @class Breakpoint names for different screen sizes.
 *
 * @version 1.20.6
 * @static
 * @public
 */
sap.m.ScreenSize = {
  
    /**
     * 240px wide 
     * @public
     */
    Phone : "Phone",

    /**
     * 600px wide 
     * @public
     */
    Tablet : "Tablet",

    /**
     * 1024px wide 
     * @public
     */
    Desktop : "Desktop",

    /**
     * 240px wide 
     * @public
     */
    XXSmall : "XXSmall",

    /**
     * 320px wide 
     * @public
     */
    XSmall : "XSmall",

    /**
     * 480px wide 
     * @public
     */
    Small : "Small",

    /**
     * 560px wide 
     * @public
     */
    Medium : "Medium",

    /**
     * 768px wide 
     * @public
     */
    Large : "Large",

    /**
     * 960px wide 
     * @public
     */
    XLarge : "XLarge",

    /**
     * 1120px wide 
     * @public
     */
    XXLarge : "XXLarge"

  };
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.m.SelectType.
jQuery.sap.declare("sap.m.SelectType");


/**
 * @class Enumeration for different Select types.
 *
 * @version 1.20.6
 * @static
 * @public
 * @since 1.16
 */
sap.m.SelectType = {
  
    /**
     * Will show the text. 
     * @public
     */
    Default : "Default",

    /**
     * Will show only the specified icon. 
     * @public
     */
    IconOnly : "IconOnly"

  };
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.m.SplitAppMode.
jQuery.sap.declare("sap.m.SplitAppMode");


/**
 * @class The mode of SplitContainer or SplitApp control to show/hide the master area.
 *
 * @version 1.20.6
 * @static
 * @public
 */
sap.m.SplitAppMode = {
  
    /**
     * Master will automatically be hidden in portrait mode. 
     * @public
     */
    ShowHideMode : "ShowHideMode",

    /**
     * Master will always be shown but in a compressed version when in portrait mode. 
     * @public
     */
    StretchCompressMode : "StretchCompressMode",

    /**
     * Master will be shown inside a Popover when in portrait mode 
     * @public
     */
    PopoverMode : "PopoverMode",

    /**
     * Master area is hidden initially both in portrait and landscape. Master area can be opened by clicking on the top left corner button or swiping right. Swipe is only enabled on mobile devices. Master will keep the open state when changing the orientation of the device. 
     * @public
     */
    HideMode : "HideMode"

  };
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.m.StandardTileType.
jQuery.sap.declare("sap.m.StandardTileType");


/**
 * @class Types for StandardTile
 *
 * @version 1.20.6
 * @static
 * @public
 */
sap.m.StandardTileType = {
  
    /**
     * Tile representing that something needs to be created 
     * @public
     */
    Create : "Create",

    /**
     * Monitor tile 
     * @public
     */
    Monitor : "Monitor",

    /**
     * Default type 
     * @public
     */
    None : "None"

  };
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.m.SwipeDirection.
jQuery.sap.declare("sap.m.SwipeDirection");


/**
 * @class Directions for swipe event.
 *
 * @version 1.20.6
 * @static
 * @public
 */
sap.m.SwipeDirection = {
  
    /**
     * Swipe from left to right 
     * @public
     */
    LeftToRight : "LeftToRight",

    /**
     * Swipe from right to left. 
     * @public
     */
    RightToLeft : "RightToLeft",

    /**
     * Both directions (left to right or right to left) 
     * @public
     */
    Both : "Both"

  };
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.m.SwitchType.
jQuery.sap.declare("sap.m.SwitchType");


/**
 * @class Enumaration for different switch types.
 *
 * @version 1.20.6
 * @static
 * @public
 */
sap.m.SwitchType = {
  
    /**
     * Will show "ON" and "OFF" translated to the current language or the custom text if provided 
     * @public
     */
    Default : "Default",

    /**
     * Switch with accept and reject icons 
     * @public
     */
    AcceptReject : "AcceptReject"

  };
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.type, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides enumeration sap.m.ToolbarDesign.
jQuery.sap.declare("sap.m.ToolbarDesign");


/**
 * @class Types of the Toolbar Design
 *
 * @version 1.20.6
 * @static
 * @public
 * @since 1.16.8
 */
sap.m.ToolbarDesign = {
  
    /**
     * The toolbar can be inserted into other controls and if the design is "Auto" then it inherits the design from parent control. 
     * @public
     */
    Auto : "Auto",

    /**
     * The toolbar and its content will be displayed transparent. 
     * @public
     */
    Transparent : "Transparent",

    /**
     * The toolbar appears smaller than the regular size to show information(e.g: text, icon). 
     * @public
     */
    Info : "Info"

  };

// -----------------------------------------------------------------------------
// Begin of Library Initialization coding, copied from shared.js
// -----------------------------------------------------------------------------

/*global Element: true */

/*!
 * @copyright@
 */

// In case the Core decides to throw it out... This module shall always be available when using the mobile lib.
jQuery.sap.require('jquery.sap.mobile'); // unlisted dependency retained


//enable support feature


//lazy imports for MessageToast
sap.ui.lazyRequire("sap.m.MessageToast", "show");

//enable ios7 support
jQuery.sap.require('sap.ui.Device'); // unlisted dependency retained

if (sap.ui.Device.os.ios && sap.ui.Device.os.version >= 7 && sap.ui.Device.os.version < 8 && sap.ui.Device.browser.name === "sf") {
	jQuery.sap.require('sap.m.ios7'); // unlisted dependency retained

}

// central mobile functionality that should not go into the UI5 Core can go from here
// ----------------------------------------------------------------------------------

/**
 * Touch helper.
 *
 * @namespace
 * @name sap.m.touch
 * @public
 **/

if (sap.m && !sap.m.touch) {
	sap.m.touch = {};
}

/**
 * Given a list of touch objects, find the touch that matches the given one.
 *
 * @param {TouchList} oTouchList The list of touch objects to search.
 * @param {Touch|number} oTouch A touch object to find or a Touch.identifier that uniquely identifies the current finger in the touch session.
 * @return {object|undefined} The touch matching if any.
 * @public
 * @name sap.m.touch.find
 * @function
*/
sap.m.touch.find = function(oTouchList, oTouch) {
	var i,
		iTouchListLength;

	if (!(oTouchList instanceof Object)) {
		jQuery.sap.assert(false, 'sap.m.touch.find(): oTouchList must be a touch list object');
		return;
	}

	if (oTouch instanceof Object && typeof oTouch.identifier !== "undefined") {
		oTouch = oTouch.identifier;
	} else if (typeof oTouch !== "number") {
		jQuery.sap.assert(false, 'sap.m.touch.find(): oTouch must be a touch object or a number');
		return;
	}

	iTouchListLength = oTouchList.length;

	// A TouchList is an object not an array, so we shouldn't use
	// Array.prototype.forEach, etc.
	for (i = 0; i < iTouchListLength; i++) {
		if (oTouchList[i].identifier === oTouch) {
			return oTouchList[i];
		}
	}

	// if the given touch object or touch identifier is not found in the touches list, then return undefined
};

/**
 * Given a list of touches, count the number of touches related with the given element.
 *
 * @param {TouchList} oTouchList The list of touch objects to search.
 * @param {jQuery|Element|string} vElement A jQuery element or an element reference or an element id.
 * @return {number} The number of touches related with the given element.
 * @public
 * @name sap.m.touch.countContained
 * @function
*/
sap.m.touch.countContained = function(oTouchList, vElement) {
	var i,
		iTouchCount = 0,
		iTouchListLength,
		iElementChildrenL,
		$TouchTarget;

	if (!(oTouchList instanceof Object)) {
		jQuery.sap.assert(false, 'sap.m.touch.countContained(): oTouchList must be a TouchList object');
		return;
	}

	if (vElement instanceof Element) {
		vElement = jQuery(vElement);
	} else if (typeof vElement === "string") {
		vElement = jQuery.sap.byId(vElement);
	} else if (!(vElement instanceof jQuery)) {
		jQuery.sap.assert(false, 'sap.m.touch.countContained(): vElement must be a jQuery object or Element reference or a string');
		return;
	}

	iElementChildrenL = vElement.children().length;
	iTouchListLength = oTouchList.length;

	// A TouchList is an object not an array, so we shouldn't use
	// Array.prototype.forEach, etc.
	for (i = 0; i < iTouchListLength; i++) {
		$TouchTarget = jQuery(oTouchList[i].target);

		//	If the current target have only one HTML element or
		//	have a HTML element antecessor that match with the given element id.
		if ((iElementChildrenL === 0  && $TouchTarget.is(vElement)) ||
			(vElement[0].contains($TouchTarget[0]))) {

			iTouchCount++;
		}
	}

	return iTouchCount;
};

!function(oLib) {

	/**
	 * Returns invalid date value of UI5
	 *
	 * @deprecated Since 1.12 UI5 returns null for invalid date
	 * @returns {null}
	 * @public
	 * @since 1.10
	 * @name sap.m#getInvalidDate
	 * @function
	 */
	oLib.getInvalidDate = function() {
		return null;
	};


	/**
	 * Finds default locale settings once and returns always the same.
	 * We should not need to create new instance to get same locale settings
	 * This method keep the locale instance in the scope and returns the same after first run
	 *
	 * @return {Object} sap.ui.core.Locale instane
	 * @public
	 * @since 1.10
	 * @name sap.m#getLocale
	 * @function
	 */
	oLib.getLocale = function() {
		var oConfig = sap.ui.getCore().getConfiguration(),
			sLocale = oConfig.getFormatSettings().getFormatLocale().toString(),
			oLocale = new sap.ui.core.Locale(sLocale);

		oConfig = sLocale = null; //maybe helps GC
		oLib.getLocale = function() {
			return oLocale;
		};

		return oLocale;
	};

	/**
	 * Finds default locale data once and returns always the same
	 *
	 * @return {Object} sap.ui.core.LocaleData instance
	 * @public
	 * @since 1.10
	 * @name sap.m#getLocaleData
	 * @function
	 */
	oLib.getLocaleData = function() {
		jQuery.sap.require("sap.ui.model.type.Date");
		var oLocaleData = sap.ui.core.LocaleData.getInstance(oLib.getLocale());

		oLib.getLocaleData = function() {
			return oLocaleData;
		};

		return oLocaleData;
	};

	/**
	 * Checks if the given parameter is a valid JsDate Object
	 *
	 * @param {any} value Any variable to test.
	 * @return {boolean}
	 * @public
	 * @since 1.10
	 * @name sap.m#isDate
	 * @function
	 */
	oLib.isDate = function(value) {
		return value && Object.prototype.toString.call(value) == "[object Date]" && !isNaN(value);
	};


	/**
	 * Search given control's parents and try to find iScroll
	 *
	 * @param {sap.ui.core.Control} oControl
	 * @return {iScroll|undefined} iScroll reference or undefined if cannot find
	 * @name sap.m#getIScroll
	 * @public
	 * @since 1.11
	 */
	oLib.getIScroll = function(oControl) {
		if (typeof window.iScroll != "function" || !(oControl instanceof sap.ui.core.Control)) {
			return;
		}

		var parent, scroller;
		for (parent = oControl; parent = parent.oParent;) {
			scroller = parent.getScrollDelegate ? parent.getScrollDelegate()._scroller : null;
			if (scroller && scroller instanceof window.iScroll) {
				return scroller;
			}
		}
	};


	/**
	 * Search given control's parents and try to find ScrollDelegate
	 *
	 * @param {sap.ui.core.Control} oControl
	 * @return {Object|undefined} ScrollDelegate or undefined if cannot find
	 * @name sap.m#getScrollDelegate
	 * @public
	 * @since 1.11
	 */
	oLib.getScrollDelegate = function(oControl) {
		if (!(oControl instanceof sap.ui.core.Control)) {
			return;
		}

		for (var parent = oControl; parent = parent.oParent;) {
			if (typeof parent.getScrollDelegate == "function") {
				return parent.getScrollDelegate();
			}
		}
	};

	/**
	 * screen size definitions in pixel
	 * if you change any value here, please also change
	 * 	1. the documentation of sap.m.ScreenSize
	 *  2. media queries in list.css
	 *
	 * @private
	 * @since 1.12
	 * @name sap.m#ScreenSizes
	 */
	oLib.ScreenSizes = {
		phone : 240,
		tablet : 600,
		desktop : 1024,
		xxsmall : 240,
		xsmall : 320,
		small : 480,
		medium : 560,
		large : 768,
		xlarge : 960,
		xxlarge : 1120
	};

	/**
	 * Base font-size
	 * @private
	 * @since 1.12
	 * @name sap.m#BaseFontSize
	 */
	oLib.BaseFontSize = jQuery(document.documentElement).css("font-size");

	/**
	 * Hide the soft keyboard
	 *
	 * @name sap.m#closeKeyboard
	 * @public
	 * @since 1.20
	 */
	oLib.closeKeyboard = function() {
		var activeElement = document.activeElement;
		if(!sap.ui.Device.system.desktop && activeElement && /(INPUT|TEXTAREA)/i.test(activeElement.tagName)) {
			activeElement.blur();
		}
	};


}(sap.m);



/**
 * <pre>
 * URL(Uniform Resource Locator) Helper
 * This helper can be used to trigger a native application(e.g email, sms, tel) from Browser.
 * That means we are restricted of browser or application implementation. e.g.
 *  - Some browsers do not let you to pass more than 2022 characters in URL
 *  - MAPI (Outlook) limit is 2083, max. path under Internet Explorer is 2048
 *  - Different Internet Explorer versions have different limitation in IE9 approximately 1000 characters
 *  - MS mail app under Windows 8 cuts mail links after approximately 100 characters
 *  - Safari gets a confirmation from user before opening a native application and can block rest triggers if user cancels it.
 *  - Some mail applications(Outlook) do not respect all encodings(e.g. Cyrillic texts are not encoded correctly)
 *
 * Note: all the given limitation lengths are for encoded text(e.g space character will be encoded to "%20")
 * </pre>
 *
 * @namespace
 * @name sap.m.URLHelper
 * @since 1.10
 * @public
 */
sap.m.URLHelper = (function($, window) {

	function isValidString(value) {
		return value && Object.prototype.toString.call(value) == "[object String]";
	}

	function formatTel(sTel) {
		if (!isValidString(sTel)) {
			return "";
		}
		return sTel.replace(/[^0-9\+\*#]/g, "");
	}

	function formatMessage(sText) {
		if (!isValidString(sText)) {
			return "";
		}
		// line breaks in the  body of a message MUST be encoded with "%0D%0A"
		// space character in the  body of a message MUST be encoded with "%20"
		// see http://www.ietf.org/rfc/rfc2368.txt for details
		sText = sText.split(/\r\n|\r|\n/g).join("\r\n");
		return window.encodeURIComponent(sText);
	}

	return $.extend(new sap.ui.base.EventProvider(), {
		/**
		 * Sanitize the given telephone number and returns telephone URI scheme
		 *
		 * @param {String} [sTel] telephone number.
		 * @return {String} telephone URI scheme.
		 * @public
		 * @name sap.m.URLHelper#normalizeTel
		 * @function
		 */
		normalizeTel : function(sTel) {
			return "tel:" + formatTel(sTel);
		},

		/**
		 * Sanitize the given telephone number and returns SMS URI scheme
		 *
		 * @param {String} [sTel] telephone number.
		 * @return {String} SMS URI scheme.
		 * @public
		 * @name sap.m.URLHelper#normalizeSms
		 * @function
		 */
		normalizeSms : function(sTel) {
			return "sms:" + formatTel(sTel);
		},

		/**
		 * Builds Email URI from given parameter.
		 * Trims spaces from email addresses
		 *
		 * @param {String} [sEmail] Destination email address.
		 * @param {String} [sSubject] Subject of the email address.
		 * @param {String} [sBody] Default message text.
		 * @param {String} [sCC] Carbon Copy email address.
		 * @param {String} [sBCC] Blind carbon copy email address.
		 * @return {String} Email URI scheme.
		 * @public
		 * @name sap.m.URLHelper#normalizeEmail
		 * @function
		 */
		normalizeEmail : function(sEmail, sSubject, sBody, sCC, sBCC) {
			var aParams = [],
				sURL = "mailto:",
				encode = window.encodeURIComponent;

			// Within mailto URLs, the characters "?", "=", "&" are reserved
			isValidString(sEmail) && (sURL += encode($.trim(sEmail)));
			isValidString(sSubject) && aParams.push("subject=" + encode(sSubject));
			isValidString(sBody) && aParams.push("body=" + formatMessage(sBody));
			isValidString(sBCC) && aParams.push("bcc=" + encode($.trim(sBCC)));
			isValidString(sCC) && aParams.push("cc=" + encode($.trim(sCC)));

			if (aParams.length) {
				sURL += "?" + aParams.join("&");
			}
			return sURL;
		},

		/**
		 * Redirects to given URL
		 * This method fires "redirect" event before open the URL
		 *
		 * @param {String} sURL Uniform resource locator.
		 * @param {boolean} [bNewWindow] Opens URL in a new browser window
		 * @public
		 * @name sap.m.URLHelper#redirect
		 * @function
		 */
		redirect : function (sURL, bNewWindow) {
			$.sap.assert(isValidString(sURL), this + "#redirect: URL must be a string" );

			this.fireEvent("redirect", sURL);
			if (!bNewWindow) {
				window.location.href = sURL;
			} else {
				window.open(sURL, "_blank");
			}
		},

		/**
		 * Adds an event registration for redirect
		 *
		 * @param {Function} fnFunction The function to call, when the event occurs.
		 * @param {Object} [oListener] The object, that wants to be notified, when the event occurs
		 * @return {Object} sap.m.URLHelper instance
		 * @public
		 * @name sap.m.URLHelper#attachRedirect
		 * @function
		 */
		attachRedirect : function (fnFunction, oListener) {
			return this.attachEvent("redirect", fnFunction, oListener);
		},

		/**
		 * Detach already registered redirect event
		 *
		 * @param {Function} fnFunction The function to call, when the event occurs.
		 * @param {Object} [oListener] The object, that wants to be notified, when the event occurs
		 * @return {Object} sap.m.URLHelper instance
		 * @public
		 * @name sap.m.URLHelper#detachRedirect
		 * @function
		 */
		detachRedirect : function (fnFunction, oListener) {
			return this.detachEvent("redirect", fnFunction, oListener);
		},

		/**
		 * Trigger telephone to call given telephone number
		 *
		 * @param {String} [sTel] telephone number.
		 * @public
		 * @name sap.m.URLHelper#triggerTel
		 * @function
		 */
		triggerTel : function(sTel) {
			this.redirect(this.normalizeTel(sTel));
		},

		/**
		 * Trigger SMS application to send SMS to given telephone number
		 *
		 * @param {String} [sTel] telephone number.
		 * @public
		 * @name sap.m.URLHelper#triggerSms
		 * @function
		 */
		triggerSms : function(sTel) {
			this.redirect(this.normalizeSms(sTel));
		},

		/**
		 * Trigger email application to send email
		 * Trims spaces from email addresses
		 *
		 * @param {String} [sEmail] Destination email address.
		 * @param {String} [sSubject] Subject of the email address.
		 * @param {String} [sBody] Default message text.
		 * @param {String} [sCC] Carbon Copy email address.
		 * @param {String} [sBCC] Blind carbon copy email address.
		 * @public
		 * @name sap.m.URLHelper#triggerEmail
		 * @function
		 */
		triggerEmail : function(sEmail, sSubject, sBody, sCC, sBCC) {
			this.redirect(this.normalizeEmail.apply(0, arguments));
		},

		toString : function() {
			return "sap.m.URLHelper";
		}
	});

}(jQuery, window));


/**
 * Helper for rendering themable background
 *
 * @namespace
 * @name sap.m.BackgroundHelper
 * @since 1.12
 * @protected
 */
sap.m.BackgroundHelper = (function($, window) {

	return {
		/**
		 * Adds CSS classes and styles to the given RenderManager, depending on the given configuration for background color and background image.
		 * To be called by control renderers supporting the global themable background image within their root tag, before they call writeClasses() and writeStyles().
		 *
		 * @param {sap.ui.core.RenderManager} rm the RenderManager
		 * @param {String} [sBgColor] a configured custom background color for the control, if any
		 * @param {sap.ui.core.URI} [sBgImgUrl] the configured custom background image for the control, if any
		 * @returns
		 *
		 * @protected
		 * @name sap.m.BackgroundHelper#addBackgroundColorStyles
		 * @function
		 */
		addBackgroundColorStyles: function(rm, sBgColor, sBgImgUrl) {
			rm.addClass("sapMGlobalBackgroundColor");

			if (sBgColor || sBgImgUrl) { // when an image or color is configured, the gradient needs to be removed, so the color can be seen behind the image
				rm.addStyle("background-image", "none");
				rm.addStyle("filter", "none");
			}
			if (sBgColor) {
				rm.addStyle("background-color", jQuery.sap.escapeHTML(sBgColor));
			}
		},


		/**
		 * @protected
		 * @returns
		 */
		/* currently not needed
		isThemeBackgroundImageModified: function() {
			jQuery.sap.require("sap.ui.core.theming.Parameters");
			var sBgImgUrl = sap.ui.core.theming.Parameters.get('sapUiGlobalBackgroundImage'); // the global background image from the theme
			if (sBgImgUrl && sBgImgUrl !== "''") {
				var sBgImgUrlDefault = sap.ui.core.theming.Parameters.get('sapUiGlobalBackgroundImageDefault');
				if (sBgImgUrl !== sBgImgUrlDefault) {
					return true;
				}
			}
			return false;
		},
		*/

		/**
		 * Renders an HTML tag into the given RenderManager which carries the background image which is either configured and given or coming from the current theme.
		 * Should be called right after the opening root tag has been completed, so this is the first child element inside the control.
		 *
		 * @param rm the RenderManager
		 * @param {sap.ui.core.Control} oControl the control within which the tag will be rendered; its ID will be used to generate the element ID
		 * @param {String}  sCssClass a css class to add to the element
		 * @param {sap.ui.core.URI}  [sBgImgUrl] the image of a configured background image; if this is not given, the theme background will be used and also the other settings are ignored.
		 * @param {boolean} [bRepeat] whether the background image should be repeated/tiled (or stretched)
		 * @param {float}   [fOpacity] the background image opacity, if any
		 * @returns
		 *
		 * @protected
		 * @name sap.m.BackgroundHelper#renderBackgroundImageTag
		 * @function
		 */
		renderBackgroundImageTag: function(rm, oControl, sCssClass, sBgImgUrl, bRepeat, fOpacity) {
			rm.write("<div id='" + oControl.getId() + "-BG' ");
			rm.addClass(sCssClass);
			rm.addClass("sapMGlobalBackgroundImage"); // this adds the background image from the theme

			if (sBgImgUrl) { // use the settings only if a background image is configured
				rm.addStyle("display", "block"); // enforce visibility even if a parent has also a background image
				rm.addStyle("background-image", "url(" + jQuery.sap.encodeHTML(sBgImgUrl) + ")");

				rm.addStyle("background-repeat", bRepeat ? "repeat" : "no-repeat");
				if (!bRepeat) {
					rm.addStyle("background-size", "cover");
					rm.addStyle("background-position", "center");
				} else { // repeat
					rm.addStyle("background-position", "left top");
				}

			} else {
				// the theme defines the background
			}

			if (fOpacity !== 1) {
				if (fOpacity > 1) { // greater than 1 enforces 1
					fOpacity = 1;
				}
				rm.addStyle("opacity", fOpacity);
			}

			rm.writeClasses();
			rm.writeStyles();
			rm.write("></div>");
		}
	};
}());

/**
 * Helper for Images
 *
 * @namespace
 * @name sap.m.ImageHelper
 * @since 1.12
 * @protected
 */
sap.m.ImageHelper = (function($, window) {

	/**
	 * Checks if value is not undefined, in which case the
	 * setter function for a given property is called.
	 * Returns true if value is set, false otherwise.
	 *
	 * @private
	 */
	function checkAndSetProperty(oControl, property, value) {
		if(value !== undefined) {
			var fSetter = oControl['set' + jQuery.sap.charToUpperCase(property)];
			if (typeof(fSetter) === "function") {
				fSetter.call(oControl, value);
				return true;
			}
		}
		return false;
	}

	return {
		/**
		 * Creates or updates an image control.
		 *
		 * @param {string} sImgId id of the image to be dealt with.
		 * @param {sap.m.Image} oImageControl the image to update. If undefined, a new image will be created.
		 * @param {sap.ui.core.Control} oParent oImageControl's parentControl.
		 * @param {Map} mProperties map object that contains key value pairs if image propeties. The 'src' property
		 * MUST be contained. Also the map's keys must be names of image properties
		 * @param {Array} aCssClassesToAdd array of css classes which will be added if the image needs to be created.
		 * @param {Array} aCssClassesToRemove all css clases that oImageControl has and which are contained in this array
		 * are removed bevore adding the css classes listed in aCssClassesToAdd.
		 * @returns the new or updated image control
		 *
		 * @protected
		 * @name sap.m.ImageHelper#getImageControl
		 * @function
		 */
		getImageControl: function(sImgId, oImageControl, oParent, mProperties, aCssClassesToAdd, aCssClassesToRemove) {
			jQuery.sap.assert( !!mProperties['src'] , "sap.m.ImageHelper.getImageControl: mProperties do not contain 'src'");

			// make sure, image is rerendered if icon source has changed
			if(oImageControl && (oImageControl.getSrc() != mProperties['src'])){
				oImageControl.destroy();
				oImageControl = undefined;
			}
			// update or create image control
			var oImage = oImageControl;
			if (!!oImage && (oImage instanceof sap.m.Image || oImage instanceof sap.ui.core.Icon)) {
				//Iterate through properties
				for (var key in mProperties) {
					checkAndSetProperty(oImage, key,  mProperties[key]);
				}
			} else {
				if(!sap.m.Image){
					jQuery.sap.require("sap.m.Image");
				}
				var mSettings = mProperties;
				//add 'id' to properties. This is required by utility
				//method 'createControlByURI'
				mSettings['id'] = sImgId;
				oImage = sap.ui.core.IconPool.createControlByURI(
						mSettings, sap.m.Image);
				//Set the parent so the image gets re-rendered, when the parent is
				oImage.setParent(oParent, null, true);
			}

			//Remove existing style classes which are contained in aCssClassesToRemove
			//(the list of css classes allowed for deletion) to have them updated later on
			//Unfortunately, there is no other way to do this but remove
			//each class individually
			if(!!aCssClassesToRemove) {
				for (var l = 0, removeLen = aCssClassesToRemove.length; l !== removeLen; l++) {
					oImage.removeStyleClass(aCssClassesToRemove[l]);
				}
			}
			//Add style classes if necessary
			if(!!aCssClassesToAdd) {
				for (var k = 0, len = aCssClassesToAdd.length; k !== len; k++) {
					oImage.addStyleClass(aCssClassesToAdd[k]);
				}
			}
			return oImageControl = oImage;
		}
	};
}());

/**
 * Helper for Popups
 *
 * @namespace
 * @name sap.m.PopupHelper
 * @since 1.16.7
 * @protected
 */
sap.m.PopupHelper = (function(){
	return {
		/**
		 * This methods converts the percentage value to an absolute number based on the given base number.
		 *
		 * @param {string} sPercentage A percentage value in string format, for example "25%"
		 * @param {float} fBaseSize A float number which the calculation is based on.
		 * @returns The calculated size string with "px" as unit or null when the format of given parameter is wrong.
		 *
		 * @protected
		 * @name sap.m.PopupHelper.calcPercentageSize
		 * @function
		 */
		calcPercentageSize: function(sPercentage, fBaseSize){
			if(typeof sPercentage !== "string"){
				jQuery.sap.log.warning("sap.m.PopupHelper: calcPercentageSize, the first parameter" + sPercentage + "isn't with type string");
				return null;
			}

			if(sPercentage.indexOf("%") <= 0){
				jQuery.sap.log.warning("sap.m.PopupHelper: calcPercentageSize, the first parameter" + sPercentage + "is not a percentage string (for example '25%')");
				return null;
			}

			var fPercent = parseFloat(sPercentage) / 100,
				fParsedBaseSize = parseFloat(fBaseSize);

			return Math.floor(fPercent * fParsedBaseSize) + "px";
		}
	};
}());

// implement Form helper factory with m controls
// possible is set before layout lib is loaded.
jQuery.sap.setObject("sap.ui.layout.form.FormHelper", {
	createLabel: function(sText){
		return new sap.m.Label({text: sText});
	},
	createButton: function(sId, fPressFunction, oThis){
		var oButton = new sap.m.Button(sId);
		oButton.attachEvent('press', fPressFunction, oThis); // attach event this way to have the right this-reference in handler
		return oButton;
	},
	setButtonContent: function(oButton, sText, sTooltip, sIcon, sIconHovered){
		oButton.setText(sText);
		oButton.setTooltip(sTooltip);
		oButton.setIcon(sIcon);
		oButton.setActiveIcon(sIconHovered);
	},
	addFormClass: function(){ return "sapUiFormM"; },
	bArrowKeySupport: false, /* disables the keyboard support for arrow keys */
	bFinal: true
});

}; // end of sap/m/library.js
if ( !jQuery.sap.isDeclared('sap.m.ActionListItemRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare("sap.m.ActionListItemRenderer");
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained



/**
 * @class ActionListItem renderer.
 * @static
 */
sap.m.ActionListItemRenderer = sap.ui.core.Renderer.extend(sap.m.ListItemBaseRenderer);

/**
 * Renders the HTML for the given control, using the provided
 * {@link sap.ui.core.RenderManager}.
 * 
 * @param {sap.ui.core.RenderManager}
 *          oRenderManager the RenderManager that can be used for writing to the
 *          Render-Output-Buffer
 * @param {sap.ui.core.Control}
 *          oControl an object representation of the control that should be
 *          rendered
 */
sap.m.ActionListItemRenderer.renderLIAttributes = function(rm, oLI) {
	rm.addClass("sapMALI");
};

sap.m.ActionListItemRenderer.renderLIContent = function(rm, oLI) {

	var isText = oLI.getText();

	// List item label
	if (isText) {
		rm.write("<div class='sapMALIText'>");
		rm.writeEscaped(isText);
		rm.write("</div>");
	}
};

}; // end of sap/m/ActionListItemRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.ActionSelectRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained

jQuery.sap.declare("sap.m.ActionSelectRenderer");

sap.m.ActionSelectRenderer = sap.ui.core.Renderer.extend(sap.m.SelectRenderer);

/**
 * CSS class to be applied to the HTML root element of the ActionSelect control.
 *
 * @type {string}
 */
sap.m.ActionSelectRenderer.CSS_CLASS = "sapMActionSelect";

/**
 * Apply a CSS class to the HTML root element of the ActionSelect control.
 *
 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
 * @param {sap.ui.core.Control} oActionSelect An object representation of the control that should be rendered.
 * @override
 * @protected
 */
sap.m.ActionSelectRenderer.addStyleClass = function(oRm, oActionSelect) {
	oRm.addClass(sap.m.ActionSelectRenderer.CSS_CLASS);
};

}; // end of sap/m/ActionSelectRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.AppRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare("sap.m.AppRenderer");
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained



/**
 * @class App renderer. 
 * @static
 */
sap.m.AppRenderer = {
};

sap.m.AppRenderer = sap.ui.core.Renderer.extend(sap.m.NavContainerRenderer);

sap.m.AppRenderer.renderAttributes = function(rm, oControl) {
	sap.m.BackgroundHelper.addBackgroundColorStyles(rm, oControl.getBackgroundColor(),  oControl.getBackgroundImage());
};

sap.m.AppRenderer.renderBeforeContent = function(rm, oControl) {
	sap.m.BackgroundHelper.renderBackgroundImageTag(rm, oControl, "sapMAppBG",  oControl.getBackgroundImage(), oControl.getBackgroundRepeat(), oControl.getBackgroundOpacity());
};

}; // end of sap/m/AppRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.Bar') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.m.Bar.
jQuery.sap.declare("sap.m.Bar");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new Bar.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getEnableFlexBox enableFlexBox} : boolean (default: false)</li>
 * <li>{@link #getTranslucent translucent} : boolean (default: false)</li></ul>
 * </li>
 * <li>Aggregations
 * <ul>
 * <li>{@link #getContentLeft contentLeft} : sap.ui.core.Control[]</li>
 * <li>{@link #getContentMiddle contentMiddle} : sap.ui.core.Control[]</li>
 * <li>{@link #getContentRight contentRight} : sap.ui.core.Control[]</li></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * A bar that may be used as a header of a page. It has the capability to center a content like a title, while having few controls on the left and right side.
 * @extends sap.ui.core.Control
 *
 * @author SAP AG 
 * @version 1.20.6
 *
 * @constructor   
 * @public
 * @name sap.m.Bar
 */
sap.ui.core.Control.extend("sap.m.Bar", { metadata : {

	// ---- object ----

	// ---- control specific ----
	library : "sap.m",
	properties : {
		"enableFlexBox" : {type : "boolean", group : "Misc", defaultValue : false, deprecated: true},
		"translucent" : {type : "boolean", group : "Appearance", defaultValue : false, deprecated: true}
	},
	aggregations : {
    	"contentLeft" : {type : "sap.ui.core.Control", multiple : true, singularName : "contentLeft"}, 
    	"contentMiddle" : {type : "sap.ui.core.Control", multiple : true, singularName : "contentMiddle"}, 
    	"contentRight" : {type : "sap.ui.core.Control", multiple : true, singularName : "contentRight"}
	}
}});


/**
 * Creates a new subclass of class sap.m.Bar with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.m.Bar.extend
 * @function
 */


/**
 * Getter for property <code>enableFlexBox</code>.
 * If this flag is set to true, contentMiddle will be rendered as a HBox and layoutData can be used to allocate available space
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>enableFlexBox</code>
 * @public
 * @deprecated Since version 1.16. 
 * This property is no longer supported, instead, contentMiddle will always occupy 100% width when no contentLeft and contentRight are being set.
 * @name sap.m.Bar#getEnableFlexBox
 * @function
 */

/**
 * Setter for property <code>enableFlexBox</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bEnableFlexBox  new value for property <code>enableFlexBox</code>
 * @return {sap.m.Bar} <code>this</code> to allow method chaining
 * @public
 * @deprecated Since version 1.16. 
 * This property is no longer supported, instead, contentMiddle will always occupy 100% width when no contentLeft and contentRight are being set.
 * @name sap.m.Bar#setEnableFlexBox
 * @function
 */


/**
 * Getter for property <code>translucent</code>.
 * A boolean value indicating whether the bar is partially translucent.
 * It is only applied for touch devices.
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>translucent</code>
 * @public
 * @since 1.12
 * @deprecated Since version 1.18.6. 
 * This property has no effect since release 1.18.6 and should not be used. Translucent bar may overlay an input and make it difficult to edit.
 * @name sap.m.Bar#getTranslucent
 * @function
 */

/**
 * Setter for property <code>translucent</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bTranslucent  new value for property <code>translucent</code>
 * @return {sap.m.Bar} <code>this</code> to allow method chaining
 * @public
 * @since 1.12
 * @deprecated Since version 1.18.6. 
 * This property has no effect since release 1.18.6 and should not be used. Translucent bar may overlay an input and make it difficult to edit.
 * @name sap.m.Bar#setTranslucent
 * @function
 */


/**
 * Getter for aggregation <code>contentLeft</code>.<br/>
 * this is the left content area, usually containing a button or an app icon. If this is overlapped by the right content, its content will disappear and text will show an elipsis.
 * 
 * @return {sap.ui.core.Control[]}
 * @public
 * @name sap.m.Bar#getContentLeft
 * @function
 */


/**
 * Inserts a contentLeft into the aggregation named <code>contentLeft</code>.
 *
 * @param {sap.ui.core.Control}
 *          oContentLeft the contentLeft to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the contentLeft should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the contentLeft is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the contentLeft is inserted at 
 *             the last position        
 * @return {sap.m.Bar} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Bar#insertContentLeft
 * @function
 */

/**
 * Adds some contentLeft <code>oContentLeft</code> 
 * to the aggregation named <code>contentLeft</code>.
 *
 * @param {sap.ui.core.Control}
 *            oContentLeft the contentLeft to add; if empty, nothing is inserted
 * @return {sap.m.Bar} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Bar#addContentLeft
 * @function
 */

/**
 * Removes an contentLeft from the aggregation named <code>contentLeft</code>.
 *
 * @param {int | string | sap.ui.core.Control} vContentLeft the contentLeft to remove or its index or id
 * @return {sap.ui.core.Control} the removed contentLeft or null
 * @public
 * @name sap.m.Bar#removeContentLeft
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>contentLeft</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.core.Control[]} an array of the removed elements (might be empty)
 * @public
 * @name sap.m.Bar#removeAllContentLeft
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.core.Control</code> in the aggregation named <code>contentLeft</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.core.Control}
 *            oContentLeft the contentLeft whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @name sap.m.Bar#indexOfContentLeft
 * @function
 */
	

/**
 * Destroys all the contentLeft in the aggregation 
 * named <code>contentLeft</code>.
 * @return {sap.m.Bar} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Bar#destroyContentLeft
 * @function
 */


/**
 * Getter for aggregation <code>contentMiddle</code>.<br/>
 * This is the middle content area. Controls such as label, segmented buttons or select should be placed here. Content that is placed here will be centrally positioned, if there is enough space. If the right or left content overlaps the middle content, the middle content will be centered in the space between the left and the right content.
 * 
 * @return {sap.ui.core.Control[]}
 * @public
 * @name sap.m.Bar#getContentMiddle
 * @function
 */


/**
 * Inserts a contentMiddle into the aggregation named <code>contentMiddle</code>.
 *
 * @param {sap.ui.core.Control}
 *          oContentMiddle the contentMiddle to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the contentMiddle should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the contentMiddle is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the contentMiddle is inserted at 
 *             the last position        
 * @return {sap.m.Bar} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Bar#insertContentMiddle
 * @function
 */

/**
 * Adds some contentMiddle <code>oContentMiddle</code> 
 * to the aggregation named <code>contentMiddle</code>.
 *
 * @param {sap.ui.core.Control}
 *            oContentMiddle the contentMiddle to add; if empty, nothing is inserted
 * @return {sap.m.Bar} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Bar#addContentMiddle
 * @function
 */

/**
 * Removes an contentMiddle from the aggregation named <code>contentMiddle</code>.
 *
 * @param {int | string | sap.ui.core.Control} vContentMiddle the contentMiddle to remove or its index or id
 * @return {sap.ui.core.Control} the removed contentMiddle or null
 * @public
 * @name sap.m.Bar#removeContentMiddle
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>contentMiddle</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.core.Control[]} an array of the removed elements (might be empty)
 * @public
 * @name sap.m.Bar#removeAllContentMiddle
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.core.Control</code> in the aggregation named <code>contentMiddle</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.core.Control}
 *            oContentMiddle the contentMiddle whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @name sap.m.Bar#indexOfContentMiddle
 * @function
 */
	

/**
 * Destroys all the contentMiddle in the aggregation 
 * named <code>contentMiddle</code>.
 * @return {sap.m.Bar} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Bar#destroyContentMiddle
 * @function
 */


/**
 * Getter for aggregation <code>contentRight</code>.<br/>
 * this is the right content area. Controls such as action buttons or search field could be placed here.
 * 
 * @return {sap.ui.core.Control[]}
 * @public
 * @name sap.m.Bar#getContentRight
 * @function
 */


/**
 * Inserts a contentRight into the aggregation named <code>contentRight</code>.
 *
 * @param {sap.ui.core.Control}
 *          oContentRight the contentRight to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the contentRight should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the contentRight is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the contentRight is inserted at 
 *             the last position        
 * @return {sap.m.Bar} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Bar#insertContentRight
 * @function
 */

/**
 * Adds some contentRight <code>oContentRight</code> 
 * to the aggregation named <code>contentRight</code>.
 *
 * @param {sap.ui.core.Control}
 *            oContentRight the contentRight to add; if empty, nothing is inserted
 * @return {sap.m.Bar} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Bar#addContentRight
 * @function
 */

/**
 * Removes an contentRight from the aggregation named <code>contentRight</code>.
 *
 * @param {int | string | sap.ui.core.Control} vContentRight the contentRight to remove or its index or id
 * @return {sap.ui.core.Control} the removed contentRight or null
 * @public
 * @name sap.m.Bar#removeContentRight
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>contentRight</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.core.Control[]} an array of the removed elements (might be empty)
 * @public
 * @name sap.m.Bar#removeAllContentRight
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.core.Control</code> in the aggregation named <code>contentRight</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.core.Control}
 *            oContentRight the contentRight whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @name sap.m.Bar#indexOfContentRight
 * @function
 */
	

/**
 * Destroys all the contentRight in the aggregation 
 * named <code>contentRight</code>.
 * @return {sap.m.Bar} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Bar#destroyContentRight
 * @function
 */


// Start of sap\m\Bar.js
/**
 * @private
 */

sap.m.Bar.prototype.onBeforeRendering = function() {
	this._removeAllListeners();
};

sap.m.Bar.prototype.onAfterRendering = function() {
	this._handleResize();
};

/**
 * Called when the control is destroyed.
 *
 * @private
 */
sap.m.Bar.prototype.exit = function() {
	this._removeAllListeners();

	if(this._oflexBox) {

		this._oflexBox.destroy();
		this._oflexBox = null;

	}

	this._$MidBarPlaceHolder = null;
	this._$RightBar = null;
	this._$LeftBar = null;
};

/**
 * @private
 */
sap.m.Bar._aResizeHandlers = ["_sResizeListenerId", "_sResizeListenerIdMid", "_sResizeListenerIdRight", "_sResizeListenerIdLeft"];

/**
 * removes all resize listeners, that the bar could have registered.
 * @private
 */
sap.m.Bar.prototype._removeAllListeners = function() {
	var that = this;

	sap.m.Bar._aResizeHandlers.forEach(function(sItem) {

		that._removeListenerFailsave(sItem);

	});
};

/**
 * Removes a listener with the specified name and sets it to null, if the listener is defined.
 * @param sListenerName the name of the listener that has to be removed
 *
 * @private
 */
sap.m.Bar.prototype._removeListenerFailsave = function(sListenerName) {
	if (this[sListenerName]) {

		sap.ui.core.ResizeHandler.deregister(this[sListenerName]);
		this[sListenerName] = null;

	}
};

/**
 * Invoked, when bar is rerendered, its size changed, or the size of one for the content bars changed
 * @private
 */
sap.m.Bar.prototype._handleResize = function() {
	this._removeAllListeners();

	var bContentLeft = !!this.getContentLeft().length,
		bContentMiddle = !!this.getContentMiddle().length,
		bContentRight = !!this.getContentRight().length;

	//No content was set yet - no need to listen to resizes
	if(!bContentLeft && !bContentMiddle && !bContentRight) {
		return;
	}

	this._$LeftBar = this.$("BarLeft");
	this._$RightBar = this.$("BarRight");
	this._$MidBarPlaceHolder = this.$("BarPH");

	this._updatePosition(bContentLeft, bContentMiddle, bContentRight);

	this._sResizeListenerId = sap.ui.core.ResizeHandler.register(this.getDomRef(), jQuery.proxy(this._handleResize, this));

	if(this.getEnableFlexBox()) {
		return;
	}

	if(bContentLeft) {
		this._sResizeListenerIdLeft = sap.ui.core.ResizeHandler.register(this._$LeftBar[0], jQuery.proxy(this._handleResize, this));
	}

	if(bContentMiddle) {
		this._sResizeListenerIdMid = sap.ui.core.ResizeHandler.register(this._$MidBarPlaceHolder[0], jQuery.proxy(this._handleResize, this));
	}

	if(bContentRight) {
		this._sResizeListenerIdRight = sap.ui.core.ResizeHandler.register(this._$RightBar[0], jQuery.proxy(this._handleResize, this));
	}
};

/**
 * Repositions the bar. 
 * If there is only one aggregation filled, this aggregation will take 100% of the bars space.
 * @param bContentLeft indicates if there is left content in the bar
 * @param bContentMiddle indicates if there is middle content in the bar
 * @param bContentRight indicates if there is right content in the bar
 * @private
 */
sap.m.Bar.prototype._updatePosition = function(bContentLeft, bContentMiddle, bContentRight) {

	if (!bContentLeft && !bContentRight) {

		this._$MidBarPlaceHolder.css({ width : '100%'});
		return;

	}

	if(bContentLeft && !bContentMiddle && !bContentRight) {

		this._$LeftBar.css({ width : '100%'});
		return;

	}

	if(!bContentLeft && !bContentMiddle && bContentRight) {

		this._$RightBar.css({ width : '100%'});
		return;

	}

	var iBarWidth = this.$().outerWidth(true);

	// reset to default
	this._$RightBar.css({ width : "" });
	this._$LeftBar.css({ width : "" });
	this._$MidBarPlaceHolder.css({ position : "", width : "", visibility : 'hidden' });

	var iRightBarWidth = this._$RightBar.outerWidth(true);

	//right bar is bigger than the bar - only show the right bar
	if(iRightBarWidth > iBarWidth) {

		if(bContentLeft) {
			this._$LeftBar.css({ width : "0px" });
		}

		if(bContentMiddle) {
			this._$MidBarPlaceHolder.css({ width : "0px" });
		}

		this._$RightBar.css({ width : iBarWidth + "px"});
		return;

	}

	var iLeftBarWidth = this._getBarContainerWidth(this._$LeftBar);

	// handle the case when left and right content are wider than the bar itself
	if (iBarWidth < (iLeftBarWidth + iRightBarWidth)) {

		// this scenario happens mostly when a very long title text is set in the left content area
		// hence we make sure the rightContent always has enough space and reduce the left content area width accordingly
		iLeftBarWidth = iBarWidth - iRightBarWidth;

		this._$LeftBar.width(iLeftBarWidth);
		this._$MidBarPlaceHolder.width(0);
		return;

	}

	//middle bar will be shown
	this._$MidBarPlaceHolder.css(this._getMidBarCss(iRightBarWidth, iBarWidth, iLeftBarWidth));

};

/**
 * Returns the css for the contentMiddle aggregation. It is centered if there is enough space for it to fit between the left and right content.
 * If not it will be centered between those two.
 * @param iRightBarWidth the width in pixel
 * @param iBarWidth the width in pixel
 * @param iLeftBarWidth the width in pixel
 * @returns {object} the new _$MidBarPlaceHolder css value
 */
sap.m.Bar.prototype._getMidBarCss = function(iRightBarWidth, iBarWidth, iLeftBarWidth) {
	var iMidBarPlaceholderWidth = this._$MidBarPlaceHolder.outerWidth(true),
		bRtl = sap.ui.getCore().getConfiguration().getRTL(),
		sLeftOrRight = bRtl ? "right" : "left",
		oMidBarCss = { visibility : "" };

	if (this.getEnableFlexBox()) {

		iMidBarPlaceholderWidth = iBarWidth - iLeftBarWidth - iRightBarWidth - parseInt(this._$MidBarPlaceHolder.css('margin-left'), 10) - parseInt(this._$MidBarPlaceHolder.css('margin-right'), 10);

		oMidBarCss.position = "absolute";
		oMidBarCss.width = iMidBarPlaceholderWidth + "px";
		oMidBarCss[sLeftOrRight] = iLeftBarWidth;

		//calculation for flex is done
		return oMidBarCss;

	}

	var iSpaceBetweenLeftAndRight = iBarWidth - iLeftBarWidth - iRightBarWidth,

		iMidBarStartingPoint = (iBarWidth / 2) - (iMidBarPlaceholderWidth / 2),
		bLeftContentIsOverlapping = iLeftBarWidth > iMidBarStartingPoint,

		iMidBarEndPoint = (iBarWidth / 2) + (iMidBarPlaceholderWidth / 2),
		bRightContentIsOverlapping = (iBarWidth - iRightBarWidth) < iMidBarEndPoint;

	if (iSpaceBetweenLeftAndRight > 0 && (bLeftContentIsOverlapping || bRightContentIsOverlapping)) {

		//Left or Right content is overlapping the Middle content

		// place the middle positioned element directly next to the end of left content area
		oMidBarCss.position = "absolute";

		//Use the remaining space
		oMidBarCss.width = iSpaceBetweenLeftAndRight + "px";

		oMidBarCss.left = bRtl ? iRightBarWidth : iLeftBarWidth;
	}

	var $MidBar = this.$("BarMiddle"),
		iMidBarWidth = $MidBar.outerWidth(true);

	if (oMidBarCss.width > iMidBarWidth) {

		oMidBarCss.width = iMidBarWidth;

	}

	return oMidBarCss;

};

/**
 * Gets the width of a container
 * @static
 * @param $Container a container with children
 * @returns {number} the width of one of the bar containers
 */
sap.m.Bar.prototype._getBarContainerWidth = function($Container) {
	var i,
		iContainerWidth = 0,
		aContainerChildren = $Container.children(),
		iContainerChildrenTotalWidth = 0;

	// Chrome browser has a problem in providing the correct div size when image inside does not have width explicitly set
	//since ff version 24 the calculation is correct, since we don't support older versions we won't check it 
	if (sap.ui.Device.browser.webkit || sap.ui.Device.browser.firefox) {

		for (i= 0; i < aContainerChildren.length; i++) {

			iContainerChildrenTotalWidth += jQuery(aContainerChildren[i]).outerWidth(true);

		}

		iContainerWidth = $Container.outerWidth(true);

	} else {

		// IE has a rounding issue with JQuery.outerWidth
		var oContainerChildrenStyle;

		for(i= 0; i < aContainerChildren.length; i++){

			oContainerChildrenStyle = window.getComputedStyle(aContainerChildren[i]);

			if (oContainerChildrenStyle.width == "auto") {

				iContainerChildrenTotalWidth += jQuery(aContainerChildren[i]).width() + 1; //add an additional 1 pixel because of rounding issue.

			} else {

				iContainerChildrenTotalWidth += parseFloat(oContainerChildrenStyle.width);

			}

			iContainerChildrenTotalWidth += parseFloat(oContainerChildrenStyle.marginLeft);
			iContainerChildrenTotalWidth += parseFloat(oContainerChildrenStyle.marginRight);
			iContainerChildrenTotalWidth += parseFloat(oContainerChildrenStyle.paddingLeft);
			iContainerChildrenTotalWidth += parseFloat(oContainerChildrenStyle.paddingRight);
		}

		var oContainerComputedStyle = window.getComputedStyle($Container[0]);

		iContainerWidth += parseFloat(oContainerComputedStyle.width);
		iContainerWidth += parseFloat(oContainerComputedStyle.marginLeft);
		iContainerWidth += parseFloat(oContainerComputedStyle.marginRight);
		iContainerWidth += parseFloat(oContainerComputedStyle.paddingLeft);
		iContainerWidth += parseFloat(oContainerComputedStyle.paddingRight);

	}

	if (iContainerWidth < iContainerChildrenTotalWidth) {

		iContainerWidth = iContainerChildrenTotalWidth;

	}

	return iContainerWidth;
};

}; // end of sap/m/Bar.js
if ( !jQuery.sap.isDeclared('sap.m.BusyDialog') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.m.BusyDialog.
jQuery.sap.declare("sap.m.BusyDialog");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new BusyDialog.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getText text} : string</li>
 * <li>{@link #getTitle title} : string</li>
 * <li>{@link #getCustomIcon customIcon} : sap.ui.core.URI</li>
 * <li>{@link #getCustomIconRotationSpeed customIconRotationSpeed} : int (default: 1000)</li>
 * <li>{@link #getCustomIconDensityAware customIconDensityAware} : boolean (default: true)</li>
 * <li>{@link #getCustomIconWidth customIconWidth} : sap.ui.core.CSSSize (default: "30px")</li>
 * <li>{@link #getCustomIconHeight customIconHeight} : sap.ui.core.CSSSize (default: "44px")</li>
 * <li>{@link #getCancelButtonText cancelButtonText} : string</li>
 * <li>{@link #getShowCancelButton showCancelButton} : boolean (default: false)</li></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul>
 * <li>{@link sap.m.BusyDialog#event:close close} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * Busy Dialog is used to indicate that the system is busy with some task and the user has to wait. During this time the UI is blocked.
 * @extends sap.ui.core.Control
 *
 * @author SAP AG 
 * @version 1.20.6
 *
 * @constructor   
 * @public
 * @name sap.m.BusyDialog
 */
sap.ui.core.Control.extend("sap.m.BusyDialog", { metadata : {

	// ---- object ----
	publicMethods : [
		// methods
		"open", "close"
	],

	// ---- control specific ----
	library : "sap.m",
	properties : {
		"text" : {type : "string", group : "Appearance", defaultValue : null},
		"title" : {type : "string", group : "Appearance", defaultValue : null},
		"customIcon" : {type : "sap.ui.core.URI", group : "Appearance", defaultValue : null},
		"customIconRotationSpeed" : {type : "int", group : "Appearance", defaultValue : 1000},
		"customIconDensityAware" : {type : "boolean", group : "", defaultValue : true},
		"customIconWidth" : {type : "sap.ui.core.CSSSize", group : "Appearance", defaultValue : "30px"},
		"customIconHeight" : {type : "sap.ui.core.CSSSize", group : "Appearance", defaultValue : "44px"},
		"cancelButtonText" : {type : "string", group : "Misc", defaultValue : null},
		"showCancelButton" : {type : "boolean", group : "Appearance", defaultValue : false}
	},
	aggregations : {
    	"_busyLabel" : {type : "sap.ui.core.Control", multiple : false, visibility : "hidden"}, 
    	"_busyIndicator" : {type : "sap.ui.core.Control", multiple : false, visibility : "hidden"}, 
    	"_busyButton" : {type : "sap.ui.core.Control", multiple : false, visibility : "hidden"}
	},
	events : {
		"close" : {}
	}
}});


/**
 * Creates a new subclass of class sap.m.BusyDialog with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.m.BusyDialog.extend
 * @function
 */

sap.m.BusyDialog.M_EVENTS = {'close':'close'};


/**
 * Getter for property <code>text</code>.
 * Optional text shown inside the popup.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>text</code>
 * @public
 * @name sap.m.BusyDialog#getText
 * @function
 */

/**
 * Setter for property <code>text</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sText  new value for property <code>text</code>
 * @return {sap.m.BusyDialog} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.BusyDialog#setText
 * @function
 */


/**
 * Getter for property <code>title</code>.
 * Sets a title to the busy dialog. Default is no title.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>title</code>
 * @public
 * @name sap.m.BusyDialog#getTitle
 * @function
 */

/**
 * Setter for property <code>title</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sTitle  new value for property <code>title</code>
 * @return {sap.m.BusyDialog} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.BusyDialog#setTitle
 * @function
 */


/**
 * Getter for property <code>customIcon</code>.
 * Icon that is displayed in the dialog header. This icon is invisible in iOS platform and it's density aware that you can use the density convention (@2, @1.5, etc.) to provide higher resolution image for higher density screen.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.core.URI} the value of property <code>customIcon</code>
 * @public
 * @name sap.m.BusyDialog#getCustomIcon
 * @function
 */

/**
 * Setter for property <code>customIcon</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.core.URI} sCustomIcon  new value for property <code>customIcon</code>
 * @return {sap.m.BusyDialog} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.BusyDialog#setCustomIcon
 * @function
 */


/**
 * Getter for property <code>customIconRotationSpeed</code>.
 * Defines the rotation speed of the given image. If a gif is used, the speed has to be set to 0. The unit is in ms.
 *
 * Default value is <code>1000</code>
 *
 * @return {int} the value of property <code>customIconRotationSpeed</code>
 * @public
 * @name sap.m.BusyDialog#getCustomIconRotationSpeed
 * @function
 */

/**
 * Setter for property <code>customIconRotationSpeed</code>.
 *
 * Default value is <code>1000</code> 
 *
 * @param {int} iCustomIconRotationSpeed  new value for property <code>customIconRotationSpeed</code>
 * @return {sap.m.BusyDialog} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.BusyDialog#setCustomIconRotationSpeed
 * @function
 */


/**
 * Getter for property <code>customIconDensityAware</code>.
 * If this is set to false, the src image will be loaded directly without attempting to fetch the density perfect image for high density device.
 * 
 * By default, this is set to true but then one or more requests are sent trying to get the density perfect version of image if this version of image doesn't exist on the server.
 * 
 * If bandwidth is the key for the application, set this value to false.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>customIconDensityAware</code>
 * @public
 * @name sap.m.BusyDialog#getCustomIconDensityAware
 * @function
 */

/**
 * Setter for property <code>customIconDensityAware</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bCustomIconDensityAware  new value for property <code>customIconDensityAware</code>
 * @return {sap.m.BusyDialog} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.BusyDialog#setCustomIconDensityAware
 * @function
 */


/**
 * Getter for property <code>customIconWidth</code>.
 * Width of the provided icon. By default 44px are used.
 *
 * Default value is <code>"30px"</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>customIconWidth</code>
 * @public
 * @name sap.m.BusyDialog#getCustomIconWidth
 * @function
 */

/**
 * Setter for property <code>customIconWidth</code>.
 *
 * Default value is <code>"30px"</code> 
 *
 * @param {sap.ui.core.CSSSize} sCustomIconWidth  new value for property <code>customIconWidth</code>
 * @return {sap.m.BusyDialog} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.BusyDialog#setCustomIconWidth
 * @function
 */


/**
 * Getter for property <code>customIconHeight</code>.
 * Height of the provided icon. By default 44px are used.
 *
 * Default value is <code>"44px"</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>customIconHeight</code>
 * @public
 * @name sap.m.BusyDialog#getCustomIconHeight
 * @function
 */

/**
 * Setter for property <code>customIconHeight</code>.
 *
 * Default value is <code>"44px"</code> 
 *
 * @param {sap.ui.core.CSSSize} sCustomIconHeight  new value for property <code>customIconHeight</code>
 * @return {sap.m.BusyDialog} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.BusyDialog#setCustomIconHeight
 * @function
 */


/**
 * Getter for property <code>cancelButtonText</code>.
 * The text of the cancel button. The default text is "Cancel" (translated to the respective language).
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>cancelButtonText</code>
 * @public
 * @name sap.m.BusyDialog#getCancelButtonText
 * @function
 */

/**
 * Setter for property <code>cancelButtonText</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sCancelButtonText  new value for property <code>cancelButtonText</code>
 * @return {sap.m.BusyDialog} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.BusyDialog#setCancelButtonText
 * @function
 */


/**
 * Getter for property <code>showCancelButton</code>.
 * A cancel button will be rendered inside the busy dialog if this property is set to true.
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>showCancelButton</code>
 * @public
 * @name sap.m.BusyDialog#getShowCancelButton
 * @function
 */

/**
 * Setter for property <code>showCancelButton</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bShowCancelButton  new value for property <code>showCancelButton</code>
 * @return {sap.m.BusyDialog} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.BusyDialog#setShowCancelButton
 * @function
 */


/**
 * This event will be fired when the busy dialog is closed. 
 *
 * @name sap.m.BusyDialog#close
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters

 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'close' event of this <code>sap.m.BusyDialog</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.m.BusyDialog</code>.<br/> itself. 
 *  
 * This event will be fired when the busy dialog is closed. 
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.m.BusyDialog</code>.<br/> itself.
 *
 * @return {sap.m.BusyDialog} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.BusyDialog#attachClose
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'close' event of this <code>sap.m.BusyDialog</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.m.BusyDialog} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.BusyDialog#detachClose
 * @function
 */

/**
 * Fire event close to attached listeners.

 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.m.BusyDialog} <code>this</code> to allow method chaining
 * @protected
 * @name sap.m.BusyDialog#fireClose
 * @function
 */


/**
 * Open the busy popup.
 *
 * @name sap.m.BusyDialog.prototype.open
 * @function

 * @type sap.m.BusyDialog
 * @public
 */


/**
 * Close the busy popup.
 *
 * @name sap.m.BusyDialog.prototype.close
 * @function

 * @type sap.m.BusyDialog
 * @public
 */


// Start of sap\m\BusyDialog.js
///**
// * This file defines behavior for the control,
// */
//sap.m.BusyDialog.prototype.init = function(){
//   // do something for initialization...
//};
jQuery.sap.require('sap.ui.core.Popup'); // unlisted dependency retained

jQuery.sap.require('sap.ui.core.theming.Parameters'); // unlisted dependency retained


sap.m.BusyDialog.prototype.init = function(){
	var that = this;
	this._$window = jQuery(window);
	this._isPlatformDependent = sap.ui.core.theming.Parameters.get("sapMPlatformDependent") == "true";
	
	this._busyIndicator = new sap.m.BusyIndicator(this.getId() + '-busyInd', {}).addStyleClass('sapMBsyInd');
	this.setAggregation("_busyIndicator", this._busyIndicator, true);
	
	this.iOldWinHeight = 0;
	this._oPopup = new sap.ui.core.Popup();
	(sap.ui.Device.os.ios && this._isPlatformDependent) ? this._oPopup.setShadow(true): this._oPopup.setShadow(false);
	this._oPopup.setModal(true, 'sapMDialogBLyInit');
	this._oPopup.setAnimations(this.openAnimation, this.closeAnimation);

	//the orientationchange event listener
	this._fOrientationChange = jQuery.proxy(this._reposition, this);
	
	this._oPopup._applyPosition = function(oPosition){
		that._setDimensions();
		sap.ui.core.Popup.prototype._applyPosition.call(this, oPosition);
	};
	this._oPopup._showBlockLayer = function(){
		sap.ui.core.Popup.prototype._showBlockLayer.call(this);
		var $BlockRef = jQuery("#sap-ui-blocklayer-popup"), $BlockBarRef;
		$BlockRef.toggleClass("sapMDialogBLyInit", true);
		if (!sap.ui.Device.os.ios && this._isPlatformDependent) {
			$BlockBarRef = jQuery("#sap-ui-blocklayer-popup-bar");
			$BlockRef.css('top', '48px');
			if($BlockBarRef.length === 0){
				var className = "sapUiBLy" + (this._sModalCSSClass ? " " + this._sModalCSSClass : "") + ' sapUiBLyBar';
				var $BlockBarRef = jQuery("<div id=\"sap-ui-blocklayer-popup-bar\" tabindex=\"0\" class=\"" + className + "\" style=\"display:block; z-index:" +  $BlockRef.css('z-index') +"; visibility:visible\"></div>");
				//need to add $BlockBarRef before the busydialog dom node, otherwise have problem with popup.js
				$BlockBarRef.insertBefore(that.$());
			} else {
				var $BlockBarRef = jQuery("#sap-ui-blocklayer-popup-bar");
				$BlockBarRef.css({"z-index" : $BlockRef.css('z-index'),
								"visibility": "visible",
								"display" : "block"});
			}
		}//Without timeout the animation is not visible from the second time.
		/*setTimeout(function() {
			$BlockRef.toggleClass('sapMDialogBLyShown', true);
		}, 0);*/
	};
	this._oPopup._hideBlockLayer = function(){
		var $BlockRef = jQuery("#sap-ui-blocklayer-popup");
		var $BlockBarRef = jQuery("#sap-ui-blocklayer-popup-bar");//$BlockRef.next('div');
		/*$BlockRef.one("webkitTransitionEnd", function(){*/
			$BlockBarRef.css({'visibility': '', 'display': 'none'});
			$BlockRef.toggleClass('sapMDialogBLyInit', false);
			$BlockRef.css("top", "");
			sap.ui.core.Popup.prototype._hideBlockLayer.call(this);
		/*});*/
		/*$BlockRef.toggleClass('sapMDialogBLyShown', false);*/
		
	};
	//keyboard support for desktop environments
	if(sap.ui.Device.system.desktop) {
		var fnOnEscape = jQuery.proxy(function(oEvent) {
				this.close();
				//event should not trigger any further actions
				oEvent.stopPropagation();
		}, this);
		//use pseudo event 'onsapescape' to implement keyboard-trigger for closing this dialog
		this._oPopup.onsapescape = fnOnEscape;
	}
};

sap.m.BusyDialog.prototype.openAnimation = function($Ref, iRealDuration, fnOpened) {
	if(sap.ui.Device.os.ios && this._isPlatformDependent) {
		$Ref.css('display', 'block');
		$Ref.bind("webkitAnimationEnd animationend", function(){
		jQuery(this).unbind("webkitAnimationEnd animationend");
			fnOpened();
		});
		$Ref.css('-webkit-animation-name', 'sapMDialogBounce')
			.css('animation-name', 'sapMDialogBounce');
	} else {
		fnOpened();
	}
};

sap.m.BusyDialog.prototype.closeAnimation = function($Ref, iRealDuration, fnClose) {
	fnClose();
};

/**
 * Destroys the dialog control
 * @private
 */
sap.m.BusyDialog.prototype.exit = function(){
	this._oPopup.close();
	this._oPopup.destroy();
	this._oPopup = null;
	
	this._$window.unbind("resize", this._fOrientationChange);
};

/**
 * Opens the dialog
 *
 * @public
 *
 */
sap.m.BusyDialog.prototype.open = function(){
	jQuery.sap.log.debug("sap.m.BusyDialog.open called at " + new Date().getTime());
	
	var oPopup = this._oPopup;
	if (oPopup.isOpen()){
		return this;
	}
	// Open popup
	oPopup.setContent(this);
	oPopup.attachEvent(sap.ui.core.Popup.M_EVENTS.opened, this._handleOpened, this);
	oPopup.setPosition("center center", "center center", document, "0 0", "fit");

	this._bOpenRequested = true;
	this._openNowIfPossibleAndRequested();

	return this;
};


sap.m.BusyDialog.prototype._openNowIfPossibleAndRequested = function(){
	if (!this._bOpenRequested) {
		return;
	}
	
	// If body/Core are not available yet, give them some more time and open later if still required
	if (!document.body || !sap.ui.getCore().isInitialized()) {
		jQuery.sap.delayedCall(50, this, "_openNowIfPossibleAndRequested");
		return;
	}
	
	this._bOpenRequested = false; // opening request is handled
	this._oPopup.open();
};

/**
 * Closes the dialog
 *
 * @public
 *
 */
sap.m.BusyDialog.prototype.close = function(){
	this._bOpenRequested = false;
	var oPopup = this._oPopup;

	var eOpenState = this._oPopup.getOpenState();
	if(!(eOpenState === sap.ui.core.OpenState.CLOSED || eOpenState === sap.ui.core.OpenState.CLOSING)){
		oPopup.attachEvent(sap.ui.core.Popup.M_EVENTS.closed, this._handleClosed, this);
		jQuery.sap.log.debug("sap.m.BusyDialog.close called at " + new Date().getTime());
		oPopup.close();
		this.fireClose();
	}
	return this;
};

sap.m.BusyDialog.prototype.setText = function(sText){
	this.setProperty("text", sText, true);
	if(!this._oLabel) {
		this._oLabel = new sap.m.Label(this.getId() + "-busyLabel", {}).addStyleClass("sapMBusyDialogLabel");
		this.setAggregation("_busyLabel", this._oLabel, true);
	}
	this._oLabel.setText(sText);
	return this;
};

sap.m.BusyDialog.prototype.setCustomIcon = function(oIcon){
	this.setProperty("customIcon", oIcon, true);
	this._busyIndicator.setCustomIcon(oIcon);
	return this;
};

sap.m.BusyDialog.prototype.setCustomIconRotationSpeed = function(iSpeed){
	this.setProperty("customIconRotationSpeed", iSpeed, true);
	this._busyIndicator.setCustomIconRotationSpeed(iSpeed);
	return this;
};

sap.m.BusyDialog.prototype.setCustomIconDensityAware = function(bAware){
	this.setProperty("customIconDensityAware", bAware, true);
	this._busyIndicator.setCustomIconDensityAware(bAware);
	return this;
};

sap.m.BusyDialog.prototype.setCustomIconWidth = function(sWidth){
	this.setProperty("customIconWidth", sWidth, true);
	this._busyIndicator.setCustomIconWidth(sWidth);
	return this;
};

sap.m.BusyDialog.prototype.setCustomIconHeight = function(sHeight){
	this.setProperty("customIconHeight", sHeight, true);
	this._busyIndicator.setCustomIconHeight(sHeight);
	return this;
};

sap.m.BusyDialog.prototype.setShowCancelButton = function(bShow){
	this.setProperty("showCancelButton", bShow, false);
	if(bShow) {
		this._createCancelButton();
	}
	return this;
};

sap.m.BusyDialog.prototype.setCancelButtonText = function(sText){
	this.setProperty("cancelButtonText", sText, true);
	this._createCancelButton();
	this._oButton.setText(sText);
	return this;
};

sap.m.BusyDialog.prototype._createCancelButton = function(){
	if(!this._oButton) {
		var sButtonStyle = "";
		var self = this;
		var sButtonText = (this.getCancelButtonText()) ? this.getCancelButtonText() : sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("BUSYDIALOG_CANCELBUTTON_TEXT");
		if(!this._isPlatformDependent) {
			sButtonStyle = sap.m.ButtonType.Transparent;
		} else {
			sButtonStyle = (sap.ui.Device.os.ios) ? sap.m.ButtonType.Unstyled : sap.m.ButtonType.Default;
		}
		this._oButton = new sap.m.Button(this.getId() + 'busyCancelBtn', {
				text: sButtonText,
				type: sButtonStyle,
				press : function() {
					self.close();
				}
		}).addStyleClass("sapMDialogBtn");
		this.setAggregation("_busyButton", this._oButton, true);
	}
};

sap.m.BusyDialog.prototype._reposition = function() {
	var ePopupState = this._oPopup.getOpenState();
	if(!(ePopupState === sap.ui.core.OpenState.OPEN)){
		return;
	}
	this._oPopup._applyPosition(this._oPopup._oLastPosition);
	
};

sap.m.BusyDialog.prototype._handleOpened = function(){
	this._oPopup.detachEvent(sap.ui.core.Popup.M_EVENTS.opened, this._handleOpened, this);
	// bind to window resize
	// In android, the orientationchange fires before the size of the window changes
	//  that's why the resize event is used here.
	this._$window.bind("resize", this._fOrientationChange);
};

sap.m.BusyDialog.prototype._handleClosed = function(){
	this._oPopup.detachEvent(sap.ui.core.Popup.M_EVENTS.closed, this._handleClosed, this);
	this._$window.unbind("resize", this._fOrientationChange);
};

sap.m.BusyDialog.prototype._setDimensions = function() {
	// Derive width and height from viewport
	var iWindowHeight = (sap.ui.Device.os.ios || !this._isPlatformDependent) ? this._$window.height() : ( this._$window.height() - 50);
	var $this = this.$();;
	//reset
	$this.css({
		"left": "0px",
		"top": "0px",
		"max-height": this._$window.height() + "px"
	});
	if(iWindowHeight <= this.iOldWinHeight) {
		if(!this.$().hasClass("sapMBsyDSmall")) {
			this._checkSize(iWindowHeight);
		}
	}
	if(iWindowHeight > this.iOldWinHeight) {
		if((this.$().hasClass("sapMBsyDSmall"))) {
			this._checkSize(iWindowHeight);
		}
	}
	if(this.iOldWinHeight == 0) {
		this._checkSize(iWindowHeight);
	}
	this.iOldWinHeight = (sap.ui.Device.os.ios || !this._isPlatformDependent) ? this._$window.height() : (this._$window.height() - 50);
};

sap.m.BusyDialog.prototype._checkSize = function(iWindowHeight) {
	if(iWindowHeight < this.$()[0].scrollHeight) {
		this.$().toggleClass("sapMBsyDSmall", true);
		if(!sap.ui.Device.os.ios && this._isPlatformDependent) {
			this.$().css("width", this._$window.width() * 0.7);
		}
	} else {
		this.$().toggleClass("sapMBsyDSmall", false);
		if(!sap.ui.Device.os.ios && !this._isPlatformDependent) {
			this.$().css("width", "18.75em");
		}
	}
};
}; // end of sap/m/BusyDialog.js
if ( !jQuery.sap.isDeclared('sap.m.BusyIndicator') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.m.BusyIndicator.
jQuery.sap.declare("sap.m.BusyIndicator");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new BusyIndicator.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getText text} : string</li>
 * <li>{@link #getTextDirection textDirection} : sap.ui.core.TextDirection (default: sap.ui.core.TextDirection.Inherit)</li>
 * <li>{@link #getVisible visible} : boolean (default: true)</li>
 * <li>{@link #getCustomIcon customIcon} : sap.ui.core.URI</li>
 * <li>{@link #getCustomIconRotationSpeed customIconRotationSpeed} : int (default: 1000)</li>
 * <li>{@link #getCustomIconDensityAware customIconDensityAware} : boolean (default: true)</li>
 * <li>{@link #getCustomIconWidth customIconWidth} : sap.ui.core.CSSSize (default: "44px")</li>
 * <li>{@link #getCustomIconHeight customIconHeight} : sap.ui.core.CSSSize (default: "44px")</li>
 * <li>{@link #getSize size} : sap.ui.core.CSSSize</li>
 * <li>{@link #getDesign design} : string (default: 'auto')</li></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * Control to indicate that the system is busy with some task and the user has to wait. When no image or gif is provided, the control renders the platforms native indicator using css.
 * @extends sap.ui.core.Control
 *
 * @author SAP AG 
 * @version 1.20.6
 *
 * @constructor   
 * @public
 * @name sap.m.BusyIndicator
 */
sap.ui.core.Control.extend("sap.m.BusyIndicator", { metadata : {

	// ---- object ----

	// ---- control specific ----
	library : "sap.m",
	properties : {
		"text" : {type : "string", group : "Data", defaultValue : null},
		"textDirection" : {type : "sap.ui.core.TextDirection", group : "Appearance", defaultValue : sap.ui.core.TextDirection.Inherit},
		"visible" : {type : "boolean", group : "Appearance", defaultValue : true},
		"customIcon" : {type : "sap.ui.core.URI", group : "Misc", defaultValue : null},
		"customIconRotationSpeed" : {type : "int", group : "Appearance", defaultValue : 1000},
		"customIconDensityAware" : {type : "boolean", group : "", defaultValue : true},
		"customIconWidth" : {type : "sap.ui.core.CSSSize", group : "Appearance", defaultValue : "44px"},
		"customIconHeight" : {type : "sap.ui.core.CSSSize", group : "Appearance", defaultValue : "44px"},
		"size" : {type : "sap.ui.core.CSSSize", group : "Misc", defaultValue : null},
		"design" : {type : "string", group : "Appearance", defaultValue : 'auto'}
	},
	aggregations : {
    	"_iconImage" : {type : "sap.ui.core.Control", multiple : false, visibility : "hidden"}, 
    	"_busyLabel" : {type : "sap.ui.core.Control", multiple : false, visibility : "hidden"}
	}
}});


/**
 * Creates a new subclass of class sap.m.BusyIndicator with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.m.BusyIndicator.extend
 * @function
 */


/**
 * Getter for property <code>text</code>.
 * Defines the text displayed next to the busy indicator (optional)
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>text</code>
 * @public
 * @name sap.m.BusyIndicator#getText
 * @function
 */

/**
 * Setter for property <code>text</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sText  new value for property <code>text</code>
 * @return {sap.m.BusyIndicator} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.BusyIndicator#setText
 * @function
 */


/**
 * Getter for property <code>textDirection</code>.
 * Options for the text direction are RTL and LTR. Alternatively, the control can inherit the text direction from its parent container.
 *
 * Default value is <code>sap.ui.core.TextDirection.Inherit</code>
 *
 * @return {sap.ui.core.TextDirection} the value of property <code>textDirection</code>
 * @public
 * @name sap.m.BusyIndicator#getTextDirection
 * @function
 */

/**
 * Setter for property <code>textDirection</code>.
 *
 * Default value is <code>sap.ui.core.TextDirection.Inherit</code> 
 *
 * @param {sap.ui.core.TextDirection} oTextDirection  new value for property <code>textDirection</code>
 * @return {sap.m.BusyIndicator} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.BusyIndicator#setTextDirection
 * @function
 */


/**
 * Getter for property <code>visible</code>.
 * Set to false to make the control invisible.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>visible</code>
 * @public
 * @name sap.m.BusyIndicator#getVisible
 * @function
 */

/**
 * Setter for property <code>visible</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bVisible  new value for property <code>visible</code>
 * @return {sap.m.BusyIndicator} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.BusyIndicator#setVisible
 * @function
 */


/**
 * Getter for property <code>customIcon</code>.
 * Icon url if an icon is used as the busy indicator.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.core.URI} the value of property <code>customIcon</code>
 * @public
 * @name sap.m.BusyIndicator#getCustomIcon
 * @function
 */

/**
 * Setter for property <code>customIcon</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.core.URI} sCustomIcon  new value for property <code>customIcon</code>
 * @return {sap.m.BusyIndicator} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.BusyIndicator#setCustomIcon
 * @function
 */


/**
 * Getter for property <code>customIconRotationSpeed</code>.
 * Defines the rotation speed of the given image. If a .gif is used, the speed has to be set to 0. The unit is in ms.
 *
 * Default value is <code>1000</code>
 *
 * @return {int} the value of property <code>customIconRotationSpeed</code>
 * @public
 * @name sap.m.BusyIndicator#getCustomIconRotationSpeed
 * @function
 */

/**
 * Setter for property <code>customIconRotationSpeed</code>.
 *
 * Default value is <code>1000</code> 
 *
 * @param {int} iCustomIconRotationSpeed  new value for property <code>customIconRotationSpeed</code>
 * @return {sap.m.BusyIndicator} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.BusyIndicator#setCustomIconRotationSpeed
 * @function
 */


/**
 * Getter for property <code>customIconDensityAware</code>.
 * If this is set to false, the src image will be loaded directly without attempting to fetch the density perfect image for high density device.
 * 
 * By default, this is set to true but then one or more requests are sent trying to get the density perfect version of image if this version of image doesn't exist on the server.
 * 
 * If bandwidth is the key for the application, set this value to false.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>customIconDensityAware</code>
 * @public
 * @name sap.m.BusyIndicator#getCustomIconDensityAware
 * @function
 */

/**
 * Setter for property <code>customIconDensityAware</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bCustomIconDensityAware  new value for property <code>customIconDensityAware</code>
 * @return {sap.m.BusyIndicator} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.BusyIndicator#setCustomIconDensityAware
 * @function
 */


/**
 * Getter for property <code>customIconWidth</code>.
 * Width of the provided icon. By default 44px are used.
 *
 * Default value is <code>"44px"</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>customIconWidth</code>
 * @public
 * @name sap.m.BusyIndicator#getCustomIconWidth
 * @function
 */

/**
 * Setter for property <code>customIconWidth</code>.
 *
 * Default value is <code>"44px"</code> 
 *
 * @param {sap.ui.core.CSSSize} sCustomIconWidth  new value for property <code>customIconWidth</code>
 * @return {sap.m.BusyIndicator} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.BusyIndicator#setCustomIconWidth
 * @function
 */


/**
 * Getter for property <code>customIconHeight</code>.
 * Height of the provided icon. By default 44px are used.
 *
 * Default value is <code>"44px"</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>customIconHeight</code>
 * @public
 * @name sap.m.BusyIndicator#getCustomIconHeight
 * @function
 */

/**
 * Setter for property <code>customIconHeight</code>.
 *
 * Default value is <code>"44px"</code> 
 *
 * @param {sap.ui.core.CSSSize} sCustomIconHeight  new value for property <code>customIconHeight</code>
 * @return {sap.m.BusyIndicator} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.BusyIndicator#setCustomIconHeight
 * @function
 */


/**
 * Getter for property <code>size</code>.
 * Defines the size of the busy indicator.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>size</code>
 * @public
 * @name sap.m.BusyIndicator#getSize
 * @function
 */

/**
 * Setter for property <code>size</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.core.CSSSize} sSize  new value for property <code>size</code>
 * @return {sap.m.BusyIndicator} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.BusyIndicator#setSize
 * @function
 */


/**
 * Getter for property <code>design</code>.
 * The design defines how the BusyIndicator should look like. There are 3 possiblities:
 * auto: automatically sets the design according to the context
 * dark: dark theme, useful within a light context
 * light: light theme, useful within a dark context
 *
 * Default value is <code>auto</code>
 *
 * @return {string} the value of property <code>design</code>
 * @public
 * @name sap.m.BusyIndicator#getDesign
 * @function
 */

/**
 * Setter for property <code>design</code>.
 *
 * Default value is <code>auto</code> 
 *
 * @param {string} sDesign  new value for property <code>design</code>
 * @return {sap.m.BusyIndicator} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.BusyIndicator#setDesign
 * @function
 */


// Start of sap\m\BusyIndicator.js
jQuery.sap.require('sap.ui.core.theming.Parameters'); // unlisted dependency retained


sap.m.BusyIndicator.prototype.init = function(){
	if(sap.ui.core.theming.Parameters.get("sapMPlatformDependent") != "true"){
		// Blue crystal design: rotating arc
		// bugs.webkit.org: id=82647, id=74801 dynamically created SVG does not animate
		// do not use SVG in ios and android < 4.2 
		if(sap.ui.Device.browser.chrome 
				|| sap.ui.Device.os.blackberry
				|| sap.ui.Device.os.android && sap.ui.Device.os.version > 4.1){
			// Browsers with correct SMIL animation show SVG (crisp rendering)
			this._bUseSvg = true;
		} else {
			// Fall-back for other browsers: show canvas animation (aliased rendering)
			this._bUseCanvas = true;
		}
	}
	this._bIosStyle = sap.ui.Device.os.ios;
	this._sBColor = sap.ui.core.theming.Parameters.get("sapUiPageBG") || "rgba(0, 0, 0, 0)";
};

sap.m.BusyIndicator.prototype.exit = function(){
	this._cancelAnimation();
};

// Request canvas animation
// @private 
if(window.requestAnimationFrame){
	sap.m.BusyIndicator.prototype._requestAnimation = function(fCallback){
		return window.requestAnimationFrame(fCallback);
	};
} else if(window.webkitRequestAnimationFrame){
	sap.m.BusyIndicator.prototype._requestAnimation = function(fCallback, oDOM){
		return window.webkitRequestAnimationFrame(fCallback, oDOM);
	};	
} else if(window.mozRequestAnimationFrame){
	sap.m.BusyIndicator.prototype._requestAnimation = function(fCallback){
		return window.mozRequestAnimationFrame(fCallback);
	};
} else {
	sap.m.BusyIndicator.prototype._requestAnimation = function(fCallback){
		return window.setTimeout(fCallback, 1000 / 60);
	};
};

// Stop canvas animation
// @private 
sap.m.BusyIndicator.prototype._cancelAnimation = function(){
	if(!this._animationId){ return;}
	
	if(window.cancelAnimationFrame){
		window.cancelAnimationFrame(this._animationId);
	} else if(window.webkitCancelAnimationFrame){
		window.webkitCancelAnimationFrame(this._animationId);
	} else if(window.mozCancelAnimationFrame){
		window.mozCancelAnimationFrame(this._animationId);
	} else{	
		window.clearTimeout(this._animationId); 
	};
	this._animationId = undefined;
};

// Do the next animation step
// @private 
sap.m.BusyIndicator.prototype._animateCanvas = function(){
	if(!this.oCanvas){ return; }
	
	var clientWidth = this.oCanvas.clientWidth,
		clientHeight = this.oCanvas.clientHeight;
	
	if(!clientWidth || !clientHeight){
			// if the indicator becomes invisible, client width and height are set to 0. 
			// Stop animation
			this._animationId = undefined;
			return;  
	}
	
	// Adjust the canvas size to avoid aliasing artifacts
	// This is needed only once after first rendering and only for custom size
	if(clientWidth != this.oCanvas.width){ 
		this.oCanvas.setAttribute("width", clientWidth);
	}
	if(clientHeight != this.oCanvas.height){
		this.oCanvas.setAttribute("height", clientHeight);
	}
	
	var context = this.oCanvas.getContext("2d"),
		w = this.oCanvas.width,
		h = this.oCanvas.height,
		x = Math.round(w/2),
		y = Math.round(h/2),
		r = Math.round(x * 0.7),
		t = new Date(),
		startAngle = 0.9 * (t.getSeconds() + t.getMilliseconds() / 1000) * 2 * Math.PI,
		endAngle = startAngle + 1.25 * Math.PI, // 225 grad
		counterClock = false,
		strokeStyle = window.getComputedStyle(this.oCanvas).color,
		lineWidth = Math.round(w / 10) * 2;
	
	context.clearRect(0,0,w,h);
	
	// clearRect does not clear canvas in Android browser 4.1, 
	// workaround: draw a white circle underneath
	if(sap.ui.Device.os.android && sap.ui.Device.os.version == 4.1 && !sap.ui.Device.browser.chrome){
		context.strokeStyle = this._sBColor; 
		context.lineWidth = lineWidth + 2;
		context.beginPath();
		context.arc(x, y, r, 0, 2 * Math.PI);
		context.stroke();
	}
	
	context.strokeStyle = strokeStyle;
	context.lineWidth = lineWidth;
	context.beginPath();
	context.arc(x, y, r, startAngle, endAngle, counterClock);
	context.stroke();
	
	this._animationId = this._requestAnimation(this._fAnimateCallback, this.oCanvas);
};

// Start the canvas based animation
// @private 
sap.m.BusyIndicator.prototype._doCanvas = function(){
	this.oCanvas = this.getDomRef("canvas");
	this._fAnimateCallback = jQuery.proxy(this._animateCanvas, this);
	this._animationId = this._requestAnimation(this._fAnimateCallback, this.oCanvas);
};

// Create internal icon image
// @private 
sap.m.BusyIndicator.prototype._createCustomIcon = function(sName, sValue){
	var self = this;
	if(!this._iconImage) {
		this._iconImage = new sap.m.Image(this.getId() + "-icon", {
				width: "44px",
				height: "44px"
			}).addStyleClass('sapMBsyIndIcon');
		this._iconImage.addDelegate({onAfterRendering : function() {
				self._setRotationSpeed();
			}
		});
		this.setAggregation("_iconImage", this._iconImage, true);
	}
	this._iconImage[sName](sValue);
	this._setRotationSpeed();
};

// Create internal label
// @private 
sap.m.BusyIndicator.prototype._createLabel = function(sName, sValue){
	if (!this._oLabel) {
		this._oLabel = new sap.m.Label(this.getId() + "-label", {}).addStyleClass("sapMBsyIndLabel");
		this.setAggregation("_busyLabel", this._oLabel);
	}
	this._oLabel[sName](sValue);
};

// Do the "old style" css based platform dependent animation
// @private 
sap.m.BusyIndicator.prototype._doPlatformDependent = function(){
	var $_elem = this.$();
	
	var parentElement = this.getParent() ? this.getParent()._context : '';
	//Set the color to the first parents color which is not transparent. Skip this when inside Dialog or Bar.
	if(!this._bIosStyle) {
		if(!this.getCustomIcon() && this.$().parent('.sapMBusyDialog').length === 0 && parentElement !== 'header') {
			var bFoundCss = true;
			
			while( $_elem.css('background-color') === "rgba(0, 0, 0, 0)" ) {
				$_elem = $_elem.parent();
				
				//Do not ask '#document' for its css. this will cause trouble. Therefore
				//'$_elem.parent().length' is checked
				if($_elem.parent().length == 0) {
					bFoundCss = false;
					break;
				}
			}
			//This is the default color
			var sBColor = bFoundCss? $_elem.css('background-color') : this._sBColor;
			this.$().children().children('.sapMSpinBar3').children('.sapMSpinBar4').css('background-color', sBColor);
		}
	}
};

// Set the rotation speed of the image
// @private 
sap.m.BusyIndicator.prototype._setRotationSpeed = function(){

	if(!this._iconImage) return;

	if(jQuery.support.cssAnimations){
		var $icon = this._iconImage.$();
		var sRotationSpeed = this.getCustomIconRotationSpeed() + "ms";
		$icon.css("-webkit-animation-duration", sRotationSpeed)
			.css("animation-duration", sRotationSpeed);
		//Bug in Chrome: After changing height of image -> changing the rotationspeed will have no affect
		//chrome needs a rerendering of this element.
		$icon.css("display", "none");
		setTimeout(function() {
			$icon.css("display", "inline");
		}, 0);
	} else { // IE9
		this._rotateCustomIcon();
	}
};

//Animate custom icon in IE9
//@private
sap.m.BusyIndicator.prototype._rotateCustomIcon = function(){

	if(!this._iconImage){
		return;
	}
	var $icon = this._iconImage.$();

	// stop if the custom icon is not available or hidden:
	if(!$icon[0] || !$icon[0].offsetWidth){
		return;
	}

	var iRotationSpeed = this.getCustomIconRotationSpeed();
	if(!iRotationSpeed) return;

	if(!this._fnRotateCustomIcon){
		this._fnRotateCustomIcon = jQuery.proxy(this._rotateCustomIcon, this);
	}
	var fnRotateCustomIcon = this._fnRotateCustomIcon;

	if(!this._$CustomRotator){
		this._$CustomRotator = jQuery({deg: 0});
	}
	var $rotator = this._$CustomRotator;

	if($rotator.running){
		return;
	}

	// restart animation
	$rotator[0].deg = 0;

	$rotator.animate({deg: 360}, {
		duration: iRotationSpeed,
		easing: "linear",
		step: function(now) {
			$rotator.running = true;
			$icon.css("-ms-transform", 'rotate(' + now + 'deg)');
		},
		complete: function(){
			$rotator.running = false;
			window.setTimeout(fnRotateCustomIcon, 10);
		}
	});
};

sap.m.BusyIndicator.prototype.onBeforeRendering = function(){
	this._cancelAnimation();
};

sap.m.BusyIndicator.prototype.onAfterRendering = function(){
	if(this._bUseSvg) {
		return; // do nothing, svg animates itself
	}else if(this._bUseCanvas) {
		this._doCanvas();
	} else {
		this._doPlatformDependent();
	};
	
};

sap.m.BusyIndicator.prototype.setText = function(sText){
	this.setProperty("text", sText, true);
	this._createLabel("setText", sText);
	return this;
};

sap.m.BusyIndicator.prototype.setTextDirection = function(sDirection){
	this.setProperty("textDirection", sDirection, true);
	this._createLabel("setTextDirection", sDirection);
	return this;
};

sap.m.BusyIndicator.prototype.setCustomIcon = function(iSrc){
	this.setProperty("customIcon", iSrc, false);
	this._createCustomIcon("setSrc", iSrc);
	return this;
};

sap.m.BusyIndicator.prototype.setCustomIconRotationSpeed = function(iSpeed){
	if(isNaN(iSpeed) || iSpeed < 0){
		iSpeed = 0;
	}
	if(iSpeed !== this.getCustomIconRotationSpeed()) {
		this.setProperty("customIconRotationSpeed", iSpeed, true);
		this._setRotationSpeed();
	}
	return this;
};

sap.m.BusyIndicator.prototype.setCustomIconDensityAware = function(bAware){
	this.setProperty("customIconDensityAware", bAware, true);
	this._createCustomIcon("setDensityAware", bAware);
	return this;
};

sap.m.BusyIndicator.prototype.setCustomIconWidth = function(sWidth){
	this.setProperty("customIconWidth", sWidth, true);
	this._createCustomIcon("setWidth", sWidth);
	return this;
};

sap.m.BusyIndicator.prototype.setCustomIconHeight = function(sHeight){
	this.setProperty("customIconHeight", sHeight, true);
	this._createCustomIcon("setHeight", sHeight);
	return this;
};

sap.m.BusyIndicator.prototype.setDesign = function(sDesign) {
	this.setProperty("design", sDesign, true);
	this.$().toggleClass("sapMBusyIndicatorLight", (this.getDesign() === "light"));
	this.$().toggleClass("sapMBusyIndicatorDark", (this.getDesign() === "dark"));
	return this;
};

/**
 * Setter for property <code>visible</code>.
 *
 * Default value is <code>true</code>
 *
 * @param {boolean} bVisible  new value for property <code>visible</code>
 * @return {sap.m.BusyIndicator} <code>this</code> to allow method chaining
 * @public
 *
 * The MessageBar.API.js "setVisible" function is enhanced in order to
 * toggle the "visibility:hidden;" attribute over the control.
 */
sap.m.BusyIndicator.prototype.setVisible = function(bVisible){
	var oDomRef = this.getDomRef();
	//only suppress rerendering when it's already rendered
	this.setProperty("visible", bVisible, !!oDomRef);
	
	if(oDomRef){
		this.getDomRef().style.visibility = bVisible? "visible" : "hidden";
		if(bVisible && !this._animationId){
			this._animateCanvas();
		}
	}
	
	return this;
};

}; // end of sap/m/BusyIndicator.js
if ( !jQuery.sap.isDeclared('sap.m.Button') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.m.Button.
jQuery.sap.declare("sap.m.Button");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new Button.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getText text} : string</li>
 * <li>{@link #getType type} : sap.m.ButtonType (default: sap.m.ButtonType.Default)</li>
 * <li>{@link #getWidth width} : sap.ui.core.CSSSize</li>
 * <li>{@link #getEnabled enabled} : boolean (default: true)</li>
 * <li>{@link #getVisible visible} : boolean (default: true)</li>
 * <li>{@link #getIcon icon} : sap.ui.core.URI</li>
 * <li>{@link #getIconFirst iconFirst} : boolean (default: true)</li>
 * <li>{@link #getActiveIcon activeIcon} : sap.ui.core.URI</li>
 * <li>{@link #getIconDensityAware iconDensityAware} : boolean (default: true)</li></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul>
 * <li>{@link sap.m.Button#event:tap tap} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li>
 * <li>{@link sap.m.Button#event:press press} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * Enables users to trigger actions. For the button UI, you can define some text or an icon, or both.
 * @extends sap.ui.core.Control
 *
 * @author SAP AG 
 * @version 1.20.6
 *
 * @constructor   
 * @public
 * @name sap.m.Button
 */
sap.ui.core.Control.extend("sap.m.Button", { metadata : {

	// ---- object ----

	// ---- control specific ----
	library : "sap.m",
	properties : {
		"text" : {type : "string", group : "Misc", defaultValue : null},
		"type" : {type : "sap.m.ButtonType", group : "Appearance", defaultValue : sap.m.ButtonType.Default},
		"width" : {type : "sap.ui.core.CSSSize", group : "Misc", defaultValue : null},
		"enabled" : {type : "boolean", group : "Behavior", defaultValue : true},
		"visible" : {type : "boolean", group : "Appearance", defaultValue : true},
		"icon" : {type : "sap.ui.core.URI", group : "Appearance", defaultValue : null},
		"iconFirst" : {type : "boolean", group : "Appearance", defaultValue : true},
		"activeIcon" : {type : "sap.ui.core.URI", group : "Misc", defaultValue : null},
		"iconDensityAware" : {type : "boolean", group : "Misc", defaultValue : true}
	},
	events : {
		"tap" : {}, 
		"press" : {}
	}
}});


/**
 * Creates a new subclass of class sap.m.Button with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.m.Button.extend
 * @function
 */

sap.m.Button.M_EVENTS = {'tap':'tap','press':'press'};


/**
 * Getter for property <code>text</code>.
 * Button text
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>text</code>
 * @public
 * @name sap.m.Button#getText
 * @function
 */

/**
 * Setter for property <code>text</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sText  new value for property <code>text</code>
 * @return {sap.m.Button} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Button#setText
 * @function
 */


/**
 * Getter for property <code>type</code>.
 * Type of a button (e.g. Default, Accept, Reject, Back, etc.)
 *
 * Default value is <code>Default</code>
 *
 * @return {sap.m.ButtonType} the value of property <code>type</code>
 * @public
 * @name sap.m.Button#getType
 * @function
 */

/**
 * Setter for property <code>type</code>.
 *
 * Default value is <code>Default</code> 
 *
 * @param {sap.m.ButtonType} oType  new value for property <code>type</code>
 * @return {sap.m.Button} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Button#setType
 * @function
 */


/**
 * Getter for property <code>width</code>.
 * Defines the width of the button.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>width</code>
 * @public
 * @name sap.m.Button#getWidth
 * @function
 */

/**
 * Setter for property <code>width</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.core.CSSSize} sWidth  new value for property <code>width</code>
 * @return {sap.m.Button} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Button#setWidth
 * @function
 */


/**
 * Getter for property <code>enabled</code>.
 * Boolean property to enable the control (default is true). Buttons that are disabled have other colors than enabled ones, depending on custom settings
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>enabled</code>
 * @public
 * @name sap.m.Button#getEnabled
 * @function
 */

/**
 * Setter for property <code>enabled</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bEnabled  new value for property <code>enabled</code>
 * @return {sap.m.Button} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Button#setEnabled
 * @function
 */


/**
 * Getter for property <code>visible</code>.
 * Invisible buttons are not rendered
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>visible</code>
 * @public
 * @name sap.m.Button#getVisible
 * @function
 */

/**
 * Setter for property <code>visible</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bVisible  new value for property <code>visible</code>
 * @return {sap.m.Button} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Button#setVisible
 * @function
 */


/**
 * Getter for property <code>icon</code>.
 * Icon to be displayed as graphical element within the button. This can be an image or an icon from the icon font.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.core.URI} the value of property <code>icon</code>
 * @public
 * @name sap.m.Button#getIcon
 * @function
 */

/**
 * Setter for property <code>icon</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.core.URI} sIcon  new value for property <code>icon</code>
 * @return {sap.m.Button} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Button#setIcon
 * @function
 */


/**
 * Getter for property <code>iconFirst</code>.
 * If set to true (default), the display sequence is 1. icon 2. control text
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>iconFirst</code>
 * @public
 * @name sap.m.Button#getIconFirst
 * @function
 */

/**
 * Setter for property <code>iconFirst</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bIconFirst  new value for property <code>iconFirst</code>
 * @return {sap.m.Button} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Button#setIconFirst
 * @function
 */


/**
 * Getter for property <code>activeIcon</code>.
 * The source property when this icon is tapped. Graphical element is changed to the new source as long as the icon is tapped.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.core.URI} the value of property <code>activeIcon</code>
 * @public
 * @name sap.m.Button#getActiveIcon
 * @function
 */

/**
 * Setter for property <code>activeIcon</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.core.URI} sActiveIcon  new value for property <code>activeIcon</code>
 * @return {sap.m.Button} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Button#setActiveIcon
 * @function
 */


/**
 * Getter for property <code>iconDensityAware</code>.
 * By default, this is set to true but then one or more requests are sent trying to get the density perfect version of image if this version of image doesn't exist on the server.
 * 
 * If only one version of image is provided, set this value to false to avoid the attempt of fetching density perfect image.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>iconDensityAware</code>
 * @public
 * @name sap.m.Button#getIconDensityAware
 * @function
 */

/**
 * Setter for property <code>iconDensityAware</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bIconDensityAware  new value for property <code>iconDensityAware</code>
 * @return {sap.m.Button} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Button#setIconDensityAware
 * @function
 */


/**
 * Event is fired when the user taps the control. (This event is deprecated, use the press event instead) 
 *
 * @name sap.m.Button#tap
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters

 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'tap' event of this <code>sap.m.Button</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.m.Button</code>.<br/> itself. 
 *  
 * Event is fired when the user taps the control. (This event is deprecated, use the press event instead) 
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.m.Button</code>.<br/> itself.
 *
 * @return {sap.m.Button} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Button#attachTap
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'tap' event of this <code>sap.m.Button</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.m.Button} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Button#detachTap
 * @function
 */

/**
 * Fire event tap to attached listeners.

 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.m.Button} <code>this</code> to allow method chaining
 * @protected
 * @name sap.m.Button#fireTap
 * @function
 */


/**
 * Event is fired when the user clicks on the control. 
 *
 * @name sap.m.Button#press
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters

 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'press' event of this <code>sap.m.Button</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.m.Button</code>.<br/> itself. 
 *  
 * Event is fired when the user clicks on the control. 
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.m.Button</code>.<br/> itself.
 *
 * @return {sap.m.Button} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Button#attachPress
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'press' event of this <code>sap.m.Button</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.m.Button} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Button#detachPress
 * @function
 */

/**
 * Fire event press to attached listeners.

 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.m.Button} <code>this</code> to allow method chaining
 * @protected
 * @name sap.m.Button#firePress
 * @function
 */


// Start of sap\m\Button.js
jQuery.sap.require('sap.ui.core.EnabledPropagator'); // unlisted dependency retained

sap.ui.core.EnabledPropagator.call(sap.m.Button.prototype);
jQuery.sap.require('sap.ui.core.theming.Parameters'); // unlisted dependency retained

jQuery.sap.require('sap.ui.core.IconPool'); // unlisted dependency retained


/**
 * Function is called to define the behavior for the control.
 *
 * @private
 */
sap.m.Button.prototype.init = function() {
	this._isPlatformDependent = sap.ui.core.theming.Parameters.get("sapMPlatformDependent") == "true";
};

/**
 * Function is called when exiting the control.
 *
 * @private
 */
sap.m.Button.prototype.exit = function(oEvent) {

	// destroy image controls if initialized
	if (this._image) {
		this._image.destroy();
	}

	if (this._iconBtn) {
		this._iconBtn.destroy();
	}
};

/**
 * Function is called when touchstart occurs on button .
 *
 * @private
 */
sap.m.Button.prototype.ontouchstart = function(oEvent) {

	// mark the event for components that needs to know if the event was handled by the button
	oEvent.setMarked();

	// change the source only when the first finger is on the control, the
	// following fingers doesn't affect
	if (oEvent.targetTouches.length === 1) {

		// set active button state
		this._activeButton();

		// set target which started the event
		this._target = oEvent.target;
	}
};

/**
 * Function is called when touchend occurs on button .
 *
 * @private
 */
sap.m.Button.prototype.ontouchend = function(oEvent) {

	// set inactive button state
	this._inactiveButton();
};

/**
 * Function is called when tap occurs on button.
 *
 * @private
 */
sap.m.Button.prototype.ontap = function(oEvent) {

	// mark the event for components that needs to know if the event was handled by the button
	oEvent.setMarked();

	// fire tap event
	if (this.getEnabled()) {

		// if target is empty set target (specially for selenium test)
		if (!this._target) {
			this._target = oEvent.target;
		}

		// check if target which started the event is the same
		if ((!!this._target) && (this._target === oEvent.target)) {
			this.fireTap({/* no parameters */}); // (This event is deprecated, use the "press" event instead)
			this.firePress({/* no parameters */});
		}
	}

	// reset target which started the event
	delete this._target;
};

/**
 * Handle the key down event for SPACE and ENTER.
 * This implementation differs from that of commons button.
 * Commons listens to the click event and ignores touchstart.
 * @param {jQuery.Event} oEvent - the keyboard event.
 * @private
 */
sap.m.Button.prototype.onkeydown = function(oEvent) {

	if (oEvent.which === jQuery.sap.KeyCodes.SPACE || oEvent.which === jQuery.sap.KeyCodes.ENTER) {

		// mark the event for components that needs to know if the event was handled by the button
		oEvent.setMarked();

		// set active button state
		this._activeButton();

		// set target which started the event
		this._target = oEvent.target;
	}
};

/**
 * Handle the key up event for SPACE and ENTER.
 *
 * @param {jQuery.Event} oEvent - the keyboard event.
 * @private
 */
sap.m.Button.prototype.onkeyup = function(oEvent) {

	// if keydown isn't caught by button, ignore the keyup.
	if (!this._target) {
		return;
	}

	this._target = null;

	if (oEvent.which === jQuery.sap.KeyCodes.SPACE || oEvent.which === jQuery.sap.KeyCodes.ENTER) {

		// mark the event for components that needs to know if the event was handled by the button
		oEvent.setMarked();

		// set inactive button state
		this._inactiveButton();
		this.firePress({/* no parameters */});
	}
};

/**
 * Ensure that the active button state is removed by focus loss.
 *
 * @param {jQuery.Event} oEvent
 * @private
 */
sap.m.Button.prototype.onfocusout = function(oEvent) {

	// set inactive button state
	this._inactiveButton();
};

/**
 * Function is called when button is active.
 *
 * @private
 */
sap.m.Button.prototype._activeButton = function() {
	this.$().addClass("sapMBtnActive");

	// handling active icon
	if (this.getEnabled()) {
		if (this.getIcon() && this.getActiveIcon() && this._image instanceof sap.m.Image) {
			this._image.setSrc(this.getActiveIcon());
		}
	}
};

/**
 * Function is called when button is inactive.
 *
 * @private
 */
sap.m.Button.prototype._inactiveButton = function() {
	this.$().removeClass("sapMBtnActive");

	// handling active icon
	if (this.getEnabled()) {
		if (this.getIcon() && this.getActiveIcon() && this._image instanceof sap.m.Image) {
			this._image.setSrc(this.getIcon());
		}
	}
};

/**
 * Function is called when image control needs to be loaded.
 *
 * @private
 */
sap.m.Button.prototype._getImage = function(sImgId, sSrc, sActiveSrc, bIconDensityAware) {

	// check if image source has changed - if yes destroy and reset image control
	if(this._image && (this._image.getSrc() != sSrc)){
		this._image.destroy();
		this._image = undefined;
	}

	// update or create image control
	var oImage = this._image;

	if (!!oImage) {

		oImage.setSrc(sSrc);
		if(oImage instanceof sap.m.Image) {
			oImage.setActiveSrc(sActiveSrc);
			oImage.setDensityAware(bIconDensityAware);
		}
	} else {

		oImage = sap.ui.core.IconPool.createControlByURI({
			id: sImgId,
			src : sSrc,
			activeSrc : sActiveSrc,
			densityAware : bIconDensityAware
		}, sap.m.Image).addStyleClass("sapMBtnCustomIcon").setParent(this, null, true);
	}

	return this._image = oImage;
};

/**
 * Function is called when internal image control needs to be loaded.
 *
 * @private
 */
sap.m.Button.prototype._getInternalIconBtn = function(sImgId, sSrc) {
	var oIcon = this._iconBtn;

	if (!!oIcon) {
		oIcon.setSrc(sSrc);
	} else {
		oIcon = sap.ui.core.IconPool.createControlByURI(sSrc, sap.m.Image);
	}

	return this._iconBtn = oIcon;
};
}; // end of sap/m/Button.js
if ( !jQuery.sap.isDeclared('sap.m.Carousel') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.m.Carousel.
jQuery.sap.declare("sap.m.Carousel");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new Carousel.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getHeight height} : sap.ui.core.CSSSize (default: '100%')</li>
 * <li>{@link #getWidth width} : sap.ui.core.CSSSize (default: '100%')</li>
 * <li>{@link #getLoop loop} : boolean (default: false)</li>
 * <li>{@link #getVisible visible} : boolean (default: true)</li>
 * <li>{@link #getShowPageIndicator showPageIndicator} : boolean (default: true)</li>
 * <li>{@link #getPageIndicatorPlacement pageIndicatorPlacement} : sap.m.PlacementType (default: sap.m.PlacementType.Bottom)</li>
 * <li>{@link #getShowBusyIndicator showBusyIndicator} : boolean (default: true)</li>
 * <li>{@link #getBusyIndicatorSize busyIndicatorSize} : sap.ui.core.CSSSize (default: '6em')</li></ul>
 * </li>
 * <li>Aggregations
 * <ul>
 * <li>{@link #getPages pages} <strong>(default aggregation)</strong> : sap.ui.core.Control[]</li></ul>
 * </li>
 * <li>Associations
 * <ul>
 * <li>{@link #getActivePage activePage} : string | sap.ui.core.Control</li></ul>
 * </li>
 * <li>Events
 * <ul>
 * <li>{@link sap.m.Carousel#event:loadPage loadPage} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li>
 * <li>{@link sap.m.Carousel#event:unloadPage unloadPage} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li>
 * <li>{@link sap.m.Carousel#event:pageChanged pageChanged} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * The Carousel control can be used to navigate through a list of sap.m controls just like flipping through the pages of a book by swiping right or left. An indicator shows the current position within the control list. When displayed in a desktop browser, a left- and right-arrow button is displayed on the carousel's sides, which can be used to navigate through the carousel.
 * 
 * Note: when displa Internet Explorer 9, page changes are not animated.
 * @extends sap.ui.core.Control
 *
 * @author SAP AG 
 * @version 1.20.6
 *
 * @constructor   
 * @public
 * @name sap.m.Carousel
 */
sap.ui.core.Control.extend("sap.m.Carousel", { metadata : {

	// ---- object ----
	publicMethods : [
		// methods
		"next", "previous"
	],

	// ---- control specific ----
	library : "sap.m",
	properties : {
		"height" : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : '100%'},
		"width" : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : '100%'},
		"loop" : {type : "boolean", group : "Misc", defaultValue : false},
		"visible" : {type : "boolean", group : "Appearance", defaultValue : true},
		"showPageIndicator" : {type : "boolean", group : "Appearance", defaultValue : true},
		"pageIndicatorPlacement" : {type : "sap.m.PlacementType", group : "Appearance", defaultValue : sap.m.PlacementType.Bottom},
		"showBusyIndicator" : {type : "boolean", group : "Appearance", defaultValue : true, deprecated: true},
		"busyIndicatorSize" : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : '6em', deprecated: true}
	},
	defaultAggregation : "pages",
	aggregations : {
    	"pages" : {type : "sap.ui.core.Control", multiple : true, singularName : "page"}
	},
	associations : {
		"activePage" : {type : "sap.ui.core.Control", multiple : false}
	},
	events : {
		"loadPage" : {deprecated: true}, 
		"unloadPage" : {deprecated: true}, 
		"pageChanged" : {}
	}
}});


/**
 * Creates a new subclass of class sap.m.Carousel with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.m.Carousel.extend
 * @function
 */

sap.m.Carousel.M_EVENTS = {'loadPage':'loadPage','unloadPage':'unloadPage','pageChanged':'pageChanged'};


/**
 * Getter for property <code>height</code>.
 * The height of the carousel. Note that when a percentage value is used, the height of the surrounding container must be defined.
 *
 * Default value is <code>100%</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>height</code>
 * @public
 * @name sap.m.Carousel#getHeight
 * @function
 */

/**
 * Setter for property <code>height</code>.
 *
 * Default value is <code>100%</code> 
 *
 * @param {sap.ui.core.CSSSize} sHeight  new value for property <code>height</code>
 * @return {sap.m.Carousel} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Carousel#setHeight
 * @function
 */


/**
 * Getter for property <code>width</code>.
 * The width of the carousel. Note that when a percentage value is used, the height of the surrounding container must be defined.
 *
 * Default value is <code>100%</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>width</code>
 * @public
 * @name sap.m.Carousel#getWidth
 * @function
 */

/**
 * Setter for property <code>width</code>.
 *
 * Default value is <code>100%</code> 
 *
 * @param {sap.ui.core.CSSSize} sWidth  new value for property <code>width</code>
 * @return {sap.m.Carousel} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Carousel#setWidth
 * @function
 */


/**
 * Getter for property <code>loop</code>.
 * Defines whether the carousel should loop, i.e show the first page after the last page is reached and vice versa.
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>loop</code>
 * @public
 * @name sap.m.Carousel#getLoop
 * @function
 */

/**
 * Setter for property <code>loop</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bLoop  new value for property <code>loop</code>
 * @return {sap.m.Carousel} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Carousel#setLoop
 * @function
 */


/**
 * Getter for property <code>visible</code>.
 * Shows or hides the carousel.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>visible</code>
 * @public
 * @name sap.m.Carousel#getVisible
 * @function
 */

/**
 * Setter for property <code>visible</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bVisible  new value for property <code>visible</code>
 * @return {sap.m.Carousel} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Carousel#setVisible
 * @function
 */


/**
 * Getter for property <code>showPageIndicator</code>.
 * Show or hide carousel's page indicator.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>showPageIndicator</code>
 * @public
 * @name sap.m.Carousel#getShowPageIndicator
 * @function
 */

/**
 * Setter for property <code>showPageIndicator</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bShowPageIndicator  new value for property <code>showPageIndicator</code>
 * @return {sap.m.Carousel} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Carousel#setShowPageIndicator
 * @function
 */


/**
 * Getter for property <code>pageIndicatorPlacement</code>.
 * Defines where the carousel's page indicator is displayed. Possible values are sap.m.PlacementType.Top, sap.m.PlacementType.Bottom. Other values are ignored and the default value will be applied. The default value is sap.m.PlacementType.Bottom.
 *
 * Default value is <code>Bottom</code>
 *
 * @return {sap.m.PlacementType} the value of property <code>pageIndicatorPlacement</code>
 * @public
 * @name sap.m.Carousel#getPageIndicatorPlacement
 * @function
 */

/**
 * Setter for property <code>pageIndicatorPlacement</code>.
 *
 * Default value is <code>Bottom</code> 
 *
 * @param {sap.m.PlacementType} oPageIndicatorPlacement  new value for property <code>pageIndicatorPlacement</code>
 * @return {sap.m.Carousel} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Carousel#setPageIndicatorPlacement
 * @function
 */


/**
 * Getter for property <code>showBusyIndicator</code>.
 * Show or hide busy indicator in the carousel when loading pages after swipe.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>showBusyIndicator</code>
 * @public
 * @deprecated Since version 1.18.7. 
 * Since 1.18.7 pages are no longer loaded or unloaded. Therefore busy indicator is not necessary any longer.
 * @name sap.m.Carousel#getShowBusyIndicator
 * @function
 */

/**
 * Setter for property <code>showBusyIndicator</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bShowBusyIndicator  new value for property <code>showBusyIndicator</code>
 * @return {sap.m.Carousel} <code>this</code> to allow method chaining
 * @public
 * @deprecated Since version 1.18.7. 
 * Since 1.18.7 pages are no longer loaded or unloaded. Therefore busy indicator is not necessary any longer.
 * @name sap.m.Carousel#setShowBusyIndicator
 * @function
 */


/**
 * Getter for property <code>busyIndicatorSize</code>.
 * Size of the busy indicators which can be displayed in the carousel.
 *
 * Default value is <code>6em</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>busyIndicatorSize</code>
 * @public
 * @deprecated Since version 1.18.7. 
 * Since 1.18.7 pages are no longer loaded or unloaded. Therefore busy indicator is not necessary any longer.
 * @name sap.m.Carousel#getBusyIndicatorSize
 * @function
 */

/**
 * Setter for property <code>busyIndicatorSize</code>.
 *
 * Default value is <code>6em</code> 
 *
 * @param {sap.ui.core.CSSSize} sBusyIndicatorSize  new value for property <code>busyIndicatorSize</code>
 * @return {sap.m.Carousel} <code>this</code> to allow method chaining
 * @public
 * @deprecated Since version 1.18.7. 
 * Since 1.18.7 pages are no longer loaded or unloaded. Therefore busy indicator is not necessary any longer.
 * @name sap.m.Carousel#setBusyIndicatorSize
 * @function
 */


/**
 * Getter for aggregation <code>pages</code>.<br/>
 * The content which the carousel displays.
 * 
 * <strong>Note</strong>: this is the default aggregation for Carousel.
 * @return {sap.ui.core.Control[]}
 * @public
 * @name sap.m.Carousel#getPages
 * @function
 */


/**
 * Inserts a page into the aggregation named <code>pages</code>.
 *
 * @param {sap.ui.core.Control}
 *          oPage the page to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the page should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the page is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the page is inserted at 
 *             the last position        
 * @return {sap.m.Carousel} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Carousel#insertPage
 * @function
 */

/**
 * Adds some page <code>oPage</code> 
 * to the aggregation named <code>pages</code>.
 *
 * @param {sap.ui.core.Control}
 *            oPage the page to add; if empty, nothing is inserted
 * @return {sap.m.Carousel} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Carousel#addPage
 * @function
 */

/**
 * Removes an page from the aggregation named <code>pages</code>.
 *
 * @param {int | string | sap.ui.core.Control} vPage the page to remove or its index or id
 * @return {sap.ui.core.Control} the removed page or null
 * @public
 * @name sap.m.Carousel#removePage
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>pages</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.core.Control[]} an array of the removed elements (might be empty)
 * @public
 * @name sap.m.Carousel#removeAllPages
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.core.Control</code> in the aggregation named <code>pages</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.core.Control}
 *            oPage the page whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @name sap.m.Carousel#indexOfPage
 * @function
 */
	

/**
 * Destroys all the pages in the aggregation 
 * named <code>pages</code>.
 * @return {sap.m.Carousel} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Carousel#destroyPages
 * @function
 */


/**
 * Provides getter and setter for the currently displayed page. For the setter, argument may be the control itself, which must be member of the carousel's page list, or the control's id.
 * The getter will return the control id
 *
 * @return {string} Id of the element which is the current target of the <code>activePage</code> association, or null
 * @public
 * @name sap.m.Carousel#getActivePage
 * @function
 */

/**
 * Provides getter and setter for the currently displayed page. For the setter, argument may be the control itself, which must be member of the carousel's page list, or the control's id.
 * The getter will return the control id
 *
 * @param {string | sap.ui.core.Control} vActivePage 
 *    Id of an element which becomes the new target of this <code>activePage</code> association.
 *    Alternatively, an element instance may be given.
 * @return {sap.m.Carousel} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Carousel#setActivePage
 * @function
 */


	
/**
 * Carousel requires a new page to be loaded. This event may be used to fill the content of that page 
 *
 * @name sap.m.Carousel#loadPage
 * @event
 * @deprecated Since version 1.18.7. 
 * Since 1.18.7 pages are no longer loaded or unloaded
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters

 * @param {string} oControlEvent.getParameters.pageId Id of the page which will be loaded
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'loadPage' event of this <code>sap.m.Carousel</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.m.Carousel</code>.<br/> itself. 
 *  
 * Carousel requires a new page to be loaded. This event may be used to fill the content of that page 
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.m.Carousel</code>.<br/> itself.
 *
 * @return {sap.m.Carousel} <code>this</code> to allow method chaining
 * @public
 * @deprecated Since version 1.18.7. 
 * Since 1.18.7 pages are no longer loaded or unloaded
 * @name sap.m.Carousel#attachLoadPage
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'loadPage' event of this <code>sap.m.Carousel</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.m.Carousel} <code>this</code> to allow method chaining
 * @public
 * @deprecated Since version 1.18.7. 
 * Since 1.18.7 pages are no longer loaded or unloaded
 * @name sap.m.Carousel#detachLoadPage
 * @function
 */

/**
 * Fire event loadPage to attached listeners.
 * 
 * Expects following event parameters:
 * <ul>
 * <li>'pageId' of type <code>string</code> Id of the page which will be loaded</li>
 * </ul>
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.m.Carousel} <code>this</code> to allow method chaining
 * @protected
 * @deprecated Since version 1.18.7. 
 * Since 1.18.7 pages are no longer loaded or unloaded
 * @name sap.m.Carousel#fireLoadPage
 * @function
 */


/**
 * Carousel does not display a page any longer and unloads it. This event may be used to clean up the content of that page. 
 *
 * @name sap.m.Carousel#unloadPage
 * @event
 * @deprecated Since version 1.18.7. 
 * Since 1.18.7 pages are no longer loaded or unloaded
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters

 * @param {string} oControlEvent.getParameters.pageId Id of the page which will be unloaded
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'unloadPage' event of this <code>sap.m.Carousel</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.m.Carousel</code>.<br/> itself. 
 *  
 * Carousel does not display a page any longer and unloads it. This event may be used to clean up the content of that page. 
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.m.Carousel</code>.<br/> itself.
 *
 * @return {sap.m.Carousel} <code>this</code> to allow method chaining
 * @public
 * @deprecated Since version 1.18.7. 
 * Since 1.18.7 pages are no longer loaded or unloaded
 * @name sap.m.Carousel#attachUnloadPage
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'unloadPage' event of this <code>sap.m.Carousel</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.m.Carousel} <code>this</code> to allow method chaining
 * @public
 * @deprecated Since version 1.18.7. 
 * Since 1.18.7 pages are no longer loaded or unloaded
 * @name sap.m.Carousel#detachUnloadPage
 * @function
 */

/**
 * Fire event unloadPage to attached listeners.
 * 
 * Expects following event parameters:
 * <ul>
 * <li>'pageId' of type <code>string</code> Id of the page which will be unloaded</li>
 * </ul>
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.m.Carousel} <code>this</code> to allow method chaining
 * @protected
 * @deprecated Since version 1.18.7. 
 * Since 1.18.7 pages are no longer loaded or unloaded
 * @name sap.m.Carousel#fireUnloadPage
 * @function
 */


/**
 * This event is fired after a carousel swipe has been completed. It is triggered both by physical swipe events and through API carousel manipulations such as calling 'next', 'previous' or 'setActivePageId' functions. 
 *
 * @name sap.m.Carousel#pageChanged
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters

 * @param {string} oControlEvent.getParameters.oldActivePageId Id of the page which was active before the page change.
 * @param {string} oControlEvent.getParameters.newActivePageId Id of the page which is active after the page change.
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'pageChanged' event of this <code>sap.m.Carousel</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.m.Carousel</code>.<br/> itself. 
 *  
 * This event is fired after a carousel swipe has been completed. It is triggered both by physical swipe events and through API carousel manipulations such as calling 'next', 'previous' or 'setActivePageId' functions. 
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.m.Carousel</code>.<br/> itself.
 *
 * @return {sap.m.Carousel} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Carousel#attachPageChanged
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'pageChanged' event of this <code>sap.m.Carousel</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.m.Carousel} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Carousel#detachPageChanged
 * @function
 */

/**
 * Fire event pageChanged to attached listeners.
 * 
 * Expects following event parameters:
 * <ul>
 * <li>'oldActivePageId' of type <code>string</code> Id of the page which was active before the page change.</li>
 * <li>'newActivePageId' of type <code>string</code> Id of the page which is active after the page change.</li>
 * </ul>
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.m.Carousel} <code>this</code> to allow method chaining
 * @protected
 * @name sap.m.Carousel#firePageChanged
 * @function
 */


/**
 * Call this method to display the next page (corresponds to a swipe right). Returns 'this' for method chaining.
 *
 * @name sap.m.Carousel.prototype.next
 * @function

 * @type sap.m.Carousel
 * @public
 */


/**
 * Call this method to display the previous page (corresponds to a swipe left). Returns 'this' for method chaining.
 *
 * @name sap.m.Carousel.prototype.previous
 * @function

 * @type sap.m.Carousel
 * @public
 */


// Start of sap\m\Carousel.js
jQuery.sap.require('sap.ui.thirdparty.mobify-carousel'); // unlisted dependency retained



//Constants convenient class selections
sap.m.Carousel._INNER_SELECTOR = ".sapMCrslInner";
sap.m.Carousel._PAGE_INDICATOR_SELECTOR = ".sapMCrslBulleted";
sap.m.Carousel._HUD_SELECTOR = ".sapMCrslHud";
sap.m.Carousel._ITEM_SELECTOR = ".sapMCrslItem";
sap.m.Carousel._LEFTMOST_CLASS = "sapMCrslLeftmost";
sap.m.Carousel._RIGHTMOST_CLASS = "sapMCrslRightmost";
sap.m.Carousel._LATERAL_CLASSES = "sapMCrslLeftmost sapMCrslRightmost";
sap.m.Carousel._bIE9 = (sap.ui.Device.browser.internet_explorer && sap.ui.Device.browser.version < 10);

/**
 * Initialize member variables which are needed later on.
 * 
 * @private
 */
sap.m.Carousel.prototype.init = function() {
	//Scroll container list for clean- up
	this._aScrollContainers = [];
	
	//Initialize '_fnAdjustAfterResize' to be used by window
	//'resize' event
	this._fnAdjustAfterResize = jQuery.proxy(function() {
		var $carouselInner = this.$().find(sap.m.Carousel._INNER_SELECTOR);
		this._oMobifyCarousel.resize($carouselInner);
	}, this);
};



/**
 * Called when the control is destroyed.
 *
 * @private
 */
sap.m.Carousel.prototype.exit = function() {
	if(this._oMobifyCarousel) {
		this._oMobifyCarousel.destroy();
		delete this._oMobifyCarousel;
	}
	
	if(this._oArrowLeft) {
		this._oArrowLeft.destroy();
		delete this._oArrowLeft;
	}
	if(this._oArrowRight) {
		this._oArrowRight.destroy();
		delete this._oArrowRight;
	}
	
	if (this._sResizeListenerId) {
		sap.ui.core.ResizeHandler.deregister(this._sResizeListenerId);
		this._sResizeListenerId = null;
	}
	this.$().off('afterSlide');
	
	this._cleanUpScrollContainer();
	this._fnAdjustAfterResize = null;
	this._aScrollContainers = null;
	if(!sap.m.Carousel._bIE9 && this._$InnerDiv) {
		jQuery(window).off("resize", this._fnAdjustAfterResize);
	}
	this._$InnerDiv = null;
};

/**
 * Housekeeping for scroll containers: Removes content for each container,
 * destroys the contianer and clears the local container list.
 * 
 * @private
 */
sap.m.Carousel.prototype._cleanUpScrollContainer = function() {
	var oScrollCont;
	while (this.length > 0) {
		oScrollCont = this._aScrollContainers.pop();
		oScrollCont.removeAllContent();
		if(oScrollCont && typeof oScrollCont.destroy === 'function') {
			oScrollCont.destroy();
		}
	}
};


/**
 * Cleans up bindings
 * 
 * @private
 */
sap.m.Carousel.prototype.onBeforeRendering = function() {
	//make sure, active page has an initial value
	var sActivePage = this.getActivePage();
	if(!sActivePage && this.getPages().length > 0) {
		//if no active page is specified, set first page.
		this.setAssociation("activePage", this.getPages()[0].getId(), true);
	}
	if (this._sResizeListenerId) {
		sap.ui.core.ResizeHandler.deregister(this._sResizeListenerId);
		this._sResizeListenerId = null;
	}
	if(!sap.m.Carousel._bIE9 && this._$InnerDiv) {
		jQuery(window).off("resize", this._fnAdjustAfterResize);
	}
	return this;
};

/**
 * When this method is called for the first time, a swipe-view instance is created which is renders
 * itself into its dedicated spot within the DOM tree. This instance is used throughout the
 * Carousel instance's lifecycle.
 * 
 * @private
 */
sap.m.Carousel.prototype.onAfterRendering = function() {
	
	//Check if carousel has been initialized
	if(this._oMobifyCarousel) {
		//Clean up existing mobify carousel
		this._oMobifyCarousel.destroy();
	}
	//Create and initialize new carousel
	this.$().carousel();
	this._oMobifyCarousel = this.getDomRef()._carousel;
	this._oMobifyCarousel.setLoop(this.getLoop());
	this._oMobifyCarousel.setRTL(sap.ui.getCore().getConfiguration().getRTL());
	
	
	
	//Go to active page: this may be necessary after adding or
	//removing pages
	var sActivePage = this.getActivePage();
	
	if(sActivePage) {
		var iIndex = this._getPageNumber(sActivePage);
		if(isNaN(iIndex)) {
			if(this.getPages().length > 0) {
				//First page is always shown as default
				this.setAssociation("activePage", this.getPages()[0].getId(), true);
			}
		} else {
			this._oMobifyCarousel.changeAnimation('sapMCrslNoTransition');
			//mobify carousel is 1-based
			this._oMobifyCarousel.move(iIndex + 1);
		}
	}
	
	this._fnAdjustHUDVisibility(sActivePage ? (this._getPageNumber(sActivePage) + 1) : 1);
	
	//attach delegate for firing 'PageChanged' events to mobify carousel's
	//'afterSlide'
	this.$().on('afterSlide', jQuery.proxy(function(e, iPreviousSlide, iNextSlide) {
		if(iNextSlide > 0){
			this._fnAdjustHUDVisibility(iNextSlide);
			var sOldActivePageId = this.getActivePage();
			var sNewActivePageId = this.getPages()[iNextSlide -1].getId();
			this.setAssociation("activePage", sNewActivePageId, true);
			
			jQuery.sap.log.debug("sap.m.Carousel: firing pageChanged event: old page: " + sOldActivePageId 
					+ ", new page: " + sNewActivePageId);
			
			this.firePageChanged( { oldActivePageId: sOldActivePageId,
				newActivePageId: sNewActivePageId});
		}
	}, this));
	this._$InnerDiv = this.$().find(sap.m.Carousel._INNER_SELECTOR)[0];
	if(sap.m.Carousel._bIE9) {
		this._sResizeListenerId = sap.ui.core.ResizeHandler.register(this._$InnerDiv, this._fnAdjustAfterResize);
	} else {
		jQuery(window).on("resize", this._fnAdjustAfterResize);
	}
};



/**
 * Sets HUD control's visibility after page has changed
 * 
 * @param iNextSlide index of the next acrtive page
 * @private
 *
 */
sap.m.Carousel.prototype._fnAdjustHUDVisibility = function(iNextSlide) {
	if (sap.ui.Device.system.desktop && !this.getLoop() && this.getPages().length > 1) {
		//update HUD arrow visibility for left- and
		//rightmost pages
		var $HUDContainer = this.$().find(sap.m.Carousel._HUD_SELECTOR);
		//clear marker classes first
		$HUDContainer.removeClass(sap.m.Carousel._LATERAL_CLASSES);
		
		if(iNextSlide === 1) {
			$HUDContainer.addClass(sap.m.Carousel._LEFTMOST_CLASS);
		} else if (iNextSlide === this.getPages().length) {
			$HUDContainer.addClass(sap.m.Carousel._RIGHTMOST_CLASS);
		}
	}
};


/**
 * Handler for 'tab previous' key event. Delegates handling to 
 * '_tabKeyPressed' function.
 * 
 * @param oEvent key event
 * @private
 *
 */
sap.m.Carousel.prototype.onsaptabprevious = function(oEvent) {
	this._bTabPrevious = true;
};

/**
 * Handler for 'tab next' key event. Delegates handling to 
 * '_tabKeyPressed' function.
 * 
 * @param oEvent key event
 * @private
 *
 */
sap.m.Carousel.prototype.onsaptabnext = function(oEvent) {
	this._bTabNext = true;
};


/**
 * Event handler for the focusin event.
 * If the focused element is the dedicated element (class sapMCrslFirstFE) at the beginning of a page, 
 * the focus is set to the end of the previous page. If the dedicated element the end of a page 
 * (class sapMCrslLastFE) is focussed, the first element of the next page is focused
 * @param {jQuery.EventObject} oEvent The event object
 * @private
 */
sap.m.Carousel.prototype.onfocusin = function(oEvent){
	if (sap.ui.Device.system.desktop) {
		var oSourceDomRef = oEvent.target,
			iPageIndex = oSourceDomRef.getAttribute('pageIndex'),
			oNextFocusDomRef,
			oNextPage;
		//Invisible Element focused by tab previous
		if(oSourceDomRef.className === 'sapMCrslFirstFE' && this._bTabPrevious) {
			if(iPageIndex > 0) {
				iPageIndex--;
			} else if(this.getLoop()) {
				iPageIndex = this.getPages().length - 1;
			}
			
			oNextPage = this.getPages()[iPageIndex];
			oNextFocusDomRef = oNextPage.$().parent().lastFocusableDomRef();
			
		} else if(oSourceDomRef.className === 'sapMCrslLastFE' && this._bTabNext) {
			//Invisible Element focused by tab next
			if(iPageIndex < this.getPages().length - 1) {
				iPageIndex++;
			} else if(this.getLoop()) {
				iPageIndex = 0;
			}
			
			oNextPage = this.getPages()[iPageIndex];
			oNextFocusDomRef = oNextPage.$().parent().firstFocusableDomRef();
		}
		
		if(oNextFocusDomRef && oNextPage) {
			var fnRequestFocus = function() {
				oNextFocusDomRef.focus();
			};
			this._oMobifyCarousel.changeAnimation('', fnRequestFocus, this);
			this.setActivePage(oNextPage.getId());
		}
		this._bTabPrevious = false;
		this._bTabNext = false;
	}
};





/**
 * API method to set carousel's active page during runtime.
 * 
 * @param vPage Id of the page or page which shall become active
 * @override
 *
 */
sap.m.Carousel.prototype.setActivePage = function (vPage) {
	var sPagedId = null,
		bHasMoved = false;
	if(typeof(vPage) == 'string') {
		sPagedId = vPage;
	} else if (vPage instanceof sap.ui.core.Control) {
		sPagedId = vPage.getId();
	}
	
	if(sPagedId) {
		if(this._oMobifyCarousel) {
			var iPageNr = this._getPageNumber(sPagedId);
			
			if(!isNaN(iPageNr)) {
				//mobify carousel's move function is '1' based
				this._oMobifyCarousel.move(iPageNr + 1);
				bHasMoved = true;
			} 
		}
	} 
	
	if(bHasMoved || !this._oMobifyCarousel) {
		//active page shall only be set, if vPage has been 
		//found amongst the carousel's pages or if carousel has not been 
		//rendered yet
		this.setAssociation("activePage", sPagedId, true);
	} else {
		jQuery.sap.log.warning("sap.m.Carousel.prototype.setActivePage: Cannot set active page " + 
	 	"because it is neither of type 'string' nor a 'sap.ui.core.Control'");
	}
	
	return this;
};



/**
 * API method to set the carousel's height
 *
 * @param oHeight the new height as CSSSize
 * @public
 * @override
 */
sap.m.Carousel.prototype.setHeight = function(oHeight) {
	//do suppress rerendering
	this.setProperty("height", oHeight, true);
	this.$().css("height", oHeight);
	return this;
};

/**
 * API method to set the carousel's width
 *
 * @param oWidth the new width as CSSSize
 * @public
 * @override
 */
sap.m.Carousel.prototype.setWidth = function(oWidth) {
	//do suppress rerendering
	this.setProperty("width", oWidth, true);
	this.$().css("width", oWidth);
	return this;
};

/**
 * API method to place the page inidicator. 
 *
 * @param sPlacement either sap.m.PlacementType.Top or sap.m.PlacementType.Bottom
 * @public
 * @override
 */
sap.m.Carousel.prototype.setPageIndicatorPlacement = function(sPlacement) {
	if(sap.m.PlacementType.Top != sPlacement &&
			sap.m.PlacementType.Bottom != sPlacement) {
		jQuery.sap.assert(false, "sap.m.Carousel.prototype.setPageIndicatorPlacement: invalid value '" + 
				sPlacement + "'. Valid values: sap.m.PlacementType.Top, sap.m.PlacementType.Bottom." +
						"\nUsing default value sap.m.PlacementType.Bottom");
		sPlacement = sap.m.PlacementType.Bottom;
	}
	
	//do suppress rerendering
	this.setProperty("pageIndicatorPlacement", sPlacement, true);
	
	var $PageIndicator = this.$().find(sap.m.Carousel._PAGE_INDICATOR_SELECTOR); 
	
	//set placement regardless of whether indicator is visible: it may become
	//visible later on and then it should be at the right place
	if(sap.m.PlacementType.Top === sPlacement) {
		this.$().prepend($PageIndicator);
		$PageIndicator.removeClass('sapMCrslBottomOffset');
		this.$().find(sap.m.Carousel._ITEM_SELECTOR).removeClass('sapMCrslBottomOffset');
	} else {
		this.$().append($PageIndicator);
		$PageIndicator.addClass('sapMCrslBottomOffset');
		this.$().find(sap.m.Carousel._ITEM_SELECTOR).addClass('sapMCrslBottomOffset');
	}
	return this;
};


/**
 * API method to set whether the carousel should display the page indicator
 *
 * @param bShowPageIndicator the new show property
 * @public
 * @override
 */
sap.m.Carousel.prototype.setShowPageIndicator = function(bShowPageIndicator) {
	
	var $PageInd = this.$().find(sap.m.Carousel._PAGE_INDICATOR_SELECTOR);
	
	bShowPageIndicator ? $PageInd.show() : $PageInd.hide();
	
	//do suppress rerendering
	this.setProperty("showPageIndicator", bShowPageIndicator, true);
	return this;
};



/**
 * API method to set whether the carousel should loop, i.e
 * show the first page after the last page is reached and vice 
 * versa.
 *
 * @param bLoop the new loop property
 * @public
 * @override
 */
sap.m.Carousel.prototype.setLoop = function(bLoop) {
	//do suppress rerendering
	this.setProperty("loop", bLoop, true);
	if(this._oMobifyCarousel) {
		this._oMobifyCarousel.setLoop(bLoop);
	}
	return this;
};

/**
 * Gets the icon of the requested arrow (left/right).
 * @private
 * @param sName left or right
 * @returns icon of the requested arrow
 */
sap.m.Carousel.prototype._getNavigationArrow = function(sName) {
	jQuery.sap.require("sap.ui.core.IconPool");
	var mProperties = {
		src : "sap-icon://navigation-" + sName + "-arrow"
	};
	
	if (sName === "left") {
		if (!this._oArrowLeft) {
			this._oArrowLeft = sap.m.ImageHelper.getImageControl(this.getId() + "-arrowScrollLeft", this._oArrowLeft, this, mProperties);
		}
		return this._oArrowLeft;
	} else if (sName === "right") {
		if (!this._oArrowRight) {
			this._oArrowRight = sap.m.ImageHelper.getImageControl(this.getId() + "-arrowScrollRight", this._oArrowRight, this, mProperties);
		}
		return this._oArrowRight;
	}
};


/**
 * Private method that places a given page control into 
 * a scroll container which does not scroll. That container does
 * not scroll itself. This is necessary to achieve the 100% height 
 * effect with an offset for the page indicator. 
 *
 * @param oPage the page to check
 * @private
 */
sap.m.Carousel.prototype._createScrollContainer = function(oPage) {
	
	var cellClasses = oPage instanceof sap.m.Image ? "sapMCrslItemTableCell sapMCrslImg" : "sapMCrslItemTableCell",
		oContent = new sap.ui.core.HTML({
		content :	"<div class='sapMCrslItemTable'>" +
						"<div class='" + cellClasses + "'></div>" +
					"</div>",
		afterRendering : function(e) {
			var rm = sap.ui.getCore().createRenderManager();
			rm.render(oPage, this.getDomRef().firstChild);
			rm.destroy();
		}
	});
	
	var oScrollContainer = new sap.m.ScrollContainer({
		horizontal: false,
		vertical: false,
		content:[oContent],
		width:'100%',
		height:'100%',
	}); 
	oScrollContainer.setParent(this, null, true);
	this._aScrollContainers.push(oScrollContainer); 
	return oScrollContainer; 
};




/**
 * API method to show the next page in the page list.
 * @public
 */
sap.m.Carousel.prototype.previous = function () {
	if(this._oMobifyCarousel) {
		this._oMobifyCarousel.prev();
	} else {
		jQuery.sap.log.warning("Unable to execute sap.m.Carousel.previous: carousel must be rendered first.");
	}
	return this;
}; 

/**
 * API method to show the previous page in the page list.
 * @public
 */
sap.m.Carousel.prototype.next = function () {
	if(this._oMobifyCarousel) {
		this._oMobifyCarousel.next();
	} else {
		jQuery.sap.log.warning("Unable to execute sap.m.Carousel.next: carousel must be rendered first.");
	}
	return this;
};



/**
 * Determines the position of a given page in the carousel's page list
 * 
 * @return the position of a given page in the carousel's page list or 'undefined' if it does not exist in the list.
 * @private
 */
sap.m.Carousel.prototype._getPageNumber = function(sPagedId) {
	var i, result;
	
	for(i=0; i<this.getPages().length; i++) {
		if(this.getPages()[i].getId() == sPagedId) {
			result = i;
			break;
		}
	}
	return result;
};

//DEPRECATED METHODS


/**
 * API method to set whether the carousel should display the busy indicators.
 * This property has been deprecated since 1.18.7. Does nothing and returns the carousel reference.
 *
 * @deprecated
 * @public
 */
sap.m.Carousel.prototype.setShowBusyIndicator = function() {
	jQuery.sap.log.warning("sap.m.Carousel: Deprecated function 'setShowBusyIndicator' called. " + 
 	"Does nothing.");
	return this;
};

/**
 * API method to check whether the carousel should display the busy indicators.
 * This property has been deprecated since 1.18.7. Always returns false,
 *
 * @deprecated
 * @public
 */
sap.m.Carousel.prototype.getShowBusyIndicator = function() {
	jQuery.sap.log.warning("sap.m.Carousel: Deprecated function 'getShowBusyIndicator' called. " + 
 	"Does nothing.");
	return false;
};

/**
 * API method to set the carousel's busy indicator size.
 * This property has been deprecated since 1.18.7. Does nothing and returns the carousel reference.
 *
 * @deprecated
 * @public
 */
sap.m.Carousel.prototype.setBusyIndicatorSize = function() {
	jQuery.sap.log.warning("sap.m.Carousel: Deprecated function 'setBusyIndicatorSize' called. " + 
 	"Does nothing.");
	return this;
};


/**
 * API method to retrieve the carousel's busy indicator size.
 * This property has been deprecated since 1.18.6. Always returns an empty string.
 *
 * @deprecated
 * @public
 */
sap.m.Carousel.prototype.getBusyIndicatorSize = function() {
	jQuery.sap.log.warning("sap.m.Carousel: Deprecated function 'getBusyIndicatorSize' called. " + 
 	"Does nothing.");
	return "";
};



}; // end of sap/m/Carousel.js
if ( !jQuery.sap.isDeclared('sap.m.CheckBox') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.m.CheckBox.
jQuery.sap.declare("sap.m.CheckBox");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new CheckBox.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getSelected selected} : boolean (default: false)</li>
 * <li>{@link #getVisible visible} : boolean (default: true)</li>
 * <li>{@link #getEnabled enabled} : boolean (default: true)</li>
 * <li>{@link #getName name} : string</li>
 * <li>{@link #getText text} : string</li>
 * <li>{@link #getTextDirection textDirection} : sap.ui.core.TextDirection (default: sap.ui.core.TextDirection.Inherit)</li>
 * <li>{@link #getWidth width} : sap.ui.core.CSSSize (default: '')</li>
 * <li>{@link #getActiveHandling activeHandling} : boolean (default: true)</li></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul>
 * <li>{@link sap.m.CheckBox#event:select select} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * CheckBox control
 * @extends sap.ui.core.Control
 *
 * @author SAP AG 
 * @version 1.20.6
 *
 * @constructor   
 * @public
 * @name sap.m.CheckBox
 */
sap.ui.core.Control.extend("sap.m.CheckBox", { metadata : {

	// ---- object ----

	// ---- control specific ----
	library : "sap.m",
	properties : {
		"selected" : {type : "boolean", group : "Data", defaultValue : false},
		"visible" : {type : "boolean", group : "Appearance", defaultValue : true},
		"enabled" : {type : "boolean", group : "Behavior", defaultValue : true},
		"name" : {type : "string", group : "Misc", defaultValue : null},
		"text" : {type : "string", group : "Appearance", defaultValue : null},
		"textDirection" : {type : "sap.ui.core.TextDirection", group : "Appearance", defaultValue : sap.ui.core.TextDirection.Inherit},
		"width" : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : ''},
		"activeHandling" : {type : "boolean", group : "Misc", defaultValue : true}
	},
	events : {
		"select" : {}
	}
}});


/**
 * Creates a new subclass of class sap.m.CheckBox with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.m.CheckBox.extend
 * @function
 */

sap.m.CheckBox.M_EVENTS = {'select':'select'};


/**
 * Getter for property <code>selected</code>.
 * Contains the state of the control whether it is flagged with a check mark, or not
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>selected</code>
 * @public
 * @name sap.m.CheckBox#getSelected
 * @function
 */

/**
 * Setter for property <code>selected</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bSelected  new value for property <code>selected</code>
 * @return {sap.m.CheckBox} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.CheckBox#setSelected
 * @function
 */


/**
 * Getter for property <code>visible</code>.
 * Invisible control is not rendered
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>visible</code>
 * @public
 * @name sap.m.CheckBox#getVisible
 * @function
 */

/**
 * Setter for property <code>visible</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bVisible  new value for property <code>visible</code>
 * @return {sap.m.CheckBox} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.CheckBox#setVisible
 * @function
 */


/**
 * Getter for property <code>enabled</code>.
 * Using this property, the control could be disabled, if required.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>enabled</code>
 * @public
 * @name sap.m.CheckBox#getEnabled
 * @function
 */

/**
 * Setter for property <code>enabled</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bEnabled  new value for property <code>enabled</code>
 * @return {sap.m.CheckBox} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.CheckBox#setEnabled
 * @function
 */


/**
 * Getter for property <code>name</code>.
 * The 'name' property to be used in the HTML code, for example for HTML forms that send data to the server via submit.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>name</code>
 * @public
 * @name sap.m.CheckBox#getName
 * @function
 */

/**
 * Setter for property <code>name</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sName  new value for property <code>name</code>
 * @return {sap.m.CheckBox} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.CheckBox#setName
 * @function
 */


/**
 * Getter for property <code>text</code>.
 * Defines the text displayed next to the check box
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>text</code>
 * @public
 * @name sap.m.CheckBox#getText
 * @function
 */

/**
 * Setter for property <code>text</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sText  new value for property <code>text</code>
 * @return {sap.m.CheckBox} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.CheckBox#setText
 * @function
 */


/**
 * Getter for property <code>textDirection</code>.
 * Options for the text direction are RTL and LTR. Alternatively, the control can inherit the text direction from its parent container.
 *
 * Default value is <code>sap.ui.core.TextDirection.Inherit</code>
 *
 * @return {sap.ui.core.TextDirection} the value of property <code>textDirection</code>
 * @public
 * @name sap.m.CheckBox#getTextDirection
 * @function
 */

/**
 * Setter for property <code>textDirection</code>.
 *
 * Default value is <code>sap.ui.core.TextDirection.Inherit</code> 
 *
 * @param {sap.ui.core.TextDirection} oTextDirection  new value for property <code>textDirection</code>
 * @return {sap.m.CheckBox} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.CheckBox#setTextDirection
 * @function
 */


/**
 * Getter for property <code>width</code>.
 * Width of Label
 *
 * Default value is <code>''</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>width</code>
 * @public
 * @name sap.m.CheckBox#getWidth
 * @function
 */

/**
 * Setter for property <code>width</code>.
 *
 * Default value is <code>''</code> 
 *
 * @param {sap.ui.core.CSSSize} sWidth  new value for property <code>width</code>
 * @return {sap.m.CheckBox} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.CheckBox#setWidth
 * @function
 */


/**
 * Getter for property <code>activeHandling</code>.
 * this is a flag to switch on activeHandling, when it is switched off, there will not be visual changes on active state. Default value is 'true'
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>activeHandling</code>
 * @public
 * @name sap.m.CheckBox#getActiveHandling
 * @function
 */

/**
 * Setter for property <code>activeHandling</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bActiveHandling  new value for property <code>activeHandling</code>
 * @return {sap.m.CheckBox} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.CheckBox#setActiveHandling
 * @function
 */


/**
 * Event is triggered when the control status is changed by the user by selecting or deselecting the checkbox. 
 *
 * @name sap.m.CheckBox#select
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters

 * @param {boolean} oControlEvent.getParameters.selected Checks whether the CheckBox is flagged or not flagged.
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'select' event of this <code>sap.m.CheckBox</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.m.CheckBox</code>.<br/> itself. 
 *  
 * Event is triggered when the control status is changed by the user by selecting or deselecting the checkbox. 
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.m.CheckBox</code>.<br/> itself.
 *
 * @return {sap.m.CheckBox} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.CheckBox#attachSelect
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'select' event of this <code>sap.m.CheckBox</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.m.CheckBox} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.CheckBox#detachSelect
 * @function
 */

/**
 * Fire event select to attached listeners.
 * 
 * Expects following event parameters:
 * <ul>
 * <li>'selected' of type <code>boolean</code> Checks whether the CheckBox is flagged or not flagged.</li>
 * </ul>
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.m.CheckBox} <code>this</code> to allow method chaining
 * @protected
 * @name sap.m.CheckBox#fireSelect
 * @function
 */


// Start of sap\m\CheckBox.js
jQuery.sap.require('sap.ui.core.EnabledPropagator'); // unlisted dependency retained

sap.ui.core.EnabledPropagator.call(sap.m.CheckBox.prototype);

sap.m.CheckBox.prototype.init = function() {
	this.addActiveState(this);
	jQuery.sap.require("sap.ui.core.IconPool");
	sap.ui.core.IconPool.insertFontFaceStyle();
};


/**
 * Called when the control is touched.
 *
 * @private
 */
sap.m.CheckBox.prototype.ontouchstart = function(oEvent) {
	//for control who need to know if they should handle events from the CheckBox control
	oEvent.originalEvent._sapui_handledByControl = true;
};

sap.m.CheckBox.prototype.setSelected = function(bSelected) {
	bSelected = !!bSelected;
	if (bSelected == this.getSelected()) {
		return this;
	}
	
	this.$("CbBg").toggleClass("sapMCbMarkChecked", bSelected);
	var oCheckBox = this.getDomRef("CB");
	if (oCheckBox){
		bSelected ? oCheckBox.setAttribute('checked', 'checked') : oCheckBox.removeAttribute('checked');
	}
	this.setProperty("selected", bSelected, true);
	return this;
};

/**
 * Function is called when CheckBox is tapped.
 *
 * @private
 */
sap.m.CheckBox.prototype.ontap = function(oEvent) {
	if (this.getEnabled()) {
		var bSelected = !this.getSelected();
		this.setSelected(bSelected);
		this.fireSelect({selected:bSelected});
	}
};

/**
 * add ActiveState to non-supported mobile platform
 * @private
 */

sap.m.CheckBox.prototype.addActiveState = function(oControl) {
	if (sap.ui.Device.os.blackberry || (sap.ui.Device.os.android && (sap.ui.Device.os.versionStr.match(/[23]\./)))){
		oControl.addDelegate({
			ontouchstart: function(oEvent){
				jQuery(oControl.getDomRef()).addClass("sapMActive");
			},
			ontouchend: function(oEvent){
				jQuery(oControl.getDomRef()).removeClass("sapMActive");
			}
		});
	}
};

sap.m.CheckBox.prototype.setText = function(sText){
	this.setProperty("text", sText, true);
	if(this._oLabel){
		this._oLabel.setText(this.getText());
	}else{
		this._createLabel("text", this.getText());
	}
	return this;
};

sap.m.CheckBox.prototype.setWidth = function(sWidth){
	this.setProperty("width", sWidth, true);
	if(this._oLabel){
		this._oLabel.setWidth(this.getWidth());
	}else{
		this._createLabel("width", this.getWidth());
	}
	return this;
};

sap.m.CheckBox.prototype.setTextDirection = function(sDirection){
	this.setProperty("textDirection", sDirection, true);
	if(this._oLabel){
		this._oLabel.setTextDirection(this.getTextDirection());
	}else{
		this._createLabel("textDirection", this.getTextDirection());
	}
	return this;
};

sap.m.CheckBox.prototype.exit = function() {
	delete this._iTabIndex;
	if(this._oLabel){
		this._oLabel.destroy();
	}
};

sap.m.CheckBox.prototype._createLabel = function(prop, value){
	this._oLabel = new sap.m.Label(this.getId() + "-label", {
					}).addStyleClass("sapMCbLabel").setParent(this, null, true);
	this._oLabel.setProperty(prop, value, false);
};

/**
 * Event handler called when the space key is pressed.
 *
 * @param {jQuery.Event} oEvent
 * @private
 */
sap.m.CheckBox.prototype.onsapspace = function(oEvent) {
	this.ontap(oEvent);
	// stop browsers default behavior
	if(oEvent) {
		oEvent.preventDefault();
		oEvent.stopPropagation();
	}
};

/*
 * Sets the tab index of the control
 *
 * @param {int} iTabIndex  greater than or equal -1
 * @return {sap.m.CheckBox}
 * @since 1.16
 * @protected
 */
sap.m.CheckBox.prototype.setTabIndex = function(iTabIndex) {
	this._iTabIndex = iTabIndex;
	this.$("CbBg").attr("tabindex", iTabIndex);
	return this;
};

}; // end of sap/m/CheckBox.js
if ( !jQuery.sap.isDeclared('sap.m.Column') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.m.Column.
jQuery.sap.declare("sap.m.Column");

jQuery.sap.require('sap.ui.core.Element'); // unlisted dependency retained



/**
 * Constructor for a new Column.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getWidth width} : sap.ui.core.CSSSize</li>
 * <li>{@link #getHAlign hAlign} : sap.ui.core.TextAlign (default: sap.ui.core.TextAlign.Begin)</li>
 * <li>{@link #getVAlign vAlign} : sap.ui.core.VerticalAlign (default: sap.ui.core.VerticalAlign.Inherit)</li>
 * <li>{@link #getStyleClass styleClass} : string</li>
 * <li>{@link #getVisible visible} : boolean (default: true)</li>
 * <li>{@link #getMinScreenWidth minScreenWidth} : string</li>
 * <li>{@link #getDemandPopin demandPopin} : boolean (default: false)</li>
 * <li>{@link #getPopinHAlign popinHAlign} : sap.ui.core.TextAlign (default: sap.ui.core.TextAlign.Begin)</li>
 * <li>{@link #getPopinDisplay popinDisplay} : sap.m.PopinDisplay (default: sap.m.PopinDisplay.Block)</li>
 * <li>{@link #getMergeDuplicates mergeDuplicates} : boolean (default: false)</li>
 * <li>{@link #getMergeFunctionName mergeFunctionName} : string (default: 'getText')</li></ul>
 * </li>
 * <li>Aggregations
 * <ul>
 * <li>{@link #getHeader header} <strong>(default aggregation)</strong> : sap.ui.core.Control</li>
 * <li>{@link #getFooter footer} : sap.ui.core.Control</li></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 
 *
 * 
 * In addition, all settings applicable to the base type {@link sap.ui.core.Element#constructor sap.ui.core.Element}
 * can be used as well.
 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * The column allows to define column specific properties that will be applied when rendering the List.
 * @extends sap.ui.core.Element
 *
 * @author SAP AG 
 * @version 1.20.6
 *
 * @constructor   
 * @public
 * @since 1.12
 * @name sap.m.Column
 */
sap.ui.core.Element.extend("sap.m.Column", { metadata : {

	// ---- object ----

	// ---- control specific ----
	library : "sap.m",
	properties : {
		"width" : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : null},
		"hAlign" : {type : "sap.ui.core.TextAlign", group : "Appearance", defaultValue : sap.ui.core.TextAlign.Begin},
		"vAlign" : {type : "sap.ui.core.VerticalAlign", group : "Appearance", defaultValue : sap.ui.core.VerticalAlign.Inherit},
		"styleClass" : {type : "string", group : "Appearance", defaultValue : null},
		"visible" : {type : "boolean", group : "Appearance", defaultValue : true},
		"minScreenWidth" : {type : "string", group : "Behavior", defaultValue : null},
		"demandPopin" : {type : "boolean", group : "Behavior", defaultValue : false},
		"popinHAlign" : {type : "sap.ui.core.TextAlign", group : "Appearance", defaultValue : sap.ui.core.TextAlign.Begin, deprecated: true},
		"popinDisplay" : {type : "sap.m.PopinDisplay", group : "Appearance", defaultValue : sap.m.PopinDisplay.Block},
		"mergeDuplicates" : {type : "boolean", group : "Behavior", defaultValue : false},
		"mergeFunctionName" : {type : "string", group : "Misc", defaultValue : 'getText'}
	},
	defaultAggregation : "header",
	aggregations : {
    	"header" : {type : "sap.ui.core.Control", multiple : false}, 
    	"footer" : {type : "sap.ui.core.Control", multiple : false}
	}
}});


/**
 * Creates a new subclass of class sap.m.Column with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.m.Column.extend
 * @function
 */


/**
 * Getter for property <code>width</code>.
 * Defines the width of the column. If you leave it empty then this column covers the remaining space.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>width</code>
 * @public
 * @name sap.m.Column#getWidth
 * @function
 */

/**
 * Setter for property <code>width</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.core.CSSSize} sWidth  new value for property <code>width</code>
 * @return {sap.m.Column} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Column#setWidth
 * @function
 */


/**
 * Getter for property <code>hAlign</code>.
 * Horizontal alignment of the column content. Available alignment settings are "Begin", "Center", "End", "Left", and "Right".
 * 
 * NOTE: Control with a "textAlign" property inherits the horizontal alignment.
 *
 * Default value is <code>Begin</code>
 *
 * @return {sap.ui.core.TextAlign} the value of property <code>hAlign</code>
 * @public
 * @name sap.m.Column#getHAlign
 * @function
 */

/**
 * Setter for property <code>hAlign</code>.
 *
 * Default value is <code>Begin</code> 
 *
 * @param {sap.ui.core.TextAlign} oHAlign  new value for property <code>hAlign</code>
 * @return {sap.m.Column} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Column#setHAlign
 * @function
 */


/**
 * Getter for property <code>vAlign</code>.
 * Vertical alignment of the cells in a column. Possible values are "Inherit", "Top", "Middle", "Bottom"
 * This property does not affect the vertical alignment of header and footer.
 *
 * Default value is <code>Inherit</code>
 *
 * @return {sap.ui.core.VerticalAlign} the value of property <code>vAlign</code>
 * @public
 * @name sap.m.Column#getVAlign
 * @function
 */

/**
 * Setter for property <code>vAlign</code>.
 *
 * Default value is <code>Inherit</code> 
 *
 * @param {sap.ui.core.VerticalAlign} oVAlign  new value for property <code>vAlign</code>
 * @return {sap.m.Column} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Column#setVAlign
 * @function
 */


/**
 * Getter for property <code>styleClass</code>.
 * CSS class name for column contents(header, cells and footer of column). This property can be used for different column styling. If column is shown as pop-in then this class name is applied to related pop-in row.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>styleClass</code>
 * @public
 * @name sap.m.Column#getStyleClass
 * @function
 */

/**
 * Setter for property <code>styleClass</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sStyleClass  new value for property <code>styleClass</code>
 * @return {sap.m.Column} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Column#setStyleClass
 * @function
 */


/**
 * Getter for property <code>visible</code>.
 * Specifies whether or not the column is visible. Invisible columns are not rendered.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>visible</code>
 * @public
 * @name sap.m.Column#getVisible
 * @function
 */

/**
 * Setter for property <code>visible</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bVisible  new value for property <code>visible</code>
 * @return {sap.m.Column} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Column#setVisible
 * @function
 */


/**
 * Getter for property <code>minScreenWidth</code>.
 * By default column is always shown. If you set this property, control checks the minimum width of the screen to show or hide this column.
 * As you can give specific CSS sizes(e.g: "480px" or "40em"), you can also use sap.m.ScreenSize enumeration(e.g: "Phone", "Tablet", "Desktop", "Small", "Medium", "Large", ....).
 * 
 * sap.m.Column.MediaQuery1->Range1 = 199
 * 
 * This property can be used for responsive design. e.g: "40em"(or "640px" or "Tablet") setting shows this column in iPad(and Desktop) but hides in iPhone.
 * Please also see "demandPopin" property
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>minScreenWidth</code>
 * @public
 * @name sap.m.Column#getMinScreenWidth
 * @function
 */

/**
 * Setter for property <code>minScreenWidth</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sMinScreenWidth  new value for property <code>minScreenWidth</code>
 * @return {sap.m.Column} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Column#setMinScreenWidth
 * @function
 */


/**
 * Getter for property <code>demandPopin</code>.
 * According to your minScreenWidth settings, the column can be hidden in different screen sizes.
 * Setting this property to true, shows this column as pop-in instead of hiding it.
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>demandPopin</code>
 * @public
 * @name sap.m.Column#getDemandPopin
 * @function
 */

/**
 * Setter for property <code>demandPopin</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bDemandPopin  new value for property <code>demandPopin</code>
 * @return {sap.m.Column} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Column#setDemandPopin
 * @function
 */


/**
 * Getter for property <code>popinHAlign</code>.
 * Horizontal alignment of the pop-in content. Available alignment settings are "Begin", "Center", "End", "Left", and "Right".
 * 
 * NOTE: Controls with a text align do not inherit the horizontal alignment.
 *
 * Default value is <code>Begin</code>
 *
 * @return {sap.ui.core.TextAlign} the value of property <code>popinHAlign</code>
 * @public
 * @deprecated Since version 1.14. 
 * Use popinDisplay property instead.
 * @name sap.m.Column#getPopinHAlign
 * @function
 */

/**
 * Setter for property <code>popinHAlign</code>.
 *
 * Default value is <code>Begin</code> 
 *
 * @param {sap.ui.core.TextAlign} oPopinHAlign  new value for property <code>popinHAlign</code>
 * @return {sap.m.Column} <code>this</code> to allow method chaining
 * @public
 * @deprecated Since version 1.14. 
 * Use popinDisplay property instead.
 * @name sap.m.Column#setPopinHAlign
 * @function
 */


/**
 * Getter for property <code>popinDisplay</code>.
 * Defines the display options of pop-in.
 * Possible values are
 * 1 - "Block"(Header is displayed in first line and value field in next line.)
 * 2 - "Inline" (Value field is displayed next to the header in same line.)
 *
 * Default value is <code>sap.m.PopinDisplay.Block</code>
 *
 * @return {sap.m.PopinDisplay} the value of property <code>popinDisplay</code>
 * @public
 * @since 1.13.2
 * @name sap.m.Column#getPopinDisplay
 * @function
 */

/**
 * Setter for property <code>popinDisplay</code>.
 *
 * Default value is <code>sap.m.PopinDisplay.Block</code> 
 *
 * @param {sap.m.PopinDisplay} oPopinDisplay  new value for property <code>popinDisplay</code>
 * @return {sap.m.Column} <code>this</code> to allow method chaining
 * @public
 * @since 1.13.2
 * @name sap.m.Column#setPopinDisplay
 * @function
 */


/**
 * Getter for property <code>mergeDuplicates</code>.
 * Set "true" to merge repeating cells(duplicates) into one.
 * Also see "mergeFunctionName" property to customize.
 * Note: this property gets disabled if any column is in pop-in!
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>mergeDuplicates</code>
 * @public
 * @since 1.16
 * @name sap.m.Column#getMergeDuplicates
 * @function
 */

/**
 * Setter for property <code>mergeDuplicates</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bMergeDuplicates  new value for property <code>mergeDuplicates</code>
 * @return {sap.m.Column} <code>this</code> to allow method chaining
 * @public
 * @since 1.16
 * @name sap.m.Column#setMergeDuplicates
 * @function
 */


/**
 * Getter for property <code>mergeFunctionName</code>.
 * Defines the value getter(serialization) function if "mergeDuplicates" property is set "true"
 * Control itself uses this function to compare values of two repeating cells.
 * Default value "getText" is suitable for Label and Text control.
 * e.g. For "Icon" control "getSrc" can be used.
 * Note: You can pass one string parameter to given function after "#" sign. e.g. "data#myparameter"
 *
 * Default value is <code>getText</code>
 *
 * @return {string} the value of property <code>mergeFunctionName</code>
 * @public
 * @since 1.16
 * @name sap.m.Column#getMergeFunctionName
 * @function
 */

/**
 * Setter for property <code>mergeFunctionName</code>.
 *
 * Default value is <code>getText</code> 
 *
 * @param {string} sMergeFunctionName  new value for property <code>mergeFunctionName</code>
 * @return {sap.m.Column} <code>this</code> to allow method chaining
 * @public
 * @since 1.16
 * @name sap.m.Column#setMergeFunctionName
 * @function
 */


/**
 * Getter for aggregation <code>header</code>.<br/>
 * Control to be displayed in the column header.
 * 
 * <strong>Note</strong>: this is the default aggregation for Column.
 * @return {sap.ui.core.Control}
 * @public
 * @name sap.m.Column#getHeader
 * @function
 */


/**
 * Setter for the aggregated <code>header</code>.
 * @param {sap.ui.core.Control} oHeader
 * @return {sap.m.Column} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Column#setHeader
 * @function
 */
	

/**
 * Destroys the header in the aggregation 
 * named <code>header</code>.
 * @return {sap.m.Column} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Column#destroyHeader
 * @function
 */


/**
 * Getter for aggregation <code>footer</code>.<br/>
 * Control to be displayed in the column footer.
 * 
 * @return {sap.ui.core.Control}
 * @public
 * @name sap.m.Column#getFooter
 * @function
 */


/**
 * Setter for the aggregated <code>footer</code>.
 * @param {sap.ui.core.Control} oFooter
 * @return {sap.m.Column} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Column#setFooter
 * @function
 */
	

/**
 * Destroys the footer in the aggregation 
 * named <code>footer</code>.
 * @return {sap.m.Column} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Column#destroyFooter
 * @function
 */


// Start of sap\m\Column.js
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained


// default index
sap.m.Column.prototype._index = -1;

// predefined screen size
sap.m.Column.prototype._screen = "";

// default media value
sap.m.Column.prototype._media = null;

// prototype lookup
sap.m.Column.prototype._getTextAlign = sap.ui.core.Renderer.getTextAlign;

sap.m.Column.prototype._clearMedia = function() {
	if (this._media && this._minWidth) {
		sap.ui.Device.media.removeRangeSet(this.getId());
		this._media = null;
	}
};

sap.m.Column.prototype._addMedia = function() {
	if (this._minWidth) {
		sap.ui.Device.media.initRangeSet(this.getId(), [parseFloat(this._minWidth)]);
		sap.ui.Device.media.attachHandler(this._notifyResize, this, this.getId());
		this._media = sap.ui.Device.media.getCurrentRange(this.getId());
		if (this._media) {
			this._media.triggered = false;
			this._media.matches = !!this._media.from;
		}
	}
};

/**
 * Notify parent to re-render
 * Also fire media event for listeners
 *
 * @private
 */
sap.m.Column.prototype._notifyResize = function(oMedia) {
	// ignore the first call
	if (!this._media.triggered) {
		this._media.triggered = true;
		return;
	}

	// keep media info
	this._media = oMedia;
	this._media.triggered = true;
	this._media.matches = !!oMedia.from;

	// wait all events to come
	jQuery.sap.delayedCall(0, this, function() {
		var parent = this.getParent();
		this.fireEvent("media", this);
		if (parent && parent.onColumnResize) {
			parent.onColumnResize(this);
		}
	});
};

sap.m.Column.prototype._validateMinWidth = function(sWidth) {
	if (Object.prototype.toString.call(sWidth) != "[object String]") {
		throw new Error('expected string for property "minScreenWidth" of ' + this);
	}
	if (Object.keys(sap.m.ScreenSizes).indexOf(sWidth.toLowerCase()) != -1) {
		return;
	}
	if (!/^\d+(\.\d+)?(px|em|rem)$/i.test(sWidth)) {
		throw new Error('invalid CSS size("px", "em", "rem" required) or sap.m.ScreenSize enumeration for property "minScreenWidth" of ' + this);
	}
};


// Checks the given width(px or em), if it is a predefined screen value
sap.m.Column.prototype._isWidthPredefined = function(sWidth) {
	var that = this,
		unit = sWidth.replace(/[^a-z]/g, ""),
		baseFontSize = parseFloat(sap.m.BaseFontSize) || 16;

	jQuery.each(sap.m.ScreenSizes, function(screen, size) {
		if (unit != "px") {
			size /= baseFontSize;
		}
		if (size + unit == sWidth) {
			that._minWidth = this + "px";
			that._screen = screen;
			return false;
		}
	});
};

/**
 * Apply text alignment of the Column to Text/Label/Link...
 *
 * TODO: This is so ugly to check content functions
 * instead we should document how to use our controls
 * to inherit text-alignment and we should add a new
 * sap.ui.core.TextAlign type called "Inherit"
 *
 * @protected *
 * @param {sap.ui.core.Control} oControl List control
 * @param {String} [sAlign] TextAlign enumeration
 * @return {sap.ui.core.Control} oControl
 */
sap.m.Column.prototype.applyAlignTo = function(oControl, sAlign) {
	if (oControl.getMetadata().getProperties().textAlign) {
		sAlign = sAlign || this.getHAlign();
		if (oControl.getTextAlign() != sAlign) {
			var oDomRef = oControl.getDomRef();
			oControl.setProperty("textAlign", sAlign, true);
			oDomRef && (oDomRef.style.textAlign = this.getCssAlign(sAlign));
		}
	}

	return oControl;
};


/**
 * Returns CSS alignment according to column hAlign setting or given parameter
 * for Begin/End values checks the locale settings
 *
 * @param {String} [sAlign] TextAlign enumeration
 * @return {String} left|center|right
 * @protected
 */
sap.m.Column.prototype.getCssAlign = function(sAlign) {
	sAlign = sAlign || this.getHAlign();
	if (sAlign == "Begin" || sAlign == "End") {
		sAlign = this._getTextAlign(sAlign);
	}

	return sAlign.toLowerCase();
};


// Returns styleClass property with extra responsive class if second parameter is set true
sap.m.Column.prototype.getStyleClass = function(bResponsive) {
	var cls = this.getProperty("styleClass");
	if (!bResponsive) {
		return cls;
	}
	if (this._screen && (!this.getDemandPopin() || !window.matchMedia)) {
		cls += " sapMSize-" + this._screen;
	} else if (this._media && !this._media.matches) {
		cls += " sapMListTblNone";
	}
	return cls;
};


/**
 * Returns visible probability of the column
 *
 * @param {boolean} [bReturnCache] Whether return cache or new result
 * @return {boolean}
 * @protected
 */
sap.m.Column.prototype.isNeverVisible = function(bReturnCache) {
	if (bReturnCache) {
		return this._isNeverVisible;
	}

	if (!this._minWidth) {
		return this._isNeverVisible = false;
	}

	var width = parseFloat(this._minWidth),
		unit = this._minWidth.replace(/[^a-z]/g, ""),
		baseFontSize = parseFloat(sap.m.BaseFontSize) || 16;

	if (unit != "px") {
		width *= baseFontSize;
	}

	return this._isNeverVisible = (width > Math.max(window.screen.width, window.screen.height));
};


/**
 * Sets the visible column index
 * Negative index values can be used to clear
 *
 * @param {int} nIndex index of the visible column
 * @protected
 */
sap.m.Column.prototype.setIndex = function(nIndex) {
	this._index = +nIndex;
};


/**
 * Sets the order of the column
 * Does not do the visual effect
 * Table should be invalidate to re-render
 *
 * @param {int} nOrder order of the column
 * @protected
 */
sap.m.Column.prototype.setOrder = function(nOrder) {
	this._order = +nOrder;
};

/**
 * Gets the order of the column
 *
 * @returns {int} nOrder order of the column
 * @protected
 */
sap.m.Column.prototype.getOrder = function() {
	return this.hasOwnProperty("_order") ? this._order : this.getInitialOrder();
};

/**
 * Sets the initial order of the column
 *
 * @param {int} nOrder initial order of the column
 * @protected
 */
sap.m.Column.prototype.setInitialOrder = function(nOrder) {
	this._initialOrder = +nOrder;
};

/**
 * Gets the initial order of the column
 *
 * @returns {int} initial order of the column
 * @protected
 */
sap.m.Column.prototype.getInitialOrder = function() {
	if (this.hasOwnProperty("_initialOrder")) {
		return this._initialOrder;
	}

	var oParent = this.getParent();
	if (oParent && oParent.indexOfColumn) {
		return oParent.indexOfColumn(this);
	}

	return -1;
};

/**
 * Display or hide the column from given table
 * This does not set the visibility property of the column
 *
 * @param {Object} oTableDomRef Table DOM reference
 * @param {boolean} [bDisplay] whether visible or not
 * @protected
 */
sap.m.Column.prototype.setDisplay = function(oTableDomRef, bDisplay) {
	if (!oTableDomRef || this._index < 0) {
		return;
	}

	// go with native we need speed
	var i = this._index + 1,
		parent =  this.getParent(),
		display = bDisplay ? "table-cell" : "none",
		header = oTableDomRef.querySelector("tr > th:nth-child(" + i + ")"),
		cells = oTableDomRef.querySelectorAll("tr > td:nth-child(" + i + ")"),
		length = cells.length;

	// set display
	header.style.display = display;
	for (i = 0; i < length; i++) {
		cells[i].style.display = display;
	}

	// let the parent know the visibility change
	if (parent && parent.setTableHeaderVisibility) {
		// make it sure rendering phase is done with timeout
		setTimeout(function() {
			parent.setTableHeaderVisibility(bDisplay);
		}, 0);
	}
};

/**
 * Display or hide the column from given table via checking media query changes
 *
 * @param {Object} oTableDomRef Table DOM reference
 * @protected
 */
sap.m.Column.prototype.setDisplayViaMedia = function(oTableDomRef) {
	var oParent = this.getParent(),
		bDisplay = this._media && this._media.matches;

	if (!this.getDemandPopin() && this._screen && oParent && oParent.setTableHeaderVisibility) {
		// this means CSS media queries already change the column visibility
		// let the parent know the visibility change
		// make it sure rendering phase is done with timeout
		setTimeout(function() {
			oParent.setTableHeaderVisibility(bDisplay);
		}, 0);
	} else {
		this.setDisplay(oTableDomRef, bDisplay);
	}
};

sap.m.Column.prototype.setVisible = function(bVisible) {
	var oParent = this.getParent(),
		oTableDomRef = oParent && oParent.getTableDomRef && oParent.getTableDomRef(),
		bInvalidate = oTableDomRef && this._index >= 0;

	this.setProperty("visible", bVisible, bInvalidate);
	if (bInvalidate) {
		this.setDisplay(oTableDomRef, bVisible);
	}

	return this;
};

/*
 * Decides if we need media query or not according to given settings
 * Checks the given width is known screen size
 */
sap.m.Column.prototype.setMinScreenWidth = function(sWidth) {
	// check if setting the old value
	if (sWidth == this.getMinScreenWidth()) {
		return this;
	}

	// first validate the value
	this._validateMinWidth(sWidth);

	// initialize
	this._clearMedia();
	this._minWidth = 0;
	this._screen = "";

	if (sWidth) {
		// check given width is known screen-size
		sWidth = sWidth.toLowerCase();
		var width = sap.m.ScreenSizes[sWidth];
		if (width) {
			width += "px";
			this._screen = sWidth;
		} else {
			this._isWidthPredefined(sWidth);
			width = sWidth;
		}

		// keep the minimum width value
		this._minWidth = width;

		/**
		// OLD: if pop-in is requested or if unknown screen-size is given then go with JS media queries
		// NEW: We always need JS media queries to detect table header visibility
		if (this.getDemandPopin() || !this._screen) {
			this._addMedia();
		}
		*/
		this._addMedia();
	}

	return this.setProperty("minScreenWidth", sWidth);
};

/*
 * Decides if we need media query or not according to given settings
 * if pop-in is demanded then we always need JS media queries
 * if not demanded but if screen size is known CSS media query can handle
 */
sap.m.Column.prototype.setDemandPopin = function(bValue) {
	// check if setting the old value
	if (bValue == this.getDemandPopin()) {
		return this;
	}

	// minimum width should have been set
	if (!this.getMinScreenWidth()) {
		return this.setProperty("demandPopin", bValue, true);
	}

	return this.setProperty("demandPopin", bValue);
};


/**
 * Checks the column will be shown as pop-in
 *
 * @protected
 */
sap.m.Column.prototype.isPopin = function() {
	if (!this.getDemandPopin()) {
		return false;
	}
	if (this._media) {
		return !this._media.matches;
	}
	return false;
};

/**
 * Checks the column will be hidden
 *
 * @protected
 */
sap.m.Column.prototype.isHidden = function() {
	if (this._media) {
		return !this._media.matches;
	}

	if (this._screen && this._minWidth) {
		return parseFloat(this._minWidth) > window.innerWidth;
	}
	return false;
};

/**
 * Checks if box-sizing border-box works for columns
 * Most of the browser does not respect this CSS property, even buggy
 * https://bugs.webkit.org/show_bug.cgi?id=18565
 *
 * @protected
 * @readonly
 * @static
 */
sap.m.Column.hasBorderBoxSupport = (function() {
	var width = 5,
		hasBorderBoxSupport = false,
		table = "<table style='table-layout:fixed; width:" + width + "px; position:absolute; left:-99px; top:-99px'>" +
					"<tr><td style='width:" + width + "px; padding:1px; border:1px solid transparent;'></td></tr>" +
				"</table>",
		$table = jQuery(table);

	jQuery(document.body).append($table);
	if ($table.find("td").width() == width) {
		hasBorderBoxSupport = true;
	}

	$table.remove();
	return hasBorderBoxSupport;
}());

/**
 * This method is called from parent after all cells in column are rendered
 *
 * @param {jQuery} $table Table jQuery reference
 * @protected
 */
sap.m.Column.prototype.onColumnRendered = function($table) {
	// If there is no borderBox support and column is visible then run the workaround for box sizing
	if (!sap.m.Column.hasBorderBoxSupport && this._index >= 0 && this.getWidth() && this.getVisible() && !this.isPopin() && !this.isNeverVisible()) {
		var $header = $table.find("th:nth-child(" +  (this._index + 1) + ")"),
			outerWidth = $header.outerWidth(),
			width = $header.width();

		// set the outer-width as column width
		$header.width(2 * outerWidth - width);
	}
};

/**
 * Sets the last value of the column if mergeDuplicates property is true
 *
 * @param {any} value Any Value
 * @returns {sap.m.Column}
 * @since 1.16
 * @protected
 */
sap.m.Column.prototype.setLastValue = function(value) {
	if (this.getMergeDuplicates()) {
		this._lastValue = value;
	}
	return this;
};

/**
 * Clears the last value of the column if mergeDuplicates property is true
 *
 * @returns {sap.m.Column}
 * @since 1.20.4
 * @protected
 */
sap.m.Column.prototype.clearLastValue = function() {
	return this.setLastValue(NaN);
};

/**
 * Gets the last value of the column
 *
 * @since 1.16
 * @protected
 */
sap.m.Column.prototype.getLastValue = function() {
	return this._lastValue;
};


/**
 * Calls from Table to notify all items are removed
 *
 * @since 1.16
 * @protected
 */
sap.m.Column.prototype.onItemsRemoved = function() {
	this.clearLastValue();
};
}; // end of sap/m/Column.js
if ( !jQuery.sap.isDeclared('sap.m.ColumnListItemRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare("sap.m.ColumnListItemRenderer");
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained




/**
 * @class ColumnListItem renderer.
 * @static
 */
sap.m.ColumnListItemRenderer = sap.ui.core.Renderer.extend(sap.m.ListItemBaseRenderer);

/**
 * Renders the HTML for the given control, using the provided
 * {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager}
 *            oRenderManager the RenderManager that can be used for writing to
 *            the Render-Output-Buffer
 * @param {sap.ui.core.Control}
 *            oControl an object representation of the control that should be
 *            rendered
 */
sap.m.ColumnListItemRenderer.renderLIAttributes = function(rm, oLI) {
	rm.addClass("sapMListTblRow");
	var vAlign = oLI.getVAlign();
	if (vAlign != sap.ui.core.VerticalAlign.Inherit) {
		rm.addClass("sapMListTblRow" + vAlign);
	}
};


/**
 * Overwriting hook method of ListItemBase
 *
 * @public
 *
 * @param {sap.ui.core.RenderManager} rm RenderManager
 * @param {sap.m.ListItemBase} oLI List item
 * @param {sap.m.Table} oTable Table control
 */
sap.m.ColumnListItemRenderer.renderLIContent = function(rm, oLI, oTable) {
	if (!oTable) {
		return;
	}

	var aColumns = oTable.getColumns(true),
		aCells = oLI.getCells();

	// remove cloned headers
	oLI.destroyAggregation("clonedHeaders", true);

	// remove pop-in if list is not in rendering phase
	// in rendering phase all pop-ins are already removed
	if (!oTable._bRendering) {
		oLI.removePopin();
	}

	aColumns.forEach(function(oColumn, i) {
		var cls,
			bRenderCell = true,
			oCell = aCells[oColumn.getInitialOrder()];

		if (!oCell || !oColumn.getVisible() || oColumn.isNeverVisible(true) || oColumn.isPopin()) {
			return;
		}

		rm.write("<td");
		rm.addClass("sapMListTblCell");
		rm.writeAttribute("id", oLI.getId() + "_cell" + i);

		// check column properties
		if (oColumn) {
			cls = oColumn.getStyleClass(true);
			cls && rm.addClass(cls);

			// merge duplicate cells
			if (!oTable.hasPopin() && oColumn.getMergeDuplicates()) {
				var sFuncWithParam = oColumn.getMergeFunctionName(),
					aFuncWithParam = sFuncWithParam.split("#"),
					sFuncParam = aFuncWithParam[1],
					sFuncName = aFuncWithParam[0];

				if (typeof oCell[sFuncName] != "function") {
					jQuery.sap.log.warning("mergeFunctionName property is defined on " + oColumn + " but this is not function of " + oCell);
				} else {
					var lastColumnValue = oColumn.getLastValue(),
						cellValue = oCell[sFuncName](sFuncParam);

					if (lastColumnValue === cellValue) {
						bRenderCell = false;
						rm.addClass("sapMListTblCellDup");
					} else {
						oColumn.setLastValue(cellValue);
					}
				}
			}

			oColumn.getVAlign() != "Inherit" && rm.addStyle("vertical-align", oColumn.getVAlign().toLowerCase());
			rm.addStyle("text-align", oColumn.getCssAlign());
			rm.writeStyles();
		}

		rm.writeClasses();
		rm.write(">");
		if (bRenderCell) {
			rm.renderControl(oColumn.applyAlignTo(oCell));
		}
		rm.write("</td>");
	});
};


/**
 * Renders pop-ins for Table Rows
 *
 * @private
 *
 * @param {sap.ui.core.RenderManager} rm RenderManager
 * @param {sap.m.ListItemBase} oLI List item
 * @param {sap.m.Table} oTable Table control
 */
sap.m.ColumnListItemRenderer.renderPopin = function(rm, oLI, oTable) {
	oLI._popinId = oLI.getId() + "-sub";
	rm.write("<tr class='sapMListTblSubRow'");
	rm.writeAttribute("id", oLI._popinId);
	rm.writeAttribute("tabindex", -1);
	rm.write("><td");
	rm.writeAttribute("colspan", oTable.getColCount());
	rm.write("><div class='sapMListTblSubCnt'>");

	var aCells = oLI.getCells(),
		aColumns = oTable.getColumns(true);

	aColumns.forEach(function(oColumn) {
		if (!oColumn.getVisible() || !oColumn.isPopin()) {
			return;
		}

		var oCell = aCells[oColumn.getInitialOrder()],
			oHeader = oColumn.getHeader();

		if (!oHeader && !oCell) {
			return;
		}

		var cls = oColumn.getStyleClass();

		/* row start */
		rm.write("<div");
		rm.addClass("sapMListTblSubCntRow");
		cls && rm.addClass(cls);
		rm.writeClasses();
		rm.write(">");

		/* header cell */
		if (oHeader) {
			rm.write("<div");
			rm.addClass("sapMListTblSubCntHdr");
			rm.writeClasses();
			rm.write(">");
			oHeader = oHeader.clone();
			oLI.addAggregation("clonedHeaders", oHeader, true);
			oColumn.applyAlignTo(oHeader, "Begin");
			rm.renderControl(oHeader);
			rm.write("</div>");

			/* separator cell */
			rm.write("<div class='sapMListTblSubCntSpr'>:</div>");
		}

		/* value cell */
		if (oCell) {
			rm.write("<div");
			rm.addClass("sapMListTblSubCntVal");
			rm.addClass("sapMListTblSubCntVal" + oColumn.getPopinDisplay());
			rm.writeClasses();
			rm.write(">");
			oColumn.applyAlignTo(oCell, "Begin");
			rm.renderControl(oCell);
			rm.write("</div>");
		}

		/* row end */
		rm.write("</div>");
	});

	rm.write("</div></td></tr>");
};
}; // end of sap/m/ColumnListItemRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.CustomListItemRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare("sap.m.CustomListItemRenderer");
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained



/**
 * @class CustomListItem renderer.
 * @static
 */
sap.m.CustomListItemRenderer = sap.ui.core.Renderer.extend(sap.m.ListItemBaseRenderer);

/**
 * Renders the HTML for the given control, using the provided
 * {@link sap.ui.core.RenderManager}.
 * 
 * @param {sap.ui.core.RenderManager}
 *            oRenderManager the RenderManager that can be used for writing to
 *            the Render-Output-Buffer
 * @param {sap.ui.core.Control}
 *            oControl an object representation of the control that should be
 *            rendered
 */
sap.m.CustomListItemRenderer.renderLIAttributes = function(rm, oLI) {
	rm.addClass("sapMCLI");
};

sap.m.CustomListItemRenderer.renderLIContent = function(rm, oLI) {
	var aContent = oLI.getContent();
	var cLength = aContent.length;
	for ( var i = 0; i < cLength; i++) {
		rm.renderControl(aContent[i]);
	}
};
}; // end of sap/m/CustomListItemRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.CustomTileRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare("sap.m.CustomTileRenderer");

/**
 * @class CustomTile renderer. 
 * @static
 */
sap.m.CustomTileRenderer = sap.ui.core.Renderer.extend(sap.m.TileRenderer);

/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 * 
 * @param {sap.ui.core.RenderManager}
 *                oRm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.ui.core.Control}
 *                oControl an object representation of the control that should be rendered
 */
 sap.m.CustomTileRenderer.render = function(rm, oControl) {
	rm.write("<div ");
	rm.writeControlData(oControl);
	rm.addClass("sapMCustomTile");
	rm.writeClasses();
	if(oControl._invisible){
		rm.addStyle("visibility", "hidden");
		rm.writeStyles();
	}
	rm.write(">");
	rm.write("<div id=\"" + oControl.getId() + "-remove\" class=\"sapMTCRemove\"></div>");
	rm.write("<div class=\"sapMCustomTileContent\">");
	this._renderContent(rm,oControl);
	rm.write("</div></div>");
};

sap.m.CustomTileRenderer._renderContent = function (rm, oTile) {
	rm.renderControl(oTile.getContent());
};

}; // end of sap/m/CustomTileRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.DateTimeInputRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained


jQuery.sap.declare("sap.m.DateTimeInputRenderer");


/**
 * @class DateTimeInput renderer.
 * @static
 *
 * For a common look & feel,
 * DateTimeInputRenderer extends the InputRenderer
 */
sap.m.DateTimeInputRenderer = sap.ui.core.Renderer.extend(sap.m.InputBaseRenderer);

/**
 * Adds control specific class
 *
 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.m.DateTimeInputRenderer.addOuterClasses = function(oRm, oControl) {
	oRm.addClass("sapMDTI");
};

/**
 * Add pointer cursor to date-time input
 *
 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.m.DateTimeInputRenderer.addCursorClass = function(oRm, oControl) {
	if (oControl.getEnabled() && oControl.getEditable()) {
		oRm.addClass("sapMPointer");
	}
};
}; // end of sap/m/DateTimeInputRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.Dialog') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.m.Dialog.
jQuery.sap.declare("sap.m.Dialog");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new Dialog.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getIcon icon} : sap.ui.core.URI</li>
 * <li>{@link #getTitle title} : string</li>
 * <li>{@link #getShowHeader showHeader} : boolean (default: true)</li>
 * <li>{@link #getType type} : sap.m.DialogType (default: sap.m.DialogType.Standard)</li>
 * <li>{@link #getState state} : sap.ui.core.ValueState (default: sap.ui.core.ValueState.None)</li>
 * <li>{@link #getStretchOnPhone stretchOnPhone} : boolean (default: false)</li>
 * <li>{@link #getStretch stretch} : boolean (default: false)</li>
 * <li>{@link #getContentWidth contentWidth} : sap.ui.core.CSSSize</li>
 * <li>{@link #getContentHeight contentHeight} : sap.ui.core.CSSSize</li>
 * <li>{@link #getHorizontalScrolling horizontalScrolling} : boolean (default: true)</li>
 * <li>{@link #getVerticalScrolling verticalScrolling} : boolean (default: true)</li></ul>
 * </li>
 * <li>Aggregations
 * <ul>
 * <li>{@link #getContent content} <strong>(default aggregation)</strong> : sap.ui.core.Control[]</li>
 * <li>{@link #getSubHeader subHeader} : sap.m.Bar</li>
 * <li>{@link #getCustomHeader customHeader} : sap.m.Bar</li>
 * <li>{@link #getBeginButton beginButton} : sap.m.Button</li>
 * <li>{@link #getEndButton endButton} : sap.m.Button</li></ul>
 * </li>
 * <li>Associations
 * <ul>
 * <li>{@link #getLeftButton leftButton} : string | sap.m.Button</li>
 * <li>{@link #getRightButton rightButton} : string | sap.m.Button</li>
 * <li>{@link #getInitialFocus initialFocus} : string | sap.ui.core.Control</li></ul>
 * </li>
 * <li>Events
 * <ul>
 * <li>{@link sap.m.Dialog#event:beforeOpen beforeOpen} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li>
 * <li>{@link sap.m.Dialog#event:afterOpen afterOpen} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li>
 * <li>{@link sap.m.Dialog#event:beforeClose beforeClose} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li>
 * <li>{@link sap.m.Dialog#event:afterClose afterClose} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * The Dialog control is used to interrupt the current processing of an application to prompt the user for information or a response.
 * @extends sap.ui.core.Control
 * @implements sap.ui.core.PopupInterface
 *
 * @author SAP AG 
 * @version 1.20.6
 *
 * @constructor   
 * @public
 * @name sap.m.Dialog
 */
sap.ui.core.Control.extend("sap.m.Dialog", { metadata : {

	// ---- object ----
	interfaces : [
		"sap.ui.core.PopupInterface"
	],
	publicMethods : [
		// methods
		"open", "close", "isOpen"
	],

	// ---- control specific ----
	library : "sap.m",
	properties : {
		"icon" : {type : "sap.ui.core.URI", group : "Appearance", defaultValue : null},
		"title" : {type : "string", group : "Appearance", defaultValue : null},
		"showHeader" : {type : "boolean", group : "Appearance", defaultValue : true},
		"type" : {type : "sap.m.DialogType", group : "Appearance", defaultValue : sap.m.DialogType.Standard},
		"state" : {type : "sap.ui.core.ValueState", group : "Appearance", defaultValue : sap.ui.core.ValueState.None},
		"stretchOnPhone" : {type : "boolean", group : "Appearance", defaultValue : false, deprecated: true},
		"stretch" : {type : "boolean", group : "Appearance", defaultValue : false},
		"contentWidth" : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : null},
		"contentHeight" : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : null},
		"horizontalScrolling" : {type : "boolean", group : "Behavior", defaultValue : true},
		"verticalScrolling" : {type : "boolean", group : "Behavior", defaultValue : true}
	},
	defaultAggregation : "content",
	aggregations : {
    	"content" : {type : "sap.ui.core.Control", multiple : true, singularName : "content"}, 
    	"subHeader" : {type : "sap.m.Bar", multiple : false}, 
    	"customHeader" : {type : "sap.m.Bar", multiple : false}, 
    	"beginButton" : {type : "sap.m.Button", multiple : false}, 
    	"endButton" : {type : "sap.m.Button", multiple : false}, 
    	"_header" : {type : "sap.ui.core.Control", multiple : false, visibility : "hidden"}, 
    	"_title" : {type : "sap.ui.core.Control", multiple : false, visibility : "hidden"}, 
    	"_icon" : {type : "sap.ui.core.Control", multiple : false, visibility : "hidden"}
	},
	associations : {
		"leftButton" : {type : "sap.m.Button", multiple : false, deprecated: true}, 
		"rightButton" : {type : "sap.m.Button", multiple : false, deprecated: true}, 
		"initialFocus" : {type : "sap.ui.core.Control", multiple : false}
	},
	events : {
		"beforeOpen" : {}, 
		"afterOpen" : {}, 
		"beforeClose" : {}, 
		"afterClose" : {}
	}
}});


/**
 * Creates a new subclass of class sap.m.Dialog with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.m.Dialog.extend
 * @function
 */

sap.m.Dialog.M_EVENTS = {'beforeOpen':'beforeOpen','afterOpen':'afterOpen','beforeClose':'beforeClose','afterClose':'afterClose'};


/**
 * Getter for property <code>icon</code>.
 * Icon that is displayed in the dialog header. This icon is invisible in iOS platform and it's density aware that you can use the density convention (@2, @1.5, etc.) to provide higher resolution image for higher density screen.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.core.URI} the value of property <code>icon</code>
 * @public
 * @name sap.m.Dialog#getIcon
 * @function
 */

/**
 * Setter for property <code>icon</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.core.URI} sIcon  new value for property <code>icon</code>
 * @return {sap.m.Dialog} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Dialog#setIcon
 * @function
 */


/**
 * Getter for property <code>title</code>.
 * Title text appears in the dialog header.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>title</code>
 * @public
 * @name sap.m.Dialog#getTitle
 * @function
 */

/**
 * Setter for property <code>title</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sTitle  new value for property <code>title</code>
 * @return {sap.m.Dialog} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Dialog#setTitle
 * @function
 */


/**
 * Getter for property <code>showHeader</code>.
 * This property decides whether the header is shown inside the dialog. If this property is set to true, the text and icon property are ignored. This property has a default value true.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>showHeader</code>
 * @public
 * @since 1.15.1
 * @name sap.m.Dialog#getShowHeader
 * @function
 */

/**
 * Setter for property <code>showHeader</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bShowHeader  new value for property <code>showHeader</code>
 * @return {sap.m.Dialog} <code>this</code> to allow method chaining
 * @public
 * @since 1.15.1
 * @name sap.m.Dialog#setShowHeader
 * @function
 */


/**
 * Getter for property <code>type</code>.
 * The type of the dialog. In theme sap_bluecrystal, the type message will limit the dialog's width within 480px when runs on tablet and desktop.
 *
 * Default value is <code>Standard</code>
 *
 * @return {sap.m.DialogType} the value of property <code>type</code>
 * @public
 * @name sap.m.Dialog#getType
 * @function
 */

/**
 * Setter for property <code>type</code>.
 *
 * Default value is <code>Standard</code> 
 *
 * @param {sap.m.DialogType} oType  new value for property <code>type</code>
 * @return {sap.m.Dialog} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Dialog#setType
 * @function
 */


/**
 * Getter for property <code>state</code>.
 * State affects the icon and the title color. If other than None is set, a predefined icon will be added to the dialog. Setting icon property will overwrite the predefined icon. The default value is None which doesn't add any icon to the Dialog control. This property is by now only supported by blue crystal theme.
 *
 * Default value is <code>None</code>
 *
 * @return {sap.ui.core.ValueState} the value of property <code>state</code>
 * @public
 * @since 1.11.2
 * @name sap.m.Dialog#getState
 * @function
 */

/**
 * Setter for property <code>state</code>.
 *
 * Default value is <code>None</code> 
 *
 * @param {sap.ui.core.ValueState} oState  new value for property <code>state</code>
 * @return {sap.m.Dialog} <code>this</code> to allow method chaining
 * @public
 * @since 1.11.2
 * @name sap.m.Dialog#setState
 * @function
 */


/**
 * Getter for property <code>stretchOnPhone</code>.
 * When it's set to true, the dialog will be full screen when it runs on a phone.
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>stretchOnPhone</code>
 * @public
 * @since 1.11.2
 * @deprecated Since version 1.13.1. 
 * Please use the new stretch property instead. This enables a stretched dialog even on tablet and desktop. If you want to achieve the same effect as stretchOnPhone, please set the stretch with jQuery.device.is.phone, then dialog is only stretched when runs on phone.
 * @name sap.m.Dialog#getStretchOnPhone
 * @function
 */

/**
 * Setter for property <code>stretchOnPhone</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bStretchOnPhone  new value for property <code>stretchOnPhone</code>
 * @return {sap.m.Dialog} <code>this</code> to allow method chaining
 * @public
 * @since 1.11.2
 * @deprecated Since version 1.13.1. 
 * Please use the new stretch property instead. This enables a stretched dialog even on tablet and desktop. If you want to achieve the same effect as stretchOnPhone, please set the stretch with jQuery.device.is.phone, then dialog is only stretched when runs on phone.
 * @name sap.m.Dialog#setStretchOnPhone
 * @function
 */


/**
 * Getter for property <code>stretch</code>.
 * When this property is set to true, the dialog is stretched to a full screen display. This property is only applicable to standard dialog and message type dialog ignores this property.
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>stretch</code>
 * @public
 * @since 1.13.1
 * @name sap.m.Dialog#getStretch
 * @function
 */

/**
 * Setter for property <code>stretch</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bStretch  new value for property <code>stretch</code>
 * @return {sap.m.Dialog} <code>this</code> to allow method chaining
 * @public
 * @since 1.13.1
 * @name sap.m.Dialog#setStretch
 * @function
 */


/**
 * Getter for property <code>contentWidth</code>.
 * Preferred width of content in Dialog. This property affects the width of dialog on phone in landscape mode, tablet or desktop, because the dialog has a fixed width when runs on phone in portrait mode. If the preferred width is less than the minimum width of dilaog or more than the available width of the screen, it will be overwritten by the min or max value. The current mininum value of dialog width on tablet is 400px.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>contentWidth</code>
 * @public
 * @since 1.12.1
 * @name sap.m.Dialog#getContentWidth
 * @function
 */

/**
 * Setter for property <code>contentWidth</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.core.CSSSize} sContentWidth  new value for property <code>contentWidth</code>
 * @return {sap.m.Dialog} <code>this</code> to allow method chaining
 * @public
 * @since 1.12.1
 * @name sap.m.Dialog#setContentWidth
 * @function
 */


/**
 * Getter for property <code>contentHeight</code>.
 * Preferred height of content in Dialog. If the preferred height is bigger than the available space on screen, it will be overwritten by the maximum available height on screen in order to make sure that dialog isn't cut off.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>contentHeight</code>
 * @public
 * @since 1.12.1
 * @name sap.m.Dialog#getContentHeight
 * @function
 */

/**
 * Setter for property <code>contentHeight</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.core.CSSSize} sContentHeight  new value for property <code>contentHeight</code>
 * @return {sap.m.Dialog} <code>this</code> to allow method chaining
 * @public
 * @since 1.12.1
 * @name sap.m.Dialog#setContentHeight
 * @function
 */


/**
 * Getter for property <code>horizontalScrolling</code>.
 * This property indicates if user can scroll horizontally inside dialog when the content is bigger than the content area. However, when scrollable control (sap.m.ScrollContainer, sap.m.Page) is in the dialog, this property needs to be set to false to disable the scrolling in dialog in order to make the scrolling in the child control work properly.
 * Dialog detects if there's sap.m.NavContainer, sap.m.Page, or sap.m.ScrollContainer as direct child added to dialog. If there is, dialog will turn off scrolling by setting this property to false automatically ignoring the existing value of this property.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>horizontalScrolling</code>
 * @public
 * @since 1.15.1
 * @name sap.m.Dialog#getHorizontalScrolling
 * @function
 */

/**
 * Setter for property <code>horizontalScrolling</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bHorizontalScrolling  new value for property <code>horizontalScrolling</code>
 * @return {sap.m.Dialog} <code>this</code> to allow method chaining
 * @public
 * @since 1.15.1
 * @name sap.m.Dialog#setHorizontalScrolling
 * @function
 */


/**
 * Getter for property <code>verticalScrolling</code>.
 * This property indicates if user can scroll vertically inside dialog when the content is bigger than the content area. However, when scrollable control (sap.m.ScrollContainer, sap.m.Page) is in the dialog, this property needs to be set to false to disable the scrolling in dialog in order to make the scrolling in the child control work properly.
 * Dialog detects if there's sap.m.NavContainer, sap.m.Page, or sap.m.ScrollContainer as direct child added to dialog. If there is, dialog will turn off scrolling by setting this property to false automatically ignoring the existing value of this property.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>verticalScrolling</code>
 * @public
 * @since 1.15.1
 * @name sap.m.Dialog#getVerticalScrolling
 * @function
 */

/**
 * Setter for property <code>verticalScrolling</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bVerticalScrolling  new value for property <code>verticalScrolling</code>
 * @return {sap.m.Dialog} <code>this</code> to allow method chaining
 * @public
 * @since 1.15.1
 * @name sap.m.Dialog#setVerticalScrolling
 * @function
 */


/**
 * Getter for aggregation <code>content</code>.<br/>
 * The content inside the dialog.
 * 
 * <strong>Note</strong>: this is the default aggregation for Dialog.
 * @return {sap.ui.core.Control[]}
 * @public
 * @name sap.m.Dialog#getContent
 * @function
 */


/**
 * Inserts a content into the aggregation named <code>content</code>.
 *
 * @param {sap.ui.core.Control}
 *          oContent the content to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the content should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the content is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the content is inserted at 
 *             the last position        
 * @return {sap.m.Dialog} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Dialog#insertContent
 * @function
 */

/**
 * Adds some content <code>oContent</code> 
 * to the aggregation named <code>content</code>.
 *
 * @param {sap.ui.core.Control}
 *            oContent the content to add; if empty, nothing is inserted
 * @return {sap.m.Dialog} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Dialog#addContent
 * @function
 */

/**
 * Removes an content from the aggregation named <code>content</code>.
 *
 * @param {int | string | sap.ui.core.Control} vContent the content to remove or its index or id
 * @return {sap.ui.core.Control} the removed content or null
 * @public
 * @name sap.m.Dialog#removeContent
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>content</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.core.Control[]} an array of the removed elements (might be empty)
 * @public
 * @name sap.m.Dialog#removeAllContent
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.core.Control</code> in the aggregation named <code>content</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.core.Control}
 *            oContent the content whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @name sap.m.Dialog#indexOfContent
 * @function
 */
	

/**
 * Destroys all the content in the aggregation 
 * named <code>content</code>.
 * @return {sap.m.Dialog} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Dialog#destroyContent
 * @function
 */


/**
 * Getter for aggregation <code>subHeader</code>.<br/>
 * When subHeader is assigned to Dialog, it's rendered directly after the main header in Dialog. SubHeader is out of the content area and won't be scrolled when content's size is bigger than the content area's size.
 * 
 * @return {sap.m.Bar}
 * @public
 * @since 1.12.2
 * @name sap.m.Dialog#getSubHeader
 * @function
 */


/**
 * Setter for the aggregated <code>subHeader</code>.
 * @param {sap.m.Bar} oSubHeader
 * @return {sap.m.Dialog} <code>this</code> to allow method chaining
 * @public
 * @since 1.12.2
 * @name sap.m.Dialog#setSubHeader
 * @function
 */
	

/**
 * Destroys the subHeader in the aggregation 
 * named <code>subHeader</code>.
 * @return {sap.m.Dialog} <code>this</code> to allow method chaining
 * @public
 * @since 1.12.2
 * @name sap.m.Dialog#destroySubHeader
 * @function
 */


/**
 * Getter for aggregation <code>customHeader</code>.<br/>
 * CustomHeader is only supported in theme sap_bluecrystal. When it's set, the icon, title and showHeader are properties ignored. Only the customHeader is shown as the header of the dialog.
 * 
 * @return {sap.m.Bar}
 * @public
 * @since 1.15.1
 * @name sap.m.Dialog#getCustomHeader
 * @function
 */


/**
 * Setter for the aggregated <code>customHeader</code>.
 * @param {sap.m.Bar} oCustomHeader
 * @return {sap.m.Dialog} <code>this</code> to allow method chaining
 * @public
 * @since 1.15.1
 * @name sap.m.Dialog#setCustomHeader
 * @function
 */
	

/**
 * Destroys the customHeader in the aggregation 
 * named <code>customHeader</code>.
 * @return {sap.m.Dialog} <code>this</code> to allow method chaining
 * @public
 * @since 1.15.1
 * @name sap.m.Dialog#destroyCustomHeader
 * @function
 */


/**
 * Getter for aggregation <code>beginButton</code>.<br/>
 * The button which is rendered on the left side (right side in RTL mode) inside the dialog.
 * 
 * @return {sap.m.Button}
 * @public
 * @since 1.15.1
 * @name sap.m.Dialog#getBeginButton
 * @function
 */


/**
 * Setter for the aggregated <code>beginButton</code>.
 * @param {sap.m.Button} oBeginButton
 * @return {sap.m.Dialog} <code>this</code> to allow method chaining
 * @public
 * @since 1.15.1
 * @name sap.m.Dialog#setBeginButton
 * @function
 */
	

/**
 * Destroys the beginButton in the aggregation 
 * named <code>beginButton</code>.
 * @return {sap.m.Dialog} <code>this</code> to allow method chaining
 * @public
 * @since 1.15.1
 * @name sap.m.Dialog#destroyBeginButton
 * @function
 */


/**
 * Getter for aggregation <code>endButton</code>.<br/>
 * The button which is rendered on the right side (left side in RTL mode) inside the dialog.
 * 
 * @return {sap.m.Button}
 * @public
 * @since 1.15.1
 * @name sap.m.Dialog#getEndButton
 * @function
 */


/**
 * Setter for the aggregated <code>endButton</code>.
 * @param {sap.m.Button} oEndButton
 * @return {sap.m.Dialog} <code>this</code> to allow method chaining
 * @public
 * @since 1.15.1
 * @name sap.m.Dialog#setEndButton
 * @function
 */
	

/**
 * Destroys the endButton in the aggregation 
 * named <code>endButton</code>.
 * @return {sap.m.Dialog} <code>this</code> to allow method chaining
 * @public
 * @since 1.15.1
 * @name sap.m.Dialog#destroyEndButton
 * @function
 */


/**
 * LeftButton is shown at the left edge of the bar in iOS, and at the right side of the bar for the other platforms. Please set this to null if you want to remove the left button from the bar. And the button is only removed from the bar, not destroyed. When showHeader is set to false, this property will be ignored. Setting leftButton will also set the beginButton internally.
 *
 * @return {string} Id of the element which is the current target of the <code>leftButton</code> association, or null
 * @public
 * @deprecated Since version 1.15.1. 
 * 
 * LeftButton has benn deprecated since 1.15.1. Please use the beginButton instead which is more RTL friendly.
 * 
 * @name sap.m.Dialog#getLeftButton
 * @function
 */

/**
 * LeftButton is shown at the left edge of the bar in iOS, and at the right side of the bar for the other platforms. Please set this to null if you want to remove the left button from the bar. And the button is only removed from the bar, not destroyed. When showHeader is set to false, this property will be ignored. Setting leftButton will also set the beginButton internally.
 *
 * @param {string | sap.m.Button} vLeftButton 
 *    Id of an element which becomes the new target of this <code>leftButton</code> association.
 *    Alternatively, an element instance may be given.
 * @return {sap.m.Dialog} <code>this</code> to allow method chaining
 * @public
 * @deprecated Since version 1.15.1. 
 * 
 * LeftButton has benn deprecated since 1.15.1. Please use the beginButton instead which is more RTL friendly.
 * 
 * @name sap.m.Dialog#setLeftButton
 * @function
 */


	
/**
 * RightButton is always shown at the right edge of the bar. Please set this to null if you want to remove the right button from the bar. And the button is only removed from the bar, not destroyed. When showHeader is set to false, this property will be ignored. Setting rightButton will also set the endButton internally.
 *
 * @return {string} Id of the element which is the current target of the <code>rightButton</code> association, or null
 * @public
 * @deprecated Since version 1.15.1. 
 * 
 * RightButton has been deprecated since 1.15.1. Please use the endButton instead which is more RTL friendly.
 * @name sap.m.Dialog#getRightButton
 * @function
 */

/**
 * RightButton is always shown at the right edge of the bar. Please set this to null if you want to remove the right button from the bar. And the button is only removed from the bar, not destroyed. When showHeader is set to false, this property will be ignored. Setting rightButton will also set the endButton internally.
 *
 * @param {string | sap.m.Button} vRightButton 
 *    Id of an element which becomes the new target of this <code>rightButton</code> association.
 *    Alternatively, an element instance may be given.
 * @return {sap.m.Dialog} <code>this</code> to allow method chaining
 * @public
 * @deprecated Since version 1.15.1. 
 * 
 * RightButton has been deprecated since 1.15.1. Please use the endButton instead which is more RTL friendly.
 * @name sap.m.Dialog#setRightButton
 * @function
 */


	
/**
 * Focus is set to the dialog in the sequence of leftButton and rightButton when available. But if some other control needs to get the focus other than one of those two buttons, set the initialFocus with the control which should be focused on. Setting initialFocus to input controls doesn't open the on screen keyboard on mobile device, this is due to the browser limitation that the on screen keyboard can't be opened with javascript code. The opening of on screen keyboard must be triggered by real user action.
 *
 * @return {string} Id of the element which is the current target of the <code>initialFocus</code> association, or null
 * @public
 * @since 1.15.0
 * @name sap.m.Dialog#getInitialFocus
 * @function
 */

/**
 * Focus is set to the dialog in the sequence of leftButton and rightButton when available. But if some other control needs to get the focus other than one of those two buttons, set the initialFocus with the control which should be focused on. Setting initialFocus to input controls doesn't open the on screen keyboard on mobile device, this is due to the browser limitation that the on screen keyboard can't be opened with javascript code. The opening of on screen keyboard must be triggered by real user action.
 *
 * @param {string | sap.ui.core.Control} vInitialFocus 
 *    Id of an element which becomes the new target of this <code>initialFocus</code> association.
 *    Alternatively, an element instance may be given.
 * @return {sap.m.Dialog} <code>this</code> to allow method chaining
 * @public
 * @since 1.15.0
 * @name sap.m.Dialog#setInitialFocus
 * @function
 */


	
/**
 * This event will be fired before the dialog is opened. 
 *
 * @name sap.m.Dialog#beforeOpen
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters

 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'beforeOpen' event of this <code>sap.m.Dialog</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.m.Dialog</code>.<br/> itself. 
 *  
 * This event will be fired before the dialog is opened. 
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.m.Dialog</code>.<br/> itself.
 *
 * @return {sap.m.Dialog} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Dialog#attachBeforeOpen
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'beforeOpen' event of this <code>sap.m.Dialog</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.m.Dialog} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Dialog#detachBeforeOpen
 * @function
 */

/**
 * Fire event beforeOpen to attached listeners.

 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.m.Dialog} <code>this</code> to allow method chaining
 * @protected
 * @name sap.m.Dialog#fireBeforeOpen
 * @function
 */


/**
 * This event will be fired after the dialog is opened. 
 *
 * @name sap.m.Dialog#afterOpen
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters

 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'afterOpen' event of this <code>sap.m.Dialog</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.m.Dialog</code>.<br/> itself. 
 *  
 * This event will be fired after the dialog is opened. 
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.m.Dialog</code>.<br/> itself.
 *
 * @return {sap.m.Dialog} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Dialog#attachAfterOpen
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'afterOpen' event of this <code>sap.m.Dialog</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.m.Dialog} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Dialog#detachAfterOpen
 * @function
 */

/**
 * Fire event afterOpen to attached listeners.

 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.m.Dialog} <code>this</code> to allow method chaining
 * @protected
 * @name sap.m.Dialog#fireAfterOpen
 * @function
 */


/**
 * This event will be fired before the dialog is closed. 
 *
 * @name sap.m.Dialog#beforeClose
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters

 * @param {sap.m.Button} oControlEvent.getParameters.origin This indicates the trigger of closing the dialog. If dialog is closed by either leftButton or rightButton, the button that closes the dialog is set to this parameter. Otherwise this parameter is set to null.
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'beforeClose' event of this <code>sap.m.Dialog</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.m.Dialog</code>.<br/> itself. 
 *  
 * This event will be fired before the dialog is closed. 
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.m.Dialog</code>.<br/> itself.
 *
 * @return {sap.m.Dialog} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Dialog#attachBeforeClose
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'beforeClose' event of this <code>sap.m.Dialog</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.m.Dialog} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Dialog#detachBeforeClose
 * @function
 */

/**
 * Fire event beforeClose to attached listeners.
 * 
 * Expects following event parameters:
 * <ul>
 * <li>'origin' of type <code>sap.m.Button</code> This indicates the trigger of closing the dialog. If dialog is closed by either leftButton or rightButton, the button that closes the dialog is set to this parameter. Otherwise this parameter is set to null.</li>
 * </ul>
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.m.Dialog} <code>this</code> to allow method chaining
 * @protected
 * @name sap.m.Dialog#fireBeforeClose
 * @function
 */


/**
 * This event will be fired after the dialog is closed. 
 *
 * @name sap.m.Dialog#afterClose
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters

 * @param {sap.m.Button} oControlEvent.getParameters.origin This indicates the trigger of closing the dialog. If dialog is closed by either leftButton or rightButton, the button that closes the dialog is set to this parameter. Otherwise this parameter is set to null.
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'afterClose' event of this <code>sap.m.Dialog</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.m.Dialog</code>.<br/> itself. 
 *  
 * This event will be fired after the dialog is closed. 
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.m.Dialog</code>.<br/> itself.
 *
 * @return {sap.m.Dialog} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Dialog#attachAfterClose
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'afterClose' event of this <code>sap.m.Dialog</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.m.Dialog} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Dialog#detachAfterClose
 * @function
 */

/**
 * Fire event afterClose to attached listeners.
 * 
 * Expects following event parameters:
 * <ul>
 * <li>'origin' of type <code>sap.m.Button</code> This indicates the trigger of closing the dialog. If dialog is closed by either leftButton or rightButton, the button that closes the dialog is set to this parameter. Otherwise this parameter is set to null.</li>
 * </ul>
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.m.Dialog} <code>this</code> to allow method chaining
 * @protected
 * @name sap.m.Dialog#fireAfterClose
 * @function
 */


/**
 * Open the dialog.
 *
 * @name sap.m.Dialog.prototype.open
 * @function

 * @type void
 * @public
 */


/**
 * Close the dialog.
 *
 * @name sap.m.Dialog.prototype.close
 * @function

 * @type void
 * @public
 */


/**
 * The method checks if the Dialog is open. It returns true when the Dialog is currently open (this includes opening and closing animations), otherwise it returns false.
 *
 * @name sap.m.Dialog.prototype.isOpen
 * @function

 * @type boolean
 * @public
 * @since 1.9.1
 */


// Start of sap\m\Dialog.js
jQuery.sap.require('sap.ui.core.Popup'); // unlisted dependency retained


jQuery.sap.require('sap.ui.core.delegate.ScrollEnablement'); // unlisted dependency retained


jQuery.sap.require('sap.ui.core.IconPool'); // unlisted dependency retained

jQuery.sap.require('sap.ui.core.theming.Parameters'); // unlisted dependency retained

jQuery.sap.require('sap.ui.core.ValueState'); // unlisted dependency retained


sap.m.Dialog._bOneDesign = (sap.ui.core.theming.Parameters.get("sapMPlatformDependent") !== 'true');
sap.m.Dialog._bIOS7Tablet = sap.ui.Device.os.ios && sap.ui.Device.system.tablet && sap.ui.Device.os.version >= 7 && sap.ui.Device.os.version < 8 && sap.ui.Device.browser.name === "sf";
sap.m.Dialog._bPaddingByDefault = (sap.ui.getCore().getConfiguration().getCompatibilityVersion("sapMDialogWithPadding").compareTo("1.16") < 0);

sap.m.Dialog._mStateClasses = {};
sap.m.Dialog._mStateClasses[sap.ui.core.ValueState.None] = "";
sap.m.Dialog._mStateClasses[sap.ui.core.ValueState.Success] = "sapMDialogSuccess";
sap.m.Dialog._mStateClasses[sap.ui.core.ValueState.Warning] = "sapMDialogWarning";
sap.m.Dialog._mStateClasses[sap.ui.core.ValueState.Error] = "sapMDialogError";

sap.m.Dialog._mIcons = {};
sap.m.Dialog._mIcons[sap.ui.core.ValueState.Success] = sap.ui.core.IconPool.getIconURI("accept");
sap.m.Dialog._mIcons[sap.ui.core.ValueState.Warning] = sap.ui.core.IconPool.getIconURI("warning2");
sap.m.Dialog._mIcons[sap.ui.core.ValueState.Error] = sap.ui.core.IconPool.getIconURI("alert");

/* =========================================================== */
/*                  begin: Lifecycle functions                 */
/* =========================================================== */
sap.m.Dialog.prototype.init = function(){
	var that = this;
	this._externalIcon = undefined;
	this._sResizeListenerId = null;
	this._$Window = jQuery(window);
	this._iHMargin = sap.ui.Device.system.phone ? 64 : 128;
	this._iVMargin = 16;
	
	// used to judge if enableScrolling needs to be disabled
	this._scrollContentList = ["NavContainer", "Page", "ScrollContainer"];
	
	this.oPopup = new sap.ui.core.Popup();
	this.oPopup.setShadow(true);
	if(jQuery.device.is.iphone && !this._bMessageType){
		this.oPopup.setModal(true, "sapMDialogTransparentBlk");
	}else{
		this.oPopup.setModal(true, "sapMDialogBlockLayerInit");
	}

	//avoid playing fancy animation in native browser with android version smaller than 4.1
	//because it has problem with keyframe animation that it always sets back to the first
	//keyframe after the animation which causes flickering during the animation.
	if(!(sap.ui.Device.os.android && sap.ui.Device.os.version < 4.1 && window.navigator.userAgent.toLowerCase().indexOf("chrome") === -1)){
		this.oPopup.setAnimations(jQuery.proxy(this._openAnimation, this), jQuery.proxy(this._closeAnimation, this));
	}
	//keyboard support for desktop environments
	if(sap.ui.Device.system.desktop) {
		var fnOnEscape = jQuery.proxy(function(oEvent) {
				// when the escape is already handled by inner control, nothing should happen inside dialog
				if(oEvent.originalEvent && oEvent.originalEvent._sapui_handledByControl){
					return;
				}
				this.close();
				//event should not trigger any further actions
				oEvent.stopPropagation();
		}, this);
		//use pseudo event 'onsapescape' to implement keyboard-trigger for closing this dialog
		//had to implement this onthe popup instance because it did not work
		//on the dialog prototype
		this.oPopup.onsapescape = fnOnEscape;
	}

	//the orientationchange event listener
	this._fnOrientationChange = jQuery.proxy(this._reposition, this);

	this._fnContentResize = jQuery.proxy(this._onResize, this);

	this._fnRepositionAfterOpen = jQuery.proxy(this._repositionAfterOpen, this);

	this.oPopup._applyPosition = function(oPosition, bFromResize) {
		var $that = that.$(),
			self = this,
			$Window = jQuery(window);

		that._deregisterResizeHandler();
		that._setDimensions();
		that._adjustScrollingPane();

		//TODO: if sap_mvi has to be restored, here has to be changed.
		oPosition.at = {
			left: ($Window.width() - $that.outerWidth()) / 2,
			top: ($Window.height() - $that.outerHeight()) / 2
		}

		sap.ui.core.Popup.prototype._applyPosition.call(self, oPosition);

		var iWindowScrollTop = that._$Window.scrollTop(),
			iTop = $that.offset().top;
		if(sap.ui.Device.os.ios && iWindowScrollTop){
			//on iOS devices, the window is shifted up when keyboard opens. That's why the dialog should also be positioned higher because jQuery UI position doesn't
			//take window scrollTop into consideration.
			$that.css("top", iTop - iWindowScrollTop);
		}

		//TODO: remove this code after Apple fixes the jQuery(window).height() is 20px more than the window.innerHeight issue.
		if(sap.m.Dialog._bIOS7Tablet && sap.ui.Device.orientation.landscape){
			iTop = $that.offset().top;
			$that.css("top", iTop - 10); //the calculated window size is 20px more than the actual size in ios 7 tablet landscape mode.
		}

		that._registerResizeHandler();
	};

	if(sap.m.Dialog._bPaddingByDefault){
		this.addStyleClass("sapUiPopupWithPadding");
	}
};

sap.m.Dialog.prototype.onBeforeRendering = function(){
	//if content has scrolling, disable scrolling automatically
	if(this._hasSingleScrollableContent()){
		this._forceDisableScrolling = true;
		jQuery.sap.log.info("VerticalScrolling and horizontalScrolling in sap.m.Dialog with ID " + this.getId() +" has been disabled because there's scrollable content inside");
	}else{
		this._forceDisableScrolling = false;
	}
	
	if(!this._forceDisableScrolling){
		if(!this._oScroller){
			this._oScroller = new sap.ui.core.delegate.ScrollEnablement(this, this.getId() + "-scroll", {
				horizontal: this.getHorizontalScrolling(), // will be disabled in adjustScrollingPane if content can fit in
				vertical: this.getVerticalScrolling(),
				zynga: false,
				preventDefault: false,
				nonTouchScrolling: "scrollbar"
			});
		}
	}
};

sap.m.Dialog.prototype.onAfterRendering = function(){
	this._$scrollPane = this.$("scroll");
	this._$content = this.$("cont");
	
	if(this.isOpen()){
		//restore the focus after rendering when dialog is already open
		var sFocusControlId = this._getFocusId();
		jQuery.sap.focus(jQuery.sap.domById(sFocusControlId));
	}
};

sap.m.Dialog.prototype.exit = function(){
	this._deregisterResizeHandler();
	
	sap.ui.Device.resize.detachHandler(this._fnOrientationChange);
	
	sap.m.InstanceManager.removeDialogInstance(this);
	
	if(this.oPopup){
		this.oPopup.detachEvent(sap.ui.core.Popup.M_EVENTS.opened, this._handleOpened, this);
		this.oPopup.detachEvent(sap.ui.core.Popup.M_EVENTS.closed, this._handleClosed, this);
		this.oPopup.destroy();
		this.oPopup = null;
	}
	if(this._oScroller){
		this._oScroller.destroy();
		this._oScroller = null;
	}

	if(this._header){
		this._header.destroy();
		this._header = null;
	}
	
	if(this._headerTitle){
		this._headerTitle.destroy();
		this._headerTitle = null;
	}

	if(this._iconImage){
		this._iconImage.destroy();
		this._iconImage = null;
	}
};
/* =========================================================== */
/*                   end: Lifecycle functions                  */
/* =========================================================== */

/* =========================================================== */
/*                    begin: public functions                  */
/* =========================================================== */
sap.m.Dialog.prototype.open = function(){
	var oPopup = this.oPopup;

	if (oPopup.isOpen()){
		return this;
	}

	//reset the close trigger
	this._oCloseTrigger = null;

	var $blockLayer = jQuery("#sap-ui-blocklayer-popup"),
		// The control that needs to be focused after dialog is open is calculated in following sequence:
		// initialFocus, beginButton, endButton
		// dialog is always modal so the focus doen't need to be on the dialog when there's no initialFocus, beginButton and endButton available.
		// but to keep the consistency, the focus will in the end fall back to dialog itself.
		sFocusControlId = this._getFocusId();

	if(!sap.m.Dialog._bOneDesign && $blockLayer.length > 0){
		var bTransparent = jQuery.device.is.iphone && !this._bMessageType && !this.hasStyleClass("sapMActionSheetDialog");
		$blockLayer.toggleClass("sapMDialogTransparentBlk", bTransparent);
		$blockLayer.toggleClass("sapMDialogBlockLayerInit", !bTransparent);
	}

	this.fireBeforeOpen();
	oPopup.attachEvent(sap.ui.core.Popup.M_EVENTS.opened, this._handleOpened, this);

	// Open popup
	oPopup.setContent(this);
	oPopup.setInitialFocusId(sFocusControlId);
	if(!sap.m.Dialog._bOneDesign && jQuery.device.is.iphone && !this._bMessageType) {
		oPopup.setPosition("center top", "center bottom", window, "0 0", "fit");
	} else {
		oPopup.setPosition("center center", "center center", window, "0 0", "fit");
	}
	oPopup.open();

	// bind to window resize
	sap.ui.Device.resize.attachHandler(this._fnOrientationChange);

	sap.m.InstanceManager.addDialogInstance(this);
	return this;
};

sap.m.Dialog.prototype.close = function(){
	var oPopup = this.oPopup;

	var eOpenState = this.oPopup.getOpenState();
	if(!(eOpenState === sap.ui.core.OpenState.CLOSED || eOpenState === sap.ui.core.OpenState.CLOSING)){
		sap.m.closeKeyboard();
		this.fireBeforeClose({origin: this._oCloseTrigger});
		oPopup.attachEvent(sap.ui.core.Popup.M_EVENTS.closed, this._handleClosed, this);
		this._deregisterResizeHandler();
		oPopup.close();
	}
	return this;
};

sap.m.Dialog.prototype.isOpen = function(){
	return this.oPopup && this.oPopup.isOpen();
};
/* =========================================================== */
/*                     end: public functions                   */
/* =========================================================== */

/* =========================================================== */
/*                      begin: event handlers                  */
/* =========================================================== */
sap.m.Dialog.prototype._handleOpened = function(){
	this.oPopup.detachEvent(sap.ui.core.Popup.M_EVENTS.opened, this._handleOpened, this);
	this.fireAfterOpen();
};

sap.m.Dialog.prototype._handleClosed = function(){
	this.oPopup.detachEvent(sap.ui.core.Popup.M_EVENTS.closed, this._handleClosed, this);
	sap.ui.Device.resize.detachHandler(this._fnOrientationChange);
	sap.m.InstanceManager.removeDialogInstance(this);
	this.fireAfterClose({origin: this._oCloseTrigger});
};

/**
 * Event handler for the focusin event.
 * If it occurs on the focus handler elements at the beginning of the dialog, the focus is set to the end, and vice versa.
 * @param {jQuery.EventObject} oEvent The event object
 * @private
 */
sap.m.Dialog.prototype.onfocusin = function(oEvent){
	var oSourceDomRef = oEvent.target;
	
	//Check if the invisible FIRST focusable element (suffix '-firstfe') has gained focus
	if (oSourceDomRef.id === this.getId() + "-firstfe") {
		//Check if buttons are available
		var oLastFocusableDomref = jQuery("#" + this.getId() + " .sapMDialogActions").lastFocusableDomRef();
		if(!oLastFocusableDomref) {
			//If there are no buttons, check the content
			oLastFocusableDomref = this.$("cont").lastFocusableDomRef();
			if(!oLastFocusableDomref) {
				//If there is no content, check the header
				oLastFocusableDomref = this.$("header").lastFocusableDomRef();
			}
		}
		jQuery.sap.focus(oLastFocusableDomref);
	} else if (oSourceDomRef.id === this.getId() + "-lastfe") {
		//Check if the invisible LAST focusable element (suffix '-lastfe') has gained focus
		//First check if header content is available
		var oFirstFocusableDomref = this.$("header").firstFocusableDomRef();
		if(!oFirstFocusableDomref) {
			//Check if content are available
			var oFirstFocusableDomref = this.$("cont").firstFocusableDomRef();
			if(!oFirstFocusableDomref) {
				//If there is no content, check the buttons
				oFirstFocusableDomref = jQuery("#" + this.getId() + " .sapMDialogActions").firstFocusableDomRef();
			}
		}
		jQuery.sap.focus(oFirstFocusableDomref);
	}
};


/* =========================================================== */
/*                      end: event handlers                  */
/* =========================================================== */


/* =========================================================== */
/*                      begin: private functions               */
/* =========================================================== */
sap.m.Dialog.prototype._openAnimation = function($Ref, iRealDuration, fnOpened) {
	if(!(sap.ui.Device.browser.internet_explorer && sap.ui.Device.browser.version < 10)){
		$Ref.css("display", "block");
	}
	
	var that = this,
		bOpenedCalled = false,
		fnEnd;
	
	if(!sap.m.Dialog._bOneDesign && jQuery.device.is.iphone && !this._bMessageType) {
		fnEnd = function(){
			if(bOpenedCalled || !that.oPopup || that.oPopup.getOpenState() !== sap.ui.core.OpenState.OPENING){
				return;
			}
			$Ref.unbind("webkitTransitionEnd transitionend");
			$Ref.removeClass("sapMDialogSliding");
			fnOpened();
			bOpenedCalled = true;
		};
		
		$Ref.addClass("sapMDialogBottom").removeClass("sapMDialogHidden");
		window.setTimeout(function(){
			$Ref.bind("webkitTransitionEnd transitionend", fnEnd);
			$Ref.addClass("sapMDialogSliding").removeClass("sapMDialogBottom");
			//check if the transitionend event isn't fired, if it's not fired due to unexpected rerendering,
			//fnOpened should be called again.
			setTimeout(function(){
				fnEnd();
			}, 400);
		}, 0);
	} else {
		if(sap.ui.Device.browser.internet_explorer && sap.ui.Device.browser.version < 10){
			$Ref.fadeIn(200, fnOpened);
		}else{
			fnEnd = function(){
				if(bOpenedCalled || !that.oPopup || that.oPopup.getOpenState() !== sap.ui.core.OpenState.OPENING){
					return;
				}
				$Ref.unbind("webkitAnimationEnd animationend");
				fnOpened();
				$Ref.removeClass("sapMDialogOpening");
				bOpenedCalled = true;
			};
			$Ref.bind("webkitAnimationEnd animationend", fnEnd);
			$Ref.addClass("sapMDialogOpening");
			//check if the transitionend event isn't fired, if it's not fired due to unexpected rerendering,
			//fnOpened should be called again.
			setTimeout(function(){
				fnEnd();
			}, 150);
		}
	}
};

sap.m.Dialog.prototype._closeAnimation = function($Ref, iRealDuration, fnClose) {
	var that = this,
		bClosedCalled = false,
		fnEnd;
	
	if(!sap.m.Dialog._bOneDesign && jQuery.device.is.iphone && !this._bMessageType) {
		fnEnd = function(){
			if(bClosedCalled){
				return;
			}
			$Ref.unbind("webkitTransitionEnd transitionend");
			$Ref.addClass("sapMDialogHidden").removeClass("sapMDialogBottom").removeClass("sapMDialogSliding");
			fnClose();
			bClosedCalled = true;
		};
		$Ref.bind("webkitTransitionEnd transitionend", fnEnd);
		$Ref.addClass("sapMDialogSliding").addClass("sapMDialogBottom");
		//check if the transitionend event isn't fired, if it's not fired due to unexpected rerendering,
		//fnClose should be called again.
		setTimeout(function(){
			fnEnd();
		}, 400);
	} else {
		if(sap.ui.Device.browser.internet_explorer && sap.ui.Device.browser.version < 10){
			$Ref.fadeOut(200, fnClose);
		}else{
			fnEnd = function(){
				if(bClosedCalled){
					return;
				}
				$Ref.unbind("webkitAnimationEnd animationend");
				fnClose();
				$Ref.removeClass("sapMDialogClosing");
				bClosedCalled = true;
			};
			$Ref.bind("webkitAnimationEnd animationend", fnEnd);
			$Ref.addClass("sapMDialogClosing");
			setTimeout(function(){
				fnEnd();
			}, 150);
		}
	}
};

sap.m.Dialog.prototype._setDimensions = function() {
	var iWindowWidth = this._$Window.width(),
		iWindowHeight = (sap.m.Dialog._bIOS7Tablet && sap.ui.Device.orientation.landscape && window.innerHeight) ? window.innerHeight : this._$Window.height(),
		$this = this.$(),
		//stretch is ignored for message dialog
		bStretch = this.getStretch() && !this._bMessageType,
		iHPaddingToScreen = this._iHMargin,
		iVPaddingToScreen = this._iVMargin,
		iPaddingLeft = window.parseInt($this.css("padding-left"), 10),
		iPaddingRight = window.parseInt($this.css("padding-right"), 10),
		iPaddingTop = window.parseInt($this.css("padding-top"), 10),
		iPaddingBottom = window.parseInt($this.css("padding-bottom"), 10),
		$content = this._$content,
		iBorderLeft = window.parseInt($this.css("border-left-width"), 10),
		iBorderRight = window.parseInt($this.css("border-right-width"), 10),
		iBorderTop = window.parseInt($this.css("border-top-width"), 10),
		iBorderBottom = window.parseInt($this.css("border-bottom-width"), 10),
		iMaxWidth = iWindowWidth - iHPaddingToScreen,
		iMaxHeight = iWindowHeight - iVPaddingToScreen,
		sContentWidth = this.getContentWidth(),
		sContentHeight = this.getContentHeight(),
		$scrollArea = this._$scrollPane,
		//this is a fix for setting useTransform false in ScrollEnablement.js line 236
		bSAreaPosAbs = $scrollArea.css("position") === "absolute",
		oSubHeader = this.getSubHeader(),
		sCalcContentWidth = "",
		iMinWidth = 0,
		iContentMaxHeight, iHeaderHeight, iSubHeaderHeight, iFooterHeight, iScrollAreaHeight, iCalcContentWidth, iWidth, iHeight, bIgnoreContentWidth;
	
	//reset
	$this.css({
		"width": "",
		"height": "",
		"min-width": "",
		"max-width": "",
		"max-height": ""
	});
	
	$scrollArea.css({
		"width": ""
	});

	if(sap.ui.Device.system.tablet || sap.ui.Device.system.desktop){
		if(sap.m.Dialog._bOneDesign && bStretch){
			$this.css({
				"right": "0px",
				"bottom": "0px",
				"width": iWindowWidth + "px",
				"min-width": iWindowWidth + "px",
				"max-height": iWindowHeight + "px"
			});
		}else{
			iMinWidth = 400;
			$this.css({
				"max-width": (this._bMessageType ? 480 : iMaxWidth) + "px",
				"max-height": iMaxHeight + "px"
			});
		}
	}else{
		if(!sap.m.Dialog._bOneDesign && jQuery.device.is.iphone && !this._bMessageType){
			$this.css({width: "100%",  height: "100%"});
		}else{
			if(sap.m.Dialog._bOneDesign && bStretch){
				$this.css({
					"width": iWindowWidth + "px",
					"height": iWindowHeight + "px",
					"max-height": iWindowHeight + "px"
				});
			}else{
				if(sap.ui.Device.orientation.portrait){
					$this.css({
						"width": iMaxWidth + "px",
						"max-height": iMaxHeight + "px"
					});
				}else{
					iMinWidth = iWindowHeight;
					$this.css({
						"min-width": iMinWidth + "px",
						"max-width": iMaxWidth + "px",
						"max-height": iMaxHeight + "px"
					});
				}
			}
		}
	}
	
	iHeaderHeight = $this.children("header.sapMDialogTitle").outerHeight(true) || 0;
	iSubHeaderHeight = oSubHeader ? oSubHeader.$().outerHeight(true) : 0;
	if(!sap.m.Dialog._bOneDesign && sap.ui.Device.os.ios && !this._bMessageType){
		iFooterHeight = 0;
	}else{
		iFooterHeight = $this.children("footer").outerHeight(true) || 0;
	}
	
	//if stretch is true, paddings to screen are ignored
	iContentMaxHeight = (((sap.m.Dialog._bOneDesign && bStretch) || (!sap.m.Dialog._bOneDesign && jQuery.device.is.iphone && !this._bMessageType)) ? iWindowHeight : iMaxHeight) - iHeaderHeight - iSubHeaderHeight - iFooterHeight - iPaddingTop - iPaddingBottom - iBorderTop - iBorderBottom;
	//sContentWidth is ignored under the following conditions, because the width is managed by dialog itself.
	// 1. when runs on a phone in portrait mode 
	// 2. in landscape mode for iphone (in mvi)
	// 3. stretch (in bluecrystal) is true
	// 4. message type dialog
	bIgnoreContentWidth = (sap.ui.Device.system.phone && (sap.ui.Device.orientation.portrait || (!sap.m.Dialog._bOneDesign && sap.ui.Device.os.ios))) || (sap.m.Dialog._bOneDesign && bStretch) || this._bMessageType;
	
	if(sContentWidth && !bIgnoreContentWidth){
		if(sContentWidth.indexOf("%") > 0){
			sContentWidth = sap.m.PopupHelper.calcPercentageSize(sContentWidth, iWindowWidth);
		}
		
		// convert the width with unit to calculated value
		sContentWidth = $content.width(sContentWidth).width() + "px";
		
		iCalcContentWidth = Math.max(
				iMinWidth - iPaddingLeft - iPaddingRight - iBorderLeft - iBorderRight,
				Math.min(
						window.parseInt(sContentWidth, 10), 
						iMaxWidth - iPaddingLeft - iPaddingRight - iBorderLeft - iBorderRight
				)
			);
		
		sCalcContentWidth = iCalcContentWidth + "px";
		
		// normally setting the width on content is enough but when display:table dom is put out of the content area in dialog in IE9
		// the dialog is pushed to max width. Thus the width has to be set on root dom to prevent this.
		$this.css({
			"width": iCalcContentWidth + iPaddingLeft + iPaddingRight + iBorderLeft + iBorderRight
		});
	}
	
	//height is set later
	$content.css({
		"width": sCalcContentWidth,
		"max-height": ""
	});
	
	if(sContentHeight.indexOf("%") > 0){
		sContentHeight = sap.m.PopupHelper.calcPercentageSize(sContentHeight, iWindowHeight);
	}
	
	if(sContentHeight){
		// convert the height with unit to calculated value
		sContentHeight = $content.height(sContentHeight).height() + "px";
	}
	
	if(bSAreaPosAbs){
		//this is a fix for setting useTransform false in ScrollEnablement.js line 236
		iScrollAreaHeight = $scrollArea.outerHeight(true);
		if(sap.m.Dialog._bOneDesign && bStretch){
			$content.css("height", iContentMaxHeight);
		}else{
			if(sContentHeight){
				$content.css("height", Math.min(iContentMaxHeight, window.parseInt(sContentHeight, 10)));
			}else{
				$content.css("height", Math.min(iContentMaxHeight, iScrollAreaHeight));
			}
		}
	}else{
		if((sap.m.Dialog._bOneDesign && bStretch) || (!sap.m.Dialog._bOneDesign && jQuery.device.is.iphone && !this._bMessageType)){
			$content.css("height", iContentMaxHeight);
		}else{
			if(sContentHeight){
				$content.css("height", Math.min(iContentMaxHeight, window.parseInt(sContentHeight, 10)));
			}else{
				$content.css("max-height", iContentMaxHeight);
			}
		}
	}
};

sap.m.Dialog.prototype._adjustScrollingPane = function(){
	var	$scrollArea = this._$scrollPane,
		oCSS = {
			"display": "block"
		};

	// In Android version less than 4.1, the scrollEnablement needs to set position: absolute to $scrollArea.
	// Thus the width 100% has to be set in order to make the scrollArea as big as the contentArea
	if($scrollArea.css("position") === "absolute"){
		oCSS.width = "100%";
	}

	// If the content fits in, the display: inline-block should be replace with display: block.
	if($scrollArea.outerWidth(true) <= this._$content.width()){
		$scrollArea.css(oCSS);
	}

	if(this._oScroller){
		this._oScroller.refresh();
	}
};

sap.m.Dialog.prototype._reposition = function() {
	var that = this, 
		ePopupState = this.oPopup.getOpenState();
	
	if(ePopupState !== sap.ui.core.OpenState.OPEN && ePopupState !== sap.ui.core.OpenState.OPENING){
		return;
	}
	
	this._fnRepositionAfterOpen();
};

sap.m.Dialog.prototype._repositionAfterOpen = function(){
	//The dialog might have been destroyed while the timeout was set
	if(!this.oPopup) {
		return;
	}

	var eState = this.oPopup.getOpenState();
	//if resize event occurs while the opening animation, the position change has to be done after the opening animation.
	if(eState === sap.ui.core.OpenState.OPENING){
		window.setTimeout(this._fnRepositionAfterOpen, 50);
	}else{
		this._reapplyPosition();
	}
};

sap.m.Dialog.prototype._reapplyPosition = function(){
	this.oPopup && this.oPopup._applyPosition(this.oPopup._oLastPosition, true);
};

sap.m.Dialog.prototype._onResize = function(){
	if(this._sResizeTimer || !this.getDomRef()){
		return;
	}
	
	var that = this, 
		oResizeDomRef = this.getDomRef("scroll");
	
	this._iResizeDomWidth = this._iResizeDomWidth || oResizeDomRef.offsetWidth;
	this._iResizeDomHeight = this._iResizeDomHeight || oResizeDomRef.offsetHeight;
	
	this._sResizeTimer = window.setTimeout(function(){
		var iNewWidth = oResizeDomRef.offsetWidth,
			iNewHeight = oResizeDomRef.offsetHeight;
		if(that._iResizeDomWidth !== iNewWidth || that._iResizeDomHeight !== iNewHeight){
			that._fnOrientationChange();
		}
		that._sResizeTimer = null;
		that._iResizeDomWidth = null;
		that._iResizeDomHeight = null;
	}, 0);
};

sap.m.Dialog.prototype._createHeader = function(){
	if(sap.m.Dialog._bOneDesign || (sap.ui.Device.os.ios && !this._bMessageType)){
		if(!this._header){
			// set parent of header to detect changes on title
			this._header = new sap.m.Bar(this.getId()+"-header").addStyleClass("sapMHeader-CTX sapMDialogTitle");
			this.setAggregation("_header", this._header, false);
		}
	}
};

/**
 * If a scrollable control (sap.m.NavContainer, sap.m.ScrollContainer, sap.m.Page) is added to dialog's content aggregation as a single child or through one or more sap.ui.mvc.View instances,
 * the scrolling inside dialog will be disabled in order to avoid wrapped scrolling areas.
 * 
 * If more than one scrollable control is added to dialog, the scrolling needs to be disabled manually.
 */
sap.m.Dialog.prototype._hasSingleScrollableContent = function(){
	var aContent = this.getContent(), i;
	
	while(aContent.length === 1 && aContent[0] instanceof sap.ui.core.mvc.View){
		aContent = aContent[0].getContent();
	}
	
	if(aContent.length === 1){
		for(i = 0 ; i < this._scrollContentList.length ; i++){
			if(aContent[0] instanceof sap.m[this._scrollContentList[i]]){
				return true;
			}
		}
	}
	
	return false;
};

sap.m.Dialog.prototype._initBlockLayerAnimation = function(){
	//!!!now the animation on blocklayer is removed due to
	//problem with calling open, close, open without any interval
	//then blocklayer can't be removed and it blocks the whole UI
	if(!sap.m.Dialog._bOneDesign && (!jQuery.device.is.iphone || this._bMessageType)){
		// Animating also the block layer
		this.oPopup._showBlockLayer = function(){
			sap.ui.core.Popup.prototype._showBlockLayer.call(this);
			var $blockLayer = jQuery("#sap-ui-blocklayer-popup");
			if(sap.ui.Device.os.ios){
				$blockLayer.addClass('sapMDialogBLyInit');
//				setTimeout(function() {
//					$blockLayer.addClass('sapMDialogBLyShown');
//				}, 0);
			}else{
				$blockLayer.addClass("sapMDialogBlockLayerAnimation");
				setTimeout(function(){
					$blockLayer.addClass("sapMDialogBlockLayer");
				}, 0);
			}
		};

		this.oPopup._hideBlockLayer = function(){
			var $blockLayer = jQuery("#sap-ui-blocklayer-popup"), that = this;
			
			if(sap.ui.core.Popup.blStack.length > 1){
				// If there's still popups open, hide block layer without animation
				sap.ui.core.Popup.prototype._hideBlockLayer.call(that);
			}else{
				$blockLayer.removeClass('sapMDialogBlockLayerInit');
				if(sap.ui.Device.os.ios){
//					$blockLayer.removeClass('sapMDialogBLyShown');
//					$blockLayer.bind("webkitTransitionEnd", function(){
//						$blockLayer.unbind("webkitTransitionEnd");
						$blockLayer.removeClass("sapMDialogBLyInit");
						sap.ui.core.Popup.prototype._hideBlockLayer.call(that);
						
//					});
				}else{
					$blockLayer.removeClass("sapMDialogBlockLayer");
	
					$blockLayer.bind("webkitTransitionEnd transitionend", function(){
						jQuery(this).unbind("webkitTransitionEnd transitionend");
						sap.ui.core.Popup.prototype._hideBlockLayer.call(that);
						$blockLayer.removeClass("sapMDialogBlockLayerAnimation");
					});
				}
			}
		};
	}else{
		this.oPopup._hideBlockLayer = function(){
			var $blockLayer = jQuery("#sap-ui-blocklayer-popup");
			$blockLayer.removeClass("sapMDialogTransparentBlk");
			sap.ui.core.Popup.prototype._hideBlockLayer.call(this);
		};
	}
};


sap.m.Dialog.prototype._clearBlockLayerAnimation = function(){
	if(jQuery.device.is.iphone && !this._bMessageType){
		delete this.oPopup._showBlockLayer;
		this.oPopup._hideBlockLayer = function(){
			var $blockLayer = jQuery("#sap-ui-blocklayer-popup");
			$blockLayer.removeClass("sapMDialogTransparentBlk");
			sap.ui.core.Popup.prototype._hideBlockLayer.call(this);
		};
	}
};

sap.m.Dialog.prototype._getFocusId = function(){
	var oBeginButton = this.getBeginButton(),
		oEndButton = this.getEndButton();
		
	// Left or Right button can be visible false and therefore not rendered.
	// In such a case, focus should be set somewhere else.
	return this.getInitialFocus() 
			|| (oBeginButton && oBeginButton.getVisible() && oBeginButton.getId())
			|| (oEndButton && oEndButton.getVisible() && oEndButton.getId())
			|| this.getId();
};

/**
 * Returns the sap.ui.core.ScrollEnablement delegate which is used with this control.
 *
 * @private
 */
sap.m.Dialog.prototype.getScrollDelegate = function() {
	return this._oScroller;
};

sap.m.Dialog.prototype._composeAggreNameInHeader = function(sPos){
	var sHeaderAggregationName;
	
	if(sPos === "Begin"){
		sHeaderAggregationName = "contentLeft";
	}else if(sPos === "End"){
		sHeaderAggregationName = "contentRight";
	}else{
		sHeaderAggregationName = "content" + sPos;
	}
	
	return sHeaderAggregationName;
};

sap.m.Dialog.prototype._setButton = function(oButton, sPos, bSkipFlag){
	var that = this,
		sPosModified = this._firstLetterUpperCase(sPos),
		sGetterName = "get" + sPosModified + "Button",
		sAggregationName = sPos.toLowerCase() + "Button",
		sHeaderAggregationName = this._composeAggreNameInHeader(sPosModified), 
		oOldButton;

	oOldButton = this[sGetterName]();
	if(oOldButton && !(oOldButton instanceof sap.m.Button)){
		oOldButton = sap.ui.getCore().byId(oOldButton);
	}
	
	if(oButton && oOldButton === oButton){
		return this;
	}

	if(!this._oButtonDelegate){
		this._oButtonDelegate = {
			ontap: function(){
				that._oCloseTrigger = this;
			}
		};
	}
	
	if(oOldButton){
		oOldButton.removeDelegate(this._oButtonDelegate);
	}
	
	if(oButton){
		oButton.addDelegate(this._oButtonDelegate, true, oButton);
		if(sap.m.Dialog._bOneDesign){
			if( !(oButton.getType() === sap.m.ButtonType.Accept || oButton.getType() === sap.m.ButtonType.Reject)){
				oButton.setType(sap.m.ButtonType.Transparent);
			}
		}
	}
	
	if(!sap.m.Dialog._bOneDesign && sap.ui.Device.os.ios && !this._bMessageType){
		this._createHeader();
		if(oButton){
			if(oOldButton){
				this._header.removeAggregation(sHeaderAggregationName, oOldButton, true);
			}
			this._header.addAggregation(sHeaderAggregationName, oButton, true);
			this._header.invalidate();
		}else{
			if(oOldButton){
				this._header.removeAggregation(sHeaderAggregationName, oOldButton);
			}
		}
	}else{
		this.setAggregation(sAggregationName, oButton, false, /*avoid infinite loop*/true);
	}
	
	return this;
};

sap.m.Dialog.prototype._getButton = function(sPos){
	var sPosModified = this._firstLetterUpperCase(sPos),
		sHeaderAggregationName = this._composeAggreNameInHeader(sPosModified),
		sAggregationName = sPos.toLowerCase() + "Button", 
		sType = this.getType(),
		aHeaderAggregation;
	
	if(!sap.m.Dialog._bOneDesign && sap.ui.Device.os.ios && !this._bMessageType){
		aHeaderAggregation = this._header && this._header.getAggregation(sHeaderAggregationName);
		if(aHeaderAggregation && aHeaderAggregation[0]){
			return aHeaderAggregation[0];
		}else{
			return null;
		}
	}else{
		return this.getAggregation(sAggregationName, null, /*avoid infinite loop*/true);
	}
	
};

sap.m.Dialog.prototype._getButtonFromHeader = function(sPos){
	if(this._header){
		var sHeaderAggregationName = this._composeAggreNameInHeader(this._firstLetterUpperCase(sPos)),
			aContent = this._header.getAggregation(sHeaderAggregationName);
		return aContent && aContent[0];
	}else{
		return null;
	}
};

sap.m.Dialog.prototype._firstLetterUpperCase = function(sValue){
	return sValue.charAt(0).toUpperCase() + sValue.slice(1).toLowerCase();
};

sap.m.Dialog.prototype._getAnyHeader = function(){
	var oCustomHeader = this.getCustomHeader();
	
	if(oCustomHeader){
		return oCustomHeader;
	}else{
		var bShowHeader = this.getShowHeader();
		
		// if showHeader is set to false and not for standard dialog in iOS in theme sap_mvi, no header.
		if(!bShowHeader && !(!sap.m.Dialog._bOneDesign && !this._bMessageType && sap.ui.Device.os.ios)){
			return null;
		}

		if(!sap.m.Dialog._bOneDesign && !this.getTitle() && !this.getBeginButton() && !this.getEndButton()){
			//if there's no title, no left and right buttons, header isn't shown. (only in platform dependent themes)
			//for platform independent themes, header is always created.
			return null;
		}
		
		this._createHeader();
		return this._header;
	}
};

sap.m.Dialog.prototype._deregisterResizeHandler = function(){
	if (this._sResizeListenerId) {
		sap.ui.core.ResizeHandler.deregister(this._sResizeListenerId);
		this._sResizeListenerId = null;
	}
};

sap.m.Dialog.prototype._registerResizeHandler = function(){
	if(!this._sResizeListenerId && this.getDomRef()){
		var oResizeDomRef = this.getDomRef("scroll");
		this._iResizeDomWidth = oResizeDomRef.offsetWidth;
		this._iResizeDomHeight = oResizeDomRef.offsetHeight;
		this._sResizeListenerId = sap.ui.core.ResizeHandler.register(oResizeDomRef,  this._fnContentResize);
	}
};
/* =========================================================== */
/*                      end: private functions                 */
/* =========================================================== */

/* =========================================================== */
/*                         begin: setters                      */
/* =========================================================== */

sap.m.Dialog.prototype.setBeginButton = function(oButton){
	return this._setButton(oButton, "begin");
};

sap.m.Dialog.prototype.setEndButton = function(oButton){
	return this._setButton(oButton, "end");
};

sap.m.Dialog.prototype.setLeftButton = function(vButton){
	if(!(vButton instanceof sap.m.Button)){
		vButton = sap.ui.getCore().byId(vButton);
	}
	
	//setting leftButton will also set the beginButton with the same button instance.
	//as this instance is aggregated by the beginButton, the hidden aggregation isn't needed.
	this._setButton(vButton, "begin");
	return this.setAssociation("leftButton", vButton);
};

sap.m.Dialog.prototype.setRightButton = function(vButton){
	if(!(vButton instanceof sap.m.Button)){
		vButton = sap.ui.getCore().byId(vButton);
	}
	
	//setting rightButton will also set the endButton with the same button instance.
	//as this instance is aggregated by the endButton, the hidden aggregation isn't needed.
	this._setButton(vButton, "end");
	return this.setAssociation("rightButton", vButton);
};

sap.m.Dialog.prototype.setTitle = function(sTitle){
	this.setProperty("title", sTitle, true);

	if(this._headerTitle){
		this._headerTitle.setText(sTitle);
	}else{
		this._headerTitle = new sap.m.Label(this.getId() + "-title", {
			text: sTitle
		}).addStyleClass("sapMDialogTitle");
		
		if(sap.m.Dialog._bOneDesign || (sap.ui.Device.os.ios && !this._bMessageType)){
			this._createHeader();
			this._header.addContentMiddle(this._headerTitle);
		}else{
			this.setAggregation("_title", this._headerTitle);
		}
	}
	return this;
};

sap.m.Dialog.prototype.setCustomHeader = function(oCustomHeader){
	if(!sap.m.Dialog._bOneDesign){
		jQuery.sap.log.warning("CustomHeader property in sap.m.Dialog isn't supported in theme sap_mvi!");
	}else{
		if(oCustomHeader){
			oCustomHeader.addStyleClass("sapMDialogTitle");
		}
		this.setAggregation("customHeader", oCustomHeader);
	}
};

sap.m.Dialog.prototype.setState = function(sState){
	var mFlags = {}, 
		$this = this.$(),
		sName;
	mFlags[sState] = true;
	
	this.setProperty("state", sState, true);
	if(sap.m.Dialog._bOneDesign){
		for(sName in sap.m.Dialog._mStateClasses){
			$this.toggleClass(sap.m.Dialog._mStateClasses[sName], !!mFlags[sName]);
		}
		this.setIcon(sap.m.Dialog._mIcons[sState], true);
	}
};

sap.m.Dialog.prototype.setIcon = function(sIcon, bInternal){
	if(!bInternal){
		this._externalIcon = sIcon;
	}else{
		if(this._externalIcon){
			sIcon = this._externalIcon;
		}
	}
	
	if(sap.m.Dialog._bOneDesign || !sap.ui.Device.os.ios){
		//icon is only shown in non iOS platform
		if(sIcon){
			if(sIcon!==this.getIcon()){
				if(this._iconImage){
					this._iconImage.setSrc(sIcon);
				}else{
					this._iconImage = sap.ui.core.IconPool.createControlByURI({
						id: this.getId() + "-icon",
						src: sIcon
					}, sap.m.Image).addStyleClass("sapMDialogIcon");
					
					if(sap.m.Dialog._bOneDesign){
						this._createHeader();
						this._header.insertAggregation("contentMiddle", this._iconImage, 0);
					}else{
						this.setAggregation("_icon", this._iconImage);
					}
				}
			}
		}else{
			var sDialogState = this.getState();
			if(!bInternal && sDialogState !== sap.ui.core.ValueState.None && sap.m.Dialog._bOneDesign){
				if(this._iconImage){
					this._iconImage.setSrc(sap.m.Dialog._mIcons[sDialogState]);
				}
			}else{
				if(this._iconImage){
					this._iconImage.destroy();
					this._iconImage = null;
				}
			}
		}
	}
	
	this.setProperty("icon", sIcon, true);
	return this;
};

sap.m.Dialog.prototype.setType = function(sType){
	var sOldType = this.getType(), $blockRef, oBeginButton, oEndButton;
	
	if(sOldType === sType){
		return;
	}
	
	//first time set type property, need to check if the left button and right button are set
	//if set, need to move them when type is message
	if(this._bMessageType === undefined){
		if(sType === sap.m.DialogType.Message && !sap.m.Dialog._bOneDesign && sap.ui.Device.os.ios){
			if(this._header){
				oBeginButton = this._getButtonFromHeader("left");
				oEndButton = this._getButtonFromHeader("right");
				if(oBeginButton){
					this.setAggregation("beginButton", oBeginButton, false, true);
				}
				if(oEndButton){
					this.setAggregation("endButton", oEndButton, false, true);
				}
				this._header.destroy();
				this._header = null;
			}
		}
	}
	
	this._bMessageType = (sType === sap.m.DialogType.Message);
	
	if(!sap.m.Dialog._bOneDesign && sap.ui.Device.os.ios){
		$blockRef = jQuery("#sap-ui-blocklayer-popup");
		//reset blocklayer css and popup animation for iphone when changing the type
		if(this._bMessageType || !sap.ui.Device.system.phone){
			this.oPopup.setModal(true, "sapMDialogBlockLayerInit");
			if($blockRef.length > 0){
				$blockRef.removeClass("sapMDialogTransparentBlk").addClass("sapMDialogBlockLayerInit");
				if(this.oPopup.isOpen()){
					$blockRef.addClass("sapMBusyBLyInit sapMBusyBLyShown");
				}	
			}
			this.oPopup.setPosition("center center", "center center", document, "0 0", "fit");
			this._initBlockLayerAnimation();
		}else{
			this.oPopup.setModal(true, "sapMDialogTransparentBlk");
			if($blockRef.length > 0){
				$blockRef.removeClass("sapMBusyBLyShown sapMBusyBLyInit").addClass("sapMDialogTransparentBlk");
			}
			this.oPopup.setPosition("center top", "center bottom", document, "0 0", "fit");
			this._clearBlockLayerAnimation();
		}
	}
	
	return this.setProperty("type", sType, false);
};

sap.m.Dialog.prototype.setStretch = function(bStretch){
	this._bStretchSet = true;
	return this.setProperty("stretch", bStretch);
};

sap.m.Dialog.prototype.setStretchOnPhone = function(bStretchOnPhone){
	if(this._bStretchSet){
		jQuery.sap.log.warning("sap.m.Dialog: stretchOnPhone property is deprecated. Setting stretchOnPhone property is ignored when there's already stretch property set.")
		return this;
	}
	this.setProperty("stretchOnPhone", bStretchOnPhone);
	return this.setProperty("stretch", bStretchOnPhone && sap.ui.Device.system.phone);
};

sap.m.Dialog.prototype.setVerticalScrolling = function(bValue) {
	var oldValue = this.getVerticalScrolling();
	if(oldValue === bValue) {
		return;
	}

	this.$().toggleClass("sapMDialogVerScrollDisabled", !bValue);
	this.setProperty("verticalScrolling", bValue);

	if(this._oScroller) {
		this._oScroller.setVertical(bValue);
	}

	return this;

};

sap.m.Dialog.prototype.setHorizontalScrolling = function(bValue) {
	var oldValue = this.getHorizontalScrolling();
	if(oldValue === bValue){
		return;
	}

	this.$().toggleClass("sapMDialogHorScrollDisabled", !bValue);
	this.setProperty("horizontalScrolling", bValue);

	if(this._oScroller) {
		this._oScroller.setHorizontal(bValue);
	}

	return this;
};
/* =========================================================== */
/*                           end: setters                      */
/* =========================================================== */

// Pass the setter of beginButton and endButton from dialog to internal header
// Both of them are singular aggregation, only the following three methods need
// to be overwritten
sap.m.Dialog.prototype.setAggregation = function(sAggregationName, oObject, bSuppressInvalidate, bPassBy){
	if(!bPassBy && (sAggregationName === "beginButton" || sAggregationName === "endButton")){
		return this._setButton(oObject, sAggregationName.substring(0, sAggregationName.indexOf("Button")));
	}else{
		return sap.ui.core.Control.prototype.setAggregation.apply(this, Array.prototype.slice.call(arguments, 0, 3));
	}
};

sap.m.Dialog.prototype.getAggregation = function(sAggregationName, oDefaultForCreation, bPassBy){
	if(!bPassBy && (sAggregationName === "beginButton" || sAggregationName === "endButton")){
		return this._getButton(sAggregationName.substring(0, sAggregationName.indexOf("Button"))) || oDefaultForCreation || null;
	}else{
		return sap.ui.core.Control.prototype.getAggregation.apply(this, Array.prototype.slice.call(arguments, 0, 2));
	}
};

sap.m.Dialog.prototype.destroyAggregation = function(sAggregationName, bSuppressInvalidate){
	if((sAggregationName === "beginButton" || sAggregationName === "endButton") && (!sap.m.Dialog._bOneDesign && sap.ui.Device.os.ios && !this._bMessageType)){
		var sPos = sAggregationName.substring(0, sAggregationName.indexOf("Button")),
			sPos = this._firstLetterUpperCase(sPos),
			sHeaderAggregationName = "content" + sPos,
			aHeaderAggregation = this._header && this._header.getAggregation(sHeaderAggregationName);
		if(aHeaderAggregation && aHeaderAggregation[0]){
			aHeaderAggregation[0].destroy();
		}
	}else{
		return sap.ui.core.Control.prototype.destroyAggregation.apply(this, arguments);
	}
};

sap.m.Dialog.prototype.forceInvalidate = sap.ui.core.Control.prototype.invalidate;

// stop propagating the invalidate to static UIArea before dialog is opened.
// otherwise the open animation can't be seen
// dialog will be rendered directly to static ui area when the open method is called.
sap.m.Dialog.prototype.invalidate = function(oOrigin){
	if(this.isOpen()){
		this.forceInvalidate(oOrigin);
	}
};

}; // end of sap/m/Dialog.js
if ( !jQuery.sap.isDeclared('sap.m.DisplayListItemRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare("sap.m.DisplayListItemRenderer");
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained



/**
 * @class DisplayListItem renderer.
 * @static
 */
sap.m.DisplayListItemRenderer = sap.ui.core.Renderer.extend(sap.m.ListItemBaseRenderer);

/**
 * Renders the HTML for the given control, using the provided
 * {@link sap.ui.core.RenderManager}.
 * 
 * @param {sap.ui.core.RenderManager}
 *          oRenderManager the RenderManager that can be used for writing to the
 *          Render-Output-Buffer
 * @param {sap.ui.core.Control}
 *          oControl an object representation of the control that should be
 *          rendered
 */
sap.m.DisplayListItemRenderer.renderLIAttributes = function(rm, oLI) {
	rm.addClass("sapMDLI");
};

sap.m.DisplayListItemRenderer.renderLIContent = function(rm, oLI) {

	var isLabel = oLI.getLabel();

	// List item label
	if (isLabel) {
		rm.write("<label for='" + oLI.getId() + "-value' class='sapMDLILabel'>");
		rm.writeEscaped(oLI.getLabel());
		rm.write("</label>");
	}
	
	var isValue = oLI.getValue();
	
	// List item value
	if (isValue) {
		rm.write("<div id='" + oLI.getId() + "-value' class='sapMDLIValue'>");
		rm.writeEscaped(oLI.getValue());
		rm.write("</div>");
	}
};

}; // end of sap/m/DisplayListItemRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.FacetFilterItemRenderer') ) {
/*
 * @copyright
 */

jQuery.sap.declare("sap.m.FacetFilterItemRenderer");
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained



sap.m.FacetFilterItemRenderer = sap.ui.core.Renderer.extend(sap.m.ListItemBaseRenderer);

/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 * 
 * @param {sap.ui.core.RenderManager}
 *          oRm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.ui.core.Control}
 *          oControl an object representation of the control that should be rendered
 */
sap.m.FacetFilterItemRenderer.renderLIContent = function(oRm, oControl) {

	oRm.write("<div");
	oRm.addClass("sapMFFLITitle");
	oRm.writeClasses();
	oRm.write(">");
  oRm.writeEscaped(oControl.getText());
  oRm.write("</div>");
};

}; // end of sap/m/FacetFilterItemRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.FacetFilterListRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare("sap.m.FacetFilterListRenderer");


jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained


jQuery.sap.declare("sap.m.FacetFilterListRenderer");

/**
 * @class List renderer.
 * @static
 *
 * ListRenderer extends the ListBaseRenderer
 */
sap.m.FacetFilterListRenderer = sap.ui.core.Renderer.extend(sap.m.ListRenderer);

}; // end of sap/m/FacetFilterListRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.FeedListItemRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for the sap.m.FeedListItem
jQuery.sap.declare("sap.m.FeedListItemRenderer");
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained



/**
 * @class FeedListItem renderer.
 * @static
 */
sap.m.FeedListItemRenderer = sap.ui.core.Renderer.extend(sap.m.ListItemBaseRenderer);

/**
 * Make sure that parent li is displayed as a horizontal webkit-box.
 * 
 * @param {sap.ui.core.RenderManager}
 *            rm the RenderManager that can be used for writing to the
 *            Render-Output-Buffer
 * @param {sap.ui.core.Control}
 *            oFeedListItem an object representation of the feed list item that
 *            should be rendered
 */
sap.m.FeedListItemRenderer.renderLIAttributes = function (rm, oFeedListItem) {
	rm.addClass("sapMFeedListItemTitleDiv");
	if (oFeedListItem._showSeparators === sap.m.ListSeparators.None) {
		rm.addClass("sapMFeedListShowSeparatorsNone");
	} else {
		rm.addClass("sapMFeedListShowSeparatorsAll");
	}
	
};

/**
 * Renders the HTML for the given control, using the provided
 * {@link sap.ui.core.RenderManager}.
 * 
 * @param {sap.ui.core.RenderManager}
 *            rm the RenderManager that can be used for writing to the
 *            Render-Output-Buffer
 * @param {sap.ui.core.Control}
 *            oFeedListItem an object representation of the feed list item that
 *            should be rendered
 */
sap.m.FeedListItemRenderer.renderLIContent = function (rm, oFeedListItem) {
	// convenience variable
	var sMyId = oFeedListItem.getId(),
		bIsPhone = sap.ui.Device.system.phone;

	rm.write('<article');
	rm.writeControlData(oFeedListItem);
	rm.addClass('sapMFeedListItem');

	rm.writeClasses();
	rm.write('>');

	// icon
	if (!!oFeedListItem.getShowIcon()) {
		rm.write('<figure id="' + sMyId + '-figure" class ="sapMFeedListItemFigure');
		if (!!oFeedListItem.getIcon()) {
			rm.write('">');
		} else {
			rm.write(' sapMFeedListItemIsDefaultIcon">');
		}
		if (!!oFeedListItem.getIconActive()) {
			
			rm.write('<a id="' + sMyId + '-iconRef" ');
			rm.writeAttribute('href', 'javascript:void(0);');
			rm.write('>');
		} 
		rm.renderControl(oFeedListItem._getImageControl());	
		if (!!oFeedListItem.getIconActive()) {
			rm.write('</a>');
		}
		rm.write('</figure>');
	}

	// text (starting with sender)
	

	
	if (bIsPhone) {
		rm.write('<div class= "sapMFeedListItemHeader ');
		if (!!oFeedListItem.getShowIcon()) {
			rm.write('sapMFeedListItemHasFigure ');
		}
		if (!!oFeedListItem.getSender() && !!oFeedListItem.getTimestamp()) {
			rm.write('sapMFeedListItemFullHeight');
		}
		rm.write('" >');
			if (!!oFeedListItem.getSender()) {
				rm.write('<p id="' + sMyId + '-name" class="sapMFeedListItemTextName">');
				rm.renderControl(oFeedListItem._getLinkControl());
				rm.write('</p>');
			}
			if (!!oFeedListItem.getTimestamp()) {
				//write date
				rm.write('<p class="sapMFeedListItemTimestamp">');
				rm.writeEscaped(oFeedListItem.getTimestamp());
				rm.write('</p>');
			}
		
		rm.write('</div>');
		rm.write('<p class="sapMFeedListItemText">');
		rm.writeEscaped(oFeedListItem.getText(), true);
		rm.write('</p>');
		if (!!oFeedListItem.getInfo()) {
			// info
			rm.write('<p class="sapMFeedListItemFooter">');
			if (!!oFeedListItem.getInfo()) {
				rm.write('<span class="sapMFeedListItemInfo">');
				rm.writeEscaped(oFeedListItem.getInfo());
				rm.write('</span>');
			}
		}
	} else {
		rm.write('<div class= "sapMFeedListItemText ');
		if (!!oFeedListItem.getShowIcon()) {
			rm.write('sapMFeedListItemHasFigure ');
		}
		rm.write('" >');
		rm.write('<p id="' + sMyId + '-text" class="sapMFeedListItemTextText">');
		if (!!oFeedListItem.getSender()) {
			rm.write('<span id="' + sMyId + '-name" class="sapMFeedListItemTextName">');
			rm.renderControl(oFeedListItem._getLinkControl());
			rm.write(': ');
			rm.write('</span>');
		}
		rm.writeEscaped(oFeedListItem.getText(), true);
		if (!!oFeedListItem.getInfo() || !!oFeedListItem.getTimestamp()) {
			if(!sap.ui.getCore().getConfiguration().getRTL()){
				// info and date
				rm.write('<p class="sapMFeedListItemFooter">');
				if (!!oFeedListItem.getInfo()) {
					rm.writeEscaped(oFeedListItem.getInfo());
					//Write Interpunct separator if necessary (with spaces before and after)
					if (!!oFeedListItem.getTimestamp()) {
						rm.write("<span>&#160&#160&#x00B7&#160&#160</span>");
					}
				}
				if (!!oFeedListItem.getTimestamp()) {
					rm.writeEscaped(oFeedListItem.getTimestamp());
				}
			} else {
				// info and date
				rm.write('<p class="sapMFeedListItemFooter">');
				if (!!oFeedListItem.getTimestamp()) {
					rm.writeEscaped(oFeedListItem.getTimestamp());
				}
				if (!!oFeedListItem.getInfo()) {
					//Write Interpunct separator if necessary (with spaces before and after)
					if (!!oFeedListItem.getTimestamp()) {
						rm.write("<span>&#160&#160&#x00B7&#160&#160</span>");
					}
					rm.writeEscaped(oFeedListItem.getInfo());
				}
				
			}
			
		}
		rm.write('</p>');
		rm.write('</div>');
	}
	rm.write('</article>');
};

}; // end of sap/m/FeedListItemRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.FlexBox') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.m.FlexBox.
jQuery.sap.declare("sap.m.FlexBox");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new FlexBox.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getVisible visible} : boolean (default: true)</li>
 * <li>{@link #getHeight height} : sap.ui.core.CSSSize (default: '')</li>
 * <li>{@link #getWidth width} : sap.ui.core.CSSSize (default: '')</li>
 * <li>{@link #getDisplayInline displayInline} : boolean (default: false)</li>
 * <li>{@link #getDirection direction} : sap.m.FlexDirection (default: sap.m.FlexDirection.Row)</li>
 * <li>{@link #getFitContainer fitContainer} : boolean (default: false)</li>
 * <li>{@link #getRenderType renderType} : sap.m.FlexRendertype (default: sap.m.FlexRendertype.Div)</li>
 * <li>{@link #getJustifyContent justifyContent} : sap.m.FlexJustifyContent (default: sap.m.FlexJustifyContent.Start)</li>
 * <li>{@link #getAlignItems alignItems} : sap.m.FlexAlignItems (default: sap.m.FlexAlignItems.Stretch)</li></ul>
 * </li>
 * <li>Aggregations
 * <ul>
 * <li>{@link #getItems items} <strong>(default aggregation)</strong> : sap.ui.core.Control[]</li></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * The FlexBox control builds the container for a flexible box layout.
 * 
 * Browser support:
 * This control is not supported in Internet Explorer 9!
 * @extends sap.ui.core.Control
 *
 * @author SAP AG 
 * @version 1.20.6
 *
 * @constructor   
 * @public
 * @name sap.m.FlexBox
 */
sap.ui.core.Control.extend("sap.m.FlexBox", { metadata : {

	// ---- object ----

	// ---- control specific ----
	library : "sap.m",
	properties : {
		"visible" : {type : "boolean", group : "Appearance", defaultValue : true},
		"height" : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : ''},
		"width" : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : ''},
		"displayInline" : {type : "boolean", group : "Appearance", defaultValue : false},
		"direction" : {type : "sap.m.FlexDirection", group : "Appearance", defaultValue : sap.m.FlexDirection.Row},
		"fitContainer" : {type : "boolean", group : "Appearance", defaultValue : false},
		"renderType" : {type : "sap.m.FlexRendertype", group : "Misc", defaultValue : sap.m.FlexRendertype.Div},
		"justifyContent" : {type : "sap.m.FlexJustifyContent", group : "Appearance", defaultValue : sap.m.FlexJustifyContent.Start},
		"alignItems" : {type : "sap.m.FlexAlignItems", group : "Appearance", defaultValue : sap.m.FlexAlignItems.Stretch}
	},
	defaultAggregation : "items",
	aggregations : {
    	"items" : {type : "sap.ui.core.Control", multiple : true, singularName : "item"}
	}
}});


/**
 * Creates a new subclass of class sap.m.FlexBox with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.m.FlexBox.extend
 * @function
 */


/**
 * Getter for property <code>visible</code>.
 * Is the control visible
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>visible</code>
 * @public
 * @name sap.m.FlexBox#getVisible
 * @function
 */

/**
 * Setter for property <code>visible</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bVisible  new value for property <code>visible</code>
 * @return {sap.m.FlexBox} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.FlexBox#setVisible
 * @function
 */


/**
 * Getter for property <code>height</code>.
 * The height of the FlexBox. Note that when a percentage is given, for the height to work as expected, the height of the surrounding container must be defined.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>height</code>
 * @public
 * @since 1.9.1
 * @name sap.m.FlexBox#getHeight
 * @function
 */

/**
 * Setter for property <code>height</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.core.CSSSize} sHeight  new value for property <code>height</code>
 * @return {sap.m.FlexBox} <code>this</code> to allow method chaining
 * @public
 * @since 1.9.1
 * @name sap.m.FlexBox#setHeight
 * @function
 */


/**
 * Getter for property <code>width</code>.
 * The width of the FlexBox. Note that when a percentage is given, for the width to work as expected, the width of the surrounding container must be defined.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>width</code>
 * @public
 * @since 1.9.1
 * @name sap.m.FlexBox#getWidth
 * @function
 */

/**
 * Setter for property <code>width</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.core.CSSSize} sWidth  new value for property <code>width</code>
 * @return {sap.m.FlexBox} <code>this</code> to allow method chaining
 * @public
 * @since 1.9.1
 * @name sap.m.FlexBox#setWidth
 * @function
 */


/**
 * Getter for property <code>displayInline</code>.
 * Determines whether the flexbox is in block or inline mode
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>displayInline</code>
 * @public
 * @name sap.m.FlexBox#getDisplayInline
 * @function
 */

/**
 * Setter for property <code>displayInline</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bDisplayInline  new value for property <code>displayInline</code>
 * @return {sap.m.FlexBox} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.FlexBox#setDisplayInline
 * @function
 */


/**
 * Getter for property <code>direction</code>.
 * Determines the direction of the layout of child elements
 *
 * Default value is <code>Row</code>
 *
 * @return {sap.m.FlexDirection} the value of property <code>direction</code>
 * @public
 * @name sap.m.FlexBox#getDirection
 * @function
 */

/**
 * Setter for property <code>direction</code>.
 *
 * Default value is <code>Row</code> 
 *
 * @param {sap.m.FlexDirection} oDirection  new value for property <code>direction</code>
 * @return {sap.m.FlexBox} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.FlexBox#setDirection
 * @function
 */


/**
 * Getter for property <code>fitContainer</code>.
 * Determines whether the flexbox will be sized to completely fill its container. If the FlexBox is inserted into a Page, the property 'enableScrolling' of the Page needs to be set to 'false' for the FlexBox to fit the entire viewport.
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>fitContainer</code>
 * @public
 * @name sap.m.FlexBox#getFitContainer
 * @function
 */

/**
 * Setter for property <code>fitContainer</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bFitContainer  new value for property <code>fitContainer</code>
 * @return {sap.m.FlexBox} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.FlexBox#setFitContainer
 * @function
 */


/**
 * Getter for property <code>renderType</code>.
 * Determines whether the layout is rendered as a series of divs or as an unordered list (ul)
 *
 * Default value is <code>Div</code>
 *
 * @return {sap.m.FlexRendertype} the value of property <code>renderType</code>
 * @public
 * @name sap.m.FlexBox#getRenderType
 * @function
 */

/**
 * Setter for property <code>renderType</code>.
 *
 * Default value is <code>Div</code> 
 *
 * @param {sap.m.FlexRendertype} oRenderType  new value for property <code>renderType</code>
 * @return {sap.m.FlexBox} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.FlexBox#setRenderType
 * @function
 */


/**
 * Getter for property <code>justifyContent</code>.
 * Determines the layout behavior along the main axis. "SpaceAround" is currently not supported in most non-Webkit browsers.
 *
 * Default value is <code>Start</code>
 *
 * @return {sap.m.FlexJustifyContent} the value of property <code>justifyContent</code>
 * @public
 * @name sap.m.FlexBox#getJustifyContent
 * @function
 */

/**
 * Setter for property <code>justifyContent</code>.
 *
 * Default value is <code>Start</code> 
 *
 * @param {sap.m.FlexJustifyContent} oJustifyContent  new value for property <code>justifyContent</code>
 * @return {sap.m.FlexBox} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.FlexBox#setJustifyContent
 * @function
 */


/**
 * Getter for property <code>alignItems</code>.
 * Determines the layout behavior of items along the cross-axis. "Baseline" is not supported in Internet Explorer <10.
 *
 * Default value is <code>Stretch</code>
 *
 * @return {sap.m.FlexAlignItems} the value of property <code>alignItems</code>
 * @public
 * @name sap.m.FlexBox#getAlignItems
 * @function
 */

/**
 * Setter for property <code>alignItems</code>.
 *
 * Default value is <code>Stretch</code> 
 *
 * @param {sap.m.FlexAlignItems} oAlignItems  new value for property <code>alignItems</code>
 * @return {sap.m.FlexBox} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.FlexBox#setAlignItems
 * @function
 */


/**
 * Getter for aggregation <code>items</code>.<br/>
 * Flex items within the FlexBox layout
 * 
 * <strong>Note</strong>: this is the default aggregation for FlexBox.
 * @return {sap.ui.core.Control[]}
 * @public
 * @name sap.m.FlexBox#getItems
 * @function
 */


/**
 * Inserts a item into the aggregation named <code>items</code>.
 *
 * @param {sap.ui.core.Control}
 *          oItem the item to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the item should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the item is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the item is inserted at 
 *             the last position        
 * @return {sap.m.FlexBox} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.FlexBox#insertItem
 * @function
 */

/**
 * Adds some item <code>oItem</code> 
 * to the aggregation named <code>items</code>.
 *
 * @param {sap.ui.core.Control}
 *            oItem the item to add; if empty, nothing is inserted
 * @return {sap.m.FlexBox} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.FlexBox#addItem
 * @function
 */

/**
 * Removes an item from the aggregation named <code>items</code>.
 *
 * @param {int | string | sap.ui.core.Control} vItem the item to remove or its index or id
 * @return {sap.ui.core.Control} the removed item or null
 * @public
 * @name sap.m.FlexBox#removeItem
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>items</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.core.Control[]} an array of the removed elements (might be empty)
 * @public
 * @name sap.m.FlexBox#removeAllItems
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.core.Control</code> in the aggregation named <code>items</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.core.Control}
 *            oItem the item whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @name sap.m.FlexBox#indexOfItem
 * @function
 */
	

/**
 * Destroys all the items in the aggregation 
 * named <code>items</code>.
 * @return {sap.m.FlexBox} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.FlexBox#destroyItems
 * @function
 */


// Start of sap\m\FlexBox.js


sap.m.FlexBox.prototype.init = function() {
	// Make sure that HBox and VBox have a valid direction
	if(this instanceof sap.m.HBox && (this.getDirection() !== "Row" || this.getDirection() !== "RowReverse")) {
		this.setDirection('Row');
	}
	if(this instanceof sap.m.VBox && (this.getDirection() !== "Column" || this.getDirection() !== "ColumnReverse")) {
		this.setDirection('Column');
	}
};

sap.m.FlexBox.prototype.setDisplayInline = function(bInline) {
	var sDisplay = "";

	this.setProperty("displayInline", bInline, false);
	if(bInline) {
		sDisplay = "inline-flex";
	} else {
		sDisplay = "flex";
	}
	sap.m.FlexBoxStylingHelper.setStyle(null, this, "display", sDisplay);
	return this;
};

sap.m.FlexBox.prototype.setDirection = function(sValue) {
	this.setProperty("direction", sValue, false);
	sap.m.FlexBoxStylingHelper.setStyle(null, this, "flex-direction", sValue);
	return this;
};

sap.m.FlexBox.prototype.setFitContainer = function(sValue) {
	if(sValue && !(this.getParent() instanceof sap.m.FlexBox)) {
		jQuery.sap.log.info("FlexBox fitContainer set to true. Remember, if the FlexBox is inserted into a Page, the property 'enableScrolling' of the Page needs to be set to 'false' for the FlexBox to fit the entire viewport.");
		var $flexContainer = this.$();
		$flexContainer.css("width", "auto");
		$flexContainer.css("height", "100%");
	}
	
	this.setProperty("fitContainer", sValue, false);

	return this;
};

//TODO Enable wrapping when any browser supports it
/*sap.m.FlexBox.prototype.setJustifyContent = function(sValue) {
	this.setProperty("wrap", sValue, true);
	sap.m.FlexBoxStylingHelper.setStyle(null, this, "flex-wrap", sValue);
	return this;
}*/

sap.m.FlexBox.prototype.setJustifyContent = function(sValue) {
	this.setProperty("justifyContent", sValue, false);
	sap.m.FlexBoxStylingHelper.setStyle(null, this, "justify-content", sValue);
	return this;
};

sap.m.FlexBox.prototype.setAlignItems = function(sValue) {
	this.setProperty("alignItems", sValue, false);
	sap.m.FlexBoxStylingHelper.setStyle(null, this, "align-items", sValue);
	return this;
};

sap.m.FlexBox.prototype.setAlignContent = function(sValue) {
	this.setProperty("alignContent", sValue, false);
	sap.m.FlexBoxStylingHelper.setStyle(null, this, "align-content", sValue);
	return this;
};

sap.m.FlexBox.prototype.onAfterRendering = function() {
	if(jQuery.support.useFlexBoxPolyfill) {
		// Check for parent FlexBoxes. Size calculations need to be made from top to bottom
		// while the renderer goes from bottom to top.
		var currentElement = this;
		var parent = null;
		jQuery.sap.log.info("Check #"+currentElement.getId()+" for nested FlexBoxes");

		for (parent = currentElement.getParent();
			parent !== null && parent !== undefined && 
			(parent instanceof sap.m.FlexBox
			|| (parent.getLayoutData() !== null && parent.getLayoutData() instanceof sap.m.FlexItemData));
			) {
			currentElement = parent;
			parent = currentElement.getParent();
		}

		this.sanitizeChildren(this);
		this.renderFlexBoxPolyFill();
	}
};

/*
 * @private
 */
sap.m.FlexBox.prototype.sanitizeChildren = function(oControl) {
	// Check the flex items
	var aChildren = oControl.getItems();
	for (var i = 0; i < aChildren.length; i++) {
		if(aChildren[i].getVisible === undefined || aChildren[i].getVisible()) {
			var $child = "";
			if(aChildren[i] instanceof sap.m.FlexBox) {
				$child = aChildren[i].$();
			} else {
				$child = aChildren[i].$().parent();	// Get wrapper <div>
			}
			var domchild =  aChildren[i].getDomRef();
			$child.width("auto");
			//$child.height("100%");
			if(aChildren[i] instanceof sap.m.FlexBox) {
				this.sanitizeChildren(aChildren[i]);
			}
		}
	}
};

/*
 * @private
 */
sap.m.FlexBox.prototype.renderFlexBoxPolyFill = function() {
	var flexMatrix = [];
	var ordinalMatrix = [];

	// Prepare flex and ordinal matrix
	var aChildren = this.getItems();
	for (var i = 0; i < aChildren.length; i++) {
		// If no visible property or if visible
		if(aChildren[i].getVisible === undefined || aChildren[i].getVisible()) {
			// Get layout properties
			var oLayoutData = aChildren[i].getLayoutData();

			if(oLayoutData !== "undefined" && oLayoutData !== null && oLayoutData instanceof sap.m.FlexItemData) {
				if(oLayoutData.getGrowFactor() !== 1) {
					flexMatrix.push(oLayoutData.getGrowFactor());
				} else {
					flexMatrix.push(1);		// default value
				}
				if(oLayoutData.getOrder() != 0) {
					ordinalMatrix.push(oLayoutData.getOrder());
				} else {
					ordinalMatrix.push(0);	// default value
				}
			}
		}
	}

	if(flexMatrix.length === 0) flexMatrix = null;
	if(ordinalMatrix.length === 0) ordinalMatrix = null;

	if(this.getFitContainer()) {
		// Call setter for fitContainer to apply the appropriate styles which are normally applied by the FlexBoxStylingHelper
		this.setFitContainer(true);
	}

	var oSettings = {
	    direction : this.getDirection(),
	    alignItems : this.getAlignItems(),
	    justifyContent : this.getJustifyContent(),
	    flexMatrix : flexMatrix,
	    ordinalMatrix : ordinalMatrix
	};

	sap.m.FlexBoxStylingHelper.applyFlexBoxPolyfill(this.getId(), oSettings);
};
}; // end of sap/m/FlexBox.js
if ( !jQuery.sap.isDeclared('sap.m.FlexBoxRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare("sap.m.FlexBoxRenderer");

/**
 * @class FlexBox renderer
 * @static
 */
sap.m.FlexBoxRenderer = {};


/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.m.FlexBoxRenderer.render = function(oRm, oControl) {
	// Return immediately if control is invisible
	if (!oControl.getVisible()) {
		return;
	}
	
	if (!jQuery.support.flexBoxLayout && !jQuery.support.newFlexBoxLayout && !jQuery.support.ie10FlexBoxLayout) {
		jQuery.sap.log.warning("This browser does not support Flexible Box Layouts natively.");
		sap.m.FlexBoxRenderer.usePolyfill = true;
	}

	// Make sure HBox and VBox don't get the wrong direction and get the appropriate class
	var hvClass = "";
	if(oControl.getDirection() === "Row" || oControl.getDirection() === "RowReverse") {
		if(oControl instanceof sap.m.VBox) {
			jQuery.sap.log.error("Flex direction cannot be set to Row or RowReverse on VBox controls.");
		} else {
			hvClass = "sapMHBox";
		}
	} else if(oControl.getDirection() === "Column" || oControl.getDirection() === "ColumnReverse"){
		if(oControl instanceof sap.m.HBox) {
			jQuery.sap.log.error("Flex direction cannot be set to Column or ColumnReverse on HBox controls.");
		} else {
			hvClass = "sapMVBox";
		}
	}

	// Special treatment if FlexBox is itself an item of a parent FlexBox
	var oParent = oControl.getParent();
	if(oControl.getParent() instanceof sap.m.FlexBox) {
		oRm.addClass("sapMFlexItem");


		// Set layout properties
		var oLayoutData = oControl.getLayoutData();
		if(oLayoutData instanceof sap.m.FlexItemData && !sap.m.FlexBoxRenderer.usePolyfill) {
			sap.m.FlexBoxStylingHelper.setFlexItemStyles(oRm, oLayoutData);
		}

		if(oParent.getRenderType() === 'List') {
			oRm.write('<li');
			oRm.writeClasses();
			oRm.writeStyles();
		}
	}

	if(oControl.getRenderType() === 'List') {
		oRm.write('<ul');
	} else {
		oRm.write('<div');
	}

	oRm.writeControlData(oControl);
	oRm.addClass("sapMFlexBox");
	oRm.addClass(hvClass);
	oRm.writeClasses();
	oRm.addStyle("width", oControl.getWidth());
	oRm.addStyle("height", oControl.getHeight());
	if(!sap.m.FlexBoxRenderer.usePolyfill) {
		sap.m.FlexBoxStylingHelper.setFlexBoxStyles(oRm, oControl);
	}
	oRm.writeStyles();
	var sTooltip = oControl.getTooltip_AsString();
	if (sTooltip) {
		oRm.writeAttributeEscaped("title", sTooltip);
	}
	oRm.write(">");

	// Now render the flex items
	var aChildren = oControl.getItems();
	var bWrapItem = true;
	for (var i = 0; i < aChildren.length; i++) {
		// Don't wrap if it's a FlexBox control or if it's not visible
		if(aChildren[i] instanceof sap.m.FlexBox || (aChildren[i].getVisible !== undefined && !aChildren[i].getVisible())) {
			bWrapItem = false;
		} else {
			bWrapItem = true;
		}

		// Create wrapper if it's not a FlexBox control
		if(bWrapItem) {
			if(oControl.getRenderType() === 'List') {
				oRm.write('<li');
			} else {
				oRm.write('<div');
			}

			// Set layout properties
			var oLayoutData = aChildren[i].getLayoutData();
			if(oLayoutData instanceof sap.m.FlexItemData) {
				if(oLayoutData.getId()) {
					oRm.write(" id='" + oLayoutData.getId() + "'");
				}
				if(oLayoutData.getStyleClass()) {
					oRm.addClass(oLayoutData.getStyleClass());
				}

				if(!sap.m.FlexBoxRenderer.usePolyfill) {
					sap.m.FlexBoxStylingHelper.setFlexItemStyles(oRm, oLayoutData);
				}

				// ScrollContainer needs height:100% on the flex item
				if(aChildren[i] instanceof sap.m.ScrollContainer) {
					oRm.addStyle("height", "100%");
				}
				oRm.writeStyles();
			}

			oRm.addClass("sapMFlexItem");
			oRm.writeClasses();
			oRm.write(">");
		}

		// Render control
		oRm.renderControl(aChildren[i]);

		if(bWrapItem) {
			// Close wrapper
			if(oControl.getRenderType() === 'List') {
				oRm.write('</li>');
			} else {
				oRm.write('</div>');
			}
		}
	}

	// Close the flexbox
	if(oControl.getRenderType() === "List") {
		oRm.write("</ul>");
	} else {
		oRm.write("</div>");
	}
};
}; // end of sap/m/FlexBoxRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.FlexItemData') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.m.FlexItemData.
jQuery.sap.declare("sap.m.FlexItemData");

jQuery.sap.require('sap.ui.core.LayoutData'); // unlisted dependency retained



/**
 * Constructor for a new FlexItemData.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getAlignSelf alignSelf} : sap.m.FlexAlignSelf (default: sap.m.FlexAlignSelf.Auto)</li>
 * <li>{@link #getOrder order} : int (default: 0)</li>
 * <li>{@link #getGrowFactor growFactor} : float (default: 0)</li>
 * <li>{@link #getStyleClass styleClass} : string (default: '')</li></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 
 *
 * 
 * In addition, all settings applicable to the base type {@link sap.ui.core.LayoutData#constructor sap.ui.core.LayoutData}
 * can be used as well.
 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * Holds layout data for a FlexBox
 * @extends sap.ui.core.LayoutData
 *
 * @author  
 * @version 1.20.6
 *
 * @constructor   
 * @public
 * @name sap.m.FlexItemData
 */
sap.ui.core.LayoutData.extend("sap.m.FlexItemData", { metadata : {

	// ---- object ----

	// ---- control specific ----
	library : "sap.m",
	properties : {
		"alignSelf" : {type : "sap.m.FlexAlignSelf", group : "Misc", defaultValue : sap.m.FlexAlignSelf.Auto},
		"order" : {type : "int", group : "Misc", defaultValue : 0},
		"growFactor" : {type : "float", group : "Misc", defaultValue : 0},
		"styleClass" : {type : "string", group : "Misc", defaultValue : '', deprecated: true}
	}
}});


/**
 * Creates a new subclass of class sap.m.FlexItemData with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.m.FlexItemData.extend
 * @function
 */


/**
 * Getter for property <code>alignSelf</code>.
 * Determines cross-axis alignment of individual element (not currently supported in Internet Explorer)
 *
 * Default value is <code>Auto</code>
 *
 * @return {sap.m.FlexAlignSelf} the value of property <code>alignSelf</code>
 * @public
 * @name sap.m.FlexItemData#getAlignSelf
 * @function
 */

/**
 * Setter for property <code>alignSelf</code>.
 *
 * Default value is <code>Auto</code> 
 *
 * @param {sap.m.FlexAlignSelf} oAlignSelf  new value for property <code>alignSelf</code>
 * @return {sap.m.FlexItemData} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.FlexItemData#setAlignSelf
 * @function
 */


/**
 * Getter for property <code>order</code>.
 * Determines the display order of flex items independent of their source code order.
 *
 * Default value is <code>0</code>
 *
 * @return {int} the value of property <code>order</code>
 * @public
 * @name sap.m.FlexItemData#getOrder
 * @function
 */

/**
 * Setter for property <code>order</code>.
 *
 * Default value is <code>0</code> 
 *
 * @param {int} iOrder  new value for property <code>order</code>
 * @return {sap.m.FlexItemData} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.FlexItemData#setOrder
 * @function
 */


/**
 * Getter for property <code>growFactor</code>.
 * Determines the flexibility of the flex item when allocatable space is remaining.
 *
 * Default value is <code>0</code>
 *
 * @return {float} the value of property <code>growFactor</code>
 * @public
 * @name sap.m.FlexItemData#getGrowFactor
 * @function
 */

/**
 * Setter for property <code>growFactor</code>.
 *
 * Default value is <code>0</code> 
 *
 * @param {float} fGrowFactor  new value for property <code>growFactor</code>
 * @return {sap.m.FlexItemData} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.FlexItemData#setGrowFactor
 * @function
 */


/**
 * Getter for property <code>styleClass</code>.
 * The style class will be applied to the flex item and can be used for CSS selectors
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>styleClass</code>
 * @public
 * @deprecated Since version 1.11.2. 
 * Generic addStyleClass method is available on the control
 * @name sap.m.FlexItemData#getStyleClass
 * @function
 */

/**
 * Setter for property <code>styleClass</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sStyleClass  new value for property <code>styleClass</code>
 * @return {sap.m.FlexItemData} <code>this</code> to allow method chaining
 * @public
 * @deprecated Since version 1.11.2. 
 * Generic addStyleClass method is available on the control
 * @name sap.m.FlexItemData#setStyleClass
 * @function
 */


// Start of sap\m\FlexItemData.js


sap.m.FlexItemData.prototype.setAlignSelf = function(sValue) {
	this.setProperty("alignSelf", sValue);
	sap.m.FlexBoxStylingHelper.setStyle(null, this, "align-self", sValue);
	return this;
};

sap.m.FlexItemData.prototype.setOrder = function(sValue) {
	this.setProperty("order", sValue);
	sap.m.FlexBoxStylingHelper.setStyle(null, this, "order", sValue);
	return this;
};

sap.m.FlexItemData.prototype.setGrowFactor = function(sValue) {
	this.setProperty("growFactor", sValue);
	sap.m.FlexBoxStylingHelper.setStyle(null, this, "flex-grow", sValue);
	return this;
};

//TODO Uncomment when property is supported by any browser
/*sap.m.FlexItemData.prototype.setShrinkFactor = function(sValue) {
	this.setProperty("shrinkFactor", sValue, true);
	sap.m.FlexBoxStylingHelper.setStyle(null, this, "flex-shrink", sValue);
	return this;
};*/

//TODO Uncomment when property is supported by any browser
/*sap.m.FlexItemData.prototype.setBaseSize = function(sValue) {
	this.setProperty("baseSize", sValue, true);
	sap.m.FlexBoxStylingHelper.setStyle(null, this, "flex-basis", sValue);
	return this;
};*/

}; // end of sap/m/FlexItemData.js
if ( !jQuery.sap.isDeclared('sap.m.GroupHeaderListItemRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare("sap.m.GroupHeaderListItemRenderer");
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained



/**
 * @class GroupHeaderListItem renderer.
 * @static
 */
sap.m.GroupHeaderListItemRenderer = sap.ui.core.Renderer.extend(sap.m.ListItemBaseRenderer);

/**
 * Renders the attributes for the given list item, using the provided
 * {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager}
 *          rm the RenderManager that can be used for writing to the
 *          Render-Output-Buffer
 * @param {sap.ui.core.Control}
 *          oLI an object representation of the list item that should be
 *          rendered
 */
sap.m.GroupHeaderListItemRenderer.renderLIAttributes = function(rm, oLI) {
	rm.addClass("sapMGHLI");
	if (oLI.getUpperCase()) {
		rm.addClass("sapMGHLIUpperCase");
	}
};


/**
 * Renders the List item content
 *
 * @param {sap.ui.core.RenderManager}
 *          rm the RenderManager that can be used for writing to the
 *          Render-Output-Buffer
 * @param {sap.ui.core.Control}
 *          oLI an object representation of the list item that should be
 *          rendered
 * @param {sap.m.Table} [oTable]
 *          If this control is inside the table then this param can be used for col spanning
 */
sap.m.GroupHeaderListItemRenderer.renderLIContent = function(rm, oLI, oTable) {
	var sTitle = oLI.getTitle();
	oTable && rm.write("<td class='sapMGHLICell' colspan='" + (oTable.getColSpan()) + "'>");

	// List item label
	if (sTitle) {
		oTable && rm.write("<div class='sapMLIBContent sapMLIBContentMargin'>");
		rm.write("<label for='" + oLI.getId() + "-value' class='sapMGHLITitle'>");
		rm.writeEscaped(sTitle);

		var iCount = oLI.getCount();
		if (iCount !== undefined && iCount !== "") {
			rm.writeEscaped(" (" + iCount + ")");
		}

		rm.write("</label>");
		oTable && rm.write("</div>");
	}

	oTable && rm.write("</td>");
};

}; // end of sap/m/GroupHeaderListItemRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.GrowingListRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare("sap.m.GrowingListRenderer");
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained




/**
 * @class GrowingList renderer.
 * @static
 */
sap.m.GrowingListRenderer = sap.ui.core.Renderer.extend(sap.m.ListRenderer);

sap.m.GrowingListRenderer.render = function(rm, oControl) {
	/**
	 * For backwards compatibility we can't remove GrowingList control
	 * However, if the compatibility version is 1.16 or higher then
	 * we stop rendering to force using List control with growing feature
	 */
	if (oControl._isIncompatible()) {
		jQuery.sap.log.warning("Does not render sap.m.GrowingList#" + oControl.getId() + " when compatibility version is 1.16 or higher. Instead use sap.m.List/Table control with growing feature!");
	} else {
		sap.m.ListRenderer.render.call(this, rm, oControl);
	}
};

}; // end of sap/m/GrowingListRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.HBox') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.m.HBox.
jQuery.sap.declare("sap.m.HBox");




/**
 * Constructor for a new HBox.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 
 *
 * 
 * In addition, all settings applicable to the base type {@link sap.m.FlexBox#constructor sap.m.FlexBox}
 * can be used as well.
 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * The HBox control builds the container for a horizontal flexible box layout. HBox is a convenience control as it is just a specialized FlexBox control.
 * 
 * Browser support:
 * This control is not supported in Internet Explorer 9!
 * @extends sap.m.FlexBox
 *
 * @author SAP AG 
 * @version 1.20.6
 *
 * @constructor   
 * @public
 * @name sap.m.HBox
 */
sap.m.FlexBox.extend("sap.m.HBox", { metadata : {

	// ---- object ----

	// ---- control specific ----
	library : "sap.m"
}});


/**
 * Creates a new subclass of class sap.m.HBox with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.m.HBox.extend
 * @function
 */


// Start of sap\m\HBox.js

}; // end of sap/m/HBox.js
if ( !jQuery.sap.isDeclared('sap.m.HBoxRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare("sap.m.HBoxRenderer");


/**
 * @class HBox renderer.
 * @static
 */
sap.m.HBoxRenderer = {
};


/**
 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
 *
 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the render output buffer
 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
 */
sap.m.HBoxRenderer.render = function(oRm, oControl){
	sap.m.FlexBoxRenderer.render.apply(this, [oRm, oControl]);
};

}; // end of sap/m/HBoxRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.IconTabBar') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.m.IconTabBar.
jQuery.sap.declare("sap.m.IconTabBar");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new IconTabBar.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getShowSelection showSelection} : boolean (default: true)</li>
 * <li>{@link #getExpandable expandable} : boolean (default: true)</li>
 * <li>{@link #getExpanded expanded} : boolean (default: true)</li>
 * <li>{@link #getSelectedKey selectedKey} : string</li>
 * <li>{@link #getVisible visible} : boolean (default: true)</li></ul>
 * </li>
 * <li>Aggregations
 * <ul>
 * <li>{@link #getItems items} : sap.m.IconTab[]</li>
 * <li>{@link #getContent content} : sap.ui.core.Control[]</li></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul>
 * <li>{@link sap.m.IconTabBar#event:select select} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li>
 * <li>{@link sap.m.IconTabBar#event:expand expand} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * A tab bar with large icons
 * @extends sap.ui.core.Control
 *
 * @author SAP AG 
 * @version 1.20.6
 *
 * @constructor   
 * @public
 * @name sap.m.IconTabBar
 */
sap.ui.core.Control.extend("sap.m.IconTabBar", { metadata : {

	// ---- object ----

	// ---- control specific ----
	library : "sap.m",
	properties : {
		"showSelection" : {type : "boolean", group : "Misc", defaultValue : true, deprecated: true},
		"expandable" : {type : "boolean", group : "Misc", defaultValue : true},
		"expanded" : {type : "boolean", group : "Misc", defaultValue : true},
		"selectedKey" : {type : "string", group : "Data", defaultValue : null},
		"visible" : {type : "boolean", group : "Behavior", defaultValue : true}
	},
	aggregations : {
    	"items" : {type : "sap.m.IconTab", multiple : true, singularName : "item"}, 
    	"content" : {type : "sap.ui.core.Control", multiple : true, singularName : "content"}
	},
	events : {
		"select" : {}, 
		"expand" : {}
	}
}});


/**
 * Creates a new subclass of class sap.m.IconTabBar with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.m.IconTabBar.extend
 * @function
 */

sap.m.IconTabBar.M_EVENTS = {'select':'select','expand':'expand'};


/**
 * Getter for property <code>showSelection</code>.
 * Defines whether the current selection should be visualized
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>showSelection</code>
 * @public
 * @deprecated Since version 1.15.0. 
 * Regarding to changes of this control this property is not needed anymore.
 * @name sap.m.IconTabBar#getShowSelection
 * @function
 */

/**
 * Setter for property <code>showSelection</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bShowSelection  new value for property <code>showSelection</code>
 * @return {sap.m.IconTabBar} <code>this</code> to allow method chaining
 * @public
 * @deprecated Since version 1.15.0. 
 * Regarding to changes of this control this property is not needed anymore.
 * @name sap.m.IconTabBar#setShowSelection
 * @function
 */


/**
 * Getter for property <code>expandable</code>.
 * Defines if the tabs can be collapsed and expanded
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>expandable</code>
 * @public
 * @since 1.15.0
 * @name sap.m.IconTabBar#getExpandable
 * @function
 */

/**
 * Setter for property <code>expandable</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bExpandable  new value for property <code>expandable</code>
 * @return {sap.m.IconTabBar} <code>this</code> to allow method chaining
 * @public
 * @since 1.15.0
 * @name sap.m.IconTabBar#setExpandable
 * @function
 */


/**
 * Getter for property <code>expanded</code>.
 * Indicates if the actual tab is expanded or not
 * 
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>expanded</code>
 * @public
 * @since 1.15.0
 * @name sap.m.IconTabBar#getExpanded
 * @function
 */

/**
 * Setter for property <code>expanded</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bExpanded  new value for property <code>expanded</code>
 * @return {sap.m.IconTabBar} <code>this</code> to allow method chaining
 * @public
 * @since 1.15.0
 * @name sap.m.IconTabBar#setExpanded
 * @function
 */


/**
 * Getter for property <code>selectedKey</code>.
 * Key of the selected item.
 * 
 * If the key has no corresponding aggregated item, no changes will apply.
 * If duplicate keys exists the first item matching the key is used.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>selectedKey</code>
 * @public
 * @since 1.15.0
 * @name sap.m.IconTabBar#getSelectedKey
 * @function
 */

/**
 * Setter for property <code>selectedKey</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sSelectedKey  new value for property <code>selectedKey</code>
 * @return {sap.m.IconTabBar} <code>this</code> to allow method chaining
 * @public
 * @since 1.15.0
 * @name sap.m.IconTabBar#setSelectedKey
 * @function
 */


/**
 * Getter for property <code>visible</code>.
 * Invisible controls are not rendered
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>visible</code>
 * @public
 * @since 1.15.0
 * @name sap.m.IconTabBar#getVisible
 * @function
 */

/**
 * Setter for property <code>visible</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bVisible  new value for property <code>visible</code>
 * @return {sap.m.IconTabBar} <code>this</code> to allow method chaining
 * @public
 * @since 1.15.0
 * @name sap.m.IconTabBar#setVisible
 * @function
 */


/**
 * Getter for aggregation <code>items</code>.<br/>
 * The items displayed in the IconTabBar
 * 
 * @return {sap.m.IconTab[]}
 * @public
 * @name sap.m.IconTabBar#getItems
 * @function
 */


/**
 * Inserts a item into the aggregation named <code>items</code>.
 *
 * @param {sap.m.IconTab}
 *          oItem the item to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the item should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the item is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the item is inserted at 
 *             the last position        
 * @return {sap.m.IconTabBar} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.IconTabBar#insertItem
 * @function
 */

/**
 * Adds some item <code>oItem</code> 
 * to the aggregation named <code>items</code>.
 *
 * @param {sap.m.IconTab}
 *            oItem the item to add; if empty, nothing is inserted
 * @return {sap.m.IconTabBar} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.IconTabBar#addItem
 * @function
 */

/**
 * Removes an item from the aggregation named <code>items</code>.
 *
 * @param {int | string | sap.m.IconTab} vItem the item to remove or its index or id
 * @return {sap.m.IconTab} the removed item or null
 * @public
 * @name sap.m.IconTabBar#removeItem
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>items</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.m.IconTab[]} an array of the removed elements (might be empty)
 * @public
 * @name sap.m.IconTabBar#removeAllItems
 * @function
 */

/**
 * Checks for the provided <code>sap.m.IconTab</code> in the aggregation named <code>items</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.m.IconTab}
 *            oItem the item whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @name sap.m.IconTabBar#indexOfItem
 * @function
 */
	

/**
 * Destroys all the items in the aggregation 
 * named <code>items</code>.
 * @return {sap.m.IconTabBar} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.IconTabBar#destroyItems
 * @function
 */


/**
 * Getter for aggregation <code>content</code>.<br/>
 * The contents displayed below the IconTabBar.
 * If there are multiple contents, they are rendered after each other. The developer has to manage to display the right one or use the content aggregation inside the IconTabFilter (which will be displayed instead if it is set).
 * 
 * @return {sap.ui.core.Control[]}
 * @public
 * @name sap.m.IconTabBar#getContent
 * @function
 */


/**
 * Inserts a content into the aggregation named <code>content</code>.
 *
 * @param {sap.ui.core.Control}
 *          oContent the content to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the content should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the content is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the content is inserted at 
 *             the last position        
 * @return {sap.m.IconTabBar} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.IconTabBar#insertContent
 * @function
 */

/**
 * Adds some content <code>oContent</code> 
 * to the aggregation named <code>content</code>.
 *
 * @param {sap.ui.core.Control}
 *            oContent the content to add; if empty, nothing is inserted
 * @return {sap.m.IconTabBar} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.IconTabBar#addContent
 * @function
 */

/**
 * Removes an content from the aggregation named <code>content</code>.
 *
 * @param {int | string | sap.ui.core.Control} vContent the content to remove or its index or id
 * @return {sap.ui.core.Control} the removed content or null
 * @public
 * @name sap.m.IconTabBar#removeContent
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>content</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.core.Control[]} an array of the removed elements (might be empty)
 * @public
 * @name sap.m.IconTabBar#removeAllContent
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.core.Control</code> in the aggregation named <code>content</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.core.Control}
 *            oContent the content whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @name sap.m.IconTabBar#indexOfContent
 * @function
 */
	

/**
 * Destroys all the content in the aggregation 
 * named <code>content</code>.
 * @return {sap.m.IconTabBar} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.IconTabBar#destroyContent
 * @function
 */


/**
 * This event will be fired when an item is selected. 
 *
 * @name sap.m.IconTabBar#select
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters

 * @param {sap.m.IconTabFilter} oControlEvent.getParameters.item The selected item.
 * @param {string} oControlEvent.getParameters.key The key of the selected item.
 * @param {sap.m.IconTabFilter} oControlEvent.getParameters.selectedItem This parameter is deprecated since 1.15.0! Please use parameter "item" instead.
 * @param {string} oControlEvent.getParameters.selectedKey This parameter is deprecated since 1.15.0! Please use parameter "key" instead.
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'select' event of this <code>sap.m.IconTabBar</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.m.IconTabBar</code>.<br/> itself. 
 *  
 * This event will be fired when an item is selected. 
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.m.IconTabBar</code>.<br/> itself.
 *
 * @return {sap.m.IconTabBar} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.IconTabBar#attachSelect
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'select' event of this <code>sap.m.IconTabBar</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.m.IconTabBar} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.IconTabBar#detachSelect
 * @function
 */

/**
 * Fire event select to attached listeners.
 * 
 * Expects following event parameters:
 * <ul>
 * <li>'item' of type <code>sap.m.IconTabFilter</code> The selected item.</li>
 * <li>'key' of type <code>string</code> The key of the selected item.</li>
 * <li>'selectedItem' of type <code>sap.m.IconTabFilter</code> This parameter is deprecated since 1.15.0! Please use parameter "item" instead.</li>
 * <li>'selectedKey' of type <code>string</code> This parameter is deprecated since 1.15.0! Please use parameter "key" instead.</li>
 * </ul>
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.m.IconTabBar} <code>this</code> to allow method chaining
 * @protected
 * @name sap.m.IconTabBar#fireSelect
 * @function
 */


/**
 * Indicates that the tab will expand or collapse 
 *
 * @name sap.m.IconTabBar#expand
 * @event
 * @since 1.15.0
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters

 * @param {boolean} oControlEvent.getParameters.expand If the tab will expand, this is true.
 * @param {boolean} oControlEvent.getParameters.collapse If the tab will collapse, this is true.
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'expand' event of this <code>sap.m.IconTabBar</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.m.IconTabBar</code>.<br/> itself. 
 *  
 * Indicates that the tab will expand or collapse 
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.m.IconTabBar</code>.<br/> itself.
 *
 * @return {sap.m.IconTabBar} <code>this</code> to allow method chaining
 * @public
 * @since 1.15.0
 * @name sap.m.IconTabBar#attachExpand
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'expand' event of this <code>sap.m.IconTabBar</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.m.IconTabBar} <code>this</code> to allow method chaining
 * @public
 * @since 1.15.0
 * @name sap.m.IconTabBar#detachExpand
 * @function
 */

/**
 * Fire event expand to attached listeners.
 * 
 * Expects following event parameters:
 * <ul>
 * <li>'expand' of type <code>boolean</code> If the tab will expand, this is true.</li>
 * <li>'collapse' of type <code>boolean</code> If the tab will collapse, this is true.</li>
 * </ul>
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.m.IconTabBar} <code>this</code> to allow method chaining
 * @protected
 * @since 1.15.0
 * @name sap.m.IconTabBar#fireExpand
 * @function
 */


// Start of sap\m\IconTabBar.js
jQuery.sap.require('sap.ui.core.delegate.ItemNavigation'); // unlisted dependency retained

jQuery.sap.require('sap.ui.core.EnabledPropagator'); // unlisted dependency retained

sap.ui.core.EnabledPropagator.apply(sap.m.IconTabBar.prototype, [true]);


sap.m.IconTabBar.SCROLL_STEP = 264; // how many pixels to scroll with every overflow arrow click

/**
 * Init
 */
sap.m.IconTabBar.prototype.init = function() {
	this._bPreviousScrollForward = false; // remember the item overflow state
	this._bPreviousScrollBack = false;
	this._iCurrentScrollLeft = 0;
	this._bRtl = sap.ui.getCore().getConfiguration().getRTL();
	
	this.startScrollX = 0;
	this.startTouchX = 0;
	this._scrollable = null;
	
	this._aTabKeys = [];

	// Initialize the ItemNavigation
	this._oItemNavigation = new sap.ui.core.delegate.ItemNavigation().setCycling(false);
	this.addDelegate(this._oItemNavigation);

	if (!sap.ui.Device.system.desktop || (sap.ui.Device.os.windows && sap.ui.Device.os.version === 8)) {
		jQuery.sap.require("sap.ui.core.delegate.ScrollEnablement");
		this._oScroller = new sap.ui.core.delegate.ScrollEnablement(this, this.getId() + "-head", {
			horizontal: true,
			vertical: false,
			zynga: false,
			iscroll: "force",
			preventDefault: false,
			nonTouchScrolling: "scrollbar"
		});
	}

};

/**
 * Exit
 */
sap.m.IconTabBar.prototype.exit = function() {
	if (this._oArrowLeft) {
		this._oArrowLeft.destroy();
	}
	if (this._oArrowRight) {
		this._oArrowRight.destroy();
	}

	if (this._oItemNavigation) {
		this.removeDelegate(this._oItemNavigation);
		this._oItemNavigation.destroy();
		delete this._oItemNavigation;
	}

	if (this._oScroller){
		this._oScroller.destroy();
		this._oScroller = null;
	}

	if (this._sResizeListenerId) {
		sap.ui.core.ResizeHandler.deregister(this._sResizeListenerId);
		this._sResizeListenerId = null;
	}
	if (this._aTabKeys) {
		this._aTabKeys = null;
	}
};

/**
 * Before Rendering
 */
sap.m.IconTabBar.prototype.onBeforeRendering = function() {
	var aItems = this.getItems(),
		sSelectedKey = this.getSelectedKey(),
		i = 0;

	if (this._sResizeListenerId) {
		sap.ui.core.ResizeHandler.deregister(this._sResizeListenerId);
		this._sResizeListenerId = null;
	}

	if (aItems.length > 0) {
		if (!this.oSelectedItem || sSelectedKey && sSelectedKey !== this.oSelectedItem.getKey()) {
			if (sSelectedKey) {
				// selected key was specified by API: set oSelectedItem to the item specified by key
				for (; i < aItems.length; i++) {
					if (!(aItems[i] instanceof sap.m.IconTabSeparator) && aItems[i].getKey() === sSelectedKey) {
						this.oSelectedItem = aItems[i];
						break;
					}
				}
			}

			// no key and no item, we set the first visible item as selected if container is not explicitly set to collapsed
			if (!this.oSelectedItem && this.getExpanded()) {
				for (i = 0; i < aItems.length; i++) { // tab item
					if (!(aItems[i] instanceof sap.m.IconTabSeparator) && aItems[i].getVisible()) {
						this.oSelectedItem = aItems[i];
						break;
					}
				}
			}
		}

		//in case the selected tab is not visible anymore and the content is expanded, the selected tab will change to the first visible tab
		if (this.oSelectedItem && !this.oSelectedItem.getVisible() && this.getExpanded()) {
			for (i = 0; i < aItems.length; i++) { // tab item
				if (!(aItems[i] instanceof sap.m.IconTabSeparator) && aItems[i].getVisible()) {
					this.oSelectedItem = aItems[i];
					break;
				}
			}
		}

		if (this.oSelectedItem) {
			this.setProperty("selectedKey", this.oSelectedItem.getKey(), true);
		}
	}
};

/**
 * Sets the selected item based on key
 * @overwrite
 * @public
 * @param {string} sKey the key of the item to be selected
 * @return {sap.m.IconTabBar} this pointer for chaining
 */
sap.m.IconTabBar.prototype.setSelectedKey = function (sKey) {
	var aItems = this.getItems(),
		i = 0;

	// adjust UI and internal variables if already rendered (otherwise taken care by onBeforeRendering)
	if (this.$().length) {
		for (; i < aItems.length; i++) {
			if (!(aItems[i] instanceof sap.m.IconTabSeparator) && aItems[i].getKey() === sKey) {
				this.setSelectedItem(aItems[i], true);
				break;
			}
		}
	}

	// set internal property
	this.setProperty("selectedKey", sKey, true);
	return this;
};


/**
 * Sets the expanded flag and toggles the expand/collapse animation if the control is already rendered
 * @overwrite
 * @public
 * @param {boolean} bExpanded new parameter value
 * @return {sap.m.IconTabBar} this pointer for chaining
 */
sap.m.IconTabBar.prototype.setExpanded = function (bExpanded) {
	// set internal property
	this.setProperty("expanded", bExpanded, true);

	// toggle animation if control is already rendered
	if (this.$().length) {
		this._toggleExpandCollapse(bExpanded);
	}
	return this;
};

/**
 * Sets the expandable flag without rerendering
 * @overwrite
 * @public
 * @param {boolean} bExpandable new parameter value
 * @return {sap.m.IconTabBar} this pointer for chaining
 */
sap.m.IconTabBar.prototype.setExpandable = function (bExpandable) {
	// set internal property
	this.setProperty("expandable", bExpandable, true);
	return this;
};

/*
 * Sets the selected item, updates the UI, and fires the select event
 * @private
 * @param {sap.m.IconTabFilter} oItem the item to be selected
 * @return {sap.m.IconTabBar} this pointer for chaining
 */
sap.m.IconTabBar.prototype.setSelectedItem = function(oItem, bAPIchange) {

	if (!oItem || !oItem.getEnabled()) {
		return this;
	}
	var $content = this.$("content");
	
	if (this.oSelectedItem && this.oSelectedItem.getVisible() && (this.getExpandable() || this.oSelectedItem !== oItem )) {
		this.oSelectedItem.$().removeClass("sapMITBSelected");
	}

	if (oItem.getVisible()) {
		//click on already selected item leads to expanding/collapsing of the content (if expandable enabled)
		if (this.oSelectedItem === oItem) {
			//if content is not expandable nothing should happen otherwise content will be expanded/collapsed
			if (this.getExpandable()) {
				this._toggleExpandCollapse();
			}
		//click on other item leads to showing the right content of this item
		} else {
			// set new item
			this.oSelectedItem = oItem;
			this.setProperty("selectedKey", this.oSelectedItem.getKey(), true);

			// add selected styles
			this.oSelectedItem.$().addClass("sapMITBSelected");

			//if item has own content, this content is shown
			var oSelectedItemContent = this.oSelectedItem.getContent();
			if (oSelectedItemContent.length > 0) {
				this._rerenderContent(oSelectedItemContent);
			//if item has not own content, general content of the icontabbar is shown
			} else {
				this._rerenderContent(this.getContent());
			}
			//if content is not expanded, content will be expanded (first click on item always leads to expanding the right content)
			if (this.getExpandable() && this.getExpanded() === false) {
				this._toggleExpandCollapse(true);
			}
			this._adjustArrow();
		}

		// scroll to item if out of viewport
		if (this.oSelectedItem.$().length > 0) {
			this._scrollIntoView(oItem, 500);
		} else {
			this._scrollAfterRendering = true;
		}
	}

	var sSelectedKey = this.oSelectedItem.getKey();
	this.oSelectedItem = oItem;
	this.setProperty("selectedKey", sSelectedKey, true);

	if (!bAPIchange) {
		this.fireSelect({
			selectedItem: this.oSelectedItem,
			selectedKey: sSelectedKey,
			item: this.oSelectedItem,
			key: sSelectedKey
		});
	}
	return this;
};

/**
 * Rerenders only shown content of the IconTabBar.
 * @private
 * @param oContent content which should be rendered.
 */
sap.m.IconTabBar.prototype._rerenderContent = function(oContent) {
	var $content = this.$("content");
	if (oContent && ($content.length > 0)) {
		var rm = sap.ui.getCore().createRenderManager();
		for (var i = 0; i < oContent.length; i++) {
			rm.renderControl(oContent[i]);
		}
		rm.flush($content[0]);
		rm.destroy();
	}
};

/**
 * Adjusts the arrow position.
 * @private
 */
sap.m.IconTabBar.prototype._adjustArrow = function(){
	var $arrow = this.$("contentArrow"),
		$head = this.$("head"),
		$item;

	if (this.getExpanded() === false) {
		return this; // no need of an arrow in this case
	}

	if (this.oSelectedItem) {
		$item = this.oSelectedItem.$();
		if ($item.length > 0) {
			//for scrolling we need to check if the new position is possible, if not, we hide the arrow but still show the old content
				if (this._bRtl){
					var iPossibleLeft = $head[0].offsetLeft;
					var iPossibleRight = document.width - iPossibleLeft - $arrow.width() / 2;
					var iRight = 0;
					var oDomRef = this.getDomRef("head");
					var iScrollRight = jQuery(oDomRef).scrollRightRTL();
					if (this.oSelectedItem.getDesign() === sap.m.IconTabFilterDesign.Vertical) {
						iRight = $arrow.parent().width() - $item[0].offsetLeft - $arrow.width() / 2 - $item.outerWidth() / 2 - $head[0].offsetLeft - iScrollRight;
					} else { //horizontal layout needs different arrow calculation
						iRight = $arrow.parent().width() - $item[0].offsetLeft - $arrow.width() / 2 - $item.outerWidth() + this.oSelectedItem.$("tab").outerWidth() / 2 - $head[0].offsetLeft - iScrollRight;
					}
					if (this._oScroller) {
						iRight += this._oScroller.getScrollLeft();
					}
					var aItems = this.getItems();
					if (((this.$("head").hasClass("sapMITBNoText") || this.oSelectedItem.$().hasClass("sapMITBHorizontal")) && ((this.oSelectedItem === aItems[0])))) {
						//first tab has less padding arrow would not point to the middle
						iRight -= 8;
					}
					$arrow.css("right", iRight + "px");
					$arrow.toggleClass("sapMITBNoContentArrow", iRight < iPossibleLeft || iRight > iPossibleRight);
				} else {
					var iPossibleLeft = $head[0].offsetLeft;
					var iPossibleRight = document.width - iPossibleLeft - $arrow.width() / 2;
					var oDomRef = this.getDomRef("head");
					var iLeft = 0;
					var iScrollLeft = oDomRef.scrollLeft;
					if (this.oSelectedItem.getDesign() === sap.m.IconTabFilterDesign.Vertical) {
						iLeft = $item[0].offsetLeft + $item.outerWidth() / 2 - $arrow.width() / 2 + $head[0].offsetLeft - iScrollLeft;
					} else { //horizontal layout needs different arrow calculation
						iLeft = $item[0].offsetLeft + this.oSelectedItem.$("tab").outerWidth() / 2- $arrow.width() / 2 + $head[0].offsetLeft - iScrollLeft;
					}
					if (this._oScroller) {
						iLeft -= this._oScroller.getScrollLeft();
					}
					var aItems = this.getItems();
					var oFirstVisibleItem = this._getFirstVisibleItem(aItems);
					if (((this.$("head").hasClass("sapMITBNoText") || this.oSelectedItem.$().hasClass("sapMITBHorizontal")) && ((this.oSelectedItem === oFirstVisibleItem)))
							|| ((aItems.length > 0) && (this.oSelectedItem === aItems[aItems.length-1])) && (!sap.ui.Device.system.desktop || sap.ui.Device.os.windows && sap.ui.Device.os.version === 8) && !this.oSelectedItem.$().hasClass("sapMITBHorizontal")) {
						//first tab has less padding, last tab has more padding arrow would not point to the middle
						iLeft -= 8;
					}
					if (this.oSelectedItem.$().hasClass("sapMITBHorizontal")) {
						iLeft += 8;
					}
					if ( (!sap.ui.Device.system.desktop || sap.ui.Device.os.windows && sap.ui.Device.os.version === 8) && !this.$("head").hasClass("sapMITBNoText")) {
						if (this.oSelectedItem === aItems[0]) {
							iLeft -= 2;
						} else if (this.oSelectedItem === aItems[aItems.length-1]) {
							iLeft += 2;
						}
					}
					$arrow.css("left", iLeft + "px");
					$arrow.toggleClass("sapMITBNoContentArrow", iLeft < iPossibleLeft || iLeft > iPossibleRight);
				}
		}
	}
};

/**
 * return first visible item, which is needed for correct arrow calculation
 */
sap.m.IconTabBar.prototype._getFirstVisibleItem = function(aItems) {
	for (var i = 0; i < aItems.length; i++) {
		if (aItems[i].getVisible()) {
			return aItems[i];
		}
	}
	
	return null;
};

/**
 * afterRendering
 */
sap.m.IconTabBar.prototype.onAfterRendering = function() {
	var oHeadDomRef = this.getDomRef("head"),
		$bar = this.$();

	// initialize scrolling
	if (this._oScroller) {
		this._oScroller.setIconTabBar(this, jQuery.proxy(this._afterIscroll, this), jQuery.proxy(this._scrollPreparation, this));
	}

	if (this.oSelectedItem && this.getExpanded()) {
		this.oSelectedItem.$().addClass("sapMITBSelected");
	}

	if (!sap.ui.Device.system.desktop || (sap.ui.Device.os.windows && sap.ui.Device.os.version === 8)) {
		jQuery.sap.delayedCall(350, this, "_checkOverflow", [oHeadDomRef, $bar]);
	}

	// reset scroll state after re-rendering for non-touch devices (iScroll will handle this internally)
	if (this._iCurrentScrollLeft !== 0 && (sap.ui.Device.system.desktop && !(sap.ui.Device.os.windows && sap.ui.Device.os.version === 8))) {
		oHeadDomRef.scrollLeft = this._iCurrentScrollLeft;
	}

	// scroll to selected item if it is out of screen and we render the control the first time
	if (this.oSelectedItem) {
		if (!this._bDoThisOnlyOnce) {
			jQuery.sap.delayedCall(1000, this, "_scrollIntoView", [this.oSelectedItem, 0]); // needs some delay to have correct position info
			this._bDoThisOnlyOnce = true;
		} else if (this._scrollAfterRendering) {
			this._scrollIntoView(this.oSelectedItem, 500); 
			this._scrollAfterRendering = false;
		}
	}

	//use ItemNavigation for keyboardHandling
	var aItems = this.getItems();
	var aTabDomRefs = [];
	var iSelectedDomIndex = -1;
	var that = this;

	// find a collection of all tabs
	aItems.forEach(function(oItem) {
		if (oItem instanceof sap.m.IconTabFilter) {
			var oItemDomRef = that.getFocusDomRef(oItem);
			jQuery(oItemDomRef).attr("tabindex", "-1");
			aTabDomRefs.push(oItemDomRef);
			if (that === this.oSelectedItem) {
				iSelectedDomIndex = aTabDomRefs.indexOf(oItem);
			}
		}
	});

	//Initialize the ItemNavigation
	if (!this._oItemNavigation) {
		this._oItemNavigation = new sap.ui.core.delegate.ItemNavigation();
		this.addDelegate(this._oItemNavigation);
	}

	//Reinitialize the ItemNavigation after rendering
	this._oItemNavigation.setRootDomRef(oHeadDomRef);
	this._oItemNavigation.setItemDomRefs(aTabDomRefs);
	this._oItemNavigation.setSelectedIndex(iSelectedDomIndex);


	//listen to resize
	this._sResizeListenerId = sap.ui.core.ResizeHandler.register(this.getDomRef(),  jQuery.proxy(this._fnResize, this));

	this._adjustArrow();
};

/**
 * Destroys the item aggregation.
 */
sap.m.IconTabBar.prototype.destroyItems = function() {
	this.oSelectedItem = null;
	this._aTabKeys = [];
	this.destroyAggregation("items");
};

sap.m.IconTabBar.prototype.addItem = function(oItem) {
	if (!(oItem instanceof sap.m.IconTabSeparator)) {
		var sKey = oItem.getKey();
		//check if key is a duplicate
		if(this._aTabKeys.indexOf(sKey) !== -1) {
			jQuery.sap.log.warning("sap.m.IconTabBar: duplicate key '" + sKey +"' inside the IconTabFilter. Please use unique keys.");
		}
		this._aTabKeys.push(sKey);
	}
	this.addAggregation("items", oItem);
};

sap.m.IconTabBar.prototype.insertItem = function(oItem, iIndex) {
	if (!(oItem instanceof sap.m.IconTabSeparator)) {
		var sKey = oItem.getKey();
		//check if key is a duplicate
		if(this._aTabKeys.indexOf(sKey) !== -1) {
			jQuery.sap.log.warning("sap.m.IconTabBar: duplicate key '" + sKey +"' inside the IconTabFilter. Please use unique keys.");
		}
		this._aTabKeys.push(sKey);
	}
	this.insertAggregation("items", oItem, iIndex);
};

sap.m.IconTabBar.prototype.removeAllItems = function() {
	this._aTabKeys = [];
	this.removeAllAggregation("items");
};

sap.m.IconTabBar.prototype.removeItem = function(oItem) {
	// Make sure we have the actual Item and not just an ID
	oItem = this.removeAggregation("items", oItem);
	
	if (oItem && !(oItem instanceof sap.m.IconTabSeparator)) {
		var sKey = oItem.getKey();
		this._aTabKeys.splice(this._aTabKeys.indexOf(sKey) , 1);
	}
	
	// Return the original value from removeAggregation
	return oItem;
};

/**
 * Called after the theme has been switched, required for new width calc
 * @private
 */
sap.m.IconTabBar.prototype.onThemeChanged = function(oEvent){
	this._adjustArrow();
};

/**
 * Function is executed when the expand/collapse animation is finished to adjust the UI 
 *
 * @param {boolean} bExpanded the new state of the container. Passed in 
 * @private
 * @return {sap.m.IconTabBar} this pointer for chaining
 */
sap.m.IconTabBar.prototype.onTransitionEnded = function(bExpanded) {
	var $content = this.$("content"),
		$container = this.$("containerContent"),
		$arrow = this.$("contentArrow");

	// if multiple animations are triggered, this function is executed multiple times in the end, so we need to ignore all except the last call
	if (this._iAnimationCounter === 1) {
		$container.toggleClass("sapMITBContentClosed", !bExpanded);
		if (bExpanded) { // expanding
			$arrow.show();
			$content.css("display", "block");
		} else { // collapsing
			$arrow.hide();
			$content.css("display", "none");
		}
	}
	// reduce animation counter
	this._iAnimationCounter = (this._iAnimationCounter > 0 ? --this._iAnimationCounter : 0);
};

/**
 * Opens and closes the content Container
 *
 * @param {boolean|undefined} bExpanded the new state of the container. If not specified, it will use the property expanded
 * @private
 * @return {sap.m.IconTabBar} this pointer for chaining
 */
sap.m.IconTabBar.prototype._toggleExpandCollapse = function(bExpanded) {
	var $content = this.$("content");

	// use inverted control state if not specified by parameter
	if (bExpanded === undefined) {
		bExpanded = !this.getExpanded();
	}

	// manage selection state
	if (this.oSelectedItem) {
		this.oSelectedItem.$().toggleClass("sapMITBSelected", bExpanded);
	}

	// show animation (keep track of active animations to avoid flickering of controls)
	this._iAnimationCounter = (this._iAnimationCounter === undefined ? 1 : ++this._iAnimationCounter);
	if (bExpanded) { // expanding
		if (this.oSelectedItem) {
			if (this.$("content").children().length === 0) { //content is not rendered yet
				//if item has own content, this content is shown
				var oSelectedItemContent = this.oSelectedItem.getContent();
				if (oSelectedItemContent.length > 0) {
					this._rerenderContent(oSelectedItemContent);
				//if item has not own content, general content of the icontabbar is shown
				} else {
					this._rerenderContent(this.getContent());
				}
			}
			$content.slideDown('400', jQuery.proxy(this.onTransitionEnded, this, bExpanded));
			this.$("containerContent").toggleClass("sapMITBContentClosed", !bExpanded);
		}
	} else { // collapsing
		this.$("contentArrow").hide();
		$content.slideUp('400', jQuery.proxy(this.onTransitionEnded, this, bExpanded));
	}

	// update property (if we have a selected item) and fire event
	if (!bExpanded || this.oSelectedItem) {
		this.setProperty("expanded", bExpanded, true);
	}
	this.fireExpand({
		expand: bExpanded,
		collapse: !bExpanded
	});

	return this;
};

/**
 * Checks if all tabs are textOnly version.
 * @private
 * @returns true if all tabs are textOnly version, otherwise false
 */
sap.m.IconTabBar.prototype._checkTextOnly = function(aItems) {
	if (aItems.length > 0) {
		for (var i = 0; i < aItems.length; i++) {
			if (!(aItems[i] instanceof sap.m.IconTabSeparator)) {
				if (aItems[i].getIcon()) {
					this._bTextOnly = false;
					return false;
				}
			}
		}
	}
	this._bTextOnly = true;
	return true;
};

/**
 * Checks if all tabs are noText version.
 * @private
 * @returns true if all tabs are noText version, otherwise false
 */
sap.m.IconTabBar.prototype._checkNoText = function(aItems) {
	if (aItems.length > 0) {
		for (var i = 0; i < aItems.length; i++) {
			if (!(aItems[i] instanceof sap.m.IconTabSeparator)) {
				if (aItems[i].getText().length > 0) {
					return false;
				}
			}
		}
	}
	return true;
};

/**
 * Checks if scrolling is needed.
 * @private
 * @returns true if scrolling is needed, otherwise false
 */
sap.m.IconTabBar.prototype._checkScrolling = function(oHead, $bar) {
	var bScrolling = false;

	if (!sap.ui.Device.system.desktop || (sap.ui.Device.os.windows && sap.ui.Device.os.version === 8)) { //iScroll is used, therefore we need other calculation then in desktop mode
		var domScrollCont = this.getDomRef("scrollContainer");
		var domHead = this.getDomRef("head");
		if (domHead.offsetWidth > domScrollCont.offsetWidth) {
			bScrolling = true;
		}
	} else { //desktop mode
		//check if there are more tabs as displayed
		if (oHead) {
			if (oHead.scrollWidth > oHead.clientWidth) {
				//scrolling possible
				bScrolling = true;
			}
		}
	}

	if (this._scrollable !== bScrolling) {
		$bar.toggleClass("sapMITBScrollable", bScrolling);
		$bar.toggleClass("sapMITBNotScrollable", !bScrolling);
		this._scrollable = bScrolling;
	}

	return bScrolling;
};

/**
 * Gets the icon of the requested arrow (left/right).
 * @private
 * @param sName left or right
 * @returns icon of the requested arrow
 */
sap.m.IconTabBar.prototype._getScrollingArrow = function(sName) {
	var mProperties = {
		src : "sap-icon://navigation-" + sName + "-arrow"
	};
	var aCssClassesToAddLeft = ["sapMITBArrowScroll", "sapMITBArrowScrollLeft"];
	var aCssClassesToAddRight = ["sapMITBArrowScroll", "sapMITBArrowScrollRight"];
	
	if (sName === "left") {
		if (!this._oArrowLeft) {
			this._oArrowLeft = sap.m.ImageHelper.getImageControl(this.getId() + "-arrowScrollLeft", this._oArrowLeft, this, mProperties, aCssClassesToAddLeft);
		}
		return this._oArrowLeft;
	}
	if (sName === "right") {
		if (!this._oArrowRight) {
			this._oArrowRight = sap.m.ImageHelper.getImageControl(this.getId() + "-arrowScrollRight", this._oArrowRight, this, mProperties, aCssClassesToAddRight);
		}
		return this._oArrowRight;
	}
};

/**
 * Changes the state of the scroll arrows depending on whether they are required due to overflow.
 *
 * @param oListDomRef the ul tag containing the items
 * @param of_back the backward scroll arrow
 * @param of_fw the forward scroll arrow
 * @private
 */
sap.m.IconTabBar.prototype._checkOverflow = function(oBarHead, $bar) {

	if (this._checkScrolling(oBarHead, $bar) && oBarHead) {
		// check whether scrolling to the left is possible
		var bScrollBack = false;
		var bScrollForward = false;

		if (!sap.ui.Device.system.desktop || (sap.ui.Device.os.windows && sap.ui.Device.os.version === 8)) { //iScroll is used, therefore we need other calculation then in desktop mode
			var domScrollCont = this.getDomRef("scrollContainer");
			var domHead = this.getDomRef("head");
			if (this._oScroller.getScrollLeft() > 0) {
				bScrollBack = true;
			}
			if ((this._oScroller.getScrollLeft() + domScrollCont.offsetWidth) < domHead.offsetWidth) {
				bScrollForward = true;
			}

		} else { //desktop mode
			var iScrollLeft = oBarHead.scrollLeft;
			var realWidth = oBarHead.scrollWidth;
			var availableWidth = oBarHead.clientWidth;

			if (Math.abs(realWidth-availableWidth) == 1){ // Avoid rounding issues see CSN 1316630 2013
				realWidth = availableWidth;
			}

			if (!this._bRtl) {   // normal LTR mode
				if (iScrollLeft > 0) {
					bScrollBack = true;
				}
				if ((realWidth > availableWidth) && (iScrollLeft + availableWidth < realWidth)) {
					bScrollForward = true;
				}
			} else {  // RTL mode
				var $List = jQuery(oBarHead);
				if ($List.scrollLeftRTL() > 0) {
					bScrollForward = true;
				}
				if ($List.scrollRightRTL() > 0) {
					bScrollBack = true;
				}
			}
		}

		// only do DOM changes if the state changed to avoid periodic application of identical values
		if ((bScrollForward != this._bPreviousScrollForward) || (bScrollBack != this._bPreviousScrollBack)) {
			this._bPreviousScrollForward = bScrollForward;
			this._bPreviousScrollBack = bScrollBack;
			$bar.toggleClass("sapMITBScrollBack", bScrollBack);
			$bar.toggleClass("sapMITBNoScrollBack", !bScrollBack);
			$bar.toggleClass("sapMITBScrollForward", bScrollForward);
			$bar.toggleClass("sapMITBNoScrollForward", !bScrollForward);
		}
	}
};

/**
 * Handles the activation of the tabs and arrows.
 * @private
 */
sap.m.IconTabBar.prototype._handleActivation = function(oEvent) {
	var sTargetId = oEvent.target.id,
		oControl = oEvent.srcControl,
		sControlId;

	var $sTargetId = jQuery.sap.byId(sTargetId);
	if (jQuery.inArray(this.$("content")[0], $sTargetId.parents()) > -1) {
		//do nothing because element is inside content
	} else {
		if (sTargetId) {
			var sId = this.getId();

			// For items: do not navigate away! Stay on the page and handle the click in-place. Right-click + "Open in new Tab" still works.
			// For scroll buttons: Prevent IE from firing beforeunload event -> see CSN 4378288 2012
			oEvent.preventDefault();

			//on mobile devices click on arrows has no effect
			if (sTargetId == sId + "-arrowScrollLeft" && sap.ui.Device.system.desktop) {
				if (sap.ui.Device.os.windows && sap.ui.Device.os.version === 8) {
					//combi devices with windows 8 should also scroll on click on arrows
					//need to use iscroll
					var iScrollLeft = this._oScroller.getScrollLeft() - sap.m.IconTabBar.SCROLL_STEP;
					if (iScrollLeft < 0) {
						iScrollLeft = 0;
					}
					// execute manual scrolling with iScroll's scrollTo method (delayedCall 0 is needed for positioning glitch)
					this._scrollPreparation();
					jQuery.sap.delayedCall(0, this._oScroller, "scrollTo", [iScrollLeft, 0, 500]);
					jQuery.sap.delayedCall(500, this, "_afterIscroll");
				} else {
					// scroll back/left button
					this._scroll(-sap.m.IconTabBar.SCROLL_STEP, 500);
				}

			} else if (sTargetId == sId + "-arrowScrollRight" && sap.ui.Device.system.desktop) {
				if (sap.ui.Device.os.windows && sap.ui.Device.os.version === 8) {
					//combi devices with windows 8 should also scroll on click on arrows
					//need to use iscroll
					var iScrollLeft = this._oScroller.getScrollLeft() + sap.m.IconTabBar.SCROLL_STEP;
					var iContainerWidth = this.$("scrollContainer").width();
					var iHeadWidth = this.$("head").width();
					if (iScrollLeft > (iHeadWidth - iContainerWidth)) {
						iScrollLeft = iHeadWidth - iContainerWidth;
					}
					// execute manual scrolling with iScroll's scrollTo method (delayedCall 0 is needed for positioning glitch)
					this._scrollPreparation();
					jQuery.sap.delayedCall(0, this._oScroller, "scrollTo", [iScrollLeft, 0, 500]);
					jQuery.sap.delayedCall(500, this, "_afterIscroll");
				} else {
					// scroll forward/right button
					this._scroll(sap.m.IconTabBar.SCROLL_STEP, 500);
				}

			} else {
				// should be one of the items - select it
				if (oControl instanceof sap.ui.core.Icon) { 
					// click on icon: fetch filter instead
					sControlId = oEvent.srcControl.getId().replace("-icon", "");
					oControl = sap.ui.getCore().byId(sControlId);
					this.setSelectedItem(oControl);
				}
				// select item if it is an iconTab but not a separator
				else if (oControl.getMetadata().isInstanceOf("sap.m.IconTab") && !(oControl instanceof sap.m.IconTabSeparator)) {
					//for tabs with showAll property true, click on whole area leads to selection, for text only version only clicking on text itself (not count)
					if (oControl.getShowAll() || this._bTextOnly && sTargetId === oControl.getId() + "-text") {
						this.setSelectedItem(oControl);
					}
				}
			}
		}
	}
};

/*
 * Scrolls to the item passed as parameter if it is not (fully) visible
 * If the item is to the left of the viewport it will be put leftmost.
 * If the item is to the right of the viewport it will be put rightmost.
 * @param {sap.m.IconTabFilter} oItem The item to be scrolled into view
 * @param {int} iDuration The duration of the animation effect
 * @private
 * @return {sap.m.IconTabBar} this pointer for chaining
 */ 
sap.m.IconTabBar.prototype._scrollIntoView = function(oItem, iDuration) {
	var $item = oItem.$(),
	oHeadDomRef,
	iScrollLeft,
	iNewScrollLeft,
	iContainerWidth;

	if ($item.length > 0) {
		var iItemWidth = $item.outerWidth();
		var iItemPosLeft = $item.position().left;

		// switch based on scrolling mode
		if (!sap.ui.Device.system.desktop || (sap.ui.Device.os.windows && sap.ui.Device.os.version === 8)) { // iScroll
			iScrollLeft = this._oScroller.getScrollLeft();
			iContainerWidth = this.$("scrollContainer").width();
			iNewScrollLeft = 0;

			// check if item is outside of viewport
			if (iItemPosLeft - iScrollLeft < 0 || iItemPosLeft - iScrollLeft > iContainerWidth - iItemWidth) {		
				if (iItemPosLeft - iScrollLeft < 0) { // left side: make this the first item
					iNewScrollLeft += iItemPosLeft;
				} else { // right side: make this the last item
					iNewScrollLeft += iItemPosLeft + iItemWidth - iContainerWidth;
				}

				// execute manual scrolling with iScroll's scrollTo method (delayedCall 0 is needed for positioning glitch)
				this._scrollPreparation();
				jQuery.sap.delayedCall(0, this._oScroller, "scrollTo", [iNewScrollLeft, 0, iDuration]);
				jQuery.sap.delayedCall(iDuration, this, "_afterIscroll");
			}
		} else { // desktop scrolling with jQuery
			oHeadDomRef = this.getDomRef("head");
			iScrollLeft = oHeadDomRef.scrollLeft;
			iContainerWidth = $item.parent().width();
			iNewScrollLeft = iScrollLeft;		

			// check if item is outside of viewport
			if (iItemPosLeft < 0 || iItemPosLeft > iContainerWidth - iItemWidth) { 
				if (iItemPosLeft < 0) { // left side: make this the first item
					iNewScrollLeft += iItemPosLeft;
				} else { // right side: make this the last item
					iNewScrollLeft += iItemPosLeft + iItemWidth - iContainerWidth;
				}

				// execute scrolling
				this._scrollPreparation();
				jQuery(oHeadDomRef).stop(true, true).animate({scrollLeft: iNewScrollLeft}, iDuration, jQuery.proxy(this._adjustAndShowArrow, this));
			}
		}
		// store current scroll state to set it after rerendering
		this._iCurrentScrollLeft = iNewScrollLeft;
	}

	return this;
};

/*
 * Scrolls the items if possible, using an animation.
 *
 * @param iDelta how far to scroll
 * @param iDuration how long to scroll (ms)
 * @private
 */
sap.m.IconTabBar.prototype._scroll = function(iDelta, iDuration) {
	this._scrollPreparation();

	var oDomRef = this.getDomRef("head");
	var iScrollLeft = oDomRef.scrollLeft;
	if (!!!sap.ui.Device.browser.internet_explorer && this._bRtl) {
		iDelta = -iDelta;
	} // RTL lives in the negative space
	var iScrollTarget = iScrollLeft+iDelta;
	jQuery(oDomRef).stop(true, true).animate({scrollLeft: iScrollTarget}, iDuration, jQuery.proxy(this._adjustAndShowArrow, this));
	this._iCurrentScrollLeft = iScrollTarget;
};

/**
 * Adjusts the arrow position and shows the arrow.
 * @private
 */
sap.m.IconTabBar.prototype._adjustAndShowArrow = function() {
	this._adjustArrow();
	this._$bar && this._$bar.toggleClass("sapMITBScrolling", false);
	this._$bar = null;
};

/**
 * Scroll preparation.
 * @private
 */
sap.m.IconTabBar.prototype._scrollPreparation = function() {
	if (!this._$bar){
		this._$bar = this.$().toggleClass("sapMITBScrolling", true);
	}
};

/**
 * After iscroll.
 * @private
*/
sap.m.IconTabBar.prototype._afterIscroll = function() {
	var oHead = this.getDomRef("head");
	this._checkOverflow(oHead, this.$());
	this._adjustAndShowArrow();
};

/**
 * Resize  handling.
 * @private
*/
sap.m.IconTabBar.prototype._fnResize = function() {
	var oHead = this.getDomRef("head");
	this._checkOverflow(oHead, this.$());
	this._adjustArrow();
};

/** 
 * @overwrite
 */
//overwritten method, returns for most cases the iconDomRef, if the given tab has no icon, the textDomRef is returned.
sap.m.IconTabBar.prototype.getFocusDomRef = function (oFocusTab) {
	
	var oTab = oFocusTab || this.oSelectedItem;

	if (!oTab) {
		return null;
	}

	if (!this._bTextOnly) {
		if (oTab.getShowAll()) {
			return oTab.getDomRef();
		}
		return oTab.getDomRef("icon");
	}
	return oTab.getDomRef("text");
};

sap.m.IconTabBar.prototype.applyFocusInfo = function (oFocusInfo) {
	//sets the focus depending on the used IconTabFilter
	if (oFocusInfo.focusDomRef) {
		jQuery(oFocusInfo.focusDomRef).focus();
	}
};

/* =========================================================== */
/*           begin: event handlers                             */
/* =========================================================== */

/**
 * Initializes scrolling on the IconTabBar. 
 *
 * @param {jQuery.Event} oEvent
 * @private
 */
sap.m.IconTabBar.prototype.ontouchstart = function(oEvent) {
	var oTargetTouch = oEvent.targetTouches[0];

	// store & init touch state
	this._iActiveTouch = oTargetTouch.identifier;
	this._iTouchStartPageX = oTargetTouch.pageX;
	this._iTouchDragX = 0;
};

/**
 * Sets an internal flag if horizontal drag was executed.
 *
 * @param {jQuery.Event} oEvent
 * @private
 */
sap.m.IconTabBar.prototype.ontouchmove = function(oEvent) {
	var oTouch = sap.m.touch.find(oEvent.changedTouches, this._iActiveTouch);

	// check for valid changes 
	if (!oTouch || oTouch.pageX === this._iTouchStartPageX) {
		return;
	}

	// sum up movement to determine in touchend event if selection should be executed
	this._iTouchDragX += Math.abs(this._iTouchStartPageX - oTouch.pageX); 
	this._iTouchStartPageX = oTouch.pageX;
};

/**
 * Handles touch end and events and trigger selection if bar was not dragged.
 *
 * @param {jQuery.Event} oEvent
 * @private
 */
sap.m.IconTabBar.prototype.ontouchend = function(oEvent) {
	// suppress selection if there ware a drag (moved more than 20px)
	if (this._iTouchDragX > 20) {
		return;
	}
	// 
	this._handleActivation(oEvent);
};


/**
 * Handle the touch cancel event.
 *
 * @param {jQuery.EventObject} oEvent The event object
 * @private
 */
sap.m.IconTabBar.prototype.ontouchcancel = sap.m.IconTabBar.prototype.ontouchend;

/**
 * Keyboard navigation event when the user presses Enter or Space.
 *
 * @param {jQuery.Event} oEvent
 * @private
 */
sap.m.IconTabBar.prototype.onsapselect = function(oEvent) {
	this._handleActivation(oEvent);
};


/* =========================================================== */
/*           end: event handlers                               */
/* =========================================================== */

}; // end of sap/m/IconTabBar.js
if ( !jQuery.sap.isDeclared('sap.m.IconTabFilter') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.m.IconTabFilter.
jQuery.sap.declare("sap.m.IconTabFilter");

jQuery.sap.require('sap.ui.core.Item'); // unlisted dependency retained



/**
 * Constructor for a new IconTabFilter.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getCount count} : string (default: '')</li>
 * <li>{@link #getShowAll showAll} : boolean (default: false)</li>
 * <li>{@link #getIcon icon} : sap.ui.core.URI (default: '')</li>
 * <li>{@link #getIconColor iconColor} : sap.ui.core.IconColor (default: sap.ui.core.IconColor.Default)</li>
 * <li>{@link #getIconDensityAware iconDensityAware} : boolean (default: true)</li>
 * <li>{@link #getVisible visible} : boolean (default: true)</li>
 * <li>{@link #getDesign design} : sap.m.IconTabFilterDesign (default: sap.m.IconTabFilterDesign.Vertical)</li></ul>
 * </li>
 * <li>Aggregations
 * <ul>
 * <li>{@link #getContent content} <strong>(default aggregation)</strong> : sap.ui.core.Control[]</li></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 
 *
 * 
 * In addition, all settings applicable to the base type {@link sap.ui.core.Item#constructor sap.ui.core.Item}
 * can be used as well.
 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * The filter item class
 * @extends sap.ui.core.Item
 * @implements sap.m.IconTab
 *
 * @author SAP AG 
 * @version 1.20.6
 *
 * @constructor   
 * @public
 * @name sap.m.IconTabFilter
 */
sap.ui.core.Item.extend("sap.m.IconTabFilter", { metadata : {

	// ---- object ----
	interfaces : [
		"sap.m.IconTab"
	],

	// ---- control specific ----
	library : "sap.m",
	properties : {
		"count" : {type : "string", group : "Data", defaultValue : ''},
		"showAll" : {type : "boolean", group : "Misc", defaultValue : false},
		"icon" : {type : "sap.ui.core.URI", group : "Misc", defaultValue : ''},
		"iconColor" : {type : "sap.ui.core.IconColor", group : "Appearance", defaultValue : sap.ui.core.IconColor.Default},
		"iconDensityAware" : {type : "boolean", group : "Appearance", defaultValue : true},
		"visible" : {type : "boolean", group : "Behavior", defaultValue : true},
		"design" : {type : "sap.m.IconTabFilterDesign", group : "Appearance", defaultValue : sap.m.IconTabFilterDesign.Vertical}
	},
	defaultAggregation : "content",
	aggregations : {
    	"content" : {type : "sap.ui.core.Control", multiple : true, singularName : "content"}
	}
}});


/**
 * Creates a new subclass of class sap.m.IconTabFilter with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.m.IconTabFilter.extend
 * @function
 */


/**
 * Getter for property <code>count</code>.
 * The number of available items if this filter is applied
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>count</code>
 * @public
 * @name sap.m.IconTabFilter#getCount
 * @function
 */

/**
 * Setter for property <code>count</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sCount  new value for property <code>count</code>
 * @return {sap.m.IconTabFilter} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.IconTabFilter#setCount
 * @function
 */


/**
 * Getter for property <code>showAll</code>.
 * Enables special visualization for disabled filter (show all items)
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>showAll</code>
 * @public
 * @name sap.m.IconTabFilter#getShowAll
 * @function
 */

/**
 * Setter for property <code>showAll</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bShowAll  new value for property <code>showAll</code>
 * @return {sap.m.IconTabFilter} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.IconTabFilter#setShowAll
 * @function
 */


/**
 * Getter for property <code>icon</code>.
 * The icon to display for this item.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.core.URI} the value of property <code>icon</code>
 * @public
 * @name sap.m.IconTabFilter#getIcon
 * @function
 */

/**
 * Setter for property <code>icon</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.core.URI} sIcon  new value for property <code>icon</code>
 * @return {sap.m.IconTabFilter} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.IconTabFilter#setIcon
 * @function
 */


/**
 * Getter for property <code>iconColor</code>.
 * If an icon font is used, the color can be chosen from the icon colors (sap.ui.core.IconColor).
 * Possible semantic colors are: Neutral, Positive, Critical, Negative.
 * Instead of the semantic icon color the brand color can be used, this is named Default.
 * Semantic colors and brand colors should not be mixed up inside one IconTabBar.
 *
 * Default value is <code>Default</code>
 *
 * @return {sap.ui.core.IconColor} the value of property <code>iconColor</code>
 * @public
 * @name sap.m.IconTabFilter#getIconColor
 * @function
 */

/**
 * Setter for property <code>iconColor</code>.
 *
 * Default value is <code>Default</code> 
 *
 * @param {sap.ui.core.IconColor} oIconColor  new value for property <code>iconColor</code>
 * @return {sap.m.IconTabFilter} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.IconTabFilter#setIconColor
 * @function
 */


/**
 * Getter for property <code>iconDensityAware</code>.
 * By default, this is set to true but then one or more requests are sent trying to get the density perfect version of image if this version of image doesn't exist on the server.
 * 
 * If bandwidth is the key for the application, set this value to false.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>iconDensityAware</code>
 * @public
 * @name sap.m.IconTabFilter#getIconDensityAware
 * @function
 */

/**
 * Setter for property <code>iconDensityAware</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bIconDensityAware  new value for property <code>iconDensityAware</code>
 * @return {sap.m.IconTabFilter} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.IconTabFilter#setIconDensityAware
 * @function
 */


/**
 * Getter for property <code>visible</code>.
 * If set to false, the control is not rendered.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>visible</code>
 * @public
 * @name sap.m.IconTabFilter#getVisible
 * @function
 */

/**
 * Setter for property <code>visible</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bVisible  new value for property <code>visible</code>
 * @return {sap.m.IconTabFilter} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.IconTabFilter#setVisible
 * @function
 */


/**
 * Getter for property <code>design</code>.
 * Design for the filter item.
 *
 * Default value is <code>Vertical</code>
 *
 * @return {sap.m.IconTabFilterDesign} the value of property <code>design</code>
 * @public
 * @name sap.m.IconTabFilter#getDesign
 * @function
 */

/**
 * Setter for property <code>design</code>.
 *
 * Default value is <code>Vertical</code> 
 *
 * @param {sap.m.IconTabFilterDesign} oDesign  new value for property <code>design</code>
 * @return {sap.m.IconTabFilter} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.IconTabFilter#setDesign
 * @function
 */


/**
 * Getter for aggregation <code>content</code>.<br/>
 * The content to show for this item (optional).
 * If this content is set, it will be displayed instead of the general content inside the IconTabBar.
 * 
 * <strong>Note</strong>: this is the default aggregation for IconTabFilter.
 * @return {sap.ui.core.Control[]}
 * @public
 * @since 1.15.0
 * @name sap.m.IconTabFilter#getContent
 * @function
 */


/**
 * Inserts a content into the aggregation named <code>content</code>.
 *
 * @param {sap.ui.core.Control}
 *          oContent the content to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the content should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the content is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the content is inserted at 
 *             the last position        
 * @return {sap.m.IconTabFilter} <code>this</code> to allow method chaining
 * @public
 * @since 1.15.0
 * @name sap.m.IconTabFilter#insertContent
 * @function
 */

/**
 * Adds some content <code>oContent</code> 
 * to the aggregation named <code>content</code>.
 *
 * @param {sap.ui.core.Control}
 *            oContent the content to add; if empty, nothing is inserted
 * @return {sap.m.IconTabFilter} <code>this</code> to allow method chaining
 * @public
 * @since 1.15.0
 * @name sap.m.IconTabFilter#addContent
 * @function
 */

/**
 * Removes an content from the aggregation named <code>content</code>.
 *
 * @param {int | string | sap.ui.core.Control} vContent the content to remove or its index or id
 * @return {sap.ui.core.Control} the removed content or null
 * @public
 * @since 1.15.0
 * @name sap.m.IconTabFilter#removeContent
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>content</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.core.Control[]} an array of the removed elements (might be empty)
 * @public
 * @since 1.15.0
 * @name sap.m.IconTabFilter#removeAllContent
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.core.Control</code> in the aggregation named <code>content</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.core.Control}
 *            oContent the content whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @since 1.15.0
 * @name sap.m.IconTabFilter#indexOfContent
 * @function
 */
	

/**
 * Destroys all the content in the aggregation 
 * named <code>content</code>.
 * @return {sap.m.IconTabFilter} <code>this</code> to allow method chaining
 * @public
 * @since 1.15.0
 * @name sap.m.IconTabFilter#destroyContent
 * @function
 */


// Start of sap\m\IconTabFilter.js
/**
 * Lazy load icon tab filter image.
 *
 * @param {Array} aCssClassesToAdd array of css classes which will be added if the image needs to be created.
 * @param {sap.ui.core.Control} oParent this element's parent.
 * @param {Array} aCssClassesToRemove all css clases that oImageControl has and which are contained in this array
 * are removed bevore adding the css classes listed in aCssClassesToAdd.
 *
 * @private
 */
sap.m.IconTabFilter.prototype._getImageControl = function(aCssClassesToAdd, oParent, aCssClassesToRemove) {
	var mProperties = { 
		src : this.getIcon(),
		densityAware : this.getIconDensityAware()
	};
	if (mProperties.src) {
		this._oImageControl = sap.m.ImageHelper.getImageControl(this.getId() + "-icon", this._oImageControl, oParent, mProperties, aCssClassesToAdd, aCssClassesToRemove);
	}
	
	return this._oImageControl;
};

/**
 * Function is called when exiting the element.
 * 
 * @private
 */
sap.m.IconTabFilter.prototype.exit = function(oEvent) {
	
	if (this._oImageControl) {
		this._oImageControl.destroy();
	}
	
	if (sap.ui.core.Item.prototype.exit) {
		sap.ui.core.Item.prototype.exit.call(this, oEvent);
	}
};


}; // end of sap/m/IconTabFilter.js
if ( !jQuery.sap.isDeclared('sap.m.IconTabSeparator') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.m.IconTabSeparator.
jQuery.sap.declare("sap.m.IconTabSeparator");

jQuery.sap.require('sap.ui.core.Element'); // unlisted dependency retained



/**
 * Constructor for a new IconTabSeparator.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getIcon icon} : sap.ui.core.URI (default: '')</li>
 * <li>{@link #getIconDensityAware iconDensityAware} : boolean (default: true)</li></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 
 *
 * 
 * In addition, all settings applicable to the base type {@link sap.ui.core.Element#constructor sap.ui.core.Element}
 * can be used as well.
 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * A tab separator item class
 * @extends sap.ui.core.Element
 * @implements sap.m.IconTab
 *
 * @author SAP AG 
 * @version 1.20.6
 *
 * @constructor   
 * @public
 * @name sap.m.IconTabSeparator
 */
sap.ui.core.Element.extend("sap.m.IconTabSeparator", { metadata : {

	// ---- object ----
	interfaces : [
		"sap.m.IconTab"
	],

	// ---- control specific ----
	library : "sap.m",
	properties : {
		"icon" : {type : "sap.ui.core.URI", group : "Misc", defaultValue : ''},
		"iconDensityAware" : {type : "boolean", group : "Appearance", defaultValue : true}
	}
}});


/**
 * Creates a new subclass of class sap.m.IconTabSeparator with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.m.IconTabSeparator.extend
 * @function
 */


/**
 * Getter for property <code>icon</code>.
 * The icon to display for this separator. If no icon is given, a separator line will be used instead.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.core.URI} the value of property <code>icon</code>
 * @public
 * @name sap.m.IconTabSeparator#getIcon
 * @function
 */

/**
 * Setter for property <code>icon</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.core.URI} sIcon  new value for property <code>icon</code>
 * @return {sap.m.IconTabSeparator} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.IconTabSeparator#setIcon
 * @function
 */


/**
 * Getter for property <code>iconDensityAware</code>.
 * By default, this is set to true but then one or more requests are sent trying to get the density perfect version of image if this version of image doesn't exist on the server.
 * 
 * If bandwidth is the key for the application, set this value to false.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>iconDensityAware</code>
 * @public
 * @name sap.m.IconTabSeparator#getIconDensityAware
 * @function
 */

/**
 * Setter for property <code>iconDensityAware</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bIconDensityAware  new value for property <code>iconDensityAware</code>
 * @return {sap.m.IconTabSeparator} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.IconTabSeparator#setIconDensityAware
 * @function
 */


// Start of sap\m\IconTabSeparator.js
/**
 * Lazy load feed icon image.
 *
 * @param {Array} aCssClasses array of css classes which will be added if the image needs to be created.
 * @param {sap.ui.core.Control} oParent this element's parent.
 * @private
 */
sap.m.IconTabSeparator.prototype._getImageControl = function(aCssClasses, oParent) {
	var mProperties = { 
		src : this.getIcon(),
		densityAware : this.getIconDensityAware()
	};
	
	this._oImageControl = sap.m.ImageHelper.getImageControl(null, this._oImageControl, oParent, mProperties, aCssClasses);
	
	return this._oImageControl;
};

/**
 * Function is called when exiting the element.
 * 
 * @private
 */
sap.m.IconTabSeparator.prototype.exit = function(oEvent) {
	
	if (this._oImageControl) {
		this._oImageControl.destroy();
	}
	
	if (sap.ui.core.Item.prototype.exit) {
		sap.ui.core.Item.prototype.exit.call(this, oEvent);
	}
};
}; // end of sap/m/IconTabSeparator.js
if ( !jQuery.sap.isDeclared('sap.m.Image') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.m.Image.
jQuery.sap.declare("sap.m.Image");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new Image.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getSrc src} : sap.ui.core.URI</li>
 * <li>{@link #getVisible visible} : boolean (default: true)</li>
 * <li>{@link #getWidth width} : sap.ui.core.CSSSize</li>
 * <li>{@link #getHeight height} : sap.ui.core.CSSSize</li>
 * <li>{@link #getDecorative decorative} : boolean (default: true)</li>
 * <li>{@link #getAlt alt} : string</li>
 * <li>{@link #getUseMap useMap} : string</li>
 * <li>{@link #getDensityAware densityAware} : boolean (default: true)</li>
 * <li>{@link #getActiveSrc activeSrc} : sap.ui.core.URI (default: "")</li></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul>
 * <li>{@link sap.m.Image#event:tap tap} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li>
 * <li>{@link sap.m.Image#event:press press} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * A wrapper around the IMG tag. The image can be loaded from a remote or local server.
 * 
 * Density related image will be loaded if image with density awareness name in format [imageName]@[densityValue].[extension] is provided. The valid desity values are 1, 1.5, 2. If the original devicePixelRatio isn't one of the three valid numbers, it's rounded up to the nearest one.
 * 
 * There are various size setting options available, and the images can be combined with actions.
 * @extends sap.ui.core.Control
 *
 * @author SAP AG 
 * @version 1.20.6
 *
 * @constructor   
 * @public
 * @name sap.m.Image
 */
sap.ui.core.Control.extend("sap.m.Image", { metadata : {

	// ---- object ----

	// ---- control specific ----
	library : "sap.m",
	properties : {
		"src" : {type : "sap.ui.core.URI", group : "Data", defaultValue : null},
		"visible" : {type : "boolean", group : "Appearance", defaultValue : true},
		"width" : {type : "sap.ui.core.CSSSize", group : "Appearance", defaultValue : null},
		"height" : {type : "sap.ui.core.CSSSize", group : "Appearance", defaultValue : null},
		"decorative" : {type : "boolean", group : "Accessibility", defaultValue : true},
		"alt" : {type : "string", group : "Accessibility", defaultValue : null},
		"useMap" : {type : "string", group : "Misc", defaultValue : null},
		"densityAware" : {type : "boolean", group : "Misc", defaultValue : true},
		"activeSrc" : {type : "sap.ui.core.URI", group : "Data", defaultValue : ""}
	},
	events : {
		"tap" : {}, 
		"press" : {}
	}
}});


/**
 * Creates a new subclass of class sap.m.Image with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.m.Image.extend
 * @function
 */

sap.m.Image.M_EVENTS = {'tap':'tap','press':'press'};


/**
 * Getter for property <code>src</code>.
 * Relative or absolute path to URL where the image file is stored. The path will be adapted to the density aware format according to the density of the device following the convention that [imageName]@[densityValue].[extension]
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.core.URI} the value of property <code>src</code>
 * @public
 * @name sap.m.Image#getSrc
 * @function
 */

/**
 * Setter for property <code>src</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.core.URI} sSrc  new value for property <code>src</code>
 * @return {sap.m.Image} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Image#setSrc
 * @function
 */


/**
 * Getter for property <code>visible</code>.
 * Invisible images are not rendered.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>visible</code>
 * @public
 * @name sap.m.Image#getVisible
 * @function
 */

/**
 * Setter for property <code>visible</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bVisible  new value for property <code>visible</code>
 * @return {sap.m.Image} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Image#setVisible
 * @function
 */


/**
 * Getter for property <code>width</code>.
 * When the empty value is kept, the original size is not changed. It is also possible to make settings for width or height only, the original ratio between width/height is maintained.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>width</code>
 * @public
 * @name sap.m.Image#getWidth
 * @function
 */

/**
 * Setter for property <code>width</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.core.CSSSize} sWidth  new value for property <code>width</code>
 * @return {sap.m.Image} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Image#setWidth
 * @function
 */


/**
 * Getter for property <code>height</code>.
 * When the empty value is kept, the original size is not changed. It is also possible to make settings for width or height only, the original ratio between width/height is maintained.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>height</code>
 * @public
 * @name sap.m.Image#getHeight
 * @function
 */

/**
 * Setter for property <code>height</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.core.CSSSize} sHeight  new value for property <code>height</code>
 * @return {sap.m.Image} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Image#setHeight
 * @function
 */


/**
 * Getter for property <code>decorative</code>.
 * A decorative image is included for design reasons. Accessibility tools will ignore decorative images.
 * 
 * Note: If the Image has an image map (useMap is set), this property will be overridden (the image will not be rendered as decorative).
 * A decorative image has no ALT attribute, so the Alt property is ignored if the image is decorative.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>decorative</code>
 * @public
 * @name sap.m.Image#getDecorative
 * @function
 */

/**
 * Setter for property <code>decorative</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bDecorative  new value for property <code>decorative</code>
 * @return {sap.m.Image} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Image#setDecorative
 * @function
 */


/**
 * Getter for property <code>alt</code>.
 * The alternative text that is displayed in case the Image is not available, or cannot be displayed.
 * If the image is set to decorative this property is ignored.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>alt</code>
 * @public
 * @name sap.m.Image#getAlt
 * @function
 */

/**
 * Setter for property <code>alt</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sAlt  new value for property <code>alt</code>
 * @return {sap.m.Image} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Image#setAlt
 * @function
 */


/**
 * Getter for property <code>useMap</code>.
 * The name of the image map that defines the clickable areas
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>useMap</code>
 * @public
 * @name sap.m.Image#getUseMap
 * @function
 */

/**
 * Setter for property <code>useMap</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sUseMap  new value for property <code>useMap</code>
 * @return {sap.m.Image} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Image#setUseMap
 * @function
 */


/**
 * Getter for property <code>densityAware</code>.
 * If this is set to false, the src image will be loaded directly without attempting to fetch the density perfect image for high density device.
 * 
 * By default, this is set to true but then one or more requests are sent trying to get the density perfect version of image if this version of image doesn't exist on the server.
 * 
 * If bandwidth is the key for the application, set this value to false.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>densityAware</code>
 * @public
 * @name sap.m.Image#getDensityAware
 * @function
 */

/**
 * Setter for property <code>densityAware</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bDensityAware  new value for property <code>densityAware</code>
 * @return {sap.m.Image} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Image#setDensityAware
 * @function
 */


/**
 * Getter for property <code>activeSrc</code>.
 * The source property when this image is tapped.
 *
 * Default value is <code>""</code>
 *
 * @return {sap.ui.core.URI} the value of property <code>activeSrc</code>
 * @public
 * @name sap.m.Image#getActiveSrc
 * @function
 */

/**
 * Setter for property <code>activeSrc</code>.
 *
 * Default value is <code>""</code> 
 *
 * @param {sap.ui.core.URI} sActiveSrc  new value for property <code>activeSrc</code>
 * @return {sap.m.Image} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Image#setActiveSrc
 * @function
 */


/**
 * Event is fired when the user clicks on the control. (This event is deprecated, use the press event instead) 
 *
 * @name sap.m.Image#tap
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters

 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'tap' event of this <code>sap.m.Image</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.m.Image</code>.<br/> itself. 
 *  
 * Event is fired when the user clicks on the control. (This event is deprecated, use the press event instead) 
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.m.Image</code>.<br/> itself.
 *
 * @return {sap.m.Image} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Image#attachTap
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'tap' event of this <code>sap.m.Image</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.m.Image} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Image#detachTap
 * @function
 */

/**
 * Fire event tap to attached listeners.

 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.m.Image} <code>this</code> to allow method chaining
 * @protected
 * @name sap.m.Image#fireTap
 * @function
 */


/**
 * Event is fired when the user clicks on the control. 
 *
 * @name sap.m.Image#press
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters

 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'press' event of this <code>sap.m.Image</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.m.Image</code>.<br/> itself. 
 *  
 * Event is fired when the user clicks on the control. 
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.m.Image</code>.<br/> itself.
 *
 * @return {sap.m.Image} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Image#attachPress
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'press' event of this <code>sap.m.Image</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.m.Image} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Image#detachPress
 * @function
 */

/**
 * Fire event press to attached listeners.

 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.m.Image} <code>this</code> to allow method chaining
 * @protected
 * @name sap.m.Image#firePress
 * @function
 */


// Start of sap\m\Image.js
sap.m.Image._currentDevicePixelRatio = (function() {

	// if devicePixelRatio property is not available, value 1 is assumed by default.
	var ratio = (window.devicePixelRatio === undefined ? 1 : window.devicePixelRatio);

	// for ratio in our library, only 1 1.5 2 are valid
	if (ratio <= 1) {
		ratio = 1;
	} else {

		// round it to the nearest valid value
		ratio *= 2;
		ratio = Math.round(ratio);
		ratio /= 2;
	}

	if (ratio > 2) {
		ratio = 2;
	}

	return ratio;
}());

/**
 * Function is called when image is loaded successfully.
 *
 * @param {jQuery.Event} oEvent
 * @private
 */
sap.m.Image.prototype.onload = function(oEvent) {

	// This is used to fix the late load event handler problem on ios platform, if the event handler
	// has not been called right after image is loaded, event is triggered manually in onAfterRendering
	// method.
	if (!this._defaultEventTriggered) {
		this._defaultEventTriggered = true;
	}

	var $DomNode = this.$(),
		oDomRef = $DomNode[0];

	if (!this._isWidthOrHeightSet()) {
		if (this._iLoadImageDensity > 1) {
			if (($DomNode.width() === oDomRef.naturalWidth) && ($DomNode.height() === oDomRef.naturalHeight)) {
				$DomNode.width($DomNode.width() / this._iLoadImageDensity);
			}
		}
	}

	$DomNode.removeClass("sapMNoImg");
};

/**
 * Function is called when error occurs during image loading.
 *
 * @param {jQuery.Event} oEvent
 * @private
 */
sap.m.Image.prototype.onerror = function(oEvent) {

	// This is used to fix the late load event handler problem on ios platform, if the event handler
	// has not been called right after image is loaded with errors, event is triggered manually in onAfterRendering
	// method.
	if (!this._defaultEventTriggered) {
		this._defaultEventTriggered = true;
	}

	var $DomNode = this.$(),
		sCurrentSrc = $DomNode.attr("src"),
		d = sap.m.Image._currentDevicePixelRatio;

	$DomNode.addClass("sapMNoImg");

	// if src is empty or there's no image existing, just stop
	if (!sCurrentSrc || this._iLoadImageDensity === 1) {
		return;
	}

	if (d === 2 || d < 1) {

		// load the default image
		this._iLoadImageDensity = 1;
		$DomNode.attr("src", this._generateSrcByDensity(this._isActiveState ? this.getActiveSrc() : this.getSrc(), 1));
	} else if (d === 1.5) {
		if (this._bVersion2Tried) {
			setTimeout(jQuery.proxy(function() {

				// if version 2 isn't on the server, load the default image
				this._iLoadImageDensity = 1;
				$DomNode.attr("src", this._generateSrcByDensity(this._isActiveState ? this.getActiveSrc() : this.getSrc(), 1));
			}, this), 0);
		} else {
			setTimeout(jQuery.proxy(function() {

				// special treatment for density 1.5
				// verify if the version for density 2 is provided or not
				this._iLoadImageDensity = 2;
				$DomNode.attr("src", this._generateSrcByDensity(this._isActiveState ? this.getActiveSrc() : this.getSrc(), 2));
				this._bVersion2Tried = true;
			}, this), 0);
		}
	}
};

/**
 * This function is called to register event handlers for load and error event on the image DOM after it's rendered.
 * It also check if the event handlers are called accordingly after the image is loaded, if not the event handlers are triggered
 * manually.
 *
 * @private
 */
sap.m.Image.prototype.onAfterRendering = function() {

	// if densityAware is set to true, we need to do extra steps for getting and resizing the density perfect version of the image.
	if (this.getDensityAware()) {
		var $DomNode = this.$();

		// bind the load and error event handler
		$DomNode.on("load", jQuery.proxy(this.onload, this));
		$DomNode.on("error", jQuery.proxy(this.onerror, this));

		var oDomRef = this.getDomRef();

		// if image has already been loaded and the load or error event handler hasn't been called, trigger it manually.
		if (oDomRef.complete && !this._defaultEventTriggered) {

			// need to use the naturalWidth property instead of jDomNode.width(),
			// the later one returns positive value even in case of broken image
			$DomNode.trigger(oDomRef.naturalWidth > 0 ? "load" : "error");	//  image loaded successfully or with error
		}
	}
};

/**
 * This binds to the touchstart event to change the src property of the image to the activeSrc.
 *
 * @private
 */
sap.m.Image.prototype.ontouchstart = function(oEvent) {
	if(oEvent.srcControl.mEventRegistry["press"] || oEvent.srcControl.mEventRegistry["tap"]){

		// mark the event for components that needs to know if the event was handled by the Image
		oEvent.setMarked();
	}

	if (oEvent.targetTouches.length === 1 && this.getActiveSrc()) {

		// change the source only when the first finger is on the image, the following fingers doesn't affect
		this.$().attr("src", this._getDensityAwareActiveSrc());
		this._isActiveState = true;
	}
};

/**
 * This changes the src property of the image back to the src property of the image control.
 *
 * @private
 */
sap.m.Image.prototype.ontouchend = function(oEvent) {
	// change the source back only when all fingers leave the image
	// avoid setting the normal state src again when there's no activeSrc property set
	if (oEvent.targetTouches.length === 0 && this.getActiveSrc()) {
		this._isActiveState = false;
		this.$().attr("src", this._getDensityAwareSrc()).removeClass("sapMNoImg");
	}
};

/**
 * This overrides the default setter of the src property and update the dom node.
 *
 * @public
 */
sap.m.Image.prototype.setSrc = function(sSrc) {
	if (sSrc === this.getSrc()) {
		return;
	}

	this.setProperty("src", sSrc, true);

	var oDomRef = this.getDomRef();
	if (oDomRef) {
		this.$().attr("src", this._getDensityAwareSrc());
	}
};

/**
 * This overrides the default setter of the activeSrc property in order to avoid the rerendering.
 *
 * @public
 */
sap.m.Image.prototype.setActiveSrc = function(sActiveSrc) {
	if (!sActiveSrc) {
		sActiveSrc = "";
	}

	this.setProperty("activeSrc", sActiveSrc, true);
};

/**
 * Function is called when image is clicked.
 *
 * @param {jQuery.Event} oEvent
 * @private
 */
sap.m.Image.prototype.ontap = function(oEvent) {
	this.fireTap({/* no parameters */}); //	(This event is deprecated, use the press event instead)
	this.firePress({/* no parameters */});
};

/**
 * Handle the key up event for SPACE and ENTER.
 *
 * @param {jQuery.Event} oEvent - the keyboard event.
 * @private
 */
sap.m.Image.prototype.onkeyup = function(oEvent) {
	if (oEvent.which === jQuery.sap.KeyCodes.SPACE || oEvent.which === jQuery.sap.KeyCodes.ENTER) {
		this.firePress({/* no parameters */});
	}
};

/**
 * Test if at least one of the width and height properties is set.
 *
 * @private
 */
sap.m.Image.prototype._isWidthOrHeightSet = function() {
	return (this.getWidth() && this.getWidth() !== '') || (this.getHeight() && this.getHeight() !== '');
};

/**
 * This function returns the density aware source based on the deviceDensityRatio value.
 * The return value is in the format [src]@[densityValue].[extension] if the densityValue not equal 1, otherwise it returns the src property.
 *
 * @private
 */
sap.m.Image.prototype._getDensityAwareSrc = function() {
	var d = sap.m.Image._currentDevicePixelRatio,
		sSrc = this.getSrc();

	// this property is used for resizing the higher resolution image when image is loaded.
	this._iLoadImageDensity = d;

	// if devicePixelRatio equals 1 or densityAware set to false, simply return the src property
	if (d === 1 || !this.getDensityAware()) {
		return sSrc;
	}

	return this._generateSrcByDensity(sSrc, d);
};

/**
 * This function returns the density aware version of the Active source base on the deviceDensityRatio value.
 *
 * @private
 */
sap.m.Image.prototype._getDensityAwareActiveSrc = function() {
	var d = sap.m.Image._currentDevicePixelRatio,
		sActiveSrc = this.getActiveSrc();

	// this property is used for resizing the higher resolution image when image is loaded.
	this._iLoadImageDensity = d;

	// if devicePixelRatio equals 1 or densityAware set to false, simply return the src property
	if (d === 1 || !this.getDensityAware()) {
		return sActiveSrc;
	}

	return this._generateSrcByDensity(sActiveSrc, d);
};

/**
 * This function generates the density aware version of the src property according to the iDensity provided.
 * It returns the density aware version of the src property.
 *
 * @private
 */
sap.m.Image.prototype._generateSrcByDensity = function(sSrc, iDensity) {
	if (!sSrc) {
		return "";
	}

	// if src is in data uri format, disable the density handling
	if (this._isDataUri(sSrc)) {
		this._iLoadImageDensity = 1;
		return sSrc;
	}

	if (iDensity === 1) {
		return sSrc;
	}

	var iLastDotPos = sSrc.lastIndexOf("."),
		iLastSlashPos = sSrc.lastIndexOf("/"),
		sName = sSrc.substring(0, iLastDotPos),
		sExtension = sSrc.substring(iLastDotPos);

	// if there's no extension
	// or there's slash after the last dot, this means that the dot may come from the host name
	if (iLastDotPos === -1 || (iLastSlashPos > iLastDotPos)) {
		return sSrc + "@" + iDensity;
	}

	sName = sName + "@" + iDensity;
	return sName + sExtension;
};

sap.m.Image.prototype._isDataUri = function(src) {
	return src ? src.indexOf("data:") === 0 : false;
};
}; // end of sap/m/Image.js
if ( !jQuery.sap.isDeclared('sap.m.InputBase') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.m.InputBase.
jQuery.sap.declare("sap.m.InputBase");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new InputBase.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getValue value} : string</li>
 * <li>{@link #getWidth width} : sap.ui.core.CSSSize</li>
 * <li>{@link #getEnabled enabled} : boolean (default: true)</li>
 * <li>{@link #getVisible visible} : boolean (default: true)</li>
 * <li>{@link #getValueState valueState} : sap.ui.core.ValueState (default: sap.ui.core.ValueState.None)</li>
 * <li>{@link #getName name} : string</li>
 * <li>{@link #getPlaceholder placeholder} : string</li>
 * <li>{@link #getEditable editable} : boolean (default: true)</li></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul>
 * <li>{@link sap.m.InputBase#event:change change} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * Base control for Input fields.
 * @extends sap.ui.core.Control
 *
 * @author SAP AG 
 * @version 1.20.6
 *
 * @constructor   
 * @public
 * @since 1.12.0
 * @name sap.m.InputBase
 */
sap.ui.core.Control.extend("sap.m.InputBase", { metadata : {

	// ---- object ----

	// ---- control specific ----
	library : "sap.m",
	properties : {
		"value" : {type : "string", group : "Data", defaultValue : null, bindable : "bindable"},
		"width" : {type : "sap.ui.core.CSSSize", group : "Appearance", defaultValue : null},
		"enabled" : {type : "boolean", group : "Behavior", defaultValue : true},
		"visible" : {type : "boolean", group : "Appearance", defaultValue : true},
		"valueState" : {type : "sap.ui.core.ValueState", group : "Data", defaultValue : sap.ui.core.ValueState.None},
		"name" : {type : "string", group : "Misc", defaultValue : null},
		"placeholder" : {type : "string", group : "Misc", defaultValue : null},
		"editable" : {type : "boolean", group : "Misc", defaultValue : true}
	},
	events : {
		"change" : {}
	}
}});


/**
 * Creates a new subclass of class sap.m.InputBase with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.m.InputBase.extend
 * @function
 */

sap.m.InputBase.M_EVENTS = {'change':'change'};


/**
 * Getter for property <code>value</code>.
 * Input Value
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>value</code>
 * @public
 * @name sap.m.InputBase#getValue
 * @function
 */

/**
 * Setter for property <code>value</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sValue  new value for property <code>value</code>
 * @return {sap.m.InputBase} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.InputBase#setValue
 * @function
 */


/**
 * Binder for property <code>value</code>.
 *
 * @param {string} sPath path to a property in the model 
 * @param {function} [fnFormatter=null] the formatter function
 * @param {sap.ui.model.BindingMode} [sMode=Default] the binding mode to be used for this property binding (e.g. one way) 
 * @return {sap.m.InputBase} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.InputBase#bindValue
 * @function
 */

/**
 * Unbinder for property <code>value</code>.
 *
 * @return {sap.m.InputBase} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.InputBase#unbindValue
 * @function
 */


/**
 * Getter for property <code>width</code>.
 * Defines the width of the input.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>width</code>
 * @public
 * @name sap.m.InputBase#getWidth
 * @function
 */

/**
 * Setter for property <code>width</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.core.CSSSize} sWidth  new value for property <code>width</code>
 * @return {sap.m.InputBase} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.InputBase#setWidth
 * @function
 */


/**
 * Getter for property <code>enabled</code>.
 * Boolean property to enable the control (default is true).
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>enabled</code>
 * @public
 * @name sap.m.InputBase#getEnabled
 * @function
 */

/**
 * Setter for property <code>enabled</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bEnabled  new value for property <code>enabled</code>
 * @return {sap.m.InputBase} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.InputBase#setEnabled
 * @function
 */


/**
 * Getter for property <code>visible</code>.
 * Invisible inputs are not rendered
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>visible</code>
 * @public
 * @name sap.m.InputBase#getVisible
 * @function
 */

/**
 * Setter for property <code>visible</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bVisible  new value for property <code>visible</code>
 * @return {sap.m.InputBase} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.InputBase#setVisible
 * @function
 */


/**
 * Getter for property <code>valueState</code>.
 * Visualizes warnings or errors related to the text field. Possible values: Warning, Error, Success.
 *
 * Default value is <code>None</code>
 *
 * @return {sap.ui.core.ValueState} the value of property <code>valueState</code>
 * @public
 * @name sap.m.InputBase#getValueState
 * @function
 */

/**
 * Setter for property <code>valueState</code>.
 *
 * Default value is <code>None</code> 
 *
 * @param {sap.ui.core.ValueState} oValueState  new value for property <code>valueState</code>
 * @return {sap.m.InputBase} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.InputBase#setValueState
 * @function
 */


/**
 * Getter for property <code>name</code>.
 * The 'name' property to be used in the HTML code (e.g. for HTML forms that send data to the server via 'submit').
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>name</code>
 * @public
 * @name sap.m.InputBase#getName
 * @function
 */

/**
 * Setter for property <code>name</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sName  new value for property <code>name</code>
 * @return {sap.m.InputBase} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.InputBase#setName
 * @function
 */


/**
 * Getter for property <code>placeholder</code>.
 * text shown when no value available
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>placeholder</code>
 * @public
 * @name sap.m.InputBase#getPlaceholder
 * @function
 */

/**
 * Setter for property <code>placeholder</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sPlaceholder  new value for property <code>placeholder</code>
 * @return {sap.m.InputBase} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.InputBase#setPlaceholder
 * @function
 */


/**
 * Getter for property <code>editable</code>.
 * Controls if a user can change the value.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>editable</code>
 * @public
 * @since 1.12.0
 * @name sap.m.InputBase#getEditable
 * @function
 */

/**
 * Setter for property <code>editable</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bEditable  new value for property <code>editable</code>
 * @return {sap.m.InputBase} <code>this</code> to allow method chaining
 * @public
 * @since 1.12.0
 * @name sap.m.InputBase#setEditable
 * @function
 */


/**
 * This event gets fired when the input operation has finished and the value has changed. 
 *
 * @name sap.m.InputBase#change
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters

 * @param {string} oControlEvent.getParameters.newValue The new value of the input
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'change' event of this <code>sap.m.InputBase</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.m.InputBase</code>.<br/> itself. 
 *  
 * This event gets fired when the input operation has finished and the value has changed. 
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.m.InputBase</code>.<br/> itself.
 *
 * @return {sap.m.InputBase} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.InputBase#attachChange
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'change' event of this <code>sap.m.InputBase</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.m.InputBase} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.InputBase#detachChange
 * @function
 */

/**
 * Fire event change to attached listeners.
 * 
 * Expects following event parameters:
 * <ul>
 * <li>'newValue' of type <code>string</code> The new value of the input</li>
 * </ul>
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.m.InputBase} <code>this</code> to allow method chaining
 * @protected
 * @name sap.m.InputBase#fireChange
 * @function
 */


// Start of sap\m\InputBase.js
jQuery.sap.require('sap.ui.core.EnabledPropagator'); // unlisted dependency retained

jQuery.sap.require('sap.ui.core.IconPool'); // unlisted dependency retained

sap.ui.core.EnabledPropagator.call(sap.m.InputBase.prototype);
sap.ui.core.IconPool.insertFontFaceStyle();

/* =========================================================== */
/* Private methods and properties                              */
/* =========================================================== */

/* ----------------------------------------------------------- */
/* Private properties                                          */
/* ----------------------------------------------------------- */

// use labels as placeholder configuration
sap.m.InputBase.prototype._bShowLabelAsPlaceholder = (function(oDevice) {

	if (!oDevice.support.input.placeholder) {
		return true;
	}

	var bUseLabel = oDevice.support.touch;

	// These OS supports right alignable placeholder natively,
	// so we do not need selfmade placeholder.
	// test page :  http://jsfiddle.net/qKPX2/3/
	if (bUseLabel && ((oDevice.os.ios && oDevice.os.version >= 6) ||
						(oDevice.os.android && oDevice.browser.chrome)) ||
						(oDevice.os.blackberry && oDevice.os.version >= 10)) {

		bUseLabel = null;	// this means derived class can make it's own checking
	}

	return bUseLabel;
}(sap.ui.Device));

/* ----------------------------------------------------------- */
/* Private methods                                             */
/* ----------------------------------------------------------- */

sap.m.InputBase.prototype._setLabelVisibility = function() {
	if (this.getDomRef() && this._$label) {
		this._$label.css("display", this.getValue() ? "none" : "inline");
	}
};

sap.m.InputBase.prototype._getInputValue = function(sValue) {
	sValue = (typeof sValue == "undefined") ? this._$input.val() : sValue.toString();

	if (this.getMaxLength && this.getMaxLength() > 0) {
		sValue = sValue.substring(0, this.getMaxLength());
	}

	return sValue;
};

sap.m.InputBase.prototype.setMaxLength = function(iMaxLength) {
	if (iMaxLength < 0) {
		return this;
	}

	this.setProperty("maxLength", iMaxLength, true);

	if (this.getDomRef()) {
		if (iMaxLength === 0) {
			this._$input.removeAttr("maxlength");
		} else {
			this._$input.val(this._$input.val().substring(0, iMaxLength));
			this._$input.attr("maxlength", iMaxLength);
		}
	}

	return this;
};

/* =========================================================== */
/* Lifecycle methods                                           */
/* =========================================================== */

/**
 * Initialization hook.
 *
 * @private
 */
sap.m.InputBase.prototype.init = function() {
	this._curpos = 0;	// cursor position
	this._lastValue = "";	// last changed value
	this._changeProxy = jQuery.proxy(this._onChange, this);
};

/**
 * Required adaptations before rendering.
 *
 * @private
 */
sap.m.InputBase.prototype.onBeforeRendering = function() {
	if (this.getDomRef()) {
		this._$input.off();
		this._curpos = this._$input.cursorPos();
	}
};

/**
 * Required adaptations after rendering.
 *
 * @private
 */
sap.m.InputBase.prototype.onAfterRendering = function() {
	this._$input = this.$("inner");
	this._$input.on("change", this._changeProxy);

	if (this._bShowLabelAsPlaceholder) {
		this._$label = this.$().find("label");
		this._setLabelVisibility();

		// workaround for iOS 5 bug - see http://stackoverflow.com/questions/7358781/tapping-on-label-in-mobile-safari
		if (sap.ui.Device.os.ios && sap.ui.Device.os.version <= 5) {
			this._$label.on("click", function() {});
		}
	}
};

/**
 * Cleans up before destruction.
 *
 * @private
 */
sap.m.InputBase.prototype.exit = function() {
	this._$input = null;
	this._$label = null;
};

/* =========================================================== */
/* Event handlers                                              */
/* =========================================================== */

/**
 * Handle the touch start event on the Input.
 *
 * @param {jQuery.Event} oEvent The event object.
 * @private
 */
sap.m.InputBase.prototype.ontouchstart = function(oEvent) {

	// mark the event for components that needs to know if the event was handled
	oEvent.setMarked();
};

/**
 * Handle the touch end event on the Input.
 *
 * @param {jQuery.Event} oEvent The event object.
 * @private
 */
sap.m.InputBase.prototype.ontouchend = function(oEvent) {
	// remember the cursor position
	this._curpos = this._$input.cursorPos();
};

sap.m.InputBase.prototype.onkeyup = function(oEvent) {
	// remember the cursor position
	this._curpos = this._$input.cursorPos();
};

sap.m.InputBase.prototype.onfocusout = function(oEvent) {

	// IE doesn't fire change event on blur sometimes
	// set initial value empty, type some text
	// hit Enter (actually here does not update internal value because does not fire change with enter)
	// return back to initial value and then blur
	// no change event is fired
	if (sap.ui.Device.browser.msie) {

		// fire event
		this._onChange(oEvent);
	}

	// ios Safari changes scrollTop, remove it in case of iScroll
	if (sap.ui.Device.os.ios) {
		var oScrollDelegate = sap.m.getScrollDelegate(this);

		if (oScrollDelegate) {
			oScrollDelegate.refresh();
		}
	}
};

sap.m.InputBase.prototype._onChange = function(oEvent) {
	// make sure _$input exists on change for async calls
	if (!this._$input) {
		return;
	}

	// compare with the old known value
	var sValue = this._getInputValue();

	if (sValue !== this._lastValue) {
		this.setProperty("value", sValue, true);
		this._curpos = this._$input.cursorPos();
		this._setLabelVisibility();
		this._lastValue = sValue;
		this.fireChange({
			value: sValue,

			// backwards compatibility
			newValue: sValue
		});
	}
};

/* ----------------------------------------------------------- */
/* Keyboard handling                                           */
/* ----------------------------------------------------------- */

/**
 * Handle when enter is pressed.
 *
 * @param {jQuery.Event} oEvent The event object.
 * @private
 */
sap.m.InputBase.prototype.onsapenter = function(oEvent) {

	// IE doesn't fire change event for inputs when we hit Enter
	if (sap.ui.Device.browser.msie && oEvent.target.tagName.toUpperCase() === "INPUT") {

		// fire event
		this._onChange(oEvent);
	}

};

/**
 * Handle when escape is pressed.
 *
 * @param {jQuery.Event} oEvent The event object.
 * @private
 */
sap.m.InputBase.prototype.onsapescape = function(oEvent) {

	// revert to the old value
	var sValue = this._getInputValue();

	if (sValue !== this._lastValue) {
		this.setValue(this._lastValue);
		this.fireEvent("liveChange", {
			value: this._lastValue,

			// backwards compatibility
			newValue: this._lastValue
		});
	}
};

/* =========================================================== */
/* API methods                                                 */
/* =========================================================== */

/* ----------------------------------------------------------- */
/* protected methods                                           */
/* ----------------------------------------------------------- */

/**
 * Register an event listener to the browser input event.
 *
 * @param {function} fnCallback Function to be called when the value of the input element is changed.
 * @protected
 * @name sap.m.InputBase#_bindToInputEvent
 */
sap.m.InputBase.prototype._bindToInputEvent = function(fnCallback) {
	this._$input.on("input", fnCallback);

	// input event in IE9 doesn't fire when we hit BACKSPACE / DEL / CUT
	var mBrowser = sap.ui.Device.browser;

	if (mBrowser.msie && mBrowser.version < 10) {
		this._$input.on({
			cut: function(oEvent) {
				setTimeout(function() {
					fnCallback(oEvent);
				}, 0);
			},

			keyup: function(oEvent) {
				var oKC = jQuery.sap.KeyCodes;
				if (oEvent.which === oKC.DELETE || oEvent.which === oKC.BACKSPACE) {
					fnCallback(oEvent);
				}
			}
		});
	}
};

/* ----------------------------------------------------------- */
/* public methods                                              */
/* ----------------------------------------------------------- */

/**
 * Setter for property <code>valueState</code>.
 *
 * Default value is <code>None</code>.
 *
 * @param {sap.ui.core.ValueState} oValueState New value for property <code>valueState</code>.
 * @return {sap.m.InputBase} <code>this</code> to allow method chaining.
 * @public
 * @name sap.m.InputBase#setValueState
 * @function
 */
sap.m.InputBase.prototype.setValueState = function(sValueState) {
	var sOldValueState = this.getValueState();
	sValueState = this.validateProperty("valueState", sValueState);

	if (sValueState === sOldValueState) {
		return this;
	}

	if (!this.getDomRef()) {
		return this.setProperty("valueState", sValueState);
	}

	var $container = this.$();
	this.setProperty("valueState", sValueState, true);

	if (sOldValueState) {
		$container.removeClass("sapMInputBase" + sOldValueState);
		this._$input.removeClass("sapMInputBase" + sOldValueState + "Inner");
	}

	if (sValueState) {
		$container.addClass("sapMInputBase" + sValueState);
		this._$input.addClass("sapMInputBase" + sValueState + "Inner");
	}

	// set tooltip based on state (will be undefined when state is None)
	var sTooltip = sap.ui.core.ValueStateSupport.enrichTooltip(this, this.getTooltip_AsString());
	this.$().attr("title", sTooltip || "");

	return this;
};

/**
 * Setter for property <code>value</code>.
 *
 * Default value is empty/<code>undefined</code>.
 *
 * @param {string} sValue New value for property <code>value</code>.
 * @return {sap.m.InputBase} <code>this</code> to allow method chaining.
 * @public
 * @name sap.m.InputBase#setValue
 * @function
 */
sap.m.InputBase.prototype.setValue = function(sValue) {
	sValue = this.validateProperty("value", sValue);
	sValue = this._getInputValue(sValue);

	if (sValue !== this.getValue()) {
		this._lastValue = sValue;
		this.setProperty("value", sValue, true);

		if (this.getDomRef() && (this._getInputValue() !== sValue)) {
			this._$input.val(sValue);
			this._setLabelVisibility();
			this._curpos = this._$input.cursorPos();
		}
	}

	return this;
};

/**
 * Setter for property <code>width</code>.
 *
 * Default value is empty/<code>undefined</code>.
 *
 * @param {sap.ui.core.CSSSize} sWidth New value for property <code>width</code>.
 * @return {sap.m.InputBase} <code>this</code> to allow method chaining.
 * @public
 * @name sap.m.InputBase#setWidth
 * @function
 */
sap.m.InputBase.prototype.setWidth = function(sWidth) {
	this.setProperty("width", sWidth, true);
	this.$().css("width", this.getWidth());
	return this;
};

/**
 * Setter for property <code>placeholder</code>.
 *
 * Default value is empty/<code>undefined</code>.
 *
 * @param {string} sPlaceholder New value for property <code>placeholder</code>.
 * @return {sap.m.InputBase} <code>this</code> to allow method chaining.
 * @public
 * @name sap.m.InputBase#setPlaceholder
 * @function
 */
sap.m.InputBase.prototype.setPlaceholder = function(sPlaceholder) {
	this.setProperty("placeholder", sPlaceholder, true);

	if (this.getDomRef()) {

		if (this._$label) {
			this._$label.text(this.getPlaceholder());
		} else {
			this._$input.attr("placeholder", this.getPlaceholder());
		}
	}

	return this;
};

sap.m.InputBase.prototype.getFocusInfo = function() {
	return {
		id: this.getId(),
		cursorPos: this._curpos
	};
};

sap.m.InputBase.prototype.applyFocusInfo = function(oFocusInfo) {
	if (this.getDomRef()) {
		sap.ui.core.Element.prototype.applyFocusInfo.call(this, oFocusInfo);
		this._$input.cursorPos(this._curpos);
	}

	return this;
};

sap.m.InputBase.prototype.getFocusDomRef = function() {
	return this.$("inner")[0] || null;
};

sap.m.InputBase.prototype.getIdForLabel = function() {
	return this.getId() + '-inner';
};
}; // end of sap/m/InputBase.js
if ( !jQuery.sap.isDeclared('sap.m.InputListItemRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare("sap.m.InputListItemRenderer");
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained



/**
 * @class InputListItem renderer.
 * @static
 */
sap.m.InputListItemRenderer = sap.ui.core.Renderer.extend(sap.m.ListItemBaseRenderer);

/**
 * Renders the HTML for the given control, using the provided
 * {@link sap.ui.core.RenderManager}.
 * 
 * @param {sap.ui.core.RenderManager}
 *          oRenderManager the RenderManager that can be used for writing to the
 *          Render-Output-Buffer
 * @param {sap.ui.core.Control}
 *          oControl an object representation of the control that should be
 *          rendered
 */
sap.m.InputListItemRenderer.renderLIAttributes = function(rm, oLI) {
	rm.addClass("sapMILI");
};

sap.m.InputListItemRenderer.renderLIContent = function(rm, oLI) {

	var sLabel = oLI.getLabel();

	// List item label
	if (sLabel) {
		rm.write("<label for='" + oLI.getId() + "-content' class='sapMILILabel'>");
		rm.writeEscaped(oLI.getLabel());
		rm.write("</label>");
	}

	// List item input content
	rm.write("<div class='sapMILIDiv sapMILI-CTX'>");

	var aContent = oLI.getContent();
	var cLength = aContent.length;
	for ( var i = 0; i < cLength; i++) {
		rm.renderControl(aContent[i]);
	}
	rm.write("</div>");
};

}; // end of sap/m/InputListItemRenderer.js
if ( !jQuery.sap.isDeclared('sap.m.Label') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.m.Label.
jQuery.sap.declare("sap.m.Label");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new Label.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getDesign design} : sap.m.LabelDesign (default: sap.m.LabelDesign.Standard)</li>
 * <li>{@link #getText text} : string</li>
 * <li>{@link #getVisible visible} : boolean (default: true)</li>
 * <li>{@link #getTextAlign textAlign} : sap.ui.core.TextAlign (default: sap.ui.core.TextAlign.Begin)</li>
 * <li>{@link #getTextDirection textDirection} : sap.ui.core.TextDirection (default: sap.ui.core.TextDirection.Inherit)</li>
 * <li>{@link #getWidth width} : sap.ui.core.CSSSize (default: '')</li>
 * <li>{@link #getRequired required} : boolean (default: false)</li></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul>
 * <li>{@link #getLabelFor labelFor} : string | sap.ui.core.Control</li></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * Label control is used in a UI5 mobile application to provide label text for other controls. Design such as bold, and text alignment can be specified.
 * @extends sap.ui.core.Control
 * @implements sap.ui.core.Label
 *
 * @author SAP AG 
 * @version 1.20.6
 *
 * @constructor   
 * @public
 * @name sap.m.Label
 */
sap.ui.core.Control.extend("sap.m.Label", { metadata : {

	// ---- object ----
	interfaces : [
		"sap.ui.core.Label"
	],

	// ---- control specific ----
	library : "sap.m",
	properties : {
		"design" : {type : "sap.m.LabelDesign", group : "Appearance", defaultValue : sap.m.LabelDesign.Standard},
		"text" : {type : "string", group : "Misc", defaultValue : null},
		"visible" : {type : "boolean", group : "Appearance", defaultValue : true},
		"textAlign" : {type : "sap.ui.core.TextAlign", group : "Appearance", defaultValue : sap.ui.core.TextAlign.Begin},
		"textDirection" : {type : "sap.ui.core.TextDirection", group : "Appearance", defaultValue : sap.ui.core.TextDirection.Inherit},
		"width" : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : ''},
		"required" : {type : "boolean", group : "Misc", defaultValue : false}
	},
	associations : {
		"labelFor" : {type : "sap.ui.core.Control", multiple : false}
	}
}});


/**
 * Creates a new subclass of class sap.m.Label with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.m.Label.extend
 * @function
 */


/**
 * Getter for property <code>design</code>.
 * set design of a label to either Standard or Bold
 *
 * Default value is <code>sap.m.LabelDesign.Standard</code>
 *
 * @return {sap.m.LabelDesign} the value of property <code>design</code>
 * @public
 * @name sap.m.Label#getDesign
 * @function
 */

/**
 * Setter for property <code>design</code>.
 *
 * Default value is <code>sap.m.LabelDesign.Standard</code> 
 *
 * @param {sap.m.LabelDesign} oDesign  new value for property <code>design</code>
 * @return {sap.m.Label} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Label#setDesign
 * @function
 */


/**
 * Getter for property <code>text</code>.
 * Label Text to be displayed
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>text</code>
 * @public
 * @name sap.m.Label#getText
 * @function
 */

/**
 * Setter for property <code>text</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sText  new value for property <code>text</code>
 * @return {sap.m.Label} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Label#setText
 * @function
 */


/**
 * Getter for property <code>visible</code>.
 * Invisible labels are not rendered
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>visible</code>
 * @public
 * @name sap.m.Label#getVisible
 * @function
 */

/**
 * Setter for property <code>visible</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bVisible  new value for property <code>visible</code>
 * @return {sap.m.Label} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Label#setVisible
 * @function
 */


/**
 * Getter for property <code>textAlign</code>.
 * Available alignment settings are "Begin", "Center", "End", "Left", and "Right".
 *
 * Default value is <code>sap.ui.core.TextAlign.Begin</code>
 *
 * @return {sap.ui.core.TextAlign} the value of property <code>textAlign</code>
 * @public
 * @name sap.m.Label#getTextAlign
 * @function
 */

/**
 * Setter for property <code>textAlign</code>.
 *
 * Default value is <code>sap.ui.core.TextAlign.Begin</code> 
 *
 * @param {sap.ui.core.TextAlign} oTextAlign  new value for property <code>textAlign</code>
 * @return {sap.m.Label} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Label#setTextAlign
 * @function
 */


/**
 * Getter for property <code>textDirection</code>.
 * Options for the text direction are RTL and LTR. Alternatively, the control can inherit the text direction from its parent container.
 *
 * Default value is <code>sap.ui.core.TextDirection.Inherit</code>
 *
 * @return {sap.ui.core.TextDirection} the value of property <code>textDirection</code>
 * @public
 * @name sap.m.Label#getTextDirection
 * @function
 */

/**
 * Setter for property <code>textDirection</code>.
 *
 * Default value is <code>sap.ui.core.TextDirection.Inherit</code> 
 *
 * @param {sap.ui.core.TextDirection} oTextDirection  new value for property <code>textDirection</code>
 * @return {sap.m.Label} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Label#setTextDirection
 * @function
 */


/**
 * Getter for property <code>width</code>.
 * Width of Label
 *
 * Default value is <code>''</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>width</code>
 * @public
 * @name sap.m.Label#getWidth
 * @function
 */

/**
 * Setter for property <code>width</code>.
 *
 * Default value is <code>''</code> 
 *
 * @param {sap.ui.core.CSSSize} sWidth  new value for property <code>width</code>
 * @return {sap.m.Label} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Label#setWidth
 * @function
 */


/**
 * Getter for property <code>required</code>.
 * Indicates that user input is required in the input this label labels.
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>required</code>
 * @public
 * @name sap.m.Label#getRequired
 * @function
 */

/**
 * Setter for property <code>required</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bRequired  new value for property <code>required</code>
 * @return {sap.m.Label} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Label#setRequired
 * @function
 */


/**
 * Association to the labeled control.
 * By default the label set the for attribute to the ID of the labeled control. This can be changed implementing function getIdForLabel on the labelled control.
 *
 * @return {string} Id of the element which is the current target of the <code>labelFor</code> association, or null
 * @public
 * @name sap.m.Label#getLabelFor
 * @function
 */

/**
 * Association to the labeled control.
 * By default the label set the for attribute to the ID of the labeled control. This can be changed implementing function getIdForLabel on the labelled control.
 *
 * @param {string | sap.ui.core.Control} vLabelFor 
 *    Id of an element which becomes the new target of this <code>labelFor</code> association.
 *    Alternatively, an element instance may be given.
 * @return {sap.m.Label} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Label#setLabelFor
 * @function
 */


	
// Start of sap\m\Label.js

/*
 * As own function to make possible to overwrite it (e.G. from Form).
 */
sap.m.Label.prototype.getLabelForRendering = function(){

	return this.getLabelFor();

};
}; // end of sap/m/Label.js
if ( !jQuery.sap.isDeclared('sap.m.Link') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.m.Link.
jQuery.sap.declare("sap.m.Link");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new Link.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getText text} : string (default: '')</li>
 * <li>{@link #getEnabled enabled} : boolean (default: true)</li>
 * <li>{@link #getVisible visible} : boolean (default: true)</li>
 * <li>{@link #getTarget target} : string</li>
 * <li>{@link #getWidth width} : sap.ui.core.CSSSize</li>
 * <li>{@link #getHref href} : sap.ui.core.URI</li>
 * <li>{@link #getWrapping wrapping} : boolean (default: false)</li></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul>
 * <li>{@link sap.m.Link#event:press press} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * A hyperlink control which can be used to trigger actions or to navigate to other applications or web pages.
 * @extends sap.ui.core.Control
 *
 * @author SAP AG 
 * @version 1.20.6
 *
 * @constructor   
 * @public
 * @since 1.12
 * @name sap.m.Link
 */
sap.ui.core.Control.extend("sap.m.Link", { metadata : {

	// ---- object ----

	// ---- control specific ----
	library : "sap.m",
	properties : {
		"text" : {type : "string", group : "Data", defaultValue : ''},
		"enabled" : {type : "boolean", group : "Behavior", defaultValue : true},
		"visible" : {type : "boolean", group : "Appearance", defaultValue : true},
		"target" : {type : "string", group : "Behavior", defaultValue : null},
		"width" : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : null},
		"href" : {type : "sap.ui.core.URI", group : "Data", defaultValue : null},
		"wrapping" : {type : "boolean", group : "Appearance", defaultValue : false}
	},
	events : {
		"press" : {allowPreventDefault : true}
	}
}});


/**
 * Creates a new subclass of class sap.m.Link with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.m.Link.extend
 * @function
 */

sap.m.Link.M_EVENTS = {'press':'press'};


/**
 * Getter for property <code>text</code>.
 * Link text to be displayed.
 *
 * Default value is <code>''</code>
 *
 * @return {string} the value of property <code>text</code>
 * @public
 * @name sap.m.Link#getText
 * @function
 */

/**
 * Setter for property <code>text</code>.
 *
 * Default value is <code>''</code> 
 *
 * @param {string} sText  new value for property <code>text</code>
 * @return {sap.m.Link} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Link#setText
 * @function
 */


/**
 * Getter for property <code>enabled</code>.
 * Whether the link can be triggered by the user.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>enabled</code>
 * @public
 * @name sap.m.Link#getEnabled
 * @function
 */

/**
 * Setter for property <code>enabled</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bEnabled  new value for property <code>enabled</code>
 * @return {sap.m.Link} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Link#setEnabled
 * @function
 */


/**
 * Getter for property <code>visible</code>.
 * Invisible links are not rendered.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>visible</code>
 * @public
 * @name sap.m.Link#getVisible
 * @function
 */

/**
 * Setter for property <code>visible</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bVisible  new value for property <code>visible</code>
 * @return {sap.m.Link} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Link#setVisible
 * @function
 */


/**
 * Getter for property <code>target</code>.
 * Options are _self, _top, _blank, _parent, _search. Alternatively, a frame name can be entered.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>target</code>
 * @public
 * @name sap.m.Link#getTarget
 * @function
 */

/**
 * Setter for property <code>target</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sTarget  new value for property <code>target</code>
 * @return {sap.m.Link} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Link#setTarget
 * @function
 */


/**
 * Getter for property <code>width</code>.
 * Width of text link. When it is set (CSS-size such as % or px), this is the exact size. When left blank, the text defines the size.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>width</code>
 * @public
 * @name sap.m.Link#getWidth
 * @function
 */

/**
 * Setter for property <code>width</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.core.CSSSize} sWidth  new value for property <code>width</code>
 * @return {sap.m.Link} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Link#setWidth
 * @function
 */


/**
 * Getter for property <code>href</code>.
 * The link target URI. Supports standard hyperlink behavior. If an action should be triggered, this should not be set, but instead an event handler for the "press" event should be registered.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.core.URI} the value of property <code>href</code>
 * @public
 * @name sap.m.Link#getHref
 * @function
 */

/**
 * Setter for property <code>href</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.core.URI} sHref  new value for property <code>href</code>
 * @return {sap.m.Link} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Link#setHref
 * @function
 */


/**
 * Getter for property <code>wrapping</code>.
 * Whether the link text is allowed to wrap when tehre is not sufficient space.
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>wrapping</code>
 * @public
 * @name sap.m.Link#getWrapping
 * @function
 */

/**
 * Setter for property <code>wrapping</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bWrapping  new value for property <code>wrapping</code>
 * @return {sap.m.Link} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Link#setWrapping
 * @function
 */


/**
 * Event is fired when the user triggers the link control. 
 *
 * @name sap.m.Link#press
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters

 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'press' event of this <code>sap.m.Link</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.m.Link</code>.<br/> itself. 
 *  
 * Event is fired when the user triggers the link control. 
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.m.Link</code>.<br/> itself.
 *
 * @return {sap.m.Link} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Link#attachPress
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'press' event of this <code>sap.m.Link</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.m.Link} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.Link#detachPress
 * @function
 */

/**
 * Fire event press to attached listeners.
 *
 * Listeners may prevent the default action of this event using the preventDefault-method on the event object.
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {boolean} whether to prevent the default action
 * @protected
 * @name sap.m.Link#firePress
 * @function
 */


// Start of sap\m\Link.js

jQuery.sap.require('sap.ui.core.EnabledPropagator'); // unlisted dependency retained


sap.ui.core.EnabledPropagator.call(sap.m.Link.prototype);

/**
 * Also trigger link activation when space is pressed on the focused control
 */
sap.m.Link.prototype.onsapspace = function(oEvent) {
	sap.m.Link.prototype._handlePress.apply(this, arguments);
};


/**
 * Function is called when Link is triggered.
 *
 * @param {jQuery.Event} oEvent
 * @private
 */
sap.m.Link.prototype._handlePress = function(oEvent) {
	if (this.getEnabled()) {
		if (!this.firePress()) { // fire event and check return value whether default action should be prevented
			oEvent.preventDefault();
		};
	} else { // disabled
		oEvent.preventDefault(); // even prevent URLs from being triggered
	}
};

if (sap.ui.Device.support.touch) {
	sap.m.Link.prototype.ontap = sap.m.Link.prototype._handlePress;
} else {
	sap.m.Link.prototype.onclick = sap.m.Link.prototype._handlePress;
}


sap.m.Link.prototype.ontouchstart = function(oEvent) {
	// for controls which need to know whether they should handle events bubbling from here
	oEvent.originalEvent._sapui_handledByControl = true;
};
}; // end of sap/m/Link.js
if ( !jQuery.sap.isDeclared('sap.m.ListItemBase') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.m.ListItemBase.
jQuery.sap.declare("sap.m.ListItemBase");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new ListItemBase.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getType type} : sap.m.ListType (default: sap.m.ListType.Inactive)</li>
 * <li>{@link #getVisible visible} : boolean (default: true)</li>
 * <li>{@link #getUnread unread} : boolean (default: false)</li>
 * <li>{@link #getSelected selected} : boolean (default: false)</li>
 * <li>{@link #getCounter counter} : int</li></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul>
 * <li>{@link sap.m.ListItemBase#event:tap tap} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li>
 * <li>{@link sap.m.ListItemBase#event:detailTap detailTap} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li>
 * <li>{@link sap.m.ListItemBase#event:press press} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li>
 * <li>{@link sap.m.ListItemBase#event:detailPress detailPress} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * ListItemBase contains the core features of all specific list items.
 * @extends sap.ui.core.Control
 *
 * @author SAP AG 
 * @version 1.20.6
 *
 * @constructor   
 * @public
 * @name sap.m.ListItemBase
 */
sap.ui.core.Control.extend("sap.m.ListItemBase", { metadata : {

	// ---- object ----
	publicMethods : [
		// methods
		"isSelected"
	],

	// ---- control specific ----
	library : "sap.m",
	properties : {
		"type" : {type : "sap.m.ListType", group : "Misc", defaultValue : sap.m.ListType.Inactive},
		"visible" : {type : "boolean", group : "Appearance", defaultValue : true},
		"unread" : {type : "boolean", group : "Misc", defaultValue : false},
		"selected" : {type : "boolean", group : "", defaultValue : false},
		"counter" : {type : "int", group : "Misc", defaultValue : null}
	},
	events : {
		"tap" : {}, 
		"detailTap" : {}, 
		"press" : {}, 
		"detailPress" : {}
	}
}});


/**
 * Creates a new subclass of class sap.m.ListItemBase with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.m.ListItemBase.extend
 * @function
 */

sap.m.ListItemBase.M_EVENTS = {'tap':'tap','detailTap':'detailTap','press':'press','detailPress':'detailPress'};


/**
 * Getter for property <code>type</code>.
 * Type of the list item, defines the behaviour
 *
 * Default value is <code>Inactive</code>
 *
 * @return {sap.m.ListType} the value of property <code>type</code>
 * @public
 * @name sap.m.ListItemBase#getType
 * @function
 */

/**
 * Setter for property <code>type</code>.
 *
 * Default value is <code>Inactive</code> 
 *
 * @param {sap.m.ListType} oType  new value for property <code>type</code>
 * @return {sap.m.ListItemBase} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ListItemBase#setType
 * @function
 */


/**
 * Getter for property <code>visible</code>.
 * Invisible list items are not rendered
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>visible</code>
 * @public
 * @name sap.m.ListItemBase#getVisible
 * @function
 */

/**
 * Setter for property <code>visible</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bVisible  new value for property <code>visible</code>
 * @return {sap.m.ListItemBase} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ListItemBase#setVisible
 * @function
 */


/**
 * Getter for property <code>unread</code>.
 * If the unread indicator is set on the list, this boolean defines if it will be shown on this list item. Default is false.
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>unread</code>
 * @public
 * @name sap.m.ListItemBase#getUnread
 * @function
 */

/**
 * Setter for property <code>unread</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bUnread  new value for property <code>unread</code>
 * @return {sap.m.ListItemBase} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ListItemBase#setUnread
 * @function
 */


/**
 * Getter for property <code>selected</code>.
 * This property defines the select state of the list item when using Single/Multi-Selection.
 * 
 * Note: Binding the "selected" property in single selection mode, may cause unwanted results, if you have more than one selected item in your binding
 * 
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>selected</code>
 * @public
 * @name sap.m.ListItemBase#getSelected
 * @function
 */

/**
 * Setter for property <code>selected</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bSelected  new value for property <code>selected</code>
 * @return {sap.m.ListItemBase} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ListItemBase#setSelected
 * @function
 */


/**
 * Getter for property <code>counter</code>.
 * Property sets a counter bubble with the integer given.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {int} the value of property <code>counter</code>
 * @public
 * @name sap.m.ListItemBase#getCounter
 * @function
 */

/**
 * Setter for property <code>counter</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {int} iCounter  new value for property <code>counter</code>
 * @return {sap.m.ListItemBase} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ListItemBase#setCounter
 * @function
 */


/**
 * tap event (This event is deprecated, use the press event instead) 
 *
 * @name sap.m.ListItemBase#tap
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters

 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'tap' event of this <code>sap.m.ListItemBase</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.m.ListItemBase</code>.<br/> itself. 
 *  
 * tap event (This event is deprecated, use the press event instead) 
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.m.ListItemBase</code>.<br/> itself.
 *
 * @return {sap.m.ListItemBase} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ListItemBase#attachTap
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'tap' event of this <code>sap.m.ListItemBase</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.m.ListItemBase} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ListItemBase#detachTap
 * @function
 */

/**
 * Fire event tap to attached listeners.

 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.m.ListItemBase} <code>this</code> to allow method chaining
 * @protected
 * @name sap.m.ListItemBase#fireTap
 * @function
 */


/**
 * detail tap event (This event is deprecated, use the detailPress event instead) 
 *
 * @name sap.m.ListItemBase#detailTap
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters

 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'detailTap' event of this <code>sap.m.ListItemBase</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.m.ListItemBase</code>.<br/> itself. 
 *  
 * detail tap event (This event is deprecated, use the detailPress event instead) 
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.m.ListItemBase</code>.<br/> itself.
 *
 * @return {sap.m.ListItemBase} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ListItemBase#attachDetailTap
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'detailTap' event of this <code>sap.m.ListItemBase</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.m.ListItemBase} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ListItemBase#detachDetailTap
 * @function
 */

/**
 * Fire event detailTap to attached listeners.

 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.m.ListItemBase} <code>this</code> to allow method chaining
 * @protected
 * @name sap.m.ListItemBase#fireDetailTap
 * @function
 */


/**
 * Event is fired when the user clicks on the control. 
 *
 * @name sap.m.ListItemBase#press
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters

 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'press' event of this <code>sap.m.ListItemBase</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.m.ListItemBase</code>.<br/> itself. 
 *  
 * Event is fired when the user clicks on the control. 
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.m.ListItemBase</code>.<br/> itself.
 *
 * @return {sap.m.ListItemBase} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ListItemBase#attachPress
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'press' event of this <code>sap.m.ListItemBase</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.m.ListItemBase} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ListItemBase#detachPress
 * @function
 */

/**
 * Fire event press to attached listeners.

 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.m.ListItemBase} <code>this</code> to allow method chaining
 * @protected
 * @name sap.m.ListItemBase#firePress
 * @function
 */


/**
 * Event is fired when the user clicks on the detail button of the control. 
 *
 * @name sap.m.ListItemBase#detailPress
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters

 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'detailPress' event of this <code>sap.m.ListItemBase</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.m.ListItemBase</code>.<br/> itself. 
 *  
 * Event is fired when the user clicks on the detail button of the control. 
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.m.ListItemBase</code>.<br/> itself.
 *
 * @return {sap.m.ListItemBase} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ListItemBase#attachDetailPress
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'detailPress' event of this <code>sap.m.ListItemBase</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.m.ListItemBase} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ListItemBase#detachDetailPress
 * @function
 */

/**
 * Fire event detailPress to attached listeners.

 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.m.ListItemBase} <code>this</code> to allow method chaining
 * @protected
 * @name sap.m.ListItemBase#fireDetailPress
 * @function
 */


/**
 * returns the state of the item selection as a boolean
 *
 * @name sap.m.ListItemBase.prototype.isSelected
 * @function

 * @type boolean
 * @public
 * @deprecated Since version 1.10.2. 
 * API Change makes this method unnecessary
 */


// Start of sap\m\ListItemBase.js
jQuery.sap.require('sap.ui.core.theming.Parameters'); // unlisted dependency retained


// IE9 does not support flex-box: do special table-based rendering (see List_noFlex.css)
sap.m.ListItemBase.prototype._bNoFlex = !jQuery.support.hasFlexBoxSupport;

// image path for different theme and OS
sap.m.ListItemBase.prototype._sImagePath = jQuery.sap.getModulePath("sap.m", "/") + "themes/" + sap.ui.getCore().getConfiguration().getTheme() + "/img/list/" + (jQuery.os.ios ? "ios" : "android") + "/";

// mode of the list e.g. singleSelection, multi...
// internal selected state of the listitem
sap.m.ListItemBase.prototype.init = function() {
	this._active = false;
	this._mode = "None";
};

/*
 * Returns the binding context path via checking the named model of parent
 *
 * @protected
 * @since 1.16.3
 */
sap.m.ListItemBase.prototype.getBindingContextPath = function(sModelName) {
	if (this._listId && !sModelName) {
		sModelName = (sap.ui.getCore().byId(this._listId).getBindingInfo("items") || {}).model;
	}

	var oContext = this.getBindingContext(sModelName);
	if (oContext) {
		return oContext.getPath();
	}
};

// radiobutton for single selection
sap.m.ListItemBase.prototype._getRadioButton = function(oRadioButtonId, sGroupName) {

	// maybe mode is changed
	if (this.hasOwnProperty("_checkBox")) {
		this._checkBox.destroy();
		delete this._checkBox;
	}

	return this._radioButton || (this._radioButton = new sap.m.RadioButton(oRadioButtonId, {
		groupName : sGroupName,
		activeHandling : false,
		selected : this.getSelected()
	}).setParent(this, null, true).attachSelect(this._select)).setTabIndex(-1);
};

// checkbox for multiselection
sap.m.ListItemBase.prototype._getCheckBox = function(oBoxId) {

	// maybe mode is changed
	if (this.hasOwnProperty("_radioButton")) {
		this._radioButton.destroy();
		delete this._radioButton;
	}

	return this._checkBox || (this._checkBox = new sap.m.CheckBox(oBoxId, {
		activeHandling : false,
		selected : this.getSelected()
	}).setParent(this, null, true).attachSelect(this._select)).setTabIndex(-1);
};

sap.m.ListItemBase.prototype.exit = function() {
	if (this._radioButton) {
		this._radioButton.destroy();
		delete this._radioButton;
	}

	if (this._checkBox) {
		this._checkBox.destroy();
		delete this._checkBox;
	}

	if (this._navImage) {
		this._navImage.destroy();
		delete this._navImage;
	}

	if (this._delIcon) {
		this._delIcon.destroy();
		delete this._delIcon;
	}

	if (this._navIcon) {
		this._navIcon.destroy();
		delete this._navIcon;
	}

	if (this._detailIcon) {
		this._detailIcon.destroy();
		delete this._detailIcon;
	}

	this._oLastFocused = null;
};

sap.m.ListItemBase.prototype.isSelectable = function() {
	return true;
};

sap.m.ListItemBase.prototype.isSelected = function() {
	if (this.isSelectable()) {
		return this.getProperty("selected");
	}
	return false;
};

sap.m.ListItemBase.prototype.getSelected = function() {
	return this.isSelected();
};

sap.m.ListItemBase.prototype.setSelected = function(bSelect, bDontNotifyParent) {
	bSelect = this.validateProperty("selected", bSelect);

	if (this.isSelectable() && bSelect != this.getProperty("selected")) {

		// notify parent about the selection first
		if (!bDontNotifyParent && this._listId) {
			var oParent = sap.ui.getCore().byId(this._listId);
			if (oParent && oParent.onItemSetSelected) {
				oParent.onItemSetSelected(this, bSelect);
			}
		}

		// update selection box
		if (this._checkBox) {
			this._checkBox.setSelected(bSelect);
		} else if (this._radioButton) {
			this._radioButton.setSelected(bSelect);
		}

		// update DOM
		if (this.getDomRef()) {
			this.$().toggleClass("sapMLIBSelected", bSelect);
		}

		// set the property
		this.setProperty("selected", bSelect, true);
	}

	return this;
};

sap.m.ListItemBase.prototype.setActive = function(bActive) {
	if (bActive != this._active) {
		this._active = bActive;
		this._activeHandling();

		if (this.getType() == "Navigation") {
			this._activeHandlingNav();
		}

		if (bActive) {
			this._activeHandlingInheritor();
		} else {
			this._inactiveHandlingInheritor();
		}
	}

	return this;
};

// somehow unread ignores css when changed directly in the dom...therefore rerendering reactivated
sap.m.ListItemBase.prototype.setUnread = function(bUnread) {
	this.setProperty("unread", bUnread);
	this.$().toggleClass("sapMLIBUnread", bUnread);
	return this;
};

sap.m.ListItemBase.prototype._getNavImage = function(oImgId, oImgStyle, oSrc, oActiveSrc) {

	// no navigation image for android
	if (!jQuery.os.ios && this.getType() == "Navigation") {
		return null;
	}

	if (this.hasOwnProperty("_navImage")) {
		return this._navImage;
	}

	if (oActiveSrc) {
		oActiveSrc = this._sImagePath + oActiveSrc;
	}

	return this._navImage = new sap.m.Image(oImgId, {
		src : this._sImagePath + oSrc,
		activeSrc : oActiveSrc,
		densityAware : false
	}).addStyleClass(oImgStyle, true).setParent(this, null, true);
};

sap.m.ListItemBase.prototype._getDelImage = function(oImgId, oImgStyle, oSrc) {
	return this._delImage || (this._delImage = new sap.m.Image(oImgId, {
		src : this._sImagePath + oSrc,
		densityAware: false
	}).addStyleClass(oImgStyle, true).setParent(this, null, true).attachPress(this._delete));
};

sap.m.ListItemBase.prototype.ontap = function(oEvent) {
	var type = this.getType();

	if (this._mode === "SingleSelectMaster" || (this._includeItemInSelection && (this._mode === "SingleSelect" || this._mode === "SingleSelectLeft" || this._mode === "MultiSelect"))) {

		// if _includeItemInSelection all tap events will be used for the mode select and delete
		// SingleSelectMaster always behaves like includeItemInSelection is set
		switch (this._mode) {
			case "SingleSelect":
			case "SingleSelectLeft":
			case "SingleSelectMaster":

				// check if radiobutton fired the event and therefore do not set the select
				if (!this.getSelected() && oEvent.srcControl && oEvent.srcControl.getId() !== this._radioButton.getId()) {
					this.setSelected(true);
					this._listId && sap.ui.getCore().byId(this._listId)._selectTapped(this);
				}

				break;
			case "MultiSelect":

				// check if checkbox fired the event and therefore do not set the select
				if (oEvent.srcControl && oEvent.srcControl.getId() !== this._checkBox.getId()) {
					this.setSelected(!this.getSelected());
					this._listId && sap.ui.getCore().byId(this._listId)._selectTapped(this);
				}

				break;
		}
	} else {
		switch (type) {
			case "Active":
			case "Navigation":

				// if a fast tap happens deactivate the touchstart/touchend timers and their logic
				if ( this._isActivationHandled(oEvent) && !this._eventHandledByControl) {
					window.clearTimeout(this._timeoutIdStart);
					window.clearTimeout(this._timeoutIdEnd);
					this.setActive(true);
					jQuery.sap.delayedCall(180, this, function() {
						this.setActive(false);
					});
				}

				if (!this._eventHandledByControl) {
					jQuery.sap.delayedCall(50, this, function(){
						this.fireTap({});
						this.firePress({});
					});
				}

				break;

			case "Detail":
				if (oEvent.srcControl && oEvent.srcControl.getId() === (this.getId() + "-imgDet")) {
					this.fireDetailTap({});
					this.fireDetailPress({});
				}

				break;

			case "DetailAndActive":
				if (oEvent.srcControl && oEvent.srcControl.getId() === (this.getId() + "-imgDet")) {
					this.fireDetailTap({});
					this.fireDetailPress({});
				} else {

					// if a fast tap happens deactivate the touchstart/touchend timers and their logic
					if ( this._isActivationHandled(oEvent) && !this._eventHandledByControl) {
						window.clearTimeout(this._timeoutIdStart);
						window.clearTimeout(this._timeoutIdEnd);
						this.setActive(true);
						jQuery.sap.delayedCall(180, this, function() {
							this.setActive(false);
						});
					}

					if (!this._eventHandledByControl) {
						jQuery.sap.delayedCall(50, this, function(){
							this.fireTap({});
							this.firePress({});
						});
					}
				}

				break;
		}
	}

	// tell the list, item is pressed
	if (this._listId && type != "Inactive") {
		sap.ui.getCore().byId(this._listId)._onItemPressed(this, oEvent);
	}
};

sap.m.ListItemBase.prototype.ontouchstart = function(oEvent) {
	this._eventHandledByControl = oEvent.originalEvent._sapui_handledByControl;

	this._touchedY = oEvent.targetTouches[0].clientY;
	this._touchedX = oEvent.targetTouches[0].clientX;

	// timeout regarding active state when scrolling
	this._timeoutIdStart = jQuery.sap.delayedCall(100, this, function() {

		// several fingers could be used
		// for selections with whole list item interaction and singleselectmaster active handling is disabled
		if (!(this._includeItemInSelection && (this._mode == "SingleSelect" || this._mode == "SingleSelectLeft" || this._mode == "MultiSelect")) && ((oEvent.touches && oEvent.touches.length === 1) || !oEvent.touches)) {
			var type = this.getType();
			switch (type) {
				case "Active":
				case "Navigation":
				case "DetailAndActive":

					if (this._isActivationHandled(oEvent) && !this._eventHandledByControl) {
						this.setActive(true);
					}

					break;
			}
		}
	});
};

// touch move to prevent active state when scrolling
sap.m.ListItemBase.prototype.ontouchmove = function(oEvent) {
	var bTouchMovement = ((Math.abs(this._touchedY - oEvent.targetTouches[0].clientY) > 10) || Math.abs(this._touchedX - oEvent.targetTouches[0].clientX) > 10);

	if ((this._active || this._timeoutIdStart) && bTouchMovement) {

		// there is movement and therefore no tap...remove active styles
		clearTimeout(this._timeoutIdStart);
		this.setActive(false);
		this._timeoutIdStart = null;
		this._timeoutIdEnd = null;
	}
};

sap.m.ListItemBase.prototype.ontouchend = function(oEvent) {

	// several fingers could be used
	if (oEvent.targetTouches.length === 0) {
		switch (this.getType()) {
			case "Active":
			case "Navigation":
			case "DetailAndActive":

				// wait maybe it is a tap
				this._timeoutIdEnd = jQuery.sap.delayedCall(100, this, function() {
					this._event = oEvent;
					this.setActive(false);
				});

				break;
		}
	}
};

// During native scrolling: Chrome sends touchcancel and no touchend thereafter
sap.m.ListItemBase.prototype.ontouchcancel = sap.m.ListItemBase.prototype.ontouchend;

// toggle active styles for navigation items
sap.m.ListItemBase.prototype._activeHandlingNav = function() {
	if (sap.ui.Device.os.ios) {
		this.$("imgNav").toggleClass("sapMLIBImgNavActive", this._active);
	}
};

// hook method for active handling...inheritors should overwrite this method
sap.m.ListItemBase.prototype._activeHandlingInheritor = function() {
};

// hook method for inactive handling...inheritors should overwrite this method
sap.m.ListItemBase.prototype._inactiveHandlingInheritor = function() {
};

// switch background style... toggle active feedback
sap.m.ListItemBase.prototype._activeHandling = function() {
	this.$().toggleClass("sapMLIBActive", this._active);
	this.$("counter").toggleClass("sapMLIBActiveCounter", this._active);

	if (this.getUnread()) {
		this.$("unread").toggleClass("sapMLIBActiveUnread", this._active);
	}

	var oImgDet = sap.ui.getCore().byId(this.getId() + "-imgDet");
	if (oImgDet) {
		oImgDet.$().toggleClass("sapMLIBIconDetActive", this._active);
	}

	var oImgDel = sap.ui.getCore().byId(this.getId() + "-imgDel");
	if (oImgDel) {
		oImgDel.$().toggleClass("sapMLIBIconDelActive", this._active);
	}
};

// checks the source control from event, whether it is handling the active feedback by its own or not...
// also delete and detail icons won't cause an active feedback
sap.m.ListItemBase.prototype._isActivationHandled = function(oEvent) {
	this._event = oEvent;
	var control = oEvent.srcControl;

	if (control && control.getId() != this.getId() + "-imgDel" && control.getId() != this.getId() + "-imgDet" && (!control.getActiveHandling || control.getActiveHandling && control.getActiveHandling() !== false)) {
		return true;
	}

	return false;
};

/* Keyboard Handling */
sap.m.ListItemBase.prototype.onsapspace = function(oEvent) {
	if (!this._listId ||
		oEvent.isMarked() ||
		!this.isSelectable() ||
		oEvent.srcControl !== this ||
		this._mode == "Delete" ||
		this._mode == "None") {
		return;
	}

	if (this._mode == "MultiSelect") {
		this.setSelected(!this.getSelected());
		sap.ui.getCore().byId(this._listId)._selectTapped(this);
	} else if (!this.getSelected()) {
		this.setSelected(true);
		sap.ui.getCore().byId(this._listId)._selectTapped(this);
	}

	// let the parent know and prevent default not to scroll down
	oEvent.preventDefault();
	oEvent.setMarked();
};

sap.m.ListItemBase.prototype.onsapenter = function(oEvent) {
	if (!this._listId ||
		oEvent.isMarked() ||
		oEvent.srcControl !== this) {
		return;
	}

	// let the list know item is pressed
	if (this.getType() != "Inactive") {
		sap.ui.getCore().byId(this._listId)._onItemPressed(this, oEvent);
	}

	// support old bug!!!
	// do not fire item press event when item is included into selection
	if ((this._includeItemInSelection && this._mode != "None" && this._mode != "Delete") ||
		this._mode == "SingleSelectMaster") {
		this.onsapspace(oEvent);
		return;
	}

	switch (this.getType()) {
		case "Active":
		case "Navigation":
		case "DetailAndActive":
			oEvent.setMarked();

			// active feedback
			this.setActive(true);
			jQuery.sap.delayedCall(180, this, function() {
				this.setActive(false);
			});

			// fire own press event
			jQuery.sap.delayedCall(0, this, function() {
				this.fireTap({});
				this.firePress({});
			});

			break;
	}
};

sap.m.ListItemBase.prototype.onsapdelete = function(oEvent) {
	if (!this._listId ||
		oEvent.isMarked() ||
		oEvent.srcControl !== this ||
		this._mode != "Delete") {
		return;
	}

	this._delete.call(this._delIcon || this._delImage);
	oEvent.preventDefault();
	oEvent.setMarked();
};

sap.m.ListItemBase.prototype._switchFocus = function(oEvent) {
	if (oEvent.srcControl !== this) {
		this._oLastFocused = oEvent.target;
		jQuery(oEvent.target).blur();
		this.$().focus();
	} else if (this._oLastFocused) {
		jQuery(this._oLastFocused).focus();
	}
};

sap.m.ListItemBase.prototype.onkeydown = function(oEvent) {
	// check whether event is marked or not
	var mKeyCodes = jQuery.sap.KeyCodes;
	if (oEvent.isMarked()) {
		return;
	}

	// switch focus to row and focused item with F7
	if (oEvent.which == mKeyCodes.F7) {
		this._switchFocus(oEvent);
		oEvent.preventDefault();
		oEvent.setMarked();
		return;
	}

	// Ctrl + A to select all
	if (oEvent.srcControl === this && oEvent.ctrlKey && oEvent.which == mKeyCodes.A) {
		sap.ui.getCore().byId(this._listId).selectAll(true);
		oEvent.preventDefault();
		oEvent.setMarked();
	}
};
}; // end of sap/m/ListItemBase.js
if ( !jQuery.sap.isDeclared('sap.m.NavContainer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.m.NavContainer.
jQuery.sap.declare("sap.m.NavContainer");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new NavContainer.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getHeight height} : sap.ui.core.CSSSize (default: '100%')</li>
 * <li>{@link #getWidth width} : sap.ui.core.CSSSize (default: '100%')</li>
 * <li>{@link #getVisible visible} : boolean (default: true)</li>
 * <li>{@link #getDefaultTransitionName defaultTransitionName} : string</li></ul>
 * </li>
 * <li>Aggregations
 * <ul>
 * <li>{@link #getPages pages} <strong>(default aggregation)</strong> : sap.ui.core.Control[]</li></ul>
 * </li>
 * <li>Associations
 * <ul>
 * <li>{@link #getInitialPage initialPage} : string | sap.ui.core.Control</li></ul>
 * </li>
 * <li>Events
 * <ul>
 * <li>{@link sap.m.NavContainer#event:navigate navigate} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li>
 * <li>{@link sap.m.NavContainer#event:afterNavigate afterNavigate} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * The NavContainer control handles hierarchic navigation between Pages or other fullscreen controls.
 * 
 * All children of this control will receive navigation events like {@link sap.m.NavContainerChild#beforeShow beforeShow}, they are documented in the pseudo interface {@link sap.m.NavContainerChild sap.m.NavContainerChild}
 * @extends sap.ui.core.Control
 *
 * @author SAP AG 
 * @version 1.20.6
 *
 * @constructor   
 * @public
 * @name sap.m.NavContainer
 */
sap.ui.core.Control.extend("sap.m.NavContainer", { metadata : {

	// ---- object ----
	publicMethods : [
		// methods
		"to", "back", "backToPage", "backToTop", "getPage", "getCurrentPage", "getPreviousPage", "addCustomTransition", "insertPreviousPage", "currentPageIsTopPage"
	],

	// ---- control specific ----
	library : "sap.m",
	properties : {
		"height" : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : '100%'},
		"width" : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : '100%'},
		"visible" : {type : "boolean", group : "Appearance", defaultValue : true},
		"defaultTransitionName" : {type : "string", group : "Appearance", defaultValue : null}
	},
	defaultAggregation : "pages",
	aggregations : {
    	"pages" : {type : "sap.ui.core.Control", multiple : true, singularName : "page"}
	},
	associations : {
		"initialPage" : {type : "sap.ui.core.Control", multiple : false}
	},
	events : {
		"navigate" : {allowPreventDefault : true}, 
		"afterNavigate" : {}
	}
}});


/**
 * Creates a new subclass of class sap.m.NavContainer with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.m.NavContainer.extend
 * @function
 */

sap.m.NavContainer.M_EVENTS = {'navigate':'navigate','afterNavigate':'afterNavigate'};


/**
 * Getter for property <code>height</code>.
 * The height of the NavContainer. Can be changed when the NavContainer should not cover the whole available area.
 *
 * Default value is <code>'100%'</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>height</code>
 * @public
 * @name sap.m.NavContainer#getHeight
 * @function
 */

/**
 * Setter for property <code>height</code>.
 *
 * Default value is <code>'100%'</code> 
 *
 * @param {sap.ui.core.CSSSize} sHeight  new value for property <code>height</code>
 * @return {sap.m.NavContainer} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.NavContainer#setHeight
 * @function
 */


/**
 * Getter for property <code>width</code>.
 * The width of the NavContainer. Can be changed when the NavContainer should not cover the whole available area.
 *
 * Default value is <code>'100%'</code>
 *
 * @return {sap.ui.core.CSSSize} the value of property <code>width</code>
 * @public
 * @name sap.m.NavContainer#getWidth
 * @function
 */

/**
 * Setter for property <code>width</code>.
 *
 * Default value is <code>'100%'</code> 
 *
 * @param {sap.ui.core.CSSSize} sWidth  new value for property <code>width</code>
 * @return {sap.m.NavContainer} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.NavContainer#setWidth
 * @function
 */


/**
 * Getter for property <code>visible</code>.
 * Whether the NavContainer is visible.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>visible</code>
 * @public
 * @name sap.m.NavContainer#getVisible
 * @function
 */

/**
 * Setter for property <code>visible</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bVisible  new value for property <code>visible</code>
 * @return {sap.m.NavContainer} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.NavContainer#setVisible
 * @function
 */


/**
 * Getter for property <code>defaultTransitionName</code>.
 * The type of the transition/animation to apply when "to()" is called without defining a transition type to use. The default is "slide" on iOS and Android; on Windows Phone the default is "door". Other options are: "fade", "flip" and "show" - and the names of any registered custom transitions.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>defaultTransitionName</code>
 * @public
 * @since 1.7.1
 * @name sap.m.NavContainer#getDefaultTransitionName
 * @function
 */

/**
 * Setter for property <code>defaultTransitionName</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sDefaultTransitionName  new value for property <code>defaultTransitionName</code>
 * @return {sap.m.NavContainer} <code>this</code> to allow method chaining
 * @public
 * @since 1.7.1
 * @name sap.m.NavContainer#setDefaultTransitionName
 * @function
 */


/**
 * Getter for aggregation <code>pages</code>.<br/>
 * The content entities between which this NavContainer navigates. These can be of type sap.m.Page, sap.ui.core.View, sap.m.Carousel or any other control with fullscreen/page semantics.
 * 
 * These aggregated controls will receive navigation events like {@link sap.m.NavContainerChild#beforeShow beforeShow}, they are documented in the pseudo interface {@link sap.m.NavContainerChild sap.m.NavContainerChild}
 * 
 * <strong>Note</strong>: this is the default aggregation for NavContainer.
 * @return {sap.ui.core.Control[]}
 * @public
 * @name sap.m.NavContainer#getPages
 * @function
 */


/**
 * Inserts a page into the aggregation named <code>pages</code>.
 *
 * @param {sap.ui.core.Control}
 *          oPage the page to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the page should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the page is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the page is inserted at 
 *             the last position        
 * @return {sap.m.NavContainer} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.NavContainer#insertPage
 * @function
 */

/**
 * Adds some page <code>oPage</code> 
 * to the aggregation named <code>pages</code>.
 *
 * @param {sap.ui.core.Control}
 *            oPage the page to add; if empty, nothing is inserted
 * @return {sap.m.NavContainer} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.NavContainer#addPage
 * @function
 */

/**
 * Removes an page from the aggregation named <code>pages</code>.
 *
 * @param {int | string | sap.ui.core.Control} vPage the page to remove or its index or id
 * @return {sap.ui.core.Control} the removed page or null
 * @public
 * @name sap.m.NavContainer#removePage
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>pages</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.core.Control[]} an array of the removed elements (might be empty)
 * @public
 * @name sap.m.NavContainer#removeAllPages
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.core.Control</code> in the aggregation named <code>pages</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.core.Control}
 *            oPage the page whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @name sap.m.NavContainer#indexOfPage
 * @function
 */
	

/**
 * Destroys all the pages in the aggregation 
 * named <code>pages</code>.
 * @return {sap.m.NavContainer} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.NavContainer#destroyPages
 * @function
 */


/**
 * This association can be used to define which page is displayed initially. If the given page does not exist or no page is given, the first page which has been added is considered as initial page.
 * This value should be set initially and not set/modified while the application is running.
 * 
 * This could be used not only for the initial display, but also if the user wants to navigate "up to top", so this page serves as a sort of "home/root page".
 *
 * @return {string} Id of the element which is the current target of the <code>initialPage</code> association, or null
 * @public
 * @name sap.m.NavContainer#getInitialPage
 * @function
 */

/**
 * This association can be used to define which page is displayed initially. If the given page does not exist or no page is given, the first page which has been added is considered as initial page.
 * This value should be set initially and not set/modified while the application is running.
 * 
 * This could be used not only for the initial display, but also if the user wants to navigate "up to top", so this page serves as a sort of "home/root page".
 *
 * @param {string | sap.ui.core.Control} vInitialPage 
 *    Id of an element which becomes the new target of this <code>initialPage</code> association.
 *    Alternatively, an element instance may be given.
 * @return {sap.m.NavContainer} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.NavContainer#setInitialPage
 * @function
 */


	
/**
 * The event is fired when navigation between two pages has been triggered. The transition (if any) to the new page has not started yet.
 * This event can be aborted by the application with preventDefault(), which means that there will be no navigation. 
 *
 * @name sap.m.NavContainer#navigate
 * @event
 * @since 1.7.1
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters

 * @param {sap.ui.core.Control} oControlEvent.getParameters.from The page which was shown before the current navigation.
 * @param {string} oControlEvent.getParameters.fromId The ID of the page which was shown before the current navigation.
 * @param {sap.ui.core.Control} oControlEvent.getParameters.to The page which will be shown after the current navigation.
 * @param {string} oControlEvent.getParameters.toId The ID of the page which will be shown after the current navigation.
 * @param {boolean} oControlEvent.getParameters.firstTime Whether the "to" page (more precisely: a control with the ID of the page which is currently navigated to) has not been shown/navigated to before.
 * @param {boolean} oControlEvent.getParameters.isTo Whether this is a forward navigation, triggered by "to()".
 * @param {boolean} oControlEvent.getParameters.isBack Whether this is a back navigation, triggered by "back()".
 * @param {boolean} oControlEvent.getParameters.isBackToTop Whether this is a navigation to the root page, triggered by "backToTop()".
 * @param {boolean} oControlEvent.getParameters.isBackToPage Whether this was a navigation to the root page, triggered by "backToTop()".
 * @param {string} oControlEvent.getParameters.direction How the navigation was triggered, possible values are "to", "back", and "backToTop".
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'navigate' event of this <code>sap.m.NavContainer</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.m.NavContainer</code>.<br/> itself. 
 *  
 * The event is fired when navigation between two pages has been triggered. The transition (if any) to the new page has not started yet.
 * This event can be aborted by the application with preventDefault(), which means that there will be no navigation. 
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.m.NavContainer</code>.<br/> itself.
 *
 * @return {sap.m.NavContainer} <code>this</code> to allow method chaining
 * @public
 * @since 1.7.1
 * @name sap.m.NavContainer#attachNavigate
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'navigate' event of this <code>sap.m.NavContainer</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.m.NavContainer} <code>this</code> to allow method chaining
 * @public
 * @since 1.7.1
 * @name sap.m.NavContainer#detachNavigate
 * @function
 */

/**
 * Fire event navigate to attached listeners.
 *
 * Listeners may prevent the default action of this event using the preventDefault-method on the event object.
 * * 
 * Expects following event parameters:
 * <ul>
 * <li>'from' of type <code>sap.ui.core.Control</code> The page which was shown before the current navigation.</li>
 * <li>'fromId' of type <code>string</code> The ID of the page which was shown before the current navigation.</li>
 * <li>'to' of type <code>sap.ui.core.Control</code> The page which will be shown after the current navigation.</li>
 * <li>'toId' of type <code>string</code> The ID of the page which will be shown after the current navigation.</li>
 * <li>'firstTime' of type <code>boolean</code> Whether the "to" page (more precisely: a control with the ID of the page which is currently navigated to) has not been shown/navigated to before.</li>
 * <li>'isTo' of type <code>boolean</code> Whether this is a forward navigation, triggered by "to()".</li>
 * <li>'isBack' of type <code>boolean</code> Whether this is a back navigation, triggered by "back()".</li>
 * <li>'isBackToTop' of type <code>boolean</code> Whether this is a navigation to the root page, triggered by "backToTop()".</li>
 * <li>'isBackToPage' of type <code>boolean</code> Whether this was a navigation to the root page, triggered by "backToTop()".</li>
 * <li>'direction' of type <code>string</code> How the navigation was triggered, possible values are "to", "back", and "backToTop".</li>
 * </ul>
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {boolean} whether to prevent the default action
 * @protected
 * @since 1.7.1
 * @name sap.m.NavContainer#fireNavigate
 * @function
 */


/**
 * The event is fired when navigation between two pages has completed. In case of animated transitions this event is fired with some delay after the "navigate" event. 
 *
 * @name sap.m.NavContainer#afterNavigate
 * @event
 * @since 1.7.1
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters

 * @param {sap.ui.core.Control} oControlEvent.getParameters.from The page which had been shown before navigation.
 * @param {string} oControlEvent.getParameters.fromId The ID of the page which had been shown before navigation.
 * @param {sap.ui.core.Control} oControlEvent.getParameters.to The page which is now shown after navigation.
 * @param {string} oControlEvent.getParameters.toId The ID of the page which is now shown after navigation.
 * @param {boolean} oControlEvent.getParameters.firstTime Whether the "to" page (more precisely: a control with the ID of the page which has been navigated to) had not been shown/navigated to before.
 * @param {boolean} oControlEvent.getParameters.isTo Whether was a forward navigation, triggered by "to()".
 * @param {boolean} oControlEvent.getParameters.isBack Whether this was a back navigation, triggered by "back()".
 * @param {boolean} oControlEvent.getParameters.isBackToTop Whether this was a navigation to the root page, triggered by "backToTop()".
 * @param {boolean} oControlEvent.getParameters.isBackToPage Whether this was a navigation to the root page, triggered by "backToTop()".
 * @param {string} oControlEvent.getParameters.direction How the navigation was triggered, possible values are "to", "back", and "backToTop".
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'afterNavigate' event of this <code>sap.m.NavContainer</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.m.NavContainer</code>.<br/> itself. 
 *  
 * The event is fired when navigation between two pages has completed. In case of animated transitions this event is fired with some delay after the "navigate" event. 
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.m.NavContainer</code>.<br/> itself.
 *
 * @return {sap.m.NavContainer} <code>this</code> to allow method chaining
 * @public
 * @since 1.7.1
 * @name sap.m.NavContainer#attachAfterNavigate
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'afterNavigate' event of this <code>sap.m.NavContainer</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.m.NavContainer} <code>this</code> to allow method chaining
 * @public
 * @since 1.7.1
 * @name sap.m.NavContainer#detachAfterNavigate
 * @function
 */

/**
 * Fire event afterNavigate to attached listeners.
 * 
 * Expects following event parameters:
 * <ul>
 * <li>'from' of type <code>sap.ui.core.Control</code> The page which had been shown before navigation.</li>
 * <li>'fromId' of type <code>string</code> The ID of the page which had been shown before navigation.</li>
 * <li>'to' of type <code>sap.ui.core.Control</code> The page which is now shown after navigation.</li>
 * <li>'toId' of type <code>string</code> The ID of the page which is now shown after navigation.</li>
 * <li>'firstTime' of type <code>boolean</code> Whether the "to" page (more precisely: a control with the ID of the page which has been navigated to) had not been shown/navigated to before.</li>
 * <li>'isTo' of type <code>boolean</code> Whether was a forward navigation, triggered by "to()".</li>
 * <li>'isBack' of type <code>boolean</code> Whether this was a back navigation, triggered by "back()".</li>
 * <li>'isBackToTop' of type <code>boolean</code> Whether this was a navigation to the root page, triggered by "backToTop()".</li>
 * <li>'isBackToPage' of type <code>boolean</code> Whether this was a navigation to the root page, triggered by "backToTop()".</li>
 * <li>'direction' of type <code>string</code> How the navigation was triggered, possible values are "to", "back", and "backToTop".</li>
 * </ul>
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.m.NavContainer} <code>this</code> to allow method chaining
 * @protected
 * @since 1.7.1
 * @name sap.m.NavContainer#fireAfterNavigate
 * @function
 */


/**
 * Navigates to the next page (with drill-down semantic) with the given (or default) animation. This creates a new history item inside the NavContainer and allows going back.
 * 
 * Note that any modifications to the target page (like setting its title, or anything else that could cause a re-rendering) should be done BEFORE calling to(), in order to avoid unwanted side effects, e.g. related to the page animation.
 * 
 * Available transitions currently include "slide" (default), "fade", "flip", and "show". None of these is currently making use of any given transitionParameters.
 * 
 * Calling this navigation method triggers first the (cancelable) "navigate" event on the NavContainer, then the "beforeHide" pseudo event on the source page and "beforeFirstShow" (if applicable) and"beforeShow" on the target page. Later - after the transition has completed - the "afterShow" pseudo event is triggered on the target page and "afterHide" on the page which has been left. The given data object is available in the "beforeFirstShow", "beforeShow" and "afterShow" event object as "data" property.
 *
 * @name sap.m.NavContainer.prototype.to
 * @function
 * @param {string} 
 *         sPageId
 *         The screen to which drilldown should happen. The ID or the control itself can be given.
 * @param {string} 
 *         sTransitionName
 *         The type of the transition/animation to apply. This parameter can be omitted; then the default is "slide" (horizontal movement from the right).
 * Other options are: "fade", "flip", and "show" and the names of any registered custom transitions.
 * 
 * None of the standard transitions is currently making use of any given transition parameters.
 * @param {object} 
 *         oData

 * @since 1.7.1 *         This optional object can carry any payload data which should be made available to the target page. The "beforeShow" event on the target page will contain this data object as "data" property.
 * 
 * Use case: in scenarios where the entity triggering the navigation can or should not directly initialize the target page, it can fill this object and the target page itself (or a listener on it) can take over the initialization, using the given data.
 * 
 * When the "transitionParameters" object is used, this "data" object must also be given (either as object or as null) in order to have a proper parameter order.
 * @param {object} 
 *         oTransitionParameters

 * @since 1.7.1 *         This optional object can contain additional information for the transition function, like the DOM element which triggered the transition or the desired transition duration.
 * 
 * For a proper parameter order, the "data" parameter must be given when the "transitionParameters" parameter is used. (it can be given as "null")
 * 
 * NOTE: it depends on the transition function how the object should be structured and which parameters are actually used to influence the transition.
 * The "show", "slide" and "fade" transitions do not use any parameter.

 * @type sap.m.NavContainer
 * @public
 */


/**
 * Navigates back one level. If already on the initial page and there is no place to go back, nothing happens.
 * 
 * Calling this navigation method triggers first the (cancelable) "navigate" event on the NavContainer, then the "beforeHide" pseudo event on the source page and "beforeFirstShow" (if applicable) and"beforeShow" on the target page. Later - after the transition has completed - the "afterShow" pseudo event is triggered on the target page and "afterHide" on the page which has been left. The given backData object is available in the "beforeFirstShow", "beforeShow" and "afterShow" event object as "data" property. The original "data" object from the "to" navigation is also available in these event objects.
 *
 * @name sap.m.NavContainer.prototype.back
 * @function
 * @param {object} 
 *         oBackData

 * @since 1.7.1 *         This optional object can carry any payload data which should be made available to the target page of the back navigation. The event on the target page will contain this data object as "backData" property. (The original data from the "to()" navigation will still be available as "data" property.)
 * 
 * In scenarios where the entity triggering the navigation can or should not directly initialize the target page, it can fill this object and the target page itself (or a listener on it) can take over the initialization, using the given data.
 * For back navigation this can be used e.g. when returning from a detail page to transfer any settings done there.
 * 
 * When the "transitionParameters" object is used, this "data" object must also be given (either as object or as null) in order to have a proper parameter order.
 * @param {object} 
 *         oTransitionParameters

 * @since 1.7.1 *         This optional object can give additional information to the transition function, like the DOM element which triggered the transition or the desired transition duration.
 * The animation type can NOT be selected here - it is always the inverse of the "to" navigation.
 * 
 * In order to use the "transitionParameters" property, the "data" property must be used (at least "null" must be given) for a proper parameter order.
 * 
 * NOTE: it depends on the transition function how the object should be structured and which parameters are actually used to influence the transition.

 * @type sap.m.NavContainer
 * @public
 */


/**
 * Navigates back to the nearest previous page in the NavContainer history with the given ID. If there is no such page among the previous pages, nothing happens.
 * The transition effect which had been used to get to the current page is inverted and used for this navigation.
 * 
 * Calling this navigation method triggers first the (cancelable) "navigate" event on the NavContainer, then the "beforeHide" pseudo event on the source page and "beforeFirstShow" (if applicable) and"beforeShow" on the target page. Later - after the transition has completed - the "afterShow" pseudo event is triggered on the target page and "afterHide" on the page which has been left. The given backData object is available in the "beforeFirstShow", "beforeShow" and "afterShow" event object as "data" property. The original "data" object from the "to" navigation is also available in these event objects.
 *
 * @name sap.m.NavContainer.prototype.backToPage
 * @function
 * @param {string} 
 *         sPageId
 *         The ID of the screen to which back navigation should happen. The nearest page with this ID among the previous pages in the history stack will be used.
 * @param {object} 
 *         oBackData
 *         This optional object can carry any payload data which should be made available to the target page of the "backToPage" navigation. The event on the target page will contain this data object as "backData" property.
 * 
 * When the "transitionParameters" object is used, this "data" object must also be given (either as object or as null) in order to have a proper parameter order.
 * @param {object} 
 *         oTransitionParameters
 *         This optional object can give additional information to the transition function, like the DOM element which triggered the transition or the desired transition duration.
 * The animation type can NOT be selected here - it is always the inverse of the "to" navigation.
 * 
 * In order to use the "transitionParameters" property, the "data" property must be used (at least "null" must be given) for a proper parameter order.
 * 
 * NOTE: it depends on the transition function how the object should be structured and which parameters are actually used to influence the transition.

 * @type sap.m.NavContainer
 * @public
 * @since 1.7.2
 */


/**
 * Navigates back to the initial/top level (this is the element aggregated as "initialPage", or the first added element). If already on the initial page, nothing happens.
 * The transition effect which had been used to get to the current page is inverted and used for this navigation.
 * 
 * Calling this navigation method triggers first the (cancelable) "navigate" event on the NavContainer, then the "beforeHide" pseudo event on the source page and "beforeFirstShow" (if applicable) and"beforeShow" on the target page. Later - after the transition has completed - the "afterShow" pseudo event is triggered on the target page and "afterHide" on the page which has been left. The given backData object is available in the "beforeFirstShow", "beforeShow" and "afterShow" event object as "data" property.
 *
 * @name sap.m.NavContainer.prototype.backToTop
 * @function
 * @param {object} 
 *         oBackData
 *         This optional object can carry any payload data which should be made available to the target page of the "backToTop" navigation. The event on the target page will contain this data object as "backData" property.
 * 
 * When the "transitionParameters" object is used, this "data" object must also be given (either as object or as null) in order to have a proper parameter order.
 * @param {object} 
 *         oTransitionParameters
 *         This optional object can give additional information to the transition function, like the DOM element which triggered the transition or the desired transition duration.
 * The animation type can NOT be selected here - it is always the inverse of the "to" navigation.
 * 
 * In order to use the "transitionParameters" property, the "data" property must be used (at least "null" must be given) for a proper parameter order.
 * 
 * NOTE: it depends on the transition function how the object should be structured and which parameters are actually used to influence the transition.

 * @type sap.m.NavContainer
 * @public
 * @since 1.7.1
 */


/**
 * Returns the control with the given ID from the "pages" aggregation (if available).
 *
 * @name sap.m.NavContainer.prototype.getPage
 * @function
 * @param {string} 
 *         sId
 *         The ID of the aggregated control to find.

 * @type sap.ui.core.Control
 * @public
 */


/**
 * Returns the currently displayed page-level control. Note: it is not necessarily an instance of sap.m.Page, but it could also be a sap.ui.core.View, sap.m.Carousel, or whatever is aggregated.
 * 
 * Returns undefined if no page has been added yet.
 *
 * @name sap.m.NavContainer.prototype.getCurrentPage
 * @function

 * @type sap.ui.core.Control
 * @public
 */


/**
 * Returns the previous page (the page from which the user drilled down to the current page with "to()").
 * Note: this is not the page which the user has seen before, but the page which is the target of the next "back()" navigation.
 * If there is no previous page, "undefined" is returned.
 *
 * @name sap.m.NavContainer.prototype.getPreviousPage
 * @function

 * @type sap.ui.core.Control
 * @public
 * @since 1.7.1
 */


/**
 * Adds a custom transition to the NavContainer type (not to a particular instance!). The transition is identified by a "name". Make sure to only use names that will not collide with transitions which may be added to the NavContainer later. A suggestion is to use the prefix "c_" or "_" for your custom transitions to ensure this.
 * 
 * "to" and "back" are the transition functions for the forward and backward navigation.
 * Both will be called with the following parameters:
 * - oFromPage: the Control which is currently being displayed by the NavContainer
 * - oToPage: the Control which should be displayed by the NavContainer after the transition
 * - fCallback: a function which MUST be called when the transition has completed
 * - oTransitionParameters: a data object that can be given by application code when triggering the transition by calling to() or back(); this object could give additional information to the transition function, like the DOM element which triggered the transition or the desired transition duration
 * 
 * The contract for "to" and "back" is that they may do an animation of their choice, but it should not take "too long". At the beginning of the transition the target page "oToPage" does have the CSS class "sapMNavItemHidden" which initially hides the target page (visibility:hidden). The transition can do any preparation (e.g. move that page out of the screen or make it transparent) and then should remove this CSS class.
 * After the animation the target page "oToPage" should cover the entire screen and the source page "oFromPage" should not be visible anymore. This page should then have the CSS class "sapMNavItemHidden".
 * For adding/removing this or other CSS classes, the transition can use the addStyleClass/removeStyleClass method:
 * oFromPage.addStyleClass("sapMNavItemHidden");
 * When the transition is complete, it MUST call the given fCallback method to inform the NavContainer that navigation has finished!
 * 
 * Hint: if the target page of your transition stays black on iPhone, try wrapping the animation start into a
 * setTimeout(..., 0)
 * block (delayed, but without waiting).
 * 
 * This method can be called on any NavContainer instance or statically on the sap.m.NavContainer type. However, the transition will always be registered for the type (and ALL instances), not for the single instance on which this method was invoked.
 * 
 * Returns the sap.m.NavContainer type if called statically, or "this" (to allow method chaining) if called on a particular NavContainer instance.
 *
 * @name sap.m.NavContainer.prototype.addCustomTransition
 * @function
 * @param {string} 
 *         sName
 *         The name of the transition. This name can be used by the application to choose this transition when navigating "to()" or "back()": the "transitionName" parameter of "NavContainer.to()" corresponds to this name, the back() navigation will automatically use the same transition.
 * 
 * Make sure to only use names that will not collide with transitions which may be added to the NavContainer later. A suggestion is to use the prefix "c_" or "_" for your custom transitions to ensure this.
 * @param {object} 
 *         oTo
 *         The function which will be called by the NavContainer when the application navigates "to()", using this animation's name. The NavContainer instance is the "this" context within the animation function.
 * 
 * See the documentation of NavContainer.addCustomTransitions for more details about this function.
 * @param {object} 
 *         oBack
 *         The function which will be called by the NavContainer when the application navigates "back()" from a page where it had navigated to using this animation's name. The NavContainer instance is the "this" context within the animation function.
 * 
 * See the documentation of NavContainer.addCustomTransitions for more details about this function.

 * @type sap.m.NavContainer
 * @public
 */


/**
 * Inserts the page/control with the specified ID into the navigation history stack of the NavContainer.
 * 
 * This can be used for deep-linking when the user directly reached a drilldown detail page using a bookmark and then wants to navigate up in the drilldown hierarchy. Normally such a back navigation would not be possible because there is no previous page in the NavContainer's history stack.
 *
 * @name sap.m.NavContainer.prototype.insertPreviousPage
 * @function
 * @param {string} 
 *         sPageId
 *         The ID of the control/page/screen which is inserted into the history stack. The respective control must be aggregated by the NavContainer, otherwise this will cause an error.
 * @param {string} 
 *         sTransitionName
 *         The type of the transition/animation which would have been used to navigate from the (inserted) previous page to the current page. When navigating back, the inverse animation will be applied.
 * This parameter can be omitted; then the default is "slide" (horizontal movement from the right).
 * @param {object} 
 *         oData
 *         This optional object can carry any payload data which would have been given to the inserted previous page if the user would have done a normal forward navigation to it.

 * @type sap.m.NavContainer
 * @public
 * @since 1.16.1
 */


/**
 * Returns whether the current page is the top/initial page.
 * 
 * Note: going to the initial page again with a row of "to" navigations causes the initial page to be displayed again, but logically one is not at the top level, so this method returns "false" in this case.
 *
 * @name sap.m.NavContainer.prototype.currentPageIsTopPage
 * @function

 * @type boolean
 * @public
 */


// Start of sap\m\NavContainer.js
sap.m.NavContainer.prototype.init = function() {
	this._pageStack = [];
	this._aQueue = [];
	this._mVisitedPages = {};
	this._iTransitionsCompleted = 0; // to track proper callback at the end of transitions
	this._bNeverRendered = true;
	this._bNavigating = false;
};




sap.m.NavContainer.prototype.onBeforeRendering = function() {
	var pageToRenderFirst = this.getCurrentPage();
	// for the very first rendering
	if (this._bNeverRendered && pageToRenderFirst) { // will be set to false after rendering
		
		// special handling for the page which is the first one which is rendered in this NavContainer
		var pageId = pageToRenderFirst.getId();
		
		if (!this._mVisitedPages[pageId]) { // events could already be fired by initial "to()" call 
			this._mVisitedPages[pageId] = true;
			
			var oNavInfo = {
					from:null,
					fromId:null,
					to:pageToRenderFirst,
					toId:pageId,
					firstTime:true,
					isTo:false,
					isBack:false,
					isBackToPage:false,
					isBackToTop:false,
					direction:"initial"
			};
			
			var oEvent = jQuery.Event("BeforeFirstShow", oNavInfo);
			oEvent.srcControl = this;
			oEvent.data = {};
			oEvent.backData = {};
			pageToRenderFirst._handleEvent(oEvent);
			
			oEvent = jQuery.Event("BeforeShow", oNavInfo);
			oEvent.srcControl = this;
			oEvent.data = {};
			oEvent.backData = {};
			pageToRenderFirst._handleEvent(oEvent);
		}
	}
};

sap.m.NavContainer.prototype.onAfterRendering = function() {
	var pageToRenderFirst = this.getCurrentPage();
	// for the very first rendering
	if (this._bNeverRendered && pageToRenderFirst) {
		this._bNeverRendered = false;
		delete this._bNeverRendered;
		
		// special handling for the page which is the first one which is rendered in this NavContainer
		var pageId = pageToRenderFirst.getId();
		
		var oNavInfo = {
				from:null,
				fromId:null,
				to:pageToRenderFirst,
				toId:pageId,
				firstTime:true,
				isTo:false,
				isBack:false,
				isBackToTop:false,
				isBackToPage:false,
				direction:"initial"
		};
		
		var oEvent = jQuery.Event("AfterShow", oNavInfo);
		oEvent.srcControl = this;
		oEvent.data = {};
		oEvent.backData = {};
		pageToRenderFirst._handleEvent(oEvent);
	}
};

/**
 * Returns the page that should act as initial page - either the one designated as such, or, if it does not exist,
 * the first page (index 0 in the aggregation). Returns null if no page is aggregated.
 *
 * @private
 */
sap.m.NavContainer.prototype._getActualInitialPage = function() {
	var pageId = this.getInitialPage();
	if (pageId) {
		var page = sap.ui.getCore().byId(pageId);
		if (page) {
			return page;
		} else {
			jQuery.sap.log.error("NavContainer: control with ID '" + pageId + "' was set as 'initialPage' but was not found as a DIRECT child of this NavContainer (number of current children: " + this.getPages().length + ").");
		}
	}
	var pages = this.getPages();
	return (pages.length > 0 ? pages[0] : null);
};


//*** API methods ***

sap.m.NavContainer.prototype.getPage = function(pageId) {
	var aPages = this.getPages();
	for (var i = 0; i < aPages.length; i++) {
		if (aPages[i] && (aPages[i].getId() == pageId)) {
			return aPages[i];
		}
	}
	return null;
};

sap.m.NavContainer.prototype.getDefaultTransitionName = function() {
	var sName = this.getProperty("defaultTransitionName");
	if (!sName) {
		sName = sap.ui.Device.os.windows_phone ? "door" : "slide";
	}
	return sName;
};


sap.m.NavContainer.prototype._ensurePageStackInitialized = function() {
	if (this._pageStack.length === 0) {
		var page = this._getActualInitialPage(); // TODO: with bookmarking / deep linking this is the initial, but not the "home"/root page
		if (page) {
			this._pageStack.push({id:page.getId(), mode:"initial", data:{}});
		}
	}
	return this._pageStack;
};

sap.m.NavContainer.prototype.getCurrentPage = function() {
	var stack = this._ensurePageStackInitialized();

	if (stack.length >= 1) {
		return this.getPage(stack[stack.length-1].id);
	} else {
		jQuery.sap.log.warning(this + ": page stack is empty but should have been initialized - application failed to provide a page to display");
		return undefined;
	}
};

sap.m.NavContainer.prototype.getPreviousPage = function() {
	var stack = this._ensurePageStackInitialized();
	
	if (stack.length > 1) {
		return this.getPage(stack[stack.length-2].id);
		
	} else if (stack.length == 1) { // the current one is the only page on the stack
		return undefined;
		
	} else {
		jQuery.sap.log.warning(this + ": page stack is empty but should have been initialized - application failed to provide a page to display");
	}
};

sap.m.NavContainer.prototype.currentPageIsTopPage = function() {
	var stack = this._ensurePageStackInitialized();
	return (stack.length === 1);
};


sap.m.NavContainer.prototype.insertPreviousPage = function(pageId, transitionName, data) {
	var stack = this._ensurePageStackInitialized();
	if (this._pageStack.length > 0) {
		var index = stack.length-1;
		var pageInfo = {id:pageId,mode:transitionName,data:data};
		if (index === 0) {
			pageInfo.mode = "initial";
			delete stack[stack.length-1].mode;
		}
		stack.splice(index, 0, pageInfo);
	} else {
		jQuery.sap.log.warning(this + ": insertPreviousPage called with empty page stack; ignoring");
	}
	
	return this;
};


sap.m.NavContainer.prototype._afterTransitionCallback = function(oNavInfo, oData, oBackData) {
	var oEvent = jQuery.Event("AfterShow", oNavInfo);
	oEvent.data = oData || {};
	oEvent.backData = oBackData || {};
	oEvent.srcControl = this; // store the element on the event (aligned with jQuery syntax)
	oNavInfo.to._handleEvent(oEvent);
	
	oEvent = jQuery.Event("AfterHide", oNavInfo);
	oEvent.srcControl = this; // store the element on the event (aligned with jQuery syntax)
	oNavInfo.from._handleEvent(oEvent);
	
	this._iTransitionsCompleted++;
	this._bNavigating = false;
	
	this.fireAfterNavigate(oNavInfo);
	// TODO: destroy HTML? Remember to destroy ALL HTML of several pages when backToTop has been called
	
	jQuery.sap.log.info(this + ": _afterTransitionCallback called, to: " + oNavInfo.toId);

	if (this._aQueue.length > 0) {
		var fnNavigate = this._aQueue.shift();
		fnNavigate();
	}
};

sap.m.NavContainer.prototype.to = function(pageId, transitionName, data, oTransitionParameters) {
	if (pageId instanceof sap.ui.core.Control) {
		pageId = pageId.getId();
	}

	// fix parameters
	if (typeof(transitionName) !== "string") {
		// transitionName is omitted, shift parameters
		oTransitionParameters = data;
		data = transitionName;
	}
	transitionName = transitionName || this.getDefaultTransitionName();
	oTransitionParameters = oTransitionParameters || {};
	data = data || {};

	// make sure the initial page is on the stack
	this._ensurePageStackInitialized();

	//add to the queue before checking the current page, because this might change
	if (this._bNavigating) {
		jQuery.sap.log.info(this.toString() + ": Cannot navigate to page " + pageId + " because another navigation is already in progress. - navigation will be executed after the previous one");
		
		this._aQueue.push(jQuery.proxy( function() {
			this.to(pageId, transitionName, data, oTransitionParameters);
		},this));
		
		return this;
	}

	var oFromPage = this.getCurrentPage();
	if (oFromPage && (oFromPage.getId() === pageId)) { // cannot navigate to the page that is already current
		jQuery.sap.log.warning(this.toString() + ": Cannot navigate to page " + pageId + " because this is the current page.");
		return this;
	}

	var oToPage = this.getPage(pageId);

	if (oToPage) {
		
		var oNavInfo = {
				from:oFromPage,
				fromId:oFromPage.getId(),
				to:oToPage,
				toId:pageId,
				firstTime:!this._mVisitedPages[pageId],
				isTo:true,
				isBack:false,
				isBackToTop:false,
				isBackToPage:false,
				direction:"to"
		};
		var bContinue = this.fireNavigate(oNavInfo);
		if (bContinue) { // ok, let's do the navigation

			sap.m.closeKeyboard();

			// TODO: let one of the pages also cancel navigation?
			var oEvent = jQuery.Event("BeforeHide", oNavInfo);
			oEvent.srcControl = this; // store the element on the event (aligned with jQuery syntax)
			// no data needed for hiding
			oFromPage._handleEvent(oEvent);
			
			if (!this._mVisitedPages[pageId]) { // if this page has not been shown before
				oEvent = jQuery.Event("BeforeFirstShow", oNavInfo);
				oEvent.srcControl = this;
				oEvent.data = data || {};
				oEvent.backData = {};
				oToPage._handleEvent(oEvent);
			}
			
			oEvent = jQuery.Event("BeforeShow", oNavInfo);
			oEvent.srcControl = this;
			oEvent.data = data || {};
			oEvent.backData = {};
			oToPage._handleEvent(oEvent);

			
			this._pageStack.push({id:pageId,mode:transitionName,data:data}); // this actually causes/is the navigation
			this._mVisitedPages[pageId] = true;
	
			if (!this.getDomRef()) { // the wanted animation has been recorded, but when the NavContainer is not rendered, we cannot animate, so just return
				jQuery.sap.log.info("'Hidden' 'to' navigation in not-rendered NavContainer " + this.toString());
				return this;
			}
	
			// render the page that should get visible
			var oToPageDomRef;
			
			if (!(oToPageDomRef = oToPage.getDomRef()) || oToPageDomRef.parentNode != this.getDomRef() || sap.ui.core.RenderManager.isPreservedContent(oToPageDomRef)) {
				oToPage.addStyleClass("sapMNavItemRendering");
				jQuery.sap.log.debug("Rendering 'to' page '" + oToPage.toString() + "' for 'to' navigation");
				var rm = sap.ui.getCore().createRenderManager();
				rm.render(oToPage, this.getDomRef());
				rm.destroy();
				oToPage.addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemRendering");
			}
	
			var oTransition = sap.m.NavContainer.transitions[transitionName] || sap.m.NavContainer.transitions["slide"];
	
			// Track proper invocation of the callback  TODO: only do this during development?
			var iCompleted = this._iTransitionsCompleted;
			var that = this;
			window.setTimeout(function(){
				if (that && (that._iTransitionsCompleted < iCompleted + 1)) {
					jQuery.sap.log.warning("Transition '" + transitionName + "' 'to' was triggered five seconds ago, but has not yet invoked the end-of-transition callback.");
				}
			}, 5000);
	
			this._bNavigating = true;
			oTransition.to.call(this, oFromPage, oToPage, jQuery.proxy(function(){this._afterTransitionCallback(oNavInfo, data);}, this), oTransitionParameters); // trigger the transition

		} else {
			jQuery.sap.log.info("Navigation to page with ID '" + pageId + "' has been aborted by the application");
		}

	} else {
		jQuery.sap.log.warning("Navigation triggered to page with ID '" + pageId + "', but this page is not known/aggregated by " + this);
	}
	return this;
};


sap.m.NavContainer.prototype.back = function(backData, oTransitionParameters) {
	this._backTo("back", backData, oTransitionParameters);
	return this;
};

sap.m.NavContainer.prototype.backToPage = function(pageId, backData, oTransitionParameters) {
	this._backTo("backToPage", backData, oTransitionParameters, pageId);
	return this;
};

sap.m.NavContainer.prototype.backToTop = function(backData, oTransitionParameters) {
	this._backTo("backToTop", backData, oTransitionParameters);
	return this;
};


sap.m.NavContainer.prototype._backTo = function(sType, backData, oTransitionParameters, sRequestedPageId) {
	if (this._bNavigating) {
		jQuery.sap.log.warning(this.toString() + ": Cannot navigate back because another navigation is already in progress. - navigation will be executed after the previous one");
		

		this._aQueue.push(jQuery.proxy( function() {
			this._backTo(sType, backData, oTransitionParameters, sRequestedPageId);
		},this));
		
		return this;
	}

	if (this._pageStack.length <= 1) {
		// there is no place to go back

		// but then the assumption is that the only page on the stack is the initial one and has not been navigated to. Check this:
		if (this._pageStack.length === 1 && this._pageStack[0].mode != "initial") {
			throw new Error("Initial page not found on the stack. How did this happen?");
		}
		return this;

	} else { // normal back navigation
		
		var oFromPageInfo = this._pageStack[this._pageStack.length-1];
		var mode = oFromPageInfo.mode;
		var oFromPage = this.getPage(oFromPageInfo.id);
		var oToPage;
		var oToPageData;
		
		if (sType === "backToTop") {
			oToPage = this._getActualInitialPage();
			oToPageData = null;
			
		} else if (sType === "backToPage") {
			var info = this._findClosestPreviousPageInfo(sRequestedPageId);
			if (!info) {
				jQuery.sap.log.error(this.toString() + ": Cannot navigate backToPage('" + sRequestedPageId + "') because target page was not found among the previous pages.");
				return this;
			}
			oToPage = sap.ui.getCore().byId(info.id);
			if (!oToPage) {
				jQuery.sap.log.error(this.toString() + ": Cannot navigate backToPage('" + sRequestedPageId + "') because target page does not exist anymore.");
				return this;
			}
			oToPageData = info.data;
			
		} else { // normal "back"
			oToPage = this.getPreviousPage();
			oToPageData = this._pageStack[this._pageStack.length-2].data;
		}
		
		if(!oToPage) {
			jQuery.sap.log.error("NavContainer back navigation: target page is not defined or not aggregated by this NavContainer. Aborting navigation.");
			return;
		}

		var oToPageId = oToPage.getId();
		backData = backData || {};
		oTransitionParameters = oTransitionParameters || {};
		
		var oNavInfo = {
			from:oFromPage,
			fromId:oFromPage.getId(),
			to:oToPage,
			toId:oToPageId,
			firstTime:!this._mVisitedPages[oToPageId],
			isTo:false,
			isBack:(sType === "back"),
			isBackToPage:(sType === "backToPage"),
			isBackToTop:(sType === "backToTop"),
			direction:sType
		};
		var bContinue = this.fireNavigate(oNavInfo);
		if (bContinue) { // ok, let's do the navigation

			sap.m.closeKeyboard();

			var oEvent = jQuery.Event("BeforeHide", oNavInfo);
			oEvent.srcControl = this; // store the element on the event (aligned with jQuery syntax)
			// no data needed for hiding
			oFromPage._handleEvent(oEvent);
			
			if (!this._mVisitedPages[oToPageId]) { // if this page has not been shown before
				oEvent = jQuery.Event("BeforeFirstShow", oNavInfo);
				oEvent.srcControl = this;
				oEvent.backData = backData || {};
				// the old data from the forward navigation should not exist because there was never a forward navigation
				oEvent.data = {};
				oToPage._handleEvent(oEvent);
			}
			
			oEvent = jQuery.Event("BeforeShow", oNavInfo);
			oEvent.srcControl = this;
			oEvent.backData = backData || {};
			oEvent.data =  oToPageData || {}; // the old data from the forward navigation
			oToPage._handleEvent(oEvent);

			this._pageStack.pop(); // this actually causes/is the navigation
			this._mVisitedPages[oToPageId] = true;
			
			if (sType === "backToTop") { // if we should navigate to top, just clean up the whole stack
				this._pageStack = [];
				this.getCurrentPage(); // this properly restores the initial page on the stack
				
			} else if (sType === "backToPage") {
				while (this._pageStack[this._pageStack.length-1].id !== sRequestedPageId) { // by now it is guaranteed that we will find it
					this._pageStack.pop();
				}
			}

			if (!this.getDomRef()) { // the wanted animation has been recorded, but when the NavContainer is not rendered, we cannot animate, so just return
				jQuery.sap.log.info("'Hidden' back navigation in not-rendered NavContainer " + this.toString());
				return this;
			}
			
			var oTransition = sap.m.NavContainer.transitions[mode] || sap.m.NavContainer.transitions["slide"];
	
			// Track proper invocation of the callback  TODO: only do this during development?
			var iCompleted = this._iTransitionsCompleted;
			var that = this;
			window.setTimeout(function(){
				if (that && (that._iTransitionsCompleted < iCompleted + 1)) {
					jQuery.sap.log.warning("Transition '" + mode + "' 'back' was triggered five seconds ago, but has not yet invoked the end-of-transition callback.");
				}
			}, 5000);
			
			this._bNavigating = true;
			
			// make sure the to-page is rendered
			var oToPageDomRef;
			if (!(oToPageDomRef = oToPage.getDomRef()) || oToPageDomRef.parentNode != this.getDomRef() || sap.ui.core.RenderManager.isPreservedContent(oToPageDomRef)) {
				oToPage.addStyleClass("sapMNavItemRendering");
				jQuery.sap.log.debug("Rendering 'to' page '" + oToPage.toString() + "' for back navigation");
				var rm = sap.ui.getCore().createRenderManager();
				var childPos = this.$().children().index(oFromPage.getDomRef());
				rm.renderControl(oToPage);
				rm.flush(this.getDomRef(), false, childPos);
				rm.destroy();
				oToPage.addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemRendering");
			}
			
			//if the from page and to page are identical, the transition is skipped.
			if(oFromPage.getId() === oToPage.getId()){
				jQuery.sap.log.info("Transition is skipped when navigating back to the same page instance" + oToPage.toString());
				this._afterTransitionCallback(oNavInfo, oToPageData, backData);
				return this;
			}
			
			// trigger the transition
			oTransition.back.call(this, oFromPage, oToPage, jQuery.proxy(function(){this._afterTransitionCallback(oNavInfo, oToPageData, backData);}, this), oTransitionParameters); // trigger the transition
		}
	}
	return this;
};

sap.m.NavContainer.prototype._findClosestPreviousPageInfo = function(sRequestedPreviousPageId) {
	for (var i = this._pageStack.length-2; i >= 0; i--) {
		var info = this._pageStack[i];
		if (info.id === sRequestedPreviousPageId) {
			return info;
		}
	}
	return null;
};


sap.m.NavContainer.transitions = sap.m.NavContainer.transitions || {}; // make sure the object exists


//*** SHOW Transition ***

sap.m.NavContainer.transitions["show"] = {
	to: function(oFromPage, oToPage, fCallback /*, oTransitionParameters is unused */) {
		oToPage.removeStyleClass("sapMNavItemHidden"); // remove the "hidden" class which has been added by the NavContainer before the transition was called
		oFromPage && oFromPage.addStyleClass("sapMNavItemHidden");
		fCallback();
	},
	
	back: function(oFromPage, oToPage, fCallback /*, oTransitionParameters is unused */) {
		oToPage.removeStyleClass("sapMNavItemHidden");
		oFromPage && oFromPage.addStyleClass("sapMNavItemHidden"); // instantly hide the previous page
		fCallback();
	}
};


//*** SLIDE Transition ***

if (jQuery.support.cssTransitions) {
	sap.m.NavContainer.transitions["slide"] = {
	
		to: function(oFromPage, oToPage, fCallback /*, oTransitionParameters is unused */) {
			oFromPage.addStyleClass("sapMNavItemCenter");
			window.setTimeout(function(){ // iPhone seems to need a zero timeout here, otherwise the to page is black (and may suddenly become visible when the DOM is touched)
			
				// set the style classes that represent the initial state
				oToPage.addStyleClass("sapMNavItemRight");     // the page to navigate to should be placed just right of the visible area
				oToPage.removeStyleClass("sapMNavItemHidden"); // remove the "hidden" class now which has been added by the NavContainer before the animation was called
				
		
				// iPhone needs some time... there is no animation without waiting
				window.setTimeout(function(){
					
					var bOneTransitionFinished = false;
					var bTransitionEndPending = true;
					var fAfterTransition = null; // make Eclipse aware that this variable is defined
					fAfterTransition = function() {
						jQuery(this).unbind("webkitTransitionEnd transitionend");
						if (!bOneTransitionFinished) {
							// the first one of both transitions finished
							bOneTransitionFinished = true;
						} else {
							// the second transition now also finished => clean up the style classes
							bTransitionEndPending = false;
							oToPage.removeStyleClass("sapMNavItemSliding").removeStyleClass("sapMNavItemCenter");
							oFromPage.removeStyleClass("sapMNavItemSliding").addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemLeft");
		
							// notify the NavContainer that the animation is complete
							fCallback();
						}
					};
					
					oFromPage.$().bind("webkitTransitionEnd transitionend", fAfterTransition);
					oToPage.$().bind("webkitTransitionEnd transitionend", fAfterTransition);
					
					// set the new style classes that represent the end state (and thus start the transition)
					oToPage.addStyleClass("sapMNavItemSliding").addStyleClass("sapMNavItemCenter").removeStyleClass("sapMNavItemRight");
					oFromPage.addStyleClass("sapMNavItemSliding").removeStyleClass("sapMNavItemCenter").addStyleClass("sapMNavItemLeft");
			
					window.setTimeout(function(){ // in case rerendering prevented the fAfterTransition call
						if (bTransitionEndPending) {
							bOneTransitionFinished = true;
							fAfterTransition.apply(oFromPage.$().add(oToPage.$()));
						}
					}, 400);
					
				}, 60); // this value has been found by testing on actual devices; with "10" there are frequent "no-animation" issues, with "100" there are none, with "50" there are very few
			
			},0); // iPhone seems to need a zero timeout here, otherwise the to page is black (and may suddenly become visible when the DOM is touched)
		},
	
		back: function(oFromPage, oToPage, fCallback /*, oTransitionParameters is unused */) {
			// set the style classes that represent the initial state
			oToPage.addStyleClass("sapMNavItemLeft");     // the page to navigate back to should be placed just left of the visible area
			oToPage.removeStyleClass("sapMNavItemHidden"); // remove the "hidden" class now which has been added by the NavContainer before the animation was called
			oFromPage.addStyleClass("sapMNavItemCenter");
	
			// iPhone needs some time... there is no animation without waiting
			window.setTimeout(function() {
				
				var bOneTransitionFinished = false;
				var bTransitionEndPending = true;
				var fAfterTransition = null; // make Eclipse aware that this variable is defined
				fAfterTransition = function() {
					jQuery(this).unbind("webkitTransitionEnd transitionend");
					if (!bOneTransitionFinished) {
						// the first one of both transitions finished
						bOneTransitionFinished = true;
					} else {
						// the second transition now also finished => clean up the style classes
						bTransitionEndPending = false;
						oToPage.removeStyleClass("sapMNavItemSliding").removeStyleClass("sapMNavItemCenter");
						oFromPage.removeStyleClass("sapMNavItemSliding").addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemRight");
	
						// notify the NavContainer that the animation is complete
						fCallback();
					}
				};
				
				oFromPage.$().bind("webkitTransitionEnd transitionend", fAfterTransition);
				oToPage.$().bind("webkitTransitionEnd transitionend", fAfterTransition);
				
				// workaround for bug in current webkit versions: in slided-in elements the z-order may be wrong and will be corrected once a re-layout is enforced 
				// see http://code.google.com/p/chromium/issues/detail?id=246965
				if (sap.ui.Device.browser.webkit) {
					window.setTimeout(function(){
						oToPage.$().css("box-shadow", "0em 1px 0em rgba(128, 128, 1280, 0.1)"); // add box-shadow
						window.setTimeout(function(){
							oToPage.$().css("box-shadow", ""); // remove it again
						},50);
					},0);
				}
				
				// set the new style classes that represent the end state (and thus start the transition)
				oToPage.addStyleClass("sapMNavItemSliding").addStyleClass("sapMNavItemCenter").removeStyleClass("sapMNavItemLeft"); // transition from left position to normal/center position starts now
				oFromPage.addStyleClass("sapMNavItemSliding").removeStyleClass("sapMNavItemCenter").addStyleClass("sapMNavItemRight"); // transition from normal position to right position starts now
				
				window.setTimeout(function(){ // in case rerendering prevented the fAfterTransition call
					if (bTransitionEndPending) {
						bOneTransitionFinished = true;
						fAfterTransition.apply(oFromPage.$().add(oToPage.$()));
					}
				}, 400);
				
			}, 100); // this value has been found by testing on actual devices; with "10" there are frequent "no-animation" issues, with "100" there are none, with "50" there are very few
		}
	};
	
} else { // no CSS transitions, IE9 support
	sap.m.NavContainer.transitions["slide"] = {
		to: function(oFromPage, oToPage, fCallback /*, oTransitionParameters is unused */) {
			var $ToPage = oToPage.$();
			$ToPage.css("left", "100%");
			oToPage.removeStyleClass("sapMNavItemHidden"); // remove the "hidden" class which has been added by the NavContainer before the transition was called

			$ToPage.animate({left: "0%"}, 300);
			var $FromPage = oFromPage.$();
			$FromPage.animate({left: "-100%"}, 300, function(){
				oFromPage.addStyleClass("sapMNavItemHidden");
				$FromPage.css("left", "0");
				fCallback();
			});
		},

		back: function(oFromPage, oToPage, fCallback /*, oTransitionParameters is unused */) {
			var $ToPage = oToPage.$();
			$ToPage.css("left", "-100%");
			oToPage.removeStyleClass("sapMNavItemHidden");

			$ToPage.animate({left: "0%"}, 300);
			var $FromPage = oFromPage.$();
			$FromPage.animate({left: "100%"}, 300, function(){
				oFromPage.addStyleClass("sapMNavItemHidden");
				$FromPage.css("left", "0");
				fCallback();
			});
		}
	};
}


//*** FADE Transition ***

if (jQuery.support.cssTransitions) {
	sap.m.NavContainer.transitions["fade"] = {
	
			to: function(oFromPage, oToPage, fCallback /*, oTransitionParameters is unused */) {
				// set the style classes that represent the initial state
				oToPage.addStyleClass("sapMNavItemTransparent");
				oToPage.removeStyleClass("sapMNavItemHidden");
	
				// iPhone needs some time for rendering, there is no animation without waiting
				window.setTimeout(function(){
					
					// the code to be executed after the new page has completed fading in
					var fAfterTransition = null; // make Eclipse aware that this variable is defined
					var bTransitionEndPending = true;
					fAfterTransition = function() {
						jQuery(this).unbind("webkitTransitionEnd transitionend");
						// clean up the style classes
						bTransitionEndPending = false;
						oFromPage.addStyleClass("sapMNavItemHidden");
						oToPage.removeStyleClass("sapMNavItemFading").removeStyleClass("sapMNavItemOpaque");
	
						// notify the NavContainer that the animation is complete
						fCallback();
					};
					
					oToPage.$().bind("webkitTransitionEnd transitionend", fAfterTransition);
					
					// set the new style classes that represent the end state (and thus start the transition)
					oToPage.addStyleClass("sapMNavItemFading").removeStyleClass("sapMNavItemTransparent").addStyleClass("sapMNavItemOpaque");
					
					window.setTimeout(function(){ // in case rerendering prevented the fAfterTransition call
						if (bTransitionEndPending) {
							fAfterTransition.apply(oToPage.$());
						}
					}, 600);
					
				}, 10);
			},
	
			back: function(oFromPage, oToPage, fCallback /*, oTransitionParameters is unused */) {
				// set the style classes that represent the initial state
				oFromPage.addStyleClass("sapMNavItemOpaque");
				oToPage.removeStyleClass("sapMNavItemHidden");
	
				// iPhone needs some time for rendering, there is no animation without waiting
				window.setTimeout(function() {
					
					// the code to be executed after the new page has completed fading in
					var fAfterTransition = null; // make Eclipse aware that this variable is defined
					var bTransitionEndPending = true;
					fAfterTransition = function() {
						jQuery(this).unbind("webkitTransitionEnd transitionend");
						// clean up the style classes
						bTransitionEndPending = false;
						oFromPage.removeStyleClass("sapMNavItemFading").addStyleClass("sapMNavItemHidden"); // TODO: destroy HTML?
						oFromPage.removeStyleClass("sapMNavItemTransparent");
	
						// notify the NavContainer that the animation is complete
						fCallback();
					};
					
					oFromPage.$().bind("webkitTransitionEnd transitionend", fAfterTransition);
					
					// set the new style classes that represent the end state (and thus start the transition)
					oFromPage.addStyleClass("sapMNavItemFading").removeStyleClass("sapMNavItemOpaque");
					oFromPage.addStyleClass("sapMNavItemTransparent");
					
					window.setTimeout(function(){ // in case rerendering prevented the fAfterTransition call
						if (bTransitionEndPending) {
							fAfterTransition.apply(oToPage.$());
						}
					}, 600);
	
				}, 10);
			}
	};

} else { // no CSS transitions, IE9 support
	sap.m.NavContainer.transitions["fade"] = {
		to: function(oFromPage, oToPage, fCallback /*, oTransitionParameters is unused */) {
			var $ToPage = oToPage.$();
			$ToPage.css("opacity", "0");
			oToPage.removeStyleClass("sapMNavItemHidden"); // remove the "hidden" class which has been added by the NavContainer before the transition was called

			$ToPage.animate({opacity: "1"}, 500, function(){
				oFromPage.addStyleClass("sapMNavItemHidden");
				fCallback();
			});
		},

		back: function(oFromPage, oToPage, fCallback /*, oTransitionParameters is unused */) {
			var $FromPage = oFromPage.$();
			oToPage.removeStyleClass("sapMNavItemHidden"); // remove the "hidden" class which has been added by the NavContainer before the transition was called

			$FromPage.animate({opacity: "0"}, 500, function(){
				oFromPage.addStyleClass("sapMNavItemHidden");
				$FromPage.css("opacity", "1");
				fCallback();
			});
		}
	};
}


//*** FLIP Transition ***

if (jQuery.support.cssTransitions) {
	sap.m.NavContainer.transitions["flip"] = {
	
		to: function(oFromPage, oToPage, fCallback /*, oTransitionParameters is unused */) {
			var that = this;
			window.setTimeout(function(){ // iPhone seems to need a zero timeout here, otherwise the to page is black (and may suddenly become visible when the DOM is touched)
				
				var isAndroid23 = (sap.ui.Device.os.android && sap.ui.Device.os.version === 2.3);
				
				// if not Android2.3 then add perspective styles to NavContainer
				!isAndroid23 && that.$().addClass("sapMNavFlip");
			
				// set the style classes that represent the initial state
				oToPage.addStyleClass("sapMNavItemFlipNext");     // the page to navigate to should be placed just right of the visible area
				oToPage.removeStyleClass("sapMNavItemHidden"); // remove the "hidden" class now which has been added by the NavContainer before the animation was called
		
				// iPhone needs some time... there is no animation without waiting
				window.setTimeout(function(){
					
					var bOneTransitionFinished = false;
					var bTransitionEndPending = true;
					var fAfterTransition = null; // make Eclipse aware that this variable is defined
					fAfterTransition = function() {
						jQuery(this).unbind("webkitTransitionEnd transitionend");
						if (!bOneTransitionFinished) {
							// the first one of both transitions finished
							bOneTransitionFinished = true;
						} else {
							// the second transition now also finished => clean up the style classes
							bTransitionEndPending = false;
							oToPage.removeStyleClass("sapMNavItemFlipping");
							oFromPage.removeStyleClass("sapMNavItemFlipping").addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemFlipPrevious");
							!isAndroid23 && that.$().removeClass("sapMNavFlip");
							
							// notify the NavContainer that the animation is complete
							fCallback();
						}
					};
					
					oFromPage.$().bind("webkitTransitionEnd transitionend", fAfterTransition);
					oToPage.$().bind("webkitTransitionEnd transitionend", fAfterTransition);
					
					// set the new style classes that represent the end state (and thus start the transition)
					oToPage.addStyleClass("sapMNavItemFlipping").removeStyleClass("sapMNavItemFlipNext");
					oFromPage.addStyleClass("sapMNavItemFlipping").addStyleClass("sapMNavItemFlipPrevious");
					
					window.setTimeout(function(){ // in case rerendering prevented the fAfterTransition call
						if (bTransitionEndPending) {
							bOneTransitionFinished = true;
							fAfterTransition.apply(oFromPage.$().add(oToPage.$()));
						}
					}, 600);
		
				}, 60); // this value has been found by testing on actual devices; with "10" there are frequent "no-animation" issues, with "100" there are none, with "50" there are very few#
			}, 0);
		},
	
		back: function(oFromPage, oToPage, fCallback /*, oTransitionParameters is unused */) {
			var that = this,
				isAndroid23 = (sap.ui.Device.os.android && sap.ui.Device.os.version === 2.3);
			
			// if not Android2.3 then add perspective styles to NavContainer
			!isAndroid23 && that.$().addClass("sapMNavFlip");
			
			// set the style classes that represent the initial state
			oToPage.addStyleClass("sapMNavItemFlipPrevious");     // the page to navigate back to should be placed just left of the visible area
			oToPage.removeStyleClass("sapMNavItemHidden"); // remove the "hidden" class now which has been added by the NavContainer before the animation was called
	
			// iPhone needs some time... there is no animation without waiting
			window.setTimeout(function() {
				
				var bOneTransitionFinished = false;
				var bTransitionEndPending = true;
				var fAfterTransition = null; // make Eclipse aware that this variable is defined
				fAfterTransition = function() {
					jQuery(this).unbind("webkitTransitionEnd transitionend");
					if (!bOneTransitionFinished) {
						// the first one of both transitions finished
						bOneTransitionFinished = true;
					} else {
						// the second transition now also finished => clean up the style classes
						bTransitionEndPending = false;
						oToPage.removeStyleClass("sapMNavItemFlipping");
						oFromPage.removeStyleClass("sapMNavItemFlipping").addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemFlipNext");
						!isAndroid23 && that.$().removeClass("sapMNavFlip");
	
						// notify the NavContainer that the animation is complete
						fCallback();
					}
				};
				
				oFromPage.$().bind("webkitTransitionEnd transitionend", fAfterTransition);
				oToPage.$().bind("webkitTransitionEnd transitionend", fAfterTransition);
				
				// set the new style classes that represent the end state (and thus start the transition)
				oToPage.addStyleClass("sapMNavItemFlipping").removeStyleClass("sapMNavItemFlipPrevious"); // transition from left position to normal/center position starts now
				oFromPage.addStyleClass("sapMNavItemFlipping").addStyleClass("sapMNavItemFlipNext"); // transition from normal position to right position starts now
	
				window.setTimeout(function(){ // in case rerendering prevented the fAfterTransition call
					if (bTransitionEndPending) {
						bOneTransitionFinished = true;
						fAfterTransition.apply(oFromPage.$().add(oToPage.$()));
					}
				}, 600);
				
			}, 60); // this value has been found by testing on actual devices; with "10" there are frequent "no-animation" issues, with "100" there are none, with "50" there are very few
		}
	};

} else { // no CSS transitions, IE9 support
	sap.m.NavContainer.transitions["flip"] = sap.m.NavContainer.transitions["slide"];
}


//*** DOOR Transition ***

if (jQuery.support.cssTransitions) {
	sap.m.NavContainer.transitions["door"] = {
	
		to: function(oFromPage, oToPage, fCallback /*, oTransitionParameters is unused */) {
			var that = this;
			window.setTimeout(function(){ // iPhone seems to need a zero timeout here, otherwise the to page is black (and may suddenly become visible when the DOM is touched)
				
				var isAndroid23 = (sap.ui.Device.os.android && sap.ui.Device.os.version === 2.3);
				
				// if not Android2.3 then add perspective styles to NavContainer
				!isAndroid23 && that.$().addClass("sapMNavDoor");
			
				// set the style classes that represent the initial state
				oToPage.addStyleClass("sapMNavItemDoorInNext");     // the page to navigate to should be placed just right of the visible area
				oToPage.removeStyleClass("sapMNavItemHidden"); // remove the "hidden" class now which has been added by the NavContainer before the animation was called
		
				// iPhone needs some time... there is no animation without waiting
				window.setTimeout(function(){
					
					var bOneTransitionFinished = false;
					var bTransitionEndPending = true;
					var fAfterTransition = null; // make Eclipse aware that this variable is defined
					fAfterTransition = function() {
						jQuery(this).unbind("webkitAnimationEnd animationend");
						if (!bOneTransitionFinished) {
							// the first one of both transitions finished
							bOneTransitionFinished = true;
						} else {
							// the second transition now also finished => clean up the style classes
							bTransitionEndPending = false;
							oToPage.removeStyleClass("sapMNavItemDooring").removeStyleClass("sapMNavItemDoorInNext");
							oFromPage.removeStyleClass("sapMNavItemDooring").addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemDoorInPrevious");
							!isAndroid23 && that.$().removeClass("sapMNavDoor");
							
							// notify the NavContainer that the animation is complete
							fCallback();
						}
					};
					
					oFromPage.$().bind("webkitAnimationEnd animationend", fAfterTransition);
					oToPage.$().bind("webkitAnimationEnd animationend", fAfterTransition);
					
					// set the new style classes that represent the end state (and thus start the transition)
					oToPage.addStyleClass("sapMNavItemDooring");
					oFromPage.addStyleClass("sapMNavItemDooring").addStyleClass("sapMNavItemDoorInPrevious");
					
					window.setTimeout(function(){ // in case rerendering prevented the fAfterTransition call
						if (bTransitionEndPending) {
							bOneTransitionFinished = true;
							fAfterTransition.apply(oFromPage.$().add(oToPage.$()));
						}
					}, 1000);
		
				}, 60); // this value has been found by testing on actual devices; with "10" there are frequent "no-animation" issues, with "100" there are none, with "50" there are very few#
			}, 0);
		},
	
		back: function(oFromPage, oToPage, fCallback /*, oTransitionParameters is unused */) {
			var that = this,
				isAndroid23 = (sap.ui.Device.os.android && sap.ui.Device.os.version === 2.3);
			
			// if not Android2.3 then add perspective styles to NavContainer
			!isAndroid23 && that.$().addClass("sapMNavDoor");
			
			// set the style classes that represent the initial state
			oToPage.addStyleClass("sapMNavItemDoorOutNext");     // the page to navigate back to should be placed just left of the visible area
			oToPage.removeStyleClass("sapMNavItemHidden"); // remove the "hidden" class now which has been added by the NavContainer before the animation was called
	
			// iPhone needs some time... there is no animation without waiting
			window.setTimeout(function() {
				
				var bOneTransitionFinished = false;
				var bTransitionEndPending = true;
				var fAfterTransition = null; // make Eclipse aware that this variable is defined
				fAfterTransition = function() {
					jQuery(this).unbind("webkitAnimationEnd animationend");
					if (!bOneTransitionFinished) {
						// the first one of both transitions finished
						bOneTransitionFinished = true;
					} else {
						// the second transition now also finished =>  clean up the style classes
						bTransitionEndPending = false;
						oToPage.removeStyleClass("sapMNavItemDooring").removeStyleClass("sapMNavItemDoorOutNext");
						oFromPage.removeStyleClass("sapMNavItemDooring").addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemDoorOutPrevious");
						!isAndroid23 && that.$().removeClass("sapMNavDoor");
	
						// notify the NavContainer that the animation is complete
						fCallback();
					}
				};
				
				oFromPage.$().bind("webkitAnimationEnd animationend", fAfterTransition);
				oToPage.$().bind("webkitAnimationEnd animationend", fAfterTransition);
				
				// set the new style classes that represent the end state (and thus start the transition)
				oToPage.addStyleClass("sapMNavItemDooring"); // transition from left position to normal/center position starts now
				oFromPage.addStyleClass("sapMNavItemDooring").addStyleClass("sapMNavItemDoorOutPrevious"); // transition from normal position to right position starts now
	
				window.setTimeout(function(){ // in case rerendering prevented the fAfterTransition call
					if (bTransitionEndPending) {
						bOneTransitionFinished = true;
						fAfterTransition.apply(oFromPage.$().add(oToPage.$()));
					}
				}, 1000);
				
			}, 60); // this value has been found by testing on actual devices; with "10" there are frequent "no-animation" issues, with "100" there are none, with "50" there are very few
		}
	};

} else { // no CSS transitions, IE9 support
	sap.m.NavContainer.transitions["door"] = sap.m.NavContainer.transitions["slide"];
}


sap.m.NavContainer.prototype.addCustomTransition = function(sName, fTo, fBack) {
	if (sap.m.NavContainer.transitions[sName]) {
		jQuery.sap.log.warning("Transition with name " + sName + " already exists in " + this + ". It is now being replaced by custom transition.");
	}
	
	sap.m.NavContainer.transitions[sName] = {to:fTo, back:fBack};
	return this;
};
sap.m.NavContainer.addCustomTransition = sap.m.NavContainer.prototype.addCustomTransition;



// ----------------- code for tracking and avoiding invalidation --------------------------

/**
 * Forces invalidation and rerendering (.invalidate() is disabled)
 * @private
 */
sap.m.NavContainer.prototype.forceInvalidation = sap.m.NavContainer.prototype.invalidate;

sap.m.NavContainer.prototype.invalidate = function(oSource) {

	if (oSource == this) {
		// does not happen because the source is only given when propagating to a parent

	} else if (!oSource) {
		// direct invalidation of the NavContainer; this means a property has been modified
		this.forceInvalidation(); // let invalidation occur

	} else if (oSource instanceof sap.ui.core.Control) {
		// an aggregated control is invalidated
		var bIsInPages = false,
			aPages = this.getPages(),
			l = aPages.length;
			
		for (var i = 0; i < l; i++) {
			if (aPages[i] === oSource) {
				bIsInPages = true;
				break;
			}
		}
		
		if (bIsInPages && !(oSource.getId() === this.getCurrentPage())) {
			// the invalidation source is a non-current page, so do not rerender anything
		} else {
			// TODO: there will be more cases where invalidation is not required...
			this.forceInvalidation();
		}
		
	} else { 
		// TODO: which cases are ending up here?
		this.forceInvalidation();
		
	}
};

sap.m.NavContainer.prototype.removePage = function(oPage) {
	oPage = this.removeAggregation("pages", oPage);
	
	if (oPage) {
		oPage.removeStyleClass("sapMNavItemHidden");
		oPage.removeStyleClass("sapMNavItem");
	}
	
	return oPage;
};


sap.m.NavContainer.prototype.removeAllPages = function() {
	var aPages = this.getPages();
	if (!aPages)	{
		return [];
	}
	
	for (var i = 0; i < aPages.length; i++) {
		aPages[i].removeStyleClass("sapMNavItemHidden");
		aPages[i].removeStyleClass("sapMNavItem");
	}

	return this.removeAllAggregation("pages");
};

sap.m.NavContainer.prototype.addPage = function(oPage) {
	var aPages = this.getPages();
	// Routing often adds an already existing page. ManagedObject would remove and re-add it because the order is affected, 
	// but here the order does not matter, so just ignore the call in this case.
	if (jQuery.inArray(oPage, aPages) > -1) {
		return this;
	}
	
	this.addAggregation("pages", oPage, true);

	// sapMNavItem must be added after addAggregation is called because addAggregation can lead
	// to a removePage-call where the class is removed again.
	oPage.addStyleClass("sapMNavItem"); 
	var iPreviousPageCount = aPages.length;
	
	if (iPreviousPageCount === 0 && /* get the NEW pages count */ this.getPages().length === 1 && this.getDomRef()) { // the added page is the first and only page and has been newly added
		this._ensurePageStackInitialized();
		this.rerender();
	}
	
	return this;
};

sap.m.NavContainer.prototype.insertPage = function(oPage, iIndex) {
	this.insertAggregation("pages", oPage, iIndex, true);

	// sapMNavItem must be added after addAggregation is called because addAggregation can lead
	// to a removePage-call where the class is removed again.
	oPage.addStyleClass("sapMNavItem");
	var iPreviousPageCount = this.getPages().length;
	
	if (iPreviousPageCount === 0 && this.getPages().length === 1 && this.getDomRef()) { // the added page is the first and only page and has been newly added
		this._ensurePageStackInitialized();
		this.rerender();
	}
	
	return this;
};



// documentation of the pseudo events (beforeShow, afterShow, beforeHide etc.)

/**
 * sap.m.NavContainerChild is an artificial interface with the only purpose to bear the documentation of 
 * pseudo events triggered by sap.m.NavContainer on its child controls when navigation occurs and child controls are displayed/hidden.
 * 
 * Interested parties outside the child control can listen to one or more of these events by registering a Delegate:
 * <pre>
 * page1.addEventDelegate({
 *    onBeforeShow: function(evt) {
 *       // page1 is about to be shown; act accordingly - if required you can read event information from the evt object
 *    },
 *    onAfterHide: function(evt) {
 *       // ...
 *    }
 * });
 * </pre>
 * 
 * @name sap.m.NavContainerChild
 * @interface 
 * @public
*/


/**
 * This event is fired before the NavContainer shows this child control for the first time.
 * @event
 * @param {sap.ui.core.Control} oEvent.srcControl the NavContainer firing the event
 * @param {object} oEvent.data the data object which has been passed with the "to" navigation, or an empty object
 * @param {object} oEvent.backData the data object which has been passed with the back navigation, or an empty object
 * @name sap.m.NavContainerChild.prototype.BeforeFirstShow
 * @public
*/

/**
 * This event is fired every time before the NavContainer shows this child control. In case of animated transitions this 
 * event is fired before the transition starts.
 * @event
 * @param {sap.ui.core.Control} oEvent.srcControl the NavContainer firing the event
 * @param {object} oEvent.data the data object which has been passed with the "to" navigation, or an empty object
 * @param {object} oEvent.backData the data object which has been passed with the back navigation, or an empty object
 * @name sap.m.NavContainerChild.prototype.BeforeShow
 * @public
*/

/**
 * This event is fired every time when the NavContainer has made this child control visible. In case of animated transitions this 
 * event is fired after the transition finishes. This control is now being displayed and not animated anymore.
 * @event
 * @param {sap.ui.core.Control} oEvent.srcControl the NavContainer firing the event
 * @param {object} oEvent.data the data object which has been passed with the "to" navigation, or an empty object
 * @param {object} oEvent.backData the data object which has been passed with the back navigation, or an empty object
 * @name sap.m.NavContainerChild.prototype.AfterShow
 * @public
*/

/**
 * This event is fired every time before the NavContainer hides this child control. In case of animated transitions this 
 * event is fired before the transition starts.
 * @event
 * @param {sap.ui.core.Control} oEvent.srcControl the NavContainer firing the event
 * @name sap.m.NavContainerChild.prototype.BeforeHide
 * @public
*/

/**
 * This event is fired every time when the NavContainer has made this child control invisible. In case of animated transitions this 
 * event is fired after the transition finishes. This control is now no longer being displayed and not animated anymore.
 * @event
 * @param {sap.ui.core.Control} oEvent.srcControl the NavContainer firing the event
 * @name sap.m.NavContainerChild.prototype.AfterHide
 * @public
*/

}; // end of sap/m/NavContainer.js
if ( !jQuery.sap.isDeclared('sap.m.ObjectAttribute') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.m.ObjectAttribute.
jQuery.sap.declare("sap.m.ObjectAttribute");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new ObjectAttribute.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getVisible visible} : boolean (default: true)</li>
 * <li>{@link #getText text} : string</li>
 * <li>{@link #getActive active} : boolean</li></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul>
 * <li>{@link sap.m.ObjectAttribute#event:press press} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * ObjectAttribute displays a text field that can be normal or active. Object attribute fires a press event when the user selects active text.
 * @extends sap.ui.core.Control
 *
 * @author  
 * @version 1.20.6
 *
 * @constructor   
 * @public
 * @since 1.12
 * @name sap.m.ObjectAttribute
 */
sap.ui.core.Control.extend("sap.m.ObjectAttribute", { metadata : {

	// ---- object ----

	// ---- control specific ----
	library : "sap.m",
	properties : {
		"visible" : {type : "boolean", group : "Appearance", defaultValue : true},
		"text" : {type : "string", group : "Misc", defaultValue : null},
		"active" : {type : "boolean", group : "Misc", defaultValue : null}
	},
	events : {
		"press" : {}
	}
}});


/**
 * Creates a new subclass of class sap.m.ObjectAttribute with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.m.ObjectAttribute.extend
 * @function
 */

sap.m.ObjectAttribute.M_EVENTS = {'press':'press'};


/**
 * Getter for property <code>visible</code>.
 * Indicates if the object attribute is visible. Invisible object attribute is not rendered.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>visible</code>
 * @public
 * @name sap.m.ObjectAttribute#getVisible
 * @function
 */

/**
 * Setter for property <code>visible</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bVisible  new value for property <code>visible</code>
 * @return {sap.m.ObjectAttribute} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ObjectAttribute#setVisible
 * @function
 */


/**
 * Getter for property <code>text</code>.
 * The object attribute text
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>text</code>
 * @public
 * @name sap.m.ObjectAttribute#getText
 * @function
 */

/**
 * Setter for property <code>text</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sText  new value for property <code>text</code>
 * @return {sap.m.ObjectAttribute} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ObjectAttribute#setText
 * @function
 */


/**
 * Getter for property <code>active</code>.
 * Indicates if the object attribute text is selectable by the user
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {boolean} the value of property <code>active</code>
 * @public
 * @name sap.m.ObjectAttribute#getActive
 * @function
 */

/**
 * Setter for property <code>active</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {boolean} bActive  new value for property <code>active</code>
 * @return {sap.m.ObjectAttribute} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ObjectAttribute#setActive
 * @function
 */


/**
 * Event is fired when the user clicks active text 
 *
 * @name sap.m.ObjectAttribute#press
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters

 * @param {string} oControlEvent.getParameters.domRef Dom reference of the object attributes' text to be used for positioning.
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'press' event of this <code>sap.m.ObjectAttribute</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.m.ObjectAttribute</code>.<br/> itself. 
 *  
 * Event is fired when the user clicks active text 
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.m.ObjectAttribute</code>.<br/> itself.
 *
 * @return {sap.m.ObjectAttribute} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ObjectAttribute#attachPress
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'press' event of this <code>sap.m.ObjectAttribute</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.m.ObjectAttribute} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ObjectAttribute#detachPress
 * @function
 */

/**
 * Fire event press to attached listeners.
 * 
 * Expects following event parameters:
 * <ul>
 * <li>'domRef' of type <code>string</code> Dom reference of the object attributes' text to be used for positioning.</li>
 * </ul>
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.m.ObjectAttribute} <code>this</code> to allow method chaining
 * @protected
 * @name sap.m.ObjectAttribute#firePress
 * @function
 */


// Start of sap\m\ObjectAttribute.js
///**
// * This file defines behavior for the control,
// */

/**
 * @private
 */
sap.m.ObjectAttribute.prototype.ontap = function(oEvent) {
	if(!!this.getActive()) {
		this.firePress({domRef: this.getDomRef()});
	}
};

/**
 * See 'return'.
 * 
 * @private
 * @returns {boolean} true if attribute's text is empty or only consists of whitespaces.
 */
sap.m.ObjectAttribute.prototype._isEmpty = function() {
	return !this.getText().trim();
};

/**
 * Function is called when the control is touched.  
 *
 * @private
 */
sap.m.ObjectAttribute.prototype.ontouchstart = function(oEvent) {
	if(!!this.getActive()) {
		// for control who need to know if they should handle events from the ObjectAttribute control
		oEvent.originalEvent._sapui_handledByControl = true;
	}
};

	

}; // end of sap/m/ObjectAttribute.js
if ( !jQuery.sap.isDeclared('sap.m.ObjectHeader') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.m.ObjectHeader.
jQuery.sap.declare("sap.m.ObjectHeader");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new ObjectHeader.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getTitle title} : string</li>
 * <li>{@link #getNumber number} : string</li>
 * <li>{@link #getNumberUnit numberUnit} : string</li>
 * <li>{@link #getIntro intro} : string</li>
 * <li>{@link #getIntroActive introActive} : boolean</li>
 * <li>{@link #getTitleActive titleActive} : boolean</li>
 * <li>{@link #getIcon icon} : sap.ui.core.URI</li>
 * <li>{@link #getIconActive iconActive} : boolean</li>
 * <li>{@link #getVisible visible} : boolean (default: true)</li>
 * <li>{@link #getIconDensityAware iconDensityAware} : boolean (default: true)</li>
 * <li>{@link #getMarkFavorite markFavorite} : boolean (default: false)</li>
 * <li>{@link #getMarkFlagged markFlagged} : boolean (default: false)</li>
 * <li>{@link #getShowMarkers showMarkers} : boolean (default: false)</li>
 * <li>{@link #getShowTitleSelector showTitleSelector} : boolean (default: false)</li>
 * <li>{@link #getNumberState numberState} : sap.ui.core.ValueState (default: sap.ui.core.ValueState.None)</li>
 * <li>{@link #getCondensed condensed} : boolean (default: false)</li>
 * <li>{@link #getBackgroundDesign backgroundDesign} : sap.m.BackgroundDesign (default: sap.m.BackgroundDesign.Transparent)</li></ul>
 * </li>
 * <li>Aggregations
 * <ul>
 * <li>{@link #getAttributes attributes} <strong>(default aggregation)</strong> : sap.m.ObjectAttribute[]</li>
 * <li>{@link #getFirstStatus firstStatus} : sap.m.ObjectStatus</li>
 * <li>{@link #getSecondStatus secondStatus} : sap.m.ObjectStatus</li>
 * <li>{@link #getStatuses statuses} : sap.ui.core.Control[]</li></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul>
 * <li>{@link sap.m.ObjectHeader#event:titlePress titlePress} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li>
 * <li>{@link sap.m.ObjectHeader#event:introPress introPress} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li>
 * <li>{@link sap.m.ObjectHeader#event:iconPress iconPress} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li>
 * <li>{@link sap.m.ObjectHeader#event:titleSelectorPress titleSelectorPress} : fnListenerFunction or [fnListenerFunction, oListenerObject] or [oData, fnListenerFunction, oListenerObject]</li></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * ObjectHeader is a display control that enables the user to easily identify a specific object. The object header title is the key identifier of the object and additional text and icons can be used to further distinguish it from other objects.
 * @extends sap.ui.core.Control
 *
 * @author  
 * @version 1.20.6
 *
 * @constructor   
 * @public
 * @since 1.12
 * @name sap.m.ObjectHeader
 */
sap.ui.core.Control.extend("sap.m.ObjectHeader", { metadata : {

	// ---- object ----

	// ---- control specific ----
	library : "sap.m",
	properties : {
		"title" : {type : "string", group : "Misc", defaultValue : null},
		"number" : {type : "string", group : "Misc", defaultValue : null},
		"numberUnit" : {type : "string", group : "Misc", defaultValue : null},
		"intro" : {type : "string", group : "Misc", defaultValue : null},
		"introActive" : {type : "boolean", group : "Misc", defaultValue : null},
		"titleActive" : {type : "boolean", group : "Misc", defaultValue : null},
		"icon" : {type : "sap.ui.core.URI", group : "Misc", defaultValue : null},
		"iconActive" : {type : "boolean", group : "Misc", defaultValue : null},
		"visible" : {type : "boolean", group : "Appearance", defaultValue : true},
		"iconDensityAware" : {type : "boolean", group : "Misc", defaultValue : true},
		"markFavorite" : {type : "boolean", group : "Misc", defaultValue : false},
		"markFlagged" : {type : "boolean", group : "Misc", defaultValue : false},
		"showMarkers" : {type : "boolean", group : "Misc", defaultValue : false},
		"showTitleSelector" : {type : "boolean", group : "Misc", defaultValue : false},
		"numberState" : {type : "sap.ui.core.ValueState", group : "Misc", defaultValue : sap.ui.core.ValueState.None},
		"condensed" : {type : "boolean", group : "Appearance", defaultValue : false},
		"backgroundDesign" : {type : "sap.m.BackgroundDesign", group : "Appearance", defaultValue : sap.m.BackgroundDesign.Transparent}
	},
	defaultAggregation : "attributes",
	aggregations : {
    	"attributes" : {type : "sap.m.ObjectAttribute", multiple : true, singularName : "attribute"}, 
    	"firstStatus" : {type : "sap.m.ObjectStatus", multiple : false, deprecated: true}, 
    	"secondStatus" : {type : "sap.m.ObjectStatus", multiple : false, deprecated: true}, 
    	"statuses" : {type : "sap.ui.core.Control", multiple : true, singularName : "status"}
	},
	events : {
		"titlePress" : {}, 
		"introPress" : {}, 
		"iconPress" : {}, 
		"titleSelectorPress" : {}
	}
}});


/**
 * Creates a new subclass of class sap.m.ObjectHeader with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.m.ObjectHeader.extend
 * @function
 */

sap.m.ObjectHeader.M_EVENTS = {'titlePress':'titlePress','introPress':'introPress','iconPress':'iconPress','titleSelectorPress':'titleSelectorPress'};


/**
 * Getter for property <code>title</code>.
 * Object header title
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>title</code>
 * @public
 * @name sap.m.ObjectHeader#getTitle
 * @function
 */

/**
 * Setter for property <code>title</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sTitle  new value for property <code>title</code>
 * @return {sap.m.ObjectHeader} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ObjectHeader#setTitle
 * @function
 */


/**
 * Getter for property <code>number</code>.
 * Object header number field
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>number</code>
 * @public
 * @name sap.m.ObjectHeader#getNumber
 * @function
 */

/**
 * Setter for property <code>number</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sNumber  new value for property <code>number</code>
 * @return {sap.m.ObjectHeader} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ObjectHeader#setNumber
 * @function
 */


/**
 * Getter for property <code>numberUnit</code>.
 * Object header number units qualifier.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>numberUnit</code>
 * @public
 * @name sap.m.ObjectHeader#getNumberUnit
 * @function
 */

/**
 * Setter for property <code>numberUnit</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sNumberUnit  new value for property <code>numberUnit</code>
 * @return {sap.m.ObjectHeader} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ObjectHeader#setNumberUnit
 * @function
 */


/**
 * Getter for property <code>intro</code>.
 * Introductory text for the object header.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>intro</code>
 * @public
 * @name sap.m.ObjectHeader#getIntro
 * @function
 */

/**
 * Setter for property <code>intro</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sIntro  new value for property <code>intro</code>
 * @return {sap.m.ObjectHeader} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ObjectHeader#setIntro
 * @function
 */


/**
 * Getter for property <code>introActive</code>.
 * Indicates that the intro is clickable
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {boolean} the value of property <code>introActive</code>
 * @public
 * @name sap.m.ObjectHeader#getIntroActive
 * @function
 */

/**
 * Setter for property <code>introActive</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {boolean} bIntroActive  new value for property <code>introActive</code>
 * @return {sap.m.ObjectHeader} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ObjectHeader#setIntroActive
 * @function
 */


/**
 * Getter for property <code>titleActive</code>.
 * Indicates that the title is clickable
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {boolean} the value of property <code>titleActive</code>
 * @public
 * @name sap.m.ObjectHeader#getTitleActive
 * @function
 */

/**
 * Setter for property <code>titleActive</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {boolean} bTitleActive  new value for property <code>titleActive</code>
 * @return {sap.m.ObjectHeader} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ObjectHeader#setTitleActive
 * @function
 */


/**
 * Getter for property <code>icon</code>.
 * Object header icon
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.core.URI} the value of property <code>icon</code>
 * @public
 * @name sap.m.ObjectHeader#getIcon
 * @function
 */

/**
 * Setter for property <code>icon</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.core.URI} sIcon  new value for property <code>icon</code>
 * @return {sap.m.ObjectHeader} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ObjectHeader#setIcon
 * @function
 */


/**
 * Getter for property <code>iconActive</code>.
 * Indicates that the object header icon is clickable
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {boolean} the value of property <code>iconActive</code>
 * @public
 * @name sap.m.ObjectHeader#getIconActive
 * @function
 */

/**
 * Setter for property <code>iconActive</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {boolean} bIconActive  new value for property <code>iconActive</code>
 * @return {sap.m.ObjectHeader} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ObjectHeader#setIconActive
 * @function
 */


/**
 * Getter for property <code>visible</code>.
 * Indicateds if object header is visible. Invisible object headers are not rendered.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>visible</code>
 * @public
 * @name sap.m.ObjectHeader#getVisible
 * @function
 */

/**
 * Setter for property <code>visible</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bVisible  new value for property <code>visible</code>
 * @return {sap.m.ObjectHeader} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ObjectHeader#setVisible
 * @function
 */


/**
 * Getter for property <code>iconDensityAware</code>.
 * By default, this is set to true but then one or more requests are sent trying to get the density perfect version of image if this version of image doesn't exist on the server.
 * 
 * If bandwidth is the key for the application, set this value to false.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>iconDensityAware</code>
 * @public
 * @name sap.m.ObjectHeader#getIconDensityAware
 * @function
 */

/**
 * Setter for property <code>iconDensityAware</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bIconDensityAware  new value for property <code>iconDensityAware</code>
 * @return {sap.m.ObjectHeader} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ObjectHeader#setIconDensityAware
 * @function
 */


/**
 * Getter for property <code>markFavorite</code>.
 * Set the favorite state to true or false. The showMarkers property must be true for this property to take effect.
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>markFavorite</code>
 * @public
 * @since 1.16.0
 * @name sap.m.ObjectHeader#getMarkFavorite
 * @function
 */

/**
 * Setter for property <code>markFavorite</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bMarkFavorite  new value for property <code>markFavorite</code>
 * @return {sap.m.ObjectHeader} <code>this</code> to allow method chaining
 * @public
 * @since 1.16.0
 * @name sap.m.ObjectHeader#setMarkFavorite
 * @function
 */


/**
 * Getter for property <code>markFlagged</code>.
 * Set the flagged state to true or false. The showMarkers property must be true for this property to take effect.
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>markFlagged</code>
 * @public
 * @since 1.16.0
 * @name sap.m.ObjectHeader#getMarkFlagged
 * @function
 */

/**
 * Setter for property <code>markFlagged</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bMarkFlagged  new value for property <code>markFlagged</code>
 * @return {sap.m.ObjectHeader} <code>this</code> to allow method chaining
 * @public
 * @since 1.16.0
 * @name sap.m.ObjectHeader#setMarkFlagged
 * @function
 */


/**
 * Getter for property <code>showMarkers</code>.
 * Indicates if object header supports showing markers such as flagged and favorite.
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>showMarkers</code>
 * @public
 * @since 1.16.0
 * @name sap.m.ObjectHeader#getShowMarkers
 * @function
 */

/**
 * Setter for property <code>showMarkers</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bShowMarkers  new value for property <code>showMarkers</code>
 * @return {sap.m.ObjectHeader} <code>this</code> to allow method chaining
 * @public
 * @since 1.16.0
 * @name sap.m.ObjectHeader#setShowMarkers
 * @function
 */


/**
 * Getter for property <code>showTitleSelector</code>.
 * When it is true, the selector arrow icon/image is shown and can be pressed.
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>showTitleSelector</code>
 * @public
 * @since 1.16.0
 * @name sap.m.ObjectHeader#getShowTitleSelector
 * @function
 */

/**
 * Setter for property <code>showTitleSelector</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bShowTitleSelector  new value for property <code>showTitleSelector</code>
 * @return {sap.m.ObjectHeader} <code>this</code> to allow method chaining
 * @public
 * @since 1.16.0
 * @name sap.m.ObjectHeader#setShowTitleSelector
 * @function
 */


/**
 * Getter for property <code>numberState</code>.
 * Object header number and numberUnit value state.
 *
 * Default value is <code>None</code>
 *
 * @return {sap.ui.core.ValueState} the value of property <code>numberState</code>
 * @public
 * @since 1.16.0
 * @name sap.m.ObjectHeader#getNumberState
 * @function
 */

/**
 * Setter for property <code>numberState</code>.
 *
 * Default value is <code>None</code> 
 *
 * @param {sap.ui.core.ValueState} oNumberState  new value for property <code>numberState</code>
 * @return {sap.m.ObjectHeader} <code>this</code> to allow method chaining
 * @public
 * @since 1.16.0
 * @name sap.m.ObjectHeader#setNumberState
 * @function
 */


/**
 * Getter for property <code>condensed</code>.
 * Displays the condensed object header with title, one attribute, number and number unit.
 *
 * Default value is <code>false</code>
 *
 * @return {boolean} the value of property <code>condensed</code>
 * @public
 * @name sap.m.ObjectHeader#getCondensed
 * @function
 */

/**
 * Setter for property <code>condensed</code>.
 *
 * Default value is <code>false</code> 
 *
 * @param {boolean} bCondensed  new value for property <code>condensed</code>
 * @return {sap.m.ObjectHeader} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ObjectHeader#setCondensed
 * @function
 */


/**
 * Getter for property <code>backgroundDesign</code>.
 * Note: only applied when "condensed" is true.
 * This property is used to set the background color of the ObjectHeader in condensed mode. Depending on the theme you can change the state of the background from "Solid" to "Transparent".
 *
 * Default value is <code>Transparent</code>
 *
 * @return {sap.m.BackgroundDesign} the value of property <code>backgroundDesign</code>
 * @public
 * @name sap.m.ObjectHeader#getBackgroundDesign
 * @function
 */

/**
 * Setter for property <code>backgroundDesign</code>.
 *
 * Default value is <code>Transparent</code> 
 *
 * @param {sap.m.BackgroundDesign} oBackgroundDesign  new value for property <code>backgroundDesign</code>
 * @return {sap.m.ObjectHeader} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ObjectHeader#setBackgroundDesign
 * @function
 */


/**
 * Getter for aggregation <code>attributes</code>.<br/>
 * The list of Object Attributes
 * 
 * <strong>Note</strong>: this is the default aggregation for ObjectHeader.
 * @return {sap.m.ObjectAttribute[]}
 * @public
 * @name sap.m.ObjectHeader#getAttributes
 * @function
 */


/**
 * Inserts a attribute into the aggregation named <code>attributes</code>.
 *
 * @param {sap.m.ObjectAttribute}
 *          oAttribute the attribute to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the attribute should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the attribute is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the attribute is inserted at 
 *             the last position        
 * @return {sap.m.ObjectHeader} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ObjectHeader#insertAttribute
 * @function
 */

/**
 * Adds some attribute <code>oAttribute</code> 
 * to the aggregation named <code>attributes</code>.
 *
 * @param {sap.m.ObjectAttribute}
 *            oAttribute the attribute to add; if empty, nothing is inserted
 * @return {sap.m.ObjectHeader} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ObjectHeader#addAttribute
 * @function
 */

/**
 * Removes an attribute from the aggregation named <code>attributes</code>.
 *
 * @param {int | string | sap.m.ObjectAttribute} vAttribute the attribute to remove or its index or id
 * @return {sap.m.ObjectAttribute} the removed attribute or null
 * @public
 * @name sap.m.ObjectHeader#removeAttribute
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>attributes</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.m.ObjectAttribute[]} an array of the removed elements (might be empty)
 * @public
 * @name sap.m.ObjectHeader#removeAllAttributes
 * @function
 */

/**
 * Checks for the provided <code>sap.m.ObjectAttribute</code> in the aggregation named <code>attributes</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.m.ObjectAttribute}
 *            oAttribute the attribute whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @name sap.m.ObjectHeader#indexOfAttribute
 * @function
 */
	

/**
 * Destroys all the attributes in the aggregation 
 * named <code>attributes</code>.
 * @return {sap.m.ObjectHeader} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ObjectHeader#destroyAttributes
 * @function
 */


/**
 * Getter for aggregation <code>firstStatus</code>.<br/>
 * First status shown on the right side of the attributes above the second status.
 * If it is not set the first attibute will expand to take the entire row.
 * 
 * @return {sap.m.ObjectStatus}
 * @public
 * @deprecated Since version 1.16.0. 
 * Use the statuses aggregation instead.
 * @name sap.m.ObjectHeader#getFirstStatus
 * @function
 */


/**
 * Setter for the aggregated <code>firstStatus</code>.
 * @param {sap.m.ObjectStatus} oFirstStatus
 * @return {sap.m.ObjectHeader} <code>this</code> to allow method chaining
 * @public
 * @deprecated Since version 1.16.0. 
 * Use the statuses aggregation instead.
 * @name sap.m.ObjectHeader#setFirstStatus
 * @function
 */
	

/**
 * Destroys the firstStatus in the aggregation 
 * named <code>firstStatus</code>.
 * @return {sap.m.ObjectHeader} <code>this</code> to allow method chaining
 * @public
 * @deprecated Since version 1.16.0. 
 * Use the statuses aggregation instead.
 * @name sap.m.ObjectHeader#destroyFirstStatus
 * @function
 */


/**
 * Getter for aggregation <code>secondStatus</code>.<br/>
 * Second status shown on the right side of the attributes below the first status.
 * If it is not set the second attibute will expand to take the entire row.
 * 
 * @return {sap.m.ObjectStatus}
 * @public
 * @deprecated Since version 1.16.0. 
 * Use the statuses aggregation instead.
 * @name sap.m.ObjectHeader#getSecondStatus
 * @function
 */


/**
 * Setter for the aggregated <code>secondStatus</code>.
 * @param {sap.m.ObjectStatus} oSecondStatus
 * @return {sap.m.ObjectHeader} <code>this</code> to allow method chaining
 * @public
 * @deprecated Since version 1.16.0. 
 * Use the statuses aggregation instead.
 * @name sap.m.ObjectHeader#setSecondStatus
 * @function
 */
	

/**
 * Destroys the secondStatus in the aggregation 
 * named <code>secondStatus</code>.
 * @return {sap.m.ObjectHeader} <code>this</code> to allow method chaining
 * @public
 * @deprecated Since version 1.16.0. 
 * Use the statuses aggregation instead.
 * @name sap.m.ObjectHeader#destroySecondStatus
 * @function
 */


/**
 * Getter for aggregation <code>statuses</code>.<br/>
 * The list of Object sap.ui.core.Control. It will only allow sap.m.ObjectStatus and sap.m.ProgressIndicator controls.
 * 
 * @return {sap.ui.core.Control[]}
 * @public
 * @since 1.16.0
 * @name sap.m.ObjectHeader#getStatuses
 * @function
 */


/**
 * Inserts a status into the aggregation named <code>statuses</code>.
 *
 * @param {sap.ui.core.Control}
 *          oStatus the status to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the status should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the status is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the status is inserted at 
 *             the last position        
 * @return {sap.m.ObjectHeader} <code>this</code> to allow method chaining
 * @public
 * @since 1.16.0
 * @name sap.m.ObjectHeader#insertStatus
 * @function
 */

/**
 * Adds some status <code>oStatus</code> 
 * to the aggregation named <code>statuses</code>.
 *
 * @param {sap.ui.core.Control}
 *            oStatus the status to add; if empty, nothing is inserted
 * @return {sap.m.ObjectHeader} <code>this</code> to allow method chaining
 * @public
 * @since 1.16.0
 * @name sap.m.ObjectHeader#addStatus
 * @function
 */

/**
 * Removes an status from the aggregation named <code>statuses</code>.
 *
 * @param {int | string | sap.ui.core.Control} vStatus the status to remove or its index or id
 * @return {sap.ui.core.Control} the removed status or null
 * @public
 * @since 1.16.0
 * @name sap.m.ObjectHeader#removeStatus
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>statuses</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.ui.core.Control[]} an array of the removed elements (might be empty)
 * @public
 * @since 1.16.0
 * @name sap.m.ObjectHeader#removeAllStatuses
 * @function
 */

/**
 * Checks for the provided <code>sap.ui.core.Control</code> in the aggregation named <code>statuses</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.ui.core.Control}
 *            oStatus the status whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @since 1.16.0
 * @name sap.m.ObjectHeader#indexOfStatus
 * @function
 */
	

/**
 * Destroys all the statuses in the aggregation 
 * named <code>statuses</code>.
 * @return {sap.m.ObjectHeader} <code>this</code> to allow method chaining
 * @public
 * @since 1.16.0
 * @name sap.m.ObjectHeader#destroyStatuses
 * @function
 */


/**
 * Event is fired when the title is active and the user tap/click on it 
 *
 * @name sap.m.ObjectHeader#titlePress
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters

 * @param {object} oControlEvent.getParameters.domRef Dom reference of the object header' title to be used for positioning.
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'titlePress' event of this <code>sap.m.ObjectHeader</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.m.ObjectHeader</code>.<br/> itself. 
 *  
 * Event is fired when the title is active and the user tap/click on it 
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.m.ObjectHeader</code>.<br/> itself.
 *
 * @return {sap.m.ObjectHeader} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ObjectHeader#attachTitlePress
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'titlePress' event of this <code>sap.m.ObjectHeader</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.m.ObjectHeader} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ObjectHeader#detachTitlePress
 * @function
 */

/**
 * Fire event titlePress to attached listeners.
 * 
 * Expects following event parameters:
 * <ul>
 * <li>'domRef' of type <code>object</code> Dom reference of the object header' title to be used for positioning.</li>
 * </ul>
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.m.ObjectHeader} <code>this</code> to allow method chaining
 * @protected
 * @name sap.m.ObjectHeader#fireTitlePress
 * @function
 */


/**
 * Event is fired when the title is active and the user tap/click on it 
 *
 * @name sap.m.ObjectHeader#introPress
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters

 * @param {object} oControlEvent.getParameters.domRef Dom reference of the object header' intro to be used for positioning.
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'introPress' event of this <code>sap.m.ObjectHeader</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.m.ObjectHeader</code>.<br/> itself. 
 *  
 * Event is fired when the title is active and the user tap/click on it 
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.m.ObjectHeader</code>.<br/> itself.
 *
 * @return {sap.m.ObjectHeader} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ObjectHeader#attachIntroPress
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'introPress' event of this <code>sap.m.ObjectHeader</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.m.ObjectHeader} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ObjectHeader#detachIntroPress
 * @function
 */

/**
 * Fire event introPress to attached listeners.
 * 
 * Expects following event parameters:
 * <ul>
 * <li>'domRef' of type <code>object</code> Dom reference of the object header' intro to be used for positioning.</li>
 * </ul>
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.m.ObjectHeader} <code>this</code> to allow method chaining
 * @protected
 * @name sap.m.ObjectHeader#fireIntroPress
 * @function
 */


/**
 * Event is fired when the title icon is active and the user tap/click on it 
 *
 * @name sap.m.ObjectHeader#iconPress
 * @event
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters

 * @param {object} oControlEvent.getParameters.domRef Dom reference of the object header' icon to be used for positioning.
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'iconPress' event of this <code>sap.m.ObjectHeader</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.m.ObjectHeader</code>.<br/> itself. 
 *  
 * Event is fired when the title icon is active and the user tap/click on it 
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.m.ObjectHeader</code>.<br/> itself.
 *
 * @return {sap.m.ObjectHeader} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ObjectHeader#attachIconPress
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'iconPress' event of this <code>sap.m.ObjectHeader</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.m.ObjectHeader} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ObjectHeader#detachIconPress
 * @function
 */

/**
 * Fire event iconPress to attached listeners.
 * 
 * Expects following event parameters:
 * <ul>
 * <li>'domRef' of type <code>object</code> Dom reference of the object header' icon to be used for positioning.</li>
 * </ul>
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.m.ObjectHeader} <code>this</code> to allow method chaining
 * @protected
 * @name sap.m.ObjectHeader#fireIconPress
 * @function
 */


/**
 * Event is fired when the object header title selector (down-arrow) is pressed 
 *
 * @name sap.m.ObjectHeader#titleSelectorPress
 * @event
 * @since 1.16.0
 * @param {sap.ui.base.Event} oControlEvent
 * @param {sap.ui.base.EventProvider} oControlEvent.getSource
 * @param {object} oControlEvent.getParameters

 * @param {object} oControlEvent.getParameters.domRef Dom reference of the object header' titleArrow to be used for positioning.
 * @public
 */
 
/**
 * Attach event handler <code>fnFunction</code> to the 'titleSelectorPress' event of this <code>sap.m.ObjectHeader</code>.<br/>.
 * When called, the context of the event handler (its <code>this</code>) will be bound to <code>oListener<code> if specified
 * otherwise to this <code>sap.m.ObjectHeader</code>.<br/> itself. 
 *  
 * Event is fired when the object header title selector (down-arrow) is pressed 
 *
 * @param {object}
 *            [oData] An application specific payload object, that will be passed to the event handler along with the event object when firing the event.
 * @param {function}
 *            fnFunction The function to call, when the event occurs.  
 * @param {object}
 *            [oListener] Context object to call the event handler with. Defaults to this <code>sap.m.ObjectHeader</code>.<br/> itself.
 *
 * @return {sap.m.ObjectHeader} <code>this</code> to allow method chaining
 * @public
 * @since 1.16.0
 * @name sap.m.ObjectHeader#attachTitleSelectorPress
 * @function
 */

/**
 * Detach event handler <code>fnFunction</code> from the 'titleSelectorPress' event of this <code>sap.m.ObjectHeader</code>.<br/>
 *
 * The passed function and listener object must match the ones used for event registration.
 *
 * @param {function}
 *            fnFunction The function to call, when the event occurs.
 * @param {object}
 *            oListener Context object on which the given function had to be called.
 * @return {sap.m.ObjectHeader} <code>this</code> to allow method chaining
 * @public
 * @since 1.16.0
 * @name sap.m.ObjectHeader#detachTitleSelectorPress
 * @function
 */

/**
 * Fire event titleSelectorPress to attached listeners.
 * 
 * Expects following event parameters:
 * <ul>
 * <li>'domRef' of type <code>object</code> Dom reference of the object header' titleArrow to be used for positioning.</li>
 * </ul>
 *
 * @param {Map} [mArguments] the arguments to pass along with the event.
 * @return {sap.m.ObjectHeader} <code>this</code> to allow method chaining
 * @protected
 * @since 1.16.0
 * @name sap.m.ObjectHeader#fireTitleSelectorPress
 * @function
 */


// Start of sap\m\ObjectHeader.js
///**
jQuery.sap.require('sap.ui.core.IconPool'); // unlisted dependency retained


sap.m.ObjectHeader.prototype.init = function() {

	this._fNumberWidth = undefined;
	
	//TODO Remove placeholder when Safari iconFont issue is addressed.
	var oPlaceholderIconUri = sap.ui.core.IconPool.getIconURI("fridge");
	this._oPlaceholderIcon = sap.ui.core.IconPool.createControlByURI({
		id : this.getId() + "-placeholder",
		src : oPlaceholderIconUri
	});	
	this._oPlaceholderIcon.addStyleClass("sapMObjStatusMarkerInvisible");

	var oFlagIconUri = sap.ui.core.IconPool.getIconURI("flag");
	this._oFlagIcon = sap.ui.core.IconPool.createControlByURI({
		id : this.getId() + "-flag",
		src : oFlagIconUri,
		visible : false
	});

	var oFavIconUri = sap.ui.core.IconPool.getIconURI("favorite");	
	this._oFavIcon = sap.ui.core.IconPool.createControlByURI({
		id : this.getId() + "-favorite",
		src : oFavIconUri,
		visible : false
	});
	
	var oTitleArrowIconUri = sap.ui.core.IconPool.getIconURI("slim-arrow-down");	
	this._oTitleArrowIcon = sap.ui.core.IconPool.createControlByURI({
		id : this.getId() + "-titleArrow",
		src : oTitleArrowIconUri,
		visible : false
	});		   
			
	this._titleText = new sap.m.Text(this.getId() + "-titleText");
	this._titleText.setMaxLines(3);
};

sap.m.ObjectHeader.prototype.ontap = function(oEvent) {

	var sourceId = oEvent.target.id;
	if (this.getIntroActive() && sourceId === this.getId() + "-intro") {
		this.fireIntroPress({
			domRef : jQuery.sap.domById(sourceId)
		});
	} else if (this.getTitleActive() && oEvent.srcControl === this._titleText) {
		this.fireTitlePress({
			domRef : jQuery.sap.domById(sourceId)
		});
	} else if (this.getIconActive() && (sourceId === this.getId() + "-img" || sourceId === this.getId() + "-icon")) {
		this.fireIconPress({
			domRef : jQuery.sap.domById(sourceId)
		});
	} else if (sourceId === this.getId() + "-titleArrow") {		
		this.fireTitleSelectorPress({
			domRef : jQuery.sap.domById(sourceId)	 
		});
	} 
};

/**
 * Called when the control is destroyed.
 * 
 * @private
 */
sap.m.ObjectHeader.prototype.exit = function() {

	if (this._sResizeListenerId) {
		sap.ui.core.ResizeHandler.deregister(this._sResizeListenerId);
		this._sResizeListenerId = null;
	}

	if (this._oImageControl) {
		this._oImageControl.destroy();
		this._oImageControl = undefined;
	}

	if (this._oPlaceholderIcon) {
		this._oPlaceholderIcon.destroy();
		this._oPlaceholderIcon = undefined;
	}

	if (this._oFavIcon) {
		this._oFavIcon.destroy();
		this._oFavIcon = undefined;
	}

	if (this._oFlagIcon) {
		this._oFlagIcon.destroy();
		this._oFlagIcon = undefined;
	}
	
	if (this._oTitleArrowIcon) {
		this._oTitleArrowIcon.destroy();
		this._oTitleArrowIcon = undefined;
	}
	
	if(this._titleText){
		this._titleText.destroy();
		this._titleText = undefined;
	}

};

/**
 * Lazy load object header's image.
 * 
 * @private
 */
sap.m.ObjectHeader.prototype._getImageControl = function() {

	var sImgId = this.getId() + "-img";
	var sSize = sap.ui.Device.system.phone ? "2.5rem" : "3rem";

	var mProperties = {
		src : this.getIcon(),
		height : sSize,
		width : sSize,
		size : sSize,
		densityAware : this.getIconDensityAware()
	};

	this._oImageControl = sap.m.ImageHelper.getImageControl(sImgId, this._oImageControl, this, mProperties);

	return this._oImageControl;
};

sap.m.ObjectHeader.prototype.onBeforeRendering = function() {

	if (this._sResizeListenerId) {
		sap.ui.core.ResizeHandler.deregister(this._sResizeListenerId);
		this._sResizeListenerId = null;
	}

};

sap.m.ObjectHeader.prototype.onAfterRendering = function() {
	
	if (this.getShowTitleSelector()) {
		this._oTitleArrowIcon.$().css("cursor", "pointer");
	}
	
	if (this.$("number").length > 0) {
		this._sResizeListenerId = sap.ui.core.ResizeHandler.register(this.getDomRef(), jQuery.proxy(this._resizeElements, this));
		setTimeout(jQuery.proxy(this._resizeElements, this));
	}
};

sap.m.ObjectHeader.prototype._resizeElements = function() {

	if (!this.getDomRef())
		return;

	var id = this.getId();
	var $numberDiv = jQuery.sap.byId(id + "-numberdiv");
	var bHasWrap = $numberDiv.hasClass("sapMOHNumberWrap");

	if (this._fNumberWidth === undefined) {
		this._fNumberWidth = $numberDiv.outerWidth();
	}

	var bOverflow = $numberDiv.parent().width() * 35 / 100 < this._fNumberWidth;

	if (bOverflow != bHasWrap) {
		$numberDiv.toggleClass("sapMOHNumberWrap");
		jQuery.sap.byId(id + "-titlediv").toggleClass("sapMOHNumberWrap");

		jQuery(sap.m.ObjectHeader._escapeId(id) + " .sapMOHBottomRow").css("margin-top", bOverflow && sap.ui.Device.system.phone ? ".25rem" : "");
		this._titleText.setMaxLines(bOverflow ? 2 : 3).rerender();
	}
};

/**
 * @param [string]
 *            sId control id to be escaped
 * @returns escaped control id with "#" prefix
 * @private
 */
sap.m.ObjectHeader._escapeId = function(sId) {

	return sId ? "#" + sId.replace(/(:|\.)/g, '\\$1') : "";
};

/**
 * @private
 * @returns {boolean}
 */
sap.m.ObjectHeader.prototype._hasBottomContent = function() {

	return (this._hasAttributes() || this._hasStatus() || this.getShowMarkers());
};

/**
 * @private
 * @returns {boolean}
 */
sap.m.ObjectHeader.prototype._hasIcon = function() {

	return !!this.getIcon().trim();
};

/**
 * @private
 * @returns {boolean}
 */
sap.m.ObjectHeader.prototype._hasAttributes = function() {

	var attributes = this.getAttributes();
	if (attributes && attributes.length > 0) {
		for ( var i = 0; i < attributes.length; i++) {
			if (!attributes[i]._isEmpty()) {
				return true;
			}
		}
	}
	return false;
};

/**
 * @private
 * @returns {boolean}
 */
sap.m.ObjectHeader.prototype._hasStatus = function() {

	var bHasStatus = ((this.getFirstStatus() && !this.getFirstStatus()._isEmpty()) || (this.getSecondStatus() && !this.getSecondStatus()._isEmpty()));

	if (!bHasStatus && this.getStatuses() && this.getStatuses().length > 0) {
		var statuses = this.getStatuses();
		for ( var i = 0; i < statuses.length; i++) {
			if (statuses[i] instanceof sap.m.ObjectStatus && !statuses[i]._isEmpty()) {
				bHasStatus = true;
				break;
			}
			else if (statuses[i] instanceof sap.m.ProgressIndicator) {
				bHasStatus = true;
				break;
			}
		}
	}

	return bHasStatus;
};

}; // end of sap/m/ObjectHeader.js
if ( !jQuery.sap.isDeclared('sap.m.ObjectIdentifier') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.m.ObjectIdentifier.
jQuery.sap.declare("sap.m.ObjectIdentifier");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new ObjectIdentifier.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getTitle title} : string</li>
 * <li>{@link #getText text} : string</li>
 * <li>{@link #getBadgeNotes badgeNotes} : boolean</li>
 * <li>{@link #getBadgePeople badgePeople} : boolean</li>
 * <li>{@link #getBadgeAttachments badgeAttachments} : boolean</li></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * ObjectIdentifier is a display control that enables the user to easily identify a specific object. The object identifier title is the key identifier of the object and additional text and icons can be used to further distinguish it from other objects.
 * @extends sap.ui.core.Control
 *
 * @author  
 * @version 1.20.6
 *
 * @constructor   
 * @public
 * @since 1.12
 * @name sap.m.ObjectIdentifier
 */
sap.ui.core.Control.extend("sap.m.ObjectIdentifier", { metadata : {

	// ---- object ----

	// ---- control specific ----
	library : "sap.m",
	properties : {
		"title" : {type : "string", group : "Misc", defaultValue : null},
		"text" : {type : "string", group : "Misc", defaultValue : null},
		"badgeNotes" : {type : "boolean", group : "Misc", defaultValue : null},
		"badgePeople" : {type : "boolean", group : "Misc", defaultValue : null},
		"badgeAttachments" : {type : "boolean", group : "Misc", defaultValue : null}
	}
}});


/**
 * Creates a new subclass of class sap.m.ObjectIdentifier with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.m.ObjectIdentifier.extend
 * @function
 */


/**
 * Getter for property <code>title</code>.
 * The object title.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>title</code>
 * @public
 * @name sap.m.ObjectIdentifier#getTitle
 * @function
 */

/**
 * Setter for property <code>title</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sTitle  new value for property <code>title</code>
 * @return {sap.m.ObjectIdentifier} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ObjectIdentifier#setTitle
 * @function
 */


/**
 * Getter for property <code>text</code>.
 * The object text.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>text</code>
 * @public
 * @name sap.m.ObjectIdentifier#getText
 * @function
 */

/**
 * Setter for property <code>text</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sText  new value for property <code>text</code>
 * @return {sap.m.ObjectIdentifier} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ObjectIdentifier#setText
 * @function
 */


/**
 * Getter for property <code>badgeNotes</code>.
 * Indicates whether or not the notes icon is displayed.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {boolean} the value of property <code>badgeNotes</code>
 * @public
 * @name sap.m.ObjectIdentifier#getBadgeNotes
 * @function
 */

/**
 * Setter for property <code>badgeNotes</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {boolean} bBadgeNotes  new value for property <code>badgeNotes</code>
 * @return {sap.m.ObjectIdentifier} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ObjectIdentifier#setBadgeNotes
 * @function
 */


/**
 * Getter for property <code>badgePeople</code>.
 * Indicates whether or not the address book icon is displayed.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {boolean} the value of property <code>badgePeople</code>
 * @public
 * @name sap.m.ObjectIdentifier#getBadgePeople
 * @function
 */

/**
 * Setter for property <code>badgePeople</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {boolean} bBadgePeople  new value for property <code>badgePeople</code>
 * @return {sap.m.ObjectIdentifier} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ObjectIdentifier#setBadgePeople
 * @function
 */


/**
 * Getter for property <code>badgeAttachments</code>.
 * Indicates whether or not the attachments icon is displayed.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {boolean} the value of property <code>badgeAttachments</code>
 * @public
 * @name sap.m.ObjectIdentifier#getBadgeAttachments
 * @function
 */

/**
 * Setter for property <code>badgeAttachments</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {boolean} bBadgeAttachments  new value for property <code>badgeAttachments</code>
 * @return {sap.m.ObjectIdentifier} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ObjectIdentifier#setBadgeAttachments
 * @function
 */


// Start of sap\m\ObjectIdentifier.js
///**
// * This file defines behavior for the control
// */

jQuery.sap.require('sap.ui.core.IconPool'); // unlisted dependency retained


/**
 * Called when the control is destroyed.
 * 
 * @private
 */
sap.m.ObjectIdentifier.prototype.exit = function() {

    if (this._attachmentsIcon) {
        this._attachmentsIcon.destroy();
        this._attachmentsIcon = null;
    }

    if (this._peopleIcon) {
        this._peopleIcon.destroy();
        this._peopleIcon = null;
    }

    if (this._notesIcon) {
        this._notesIcon.destroy();
        this._notesIcon = null;
    }
};

/**
 * Lazy load attachments icon.
 * 
 * @private
 */
sap.m.ObjectIdentifier.prototype._getAttachmentsIcon = function() {

	if (!this._attachmentsIcon){
		this._attachmentsIcon = this._getIcon(sap.ui.core.IconPool.getIconURI("attachment"), this.getId() + "-attachments");
	}

    return this._attachmentsIcon;
};

/**
 * Lazy load people icon.
 * 
 * @private
 */
sap.m.ObjectIdentifier.prototype._getPeopleIcon = function() {

	if (!this._peopleIcon){
		this._peopleIcon = this._getIcon(sap.ui.core.IconPool.getIconURI("group"), this.getId() + "-people");
	}

    return this._peopleIcon;
};

/**
 * Lazy load notes icon.
 * 
 * @private
 */
sap.m.ObjectIdentifier.prototype._getNotesIcon = function() {

	if(!this._notesIcon ) {
		this._notesIcon  = this._getIcon(sap.ui.core.IconPool.getIconURI("notes"), this.getId() + "-notes");
	}

    return this._notesIcon;
};

/**
 * Create icon image.
 * 
 * @private
 */
sap.m.ObjectIdentifier.prototype._getIcon = function(sURI, sImageId) {

    var sSize = sap.ui.Device.system.phone ? "1em" : "1em";
    var oImage;

    oImage = this._icon || sap.ui.core.IconPool.createControlByURI({
        src : sURI,
        id : sImageId + "-icon",
        size : sSize
    }, sap.m.Image);

    oImage.setSrc(sURI);

    return oImage;
};
}; // end of sap/m/ObjectIdentifier.js
if ( !jQuery.sap.isDeclared('sap.m.ObjectListItem') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.m.ObjectListItem.
jQuery.sap.declare("sap.m.ObjectListItem");




/**
 * Constructor for a new ObjectListItem.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getTitle title} : string</li>
 * <li>{@link #getNumber number} : string</li>
 * <li>{@link #getNumberUnit numberUnit} : string</li>
 * <li>{@link #getIntro intro} : string</li>
 * <li>{@link #getIcon icon} : sap.ui.core.URI</li>
 * <li>{@link #getActiveIcon activeIcon} : sap.ui.core.URI</li>
 * <li>{@link #getIconDensityAware iconDensityAware} : boolean (default: true)</li>
 * <li>{@link #getMarkFavorite markFavorite} : boolean</li>
 * <li>{@link #getMarkFlagged markFlagged} : boolean</li>
 * <li>{@link #getShowMarkers showMarkers} : boolean</li>
 * <li>{@link #getNumberState numberState} : sap.ui.core.ValueState (default: sap.ui.core.ValueState.None)</li></ul>
 * </li>
 * <li>Aggregations
 * <ul>
 * <li>{@link #getAttributes attributes} <strong>(default aggregation)</strong> : sap.m.ObjectAttribute[]</li>
 * <li>{@link #getFirstStatus firstStatus} : sap.m.ObjectStatus</li>
 * <li>{@link #getSecondStatus secondStatus} : sap.m.ObjectStatus</li></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 
 *
 * 
 * In addition, all settings applicable to the base type {@link sap.m.ListItemBase#constructor sap.m.ListItemBase}
 * can be used as well.
 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * ObjectListItem is a display control that provides summary information about an object as an item in a list. The object list item title is the key identifier of the object. Additional text and icons can be used to further distinguish it from other objects. Attributes and statuses can be used to provide additional meaning about the object to the user.
 * @extends sap.m.ListItemBase
 *
 * @author  
 * @version 1.20.6
 *
 * @constructor   
 * @public
 * @since 1.12
 * @name sap.m.ObjectListItem
 */
sap.m.ListItemBase.extend("sap.m.ObjectListItem", { metadata : {

	// ---- object ----

	// ---- control specific ----
	library : "sap.m",
	properties : {
		"title" : {type : "string", group : "Misc", defaultValue : null},
		"number" : {type : "string", group : "Misc", defaultValue : null},
		"numberUnit" : {type : "string", group : "Misc", defaultValue : null},
		"intro" : {type : "string", group : "Misc", defaultValue : null},
		"icon" : {type : "sap.ui.core.URI", group : "Misc", defaultValue : null},
		"activeIcon" : {type : "sap.ui.core.URI", group : "Misc", defaultValue : null},
		"iconDensityAware" : {type : "boolean", group : "Misc", defaultValue : true},
		"markFavorite" : {type : "boolean", group : "Misc", defaultValue : null},
		"markFlagged" : {type : "boolean", group : "Misc", defaultValue : null},
		"showMarkers" : {type : "boolean", group : "Misc", defaultValue : null},
		"numberState" : {type : "sap.ui.core.ValueState", group : "Misc", defaultValue : sap.ui.core.ValueState.None}
	},
	defaultAggregation : "attributes",
	aggregations : {
    	"attributes" : {type : "sap.m.ObjectAttribute", multiple : true, singularName : "attribute"}, 
    	"firstStatus" : {type : "sap.m.ObjectStatus", multiple : false}, 
    	"secondStatus" : {type : "sap.m.ObjectStatus", multiple : false}
	}
}});


/**
 * Creates a new subclass of class sap.m.ObjectListItem with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.m.ObjectListItem.extend
 * @function
 */


/**
 * Getter for property <code>title</code>.
 * Object list item title
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>title</code>
 * @public
 * @name sap.m.ObjectListItem#getTitle
 * @function
 */

/**
 * Setter for property <code>title</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sTitle  new value for property <code>title</code>
 * @return {sap.m.ObjectListItem} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ObjectListItem#setTitle
 * @function
 */


/**
 * Getter for property <code>number</code>.
 * Object list item number
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>number</code>
 * @public
 * @name sap.m.ObjectListItem#getNumber
 * @function
 */

/**
 * Setter for property <code>number</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sNumber  new value for property <code>number</code>
 * @return {sap.m.ObjectListItem} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ObjectListItem#setNumber
 * @function
 */


/**
 * Getter for property <code>numberUnit</code>.
 * The number units qualifier of the object list item
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>numberUnit</code>
 * @public
 * @name sap.m.ObjectListItem#getNumberUnit
 * @function
 */

/**
 * Setter for property <code>numberUnit</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sNumberUnit  new value for property <code>numberUnit</code>
 * @return {sap.m.ObjectListItem} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ObjectListItem#setNumberUnit
 * @function
 */


/**
 * Getter for property <code>intro</code>.
 * Introductory text for the object list item.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>intro</code>
 * @public
 * @name sap.m.ObjectListItem#getIntro
 * @function
 */

/**
 * Setter for property <code>intro</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sIntro  new value for property <code>intro</code>
 * @return {sap.m.ObjectListItem} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ObjectListItem#setIntro
 * @function
 */


/**
 * Getter for property <code>icon</code>.
 * Object list item icon displayed to the left of the title.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.core.URI} the value of property <code>icon</code>
 * @public
 * @name sap.m.ObjectListItem#getIcon
 * @function
 */

/**
 * Setter for property <code>icon</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.core.URI} sIcon  new value for property <code>icon</code>
 * @return {sap.m.ObjectListItem} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ObjectListItem#setIcon
 * @function
 */


/**
 * Getter for property <code>activeIcon</code>.
 * Icon displayed when the object list item is active.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {sap.ui.core.URI} the value of property <code>activeIcon</code>
 * @public
 * @name sap.m.ObjectListItem#getActiveIcon
 * @function
 */

/**
 * Setter for property <code>activeIcon</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {sap.ui.core.URI} sActiveIcon  new value for property <code>activeIcon</code>
 * @return {sap.m.ObjectListItem} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ObjectListItem#setActiveIcon
 * @function
 */


/**
 * Getter for property <code>iconDensityAware</code>.
 * By default, this is set to true but then one or more requests are sent trying to get the density perfect version of image if this version of image doesn't exist on the server.
 * 
 * If bandwidth is the key for the application, set this value to false.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>iconDensityAware</code>
 * @public
 * @name sap.m.ObjectListItem#getIconDensityAware
 * @function
 */

/**
 * Setter for property <code>iconDensityAware</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bIconDensityAware  new value for property <code>iconDensityAware</code>
 * @return {sap.m.ObjectListItem} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ObjectListItem#setIconDensityAware
 * @function
 */


/**
 * Getter for property <code>markFavorite</code>.
 * Set the favorite state for the object list item
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {boolean} the value of property <code>markFavorite</code>
 * @public
 * @since 1.16.0
 * @name sap.m.ObjectListItem#getMarkFavorite
 * @function
 */

/**
 * Setter for property <code>markFavorite</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {boolean} bMarkFavorite  new value for property <code>markFavorite</code>
 * @return {sap.m.ObjectListItem} <code>this</code> to allow method chaining
 * @public
 * @since 1.16.0
 * @name sap.m.ObjectListItem#setMarkFavorite
 * @function
 */


/**
 * Getter for property <code>markFlagged</code>.
 * Set the flagged state for the object list item
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {boolean} the value of property <code>markFlagged</code>
 * @public
 * @since 1.16.0
 * @name sap.m.ObjectListItem#getMarkFlagged
 * @function
 */

/**
 * Setter for property <code>markFlagged</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {boolean} bMarkFlagged  new value for property <code>markFlagged</code>
 * @return {sap.m.ObjectListItem} <code>this</code> to allow method chaining
 * @public
 * @since 1.16.0
 * @name sap.m.ObjectListItem#setMarkFlagged
 * @function
 */


/**
 * Getter for property <code>showMarkers</code>.
 * Set to true if the object list item can be marked with icons such as favorite and flag.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {boolean} the value of property <code>showMarkers</code>
 * @public
 * @since 1.16.0
 * @name sap.m.ObjectListItem#getShowMarkers
 * @function
 */

/**
 * Setter for property <code>showMarkers</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {boolean} bShowMarkers  new value for property <code>showMarkers</code>
 * @return {sap.m.ObjectListItem} <code>this</code> to allow method chaining
 * @public
 * @since 1.16.0
 * @name sap.m.ObjectListItem#setShowMarkers
 * @function
 */


/**
 * Getter for property <code>numberState</code>.
 * Object list item number and numberUnit value state.
 *
 * Default value is <code>None</code>
 *
 * @return {sap.ui.core.ValueState} the value of property <code>numberState</code>
 * @public
 * @since 1.16.0
 * @name sap.m.ObjectListItem#getNumberState
 * @function
 */

/**
 * Setter for property <code>numberState</code>.
 *
 * Default value is <code>None</code> 
 *
 * @param {sap.ui.core.ValueState} oNumberState  new value for property <code>numberState</code>
 * @return {sap.m.ObjectListItem} <code>this</code> to allow method chaining
 * @public
 * @since 1.16.0
 * @name sap.m.ObjectListItem#setNumberState
 * @function
 */


/**
 * Getter for aggregation <code>attributes</code>.<br/>
 * List of attributes displayed below the title to the left of the status fields.
 * 
 * <strong>Note</strong>: this is the default aggregation for ObjectListItem.
 * @return {sap.m.ObjectAttribute[]}
 * @public
 * @name sap.m.ObjectListItem#getAttributes
 * @function
 */


/**
 * Inserts a attribute into the aggregation named <code>attributes</code>.
 *
 * @param {sap.m.ObjectAttribute}
 *          oAttribute the attribute to insert; if empty, nothing is inserted
 * @param {int}
 *             iIndex the <code>0</code>-based index the attribute should be inserted at; for 
 *             a negative value of <code>iIndex</code>, the attribute is inserted at position 0; for a value 
 *             greater than the current size of the aggregation, the attribute is inserted at 
 *             the last position        
 * @return {sap.m.ObjectListItem} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ObjectListItem#insertAttribute
 * @function
 */

/**
 * Adds some attribute <code>oAttribute</code> 
 * to the aggregation named <code>attributes</code>.
 *
 * @param {sap.m.ObjectAttribute}
 *            oAttribute the attribute to add; if empty, nothing is inserted
 * @return {sap.m.ObjectListItem} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ObjectListItem#addAttribute
 * @function
 */

/**
 * Removes an attribute from the aggregation named <code>attributes</code>.
 *
 * @param {int | string | sap.m.ObjectAttribute} vAttribute the attribute to remove or its index or id
 * @return {sap.m.ObjectAttribute} the removed attribute or null
 * @public
 * @name sap.m.ObjectListItem#removeAttribute
 * @function
 */

/**
 * Removes all the controls in the aggregation named <code>attributes</code>.<br/>
 * Additionally unregisters them from the hosting UIArea.
 * @return {sap.m.ObjectAttribute[]} an array of the removed elements (might be empty)
 * @public
 * @name sap.m.ObjectListItem#removeAllAttributes
 * @function
 */

/**
 * Checks for the provided <code>sap.m.ObjectAttribute</code> in the aggregation named <code>attributes</code> 
 * and returns its index if found or -1 otherwise.
 *
 * @param {sap.m.ObjectAttribute}
 *            oAttribute the attribute whose index is looked for.
 * @return {int} the index of the provided control in the aggregation if found, or -1 otherwise
 * @public
 * @name sap.m.ObjectListItem#indexOfAttribute
 * @function
 */
	

/**
 * Destroys all the attributes in the aggregation 
 * named <code>attributes</code>.
 * @return {sap.m.ObjectListItem} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ObjectListItem#destroyAttributes
 * @function
 */


/**
 * Getter for aggregation <code>firstStatus</code>.<br/>
 * First status text field shown on the right side of the attributes.
 * 
 * @return {sap.m.ObjectStatus}
 * @public
 * @name sap.m.ObjectListItem#getFirstStatus
 * @function
 */


/**
 * Setter for the aggregated <code>firstStatus</code>.
 * @param {sap.m.ObjectStatus} oFirstStatus
 * @return {sap.m.ObjectListItem} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ObjectListItem#setFirstStatus
 * @function
 */
	

/**
 * Destroys the firstStatus in the aggregation 
 * named <code>firstStatus</code>.
 * @return {sap.m.ObjectListItem} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ObjectListItem#destroyFirstStatus
 * @function
 */


/**
 * Getter for aggregation <code>secondStatus</code>.<br/>
 * Second status text field shown on the right side of the attributes.
 * 
 * @return {sap.m.ObjectStatus}
 * @public
 * @name sap.m.ObjectListItem#getSecondStatus
 * @function
 */


/**
 * Setter for the aggregated <code>secondStatus</code>.
 * @param {sap.m.ObjectStatus} oSecondStatus
 * @return {sap.m.ObjectListItem} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ObjectListItem#setSecondStatus
 * @function
 */
	

/**
 * Destroys the secondStatus in the aggregation 
 * named <code>secondStatus</code>.
 * @return {sap.m.ObjectListItem} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ObjectListItem#destroySecondStatus
 * @function
 */


// Start of sap\m\ObjectListItem.js
///**
// * This file defines behavior for the control,
// */

jQuery.sap.require('sap.ui.core.IconPool'); // unlisted dependency retained


/**
 * @private
 */
sap.m.ObjectListItem.prototype.exit = function(oEvent) {
	// image or icon if initialized
	if (this._oImageControl) {
		this._oImageControl.destroy();
	}
	
	if (this._oPlaceholderIcon) {
		this._oPlaceholderIcon.destroy();
		this._oPlaceholderIcon = undefined;
	}

	if (this._oFavIcon) {
		this._oFavIcon.destroy();
		this._oFavIcon = undefined;
	}
	
	if (this._oFlagIcon) {
		this._oFlagIcon.destroy();
		this._oFlagIcon = undefined;
	}	
	
	if(this._oTitleText){
		this._oTitleText.destroy();
		this._oTitleText = undefined;
	}
	
	sap.m.ListItemBase.prototype.exit.apply(this);
};

/**
 * @private
 * @returns {boolean}
 */
sap.m.ObjectListItem.prototype._hasAttributes = function() {
	var attributes = this.getAttributes(); 
	if(attributes.length > 0) {
		for(var i=0; i < attributes.length; i++) {
			if(!attributes[i]._isEmpty()) {
				return true;
			}
		}
	}
	return false;
};

/**
 * @private
 * @returns {boolean}
 */
sap.m.ObjectListItem.prototype._hasStatus = function() {
	return ((this.getFirstStatus() && !this.getFirstStatus()._isEmpty())
			|| (this.getSecondStatus() && !this.getSecondStatus()._isEmpty() ));
};

/**
 * @private
 * @returns {boolean}
 */
sap.m.ObjectListItem.prototype._hasBottomContent = function() {
	
	return (this._hasAttributes() || this._hasStatus() || this.getShowMarkers());
};

/**
 * @private
 * @returns {Array}
 */
sap.m.ObjectListItem.prototype._getVisibleAttributes = function() {

	var aAllAttributes = this.getAttributes();
	var aVisibleAttributes = [];

	for (var i=0; i < aAllAttributes.length; i++) {
		if(aAllAttributes[i].getVisible()){
			aVisibleAttributes.push(aAllAttributes[i]);
		}
	};

	return aVisibleAttributes;
};

/**
 * Lazy load list item's image.
 *
 * @private
 */
sap.m.ObjectListItem.prototype._getImageControl = function() {

	var sImgId = this.getId() + '-img';
	var sSize = "2.5rem";
	var mProperties = { 
		src : this.getIcon(),
		height : sSize,
		width : sSize,
		size: sSize,
		densityAware : this.getIconDensityAware()
	};
	var aCssClasses = ['sapMObjLIcon'];
	
	this._oImageControl = sap.m.ImageHelper.getImageControl(sImgId, this._oImageControl, this, mProperties, aCssClasses);
	
	return this._oImageControl;
};

/**
 * Overwrite base method to hook into list item's active handling
 * 
 * @private
 */
sap.m.ObjectListItem.prototype._activeHandlingInheritor = function() {
	var sActiveSrc = this.getActiveIcon();
	
	if(!!this._oImageControl  && !!sActiveSrc) {
		this._oImageControl.setSrc(sActiveSrc);
	}	
};

/**
 * Overwrite base method to hook into list item's inactive handling
 * 
 * @private
 */
sap.m.ObjectListItem.prototype._inactiveHandlingInheritor = function() {
	var sSrc = this.getIcon();
	if(!!this._oImageControl) {
		this._oImageControl.setSrc(sSrc);
	}	
};

/**
 * @private
 * @returns Flag icon control
 */
//TODO Remove placeholder when Safari iconFont issue is addressed.
sap.m.ObjectListItem.prototype._getPlaceholderIcon = function() {
	
	if(!this._oPlaceholderIcon) {

		var oPlaceholderIconUri = sap.ui.core.IconPool.getIconURI("fridge");
		this._oPlaceholderIcon = sap.ui.core.IconPool.createControlByURI({
			id: this.getId() + "-placeholder",
			src: oPlaceholderIconUri
		});
		
		this._oPlaceholderIcon.addStyleClass("sapMObjStatusMarkerInvisible");
	}	
	return this._oPlaceholderIcon;
};

/**
 * @private
 * @returns Flag icon control
 */
sap.m.ObjectListItem.prototype._getFlagIcon = function() {
	
	if(!this._oFlagIcon) {

		var oFlagIconUri = sap.ui.core.IconPool.getIconURI("flag");
		this._oFlagIcon = sap.ui.core.IconPool.createControlByURI({
			id: this.getId() + "-flag",
			src: oFlagIconUri
		});
	}	
	return this._oFlagIcon;
};

/**
 * @private
 * @returns Favorite icon control
 */
sap.m.ObjectListItem.prototype._getFavoriteIcon = function() {
	
	if(!this._oFavIcon) {

	    var oFavIconUri = sap.ui.core.IconPool.getIconURI("favorite");
	    this._oFavIcon = sap.ui.core.IconPool.createControlByURI({
	           id: this.getId() + "-favorite",
	           src: oFavIconUri
	    });	
	}
	return this._oFavIcon;
};

/**
 * @private
 * @returns title text control
 */
sap.m.ObjectListItem.prototype._getTitleText = function() {
	
	if(!this._oTitleText) {
		this._oTitleText = new sap.m.Text(this.getId() + "-titleText", {
			maxLines: 2
		});
	}
	return this._oTitleText;
};
}; // end of sap/m/ObjectListItem.js
if ( !jQuery.sap.isDeclared('sap.m.ObjectNumber') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.m.ObjectNumber.
jQuery.sap.declare("sap.m.ObjectNumber");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new ObjectNumber.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in single or double quotes).
 *
 * The supported settings are:
 * <ul>
 * <li>Properties
 * <ul>
 * <li>{@link #getNumber number} : string</li>
 * <li>{@link #getNumberUnit numberUnit} : string</li>
 * <li>{@link #getVisible visible} : boolean (default: true)</li>
 * <li>{@link #getEmphasized emphasized} : boolean (default: true)</li>
 * <li>{@link #getState state} : sap.ui.core.ValueState (default: sap.ui.core.ValueState.None)</li>
 * <li>{@link #getUnit unit} : string</li></ul>
 * </li>
 * <li>Aggregations
 * <ul></ul>
 * </li>
 * <li>Associations
 * <ul></ul>
 * </li>
 * <li>Events
 * <ul></ul>
 * </li>
 * </ul> 

 *
 * @param {string} [sId] id for the new control, generated automatically if no id is given 
 * @param {object} [mSettings] initial settings for the new control
 *
 * @class
 * ObjectNumber displays number and number unit properties for an object. The number can be displayed using semantic colors to provide addition meaning about the object to the user.
 * @extends sap.ui.core.Control
 *
 * @author  
 * @version 1.20.6
 *
 * @constructor   
 * @public
 * @since 1.12
 * @name sap.m.ObjectNumber
 */
sap.ui.core.Control.extend("sap.m.ObjectNumber", { metadata : {

	// ---- object ----

	// ---- control specific ----
	library : "sap.m",
	properties : {
		"number" : {type : "string", group : "Misc", defaultValue : null},
		"numberUnit" : {type : "string", group : "Misc", defaultValue : null, deprecated: true},
		"visible" : {type : "boolean", group : "Appearance", defaultValue : true},
		"emphasized" : {type : "boolean", group : "Appearance", defaultValue : true},
		"state" : {type : "sap.ui.core.ValueState", group : "Misc", defaultValue : sap.ui.core.ValueState.None},
		"unit" : {type : "string", group : "Misc", defaultValue : null}
	}
}});


/**
 * Creates a new subclass of class sap.m.ObjectNumber with name <code>sClassName</code> 
 * and enriches it with the information contained in <code>oClassInfo</code>.
 * 
 * <code>oClassInfo</code> might contain the same kind of informations as described in {@link sap.ui.core.Element.extend Element.extend}.
 *   
 * @param {string} sClassName name of the class to be created
 * @param {object} [oClassInfo] object literal with informations about the class  
 * @param {function} [FNMetaImpl] constructor function for the metadata object. If not given, it defaults to sap.ui.core.ElementMetadata.
 * @return {function} the created class / constructor function
 * @public
 * @static
 * @name sap.m.ObjectNumber.extend
 * @function
 */


/**
 * Getter for property <code>number</code>.
 * Number field of the object number
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>number</code>
 * @public
 * @name sap.m.ObjectNumber#getNumber
 * @function
 */

/**
 * Setter for property <code>number</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sNumber  new value for property <code>number</code>
 * @return {sap.m.ObjectNumber} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ObjectNumber#setNumber
 * @function
 */


/**
 * Getter for property <code>numberUnit</code>.
 * Number units qualifier
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>numberUnit</code>
 * @public
 * @deprecated Since version 1.16.1. 
 * 
 * Replaced by unit property due to the number before unit is redundant.
 * @name sap.m.ObjectNumber#getNumberUnit
 * @function
 */

/**
 * Setter for property <code>numberUnit</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sNumberUnit  new value for property <code>numberUnit</code>
 * @return {sap.m.ObjectNumber} <code>this</code> to allow method chaining
 * @public
 * @deprecated Since version 1.16.1. 
 * 
 * Replaced by unit property due to the number before unit is redundant.
 * @name sap.m.ObjectNumber#setNumberUnit
 * @function
 */


/**
 * Getter for property <code>visible</code>.
 * Indicates if object number is visible. Invisible object number is not rendered.
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>visible</code>
 * @public
 * @name sap.m.ObjectNumber#getVisible
 * @function
 */

/**
 * Setter for property <code>visible</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bVisible  new value for property <code>visible</code>
 * @return {sap.m.ObjectNumber} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ObjectNumber#setVisible
 * @function
 */


/**
 * Getter for property <code>emphasized</code>.
 * Indicates if the object number should appear emphasized
 *
 * Default value is <code>true</code>
 *
 * @return {boolean} the value of property <code>emphasized</code>
 * @public
 * @name sap.m.ObjectNumber#getEmphasized
 * @function
 */

/**
 * Setter for property <code>emphasized</code>.
 *
 * Default value is <code>true</code> 
 *
 * @param {boolean} bEmphasized  new value for property <code>emphasized</code>
 * @return {sap.m.ObjectNumber} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ObjectNumber#setEmphasized
 * @function
 */


/**
 * Getter for property <code>state</code>.
 * The object number's value state. Setting this state will cause the number to be rendered in state-specific colors (only blue-crystal theme).
 *
 * Default value is <code>sap.ui.core.ValueState.None</code>
 *
 * @return {sap.ui.core.ValueState} the value of property <code>state</code>
 * @public
 * @name sap.m.ObjectNumber#getState
 * @function
 */

/**
 * Setter for property <code>state</code>.
 *
 * Default value is <code>sap.ui.core.ValueState.None</code> 
 *
 * @param {sap.ui.core.ValueState} oState  new value for property <code>state</code>
 * @return {sap.m.ObjectNumber} <code>this</code> to allow method chaining
 * @public
 * @name sap.m.ObjectNumber#setState
 * @function
 */


/**
 * Getter for property <code>unit</code>.
 * Number units qualifier. If numberUnit and unit are both set, the unit value is used.
 *
 * Default value is empty/<code>undefined</code>
 *
 * @return {string} the value of property <code>unit</code>
 * @public
 * @since 1.16.1
 * @name sap.m.ObjectNumber#getUnit
 * @function
 */

/**
 * Setter for property <code>unit</code>.
 *
 * Default value is empty/<code>undefined</code> 
 *
 * @param {string} sUnit  new value for property <code>unit</code>
 * @return {sap.m.ObjectNumber} <code>this</code> to allow method chaining
 * @public
 * @since 1.16.1
 * @name sap.m.ObjectNumber#setUnit
 * @function
 */


// Start of sap\m\ObjectNumber.js
///**
// * This file defines behavior for the control,
// */

/**
 * String to prefix css class for number status to be used in
 * controler and renderer
 * @private 
 */
sap.m.ObjectNumber.prototype._sCSSPrefixObjNumberStatus = 'sapMObjectNumberStatus';

/**
 * API method to set the object number's value state
 *
 * @param sState the Object Number's value state
 * @public
 */
sap.m.ObjectNumber.prototype.setState = function(sState) {
	//remove the current value state css class
	this.$().removeClass(this._sCSSPrefixObjNumberStatus + this.getState());

	//do suppress rerendering
	this.setProperty("state", sState, true);

	//now set the new css state class
	this.$().addClass(this._sCSSPrefixObjNumberStatus + this.getState());

	return this;
};
}; // end of sap/m/ObjectNumber.js
if ( !jQuery.sap.isDeclared('sap.m.ObjectStatus') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* ----------------------------------------------------------------------------------
 * Hint: This is a derived (generated) file. Changes should be done in the underlying 
 * source files only (*.control, *.js) or they will be lost after the next generation.
 * ---------------------------------------------------------------------------------- */

// Provides control sap.m.ObjectStatus.
jQuery.sap.declare("sap.m.ObjectStatus");

jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained



/**
 * Constructor for a new ObjectStatus.
 * 
 * Accepts an object literal <code>mSettings</code> that defines initial 
 * property values, aggregated and associated objects as well as event handlers. 
 * 
 * If the name of a setting is ambiguous (e.g. a property has the same name as an event), 
 * then the framework assumes property, aggregation, association, event in that order. 
 * To override this automatic resolution, one of the prefixes "aggregation:", "association:" 
 * or "event:" can be added to the name of the setting (such a prefixed name must be
 * enclosed in 