/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare("sap.ui.commons.ButtonRenderer");sap.ui.commons.ButtonRenderer={};
sap.ui.commons.ButtonRenderer.render=function(r,b){if(!b.getVisible()){return}r.addClass("sapUiBtn");r.write("<button type=\"button\"");r.writeControlData(b);if(b.getTooltip_AsString()){r.writeAttributeEscaped("title",b.getTooltip_AsString())}if(b.getStyled()){r.addClass("sapUiBtnS")}if(b.getLite()){r.addClass("sapUiBtnLite")}else{r.addClass("sapUiBtnNorm")}var s=b.getStyle();if(s!=""&&s!=sap.ui.commons.ButtonStyle.Default){r.addClass("sapUiBtn"+jQuery.sap.escapeHTML(s))}r.writeAccessibilityState(b,{role:'button',disabled:!b.getEnabled()});if(!b.getEnabled()){r.write(" tabIndex=\"-1\"");r.addClass("sapUiBtnDsbl")}else{r.write(" tabIndex=\"0\"");r.addClass("sapUiBtnStd")}var i=false;if(!b.getText()&&b.getIcon()){r.addClass("sapUiBtnIconOnly");i=true}if(b.getWidth()&&b.getWidth()!=''){r.addStyle("width",b.getWidth());r.addClass("sapUiBtnFixedWidth")}if(b.getHeight()&&b.getHeight()!=''){r.addStyle("height",b.getHeight())}r.writeStyles();if(this.renderButtonAttributes){this.renderButtonAttributes(r,b)}if(!!sap.ui.Device.browser.internet_explorer&&(!document.documentMode||document.documentMode<10)){r.addClass("sapUiBtnNoGradient")}r.writeClasses();r.write(">");if(this.renderButtonContentBefore){this.renderButtonContentBefore(r,b)}var u=false;if(sap.ui.core.IconPool.isIconURI(b.getIcon())){u=true}if(b.getIconFirst()){if(u){this.writeIconHtml(r,b,i)}else if(this._getIconForState(b,"base")){this.writeImgHtml(r,b,i)}}if(b.getText()){if(!b.getIcon()&&!this.renderButtonContentBefore&&!this.renderButtonContentAfter){r.writeEscaped(b.getText())}else{r.write("<span class=\"sapUiBtnTxt\">");r.writeEscaped(b.getText());r.write("</span>")}}if(!b.getIconFirst()){if(u){this.writeIconHtml(r,b,i)}else if(this._getIconForState(b,"base")){this.writeImgHtml(r,b,i)}}if(this.renderButtonContentAfter){this.renderButtonContentAfter(r,b)}r.write("</button>")};
sap.ui.commons.ButtonRenderer.onactive=function(b){b.$().addClass("sapUiBtnAct").removeClass("sapUiBtnStd");b.$("img").attr("src",this._getIconForState(b,"active"))};
sap.ui.commons.ButtonRenderer.ondeactive=function(b){b.$().addClass("sapUiBtnStd").removeClass("sapUiBtnAct");b.$("img").attr("src",this._getIconForState(b,"deactive"))};
sap.ui.commons.ButtonRenderer.onblur=function(b){b.$().removeClass("sapUiBtnFoc");b.$("img").attr("src",this._getIconForState(b,"blur"));if(!!sap.ui.Device.browser.internet_explorer){sap.ui.commons.ButtonRenderer.onmouseout(b)}};
sap.ui.commons.ButtonRenderer.onfocus=function(b){b.$().addClass("sapUiBtnFoc");b.$("img").attr("src",this._getIconForState(b,"focus"))};
sap.ui.commons.ButtonRenderer.onmouseout=function(b){b.$().removeClass("sapUiBtnAct");b.$().addClass("sapUiBtnStd");b.$("img").attr("src",this._getIconForState(b,"mouseout"))};
sap.ui.commons.ButtonRenderer.onmouseover=function(b){b.$("img").attr("src",this._getIconForState(b,"mouseover"))};
sap.ui.commons.ButtonRenderer._getIconForState=function(b,s){if(!b.getEnabled()){s="disabled"}switch(s){case"focus":case"blur":case"base":if(b.$().hasClass("sapUiBtnAct")){var i=b.getIconSelected()||b.getIconHovered();return i?i:b.getIcon()}else if(b.$().hasClass("sapUiBtnFoc")){return b.getIconHovered()||b.getIcon()}return b.getIcon();case"mouseout":if(b.$().hasClass("sapUiBtnFoc")){return b.getIconHovered()||b.getIcon()}return b.getIcon();case"active":var i=b.getIconSelected()||b.getIconHovered();return i?i:b.getIcon();case"mouseover":case"deactive":var i=b.getIconHovered();return i?i:b.getIcon()}return b.getIcon()};
sap.ui.commons.ButtonRenderer.writeImgHtml=function(r,b,i){var a=r,c=this._getIconForState(b,"base");a.write("<img");a.writeAttribute("id",b.getId()+"-img");a.writeAttributeEscaped("src",c);if(b.getTooltip_AsString()&&!b.getText()){a.writeAttributeEscaped("alt",b.getTooltip_AsString())}else{a.writeAttribute("alt","")}if(!i){a.writeAttribute("role","presentation")}a.addClass("sapUiBtnIco");if(b.getText()){if(b.getIconFirst()){a.addClass("sapUiBtnIcoL")}else{a.addClass("sapUiBtnIcoR")}}a.writeClasses();a.write("/>")};
sap.ui.commons.ButtonRenderer.writeIconHtml=function(r,b,i){var a=r;var I=sap.ui.core.IconPool.getIconInfo(b.getIcon());var c=[];var A={};A["id"]=b.getId()+"-icon";c.push("sapUiBtnIco");if(b.getText()){var R=a.getConfiguration().getRTL();if((b.getIconFirst()&&(!R||I.skipMirroring))||(!b.getIconFirst()&&!I.skipMirroring&&R)){c.push("sapUiBtnIcoL")}else{c.push("sapUiBtnIcoR")}}a.writeIcon(b.getIcon(),c,A)};
sap.ui.commons.ButtonRenderer.changeIcon=function(b){if(sap.ui.core.IconPool.isIconURI(b.getIcon())){var i=sap.ui.core.IconPool.getIconInfo(b.getIcon());var I=b.$("icon");if(sap.ui.Device.browser.internet_explorer&&sap.ui.Device.browser.version<9){I.text(i.content)}else{I.attr("data-sap-ui-icon-content",i.content)}if(!i.skipMirroring){I.addClass("sapUiIconMirrorInRTL")}else{I.removeClass("sapUiIconMirrorInRTL")}}else if(b.$().hasClass("sapUiBtnAct")){b.$("img").attr("src",this._getIconForState(b,"active"))}else if(b.$().hasClass("sapUiBtnFoc")){b.$("img").attr("src",this._getIconForState(b,"focus"))}else if(b.$().hasClass("sapUiBtnStd")){b.$("img").attr("src",this._getIconForState(b,"base"))}};
