/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare("sap.ui.commons.FormattedTextView");jQuery.sap.require("sap.ui.commons.library");jQuery.sap.require("sap.ui.core.Control");sap.ui.core.Control.extend("sap.ui.commons.FormattedTextView",{metadata:{publicMethods:["setContent"],library:"sap.ui.commons",properties:{"visible":{type:"boolean",group:"Behavior",defaultValue:true},"accessibleRole":{type:"sap.ui.core.AccessibleRole",group:"Accessibility",defaultValue:sap.ui.core.AccessibleRole.Document},"htmlText":{type:"string",group:"Misc",defaultValue:""}},aggregations:{"controls":{type:"sap.ui.commons.FormattedTextViewControl",multiple:true,singularName:"control"}}}});jQuery.sap.require("jquery.sap.encoder");(function(){sap.ui.commons.FormattedTextView.prototype.init=function(){this._aAllowedInterfaces=[];this._aAllowedInterfaces[0]="sap.ui.commons.FormattedTextViewControl";this._ftv={};this._ftv.ATTRIBS={'span::class':1,'div::class':1,'div::id':1,'span::id':1,'embed::data-index':1};this._ftv.ELEMENTS={'abbr':1,'acronym':1,'address':1,'blockquote':1,'br':1,'cite':1,'code':1,'dfn':1,'div':1,'em':1,'h1':1,'h2':1,'h3':1,'h4':1,'h5':1,'h6':1,'kbd':1,'p':1,'pre':1,'q':1,'samp':1,'strong':1,'span':1,'var':1,'dl':1,'dt':1,'dd':1,'ol':1,'ul':1,'li':1,'embed':1}};sap.ui.commons.FormattedTextView.prototype.exit=function(){delete this._aAllowedInterfaces;delete this._ftv};sap.ui.commons.FormattedTextView.prototype.hasControls=function(){var c=this.getAggregation("controls");if(c&&c.length>0){return true}return false};var s=function(t,a){for(var i=0;i<a.length;i+=2){var A=t+"::"+a[i];if(this._ftv.ATTRIBS[A]){if(t==="embed"){var b=/^[0-9]*$/;if(!a[i+1].match(b)){return null}}}else{var w='<'+t+'> with attribute ['+a[i]+'="'+a[i+1]+'"] is not allowed and cut';jQuery.sap.log.warning(w,this);a[i+1]=null}}return a};var p=function(t,a){if(this._ftv.ELEMENTS[t]){var b=jQuery.proxy(s,this);return b(t,a)}else{var w='<'+t+'> is not allowed and cut (and its content)';jQuery.sap.log.warning(w,this)}};sap.ui.commons.FormattedTextView.prototype.setHtmlText=function(t){var a="";var P=jQuery.proxy(p,this);a=jQuery.sap._sanitizeHTML(t,{tagPolicy:P});this.setProperty("htmlText",a)};var S=function(c,t){if(t.hasControls()){t.removeAllAggregation("controls")}var I=jQuery.isArray(c);if(I&&c.length>0){for(var i=0;i<c.length;i++){t.addAggregation("controls",c[i],true)}t.invalidate()}};sap.ui.commons.FormattedTextView.prototype.setContent=function(h,c){this.setHtmlText(h);S(c,this)}}());
