/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/base/ManagedObject','./Element','jquery.sap.act','jquery.sap.ui'],function(q,M,E){"use strict";var U=M.extend("sap.ui.core.UIArea",{constructor:function(c,r){if(arguments.length===0){return}M.apply(this);this.oCore=c;this.bLocked=false;this.bInitial=true;this.aContentToRemove=[];this.bNeedsRerendering=false;if(r!=null){this.setRootNode(r);this.bNeedsRerendering=this.bNeedsRerendering&&!q.sap.domById(r.id+"-Init")}this.mInvalidatedControls={};if(!this.bNeedsRerendering){this.oRenderControl=null}else{this.oCore.addInvalidatedUIArea(this)}},metadata:{publicMethods:["setRootNode","getRootNode","setRootControl","getRootControl","lock","unlock","isLocked"],aggregations:{content:{name:"content",type:"sap.ui.core.Control",multiple:true,singularName:"content"},dependents:{name:"dependents",type:"sap.ui.core.Control",multiple:true}}}});U.prototype.isInvalidateSuppressed=function(){return this.iSuppressInvalidate>0};U.prototype.getId=function(){return this.oRootNode?this.oRootNode.id:null};U.prototype.getUIArea=function(){return this};U.prototype.setRootNode=function(r){if(this.oRootNode===r){return}if(this.oRootNode){this._ondetach()}this.oRootNode=r;if(this.getContent().length>0){this.invalidate()}if(this.oRootNode){this._onattach()}};U.prototype.getRootNode=function(){return this.oRootNode};U.prototype.setRootControl=function(r){this.removeAllContent();this.addContent(r)};U.prototype.getRootControl=function(i){var c=this.getContent();if(c.length>0){if(i>=0&&i<c.length){return c[i]}return c[0]}return null};U.prototype._addRemovedContent=function(d){if(this.oRootNode&&d){this.aContentToRemove.push(d)}};U.prototype.addContent=function(c,_){this.addAggregation("content",c,_);if(_!==true){this.invalidate()}return this};U.prototype.removeContent=function(c,_){var C=this.removeAggregation("content",c,_);if(!_){var d;if(C&&C.getDomRef){d=C.getDomRef()}this._addRemovedContent(d)}return C};U.prototype.removeAllContent=function(){var c=this.removeAllAggregation("content");for(var i=0;i<c.length;i++){var d;var C=c[i];if(C&&C.getDomRef){d=C.getDomRef()}this._addRemovedContent(d)}return c};U.prototype.destroyContent=function(){var c=this.getContent();for(var i=0;i<c.length;i++){var d;var C=c[i];if(C&&C.getDomRef){d=C.getDomRef()}this._addRemovedContent(d)}this.destroyAggregation("content");return this};U.prototype.lock=function(){this.bLocked=true};U.prototype.unlock=function(){if(this.bLocked&&this.bNeedsRerendering){this.oCore.addInvalidatedUIArea(this)}this.bLocked=false};U.prototype.isLocked=function(){return this.bLocked};U.prototype.getBindingContext=function(){return null};U.prototype.getEventingParent=function(){return this.oCore};U.prototype.isActive=function(){return q.sap.domById(this.getId())!=null};U.prototype.invalidate=function(){this.addInvalidatedControl(this)};U.prototype.addInvalidatedControl=function(c){if(this.oRenderControl==this){return}if(!this.bNeedsRerendering){this.oCore.addInvalidatedUIArea(this)}var i=c.getId();if(c==this){this.oRenderControl=this;this.bNeedsRerendering=true;return}if(this.mInvalidatedControls[i]){return}if(!this.oRenderControl){this.mInvalidatedControls[i]=c;this.bNeedsRerendering=true}};U.prototype.rerender=function(f){if(f){this.bNeedsRerendering=true}if(this.bLocked||!this.bNeedsRerendering){return false}var t=this;q.sap.measure.pause("rerenderAllUIAreas");q.sap.measure.start(this.getId()+"---rerender","Rerendering of "+this.getMetadata().getName());if(this.oRenderControl==this){if(this.oRootNode){q.sap.log.info("Rerendering of UI area: "+this.getId());sap.ui.core.RenderManager.preserveContent(this.oRootNode,false,this.bInitial);this.bInitial=false;var c=function(b,d){var l=b.length;var D;for(var i=0;i<l;i++){D=d?b[i].getDomRef():b[i];if(D&&!sap.ui.core.RenderManager.isPreservedContent(D)&&t.oRootNode===D.parentNode){q(D).remove()}}return l};c(this.aContentToRemove);this.aContentToRemove=[];var C=this.getContent();var l=c(C,true);for(var i=0;i<l;i++){this.oCore.oRenderManager.render(C[i],this.oRootNode,true)}}else{q.sap.measure.end(this.getId()+"---rerender");q.sap.measure.resume("rerenderAllUIAreas");return false}}else{var a=function(A){while(A&&A!==t){if(t.mInvalidatedControls.hasOwnProperty(A.getId())){return true}if(A&&A.getMetadata&&A.getMetadata().isInstanceOf("sap.ui.core.PopupInterface")){break}A=A.getParent()}return false};for(var n in this.mInvalidatedControls){var o=this.oCore.byId(n);if(o&&!a(o.getParent())){o.rerender()}}}this.oRenderControl=null;this.mInvalidatedControls={};this.bNeedsRerendering=false;q.sap.measure.end(this.getId()+"---rerender");q.sap.measure.resume("rerenderAllUIAreas");return true};U.rerenderControl=function(c){var d=c?c.getDomRef():null;var p=d&&d.parentNode;if(p){var u=c.getUIArea();var r=u?u.oCore.oRenderManager:sap.ui.getCore().createRenderManager();q.sap.log.info("Rerendering of control (using Core-RenderManager: "+(!!u)+"): "+c.getId());sap.ui.core.RenderManager.preserveContent(d,true,false);r.render(c,p)}else{q.sap.log.warning("Couldn't rerender '"+c.getId()+"', as its DOM location couldn't be determined")}};U.prototype._handleEvent=function(e){var o=null;o=q(e.target).control(0);q.sap.act.refresh();if(o===null){return}if(e.isMarked("delayedMouseEvent")){return}if(e.isMarked("handledByUIArea")){e.setMark("firstUIArea",false);return}e.setMarked("firstUIArea");e.srcControl=o;this.oCore._handleControlEvent(e,this.getId());if(this.bLocked||this.oCore.isLocked()){return}var a=[];if(e.getPseudoTypes){a=e.getPseudoTypes()}a.push(e.type);while(o&&o instanceof E&&o.isActive()&&!e.isPropagationStopped()){for(var i=0,b=a.length;i<b;i++){var t=a[i];e.type=t;e.currentTarget=o.getDomRef();o._handleEvent(e);if(e.isImmediatePropagationStopped()){break}}if(e.isPropagationStopped()){break}if(o.bStopEventBubbling){break}var d=o.getDomRef();if(!d){break}d=d.parentNode;o=null;if(e.isMarked("fromMouseout")&&q.sap.containsOrEquals(d,e.relatedTarget)){break}while(d&&d!==this.getRootNode()){if(d.id){o=q(d).control(0);if(o){break}}d=d.parentNode}}e.currentTarget=this.getRootNode();(e.originalEvent||e)._sapui_handledByUIArea=true;if(e.isPropagationStopped()){q.sap.log.debug("'"+e.type+"' propagation has been stopped")}var n=e.type;if(n!="mousemove"&&n!="mouseover"&&n!="scroll"&&n!="mouseout"){var c=q(e.target).control(0);if(c){q.sap.log.debug("Event fired: '"+e.type+"' on "+c,"","sap.ui.core.UIArea")}else{q.sap.log.debug("Event fired: '"+e.type+"'","","sap.ui.core.UIArea")}}};U.prototype._onattach=function(){var d=this.getRootNode();if(d==null){return}q(d).attr("data-sap-ui-area",d.id).bind(q.sap.ControlEvents.join(" "),q.proxy(this._handleEvent,this))};U.prototype._ondetach=function(){var d=this.getRootNode();if(d==null){return}q(d).removeAttr("data-sap-ui-area").unbind()};U.prototype.clone=function(){throw new Error("UIArea can't be cloned")};return U},true);
