/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2014 SAP AG or an SAP affiliate company. 
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define('sap/ui/core/plugin/LessSupport',['jquery.sap.global','sap/ui/core/Core'],function(q,C){"use strict";var L=function(){};L.prototype.startPlugin=function(c,o){q.sap.log.info("Starting LessSupport plugin.");q.sap.log.warning("  NOT FOR PRODUCTIVE USAGE! LessSupport is an experimental feature which might change in future!");var u=q.sap.getUriParameters();var n=u.get("sap-ui-xx-noless");if(n){n=n.toLowerCase()}if(n!=="false"&&(window.top.JsUnit||(window.sap.ui.test&&window.sap.ui.test.qunit))){q.sap.log.info("  LessSupport has been deactivated for JSUnit Testrunner or QUnit.");return}if(n&&n!=="false"){q.sap.log.info("  LessSupport has been deactivated by URL parameter.");return}else{q.sap.log.info("  LessSupport can be deactivated by adding the following parameter to your URL: \"sap-ui-xx-noless=X\".")}window.less=window.less||{env:"development",errorReporting:function(m,e,r){if(m==="add"){console.error("Failed to parse: "+r,e)}}};q.sap.require("sap.ui.thirdparty.less");this.oCore=c;this.bActive=true;var T=window.less.tree.Color.prototype.toCSS;window.less.tree.Color.prototype.toCSS=function(){if(this.alpha==0&&this.rgb[0]==0&&this.rgb[1]==0&&this.rgb[2]==0){return"transparent"}return T.apply(this,arguments)};this.oCore.includeLibraryTheme=q.proxy(this.includeLibraryTheme,this);this.oCore.applyTheme=q.proxy(this.applyTheme,this);var a=this,U=false;var l=[];q("link[id^=sap-ui-theme-]").each(function(){var _=a.initLink(this);U=_||U;if(_){l.push(this.id.substr(13))}});this.refreshLess(U);var b=0;function d(){var e=true;var f;for(var i=0;i<l.length;i++){f=sap.ui.core.ThemeCheck.checkStyle("less:"+l[i],true);if(f){q.sap.byId("sap-ui-theme-"+l[i]).attr("sap-ui-ready","true")}e=e&&f}b++;if(b>100){e=true;q.sap.log.warning("LessSupport: Max theme check cycles reached.")}if(e){sap.ui.core.ThemeCheck.themeLoaded=true;q.sap.delayedCall(0,c,"fireThemeChanged",[{theme:c.sTheme}])}else{q.sap.delayedCall(100,null,d)}}if(U){q.sap.delayedCall(100,null,d)}};L.prototype.stopPlugin=function(){q.sap.log.info("Stopping LessSupport plugin.");if(this.bActive){q("link[id^=sap-ui-theme-]").each(function(){var l=this.id.substr(13);q.sap.byId("less:"+l).remove()});delete this.oCore.includeLibraryTheme;delete this.oCore.applyTheme;this.oCore=null}};L.prototype.initLink=function(l){var u=this.updateLink(l);q("<style>").attr("id","less:"+l.id.substr(13)).attr("type","text/css").attr("media",this.media||"screen").insertAfter(l);return u};L.prototype.updateLink=function(l){var s=l.id.substr(13);var p;if((p=s.indexOf("-["))>0){s=s.substr(0,p)}var b=this.oCore._getThemePath(s,this.oCore.sTheme);var f=l.href.substring(l.href.lastIndexOf("/")+1,l.href.lastIndexOf("."));var a=q.sap.endsWith(l.href,".less");var i=this.getLastModified(b+f+".less");var c=this.getLastModified(b+f+".css");var u=i>c;q.sap.log.debug("LessSupport.updateLink: "+b+f+": "+(u?"LESS":"CSS"));if(!u){if(l.title){delete l.title}l.href=b+f+".css";l.rel="stylesheet";this.unregisterLink(l);return false}l.title=s;l.href=b+f+".less";l.rel="stylesheet/less";this.registerLink(l);return true};L.prototype.getLastModified=function(u){var l;q.ajax({url:u,type:"HEAD",complexResult:true,async:false,success:function(d,a,x){l=x.getResponseHeader("Last-Modified")||-1},error:function(x,a,e){l=-1}});q.sap.log.debug("CSS/LESS head-check: "+u+"; last-modified: "+l);return Date.parse(l)};L.prototype.applyTheme=function(T,s){C.prototype.applyTheme.apply(this.oCore,arguments);var a=this,u=false;q("link[id^=sap-ui-theme-]").each(function(){u=a.updateLink(this)||u});this.refreshLess(u)};L.prototype.includeLibraryTheme=function(l){C.prototype.includeLibraryTheme.apply(this.oCore,arguments);var a=this,u=false;q("link[id='sap-ui-theme-"+l+"']").each(function(){u=a.initLink(this)||u});this.refreshLess(u)};L.prototype.registerLink=function(l){if(window.less&&window.less.sheets){var i=q.inArray(l,window.less.sheets);if(i===-1){window.less.sheets.push(l)}}};L.prototype.unregisterLink=function(l){if(window.less&&window.less.sheets){var s=l.id.substr(13);var i=q.inArray(l,window.less.sheets);if(i>=0){window.less.sheets.splice(i,1);q.sap.byId("less:"+s).html("")}}};L.prototype.refreshLess=function(u){if(u){if(!document.getElementById("sap-ui-ide-less-mode")){q("<span>").attr("id","sap-ui-ide-less-mode").attr("title","Less mode is active. Click to hide this information.").css("position","absolute").css("right","10px").css("bottom","10px").css("padding","10px").css("border","3px solid red").css("border-radius","10px").css("opacity","0.75").css("color","black").css("background-color","white").css("font-weight","bold").css("z-index","99999").css("cursor","pointer").text("LESS MODE").bind("click",function(){q(this).css("display","none")}).appendTo(window.document.body)}}else{var n=document.getElementById("sap-ui-ide-less-mode");if(n){q(n).remove()}}if(window.less&&window.less.refresh){window.less.refresh()}};var t=new L();sap.ui.getCore().registerPlugin(t);return L},true);
